/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.senseless.pay;

import com.wovoe.carpark.JsonListType;
import com.wovoe.carpark.dto.CarparkQueryFee;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.senseless.pay.SencelessPayResult;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.remote.CarparkCloudMessageHandler;
import com.wovoe.carpark.service.remote.CloudMsgService;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.http.HttpResponseCallback;
import com.wovoe.framework.http.HttpUtil;
import java.math.BigDecimal;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SDXLETCCloudPayer {
    private static long selBeginTimeMills;

    public static SencelessPayResult deduct(Map<String, Object> rquestMap, final CarparkQueryFee queryFee, Map<String, String> configMap) {
        try {
            Date exitTimeDate;
            Date enterTimeDate;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            final SimpleDateFormat df1 = new SimpleDateFormat("yyyyMMddHHmmss");
            String enterTime = (String)rquestMap.get("enterTime");
            final String plateNumber = queryFee.getPlate_number();
            final String out_order_no = (String)rquestMap.get("outOrderNo");
            if (enterTime == null || enterTime.length() == 0) {
                return new SencelessPayResult("FAIL", "\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570enterTime");
            }
            try {
                enterTimeDate = df.parse(enterTime);
            }
            catch (ParseException e1) {
                return new SencelessPayResult("FAIL", "enterTime\u683c\u5f0f\u9519\u8bef");
            }
            String enter_time = df1.format(enterTimeDate);
            String exitTime = (String)rquestMap.get("exitTime");
            if (exitTime == null || exitTime.length() == 0) {
                exitTime = (String)rquestMap.get("chargeEndTime");
            }
            if (exitTime == null || exitTime.length() == 0) {
                exitTimeDate = ServiceUtil.getNow();
            } else {
                try {
                    exitTimeDate = df.parse(exitTime);
                }
                catch (ParseException e) {
                    exitTimeDate = ServiceUtil.getNow();
                }
            }
            String leave_time = df1.format(exitTimeDate);
            final BigDecimal moneyYun = queryFee.getActual_charge_amount();
            final int trans_amount = moneyYun.multiply(new BigDecimal(100)).intValue();
            if (trans_amount <= 0) {
                return new SencelessPayResult("FAIL", "\u4ea4\u6613\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            String carTypeName = (String)rquestMap.get("carTypeName");
            String plate_type_code = "0";
            if (carTypeName != null && carTypeName.length() > 0) {
                if (carTypeName.indexOf("\u8d85") != -1) {
                    plate_type_code = "2";
                } else if (carTypeName.indexOf("\u5927") != -1) {
                    plate_type_code = "1";
                }
            }
            String parking_type_code = "11";
            int vehplate_color = 0;
            String plateColor = (String)rquestMap.get("plateColor");
            if (plateColor != null && plateColor.length() > 0) {
                if (plateColor.indexOf("\u84dd\u767d") != -1) {
                    vehplate_color = 6;
                } else if (plateColor.indexOf("\u9ec4\u7eff") != -1) {
                    vehplate_color = 5;
                } else if (plateColor.indexOf("\u6e10\u53d8\u7eff") != -1) {
                    vehplate_color = 4;
                } else if (plateColor.indexOf("\u9ec4") != -1) {
                    vehplate_color = 1;
                } else if (plateColor.indexOf("\u9ed1") != -1) {
                    vehplate_color = 2;
                } else if (plateColor.indexOf("\u767d") != -1) {
                    vehplate_color = 3;
                } else if (plateColor.indexOf("\u7eff") != -1) {
                    vehplate_color = 11;
                } else if (plateColor.indexOf("\u7ea2") != -1) {
                    vehplate_color = 12;
                }
            }
            String park_time = SDXLETCCloudPayer.getTimeLenSecDes((int)((exitTimeDate.getTime() - enterTimeDate.getTime()) / 1000L));
            XinlianEtcConfig etcConfig = SDXLETCCloudPayer.toXinlianEtcConfig(configMap);
            if (etcConfig == null) {
                return new SencelessPayResult("FAIL", "\u914d\u7f6e\u9519\u8bef");
            }
            if (etcConfig.getAppId() == null || etcConfig.getAppId().length() == 0 || etcConfig.getGateWay() == null || etcConfig.getGateWay().length() == 0 || etcConfig.getMerPrivateKey() == null || etcConfig.getXlPublicKey() == null) {
                return new SencelessPayResult("FAIL", "ETC\u652f\u4ed8\u914d\u7f6e\u9519\u8bef");
            }
            String channelNo = (String)rquestMap.get("passChannelNo");
            if (channelNo == null || channelNo.length() == 0) {
                channelNo = (String)rquestMap.get("exitChannelNo");
            }
            if (channelNo == null || channelNo.length() == 0) {
                return new SencelessPayResult("FAIL", "\u8bf7\u6c42\u7f3a\u5c11\u8f66\u9053\u7f16\u53f7");
            }
            XinlianEtcConfig.LaneConfig laneConfig = null;
            if (etcConfig.getLaneMapping() != null) {
                laneConfig = etcConfig.getLaneMapping().get(channelNo);
            }
            if (laneConfig == null || laneConfig.getLaneId() == null || laneConfig.getLaneId().length() == 0 || laneConfig.getLaneName() == null || laneConfig.getLaneName().length() == 0) {
                return new SencelessPayResult("FAIL", "\u6b64\u8f66\u9053\u672a\u5f00\u901aETC\u652f\u4ed8");
            }
            final String pay_serial_no = SDXLETCCloudPayer.getPaySerialNo(etcConfig.getAppId(), enterTimeDate, plateNumber);
            LinkedHashMap<String, Object> requestParams = new LinkedHashMap<String, Object>();
            requestParams.put("lane_id", laneConfig.getLaneId());
            requestParams.put("lane_name", laneConfig.getLaneName());
            requestParams.put("pay_serial_no", pay_serial_no);
            requestParams.put("trans_amount", trans_amount);
            requestParams.put("vehplate_color", vehplate_color);
            requestParams.put("vehplate_no", plateNumber);
            requestParams.put("park_time", park_time);
            requestParams.put("enter_time", enter_time);
            requestParams.put("leave_time", leave_time);
            requestParams.put("plate_type_code", plate_type_code);
            requestParams.put("parking_type_code", parking_type_code);
            String bizId = "etc.parking.cloud.fee";
            final String logHead = String.valueOf(plateNumber) + ",ETC\u4e91\u6263\u8d39" + trans_amount + "\u5206,laneId:" + laneConfig.getLaneId() + ",\u8bf7\u6c42\u5355\u53f7:" + pay_serial_no;
            final String query_pay_serial_no = pay_serial_no;
            KeyValueEntry<String, Object> kv = SDXLETCCloudPayer.doRequest(etcConfig, requestParams, bizId, logHead);
            if ("000000".equals(kv.getKey())) {
                BigDecimal totalAmount;
                int res_trans_amount;
                int status;
                KeyValueEntry dataKv = (KeyValueEntry)kv.getValue();
                if (dataKv.getValue() == null || !(dataKv.getValue() instanceof Map)) {
                    ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u7f3a\u5c11data! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                    return new SencelessPayResult("FAIL", "\u54cd\u5e94\u6570\u636e\u7f3a\u5c11data");
                }
                Map data = (Map)dataKv.getValue();
                Object statusObj = data.get("status");
                if (statusObj == null) {
                    ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u7f3a\u5c11data.status! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                    return new SencelessPayResult("FAIL", "\u54cd\u5e94\u6570\u636e\u7f3a\u5c11\u652f\u4ed8\u72b6\u6001");
                }
                try {
                    status = statusObj instanceof Number ? ((Number)statusObj).intValue() : Integer.parseInt(statusObj.toString());
                }
                catch (Exception ex) {
                    ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u672a\u77e5data.status! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                    return new SencelessPayResult("FAIL", "\u54cd\u5e94\u6570\u636e\u8fd4\u56de\u672a\u77e5\u652f\u4ed8\u72b6\u6001");
                }
                if (status != 0) {
                    ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u4ea4\u6613\u72b6\u6001\u5931\u8d25! bizId:" + bizId + ", \u6613\u72b6\u72b6\u6001: " + status));
                    return new SencelessPayResult("FAIL", "\u6263\u8d39\u5931\u8d25");
                }
                Object trans_amountObj = data.get("trans_amount");
                if (trans_amountObj == null) {
                    ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u7f3a\u5c11data.trans_amount! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                    return new SencelessPayResult("FAIL", "\u54cd\u5e94\u6570\u636e\u7f3a\u5c11\u652f\u4ed8\u72b6\u6001");
                }
                try {
                    res_trans_amount = trans_amountObj instanceof Number ? ((Number)trans_amountObj).intValue() : Integer.parseInt(trans_amountObj.toString());
                }
                catch (Exception ex) {
                    ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u672a\u77e5data.trans_amount! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                    return new SencelessPayResult("FAIL", "\u54cd\u5e94\u6570\u636e\u8fd4\u56de\u672a\u77e5\u4ea4\u6613\u91d1\u989d");
                }
                if (res_trans_amount != trans_amount) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u7684\u4ea4\u6613\u91d1\u989d\u4e0e\u8bf7\u6c42\u6263\u8d39\u7684\u4e0d\u4e00\u81f4! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                }
                String res_lane_id = (String)data.get("lane_id");
                String res_pay_serial_no = (String)data.get("pay_serial_no");
                if (!laneConfig.getLaneId().equals(res_lane_id)) {
                    ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u4ea4\u6613\u6210\u529f!\u4f46\u662f\u54cd\u5e94\u7684\u8f66\u9053\u53f7\u4e0d\u4e00\u81f4, \u8bf7\u6c42:" + laneConfig.getLaneId() + ",  bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                    return new SencelessPayResult("FAIL", "\u6263\u8d39\u8fd4\u56de\u8f66\u9053ID\u9519\u8bef");
                }
                if (!pay_serial_no.equals(res_pay_serial_no)) {
                    ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u4ea4\u6613\u6210\u529f!\u4f46\u662f\u54cd\u5e94\u7684\u652f\u4ed8\u6d41\u6c34\u53f7\u4e0d\u4e00\u81f4, \u8bf7\u6c42:" + pay_serial_no + ",  bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                    return new SencelessPayResult("FAIL", "\u6263\u8d39\u8fd4\u56de\u8f66\u9053ID\u9519\u8bef");
                }
                String res_trans_time = (String)data.get("trans_time");
                Date trans_time = null;
                if (res_trans_time != null && res_trans_time.length() > 0) {
                    try {
                        trans_time = df1.parse(res_trans_time);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (trans_time == null) {
                    trans_time = ServiceUtil.getNow();
                }
                if (res_trans_amount != trans_amount) {
                    double d = res_trans_amount / 100;
                    totalAmount = new BigDecimal(d).setScale(2, 4);
                } else {
                    totalAmount = moneyYun;
                }
                ServiceLog.getLog().info((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u6210\u529f, bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                SDXLETCCloudPayer.handleEtcPaySuccess(totalAmount, trans_time, queryFee, query_pay_serial_no, out_order_no);
                return new SencelessPayResult("WAIT_PAY_RESULT", "WAIT_PAY_RESULT");
            }
            if ("-1".equals(kv.getKey()) || "000001".equals(kv.getKey()) || "999999".equals(kv.getKey())) {
                final XinlianEtcConfig etcConfig0 = etcConfig;
                final long beginMills = ServiceUtil.getServiceContext().currentTimeMillis();
                JobTask task = new JobTask(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    protected void doRun() throws Exception {
                        LinkedHashMap<String, String> qParams = new LinkedHashMap<String, String>();
                        qParams.put("pay_serial_no", query_pay_serial_no);
                        String bizId = "etc.parking.cloud.query";
                        String logHead0 = "\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c, " + plateNumber + "ETC\u4e91\u6263\u8d39" + trans_amount + "\u5206,\u8ba2\u5355: " + query_pay_serial_no;
                        KeyValueEntry kv = SDXLETCCloudPayer.doRequest(etcConfig0, qParams, bizId, logHead0);
                        boolean reQuery = false;
                        if ("000000".equals(kv.getKey())) {
                            int status;
                            KeyValueEntry dataKv = (KeyValueEntry)kv.getValue();
                            if (dataKv.getValue() == null || !(dataKv.getValue() instanceof Map)) {
                                ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u7f3a\u5c11data! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                                return;
                            }
                            Map data = (Map)dataKv.getValue();
                            Object statusObj = data.get("status");
                            if (statusObj == null) {
                                ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u7f3a\u5c11data.status! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                                return;
                            }
                            try {
                                status = statusObj instanceof Number ? ((Number)statusObj).intValue() : Integer.parseInt(statusObj.toString());
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u672a\u77e5data.status! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                                return;
                            }
                            if (status == 0) {
                                BigDecimal totalAmount;
                                int res_trans_amount;
                                Object trans_amountObj = data.get("trans_amount");
                                if (trans_amountObj == null) {
                                    ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u7f3a\u5c11data.trans_amount! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                                    return;
                                }
                                try {
                                    res_trans_amount = trans_amountObj instanceof Number ? ((Number)trans_amountObj).intValue() : Integer.parseInt(trans_amountObj.toString());
                                }
                                catch (Exception ex) {
                                    ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u672a\u77e5data.trans_amount! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                                    return;
                                }
                                String res_pay_serial_no = (String)data.get("pay_serial_no");
                                if (!query_pay_serial_no.equals(res_pay_serial_no)) {
                                    ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u4ea4\u6613\u6210\u529f!\u4f46\u662f\u54cd\u5e94\u7684\u652f\u4ed8\u6d41\u6c34\u53f7\u4e0d\u4e00\u81f4, \u8bf7\u6c42:" + pay_serial_no + ",  bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                                    return;
                                }
                                String res_trans_time = (String)data.get("trans_time");
                                Date trans_time = null;
                                if (res_trans_time != null && res_trans_time.length() > 0) {
                                    try {
                                        trans_time = df1.parse(res_trans_time);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (trans_time == null) {
                                    trans_time = ServiceUtil.getNow();
                                }
                                if (res_trans_amount != trans_amount) {
                                    double d = res_trans_amount / 100;
                                    totalAmount = new BigDecimal(d).setScale(2, 4);
                                } else {
                                    totalAmount = moneyYun;
                                }
                                ServiceLog.getLog().info((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u5f02\u6b65\u67e5\u8be2\u72b6\u6001\u4ea4\u6613\u6210\u529f, bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + dataKv.getKey()));
                                SDXLETCCloudPayer.handleEtcPaySuccess(totalAmount, trans_time, queryFee, query_pay_serial_no, out_order_no);
                                return;
                            }
                            if (status != 2) return;
                            reQuery = true;
                        } else if ("-1".equals(kv.getKey()) || "000001".equals(kv.getKey()) || "999999".equals(kv.getKey())) {
                            reQuery = true;
                        }
                        if (!reQuery) return;
                        long timeoutMills = TimeUnit.MINUTES.toMillis(3L);
                        if (ServiceUtil.getServiceContext().currentTimeMillis() - beginMills >= timeoutMills) return;
                        ServiceUtil.getServiceContext().delay(this, 5000L, TimeUnit.MILLISECONDS);
                    }
                };
                ServiceUtil.getServiceContext().delay(task, 3000L, TimeUnit.MILLISECONDS);
            }
            return new SencelessPayResult("FAIL", kv.getValue() == null ? "\u6263\u8d39\u5931\u8d25" : kv.getValue().toString());
        }
        catch (Throwable ex) {
            ServiceLog.getLog().error((Object)ex.getMessage());
            return new SencelessPayResult("ERROR", "\u6263\u8d39\u5931\u8d25");
        }
    }

    private static void handleEtcPaySuccess(BigDecimal AMOUNT, Date payTime, CarparkQueryFee queryFee, String pay_serial_no, String outOrderNo) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("cloudOrderNo", pay_serial_no);
        dataMap.put("payAmount", AMOUNT.toString());
        dataMap.put("payTime", df.format(payTime));
        dataMap.put("payMethod", String.valueOf(6));
        dataMap.put("payScene", String.valueOf(5));
        dataMap.put("chargeOrg", String.valueOf(35));
        dataMap.put("payEntry", String.valueOf(0));
        dataMap.put("outOrderNo", outOrderNo);
        dataMap.put("tranDes", "ETC\u652f\u4ed8");
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
            long selfPayId = applicationService.createLocalRecordSeq("ck_carpark_query_fee_seq");
            int x = (int)selfPayId;
            dataMap.put("selfPayId", String.valueOf(x));
            CarparkCloudMessageHandler carparkCloudMessageHandler = (CarparkCloudMessageHandler)ServiceUtil.getServiceContext().getService("carparkCloudMessageHandler");
            carparkCloudMessageHandler.senceLessPaySuccess(dataMap, new HashMap<String, Object>());
        } else {
            CloudMsgService cloudMsgService = (CloudMsgService)ServiceUtil.getServiceContext().getService("cloudMsgService");
            cloudMsgService.senceLessPaySuccess(dataMap, new HashMap<String, Object>());
        }
    }

    public static XinlianEtcConfig toXinlianEtcConfig(Map<String, String> configMap) {
        try {
            KeyFactory keyFactory;
            byte[] encodedKey;
            String gateway = configMap.get("gateway");
            String appId = configMap.get("appId");
            String xlPublicKey = configMap.get("xlPublicKey");
            String merPrivateKey = configMap.get("merPrivateKey");
            String lanes = configMap.get("lanes");
            XinlianEtcConfig rc = new XinlianEtcConfig();
            rc.setAppId(appId);
            rc.setGateWay(gateway);
            rc.xlPublicKeyBase64 = xlPublicKey;
            rc.merPrivateKeyBase64 = merPrivateKey;
            rc.laneMapping = new HashMap();
            if (lanes != null && lanes.length() > 0) {
                JsonListType<XinlianEtcConfig.LaneConfig> jsonListType = new JsonListType<XinlianEtcConfig.LaneConfig>(XinlianEtcConfig.LaneConfig.class);
                List list = (List)GsonBuilder.create().fromJson(lanes, jsonListType);
                for (XinlianEtcConfig.LaneConfig c : list) {
                    rc.laneMapping.put(c.channelNo, c);
                }
            }
            String RSA_ALGORITHM = "RSA";
            try {
                encodedKey = Base64.getDecoder().decode(merPrivateKey);
                keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
                rc.merPrivateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)("\u5c71\u4e1cETC\u914d\u7f6e\u9519\u8bef\uff0c\u5546\u6237\u79c1\u94a5\u9519\u8bef! \u8bf7\u68c0\u67e5, appid: " + rc.appId));
            }
            try {
                encodedKey = Base64.getDecoder().decode(xlPublicKey);
                keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
                rc.xlPublicKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)("\u5c71\u4e1cETC\u914d\u7f6e\u9519\u8bef\uff0c\u4fe1\u8054\u516c\u94a5\u9519\u8bef! \u8bf7\u68c0\u67e5, appid: " + rc.appId));
            }
            return rc;
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String getTimeLenSecDes(int timeLenSec) {
        String vtext;
        int secs = timeLenSec;
        if (secs <= 0) {
            vtext = "0\u52060\u79d2";
        } else {
            int sec = timeLenSec % 60;
            int tminite = timeLenSec / 60;
            if (tminite == 0) {
                vtext = "0\u5206" + sec + "\u79d2";
            } else {
                int hour;
                int minite = tminite % 60;
                int thour = tminite / 60;
                int day = 0;
                if (thour > 24) {
                    day = thour / 24;
                    hour = thour % 24;
                } else {
                    hour = thour;
                }
                StringBuffer b = new StringBuffer();
                if (day > 0) {
                    b.append(day).append("\u5929");
                }
                if (hour > 0 || day > 0) {
                    b.append(hour).append("\u5c0f\u65f6");
                }
                b.append(minite);
                b.append("\u5206");
                b.append(sec).append("\u79d2");
                vtext = b.toString();
            }
        }
        return vtext;
    }

    private static KeyValueEntry<String, Object> doRequest(XinlianEtcConfig etcConfig, Object requestParams, String bizId, String logHead) {
        Map resMap;
        String res;
        HashMap<String, String> baseMap = new HashMap<String, String>();
        try {
            baseMap.put("versions", "1.0");
            baseMap.put("appid", etcConfig.getAppId());
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("biz_id", bizId);
            String waste_sn = String.valueOf(System.currentTimeMillis());
            int x = 32 - waste_sn.length();
            if (x > 0) {
                String r = RandomStringGenerator.getDefaultInstance().getNewString(x).toLowerCase();
                waste_sn = String.valueOf(r) + waste_sn;
            }
            dataMap.put("waste_sn", waste_sn);
            dataMap.put("params", requestParams);
            String dataJson = ServiceUtil.getHtmlEscapingGson().toJson(dataMap);
            baseMap.put("data", dataJson);
            String base64 = Base64.getEncoder().encodeToString(dataJson.getBytes("UTF-8"));
            byte[] signData = base64.getBytes("UTF-8");
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(etcConfig.getMerPrivateKey());
            signature.update(signData);
            byte[] signed = signature.sign();
            String requestSign = Base64.getEncoder().encodeToString(signed);
            baseMap.put("sign", requestSign);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u5c71\u4e1c\u4fe1\u8054ETC,\u751f\u6210\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff01bizId:" + bizId), (Throwable)ex);
            return new KeyValueEntry((Object)"-100", (Object)"\u751f\u6210\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff01");
        }
        try {
            res = (String)HttpUtil.doRequest((String)etcConfig.getGateWay(), null, baseMap, null, null, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)6000, (int)10000);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u7f51\u7edc\u9519\u8bef\uff01bizId:" + bizId), (Throwable)ex);
            return new KeyValueEntry((Object)"-1", (Object)"\u8bf7\u6c42\u7f51\u7edc\u5f02\u5e38");
        }
        if (res == null || res.length() == 0) {
            ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u7a7a\u6570\u636e\uff01bizId:" + bizId));
            return new KeyValueEntry((Object)"-2", (Object)"\u8bf7\u6c42\u7f51\u7edc\u5f02\u5e38");
        }
        try {
            resMap = (Map)ServiceUtil.getHtmlEscapingGson().fromJson(res, Map.class);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u4e0d\u662fjson\u6570\u636e\uff01bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + res));
            return new KeyValueEntry((Object)"-3", (Object)"\u8fd4\u56de\u9519\u8bef\u7684\u6570\u636e");
        }
        try {
            Map response = (Map)resMap.get("response");
            if (response == null) {
                ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u7f3a\u5c11response! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + res));
                return new KeyValueEntry((Object)"-3", (Object)"\u8fd4\u56de\u9519\u8bef\u7684\u6570\u636e");
            }
            String code = (String)response.get("code");
            if (code == null || code.length() == 0) {
                ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u7f3a\u5c11response.code! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + res));
                return new KeyValueEntry((Object)"-3", (Object)"\u8fd4\u56de\u9519\u8bef\u7684\u6570\u636e");
            }
            String resResponse = ServiceUtil.getHtmlEscapingGson().toJson((Object)response);
            if ("000000".equals(code)) {
                String resSign = (String)resMap.get("sign");
                if (resSign == null || resSign.length() == 0) {
                    ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u7f3a\u5c11resSign! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + res));
                    return new KeyValueEntry((Object)"-3", (Object)"\u8fd4\u56de\u9519\u8bef\u7684\u6570\u636e");
                }
                boolean checkSign = false;
                try {
                    byte[] checkSignBytes = Base64.getDecoder().decode(resSign);
                    String resBase64 = Base64.getEncoder().encodeToString(resResponse.getBytes("UTF-8"));
                    Signature signature = Signature.getInstance("SHA256WithRSA");
                    signature.initVerify(etcConfig.getXlPublicKey());
                    signature.update(resBase64.getBytes("UTF-8"));
                    checkSign = signature.verify(checkSignBytes);
                }
                catch (Exception ex) {
                    checkSign = false;
                }
                if (!checkSign) {
                    ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u6570\u636e\u9a8c\u7b7e\u5931\u8d25! bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + res));
                    return new KeyValueEntry((Object)"-4", (Object)"\u8fd4\u56de\u6570\u636e\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
                }
                Object data = response.get("data");
                return new KeyValueEntry((Object)code, (Object)new KeyValueEntry((Object)resResponse, data));
            }
            String message = (String)response.get("message");
            ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u5931\u8d25! bizId:" + bizId + ", \u9519\u8bef\u4ee3\u7801: " + code + ", message: " + message + ", response:" + resResponse));
            return new KeyValueEntry((Object)code, (Object)message);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)(String.valueOf(logHead) + ": \u8bf7\u6c42\u5c71\u4e1c\u4fe1\u8054ETC\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff01bizId:" + bizId + ", \u8fd4\u56de\u6570\u636e: " + res));
            return new KeyValueEntry((Object)"-3", (Object)"\u8fd4\u56de\u9519\u8bef\u7684\u6570\u636e");
        }
    }

    public static String getPaySerialNo(String appId, Date time, String plate) {
        if (selBeginTimeMills == 0L) {
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            cl.set(2020, 0, 1, 0, 0, 0);
            selBeginTimeMills = cl.getTimeInMillis();
        }
        StringBuilder sbr = new StringBuilder(32);
        int sec = (int)((time.getTime() - selBeginTimeMills) / 1000L);
        byte[] timeBytes = BytesTool.intToBytes((int)sec);
        sbr.append(appId);
        sbr.append(BytesTool.byteArrayToHexString((byte[])timeBytes));
        StringBuilder sb1 = new StringBuilder();
        int i = 0;
        while (i < plate.length()) {
            char a = plate.charAt(i);
            if (a >= '0' && a <= '9') {
                sbr.append(a);
            } else if (a >= 'A' && a <= 'Z') {
                sbr.append((char)(a + 32));
            } else if (a >= 'a' && a <= 'z') {
                sbr.append(a);
            } else {
                sb1.append(a);
            }
            if (sbr.length() >= 32) break;
            ++i;
        }
        if (sbr.length() > 0 && sbr.length() < 32) {
            byte[] at;
            String v = sbr.toString();
            try {
                at = v.getBytes("UTF-8");
            }
            catch (Exception ex) {
                at = v.getBytes();
            }
            String x = BytesTool.byteArrayToHexString((byte[])at);
            int i2 = 0;
            while (i2 < x.length()) {
                sbr.append(x.charAt(i2));
                if (sbr.length() >= 32) break;
                ++i2;
            }
        }
        if (sbr.length() <= 32) {
            return sbr.toString();
        }
        return sbr.substring(0, 32);
    }

    public static class XinlianEtcConfig {
        private String gateWay;
        private String appId;
        private String xlPublicKeyBase64;
        private PublicKey xlPublicKey;
        private String merPrivateKeyBase64;
        private PrivateKey merPrivateKey;
        private Map<String, LaneConfig> laneMapping;

        public String getGateWay() {
            return this.gateWay;
        }

        public void setGateWay(String gateWay) {
            this.gateWay = gateWay;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getXlPublicKeyBase64() {
            return this.xlPublicKeyBase64;
        }

        public void setXlPublicKeyBase64(String xlPublicKeyBase64) {
            this.xlPublicKeyBase64 = xlPublicKeyBase64;
        }

        public PublicKey getXlPublicKey() {
            return this.xlPublicKey;
        }

        public void setXlPublicKey(PublicKey xlPublicKey) {
            this.xlPublicKey = xlPublicKey;
        }

        public String getMerPrivateKeyBase64() {
            return this.merPrivateKeyBase64;
        }

        public void setMerPrivateKeyBase64(String merPrivateKeyBase64) {
            this.merPrivateKeyBase64 = merPrivateKeyBase64;
        }

        public PrivateKey getMerPrivateKey() {
            return this.merPrivateKey;
        }

        public void setMerPrivateKey(PrivateKey merPrivateKey) {
            this.merPrivateKey = merPrivateKey;
        }

        public Map<String, LaneConfig> getLaneMapping() {
            return this.laneMapping;
        }

        public void setLaneMapping(Map<String, LaneConfig> laneMapping) {
            this.laneMapping = laneMapping;
        }

        public static class LaneConfig {
            private String channelNo;
            private String laneId;
            private String laneName;

            public String getChannelNo() {
                return this.channelNo;
            }

            public void setChannelNo(String channelNo) {
                this.channelNo = channelNo;
            }

            public String getLaneId() {
                return this.laneId;
            }

            public void setLaneId(String laneId) {
                this.laneId = laneId;
            }

            public String getLaneName() {
                return this.laneName;
            }

            public void setLaneName(String laneName) {
                this.laneName = laneName;
            }
        }
    }
}

