/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.senseless.pay;

import com.google.gson.Gson;
import com.wovoe.carpark.dto.CarparkQueryFee;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.senseless.pay.RSAYongchengUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.http.HttpUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class WuhanChangSenselessPayer {
    private static final String decutRequestURI = "/pay/parkpot/toAutoPay";
    private static final String checkPlateRequestURI = "/parkCheck";
    private static long time20100101Mills;

    static {
        Calendar cl = Calendar.getInstance();
        cl.set(2020, 0, 1, 0, 0, 0);
        cl.set(14, 0);
        time20100101Mills = cl.getTimeInMillis();
    }

    private static YongchengHttpResponseBaseVo send(String accessName, String url, String rsaPrivateKey, Object obj, String plateNumber) {
        String result;
        String sign;
        String data;
        YongchengHttpRequestBaseVo vo = new YongchengHttpRequestBaseVo();
        vo.accessName = accessName;
        Gson gson = GsonBuilder.create();
        String dataJson = obj instanceof String ? (String)obj : gson.toJson(obj);
        try {
            data = RSAYongchengUtil.encryptByPrivateKey(dataJson, rsaPrivateKey);
            vo.setData(data);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u6b66\u6c49\u79d8\u94a5\u914d\u7f6e\u9519\u8bef\uff01");
            return null;
        }
        try {
            sign = RSAYongchengUtil.sign(data, rsaPrivateKey);
        }
        catch (Exception e) {
            ServiceLog.getLog().warn((Object)"\u6b66\u6c49\u79d8\u94a5\u914d\u7f6e\u9519\u8bef\uff01\u8c03\u7528\u7b7e\u540d\u5931\u8d25");
            return null;
        }
        vo.setSign(sign);
        String body = gson.toJson((Object)vo);
        try {
            result = HttpUtil.doJsonRquest((String)url, null, (String)body, (int)6000, (int)10000);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u6b66\u6c49\u670d\u52a1\u5668\u5f02\u5e38 " + ex + ", \u8bf7\u6c42\uff1a" + dataJson + ", url: " + url + ", \u52a0\u5bc6\u540e\u53d1\u9001JSON: " + body));
            return null;
        }
        if (result == null || result.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u6b66\u6c49\u670d\u52a1\u5668\u5f02\u5e38, \u8fd4\u56de\u7a7a\u6570\u636e, \u8bf7\u6c42\uff1a" + dataJson + ", url: " + url));
            return null;
        }
        ServiceLog.getLog().info((Object)(String.valueOf(plateNumber) + "\uff1a\u8c03\u7528\u6b66\u6c49\u6263\u8d39 \u54cd\u5e94: " + result));
        try {
            YongchengHttpResponseBaseVo yongchengHttpResponseBaseVo = (YongchengHttpResponseBaseVo)gson.fromJson(result, YongchengHttpResponseBaseVo.class);
            return yongchengHttpResponseBaseVo;
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u6b66\u6c49\u670d\u52a1\u5668\u5f02\u5e38 \u8fd4\u56de\u7684\u4e0d\u662fjson, \u8bf7\u6c42\uff1a" + dataJson + ", url: " + url + ", \u54cd\u5e94: " + result));
            return null;
        }
    }

    public static String getExtBusinessId(String enterNo, Date passTime) {
        int inter = (int)((passTime.getTime() - time20100101Mills) / 1000L);
        return String.valueOf(BytesTool.byteArrayToHexString((byte[])BytesTool.intToBytes((int)inter))) + enterNo;
    }

    public static Map<String, Object> deduct(CarparkQueryFee queryFee, String orderId, Map<String, String> config) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            LinkedHashMap<String, Object> requestMap = new LinkedHashMap<String, Object>();
            requestMap.put("parkpotId", config.get("parkpotId"));
            requestMap.put("extBusinessId", WuhanChangSenselessPayer.getExtBusinessId(queryFee.getEnter_record_no(), queryFee.getEnter_time()));
            int paymentTotal = (int)(queryFee.getActual_charge_amount().doubleValue() * 100.0);
            requestMap.put("paymentTotal", paymentTotal);
            requestMap.put("totalFee", paymentTotal);
            requestMap.put("outTradeNo", orderId);
            requestMap.put("outTradeTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(queryFee.getQuery_time()));
            requestMap.put("autoPayType", "0");
            String domain = config.get("com_base_address");
            if (domain.endsWith("/")) {
                domain = domain.substring(0, domain.length() - 1);
            }
            String url = String.valueOf(domain) + decutRequestURI;
            String rsaPrivateKey = config.get("platform_secret_key");
            String accessName = config.get("platform_mch_id");
            YongchengHttpResponseBaseVo vo = WuhanChangSenselessPayer.send(accessName, url, rsaPrivateKey, requestMap, queryFee.getPlate_number());
            if (vo == null) {
                returnMap.put("RETURN_CODE", "ERROR");
                returnMap.put("RETURN_VALUE", "\u67e5\u8be2\u5931\u8d25");
            } else if (!vo.isSuccess()) {
                returnMap.put("RETURN_CODE", "ERROR");
                returnMap.put("RETURN_VALUE", vo.getErrorMsg());
            } else if (vo.getData() == null) {
                returnMap.put("RETURN_CODE", "ERROR");
                returnMap.put("RETURN_VALUE", "\u8fd4\u56deNULL\u6570\u636e");
            } else if ("1".equals(vo.getData().getPayStatus())) {
                returnMap.put("RETURN_CODE", "WAIT_PAY_RESULT");
                returnMap.put("RETURN_VALUE", "WAIT_PAY_RESULT");
            } else {
                returnMap.put("RETURN_CODE", "FAIL");
                returnMap.put("RETURN_VALUE", "\u6263\u8d39\u5931\u8d25");
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u8c03\u7528\u6b66\u6c49\u652f\u4ed8\u5f02\u5e38", (Throwable)ex);
            returnMap.put("RETURN_CODE", "ERROR");
            returnMap.put("RETURN_VALUE", "\u5185\u90e8\u9519\u8bef");
        }
        return returnMap;
    }

    public static Map<String, Object> checkPermission(String plateNo, String plateType, Map<String, String> config) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        try {
            Map responseMap;
            String result;
            String sign;
            String data;
            LinkedHashMap<String, String> requestMap = new LinkedHashMap<String, String>();
            requestMap.put("parkpotId", config.get("parkpotId"));
            requestMap.put("plateNo", plateNo);
            requestMap.put("plateType", plateType);
            String domain = config.get("com_base_address");
            if (domain.endsWith("/")) {
                domain = domain.substring(0, domain.length() - 1);
            }
            String url = String.valueOf(domain) + checkPlateRequestURI;
            String rsaPrivateKey = config.get("platform_secret_key");
            String accessName = config.get("platform_mch_id");
            YongchengHttpRequestBaseVo vo = new YongchengHttpRequestBaseVo();
            vo.accessName = accessName;
            Gson gson = GsonBuilder.create();
            String dataJson = gson.toJson(requestMap);
            try {
                data = RSAYongchengUtil.encryptByPrivateKey(dataJson, rsaPrivateKey);
                vo.setData(data);
            }
            catch (Exception ex) {
                returnMap.put("RETURN_CODE", "ERROR");
                returnMap.put("RETURN_VALUE", "\u6b66\u6c49\u79d8\u94a5\u914d\u7f6e\u9519\u8bef\uff01\u52a0\u5bc6\u5931\u8d25");
                ServiceLog.getLog().warn((Object)"\u6b66\u6c49\u79d8\u94a5\u914d\u7f6e\u9519\u8bef\uff01\u52a0\u5bc6\u5931\u8d25");
                return returnMap;
            }
            try {
                sign = RSAYongchengUtil.sign(data, rsaPrivateKey);
            }
            catch (Exception e) {
                returnMap.put("RETURN_CODE", "ERROR");
                returnMap.put("RETURN_VALUE", "\u6b66\u6c49\u79d8\u94a5\u914d\u7f6e\u9519\u8bef\uff01\u8c03\u7528\u7b7e\u540d\u5931\u8d25");
                ServiceLog.getLog().warn((Object)"\u6b66\u6c49\u79d8\u94a5\u914d\u7f6e\u9519\u8bef\uff01\u8c03\u7528\u7b7e\u540d\u5931\u8d25");
                return returnMap;
            }
            vo.setSign(sign);
            String body = gson.toJson((Object)vo);
            try {
                result = HttpUtil.doJsonRquest((String)url, null, (String)body, (int)6000, (int)8000);
            }
            catch (Exception ex) {
                returnMap.put("RETURN_CODE", "ERROR");
                returnMap.put("RETURN_VALUE", "\u8bf7\u6c42\u6b66\u6c49\u670d\u52a1\u5668\u6821\u9a8c\u8f66\u724c\u662f\u5426\u6709\u6743\u9650\u901a\u8fc7\u7f51\u7edc\u5f02\u5e38! " + ex);
                ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u6b66\u6c49\u670d\u52a1\u5668\u5f02\u5e38 " + ex + ", \u8bf7\u6c42\uff1a" + dataJson + ", url: " + url + ", \u52a0\u5bc6\u540e\u53d1\u9001JSON: " + body));
                return returnMap;
            }
            if (result == null || result.length() == 0) {
                ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u6b66\u6c49\u670d\u52a1\u5668\u5f02\u5e38, \u8fd4\u56de\u7a7a\u6570\u636e, \u8bf7\u6c42\uff1a" + dataJson + ", url: " + url));
                returnMap.put("RETURN_CODE", "ERROR");
                returnMap.put("RETURN_VALUE", "\u8bf7\u6c42\u6b66\u6c49\u670d\u52a1\u5668\u6821\u9a8c\u8f66\u724c\u662f\u5426\u6709\u6743\u9650\u8fd4\u56de\u7a7a\u6570\u636e");
                return returnMap;
            }
            ServiceLog.getLog().info((Object)(String.valueOf(plateNo) + "\uff1a\u8c03\u7528\u6b66\u6c49\u8fd4\u56de\u662f\u5426\u6709\u6743\u9650\uff0c \u54cd\u5e94: " + result));
            try {
                responseMap = (Map)gson.fromJson(result, Map.class);
            }
            catch (Exception ex) {
                returnMap.put("RETURN_CODE", "ERROR");
                returnMap.put("RETURN_VALUE", "\u8bf7\u6c42\u6b66\u6c49\u670d\u52a1\u5668\u6821\u9a8c\u8f66\u724c\u662f\u5426\u6709\u6743\u9650\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e! ");
                ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u6b66\u6c49\u670d\u52a1\u5668\u5f02\u5e38 " + ex + ", \u8bf7\u6c42\uff1a" + dataJson + ", url: " + url + ", \u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e " + result));
                return returnMap;
            }
            Object resultCode = responseMap.get("result");
            boolean success = false;
            if (resultCode != null) {
                success = resultCode instanceof Number ? ((Number)resultCode).intValue() == 0 : "0".equals(resultCode.toString());
            }
            if (!success) {
                returnMap.put("RETURN_CODE", "ERROR");
                returnMap.put("RETURN_VALUE", "\u8bf7\u6c42\u6b66\u6c49\u670d\u52a1\u5668\u6821\u9a8c\u8f66\u724c\u662f\u5426\u6709\u6743\u9650\u8fd4\u56de\u8bf7\u6c42\u5931\u8d25\uff01\u9519\u8bef\u4ee3\u7801\uff1a " + responseMap.get("errcode") + ", \u9519\u8bef\u539f\u56e0\uff1a" + responseMap.get("errmsg"));
                return returnMap;
            }
            if (responseMap.get("data") == null) {
                returnMap.put("RETURN_CODE", "ERROR");
                returnMap.put("RETURN_VALUE", "\u54cd\u5e94\u7f3a\u5c11data");
                return returnMap;
            }
            Map dataMap = (Map)responseMap.get("data");
            Object _status = dataMap.get("status");
            if (_status == null) {
                returnMap.put("RETURN_CODE", "ERROR");
                returnMap.put("RETURN_VALUE", "\u54cd\u5e94data\u7f3a\u5c11status");
                return returnMap;
            }
            String status = _status instanceof String ? (String)_status : (_status instanceof Number ? String.valueOf(((Number)_status).intValue()) : _status.toString());
            Object _shareStatus = dataMap.get("shareStatus");
            String shareStatus = _shareStatus == null ? "0" : (_shareStatus instanceof Number ? String.valueOf(((Number)_shareStatus).intValue()) : _shareStatus.toString());
            if ("1".equals(status)) {
                returnMap.put("RETURN_CODE", "ALLOWPASS");
                returnMap.put("RETURN_VALUE", "1".equals(shareStatus) ? "SHARECAR" : "OK");
                return returnMap;
            }
            if ("0".equals(status)) {
                String reasonMsg = (String)returnMap.get("reasonMsg");
                returnMap.put("RETURN_CODE", "FORBITPASS");
                if (reasonMsg != null && reasonMsg.length() > 0) {
                    returnMap.put("RETURN_VALUE", reasonMsg);
                } else {
                    Object _reason = returnMap.get("reason");
                    String reason = _reason == null ? "" : (_reason instanceof Number ? String.valueOf(((Number)_reason).intValue()) : _reason.toString());
                    if ("1".equals(reason)) {
                        returnMap.put("RETURN_VALUE", "\u975e\u4f1a\u5458\u9650\u5165");
                    } else if ("2".equals(reason)) {
                        returnMap.put("RETURN_VALUE", "\u5e02\u7ea7\u9ed1\u540d\u5355\u8f66\u9650\u5165");
                    } else {
                        returnMap.put("RETURN_VALUE", "\u6b66\u6c49\u667a\u6167\u505c\u8f66\u5e73\u53f0\u7981\u6b62\u6b64\u8f66\u8f86\u8fdb\u5165");
                    }
                }
                return returnMap;
            }
            returnMap.put("RETURN_CODE", "ERROR");
            returnMap.put("RETURN_VALUE", "\u54cd\u5e94data\u672a\u77e5\u72b6\u6001\uff01 status:" + status);
            return returnMap;
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u8bf7\u6c42\u6b66\u6c49\u670d\u52a1\u5668\u6821\u9a8c\u8f66\u724c\u662f\u5426\u6709\u6743\u9650\u5f02\u5e38", (Throwable)ex);
            returnMap.put("RETURN_CODE", "ERROR");
            returnMap.put("RETURN_VALUE", "\u5185\u90e8\u9519\u8bef");
            return returnMap;
        }
    }

    public static class PayResult {
        private String isCreditleave;
        private String payMode;
        private String outTradeNo;
        private Integer paymentTotal;
        private Integer payPreferential;
        private String payid;
        private String payStatus;
        private Integer actualPay;

        public String getIsCreditleave() {
            return this.isCreditleave;
        }

        public void setIsCreditleave(String isCreditleave) {
            this.isCreditleave = isCreditleave;
        }

        public String getPayMode() {
            return this.payMode;
        }

        public void setPayMode(String payMode) {
            this.payMode = payMode;
        }

        public String getOutTradeNo() {
            return this.outTradeNo;
        }

        public void setOutTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
        }

        public Integer getPaymentTotal() {
            return this.paymentTotal;
        }

        public void setPaymentTotal(Integer paymentTotal) {
            this.paymentTotal = paymentTotal;
        }

        public Integer getPayPreferential() {
            return this.payPreferential;
        }

        public void setPayPreferential(Integer payPreferential) {
            this.payPreferential = payPreferential;
        }

        public String getPayid() {
            return this.payid;
        }

        public void setPayid(String payid) {
            this.payid = payid;
        }

        public String getPayStatus() {
            return this.payStatus;
        }

        public void setPayStatus(String payStatus) {
            this.payStatus = payStatus;
        }

        public Integer getActualPay() {
            return this.actualPay;
        }

        public void setActualPay(Integer actualPay) {
            this.actualPay = actualPay;
        }
    }

    public static class YongchengHttpRequestBaseVo {
        private String accessName;
        private String data;
        private String sign;

        public String getAccessName() {
            return this.accessName;
        }

        public void setAccessName(String accessName) {
            this.accessName = accessName;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getSign() {
            return this.sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }
    }

    public static class YongchengHttpResponseBaseVo {
        private Integer result;
        private Integer errorCode;
        private String errorMsg;
        private PayResult data;

        public boolean isSuccess() {
            return this.result != null && this.result == 0;
        }

        public Integer getResult() {
            return this.result;
        }

        public void setResult(Integer result) {
            this.result = result;
        }

        public Integer getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(Integer errorCode) {
            this.errorCode = errorCode;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public PayResult getData() {
            return this.data;
        }

        public void setData(PayResult data) {
            this.data = data;
        }
    }
}

