/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.service.impl;

import com.google.gson.Gson;
import com.wovoe.carpark.ChangeShiftsListener;
import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.ConfirmPassDialogCallback;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.DispatchDataTaskUtil;
import com.wovoe.carpark.JsonListType;
import com.wovoe.carpark.MessageLog;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.PayCodePayTask;
import com.wovoe.carpark.RpcReomtecServiceFactory;
import com.wovoe.carpark.SenselessOrderNo;
import com.wovoe.carpark.UserSession;
import com.wovoe.carpark.ValidateUtil;
import com.wovoe.carpark.charge.CarparkChargeFactory;
import com.wovoe.carpark.charge.ChargeAlgorithm;
import com.wovoe.carpark.charge.ChargeContext;
import com.wovoe.carpark.charge.ChargePassRecord;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.charge.Discount;
import com.wovoe.carpark.cloud.CarparkCloudConnection;
import com.wovoe.carpark.cloud.client.CloudCarparkDataSyncService;
import com.wovoe.carpark.cloud.client.HostSate;
import com.wovoe.carpark.conn.udp.CarparkUdpClient;
import com.wovoe.carpark.conn.udp.CarparkUdpClientManager;
import com.wovoe.carpark.conn.udp.CarparkUdpConnSession;
import com.wovoe.carpark.conn.udp.CarparkUdpP2pConnection;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkAttribute;
import com.wovoe.carpark.dto.CarparkCarOwner;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkDateRange;
import com.wovoe.carpark.dto.CarparkDiscountRecord;
import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkDutyNumber;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.dto.CarparkOperationLog;
import com.wovoe.carpark.dto.CarparkPassDiscount;
import com.wovoe.carpark.dto.CarparkPassPermission;
import com.wovoe.carpark.dto.CarparkPassPermissionChannel;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassSelfPay;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkQueryFee;
import com.wovoe.carpark.dto.CarparkRole;
import com.wovoe.carpark.dto.CarparkRolePermission;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.action.LoudspeakerAction;
import com.wovoe.carpark.equipment.driver.CYChannelDisplayAction;
import com.wovoe.carpark.equipment.driver.YKTBoardDisplayAction;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.app.LocalPassRecordEvent;
import com.wovoe.carpark.event.app.PassRecordEvent;
import com.wovoe.carpark.event.app.SelfPaySuccessEvent;
import com.wovoe.carpark.gui.GuiLog;
import com.wovoe.carpark.internel.DefaultMessageLog;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.SavePassDataFilter;
import com.wovoe.carpark.senseless.pay.CcbSenselessPayer;
import com.wovoe.carpark.senseless.pay.SDXLETCCloudPayer;
import com.wovoe.carpark.senseless.pay.SencelessPayResult;
import com.wovoe.carpark.senseless.pay.WuhanChangSenselessPayer;
import com.wovoe.carpark.senseless.pay.YiChangSenselessPayer;
import com.wovoe.carpark.senseless.pay.YongChengSenselessPayer;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.service.impl.remote.CommonRemoteServiceImpl;
import com.wovoe.carpark.service.remote.CommonRemoteService;
import com.wovoe.carpark.vo.ImportEnterPassVo;
import com.wovoe.carpark.vo.Volume;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.JavaBeanTool;
import com.wovoe.framework.JavaBeanUtil;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.Service;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RemoteConnection;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.imageio.ImageIO;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.SqlSession;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

@Service(value="applicationService")
public class ApplicationServiceImpl
implements ApplicationService {
    private static final String GUI_LOGIN_USER_SESSION = "GUI_LOGIN_USER_SESSION";
    private MessageLog messageLog = new DefaultMessageLog();
    private Properties localChannelVolumeConfig;
    private static final String localChannelVolumeConfigFile = "chvolume.conf";
    private CopyOnWriteArrayList<ChangeShiftsListener> changeShiftsListeners = new CopyOnWriteArrayList();

    @Override
    public MessageLog getMessageLog() {
        return this.messageLog;
    }

    @Override
    public String replacePlate(String regplate) {
        return regplate;
    }

    @Override
    public boolean plateEquals(String plate1, String plate2, int faultTolerant) {
        if (plate1 != null && plate2 != null) {
            if (faultTolerant <= 0) {
                return plate1.equals(plate2);
            }
            if (plate1.length() == plate2.length()) {
                try {
                    int error = 0;
                    int len = plate1.length();
                    int i = 0;
                    while (i < len) {
                        if (plate1.charAt(i) != plate2.charAt(i)) {
                            ++error;
                        }
                        ++i;
                    }
                    return error <= faultTolerant;
                }
                catch (Exception ex) {
                    return plate1.equals(plate2);
                }
            }
        }
        return false;
    }

    @Override
    public long createLocalRecordSeq(String seqName) {
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        long id = commonDaoService.getSequece(seqName);
        long idHead = (long)ServiceUtil.getServiceContext().getCarparkLocalConfig().getSeq_prefix().intValue() << 32;
        return idHead | id;
    }

    @Override
    public Map<String, Object> doGuiLogin(String userCode, String password) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (userCode == null || userCode.length() == 0) {
            resultMap.put("returnValue", "\u8bf7\u8f93\u5165\u767b\u5f55\u7528\u6237\u540d");
            return resultMap;
        }
        if (password == null || password.length() == 0) {
            resultMap.put("returnValue", "\u8bf7\u8f93\u5165\u767b\u5f55\u5bc6\u7801");
            return resultMap;
        }
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkUser user = (CarparkUser)commonDaoService.selectOne(new SearchParam().addEQ("user_code", (Object)userCode).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkUser.class);
        if (user == null) {
            resultMap.put("returnValue", "\u7528\u6237\u4e0d\u5b58\u5728");
            return resultMap;
        }
        if (user.getPassword() == null) {
            user.setPassword("");
        }
        if (!CryptoUtil.MD5Encode((String)password).toLowerCase().equals(user.getPassword().toLowerCase())) {
            resultMap.put("returnValue", "\u5bc6\u7801\u9519\u8bef");
            return resultMap;
        }
        CarparkRole role = (CarparkRole)commonDaoService.selectOne(new SearchParam().addEQ("role_no", (Object)user.getRole_no()).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkRole.class, null);
        if (role == null) {
            resultMap.put("returnValue", "\u7528\u6237\u89d2\u8272\u4e0d\u5b58\u5728");
            return resultMap;
        }
        HashSet<String> permissions = null;
        if (!"1".equals(user.getRole_no())) {
            List pList = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"permission_no"}).addEQ("role_no", (Object)user.getRole_no()).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id), CarparkRolePermission.class, null);
            if (pList != null && !pList.isEmpty()) {
                permissions = new HashSet<String>();
                for (CarparkRolePermission p1 : pList) {
                    if (p1.getPermission_no() == null || p1.getPermission_no().length() <= 0) continue;
                    permissions.add(p1.getPermission_no());
                }
            }
            if (permissions == null || !permissions.contains("long_host_client_" + ServiceUtil.getServiceContext().getLocalHostNo())) {
                resultMap.put("returnValue", "\u8be5\u7528\u6237\u6ca1\u6709\u767b\u5f55\u6743\u9650");
                return resultMap;
            }
        }
        Calendar cl = Calendar.getInstance();
        cl.add(5, -30);
        cl.set(14, 0);
        cl.set(13, 0);
        cl.set(12, 0);
        cl.set(11, 0);
        Date maxDate1 = cl.getTime();
        SearchParam p = new SearchParam().addEQ("login_duty_user_code", (Object)userCode).addEQ("login_host_no", (Object)ServiceUtil.getServiceContext().getLocalHostNo()).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("start_time DESC");
        Pagination page = new Pagination();
        page.setGotoPage(1);
        page.setNeedQueryCount(false);
        page.setRecordsCount(1L);
        page.setPageSize(1);
        CarparkDutyNumber userLastDutyNumber = (CarparkDutyNumber)commonDaoService.selectOne(p, CarparkDutyNumber.class, page);
        if (userLastDutyNumber != null && userLastDutyNumber.getEnd_time() == null) {
            if (userLastDutyNumber.getStart_time() == null) {
                userLastDutyNumber = null;
            } else if (userLastDutyNumber.getStart_time().before(maxDate1)) {
                Enumeration<PassChannel> ens;
                StringBuilder errmessage = new StringBuilder(128);
                errmessage.append("\u63d0\u9192\uff1a\u60a8\u5df2\u8fde\u7eed\u8d85\u8fc730\u5929\u672a\u4ea4\u73ed\u4e86\uff01\n\u7cfb\u7edf\u5c06\u81ea\u52a8\u4e3a\u60a8\u4ea4\u73ed\u3002\n");
                SearchParam ms = new SearchParam(commonDaoService.getTableName(CarparkTransaction.class));
                ms.setQueryFields(new String[]{"SUM(tran_money) as totol_money"});
                ms.addGTE("tran_time", (Object)userLastDutyNumber.getStart_time());
                ms.addLTE("tran_time", (Object)new Date());
                ms.addEQ("operate_user_code", (Object)userLastDutyNumber.getLogin_duty_user_code());
                ms.addEQ("duty_no", (Object)userLastDutyNumber.getDuty_no());
                ms.addEQ("pay_method", (Object)0);
                ms.addEQ("pay_scene", (Object)0);
                HashSet<String> hostSet = new HashSet<String>();
                hostSet.add(ServiceUtil.getServiceContext().getLocalHostNo());
                CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
                if (config != null && config.getHost_use() == 1 && config.getNet_mode() == 2 && config.getCarpark_deploy_type() == 1 && (ens = ServiceUtil.getServiceContext().getPassChannelManager().getChannels()) != null) {
                    while (ens.hasMoreElements()) {
                        PassChannel chanel = ens.nextElement();
                        String slaveHostNo = chanel.getChannel().getSlave_managed_host_no();
                        if (slaveHostNo == null || slaveHostNo.length() <= 0) continue;
                        hostSet.add(slaveHostNo);
                    }
                }
                if (hostSet.size() == 1) {
                    p.addEQ("host_no", (Object)ServiceUtil.getServiceContext().getLocalHostNo());
                } else {
                    p.addINList("host_no", hostSet);
                }
                Map moneyMap = commonDaoService.selectOne(ms);
                BigDecimal totol_money = null;
                if (moneyMap != null) {
                    totol_money = (BigDecimal)moneyMap.get("totol_money");
                }
                if (totol_money == null) {
                    totol_money = Constants.MONEY_ZERO;
                }
                NumberFormat sf = NumberFormat.getCurrencyInstance(Locale.CHINA);
                errmessage.append("\u4e0a\u4e2a\u73ed\u6b21\u91d1\u989d:").append(sf.format(totol_money.doubleValue()));
                resultMap.put("tipMsg", errmessage.toString());
                resultMap.put("tipTitle", "\u81ea\u52a8\u4ea4\u73ed\u63d0\u9192");
                CommonParam uparam = new CommonParam(commonDaoService.getTableName(CarparkDutyNumber.class));
                uparam.addEQ("id", (Object)userLastDutyNumber.getId());
                uparam.addUpdate("state", (Object)1);
                uparam.addUpdate("end_time", (Object)ServiceUtil.getNow());
                commonDaoService.update(uparam);
                userLastDutyNumber.setState(1);
                userLastDutyNumber.setEnd_time(ServiceUtil.getNow());
                List<CarparkDispatchTask> ulTaskList = DispatchDataTaskUtil.createDispatchRecordByIdTaskList(commonDaoService.getTableName(CarparkDutyNumber.class), userLastDutyNumber.getId(), "CARPARK_SERVER");
                CarparkDispatchTask task = null;
                if (ulTaskList != null && !ulTaskList.isEmpty()) {
                    task = ulTaskList.get(0);
                }
                if (task != null) {
                    commonDaoService.insert(task);
                }
            }
        }
        if (userLastDutyNumber != null && userLastDutyNumber.getEnd_time() == null) {
            CommonParam uparam = new CommonParam(commonDaoService.getTableName(CarparkDutyNumber.class));
            uparam.addEQ("id", (Object)userLastDutyNumber.getId());
            uparam.addUpdate("state", (Object)0);
            Date now = ServiceUtil.getNow();
            uparam.addUpdate("last_login_time", (Object)now);
            commonDaoService.update(uparam);
            userLastDutyNumber.setState(0);
            userLastDutyNumber.setLast_login_time(now);
        } else {
            userLastDutyNumber = new CarparkDutyNumber();
            userLastDutyNumber.setCarpark_id(carpark_id);
            userLastDutyNumber.setEnd_time(null);
            userLastDutyNumber.setId(this.createLocalRecordSeq("ck_carpark_duty_number_seq"));
            userLastDutyNumber.setDuty_no(userLastDutyNumber.getId().toString());
            userLastDutyNumber.setLogin_duty_user_code(userCode);
            userLastDutyNumber.setLogin_host_no(ServiceUtil.getServiceContext().getLocalHostNo());
            userLastDutyNumber.setProject_id(project_id);
            userLastDutyNumber.setStart_time(ServiceUtil.getNow());
            userLastDutyNumber.setState(0);
            userLastDutyNumber.setLast_login_time(userLastDutyNumber.getStart_time());
            commonDaoService.insert((Object)userLastDutyNumber);
            List<CarparkDispatchTask> ulTaskList = DispatchDataTaskUtil.createDispatchRecordByIdTaskList(commonDaoService.getTableName(CarparkDutyNumber.class), userLastDutyNumber.getId(), "CARPARK_SERVER");
            CarparkDispatchTask task = null;
            if (ulTaskList != null && !ulTaskList.isEmpty()) {
                task = ulTaskList.get(0);
            }
            if (task != null) {
                commonDaoService.insert(task);
            }
            if (resultMap.get("tipMsg") == null) {
                SearchParam px = new SearchParam().addEQ("login_host_no", (Object)ServiceUtil.getServiceContext().getLocalHostNo()).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id);
                px.addGTE("start_time", (Object)maxDate1).addNotEQ("login_duty_user_code", (Object)userCode).setOrerbySql("start_time DESC").setWhereString(" AND end_time IS NULL AND start_time IS NOT NULL");
                Pagination page1 = new Pagination();
                page1.setGotoPage(1);
                page1.setNeedQueryCount(false);
                page1.setRecordsCount(1L);
                page1.setPageSize(1);
                CarparkDutyNumber lastDutyNumber = (CarparkDutyNumber)commonDaoService.selectOne(px, CarparkDutyNumber.class, page1);
                if (lastDutyNumber != null && !userCode.equals(lastDutyNumber.getLogin_duty_user_code())) {
                    StringBuilder errmessage = new StringBuilder(128);
                    CarparkUser user1 = (CarparkUser)commonDaoService.selectOne(new SearchParam().addEQ("user_code", (Object)lastDutyNumber.getLogin_duty_user_code()).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkUser.class);
                    errmessage.append("\u63d0\u793a\uff1a\u4e0a\u4e00\u73ed\u6b21: ").append(lastDutyNumber.getDuty_no()).append(", ");
                    if (user1 != null) {
                        errmessage.append(user1.getUser_name());
                    } else {
                        errmessage.append(lastDutyNumber.getLogin_duty_user_code());
                    }
                    SimpleDateFormat df = new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206");
                    errmessage.append("\n\u4e0a\u73ed\u65f6\u95f4:").append(df.format(lastDutyNumber.getStart_time()));
                    SearchParam ms = new SearchParam(commonDaoService.getTableName(CarparkTransaction.class));
                    ms.setQueryFields(new String[]{"SUM(tran_money) as totol_money"});
                    ms.addGTE("tran_time", (Object)lastDutyNumber.getStart_time());
                    ms.addLTE("tran_time", (Object)new Date());
                    ms.addEQ("operate_user_code", (Object)lastDutyNumber.getLogin_duty_user_code());
                    ms.addEQ("duty_no", (Object)lastDutyNumber.getDuty_no());
                    ms.addEQ("host_no", (Object)ServiceUtil.getServiceContext().getLocalHostNo());
                    ms.addEQ("pay_method", (Object)0);
                    ms.addEQ("pay_scene", (Object)0);
                    Map moneyMap = commonDaoService.selectOne(ms);
                    BigDecimal totol_money = null;
                    if (moneyMap != null) {
                        totol_money = (BigDecimal)moneyMap.get("totol_money");
                    }
                    if (totol_money == null) {
                        totol_money = Constants.MONEY_ZERO;
                    }
                    NumberFormat sf = NumberFormat.getCurrencyInstance(Locale.CHINA);
                    errmessage.append("\n \u5df2\u6536\u73b0\u91d1:").append(sf.format(totol_money.doubleValue()));
                    errmessage.append("\n\u73ed\u6b21\u672a\u7ed3\u675f! ");
                    resultMap.put("tipMsg", errmessage.toString());
                    resultMap.put("tipTitle", "\u672a\u4ea4\u73ed\u63d0\u793a");
                }
            }
        }
        UserSession session = new UserSession(user);
        session.setDutyNumber(userLastDutyNumber);
        session.setPermissions(permissions);
        session.setRole(role);
        this.setUserSession(session);
        resultMap.put("returnValue", "SUCCESS");
        return resultMap;
    }

    public void setHostNoSp(SearchParam sp) {
        Enumeration<PassChannel> ens;
        String hostNo = ServiceUtil.getServiceContext().getLocalHostNo();
        HashSet<String> hostSet = new HashSet<String>();
        hostSet.add(hostNo);
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config != null && config.getHost_use() == 1 && config.getNet_mode() == 2 && config.getCarpark_deploy_type() == 1 && (ens = ServiceUtil.getServiceContext().getPassChannelManager().getChannels()) != null) {
            while (ens.hasMoreElements()) {
                PassChannel chanel = ens.nextElement();
                String slaveHostNo = chanel.getChannel().getSlave_managed_host_no();
                if (slaveHostNo == null || slaveHostNo.length() <= 0) continue;
                hostSet.add(slaveHostNo);
            }
        }
        if (hostSet.size() == 1) {
            sp.addEQ("host_no", (Object)hostNo);
        } else {
            sp.addINList("host_no", hostSet);
        }
    }

    @Override
    public Map<String, Object> changeShifts(String userCode, String userName, String password, Date shiftTime) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (userCode == null || userCode.length() == 0) {
            resultMap.put("returnValue", "\u8bf7\u8f93\u5165\u4ea4\u73ed\u7528\u6237\u540d");
            return resultMap;
        }
        if (password == null || password.length() == 0) {
            resultMap.put("returnValue", "\u8bf7\u8f93\u5165\u767b\u5f55\u5bc6\u7801");
            return resultMap;
        }
        UserSession currentSession = this.getUserSession();
        if (currentSession == null) {
            resultMap.put("returnValue", "\u5f53\u524d\u6ca1\u6709\u5df2\u767b\u5f55\u7684\u7528\u6237\uff0c\u65e0\u6cd5\u4ea4\u63a5\u73ed");
            return resultMap;
        }
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkUser user = (CarparkUser)commonDaoService.selectOne(new SearchParam().addEQ("user_code", (Object)userCode).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkUser.class);
        if (user == null) {
            resultMap.put("returnValue", "\u4ea4\u73ed\u7528\u6237\u4e0d\u5b58\u5728");
            return resultMap;
        }
        if (user.getPassword() == null) {
            user.setPassword("");
        }
        if (!CryptoUtil.MD5Encode((String)password).toLowerCase().equals(user.getPassword().toLowerCase())) {
            resultMap.put("returnValue", "\u767b\u5f55\u5bc6\u7801\u9519\u8bef");
            return resultMap;
        }
        CarparkRole role = (CarparkRole)commonDaoService.selectOne(new SearchParam().addEQ("role_no", (Object)user.getRole_no()).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkRole.class, null);
        if (role == null) {
            resultMap.put("returnValue", "\u7528\u6237\u89d2\u8272\u4e0d\u5b58\u5728");
            return resultMap;
        }
        HashSet<String> permissions = null;
        if (!"1".equals(user.getRole_no())) {
            List pList = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"permission_no"}).addEQ("role_no", (Object)user.getRole_no()).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id), CarparkRolePermission.class, null);
            if (pList != null && !pList.isEmpty()) {
                permissions = new HashSet<String>();
                for (CarparkRolePermission p1 : pList) {
                    if (p1.getPermission_no() == null || p1.getPermission_no().length() <= 0) continue;
                    permissions.add(p1.getPermission_no());
                }
            }
            if (permissions == null || !permissions.contains("long_host_client_" + ServiceUtil.getServiceContext().getLocalHostNo())) {
                resultMap.put("returnValue", "\u8be5\u7528\u6237\u6ca1\u6709\u767b\u5f55/\u4ea4\u73ed\u6743\u9650");
                return resultMap;
            }
        }
        if (shiftTime == null) {
            shiftTime = ServiceUtil.getNow();
        }
        CarparkDutyNumber userLastDutyNumber0 = currentSession.getDutyNumber();
        CarparkUser currentShiftUser = currentSession.getUser();
        CommonParam uparam = new CommonParam(commonDaoService.getTableName(CarparkDutyNumber.class));
        uparam.addEQ("id", (Object)userLastDutyNumber0.getId());
        uparam.addUpdate("state", (Object)1);
        uparam.addUpdate("end_time", (Object)shiftTime);
        commonDaoService.update(uparam);
        userLastDutyNumber0.setState(1);
        userLastDutyNumber0.setEnd_time(ServiceUtil.getNow());
        List<CarparkDispatchTask> ulTaskList = DispatchDataTaskUtil.createDispatchRecordByIdTaskList(commonDaoService.getTableName(CarparkDutyNumber.class), userLastDutyNumber0.getId(), "CARPARK_SERVER");
        CarparkDispatchTask task = null;
        if (ulTaskList != null && !ulTaskList.isEmpty()) {
            task = ulTaskList.get(0);
        }
        if (task != null) {
            commonDaoService.insert(task);
        }
        SearchParam p = new SearchParam().addEQ("login_duty_user_code", (Object)userCode).addEQ("login_host_no", (Object)ServiceUtil.getServiceContext().getLocalHostNo()).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("start_time DESC");
        Pagination page = new Pagination();
        page.setGotoPage(1);
        page.setNeedQueryCount(false);
        page.setRecordsCount(1L);
        page.setPageSize(1);
        CarparkDutyNumber userLastDutyNumber = (CarparkDutyNumber)commonDaoService.selectOne(p, CarparkDutyNumber.class, page);
        if (userLastDutyNumber != null && userLastDutyNumber.getEnd_time() == null) {
            if (userLastDutyNumber.getStart_time() == null) {
                userLastDutyNumber = null;
            } else {
                Calendar cl = Calendar.getInstance();
                cl.setTime(shiftTime);
                cl.add(5, -30);
                cl.set(14, 0);
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                Date maxDate1 = cl.getTime();
                if (userLastDutyNumber.getStart_time().before(maxDate1)) {
                    StringBuilder errmessage = new StringBuilder(128);
                    SimpleDateFormat df = new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
                    errmessage.append("\u73ed\u6b21\u5173\u95ed\u63d0\u9192:").append(userName).append(",\u60a8\u4e0a\u4e2a\u73ed\u6b21\u4ece").append(df.format(userLastDutyNumber.getStart_time())).append("\u5f00\u59cb,\u5df2\u8d85\u8fc730\u5929\u672a\u4ea4\u73ed,");
                    SearchParam ms = new SearchParam(commonDaoService.getTableName(CarparkTransaction.class));
                    ms.setQueryFields(new String[]{"SUM(tran_money) as totol_money"});
                    ms.addGTE("tran_time", (Object)userLastDutyNumber.getStart_time());
                    ms.addLTE("tran_time", (Object)shiftTime);
                    ms.addEQ("operate_user_code", (Object)userLastDutyNumber.getLogin_duty_user_code());
                    ms.addEQ("duty_no", (Object)userLastDutyNumber.getDuty_no());
                    this.setHostNoSp(ms);
                    ms.addEQ("pay_method", (Object)0);
                    ms.addEQ("pay_scene", (Object)0);
                    Map moneyMap = commonDaoService.selectOne(ms);
                    BigDecimal totol_money = null;
                    if (moneyMap != null) {
                        totol_money = (BigDecimal)moneyMap.get("totol_money");
                    }
                    if (totol_money == null) {
                        totol_money = Constants.MONEY_ZERO;
                    }
                    NumberFormat sf = NumberFormat.getCurrencyInstance(Locale.CHINA);
                    errmessage.append("\u4e0a\u4e2a\u73ed\u6b21\u672a\u4ea4\u91d1\u989d:").append(sf.format(totol_money.doubleValue()));
                    errmessage.append(",\u7cfb\u7edf\u5df2\u4e3a\u60a8\u5173\u95ed\u4e0a\u4e2a\u73ed\u6b21,\u60a8\u65b0\u73ed\u6b21\u4e0a\u73ed\u65f6\u95f4\u4e3a:").append(df.format(shiftTime));
                    resultMap.put("tipMsg", errmessage.toString());
                    uparam = new CommonParam(commonDaoService.getTableName(CarparkDutyNumber.class));
                    uparam.addEQ("id", (Object)userLastDutyNumber.getId());
                    uparam.addUpdate("state", (Object)1);
                    uparam.addUpdate("end_time", (Object)shiftTime);
                    commonDaoService.update(uparam);
                    userLastDutyNumber.setState(1);
                    userLastDutyNumber.setEnd_time(shiftTime);
                    List<CarparkDispatchTask> ulTaskList1 = DispatchDataTaskUtil.createDispatchRecordByIdTaskList(commonDaoService.getTableName(CarparkDutyNumber.class), userLastDutyNumber.getId(), "CARPARK_SERVER");
                    if (ulTaskList1 != null && !ulTaskList1.isEmpty()) {
                        task = ulTaskList1.get(0);
                    }
                    if (task != null) {
                        commonDaoService.insert((Object)task);
                    }
                }
            }
        }
        if (userLastDutyNumber != null && userLastDutyNumber.getEnd_time() == null) {
            uparam = new CommonParam(commonDaoService.getTableName(CarparkDutyNumber.class));
            uparam.addEQ("id", (Object)userLastDutyNumber.getId());
            uparam.addUpdate("state", (Object)0);
            uparam.addUpdate("last_login_time", (Object)shiftTime);
            commonDaoService.update(uparam);
            userLastDutyNumber.setState(0);
            userLastDutyNumber.setLast_login_time(shiftTime);
            StringBuilder errmessage = new StringBuilder(128);
            SimpleDateFormat df = new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
            errmessage.append("\u73ed\u6b21\u672a\u7ed3\u675f\u63d0\u9192:").append(userName).append(",\u60a8\u4e0a\u4e2a\u73ed\u6b21\u4ece").append(df.format(userLastDutyNumber.getStart_time())).append("\u5f00\u59cb,");
            SearchParam ms = new SearchParam(commonDaoService.getTableName(CarparkTransaction.class));
            ms.setQueryFields(new String[]{"SUM(tran_money) as totol_money"});
            ms.addGTE("tran_time", (Object)userLastDutyNumber.getStart_time());
            ms.addLTE("tran_time", (Object)shiftTime);
            ms.addEQ("operate_user_code", (Object)userLastDutyNumber.getLogin_duty_user_code());
            ms.addEQ("duty_no", (Object)userLastDutyNumber.getDuty_no());
            this.setHostNoSp(ms);
            ms.addEQ("pay_method", (Object)0);
            ms.addEQ("pay_scene", (Object)0);
            Map moneyMap = commonDaoService.selectOne(ms);
            BigDecimal totol_money = null;
            if (moneyMap != null) {
                totol_money = (BigDecimal)moneyMap.get("totol_money");
            }
            if (totol_money == null) {
                totol_money = Constants.MONEY_ZERO;
            }
            NumberFormat sf = NumberFormat.getCurrencyInstance(Locale.CHINA);
            errmessage.append("\u7d2f\u8ba1\u672a\u4ea4\u91d1\u989d:").append(sf.format(totol_money.doubleValue()));
            errmessage.append(",\u73ed\u6b21\u672a\u7ed3\u675f,\u672c\u6b21\u4ea4\u73ed\u60a8\u5c06\u63a5\u7740\u4e0a\u4e2a\u73ed\u6b21\u7ee7\u7eed\u4e0a\u73ed\u3002");
            resultMap.put("tipMsg", errmessage.toString());
        } else {
            userLastDutyNumber = new CarparkDutyNumber();
            userLastDutyNumber.setCarpark_id(carpark_id);
            userLastDutyNumber.setEnd_time(null);
            userLastDutyNumber.setId(this.createLocalRecordSeq("ck_carpark_duty_number_seq"));
            userLastDutyNumber.setDuty_no(userLastDutyNumber.getId().toString());
            userLastDutyNumber.setLogin_duty_user_code(userCode);
            userLastDutyNumber.setLogin_host_no(ServiceUtil.getServiceContext().getLocalHostNo());
            userLastDutyNumber.setProject_id(project_id);
            userLastDutyNumber.setStart_time(shiftTime);
            userLastDutyNumber.setState(0);
            userLastDutyNumber.setLast_login_time(userLastDutyNumber.getStart_time());
            commonDaoService.insert((Object)userLastDutyNumber);
            List<CarparkDispatchTask> ulTaskList1 = DispatchDataTaskUtil.createDispatchRecordByIdTaskList(commonDaoService.getTableName(CarparkDutyNumber.class), userLastDutyNumber.getId(), "CARPARK_SERVER");
            if (ulTaskList1 != null && !ulTaskList1.isEmpty()) {
                task = ulTaskList1.get(0);
            }
            if (task != null) {
                commonDaoService.insert((Object)task);
            }
        }
        UserSession session = new UserSession(user);
        session.setDutyNumber(userLastDutyNumber);
        session.setPermissions(permissions);
        session.setRole(role);
        this.setUserSession(session);
        resultMap.put("returnValue", "SUCCESS");
        if (userLastDutyNumber0 != null && userLastDutyNumber0.getStart_time() != null && this.changeShiftsListeners != null && !this.changeShiftsListeners.isEmpty()) {
            try {
                SearchParam ms = new SearchParam(commonDaoService.getTableName(CarparkTransaction.class));
                ms.setQueryFields(new String[]{"SUM(tran_money) as totol_money"});
                ms.addGTE("tran_time", (Object)userLastDutyNumber0.getStart_time());
                ms.addLTE("tran_time", (Object)shiftTime);
                ms.addEQ("operate_user_code", (Object)userLastDutyNumber0.getLogin_duty_user_code());
                ms.addEQ("duty_no", (Object)userLastDutyNumber0.getDuty_no());
                this.setHostNoSp(ms);
                ms.addEQ("pay_method", (Object)0);
                ms.addEQ("pay_scene", (Object)0);
                Map moneyMap = commonDaoService.selectOne(ms);
                BigDecimal totol_money = null;
                if (moneyMap != null) {
                    totol_money = (BigDecimal)moneyMap.get("totol_money");
                }
                if (totol_money == null) {
                    totol_money = Constants.MONEY_ZERO;
                }
                for (ChangeShiftsListener changeShiftsListener : this.changeShiftsListeners) {
                    try {
                        changeShiftsListener.onChangeShifts(userLastDutyNumber0, currentShiftUser, userLastDutyNumber, user, totol_money);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)"\u4ea4\u73ed\u56de\u8c03\u9519\u8bef\uff01", (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"\u4ea4\u73ed\u56de\u8c03\u5f02\u5e38\uff01", (Throwable)ex);
            }
        }
        return resultMap;
    }

    @Override
    public UserSession getUserSession() {
        return (UserSession)ServiceUtil.getServiceContext().getAttribute(GUI_LOGIN_USER_SESSION);
    }

    @Override
    public void setUserSession(UserSession session) {
        if (session == null) {
            ServiceUtil.getServiceContext().removeAttribute(GUI_LOGIN_USER_SESSION);
        } else {
            ServiceUtil.getServiceContext().setAttribute(GUI_LOGIN_USER_SESSION, session);
        }
    }

    @Override
    public void exeDispatchTask(CarparkDispatchTask task) {
        if (task == null || task.getId() == null) {
            return;
        }
        String cmd = task.getService_name();
        int h = cmd.lastIndexOf(46);
        String serviceName = cmd.substring(0, h);
        String methodName = cmd.substring(h + 1);
        Object obj = ServiceUtil.getServiceContext().getService(serviceName);
        if (obj == null) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u627e\u5230Service:" + serviceName + ",\u6267\u884c\u4efb\u52a1\u5931\u8d25!"));
            return;
        }
        try {
            Method method = obj.getClass().getMethod(methodName, String.class, String.class);
            Boolean renturnValue = (Boolean)method.invoke(obj, task.getHost_no(), task.getJson_data());
            if (renturnValue.booleanValue()) {
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                CommonParam p = new CommonParam(commonDaoService.getTableName(CarparkDispatchTask.class));
                p.addEQ("id", (Object)task.getId());
                commonDaoService.delete((SearchParam)p);
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u6267\u884c\u4efb\u52a1:" + cmd + "\u5f02\u5e38!"), (Throwable)ex);
        }
    }

    private void asynTryRunDispatchTask0(Map<String, List<CarparkDispatchTask>> hostTaskMap) {
        if (hostTaskMap == null || hostTaskMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<CarparkDispatchTask>> e : hostTaskMap.entrySet()) {
            List<CarparkDispatchTask> taskList;
            if (!ServiceUtil.getServiceContext().isConected(e.getKey()) || (taskList = e.getValue()) == null || taskList.isEmpty()) continue;
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (CarparkDispatchTask t : taskList) {
                            if (ServiceUtil.getServiceContext().isConected(t.getHost_no())) {
                                ApplicationServiceImpl.this.exeDispatchTask(t);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable ex) {
                        ServiceLog.getLog().warn((Object)"", ex);
                    }
                }
            });
        }
    }

    @Override
    public void asynTryRunDispatchTask(Collection<CarparkDispatchTask> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        HashMap<String, List<CarparkDispatchTask>> xmap = new HashMap<String, List<CarparkDispatchTask>>();
        for (CarparkDispatchTask t : tasks) {
            LinkedList<CarparkDispatchTask> x1 = (LinkedList<CarparkDispatchTask>)xmap.get(t.getHost_no());
            if (x1 == null) {
                x1 = new LinkedList<CarparkDispatchTask>();
                xmap.put(t.getHost_no(), x1);
            }
            x1.add(t);
        }
        this.asynTryRunDispatchTask0(xmap);
    }

    @Override
    public List<CarparkPassRecord> getSubAreaPassRecordList(CarparkPassRecord enterRecord, Date exitTime, List<CarparkPresenceRecord> extraSubRecordsList) {
        CarparkPassRecord sr;
        ArrayList subrecordsList;
        if (enterRecord == null || enterRecord.getEnter_time() == null || enterRecord.getArea_no() == null || enterRecord.getArea_no().length() == 0 || enterRecord.getPassport_number() == null || enterRecord.getPassport_number().length() == 0 || enterRecord.getMedium_type() == null || enterRecord.getArea_level() == null) {
            return null;
        }
        List<String> subAreaList = ServiceUtil.getServiceContext().getDBConfigCache().getAllSbuArea(enterRecord.getArea_no());
        if (subAreaList == null || subAreaList.isEmpty()) {
            return null;
        }
        if (exitTime == null) {
            exitTime = ServiceUtil.getNow();
        }
        int projectId = ServiceUtil.getServiceContext().getProjectId();
        int carparkId = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam passRecordParam = new SearchParam().addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)carparkId).addEQ("passport_number", (Object)enterRecord.getPassport_number()).addEQ("medium_type", (Object)enterRecord.getMedium_type()).addGTE("pass_time", (Object)enterRecord.getEnter_time()).addLTE("pass_time", (Object)exitTime);
        if (subAreaList.size() > 1) {
            passRecordParam.addINList("area_no", subAreaList);
        } else {
            passRecordParam.addEQ("area_no", (Object)subAreaList.get(0));
        }
        passRecordParam.setOrerbySql("pass_time");
        ArrayList subrecordsList0 = commonDaoService.selectList(passRecordParam, CarparkPassRecord.class, null);
        if (extraSubRecordsList == null || extraSubRecordsList.isEmpty()) {
            subrecordsList = subrecordsList0;
        } else {
            subrecordsList = new ArrayList((subrecordsList0 == null ? 0 : subrecordsList0.size()) + extraSubRecordsList.size());
            if (subrecordsList0 != null && !subrecordsList0.isEmpty()) {
                subrecordsList.addAll(subrecordsList0);
            }
            for (CarparkPresenceRecord r : extraSubRecordsList) {
                if (r == null || r.getEnter_time() == null || r.getArea_no() == null || r.getArea_no().length() == 0 || r.getEnter_time().after(exitTime) || !subAreaList.contains(r.getArea_no())) continue;
                CarparkPassRecord r1 = new CarparkPassRecord();
                JavaBeanTool.copyTo((Object)r, (Object)r1);
                r1.setExit_time(exitTime);
                r1.setPass_time(exitTime);
                r1.setExit_record_no(r1.getEnter_record_no());
                r1.setExit_plate(r1.getEnter_plate());
                subrecordsList.add(r1);
            }
        }
        if (subrecordsList == null || subrecordsList.isEmpty()) {
            return null;
        }
        PriorityQueue<CarparkPassRecord> p = new PriorityQueue<CarparkPassRecord>(2 * subrecordsList.size(), new Comparator<CarparkPassRecord>(){

            @Override
            public int compare(CarparkPassRecord o1, CarparkPassRecord o2) {
                int x = o1.getPass_time().compareTo(o2.getPass_time());
                if (x == 0) {
                    if (o1.getEnter_time() != null && o2.getEnter_time() != null) {
                        x = o1.getArea_level().compareTo(o2.getArea_level());
                    } else if (o1.getExit_time() != null && o2.getExit_time() != null) {
                        x = 0 - o1.getArea_level().compareTo(o2.getArea_level());
                    } else if (o1.getEnter_time() != null) {
                        x = -1;
                    } else if (o1.getExit_time() != null) {
                        x = 1;
                    }
                }
                return x;
            }
        });
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        HashSet<String> sx = new HashSet<String>();
        for (CarparkPassRecord r : subrecordsList) {
            if (r.getPass_time() == null || r.getArea_no() == null || r.getArea_no().length() == 0 || r.getParent_area_no() == null || r.getParent_area_no().length() == 0 || r.getArea_level() == null) continue;
            if (r.getEnter_time() != null) {
                String key = String.valueOf(r.getArea_no()) + "_" + df.format(r.getEnter_time());
                if (r.getExit_time() == null) {
                    if (sx.contains(key)) continue;
                    p.offer(r);
                    sx.add(key);
                    continue;
                }
                if (r.getEnter_time().getTime() >= enterRecord.getEnter_time().getTime() && !sx.contains(key)) {
                    CarparkPassRecord c = (CarparkPassRecord)r.clone();
                    c.setExit_time(null);
                    c.setPass_time(r.getEnter_time());
                    p.offer(c);
                    sx.add(key);
                }
                r.setEnter_time(null);
                p.offer(r);
                continue;
            }
            if (r.getExit_time() == null) continue;
            p.offer(r);
        }
        LinkedList<CarparkPassRecord> passList = new LinkedList<CarparkPassRecord>();
        LinkedList<CarparkPassRecord> enterstack = new LinkedList<CarparkPassRecord>();
        enterstack.addLast(enterRecord);
        Date lastPassTime = enterRecord.getEnter_time();
        String notExitStrv = null;
        while ((sr = p.poll()) != null) {
            CarparkPassRecord enter;
            if (sr.getExit_time() != null) {
                enter = (CarparkPassRecord)enterstack.peekLast();
                if (enter != null) {
                    if (enter.getArea_no().equals(sr.getArea_no())) {
                        enterstack.removeLast();
                        JavaBeanMap map1 = new JavaBeanMap((Object)enter);
                        JavaBeanMap map2 = new JavaBeanMap((Object)sr);
                        Set nemes = map1.keySet();
                        String _enter = "enter_";
                        for (String nem : nemes) {
                            if (!nem.startsWith(_enter)) continue;
                            map2.put(nem, map1.get((Object)nem));
                        }
                        passList.add(sr);
                    } else if (sr.getArea_level().intValue() == enter.getArea_level().intValue()) {
                        enterstack.removeLast();
                    } else if (sr.getArea_level() > enter.getArea_level()) {
                        if (enter.getArea_no().equals(sr.getParent_area_no())) {
                            sr.setEnter_time(lastPassTime);
                        }
                    } else {
                        CarparkPassRecord x1;
                        LinkedList<CarparkPassRecord> b = new LinkedList<CarparkPassRecord>();
                        while ((x1 = (CarparkPassRecord)enterstack.peekLast()) != null) {
                            if (sr.getArea_level() < x1.getArea_level()) {
                                b.add(x1);
                                enterstack.removeLast();
                                continue;
                            }
                            if (sr.getArea_level().intValue() == x1.getArea_level().intValue()) {
                                if (x1.getArea_no().equals(sr.getArea_no())) {
                                    enterstack.removeLast();
                                    for (CarparkPassRecord m : b) {
                                        if (notExitStrv == null && ((notExitStrv = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("PARKING_INNER_UNEXIT_RECORD")) == null || notExitStrv.length() == 0)) {
                                            notExitStrv = "0";
                                        }
                                        if ("1".equals(notExitStrv)) continue;
                                        m.setExit_time(sr.getExit_time());
                                        m.setPass_time(sr.getExit_time());
                                        passList.add(m);
                                    }
                                    JavaBeanMap map1 = new JavaBeanMap((Object)x1);
                                    JavaBeanMap map2 = new JavaBeanMap((Object)sr);
                                    Set nemes = map1.keySet();
                                    String _enter = "enter_";
                                    for (String nem : nemes) {
                                        if (!nem.startsWith(_enter)) continue;
                                        map2.put(nem, map1.get((Object)nem));
                                    }
                                    passList.add(sr);
                                } else {
                                    enterstack.removeLast();
                                }
                            }
                            break;
                        }
                    }
                }
            } else if (sr.getEnter_time() != null && (enter = (CarparkPassRecord)enterstack.peekLast()) != null) {
                if (sr.getArea_no().equals(enter.getArea_no())) {
                    enterstack.removeLast();
                    enterstack.addLast(sr);
                } else if (enter.getArea_no().equals(sr.getParent_area_no())) {
                    enterstack.addLast(sr);
                } else {
                    List<String> parealist = ServiceUtil.getServiceContext().getDBConfigCache().getAllParentArea(sr.getArea_no());
                    if (parealist != null && !parealist.isEmpty()) {
                        CarparkPassRecord k;
                        while ((k = (CarparkPassRecord)enterstack.peekLast()) != null) {
                            if (enterstack.size() == 1 || parealist.contains(k.getArea_no())) break;
                            enterstack.removeLast();
                        }
                        if ((k = (CarparkPassRecord)enterstack.peekLast()).getArea_no().equals(sr.getParent_area_no())) {
                            enterstack.addLast(sr);
                        }
                    }
                }
            }
            lastPassTime = sr.getPass_time();
        }
        for (CarparkPassRecord rx : enterstack) {
            if (rx == enterRecord) continue;
            if (notExitStrv == null && ((notExitStrv = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("PARKING_INNER_UNEXIT_RECORD")) == null || notExitStrv.length() == 0)) {
                notExitStrv = "0";
            }
            if ("1".equals(notExitStrv)) continue;
            rx.setExit_time(exitTime);
            rx.setPass_time(exitTime);
            passList.add(rx);
        }
        if (passList.size() > 1) {
            Collections.sort(passList, new Comparator<CarparkPassRecord>(){

                @Override
                public int compare(CarparkPassRecord o1, CarparkPassRecord o2) {
                    int x = o1.getEnter_time().compareTo(o2.getEnter_time());
                    if (x == 0) {
                        x = o1.getArea_level().compareTo(o2.getArea_level());
                    }
                    return x;
                }
            });
        }
        return passList;
    }

    @Override
    public Cost charge(CarparkPassRecord chargeEnterRecord, Date exitTime, String passportTypeNo, String carTypeNo, Date expirDate, String plateNumber, String passportNumber, Integer mediumType, Date enterTime, CarparkPassDiscount selectDiscount, CarparkPassRecord lastEntryRecord, List<CarparkPresenceRecord> extraSubRecordsList) {
        return this.charge(chargeEnterRecord, exitTime, passportTypeNo, carTypeNo, expirDate, plateNumber, passportNumber, mediumType, enterTime, selectDiscount, lastEntryRecord, extraSubRecordsList, null);
    }

    @Override
    public Cost charge(CarparkPassRecord chargeEnterRecord, Date exitTime, String passportTypeNo, String carTypeNo, Date expirDate, String plateNumber, String passportNumber, Integer mediumType, Date enterTime, CarparkPassDiscount selectDiscount, CarparkPassRecord lastEntryRecord, List<CarparkPresenceRecord> extraSubRecordsList, List<CarparkPassDiscount> otherDiscountList) {
        return this.charge(chargeEnterRecord, exitTime, passportTypeNo, carTypeNo, expirDate, plateNumber, passportNumber, mediumType, enterTime, selectDiscount, lastEntryRecord, extraSubRecordsList, otherDiscountList, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Cost charge(CarparkPassRecord chargeEnterRecord, Date exitTime, String passportTypeNo, String carTypeNo, Date expirDate, String plateNumber, String passportNumber, Integer mediumType, Date enterTime, CarparkPassDiscount selectDiscount, CarparkPassRecord lastEntryRecord, List<CarparkPresenceRecord> extraSubRecordsList, List<CarparkPassDiscount> otherDiscountList, boolean ignoreSelfPayPlanLeaveTime) {
        KeyValueEntry<CarparkPassSelfPay, List<CarparkPassSelfPay>> selepEntry = this.getCarparkPassSelfPay(passportNumber, mediumType, enterTime);
        CarparkPassSelfPay selfPay = null;
        if (selepEntry != null) {
            selfPay = (CarparkPassSelfPay)selepEntry.getKey();
        }
        CarparkPassDiscount selectDiscount00 = selectDiscount;
        CarparkPassDiscount selectDiscountToMoney = null;
        if (selectDiscount != null && selectDiscount.getDiscount_method() != null && selectDiscount.getDiscount_method() == 5 && selectDiscount.getDiscount_value() != null && selectDiscount.getDiscount_value() > 0) {
            selectDiscountToMoney = selectDiscount;
            selectDiscount = null;
        }
        if (otherDiscountList != null && !otherDiscountList.isEmpty()) {
            for (CarparkPassDiscount d : otherDiscountList) {
                if (d.getDiscount_method() == null || d.getDiscount_method() != 5 || d.getDiscount_value() == null || d.getDiscount_value() <= 0) continue;
                if (selectDiscountToMoney == null) {
                    selectDiscountToMoney = d;
                    continue;
                }
                if (d.getDiscount_value() >= selectDiscountToMoney.getDiscount_value()) continue;
                selectDiscountToMoney = d;
            }
        }
        if (!ignoreSelfPayPlanLeaveTime && selfPay != null && exitTime.getTime() <= selfPay.getPlan_leave_time().getTime()) {
            Cost cost = new Cost();
            cost.setShouldCharged(selfPay.getShould_charge());
            cost.setPeriod_multi_start(selfPay.getPeriod_multi_start());
            cost.setPeriod_multi_received(selfPay.getPeriod_multi_received());
            cost.setPeriod_multi_free(selfPay.getPeriod_multi_free());
            cost.setNext_period_multi_start(selfPay.getNext_period_multi_start());
            cost.setNext_period_multi_cur(selfPay.getNext_period_multi_cur());
            cost.setDiscountMoney(selfPay.getDiscount_money());
            cost.setCharge_start_time(selfPay.getCharge_start_time());
            cost.setChargeTimeMinutes(selfPay.getCharge_time_length());
            cost.setChargeDetail(new HashMap<String, String>());
            BigDecimal money = selfPay.getPaid_amount();
            if (selfPay.getAlready_paid() != null && selfPay.getAlready_paid().doubleValue() > 0.0) {
                money = money.add(selfPay.getAlready_paid());
            }
            cost.setAlready_paid(money);
            cost.setAlready_paid_method(selfPay.getPaid_method());
            cost.setAlready_paid_scene(selfPay.getPay_scene());
            cost.setAlready_paid_time(selfPay.getPaid_time());
            cost.setAlready_paid_charge_org(selfPay.getCharge_org());
            cost.setAlreadyPaidList((List)selepEntry.getValue());
            cost.setCash(cost.getActualCharge());
            if (cost.getCash().doubleValue() == 0.0) {
                boolean addSelectDiscount = true;
                LinkedList<CarparkPassDiscount> discountList = new LinkedList<CarparkPassDiscount>();
                try {
                    if (selfPay.getDiscounts_json() != null && selfPay.getDiscounts_json().length() > 0 && cost.getDiscountMoney() != null && cost.getDiscountMoney().doubleValue() > 0.0) {
                        JsonListType<CarparkPassDiscount> jsonListType = new JsonListType<CarparkPassDiscount>(CarparkPassDiscount.class);
                        List discountListOrder = (List)GsonBuilder.create().fromJson(selfPay.getDiscounts_json(), jsonListType);
                        if (discountListOrder != null && !discountListOrder.isEmpty()) {
                            HashMap<String, BigDecimal> disNosMap = null;
                            for (CarparkPassDiscount d : discountListOrder) {
                                if (d.getId() == null) {
                                    if ("0".equals(d.getDiscount_no()) && d.getEnter_record_no() != null && d.getPassport_number() != null && d.getMedium_type() != null && d.getDiscount_value() != null && d.getDiscount_time() != null && d.getDiscount_project_no() != null) {
                                        addSelectDiscount = false;
                                        discountList.add(d);
                                        continue;
                                    }
                                    ServiceLog.getLog().warn((Object)("CarparkPassSelfPay:\u5305\u542b\u6682\u65f6\u65e0\u6cd5\u5904\u7406\u7684\u6253\u6298\u5185\u5bb9: " + GsonBuilder.create().toJson((Object)d)));
                                    continue;
                                }
                                if (disNosMap == null) {
                                    disNosMap = new HashMap<String, BigDecimal>();
                                }
                                disNosMap.put(d.getDiscount_no(), d.getDiscount_amount() == null ? Cost.ZERO : d.getDiscount_amount());
                            }
                            if (disNosMap != null && !disNosMap.isEmpty()) {
                                List discountRecordList = null;
                                SearchParam sp = new SearchParam();
                                if (disNosMap.size() == 1) {
                                    sp.addEQ("discount_no", ServiceUtil.getFirstElement(disNosMap.keySet()));
                                } else {
                                    sp.addINList("discount_no", disNosMap.keySet());
                                }
                                sp.addEQ("enter_time", (Object)enterTime).addEQ("passport_number", (Object)passportNumber).addEQ("medium_type", (Object)mediumType);
                                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                                discountRecordList = commonDaoService.selectList(sp, CarparkDiscountRecord.class, null);
                                if (discountRecordList != null && !discountRecordList.isEmpty()) {
                                    for (CarparkDiscountRecord d : discountRecordList) {
                                        d.setDiscount_amount(Cost.ZERO);
                                        BigDecimal d2 = (BigDecimal)disNosMap.get(d.getDiscount_no());
                                        if (d2 != null) {
                                            d.setDiscount_amount(d2);
                                        }
                                        discountList.add(d);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ServiceLog.getLog().error((Object)ex.getMessage(), (Throwable)ex);
                }
                if (addSelectDiscount && selectDiscount != null && cost.getDiscountMoney() != null && cost.getDiscountMoney().doubleValue() > 0.0) {
                    discountList.add(selectDiscount);
                }
                if (!discountList.isEmpty()) {
                    cost.setDiscountList(discountList);
                }
                return cost;
            }
        }
        List<CarparkPassRecord> subAreaRecords = this.getSubAreaPassRecordList(chargeEnterRecord, exitTime, extraSubRecordsList);
        ChargePassRecord chargePassRecord = new ChargePassRecord();
        chargePassRecord.setAreaLevel(chargeEnterRecord.getArea_level());
        chargePassRecord.setAreaNo(chargeEnterRecord.getArea_no());
        chargePassRecord.setEnterTime(chargeEnterRecord.getEnter_time());
        chargePassRecord.setParentAreaNo(chargeEnterRecord.getParent_area_no());
        chargePassRecord.setRecordNo(chargeEnterRecord.getEnter_record_no());
        chargePassRecord.setExitTime(exitTime);
        if (chargeEnterRecord.getOccupy_end_time() != null && chargeEnterRecord.getOccupy_passport_type_no() != null && chargeEnterRecord.getOccupy_passport_type_no().length() > 0) {
            chargePassRecord.setFirstPassportTypeNo(chargeEnterRecord.getOccupy_passport_type_no());
            chargePassRecord.setFirtEndTime(chargeEnterRecord.getOccupy_end_time());
        }
        ArrayList<ChargePassRecord> subChargePassRecordList = null;
        if (subAreaRecords != null && !subAreaRecords.isEmpty()) {
            subChargePassRecordList = new ArrayList<ChargePassRecord>(subAreaRecords.size());
            for (CarparkPassRecord r : subAreaRecords) {
                ChargePassRecord r1 = new ChargePassRecord();
                r1.setAreaLevel(r.getArea_level());
                r1.setAreaNo(r.getArea_no());
                r1.setEnterTime(r.getEnter_time());
                r1.setParentAreaNo(r.getParent_area_no());
                if (r.getId() == null) {
                    if (r.getExit_record_no() != null && r.getExit_record_no().length() > 0) {
                        r1.setRecordNo(r.getExit_record_no());
                    } else {
                        r1.setRecordNo(r.getEnter_record_no());
                    }
                } else {
                    r1.setRecordNo(r.getId().toString());
                }
                r1.setExitTime(r.getExit_time());
                subChargePassRecordList.add(r1);
            }
        }
        LinkedList<Discount> discounts = new LinkedList<Discount>();
        List<CarparkPassDiscount> discountList = this.getPassDiscountList(passportNumber, mediumType, enterTime);
        if (discountList == null) {
            discountList = new LinkedList<CarparkPassDiscount>();
        }
        if (selectDiscount != null) {
            if (discountList instanceof LinkedList) {
                ((LinkedList)discountList).addFirst(selectDiscount);
            } else if (discountList.isEmpty()) {
                discountList.add(selectDiscount);
            } else {
                discountList.add(0, selectDiscount);
            }
        }
        if (otherDiscountList != null && !otherDiscountList.isEmpty()) {
            discountList.addAll(otherDiscountList);
        }
        if (discountList != null && !discountList.isEmpty()) {
            for (CarparkPassDiscount cd : discountList) {
                if (cd.getDiscount_method() == null || cd.getDiscount_value() == null || cd.getDiscount_time() == null || cd.getDiscount_method() == 5) continue;
                Discount d = new Discount();
                d.setDiscount_method(cd.getDiscount_method());
                d.setDiscount_no(cd.getDiscount_no());
                d.setDiscount_value(cd.getDiscount_value());
                d.setDiscountTime(cd.getDiscount_time());
                discounts.add(d);
            }
        }
        ChargeAlgorithm chargeAlgorithm = CarparkChargeFactory.getChargeAlgorithm();
        ChargeContext context = CarparkChargeFactory.getChargeContextFactory().create();
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        Integer carparkId = ServiceUtil.getServiceContext().getCarparkId();
        Cost cost = CarparkChargeFactory.getCarparkCharge().exitCharge(projectId, carparkId, passportTypeNo, carTypeNo, expirDate, chargePassRecord, subChargePassRecordList, plateNumber, discounts, context, chargeAlgorithm);
        if (cost.getCharge_start_time() == null) {
            cost.setCharge_start_time(chargePassRecord.getEnterTime());
        }
        Date chargeBeginTime = cost.getCharge_start_time();
        Date chargeEndTime = chargePassRecord.getExitTime();
        LinkedList<Map<String, String>> areaChargeLenList = new LinkedList<Map<String, String>>();
        if (chargeBeginTime != null && chargeEndTime != null && chargeEndTime.getTime() > chargeBeginTime.getTime()) {
            LinkedHashMap<String, KeyValueEntry> areaLengthMap = new LinkedHashMap<String, KeyValueEntry>();
            areaLengthMap.put(chargePassRecord.getAreaNo(), new KeyValueEntry((Object)"", (Object)((int)TimeUnit.MILLISECONDS.toMinutes(chargeEndTime.getTime() - chargeBeginTime.getTime()))));
            if (subChargePassRecordList != null && !subChargePassRecordList.isEmpty()) {
                for (ChargePassRecord chargePassRecord2 : subChargePassRecordList) {
                    CarparkArea area;
                    if (chargePassRecord2.getEnterTime() == null || chargePassRecord2.getExitTime() == null || chargePassRecord2.getExitTime().getTime() <= chargePassRecord2.getEnterTime().getTime() || (area = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap().get(chargePassRecord2.getAreaNo())) == null) continue;
                    Date beginTime = null;
                    Date endTime = null;
                    beginTime = chargePassRecord2.getEnterTime().getTime() >= chargeBeginTime.getTime() ? chargePassRecord2.getEnterTime() : chargeBeginTime;
                    endTime = chargePassRecord2.getExitTime().getTime() <= chargeEndTime.getTime() ? chargePassRecord2.getExitTime() : chargeEndTime;
                    if (beginTime == null || endTime == null || endTime.getTime() <= beginTime.getTime()) continue;
                    int mins = (int)TimeUnit.MILLISECONDS.toMinutes(endTime.getTime() - beginTime.getTime());
                    KeyValueEntry kv = (KeyValueEntry)areaLengthMap.get(chargePassRecord2.getAreaNo());
                    if (kv != null) {
                        kv.setValue((Object)((Integer)kv.getValue() + mins));
                        continue;
                    }
                    kv = new KeyValueEntry((Object)chargePassRecord2.getParentAreaNo(), (Object)mins);
                    areaLengthMap.put(chargePassRecord2.getAreaNo(), kv);
                }
            }
            for (Map.Entry entry : areaLengthMap.entrySet()) {
                int length1 = (Integer)((KeyValueEntry)entry.getValue()).getValue();
                int len2 = 0;
                for (Map.Entry entry1 : areaLengthMap.entrySet()) {
                    if (!((String)((KeyValueEntry)entry1.getValue()).getKey()).equals(entry.getKey())) continue;
                    len2 += ((Integer)((KeyValueEntry)entry1.getValue()).getValue()).intValue();
                }
                CarparkArea area = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap().get(entry.getKey());
                int len = length1 - len2;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("areaNo", (String)entry.getKey());
                map.put("areaName", area == null ? "" : area.getArea_name());
                map.put("parkLen", String.valueOf(len < 0 ? 0 : len));
                areaChargeLenList.add(map);
            }
        }
        cost.setAreaChargeLenList(areaChargeLenList);
        if (discountList != null && !discountList.isEmpty() && discounts != null && !discounts.isEmpty()) {
            block12: for (CarparkPassDiscount dic : discountList) {
                for (Discount d : discounts) {
                    if (dic.getDiscount_no() == null || !dic.getDiscount_no().equals(d.getDiscount_no())) continue;
                    dic.setDiscount_amount(d.getAmount());
                    continue block12;
                }
            }
        }
        if (selectDiscountToMoney != null) {
            BigDecimal discountToMoney = new BigDecimal(selectDiscountToMoney.getDiscount_value().doubleValue() / 100.0).setScale(2, 4);
            BigDecimal bigDecimal = cost.getActualCharge();
            if (bigDecimal.doubleValue() > discountToMoney.doubleValue()) {
                BigDecimal discountMoney = bigDecimal.subtract(discountToMoney);
                cost.setDiscountMoney(cost.getDiscountMoney().add(discountMoney));
                int discountMethod = 0;
                int discountValue = discountMoney.multiply(new BigDecimal("100")).setScale(2, 4).intValue();
                selectDiscountToMoney.setDiscount_method(discountMethod);
                selectDiscountToMoney.setDiscount_value(discountValue);
                selectDiscountToMoney.setDiscount_value_des(this.getDiscountValueDes(discountMethod, discountValue));
                selectDiscountToMoney.setDiscount_amount(discountMoney);
                if (selectDiscount00 != null && selectDiscount00 == selectDiscountToMoney) {
                    if (discountList instanceof LinkedList) {
                        ((LinkedList)discountList).addFirst(selectDiscountToMoney);
                    } else if (discountList.isEmpty()) {
                        discountList.add(selectDiscountToMoney);
                    } else {
                        discountList.add(0, selectDiscountToMoney);
                    }
                }
            }
        }
        cost.setDiscountList(discountList);
        if (cost.getShouldCharged().doubleValue() > 0.0) {
            if (lastEntryRecord != null) {
                void var33_59;
                String vx1;
                void var33_57;
                void var33_55;
                BigDecimal lastPaid = Constants.MONEY_ZERO;
                if (lastEntryRecord.getAlready_paid() != null && lastEntryRecord.getAlready_paid().doubleValue() > 0.0) {
                    lastPaid = lastPaid.add(lastEntryRecord.getAlready_paid());
                }
                if (lastEntryRecord.getCash_pay() != null && lastEntryRecord.getCash_pay().doubleValue() > 0.0) {
                    lastPaid = lastPaid.add(lastEntryRecord.getCash_pay());
                }
                if (lastEntryRecord.getDeduct_money() != null && lastEntryRecord.getDeduct_money().doubleValue() > 0.0) {
                    lastPaid = lastPaid.add(lastEntryRecord.getDeduct_money());
                }
                BigDecimal bigDecimal = cost.getShouldCharged();
                if (lastPaid.doubleValue() > 0.0) {
                    BigDecimal bigDecimal2 = bigDecimal.subtract(lastPaid);
                }
                if (var33_55.doubleValue() < 0.0) {
                    BigDecimal bigDecimal3 = Constants.MONEY_ZERO;
                }
                if (var33_57.doubleValue() > 0.0 && passportTypeNo != null && passportTypeNo.length() > 0 && (vx1 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportTypeNo, "PASSTYPE_NOENTRY_MATCH_MAXAMOUNT")) != null && vx1.length() > 0) {
                    try {
                        if (vx1.indexOf(45) == -1) {
                            BigDecimal dv = new BigDecimal(vx1).setScale(2, 4);
                            if (dv.doubleValue() > 0.0) {
                                if (var33_57.doubleValue() > dv.doubleValue()) {
                                    BigDecimal bigDecimal4 = dv;
                                }
                            } else {
                                dv.doubleValue();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                cost.setShouldCharged(var33_59.setScale(2, 4));
            }
            if (selfPay != null) {
                BigDecimal money = selfPay.getPaid_amount();
                if (selfPay.getAlready_paid() != null && selfPay.getAlready_paid().doubleValue() > 0.0) {
                    money = money.add(selfPay.getAlready_paid());
                }
                cost.setAlready_paid(money);
                cost.setAlready_paid_method(selfPay.getPaid_method());
                cost.setAlready_paid_scene(selfPay.getPay_scene());
                cost.setAlready_paid_time(selfPay.getPaid_time());
                cost.setAlready_paid_charge_org(selfPay.getCharge_org());
                cost.setAlreadyPaidList((List)selepEntry.getValue());
            }
        }
        cost.getActualCharge();
        return cost;
    }

    @Override
    public List<CarparkPassDiscount> getPassDiscountList(String passportNumber, Integer mediumType, Date enterTime) {
        List<CarparkPassDiscount> l;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        try (SqlSession session = commonDaoService.openSqlSession();){
            l = this.getPassDiscountList(session, passportNumber, mediumType, enterTime);
        }
        return l;
    }

    @Override
    public List<CarparkPassDiscount> getPassDiscountList(SqlSession session, String passportNumber, Integer mediumType, Date enterTime) {
        LinkedList<CarparkPassDiscount> discountList = new LinkedList<CarparkPassDiscount>();
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        Integer carparkId = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Calendar cl = Calendar.getInstance();
        cl.set(2018, 0, 1, 0, 0, 0);
        cl.set(14, 0);
        int minute = (int)TimeUnit.MILLISECONDS.toMinutes(enterTime.getTime() - cl.getTimeInMillis());
        SearchParam param = new SearchParam().addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)carparkId).addEQ("passport_number", (Object)passportNumber).addEQ("medium_type", (Object)mediumType).addLT("enter_time", (Object)enterTime).addEQ("discount_method", (Object)3).addGT("discount_value", (Object)minute);
        param.setOrerbySql("discount_time");
        List dlist = commonDaoService.selectList(session, param, CarparkPassDiscount.class, null);
        if (dlist != null && !dlist.isEmpty()) {
            discountList.addAll(dlist);
        }
        param = new SearchParam().addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)carparkId).addEQ("passport_number", (Object)passportNumber).addEQ("medium_type", (Object)mediumType).addEQ("enter_time", (Object)enterTime);
        param.setOrerbySql("discount_time");
        dlist = commonDaoService.selectList(session, param, CarparkPassDiscount.class, null);
        if (dlist != null && !dlist.isEmpty()) {
            discountList.addAll(dlist);
        }
        return discountList;
    }

    @Override
    public KeyValueEntry<CarparkPassSelfPay, List<CarparkPassSelfPay>> getCarparkPassSelfPay(String passportNumber, Integer mediumType, Date enterTime) {
        KeyValueEntry<CarparkPassSelfPay, List<CarparkPassSelfPay>> l;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        try (SqlSession session = commonDaoService.openSqlSession();){
            l = this.getCarparkPassSelfPay(session, passportNumber, mediumType, enterTime);
        }
        return l;
    }

    private List<CarparkPassSelfPay> mergePassSelfPay(List<CarparkPassSelfPay> selfPayList, List<CarparkTransaction> transList) {
        CarparkPassSelfPay ss;
        String key;
        boolean tranEmpty;
        boolean selfEmpty = selfPayList == null || selfPayList.isEmpty();
        boolean bl = tranEmpty = transList == null || transList.isEmpty();
        if (selfEmpty && tranEmpty) {
            return Collections.emptyList();
        }
        if (!selfEmpty && tranEmpty) {
            return selfPayList;
        }
        if (selfEmpty && !tranEmpty) {
            selfPayList = new ArrayList<CarparkPassSelfPay>(transList.size());
            Calendar cl = Calendar.getInstance();
            String sv = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("MAXSTAY_TIME_LENGTH");
            int maxAllowMinus = 15;
            try {
                if (sv != null && sv.length() > 0) {
                    maxAllowMinus = Integer.parseInt(sv);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (maxAllowMinus <= 0) {
                maxAllowMinus = 15;
            }
            for (CarparkTransaction t : transList) {
                if (t.getTran_money() == null || t.getTran_money().doubleValue() == 0.0 || t.getTran_time() == null) continue;
                cl.setTime(t.getTran_time());
                cl.add(12, maxAllowMinus);
                selfPayList.add(this.toCarparkPassSelfPay(t, cl.getTime()));
            }
            return selfPayList;
        }
        HashMap<String, CarparkTransaction> m = new HashMap<String, CarparkTransaction>();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        BigDecimal dx = new BigDecimal("100.00");
        for (CarparkTransaction t : transList) {
            if (t.getTran_money() == null || t.getTran_money().doubleValue() == 0.0 || t.getTran_time() == null) continue;
            key = String.valueOf(df.format(t.getTran_time())) + "_" + t.getTran_money().multiply(dx).intValue();
            m.put(key, t);
        }
        for (CarparkPassSelfPay sl : selfPayList) {
            key = String.valueOf(df.format(sl.getPaid_time())) + "_" + sl.getPaid_amount().multiply(dx).intValue();
            m.remove(key);
        }
        if (m.isEmpty()) {
            return selfPayList;
        }
        PriorityQueue<CarparkPassSelfPay> queue = new PriorityQueue<CarparkPassSelfPay>(m.size() + selfPayList.size(), new Comparator<CarparkPassSelfPay>(){

            @Override
            public int compare(CarparkPassSelfPay o1, CarparkPassSelfPay o2) {
                return o1.getPaid_time().compareTo(o2.getPaid_time());
            }
        });
        CarparkPassSelfPay last = null;
        for (CarparkPassSelfPay sl : selfPayList) {
            queue.offer(sl);
            last = sl;
        }
        Calendar cl = Calendar.getInstance();
        String sv = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("MAXSTAY_TIME_LENGTH");
        int maxAllowMinus = 15;
        try {
            if (sv != null && sv.length() > 0) {
                maxAllowMinus = Integer.parseInt(sv);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (maxAllowMinus <= 0) {
            maxAllowMinus = 15;
        }
        for (CarparkTransaction t : m.values()) {
            cl.setTime(t.getTran_time());
            cl.add(12, maxAllowMinus);
            CarparkPassSelfPay sp = this.toCarparkPassSelfPay(t, cl.getTime());
            if (last != null) {
                sp.setPeriod_multi_start(last.getPeriod_multi_start());
                sp.setPeriod_multi_received(last.getPeriod_multi_received());
                sp.setNext_period_multi_cur(last.getNext_period_multi_cur());
                sp.setNext_period_multi_start(last.getNext_period_multi_start());
            }
            queue.offer(sp);
        }
        selfPayList = new ArrayList<CarparkPassSelfPay>(queue.size());
        while ((ss = queue.poll()) != null) {
            selfPayList.add(ss);
        }
        return selfPayList;
    }

    private CarparkPassSelfPay toCarparkPassSelfPay(CarparkTransaction t, Date plan_leave_time) {
        CarparkPassSelfPay p = new CarparkPassSelfPay();
        p.setId(t.getId());
        p.setPaid_amount(t.getTran_money());
        p.setPaid_method(t.getPay_method());
        p.setPay_scene(t.getPay_scene());
        p.setCharge_org(t.getCharge_org());
        p.setPay_entry(t.getPay_entry());
        p.setPaid_time(t.getTran_time());
        p.setPlan_leave_time(plan_leave_time);
        p.setPassport_number(t.getPassport_number());
        p.setMedium_type(t.getMedium_type());
        p.setEnter_time(t.getEnter_time());
        p.setCharge_start_time(t.getEnter_time());
        p.setPlate_number(t.getPlate_number());
        p.setEnter_record_no(t.getEnter_record_no());
        p.setShould_charge(t.getShould_charge());
        p.setDiscount_money(t.getDiscount_money());
        p.setAlready_paid(t.getAlready_paid());
        p.setPeriod_multi_free(t.getPeriod_multi_free());
        p.setCharge_time_length((int)TimeUnit.MILLISECONDS.toMinutes(t.getTran_time().getTime() - t.getEnter_time().getTime()));
        p.setCloud_order_no(t.getOrder_no());
        p.setCharge_record_no(t.getTansaction_no());
        p.setCreated_time(t.getCreated_time());
        p.setCarpark_id(t.getCarpark_id());
        p.setProject_id(t.getProject_id());
        p.setDuty_no(t.getDuty_no());
        return p;
    }

    @Override
    public KeyValueEntry<CarparkPassSelfPay, List<CarparkPassSelfPay>> getCarparkPassSelfPay(SqlSession session, String passportNumber, Integer mediumType, Date enterTime) {
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        Integer carparkId = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam param1 = new SearchParam().addEQ("passport_number", (Object)passportNumber).addEQ("medium_type", (Object)mediumType).addEQ("enter_time", (Object)enterTime).addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)carparkId);
        param1.setOrder_by("paid_time ASC");
        List<CarparkPassSelfPay> selfPayList = commonDaoService.selectList(session, param1, CarparkPassSelfPay.class, null);
        param1 = new SearchParam().addEQ("passport_number", (Object)passportNumber).addEQ("enter_time", (Object)enterTime).addEQ("medium_type", (Object)mediumType).addEQ("tran_type", (Object)0).addEQ("service_type", (Object)0).addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)carparkId);
        param1.setOrder_by("tran_time ASC");
        List transList = commonDaoService.selectList(session, param1, CarparkTransaction.class, null);
        selfPayList = this.mergePassSelfPay(selfPayList, transList);
        if (selfPayList == null || selfPayList.isEmpty()) {
            return null;
        }
        if (selfPayList.size() == 1) {
            return new KeyValueEntry((Object)selfPayList.get(0), selfPayList);
        }
        int lastIndex = selfPayList.size() - 1;
        CarparkPassSelfPay last = selfPayList.get(lastIndex).clone();
        BigDecimal d1 = Constants.MONEY_ZERO;
        int i = 0;
        while (i < lastIndex) {
            CarparkPassSelfPay p = selfPayList.get(i);
            if (p.getPaid_amount() != null) {
                d1 = d1.add(p.getPaid_amount());
            }
            ++i;
        }
        if (last.getAlready_paid() == null || last.getAlready_paid().doubleValue() < d1.doubleValue()) {
            last.setAlready_paid(d1);
        }
        return new KeyValueEntry((Object)last, selfPayList);
    }

    @Override
    public String getDiscountValueDes(int dicountMethod, int discountValue) {
        String s;
        if (discountValue <= 0) {
            return "\u65e0\u4f18\u60e0";
        }
        if (dicountMethod == 1) {
            s = "\u514d\u8d39\u505c\u8f66" + this.getTimeLenDes(discountValue);
        } else if (dicountMethod == 0) {
            s = "\u505c\u8f66\u8d39\u51cf\u514d" + new BigDecimal((double)discountValue / 100.0).setScale(2, 4) + "\u5143";
        } else if (dicountMethod == 2) {
            s = discountValue >= 100 ? "\u505c\u8f66\u8d39\u5168\u514d" : "\u505c\u8f66\u8d39\u4f18\u60e0" + discountValue + "%";
        } else if (dicountMethod == 3) {
            Calendar cl = Calendar.getInstance();
            cl.set(2018, 0, 1, 0, 0, 0);
            cl.set(14, 0);
            cl.add(12, discountValue);
            SimpleDateFormat df = new SimpleDateFormat("yy-MM-dd HH:mm");
            s = "\u514d\u8d39\u505c\u8f66\u81f3:" + df.format(cl.getTime());
        }
        s = dicountMethod == 5 ? "\u514d\u8d39\u5230\u6307\u5b9a\u91d1\u989d" + this.getTimeLenDes(discountValue) : "";
        return s;
    }

    @Override
    public String getTimeLenDes(int timeLenMinus) {
        String vtext;
        int parkingTimes = timeLenMinus;
        if (parkingTimes <= 0) {
            vtext = "\u4e0d\u8db31\u5206\u949f";
        } else {
            int hour;
            int tminite = parkingTimes;
            int minite = tminite % 60;
            int thour = tminite / 60;
            int day = 0;
            if (thour > 24) {
                day = thour / 24;
                hour = thour % 24;
            } else {
                hour = thour;
            }
            StringBuffer b = new StringBuffer();
            if (day > 0) {
                b.append(day).append("\u5929");
            }
            if (hour > 0) {
                b.append(hour).append("\u5c0f\u65f6");
            }
            if (b.length() == 0 || minite > 0) {
                b.append(minite);
                if (day > 0) {
                    b.append("\u5206");
                } else {
                    b.append("\u5206\u949f");
                }
            }
            vtext = b.toString();
        }
        return vtext;
    }

    @Override
    public String getTimeLenSecDes(int timeLenSec) {
        String vtext;
        int secs = timeLenSec;
        if (secs <= 0) {
            vtext = "0\u79d2";
        } else {
            int sec = timeLenSec % 60;
            int tminite = timeLenSec / 60;
            if (tminite == 0) {
                vtext = String.valueOf(sec) + "\u79d2";
            } else {
                int hour;
                int minite = tminite % 60;
                int thour = tminite / 60;
                int day = 0;
                if (thour > 24) {
                    day = thour / 24;
                    hour = thour % 24;
                } else {
                    hour = thour;
                }
                StringBuffer b = new StringBuffer();
                if (day > 0) {
                    b.append(day).append("\u5929");
                }
                if (hour > 0) {
                    b.append(hour).append("\u5c0f\u65f6");
                }
                if (minite == 0) {
                    if (b.length() == 0) {
                        b.append(sec).append("\u79d2");
                    } else if (sec > 0) {
                        b.append(sec).append("\u79d2");
                    }
                } else if (sec == 0) {
                    b.append(minite);
                    if (day > 0) {
                        b.append("\u5206");
                    } else {
                        b.append("\u5206\u949f");
                    }
                } else if (b.length() == 0) {
                    b.append(minite).append("\u5206\u949f").append(sec).append("\u79d2");
                } else {
                    b.append(minite).append("\u5206").append(sec).append("\u79d2");
                }
                vtext = b.toString();
            }
        }
        return vtext;
    }

    @Override
    public OperationFuture<Map<String, BufferedImage>> asynLoadRemotePic(final String picHost, final String ... dbpicPaths) {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            if (dbpicPaths == null || dbpicPaths.length == 0) {
                f.setResult(new HashMap());
            } else {
                final HashMap rMap = new HashMap();
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String[] stringArray = dbpicPaths;
                            int n = dbpicPaths.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String dbpath = stringArray[n2];
                                try {
                                    BufferedImage img = ApplicationServiceImpl.this.loadPic(picHost, dbpath);
                                    rMap.put(dbpath, img);
                                }
                                catch (Exception ex) {
                                    ServiceLog.getLog().warn((Object)("\u52a0\u8f7d\u56fe\u7247\u5f02\u5e38!" + ex.getMessage()));
                                }
                                ++n2;
                            }
                        }
                        finally {
                            f.setResult((Object)rMap);
                        }
                    }
                });
            }
        }
        catch (Throwable ex) {
            f.setResult(new HashMap());
        }
        return f;
    }

    @Override
    public BufferedImage loadLocalPic(String dbpath) {
        block4: {
            try {
                if (dbpath != null && dbpath.length() != 0) break block4;
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        RecordSaveService s = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        String path = s.getLocalPicPath(dbpath);
        File f1 = new File(path);
        if (f1.exists() && f1.isFile()) {
            return ImageIO.read(f1);
        }
        return null;
    }

    @Override
    public BufferedImage loadLanRemotePic(String hostno, String dbpath) {
        BufferedImage buff;
        block29: {
            CarparkHost host;
            block27: {
                block26: {
                    block25: {
                        if (hostno == null || hostno.length() == 0 || dbpath == null || dbpath.length() == 0) {
                            return null;
                        }
                        buff = null;
                        if (ServiceUtil.getServiceContext().getLocalHostNo().equals(hostno)) {
                            return this.loadLocalPic(dbpath);
                        }
                        if (ServiceUtil.getServiceContext().isConected(hostno)) break block25;
                        return null;
                    }
                    host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(hostno);
                    if (host != null) break block26;
                    return null;
                }
                if (host.getNet_mode() == 1) break block27;
                return null;
            }
            try {
                String remoteHostIp = host.getHost_ip();
                int remotePort = host.getHost_port();
                StringBuilder sbr = new StringBuilder(128);
                sbr.append("http://").append(remoteHostIp);
                if (remotePort != 80) {
                    sbr.append(':').append(remotePort);
                }
                sbr.append("/obtainlocalpic.action");
                String path = BytesTool.compressBytes((byte[])dbpath.getBytes("UTF-8"));
                sbr.append("?path=").append(path);
                URL url = new URL(sbr.toString());
                HttpURLConnection httpUrlConn = (HttpURLConnection)url.openConnection();
                httpUrlConn.setConnectTimeout(4000);
                httpUrlConn.setReadTimeout(5000);
                httpUrlConn.connect();
                ByteArrayOutputStream out = new ByteArrayOutputStream(512000);
                try (InputStream in = httpUrlConn.getInputStream();){
                    int r;
                    while ((r = in.read()) != -1) {
                        out.write(r);
                    }
                }
                finally {
                    try {
                        httpUrlConn.disconnect();
                    }
                    catch (Exception exception) {}
                }
                byte[] data = out.toByteArray();
                ByteArrayInputStream oui = new ByteArrayInputStream(data);
                buff = ImageIO.read(oui);
                try {
                    CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
                    if (localHost.getHost_type() == null || localHost.getHost_type() != 1) break block29;
                    RecordSaveService s = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                    String localpath = s.getLocalPicPath(dbpath);
                    File localPicFile = new File(localpath);
                    if (!localPicFile.getParentFile().exists()) {
                        localPicFile.getParentFile().mkdirs();
                    }
                    try (FileOutputStream fout = new FileOutputStream(localPicFile);){
                        fout.write(data);
                    }
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return buff;
    }

    @Override
    public BufferedImage loadPic(String hostno, String dbpath) {
        if (dbpath == null || dbpath.length() == 0) {
            return null;
        }
        BufferedImage in = this.loadLocalPic(dbpath);
        if (in != null) {
            return in;
        }
        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
        if (localHost != null) {
            if (localHost.getHost_use() == 1) {
                CarparkHost serverHost;
                CarparkHost chost;
                if (localHost.getNet_mode() == 2) {
                    if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                        block30: {
                            if (!ServiceUtil.getServiceContext().isConnectedCloud()) {
                                return null;
                            }
                            try {
                                BufferedImage buff;
                                block31: {
                                    byte[] data = CloudCarparkDataSyncService.getRemotePic(dbpath, null);
                                    if (data == null || data.length <= 0) break block30;
                                    ByteArrayInputStream oui = new ByteArrayInputStream(data);
                                    buff = ImageIO.read(oui);
                                    try {
                                        if (localHost.getHost_type() == null || localHost.getHost_type() != 1) break block31;
                                        RecordSaveService s = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                                        String localpath = s.getLocalPicPath(dbpath);
                                        File localPicFile = new File(localpath);
                                        if (!localPicFile.getParentFile().exists()) {
                                            localPicFile.getParentFile().mkdirs();
                                        }
                                        try (FileOutputStream fout = new FileOutputStream(localPicFile);){
                                            fout.write(data);
                                        }
                                    }
                                    catch (Exception ex) {
                                        ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                                    }
                                }
                                return buff;
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)("\u4ece\u4e91\u7aef\u83b7\u53d6\u56fe\u7247\u5931\u8d25!" + ex.getMessage()));
                            }
                        }
                        return null;
                    }
                    CarparkUdpP2pConnection conn = ServiceUtil.getServiceContext().getCarparkUdpP2pConnection();
                    if (conn == null) {
                        return null;
                    }
                    CarparkUdpConnSession session = conn.getConnectedServerSession();
                    if (session == null) {
                        return null;
                    }
                    return this.loadWanPic(localHost.getHost_no(), session.getCarparkSignKey(), session.getCarparkSeverHostNo(), session.getCarparkServerAddress(), dbpath, 8000L, session.isUseCloudProxy(), session.getCloudSocketAddress(), session.getProxyToken());
                }
                if (hostno != null && hostno.length() > 0 && !hostno.equals(localHost.getHost_no()) && (chost = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(hostno)) != null) {
                    if (chost.getHost_use() == 1) {
                        BufferedImage in1;
                        if (chost.getNet_mode() == 1 && chost.getHost_type() != null && chost.getHost_type() == 1 && (in1 = this.loadLanRemotePic(hostno, dbpath)) != null) {
                            return in1;
                        }
                    } else {
                        return this.loadLanRemotePic(hostno, dbpath);
                    }
                }
                if ((serverHost = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkServerHost()) != null) {
                    return this.loadLanRemotePic(serverHost.getHost_no(), dbpath);
                }
                return null;
            }
            if (hostno == null || hostno.length() == 0) {
                return null;
            }
            if (hostno.equals(localHost.getHost_no())) {
                return null;
            }
            CarparkHost chost = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(hostno);
            if (chost == null) {
                return null;
            }
            if (chost.getHost_type() != 1) {
                return null;
            }
            if (chost.getNet_mode() == 2) {
                CarparkUdpClient client = CarparkUdpClientManager.getInstance().getCarparkUdpClient(hostno);
                if (client == null) {
                    return null;
                }
                if (!client.isConnected()) {
                    return null;
                }
                InetSocketAddress clientAddress = client.getClientAddress();
                if (clientAddress == null) {
                    return null;
                }
                return this.loadWanPic(localHost.getHost_no(), ServiceUtil.getServiceContext().getCarpark().getLan_sign_key(), hostno, clientAddress, dbpath, 8000L, client.isUseCloudProxy(), client.getCloudSocketAddress(), client.getProxyToken());
            }
            return this.loadLanRemotePic(hostno, dbpath);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage loadWanPic(String srcHostNo, String signKey, String detHostNo, InetSocketAddress remoteAddress, String dbpath, final long timeOutMills, boolean useCloudProxy, InetSocketAddress cloudProxySocketAddress, byte[] proxyToken) {
        try {
            RemoteConnection conn = ServiceUtil.getServiceContext().getCarparkUdpConnectionFactory().createUdpConnection(remoteAddress);
            RequestSender sender = conn.createRequest();
            if (useCloudProxy) {
                if (cloudProxySocketAddress != null && proxyToken != null && proxyToken.length > 0) {
                    sender.setAttribute("USE_CLOUD_PROXY_ENTRY", (Object)new KeyValueEntry((Object)cloudProxySocketAddress, (Object)proxyToken));
                } else {
                    sender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
                }
            } else {
                sender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
            }
            sender.setRequestActionName("/CaraprkDownloadFileAction");
            sender.setHeader("op", "downloadDBPic");
            sender.setHeader("srcHostNo", srcHostNo);
            sender.setHeader("destHostNo", detHostNo);
            sender.setHeader("tmills", String.valueOf(System.currentTimeMillis()));
            sender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            sender.setHeader("dbpath", dbpath);
            sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)signKey));
            final OperationFutureHandler rh = ServiceUtil.getServiceContext().createOperationFuture();
            sender.doRequest(new SendCallback(){

                public void onException(Throwable ex) {
                    rh.setException(ex);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    rh.setException((Throwable)new TimeoutException("\u4e0b\u8f7d\u56fe\u7247\u54cd\u5e94\u8d85\u65f6"));
                }

                public long getWaitTimeoutMills() {
                    return timeOutMills;
                }

                public void doReceiver(Receiver r, int id) throws Exception {
                    rh.setResult((Object)r);
                }
            });
            Receiver rev = (Receiver)rh.get(timeOutMills + 1000L, TimeUnit.MILLISECONDS);
            if (rev == null) {
                throw new TimeoutException("\u4e0b\u8f7d\u56fe\u7247\u54cd\u5e94\u8d85\u65f6");
            }
            String repCode = rev.getHeaderValue("respCode");
            if (!"SUCCESS".equals(repCode)) {
                if ("FILE_NOT_FOUND".equals(repCode)) {
                    return null;
                }
                String msg = rev.getHeaderValue("respMsg");
                if (msg != null) throw new IOException(msg);
                msg = "\u9519\u8bef\uff1a" + repCode;
                throw new IOException(msg);
            }
            String sign = rev.getHeaderValue("sign");
            String checkSign = HMPNetDataSignTool.getSign((Receiver)rev, (String)signKey);
            if (!checkSign.equals(sign)) {
                throw new IOException("\u6570\u636e\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
            }
            if (rev.getData() == null) return null;
            if (rev.getDataLength() == 0) return null;
            if (rev.getData().length == 0) {
                return null;
            }
            ByteArrayInputStream oui = new ByteArrayInputStream(rev.getData(), rev.getDataOffset(), rev.getDataLength());
            BufferedImage buff = ImageIO.read(oui);
            try {
                CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
                if (localHost.getHost_type() == null) return buff;
                if (localHost.getHost_type() != 1) return buff;
                RecordSaveService s = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                String localpath = s.getLocalPicPath(dbpath);
                File localPicFile = new File(localpath);
                if (!localPicFile.getParentFile().exists()) {
                    localPicFile.getParentFile().mkdirs();
                }
                try (FileOutputStream fout = new FileOutputStream(localPicFile);){
                    fout.write(rev.getData(), rev.getDataOffset(), rev.getDataLength());
                    return buff;
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"", (Throwable)ex);
            }
            return buff;
        }
        catch (Throwable ex) {
            Throwable t;
            if (ex instanceof ExecutionException && (t = ((ExecutionException)ex).getCause()) != null) {
                ex = t;
            }
            ServiceLog.getLog().warn((Object)("\u83b7\u53d6\u8fdc\u7a0b\u56fe\u7247\u5f02\u5e38\uff1a" + ex.getMessage()));
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> querySimilarPresenceRecord(String[] queryFields, final String plateNumber, String areaNo, int errV) {
        if (plateNumber == null || plateNumber.length() == 0 || areaNo == null || areaNo.length() == 0) {
            return new ArrayList<Map<String, Object>>(0);
        }
        if (errV < 0) {
            errV = 0;
        }
        if (errV > plateNumber.length()) {
            errV = plateNumber.length();
        }
        final int errx = errV;
        final List[] set1 = new List[errx + 1];
        int i = 0;
        while (i <= errx) {
            set1[i] = new LinkedList();
            ++i;
        }
        String[] qeureyStr = null;
        String field_passport_number = "passport_number";
        if (queryFields != null && queryFields.length > 0) {
            ArrayList<String> x = new ArrayList<String>(queryFields.length + 1);
            boolean findp = false;
            String[] stringArray = queryFields;
            int n = queryFields.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null && s.length() != 0) {
                    x.add(s);
                    if (!findp && "passport_number".equals(s)) {
                        findp = true;
                    }
                }
                ++n2;
            }
            if (!findp) {
                x.add("passport_number");
            }
            qeureyStr = x.toArray(new String[x.size()]);
        }
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam p = new SearchParam(daoService.getTableName(CarparkPresenceRecord.class));
        p.addEQ("medium_type", (Object)6);
        p.addEQ("area_no", (Object)areaNo);
        p.addEQ("exit_time", null);
        p.addNotEQ("enter_time", null);
        p.setOrerbySql("id");
        if (qeureyStr != null && qeureyStr.length > 0) {
            p.setQueryFields(qeureyStr);
        }
        final int[] taotalSize = new int[1];
        daoService.select(p, null, (ResultHandler)new ResultHandler<Map<String, Object>>(){

            public void handleResult(ResultContext<? extends Map<String, Object>> context) {
                if (context == null) {
                    return;
                }
                Map r = (Map)context.getResultObject();
                if (r == null) {
                    return;
                }
                String plate = (String)r.get("passport_number");
                if (plate == null || plate.length() == 0) {
                    return;
                }
                if (plateNumber.length() != plate.length()) {
                    return;
                }
                int errcount = 0;
                int i = 0;
                while (i < plateNumber.length()) {
                    if (plateNumber.charAt(i) != plate.charAt(i)) {
                        ++errcount;
                    }
                    if (errcount > errx) break;
                    ++i;
                }
                if (errcount <= errx) {
                    List s1 = set1[errcount];
                    s1.add(r);
                    taotalSize[0] = taotalSize[0] + 1;
                }
            }
        });
        if (taotalSize[0] == 0) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> xlist = new ArrayList<Map<String, Object>>(taotalSize[0]);
        int i2 = 0;
        while (i2 < set1.length) {
            List a = set1[i2];
            if (a != null && !a.isEmpty()) {
                xlist.addAll(a);
            }
            ++i2;
        }
        return xlist;
    }

    @Override
    public void modifyEnterPlate(long recordId, String oldPlate, String newPlate, Date modifyDate, String modifyUserCode, String modifyUserName) {
        LinkedList<CarparkDispatchTask> dispatchTaskList = new LinkedList<CarparkDispatchTask>();
        CommonDaoService commonServie = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPassRecord record = null;
        try (SqlSession session = commonServie.openSqlSession();){
            try {
                RecordSaveService recordSaveService;
                UserSession userSession = this.getUserSession();
                if (modifyUserCode == null || modifyUserCode.length() == 0 || modifyUserName == null || modifyUserName.length() == 0) {
                    if (userSession != null && userSession.getUser() != null) {
                        modifyUserCode = userSession.getUser().getUser_code();
                        modifyUserName = userSession.getUser().getUser_name();
                    } else {
                        modifyUserCode = "admin";
                        modifyUserName = "\u8d85\u7ea7\u7ba1\u7406\u5458";
                    }
                }
                if (modifyDate == null) {
                    modifyDate = ServiceUtil.getNow();
                }
                if ((record = (recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class)).handleModifyPlate(session, recordId, oldPlate, newPlate, modifyDate, modifyUserCode, modifyUserName)) != null) {
                    HashMap<String, String> jsonMap = new HashMap<String, String>();
                    jsonMap.put("recordId", String.valueOf(recordId));
                    jsonMap.put("oldPlate", oldPlate);
                    jsonMap.put("newPlate", newPlate);
                    jsonMap.put("modifyTimeMills", String.valueOf(modifyDate.getTime()));
                    jsonMap.put("modifyUserCode", modifyUserCode);
                    jsonMap.put("modifyUserName", modifyUserName);
                    Gson gosn = GsonBuilder.create();
                    String jsonparamString = gosn.toJson(jsonMap);
                    List<CarparkDispatchTask> dlist = DispatchDataTaskUtil.createDispatchTaskList("transferDataService.sendModifyPassPlate", jsonparamString, "ALL_HOSTS");
                    if (dlist != null && !dlist.isEmpty()) {
                        for (CarparkDispatchTask task : dlist) {
                            commonServie.insert(session, (Object)task);
                            dispatchTaskList.add(task);
                        }
                    }
                }
                session.commit();
            }
            catch (Throwable e) {
                session.rollback();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (record != null) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new PassRecordEvent(this, record));
            if (ServiceUtil.getServiceContext().getLocalHostNo().equals(record.getEnter_host_no())) {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new LocalPassRecordEvent(this, record));
            }
        }
        if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
            this.asynTryRunDispatchTask(dispatchTaskList);
        }
    }

    @Override
    public BigDecimal queryDutyTotalCash(Date endDate) {
        UserSession loginUserSession = this.getUserSession();
        if (loginUserSession == null) {
            return Constants.MONEY_ZERO;
        }
        CarparkDutyNumber dutyNumber = loginUserSession.getDutyNumber();
        if (dutyNumber == null) {
            return Constants.MONEY_ZERO;
        }
        CommonDaoService commonServie = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam p = new SearchParam(commonServie.getTableName(CarparkTransaction.class));
        p.addGTE("tran_time", (Object)dutyNumber.getStart_time());
        if (endDate != null) {
            p.addLTE("tran_time", (Object)endDate);
        }
        p.addEQ("pay_method", (Object)0);
        p.addEQ("duty_no", (Object)dutyNumber.getDuty_no());
        p.addEQ("host_no", (Object)ServiceUtil.getServiceContext().getLocalHostNo());
        p.addEQ("operate_user_code", (Object)dutyNumber.getLogin_duty_user_code());
        p.addEQ("pay_scene", (Object)0);
        p.addQueyField("SUM(tran_money) AS total_cash");
        Map map = commonServie.selectOne(p);
        if (map == null || map.isEmpty()) {
            return Constants.MONEY_ZERO;
        }
        BigDecimal money = (BigDecimal)map.get("total_cash");
        if (money == null) {
            return Constants.MONEY_ZERO;
        }
        return money;
    }

    @Override
    public Volume getVolume(Equipment equipment) {
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig() != null && ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != null && ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
            EquipmentConfig config;
            String DAY_TIME_SET = null;
            String DAY_TIME_VOLUME = null;
            String NIGHT_TIME_VOLUME = null;
            if (equipment != null && (config = equipment.getEquipmentConfig()) != null) {
                DAY_TIME_SET = config.getConfigValue("DAY_TIME_SET");
                DAY_TIME_VOLUME = config.getConfigValue("DAY_TIME_VOLUME");
                NIGHT_TIME_VOLUME = config.getConfigValue("NIGHT_TIME_VOLUME");
            }
            if (DAY_TIME_SET == null || DAY_TIME_SET.length() == 0) {
                DAY_TIME_SET = "07:00:00-19:00:00";
            }
            int dayBeginHour = 7;
            int dayBeginMins = 0;
            int dayEndHour = 19;
            int dayEndMins = 0;
            int dayVolume = 50;
            int nightVolume = 50;
            try {
                if (DAY_TIME_VOLUME != null && DAY_TIME_VOLUME.length() > 0) {
                    int x = Integer.parseInt(DAY_TIME_VOLUME);
                    if (x < 0) {
                        x = 0;
                    }
                    if (x > 100) {
                        x = 100;
                    }
                    dayVolume = x;
                }
            }
            catch (Exception x) {
                // empty catch block
            }
            try {
                if (NIGHT_TIME_VOLUME != null && NIGHT_TIME_VOLUME.length() > 0) {
                    int x = Integer.parseInt(NIGHT_TIME_VOLUME);
                    if (x < 0) {
                        x = 0;
                    }
                    if (x > 100) {
                        x = 100;
                    }
                    nightVolume = x;
                }
            }
            catch (Exception x) {
                // empty catch block
            }
            if ((x = DAY_TIME_SET.indexOf(45)) != -1) {
                String[] ax1;
                String ax = DAY_TIME_SET.substring(0, x).trim();
                String ex = DAY_TIME_SET.substring(x + 1).trim();
                if (ax.equals("00:00:00") || ax.equals("00:00")) {
                    dayBeginHour = 0;
                    dayBeginMins = 0;
                } else {
                    ax1 = ax.split(":");
                    if (ax1.length >= 2) {
                        try {
                            dayBeginHour = Integer.parseInt(ax1[0].trim());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            dayBeginMins = Integer.parseInt(ax1[1].trim());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (ex.equals("00:00:00") || ex.equals("24:00:00") || ex.equals("00:00") || ex.equals("24:00")) {
                    dayEndHour = 23;
                    dayEndMins = 59;
                } else {
                    ax1 = ex.split(":");
                    if (ax1.length >= 2) {
                        try {
                            dayEndHour = Integer.parseInt(ax1[0].trim());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            dayEndMins = Integer.parseInt(ax1[1].trim());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (dayBeginHour < 0) {
                dayBeginHour = 0;
            } else if (dayBeginHour > 23) {
                dayBeginHour = 23;
            }
            if (dayBeginMins < 0) {
                dayBeginMins = 0;
            } else if (dayBeginMins > 59) {
                dayBeginMins = 59;
            }
            if (dayEndHour < 0) {
                dayEndHour = 0;
            } else if (dayEndHour > 23) {
                dayEndHour = 23;
            }
            if (dayEndMins < 0) {
                dayEndMins = 0;
            } else if (dayEndMins > 59) {
                dayEndMins = 59;
            }
            int s = dayBeginHour * 60 + dayBeginMins;
            int e = dayEndHour * 60 + dayEndMins;
            if (s >= e) {
                dayBeginHour = 7;
                dayBeginMins = 0;
                dayEndHour = 19;
                dayEndMins = 0;
            }
            Volume volume = new Volume();
            volume.setDayBeginHour(dayBeginHour);
            volume.setDayBeginMins(dayBeginMins);
            volume.setDayEndHour(dayEndHour);
            volume.setDayEndMins(dayEndMins);
            volume.setDayVolume(dayVolume);
            volume.setNightVolume(nightVolume);
            return volume;
        }
        return this.getLocalConfigVolume();
    }

    @Override
    public Volume getLocalConfigVolume() {
        if (this.localChannelVolumeConfig == null) {
            this.localChannelVolumeConfig = ServiceUtil.getServiceContext().readLocalRuntimeData(null, localChannelVolumeConfigFile, localChannelVolumeConfigFile);
        }
        Volume v = new Volume();
        v.readFromProperties(this.localChannelVolumeConfig);
        return v;
    }

    @Override
    public KeyValueEntry<String, String> setVolume() {
        StringBuilder sbr;
        KeyValueEntry message = new KeyValueEntry();
        List<Equipment> eqList = ServiceUtil.getServiceContext().getEquipmentManager().getEquipmentsByActionClass(LoudspeakerAction.class);
        if (eqList == null || eqList.isEmpty()) {
            message.setValue((Object)"\u6ca1\u6709\u6709\u6548\u7684\u8bed\u97f3\u8bbe\u5907\uff01");
        }
        LinkedList<String> okList = new LinkedList<String>();
        LinkedList<String> faList = new LinkedList<String>();
        LinkedHashSet<String> cyList = new LinkedHashSet<String>();
        LinkedList<KeyValueEntry> opList = new LinkedList<KeyValueEntry>();
        for (Equipment e : eqList) {
            LoudspeakerAction action = (LoudspeakerAction)e.getEquipmentAction();
            opList.add(new KeyValueEntry(action.setVolume(this.getVolume(e)), (Object)e.getName()));
            if (!(action instanceof CYChannelDisplayAction)) continue;
            cyList.add(e.getName());
        }
        for (KeyValueEntry k : opList) {
            try {
                Integer a = (Integer)((OperationFuture)k.getKey()).get(4L, TimeUnit.SECONDS);
                if (a == null || a != 0) {
                    faList.add((String)k.getValue());
                    if (!cyList.contains(k.getValue())) continue;
                    cyList.remove(k.getValue());
                    continue;
                }
                okList.add((String)k.getValue());
            }
            catch (Exception ex) {
                faList.add((String)k.getValue());
            }
        }
        if (!okList.isEmpty()) {
            sbr = new StringBuilder(64);
            for (String s : okList) {
                if (sbr.length() > 0) {
                    sbr.append('\u3001');
                }
                sbr.append(s);
            }
            sbr.append("\u8bbe\u7f6e\u97f3\u91cf\u6210\u529f\uff01");
            if (!cyList.isEmpty()) {
                sbr.append("\u591c\u95f4\u97f3\u91cf1\u5206\u949f\u540e\u751f\u6548\uff01");
            }
            message.setKey((Object)sbr.toString());
        }
        if (!faList.isEmpty()) {
            sbr = new StringBuilder(64);
            for (String s : faList) {
                if (sbr.length() > 0) {
                    sbr.append('\u3001');
                }
                sbr.append(s);
            }
            sbr.append("\u8bbe\u7f6e\u97f3\u91cf\u5931\u8d25!\u539f\u56e0\uff1a\u672a\u8fde\u63a5\u6216\u8d85\u65f6");
            message.setValue((Object)sbr.toString());
        }
        return message;
    }

    @Override
    public void saveLocalConfigVolume(final Volume volume) {
        List<Equipment> eqList;
        if (volume == null) {
            return;
        }
        Volume old = this.getLocalConfigVolume();
        if (!old.equals(volume)) {
            volume.writeToProperties(this.localChannelVolumeConfig);
            ServiceUtil.getServiceContext().storeRuntimeDataToFile(null, localChannelVolumeConfigFile, localChannelVolumeConfigFile, this.localChannelVolumeConfig);
        }
        if ((eqList = ServiceUtil.getServiceContext().getEquipmentManager().getEquipmentsByActionClass(LoudspeakerAction.class)) == null || eqList.isEmpty()) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u64cd\u4f5c\u5931\u8d25\uff01\u6ca1\u6709\u6709\u6548\u7684\u8bed\u97f3\u8bbe\u5907\uff01", 4));
        } else {
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    StringBuilder sbr;
                    LinkedList<String> okList = new LinkedList<String>();
                    LinkedList<String> faList = new LinkedList<String>();
                    LinkedHashSet<String> cyList = new LinkedHashSet<String>();
                    LinkedHashSet<String> cyList1 = new LinkedHashSet<String>();
                    LinkedList<KeyValueEntry> opList = new LinkedList<KeyValueEntry>();
                    for (Equipment e : eqList) {
                        LoudspeakerAction action = (LoudspeakerAction)e.getEquipmentAction();
                        opList.add(new KeyValueEntry(action.setVolume(volume), (Object)e.getName()));
                        if (action instanceof CYChannelDisplayAction) {
                            cyList.add(e.getName());
                            continue;
                        }
                        if (!(action instanceof YKTBoardDisplayAction)) continue;
                        cyList1.add(e.getName());
                    }
                    for (KeyValueEntry k : opList) {
                        try {
                            Integer a = (Integer)((OperationFuture)k.getKey()).get(4L, TimeUnit.SECONDS);
                            if (a == null || a != 0) {
                                faList.add((String)k.getValue());
                                if (!cyList.contains(k.getValue())) continue;
                                cyList.remove(k.getValue());
                                continue;
                            }
                            okList.add((String)k.getValue());
                        }
                        catch (Exception ex) {
                            faList.add((String)k.getValue());
                        }
                    }
                    if (!okList.isEmpty()) {
                        sbr = new StringBuilder(64);
                        for (String s : okList) {
                            if (sbr.length() > 0) {
                                sbr.append('\u3001');
                            }
                            sbr.append(s);
                        }
                        sbr.append("\u8bbe\u7f6e\u97f3\u91cf\u6210\u529f\uff01");
                        if (!cyList.isEmpty()) {
                            sbr.append("\u591c\u95f4\u97f3\u91cf1\u5206\u949f\u540e\u751f\u6548\uff01");
                        }
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, sbr.toString(), 2));
                    }
                    if (!cyList1.isEmpty()) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u4ee5\u4e0b\u8bbe\u5907 " + cyList1 + " \u8f6f\u4ef6\u53ea\u80fd\u63a7\u5236\u9759\u97f3\u4e0e\u4e0d\u9759\u97f3\uff0c\u4e0d\u80fd\u63a7\u5236\u97f3\u91cf\u5927\u5c0f", 1));
                    }
                    if (!faList.isEmpty()) {
                        sbr = new StringBuilder(64);
                        for (String s : faList) {
                            if (sbr.length() > 0) {
                                sbr.append('\u3001');
                            }
                            sbr.append(s);
                        }
                        sbr.append("\u8bbe\u7f6e\u97f3\u91cf\u5931\u8d25!\u539f\u56e0\uff1a\u672a\u8fde\u63a5\u6216\u8d85\u65f6");
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, sbr.toString(), 4));
                    }
                }
            });
        }
    }

    @Override
    public int modifyUserPwd(String userCode, String oldPwd, String newPwd) {
        if (newPwd == null || newPwd.length() == 0) {
            return 1;
        }
        if (userCode == null || userCode.length() == 0) {
            return 2;
        }
        CommonDaoService commonServie = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CarparkUser user = (CarparkUser)commonServie.selectOne(new SearchParam().addEQ("user_code", (Object)userCode).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkUser.class);
        if (user == null) {
            return 2;
        }
        if (oldPwd != null) {
            if (user.getPassword() == null || user.getPassword().length() == 0) {
                return 3;
            }
            String pwd1 = CryptoUtil.MD5Encode((String)oldPwd).toLowerCase();
            if (!pwd1.equals(user.getPassword().toLowerCase())) {
                return 3;
            }
        }
        String updatePwd = CryptoUtil.MD5Encode((String)newPwd).toLowerCase();
        CommonParam updateParam = new CommonParam(commonServie.getTableName(CarparkUser.class));
        updateParam.addUpdate("password", (Object)updatePwd);
        updateParam.addEQ("user_code", (Object)userCode);
        updateParam.addEQ("id", (Object)user.getId());
        int r = commonServie.update(updateParam);
        if (r <= 0) {
            return 4;
        }
        return 0;
    }

    @Override
    public KeyValueEntry<Integer, String> importPresenceRecordFromExcel(String fileName, InputStream xlsin, String opUserCode, String opUserName) throws Exception {
        if (fileName == null || !fileName.endsWith(".xls")) {
            throw new RuntimeException("\u53ea\u80fd\u4e0a\u4f20 .xls \u6587\u4ef6");
        }
        TreeSet<ImportEnterPassVo> dataSet = new TreeSet<ImportEnterPassVo>(new Comparator<ImportEnterPassVo>(){

            @Override
            public int compare(ImportEnterPassVo o1, ImportEnterPassVo o2) {
                int x1 = o1.getPlateNumber().compareTo(o2.getPlateNumber());
                if (x1 == 0 && (x1 = o1.getEnterTime().compareTo(o2.getEnterTime())) == 0) {
                    x1 = o1.getEnterAreaList().get(0).getArea_level().compareTo(o2.getEnterAreaList().get(0).getArea_level());
                }
                return x1;
            }
        });
        try (HSSFWorkbook wb = new HSSFWorkbook(xlsin);){
            Iterator<CarparkCarType> iterator;
            HSSFSheet sheet = wb.getSheetAt(0);
            int h1 = sheet.getLastRowNum();
            if (h1 == 0) {
                throw new Exception("\u5728\u7b2c\u4e00\u4e2aSheet\u4e2d\u6ca1\u6709\u627e\u5230\u6570\u636e!");
            }
            HSSFRow headRow = sheet.getRow(0);
            int headCellNum = headRow.getLastCellNum() & 0xFFFF;
            if (headCellNum == 0) {
                throw new Exception("\u7b2c\u4e00\u884c\u7f3a\u5c11\u6570\u636e\u5c5e\u6027\uff0c\u7b2c\u4e00\u884c\u6240\u6709\u5217\u5fc5\u987b\u662f\u5c5e\u6027\u540d!");
            }
            String[] headNames = new String[]{"\u8f66\u724c\u53f7\u7801", "\u5165\u573a\u65f6\u95f4", "\u5165\u573a\u901a\u9053", "\u8f66\u8f86\u7c7b\u578b"};
            HashMap<Integer, String> headIndexNameMap = new HashMap<Integer, String>();
            HashMap<String, Integer> headNameIndexMap = new HashMap<String, Integer>();
            String[] stringArray = headNames;
            int n = headNames.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                headNameIndexMap.put(s, -1);
                ++n2;
            }
            int j = 0;
            while (j <= headCellNum) {
                Integer oldIndex;
                String v1;
                HSSFCell cell = headRow.getCell(j);
                if (cell != null && (v1 = cell.getStringCellValue()) != null && (v1 = v1.trim()).length() > 0 && (oldIndex = (Integer)headNameIndexMap.get(v1)) != null) {
                    if (oldIndex == -1) {
                        headNameIndexMap.put(v1, j);
                        headIndexNameMap.put(j, v1);
                    } else {
                        KeyValueEntry keyValueEntry = new KeyValueEntry((Object)1, (Object)("\u7b2c\u4e00\u884c,\u7b2c" + (j + 1) + "\u5217\u4e0e\u7b2c" + (oldIndex + 1) + ",\u5217\u540d\u91cd\u590d\uff1a" + v1));
                        return keyValueEntry;
                    }
                }
                ++j;
            }
            int maxCellindex = -1;
            String[] stringArray2 = headNames;
            int oldIndex = headNames.length;
            int v1 = 0;
            while (v1 < oldIndex) {
                String s = stringArray2[v1];
                Integer x = (Integer)headNameIndexMap.get(s);
                if (x == null || x == -1) {
                    KeyValueEntry keyValueEntry = new KeyValueEntry((Object)1, (Object)("\u7b2c\u4e00\u884c\u5c5e\u6027\u540d\u7f3a\u5c11\u5217\u540d\u4e3a\uff1a" + s + "\u7684\u5217"));
                    return keyValueEntry;
                }
                if (x > maxCellindex) {
                    maxCellindex = x;
                }
                ++v1;
            }
            Map<String, CarparkCarType> carTypeMap0 = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
            HashMap<String, CarparkCarType> carTypeMap = new HashMap<String, CarparkCarType>();
            if (carTypeMap0 != null) {
                for (CarparkCarType t : carTypeMap0.values()) {
                    carTypeMap.put(t.getCar_type_name(), t);
                }
            }
            Map<String, CarparkChannel> channelMap0 = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
            HashMap<String, CarparkChannel> channelMap = new HashMap<String, CarparkChannel>();
            if (channelMap0 != null) {
                for (CarparkChannel ch : channelMap0.values()) {
                    channelMap.put(ch.getChannel_name(), ch);
                }
            }
            Map<String, ChannelArea> channelAreaMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas();
            int osFFFF = 65535;
            CarparkCarType defaultCarType = PassChannel.getTimepDynCarType();
            if (defaultCarType == null && (iterator = carTypeMap0.values().iterator()).hasNext()) {
                CarparkCarType t;
                defaultCarType = t = iterator.next();
            }
            if (defaultCarType == null) {
                KeyValueEntry keyValueEntry = new KeyValueEntry((Object)1, (Object)"\u8bf7\u5728\u8f66\u8f86\u7c7b\u578b\u4e2d\u5b9a\u4e49\u81f3\u5c11\u4e00\u4e2a\u8f66\u8f86\u7c7b\u578b\uff01");
                return keyValueEntry;
            }
            int i = 1;
            while (i <= h1) {
                block96: {
                    HSSFRow row = sheet.getRow(i);
                    if (row == null) break block96;
                    int cellNum = row.getLastCellNum() & osFFFF;
                    ImportEnterPassVo vo = new ImportEnterPassVo();
                    int j2 = 0;
                    while (j2 <= cellNum) {
                        block97: {
                            block99: {
                                String carTypeName;
                                HSSFCell cell;
                                String headZhName;
                                block98: {
                                    headZhName = (String)headIndexNameMap.get(j2);
                                    if (headZhName == null) break block97;
                                    cell = row.getCell(j2);
                                    if (!headZhName.equals(headNames[0])) break block98;
                                    String plate = this.getString(cell);
                                    if (plate == null || plate.length() == 0) break block97;
                                    String v2 = plate.toUpperCase();
                                    v2 = v2.replaceAll("'", "");
                                    v2 = v2.replaceAll("\"", "");
                                    v2 = v2.replaceAll("\u3000", "");
                                    v2 = v2.replaceAll(" ", "");
                                    if ((v2 = v2.replaceAll("I", "1")).length() != 7 && v2.length() != 8) {
                                        KeyValueEntry keyValueEntry = new KeyValueEntry((Object)1, (Object)("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j2 + 1) + "\u5217\uff1a" + headZhName + "\uff1a" + v2 + " \u9519\u8bef!"));
                                        return keyValueEntry;
                                    }
                                    vo.setPlateNumber(v2);
                                    break block99;
                                }
                                if (headZhName.equals(headNames[1])) {
                                    Date d1 = this.getDateTime(cell, i, j2, headZhName);
                                    if (d1 != null) {
                                        vo.setEnterTime(d1);
                                    }
                                } else if (headZhName.equals(headNames[2])) {
                                    String channelName = this.getString(cell);
                                    if (channelName != null && channelName.length() > 0) {
                                        CarparkChannel chanel = (CarparkChannel)channelMap.get(channelName);
                                        if (chanel == null) {
                                            KeyValueEntry keyValueEntry = new KeyValueEntry((Object)1, (Object)("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j2 + 1) + "\u5217\uff1a" + headZhName + "\uff1a" + channelName + " \u672a\u5b9a\u4e49\uff0c\u8bf7\u5230\u901a\u9053\u7ba1\u7406\u4e2d\u6dfb\u52a0!"));
                                            return keyValueEntry;
                                        }
                                        ChannelArea chArea = channelAreaMap.get(chanel.getChannel_no());
                                        if (chArea == null) {
                                            KeyValueEntry keyValueEntry = new KeyValueEntry((Object)1, (Object)("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j2 + 1) + "\u5217\uff1a" + headZhName + "\uff1a" + channelName + " \u672a\u5173\u8054\u573a\u533a\uff0c\u8bf7\u5230\u901a\u9053\u7ba1\u7406\u4e2d\u8fdb\u884c\u5904\u7406!"));
                                            return keyValueEntry;
                                        }
                                        List<CarparkArea> clooa = chArea.getEnterAreas();
                                        if (clooa == null || clooa.isEmpty()) {
                                            KeyValueEntry keyValueEntry = new KeyValueEntry((Object)1, (Object)("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j2 + 1) + "\u5217\uff1a" + headZhName + "\uff1a" + channelName + " \u4e0d\u662f\u5165\u573a\u901a\u9053!"));
                                            return keyValueEntry;
                                        }
                                        vo.setEnterChannel(chanel);
                                        vo.setEnterAreaList(clooa);
                                    }
                                } else if (headZhName.equals(headNames[3]) && (carTypeName = this.getString(cell)) != null && carTypeName.length() > 0) {
                                    CarparkCarType c = (CarparkCarType)carTypeMap.get(carTypeName);
                                    if (c == null) {
                                        KeyValueEntry keyValueEntry = new KeyValueEntry((Object)1, (Object)("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j2 + 1) + "\u5217\uff1a" + headZhName + "\uff1a" + carTypeName + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5230\u8f66\u8f86\u7ba1\u7406\u4e2d\u6dfb\u52a0!"));
                                        return keyValueEntry;
                                    }
                                    vo.setCarType(c);
                                }
                            }
                            if (j2 >= maxCellindex) break;
                        }
                        ++j2;
                    }
                    if (vo.getPlateNumber() != null || vo.getEnterChannel() != null || vo.getCarType() != null || vo.getEnterTime() != null) {
                        int j3;
                        if (vo.getPlateNumber() == null) {
                            j3 = (Integer)headNameIndexMap.get(headNames[0]);
                            KeyValueEntry keyValueEntry = new KeyValueEntry((Object)1, (Object)("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j3 + 1) + "\u5217\uff1a\u7f3a\u5c11\u8f66\u724c\u53f7!"));
                            return keyValueEntry;
                        }
                        if (vo.getEnterTime() == null) {
                            j3 = (Integer)headNameIndexMap.get(headNames[1]);
                            KeyValueEntry keyValueEntry = new KeyValueEntry((Object)1, (Object)("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j3 + 1) + "\u5217\uff1a\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5165\u573a\u65f6\u95f4!"));
                            return keyValueEntry;
                        }
                        if (vo.getEnterChannel() == null) {
                            j3 = (Integer)headNameIndexMap.get(headNames[2]);
                            KeyValueEntry keyValueEntry = new KeyValueEntry((Object)1, (Object)("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j3 + 1) + "\u5217\uff1a\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5165\u573a\u901a\u9053\u540d\u79f0!"));
                            return keyValueEntry;
                        }
                        if (vo.getCarType() == null) {
                            vo.setCarType(defaultCarType);
                        }
                        dataSet.add(vo);
                    }
                }
                ++i;
            }
        }
        int hanldeCount = 0;
        int successCount = 0;
        int aboutCount = 0;
        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        if (dataSet != null && !dataSet.isEmpty()) {
            hanldeCount = dataSet.size();
            ApplicationServiceImpl applicationService = this;
            int lanState = SavePassDataFilter.getLanState0();
            Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            Integer project_id = ServiceUtil.getServiceContext().getProjectId();
            Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
            String prtaableName = commonDaoService.getTableName(CarparkPresenceRecord.class);
            RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            HashMap<String, List<CarparkDispatchTask>> dispathListMap = new HashMap<String, List<CarparkDispatchTask>>();
            for (ImportEnterPassVo vo : dataSet) {
                SearchParam s1 = new SearchParam(prtaableName).addEQ("passport_number", (Object)vo.getPlateNumber()).addEQ("medium_type", (Object)6).addGTE("enter_time", (Object)vo.getEnterTime());
                if (vo.getEnterAreaList().size() == 1) {
                    s1.addEQ("area_no", (Object)vo.getEnterAreaList().get(0).getArea_no());
                } else {
                    for (CarparkArea enterArea : vo.getEnterAreaList()) {
                        s1.addIN("area_no", (Object)enterArea.getArea_no());
                    }
                }
                long count = commonDaoService.selectCount(s1);
                if (count > 0L) {
                    ++aboutCount;
                    continue;
                }
                LinkedList<CarparkPassRecord> passRecordList = new LinkedList<CarparkPassRecord>();
                LinkedList<CarparkDispatchTask> dispatchTaskList = new LinkedList<CarparkDispatchTask>();
                CarparkPassport passport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("passport_number", (Object)vo.getPlateNumber()).addEQ("medium_type", (Object)6).setOrerbySql("created_time DESC"), CarparkPassport.class);
                if (passport == null) {
                    passport = PassChannel.createTempDynCarparkPassport(vo.getPlateNumber(), false, null);
                } else {
                    CarparkPassportType passportType = passportTypeMap.get(passport.getPassport_type_no());
                    if (passportType == null) {
                        passport = PassChannel.createTempDynCarparkPassport(vo.getPlateNumber(), false, null);
                    }
                }
                CarparkPassportType passportType = passportTypeMap.get(passport.getPassport_type_no());
                CarparkCarType carType = vo.getCarType();
                passport.setCar_type_no(carType.getCar_type_no());
                CarparkCarOwner carOwner = null;
                if (passport.getCar_owner_no() != null && passport.getCar_owner_no().length() > 0) {
                    carOwner = (CarparkCarOwner)commonDaoService.selectOne(new SearchParam().addEQ("project_id", (Object)ServiceUtil.getServiceContext().getProjectId()).addEQ("car_owner_no", (Object)passport.getCar_owner_no()), CarparkCarOwner.class);
                }
                Date passTime = vo.getEnterTime();
                boolean isNotStart = false;
                boolean isStop = false;
                if (passportType.getPass_type() == 2) {
                    isNotStart = passport.getStart_date() != null && passport.getStart_date().after(passTime);
                    boolean bl = isStop = passport.getPassport_state() == 2 && passport.getStop_date() != null && passport.getStop_date().before(passTime);
                    if (isNotStart || isStop) {
                        passportType = PassChannel.getTempDynPassportType();
                        if (passportType == null) {
                            throw new IllegalStateException("\u65e0\u6cd5\u627e\u5230\u4e34\u65f6\u901a\u884c\u8bc1\u7c7b\u578b");
                        }
                        passport.setPassport_type_no(passportType.getPassport_type_no());
                    }
                }
                boolean isBlackList = false;
                if (passport.getPassport_state() != null && passport.getPassport_state() == 1) {
                    isBlackList = true;
                }
                LinkedHashMap<String, CarparkPresenceRecord> areaPresenceRecordMap = new LinkedHashMap<String, CarparkPresenceRecord>();
                SearchParam preseceRecordParam = new SearchParam().addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).addEQ("medium_type", (Object)passport.getMedium_type());
                preseceRecordParam.addEQ("passport_number", (Object)passport.getPassport_number());
                preseceRecordParam.setOrerbySql("enter_time,area_level");
                LinkedList presenceRecordList = commonDaoService.selectList(preseceRecordParam, CarparkPresenceRecord.class, null);
                if (presenceRecordList == null) {
                    presenceRecordList = new LinkedList();
                }
                if (!presenceRecordList.isEmpty()) {
                    for (CarparkPresenceRecord r : presenceRecordList) {
                        if (r.getEnter_time() == null || r.getExit_time() != null) continue;
                        areaPresenceRecordMap.put(r.getArea_no(), r);
                    }
                }
                if (carOwner != null) {
                    KeyValueEntry<CarparkPassportType, CarparkPassport> newPassport = ServiceUtil.getServiceContext().getMutiSpaceCarAlgorithm().getPassportAndTypeByMutiCar(passport, passportType, 0, vo.getEnterAreaList().get(0), null, null);
                    if (newPassport != null && newPassport.getKey() != null && newPassport.getValue() != null) {
                        passport = (CarparkPassport)newPassport.getValue();
                        passportType = (CarparkPassportType)newPassport.getKey();
                    }
                    if (passport.getSpace_reg_no() == null || passport.getSpace_reg_no().length() == 0) {
                        passport.setSpace_reg_no(passport.getRegister_plate());
                    }
                }
                int pass_state_value = 0;
                if (isBlackList) {
                    pass_state_value = 6;
                } else if (isNotStart) {
                    pass_state_value = 7;
                } else if (isStop) {
                    pass_state_value = 8;
                }
                for (CarparkArea area : vo.getEnterAreaList()) {
                    CarparkPassRecord carparkPassRecord = new CarparkPassRecord();
                    long passRecordId = applicationService.createLocalRecordSeq("ck_carpark_pass_record_seq");
                    carparkPassRecord.setId(passRecordId);
                    carparkPassRecord.setCreated_time(ServiceUtil.getNow());
                    carparkPassRecord.setEnter_record_no("C" + carparkPassRecord.getId().toString());
                    carparkPassRecord.setPassport_no(passport.getPassport_no());
                    carparkPassRecord.setPassport_number(passport.getPassport_number());
                    carparkPassRecord.setMedium_type(passport.getMedium_type());
                    carparkPassRecord.setPass_type(passportType.getPass_type());
                    carparkPassRecord.setPassport_type_no(passportType.getPassport_type_no());
                    carparkPassRecord.setPassport_type_name(passportType.getPassport_type_name());
                    if (carOwner != null) {
                        carparkPassRecord.setCar_owner_no(carOwner.getCar_owner_no());
                        carparkPassRecord.setCar_owner_name(carOwner.getCar_owner_name());
                        carparkPassRecord.setCar_owner_addr(ServiceUtil.getString(carOwner.getAddress(), 100));
                    }
                    carparkPassRecord.setArea_no(area.getArea_no());
                    carparkPassRecord.setParent_area_no(area.getParent_area_no());
                    carparkPassRecord.setArea_level(area.getArea_level());
                    carparkPassRecord.setArea_name(area.getArea_name());
                    carparkPassRecord.setPass_time(passTime);
                    carparkPassRecord.setPass_plate(vo.getPlateNumber());
                    carparkPassRecord.setEnter_passport_type_no(passportType.getPassport_type_no());
                    carparkPassRecord.setEnter_time(passTime);
                    carparkPassRecord.setEnter_channel_no(vo.getEnterChannel().getChannel_no());
                    carparkPassRecord.setEnter_channel_name(vo.getEnterChannel().getChannel_name());
                    carparkPassRecord.setEnter_car_type_no(carType.getCar_type_no());
                    carparkPassRecord.setEnter_car_type_name(carType.getCar_type_name());
                    carparkPassRecord.setEnter_default_car_type_no(carType.getCar_type_no());
                    carparkPassRecord.setEnter_plate(vo.getPlateNumber());
                    carparkPassRecord.setEnter_duty_no("0");
                    carparkPassRecord.setEnter_duty_user_code(opUserCode);
                    carparkPassRecord.setEnter_duty_user_name(opUserName);
                    carparkPassRecord.setEnter_plate_source(1);
                    carparkPassRecord.setEnter_host_no(localHost.getHost_no());
                    carparkPassRecord.setEnter_host_name(localHost.getHost_name());
                    carparkPassRecord.setEnter_lan_state(lanState);
                    if (carparkPassRecord.getPass_type() != null && carparkPassRecord.getPass_type() == 2) {
                        carparkPassRecord.setEnter_valid_date(passport.getDeadline());
                    }
                    if (carparkPassRecord.getPass_type() != null && carparkPassRecord.getPass_type() == 1) {
                        carparkPassRecord.setEnter_balance(passport.getBalance());
                    }
                    carparkPassRecord.setPass_state_value(pass_state_value);
                    int state = 3;
                    carparkPassRecord.setRecord_state(state);
                    carparkPassRecord.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                    carparkPassRecord.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                    carparkPassRecord.setPass_channel_no(carparkPassRecord.getEnter_channel_no());
                    carparkPassRecord.setPass_duty_user_code(carparkPassRecord.getEnter_duty_user_code());
                    carparkPassRecord.setPass_host_no(carparkPassRecord.getEnter_host_no());
                    carparkPassRecord.setPass_car_type_no(carparkPassRecord.getEnter_car_type_no());
                    passRecordList.add(carparkPassRecord);
                }
                String dispathTableN = commonDaoService.getTableName(CarparkPassRecord.class);
                for (CarparkPassRecord carparkPassRecord : passRecordList) {
                    dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(dispathTableN, carparkPassRecord.getId().toString(), "ALL_HOSTS"));
                }
                try (SqlSession sqlSession = commonDaoService.openSqlSession();){
                    try {
                        if (passRecordList != null && !passRecordList.isEmpty()) {
                            for (CarparkPassRecord carparkPassRecord : passRecordList) {
                                commonDaoService.insert(sqlSession, (Object)carparkPassRecord);
                                recordSaveService.handlePresenceRecord(sqlSession, carparkPassRecord);
                                recordSaveService.onAddPassRecord(sqlSession, carparkPassRecord, false);
                            }
                        }
                        if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
                            for (CarparkDispatchTask carparkDispatchTask : dispatchTaskList) {
                                commonDaoService.insert(sqlSession, (Object)carparkDispatchTask);
                            }
                        }
                        sqlSession.commit();
                    }
                    catch (Exception exception) {
                        sqlSession.rollback();
                        throw exception;
                    }
                }
                ++successCount;
                if (dispatchTaskList == null || dispatchTaskList.isEmpty()) continue;
                for (CarparkDispatchTask carparkDispatchTask : dispatchTaskList) {
                    LinkedList<CarparkDispatchTask> lst = (LinkedList<CarparkDispatchTask>)dispathListMap.get(carparkDispatchTask.getHost_no());
                    if (lst == null) {
                        lst = new LinkedList<CarparkDispatchTask>();
                        dispathListMap.put(carparkDispatchTask.getHost_no(), lst);
                    }
                    lst.add(carparkDispatchTask);
                }
            }
            if (dispathListMap != null && !dispathListMap.isEmpty()) {
                this.asynTryRunDispatchTask0(dispathListMap);
            }
        }
        String msg = "\u6210\u529f\u5904\u7406\u5728\u573a\u8f66\u8f86:" + hanldeCount + "\u7b14\u8bb0\u5f55\uff0c\u5176\u4e2d\u6210\u529f\u5bfc\u5165:" + successCount + "\u7b14";
        if (aboutCount > 0) {
            msg = String.valueOf(msg) + "\uff0c\u4e22\u5f03" + aboutCount + "\u7b14\u8bb0\u5f55\uff0c\u4e22\u5f03\u539f\u56e0\uff1a\u6570\u636e\u5e93\u5df2\u5b58\u5728\u76f8\u540c\u8f66\u724c\uff0c\u4e14\u5165\u573a\u65f6\u95f4\u5927\u4e8e\u6216\u7b49\u4e8eexcel\u4e2d\u5165\u573a\u65f6\u95f4";
        }
        if (successCount > 0 && localHost != null && localHost.getHost_use() != null && (localHost.getHost_use() == 2 || localHost.getHost_use() == 3)) {
            CarparkOperationLog opLog = new CarparkOperationLog();
            opLog.setOp_cat(Constants.LOG_OP_CAT_2);
            opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_2_4);
            opLog.setOp_time(ServiceUtil.getNow());
            String text = msg;
            opLog.setOp_des(text);
            opLog.setOp_user_code(opUserCode == null ? "" : opUserCode);
            opLog.setOp_user_name(opUserName == null ? "" : opUserName);
            opLog.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
            opLog.setProject_id(ServiceUtil.getServiceContext().getProjectId());
            opLog.setId(this.createLocalRecordSeq("ck_carpark_operation_log_seq"));
            commonDaoService.insert((Object)opLog);
        }
        return new KeyValueEntry((Object)0, (Object)msg);
    }

    private String getCardNo(HSSFRow row, int columnSize, int cardNoIndex) {
        block9: {
            HSSFCell cell;
            block8: {
                block7: {
                    if (cardNoIndex >= 0 && cardNoIndex <= columnSize) break block7;
                    return null;
                }
                cell = row.getCell(cardNoIndex);
                if (cell != null) break block8;
                return null;
            }
            try {
                String zl = this.getString(cell);
                if (zl == null) {
                    try {
                        double a = cell.getNumericCellValue();
                        return String.valueOf((long)a);
                    }
                    catch (Exception exception) {
                        break block9;
                    }
                }
                return zl;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAllEmpty(HSSFRow row, int columnSize, Set<Integer> set) {
        try {
            int j = 0;
            while (true) {
                String value;
                HSSFCell cell;
                if (j > columnSize) {
                    return true;
                }
                if (set.contains(j) && (cell = row.getCell(j)) != null && (value = this.getString(cell)) != null && value.length() > 0) {
                    return false;
                }
                ++j;
            }
        }
        catch (Exception ex) {
            return false;
        }
    }

    private List<KeyValueEntry<String, String>> getPlates(String plates) {
        LinkedList<KeyValueEntry<String, String>> plateList = new LinkedList<KeyValueEntry<String, String>>();
        if (plates == null || plates.length() == 0) {
            return plateList;
        }
        String v2 = plates.toUpperCase();
        v2 = v2.replace("\u3000", "");
        v2 = v2.replace(" ", "");
        v2 = v2.replace("I", "1");
        v2 = v2.replace("\uff0c", ",");
        v2 = v2.replace("\uff1a", ":");
        v2 = v2.replace("'", "");
        int h1 = (v2 = v2.replace("\"", "")).indexOf(44);
        if (h1 == -1) {
            String passportTypeName;
            String plate;
            int h2 = v2.indexOf(58);
            if (h2 == -1) {
                plate = v2;
                passportTypeName = null;
            } else {
                plate = v2.substring(0, h2).trim();
                passportTypeName = v2.substring(h2 + 1).trim();
            }
            plateList.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)plate, passportTypeName));
        } else {
            String[] ax;
            String[] stringArray = ax = v2.split(",");
            int n = ax.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if ((s = s.trim()).length() > 0) {
                    String passportTypeName;
                    String plate;
                    int h2 = s.indexOf(58);
                    if (h2 == -1) {
                        plate = s;
                        passportTypeName = null;
                    } else {
                        plate = s.substring(0, h2).trim();
                        passportTypeName = s.substring(h2 + 1).trim();
                    }
                    plateList.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)plate, passportTypeName));
                }
                ++n2;
            }
        }
        return plateList;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String importPlateFromExcel(String fileName, InputStream xlsin, String opUserCode, String opUserName) throws Exception {
        if (!fileName.endsWith(".xls")) {
            throw new RuntimeException("\u53ea\u80fd\u4e0a\u4f20 .xls \u6587\u4ef6");
        }
        wb = new HSSFWorkbook(xlsin);
        try {
            now = new Date();
            sheet = wb.getSheetAt(0);
            h1 = sheet.getLastRowNum();
            if (h1 == 0) {
                throw new Exception("\u5728\u7b2c\u4e00\u4e2aSheet\u4e2d\u6ca1\u6709\u627e\u5230\u6570\u636e!");
            }
            headRow = sheet.getRow(0);
            headCellNum = headRow.getLastCellNum() & 65535;
            if (headCellNum == 0) {
                throw new Exception("\u7b2c\u4e00\u884c\u7f3a\u5c11\u6570\u636e\u5c5e\u6027\uff0c\u7b2c\u4e00\u884c\u6240\u6709\u5217\u5fc5\u987b\u662f\u8f66\u724c\u5c5e\u6027!");
            }
            ivalidMap = this.getAllPlateImportHeadMap();
            ivalidMap.put("\u5907\u6ce8\u4fe1\u606f", "remark");
            title_authArea = "\u6388\u6743\u573a\u533a";
            title_authChanel = "\u6388\u6743\u8f66\u9053";
            ivalidMap.put(title_authArea, "auth_areas");
            headMap = new HashMap<Integer, String>();
            cardNoIndex = -1;
            j = 0;
            while (j <= headCellNum) {
                cell = headRow.getCell(j);
                if (cell != null && (v1 = cell.getStringCellValue()) != null && (v1 = v1.trim()).length() > 0) {
                    if (!ivalidMap.containsKey(v1)) {
                        throw new Exception("\u7b2c\u4e00\u884c,\u7b2c" + (j + 1) + "\u5217,\u5217\u540d\uff1a" + v1 + "\u65e0\u6548\uff01\u5408\u6cd5\u7684\u5217\u540d\u79f0\uff1a" + ivalidMap.keySet() + "\uff0c\u5982\u679c\u8be5\u5c5e\u6027\u9700\u8981\uff0c\u60a8\u53ef\u5728\u3010\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86\u8f66\u4e3b\u7ba1\u7406-\u81ea\u5b9a\u4e49\u8f66\u4e3b\u5c5e\u6027\u3011\u4e2d\u6dfb\u52a0");
                    }
                    headMap.put(j, v1);
                    if (cardNoIndex == -1 && "\u5361\u53f7".equals(v1)) {
                        cardNoIndex = j;
                    }
                }
                ++j;
            }
            if (headMap.isEmpty()) {
                throw new Exception("\u7b2c\u4e00\u884c\u7f3a\u5c11\u6570\u636e\u5c5e\u6027\uff0c\u7b2c\u4e00\u884c\u6240\u6709\u5217\u5fc5\u987b\u662f\u5ba2\u6237/\u8f66\u724c\u5c5e\u6027! \u5408\u6cd5\u7684\u6570\u636e\u5c5e\u6027\uff1a\u5408\u6cd5\u7684\u5217\u540d\u79f0\uff1a" + ivalidMap.keySet());
            }
            var20_22 = sn = new String[]{"\u8f66\u724c\u53f7\u7801", "\u8f66\u724c\u7c7b\u578b", "\u8f66\u8f86\u7c7b\u578b", "\u8f66\u4e3b\u7f16\u53f7", "\u8f66\u4e3b\u59d3\u540d"};
            var19_23 = sn.length;
            v1 = 0;
            while (v1 < var19_23) {
                s = var20_22[v1];
                if (!headMap.values().contains(s)) {
                    throw new Exception(String.valueOf(s) + "\u662f\u5fc5\u987b\u7684,\u4f46\u662f\u7b2c\u4e00\u884c\u672a\u627e\u5230\u6b64\u5217");
                }
                ++v1;
            }
            authLanesMap = new HashMap<String, HashSet<E>>();
            passportMap = new HashMap<String, LinkedList<CarparkPassport>>();
            ownerMap = new LinkedHashMap<String, CarparkCarOwner>();
            commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            osFFFF = 65535;
            uMap = new HashMap<String, Integer>();
            cardMap = new HashMap<String, Integer>();
            passportTypeNameCodeMap = new HashMap<String, String>();
            passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            for (CarparkPassportType e : passportTypeMap.values()) {
                passportTypeNameCodeMap.put(e.getPassport_type_name(), e.getPassport_type_no());
            }
            carTypeNameCodeMap = new HashMap<String, String>();
            carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
            for (CarparkCarType t : carTypeMap.values()) {
                carTypeNameCodeMap.put(t.getCar_type_name(), t.getCar_type_no());
            }
            areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
            areaNameNos = new HashMap<String, String>();
            if (areaMap != null && !areaMap.isEmpty()) {
                for (CarparkArea area : areaMap.values()) {
                    areaNameNos.put(area.getArea_name(), area.getArea_no());
                }
            }
            areaChannelMaps = ServiceUtil.getServiceContext().getDBConfigCache().getAreaChannelsMap();
            inValidLineCount = 0;
            maxInValidLineCount = 10;
            totoalLines = 0;
            i = 1;
            while (i <= h1) {
                block170: {
                    row = sheet.getRow(i);
                    if (row == null) break block170;
                    carOwner = new CarparkCarOwner();
                    carOwnerMap = new JavaBeanMap((Object)carOwner);
                    passport = new CarparkPassport();
                    cellNum = row.getLastCellNum() & osFFFF;
                    needDeadLine = false;
                    needBlance = false;
                    isValidLine = true;
                    copyPlateList = null;
                    j = 0;
                    while (j <= cellNum) {
                        block171: {
                            block172: {
                                attrZhcn = (String)headMap.get(j);
                                if (attrZhcn == null) break block171;
                                cell = row.getCell(j);
                                if (!sn[0].equals(attrZhcn)) break block172;
                                plates = this.getString(cell);
                                if (plates != null && plates.length() != 0) ** GOTO lbl123
                                if (cardNoIndex != -1) {
                                    cardNumber = this.getCardNo(row, cellNum, cardNoIndex);
                                    if (cardNumber != null && cardNumber.length() > 0) {
                                        cardNumber = cardNumber.replace("\u3000", "");
                                        cardNumber = cardNumber.replace(" ", "");
                                        cardNumber = cardNumber.replace("'", "");
                                        cardNumber = cardNumber.replace("\"", "");
                                    }
                                    if (cardNumber == null || cardNumber.length() == 0) {
                                        if (this.isAllEmpty(row, cellNum, headMap.keySet())) {
                                            isValidLine = false;
                                            break;
                                        }
                                        throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a\u8f66\u724c\u53f7\u4e0e\u5361\u53f7\u7b2c" + (cardNoIndex + 1) + "\u5217\u81f3\u5c11\u4e00\u9879\u6709\u503c");
                                    }
                                    if (cardMap.containsKey(cardNumber)) {
                                        throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (cardNoIndex + 1) + "\u5217\uff1a\u4e0e\u7b2c" + cardMap.get(cardNumber) + "\u884c\u5361\u53f7\uff1a" + cardNumber + " \u51b2\u7a81!");
                                    }
                                    cardMap.put(cardNumber, i + 1);
                                    count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPassport.class)).addEQ("passport_number", (Object)ServiceUtil.getPassportNumber(cardNumber)));
                                    if (count > 0L) {
                                        throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (cardNoIndex + 1) + "\u5217\uff1a\u5361\u53f7\uff1a" + cardNumber + " \u6570\u636e\u5e93\u4e2d" + ServiceUtil.getPassportNumber(cardNumber) + "\u5df2\u7ecf\u5b58\u5728!");
                                    }
                                    cardNumber = ServiceUtil.getPassportNumber(cardNumber);
                                    passport.setPassport_number(cardNumber);
                                    passport.setMedium_type(1);
                                } else {
                                    if (this.isAllEmpty(row, cellNum, headMap.keySet())) {
                                        isValidLine = false;
                                        break;
                                    }
                                    throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a\u8f66\u724c\u53f7\u7801\u4e3a\u7a7a!");
lbl123:
                                    // 1 sources

                                    plateList = this.getPlates(plates);
                                    if (plateList == null || plateList.isEmpty()) {
                                        throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a\u65e0\u6548\u8f66\u724c\u53f7!");
                                    }
                                    cardNumber = null;
                                    if (cardNoIndex != -1 && (cardNumber = this.getCardNo(row, cellNum, cardNoIndex)) != null && cardNumber.length() > 0) {
                                        cardNumber = cardNumber.replace("\u3000", "");
                                        cardNumber = cardNumber.replace(" ", "");
                                        cardNumber = cardNumber.replace("'", "");
                                        cardNumber = cardNumber.replace("\"", "");
                                    }
                                    if (cardNumber != null && cardNumber.length() > 0) {
                                        if (plateList.size() != 1) {
                                            throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a\u51fa\u73b0\u591a\u4e2a\u8f66\u724c! \u4e00\u5f20\u5361\u6700\u591a\u7ed1\u5b9a\u4e00\u4e2a\u8f66\u724c");
                                        }
                                        if (cardMap.containsKey(cardNumber)) {
                                            throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (cardNoIndex + 1) + "\u5217\uff1a\u4e0e\u7b2c" + cardMap.get(cardNumber) + "\u884c\u5361\u53f7\uff1a" + cardNumber + " \u51b2\u7a81!");
                                        }
                                        cardMap.put(cardNumber, i + 1);
                                        count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPassport.class)).addEQ("passport_number", (Object)ServiceUtil.getPassportNumber(cardNumber)));
                                        if (count > 0L) {
                                            throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (cardNoIndex + 1) + "\u5217\uff1a\u5361\u53f7\uff1a" + cardNumber + " \u6570\u636e\u5e93\u4e2d" + ServiceUtil.getPassportNumber(cardNumber) + "\u5df2\u7ecf\u5b58\u5728!");
                                        }
                                    }
                                    defaultPlateEntry = null;
                                    for (KeyValueEntry<String, String> entry : plateList) {
                                        if (((String)entry.getKey()).length() < 7 || ((String)entry.getKey()).length() > 8) {
                                            throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a\u8f66\u724c\u53f7\u7801\uff1a" + (String)entry.getKey() + " \u9519\u8bef!");
                                        }
                                        if (uMap.containsKey(entry.getKey())) {
                                            throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a\u4e0e\u7b2c" + uMap.get(entry.getKey()) + "\u884c\u8f66\u724c\u53f7\u7801\uff1a" + (String)entry.getKey() + " \u51b2\u7a81!");
                                        }
                                        count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPassport.class)).addEQ("register_plate", entry.getKey()));
                                        if (count > 0L) {
                                            throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a\u8f66\u724c\u53f7\u7801\uff1a" + (String)entry.getKey() + " \u6570\u636e\u5e93\u4e2d\u5df2\u7ecf\u5b58\u5728!");
                                        }
                                        if (entry.getValue() == null) {
                                            if (defaultPlateEntry == null) {
                                                defaultPlateEntry = entry;
                                            }
                                        } else {
                                            if (((String)entry.getValue()).length() == 0) {
                                                throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a\u8f66\u724c\u53f7\u7801\uff1a" + (String)entry.getKey() + " \u7684\u8f66\u8f86\u7c7b\u578b\u540d\u79f0\u5b9a\u4e49\u9519\u8bef! \u6b63\u786e\u8bed\u6cd5 \u8f66\u724c\u53f7, \u8f66\u724c\u53f7:{\u5b50\u6bcd\u8f66\u8f66\u724c\u7c7b\u578b\u540d}, \u8f66\u724c\u53f7:{\u5b50\u6bcd\u8f66\u8f66\u724c\u7c7b\u578b\u540d}");
                                            }
                                            if (!passportTypeNameCodeMap.containsKey(entry.getValue())) {
                                                throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a\u8f66\u724c\u53f7\u7801:" + (String)entry.getKey() + " \u5bf9\u5e94\u7684\u8f66\u724c\u7c7b\u578b\u4e0d\u5b58\u5728\uff01\u5408\u6cd5\u503c\u4e3a\uff1a" + passportTypeNameCodeMap.keySet() + "\uff0c\u5f53\u7136\u60a8\u53ef\u4ee5\u5728\u3010\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8f66\u724c/\u5361\u7c7b\u578b\u8bbe\u7f6e\u4e2d\u6dfb\u52a0\u6b64\u8f66\u724c\u7c7b\u578b\u3011");
                                            }
                                            passportType = passportTypeMap.get(passportTypeNameCodeMap.get(entry.getValue()));
                                            if (passportType.getPass_type() == 0 && passportType.getUse_muti_car() == 1) {
                                                entry.setValue((Object)passportType.getPassport_type_no());
                                            } else {
                                                throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a\u8f66\u724c\u53f7\u7801\uff1a" + (String)entry.getKey() + " \u7684\u8f66\u8f86\u7c7b\u578b\u540d\u79f0\u5b9a\u4e49\u9519\u8bef! \u53ea\u5141\u8bb8\u5b50\u6bcd\u8f66\u7c7b\u578b");
                                            }
                                        }
                                        uMap.put((String)entry.getKey(), i + 1);
                                    }
                                    if (defaultPlateEntry == null) {
                                        throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a\u8f66\u724c\u53f7\u7801\u9519\u8bef, \u81f3\u5c11\u8f93\u5165\u4e00\u4e2a\u4e0d\u5e26\u8f66\u724c\u7c7b\u578b\u7684\u8f66\u724c");
                                    }
                                    if (cardNumber == null || cardNumber.length() == 0) {
                                        passport.setPassport_number((String)defaultPlateEntry.getKey());
                                        passport.setMedium_type(6);
                                    } else {
                                        cardNumber = ServiceUtil.getPassportNumber(cardNumber);
                                        passport.setPassport_number(cardNumber);
                                        passport.setMedium_type(1);
                                    }
                                    passport.setRegister_plate((String)defaultPlateEntry.getKey());
                                    plateList.remove(defaultPlateEntry);
                                    copyPlateList = plateList;
                                }
                                break block171;
                            }
                            if (j != cardNoIndex) {
                                if (sn[1].equals(attrZhcn)) {
                                    passportTypeName = this.getString(cell);
                                    if (passportTypeName == null || (passportTypeName = passportTypeName.trim()).length() == 0) {
                                        if (this.isAllEmpty(row, cellNum, headMap.keySet())) {
                                            isValidLine = false;
                                            break;
                                        }
                                        throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a" + attrZhcn + "\u4e3a\u7a7a!");
                                    }
                                    if (!passportTypeNameCodeMap.containsKey(passportTypeName)) {
                                        throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a\u5c5e\u6027" + attrZhcn + "\u503c:" + passportTypeName + "\u4e0d\u5b58\u5728\uff01\u5408\u6cd5\u503c\u4e3a\uff1a" + passportTypeNameCodeMap.keySet() + "\uff0c\u5f53\u7136\u60a8\u53ef\u4ee5\u5728\u3010\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8f66\u724c/\u5361\u7c7b\u578b\u8bbe\u7f6e\u4e2d\u6dfb\u52a0\u6b64\u8f66\u724c\u7c7b\u578b\u3011");
                                    }
                                    passportType = passportTypeMap.get(passportTypeNameCodeMap.get(passportTypeName));
                                    if (passportType.getPass_type() == 2) {
                                        needDeadLine = true;
                                    } else if (passportType.getPass_type() == 1) {
                                        needBlance = true;
                                    }
                                    passport.setPassport_type_no(passportType.getPassport_type_no());
                                } else if (sn[2].equals(attrZhcn)) {
                                    carTypeName = this.getString(cell);
                                    if (carTypeName == null || (carTypeName = carTypeName.trim()).length() == 0) {
                                        if (this.isAllEmpty(row, cellNum, headMap.keySet())) {
                                            isValidLine = false;
                                            break;
                                        }
                                        throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a" + attrZhcn + "\u4e3a\u7a7a!");
                                    }
                                    if (!carTypeNameCodeMap.containsKey(carTypeName)) {
                                        throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a\u5c5e\u6027" + attrZhcn + "\u503c:" + carTypeName + "\u4e0d\u5b58\u5728\uff01\u5408\u6cd5\u503c\u4e3a\uff1a" + carTypeNameCodeMap.keySet() + "\uff0c\u5f53\u7136\u60a8\u53ef\u4ee5\u5728\u3010\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8f66\u8f86\u7c7b\u578b\u8bbe\u7f6e\u4e2d\u6dfb\u52a0\u6b64\u8f66\u8f86\u7c7b\u578b\u3011");
                                    }
                                    passport.setCar_type_no((String)carTypeNameCodeMap.get(carTypeName));
                                } else if ("\u505c\u8f66\u4f4d\u53f7".equals(attrZhcn)) {
                                    parking_space_no = this.getString(cell);
                                    if (parking_space_no == null) {
                                        try {
                                            vc = this.getLong(cell, i, j, attrZhcn);
                                            if (vc != null && vc > 0L) {
                                                parking_space_no = vc.toString();
                                            }
                                        }
                                        catch (Exception vc) {
                                            // empty catch block
                                        }
                                    }
                                    passport.setParking_space_no(parking_space_no);
                                } else if ("\u884c\u9a76\u8bc1\u53f7".equals(attrZhcn)) {
                                    vehicle_number = this.getString(cell);
                                    if (vehicle_number == null) {
                                        try {
                                            vc = this.getLong(cell, i, j, attrZhcn);
                                            if (vc != null && vc > 0L) {
                                                vehicle_number = vc.toString();
                                            }
                                        }
                                        catch (Exception vc) {
                                            // empty catch block
                                        }
                                    }
                                    passport.setVehicle_number(ServiceUtil.getString(vehicle_number, 45));
                                } else if ("\u6709\u6548\u671f".equals(attrZhcn)) {
                                    d1 = this.getDate(cell, i, j, attrZhcn);
                                    if (d1 != null) {
                                        cl = Calendar.getInstance();
                                        cl.setTime(d1);
                                        cl.set(11, 23);
                                        cl.set(12, 59);
                                        cl.set(13, 59);
                                        cl.set(14, 999);
                                        passport.setDeadline(cl.getTime());
                                    }
                                } else if ("\u5f00\u59cb\u65e5\u671f".equals(attrZhcn)) {
                                    d1 = this.getDate(cell, i, j, attrZhcn);
                                    if (d1 != null) {
                                        cl = Calendar.getInstance();
                                        cl.setTime(d1);
                                        cl.set(11, 0);
                                        cl.set(12, 0);
                                        cl.set(13, 0);
                                        cl.set(14, 0);
                                        passport.setStart_date(cl.getTime());
                                    }
                                } else if ("\u4f59\u989d".equals(attrZhcn) || "\u8f66\u8f86\u8d26\u6237\u4f59\u989d".equals(attrZhcn)) {
                                    d = this.getDouble(cell, i, j, attrZhcn);
                                    if (d != null) {
                                        passport.setBalance(new BigDecimal(d));
                                    }
                                } else if (title_authArea.equals(attrZhcn)) {
                                    if (passport.getPassport_number() != null && passport.getPassport_number().length() > 0 && (areas = this.getString(cell)) != null && areas.length() > 0) {
                                        areaNames = areas.split(",");
                                        passChannels = null;
                                        count = areaNames;
                                        var52_96 = areaNames.length;
                                        entry = 0;
                                        while (entry < var52_96) {
                                            areaName = count[entry];
                                            if ((areaName = areaName.trim()) != null && areaName.length() > 0) {
                                                areaNo = (String)areaNameNos.get(areaName);
                                                if (areaNo == null || areaNo.length() == 0) {
                                                    throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a\u5c5e\u6027" + attrZhcn + "\u503c:" + areaName + "\u4e0d\u5b58\u5728\uff01\u8be5\u6388\u6743\u573a\u533a\u4e0d\u5b58\u5728, \u60a8\u53ef\u4ee5\u5728\u533a\u57df\u7ba1\u7406\u6dfb\u52a0\u4e00\u4e2a");
                                                }
                                                channels = areaChannelMaps.get(areaNo);
                                                if (channels != null && !channels.isEmpty()) {
                                                    if (passChannels == null) {
                                                        passChannels = new HashSet<String>();
                                                    }
                                                    for (String s : channels) {
                                                        passChannels.add(s);
                                                    }
                                                }
                                            }
                                            ++entry;
                                        }
                                        if (passChannels != null && !passChannels.isEmpty()) {
                                            authLanesMap.put(passport.getPassport_number(), passChannels);
                                        }
                                    }
                                } else if (!title_authChanel.equals(attrZhcn)) {
                                    if (sn[3].equals(attrZhcn)) {
                                        zl = this.getString(cell);
                                        if (zl == null) {
                                            try {
                                                jh = cell.getNumericCellValue();
                                                jh1 = (int)jh;
                                                zl = jh == (double)jh1 ? String.valueOf(jh1) : String.valueOf(jh);
                                            }
                                            catch (Exception jh) {
                                                // empty catch block
                                            }
                                        }
                                        if (zl == null || (zl = zl.trim()).length() == 0) {
                                            throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a" + attrZhcn + "\u4e3a\u7a7a!");
                                        }
                                        carOwner.setCar_owner_no(zl);
                                        count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkCarOwner.class)).addEQ("car_owner_no", (Object)zl));
                                        if (count > 0L) {
                                            throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a" + attrZhcn + "\uff1a" + zl + " \u6570\u636e\u5e93\u4e2d\u5df2\u7ecf\u5b58\u5728!");
                                        }
                                    } else if (sn[4].equals(attrZhcn)) {
                                        zl = this.getString(cell);
                                        if (zl == null || (zl = zl.trim()).length() == 0) {
                                            throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a" + attrZhcn + "\u4e3a\u7a7a!");
                                        }
                                        carOwner.setCar_owner_name(ServiceUtil.getString(zl, 45));
                                    } else if ("\u8eab\u4efd\u8bc1\u53f7".equals(attrZhcn)) {
                                        zl = this.getString(cell);
                                        if (zl != null && (zl = zl.trim()).length() > 0) {
                                            if (!ValidateUtil.isIDCard(zl)) {
                                                throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a" + attrZhcn + ":" + zl + " \u9519\u8bef\u7684\u8eab\u4efd\u8bc1\u53f7!");
                                            }
                                            carOwner.setId_number(zl);
                                        }
                                    } else if ("\u624b\u673a\u53f7\u7801".equals(attrZhcn)) {
                                        zl = this.getString(cell);
                                        if (zl == null && (al = this.getLong(cell, i, i, attrZhcn)) != null && al > 0L) {
                                            zl = al.toString();
                                        }
                                        if (zl != null && (zl = zl.trim()).length() > 0) {
                                            carOwner.setPhone_number(zl);
                                        }
                                    } else if ("\u9a7e\u9a76\u8bc1\u53f7".equals(attrZhcn)) {
                                        zl = this.getString(cell);
                                        if (zl == null) {
                                            try {
                                                al = this.getLong(cell, i, i, attrZhcn);
                                                if (al != null && al > 0L) {
                                                    zl = al.toString();
                                                }
                                            }
                                            catch (Exception al) {
                                                // empty catch block
                                            }
                                        }
                                        if (zl != null && (zl = zl.trim()).length() > 0) {
                                            carOwner.setDriver_number(zl);
                                        }
                                    } else if ("\u7535\u5b50\u90ae\u7bb1".equals(attrZhcn)) {
                                        zl = this.getString(cell);
                                        if (zl != null && (zl = zl.trim()).length() > 0) {
                                            if (!ValidateUtil.isEmail(zl)) {
                                                throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a" + attrZhcn + ":" + zl + " \u9519\u8bef\u7684\u90ae\u7bb1\u53f7!");
                                            }
                                            carOwner.setEmail(zl);
                                        }
                                    } else if ("\u8f66\u4e3b\u6027\u522b".equals(attrZhcn)) {
                                        zl = this.getString(cell);
                                        if (zl != null && (zl = zl.trim()).length() > 0) {
                                            if (!"\u7537".equals(zl) && !"\u5973".equals(zl)) {
                                                throw new Exception("\u7b2c" + (i + 1) + "\u884c, \u7b2c" + (j + 1) + "\u5217\uff1a" + attrZhcn + ":" + zl + " \u6027\u522b\u53ea\u80fd\u662f\u7537\u6216\u8005\u5973!");
                                            }
                                            if ("\u7537".equals(zl)) {
                                                carOwner.setSex(0);
                                            } else {
                                                carOwner.setSex(1);
                                            }
                                        } else {
                                            carOwner.setSex(0);
                                        }
                                    } else if ("\u5907\u6ce8\u4fe1\u606f".equals(attrZhcn)) {
                                        zl = this.getString(cell);
                                        if (zl != null && (zl = zl.trim()).length() > 0) {
                                            carOwner.setRemark(ServiceUtil.getString(zl, 200));
                                        } else {
                                            carOwner.setRemark("");
                                        }
                                    } else if ("\u8f66\u4e3b\u8d26\u6237\u4f59\u989d".equals(attrZhcn)) {
                                        d = this.getDouble(cell, i, j, attrZhcn);
                                        if (d != null) {
                                            carOwner.setAccount_balance(new BigDecimal(d));
                                        }
                                    } else {
                                        zl = this.getString(cell);
                                        if (zl != null && (zl = zl.trim()).length() > 0) {
                                            key = ivalidMap.get(attrZhcn);
                                            carOwnerMap.put(key, (Object)zl);
                                        }
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                    if (!isValidLine) {
                        if (++inValidLineCount >= maxInValidLineCount) break;
                    } else {
                        if (inValidLineCount != 0) {
                            inValidLineCount = 0;
                        }
                        if (needDeadLine && passport.getDeadline() == null) {
                            throw new Exception("\u7b2c" + (i + 1) + "\u884c\uff1a\u8f66\u724c\u7c7b\u578b\u4e3a\u6708\u5361\u7c7b\u578b\uff0c\u4f46\u662f\u7f3a\u5c11\u6709\u6548\u671f\u6570\u636e\uff01");
                        }
                        if (needBlance) {
                            passportType = passportTypeMap.get(passport.getPassport_type_no());
                            if ("1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CAR_OWNER_ACCOUNT_BALANCE")) && "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "STOREAGE_DECUNT_AOUHNT"))) {
                                if (carOwner.getAccount_balance() == null) {
                                    throw new Exception("\u7b2c" + (i + 1) + "\u884c,\u8f66\u724c\u7c7b\u578b\u4e3a\u50a8\u503c\u8f66\u7c7b\u578b\uff0c\u8be5\u8f66\u724c\u7684\u6263\u6b3e\u8d26\u6237\u4e3a\u8f66\u4e3b\u8d26\u6237\uff0c \u4f46\u662f\u7f3a\u5c11\u6709\u4f59\u989d\u6570\u636e\uff01 \u5bf9\u5e94\u7684\u8868\u5934\u4e3a: \u8f66\u4e3b\u8d26\u6237\u4f59\u989d");
                                }
                            } else if (passport.getBalance() == null) {
                                throw new Exception("\u7b2c" + (i + 1) + "\u884c,\u8f66\u724c\u7c7b\u578b\u4e3a\u50a8\u503c\u8f66\u7c7b\u578b\uff0c\u8be5\u8f66\u724c\u7684\u6263\u6b3e\u8d26\u6237\u4e3a\u8f66\u8f86\u8d26\u6237\uff0c \u4f46\u662f\u7f3a\u5c11\u6709\u4f59\u989d\u6570\u636e\uff01 \u5bf9\u5e94\u7684\u8868\u5934\u4e3a: \u8f66\u8f86\u8d26\u6237\u4f59\u989d\uff0c\u6216\u4f59\u989d");
                            }
                        }
                        if ((list = (LinkedList<CarparkPassport>)passportMap.get(carOwner.getCar_owner_no())) == null) {
                            list = new LinkedList<CarparkPassport>();
                            passportMap.put(carOwner.getCar_owner_no(), list);
                        }
                        list.add(passport);
                        ownerMap.put(carOwner.getCar_owner_no(), carOwner);
                        passport.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                        passport.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                        carOwner.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                        carOwner.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                        carOwner.setLast_updated_time(now);
                        carOwner.setCreated_time(now);
                        if (passport.getStart_date() == null) {
                            cl = Calendar.getInstance();
                            cl.set(11, 0);
                            cl.set(12, 0);
                            cl.set(13, 0);
                            cl.set(14, 0);
                            passport.setStart_date(cl.getTime());
                        }
                        passport.setCreated_time(now);
                        passport.setLast_updated_time(now);
                        passport.setReg_time(now);
                        if (passport.getMedium_type() == null) {
                            passport.setMedium_type(6);
                        }
                        passport.setCar_owner_no(carOwner.getCar_owner_no());
                        passport.setReg_source(1);
                        passport.setRemain_hours(0);
                        passport.setForbid_online_pay(0);
                        passport.setCash_pledge(Constants.MONEY_ZERO);
                        passport.setPassport_state(0);
                        if (copyPlateList != null && !copyPlateList.isEmpty() && passport.getMedium_type() == 6) {
                            for (KeyValueEntry<String, String> entry : copyPlateList) {
                                if (((String)entry.getKey()).equals(passport.getRegister_plate())) continue;
                                passport0 = passport.clone();
                                passport0.setPassport_number((String)entry.getKey());
                                passport0.setRegister_plate((String)entry.getKey());
                                if (entry.getValue() != null && ((String)entry.getValue()).length() > 0) {
                                    passportType = passportTypeMap.get(entry.getValue());
                                    passport0.setPassport_type_no(passportType.getPassport_type_no());
                                    passport0.setDeadline(null);
                                    passport0.setBalance(Constants.MONEY_ZERO);
                                }
                                list.add(passport0);
                            }
                        }
                        ++totoalLines;
                    }
                }
                ++i;
            }
            finishCount = 0;
            errCount = 0;
            sbr = new StringBuilder();
            authBeginTime = null;
            authEndTime = null;
            for (Map.Entry<K, V> en : passportMap.entrySet()) {
                session = commonDaoService.openSqlSession();
                try {
                    try {
                        c = (CarparkCarOwner)ownerMap.get(en.getKey());
                        c.setId(commonDaoService.getSequece("ck_common_seq"));
                        c.setCar_owner_no("C" + c.getId());
                        try {
                            commonDaoService.insert(session, (Object)c);
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().error((Object)("\u9519\u8bef\u5bfc\u5165\u8f66\u4e3b\u6570\u636e: " + GsonBuilder.create().toJson((Object)c)));
                            ServiceLog.getLog().error((Object)ex.getMessage(), (Throwable)ex);
                            if (sbr.length() > 0) {
                                sbr.append("<br>");
                            }
                            sbr.append("\u8f66\u4e3b\uff1a" + c.getCar_owner_no() + ": " + c.getCar_owner_name() + " \u6570\u636e\u5f02\u5e38! ");
                            throw ex;
                        }
                        for (CarparkPassport p : (List)en.getValue()) {
                            p.setId(commonDaoService.getSequece("ck_common_seq"));
                            p.setPassport_no("C" + p.getId());
                            p.setCar_owner_no(c.getCar_owner_no());
                            try {
                                commonDaoService.insert(session, (Object)p);
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().error((Object)("\u9519\u8bef\u5bfc\u5165\u8f66\u724c\u6570\u636e: " + GsonBuilder.create().toJson((Object)p)));
                                ServiceLog.getLog().error((Object)ex.getMessage(), (Throwable)ex);
                                if (sbr.length() > 0) {
                                    sbr.append("<br>");
                                }
                                sbr.append("\u8f66\u724c\u53f7\uff1a" + p.getRegister_plate() + " \u6570\u636e\u5f02\u5e38: " + ex.getMessage());
                                throw ex;
                            }
                            authLanesNos = (Set)authLanesMap.get(p.getPassport_number());
                            if (authLanesNos == null || authLanesNos.isEmpty()) continue;
                            pList = commonDaoService.selectList(new SearchParam().addEQ("auth_type_no", (Object)p.getPassport_number()).addEQ("auth_type", (Object)2).addEQ("carpark_id", (Object)p.getCarpark_id()), CarparkPassPermission.class, null);
                            if (pList != null && !pList.isEmpty()) {
                                for (CarparkPassPermission pxx : pList) {
                                    p1 = new SearchParam(commonDaoService.getTableName(CarparkPassPermission.class)).addEQ("pass_permission_no", (Object)pxx.getPass_permission_no()).addEQ("carpark_id", (Object)p.getCarpark_id());
                                    p2 = new SearchParam(commonDaoService.getTableName(CarparkPassPermissionChannel.class)).addEQ("pass_permission_no", (Object)pxx.getPass_permission_no()).addEQ("carpark_id", (Object)p.getCarpark_id());
                                    p3 = new SearchParam(commonDaoService.getTableName(CarparkDateRange.class)).addEQ("ref_no", (Object)pxx.getPass_permission_no()).addEQ("ref_type", (Object)0).addEQ("carpark_id", (Object)p.getCarpark_id());
                                    commonDaoService.delete(session, p1);
                                    commonDaoService.delete(session, p2);
                                    commonDaoService.delete(session, p3);
                                }
                            }
                            p5 = new CarparkPassPermission();
                            p5.setId(commonDaoService.getSequece("ck_common_seq"));
                            p5.setAuth_type(2);
                            p5.setAuth_type_no(p.getPassport_number());
                            p5.setAuth_value(1);
                            p5.setCreated_time(now);
                            p5.setDate_range_type(1);
                            p5.setDate_range_value("");
                            p5.setLast_updated_time(now);
                            p5.setPass_permission_no("C" + p5.getId());
                            p5.setCarpark_id(p.getCarpark_id());
                            p5.setProject_id(p.getProject_id());
                            commonDaoService.insert(session, (Object)p5);
                            for (String laneNo : authLanesNos) {
                                c8 = new CarparkPassPermissionChannel();
                                c8.setId(commonDaoService.getSequece("ck_common_seq"));
                                c8.setChannel_no(laneNo);
                                c8.setPass_permission_no(p5.getPass_permission_no());
                                c8.setLast_updated_time(now);
                                c8.setCarpark_id(p5.getCarpark_id());
                                c8.setProject_id(p5.getProject_id());
                                commonDaoService.insert(session, (Object)c8);
                            }
                            r = new CarparkDateRange();
                            r.setId(commonDaoService.getSequece("ck_common_seq"));
                            r.setDate_range_no("C" + r.getId());
                            r.setLast_updated_time(now);
                            r.setCarpark_id(p5.getCarpark_id());
                            r.setCreated_time(now);
                            r.setProject_id(p5.getProject_id());
                            r.setRef_no(p5.getPass_permission_no());
                            r.setRef_type(0);
                            if (authBeginTime == null || authEndTime == null) {
                                authBeginTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse("2000-01-01 00:00:00");
                                authEndTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse("2000-01-01 23:59:59");
                            }
                            r.setRange_begin(authBeginTime);
                            r.setRange_end(authEndTime);
                            commonDaoService.insert(session, (Object)r);
                        }
                        session.commit();
                        finishCount += ((List)en.getValue()).size();
                    }
                    catch (Exception ex) {
                        session.rollback();
                        errCount += ((List)en.getValue()).size();
                        session.close();
                        continue;
                    }
                }
                catch (Throwable var58_104) {
                    session.close();
                    throw var58_104;
                }
                session.close();
            }
            msg = "\u64cd\u4f5c\u5b8c\u6210\uff01\u5df2\u6210\u529f\u5bfc\u5165 " + finishCount + " \u7b14\u8f66\u724c\u8bb0\u5f55\uff01\u6709\u6548Excel\u8bb0\u5f55\u884c\u6570\uff1a" + totoalLines;
            if (sbr.length() > 0) {
                msg = String.valueOf(msg) + "<br>\u5931\u8d25\u8bb0\u5f55\u6570: " + errCount + "<div style='color:red;font-size:12px;'>" + sbr.toString() + "</div>";
            }
            var60_105 = msg;
            return var60_105;
        }
        finally {
            wb.close();
        }
    }

    private Map<String, String> getAllPlateImportHeadMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("\u8f66\u724c\u53f7\u7801", "passport_number");
        map.put("\u5361\u53f7", "card_number");
        map.put("\u8f66\u724c\u7c7b\u578b", "passport_type_name");
        map.put("\u8f66\u8f86\u7c7b\u578b", "car_type_name");
        map.put("\u5f00\u59cb\u65e5\u671f", "start_date");
        map.put("\u6709\u6548\u671f", "deadline");
        map.put("\u8f66\u8f86\u8d26\u6237\u4f59\u989d", "balance");
        map.put("\u505c\u8f66\u4f4d\u53f7", "parking_space_no");
        map.put("\u884c\u9a76\u8bc1\u53f7", "vehicle_number");
        map.put("\u8f66\u4e3b\u7f16\u53f7", "car_owner_no");
        map.put("\u8f66\u4e3b\u59d3\u540d", "car_owner_name");
        map.put("\u8f66\u4e3b\u8d26\u6237\u4f59\u989d", "account_balance");
        map.put("\u8eab\u4efd\u8bc1\u53f7", "id_number");
        map.put("\u9a7e\u9a76\u8bc1\u53f7", "driver_number");
        map.put("\u8f66\u4e3b\u4f4f\u5740", "address");
        map.put("\u624b\u673a\u53f7\u7801", "phone_number");
        map.put("\u7535\u5b50\u90ae\u7bb1", "email");
        map.put("\u8f66\u4e3b\u6027\u522b", "sex");
        Map<String, CarparkAttribute> carOwnerAttrMap = ServiceUtil.getServiceContext().getDBConfigCache().getAttributeTypeMap().get(8);
        if (carOwnerAttrMap != null && !carOwnerAttrMap.isEmpty()) {
            for (CarparkAttribute t : carOwnerAttrMap.values()) {
                map.put(t.getAttribute_value(), t.getAttribute_key());
            }
        }
        return map;
    }

    private String getString(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        try {
            String v1 = cell.getStringCellValue();
            if (v1 != null && (v1 = v1.trim()).length() > 0) {
                return v1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Double getDouble(HSSFCell cell, int x, int y, String name) {
        block10: {
            if (cell == null) {
                return null;
            }
            try {
                String v1 = cell.getStringCellValue();
                if (v1 != null && (v1 = v1.trim()).length() > 0) {
                    try {
                        Double h = Double.valueOf(v1);
                        return h;
                    }
                    catch (NumberFormatException ex) {
                        throw new NumberFormatException("\u7b2c" + (x + 1) + "\u884c,\u7b2c" + (y + 1) + "\u5217\u3010" + name + "\u3011\u4e0d\u662f\u6570\u5b57!");
                    }
                }
                try {
                    double a = cell.getNumericCellValue();
                    return a;
                }
                catch (Exception a) {
                }
            }
            catch (Exception ex) {
                try {
                    double a = cell.getNumericCellValue();
                    return a;
                }
                catch (Exception ex1) {
                    if (!(ex instanceof NumberFormatException)) break block10;
                    throw (NumberFormatException)ex;
                }
            }
        }
        return null;
    }

    private Long getLong(HSSFCell cell, int x, int y, String name) {
        block10: {
            if (cell == null) {
                return null;
            }
            try {
                String v1 = cell.getStringCellValue();
                if (v1 != null && (v1 = v1.trim()).length() > 0) {
                    try {
                        Long h = Long.valueOf(v1);
                        return h;
                    }
                    catch (NumberFormatException ex) {
                        throw new NumberFormatException("\u7b2c" + (x + 1) + "\u884c,\u7b2c" + (y + 1) + "\u5217\u3010" + name + "\u3011\u4e0d\u662f\u6570\u5b57!");
                    }
                }
                try {
                    double a = cell.getNumericCellValue();
                    return (long)a;
                }
                catch (Exception a) {
                }
            }
            catch (Exception ex) {
                try {
                    double a = cell.getNumericCellValue();
                    return (long)a;
                }
                catch (Exception ex1) {
                    if (!(ex instanceof NumberFormatException)) break block10;
                    throw (NumberFormatException)ex;
                }
            }
        }
        return null;
    }

    private Date getDateTime(HSSFCell cell, int x, int y, String name) {
        block26: {
            if (cell == null) {
                return null;
            }
            try {
                Date d1 = cell.getDateCellValue();
                if (d1 == null) {
                    try {
                        String v1 = cell.getStringCellValue();
                        if (v1 != null && (v1 = v1.trim()).length() > 0) {
                            if (v1.indexOf(45) != -1) {
                                try {
                                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                    return df.parse(v1);
                                }
                                catch (Exception ex2) {
                                    throw new RuntimeException("\u7b2c" + (x + 1) + "\u884c,\u7b2c" + (y + 1) + "\u5217\u3010" + name + "\u3011\u65f6\u95f4\u683c\u5f0f\u5e94\u8be5\u4e3a \u5e74-\u6708-\u65e5 \u65f6:\u5206:\u79d2 !");
                                }
                            }
                            if (v1.indexOf(47) != -1) {
                                try {
                                    SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                                    return df.parse(v1);
                                }
                                catch (Exception ex2) {
                                    throw new RuntimeException("\u7b2c" + (x + 1) + "\u884c,\u7b2c" + (y + 1) + "\u5217\u3010" + name + "\u3011\u65f6\u95f4\u683c\u5f0f\u5e94\u8be5\u4e3a \u5e74/\u6708/\u65e5 \u65f6:\u5206:\u79d2 !");
                                }
                            }
                            try {
                                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                return df.parse(v1);
                            }
                            catch (Exception ex2) {
                                throw new RuntimeException("\u7b2c" + (x + 1) + "\u884c,\u7b2c" + (y + 1) + "\u5217\u3010" + name + "\u3011\u65f6\u95f4\u683c\u5f0f\u5e94\u8be5\u4e3a \u5e74-\u6708-\u65e5 \u65f6:\u5206:\u79d2 !");
                            }
                        }
                        break block26;
                    }
                    catch (Exception v1) {}
                    break block26;
                }
                return d1;
            }
            catch (Exception ex) {
                try {
                    String v1 = cell.getStringCellValue();
                    if (v1 != null && (v1 = v1.trim()).length() > 0) {
                        if (v1.indexOf(45) != -1) {
                            try {
                                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                return df.parse(v1);
                            }
                            catch (Exception ex2) {
                                throw new RuntimeException("\u7b2c" + (x + 1) + "\u884c,\u7b2c" + (y + 1) + "\u5217\u3010" + name + "\u3011\u65f6\u95f4\u683c\u5f0f\u5e94\u8be5\u4e3a \u5e74-\u6708-\u65e5 \u65f6:\u5206:\u79d2 !");
                            }
                        }
                        if (v1.indexOf(47) != -1) {
                            try {
                                SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                                return df.parse(v1);
                            }
                            catch (Exception ex2) {
                                throw new RuntimeException("\u7b2c" + (x + 1) + "\u884c,\u7b2c" + (y + 1) + "\u5217\u3010" + name + "\u3011\u65f6\u95f4\u683c\u5f0f\u5e94\u8be5\u4e3a \u5e74/\u6708/\u65e5 \u65f6:\u5206:\u79d2 !");
                            }
                        }
                        try {
                            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            return df.parse(v1);
                        }
                        catch (Exception ex2) {
                            throw new RuntimeException("\u7b2c" + (x + 1) + "\u884c,\u7b2c" + (y + 1) + "\u5217\u3010" + name + "\u3011\u65f6\u95f4\u683c\u5f0f\u5e94\u8be5\u4e3a \u5e74-\u6708-\u65e5 \u65f6:\u5206:\u79d2 !");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private Date getDate(HSSFCell cell, int x, int y, String name) {
        block14: {
            if (cell == null) {
                return null;
            }
            try {
                Date d1 = cell.getDateCellValue();
                if (d1 == null) {
                    try {
                        String v1 = cell.getStringCellValue();
                        if (v1 != null && (v1 = v1.trim()).length() > 0) {
                            try {
                                SimpleDateFormat df = new SimpleDateFormat("yy-M-d");
                                return df.parse(v1);
                            }
                            catch (Exception ex2) {
                                throw new RuntimeException("\u7b2c" + (x + 1) + "\u884c,\u7b2c" + (y + 1) + "\u5217\u3010" + name + "\u3011\u65e5\u671f\u683c\u5f0f\u5e94\u8be5\u4e3a \u5e74-\u6708-\u65e5 !");
                            }
                        }
                        break block14;
                    }
                    catch (Exception v1) {}
                    break block14;
                }
                return d1;
            }
            catch (Exception ex) {
                try {
                    String v1 = cell.getStringCellValue();
                    if (v1 != null && (v1 = v1.trim()).length() > 0) {
                        try {
                            SimpleDateFormat df = new SimpleDateFormat("yy-M-d");
                            return df.parse(v1);
                        }
                        catch (Exception ex2) {
                            throw new RuntimeException("\u7b2c" + (x + 1) + "\u884c,\u7b2c" + (y + 1) + "\u5217\u3010" + name + "\u3011\u65e5\u671f\u683c\u5f0f\u5e94\u8be5\u4e3a \u5e74-\u6708-\u65e5 !");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public void exportImportTempExcel(OutputStream out) throws Exception {
        try (HSSFWorkbook workbook = new HSSFWorkbook();){
            HSSFSheet sheet = workbook.createSheet("\u8f66\u724c\u5bfc\u5165\u6a21\u677f");
            int rowIndex = 0;
            int cellIndex = 0;
            Map<String, String> headArrv = this.getAllPlateImportHeadMap();
            headArrv.put("\u5907\u6ce8\u4fe1\u606f", "remark");
            HSSFRow headRow = sheet.createRow(rowIndex++);
            for (Map.Entry<String, String> entry : headArrv.entrySet()) {
                headRow.createCell(cellIndex++).setCellValue(entry.getKey());
            }
            String[] sn = new String[]{"\u8f66\u724c\u53f7\u7801", "\u8f66\u724c\u7c7b\u578b", "\u8f66\u8f86\u7c7b\u578b", "\u8f66\u4e3b\u7f16\u53f7", "\u8f66\u4e3b\u59d3\u540d"};
            HashSet<String> hasset = new HashSet<String>();
            String[] stringArray = sn;
            int n = sn.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                hasset.add(s);
                ++n2;
            }
            HSSFRow row = sheet.createRow(rowIndex++);
            cellIndex = 0;
            for (Map.Entry<String, String> entry : headArrv.entrySet()) {
                String v = hasset.contains(entry.getKey()) ? ("\u8f66\u724c\u53f7\u7801".equals(entry.getKey()) ? "\u8f66\u724c\u53f7\u7801\u548c\u5361\u53f7\u81f3\u5c11\u4e00\u9879\u6709\u503c" : "\u5fc5\u987b\u6709\u503c\uff0c\u4e14\u8be5\u5217\u5fc5\u987b\u6709") : ("\u6709\u6548\u671f".equals(entry.getKey()) ? "2019-10-01 (\u6708\u5361\u8f66\u65f6\u7c7b\u578b\u5fc5\u987b\uff0c\u5176\u4ed6\u53ef\u4ee5\u4e3a\u7a7a)" : ("\u4f59\u989d".equals(entry.getKey()) || "\u8f66\u8f86\u8d26\u6237\u4f59\u989d".equals(entry.getKey()) ? "0.00 (\u50a8\u503c\u8f66\u81ea\u8eab\u7684\u4f59\u989d)" : ("\u8f66\u4e3b\u8d26\u6237\u4f59\u989d".equals(entry.getKey()) ? "0.00 (\u4e00\u4e2a\u7528\u6237\u591a\u4e2a\u50a8\u503c\u8f66\u5171\u4eab\u6263\u8d39)" : "\u53ef\u4ee5\u4e3a\u7a7a\uff0c\u6216\u5217\u4e0d\u5b58\u5728")));
                row.createCell(cellIndex++).setCellValue(v);
            }
            workbook.write(out);
        }
    }

    @Override
    public void exportPlateClientExcel(OutputStream out) throws Exception {
        try (HSSFWorkbook workbook = new HSSFWorkbook();){
            HSSFSheet sheet = workbook.createSheet("\u8f66\u724c\u8f66\u4e3b\u4fe1\u606f");
            int rowIndex = 0;
            int cellIndex = 0;
            Map<String, String> headArrv = this.getAllPlateImportHeadMap();
            headArrv.put("\u8f66\u724c\u53f7\u7801", "register_plate");
            headArrv.put("\u5907\u6ce8\u4fe1\u606f", "remark1");
            HSSFRow headRow = sheet.createRow(rowIndex++);
            for (Map.Entry<String, String> entry : headArrv.entrySet()) {
                headRow.createCell(cellIndex++).setCellValue(entry.getKey());
            }
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            SearchParam sp = new SearchParam(String.valueOf(commonDaoService.getTableName(CarparkPassport.class)) + " a LEFT JOIN " + commonDaoService.getTableName(CarparkCarOwner.class) + " b ON a.car_owner_no=b.car_owner_no AND a.carpark_id=b.carpark_id AND a.project_id=b.project_id");
            ArrayList<String> selectFields = new ArrayList<String>();
            selectFields.add("a.*");
            selectFields.add("b.remark AS remark1");
            String[] clientNames = commonDaoService.getColumnNames(commonDaoService.getTableName(CarparkCarOwner.class));
            Set<String> notX = ServiceUtil.toSet("id", "car_owner_no", "remark", "created_time", "last_updated_time", "project_id", "carpark_id");
            String[] stringArray = clientNames;
            int n = clientNames.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!notX.contains(s)) {
                    selectFields.add("b." + s);
                }
                ++n2;
            }
            sp.setSelectFields(selectFields);
            sp.setOrder_by("a.car_owner_no");
            List list = commonDaoService.selectList(sp, null);
            for (Map objMap : list) {
                Integer medium_type;
                CarparkCarType t2;
                Integer sex;
                HSSFRow row = sheet.createRow(rowIndex++);
                cellIndex = 0;
                Date d = (Date)objMap.get("start_date");
                if (d != null) {
                    objMap.put("start_date", df.format(d));
                }
                if ((d = (Date)objMap.get("deadline")) != null) {
                    objMap.put("deadline", df.format(d));
                }
                if ((sex = (Integer)objMap.get("sex")) != null && sex == 1) {
                    objMap.put("sex", "\u5973");
                } else {
                    objMap.put("sex", "\u7537");
                }
                CarparkPassportType t1 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(objMap.get("passport_type_no"));
                if (t1 != null) {
                    objMap.put("passport_type_name", t1.getPassport_type_name());
                }
                if ((t2 = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap().get(objMap.get("car_type_no"))) != null) {
                    objMap.put("car_type_name", t2.getCar_type_name());
                }
                if ((medium_type = (Integer)objMap.get("medium_type")) == 0 || medium_type == 1) {
                    objMap.put("card_number", objMap.get("passport_number"));
                    objMap.put("passport_number", "");
                } else {
                    objMap.put("card_number", "");
                }
                Map tmap = JavaBeanUtil.toStringMap((Object)objMap);
                for (Map.Entry<String, String> entry : headArrv.entrySet()) {
                    Object t = tmap.get(entry.getValue());
                    String vl = t != null ? t.toString() : "";
                    row.createCell(cellIndex++).setCellValue(vl);
                }
            }
            workbook.write(out);
        }
    }

    @Override
    public void asynHandleDiscount(final CarparkPassDiscount carparkDiscountRecord) {
        if (carparkDiscountRecord == null) {
            return;
        }
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public void run() {
                chanles = ServiceUtil.getServiceContext().getPassChannelManager().getChannels();
                if (chanles != null) ** GOTO lbl151
                return;
lbl-1000:
                // 1 sources

                {
                    passChannel = chanles.nextElement();
                    cl = passChannel.getSessions();
                    if (cl == null) continue;
                    lastRegPassSession = null;
                    lastSession = null;
                    for (final PassSession session : cl) {
                        if (session.getReadPassportNumberEvent() == null || session.getReadPassportNumberEvent().isManualTrigger()) continue;
                        if (session.getPlateRecognizedEvent() != null) {
                            lastRegPassSession = session;
                        }
                        lastSession = session;
                    }
                    for (final PassSession session : cl) {
                        if (session.getSessionState() == PassSession.SessionState.CANCELED) continue;
                        find = false;
                        if (carparkDiscountRecord.getPalte_number() != null && carparkDiscountRecord.getPalte_number().length() > 0 && carparkDiscountRecord.getPalte_number().equals(session.getPassPlate())) {
                            find = true;
                        }
                        if (!find && carparkDiscountRecord.getPassport_number() != null && carparkDiscountRecord.getMedium_type() != null && (event = session.getReadPassportNumberEvent()) != null && carparkDiscountRecord.getPassport_number().equals(event.getPassportNumber()) && carparkDiscountRecord.getMedium_type().intValue() == event.getPassportMediumType()) {
                            find = true;
                        }
                        if (!find) continue;
                        state = session.getSessionState();
                        if (state == PassSession.SessionState.WAIT_PAY || state == PassSession.SessionState.OPEN_DIALOG) {
                            session.setAttribute("SELF_DISCOUNT_PASS", Boolean.TRUE);
                            sbr = new StringBuilder(128);
                            if (carparkDiscountRecord.getDiscount_time() != null) {
                                sbr.append(new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm:ss").format(carparkDiscountRecord.getDiscount_time())).append(": ");
                            }
                            if (carparkDiscountRecord.getPalte_number() != null) {
                                sbr.append(String.valueOf(carparkDiscountRecord.getPalte_number()) + ", ");
                            }
                            sbr.append("\u6253\u6298\u6210\u529f!");
                            if (carparkDiscountRecord.getDiscount_value_des() != null && carparkDiscountRecord.getDiscount_value_des().length() > 0) {
                                sbr.append(" (").append(carparkDiscountRecord.getDiscount_value_des()).append(')');
                            }
                            if (carparkDiscountRecord.getDiscount_project_name() != null && carparkDiscountRecord.getDiscount_project_name().length() > 0) {
                                sbr.append(" [").append(carparkDiscountRecord.getDiscount_project_name()).append("]");
                            }
                            if (carparkDiscountRecord.getDiscount_merchant_name() != null && carparkDiscountRecord.getDiscount_merchant_name().length() > 0) {
                                sbr.append(" [").append(carparkDiscountRecord.getDiscount_merchant_name()).append("]");
                            }
                            if (carparkDiscountRecord.getDiscount_amount() != null && carparkDiscountRecord.getDiscount_amount().doubleValue() > 0.0) {
                                sbr.append(" \u51cf\u514d\u91d1\u989d\uff1a").append(carparkDiscountRecord.getDiscount_amount()).append("\u5143");
                            }
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, sbr.toString(), 1, 10000));
                            var11_11 = session.getExeFilterLock();
                            synchronized (var11_11) {
                                if (state == PassSession.SessionState.WAIT_PAY || state == PassSession.SessionState.OPEN_DIALOG) {
                                    try {
                                        session.getChargeFilter().doFilter(session);
                                    }
                                    catch (Exception e) {
                                        ServiceLog.getLog().warn((Object)("\u91cd\u65b0\u8ba1\u8d39\u5f02\u5e38!" + e.getMessage()), (Throwable)e);
                                        continue;
                                    }
                                }
                            }
                            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                                if (state != PassSession.SessionState.OPEN_DIALOG) continue;
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new SelfPaySuccessEvent(session, null, false));
                                continue;
                            }
                            cost = (Cost)session.getAttribute("pass_cost");
                            if (cost != null && cost.getActualCharge() != null && cost.getActualCharge().doubleValue() <= 0.0 && (lastRegPassSession == session || session == lastSession) && !session.getReadPassportNumberEvent().isManualTrigger()) {
                                delayRun = false;
                                hostSate = session.getPassChannel().getLanConnectManageHostState();
                                if (hostSate != null && (remoteSessionId = (String)session.getAttribute("SLAVE_HOST_SESSIONID_" + hostSate.getHostNo())) != null && remoteSessionId.length() > 0) {
                                    delayRun = true;
                                }
                                if (delayRun) {
                                    if (state == PassSession.SessionState.OPEN_DIALOG) {
                                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new SelfPaySuccessEvent(session, null, false));
                                    }
                                    r /* !! */  = new JobTask(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        protected void doRun() throws Exception {
                                            PassSession.SessionState state = session.getSessionState();
                                            if (state == PassSession.SessionState.WAIT_PAY || state == PassSession.SessionState.OPEN_DIALOG) {
                                                ConfirmPassDialogCallback callback;
                                                boolean closeDialog = false;
                                                Object object = session.getExeFilterLock();
                                                synchronized (object) {
                                                    block13: {
                                                        state = session.getSessionState();
                                                        if (state == PassSession.SessionState.WAIT_PAY) {
                                                            try {
                                                                String message = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u672a\u80fd\u63a5\u6536\u5230\u7f51\u5173\u76d2\u5b50\u653e\u884c\u6210\u529f\u4fe1\u53f7! \u672c\u673a\u653e\u884c\u652f\u4ed8\u6253\u6298\u8f66\u724c:" + session.getPassPlate();
                                                                ServiceLog.getLog().warn((Object)message);
                                                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, message, 3));
                                                                ServiceUtil.getServiceContext().getPassFilterChain().excecutePassFilterAndBehind(session, session.getChargeFilter());
                                                            }
                                                            catch (Exception e) {
                                                                ServiceLog.getLog().warn((Object)("\u6267\u884c\u653e\u884c\u6d41\u7a0b\u5f02\u5e38!" + e.getMessage()), (Throwable)e);
                                                            }
                                                        } else if (state == PassSession.SessionState.OPEN_DIALOG) {
                                                            closeDialog = true;
                                                            try {
                                                                String message = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u672a\u80fd\u63a5\u6536\u5230\u7f51\u5173\u76d2\u5b50\u653e\u884c\u6210\u529f\u4fe1\u53f7! \u672c\u673a\u653e\u884c\u652f\u4ed8\u6253\u6298\u8f66\u724c:" + session.getPassPlate();
                                                                ServiceLog.getLog().warn((Object)message);
                                                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, message, 3));
                                                                ServiceUtil.getServiceContext().getPassFilterChain().excecuteBehindPassFilters(session, session.getConfirmPassFilter());
                                                            }
                                                            catch (Throwable ex) {
                                                                if (session != null) {
                                                                    session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                                                    session.setSessionState(PassSession.SessionState.CANCELED);
                                                                }
                                                                GuiLog.getLog().warn((Object)"\u653e\u884c\u5f02\u5e38", ex);
                                                                if (session == null) break block13;
                                                                String msg = session.getReadPassportNumberEvent() != null ? String.valueOf(Constants.getMediumTypeDes(session.getReadPassportNumberEvent().getPassportMediumType())) + "\uff1a" + session.getReadPassportNumberEvent().getPassportNumber() : "";
                                                                String message = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u653e\u884c\u5f02\u5e38\uff01\u5185\u90e8\u9519\u8bef\uff01" + msg;
                                                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, message, 4));
                                                            }
                                                        }
                                                    }
                                                }
                                                if (closeDialog && (callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback()) != null) {
                                                    callback.doClosePassDialog(session);
                                                }
                                            }
                                        }
                                    };
                                    ServiceUtil.getServiceContext().delay((JobTask)r /* !! */ , 5000L, TimeUnit.MILLISECONDS);
                                    continue;
                                }
                                if (state == PassSession.SessionState.WAIT_PAY) {
                                    r /* !! */  = session.getExeFilterLock();
                                    synchronized (r /* !! */ ) {
                                        if (session.getSessionState() == PassSession.SessionState.WAIT_PAY) {
                                            try {
                                                ServiceUtil.getServiceContext().getPassFilterChain().excecuteBehindPassFilters(session, session.getChargeFilter());
                                            }
                                            catch (Exception e) {
                                                ServiceLog.getLog().error((Object)"\u653e\u884c\u5f02\u5e38\uff01", (Throwable)e);
                                            }
                                        }
                                        continue;
                                    }
                                }
                                closeDialog = true;
                                e = session.getExeFilterLock();
                                synchronized (e) {
                                    if (session.getSessionState() == PassSession.SessionState.OPEN_DIALOG) {
                                        if (session != null && session.getPassChannel().isSwipeCard(session) && session.getPassportType() != null && session.getPassportType().getPass_type() == 0 && session.getPassportType().getUse_muti_car() == 0) {
                                            closeDialog = false;
                                        }
                                        if (closeDialog) {
                                            try {
                                                ServiceUtil.getServiceContext().getPassFilterChain().excecuteBehindPassFilters(session, session.getConfirmPassFilter());
                                                session.removeCancelPassRecord();
                                            }
                                            catch (Throwable e) {
                                                session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                                session.setSessionState(PassSession.SessionState.CANCELED);
                                                GuiLog.getLog().warn((Object)"\u653e\u884c\u5f02\u5e38", e);
                                                msg = session.getReadPassportNumberEvent() != null ? String.valueOf(Constants.getMediumTypeDes(session.getReadPassportNumberEvent().getPassportMediumType())) + "\uff1a" + session.getReadPassportNumberEvent().getPassportNumber() : "";
                                                message = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u653e\u884c\u5f02\u5e38\uff01\u5185\u90e8\u9519\u8bef\uff01" + msg;
                                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, message, 4));
                                            }
                                        }
                                    }
                                }
                                if (closeDialog) {
                                    callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                                    if (callback == null) continue;
                                    callback.doClosePassDialog(session);
                                    continue;
                                }
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new SelfPaySuccessEvent(session, null, false));
                                continue;
                            }
                            if (state != PassSession.SessionState.OPEN_DIALOG) continue;
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new SelfPaySuccessEvent(session, null, false));
                            continue;
                        }
                        if (state != PassSession.SessionState.PROCESSING) continue;
                        waitResultKey = "CLOUD-doSenselessPay-result-" + ServiceUtil.getServiceContext().getLocalHostNo() + "-" + carparkDiscountRecord.getEnter_record_no() + "-" + carparkDiscountRecord.getPassport_number();
                        object = ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)waitResultKey);
                        if (object == null) continue;
                        sbr = new StringBuilder(128);
                        if (carparkDiscountRecord.getDiscount_time() != null) {
                            sbr.append(new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm:ss").format(carparkDiscountRecord.getDiscount_time())).append(": ");
                        }
                        if (carparkDiscountRecord.getPalte_number() != null) {
                            sbr.append(String.valueOf(carparkDiscountRecord.getPalte_number()) + ", ");
                        }
                        sbr.append("\u6253\u6298\u6210\u529f!");
                        if (carparkDiscountRecord.getDiscount_value_des() != null && carparkDiscountRecord.getDiscount_value_des().length() > 0) {
                            sbr.append(" (").append(carparkDiscountRecord.getDiscount_value_des()).append(')');
                        }
                        if (carparkDiscountRecord.getDiscount_project_name() != null && carparkDiscountRecord.getDiscount_project_name().length() > 0) {
                            sbr.append(" [").append(carparkDiscountRecord.getDiscount_project_name()).append("]");
                        }
                        if (carparkDiscountRecord.getDiscount_merchant_name() != null && carparkDiscountRecord.getDiscount_merchant_name().length() > 0) {
                            sbr.append(" [").append(carparkDiscountRecord.getDiscount_merchant_name()).append("]");
                        }
                        if (carparkDiscountRecord.getDiscount_amount() != null && carparkDiscountRecord.getDiscount_amount().doubleValue() > 0.0) {
                            sbr.append(" \u51cf\u514d\u91d1\u989d\uff1a").append(carparkDiscountRecord.getDiscount_amount()).append("\u5143");
                        }
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, sbr.toString(), 1, 10000));
                    }
lbl151:
                    // 3 sources

                    ** while (chanles.hasMoreElements())
                }
lbl152:
                // 1 sources

            }
        });
    }

    @Override
    public void asynHandleSelfPay(final CarparkPassSelfPay sefPay) {
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                scanPaySuccess = sefPay.getPay_scene() != null && sefPay.getPay_scene() == 2;
                chanles = ServiceUtil.getServiceContext().getPassChannelManager().getChannels();
                if (chanles != null) ** GOTO lbl156
                return;
lbl-1000:
                // 1 sources

                {
                    passChannel = chanles.nextElement();
                    cl = passChannel.getSessions();
                    if (cl == null) continue;
                    for (final PassSession session : cl) {
                        if (session.getSessionState() == PassSession.SessionState.CANCELED) continue;
                        find = false;
                        if (sefPay.getPassport_number() != null && sefPay.getMedium_type() != null && (event = session.getReadPassportNumberEvent()) != null && sefPay.getPassport_number().equals(event.getPassportNumber()) && sefPay.getMedium_type().intValue() == event.getPassportMediumType()) {
                            find = true;
                        }
                        if (!find && sefPay.getPlate_number() != null && sefPay.getPlate_number().length() > 0 && sefPay.getPlate_number().equals(session.getPassPlate())) {
                            find = true;
                        }
                        if (find && !scanPaySuccess && sefPay.getPaid_amount().doubleValue() <= 0.0 && (session != passChannel.getLastSession() || session.getCarLeftEvent() != null)) {
                            if (session.getSessionState() == PassSession.SessionState.OPEN_DIALOG || session.getSessionState() == PassSession.SessionState.WAIT_PAY) {
                                try {
                                    try {
                                        if (session.getPassChannel().getLanConnectManageHostState() == null || session.getAttribute("CONFIRM_SESSION_DATA_FROM_BOX") == null) {
                                            if (session.getOpenDialogCacnelRecord() != null) {
                                                session.doSaveCancelPassRecrodIfExist(false, false);
                                            }
                                        } else {
                                            session.removeCancelPassRecord();
                                        }
                                    }
                                    catch (Exception ex) {
                                        ServiceLog.getLog().warn((Object)"\u4fdd\u5b58\u53d6\u6d88\u653e\u884c\u6570\u636e\u5f02\u5e38", (Throwable)ex);
                                        try {
                                            session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                            session.setSessionState(PassSession.SessionState.CANCELED);
                                            try {
                                                callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                                                if (callback == null) continue;
                                                callback.doClosePassDialog(session);
                                            }
                                            finally {
                                                session.getPassChannel().invalidateSession(session);
                                            }
                                        }
                                        catch (Exception ex1) {
                                            ServiceLog.getLog().warn((Object)"\u5173\u95ed\u7a97\u53e3\u5f02\u5e38", (Throwable)ex1);
                                        }
                                        continue;
                                    }
                                }
                                catch (Throwable var9_11) {
                                    try {
                                        session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                        session.setSessionState(PassSession.SessionState.CANCELED);
                                        try {
                                            callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                                            if (callback != null) {
                                                callback.doClosePassDialog(session);
                                            }
                                        }
                                        finally {
                                            session.getPassChannel().invalidateSession(session);
                                        }
                                    }
                                    catch (Exception ex1) {
                                        ServiceLog.getLog().warn((Object)"\u5173\u95ed\u7a97\u53e3\u5f02\u5e38", (Throwable)ex1);
                                    }
                                    throw var9_11;
                                }
                                try {
                                    session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                    session.setSessionState(PassSession.SessionState.CANCELED);
                                    try {
                                        callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                                        if (callback == null) continue;
                                        callback.doClosePassDialog(session);
                                    }
                                    finally {
                                        session.getPassChannel().invalidateSession(session);
                                    }
                                }
                                catch (Exception ex1) {
                                    ServiceLog.getLog().warn((Object)"\u5173\u95ed\u7a97\u53e3\u5f02\u5e38", (Throwable)ex1);
                                }
                                continue;
                            }
                            if (session.getSessionState() != PassSession.SessionState.PROCESSING) continue;
                            session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                            session.setSessionState(PassSession.SessionState.CANCELED);
                            session.getPassChannel().invalidateSession(session);
                            continue;
                        }
                        if (!find) continue;
                        session.setAttribute("SELF_PAY_PASS", Boolean.TRUE);
                        session.setAttribute("SELF_SLEF_PAY_RESULT", sefPay);
                        if (scanPaySuccess && (payTask = (PayCodePayTask)session.getAttribute("PASS_SCANCODE_TASK")) != null) {
                            payTask.onPaySeuccess(sefPay);
                        }
                        hanleMills = session.getHandlePaySuccessAdviceMills();
                        handlePaySuccessAdviceMills = hanleMills.get();
                        lv = ServiceUtil.getServiceContext().currentTimeMillis();
                        if (handlePaySuccessAdviceMills != 0L && lv - handlePaySuccessAdviceMills < 8000L || !(canrun = hanleMills.compareAndSet(handlePaySuccessAdviceMills, lv))) continue;
                        try {
                            session.setDsiplay1MsgWhenMoney(null);
                            sss = session.getReDisplayPayMsg1Task();
                            if (sss != null) {
                                try {
                                    sss.cancel(true);
                                }
                                catch (Exception var15_23) {
                                    // empty catch block
                                }
                                session.setReDisplayPayMsg1Task(null);
                            }
                            if ((state = session.getSessionState()) == PassSession.SessionState.WAIT_PAY || state == PassSession.SessionState.OPEN_DIALOG) {
                                sbr = new StringBuilder();
                                payMethodName = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(sefPay.getPaid_method());
                                isLocalServerPay = false;
                                if (sefPay.getPay_scene() != null && sefPay.getPay_scene() == 1) {
                                    isLocalServerPay = true;
                                }
                                if (isLocalServerPay) {
                                    sbr.append("\u7ba1\u7406\u5904\u6536\u8d39");
                                }
                                if (payMethodName == null || payMethodName.length() == 0) {
                                    payMethodName = isLocalServerPay != false ? "" : "\u5728\u7ebf";
                                }
                                sbr.append(payMethodName);
                                if (!isLocalServerPay && payMethodName.indexOf("\u652f\u4ed8") == -1) {
                                    sbr.append("\u652f\u4ed8");
                                }
                                sbr.append("\u6210\u529f");
                                if (sefPay.getPaid_amount() != null) {
                                    sbr.append("\uff0c\u652f\u4ed8\u91d1\u989d\uff1a").append(sefPay.getPaid_amount()).append("\u5143");
                                }
                                if (sefPay.getPaid_time() != null) {
                                    sbr.append("\uff0c\u652f\u4ed8\u65f6\u95f4\uff1a").append(new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5 HH:mm:ss").format(sefPay.getPaid_time()));
                                }
                                if (sefPay.getPlate_number() != null && sefPay.getPlate_number().length() > 4) {
                                    sbr.append("\uff0c\u652f\u4ed8\u8f66\u724c\uff1a").append(sefPay.getPlate_number());
                                }
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, sbr.toString(), 1, 10000));
                            }
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().warn((Object)("\u63d0\u793a\u652f\u4ed8\u6210\u529f\u6d88\u606f\u5f02\u5e38!" + ex.getMessage()), (Throwable)ex);
                        }
                        if ((state = session.getSessionState()) == PassSession.SessionState.WAIT_PAY || state == PassSession.SessionState.OPEN_DIALOG) {
                            isHandleNoSensePay = false;
                            if (sefPay.getPay_scene() != null && sefPay.getPay_scene() == 5) {
                                waitResultKey = "CLOUD-doSenselessPay-result-" + ServiceUtil.getServiceContext().getLocalHostNo() + "-" + sefPay.getEnter_record_no() + "-" + sefPay.getPassport_number();
                                object = ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)waitResultKey);
                                if (object != null && object instanceof OperationFutureHandler && !(hander = (OperationFutureHandler)object).isDone()) {
                                    hander.setResult((Object)sefPay);
                                    if (hander.getResult() == sefPay) {
                                        isHandleNoSensePay = true;
                                    }
                                }
                            }
                            if (!isHandleNoSensePay) {
                                ApplicationServiceImpl.access$0(ApplicationServiceImpl.this, session, sefPay);
                                continue;
                            }
                            ServiceUtil.getServiceContext().delay(new JobTask(){

                                protected void doRun() throws Exception {
                                    PassSession.SessionState state = session.getSessionState();
                                    if (state == PassSession.SessionState.OPEN_DIALOG || state == PassSession.SessionState.WAIT_PAY) {
                                        ApplicationServiceImpl.this.handlePaySuccess(session, sefPay);
                                    }
                                }
                            }, 1000L, TimeUnit.MILLISECONDS);
                            continue;
                        }
                        if (state != PassSession.SessionState.PROCESSING) continue;
                        waitResultKey = "CLOUD-doSenselessPay-result-" + ServiceUtil.getServiceContext().getLocalHostNo() + "-" + sefPay.getEnter_record_no() + "-" + sefPay.getPassport_number();
                        object = ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)waitResultKey);
                        if (object != null && object instanceof OperationFutureHandler) {
                            hander = (OperationFutureHandler)object;
                            hander.setResult((Object)sefPay);
                            continue;
                        }
                        session1 = session;
                        ServiceUtil.getServiceContext().getScheduledExecutorService().schedule(new Runnable(){

                            @Override
                            public void run() {
                                PassSession.SessionState state = session1.getSessionState();
                                if (state == PassSession.SessionState.WAIT_PAY || state == PassSession.SessionState.OPEN_DIALOG) {
                                    ApplicationServiceImpl.this.asynHandleSelfPay(sefPay);
                                }
                            }
                        }, 1L, TimeUnit.SECONDS);
                    }
lbl156:
                    // 3 sources

                    ** while (chanles.hasMoreElements())
                }
lbl157:
                // 1 sources

            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePaySuccess(final PassSession session, CarparkPassSelfPay sefPay) {
        Object r;
        String remoteSessionId;
        PassSession.SessionState state = session.getSessionState();
        boolean delayRun = false;
        HostSate hostSate = session.getPassChannel().getLanConnectManageHostState();
        if (hostSate != null && (remoteSessionId = (String)session.getAttribute("SLAVE_HOST_SESSIONID_" + hostSate.getHostNo())) != null && remoteSessionId.length() > 0) {
            delayRun = true;
        }
        if (delayRun) {
            if (state == PassSession.SessionState.OPEN_DIALOG) {
                if (session.getChargeFilter() != null) {
                    try {
                        session.getChargeFilter().doFilter(session);
                    }
                    catch (Exception e) {
                        ServiceLog.getLog().warn((Object)("\u91cd\u65b0\u8ba1\u8d39\u5f02\u5e38!" + e.getMessage()), (Throwable)e);
                    }
                }
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new SelfPaySuccessEvent(session, sefPay, false));
            }
            r = new JobTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void doRun() throws Exception {
                    PassSession.SessionState state = session.getSessionState();
                    if (state == PassSession.SessionState.WAIT_PAY || state == PassSession.SessionState.OPEN_DIALOG) {
                        ConfirmPassDialogCallback callback;
                        boolean closeDialog = false;
                        Object object = session.getExeFilterLock();
                        synchronized (object) {
                            block13: {
                                state = session.getSessionState();
                                if (state == PassSession.SessionState.WAIT_PAY) {
                                    try {
                                        String message = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u672a\u80fd\u63a5\u6536\u5230\u63a7\u5236\u76d2\u653e\u884c\u6210\u529f\u4fe1\u53f7! \u672c\u673a\u653e\u884c\u652f\u4ed8\u6210\u529f\u8f66\u724c:" + session.getPassPlate();
                                        ServiceLog.getLog().warn((Object)message);
                                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, message, 3));
                                        ServiceUtil.getServiceContext().getPassFilterChain().excecutePassFilterAndBehind(session, session.getChargeFilter());
                                    }
                                    catch (Exception e) {
                                        ServiceLog.getLog().warn((Object)("\u6267\u884c\u653e\u884c\u6d41\u7a0b\u5f02\u5e38!" + e.getMessage()), (Throwable)e);
                                    }
                                } else if (state == PassSession.SessionState.OPEN_DIALOG) {
                                    closeDialog = true;
                                    try {
                                        String message = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u672a\u80fd\u63a5\u6536\u5230\u63a7\u5236\u76d2\u653e\u884c\u6210\u529f\u4fe1\u53f7! \u672c\u673a\u653e\u884c\u652f\u4ed8\u6210\u529f\u8f66\u724c:" + session.getPassPlate();
                                        ServiceLog.getLog().warn((Object)message);
                                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, message, 3));
                                        ServiceUtil.getServiceContext().getPassFilterChain().excecuteBehindPassFilters(session, session.getConfirmPassFilter());
                                    }
                                    catch (Throwable ex) {
                                        if (session != null) {
                                            session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                            session.setSessionState(PassSession.SessionState.CANCELED);
                                        }
                                        ServiceLog.getLog().warn((Object)"\u653e\u884c\u5f02\u5e38", ex);
                                        if (session == null) break block13;
                                        String msg = session.getReadPassportNumberEvent() != null ? String.valueOf(Constants.getMediumTypeDes(session.getReadPassportNumberEvent().getPassportMediumType())) + "\uff1a" + session.getReadPassportNumberEvent().getPassportNumber() : "";
                                        String message = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u653e\u884c\u5f02\u5e38\uff01\u5185\u90e8\u9519\u8bef\uff01" + msg;
                                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, message, 4));
                                    }
                                }
                            }
                        }
                        if (closeDialog && (callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback()) != null) {
                            callback.doClosePassDialog(session);
                        }
                    }
                }
            };
            ServiceUtil.getServiceContext().delay((JobTask)r, 5000L, TimeUnit.MILLISECONDS);
        } else {
            if (state == PassSession.SessionState.WAIT_PAY) {
                r = session.getExeFilterLock();
                synchronized (r) {
                    if (session.getSessionState() == PassSession.SessionState.WAIT_PAY) {
                        try {
                            ServiceUtil.getServiceContext().getPassFilterChain().excecutePassFilterAndBehind(session, session.getChargeFilter());
                        }
                        catch (Exception e) {
                            ServiceLog.getLog().warn((Object)("\u6267\u884c\u653e\u884c\u6d41\u7a0b\u5f02\u5e38!" + e.getMessage()), (Throwable)e);
                        }
                    }
                }
            }
            if (state == PassSession.SessionState.OPEN_DIALOG) {
                boolean closeDialog = true;
                Object e = session.getExeFilterLock();
                synchronized (e) {
                    if (session.getSessionState() == PassSession.SessionState.OPEN_DIALOG) {
                        Cost cost;
                        if (session.getChargeFilter() != null) {
                            try {
                                session.getChargeFilter().doFilter(session);
                            }
                            catch (Exception e2) {
                                ServiceLog.getLog().warn((Object)("\u91cd\u65b0\u8ba1\u8d39\u5f02\u5e38!" + e2.getMessage()), (Throwable)e2);
                            }
                        }
                        if ((cost = (Cost)session.getAttribute("pass_cost")) == null) {
                            cost = new Cost();
                        }
                        if (cost.getCash().doubleValue() <= 0.0) {
                            if (session != null && session.getPassChannel().isSwipeCard(session) && session.getPassportType() != null && session.getPassportType().getPass_type() == 0 && session.getPassportType().getUse_muti_car() == 0) {
                                closeDialog = false;
                            }
                            if (closeDialog) {
                                try {
                                    ServiceUtil.getServiceContext().getPassFilterChain().excecuteBehindPassFilters(session, session.getConfirmPassFilter());
                                    session.removeCancelPassRecord();
                                }
                                catch (Throwable e3) {
                                    session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                    session.setSessionState(PassSession.SessionState.CANCELED);
                                    GuiLog.getLog().warn((Object)"\u653e\u884c\u5f02\u5e38", e3);
                                    String msg = session.getReadPassportNumberEvent() != null ? String.valueOf(Constants.getMediumTypeDes(session.getReadPassportNumberEvent().getPassportMediumType())) + "\uff1a" + session.getReadPassportNumberEvent().getPassportNumber() : "";
                                    String message = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u653e\u884c\u5f02\u5e38\uff01\u5185\u90e8\u9519\u8bef\uff01" + msg;
                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, message, 4));
                                }
                            }
                        } else {
                            closeDialog = false;
                        }
                    }
                }
                if (closeDialog) {
                    ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                    if (callback != null) {
                        callback.doClosePassDialog(session);
                    }
                } else {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new SelfPaySuccessEvent(session, sefPay, false));
                }
            }
        }
    }

    @Override
    public boolean isAlipayScanCode(String scanCode) {
        return (scanCode.startsWith("25") || scanCode.startsWith("26") || scanCode.startsWith("27") || scanCode.startsWith("28") || scanCode.startsWith("29") || scanCode.startsWith("30")) && scanCode.length() >= 16 && scanCode.length() <= 24 && ValidateUtil.isNumeric(scanCode);
    }

    @Override
    public boolean isWeixinPayScanCode(String scanCode) {
        return (scanCode.startsWith("10") || scanCode.startsWith("11") || scanCode.startsWith("12") || scanCode.startsWith("13") || scanCode.startsWith("14") || scanCode.startsWith("15")) && scanCode.length() == 18 && ValidateUtil.isNumeric(scanCode);
    }

    @Override
    public boolean isEnableWeixinPayCode() {
        Map<Integer, String> paySceneMap = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap();
        Map<Integer, String> payMethodMap = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap();
        return paySceneMap != null && payMethodMap != null && paySceneMap.containsKey(2) && payMethodMap.containsKey(4);
    }

    @Override
    public boolean isEnableAliPayCode() {
        Map<Integer, String> paySceneMap = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap();
        Map<Integer, String> payMethodMap = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap();
        return paySceneMap != null && payMethodMap != null && paySceneMap.containsKey(2) && payMethodMap.containsKey(5);
    }

    @Override
    public Map<String, Object> doScanCodePay(String scanCode, PassSession session, boolean manual) {
        UserSession usersesion;
        Map<String, Object> paramMap = new HashMap<String, Object>();
        if (manual && (usersesion = this.getUserSession()) != null) {
            CarparkUser user;
            CarparkDutyNumber nuner = usersesion.getDutyNumber();
            if (nuner != null) {
                paramMap.put("duty_no", nuner.getDuty_no());
            }
            if ((user = usersesion.getUser()) != null) {
                paramMap.put("operate_user_code", user.getUser_code());
                paramMap.put("operate_user_name", user.getUser_name());
            }
        }
        paramMap = CommonRemoteServiceImpl.setQueryPassSessionResult(session, paramMap);
        if (manual) {
            paramMap.remove("duty_no");
            paramMap.remove("operate_user_code");
            paramMap.remove("operate_user_name");
        }
        paramMap.put("scanCode", scanCode);
        if (!"0".equals(paramMap.get("returnCode"))) {
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", paramMap.get("returnCode"));
            resutMap.put("RETURN_VALUE", paramMap.get("returnMsg"));
            return resutMap;
        }
        CarparkHost localhost = ServiceUtil.getServiceContext().getLocalHost();
        if (localhost == null) {
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u4e3b\u673a\u4e22\u5931");
            return resutMap;
        }
        if (localhost.getHost_use() == 2 || localhost.getHost_use() == 3) {
            return this.doServerScanCodePay(paramMap);
        }
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
            return this.doOnlineScanCodePay(paramMap);
        }
        CarparkHost serverHost = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkServerHost();
        if (serverHost == null) {
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u65e0\u6cd5\u627e\u5230\u505c\u8f66\u573a\u670d\u52a1\u5668");
            return resutMap;
        }
        RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(serverHost.getHost_no(), true);
        if (rpc == null) {
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u672a\u80fd\u8fde\u63a5\u505c\u8f66\u573a\u670d\u52a1\u5668");
            return resutMap;
        }
        try {
            CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
            HashMap<String, Object> context = new HashMap<String, Object>();
            return rpcService.doScanCodePay(paramMap, context);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u505c\u8f66\u573a\u670d\u52a1\u5668\u901a\u4fe1\u5f02\u5e38");
            return resutMap;
        }
    }

    public Map<String, Object> doOnlineScanCodePay(Map<String, Object> paramMap) {
        try {
            CarparkCloudConnection conn = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection();
            if (conn == null || !conn.isConnected()) {
                HashMap<String, Object> resutMap = new HashMap<String, Object>();
                resutMap.put("RETURN_CODE", "ERROR");
                resutMap.put("RETURN_VALUE", "\u672a\u80fd\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668");
                return resutMap;
            }
            return conn.doScanCodePay(paramMap);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u505c\u8f66\u573a\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
            return resutMap;
        }
    }

    @Override
    public Map<String, Object> doServerScanCodePay(Map<String, Object> paramMap) {
        try {
            String carparkQeuryFeeJson = (String)paramMap.remove("carparkQeuryFee");
            CarparkQueryFee queryFee = (CarparkQueryFee)GsonBuilder.create().fromJson(carparkQeuryFeeJson, CarparkQueryFee.class);
            queryFee.setId(this.createLocalRecordSeq("ck_carpark_query_fee_seq"));
            paramMap.put("outOrderNo", String.valueOf(queryFee.getId().toString()) + "_" + new SimpleDateFormat("yyyyMMdd").format(queryFee.getQuery_time()));
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            commonDaoService.insert((Object)queryFee);
            CarparkCloudConnection conn = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection();
            if (conn == null || !conn.isConnected()) {
                HashMap<String, Object> resutMap = new HashMap<String, Object>();
                resutMap.put("RETURN_CODE", "ERROR");
                resutMap.put("RETURN_VALUE", "\u672a\u80fd\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668");
                return resutMap;
            }
            return conn.doScanCodePay(paramMap);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u505c\u8f66\u573a\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
            return resutMap;
        }
    }

    @Override
    public Map<String, Object> doQueryScanPayState(String token, String orderNo) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("token", token);
        paramMap.put("orderNo", orderNo);
        CarparkHost localhost = ServiceUtil.getServiceContext().getLocalHost();
        if (localhost == null) {
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u4e3b\u673a\u4e22\u5931");
            return resutMap;
        }
        if (localhost.getHost_use() == 2 || localhost.getHost_use() == 3) {
            return this.doServerQueryScanPayState(paramMap);
        }
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
            return this.doServerQueryScanPayState(paramMap);
        }
        CarparkHost serverHost = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkServerHost();
        if (serverHost == null) {
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u65e0\u6cd5\u627e\u5230\u505c\u8f66\u573a\u670d\u52a1\u5668");
            return resutMap;
        }
        RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(serverHost.getHost_no(), true);
        if (rpc == null) {
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "NEEDQUERY");
            resutMap.put("RETURN_VALUE", "\u672a\u80fd\u8fde\u63a5\u505c\u8f66\u573a\u670d\u52a1\u5668");
            return resutMap;
        }
        try {
            CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
            HashMap<String, Object> context = new HashMap<String, Object>();
            return rpcService.doQueryScanPaySate(paramMap, context);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "NEEDQUERY");
            resutMap.put("RETURN_VALUE", "\u505c\u8f66\u573a\u670d\u52a1\u5668\u901a\u4fe1\u5f02\u5e38");
            return resutMap;
        }
    }

    @Override
    public Map<String, Object> doServerQueryScanPayState(Map<String, Object> paramMap) {
        try {
            CarparkCloudConnection conn = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection();
            if (conn == null) {
                HashMap<String, Object> resutMap = new HashMap<String, Object>();
                resutMap.put("RETURN_CODE", "ERROR");
                resutMap.put("RETURN_VALUE", "\u672a\u80fd\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668");
                return resutMap;
            }
            KeyValueEntry<String, String> en = conn.doQueryScanPaySate(paramMap);
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", en.getKey());
            resutMap.put("RETURN_VALUE", en.getValue());
            return resutMap;
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u505c\u8f66\u573a\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
            return resutMap;
        }
    }

    @Override
    public Map<String, Object> doCancelScanPay(String token, String orderNo) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("token", token);
        paramMap.put("orderNo", orderNo);
        CarparkHost localhost = ServiceUtil.getServiceContext().getLocalHost();
        if (localhost == null) {
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u4e3b\u673a\u4e22\u5931");
            return resutMap;
        }
        if (localhost.getHost_use() == 2 || localhost.getHost_use() == 3) {
            return this.doServerCancelScanPay(paramMap);
        }
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
            return this.doServerCancelScanPay(paramMap);
        }
        CarparkHost serverHost = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkServerHost();
        if (serverHost == null) {
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u65e0\u6cd5\u627e\u5230\u505c\u8f66\u573a\u670d\u52a1\u5668");
            return resutMap;
        }
        RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(serverHost.getHost_no(), true);
        if (rpc == null) {
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u672a\u80fd\u8fde\u63a5\u505c\u8f66\u573a\u670d\u52a1\u5668");
            return resutMap;
        }
        try {
            CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
            HashMap<String, Object> context = new HashMap<String, Object>();
            return rpcService.doCancelScanPayOrder(paramMap, context);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u505c\u8f66\u573a\u670d\u52a1\u5668\u901a\u4fe1\u5f02\u5e38");
            return resutMap;
        }
    }

    @Override
    public Map<String, Object> doServerCancelScanPay(Map<String, Object> paramMap) {
        try {
            CarparkCloudConnection conn = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection();
            if (conn == null) {
                HashMap<String, Object> resutMap = new HashMap<String, Object>();
                resutMap.put("RETURN_CODE", "ERROR");
                resutMap.put("RETURN_VALUE", "\u672a\u80fd\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668");
                return resutMap;
            }
            KeyValueEntry<String, String> en = conn.doCancelScanPayOrder(paramMap);
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", en.getKey());
            resutMap.put("RETURN_VALUE", en.getValue());
            return resutMap;
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u505c\u8f66\u573a\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
            return resutMap;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Map<String, Object> doSenselessPay(String plate, String contractTypes, PassSession session) {
        block20: {
            paramMap = new HashMap<String, Object>();
            usersesion = this.getUserSession();
            if (usersesion != null) {
                nuner = usersesion.getDutyNumber();
                if (nuner != null) {
                    paramMap.put("duty_no", nuner.getDuty_no());
                }
                if ((user = usersesion.getUser()) != null) {
                    paramMap.put("operate_user_code", user.getUser_code());
                    paramMap.put("operate_user_name", user.getUser_name());
                }
            }
            paramMap = CommonRemoteServiceImpl.setQueryPassSessionResult(session, paramMap);
            paramMap.remove("duty_no");
            paramMap.remove("operate_user_code");
            paramMap.remove("operate_user_name");
            paramMap.put("contractTypes", contractTypes);
            if (!"0".equals(paramMap.get("returnCode"))) {
                resutMap = new HashMap<String, Object>();
                resutMap.put("RETURN_CODE", paramMap.get("returnCode"));
                resutMap.put("RETURN_VALUE", paramMap.get("returnMsg"));
                return resutMap;
            }
            localhost = ServiceUtil.getServiceContext().getLocalHost();
            if (localhost == null) {
                resutMap = new HashMap<String, Object>();
                resutMap.put("RETURN_CODE", "ERROR");
                resutMap.put("RETURN_VALUE", "\u4e3b\u673a\u4e22\u5931");
                return resutMap;
            }
            enterRecordNo = (String)paramMap.get("enterRecordNo");
            passportNumber = (String)paramMap.get("passportNumber");
            waitResultKey = "CLOUD-doSenselessPay-result-" + ServiceUtil.getServiceContext().getLocalHostNo() + "-" + enterRecordNo + "-" + passportNumber;
            resultHandler = ServiceUtil.getServiceContext().createOperationFuture();
            ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)waitResultKey, (Object)resultHandler, new TimeoutObjectPool.TimeoutCallback(){

                public void onTimeout(Object arg0, Object arg1) throws Exception {
                    if (!resultHandler.isDone()) {
                        resultHandler.setResult(null);
                    }
                }
            }, 15L, TimeUnit.SECONDS);
            try {
                block22: {
                    block21: {
                        if (localhost.getHost_use() != 2 && localhost.getHost_use() != 3) break block21;
                        resultMap = this.doServerSenselessPay(paramMap);
                        ** GOTO lbl75
                    }
                    config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
                    if (config.getCarpark_deploy_type() != 1) break block22;
                    resultMap = this.doOnlineSenselessPay(paramMap);
                    ** GOTO lbl75
                }
                serverHost = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkServerHost();
                if (serverHost == null) {
                    resutMap = new HashMap<String, Object>();
                    resutMap.put("RETURN_CODE", "ERROR");
                    resutMap.put("RETURN_VALUE", "\u65e0\u6cd5\u627e\u5230\u505c\u8f66\u573a\u670d\u52a1\u5668");
                    var18_18 = resutMap;
                    return var18_18;
                }
                rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(serverHost.getHost_no(), true);
                if (rpc == null) {
                    resutMap = new HashMap<String, Object>();
                    resutMap.put("RETURN_CODE", "ERROR");
                    resutMap.put("RETURN_VALUE", "\u672a\u80fd\u8fde\u63a5\u505c\u8f66\u573a\u670d\u52a1\u5668");
                    var18_19 = resutMap;
                    return var18_19;
                }
                try {
                    rpcService = rpc.crateRemoteService(CommonRemoteService.class);
                    context = new HashMap<String, Object>();
                    resultMap = rpcService.doSenselessPay(paramMap, context);
lbl75:
                    // 3 sources

                    RETURN_CODE = (String)resultMap.get("RETURN_CODE");
                    if (RETURN_CODE == null || RETURN_CODE.length() == 0) {
                        resultMap.put("RETURN_CODE", "ERROR");
                        resultMap.put("RETURN_VALUE", "\u7f3a\u5c11\u54cd\u5e94\u7801");
                        break block20;
                    }
                    if ("WAIT_PAY_RESULT".equals(RETURN_CODE)) {
                        try {
                            selfPay = (CarparkPassSelfPay)resultHandler.get(16L, TimeUnit.SECONDS);
                            if (selfPay == null) {
                                resultMap.put("RETURN_CODE", "ERROR");
                                resultMap.put("RETURN_VALUE", "\u7b49\u5f85\u652f\u4ed8\u7ed3\u679c\u8d85\u65f6");
                                ServiceLog.getLog().error((Object)(String.valueOf(plate) + "\u65e0\u611f\u652f\u4ed8\u5931\u8d25\uff01\u7b49\u5f85\u652f\u4ed8\u7ed3\u679c\u8d85\u65f6! "));
                                break block20;
                            }
                            resultMap.put("RETURN_CODE", "SUCCESS");
                            resultMap.put("RETURN_VALUE", GsonBuilder.create().toJson((Object)selfPay));
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().error((Object)(String.valueOf(plate) + "\u65e0\u611f\u652f\u4ed8\u5931\u8d25\uff01\u7b49\u5f85\u652f\u4ed8\u7ed3\u679c\u5f02\u5e38! " + (resultHandler.getException() == null ? ex : resultHandler.getException())));
                            resultMap.put("RETURN_CODE", "ERROR");
                            resultMap.put("RETURN_VALUE", "\u7b49\u5f85\u652f\u4ed8\u7ed3\u679c\u5f02\u5e38");
                        }
                        break block20;
                    }
                    if (resultHandler.isDone() && resultHandler.getException() == null && resultHandler.getResult() != null) {
                        resultMap.put("RETURN_CODE", "SUCCESS");
                        resultMap.put("RETURN_VALUE", GsonBuilder.create().toJson(resultHandler.getResult()));
                    }
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(plate) + "\u65e0\u611f\u652f\u4ed8\u5931\u8d25\uff01\u5f02\u5e38\uff1a "), (Throwable)ex);
                    resutMap = new HashMap<String, Object>();
                    resutMap.put("RETURN_CODE", "ERROR");
                    resutMap.put("RETURN_VALUE", "\u505c\u8f66\u573a\u670d\u52a1\u5668\u901a\u4fe1\u5f02\u5e38");
                    var18_20 = resutMap;
                    return var18_20;
                }
            }
            finally {
                ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)waitResultKey);
            }
        }
        return resultMap;
    }

    public Map<String, Object> doOnlineSenselessPay(Map<String, Object> paramMap) {
        return this.doServerSenselessPay(paramMap);
    }

    @Override
    public Map<String, Object> doServerSenselessPay(Map<String, Object> paramMap) {
        try {
            Map<String, String> cConfig;
            String reutrnCode;
            Map<String, String> yongChengConfig;
            String platform_secret_key;
            String platform_mch_id;
            String com_base_address;
            String contractTypes = (String)paramMap.get("contractTypes");
            if (contractTypes == null || contractTypes.length() == 0) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "FAIL");
                map.put("RETURN_VALUE", "\u7f3a\u5c11\u53c2\u6570contractTypes");
                return map;
            }
            String[] contractTypesArray = contractTypes.split(",");
            LinkedHashSet<Integer> sets = new LinkedHashSet<Integer>();
            String[] stringArray = contractTypesArray;
            int n = contractTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if ((s = s.trim()).length() != 0) {
                    try {
                        sets.add(Integer.valueOf(s));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            if (sets.isEmpty()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "FAIL");
                map.put("RETURN_VALUE", "\u53c2\u6570contractTypes\u503c\u9519\u8bef");
                return map;
            }
            String carparkQeuryFeeJson = (String)paramMap.remove("carparkQeuryFee");
            CarparkQueryFee queryFee = (CarparkQueryFee)GsonBuilder.create().fromJson(carparkQeuryFeeJson, CarparkQueryFee.class);
            if (!ServiceUtil.getServiceContext().isSupportSenselessPay() && sets.isEmpty()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "FAIL_CONFIG_ERROR");
                map.put("RETURN_VALUE", "\u672a\u914d\u7f6e\u65e0\u611f\u652f\u4ed8\u6263\u6b3e");
                return map;
            }
            if (ServiceUtil.getServiceContext().getCloudContext() == null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "NET_ERROR");
                map.put("RETURN_VALUE", "\u672a\u8fde\u63a5\u4e91\u5e73\u53f0");
                return map;
            }
            if (ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection() == null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "NET_ERROR");
                map.put("RETURN_VALUE", "\u672a\u8fde\u63a5\u4e91\u5e73\u53f0");
                return map;
            }
            if (!ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().isConnected()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "NET_ERROR");
                map.put("RETURN_VALUE", "\u672a\u8fde\u63a5\u4e91\u5e73\u53f0");
                return map;
            }
            if (sets.contains(9) || sets.contains(1)) {
                Map<String, String> ccbConfig = ServiceUtil.getServiceContext().getSenselessConfig(9);
                if (ccbConfig != null && !ccbConfig.isEmpty()) {
                    Map responseMap;
                    boolean isSupportX;
                    sets.remove(9);
                    sets.remove(1);
                    String v1 = ccbConfig.get("WL_SCA");
                    String v2 = ccbConfig.get("WL_CCA");
                    Object centry = null;
                    boolean bl = isSupportX = Constants.YES_STR.equals(v1) || Constants.YES_STR.equals(v2);
                    if (!isSupportX && "SUCCESS".equals((centry = CcbSenselessPayer.queryContract(queryFee.getPlate_number(), ccbConfig)).getKey())) {
                        responseMap = (Map)centry.getValue();
                        if (responseMap.get("AUTHSTATUS") != null && responseMap.get("AUTHNO") != null) {
                            if (queryFee.getPlate_number().equals(responseMap.get("AUTHNO").toString())) {
                                boolean isContract = "1".equals(responseMap.get("AUTHSTATUS").toString());
                                centry = isContract ? null : new KeyValueEntry((Object)"UNCONTRACT", (Object)"\u8f66\u724c\u672a\u7b7e\u7ea6");
                            } else {
                                centry = new KeyValueEntry((Object)"ERROR", (Object)"\u67e5\u8be2\u8f66\u724c\u662f\u5426\u7b7e\u7ea6\u5931\u8d25");
                                ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5efa\u884c\u65e0\u611f\u652f\u4ed8\u67e5\u8be2\u8f66\u724c\u662f\u5426\u7b7e\u7ea6\u5f02\u5e38! \u8fd4\u56de\u8f66\u724c\u4e0d\u4e00\u81f4,\u671f\u5f85\u8f66\u724c: " + queryFee.getPlate_number() + ", \u8fd4\u56de\u6570\u636e: " + responseMap));
                            }
                        } else {
                            ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u5efa\u884c\u65e0\u611f\u652f\u4ed8\u67e5\u8be2\u8f66\u724c\u662f\u5426\u7b7e\u7ea6\u5f02\u5e38! \u7f3a\u5c11\u6570\u636e\u5c5e\u6027,\u8fd4\u56de\u6570\u636e: " + responseMap));
                            centry = new KeyValueEntry((Object)"ERROR", (Object)"\u67e5\u8be2\u8f66\u724c\u662f\u5426\u7b7e\u7ea6\u5931\u8d25");
                        }
                    }
                    String ccbOrderNo = CcbSenselessPayer.getOrderId(queryFee.getPlate_number(), queryFee.getEnter_time());
                    if (centry == null) {
                        centry = CcbSenselessPayer.deduct(queryFee.getPlate_number(), queryFee.getActual_charge_amount(), ccbOrderNo, ccbConfig);
                    }
                    if ("SUCCESS".equals(centry.getKey())) {
                        responseMap = (Map)centry.getValue();
                        return this.handleCcbSenselessPayResult(responseMap, queryFee, ccbOrderNo);
                    }
                    ServiceLog.getLog().warn((Object)(String.valueOf(queryFee.getPlate_number()) + ": \u8c03\u7528\u5efa\u884c\u65e0\u611f\u652f\u4ed8\u6263\u8d39\u5931\u8d25!" + (String)centry.getKey() + ": " + centry.getValue()));
                    if ("REQUEST_ERROR".equals(centry.getKey()) || "RESPONSE_ERROR".equals(centry.getKey())) {
                        if (sets.isEmpty() || !ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().isConnected()) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("RETURN_CODE", centry.getKey());
                            map.put("RETURN_VALUE", centry.getValue().toString());
                            return map;
                        }
                    } else if (sets.isEmpty()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("RETURN_CODE", centry.getKey());
                        map.put("RETURN_VALUE", centry.getValue().toString());
                        return map;
                    }
                    if (ServiceUtil.getServiceContext().getCloudContext() == null) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("RETURN_CODE", "NET_ERROR");
                        map.put("RETURN_VALUE", "\u672a\u8fde\u63a5\u4e91\u5e73\u53f0");
                        return map;
                    }
                    if (ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection() == null) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("RETURN_CODE", "NET_ERROR");
                        map.put("RETURN_VALUE", "\u672a\u8fde\u63a5\u4e91\u5e73\u53f0");
                        return map;
                    }
                    if (!ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().isConnected()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("RETURN_CODE", "NET_ERROR");
                        map.put("RETURN_VALUE", "\u672a\u8fde\u63a5\u4e91\u5e73\u53f0");
                        return map;
                    }
                }
            } else if (sets.contains(8)) {
                Map<String, String> yongChengConfig2 = ServiceUtil.getServiceContext().getSenselessConfig(8);
                if (yongChengConfig2 == null || yongChengConfig2.isEmpty()) {
                    ServiceLog.getLog().warn((Object)"\u752c\u57ce\u65e0\u611f\u652f\u4ed8\u7f3a\u5c11\u914d\u7f6e");
                    sets.remove(8);
                } else {
                    com_base_address = yongChengConfig2.get("com_base_address");
                    platform_mch_id = yongChengConfig2.get("platform_mch_id");
                    platform_secret_key = yongChengConfig2.get("platform_secret_key");
                    String parkpotId = yongChengConfig2.get("parkpotId");
                    if (com_base_address == null || com_base_address.length() == 0 || platform_mch_id == null || platform_mch_id.length() == 0 || platform_secret_key == null || platform_secret_key.length() == 0 || parkpotId == null || parkpotId.length() == 0) {
                        ServiceLog.getLog().warn((Object)"\u752c\u57ce\u65e0\u611f\u652f\u4ed8\u914d\u7f6e\u4e0d\u6b63\u786e");
                        sets.remove(8);
                    }
                }
            } else if (sets.contains(22)) {
                Map<String, String> yichangConfig = ServiceUtil.getServiceContext().getSenselessConfig(22);
                if (yichangConfig == null || yichangConfig.isEmpty()) {
                    ServiceLog.getLog().warn((Object)"\u5b9c\u660c\u65e0\u611f\u652f\u4ed8\u7f3a\u5c11\u914d\u7f6e");
                    sets.remove(22);
                } else {
                    com_base_address = yichangConfig.get("com_base_address");
                    platform_mch_id = yichangConfig.get("platform_mch_id");
                    platform_secret_key = yichangConfig.get("platform_secret_key");
                    String parkpotId = yichangConfig.get("parkpotId");
                    if (com_base_address == null || com_base_address.length() == 0 || platform_mch_id == null || platform_mch_id.length() == 0 || platform_secret_key == null || platform_secret_key.length() == 0 || parkpotId == null || parkpotId.length() == 0) {
                        ServiceLog.getLog().warn((Object)"\u5b9c\u660c\u65e0\u611f\u652f\u4ed8\u914d\u7f6e\u4e0d\u6b63\u786e");
                        sets.remove(22);
                    }
                }
            } else if (sets.contains(23)) {
                Map<String, String> sdxlConfig = ServiceUtil.getServiceContext().getSenselessConfig(23);
                if (sdxlConfig == null || sdxlConfig.isEmpty()) {
                    ServiceLog.getLog().warn((Object)"\u5c71\u4e1c\u4fe1\u8054ETC\u652f\u4ed8\u7f3a\u5c11\u914d\u7f6e");
                    sets.remove(23);
                } else {
                    String gateway = sdxlConfig.get("gateway");
                    String appId = sdxlConfig.get("appId");
                    String xlPublicKey = sdxlConfig.get("xlPublicKey");
                    String merPrivateKey = sdxlConfig.get("merPrivateKey");
                    String lanes = sdxlConfig.get("lanes");
                    if (gateway == null || gateway.length() == 0 || appId == null || appId.length() == 0 || xlPublicKey == null || xlPublicKey.length() == 0 || merPrivateKey == null || merPrivateKey.length() == 0 || lanes == null || lanes.length() == 0) {
                        ServiceLog.getLog().warn((Object)"\u5c71\u4e1c\u4fe1\u8054ETC\u652f\u4ed8\u914d\u7f6e\u4e0d\u6b63\u786e");
                        sets.remove(23);
                    }
                }
            }
            if (sets.isEmpty()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "FAIL");
                map.put("RETURN_VALUE", "\u652f\u4ed8\u5931\u8d25");
                return map;
            }
            queryFee.setId(this.createLocalRecordSeq("ck_carpark_query_fee_seq"));
            SenselessOrderNo senselessOrderNo = new SenselessOrderNo(queryFee.getId(), ServiceUtil.getServiceContext().getLocalHostNo(), ServiceUtil.getServiceContext().getCarparkId());
            String outOrderNo = senselessOrderNo.toString();
            paramMap.put("outOrderNo", outOrderNo);
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            commonDaoService.insert((Object)queryFee);
            if (sets.contains(8)) {
                Map<String, Object> rMap;
                sets.remove(8);
                yongChengConfig = ServiceUtil.getServiceContext().getSenselessConfig(8);
                if (yongChengConfig != null && !yongChengConfig.isEmpty() && (rMap = YongChengSenselessPayer.deduct(queryFee, outOrderNo, yongChengConfig)) != null) {
                    reutrnCode = (String)rMap.get("RETURN_CODE");
                    if ("WAIT_PAY_RESULT".equals(reutrnCode) || "SUCCESS".equals(reutrnCode)) {
                        return rMap;
                    }
                    if (sets.isEmpty()) {
                        return rMap;
                    }
                }
            } else if (sets.contains(22)) {
                Map<String, Object> rMap;
                sets.remove(22);
                yongChengConfig = ServiceUtil.getServiceContext().getSenselessConfig(22);
                if (yongChengConfig != null && !yongChengConfig.isEmpty() && (rMap = YiChangSenselessPayer.deduct(queryFee, outOrderNo, yongChengConfig)) != null) {
                    reutrnCode = (String)rMap.get("RETURN_CODE");
                    if ("WAIT_PAY_RESULT".equals(reutrnCode) || "SUCCESS".equals(reutrnCode)) {
                        return rMap;
                    }
                    if (sets.isEmpty()) {
                        return rMap;
                    }
                }
            } else if (sets.contains(44)) {
                Map<String, Object> rMap;
                sets.remove(44);
                cConfig = ServiceUtil.getServiceContext().getSenselessConfig(44);
                if (cConfig != null && !cConfig.isEmpty() && (rMap = WuhanChangSenselessPayer.deduct(queryFee, outOrderNo, cConfig)) != null) {
                    reutrnCode = (String)rMap.get("RETURN_CODE");
                    if ("WAIT_PAY_RESULT".equals(reutrnCode) || "SUCCESS".equals(reutrnCode)) {
                        return rMap;
                    }
                    if (sets.isEmpty()) {
                        return rMap;
                    }
                }
            } else if (sets.contains(23)) {
                SencelessPayResult rx;
                sets.remove(23);
                cConfig = ServiceUtil.getServiceContext().getSenselessConfig(23);
                if (cConfig != null && !cConfig.isEmpty() && (rx = SDXLETCCloudPayer.deduct(paramMap, queryFee, cConfig)) != null) {
                    HashMap map = new HashMap();
                    map.put("RETURN_CODE", rx.getPayResult());
                    if ("SUCCESS".equals(rx.getPayResult())) {
                        if (rx.getPassSelfPay() != null) {
                            map.put("RETURN_VALUE", GsonBuilder.create().toJson((Object)rx.getPassSelfPay()));
                        }
                    } else {
                        map.put("RETURN_VALUE", rx.getPayMsg());
                    }
                    return map;
                }
            }
            if (sets.isEmpty()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RETURN_CODE", "FAIL");
                map.put("RETURN_VALUE", "\u652f\u4ed8\u5931\u8d25");
                return map;
            }
            StringBuilder sbr = new StringBuilder(contractTypes.length());
            for (Integer a : sets) {
                if (sbr.length() > 0) {
                    sbr.append(',');
                }
                sbr.append(a.toString());
            }
            contractTypes = sbr.toString();
            paramMap.put("contractTypes", contractTypes);
            CarparkCloudConnection conn = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection();
            if (conn == null || !conn.isConnected()) {
                HashMap<String, Object> resutMap = new HashMap<String, Object>();
                resutMap.put("RETURN_CODE", "ERROR");
                resutMap.put("RETURN_VALUE", "\u672a\u80fd\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668");
                return resutMap;
            }
            return conn.doSenselessPay(paramMap);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "ERROR");
            resutMap.put("RETURN_VALUE", "\u505c\u8f66\u573a\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
            return resutMap;
        }
    }

    private Map<String, Object> handleCcbSenselessPayResult(Map<?, ?> resultMap, CarparkQueryFee queryFee, String orderNo) {
        try {
            if ("Y".equals(resultMap.get("RESULT"))) {
                try {
                    Date now;
                    BigDecimal AMOUNT = new BigDecimal(resultMap.get("AMOUNT").toString());
                    Calendar cl = Calendar.getInstance();
                    cl.set(14, 0);
                    Date payTime = now = cl.getTime();
                    final CarparkPassSelfPay sefPay = new CarparkPassSelfPay();
                    long selfPayId = this.createLocalRecordSeq("ck_carpark_query_fee_seq");
                    if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                        int x = (int)selfPayId;
                        selfPayId = x;
                    }
                    sefPay.setId(selfPayId);
                    sefPay.setPaid_amount(AMOUNT);
                    sefPay.setPaid_method(9);
                    sefPay.setPay_scene(5);
                    sefPay.setCharge_org(1);
                    sefPay.setPay_entry(0);
                    sefPay.setPaid_time(payTime);
                    cl.setTime(payTime);
                    cl.add(12, 15);
                    sefPay.setPlan_leave_time(cl.getTime());
                    sefPay.setPassport_number(queryFee.getPassport_number());
                    sefPay.setMedium_type(queryFee.getMedium_type());
                    sefPay.setEnter_time(queryFee.getEnter_time());
                    sefPay.setCharge_start_time(queryFee.getCharge_start_time());
                    sefPay.setPlate_number(queryFee.getPlate_number());
                    sefPay.setEnter_record_no(queryFee.getEnter_record_no());
                    sefPay.setShould_charge(queryFee.getShould_charge());
                    sefPay.setDiscount_money(queryFee.getDiscount_money());
                    sefPay.setAlready_paid(queryFee.getAlready_paid());
                    sefPay.setPeriod_multi_free(queryFee.getPeriod_multi_free());
                    sefPay.setPeriod_multi_received(queryFee.getPeriod_multi_received());
                    sefPay.setPeriod_multi_start(queryFee.getPeriod_multi_start());
                    sefPay.setNext_period_multi_cur(queryFee.getNext_period_multi_cur());
                    sefPay.setNext_period_multi_start(queryFee.getNext_period_multi_start());
                    sefPay.setCharge_time_length(queryFee.getCharge_time_length());
                    sefPay.setCloud_order_no(orderNo);
                    sefPay.setCreated_time(now);
                    sefPay.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                    sefPay.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                    sefPay.setDuty_no(queryFee.getDuty_no());
                    sefPay.setDiscounts_json(queryFee.getDiscounts_json());
                    CarparkTransaction t = new CarparkTransaction();
                    long tranId = this.createLocalRecordSeq("ck_carpark_transaction_seq");
                    t.setId(tranId);
                    t.setTansaction_no("C" + t.getId().toString());
                    t.setTran_type(0);
                    t.setService_type(0);
                    t.setPlate_number(sefPay.getPlate_number());
                    t.setPassport_number(sefPay.getPassport_number());
                    t.setMedium_type(sefPay.getMedium_type());
                    t.setPassport_no(queryFee.getPassport_no());
                    t.setPass_type(queryFee.getPass_type());
                    t.setPassport_type_no(queryFee.getPassport_type_no());
                    t.setPassport_type_name(queryFee.getPassport_type_name());
                    t.setCar_type_no(queryFee.getCar_type_no());
                    t.setCar_type_name(queryFee.getCar_type_name());
                    t.setOrder_no(sefPay.getCloud_order_no());
                    t.setTran_money(sefPay.getPaid_amount());
                    t.setTran_time(sefPay.getPaid_time());
                    t.setPay_method(sefPay.getPaid_method());
                    t.setPay_scene(sefPay.getPay_scene());
                    t.setCharge_org(sefPay.getCharge_org());
                    t.setPay_entry(sefPay.getPay_entry());
                    t.setTran_area_no(queryFee.getTran_area_no());
                    t.setTran_area_name(queryFee.getTran_area_name());
                    t.setTran_channel_no(queryFee.getTran_area_no());
                    t.setTran_channel_name(queryFee.getTran_area_name());
                    t.setTran_user_no(queryFee.getTran_user_no());
                    t.setTran_user_name(queryFee.getTran_user_name());
                    t.setDuty_no(sefPay.getDuty_no());
                    t.setEnter_record_no(sefPay.getEnter_record_no());
                    t.setEnter_time(sefPay.getEnter_time());
                    t.setOperate_user_code(queryFee.getOperate_user_code());
                    t.setOperate_user_name(queryFee.getOperate_user_name());
                    t.setTran_des("\u4e34\u505c\u5efa\u884c\u65e0\u611f\u652f\u4ed8");
                    t.setShould_charge(sefPay.getShould_charge());
                    t.setDiscount_money(sefPay.getDiscount_money());
                    t.setAlready_paid(sefPay.getAlready_paid());
                    t.setPeriod_multi_free(sefPay.getPeriod_multi_free());
                    t.setHost_no(queryFee.getHost_no());
                    t.setHost_name(queryFee.getHost_name());
                    t.setCreated_time(sefPay.getCreated_time());
                    t.setCarpark_id(sefPay.getCarpark_id());
                    t.setProject_id(sefPay.getProject_id());
                    t.setExit_time(null);
                    sefPay.setCharge_record_no(t.getTansaction_no());
                    CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    final LinkedList<CarparkDispatchTask> dispatchTaskList = new LinkedList<CarparkDispatchTask>();
                    if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != 1) {
                        dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(daoService.getTableName(CarparkTransaction.class), t.getId().toString(), "ALL_HOSTS"));
                    } else {
                        dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(daoService.getTableName(CarparkTransaction.class), t.getId().toString(), "CARPARK_SERVER"));
                    }
                    try (SqlSession session = daoService.openSqlSession();){
                        try {
                            daoService.insert(session, (Object)sefPay);
                            daoService.insert(session, (Object)t);
                            if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
                                for (CarparkDispatchTask task : dispatchTaskList) {
                                    daoService.insert(session, (Object)task);
                                }
                            }
                            session.commit();
                        }
                        catch (Exception ex) {
                            session.rollback();
                            throw ex;
                        }
                    }
                    ServiceUtil.getServiceContext().getScheduledExecutorService().schedule(new Runnable(){

                        @Override
                        public void run() {
                            if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
                                ApplicationServiceImpl.this.asynTryRunDispatchTask(dispatchTaskList);
                            }
                            ApplicationServiceImpl.this.asynHandleSelfPay(sefPay);
                        }
                    }, 3000L, TimeUnit.MILLISECONDS);
                    HashMap<String, Object> resutMap = new HashMap<String, Object>();
                    resutMap.put("RETURN_CODE", "SUCCESS");
                    resutMap.put("RETURN_VALUE", GsonBuilder.create().toJson((Object)sefPay));
                    try {
                        StringBuilder bsr = new StringBuilder();
                        if (sefPay.getPlate_number() != null && sefPay.getPlate_number().length() > 0) {
                            bsr.append(sefPay.getPlate_number()).append(", ");
                        }
                        if (sefPay.getMedium_type() != null && sefPay.getMedium_type() != 6) {
                            bsr.append("\u5361\u53f7\uff1a").append(sefPay.getPassport_number()).append(", ");
                        }
                        bsr.append("\u65e0\u611f\u652f\u4ed8").append(": ").append(sefPay.getPaid_amount()).append(", ");
                        if (sefPay.getPaid_time() != null) {
                            bsr.append("\u652f\u4ed8\u65f6\u95f4: ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(sefPay.getPaid_time()));
                        }
                        bsr.append("\u8ba2\u5355\u53f7: ").append(sefPay.getCloud_order_no());
                        ServiceLog.getLog().info((Object)("\u5efa\u884c\u652f\u4ed8\u6210\u529f: " + bsr.toString()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return resutMap;
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u5efa\u884c\u65e0\u611f\u652f\u4ed8\u6210\u529f\uff01\u4f46\u662f\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef! \u652f\u4ed8\u6210\u529f\u6d88\u606f" + resultMap), (Throwable)ex);
                    HashMap<String, Object> resutMap = new HashMap<String, Object>();
                    resutMap.put("RETURN_CODE", "PAY_SUCCESS_SYS_ERROR");
                    resutMap.put("RETURN_VALUE", "\u5efa\u884c\u652f\u4ed8\u6210\u529f\uff0c\u4f46\u8f66\u573a\u7cfb\u7edf\u5185\u90e8\u9519\u8bef!");
                    return resutMap;
                }
            }
            ServiceLog.getLog().warn((Object)(String.valueOf(queryFee.getPlate_number()) + ": \u5efa\u884c\u6263\u8d39\u4e1a\u52a1\u5931\u8d25! \u54cd\u5e94: " + resultMap));
            String errCode = (String)resultMap.get("ERRORCODE");
            String errMsg = (String)resultMap.get("ERRORMSG");
            if (errCode == null || errCode.length() == 0) {
                errCode = "PAY_ERROR";
            }
            if (errMsg == null || errMsg.length() == 0) {
                errMsg = "\u5efa\u884c\u652f\u4ed8\u5931\u8d25";
            }
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", errCode);
            resutMap.put("RETURN_VALUE", errMsg);
            return resutMap;
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            HashMap<String, Object> resutMap = new HashMap<String, Object>();
            resutMap.put("RETURN_CODE", "PAY_ERROR");
            resutMap.put("RETURN_VALUE", "\u5efa\u884c\u652f\u4ed8\u5f02\u5e38");
            return resutMap;
        }
    }

    @Override
    public void addChangeShiftsListener(ChangeShiftsListener changeShiftsListener) {
        if (changeShiftsListener != null) {
            this.changeShiftsListeners.add(changeShiftsListener);
        }
    }

    @Override
    public void removeChangeShiftsListener(ChangeShiftsListener changeShiftsListener) {
        if (changeShiftsListener != null) {
            this.changeShiftsListeners.remove(changeShiftsListener);
        }
    }

    @Override
    public Collection<ChangeShiftsListener> getChangeShiftsListeners() {
        return this.changeShiftsListeners;
    }

    @Override
    public void closeConfirmDialogWithout(String withoutChannelNo, String passportNumber, int mediaType, Date passTime) {
        if (withoutChannelNo == null || withoutChannelNo.length() == 0 || passportNumber == null || passportNumber.length() == 0) {
            return;
        }
        Map<String, CarparkChannel> chanelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
        CarparkChannel otherChannel = null;
        if (chanelMap != null) {
            otherChannel = chanelMap.get(withoutChannelNo);
        }
        if (otherChannel == null) {
            return;
        }
        Enumeration<PassChannel> enus = ServiceUtil.getServiceContext().getPassChannelManager().getChannels();
        if (enus != null) {
            while (enus.hasMoreElements()) {
                Collection<PassSession> sessions;
                PassChannel passChannel = enus.nextElement();
                if (withoutChannelNo.equals(passChannel.getChannelNo()) || (sessions = passChannel.getSessions()) == null) continue;
                for (PassSession session : sessions) {
                    Date sessionPassTime;
                    if ((session.getSessionState() == PassSession.SessionState.OPEN_DIALOG || session.getSessionState() == PassSession.SessionState.WAIT_PAY) && session.getReadPassportNumberEvent() != null && passportNumber.equals(session.getReadPassportNumberEvent().getPassportNumber()) && mediaType == session.getReadPassportNumberEvent().getPassportMediumType()) {
                        String plate;
                        ConfirmPassDialogCallback callback;
                        boolean openingDialog;
                        if (passTime != null && (sessionPassTime = (Date)session.getAttribute("passTime")) != null && sessionPassTime.getTime() > passTime.getTime()) continue;
                        boolean bl = openingDialog = session.getSessionState() == PassSession.SessionState.OPEN_DIALOG;
                        if (session.getOpenDialogCacnelRecord() != null) {
                            session.doSaveCancelPassRecrodIfExist(false, false);
                        }
                        session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                        session.setSessionState(PassSession.SessionState.CANCELED);
                        if (openingDialog && (callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback()) != null) {
                            callback.doClosePassDialog(session);
                        }
                        String msg = (plate = session.getPassPlate()) == null || plate.length() == 0 ? "\u8f66\u8f86\uff1a" + passportNumber : "\u8f66\u8f86\uff1a" + plate;
                        msg = String.valueOf(msg) + "\u5df2\u9a76\u5165\u8f66\u9053\uff1a" + otherChannel.getChannel_name();
                        msg = openingDialog ? String.valueOf(msg) + ", " + session.getPassChannel().getChannel().getChannel_name() + "\u7684\u653e\u884c\u786e\u8ba4\u6846\u5df2\u5173\u95ed! " : String.valueOf(msg) + ", \u79bb\u5f00\u4e86" + session.getPassChannel().getChannel().getChannel_name();
                        ServiceLog.getLog().info((Object)msg);
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2));
                        continue;
                    }
                    if (session.getSessionState() != PassSession.SessionState.WAIT_CAR_LEAVE && session.getSessionState() != PassSession.SessionState.CAR_LEAVING || session.getReadPassportNumberEvent() == null || !passportNumber.equals(session.getReadPassportNumberEvent().getPassportNumber()) || mediaType != session.getReadPassportNumberEvent().getPassportMediumType()) continue;
                    sessionPassTime = (Date)session.getAttribute("passTime");
                    if (passTime != null) {
                        if (sessionPassTime != null && sessionPassTime.getTime() > passTime.getTime()) continue;
                        session.setSessionState(PassSession.SessionState.CAR_LEFT);
                        continue;
                    }
                    session.setSessionState(PassSession.SessionState.CAR_LEFT);
                }
            }
        }
    }

    @Override
    public void notifyOtherHostsHandling(String handlingChannelNo, String handlingPassportNumber, int handlingMediaType) {
        Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        if (hostMap == null) {
            return;
        }
        CarparkHost localHost = hostMap.get(ServiceUtil.getServiceContext().getLocalHostNo());
        if (localHost == null) {
            return;
        }
        final LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("handlingHostNo", localHost.getHost_no());
        paramMap.put("channelNo", handlingChannelNo);
        paramMap.put("passportNumber", handlingPassportNumber);
        paramMap.put("mediaType", String.valueOf(handlingMediaType));
        for (CarparkHost h : hostMap.values()) {
            if (localHost.getHost_no().equals(h.getHost_no()) || !ServiceUtil.getServiceContext().isConected(h.getHost_no())) continue;
            final String destHostNo = h.getHost_no();
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(destHostNo, true);
                        if (rpc == null) {
                            return;
                        }
                        CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
                        Map<String, Object> response = rpcService.otherHostsHandlingPass(paramMap, null);
                        if (!"0".equals(response.get("responseCode"))) {
                            ServiceLog.getLog().warn((Object)("\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5otherHostsHandlingPass\u9519\u8bef\uff1a" + response.get("responseMsg")));
                        }
                    }
                    catch (Throwable ex) {
                        Throwable ex1 = ServiceUtil.getRPCInvokeException(ex);
                        LogUtil.getLog().warn((Object)("\u8c03\u7528\u8fdc\u7a0b\u4e3b\u673a:" + destHostNo + ", \u8fdc\u7a0b\u65b9\u6cd5\uff1aotherHostsHandlingPass\u5f02\u5e38\uff01" + ex1.getMessage()));
                    }
                }
            });
        }
    }

    @Override
    public KeyValueEntry<CarparkPassport, KeyValueEntry<CarparkPassportType, CarparkPresenceRecord>> queryRechargeMutiTempRecord(CarparkPassport rechargePassport) {
        if (rechargePassport == null) {
            return null;
        }
        if (rechargePassport.getCar_owner_no() == null || rechargePassport.getCar_owner_no().length() == 0) {
            return null;
        }
        if (rechargePassport.getRegister_plate() == null || rechargePassport.getRegister_plate().length() == 0) {
            return null;
        }
        Date now = ServiceUtil.getNow();
        if (rechargePassport.getDeadline() == null || rechargePassport.getDeadline().after(now)) {
            return null;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        if (passportTypeMap == null) {
            return null;
        }
        CarparkPassportType rechargeType = passportTypeMap.get(rechargePassport.getPassport_type_no());
        if (rechargeType == null || rechargeType.getUse_muti_car() != 1) {
            return null;
        }
        if (rechargeType.getPass_type() != 2) {
            return null;
        }
        List passportList = commonDaoService.selectList(new SearchParam().addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()).addEQ("car_owner_no", (Object)rechargePassport.getCar_owner_no()), CarparkPassport.class, null);
        if (passportList == null || passportList.size() <= 1) {
            return null;
        }
        LinkedList<KeyValueEntry> templist = new LinkedList<KeyValueEntry>();
        LinkedList<KeyValueEntry> fixedlist = new LinkedList<KeyValueEntry>();
        boolean isTempFinded = false;
        boolean isFixtFinded = false;
        HashMap<String, String> platesMap = new HashMap<String, String>();
        HashMap<String, Boolean> validPassportTypes = new HashMap<String, Boolean>();
        for (CarparkPassport p : passportList) {
            CarparkPassportType pt;
            if (p.getRegister_plate() == null || p.getRegister_plate().length() == 0 || p.getMedium_type() != 6 || (pt = passportTypeMap.get(p.getPassport_type_no())) == null) continue;
            if (p.getPassport_state() == 2) {
                boolean isStop;
                boolean bl = isStop = p.getStop_date() != null && p.getStop_date().before(now);
                if (isStop) {
                    continue;
                }
            } else if (p.getPassport_state() != 0) continue;
            if (pt.getUse_muti_car() == null || pt.getUse_muti_car() != 1) continue;
            if (pt.getPass_type() == 2) {
                boolean isNotStart;
                boolean bl = isNotStart = p.getStart_date() != null && p.getStart_date().after(now);
                if (isNotStart) continue;
            }
            Boolean temp = null;
            if (pt.getPass_type() == 0) {
                temp = Boolean.TRUE;
            } else if (pt.getPass_type() == 2 || pt.getPass_type() == 4) {
                temp = Boolean.FALSE;
            }
            if (temp == null) continue;
            platesMap.put(p.getRegister_plate(), p.getPassport_no());
            validPassportTypes.put(pt.getPassport_type_no(), temp);
            KeyValueEntry e = new KeyValueEntry((Object)pt, (Object)p);
            if (temp.booleanValue()) {
                templist.add(e);
                if (isTempFinded || !p.getRegister_plate().equals(rechargePassport.getRegister_plate())) continue;
                isTempFinded = true;
                continue;
            }
            fixedlist.add(e);
            if (isFixtFinded || !p.getRegister_plate().equals(rechargePassport.getRegister_plate())) continue;
            isFixtFinded = true;
        }
        if (!templist.isEmpty() && !fixedlist.isEmpty() && (isFixtFinded || isTempFinded)) {
            Collections.sort(fixedlist, new Comparator<KeyValueEntry<CarparkPassportType, CarparkPassport>>(){
                Date now = new Date();

                @Override
                public int compare(KeyValueEntry<CarparkPassportType, CarparkPassport> o1, KeyValueEntry<CarparkPassportType, CarparkPassport> o2) {
                    if (((CarparkPassportType)o1.getKey()).getPass_type() == 4 && ((CarparkPassportType)o2.getKey()).getPass_type() == 4) {
                        return ((CarparkPassportType)o1.getKey()).getPassport_type_no().compareTo(((CarparkPassportType)o2.getKey()).getPassport_type_no());
                    }
                    if (((CarparkPassportType)o1.getKey()).getPass_type() == 4 && ((CarparkPassportType)o2.getKey()).getPass_type() != 4) {
                        return -1;
                    }
                    if (((CarparkPassportType)o1.getKey()).getPass_type() != 4 && ((CarparkPassportType)o2.getKey()).getPass_type() == 4) {
                        return 1;
                    }
                    if (((CarparkPassport)o1.getValue()).getStart_date() != null && ((CarparkPassport)o1.getValue()).getStart_date().after(this.now)) {
                        return 1;
                    }
                    if (((CarparkPassport)o2.getValue()).getStart_date() != null && ((CarparkPassport)o2.getValue()).getStart_date().after(this.now)) {
                        return -1;
                    }
                    if (((CarparkPassport)o1.getValue()).getDeadline() == null && ((CarparkPassport)o2.getValue()).getDeadline() == null) {
                        return ((CarparkPassport)o1.getValue()).getPassport_no().compareTo(((CarparkPassport)o2.getValue()).getPassport_no());
                    }
                    if (((CarparkPassport)o1.getValue()).getDeadline() != null && ((CarparkPassport)o2.getValue()).getDeadline() == null) {
                        return 1;
                    }
                    if (((CarparkPassport)o1.getValue()).getDeadline() == null && ((CarparkPassport)o2.getValue()).getDeadline() != null) {
                        return -1;
                    }
                    if (((CarparkPassport)o1.getValue()).getDeadline().after(((CarparkPassport)o2.getValue()).getDeadline())) {
                        return -1;
                    }
                    if (((CarparkPassport)o1.getValue()).getDeadline().before(((CarparkPassport)o2.getValue()).getDeadline())) {
                        return 1;
                    }
                    return 0;
                }
            });
            SearchParam searchParam = new SearchParam();
            searchParam.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
            searchParam.addEQ("car_owner_no", (Object)rechargePassport.getCar_owner_no());
            searchParam.addINList("enter_plate", platesMap.keySet());
            searchParam.addEQ("medium_type", (Object)6);
            searchParam.addEQ("area_level", (Object)1);
            searchParam.setWhereString("AND enter_time IS NOT NULL AND exit_time IS NULL");
            searchParam.setOrerbySql("enter_time");
            List prenseCarRecords = commonDaoService.selectList(searchParam, CarparkPresenceRecord.class, null);
            if (prenseCarRecords == null || prenseCarRecords.isEmpty()) {
                return null;
            }
            int fixCount = 0;
            for (KeyValueEntry entry : fixedlist) {
                if (((CarparkPassportType)entry.getKey()).getPass_type() == 4) {
                    ++fixCount;
                    continue;
                }
                if (((CarparkPassport)entry.getValue()).getDeadline() == null) {
                    ++fixCount;
                    continue;
                }
                if (!((CarparkPassport)entry.getValue()).getDeadline().after(now)) continue;
                ++fixCount;
            }
            for (CarparkPresenceRecord record : prenseCarRecords) {
                if (fixCount > 0) {
                    --fixCount;
                    continue;
                }
                CarparkPassport findPassport = null;
                CarparkPassportType findPassportType = null;
                for (CarparkPassport p : passportList) {
                    if (p.getRegister_plate() == null || !p.getRegister_plate().equals(record.getEnter_plate())) continue;
                    findPassport = p;
                    break;
                }
                if (findPassport == null) continue;
                findPassportType = (CarparkPassportType)((KeyValueEntry)templist.get(0)).getKey();
                return new KeyValueEntry((Object)findPassport, (Object)new KeyValueEntry((Object)findPassportType, (Object)record));
            }
        }
        return null;
    }
}

