/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.service.impl;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkChannelArea;
import com.wovoe.carpark.dto.CarparkChannelEquipment;
import com.wovoe.carpark.dto.CarparkChargeRule;
import com.wovoe.carpark.dto.CarparkChargeSegmentRule;
import com.wovoe.carpark.dto.CarparkChargeTimeLenRange;
import com.wovoe.carpark.dto.CarparkEquipment;
import com.wovoe.carpark.dto.CarparkEquipmentConfig;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.equipment.EquipmentDefinition;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentParameter;
import com.wovoe.carpark.equipment.ProductDrivers;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.BasicSettingService;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.Service;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.ibatis.session.SqlSession;

@Service(value="basicSettingService")
public class BasicSettingServiceImpl
implements BasicSettingService {
    @Override
    public List<CarparkArea> getCarparkAreaList() {
        return this.getCarparkAreaList(ServiceUtil.getServiceContext().getCarparkId(), ServiceUtil.getServiceContext().getProjectId(), (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class));
    }

    @Override
    public List<CarparkArea> getCarparkAreaList(Integer carparkId, Integer project_id, CommonDaoService commonDaoService) {
        List list = commonDaoService.selectList(new SearchParam().addEQ("carpark_id", (Object)carparkId).addEQ("project_id", (Object)project_id).setOrerbySql("area_level,id"), CarparkArea.class, null);
        if (list == null || list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (list.size() == 1) {
            return list;
        }
        HashMap<String, CarparkArea> areaMap = new HashMap<String, CarparkArea>();
        LinkedList<CarparkArea> arList = new LinkedList<CarparkArea>();
        for (CarparkArea area : list) {
            areaMap.put(area.getArea_no(), area);
            if (area.getArea_level() == 1) {
                arList.add(area);
                continue;
            }
            CarparkArea p = (CarparkArea)areaMap.get(area.getParent_area_no());
            if (p == null) continue;
            List<CarparkArea> ch = p.getChildren();
            if (ch == null) {
                ch = new LinkedList<CarparkArea>();
                p.setChildren(ch);
            }
            ch.add(area);
        }
        ArrayList<CarparkArea> returnList = new ArrayList<CarparkArea>();
        for (CarparkArea area : arList) {
            this.addAreaAndChildren(returnList, area);
        }
        return returnList;
    }

    private void addAreaAndChildren(List<CarparkArea> returnList, CarparkArea area) {
        if (area != null) {
            returnList.add(area);
            if (area.getChildren() != null) {
                for (CarparkArea a : area.getChildren()) {
                    this.addAreaAndChildren(returnList, a);
                }
            }
        }
    }

    @Override
    public int getAreaNumber(Integer carparkId, Integer project_id, CommonDaoService commonDaoService) {
        List list = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"area_number"}).addEQ("carpark_id", (Object)carparkId).addEQ("project_id", (Object)project_id), CarparkArea.class, null);
        HashSet<Integer> exist = new HashSet<Integer>();
        if (list != null) {
            for (CarparkArea a : list) {
                if (a.getArea_number() == null) continue;
                exist.add(a.getArea_number());
            }
        }
        int i = 1;
        while (i < 256) {
            if (!exist.contains(i)) {
                return i;
            }
            ++i;
        }
        return 1;
    }

    @Override
    public Map<CarparkArea, List<KeyValueEntry<CarparkChannel, Integer>>> getAreaChannelRelations(Integer carpark_id, Integer project_id, CommonDaoService commonDaoService) {
        LinkedHashMap<CarparkArea, List<KeyValueEntry<CarparkChannel, Integer>>> returnMap = new LinkedHashMap<CarparkArea, List<KeyValueEntry<CarparkChannel, Integer>>>();
        List<CarparkArea> arealist = this.getCarparkAreaList(carpark_id, project_id, commonDaoService);
        if (arealist == null || arealist.isEmpty()) {
            return returnMap;
        }
        List channelList = commonDaoService.selectList(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkChannel.class, null);
        List channelAreaList = null;
        if (channelList != null && !channelList.isEmpty()) {
            channelAreaList = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"channel_no", "area_no", "channel_direction"}).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).setOrerbySql("channel_no"), CarparkChannelArea.class, null);
        }
        if (channelAreaList == null || channelAreaList.isEmpty()) {
            for (CarparkArea area : arealist) {
                returnMap.put(area, Collections.emptyList());
            }
            return returnMap;
        }
        HashMap<String, CarparkChannel> chanelMap = new HashMap<String, CarparkChannel>();
        for (CarparkChannel c : channelList) {
            chanelMap.put(c.getChannel_no(), c);
        }
        HashMap<String, LinkedList<KeyValueEntry>> areaNoMap = new HashMap<String, LinkedList<KeyValueEntry>>();
        for (CarparkChannelArea ch : channelAreaList) {
            CarparkChannel c;
            if (ch.getArea_no() == null || ch.getChannel_direction() == null || ch.getChannel_no() == null || (c = (CarparkChannel)chanelMap.get(ch.getChannel_no())) == null) continue;
            LinkedList<KeyValueEntry> l = (LinkedList<KeyValueEntry>)areaNoMap.get(ch.getArea_no());
            if (l == null) {
                l = new LinkedList<KeyValueEntry>();
                areaNoMap.put(ch.getArea_no(), l);
            }
            l.add(new KeyValueEntry((Object)c, (Object)ch.getChannel_direction()));
        }
        for (CarparkArea area : arealist) {
            List l = (List)areaNoMap.get(area.getArea_no());
            if (l == null) {
                l = Collections.emptyList();
            }
            returnMap.put(area, l);
        }
        return returnMap;
    }

    @Override
    public int getChannelNumber(Integer carparkId, Integer project_id, CommonDaoService commonDaoService) {
        List list = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"channel_number"}).addEQ("carpark_id", (Object)carparkId).addEQ("project_id", (Object)project_id), CarparkChannel.class, null);
        HashSet<Integer> exist = new HashSet<Integer>();
        if (list != null) {
            for (CarparkChannel a : list) {
                if (a.getChannel_number() == null) continue;
                exist.add(a.getChannel_number());
            }
        }
        int i = 1;
        while (i < 256) {
            if (!exist.contains(i)) {
                return i;
            }
            ++i;
        }
        return 1;
    }

    @Override
    public Map<String, String> getAllEquipmentIpSetMap(Integer carpark_id, Integer project_id, CommonDaoService commonDaoService) {
        HashMap<String, String> set = new HashMap<String, String>();
        List list = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"equipment_no", "config_value"}).addEQ("config_key", (Object)"ip").addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkEquipmentConfig.class, null);
        if (list != null && !list.isEmpty()) {
            for (CarparkEquipmentConfig c : list) {
                if (c.getConfig_value() == null || c.getConfig_value().length() <= 0) continue;
                set.put(c.getConfig_value(), c.getEquipment_no());
            }
        }
        return set;
    }

    @Override
    public String getAvailableIp(Set<String> existIpSet, String basicIp) {
        String availableIp;
        if (existIpSet == null) {
            existIpSet = Collections.EMPTY_SET;
        }
        if ((availableIp = basicIp) != null && availableIp.length() > 0) {
            int h = availableIp.lastIndexOf(46);
            if (h == -1) {
                availableIp = null;
            } else {
                int lastIp;
                try {
                    lastIp = Integer.parseInt(availableIp.substring(h + 1));
                }
                catch (Exception e) {
                    lastIp = -1;
                }
                if (lastIp > 254 || lastIp < 1) {
                    availableIp = null;
                } else {
                    availableIp = availableIp.substring(0, h + 1);
                    int i = 1;
                    while (i <= 254) {
                        int lastIp0 = lastIp + i;
                        if (lastIp0 > 254 && (lastIp0 -= 254) < lastIp) {
                            lastIp0 = lastIp - lastIp0;
                        }
                        if (lastIp0 > 0 && lastIp0 < 255 && !existIpSet.contains(String.valueOf(availableIp) + lastIp0)) {
                            availableIp = String.valueOf(availableIp) + lastIp0;
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        return availableIp;
    }

    @Override
    public void insertDefaultChannelEquipments(Integer carpark_id, Integer project_id, String channelNo, CommonDaoService commonDaoService, SqlSession session, String basicIp, String productDriveName0) {
        List xli;
        String productName;
        if (productDriveName0 == null || productDriveName0.length() == 0 || !ProductDrivers.getProductDriverMap().containsKey(productDriveName0)) {
            productName = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("DEFAULT_DQ_TYPES");
            if (productName == null || productName.length() == 0) {
                productName = ProductDrivers.getDefaultProductName();
            } else if (!ProductDrivers.getProductDriverMap().containsKey(productName)) {
                productName = ProductDrivers.getDefaultProductName();
            }
        } else {
            productName = productDriveName0;
        }
        ProductDrivers.DriverName[] driverNames = ProductDrivers.getProductDriverMap().get(productName);
        if (driverNames == null) {
            driverNames = ServiceUtil.getFirstElement(ProductDrivers.getProductDriverMap().values());
        }
        if (driverNames == null || driverNames.length == 0) {
            return;
        }
        HashSet<String> allIpset = new HashSet<String>();
        List list = commonDaoService.selectList(session, new SearchParam().setQueryFields(new String[]{"config_value"}).addEQ("config_key", (Object)"ip").addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkEquipmentConfig.class, null);
        if (list != null && !list.isEmpty()) {
            for (CarparkEquipmentConfig c : list) {
                if (c.getConfig_value() == null || c.getConfig_value().length() <= 0) continue;
                allIpset.add(c.getConfig_value());
            }
        }
        if ((xli = commonDaoService.selectList(session, new SearchParam().setQueryFields(new String[]{"host_ip"}).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkHost.class, null)) != null && !xli.isEmpty()) {
            for (CarparkHost c : xli) {
                if (c.getHost_ip() == null || c.getHost_ip().length() <= 0) continue;
                allIpset.add(c.getHost_ip());
            }
        }
        allIpset.add(basicIp);
        ProductDrivers.DriverName[] driverNameArray = driverNames;
        int n = driverNames.length;
        int n2 = 0;
        while (n2 < n) {
            ProductDrivers.DriverName driverName = driverNameArray[n2];
            EquipmentDriver driver = ServiceUtil.getServiceContext().getEquipmentDriverManager().getByDrivrName(driverName.getName());
            if (driver != null) {
                this.insertDefaultChannelEquipments(carpark_id, project_id, new String[]{channelNo}, commonDaoService, session, driver, "", 1, allIpset, basicIp, driverName, productName);
            }
            ++n2;
        }
    }

    @Override
    public void insertDefaultChannelEquipments(Integer carpark_id, Integer project_id, String[] channelNos, CommonDaoService commonDaoService, SqlSession session, EquipmentDriver driver, String parentNo, int level, Set<String> allIpset, String basicIp, ProductDrivers.DriverName driverName, String productName) {
        EquipmentDefinition d = driver.getEquipmentDefinition();
        Date now = ServiceUtil.getNow();
        CarparkEquipment eq = new CarparkEquipment();
        eq.setId(commonDaoService.getSequece("ck_common_seq"));
        eq.setEquipment_no("C" + eq.getId());
        eq.setCarpark_id(carpark_id);
        eq.setCreated_time(now);
        eq.setDisable(0);
        eq.setEquipment_driver(driver.getName());
        eq.setEquipment_level(level);
        eq.setEquipment_manufacturer(driver.getSupplier());
        eq.setEquipment_model(null);
        List ll = commonDaoService.selectList(session, new SearchParam().setQueryFields(new String[]{"equipment_name"}).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("equipment_type", (Object)driver.getEquipmentType()), CarparkEquipment.class, null);
        if (ll == null || ll.isEmpty()) {
            eq.setEquipment_name(String.valueOf(d.getEquipmentTypeName()) + "01");
        } else {
            HashSet<String> hp = new HashSet<String>();
            for (CarparkEquipment c : ll) {
                hp.add(c.getEquipment_name());
            }
            String namex = null;
            int i = 1;
            while (i < 10000) {
                String vla = i < 10 ? String.valueOf(d.getEquipmentTypeName()) + "0" + i : String.valueOf(d.getEquipmentTypeName()) + i;
                if (!hp.contains(vla)) {
                    namex = vla;
                    break;
                }
                ++i;
            }
            if (namex == null) {
                namex = String.valueOf(d.getEquipmentTypeName()) + eq.getId();
            }
            eq.setEquipment_name(namex);
        }
        eq.setEquipment_serial_number(null);
        eq.setEquipment_type(driver.getEquipmentType());
        eq.setEquipment_use(d.getDefaultUse());
        eq.setLast_updated_time(now);
        eq.setProject_id(project_id);
        eq.setParent_equipment_no(parentNo);
        commonDaoService.insert(session, (Object)eq);
        if (channelNos != null && channelNos.length > 0) {
            String[] i = channelNos;
            int vla = channelNos.length;
            int namex = 0;
            while (namex < vla) {
                String channelNo = i[namex];
                CarparkChannelEquipment ec = new CarparkChannelEquipment();
                ec.setCarpark_id(carpark_id);
                ec.setChannel_no(channelNo);
                ec.setEquipment_no(eq.getEquipment_no());
                ec.setId(commonDaoService.getSequece("ck_common_seq"));
                ec.setLast_updated_time(now);
                ec.setProject_id(project_id);
                commonDaoService.insert(session, (Object)ec);
                ++namex;
            }
        }
        String static_voice_ver = "static_voice_ver";
        String htc_driver_name = "wovoe_hctls_screen_driver";
        String JX_ZK01 = "JX_ZK01";
        List<EquipmentParameter> pList = d.getParameterDefinition();
        if (pList != null && !pList.isEmpty()) {
            for (EquipmentParameter p : pList) {
                CarparkEquipmentConfig config;
                if (p.getParameterName() == null || p.getParameterName().length() == 0 || p.getUse() != -1 && (d.getUseInputType() != 0 ? !Constants.isContains(p.getUse(), d.getDefaultUse()) : p.getUse() != d.getDefaultUse())) continue;
                if (p.getParentParameterKey() == null || p.getParentParameterKey().length() == 0) {
                    if (p.getParameterDefaultValue() == null || p.getParameterDefaultValue().length() == 0) {
                        if (!"ip".equals(p.getParameterName())) continue;
                        String ip = this.getAvailableIp(allIpset, basicIp);
                        allIpset.add(ip);
                        config = new CarparkEquipmentConfig();
                        config.setCarpark_id(carpark_id);
                        config.setConfig_key(p.getParameterName());
                        config.setConfig_value(ip);
                        config.setEquipment_no(eq.getEquipment_no());
                        config.setId(commonDaoService.getSequece("ck_common_seq"));
                        config.setLast_updated_time(now);
                        config.setProject_id(project_id);
                        commonDaoService.insert(session, (Object)config);
                        continue;
                    }
                    CarparkEquipmentConfig config2 = new CarparkEquipmentConfig();
                    config2.setCarpark_id(carpark_id);
                    config2.setConfig_key(p.getParameterName());
                    if ("static_voice_ver".equals(p.getParameterName()) && "wovoe_hctls_screen_driver".equals(driver.getName())) {
                        if ("JX_ZK01".equals(productName)) {
                            config2.setConfig_value("2");
                        } else {
                            config2.setConfig_value(p.getParameterDefaultValue());
                        }
                    } else {
                        config2.setConfig_value(p.getParameterDefaultValue());
                    }
                    config2.setEquipment_no(eq.getEquipment_no());
                    config2.setId(commonDaoService.getSequece("ck_common_seq"));
                    config2.setLast_updated_time(now);
                    config2.setProject_id(project_id);
                    commonDaoService.insert(session, (Object)config2);
                    continue;
                }
                String pvalue = null;
                for (EquipmentParameter p1 : pList) {
                    if (!p.getParentParameterKey().equals(p1.getParameterName())) continue;
                    pvalue = p1.getParameterDefaultValue();
                    break;
                }
                if (pvalue == null || pvalue.length() <= 0 || !p.getParameterName().startsWith(String.valueOf(p.getParentParameterKey()) + pvalue) || p.getParameterDefaultValue() == null || p.getParameterDefaultValue().length() <= 0) continue;
                config = new CarparkEquipmentConfig();
                config.setCarpark_id(carpark_id);
                config.setConfig_key(p.getParameterName());
                config.setConfig_value(p.getParameterDefaultValue());
                config.setEquipment_no(eq.getEquipment_no());
                config.setId(commonDaoService.getSequece("ck_common_seq"));
                config.setLast_updated_time(now);
                config.setProject_id(project_id);
                commonDaoService.insert(session, (Object)config);
            }
        }
        if (driverName.getSubNames() != null && driverName.getSubNames().length > 0) {
            ProductDrivers.DriverName[] driverNameArray = driverName.getSubNames();
            int n = driverNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                EquipmentDefinition df;
                ProductDrivers.DriverName subname = driverNameArray[n2];
                EquipmentDriver a = ServiceUtil.getServiceContext().getEquipmentDriverManager().getByDrivrName(subname.getName());
                if (a != null && (df = a.getEquipmentDefinition()) != null && df.isSupportParentDriveName(driverName.getName())) {
                    this.insertDefaultChannelEquipments(carpark_id, project_id, channelNos, commonDaoService, session, a, eq.getEquipment_no(), level + 1, allIpset, basicIp, subname, productName);
                }
                ++n2;
            }
        }
    }

    @Override
    public List<CarparkChannel> getChannelListFromCache() {
        CarparkChannel c;
        Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
        if (channelMap == null || channelMap.isEmpty()) {
            return new LinkedList<CarparkChannel>();
        }
        PriorityQueue<CarparkChannel> queue = new PriorityQueue<CarparkChannel>(channelMap.size(), new Comparator<CarparkChannel>(){

            @Override
            public int compare(CarparkChannel o1, CarparkChannel o2) {
                return o1.getChannel_name().compareTo(o2.getChannel_name());
            }
        });
        for (CarparkChannel ch : channelMap.values()) {
            queue.offer(ch);
        }
        ArrayList<CarparkChannel> returnList = new ArrayList<CarparkChannel>(channelMap.size());
        while ((c = queue.poll()) != null) {
            returnList.add(c);
        }
        return returnList;
    }

    @Override
    public List<CarparkPassportType> getPassportTypeListFromCache() {
        CarparkPassportType c;
        Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        if (passportTypeMap == null || passportTypeMap.isEmpty()) {
            return new LinkedList<CarparkPassportType>();
        }
        PriorityQueue<CarparkPassportType> queue = new PriorityQueue<CarparkPassportType>(passportTypeMap.size(), new Comparator<CarparkPassportType>(){

            @Override
            public int compare(CarparkPassportType o1, CarparkPassportType o2) {
                int passTyp1 = o1.getPass_type();
                int passType2 = o2.getPass_type();
                if (passTyp1 == 1) {
                    passTyp1 = 2;
                } else if (passTyp1 == 2) {
                    passTyp1 = 1;
                } else if (passTyp1 == 0 && o1.getPassport_type_number() != 0) {
                    passTyp1 = 5;
                }
                if (passType2 == 1) {
                    passType2 = 2;
                } else if (passType2 == 2) {
                    passType2 = 1;
                } else if (passType2 == 0 && o2.getPassport_type_number() != 0) {
                    passType2 = 5;
                }
                int x = Integer.valueOf(passTyp1).compareTo(passType2);
                if (x == 0 && (x = o1.getPassport_type_number().compareTo(o2.getPassport_type_number())) == 0) {
                    x = o1.getId().compareTo(o2.getId());
                }
                return x;
            }
        });
        for (CarparkPassportType ch : passportTypeMap.values()) {
            queue.offer(ch);
        }
        ArrayList<CarparkPassportType> returnList = new ArrayList<CarparkPassportType>(passportTypeMap.size());
        while ((c = queue.poll()) != null) {
            returnList.add(c);
        }
        return returnList;
    }

    @Override
    public List<CarparkCarType> getCarTypeListFromCache() {
        CarparkCarType c;
        Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        if (carTypeMap == null || carTypeMap.isEmpty()) {
            return new LinkedList<CarparkCarType>();
        }
        PriorityQueue<CarparkCarType> queue = new PriorityQueue<CarparkCarType>(carTypeMap.size(), new Comparator<CarparkCarType>(){

            @Override
            public int compare(CarparkCarType o1, CarparkCarType o2) {
                int x = o1.getCar_type_number().compareTo(o2.getCar_type_number());
                if (x == 0) {
                    x = o1.getId().compareTo(o2.getId());
                }
                return x;
            }
        });
        for (CarparkCarType ch : carTypeMap.values()) {
            queue.offer(ch);
        }
        ArrayList<CarparkCarType> returnList = new ArrayList<CarparkCarType>(carTypeMap.size());
        while ((c = queue.poll()) != null) {
            returnList.add(c);
        }
        return returnList;
    }

    @Override
    public List<CarparkArea> getAreaListFromCache() {
        Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
        if (areaMap == null || areaMap.isEmpty()) {
            return new LinkedList<CarparkArea>();
        }
        ArrayList<CarparkArea> areaList = new ArrayList<CarparkArea>(areaMap.values());
        return areaList;
    }

    @Override
    public int deleteChargeRule(String area_no, String car_type_no, String passport_type_no, Integer carpark_id, Integer project_id, CommonDaoService commonDaoService, SqlSession session) {
        List chargeRuleList;
        if (area_no == null && car_type_no == null && passport_type_no == null) {
            return -1;
        }
        SearchParam param = new SearchParam(commonDaoService.getTableName(CarparkChargeRule.class)).setQueryFields(new String[]{"id", "charge_rule_no"}).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
        if (area_no != null) {
            param.addEQ("area_no", (Object)area_no);
        }
        if (car_type_no != null) {
            param.addEQ("car_type_no", (Object)car_type_no);
        }
        if (passport_type_no != null) {
            param.addEQ("passport_type_no", (Object)passport_type_no);
        }
        if ((chargeRuleList = commonDaoService.selectList(session, param, CarparkChargeRule.class, null)) == null || chargeRuleList.isEmpty()) {
            return 0;
        }
        ArrayList<String> charge_rule_nos = new ArrayList<String>(chargeRuleList.size());
        ArrayList<Long> ids = new ArrayList<Long>(chargeRuleList.size());
        for (CarparkChargeRule r : chargeRuleList) {
            charge_rule_nos.add(r.getCharge_rule_no());
            ids.add(r.getId());
        }
        SearchParam s1 = new SearchParam().setQueryFields(new String[]{"id", "charge_segment_rule_no"}).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
        if (charge_rule_nos.size() == 1) {
            s1.addEQ("charge_rule_no", charge_rule_nos.get(0));
        } else {
            s1.addINList("charge_rule_no", charge_rule_nos);
        }
        List segmentRuleList = commonDaoService.selectList(session, s1, CarparkChargeSegmentRule.class, null);
        if (segmentRuleList != null && !segmentRuleList.isEmpty()) {
            ArrayList<String> charge_segment_rule_nos = new ArrayList<String>(segmentRuleList.size());
            ArrayList<Long> segmentIds = new ArrayList<Long>();
            for (CarparkChargeSegmentRule r : segmentRuleList) {
                charge_segment_rule_nos.add(r.getCharge_segment_rule_no());
                segmentIds.add(r.getId());
            }
            commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkChargeTimeLenRange.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addINList("charge_segment_rule_no", charge_segment_rule_nos));
            commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkChargeSegmentRule.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addINList("id", segmentIds));
        }
        int count = commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkChargeRule.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addINList("id", ids));
        return count;
    }
}

