/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.service.impl;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.CarparkCommonService;
import com.wovoe.framework.ObjectCreateCallback;
import com.wovoe.framework.Service;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.KeyValue;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

@Service(value="carparkCommonService")
public class CarparkCommonServiceImpl
implements CarparkCommonService {
    @Override
    public List<Map<String, String>> queryParkingExceedCars(Date beginTime, Date endTime, Long beginMins, Long endMins, String plateNumber, boolean plateFuzzy, String araNo, String passTypeNo, String carTypeNo, String carOwnerName, String carOwnerAddress, Pagination pagination, ObjectCreateCallback<Map<String, String>> callback) {
        ArrayList<Map<String, String>> rList;
        if (beginTime == null || endTime == null || endTime.getTime() <= beginTime.getTime()) {
            rList = new ArrayList<Map<String, String>>(0);
            if (pagination != null) {
                pagination.setRecordsCount(0L);
                pagination.calculatePage();
            }
        } else {
            String car_owner_addr;
            String car_owner_name;
            String car_type_no;
            String passport_type_no;
            ParkingDurationA tempDuration;
            long parkingLengthSec;
            String tPlate;
            Date tExitTime;
            Date tEnterTime;
            List queyHisList;
            if (beginMins == null || beginMins.intValue() < 0) {
                beginMins = 0L;
            }
            if (endMins == null || endMins.intValue() < 0) {
                endMins = Integer.MAX_VALUE;
            }
            if (beginMins.intValue() >= endMins.intValue()) {
                ArrayList<Map<String, String>> rList2 = new ArrayList<Map<String, String>>(0);
                if (pagination != null) {
                    pagination.setRecordsCount(0L);
                    pagination.calculatePage();
                }
                return rList2;
            }
            long beginSecs = beginMins * 60L;
            long endSecs = endMins * 60L;
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            SearchParam sp = new SearchParam(daoService.getTableName(CarparkPassRecord.class)).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()).addGTE("pass_time", (Object)beginTime).addLTE("pass_time", (Object)endTime);
            if (plateNumber != null && plateNumber.length() > 0) {
                if (plateFuzzy) {
                    sp.addLike("pass_plate", plateNumber);
                } else {
                    sp.addEQ("pass_plate", (Object)plateNumber);
                }
            }
            if (araNo != null && araNo.length() > 0) {
                sp.addEQ("area_no", (Object)araNo);
            } else {
                sp.addEQ("area_level", (Object)1);
            }
            if (passTypeNo != null && passTypeNo.length() > 0) {
                sp.addEQ("passport_type_no", (Object)passTypeNo);
            }
            if (carTypeNo != null && carTypeNo.length() > 0) {
                sp.addEQ("exit_car_type_no", (Object)carTypeNo);
            }
            sp.addNotEQ("enter_time", null);
            sp.addNotEQ("exit_time", null);
            String idStr = "id";
            String pass_plateStr = "pass_plate";
            String enter_timeStr = "enter_time";
            String exit_timeStr = "exit_time";
            String passport_type_noStr = "passport_type_no";
            String exit_car_type_noStr = "exit_car_type_no";
            String carOwnerNameStr = "car_owner_name";
            String carOwnerAddressStr = "car_owner_addr";
            if (carOwnerName != null && carOwnerName.length() > 0) {
                sp.addLike(carOwnerNameStr, carOwnerName);
            }
            if (carOwnerAddress != null && carOwnerAddress.length() > 0) {
                sp.addLike(carOwnerAddressStr, carOwnerAddress);
            }
            sp.setQueryFields(new String[]{idStr, pass_plateStr, enter_timeStr, exit_timeStr, passport_type_noStr, exit_car_type_noStr, carOwnerNameStr, carOwnerAddressStr});
            sp.setOrder_by(String.valueOf(idStr) + " ASC");
            Pagination pg = new Pagination();
            int fetchSize = 2000;
            Long gtId = 0L;
            KeyValue gtIdKv = new KeyValue((Object)idStr, (Object)gtId);
            if (sp.getPropertysGT() == null) {
                sp.setPropertysGT(new ArrayList());
            }
            sp.getPropertysGT().add(gtIdKv);
            HashMap<String, ParkingDurationA> zMap = new HashMap<String, ParkingDurationA>();
            do {
                pg.resetParameters();
                pg.setNeedQueryCount(false);
                pg.setGotoPage(1);
                pg.setPageSize(2000);
                pg.setRecordsCount(2000L);
                gtIdKv.setValue((Object)gtId);
                queyHisList = daoService.selectList(sp, pg);
                if (queyHisList == null || queyHisList.isEmpty()) break;
                for (Map m : queyHisList) {
                    gtId = (Long)m.get(idStr);
                    tEnterTime = (Date)m.get(enter_timeStr);
                    tExitTime = (Date)m.get(exit_timeStr);
                    tPlate = (String)m.get(pass_plateStr);
                    if (tPlate == null || tPlate.length() <= 0 || tEnterTime == null || tExitTime == null || !tExitTime.after(tEnterTime)) continue;
                    parkingLengthSec = tEnterTime.before(beginTime) ? TimeUnit.MILLISECONDS.toSeconds(tExitTime.getTime() - beginTime.getTime()) : TimeUnit.MILLISECONDS.toSeconds(tExitTime.getTime() - tEnterTime.getTime());
                    tempDuration = (ParkingDurationA)zMap.get(tPlate);
                    if (tempDuration == null) {
                        tempDuration = new ParkingDurationA((int)parkingLengthSec, false);
                        zMap.put(tPlate, tempDuration);
                    } else {
                        ParkingDurationA parkingDurationA = tempDuration;
                        parkingDurationA.durationSec = parkingDurationA.durationSec + (int)parkingLengthSec;
                        ParkingDurationA parkingDurationA2 = tempDuration;
                        parkingDurationA2.parkingTimes = parkingDurationA2.parkingTimes + 1;
                    }
                    passport_type_no = (String)m.get(passport_type_noStr);
                    if (passport_type_no != null && passport_type_no.length() > 0) {
                        tempDuration.passport_type_no = passport_type_no;
                    }
                    if ((car_type_no = (String)m.get(exit_car_type_noStr)) != null && car_type_no.length() > 0) {
                        tempDuration.car_type_no = car_type_no;
                    }
                    if (araNo != null && araNo.length() > 0) {
                        tempDuration.area_no = araNo;
                    } else {
                        tempDuration.area_no = Constants.NO_STR;
                    }
                    car_owner_name = (String)m.get(carOwnerNameStr);
                    if (car_owner_name != null && car_owner_name.length() > 0) {
                        tempDuration.car_owner_name = car_owner_name;
                    }
                    if ((car_owner_addr = (String)m.get(carOwnerAddressStr)) == null || car_owner_addr.length() <= 0) continue;
                    tempDuration.car_owner_addr = car_owner_addr;
                }
            } while (queyHisList.size() >= 2000);
            sp = new SearchParam(daoService.getTableName(CarparkPresenceRecord.class)).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()).addLTE("enter_time", (Object)endTime);
            if (plateNumber != null && plateNumber.length() > 0) {
                if (plateFuzzy) {
                    sp.addLike("enter_plate", plateNumber);
                } else {
                    sp.addEQ("enter_plate", (Object)plateNumber);
                }
            }
            if (araNo != null && araNo.length() > 0) {
                sp.addEQ("area_no", (Object)araNo);
            } else {
                sp.addEQ("area_level", (Object)1);
            }
            if (passTypeNo != null && passTypeNo.length() > 0) {
                sp.addEQ("passport_type_no", (Object)passTypeNo);
            }
            if (carTypeNo != null && carTypeNo.length() > 0) {
                sp.addEQ("enter_car_type_no", (Object)carTypeNo);
            }
            if (carOwnerName != null && carOwnerName.length() > 0) {
                sp.addLike(carOwnerNameStr, carOwnerName);
            }
            if (carOwnerAddress != null && carOwnerAddress.length() > 0) {
                sp.addLike(carOwnerAddressStr, carOwnerAddress);
            }
            sp.setOrder_by("id ASC");
            gtId = 0L;
            gtIdKv.setValue((Object)gtId);
            if (sp.getPropertysGT() == null) {
                sp.setPropertysGT(new ArrayList());
            }
            sp.getPropertysGT().add(gtIdKv);
            String enterPlateStr = "enter_plate";
            String enter_car_type_noStr = "enter_car_type_no";
            sp.setQueryFields(new String[]{idStr, enterPlateStr, enter_timeStr, passport_type_noStr, enter_car_type_noStr, carOwnerNameStr, carOwnerAddressStr});
            do {
                pg.resetParameters();
                pg.setNeedQueryCount(false);
                pg.setGotoPage(1);
                pg.setPageSize(2000);
                pg.setRecordsCount(2000L);
                gtIdKv.setValue((Object)gtId);
                queyHisList = daoService.selectList(sp, pg);
                if (queyHisList == null || queyHisList.isEmpty()) break;
                for (Map m : queyHisList) {
                    gtId = (Long)m.get(idStr);
                    tEnterTime = (Date)m.get(enter_timeStr);
                    tPlate = (String)m.get(enterPlateStr);
                    tExitTime = endTime;
                    if (tPlate == null || tPlate.length() <= 0 || tEnterTime == null || !tEnterTime.before(tExitTime)) continue;
                    parkingLengthSec = tEnterTime.before(beginTime) ? TimeUnit.MILLISECONDS.toSeconds(tExitTime.getTime() - beginTime.getTime()) : TimeUnit.MILLISECONDS.toSeconds(tExitTime.getTime() - tEnterTime.getTime());
                    tempDuration = (ParkingDurationA)zMap.get(tPlate);
                    if (tempDuration == null) {
                        tempDuration = new ParkingDurationA((int)parkingLengthSec, true);
                        zMap.put(tPlate, tempDuration);
                    } else {
                        ParkingDurationA parkingDurationA = tempDuration;
                        parkingDurationA.durationSec = parkingDurationA.durationSec + (int)parkingLengthSec;
                        ParkingDurationA parkingDurationA3 = tempDuration;
                        parkingDurationA3.parkingTimes = parkingDurationA3.parkingTimes + 1;
                        tempDuration.in = true;
                    }
                    passport_type_no = (String)m.get(passport_type_noStr);
                    if (passport_type_no != null && passport_type_no.length() > 0) {
                        tempDuration.passport_type_no = passport_type_no;
                    }
                    if ((car_type_no = (String)m.get(enter_car_type_noStr)) != null && car_type_no.length() > 0) {
                        tempDuration.car_type_no = car_type_no;
                    }
                    if (araNo != null && araNo.length() > 0) {
                        tempDuration.area_no = araNo;
                    } else {
                        tempDuration.area_no = Constants.NO_STR;
                    }
                    car_owner_name = (String)m.get(carOwnerNameStr);
                    if (car_owner_name != null && car_owner_name.length() > 0) {
                        tempDuration.car_owner_name = car_owner_name;
                    }
                    if ((car_owner_addr = (String)m.get(carOwnerAddressStr)) == null || car_owner_addr.length() <= 0) continue;
                    tempDuration.car_owner_addr = car_owner_addr;
                }
            } while (queyHisList.size() >= 2000);
            TreeMap<String, ParkingDurationA> plateMap = new TreeMap<String, ParkingDurationA>();
            if (zMap != null && !zMap.isEmpty()) {
                for (Map.Entry entry : zMap.entrySet()) {
                    if ((long)((ParkingDurationA)entry.getValue()).durationSec <= beginSecs || (long)((ParkingDurationA)entry.getValue()).durationSec > endSecs) continue;
                    plateMap.put((String)entry.getKey(), (ParkingDurationA)entry.getValue());
                }
            }
            zMap = null;
            if (!plateMap.isEmpty()) {
                int offset = 0;
                int length = plateMap.size();
                if (pagination != null) {
                    pagination.setRecordsCount((long)plateMap.size());
                    pagination.calculatePage();
                    length = pagination.getLimitCount();
                    offset = pagination.getOffset();
                }
                if (length < 1) {
                    rList = new ArrayList(0);
                    if (pagination != null) {
                        pagination.setRecordsCount(0L);
                        pagination.calculatePage();
                    }
                } else {
                    rList = new ArrayList(callback == null ? length : 0);
                    int beginIndex = 0;
                    String str_plateNumber = "plateNumber";
                    String str_parkingTimes = "parkingTimes";
                    String str_parkingDuration = "parkingDuration";
                    String str_parkingDurationDes = "parkingDurationDes";
                    String str_parkingAraNo = "parkingAraNo";
                    String str_parkingAraName = "parkingAraName";
                    String str_currentParking = "currentParking";
                    String str_passportTypeNo = "passportTypeNo";
                    String str_passportTypeName = "passportTypeName";
                    String str_carTypeNo = "carTypeNo";
                    String str_carTypeName = "carTypeName";
                    String str_carIn = "carIn";
                    String str_carOwnerNameStr = "carOwnerName";
                    String str_carOwnerAddrStr = "carOwnerAddr";
                    Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
                    Map<String, CarparkPassportType> passTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                    Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
                    ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    String ParkingX = "\u8f66\u573a";
                    for (Map.Entry entry : plateMap.entrySet()) {
                        if (beginIndex >= offset) {
                            Object pt;
                            LinkedHashMap<String, String> rDataMap = new LinkedHashMap<String, String>();
                            rDataMap.put("plateNumber", (String)entry.getKey());
                            rDataMap.put("parkingTimes", String.valueOf(((ParkingDurationA)entry.getValue()).parkingTimes));
                            rDataMap.put("parkingDuration", String.valueOf(((ParkingDurationA)entry.getValue()).durationSec));
                            rDataMap.put("parkingDurationDes", appService.getTimeLenSecDes(((ParkingDurationA)entry.getValue()).durationSec));
                            rDataMap.put("parkingAraNo", ((ParkingDurationA)entry.getValue()).area_no);
                            if (((ParkingDurationA)entry.getValue()).area_no != null && ((ParkingDurationA)entry.getValue()).area_no.length() > 0) {
                                if (Constants.NO_STR.equals(((ParkingDurationA)entry.getValue()).area_no)) {
                                    rDataMap.put("parkingAraName", ParkingX);
                                } else {
                                    CarparkArea ara = areaMap.get(((ParkingDurationA)entry.getValue()).area_no);
                                    rDataMap.put("parkingAraName", ara == null ? "" : ara.getArea_name());
                                }
                            } else {
                                rDataMap.put("parkingAraName", "");
                            }
                            rDataMap.put("currentParking", ((ParkingDurationA)entry.getValue()).in ? Constants.YES_STR : Constants.NO_STR);
                            rDataMap.put("passportTypeNo", ((ParkingDurationA)entry.getValue()).passport_type_no);
                            if (((ParkingDurationA)entry.getValue()).passport_type_no != null && ((ParkingDurationA)entry.getValue()).passport_type_no.length() > 0) {
                                pt = passTypeMap.get(((ParkingDurationA)entry.getValue()).passport_type_no);
                                rDataMap.put("passportTypeName", pt == null ? "" : ((CarparkPassportType)pt).getPassport_type_name());
                            } else {
                                rDataMap.put("passportTypeName", "");
                            }
                            rDataMap.put("carTypeNo", ((ParkingDurationA)entry.getValue()).car_type_no);
                            if (((ParkingDurationA)entry.getValue()).car_type_no != null && ((ParkingDurationA)entry.getValue()).car_type_no.length() > 0) {
                                pt = carTypeMap.get(((ParkingDurationA)entry.getValue()).car_type_no);
                                rDataMap.put("carTypeName", pt == null ? "" : ((CarparkCarType)pt).getCar_type_name());
                            } else {
                                rDataMap.put("carTypeName", "");
                            }
                            rDataMap.put("carIn", ((ParkingDurationA)entry.getValue()).in ? Constants.YES_STR : Constants.NO_STR);
                            rDataMap.put("carOwnerName", ((ParkingDurationA)entry.getValue()).car_owner_name);
                            rDataMap.put("carOwnerAddr", ((ParkingDurationA)entry.getValue()).car_owner_addr);
                            if (callback != null) {
                                callback.createSuccess(rDataMap);
                            } else {
                                rList.add(rDataMap);
                            }
                            if (--length <= 0) break;
                        }
                        ++beginIndex;
                    }
                }
            } else {
                rList = new ArrayList(0);
                if (pagination != null) {
                    pagination.setRecordsCount(0L);
                    pagination.calculatePage();
                }
            }
        }
        return rList;
    }

    @Override
    public List<Map<String, Object>> queryParkingExceedCarDetail(Date beginTime, Date endTime, String plateNumber, String araNo, boolean querySubArea) {
        ArrayList<Map<String, Object>> rList = null;
        if (beginTime == null || endTime == null || endTime.getTime() <= beginTime.getTime() || plateNumber == null || plateNumber.length() == 0) {
            rList = new ArrayList<Map<String, Object>>(0);
        } else {
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            SearchParam sp = new SearchParam(daoService.getTableName(CarparkPassRecord.class)).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()).addGTE("pass_time", (Object)beginTime).addLTE("pass_time", (Object)endTime);
            sp.addEQ("pass_plate", (Object)plateNumber);
            if (araNo != null && araNo.length() > 0) {
                if (querySubArea) {
                    List<String> subList = ServiceUtil.getServiceContext().getDBConfigCache().getAllSbuArea(araNo);
                    if (subList != null && !subList.isEmpty()) {
                        sp.addIN("area_no", (Object)araNo);
                        sp.addINList("area_no", subList);
                    } else {
                        sp.addEQ("area_no", (Object)araNo);
                    }
                } else {
                    sp.addEQ("area_no", (Object)araNo);
                }
            } else if (!querySubArea) {
                sp.addEQ("area_level", (Object)1);
            }
            sp.addNotEQ("enter_time", null);
            sp.addNotEQ("exit_time", null);
            sp.setOrder_by("exit_time");
            String idStr = "id";
            String pass_plateStr = "pass_plate";
            String enter_timeStr = "enter_time";
            String exit_timeStr = "exit_time";
            String passport_type_nameStr = "passport_type_name";
            String area_nameStr = "area_name";
            sp.setQueryFields(new String[]{idStr, pass_plateStr, "enter_time", exit_timeStr, area_nameStr, passport_type_nameStr, "exit_car_type_name AS car_type_name", "enter_car_pic", "enter_plate_pic", "exit_car_pic", "exit_plate_pic"});
            List queyHisList = daoService.selectList(sp, null);
            String enterPlateStr = "enter_plate";
            sp = new SearchParam(daoService.getTableName(CarparkPresenceRecord.class)).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()).addLTE("enter_time", (Object)endTime);
            sp.addEQ(enterPlateStr, (Object)plateNumber);
            if (araNo != null && araNo.length() > 0) {
                if (querySubArea) {
                    List<String> subList = ServiceUtil.getServiceContext().getDBConfigCache().getAllSbuArea(araNo);
                    if (subList != null && !subList.isEmpty()) {
                        sp.addIN("area_no", (Object)araNo);
                        sp.addINList("area_no", subList);
                    } else {
                        sp.addEQ("area_no", (Object)araNo);
                    }
                } else {
                    sp.addEQ("area_no", (Object)araNo);
                }
            } else if (!querySubArea) {
                sp.addEQ("area_level", (Object)1);
            }
            sp.addNotEQ("enter_time", null);
            sp.addEQ("exit_time", null);
            sp.setOrder_by("enter_time");
            sp.setQueryFields(new String[]{idStr, "enter_plate AS pass_plate", "enter_time", exit_timeStr, area_nameStr, passport_type_nameStr, "enter_car_type_name AS car_type_name", "enter_car_pic", "enter_plate_pic", "exit_car_pic", "exit_plate_pic"});
            List queypList = daoService.selectList(sp, null);
            int totoalSize = (queyHisList == null ? 0 : queyHisList.size()) + (queypList == null ? 0 : queypList.size());
            if (totoalSize > 0) {
                int parkingLengthSec;
                String tPlate;
                Map<String, Object> m2;
                String str_parkingDuration = "parkingDuration";
                String str_parkingDurationDes = "parkingDurationDes";
                String str_q_parkingDuration = "q_parkingDuration";
                String str_q_parkingDurationDes = "q_parkingDurationDes";
                PriorityQueue<Map<String, Object>> pO = new PriorityQueue<Map<String, Object>>(totoalSize, new Comparator<Map<String, Object>>(){

                    @Override
                    public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                        return ((Date)o1.get("enter_time")).compareTo((Date)o2.get("enter_time"));
                    }
                });
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                if (queyHisList != null && !queyHisList.isEmpty()) {
                    for (Map<String, Object> m2 : queyHisList) {
                        Date tEnterTime = (Date)m2.get("enter_time");
                        Date tExitTime = (Date)m2.get(exit_timeStr);
                        tPlate = (String)m2.get(pass_plateStr);
                        if (tPlate == null || tPlate.length() <= 0 || tEnterTime == null || tExitTime == null || !tExitTime.after(tEnterTime)) continue;
                        pO.offer(m2);
                        parkingLengthSec = tEnterTime.before(beginTime) ? (int)TimeUnit.MILLISECONDS.toSeconds(tExitTime.getTime() - beginTime.getTime()) : (int)TimeUnit.MILLISECONDS.toSeconds(tExitTime.getTime() - tEnterTime.getTime());
                        m2.put("q_parkingDuration", parkingLengthSec);
                        m2.put("q_parkingDurationDes", appService.getTimeLenSecDes(parkingLengthSec));
                        parkingLengthSec = (int)TimeUnit.MILLISECONDS.toSeconds(tExitTime.getTime() - tEnterTime.getTime());
                        m2.put("parkingDuration", parkingLengthSec);
                        m2.put("parkingDurationDes", appService.getTimeLenSecDes(parkingLengthSec));
                    }
                }
                if (queypList != null && !queypList.isEmpty()) {
                    Date now = ServiceUtil.getNow();
                    for (Map m3 : queypList) {
                        Date tEnterTime = (Date)m3.get("enter_time");
                        tPlate = (String)m3.get(pass_plateStr);
                        Date tExitTime = endTime;
                        if (tPlate == null || tPlate.length() <= 0 || tEnterTime == null) continue;
                        pO.offer(m3);
                        parkingLengthSec = tEnterTime.before(beginTime) ? (int)TimeUnit.MILLISECONDS.toSeconds(tExitTime.getTime() - beginTime.getTime()) : (int)TimeUnit.MILLISECONDS.toSeconds(tExitTime.getTime() - tEnterTime.getTime());
                        m3.put("q_parkingDuration", parkingLengthSec);
                        m3.put("q_parkingDurationDes", appService.getTimeLenSecDes(parkingLengthSec));
                        tExitTime = now;
                        parkingLengthSec = (int)TimeUnit.MILLISECONDS.toSeconds(tExitTime.getTime() - tEnterTime.getTime());
                        m3.put("parkingDuration", parkingLengthSec);
                        m3.put("parkingDurationDes", appService.getTimeLenSecDes(parkingLengthSec));
                    }
                }
                rList = new ArrayList(pO.size());
                while ((m2 = pO.poll()) != null) {
                    rList.add(m2);
                }
            } else {
                rList = new ArrayList(0);
            }
        }
        return rList;
    }

    private static class ParkingDurationA {
        private int durationSec;
        private boolean in;
        private int parkingTimes;
        private String passport_type_no = "";
        private String area_no = "";
        private String car_type_no = "";
        private String car_owner_name = "";
        private String car_owner_addr = "";

        ParkingDurationA(int durationSec, boolean in) {
            this.durationSec = durationSec;
            this.in = in;
            this.parkingTimes = 1;
        }
    }
}

