/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.service.impl;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.ParkingSpace;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.cloud.client.HostSate;
import com.wovoe.carpark.conn.udp.net.LanPassChannelHandleAction;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkEscapeOrder;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.action.CarChannelDisplayAction;
import com.wovoe.carpark.equipment.action.DynLoudspeakerAction;
import com.wovoe.carpark.equipment.action.LoudspeakerAction;
import com.wovoe.carpark.equipment.action.ParkingSpaceDisplayAction;
import com.wovoe.carpark.equipment.action.ParkingSpaceScreenAction;
import com.wovoe.carpark.equipment.action.StaticLoudSpeakerServiceAction;
import com.wovoe.carpark.equipment.driver.DnctChannelDisplayAction;
import com.wovoe.carpark.equipment.driver.EQScreenAction;
import com.wovoe.carpark.equipment.driver.H2DisplayAction;
import com.wovoe.carpark.equipment.driver.WlykLaneDisplayAction;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.DisplayVoiceService;
import com.wovoe.carpark.vo.ParingSpaceVo;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.Service;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@Service
public class DisplayVoiceServiceImpl
implements DisplayVoiceService {
    private void logErr(OperationFuture<Integer> f, final String channelName, final Equipment eq, final String Op) {
        if (f == null) {
            return;
        }
        f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void waitCompleteTimeout() {
                ServiceLog.getLog().warn((Object)(String.valueOf(channelName) + ":" + eq.getName() + "," + Op + "\u8d85\u65f6!"));
            }

            public void operationComplete(OperationFuture<Integer> fu) {
                if (fu.getException() != null) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(channelName) + ":" + eq.getName() + "," + Op + "\u5931\u8d25! \u539f\u56e0:" + fu.getException().getMessage()));
                } else if (fu.getResult() == null) {
                    this.waitCompleteTimeout();
                } else if ((Integer)fu.getResult() != 0) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(channelName) + ":" + eq.getName() + "," + Op + "\u5931\u8d25! \u9519\u8bef\u4ee3\u7801\uff1a" + fu.getResult()));
                }
            }
        });
    }

    private String getCarparkUnManUrl(String channelNo) {
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config != null && config.getHost_use() == 1 && config.getNet_mode() == 2 && config.getCarpark_deploy_type() == 1) {
            return this.getUnManUrl(channelNo);
        }
        if (channelNo == null || channelNo.length() == 0) {
            return null;
        }
        String pk = ServiceUtil.getServiceContext().getCarpark().getCloud_carpark_id();
        if (pk == null || pk.length() == 0) {
            return null;
        }
        byte[] cNo = channelNo.getBytes();
        byte[] dataB = new byte[9 + cNo.length];
        int offset = 0;
        dataB[offset++] = 87;
        long mills = System.currentTimeMillis() + 1800000L;
        byte[] timeMills = BytesTool.LongToBytes((long)mills);
        System.arraycopy(timeMills, 0, dataB, offset, timeMills.length);
        System.arraycopy(cNo, 0, dataB, offset += timeMills.length, cNo.length);
        String x = BytesTool.compressBytes((byte[])dataB);
        String host = ServiceUtil.getCloudPayDomain();
        return String.valueOf("cloud.wlyk.com".equals(host) ? "https://" : "http://") + host + "/core/p/u.do?pk=" + pk + "&cl=" + x;
    }

    @Override
    public void playWhenNoplate(PassChannel passChannel) {
        List<Equipment> displayList;
        ChannelArea channelArea;
        String text1 = "\u672a\u68c0\u6d4b\u5230\u8f66\u724c";
        String text2 = null;
        Boolean enter = null;
        if (ServiceUtil.getServiceContext().getDBConfigCache().isSupportSelfOnlinePay() && ServiceUtil.getServiceContext().isConnectedCloud() && (channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(passChannel.getChannelNo())) != null) {
            if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                text2 = "\u60a8\u53ef\u4ee5\u4f7f\u7528\u5fae\u4fe1\u6216\u652f\u4ed8\u5b9d\u626b\u7801\u5165\u573a";
                enter = Boolean.TRUE;
            } else if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                text2 = "\u60a8\u53ef\u4ee5\u4f7f\u7528\u5fae\u4fe1\u6216\u652f\u4ed8\u5b9d\u626b\u7801\u79bb\u573a";
                enter = Boolean.FALSE;
            }
        }
        if ((displayList = passChannel.getEquipmentList(10)) != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                OperationFuture<Integer> f;
                if (eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                int dispaySecs = 0;
                String[] displayLines = null;
                if (action instanceof CarChannelDisplayAction) {
                    CarChannelDisplayAction disPlayAction = (CarChannelDisplayAction)action;
                    String qrCodeUrl = null;
                    if (enter != null) {
                        int qrType = disPlayAction.getDisplayQrCodeType();
                        if (qrType == 1) {
                            qrCodeUrl = this.getCarparkUnManUrl(passChannel.getChannelNo());
                            if (qrCodeUrl == null || qrCodeUrl.length() <= 0 || !qrCodeUrl.startsWith("http://") && !qrCodeUrl.startsWith("https://")) {
                                qrCodeUrl = null;
                            }
                        } else if (qrType == 2 && ((qrCodeUrl = disPlayAction.getDisplayStaticQrCodeContent()) == null || qrCodeUrl.length() <= 0 || "0".equals(qrCodeUrl))) {
                            qrCodeUrl = null;
                        }
                    }
                    if (enter != null && qrCodeUrl != null && qrCodeUrl.length() > 0) {
                        String txt = enter != false ? "\u626b\u7801\u5165\u573a" : "\u626b\u7801\u79bb\u573a";
                        if (disPlayAction instanceof H2DisplayAction) {
                            dispaySecs = 300;
                            displayLines = new String[]{"\u65e0\u724c\u8f66", "\u8bf7" + txt};
                            f = disPlayAction.display(dispaySecs, displayLines);
                            this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + text1);
                        }
                        f = disPlayAction.displayQrCode(300, qrCodeUrl, txt);
                        this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a\u4e8c\u7ef4\u7801" + txt);
                    } else {
                        int displayCount = disPlayAction.getDisplayCount();
                        dispaySecs = 30;
                        displayLines = displayCount == 1 ? new String[]{text1} : (text2 != null && text2.length() > 0 ? new String[]{text1, text2} : new String[]{text1});
                        f = disPlayAction.display(dispaySecs, displayLines);
                        this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + text1);
                    }
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_playWhenNoplate(passChannel)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = text1;
                if (text2 != null && text2.length() > 0) {
                    v = String.valueOf(v) + "," + text2;
                }
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    @Override
    public void notDetectedCar(PassChannel passChannel) {
        String text1 = "\u672a\u68c0\u6d4b\u5230\u8f66\u8f86";
        List<Equipment> displayList = passChannel.getEquipmentList(10);
        if (displayList != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                if (eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    CarChannelDisplayAction disPlayAction = (CarChannelDisplayAction)action;
                    OperationFuture<Integer> f = disPlayAction.display(10, new String[]{text1});
                    this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + text1);
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_notDetectedCar(passChannel)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = text1;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    private boolean isSwipeCard(PassSession session) {
        return session.getPassChannel().isSwipeCard(session);
    }

    @Override
    public void unRegisterCard(PassSession session) {
        List<Equipment> displayList;
        PassChannel passChannel = session.getPassChannel();
        String text2 = "\u65e0\u6548\u5361,\u672a\u6ce8\u518c";
        String text3 = null;
        ChannelArea channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(passChannel.getChannelNo());
        if (channelArea != null) {
            if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                text3 = "\u7981\u6b62\u5165\u573a";
            } else if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                text3 = "\u7981\u6b62\u79bb\u573a";
            }
        }
        if (text3 == null) {
            text3 = "\u7981\u6b62\u901a\u884c";
        }
        if ((displayList = this.getDisplayAndVoiceEqList(session)) != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    this.displayLines((CarChannelDisplayAction)action, null, text2, text3, passChannel.getChannel().getChannel_name());
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_unRegisterCard(session)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = text2;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    @Override
    public void monthCardNotStarted(PassSession session) {
        List<Equipment> displayList;
        PassChannel passChannel = session.getPassChannel();
        String text2 = "\u6708\u5361\u672a\u542f\u7528";
        String text3 = null;
        ChannelArea channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(passChannel.getChannelNo());
        if (channelArea != null) {
            if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                text3 = "\u7981\u6b62\u5165\u573a";
            } else if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                text3 = "\u7981\u6b62\u79bb\u573a";
            }
        }
        if (text3 == null) {
            text3 = "\u7981\u6b62\u901a\u884c";
        }
        if ((displayList = this.getDisplayAndVoiceEqList(session)) != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                LoudspeakerAction lo;
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    this.displayLines((CarChannelDisplayAction)action, null, text2, text3, passChannel.getChannel().getChannel_name());
                }
                if (!(action instanceof LoudspeakerAction) || (lo = (LoudspeakerAction)action).getCarparkLoudspeakerAction() != null || lo.getDynLoudspeakerAction() == null) continue;
                String v = text2;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    @Override
    public void monthCardStopped(PassSession session) {
        List<Equipment> displayList;
        PassChannel passChannel = session.getPassChannel();
        String text2 = "\u6708\u5361\u5df2\u505c\u7528";
        String text3 = null;
        ChannelArea channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(passChannel.getChannelNo());
        if (channelArea != null) {
            if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                text3 = "\u7981\u6b62\u5165\u573a";
            } else if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                text3 = "\u7981\u6b62\u79bb\u573a";
            }
        }
        if (text3 == null) {
            text3 = "\u7981\u6b62\u901a\u884c";
        }
        if ((displayList = this.getDisplayAndVoiceEqList(session)) != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                LoudspeakerAction lo;
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    this.displayLines((CarChannelDisplayAction)action, null, text2, text3, passChannel.getChannel().getChannel_name());
                }
                if (!(action instanceof LoudspeakerAction) || (lo = (LoudspeakerAction)action).getCarparkLoudspeakerAction() != null || lo.getDynLoudspeakerAction() == null) continue;
                String v = text2;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    @Override
    public void blacklistCar(PassSession session) {
        List<Equipment> displayList;
        PassChannel passChannel = session.getPassChannel();
        String text1 = session.getPassPlate();
        String text2 = "\u9ed1\u540d\u5355\u8f66";
        if (this.isSwipeCard(session)) {
            text2 = "\u9ed1\u540d\u5355\u5361";
        }
        String text3 = null;
        ChannelArea channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(passChannel.getChannelNo());
        if (channelArea != null) {
            if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                text3 = "\u7981\u6b62\u5165\u573a";
            } else if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                text3 = "\u7981\u6b62\u79bb\u573a";
            }
        }
        if (text3 == null) {
            text3 = "\u7981\u6b62\u901a\u884c";
        }
        if ((displayList = this.getDisplayAndVoiceEqList(session)) != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    this.displayLines((CarChannelDisplayAction)action, text1, text2, text3, passChannel.getChannel().getChannel_name());
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_blacklistCar(session)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = String.valueOf(text2) + "," + text3;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    @Override
    public void forbidPass(PassSession session) {
        List<Equipment> displayList;
        List existMutiCarEnterRecords;
        PassChannel passChannel = session.getPassChannel();
        String text1 = session.getPassPlate();
        if (text1 == null) {
            text1 = "";
        }
        String text2 = null;
        CarparkPassportType t = session.getPassportType();
        text2 = t != null ? t.getPassport_type_name() : "";
        String text3 = null;
        ChannelArea channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(passChannel.getChannelNo());
        if (channelArea != null) {
            if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                text3 = "\u7981\u6b62\u5165\u573a";
            } else if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                text3 = "\u7981\u6b62\u79bb\u573a";
            }
        }
        if (text3 == null) {
            text3 = "\u7981\u6b62\u901a\u884c";
        }
        String text4 = null;
        if (session.getPassportType().getPass_type() == 0 && session.getPassportType().getUse_muti_car() == 1 && session.getPassport().getRegister_plate() != null && session.getPassport().getRegister_plate().length() > 0 && (existMutiCarEnterRecords = (List)session.getAttribute("existMutiCarEnterRecords")) != null && !existMutiCarEnterRecords.isEmpty()) {
            String v;
            CarparkPresenceRecord precord = null;
            for (CarparkPresenceRecord r : existMutiCarEnterRecords) {
                if (r.getEnter_plate() == null || r.getEnter_plate().length() <= 0 || r.getExit_time() != null || r.getEnter_time() == null || r.getEnter_plate().equals(session.getPassport().getRegister_plate())) continue;
                precord = r;
                break;
            }
            if (precord != null && (v = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(session.getPassChannel().getChannelNo(), "CHANNEL_ENTER_TIP_MUTICAR")) != null && "1".equals(v)) {
                Integer a = (Integer)session.getAttribute("EXIST_MUTI_CAR_COUNT");
                if (a == null || a < 1) {
                    a = 1;
                }
                text4 = a == 1 ? String.valueOf(precord.getEnter_plate()) + ",\u5df2\u5165\u573a" : String.valueOf(precord.getEnter_plate()) + ",\u7b49\u4e00\u5171" + a + "\u8f86\u8f66\u5df2\u5165\u573a";
            }
        }
        if ((displayList = this.getDisplayAndVoiceEqList(session)) != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                OperationFuture<Integer> f;
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    String v2;
                    String v1;
                    String[] playTexts;
                    CarChannelDisplayAction disPlayAction = (CarChannelDisplayAction)action;
                    int displayCount = disPlayAction.getDisplayCount();
                    if (displayCount == 1) {
                        String v = text1 != null && text1.length() > 0 ? String.valueOf(text1) + "," + text2 + "," + text3 : String.valueOf(text2) + "," + text3;
                        if (text4 != null) {
                            v = String.valueOf(v) + "," + text4;
                        }
                        playTexts = new String[]{v};
                    } else if (displayCount == 2) {
                        if (text4 != null) {
                            v1 = text1 != null && text1.length() > 0 ? String.valueOf(text1) + "," + text2 : text2;
                            v2 = String.valueOf(text3) + "," + text4;
                        } else if (text1 != null && text1.length() > 0) {
                            v1 = text1;
                            v2 = String.valueOf(text2) + "," + text3;
                        } else {
                            v1 = text2;
                            v2 = text3;
                        }
                        playTexts = new String[]{v1, v2};
                    } else {
                        String v3;
                        String v4 = null;
                        if (text4 != null) {
                            if (text1 != null && text1.length() > 0) {
                                if (displayCount == 3) {
                                    v1 = text1;
                                    v2 = String.valueOf(text2) + "," + text3;
                                    v3 = text4;
                                } else {
                                    v1 = text1;
                                    v2 = text2;
                                    v3 = text3;
                                    v4 = text4;
                                }
                            } else {
                                v1 = text2;
                                v2 = text3;
                                v3 = text4;
                            }
                        } else if (text1 != null && text1.length() > 0) {
                            v1 = text1;
                            v2 = text2;
                            v3 = text3;
                        } else {
                            v1 = text2;
                            v2 = text3;
                            v3 = null;
                        }
                        playTexts = displayCount == 3 ? new String[]{v1, v2, v3} : new String[]{v1, v2, v3, v4};
                    }
                    f = disPlayAction.display(30, playTexts);
                    this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a: \u7981\u6b62\u901a\u884c");
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_forbidPass(session)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = text4 != null ? String.valueOf(text4) + "," : "";
                if (session.getPassPlate() != null && session.getPassPlate().length() > 0) {
                    v = String.valueOf(v) + session.getPassPlate() + "," + text2 + "," + text3;
                }
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    @Override
    public void noPermissionPass(PassSession session) {
        List<Equipment> displayList;
        PassChannel passChannel = session.getPassChannel();
        String text1 = session.getPassPlate();
        String text2 = null;
        CarparkPassportType t = session.getPassportType();
        text2 = t != null ? t.getPassport_type_name() : "";
        String text3 = (String)session.getAttribute("tipnoPermissionPassDetail");
        if (text3 == null || text3.length() == 0) {
            text3 = "\u672a\u6388\u6743";
        }
        if ((displayList = this.getDisplayAndVoiceEqList(session)) != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    this.displayLines((CarChannelDisplayAction)action, text1, text2, text3, passChannel.getChannel().getChannel_name());
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_noPermissionPass(session)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = String.valueOf(text2) + "," + text3;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    @Override
    public void repeatEnter(PassSession session) {
        PassChannel passChannel = session.getPassChannel();
        String text1 = session.getPassPlate();
        String plate = null;
        if (text1 == null || text1.length() == 0) {
            text1 = "";
        } else {
            plate = text1;
        }
        String text2 = null;
        CarparkPassportType t = session.getPassportType();
        text2 = t != null ? t.getPassport_type_name() : "";
        String text3 = "\u91cd\u590d\u5165\u573a";
        List<Equipment> displayList = this.getDisplayAndVoiceEqList(session);
        if (displayList != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    this.displayLines((CarChannelDisplayAction)action, text1, text2, text3, passChannel.getChannel().getChannel_name());
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_repeatEnter(session)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = String.valueOf(plate == null ? text2 : this.getDynPlate(plate, action instanceof WlykLaneDisplayAction)) + "," + text3;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    private String getDynPlate(String plate, boolean addblank) {
        if (plate == null) {
            return null;
        }
        if (plate.length() == 0) {
            return plate;
        }
        if (plate.startsWith("WJ")) {
            plate = "\u6b66\u8b66" + plate.substring(2);
        }
        if (addblank) {
            StringBuilder sbr = new StringBuilder(32);
            char blank = ' ';
            int i = 0;
            while (i < plate.length()) {
                if (i > 0) {
                    sbr.append(blank);
                }
                sbr.append(plate.charAt(i));
                ++i;
            }
            plate = sbr.toString();
        }
        return plate;
    }

    @Override
    public void enterRecordNotFount(PassSession session) {
        List<Equipment> displayList;
        PassChannel passChannel = session.getPassChannel();
        String text1 = session.getPassPlate();
        String plate = null;
        if (text1 == null || text1.length() == 0) {
            text1 = "";
        } else {
            plate = text1;
        }
        String text2 = null;
        CarparkPassportType t = session.getPassportType();
        text2 = t != null ? t.getPassport_type_name() : "";
        String text3 = "\u672a\u627e\u5230\u5165\u573a\u8f66\u724c";
        if (this.isSwipeCard(session)) {
            text3 = "\u5361\u672a\u5165\u573a";
        }
        if ((displayList = this.getDisplayAndVoiceEqList(session)) != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    this.displayLines((CarChannelDisplayAction)action, text1, text2, text3, passChannel.getChannel().getChannel_name());
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_enterRecordNotFount(session)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = String.valueOf(plate == null ? text2 : this.getDynPlate(plate, action instanceof WlykLaneDisplayAction)) + "," + text3;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    @Override
    public void dateExpired(PassSession session) {
        PassChannel passChannel = session.getPassChannel();
        String text1 = session.getPassPlate();
        if (text1 == null || text1.length() == 0) {
            text1 = "\u672a\u68c0\u6d4b\u5230\u8f66\u724c";
        }
        String text2 = null;
        CarparkPassportType t = session.getPassportType();
        text2 = t != null ? t.getPassport_type_name() : "";
        String text3 = session.getForbidPassExceptions().contains(7) ? "\u672a\u542f\u7528" : (session.getForbidPassExceptions().contains(8) ? "\u5df2\u505c\u7528" : "\u5df2\u8fc7\u671f");
        List<Equipment> displayList = this.getDisplayAndVoiceEqList(session);
        if (displayList != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    this.displayLines((CarChannelDisplayAction)action, text1, text2, text3, passChannel.getChannel().getChannel_name());
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_dateExpired(session)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = String.valueOf(text2) + "," + text3;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    private void parkingTaked(PassSession session, Set<String> plateSet) {
        PassChannel passChannel = session.getPassChannel();
        String text1 = "\u8f66\u8f86" + plateSet + "\u5df2\u5728\u573a\u5185";
        String text2 = session.getPassPlate();
        String text3 = "\u7981\u6b62\u901a\u884c";
        List<Equipment> displayList = this.getDisplayAndVoiceEqList(session);
        if (displayList != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                OperationFuture<Integer> f;
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    CarChannelDisplayAction disPlayAction = (CarChannelDisplayAction)action;
                    int count = disPlayAction.getDisplayCount();
                    String[] playTexts = count == 1 ? new String[]{text1} : (count == 2 ? new String[]{text1, String.valueOf(text2) + "," + text3} : new String[]{text1, text2, text3});
                    f = disPlayAction.display(30, playTexts);
                    this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a: " + text1 + "," + text2 + "," + text3);
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_parkingTaked(session)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = String.valueOf(text2) + "," + text3;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    @Override
    public void parkingFull(PassSession session) {
        if (session.getAttribute("TAKE_SPASE_PLATE_SET") != null) {
            this.parkingTaked(session, (Set)session.getAttribute("TAKE_SPASE_PLATE_SET"));
        } else {
            PassChannel passChannel = session.getPassChannel();
            String text1 = session.getPassPlate();
            if (text1 == null || text1.length() == 0) {
                text1 = "\u672a\u68c0\u6d4b\u5230\u8f66\u724c";
            }
            String text2 = null;
            CarparkPassportType t = session.getPassportType();
            text2 = t != null ? t.getPassport_type_name() : "";
            String text3 = "\u8f66\u4f4d\u5df2\u6ee1";
            List<Equipment> displayList = this.getDisplayAndVoiceEqList(session);
            if (displayList != null && !displayList.isEmpty()) {
                for (Equipment eq : displayList) {
                    if (eq.getType() == 10 && eq.getUse() != 1) continue;
                    Object action = eq.getEquipmentAction();
                    if (action instanceof CarChannelDisplayAction) {
                        this.displayLines((CarChannelDisplayAction)action, text1, text2, text3, passChannel.getChannel().getChannel_name());
                    }
                    if (!(action instanceof LoudspeakerAction)) continue;
                    LoudspeakerAction lo = (LoudspeakerAction)action;
                    if (lo.getCarparkLoudspeakerAction() != null) {
                        byte[] sB;
                        StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                        if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_parkingFull(session)) == null || sB.length <= 0) continue;
                        lo.getCarparkLoudspeakerAction().play(sB);
                        continue;
                    }
                    if (lo.getDynLoudspeakerAction() == null) continue;
                    String v = String.valueOf(text2) + "," + text3;
                    DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                    OperationFuture<Integer> f = d.play(v);
                    this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
                }
            }
        }
    }

    private List<Equipment> getDisplayAndVoiceEqList(PassSession session) {
        Equipment eq;
        List<Equipment> displayList = session.getPassChannel().getEquipmentList(10);
        if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().getDetectedPassEvent() != null && session.getReadPassportNumberEvent().getDetectedPassEvent().getSource() instanceof Equipment && (eq = (Equipment)session.getReadPassportNumberEvent().getDetectedPassEvent().getSource()).getType() != 10 && eq.getEquipmentAction() instanceof LoudspeakerAction) {
            if (displayList == null || displayList.isEmpty()) {
                displayList = new LinkedList<Equipment>();
            }
            displayList.add(eq);
        }
        return displayList;
    }

    @Override
    public void parkingFullQueue(PassSession session) {
        PassChannel passChannel = session.getPassChannel();
        String text1 = session.getPassPlate();
        if (text1 == null || text1.length() == 0) {
            text1 = "\u672a\u68c0\u6d4b\u5230\u8f66\u724c";
        }
        String text2 = null;
        CarparkPassportType t = session.getPassportType();
        text2 = t != null ? t.getPassport_type_name() : "";
        String text3 = "\u8f66\u4f4d\u5df2\u6ee1,\u8bf7\u7b49\u5f85";
        List<Equipment> displayList = this.getDisplayAndVoiceEqList(session);
        if (displayList != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    this.displayLines((CarChannelDisplayAction)action, text1, text2, text3, passChannel.getChannel().getChannel_name());
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_parkingFullQueue(session)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = String.valueOf(text2) + "," + text3;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    private void playSuccessEnter(PassSession session) {
        List<Equipment> displayList;
        List existMutiCarEnterRecords;
        String v;
        String plate;
        String playPlateTypeDefine;
        String passTipMonthDurationOut = null;
        String passTipMonthDurationIn = null;
        String passPlayMonthDurationVoice = null;
        Map<?, ?> passTipMonthDurationInfo = this.getPassTipMonthDurationInfo(session);
        if (passTipMonthDurationInfo != null) {
            passTipMonthDurationOut = this.getPassTipMonthDurationOut(passTipMonthDurationInfo);
            passTipMonthDurationIn = this.getPassTipMonthDurationIn(passTipMonthDurationInfo);
            passPlayMonthDurationVoice = this.getPassPlayMonthDurationVoice(passTipMonthDurationInfo);
        }
        boolean isNeedPlayPlate = true;
        boolean isNeedPlayPlateType = true;
        String playPlateDefine = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(session.getPassChannel().getChannelNo(), "CHANNEL_PLAY_VOICE_PLATE");
        if (playPlateDefine != null && "0".equals(playPlateDefine)) {
            isNeedPlayPlate = false;
        }
        if ((playPlateTypeDefine = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(session.getPassChannel().getChannelNo(), "CHANNEL_PLAY_VOICE_PASS_TYPE")) != null && "0".equals(playPlateTypeDefine)) {
            isNeedPlayPlateType = false;
        }
        PassChannel passChannel = session.getPassChannel();
        Collection<Integer> cl1 = session.getConfirmPassExceptions();
        Collection<Integer> cl2 = session.getAllowPassExcetpions();
        Collection<Integer> cl3 = session.getForbidPassExceptions();
        HashSet<Integer> exceptionValueSet = new HashSet<Integer>();
        if (cl1 != null) {
            exceptionValueSet.addAll(cl1);
        }
        if (cl2 != null) {
            exceptionValueSet.addAll(cl2);
        }
        if (cl3 != null) {
            exceptionValueSet.addAll(cl3);
        }
        if ((plate = session.getPassPlate()) != null && plate.length() == 0) {
            plate = null;
        }
        CarparkPassportType passportType = session.getPassportType();
        Cost cost = (Cost)session.getAttribute("pass_cost");
        Integer remainDays = null;
        BigDecimal blance = null;
        boolean needRemainChargeDate = false;
        boolean needRemainChargeMoney = false;
        boolean playRemainChargeDate = false;
        boolean playRemainChargeMoney = false;
        double blanceLessthanMoney = 0.0;
        if (!(exceptionValueSet.contains(6) || exceptionValueSet.contains(7) || exceptionValueSet.contains(8))) {
            if (passportType.getPass_type() == 2) {
                if (session.getPassport().getDeadline() != null) {
                    String v2;
                    Calendar c = Calendar.getInstance();
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    long currentDate = c.getTimeInMillis();
                    c.setTime(session.getPassport().getDeadline());
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    long validDate = c.getTimeInMillis();
                    remainDays = (int)((validDate - currentDate) / 86400000L);
                    if (remainDays >= 0 && (v2 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "PLAY_REMIND_PERIOD_DAYS")) != null && Constants.YES_STR.equals(v2)) {
                        playRemainChargeDate = true;
                    }
                    if (!playRemainChargeDate) {
                        int rea;
                        v = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "REMIND_PERIOD_DAYS");
                        if (v == null || v.length() == 0) {
                            v = "7";
                        }
                        try {
                            rea = Integer.parseInt(v);
                            if (rea < 0) {
                                rea = 0;
                            }
                        }
                        catch (Exception ex) {
                            rea = 7;
                        }
                        if (remainDays <= 0 || remainDays <= rea) {
                            needRemainChargeDate = true;
                        }
                    }
                }
            } else if (passportType.getPass_type() == 1 && session.getPassport().getBalance() != null) {
                blance = session.getPassport().getBalance();
                String v1 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "PLAY_BLANCE_STRATEGY");
                if (v1 != null && Constants.YES_STR.equals(v1)) {
                    playRemainChargeMoney = true;
                }
                if (!playRemainChargeMoney) {
                    double a;
                    double rea;
                    String v3 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "REMIND_BLANCE_MONEY");
                    if (v3 == null || v3.length() == 0) {
                        v3 = "0";
                    }
                    try {
                        rea = Double.parseDouble(v3);
                        if (rea < 0.0) {
                            rea = 0.0;
                        }
                    }
                    catch (Exception ex) {
                        rea = 0.0;
                    }
                    blanceLessthanMoney = rea;
                    if (blance.doubleValue() <= 0.0 || blance.doubleValue() <= rea) {
                        needRemainChargeMoney = true;
                    } else if (cost.getActualCharge().doubleValue() > 0.0 && (a = blance.subtract(cost.getActualCharge()).doubleValue()) <= rea) {
                        needRemainChargeDate = true;
                    }
                }
            }
        }
        String selDefineText = this.getPassChannelDisplayVoice(session.getPassChannel().getChannelNo(), session.getPassportType().getPassport_type_no());
        String passText = "\u6b22\u8fce\u5149\u4e34";
        if (selDefineText != null && selDefineText.length() > 0) {
            passText = selDefineText;
        }
        String remaindInfo = null;
        if (remainDays != null && (needRemainChargeDate || playRemainChargeDate)) {
            remaindInfo = remainDays < 0 ? "\u5df2\u8fc7\u671f,\u8bf7\u7eed\u8d39" : (remainDays == 0 ? "\u4eca\u5929\u5230\u671f,\u8bf7\u53ca\u65f6\u7eed\u8d39" : "\u6709\u6548\u671f\u5269\u4f59" + remainDays + "\u5929");
        } else if (needRemainChargeMoney || playRemainChargeMoney) {
            if (playRemainChargeMoney && blance != null) {
                remaindInfo = "\u4f59\u989d: " + this.getDiplsyMoney(blance.setScale(2, 4)) + "\u5143";
            } else if (blance.doubleValue() <= 0.0) {
                remaindInfo = "\u4f59\u989d\u4e0d\u8db3,\u8bf7\u53ca\u65f6\u5145\u503c";
            } else if (blanceLessthanMoney > 0.0 && blance.doubleValue() < blanceLessthanMoney) {
                remaindInfo = "\u4f59\u989d\u4e0d\u8db3" + this.getDiplsyMoney(new BigDecimal(blanceLessthanMoney).setScale(2, 4)) + "\u5143,\u8bf7\u53ca\u65f6\u5145\u503c";
            }
        }
        String text4 = null;
        if (session.getPassportType().getPass_type() == 0 && session.getPassportType().getUse_muti_car() == 1 && session.getPassport().getRegister_plate() != null && session.getPassport().getRegister_plate().length() > 0 && (existMutiCarEnterRecords = (List)session.getAttribute("existMutiCarEnterRecords")) != null && !existMutiCarEnterRecords.isEmpty()) {
            CarparkPresenceRecord precord = null;
            for (CarparkPresenceRecord r : existMutiCarEnterRecords) {
                if (r.getEnter_plate() == null || r.getEnter_plate().length() <= 0 || r.getExit_time() != null || r.getEnter_time() == null || r.getEnter_plate().equals(session.getPassport().getRegister_plate())) continue;
                precord = r;
                break;
            }
            if (precord != null && (v = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(session.getPassChannel().getChannelNo(), "CHANNEL_ENTER_TIP_MUTICAR")) != null && "1".equals(v)) {
                Integer a = (Integer)session.getAttribute("EXIST_MUTI_CAR_COUNT");
                if (a == null || a < 1) {
                    a = 1;
                }
                text4 = a == 1 ? String.valueOf(precord.getEnter_plate()) + ",\u5df2\u5165\u573a" : String.valueOf(precord.getEnter_plate()) + ",\u7b49\u4e00\u5171" + a + "\u8f86\u8f66\u5df2\u5165\u573a";
            }
        }
        if ((displayList = this.getDisplayAndVoiceEqList(session)) != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    String v3;
                    OperationFuture<Integer> f;
                    CarChannelDisplayAction disPlayAction = (CarChannelDisplayAction)action;
                    int diplayCount = disPlayAction.getDisplayCount();
                    if (diplayCount <= 1) {
                        StringBuilder sbr = new StringBuilder(128);
                        if (plate != null) {
                            sbr.append(plate).append(',');
                        }
                        sbr.append(passportType.getPassport_type_name());
                        if (passTipMonthDurationOut != null && passTipMonthDurationOut.length() > 0) {
                            sbr.append(',').append(passTipMonthDurationOut);
                        }
                        if (passTipMonthDurationIn != null && passTipMonthDurationIn.length() > 0) {
                            sbr.append(',').append(passTipMonthDurationIn);
                        }
                        if (remaindInfo != null && remaindInfo.length() > 0) {
                            sbr.append(',').append(remaindInfo);
                        }
                        if (text4 != null) {
                            sbr.append(',').append(text4);
                        }
                        sbr.append(",").append(passText);
                        String v4 = sbr.toString();
                        f = disPlayAction.display(15, new String[]{v4});
                        this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + v4);
                    } else if (diplayCount == 2) {
                        StringBuilder sbr = new StringBuilder(128);
                        StringBuilder sbr2 = new StringBuilder(128);
                        if (text4 != null) {
                            if (plate != null) {
                                sbr.append(plate).append(',');
                            }
                            sbr.append(passportType.getPassport_type_name());
                            if (remaindInfo != null && remaindInfo.length() > 0) {
                                sbr.append(',').append(remaindInfo);
                            }
                            sbr.append(",").append(passText);
                            sbr2.append(text4);
                        } else {
                            if (plate != null) {
                                sbr.append(plate);
                            }
                            if (remaindInfo != null && remaindInfo.length() > 0) {
                                if (sbr.length() > 0) {
                                    sbr.append(',');
                                }
                                sbr.append(passText);
                                sbr2.append(passportType.getPassport_type_name()).append(",").append(remaindInfo);
                            } else if (sbr.length() == 0) {
                                sbr.append(passportType.getPassport_type_name());
                                sbr2.append(passText);
                            } else {
                                sbr2.append(passportType.getPassport_type_name()).append(',').append(passText);
                            }
                        }
                        String v1 = sbr.toString();
                        String v2 = sbr2.toString();
                        if (passTipMonthDurationIn != null && passTipMonthDurationIn.length() > 0) {
                            v2 = String.valueOf(passTipMonthDurationIn) + "," + v2;
                        }
                        if (passTipMonthDurationOut != null && passTipMonthDurationOut.length() > 0) {
                            v2 = String.valueOf(passTipMonthDurationOut) + "," + v2;
                        }
                        f = disPlayAction.display(15, new String[]{v1, v2});
                        this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + v1 + "," + v2);
                    } else if (diplayCount == 3) {
                        String v2;
                        String v1;
                        if (text4 == null) {
                            if (plate != null && plate.length() > 0) {
                                v1 = plate;
                                v2 = remaindInfo != null && remaindInfo.length() > 0 ? String.valueOf(passportType.getPassport_type_name()) + "," + remaindInfo : passportType.getPassport_type_name();
                                v3 = passText;
                            } else {
                                v1 = passportType.getPassport_type_name();
                                if (remaindInfo != null && remaindInfo.length() > 0) {
                                    v2 = remaindInfo;
                                    v3 = passText;
                                } else {
                                    v2 = passText;
                                    v3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                                }
                            }
                        } else {
                            if (plate != null && plate.length() > 0) {
                                if (remaindInfo != null && remaindInfo.length() > 0) {
                                    v1 = String.valueOf(plate) + "," + passText;
                                    v2 = String.valueOf(passportType.getPassport_type_name()) + "," + remaindInfo;
                                } else {
                                    v1 = plate;
                                    v2 = String.valueOf(passportType.getPassport_type_name()) + "," + passText;
                                }
                            } else if (remaindInfo != null && remaindInfo.length() > 0) {
                                v1 = String.valueOf(passportType.getPassport_type_name()) + "," + passText;
                                v2 = remaindInfo;
                            } else {
                                v1 = passportType.getPassport_type_name();
                                v2 = passText;
                            }
                            v3 = text4;
                        }
                        if (passTipMonthDurationOut != null && passTipMonthDurationOut.length() > 0) {
                            v2 = String.valueOf(passTipMonthDurationOut) + "," + v2;
                        }
                        if (passTipMonthDurationIn != null && passTipMonthDurationIn.length() > 0) {
                            v3 = String.valueOf(passTipMonthDurationIn) + "," + v3;
                        }
                        f = disPlayAction.display(15, new String[]{v1, v2, v3});
                        this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + v1 + "," + v2 + "," + v3);
                    } else {
                        String v2;
                        String v1;
                        String v4;
                        if (text4 == null) {
                            if (this.isVerticalScreen4(disPlayAction)) {
                                if (plate != null && plate.length() > 0) {
                                    if (remaindInfo != null && remaindInfo.length() > 0) {
                                        v4 = remaindInfo;
                                        v1 = plate;
                                        v2 = passportType.getPassport_type_name();
                                        v3 = passText;
                                    } else {
                                        v1 = plate;
                                        v2 = passportType.getPassport_type_name();
                                        v3 = passText;
                                        v4 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                                    }
                                } else if (remaindInfo != null && remaindInfo.length() > 0) {
                                    v1 = remaindInfo;
                                    v2 = passportType.getPassport_type_name();
                                    v3 = passText;
                                    v4 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                                } else {
                                    v1 = passText;
                                    v4 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                                    v2 = passportType.getPassport_type_name();
                                    v3 = session.getCarType().getCar_type_name();
                                }
                            } else {
                                v1 = plate;
                                v2 = passportType.getPassport_type_name();
                                if (remaindInfo != null && remaindInfo.length() > 0) {
                                    v3 = remaindInfo;
                                    v4 = passText;
                                } else {
                                    v3 = passText;
                                    v4 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                                }
                            }
                        } else {
                            if (plate != null && plate.length() > 0) {
                                if (this.isVerticalScreen4(disPlayAction)) {
                                    v1 = plate;
                                    if (remaindInfo != null && remaindInfo.length() > 0) {
                                        v1 = String.valueOf(v1) + "," + remaindInfo;
                                    }
                                    v2 = passportType.getPassport_type_name();
                                    v3 = passText;
                                } else {
                                    v1 = plate;
                                    v2 = passportType.getPassport_type_name();
                                    if (remaindInfo != null && remaindInfo.length() > 0) {
                                        v2 = String.valueOf(v2) + "," + remaindInfo;
                                    }
                                    v3 = passText;
                                }
                            } else if (remaindInfo != null && remaindInfo.length() > 0) {
                                v1 = remaindInfo;
                                v2 = passportType.getPassport_type_name();
                                v3 = passText;
                            } else {
                                v1 = passportType.getPassport_type_name();
                                v2 = session.getCarType().getCar_type_name();
                                v3 = passText;
                            }
                            v4 = text4;
                        }
                        if (passTipMonthDurationOut != null && passTipMonthDurationOut.length() > 0) {
                            v2 = String.valueOf(passTipMonthDurationOut) + "," + v2;
                        }
                        if (passTipMonthDurationIn != null && passTipMonthDurationIn.length() > 0) {
                            v3 = String.valueOf(passTipMonthDurationIn) + "," + v3;
                        }
                        f = disPlayAction.display(15, new String[]{v1, v2, v3, v4});
                        this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + v1 + "," + v2 + "," + v3 + "," + v4);
                    }
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_playSuccessEnter(session, isNeedPlayPlate, isNeedPlayPlateType, plate, remaindInfo, remainDays, blance, needRemainChargeDate, needRemainChargeMoney, playRemainChargeDate, playRemainChargeMoney, blanceLessthanMoney, passText)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                StringBuilder sbr = new StringBuilder(128);
                if (text4 != null && text4.length() > 0) {
                    sbr.append(text4).append(',');
                }
                if (plate != null && isNeedPlayPlate) {
                    sbr.append(this.getDynPlate(plate, action instanceof WlykLaneDisplayAction)).append(',');
                }
                if (passPlayMonthDurationVoice != null && passPlayMonthDurationVoice.length() > 0) {
                    sbr.append(passPlayMonthDurationVoice).append(',');
                }
                if (isNeedPlayPlateType) {
                    sbr.append(passportType.getPassport_type_name());
                }
                String remaindInfo1 = null;
                if (remaindInfo != null && remaindInfo.length() > 0) {
                    if (remainDays != null && (needRemainChargeDate || playRemainChargeDate)) {
                        remaindInfo1 = remainDays < 0 ? "\u5df2\u8fc7\u671f,\u8bf7\u7eed\u8d39" : (remainDays == 0 ? "\u4eca\u5929\u5230\u671f,\u8bf7\u53ca\u65f6\u7eed\u8d39" : "\u8fd8\u5269" + ServiceUtil.getRemainDays(remainDays) + "\u5230\u671f");
                    } else if (blance != null && needRemainChargeMoney) {
                        if (blance.doubleValue() <= 0.0) {
                            remaindInfo1 = "\u4f59\u989d\u4e0d\u8db3,\u8bf7\u53ca\u65f6\u5145\u503c";
                        } else if (blanceLessthanMoney > 0.0 && blance.doubleValue() < blanceLessthanMoney) {
                            remaindInfo1 = "\u4f59\u989d\u4e0d\u8db3" + ServiceUtil.getMoneyYunChina(new BigDecimal(blanceLessthanMoney).setScale(2, 4)) + ",\u8bf7\u53ca\u65f6\u5145\u503c";
                        }
                    } else if (playRemainChargeMoney && blance != null) {
                        remaindInfo1 = blance.doubleValue() <= 0.0 ? "\u4f59\u989d\u4e0d\u8db3,\u8bf7\u53ca\u65f6\u5145\u503c" : "\u4f59\u989d" + ServiceUtil.getMoneyYunChina(blance.setScale(2, 4));
                    }
                    if (remaindInfo1 != null) {
                        if (!isNeedPlayPlateType) {
                            if (sbr.length() > 0) {
                                sbr.append(',');
                            }
                            sbr.append(passportType.getPassport_type_name());
                        }
                        if (sbr.length() > 0) {
                            sbr.append(',');
                        }
                        sbr.append(remaindInfo1);
                    }
                }
                if (sbr.length() > 0) {
                    sbr.append(',');
                }
                sbr.append(passText);
                boolean play = true;
                if (lo.getDynLoudspeakerAction() instanceof DnctChannelDisplayAction && (remaindInfo1 == null || remaindInfo1.length() == 0) && ("\u6b22\u8fce\u5149\u4e34".equals(passText) || "\u6b22\u8fce\u56de\u5bb6".equals(passText))) {
                    if (isNeedPlayPlateType) {
                        int pssTypex = 0;
                        if ("\u4e34\u505c\u8f66".equals(passportType.getPassport_type_name()) || "\u4e34\u65f6\u8f66".equals(passportType.getPassport_type_name())) {
                            pssTypex = -83;
                        } else if ("\u6708\u79df\u8f66".equals(passportType.getPassport_type_name()) || "\u6708\u5361\u8f66".equals(passportType.getPassport_type_name())) {
                            pssTypex = -85;
                        } else if ("\u4e34\u505c\u5361".equals(passportType.getPassport_type_name()) || "\u4e34\u65f6\u5361".equals(passportType.getPassport_type_name())) {
                            pssTypex = -68;
                        } else if ("\u6708\u79df\u5361".equals(passportType.getPassport_type_name()) || "\u6708\u5361".equals(passportType.getPassport_type_name())) {
                            pssTypex = -67;
                        }
                        if (pssTypex != 0) {
                            byte[] plateBytes = ((DnctChannelDisplayAction)lo.getDynLoudspeakerAction()).getPlateCodes(plate);
                            byte[] bx = new byte[plateBytes.length + 2];
                            int index = 0;
                            System.arraycopy(plateBytes, 0, bx, index, plateBytes.length);
                            index += plateBytes.length;
                            bx[index++] = pssTypex;
                            bx[index++] = "\u6b22\u8fce\u5149\u4e34".equals(passText) ? 102 : -47;
                            play = false;
                            ((DnctChannelDisplayAction)lo.getDynLoudspeakerAction()).play(bx);
                        }
                    } else {
                        byte[] plateBytes = ((DnctChannelDisplayAction)lo.getDynLoudspeakerAction()).getPlateCodes(plate);
                        byte[] bx = new byte[plateBytes.length + 1];
                        System.arraycopy(plateBytes, 0, bx, 0, plateBytes.length);
                        bx[plateBytes.length] = "\u6b22\u8fce\u5149\u4e34".equals(passText) ? 102 : -47;
                        play = false;
                        ((DnctChannelDisplayAction)lo.getDynLoudspeakerAction()).play(bx);
                    }
                }
                if (!play) continue;
                String v5 = sbr.toString();
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v5);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v5);
            }
        }
    }

    private Map<?, ?> getPassTipMonthDurationInfo(PassSession session) {
        String platex;
        String key_MonthlyFreeDurationInfo = "MonthlyFreeDurationInfo";
        Map infoMap = (Map)session.getAttribute(key_MonthlyFreeDurationInfo);
        if (infoMap != null && (platex = (String)infoMap.get("monthlyFreeDurationPlateNo")) != null && platex.length() > 0 && platex.equals(session.getPassPlate())) {
            return infoMap;
        }
        return null;
    }

    private String getPassTipMonthDurationOut(Map<?, ?> infoMap) {
        String v;
        if (infoMap != null && (v = (String)infoMap.get("passTipMonthDurationOut")) != null && v.length() > 0) {
            return v;
        }
        return null;
    }

    private String getPassTipMonthDurationIn(Map<?, ?> infoMap) {
        String v;
        if (infoMap != null && (v = (String)infoMap.get("passTipMonthDurationIn")) != null && v.length() > 0) {
            return v;
        }
        return null;
    }

    private String getPassPlayMonthDurationVoice(Map<?, ?> infoMap) {
        String v;
        if (infoMap != null && (v = (String)infoMap.get("passPlayMonthDurationVoice")) != null && v.length() > 0) {
            return v;
        }
        return null;
    }

    private void playSuccessExit(PassSession session) {
        boolean needPlayBalace;
        String plate;
        String playPlateTypeDefine;
        String passTipMonthDurationOut = null;
        String passTipMonthDurationIn = null;
        String passPlayMonthDurationVoice = null;
        Map<?, ?> passTipMonthDurationInfo = this.getPassTipMonthDurationInfo(session);
        if (passTipMonthDurationInfo != null) {
            passTipMonthDurationOut = this.getPassTipMonthDurationOut(passTipMonthDurationInfo);
            passTipMonthDurationIn = this.getPassTipMonthDurationIn(passTipMonthDurationInfo);
            passPlayMonthDurationVoice = this.getPassPlayMonthDurationVoice(passTipMonthDurationInfo);
        }
        boolean isNeedPlayPlate = true;
        boolean isNeedPlayPlateType = true;
        String playPlateDefine = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(session.getPassChannel().getChannelNo(), "CHANNEL_PLAY_VOICE_PLATE");
        if (playPlateDefine != null && "0".equals(playPlateDefine)) {
            isNeedPlayPlate = false;
        }
        if ((playPlateTypeDefine = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(session.getPassChannel().getChannelNo(), "CHANNEL_PLAY_VOICE_PASS_TYPE")) != null && "0".equals(playPlateTypeDefine)) {
            isNeedPlayPlateType = false;
        }
        PassChannel passChannel = session.getPassChannel();
        Collection<Integer> cl1 = session.getConfirmPassExceptions();
        Collection<Integer> cl2 = session.getAllowPassExcetpions();
        Collection<Integer> cl3 = session.getForbidPassExceptions();
        HashSet<Integer> exceptionValueSet = new HashSet<Integer>();
        if (cl1 != null) {
            exceptionValueSet.addAll(cl1);
        }
        if (cl2 != null) {
            exceptionValueSet.addAll(cl2);
        }
        if (cl3 != null) {
            exceptionValueSet.addAll(cl3);
        }
        if ((plate = session.getPassPlate()) != null && plate.length() == 0) {
            plate = null;
        }
        CarparkPassportType passportType = session.getPassportType();
        Cost cost = (Cost)session.getAttribute("pass_cost");
        Integer remainDays = null;
        BigDecimal blance = null;
        boolean needRemainChargeDate = false;
        boolean needRemainChargeMoney = false;
        boolean playRemainChargeDate = false;
        boolean playRemainChargeMoney = false;
        double blanceLessthanMoney = 0.0;
        if (!(exceptionValueSet.contains(6) || exceptionValueSet.contains(7) || exceptionValueSet.contains(8))) {
            if (passportType.getPass_type() == 2) {
                if (session.getPassport().getDeadline() != null) {
                    String v;
                    Calendar c = Calendar.getInstance();
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    long currentDate = c.getTimeInMillis();
                    c.setTime(session.getPassport().getDeadline());
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    long validDate = c.getTimeInMillis();
                    remainDays = (int)((validDate - currentDate) / 86400000L);
                    if (remainDays >= 0 && (v = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "PLAY_REMIND_PERIOD_DAYS")) != null && Constants.YES_STR.equals(v)) {
                        playRemainChargeDate = true;
                    }
                    if (!playRemainChargeDate) {
                        int rea;
                        String v2 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "REMIND_PERIOD_DAYS");
                        if (v2 == null || v2.length() == 0) {
                            v2 = "7";
                        }
                        try {
                            rea = Integer.parseInt(v2);
                            if (rea < 0) {
                                rea = 0;
                            }
                        }
                        catch (Exception ex) {
                            rea = 7;
                        }
                        if (remainDays <= 0 || remainDays <= rea) {
                            needRemainChargeDate = true;
                        }
                    }
                }
            } else if (passportType.getPass_type() == 1 && session.getPassport().getBalance() != null) {
                blance = session.getPassport().getBalance();
                String v1 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "PLAY_BLANCE_STRATEGY");
                if (v1 != null && Constants.YES_STR.equals(v1)) {
                    playRemainChargeMoney = true;
                }
                if (!playRemainChargeMoney) {
                    double a;
                    double rea;
                    String v = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "REMIND_BLANCE_MONEY");
                    if (v == null || v.length() == 0) {
                        v = "0";
                    }
                    try {
                        rea = Double.parseDouble(v);
                        if (rea < 0.0) {
                            rea = 0.0;
                        }
                    }
                    catch (Exception ex) {
                        rea = 0.0;
                    }
                    blanceLessthanMoney = rea;
                    if (blance.doubleValue() <= 0.0 || blance.doubleValue() <= rea) {
                        needRemainChargeMoney = true;
                    } else if (cost.getActualCharge().doubleValue() > 0.0 && (a = blance.subtract(cost.getActualCharge()).doubleValue()) <= rea) {
                        needRemainChargeDate = true;
                    }
                }
            }
        }
        String selDefineText = this.getPassChannelDisplayVoice(session.getPassChannel().getChannelNo(), session.getPassportType().getPassport_type_no());
        String passText = "\u4e00\u8def\u987a\u98ce";
        if (selDefineText != null && selDefineText.length() > 0) {
            passText = selDefineText;
        }
        String passTypeName = session.getPassportType().getPassport_type_name();
        String carTypeName = session.getCarType().getCar_type_name();
        String payInfo = null;
        String payDynVoice = null;
        BigDecimal afterDeduct = null;
        CarparkArea exitArea = (CarparkArea)session.getAttribute("PASS_EXIT_AREA");
        boolean bl = needPlayBalace = cost.getDeduct_money().doubleValue() > 0.0 || blance != null && passportType.getPass_type() == 1 && cost.getActualCharge().doubleValue() == 0.0 && this.getEnterRecord(session) != null && exitArea != null && exitArea.getArea_level() != null && exitArea.getArea_level() == 1;
        if (needPlayBalace) {
            needRemainChargeMoney = false;
            playRemainChargeMoney = false;
        }
        if (needPlayBalace) {
            payInfo = "\u672c\u6b21\u505c\u8f66\u6263\u8d39 " + this.getDiplsyMoney(cost.getDeduct_money()) + "\u5143";
            payDynVoice = "\u672c\u6b21\u505c\u8f66\u6263\u8d39 " + ServiceUtil.getMoneyYunChina(cost.getDeduct_money());
            if (blance != null) {
                afterDeduct = blance.subtract(cost.getDeduct_money());
                payInfo = String.valueOf(payInfo) + ",\u4f59\u989d:" + this.getDiplsyMoney(afterDeduct) + "\u5143";
                payDynVoice = String.valueOf(payDynVoice) + ",\u4f59\u989d:" + ServiceUtil.getMoneyYunChina(afterDeduct);
            }
        } else if (cost.getCash().doubleValue() == 0.0 && cost.getAlready_paid().doubleValue() > 0.0 && session.getAttribute("ALREAD_DISPLAY_SEF_PAY") == null) {
            if (cost.getAlready_paid_scene() != null && cost.getAlready_paid_method() != null) {
                String payName = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(cost.getAlready_paid_method());
                if (cost.getAlready_paid_scene() == 5) {
                    if (cost.getAlready_paid_method() == 6) {
                        payInfo = "ETC\u6263\u8d39" + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143\u6210\u529f";
                        payDynVoice = "ETC\u6263\u8d39" + ServiceUtil.getMoneyYunChina(cost.getAlready_paid()) + "\u6210\u529f";
                    } else {
                        payInfo = String.valueOf(payName == null ? "" : payName) + "\u65e0\u611f\u652f\u4ed8" + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143\u6210\u529f";
                        payDynVoice = String.valueOf(payName == null ? "" : payName) + "\u65e0\u611f\u652f\u4ed8" + ServiceUtil.getMoneyYunChina(cost.getAlready_paid()) + "\u5143\u6210\u529f";
                    }
                } else if (cost.getAlready_paid_method() == 0) {
                    payInfo = "\u573a\u5185\u5df2\u7f34\u8d39" + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143";
                    payDynVoice = "\u573a\u5185\u5df2\u7f34\u8d39" + ServiceUtil.getMoneyYunChina(cost.getAlready_paid());
                } else if (cost.getAlready_paid_method() == 7) {
                    payInfo = "\u4f18\u60e0\u5238\u5df2\u62b5\u6263" + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143";
                    payDynVoice = "\u4f18\u60e0\u5238\u5df2\u62b5\u6263" + ServiceUtil.getMoneyYunChina(cost.getAlready_paid());
                } else if (payName != null && payName.length() > 0) {
                    String v;
                    if (cost.getAlready_paid_scene() == 3) {
                        v = String.valueOf(payName) + "\u5df2\u652f\u4ed8";
                        payInfo = String.valueOf(v) + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143";
                        payDynVoice = String.valueOf(v) + ServiceUtil.getMoneyYunChina(cost.getAlready_paid());
                    } else {
                        v = String.valueOf(payName) + "\u652f\u4ed8";
                        payInfo = String.valueOf(v) + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143\u6210\u529f";
                        payDynVoice = String.valueOf(v) + ServiceUtil.getMoneyYunChina(cost.getAlready_paid()) + "\u6210\u529f";
                    }
                } else if (cost.getAlready_paid_scene() == 3) {
                    payInfo = "\u573a\u5185\u5df2\u652f\u4ed8" + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143";
                    payDynVoice = "\u573a\u5185\u5df2\u652f\u4ed8" + ServiceUtil.getMoneyYunChina(cost.getAlready_paid());
                } else {
                    payInfo = "\u5728\u7ebf\u652f\u4ed8" + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143\u6210\u529f";
                    payDynVoice = "\u5728\u7ebf\u652f\u4ed8" + ServiceUtil.getMoneyYunChina(cost.getAlready_paid()) + "\u6210\u529f";
                }
            } else {
                payInfo = "\u573a\u5185\u5df2\u652f\u4ed8" + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143";
                payDynVoice = "\u573a\u5185\u5df2\u652f\u4ed8" + ServiceUtil.getMoneyYunChina(cost.getAlready_paid());
            }
        }
        BigDecimal rBalance = blance;
        if (afterDeduct != null) {
            rBalance = afterDeduct;
        }
        String remaindInfo = null;
        String remaindDynVoice = null;
        if (remainDays != null && (needRemainChargeDate || playRemainChargeDate)) {
            if (remainDays < 0) {
                remaindInfo = "\u5df2\u8fc7\u671f,\u8bf7\u7eed\u8d39";
                remaindDynVoice = "\u5df2\u8fc7\u671f,\u8bf7\u7eed\u8d39";
            } else if (remainDays == 0) {
                remaindInfo = "\u4eca\u5929\u5230\u671f,\u8bf7\u53ca\u65f6\u7eed\u8d39";
                remaindDynVoice = "\u4eca\u5929\u5230\u671f,\u8bf7\u53ca\u65f6\u7eed\u8d39";
            } else {
                remaindInfo = "\u8fd8\u5269" + remainDays + "\u5929\u5230\u671f";
                remaindDynVoice = "\u8fd8\u5269" + ServiceUtil.getRemainDaysChina(remainDays) + "\u5230\u671f";
            }
        } else if (blance != null && needRemainChargeMoney) {
            if (blance.doubleValue() <= 0.0 || afterDeduct != null && afterDeduct.doubleValue() <= 0.0) {
                remaindInfo = "\u4f59\u989d\u4e0d\u8db3,\u8bf7\u53ca\u65f6\u5145\u503c";
                remaindDynVoice = "\u4f59\u989d\u4e0d\u8db3,\u8bf7\u53ca\u65f6\u5145\u503c";
            } else if (blanceLessthanMoney > 0.0 && (blance.doubleValue() < blanceLessthanMoney || afterDeduct != null && afterDeduct.doubleValue() <= blanceLessthanMoney)) {
                remaindInfo = "\u4f59\u989d\u4e0d\u8db3" + this.getDiplsyMoney(new BigDecimal(blanceLessthanMoney).setScale(2, 4)) + "\u5143,\u8bf7\u53ca\u65f6\u5145\u503c";
                remaindDynVoice = "\u4f59\u989d\u4e0d\u8db3" + ServiceUtil.getMoneyYunChina(new BigDecimal(blanceLessthanMoney).setScale(2, 4)) + ",\u8bf7\u53ca\u65f6\u5145\u503c";
            }
        } else if (rBalance != null && playRemainChargeMoney) {
            remaindInfo = "\u4f59\u989d" + this.getDiplsyMoney(rBalance.setScale(2, 4)) + "\u5143";
            remaindDynVoice = "\u4f59\u989d" + ServiceUtil.getMoneyYunChina(rBalance.setScale(2, 4));
        }
        List<Equipment> displayList = this.getDisplayAndVoiceEqList(session);
        if (displayList != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    String v3;
                    String v2;
                    String v1;
                    OperationFuture<Integer> f;
                    CarChannelDisplayAction disPlayAction = (CarChannelDisplayAction)action;
                    int displayCount = disPlayAction.getDisplayCount();
                    if (displayCount <= 1) {
                        StringBuilder sbr = new StringBuilder();
                        if (plate != null) {
                            sbr.append(plate).append(',');
                        }
                        sbr.append(passTypeName);
                        if (passTipMonthDurationOut != null && passTipMonthDurationOut.length() > 0) {
                            sbr.append(',').append(passTipMonthDurationOut);
                        }
                        if (passTipMonthDurationIn != null && passTipMonthDurationIn.length() > 0) {
                            sbr.append(',').append(passTipMonthDurationIn);
                        }
                        if (payInfo != null && payInfo.length() > 0) {
                            sbr.append(',').append(payInfo);
                        }
                        if (remaindInfo != null && remaindInfo.length() > 0) {
                            sbr.append(',').append(remaindInfo);
                        }
                        sbr.append(passText);
                        String v = sbr.toString();
                        f = disPlayAction.display(15, new String[]{v});
                        this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + v);
                    } else if (displayCount <= 2) {
                        String string = v1 = plate == null ? passTypeName : String.valueOf(plate) + "," + passTypeName;
                        if (remaindInfo != null && payInfo != null) {
                            v1 = String.valueOf(v1) + "," + payInfo;
                            v2 = String.valueOf(remaindInfo) + "," + passText;
                        } else if (remaindInfo == null && payInfo != null) {
                            v1 = String.valueOf(v1) + "," + passText;
                            v2 = payInfo;
                        } else if (remaindInfo != null && payInfo == null) {
                            v1 = String.valueOf(v1) + "," + passText;
                            v2 = remaindInfo;
                        } else {
                            v2 = passText;
                        }
                        if (passTipMonthDurationIn != null && passTipMonthDurationIn.length() > 0) {
                            v2 = String.valueOf(passTipMonthDurationIn) + "," + v2;
                        }
                        if (passTipMonthDurationOut != null && passTipMonthDurationOut.length() > 0) {
                            v2 = String.valueOf(passTipMonthDurationOut) + "," + v2;
                        }
                        f = disPlayAction.display(15, new String[]{v1, v2});
                        this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + v2);
                    } else if (displayCount <= 3) {
                        if (remaindInfo != null && payInfo != null) {
                            v1 = String.valueOf(plate == null ? passTypeName : String.valueOf(plate) + "," + passTypeName) + "," + passText;
                            v2 = payInfo;
                            v3 = remaindInfo;
                        } else if (remaindInfo == null && payInfo != null) {
                            v1 = plate == null ? passTypeName : String.valueOf(plate) + "," + passTypeName;
                            v2 = payInfo;
                            v3 = passText;
                        } else if (remaindInfo != null && payInfo == null) {
                            v1 = plate == null ? passTypeName : String.valueOf(plate) + "," + passTypeName;
                            v2 = remaindInfo;
                            v3 = passText;
                        } else {
                            v1 = plate == null ? carTypeName : plate;
                            v2 = passTypeName;
                            v3 = passText;
                        }
                        if (passTipMonthDurationOut != null && passTipMonthDurationOut.length() > 0) {
                            v2 = String.valueOf(passTipMonthDurationOut) + "," + v2;
                        }
                        if (passTipMonthDurationIn != null && passTipMonthDurationIn.length() > 0) {
                            v3 = String.valueOf(passTipMonthDurationIn) + "," + v3;
                        }
                        f = disPlayAction.display(15, new String[]{v1, v2, v3});
                        this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + v3);
                    } else {
                        String v4;
                        if (this.isVerticalScreen4(disPlayAction)) {
                            if (remaindInfo != null && payInfo != null) {
                                v1 = String.valueOf(payInfo) + "," + passText;
                                v4 = String.valueOf(plate == null ? "" : plate) + "," + remaindInfo;
                            } else if (remaindInfo == null && payInfo != null) {
                                v1 = payInfo;
                                v4 = String.valueOf(plate == null ? "" : plate) + "," + passText;
                            } else if (remaindInfo != null && payInfo == null) {
                                v1 = remaindInfo;
                                v4 = String.valueOf(plate == null ? "" : plate) + "," + passText;
                            } else {
                                v1 = passText;
                                v4 = plate == null ? "" : plate;
                            }
                            v2 = passTypeName;
                            v3 = carTypeName;
                        } else {
                            v4 = passText;
                            if (remaindInfo != null && payInfo != null) {
                                v1 = plate == null ? passTypeName : String.valueOf(plate) + "," + passTypeName;
                                v2 = payInfo;
                                v3 = remaindInfo;
                            } else if (remaindInfo == null && payInfo != null) {
                                v1 = plate == null ? carTypeName : plate;
                                v2 = passTypeName;
                                v3 = payInfo;
                            } else if (remaindInfo != null && payInfo == null) {
                                v1 = plate == null ? carTypeName : plate;
                                v2 = passTypeName;
                                v3 = remaindInfo;
                            } else {
                                v1 = plate == null ? "" : plate;
                                v2 = passTypeName;
                                v3 = carTypeName;
                            }
                        }
                        if (passTipMonthDurationOut != null && passTipMonthDurationOut.length() > 0) {
                            v2 = String.valueOf(passTipMonthDurationOut) + "," + v2;
                        }
                        if (passTipMonthDurationIn != null && passTipMonthDurationIn.length() > 0) {
                            v3 = String.valueOf(passTipMonthDurationIn) + "," + v3;
                        }
                        f = disPlayAction.display(15, new String[]{v1, v2, v3, v4});
                        this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + v4);
                    }
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_playSuccessExit(session, isNeedPlayPlate, isNeedPlayPlateType, plate, remaindInfo, remainDays, blance, needRemainChargeDate, needRemainChargeMoney, playRemainChargeDate, playRemainChargeMoney, blanceLessthanMoney, passText, needPlayBalace, afterDeduct, rBalance)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                StringBuilder sbr = new StringBuilder(128);
                if (plate != null && isNeedPlayPlate) {
                    sbr.append(this.getDynPlate(plate, action instanceof WlykLaneDisplayAction)).append(',');
                }
                if (passPlayMonthDurationVoice != null && passPlayMonthDurationVoice.length() > 0) {
                    sbr.append(passPlayMonthDurationVoice).append(',');
                }
                if (payDynVoice != null && payDynVoice.length() > 0) {
                    sbr.append(payDynVoice).append(',');
                    if (remaindDynVoice != null && remaindDynVoice.length() > 0) {
                        sbr.append(remaindDynVoice);
                    } else {
                        sbr.append(passText);
                    }
                } else {
                    if (remaindDynVoice != null && remaindDynVoice.length() > 0) {
                        sbr.append(remaindDynVoice).append(',');
                    } else if (isNeedPlayPlateType) {
                        sbr.append(passTypeName).append(',');
                    }
                    sbr.append(passText);
                }
                boolean play = true;
                if (!(!(lo.getDynLoudspeakerAction() instanceof DnctChannelDisplayAction) || payDynVoice != null && payDynVoice.length() != 0 || remaindDynVoice != null && remaindDynVoice.length() != 0 || !"\u4e00\u8def\u987a\u98ce".equals(passText) && !"\u4e00\u8def\u5e73\u5b89".equals(passText))) {
                    byte[] plateBytes = ((DnctChannelDisplayAction)lo.getDynLoudspeakerAction()).getPlateCodes(plate);
                    byte[] bx = new byte[plateBytes.length + 1];
                    System.arraycopy(plateBytes, 0, bx, 0, plateBytes.length);
                    bx[plateBytes.length] = "\u4e00\u8def\u987a\u98ce".equals(passText) ? 104 : 105;
                    play = false;
                    ((DnctChannelDisplayAction)lo.getDynLoudspeakerAction()).play(bx);
                }
                if (!play) continue;
                String v = sbr.toString();
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    @Override
    public void playPassSuccess(PassSession session) {
        ChannelArea channelArea = (ChannelArea)session.getAttribute("channelArea");
        if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
            this.playSuccessEnter(session);
        } else if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
            this.playSuccessExit(session);
        }
        this.playPassSuccessLan(session);
    }

    @Override
    public void playMoney(PassSession session) {
        try {
            session.setAttribute("PLAY_HANDLE_SESSION_MILLS", ServiceUtil.getServiceContext().currentTimeMillis());
            session.setAttribute("ALREADY_PLAY_CHARGE_VOICE", Boolean.TRUE);
            this.playMoney(session, 200, true);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u7f34\u8d39\u91d1\u989d\u5f02\u5e38\uff01", (Throwable)ex);
        }
    }

    private CarparkPresenceRecord getEnterRecord(PassSession passSession) {
        CarparkArea exitArea = (CarparkArea)passSession.getAttribute("PASS_EXIT_AREA");
        Map areaPresenceRecordMap = (Map)passSession.getAttribute("areaPresenceRecordMap");
        CarparkPresenceRecord enterRecord = null;
        if (areaPresenceRecordMap != null && !areaPresenceRecordMap.isEmpty() && exitArea != null) {
            enterRecord = (CarparkPresenceRecord)areaPresenceRecordMap.get(exitArea.getArea_no());
        }
        return enterRecord;
    }

    private String getDiplsyMoney(BigDecimal d) {
        if (d == null) {
            d = Constants.MONEY_ZERO;
        }
        String m = (double)d.intValue() == d.doubleValue() ? String.valueOf(d.intValue()) : d.toString();
        return m;
    }

    private void playMoney(PassSession session, int playcount, boolean needVoice) {
        List<Equipment> displayList;
        String text4;
        String text3;
        String text2;
        Cost cost = (Cost)session.getAttribute("pass_cost");
        if (cost == null) {
            cost = new Cost();
        }
        PassChannel passChannel = session.getPassChannel();
        String text1 = session.getPassPlate();
        String plate = null;
        if (text1 == null || text1.length() == 0 || "\u8bf7\u8f93\u5165\u8f66\u724c".equals(text1)) {
            text1 = "";
        } else {
            plate = text1;
        }
        ApplicationService sa = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        boolean expiered = false;
        if (cost.getCash().doubleValue() > 0.0 && session.getPassportType().getPass_type() == 2) {
            Collection<Integer> cl1 = session.getConfirmPassExceptions();
            Collection<Integer> cl2 = session.getAllowPassExcetpions();
            Collection<Integer> cl3 = session.getForbidPassExceptions();
            HashSet<Integer> exceptionValueSet = new HashSet<Integer>();
            if (cl1 != null) {
                exceptionValueSet.addAll(cl1);
            }
            if (cl2 != null) {
                exceptionValueSet.addAll(cl2);
            }
            if (cl3 != null) {
                exceptionValueSet.addAll(cl3);
            }
            if (exceptionValueSet.contains(4) && !exceptionValueSet.contains(8)) {
                expiered = true;
            }
        }
        ChannelArea channelArea = (ChannelArea)session.getAttribute("channelArea");
        CarparkPresenceRecord enterRecord = null;
        if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
            enterRecord = this.getEnterRecord(session);
        }
        Integer parkTimeLen = null;
        Date passTime = (Date)session.getAttribute("passTime");
        if (enterRecord != null && enterRecord.getEnter_time() != null) {
            parkTimeLen = ServiceUtil.getMins(enterRecord.getEnter_time(), passTime);
        }
        String text9 = null;
        if (enterRecord == null || enterRecord.getEnter_time() == null) {
            if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                if (text1 == null || text1.length() == 0) {
                    text1 = session.getPassportType().getPassport_type_name();
                    text2 = "\u8bf7\u7f34\u8d390\u5143";
                    text3 = session.getCarType().getCar_type_name();
                    text4 = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(passTime == null ? new Date() : passTime);
                } else {
                    text2 = "\u8bf7\u7f34\u8d390\u5143";
                    text3 = session.getPassportType().getPassport_type_name();
                    text4 = session.getCarType().getCar_type_name();
                }
            } else {
                CarparkEscapeOrder escapeOrder = (CarparkEscapeOrder)session.getAttribute("ESCAPE_ORDER");
                if (escapeOrder != null) {
                    if (text1 == null || text1.length() == 0) {
                        text1 = "\u4e0a\u6b21\u79bb\u573a\u672a\u7f34\u8d39";
                        text2 = "\u8bf7\u8865\u7f34" + this.getDiplsyMoney(cost.getCash()) + "\u5143";
                        text3 = "\u4e0a\u6b21\u79bb\u573a\u65f6\u95f4\uff1a" + new SimpleDateFormat("yyyy-MM-dd HH:mm").format(escapeOrder.getExit_time());
                        text4 = "\u505c\u8f66\u65f6\u957f\uff1a" + sa.getTimeLenDes(ServiceUtil.getMins(escapeOrder.getEnter_time(), escapeOrder.getExit_time()));
                    } else {
                        text2 = "\u8bf7\u8865\u7f34" + this.getDiplsyMoney(cost.getCash()) + "\u5143";
                        text3 = "\u4e0a\u6b21\u79bb\u573a\u672a\u7f34\u8d39\uff0c\u79bb\u573a\u65f6\u95f4\uff1a" + new SimpleDateFormat("yyyy-MM-dd HH:mm").format(escapeOrder.getExit_time());
                        text4 = "\u505c\u8f66\u65f6\u957f\uff1a" + sa.getTimeLenDes(ServiceUtil.getMins(escapeOrder.getEnter_time(), escapeOrder.getExit_time()));
                    }
                } else if (text1 == null || text1.length() == 0) {
                    text1 = session.getPassportType().getPassport_type_name();
                    text2 = "\u8bf7\u7f34\u8d39" + this.getDiplsyMoney(cost.getCash()) + "\u5143";
                    text3 = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(passTime == null ? new Date() : passTime);
                    text4 = session.getCarType().getCar_type_name();
                } else {
                    text2 = "\u8bf7\u7f34\u8d39" + this.getDiplsyMoney(cost.getCash()) + "\u5143";
                    text3 = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(passTime == null ? new Date() : passTime);
                    text4 = String.valueOf(session.getPassportType().getPassport_type_name()) + "," + session.getCarType().getCar_type_name();
                }
            }
        } else {
            text3 = parkTimeLen == null ? (cost.getChargeTimeMinutes() > 0 ? "\u8ba1\u8d39\u65f6\u957f:" + sa.getTimeLenDes(cost.getChargeTimeMinutes()) : "") : (parkTimeLen.intValue() == cost.getChargeTimeMinutes() || cost.getChargeTimeMinutes() <= 0 ? "\u505c\u8f66:" + sa.getTimeLenDes(parkTimeLen) : "\u8ba1\u8d39\u65f6\u957f:" + sa.getTimeLenDes(cost.getChargeTimeMinutes()));
            if (cost.getDeduct_money().doubleValue() > 0.0) {
                text2 = "\u672c\u6b21\u505c\u8f66\u6263\u8d39" + this.getDiplsyMoney(cost.getDeduct_money()) + "\u5143";
            } else {
                text9 = cost.getCash().doubleValue() > 0.0 && session.getPassportType().getPass_type() == 1 && session.getPassport().getBalance() != null && session.getPassport().getBalance().doubleValue() < cost.getActualCharge().doubleValue() ? (text2 = "\u4f59\u989d\u4e0d\u8db3,\u8bf7\u7f34\u8d39" + this.getDiplsyMoney(cost.getCash()) + "\u5143") : (expiered ? (text2 = "\u5df2\u8fc7\u671f,\u8bf7\u7f34\u8d39" + this.getDiplsyMoney(cost.getCash()) + "\u5143") : (cost.getCash().doubleValue() > 0.0 && cost.getAlready_paid().doubleValue() > 0.0 ? (text2 = "\u79bb\u573a\u8d85\u65f6,\u8bf7\u8865\u7f34" + this.getDiplsyMoney(cost.getCash()) + "\u5143") : (text2 = "\u8bf7\u7f34\u8d39" + this.getDiplsyMoney(cost.getCash()) + "\u5143")));
            }
            if (text1 == null || text1.length() == 0) {
                text1 = session.getPassportType().getPassport_type_name();
                text4 = session.getCarType().getCar_type_name();
            } else {
                text4 = String.valueOf(session.getPassportType().getPassport_type_name()) + "," + session.getCarType().getCar_type_name();
            }
            if (enterRecord.getEnter_time() != null && enterRecord.getOccupy_end_time() != null && enterRecord.getOccupy_passport_type_no() != null && enterRecord.getOccupy_passport_type_no().length() > 0 && !enterRecord.getOccupy_passport_type_no().equals(session.getPassportType().getPassport_type_no())) {
                int len = ServiceUtil.getMins(enterRecord.getEnter_time(), enterRecord.getOccupy_end_time());
                CarparkPassportType t = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(enterRecord.getOccupy_passport_type_no());
                text4 = t != null && t.getPass_type() != 0 ? String.valueOf(text4) + ", \u672c\u8f66\u4e3a" + t.getPassport_type_name() + "\u65f6\u957f: " + sa.getTimeLenDes(len) : String.valueOf(text4) + ", \u5360\u7528\u4e34\u505c\u8f66\u4f4d\u65f6\u957f: " + sa.getTimeLenDes(len);
            }
            if (cost.getCash().doubleValue() <= 0.0) {
                text9 = null;
            }
        }
        if (cost.getArrears().doubleValue() > 0.0) {
            text2 = "\u8bf7\u7f34\u8d39" + this.getDiplsyMoney(cost.getCashAndArrears()) + "\u5143";
            text3 = text3 != null && text3.length() > 0 ? "\u60a8\u6709" + cost.getR_count() + "\u7b14\u6b20\u8d39\u8ba2\u5355, " + text3 : "\u60a8\u6709" + cost.getR_count() + "\u7b14\u6b20\u8d39\u8ba2\u5355";
            text9 = text2;
        }
        if ((displayList = this.getDisplayAndVoiceEqList(session)) != null && !displayList.isEmpty()) {
            boolean canshowQr0 = false;
            if (ServiceUtil.getServiceContext().getDBConfigCache().isSupportSelfOnlinePay() && ServiceUtil.getServiceContext().isConnectedCloud()) {
                canshowQr0 = true;
            }
            for (Equipment eq : displayList) {
                String v;
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    OperationFuture<Integer> f;
                    CarChannelDisplayAction disPlayAction = (CarChannelDisplayAction)action;
                    String qrCodeUrl = null;
                    if (playcount > 1 && text9 != null && text9.length() > 0) {
                        int qrType = disPlayAction.getDisplayQrCodeType();
                        if (qrType == 1) {
                            if (canshowQr0 && ((qrCodeUrl = this.getCarparkUnManUrl(passChannel.getChannelNo())) == null || qrCodeUrl.length() <= 0 || !qrCodeUrl.startsWith("http://") && !qrCodeUrl.startsWith("https://"))) {
                                qrCodeUrl = null;
                            }
                        } else if (qrType == 2 && ((qrCodeUrl = eq.getEquipmentConfig().getConfigValue("qrcode_content")) == null || qrCodeUrl.length() <= 0 || "0".equals(qrCodeUrl))) {
                            qrCodeUrl = null;
                        }
                    }
                    boolean displayTempMsg = true;
                    boolean displayH2QrCode = false;
                    if (text9 != null && text9.length() > 0 && qrCodeUrl != null && qrCodeUrl.length() > 0) {
                        String passPlate = session.getPassPlate();
                        if (disPlayAction instanceof WlykLaneDisplayAction) {
                            String line2 = null;
                            if (passPlate != null && passPlate.length() >= 7 && session.getReadPassportNumberEvent() != null && !session.getReadPassportNumberEvent().isUserScan()) {
                                line2 = passPlate;
                            }
                            String dMsg = cost.getArrears().doubleValue() > 0.0 ? String.valueOf(this.getDiplsyMoney(cost.getCashAndArrears())) + "\u5143,\u5305\u542b" + cost.getR_count() + "\u7b14\u6b20\u8d39\u8ba2\u5355" : String.valueOf(this.getDiplsyMoney(cost.getCash())) + "\u5143";
                            OperationFuture<Integer> f2 = ((WlykLaneDisplayAction)disPlayAction).displayQrCode(playcount > 1 ? 300 : playcount, qrCodeUrl, dMsg, line2);
                            this.logErr(f2, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a\u4e8c\u7ef4\u7801" + text9);
                            displayTempMsg = false;
                        } else if (disPlayAction instanceof H2DisplayAction) {
                            displayH2QrCode = true;
                        } else {
                            if (passPlate != null && passPlate.length() >= 7 && session.getReadPassportNumberEvent() != null && !session.getReadPassportNumberEvent().isUserScan()) {
                                text9 = String.valueOf(text9) + "," + passPlate;
                            }
                            String dMsg = cost.getArrears().doubleValue() > 0.0 ? String.valueOf(this.getDiplsyMoney(cost.getCashAndArrears())) + "\u5143,\u5305\u542b" + cost.getR_count() + "\u7b14\u6b20\u8d39\u8ba2\u5355" : text9;
                            OperationFuture<Integer> f3 = disPlayAction.displayQrCode(playcount > 1 ? 300 : playcount, qrCodeUrl, dMsg);
                            this.logErr(f3, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a\u4e8c\u7ef4\u7801" + text9);
                            displayTempMsg = false;
                        }
                    }
                    if (displayTempMsg) {
                        if (disPlayAction.getDisplayCount() <= 2) {
                            String pva = text1;
                            pva = disPlayAction.getDisplayCount() == 2 ? String.valueOf(pva) + "," + text3 : String.valueOf(pva) + "," + text2;
                            session.setDsiplay1MsgWhenMoney(pva);
                            String[] txt = disPlayAction.getDisplayCount() == 2 ? new String[]{pva, String.valueOf(text2) + "," + text4} : new String[]{pva};
                            f = disPlayAction.display(playcount, txt);
                            this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + pva);
                        } else if (disPlayAction.getDisplayCount() == 3) {
                            session.setDsiplay1MsgWhenMoney(text1);
                            f = disPlayAction.display(playcount, new String[]{text1, text2, String.valueOf(text3) + "," + text4});
                            this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + text1 + text2 + text3 + "," + text4);
                        } else if (this.isVerticalScreen4(disPlayAction)) {
                            session.setDsiplay1MsgWhenMoney(text2);
                            String[] displayTexts = new String[4];
                            displayTexts[0] = text2;
                            displayTexts[1] = session.getPassportType().getPassport_type_name();
                            displayTexts[2] = session.getCarType().getCar_type_name();
                            String v1x = "";
                            if (text3 != null && text3.indexOf(displayTexts[1]) == -1 && text3.indexOf(displayTexts[2]) == -1) {
                                v1x = text3;
                            }
                            if (text4 != null && text4.indexOf(displayTexts[1]) == -1 && text4.indexOf(displayTexts[2]) == -1) {
                                if (v1x.length() > 0) {
                                    v1x = String.valueOf(v1x) + ",";
                                }
                                v1x = String.valueOf(v1x) + text4;
                            }
                            if (plate != null && plate.length() > 0) {
                                v1x = v1x.length() == 0 ? text1 : String.valueOf(text1) + "," + v1x;
                            } else if (v1x.length() == 0) {
                                v1x = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(passTime == null ? new Date() : passTime);
                            }
                            displayTexts[3] = v1x;
                            session.setDsiplay1MsgWhenMoney(text1);
                            f = disPlayAction.display(playcount, new String[]{text1, text2, text3, text4});
                            this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + text1 + text2 + text3 + text4);
                        } else {
                            session.setDsiplay1MsgWhenMoney(text1);
                            f = disPlayAction.display(playcount, new String[]{text1, text2, text3, text4});
                            this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + text1 + text2 + text3 + text4);
                        }
                    }
                    if (displayH2QrCode && playcount > 1) {
                        f = disPlayAction.displayQrCode(300, qrCodeUrl, null);
                        this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a\u4e8c\u7ef4\u7801" + text9);
                    }
                }
                if (!needVoice || !(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_playMoney(session)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                if (cost.getDeduct_money().doubleValue() > 0.0) {
                    v = "\u672c\u6b21\u505c\u8f66\u6263\u8d39" + ServiceUtil.getMoneyYunChina(cost.getDeduct_money());
                } else {
                    byte[] ba;
                    boolean play = true;
                    if (lo.getDynLoudspeakerAction() instanceof DnctChannelDisplayAction && (ba = ((DnctChannelDisplayAction)lo.getDynLoudspeakerAction()).getMoneyOrDayTimeCode(ServiceUtil.getMoneyYun(cost.getCashAndArrears()))) != null && ba.length > 0) {
                        play = false;
                        byte[] b = new byte[ba.length + 1];
                        b[0] = 115;
                        System.arraycopy(ba, 0, b, 1, ba.length);
                        OperationFuture<Integer> f = ((DnctChannelDisplayAction)lo.getDynLoudspeakerAction()).play(b);
                        this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a\u8bf7\u7f34\u8d39" + cost.getCashAndArrears() + "\u5143");
                    }
                    v = play ? (cost.getCash().doubleValue() > 0.0 && session.getPassportType().getPass_type() == 1 && session.getPassport().getBalance() != null && session.getPassport().getBalance().doubleValue() < cost.getActualCharge().doubleValue() ? "\u4f59\u989d\u4e0d\u8db3,\u8bf7\u7f34\u8d39" + ServiceUtil.getMoneyYunChina(cost.getCashAndArrears()) : (expiered ? "\u5df2\u8fc7\u671f,\u8bf7\u7f34\u8d39" + ServiceUtil.getMoneyYunChina(cost.getCashAndArrears()) : (cost.getCash().doubleValue() > 0.0 && cost.getAlready_paid().doubleValue() > 0.0 ? "\u79bb\u573a\u8d85\u65f6,\u8bf7\u7f34\u8d39" + ServiceUtil.getMoneyYunChina(cost.getCashAndArrears()) : "\u8bf7\u7f34\u8d39" + ServiceUtil.getMoneyYunChina(cost.getCashAndArrears())))) : null;
                }
                if (v == null) continue;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
        if (needVoice) {
            String key = "DisplayVoiceServiceImpl.clearDisplayMessageSessionStateChangeListener";
            Collection<PassSession> cls = session.getPassChannel().getSessions();
            for (PassSession p : cls) {
                PassSession.SessionStateChangeListener l1 = (PassSession.SessionStateChangeListener)p.removeAttribute(key);
                if (l1 == null) continue;
                p.removeSessionStateChangeListener(l1);
            }
            PassSession.SessionStateChangeListener l = new PassSession.SessionStateChangeListener(){
                private boolean l;

                @Override
                public void sessionStateChanged(PassSession session, PassSession.SessionState oldState, PassSession.SessionState newState) {
                    if (newState == PassSession.SessionState.CANCELED && !this.l) {
                        this.l = true;
                        DisplayVoiceServiceImpl.this.playMoney(session, 1, false);
                    }
                }
            };
            session.addSessionStateChangeListener(l);
            session.setAttribute(key, l);
        }
    }

    @Override
    public void playSefPayMoney(PassSession session) {
        this.playMoney(session);
    }

    @Override
    public void playOherChanelPassPayDisCloud(PassSession session) {
        Cost cost = (Cost)session.getAttribute("pass_cost");
        PassChannel passChannel = session.getPassChannel();
        String text1 = session.getPassPlate();
        String text2 = "\u8bf7\u5230\u4eba\u5de5\u6536\u8d39\u5904\u7f34\u8d39" + this.getDiplsyMoney(cost.getCash()) + "\u5143";
        String text3 = "\u7f51\u7edc\u5f02\u5e38,\u65e0\u6cd5\u5fae\u4fe1\u6216\u652f\u4ed8\u5b9d\u652f\u4ed8";
        List<Equipment> displayList = this.getDisplayAndVoiceEqList(session);
        if (displayList != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    this.displayLines((CarChannelDisplayAction)action, text1, text2, text3, passChannel.getChannel().getChannel_name());
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_playOtherChanelPassPayDisCloud(session)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = String.valueOf(text2) + "," + text3;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    @Override
    public void playOherChanelPassPay(PassSession session) {
        Cost cost = (Cost)session.getAttribute("pass_cost");
        PassChannel passChannel = session.getPassChannel();
        String text1 = session.getPassPlate();
        String text2 = "\u8bf7\u5230\u4eba\u5de5\u6536\u8d39\u5904\u7f34\u8d39";
        String text3 = String.valueOf(this.getDiplsyMoney(cost.getCash())) + "\u5143";
        List<Equipment> displayList = this.getDisplayAndVoiceEqList(session);
        if (displayList != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    this.displayLines((CarChannelDisplayAction)action, text1, text2, text3, passChannel.getChannel().getChannel_name());
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_playOtherChanelPassPay(session)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = String.valueOf(text2) + "," + text3;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    @Override
    public void playPassError(PassSession session) {
        PassChannel passChannel = session.getPassChannel();
        String text1 = session.getPassPlate();
        if (text1 == null || text1.length() == 0) {
            text1 = "";
        }
        String text2 = "\u7cfb\u7edf\u5f02\u5e38";
        String text3 = "\u653e\u884c\u5931\u8d25";
        List<Equipment> displayList = this.getDisplayAndVoiceEqList(session);
        if (displayList != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    this.displayLines((CarChannelDisplayAction)action, text1, text2, text3, passChannel.getChannel().getChannel_name());
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || (sB = staticLoudSpeakerServiceAction.get_playPassError(session)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = String.valueOf(text2) + "," + text3;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    private void displayLines(CarChannelDisplayAction disPlayAction, String text1, String text2, String text3, String channelName) {
        String[] playTexts;
        int displayCount = disPlayAction.getDisplayCount();
        if (displayCount <= 0) {
            displayCount = 1;
        }
        if (displayCount == 1) {
            playTexts = new String[1];
            playTexts[0] = text1 != null && text1.length() > 0 ? String.valueOf(text1) + "," + text2 + "," + text3 : String.valueOf(text2) + "," + text3;
        } else if (displayCount == 2) {
            playTexts = new String[2];
            if (text1 != null && text1.length() > 0) {
                playTexts[0] = text1;
                playTexts[1] = String.valueOf(text2) + "," + text3;
            } else {
                playTexts[0] = text2;
                playTexts[1] = text3;
            }
        } else {
            playTexts = text1 != null && text1.length() > 0 ? new String[]{text1, text2, text3} : new String[]{text2, text3};
        }
        OperationFuture<Integer> f = disPlayAction.display(30, playTexts);
        this.logErr(f, channelName, disPlayAction.getEquipment(), "\u663e\u793a: " + text2 + "," + text3);
    }

    private String getChannelConfiremDisplayVoice(String channelNo) {
        String defaultV;
        String selDefineText = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_CONFIRM_DISPLAY_MSG");
        if (selDefineText == null) {
            selDefineText = "";
        }
        if ((defaultV = "\u9ed8\u8ba4").equals(selDefineText = selDefineText.trim())) {
            selDefineText = "";
        }
        return selDefineText;
    }

    @Override
    public void playConfirmPass(PassSession session) {
        String text3;
        session.setAttribute("PLAY_HANDLE_SESSION_MILLS", ServiceUtil.getServiceContext().currentTimeMillis());
        PassChannel passChannel = session.getPassChannel();
        String text1 = session.getPassPlate();
        if (text1 == null) {
            text1 = "";
        }
        String text2 = null;
        CarparkPassportType t = session.getPassportType();
        text2 = t != null ? t.getPassport_type_name() : "";
        boolean useDefaultVoice = false;
        String confirmPassMsgDisplay = (String)session.getAttribute("confirmPassMsgDisplay");
        if (confirmPassMsgDisplay == null || confirmPassMsgDisplay.length() == 0) {
            confirmPassMsgDisplay = (String)session.getAttribute("PASS_CONFIRM_MESSAGE");
        }
        String selfDefine = (String)session.getAttribute("PASS_CONFIRM_MESSAGE");
        String qrcode = (String)session.getAttribute("PASS_CONFIRM_PAY_QRCODE");
        if (confirmPassMsgDisplay == null || confirmPassMsgDisplay.length() == 0) {
            String v = this.getChannelConfiremDisplayVoice(passChannel.getChannelNo());
            if (v == null || v.length() == 0) {
                useDefaultVoice = true;
                text3 = "\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4\u653e\u884c";
            } else {
                text3 = v;
            }
        } else {
            text3 = confirmPassMsgDisplay;
        }
        List<Equipment> displayList = this.getDisplayAndVoiceEqList(session);
        if (displayList != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                if (eq.getType() == 10 && eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    if (qrcode != null && qrcode.length() > 0 && ((CarChannelDisplayAction)action).getDisplayQrCodeType() == 1) {
                        if (selfDefine == null || selfDefine.length() == 0) {
                            selfDefine = "\u8bf7\u626b\u7801";
                        }
                        if (action instanceof H2DisplayAction) {
                            int dispaySecs = 300;
                            String[] displayLines = new String[]{selfDefine};
                            ((H2DisplayAction)action).display(dispaySecs, displayLines);
                        }
                        OperationFuture<Integer> f = ((CarChannelDisplayAction)action).displayQrCode(300, qrcode, selfDefine);
                        this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a\u4e8c\u7ef4\u7801" + qrcode);
                    } else {
                        this.displayLines((CarChannelDisplayAction)action, text1, text2, text3, passChannel.getChannel().getChannel_name());
                    }
                }
                if (!(action instanceof LoudspeakerAction)) continue;
                LoudspeakerAction lo = (LoudspeakerAction)action;
                if (lo.getCarparkLoudspeakerAction() != null) {
                    byte[] sB;
                    StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction = lo.getCarparkLoudspeakerAction().getStaticLoudSpeakerServiceAction();
                    if (staticLoudSpeakerServiceAction == null || !useDefaultVoice || (sB = staticLoudSpeakerServiceAction.get_playConfirmPass(session)) == null || sB.length <= 0) continue;
                    lo.getCarparkLoudspeakerAction().play(sB);
                    continue;
                }
                if (lo.getDynLoudspeakerAction() == null) continue;
                String v = String.valueOf(text2) + "," + text3;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    @Override
    public void displayRemainSpaceIfNeed() {
        this.displayChannelScreenSpace();
    }

    private void displayChannelScreenSpace() {
        Collection<Equipment> screenList = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(10);
        if (screenList == null || screenList.isEmpty()) {
            return;
        }
        HashMap<String, Integer> spaceMap = new HashMap<String, Integer>();
        String staticText = "staticText";
        for (Equipment eq : screenList) {
            PassSession session;
            ChannelArea channelArea;
            Set<String> spaceTypeNoset;
            ParkingSpaceDisplayAction action;
            Object ax;
            if (eq.getEquipmentAction() instanceof ParkingSpaceScreenAction) {
                ParkingSpaceScreenAction action2 = (ParkingSpaceScreenAction)eq.getEquipmentAction();
                action2.displaySpace(ParkingSpace.getInstance());
                continue;
            }
            List<String> list = eq.getChannelNos();
            if (list == null || list.isEmpty()) continue;
            String channelNo = list.get(0);
            PassChannel channel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
            if (channel == null || !((ax = eq.getEquipmentAction()) instanceof ParkingSpaceDisplayAction) || !(action = (ParkingSpaceDisplayAction)ax).isWorkingProperly() || !(action instanceof EQScreenAction) && channel.getLanConnectManageHostState() != null || (spaceTypeNoset = action.getNeedDisplaySpaceTypeNos()) == null || spaceTypeNoset.isEmpty() || (channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(channelNo)) == null) continue;
            CarparkArea displayArea = null;
            if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                displayArea = channelArea.getEnterAreas().get(channelArea.getEnterAreas().size() - 1);
            } else if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                displayArea = channelArea.getExitAreas().get(channelArea.getExitAreas().size() - 1);
            }
            if (displayArea == null || eq.getUse() == 1 && (session = channel.getLastSession()) != null && (session.getSessionState() == PassSession.SessionState.OPEN_DIALOG || session.getSessionState() == PassSession.SessionState.WAIT_PAY || session.getSessionState() == PassSession.SessionState.PROCESSING)) continue;
            HashMap<String, Integer> displayMap = new HashMap<String, Integer>();
            for (String s9 : spaceTypeNoset) {
                EQScreenAction eqAction;
                if (s9 == null || s9.length() == 0) continue;
                if (action instanceof EQScreenAction && (eqAction = (EQScreenAction)action).isExtendDefineSpaceTypeNo(s9)) {
                    Integer vx = eqAction.getExtendSpaceTypeNoCode(s9);
                    if (vx == null) {
                        s9 = "0";
                    } else {
                        displayMap.put(s9, vx);
                        continue;
                    }
                }
                if ("staticText".equals(s9)) {
                    displayMap.put(s9, Integer.MIN_VALUE);
                    continue;
                }
                if (s9.startsWith("r-")) {
                    if (displayMap.containsKey(s9)) continue;
                    ParingSpaceVo paringSpaceVo = ParkingSpace.getInstance().getRemainSpaceInfo(s9);
                    if (paringSpaceVo == null) {
                        displayMap.put(s9, 0);
                        continue;
                    }
                    displayMap.put(s9, paringSpaceVo.getRemain());
                    continue;
                }
                if (s9.startsWith("t-")) {
                    if (displayMap.containsKey(s9)) continue;
                    int a = ParkingSpace.getInstance().getTookSpaceCount(s9);
                    displayMap.put(s9, a);
                    continue;
                }
                String key = String.valueOf(s9) + "_+" + displayArea.getArea_no();
                Integer va = (Integer)spaceMap.get(key);
                if (va == null) {
                    if ("0".equals(s9)) {
                        int remain = ParkingSpace.getInstance().getRemainSpace(displayArea.getArea_no());
                        if (remain < 0) {
                            remain = 0;
                        }
                        spaceMap.put(key, remain);
                        va = remain;
                    } else if (s9.startsWith("rs-")) {
                        String s = s9.substring(3);
                        if (!ServiceUtil.getServiceContext().getDBConfigCache().getSpaceTypeMap().containsKey(s)) {
                            spaceMap.put(key, 0);
                            va = 0;
                        } else {
                            String spaceKey = "r-a_" + displayArea.getArea_no() + "-s_" + s;
                            ParingSpaceVo paringSpaceVo = ParkingSpace.getInstance().getRemainSpaceInfo(spaceKey);
                            if (paringSpaceVo == null) {
                                spaceMap.put(key, 0);
                                va = 0;
                            } else {
                                spaceMap.put(key, paringSpaceVo.getRemain());
                                va = paringSpaceVo.getRemain();
                            }
                        }
                    } else {
                        String s = s9;
                        if (!ServiceUtil.getServiceContext().getDBConfigCache().getSpaceTypeMap().containsKey(s)) {
                            spaceMap.put(key, 0);
                            va = 0;
                        } else {
                            int totalCount = ParkingSpace.getInstance().getSpaceTypeTotalSpaceCount(displayArea.getArea_no(), s);
                            if (totalCount <= 0) {
                                spaceMap.put(key, 0);
                                va = 0;
                            } else {
                                int tookCount = ParkingSpace.getInstance().getTookSpaceBySpaceType(displayArea.getArea_no(), s);
                                int remain = totalCount - tookCount;
                                if (remain < 0) {
                                    remain = 0;
                                }
                                spaceMap.put(key, remain);
                                va = remain;
                            }
                        }
                    }
                }
                displayMap.put(s9, va);
            }
            OperationFuture<Integer> f = action.displayParkingSpaces(displayMap);
            this.logErr(f, channel.getChannel().getChannel_name(), eq, "\u663e\u793a\u4f59\u4f4d\u4fe1\u606f");
        }
    }

    @Override
    public void displayMsg(PassChannel passChannel, String msg, String plateNo, boolean play) {
        String[] text2;
        String[] text1;
        if (plateNo == null || plateNo.length() == 0) {
            text1 = msg;
            text2 = null;
        } else {
            text1 = plateNo;
            text2 = msg;
        }
        List<Equipment> displayList = passChannel.getEquipmentList(10);
        if (displayList != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                LoudspeakerAction lo;
                Object playText;
                if (eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    OperationFuture<Integer> f;
                    CarChannelDisplayAction disPlayAction = (CarChannelDisplayAction)action;
                    if (disPlayAction.getDisplayCount() >= 2) {
                        playText = text1 == null || text1.length() == 0 ? (text2 != null && text2.length() > 0 ? new String[]{text2} : null) : (text2 != null && text2.length() > 0 ? new String[]{text1, text2} : new String[]{text1});
                        if (playText != null && ((String)playText).length > 0) {
                            f = disPlayAction.display(15, (String[])playText);
                            this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + (String)msg);
                        }
                    } else {
                        playText = text1;
                        if (playText == null || playText.length() == 0) {
                            playText = text2;
                        } else if (text2 != null && text2.length() > 0) {
                            playText = String.valueOf(playText) + "," + (String)text2;
                        }
                        if (playText != null && playText.length() > 0) {
                            f = disPlayAction.display(15, new String[]{playText});
                            this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + (String)playText);
                        }
                    }
                }
                if (!play || !(action instanceof LoudspeakerAction) || (lo = (LoudspeakerAction)action).getDynLoudspeakerAction() == null) continue;
                playText = text1;
                if (playText == null || playText.length() == 0) {
                    playText = text2;
                } else if (text2 != null && text2.length() > 0) {
                    playText = String.valueOf(playText) + "," + (String)text2;
                }
                if (playText == null || playText.length() <= 0) continue;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play((String)playText);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + (String)playText);
            }
        }
    }

    @Override
    public void displayAndPlayMsg(PassChannel passChannel, String msg) {
        String text1 = msg;
        if (text1 == null || text1.length() == 0) {
            return;
        }
        List<Equipment> displayList = passChannel.getEquipmentList(10);
        if (displayList != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                LoudspeakerAction lo;
                if (eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    CarChannelDisplayAction disPlayAction = (CarChannelDisplayAction)action;
                    OperationFuture<Integer> f = disPlayAction.display(15, new String[]{text1});
                    this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + text1);
                }
                if (!(action instanceof LoudspeakerAction) || (lo = (LoudspeakerAction)action).getDynLoudspeakerAction() == null) continue;
                String v = text1;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(v);
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + v);
            }
        }
    }

    @Override
    public void displayScanPayMsg(final PassSession session, String playMsg, String voiceMsg, int disPlaySecs) {
        ScheduledFuture<?> sss;
        if (disPlaySecs <= 0) {
            disPlaySecs = 10;
        }
        if ((sss = session.getReDisplayPayMsg1Task()) != null) {
            try {
                sss.cancel(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            session.setReDisplayPayMsg1Task(null);
        }
        boolean displayed = false;
        List<Equipment> displayList = session.getPassChannel().getEquipmentList(10);
        if (displayList != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                LoudspeakerAction lo;
                if (eq.getUse() != 1) continue;
                Object action = eq.getEquipmentAction();
                if (action instanceof CarChannelDisplayAction) {
                    CarChannelDisplayAction disPlayAction = (CarChannelDisplayAction)action;
                    if (playMsg != null && playMsg.length() > 0) {
                        displayed = true;
                        OperationFuture<Integer> f = disPlayAction.display(disPlaySecs, new String[]{playMsg});
                        this.logErr(f, session.getPassChannel().getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + playMsg);
                    }
                }
                if (voiceMsg == null || voiceMsg.length() <= 0 || !(action instanceof LoudspeakerAction) || (lo = (LoudspeakerAction)action).getDynLoudspeakerAction() == null) continue;
                DynLoudspeakerAction d = lo.getDynLoudspeakerAction();
                OperationFuture<Integer> f = d.play(voiceMsg);
                this.logErr(f, session.getPassChannel().getChannel().getChannel_name(), eq, "\u64ad\u62a5\u8bed\u97f3\uff1a" + voiceMsg);
            }
        }
        if (displayed) {
            ScheduledFuture sh = ServiceUtil.getServiceContext().delay(new JobTask(){

                protected void doRun() throws Exception {
                    List<Equipment> displayList;
                    String msg = session.getDsiplay1MsgWhenMoney();
                    if (msg == null || msg.length() == 0) {
                        return;
                    }
                    PassSession.SessionState state = session.getSessionState();
                    if (!(state != PassSession.SessionState.WAIT_PAY && state != PassSession.SessionState.OPEN_DIALOG || (displayList = session.getPassChannel().getEquipmentList(10)) == null || displayList.isEmpty())) {
                        for (Equipment eq : displayList) {
                            Object action;
                            if (eq.getUse() != 1 || !((action = eq.getEquipmentAction()) instanceof CarChannelDisplayAction)) continue;
                            CarChannelDisplayAction disPlayAction = (CarChannelDisplayAction)action;
                            OperationFuture<Integer> f = disPlayAction.display(100, new String[]{msg});
                            DisplayVoiceServiceImpl.this.logErr((OperationFuture<Integer>)f, session.getPassChannel().getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + msg);
                        }
                    }
                }
            }, disPlaySecs, TimeUnit.SECONDS);
            session.setReDisplayPayMsg1Task(sh);
        }
    }

    private boolean isVerticalScreen4(CarChannelDisplayAction disPlayAction) {
        if (disPlayAction == null) {
            return false;
        }
        if (disPlayAction.getDisplayCount() != 4) {
            return false;
        }
        return disPlayAction.isVerticalScreen();
    }

    @Override
    public void displaySenselessPaying(PassChannel passChannel, String plate, String msg) {
        if (plate == null) {
            plate = "";
        }
        if (msg == null || msg.length() == 0) {
            msg = "\u65e0\u611f\u652f\u4ed8\u4e2d";
        }
        String text1 = plate;
        String text2 = msg;
        List<Equipment> displayList = passChannel.getEquipmentList(10);
        if (displayList != null && !displayList.isEmpty()) {
            for (Equipment eq : displayList) {
                Object action;
                if (eq.getUse() != 1 || !((action = eq.getEquipmentAction()) instanceof CarChannelDisplayAction)) continue;
                CarChannelDisplayAction disPlayAction = (CarChannelDisplayAction)action;
                int count = disPlayAction.getDisplayCount();
                if (count > 1) {
                    String[] sz = text1.length() > 0 && text2.length() > 0 ? new String[]{text1, text2} : (text1.length() > 0 && text2.length() == 0 ? new String[]{text1} : (text1.length() == 0 && text2.length() > 0 ? new String[]{text2} : null));
                    if (sz == null) continue;
                    OperationFuture<Integer> f = disPlayAction.display(10, sz);
                    this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + msg);
                    continue;
                }
                if (text1 == null || text1.length() == 0) {
                    text1 = msg;
                } else if (text2 != null && text2.length() > 0) {
                    text1 = String.valueOf(text1) + "," + msg;
                }
                OperationFuture<Integer> f = disPlayAction.display(10, new String[]{text1});
                this.logErr(f, passChannel.getChannel().getChannel_name(), eq, "\u663e\u793a\uff1a" + text1);
            }
        }
    }

    @Override
    public void clearLanHostMessage(PassSession session) {
        CarparkHost host;
        String slaveHostNo;
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config != null && config.getHost_use() == 1 && config.getNet_mode() == 2 && config.getCarpark_deploy_type() == 1 && (slaveHostNo = session.getPassChannel().getChannel().getSlave_managed_host_no()) != null && slaveHostNo.length() > 0 && !slaveHostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo()) && (host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(slaveHostNo)) != null && host.getHost_use() == 1 && host.getNet_mode() == 2) {
            HostSate state = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanHostSate(host.getHost_no());
            if (state == null || state.getLanSocketAddress() == null) {
                return;
            }
            String remoteSessionId = (String)session.getAttribute("SLAVE_HOST_SESSIONID_" + host.getHost_no());
            if (remoteSessionId != null && remoteSessionId.length() > 0) {
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("channelNo", session.getPassChannel().getChannelNo());
            map.put("displayId", String.valueOf(ServiceUtil.getServiceContext().getLocalHostNo()) + "_" + session.getSessionId());
            map.put("displayM", "clearDisplay");
            if (map != null && !map.isEmpty()) {
                LanPassChannelHandleAction.doDisplayPassMessage(state.getHostNo(), state.getLanSocketAddress(), map);
                return;
            }
        }
    }

    @Override
    public void playMoneyLanHost(PassSession session) {
        CarparkHost host;
        String slaveHostNo;
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config != null && config.getHost_use() == 1 && config.getNet_mode() == 2 && config.getCarpark_deploy_type() == 1 && (slaveHostNo = session.getPassChannel().getChannel().getSlave_managed_host_no()) != null && slaveHostNo.length() > 0 && !slaveHostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo()) && (host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(slaveHostNo)) != null && host.getHost_use() == 1 && host.getNet_mode() == 2) {
            HostSate state = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanHostSate(host.getHost_no());
            if (state == null || state.getLanSocketAddress() == null) {
                return;
            }
            String remoteSessionId = (String)session.getAttribute("SLAVE_HOST_SESSIONID_" + host.getHost_no());
            if (remoteSessionId != null && remoteSessionId.length() > 0) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("channelNo", session.getPassChannel().getChannelNo());
                paramMap.put("passSessionId", remoteSessionId);
                LanPassChannelHandleAction.doDisplayPaySession(state.getHostNo(), state.getLanSocketAddress(), paramMap);
                return;
            }
            Map<String, String> map = this.getLanplayMoney(session, state.getQrValue());
            if (map != null && !map.isEmpty()) {
                map.put("channelNo", session.getPassChannel().getChannelNo());
                map.put("displayId", String.valueOf(ServiceUtil.getServiceContext().getLocalHostNo()) + "_" + session.getSessionId());
                LanPassChannelHandleAction.doDisplayPassMessage(state.getHostNo(), state.getLanSocketAddress(), map);
                return;
            }
        }
    }

    private void playPassSuccessLan(PassSession session) {
        CarparkHost host;
        String slaveHostNo;
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config != null && config.getHost_use() == 1 && config.getNet_mode() == 2 && config.getCarpark_deploy_type() == 1 && (slaveHostNo = session.getPassChannel().getChannel().getSlave_managed_host_no()) != null && slaveHostNo.length() > 0 && !slaveHostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo()) && (host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(slaveHostNo)) != null && host.getHost_use() == 1 && host.getNet_mode() == 2) {
            HostSate state = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanHostSate(host.getHost_no());
            if (state == null || state.getLanSocketAddress() == null) {
                return;
            }
            String remoteSessionId = (String)session.getAttribute("SLAVE_HOST_SESSIONID_" + host.getHost_no());
            if (remoteSessionId != null && remoteSessionId.length() > 0) {
                return;
            }
            Map<String, String> map = null;
            ChannelArea channelArea = (ChannelArea)session.getAttribute("channelArea");
            if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                map = this.getLanPlaySuccessEnter(session);
            } else if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                map = this.getLanPlaySuccessExit(session);
            }
            if (map != null && !map.isEmpty()) {
                map.put("channelNo", session.getPassChannel().getChannelNo());
                map.put("displayId", String.valueOf(ServiceUtil.getServiceContext().getLocalHostNo()) + "_" + session.getSessionId());
                LanPassChannelHandleAction.doDisplayPassMessage(state.getHostNo(), state.getLanSocketAddress(), map);
                return;
            }
        }
    }

    private Map<String, String> getLanPlaySuccessExit(PassSession session) {
        String dv;
        String line3;
        String passPlate;
        String v;
        String plate;
        Collection<Integer> cl1 = session.getConfirmPassExceptions();
        Collection<Integer> cl2 = session.getAllowPassExcetpions();
        Collection<Integer> cl3 = session.getForbidPassExceptions();
        HashSet<Integer> exceptionValueSet = new HashSet<Integer>();
        if (cl1 != null) {
            exceptionValueSet.addAll(cl1);
        }
        if (cl2 != null) {
            exceptionValueSet.addAll(cl2);
        }
        if (cl3 != null) {
            exceptionValueSet.addAll(cl3);
        }
        if ((plate = session.getPassPlate()) != null && plate.length() == 0) {
            plate = null;
        }
        CarparkPassportType passportType = session.getPassportType();
        Cost cost = (Cost)session.getAttribute("pass_cost");
        Integer remainDays = null;
        BigDecimal blance = null;
        boolean needRemainChargeDate = false;
        boolean needRemainChargeMoney = false;
        double blanceLessthanMoney = 0.0;
        if (!(exceptionValueSet.contains(6) || exceptionValueSet.contains(7) || exceptionValueSet.contains(8))) {
            if (passportType.getPass_type() == 2) {
                if (session.getPassport().getDeadline() != null) {
                    int rea;
                    Calendar c = Calendar.getInstance();
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    long currentDate = c.getTimeInMillis();
                    c.setTime(session.getPassport().getDeadline());
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    long validDate = c.getTimeInMillis();
                    remainDays = (int)((validDate - currentDate) / 86400000L);
                    v = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "REMIND_PERIOD_DAYS");
                    if (v == null || v.length() == 0) {
                        v = "7";
                    }
                    try {
                        rea = Integer.parseInt(v);
                        if (rea < 0) {
                            rea = 0;
                        }
                    }
                    catch (Exception ex) {
                        rea = 7;
                    }
                    if (remainDays <= 0 || remainDays <= rea) {
                        needRemainChargeDate = true;
                    }
                }
            } else if (passportType.getPass_type() == 1 && session.getPassport().getBalance() != null) {
                double a;
                double rea;
                blance = session.getPassport().getBalance();
                String v2 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "REMIND_BLANCE_MONEY");
                if (v2 == null || v2.length() == 0) {
                    v2 = "0";
                }
                try {
                    rea = Double.parseDouble(v2);
                    if (rea < 0.0) {
                        rea = 0.0;
                    }
                }
                catch (Exception ex) {
                    rea = 0.0;
                }
                blanceLessthanMoney = rea;
                if (blance.doubleValue() <= 0.0 || blance.doubleValue() <= rea) {
                    needRemainChargeMoney = true;
                } else if (cost.getActualCharge().doubleValue() > 0.0 && (a = blance.subtract(cost.getActualCharge()).doubleValue()) <= rea) {
                    needRemainChargeDate = true;
                }
            }
        }
        String selDefineText = this.getPassChannelDisplayVoice(session.getPassChannel().getChannelNo(), session.getPassportType().getPassport_type_no());
        String passText = "\u4e00\u8def\u987a\u98ce";
        if (selDefineText != null && selDefineText.length() > 0) {
            passText = selDefineText;
        }
        String payInfo = null;
        String payDynVoice = null;
        BigDecimal afterDeduct = null;
        if (cost.getDeduct_money().doubleValue() > 0.0) {
            payInfo = "\u672c\u6b21\u505c\u8f66\u6263\u8d39 " + this.getDiplsyMoney(cost.getDeduct_money()) + "\u5143";
            payDynVoice = "\u672c\u6b21\u505c\u8f66\u6263\u8d39 " + ServiceUtil.getMoneyYunChina(cost.getDeduct_money());
            if (blance != null) {
                afterDeduct = blance.subtract(cost.getDeduct_money());
                payInfo = String.valueOf(payInfo) + ",\u4f59\u989d:" + this.getDiplsyMoney(afterDeduct) + "\u5143";
                payDynVoice = String.valueOf(payDynVoice) + ",\u4f59\u989d:" + ServiceUtil.getMoneyYunChina(afterDeduct);
            }
        } else if (cost.getCash().doubleValue() == 0.0 && cost.getAlready_paid().doubleValue() > 0.0 && session.getAttribute("ALREAD_DISPLAY_SEF_PAY") == null) {
            if (cost.getAlready_paid_scene() != null && cost.getAlready_paid_method() != null) {
                String payName = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(cost.getAlready_paid_method());
                if (cost.getAlready_paid_scene() == 5) {
                    if (cost.getAlready_paid_method() == 6) {
                        payInfo = "ETC\u6263\u8d39" + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143\u6210\u529f";
                        payDynVoice = "ETC\u6263\u8d39" + ServiceUtil.getMoneyYunChina(cost.getAlready_paid()) + "\u6210\u529f";
                    } else {
                        payInfo = String.valueOf(payName == null ? "" : payName) + "\u65e0\u611f\u652f\u4ed8" + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143\u6210\u529f";
                        payDynVoice = String.valueOf(payName == null ? "" : payName) + "\u65e0\u611f\u652f\u4ed8" + ServiceUtil.getMoneyYunChina(cost.getAlready_paid()) + "\u5143\u6210\u529f";
                    }
                } else if (cost.getAlready_paid_method() == 0) {
                    payInfo = "\u573a\u5185\u5df2\u7f34\u8d39" + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143";
                    payDynVoice = "\u573a\u5185\u5df2\u7f34\u8d39" + ServiceUtil.getMoneyYunChina(cost.getAlready_paid());
                } else if (cost.getAlready_paid_method() == 7) {
                    payInfo = "\u4f18\u60e0\u5238\u5df2\u62b5\u6263" + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143";
                    payDynVoice = "\u4f18\u60e0\u5238\u5df2\u62b5\u6263" + ServiceUtil.getMoneyYunChina(cost.getAlready_paid());
                } else if (payName != null && payName.length() > 0) {
                    if (cost.getAlready_paid_scene() == 3) {
                        v = String.valueOf(payName) + "\u5df2\u652f\u4ed8";
                        payInfo = String.valueOf(v) + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143";
                        payDynVoice = String.valueOf(v) + ServiceUtil.getMoneyYunChina(cost.getAlready_paid());
                    } else {
                        v = String.valueOf(payName) + "\u652f\u4ed8";
                        payInfo = String.valueOf(v) + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143\u6210\u529f";
                        payDynVoice = String.valueOf(v) + ServiceUtil.getMoneyYunChina(cost.getAlready_paid()) + "\u6210\u529f";
                    }
                } else if (cost.getAlready_paid_scene() == 3) {
                    payInfo = "\u573a\u5185\u5df2\u652f\u4ed8" + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143";
                    payDynVoice = "\u573a\u5185\u5df2\u652f\u4ed8" + ServiceUtil.getMoneyYunChina(cost.getAlready_paid());
                } else {
                    payInfo = "\u5728\u7ebf\u652f\u4ed8" + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143\u6210\u529f";
                    payDynVoice = "\u5728\u7ebf\u652f\u4ed8" + ServiceUtil.getMoneyYunChina(cost.getAlready_paid()) + "\u6210\u529f";
                }
            } else {
                payInfo = "\u573a\u5185\u5df2\u652f\u4ed8" + this.getDiplsyMoney(cost.getAlready_paid()) + "\u5143";
                payDynVoice = "\u573a\u5185\u5df2\u652f\u4ed8" + ServiceUtil.getMoneyYunChina(cost.getAlready_paid());
            }
        }
        String remaindInfo = null;
        String remaindDynVoice = null;
        if (remainDays != null && needRemainChargeDate) {
            if (remainDays < 0) {
                remaindInfo = "\u5df2\u8fc7\u671f,\u8bf7\u7eed\u8d39";
                remaindDynVoice = "\u5df2\u8fc7\u671f,\u8bf7\u7eed\u8d39";
            } else if (remainDays == 0) {
                remaindInfo = "\u4eca\u5929\u5230\u671f,\u8bf7\u53ca\u65f6\u7eed\u8d39";
                remaindDynVoice = "\u4eca\u5929\u5230\u671f,\u8bf7\u53ca\u65f6\u7eed\u8d39";
            } else {
                remaindInfo = "\u8fd8\u5269" + remainDays + "\u5929\u5230\u671f";
                remaindDynVoice = "\u8fd8\u5269" + ServiceUtil.getRemainDaysChina(remainDays) + "\u5230\u671f";
            }
        } else if (needRemainChargeMoney) {
            if (blance.doubleValue() <= 0.0 || afterDeduct != null && afterDeduct.doubleValue() <= 0.0) {
                remaindInfo = "\u4f59\u989d\u4e0d\u8db3,\u8bf7\u53ca\u65f6\u5145\u503c";
                remaindDynVoice = "\u4f59\u989d\u4e0d\u8db3,\u8bf7\u53ca\u65f6\u5145\u503c";
            } else if (blanceLessthanMoney > 0.0 && (blance.doubleValue() < blanceLessthanMoney || afterDeduct != null && afterDeduct.doubleValue() <= blanceLessthanMoney)) {
                remaindInfo = "\u4f59\u989d\u4e0d\u8db3" + this.getDiplsyMoney(new BigDecimal(blanceLessthanMoney).setScale(2, 4)) + "\u5143,\u8bf7\u53ca\u65f6\u5145\u503c";
                remaindDynVoice = "\u4f59\u989d\u4e0d\u8db3" + ServiceUtil.getMoneyYunChina(new BigDecimal(blanceLessthanMoney).setScale(2, 4)) + ",\u8bf7\u53ca\u65f6\u5145\u503c";
            }
        }
        String text1 = passPlate = session.getPassPlate();
        CarparkPassportType t = session.getPassportType();
        String text2 = t != null ? t.getPassport_type_name() : "";
        String a_line1 = null;
        String a_line2 = null;
        Object a_line3 = null;
        String b_line1 = null;
        String b_line2 = null;
        String b_line3 = null;
        String textx = text1;
        if (text1 != null && text1.length() > 0) {
            if (text2 != null && text2.length() > 0) {
                text1 = String.valueOf(text1) + ",";
                text1 = String.valueOf(text1) + text2;
            }
        } else {
            text1 = text2;
        }
        String line2 = payInfo != null && payInfo.length() > 0 ? payInfo : (remaindInfo != null && remaindInfo.length() > 0 ? remaindInfo : passText);
        a_line1 = text1;
        a_line2 = line2;
        a_line3 = null;
        text1 = textx;
        if (text1 != null && text1.length() > 0) {
            if (text2 != null && text2.length() > 0) {
                text1 = String.valueOf(text1) + "\n";
                text1 = String.valueOf(text1) + text2;
            }
        } else {
            text1 = text2;
        }
        if (payInfo != null && payInfo.length() > 0) {
            line2 = payInfo;
            line3 = remaindInfo != null && remaindInfo.length() > 0 ? remaindInfo : passText;
        } else if (remaindInfo != null && remaindInfo.length() > 0) {
            line2 = remaindInfo;
            line3 = passText;
        } else {
            line2 = passText;
            line3 = null;
        }
        b_line1 = text1;
        b_line2 = line2;
        b_line3 = line3;
        String string = dv = passPlate == null ? "" : this.getDynPlate(passPlate, true);
        if (payDynVoice != null) {
            dv = String.valueOf(dv) + payDynVoice;
        }
        if (remaindDynVoice != null) {
            dv = String.valueOf(dv) + remaindDynVoice;
        }
        dv = String.valueOf(dv) + passText;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("displayM", "displayMessage");
        paramMap.put("a_line1", a_line1);
        paramMap.put("a_line2", a_line2);
        paramMap.put("a_line3", (String)a_line3);
        paramMap.put("b_line1", b_line1);
        paramMap.put("b_line2", b_line2);
        paramMap.put("b_line3", b_line3);
        paramMap.put("voice", dv);
        paramMap.put("displaySecs", String.valueOf(15));
        return paramMap;
    }

    private String getPassChannelDisplayVoice(String channelNo, String passportTypeNo) {
        String defaultV;
        String selDefineText = ServiceUtil.getServiceContext().getDBConfigCache().getChannelPassportTypeStrategyValue(channelNo, passportTypeNo, "CHANNEL_PASSTYPE_DISPLAY_VOICE");
        if (selDefineText == null) {
            selDefineText = "";
        }
        if ((defaultV = "\u9ed8\u8ba4").equals(selDefineText = selDefineText.trim())) {
            selDefineText = "";
        }
        if (selDefineText == null || selDefineText.length() == 0) {
            selDefineText = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_PASS_DISPLAY_VOICE");
            if (selDefineText == null || (selDefineText = selDefineText.trim()).length() == 0) {
                selDefineText = "";
            } else if (defaultV.equals(selDefineText)) {
                selDefineText = "";
            }
        }
        return selDefineText;
    }

    private Map<String, String> getLanPlaySuccessEnter(PassSession session) {
        String dv;
        String text3;
        String passPlate;
        List existMutiCarEnterRecords;
        Collection<Integer> cl1 = session.getConfirmPassExceptions();
        Collection<Integer> cl2 = session.getAllowPassExcetpions();
        Collection<Integer> cl3 = session.getForbidPassExceptions();
        HashSet<Integer> exceptionValueSet = new HashSet<Integer>();
        if (cl1 != null) {
            exceptionValueSet.addAll(cl1);
        }
        if (cl2 != null) {
            exceptionValueSet.addAll(cl2);
        }
        if (cl3 != null) {
            exceptionValueSet.addAll(cl3);
        }
        CarparkPassportType passportType = session.getPassportType();
        Cost cost = (Cost)session.getAttribute("pass_cost");
        Integer remainDays = null;
        BigDecimal blance = null;
        boolean needRemainChargeDate = false;
        boolean needRemainChargeMoney = false;
        double blanceLessthanMoney = 0.0;
        if (!(exceptionValueSet.contains(6) || exceptionValueSet.contains(7) || exceptionValueSet.contains(8))) {
            if (passportType.getPass_type() == 2) {
                if (session.getPassport().getDeadline() != null) {
                    int rea;
                    Calendar c = Calendar.getInstance();
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    long currentDate = c.getTimeInMillis();
                    c.setTime(session.getPassport().getDeadline());
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    long validDate = c.getTimeInMillis();
                    remainDays = (int)((validDate - currentDate) / 86400000L);
                    String v = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "REMIND_PERIOD_DAYS");
                    if (v == null || v.length() == 0) {
                        v = "7";
                    }
                    try {
                        rea = Integer.parseInt(v);
                        if (rea < 0) {
                            rea = 0;
                        }
                    }
                    catch (Exception ex) {
                        rea = 7;
                    }
                    if (remainDays <= 0 || remainDays <= rea) {
                        needRemainChargeDate = true;
                    }
                }
            } else if (passportType.getPass_type() == 1 && session.getPassport().getBalance() != null) {
                double a;
                double rea;
                blance = session.getPassport().getBalance();
                String v = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "REMIND_BLANCE_MONEY");
                if (v == null || v.length() == 0) {
                    v = "0";
                }
                try {
                    rea = Double.parseDouble(v);
                    if (rea < 0.0) {
                        rea = 0.0;
                    }
                }
                catch (Exception ex) {
                    rea = 0.0;
                }
                blanceLessthanMoney = rea;
                if (blance.doubleValue() <= 0.0 || blance.doubleValue() <= rea) {
                    needRemainChargeMoney = true;
                } else if (cost.getActualCharge().doubleValue() > 0.0 && (a = blance.subtract(cost.getActualCharge()).doubleValue()) <= rea) {
                    needRemainChargeDate = true;
                }
            }
        }
        String selDefineText = this.getPassChannelDisplayVoice(session.getPassChannel().getChannelNo(), session.getPassportType().getPassport_type_no());
        String passText = "\u6b22\u8fce\u5149\u4e34";
        if (selDefineText != null && selDefineText.length() > 0) {
            passText = selDefineText;
        }
        String remaindInfo = null;
        String voiceInfo = null;
        if (remainDays != null && needRemainChargeDate) {
            if (remainDays < 0) {
                voiceInfo = remaindInfo = "\u5df2\u8fc7\u671f,\u8bf7\u7eed\u8d39";
            } else if (remainDays == 0) {
                voiceInfo = remaindInfo = "\u4eca\u5929\u5230\u671f,\u8bf7\u53ca\u65f6\u7eed\u8d39";
            } else {
                remaindInfo = "\u8fd8\u5269" + remainDays + "\u5929\u5230\u671f";
                voiceInfo = "\u8fd8\u5269" + ServiceUtil.getRemainDaysChina(remainDays) + "\u5230\u671f";
            }
        } else if (needRemainChargeMoney) {
            if (blance.doubleValue() <= 0.0) {
                voiceInfo = remaindInfo = "\u4f59\u989d\u4e0d\u8db3,\u8bf7\u53ca\u65f6\u5145\u503c";
            } else if (blanceLessthanMoney > 0.0 && blance.doubleValue() < blanceLessthanMoney) {
                remaindInfo = "\u4f59\u989d\u4e0d\u8db3" + this.getDiplsyMoney(new BigDecimal(blanceLessthanMoney).setScale(2, 4)) + "\u5143,\u8bf7\u53ca\u65f6\u5145\u503c";
                voiceInfo = "\u4f59\u989d\u4e0d\u8db3" + ServiceUtil.getMoneyYunChina(new BigDecimal(blanceLessthanMoney).setScale(2, 4)) + "\u8bf7\u53ca\u65f6\u5145\u503c";
            }
        }
        String text4 = null;
        if (session.getPassportType().getPass_type() == 0 && session.getPassportType().getUse_muti_car() == 1 && session.getPassport().getRegister_plate() != null && session.getPassport().getRegister_plate().length() > 0 && (existMutiCarEnterRecords = (List)session.getAttribute("existMutiCarEnterRecords")) != null && !existMutiCarEnterRecords.isEmpty()) {
            String v;
            CarparkPresenceRecord precord = null;
            for (CarparkPresenceRecord r : existMutiCarEnterRecords) {
                if (r.getEnter_plate() == null || r.getEnter_plate().length() <= 0 || r.getExit_time() != null || r.getEnter_time() == null || r.getEnter_plate().equals(session.getPassport().getRegister_plate())) continue;
                precord = r;
                break;
            }
            if (precord != null && (v = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(session.getPassChannel().getChannelNo(), "CHANNEL_ENTER_TIP_MUTICAR")) != null && "1".equals(v)) {
                Integer a = (Integer)session.getAttribute("EXIST_MUTI_CAR_COUNT");
                if (a == null || a < 1) {
                    a = 1;
                }
                text4 = a == 1 ? String.valueOf(precord.getEnter_plate()) + ",\u5df2\u5165\u573a" : String.valueOf(precord.getEnter_plate()) + ",\u7b49\u4e00\u5171" + a + "\u8f86\u8f66\u5df2\u5165\u573a";
            }
        }
        String text1 = passPlate = session.getPassPlate();
        CarparkPassportType t = session.getPassportType();
        String text2 = t != null ? t.getPassport_type_name() : "";
        String a_line1 = null;
        String a_line2 = null;
        Object a_line3 = null;
        String b_line1 = null;
        String b_line2 = null;
        String b_line3 = null;
        String textx = text1;
        if (text1 != null && text1.length() > 0) {
            if (text2 != null && text2.length() > 0) {
                text1 = String.valueOf(text1) + ",";
                text1 = String.valueOf(text1) + text2;
            }
        } else {
            text1 = text2;
        }
        a_line1 = text1;
        a_line2 = text4 != null ? text4 : (remaindInfo != null ? remaindInfo : passText);
        text1 = textx;
        if (text1 == null || text1.length() == 0) {
            text1 = text2;
            if (text4 != null) {
                text2 = text4;
                text3 = passText;
            } else if (remaindInfo != null) {
                text2 = remaindInfo;
                text3 = passText;
            } else {
                text2 = passText;
                text3 = new SimpleDateFormat("yy/MM/dd HH:mm").format(new Date());
            }
        } else {
            if (text4 != null) {
                if (text2 != null && text2.length() > 0) {
                    text1 = String.valueOf(text1) + "\n";
                    text1 = String.valueOf(text1) + text2;
                }
                text2 = text4;
            } else if (remaindInfo != null) {
                if (text2 != null && text2.length() > 0) {
                    text1 = String.valueOf(text1) + "\n";
                    text1 = String.valueOf(text1) + text2;
                }
                text2 = remaindInfo;
            }
            text3 = passText;
        }
        b_line1 = text1;
        b_line2 = text2;
        b_line3 = text3;
        if (text4 == null) {
            dv = passPlate == null ? "" : this.getDynPlate(passPlate, true);
        } else {
            dv = text4;
            dv = String.valueOf(dv) + (passPlate == null ? "" : this.getDynPlate(passPlate, true));
        }
        if (voiceInfo != null) {
            dv = String.valueOf(dv) + voiceInfo;
        }
        dv = String.valueOf(dv) + passText;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("displayM", "displayMessage");
        paramMap.put("a_line1", a_line1);
        paramMap.put("a_line2", a_line2);
        paramMap.put("a_line3", (String)a_line3);
        paramMap.put("b_line1", b_line1);
        paramMap.put("b_line2", b_line2);
        paramMap.put("b_line3", b_line3);
        paramMap.put("voice", dv);
        paramMap.put("displaySecs", String.valueOf(15));
        return paramMap;
    }

    private String getUnManUrl(String channelNo) {
        String host = ServiceUtil.getCloudPayDomain();
        byte[] cNo = channelNo.getBytes();
        byte[] dataB = new byte[14 + cNo.length];
        int offset = 0;
        dataB[offset++] = 86;
        byte[] carparkId = BytesTool.intToBytes((int)ServiceUtil.getServiceContext().getCarparkId());
        System.arraycopy(carparkId, 0, dataB, offset, carparkId.length);
        long mills = System.currentTimeMillis() + 1800000L;
        byte[] timeMills = BytesTool.LongToBytes((long)mills);
        System.arraycopy(timeMills, 0, dataB, offset += carparkId.length, timeMills.length);
        offset += timeMills.length;
        dataB[offset++] = (byte)cNo.length;
        System.arraycopy(cNo, 0, dataB, offset, cNo.length);
        String x = BytesTool.compressBytes((byte[])dataB);
        return String.valueOf("cloud.wlyk.com".equals(host) ? "https://" : "http://") + host + "/core/p/u.do?x=" + x;
    }

    private Map<String, String> getLanplayMoney(PassSession session, String qrValue) {
        String passPlate;
        String text1 = passPlate = session.getPassPlate();
        CarparkPassportType t = session.getPassportType();
        String text2 = t != null ? t.getPassport_type_name() : "";
        Cost cost = (Cost)session.getAttribute("pass_cost");
        boolean expiered = false;
        if (cost.getCash().doubleValue() > 0.0 && session.getPassportType().getPass_type() == 2) {
            Collection<Integer> cl1 = session.getConfirmPassExceptions();
            Collection<Integer> cl2 = session.getAllowPassExcetpions();
            Collection<Integer> cl3 = session.getForbidPassExceptions();
            HashSet<Integer> exceptionValueSet = new HashSet<Integer>();
            if (cl1 != null) {
                exceptionValueSet.addAll(cl1);
            }
            if (cl2 != null) {
                exceptionValueSet.addAll(cl2);
            }
            if (cl3 != null) {
                exceptionValueSet.addAll(cl3);
            }
            if (exceptionValueSet.contains(4) && !exceptionValueSet.contains(8)) {
                expiered = true;
            }
        }
        String excp = null;
        String voice = "\u8bf7\u652f\u4ed8" + ServiceUtil.getMoneyYunChina(cost.getCash());
        if (cost.getCash().doubleValue() > 0.0 && session.getPassportType().getPass_type() == 1 && session.getPassport().getBalance() != null && session.getPassport().getBalance().doubleValue() < cost.getActualCharge().doubleValue()) {
            excp = "\u4f59\u989d\u4e0d\u8db3";
            voice = String.valueOf(excp) + voice;
        } else if (expiered) {
            excp = "\u5df2\u8fc7\u671f";
            voice = String.valueOf(excp) + voice;
        } else if (cost.getCash().doubleValue() > 0.0 && cost.getAlready_paid().doubleValue() > 0.0) {
            excp = "\u79bb\u573a\u8d85\u65f6";
            voice = String.valueOf(excp) + voice;
        }
        if (cost.getCash().doubleValue() > 0.0) {
            HashMap<String, String> paramMap;
            String url;
            if (qrValue == null || qrValue.length() == 0) {
                qrValue = Constants.YES_STR;
            }
            if (!Constants.NO_STR.equals(qrValue) && ServiceUtil.getServiceContext().isConnectedCloud()) {
                if (Constants.YES_STR.equals(qrValue)) {
                    if (ServiceUtil.getServiceContext().getDBConfigCache().isSupportSelfOnlinePay()) {
                        url = this.getUnManUrl(session.getPassChannel().getChannelNo());
                        paramMap = new HashMap();
                        paramMap.put("displayM", "displayQrCode");
                        paramMap.put("qrCodeContent", url);
                        paramMap.put("line1", String.valueOf(this.getDiplsyMoney(cost.getCash())) + "\u5143");
                        paramMap.put("line2", session.getPassPlate());
                        paramMap.put("voice", voice);
                        paramMap.put("displaySecs", String.valueOf(600));
                        return paramMap;
                    }
                } else {
                    HashMap<String, String> paramMap2 = new HashMap<String, String>();
                    paramMap2.put("displayM", "displayQrCode");
                    paramMap2.put("qrCodeContent", qrValue);
                    paramMap2.put("line1", String.valueOf(this.getDiplsyMoney(cost.getCash())) + "\u5143");
                    paramMap2.put("line2", session.getPassPlate());
                    paramMap2.put("voice", voice);
                    paramMap2.put("displaySecs", String.valueOf(600));
                    return paramMap2;
                }
            }
            if (ServiceUtil.getServiceContext().getDBConfigCache().isSupportSelfOnlinePay() && ServiceUtil.getServiceContext().isConnectedCloud()) {
                url = this.getUnManUrl(session.getPassChannel().getChannelNo());
                paramMap = new HashMap<String, String>();
                paramMap.put("displayM", "displayQrCode");
                paramMap.put("qrCodeContent", url);
                paramMap.put("line1", String.valueOf(this.getDiplsyMoney(cost.getCash())) + "\u5143");
                paramMap.put("line2", session.getPassPlate());
                paramMap.put("voice", voice);
                paramMap.put("displaySecs", String.valueOf(600));
                return paramMap;
            }
        }
        ApplicationService sa = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        CarparkPresenceRecord enterRecord = this.getEnterRecord(session);
        Integer parkTimeLen = null;
        if (enterRecord != null && enterRecord.getEnter_time() != null) {
            Date passTime = (Date)session.getAttribute("passTime");
            parkTimeLen = ServiceUtil.getMins(enterRecord.getEnter_time(), passTime);
        }
        String text4 = parkTimeLen == null || parkTimeLen.intValue() != cost.getChargeTimeMinutes() ? "\u8ba1\u8d39:" + sa.getTimeLenDes(cost.getChargeTimeMinutes()) : "\u505c\u8f66:" + sa.getTimeLenDes(parkTimeLen);
        String a_line1 = null;
        String a_line2 = null;
        Object a_line3 = null;
        String b_line1 = null;
        String b_line2 = null;
        String b_line3 = null;
        String textx = text1;
        if (text1 != null && text1.length() > 0) {
            if (text2 != null && text2.length() > 0) {
                text1 = String.valueOf(text1) + ",";
                text1 = String.valueOf(text1) + text2;
            }
        } else {
            text1 = text2;
        }
        if (excp != null && excp.length() > 0) {
            text1 = String.valueOf(text1) + "," + excp;
        }
        String line2 = "\u652f\u4ed8:" + this.getDiplsyMoney(cost.getCash()) + "\u5143," + text4;
        a_line1 = text1;
        a_line2 = line2;
        text1 = textx;
        if (text1 != null && text1.length() > 0) {
            if (text2 != null && text2.length() > 0) {
                text1 = String.valueOf(text1) + "\n";
                text1 = String.valueOf(text1) + text2;
            }
        } else {
            text1 = text2;
        }
        line2 = excp != null && excp.length() > 0 ? String.valueOf(excp) + "\n" + this.getDiplsyMoney(cost.getCash()) + "\u5143" : "\u652f\u4ed8\u91d1\u989d\n" + this.getDiplsyMoney(cost.getCash()) + "\u5143";
        b_line1 = text1;
        b_line2 = line2;
        b_line3 = text4;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("displayM", "displayMessage");
        paramMap.put("a_line1", a_line1);
        paramMap.put("a_line2", a_line2);
        paramMap.put("a_line3", (String)a_line3);
        paramMap.put("b_line1", b_line1);
        paramMap.put("b_line2", b_line2);
        paramMap.put("b_line3", b_line3);
        paramMap.put("voice", voice);
        paramMap.put("displaySecs", String.valueOf(600));
        return paramMap;
    }
}

