/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.service.impl;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.ExportService;
import com.wovoe.framework.CsvWriter;
import com.wovoe.framework.Service;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

@Service
public class ExportServiceImpl
implements ExportService {
    @Override
    public void exportPresenceRecordExcel(SearchParam searchParam, Map<String, String> headArr, OutputStream out) throws Exception {
        try (HSSFWorkbook workbook = new HSSFWorkbook();){
            HSSFSheet sheet = workbook.createSheet("\u5728\u573a\u8f66\u8f86\u8bb0\u5f55");
            int rowIndex = 0;
            int cellIndex = 0;
            HSSFRow headRow = sheet.createRow(rowIndex++);
            for (Map.Entry<String, String> entry : headArr.entrySet()) {
                headRow.createCell(cellIndex++).setCellValue(entry.getValue() == null ? "" : entry.getValue());
            }
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            List dataList = commonDaoService.selectList(searchParam, null);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            String enter_time = "enter_time";
            String enter_valid_date = "enter_valid_date";
            String enter_plate_source = "enter_plate_source";
            String enter_balance = "enter_balance";
            String _pass_type = "pass_type";
            if (dataList != null && !dataList.isEmpty()) {
                for (Map dataMap : dataList) {
                    HSSFRow row = sheet.createRow(rowIndex++);
                    cellIndex = 0;
                    for (Map.Entry<String, String> entry : headArr.entrySet()) {
                        String value = null;
                        Object vobj = dataMap.get(entry.getKey());
                        if ("enter_time".equals(entry.getKey())) {
                            if (vobj != null) {
                                value = df.format((Date)vobj);
                            }
                        } else if ("enter_valid_date".equals(entry.getKey())) {
                            Integer pass_type;
                            if (vobj != null && (pass_type = (Integer)dataMap.get("pass_type")) != null && pass_type == 2) {
                                value = df1.format((Date)vobj);
                            }
                        } else if ("enter_balance".equals(entry.getKey())) {
                            Integer pass_type;
                            if (vobj != null && (pass_type = (Integer)dataMap.get("pass_type")) != null && pass_type == 1) {
                                value = vobj.toString();
                            }
                        } else if ("enter_plate_source".equals(entry.getKey())) {
                            if (vobj != null) {
                                int a = (Integer)vobj;
                                if (a == 0) {
                                    value = "\u8f66\u724c\u8bc6\u522b";
                                } else if (a == 1) {
                                    value = "\u4eba\u5de5\u653e\u884c";
                                } else if (a == 2) {
                                    String enter_plate_modify_user_name = (String)dataMap.get("enter_plate_modify_user_name");
                                    value = enter_plate_modify_user_name != null && enter_plate_modify_user_name.length() > 0 ? String.valueOf(enter_plate_modify_user_name) + "\u4fee\u6539\u8f66\u724c" : "\u4eba\u5de5\u4fee\u6539\u8f66\u724c";
                                } else if (a == 3) {
                                    value = "ETC";
                                } else if (a == 4) {
                                    value = "\u6a21\u7cca\u5339\u914d";
                                } else if (a == 5) {
                                    value = "\u8f66\u4e3b\u626b\u7801";
                                }
                            }
                        } else if (vobj != null) {
                            value = vobj.toString();
                        }
                        row.createCell(cellIndex++).setCellValue(value == null ? "" : value);
                    }
                }
            }
            workbook.write(out);
        }
    }

    @Override
    public void exportEnterRecordCsv(SearchParam searchParam, Map<String, String> headArr, PrintWriter out) throws Exception {
        List dataList;
        CsvWriter writer = new CsvWriter((Writer)out, ',');
        for (Map.Entry<String, String> entry : headArr.entrySet()) {
            writer.write(entry.getValue());
        }
        writer.endRecord();
        writer.flush();
        searchParam.setOrder_by("id");
        int fetchSize = 500;
        long id = 0L;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
        String enter_time = "enter_time";
        String enter_valid_date = "enter_valid_date";
        String enter_plate_source = "enter_plate_source";
        String enter_balance = "enter_balance";
        String _pass_type = "pass_type";
        String idstr = "id";
        do {
            Pagination p = new Pagination();
            p.setRecordsCount((long)fetchSize);
            p.setNeedQueryCount(false);
            p.setGotoPage(1);
            p.setPageSize(fetchSize);
            SearchParam searchParam0 = new SearchParam();
            searchParam.copyTo(searchParam0);
            searchParam0.addGT("id", (Object)id);
            dataList = commonDaoService.selectList(searchParam0, p);
            if (dataList == null || dataList.isEmpty()) break;
            if (dataList == null || dataList.isEmpty()) continue;
            for (Map dataMap : dataList) {
                id = (Long)dataMap.get(idstr);
                for (Map.Entry<String, String> entry : headArr.entrySet()) {
                    String value = null;
                    Object vobj = dataMap.get(entry.getKey());
                    if ("enter_time".equals(entry.getKey())) {
                        if (vobj != null) {
                            value = df.format((Date)vobj);
                        }
                    } else if ("enter_valid_date".equals(entry.getKey())) {
                        Integer pass_type;
                        if (vobj != null && (pass_type = (Integer)dataMap.get("pass_type")) != null && pass_type == 2) {
                            value = df1.format((Date)vobj);
                        }
                    } else if ("enter_balance".equals(entry.getKey())) {
                        Integer pass_type;
                        if (vobj != null && (pass_type = (Integer)dataMap.get("pass_type")) != null && pass_type == 1) {
                            value = vobj.toString();
                        }
                    } else if ("enter_plate_source".equals(entry.getKey())) {
                        if (vobj != null) {
                            int a = (Integer)vobj;
                            if (a == 0) {
                                value = "\u8f66\u724c\u8bc6\u522b";
                            } else if (a == 1) {
                                value = "\u4eba\u5de5\u653e\u884c";
                            } else if (a == 2) {
                                String enter_plate_modify_user_name = (String)dataMap.get("enter_plate_modify_user_name");
                                value = enter_plate_modify_user_name != null && enter_plate_modify_user_name.length() > 0 ? String.valueOf(enter_plate_modify_user_name) + "\u4fee\u6539\u8f66\u724c" : "\u4eba\u5de5\u4fee\u6539\u8f66\u724c";
                            } else if (a == 3) {
                                value = "ETC";
                            } else if (a == 4) {
                                value = "\u6a21\u7cca\u5339\u914d";
                            } else if (a == 5) {
                                value = "\u8f66\u4e3b\u626b\u7801";
                            }
                        }
                    } else if (vobj != null) {
                        value = vobj.toString();
                    }
                    writer.write(value == null ? "" : value);
                }
                writer.endRecord();
                writer.flush();
            }
        } while (dataList.size() >= fetchSize);
    }

    @Override
    public void exportIllegalRecordCsv(SearchParam searchParam, Map<String, String> headArr, PrintWriter out) throws Exception {
        List dataList;
        CsvWriter writer = new CsvWriter((Writer)out, ',');
        for (Map.Entry<String, String> entry : headArr.entrySet()) {
            writer.write(entry.getValue());
        }
        writer.endRecord();
        writer.flush();
        searchParam.setOrder_by("id");
        int fetchSize = 500;
        long id = 0L;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String pass_time = "pass_time";
        String idstr = "id";
        do {
            Pagination p = new Pagination();
            p.setRecordsCount((long)fetchSize);
            p.setNeedQueryCount(false);
            p.setGotoPage(1);
            p.setPageSize(fetchSize);
            SearchParam searchParam0 = new SearchParam();
            searchParam.copyTo(searchParam0);
            searchParam0.addGT("id", (Object)id);
            dataList = commonDaoService.selectList(searchParam0, p);
            if (dataList == null || dataList.isEmpty()) break;
            if (dataList == null || dataList.isEmpty()) continue;
            for (Map dataMap : dataList) {
                id = (Long)dataMap.get(idstr);
                for (Map.Entry<String, String> entry : headArr.entrySet()) {
                    String value = null;
                    Object vobj = dataMap.get(entry.getKey());
                    if ("pass_time".equals(entry.getKey())) {
                        if (vobj != null) {
                            value = df.format((Date)vobj);
                        }
                    } else if (vobj != null) {
                        value = vobj.toString();
                    }
                    writer.write(value == null ? "" : value);
                }
                writer.endRecord();
                writer.flush();
            }
        } while (dataList.size() >= fetchSize);
    }

    @Override
    public void exportDiscountRecordCsv(SearchParam searchParam, Map<String, String> headArr, PrintWriter out) throws Exception {
        List dataList;
        CsvWriter writer = new CsvWriter((Writer)out, ',');
        for (Map.Entry<String, String> entry : headArr.entrySet()) {
            writer.write(entry.getValue());
        }
        writer.endRecord();
        writer.flush();
        searchParam.setOrder_by("id");
        int fetchSize = 500;
        long id = 0L;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String discount_source = "discount_source";
        String enter_time = "enter_time";
        String discount_time = "discount_time";
        String exit_time = "exit_time";
        String idstr = "id";
        do {
            Pagination p = new Pagination();
            p.setRecordsCount((long)fetchSize);
            p.setNeedQueryCount(false);
            p.setGotoPage(1);
            p.setPageSize(fetchSize);
            SearchParam searchParam0 = new SearchParam();
            searchParam.copyTo(searchParam0);
            searchParam0.addGT("id", (Object)id);
            dataList = commonDaoService.selectList(searchParam0, p);
            if (dataList == null || dataList.isEmpty()) break;
            if (dataList == null || dataList.isEmpty()) continue;
            for (Map dataMap : dataList) {
                id = (Long)dataMap.get(idstr);
                for (Map.Entry<String, String> entry : headArr.entrySet()) {
                    String value = null;
                    Object vobj = dataMap.get(entry.getKey());
                    if ("enter_time".equals(entry.getKey()) || "discount_time".equals(entry.getKey()) || "exit_time".equals(entry.getKey())) {
                        if (vobj != null) {
                            value = df.format((Date)vobj);
                        }
                    } else if ("discount_source".equals(entry.getKey())) {
                        value = Constants.getDisocuntSourceMap().get(dataMap.get("discount_source"));
                    } else if (vobj != null) {
                        value = vobj.toString();
                    }
                    writer.write(value == null ? "" : value);
                }
                writer.endRecord();
                writer.flush();
            }
        } while (dataList.size() >= fetchSize);
    }

    private void addMoney(Map<String, BigDecimal> totalMoneyMap, String key, Object money) {
        if (money != null && money instanceof BigDecimal) {
            BigDecimal m = totalMoneyMap.get(key);
            if (m == null) {
                totalMoneyMap.put(key, (BigDecimal)money);
            } else {
                BigDecimal m1 = (BigDecimal)money;
                if (m1.doubleValue() != 0.0) {
                    m = m.add(m1);
                    totalMoneyMap.put(key, m);
                }
            }
        }
    }

    private String getMoney(Map<String, BigDecimal> totalMoneyMap, String key) {
        BigDecimal m1 = totalMoneyMap.get(key);
        if (m1 == null) {
            m1 = Constants.MONEY_ZERO;
        }
        NumberFormat sf = NumberFormat.getCurrencyInstance(Locale.CHINA);
        return sf.format(m1);
    }

    @Override
    public void exportTempPayRecordCsv(SearchParam searchParam, Map<String, String> headArr, PrintWriter out) throws Exception {
        List dataList;
        CsvWriter writer = new CsvWriter((Writer)out, ',');
        for (Map.Entry<String, String> entry : headArr.entrySet()) {
            writer.write(entry.getValue());
        }
        writer.endRecord();
        writer.flush();
        searchParam.setOrder_by("id");
        int fetchSize = 500;
        long id = 0L;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String enter_time = "enter_time";
        String tran_time = "tran_time";
        String tran_money = "tran_money";
        String pay_method = "pay_method";
        String pay_scene = "pay_scene";
        String charge_org = "charge_org";
        HashMap<String, BigDecimal> totalMoneyMap = new HashMap<String, BigDecimal>();
        HashSet<String> moneySet = new HashSet<String>();
        moneySet.add("tran_money");
        String idstr = "id";
        do {
            Pagination p = new Pagination();
            p.setRecordsCount((long)fetchSize);
            p.setNeedQueryCount(false);
            p.setGotoPage(1);
            p.setPageSize(fetchSize);
            SearchParam searchParam0 = new SearchParam();
            searchParam.copyTo(searchParam0);
            searchParam0.addGT("id", (Object)id);
            dataList = commonDaoService.selectList(searchParam0, p);
            if (dataList == null || dataList.isEmpty()) break;
            if (dataList == null || dataList.isEmpty()) continue;
            for (Map dataMap : dataList) {
                id = (Long)dataMap.get(idstr);
                for (Map.Entry<String, String> entry : headArr.entrySet()) {
                    String value = null;
                    Object vobj = dataMap.get(entry.getKey());
                    if ("enter_time".equals(entry.getKey()) || "tran_time".equals(entry.getKey())) {
                        if (vobj != null) {
                            value = df.format((Date)vobj);
                        }
                    } else if ("pay_method".equals(entry.getKey())) {
                        if (vobj != null) {
                            value = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get((Integer)vobj);
                        }
                    } else if ("pay_scene".equals(entry.getKey())) {
                        if (vobj != null) {
                            value = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap().get((Integer)vobj);
                        }
                    } else if ("charge_org".equals(entry.getKey())) {
                        if (vobj != null) {
                            value = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap().get((Integer)vobj);
                        }
                    } else if (vobj != null) {
                        value = vobj.toString();
                    }
                    if (moneySet.contains(entry.getKey())) {
                        this.addMoney(totalMoneyMap, entry.getKey(), vobj);
                    }
                    writer.write(value == null ? "" : value);
                }
                writer.endRecord();
                writer.flush();
            }
        } while (dataList.size() >= fetchSize);
        for (Map.Entry<String, String> entry : headArr.entrySet()) {
            if ("tran_time".equals(entry.getKey())) {
                writer.write("\u603b\u8ba1\uff1a");
                continue;
            }
            if (moneySet.contains(entry.getKey())) {
                writer.write(this.getMoney(totalMoneyMap, entry.getKey()));
                continue;
            }
            writer.write("");
        }
        writer.endRecord();
        writer.flush();
    }

    @Override
    public void exportExitRecordCsv(SearchParam searchParam, Map<String, String> headArr, PrintWriter out) throws Exception {
        List dataList;
        CsvWriter writer = new CsvWriter((Writer)out, ',');
        for (Map.Entry<String, String> entry : headArr.entrySet()) {
            writer.write(entry.getValue());
        }
        writer.endRecord();
        writer.flush();
        searchParam.setOrder_by("id");
        int fetchSize = 500;
        long id = 0L;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
        String enter_time = "enter_time";
        String exit_time = "exit_time";
        String enter_valid_date = "enter_valid_date";
        String exit_valid_date = "exit_valid_date";
        String enter_plate_source = "enter_plate_source";
        String exit_plate_source = "exit_plate_source";
        String enter_balance = "enter_balance";
        String exit_balance = "exit_balance";
        String _pass_type = "pass_type";
        String parkTimeLen = "parkTimeLen";
        String exit_fee_time_length = "exit_fee_time_length";
        String discount_des = "discount_des";
        String discount_times = "discount_times";
        String discount_source = "discount_source";
        String discount_method = "discount_method";
        String discount_value = "discount_value";
        String discount_time = "discount_time";
        HashMap<String, BigDecimal> totalMoneyMap = new HashMap<String, BigDecimal>();
        HashSet<String> moneySet = new HashSet<String>();
        moneySet.add("exit_should_charge");
        moneySet.add("period_multi_free");
        moneySet.add("discount_money");
        moneySet.add("already_paid");
        moneySet.add("cash_pay");
        moneySet.add("deduct_money");
        String idstr = "id";
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        do {
            Pagination p = new Pagination();
            p.setRecordsCount((long)fetchSize);
            p.setNeedQueryCount(false);
            p.setGotoPage(1);
            p.setPageSize(fetchSize);
            SearchParam searchParam0 = new SearchParam();
            searchParam.copyTo(searchParam0);
            searchParam0.addGT("id", (Object)id);
            dataList = commonDaoService.selectList(searchParam0, p);
            if (dataList == null || dataList.isEmpty()) break;
            if (dataList == null || dataList.isEmpty()) continue;
            for (Map dataMap : dataList) {
                id = (Long)dataMap.get(idstr);
                for (Map.Entry<String, String> entry : headArr.entrySet()) {
                    String vobj;
                    String value = null;
                    if ("parkTimeLen".equals(entry.getKey())) {
                        if (dataMap.get("enter_time") == null || dataMap.get("exit_time") == null) {
                            vobj = "";
                        } else {
                            long a = ((Date)dataMap.get("exit_time")).getTime() - ((Date)dataMap.get("enter_time")).getTime();
                            if (a > 0L) {
                                int secs = (int)TimeUnit.MILLISECONDS.toSeconds(a);
                                vobj = appService.getTimeLenSecDes(secs);
                            } else {
                                vobj = "\u4e0d\u8db31\u5206\u949f";
                            }
                        }
                    } else if ("discount_des".equals(entry.getKey())) {
                        Integer diM = (Integer)dataMap.get("discount_method");
                        Integer diV = (Integer)dataMap.get("discount_value");
                        Integer diT = (Integer)dataMap.get("discount_times");
                        vobj = diT != null && diM != null && diV != null && diT > 0 ? appService.getDiscountValueDes(diM, diV) : "";
                    } else {
                        Integer ds;
                        vobj = "discount_source".equals(entry.getKey()) ? ((ds = (Integer)dataMap.get("discount_source")) == null ? "" : Constants.getDisocuntSourceMap().get(ds)) : dataMap.get(entry.getKey());
                    }
                    if ("enter_time".equals(entry.getKey()) || "exit_time".equals(entry.getKey()) || "discount_time".equals(entry.getKey())) {
                        if (vobj != null) {
                            value = df.format((Date)((Object)vobj));
                        }
                    } else if ("enter_valid_date".equals(entry.getKey()) || "exit_valid_date".equals(entry.getKey())) {
                        Integer pass_type;
                        if (vobj != null && (pass_type = (Integer)dataMap.get("pass_type")) != null && pass_type == 2) {
                            value = df1.format((Date)((Object)vobj));
                        }
                    } else if ("enter_balance".equals(entry.getKey()) || "exit_balance".equals(entry.getKey())) {
                        Integer pass_type;
                        if (vobj != null && (pass_type = (Integer)dataMap.get("pass_type")) != null && pass_type == 1) {
                            value = vobj.toString();
                        }
                    } else if ("enter_plate_source".equals(entry.getKey()) || "exit_plate_source".equals(entry.getKey())) {
                        if (vobj != null) {
                            int a = (Integer)((Object)vobj);
                            if (a == 0) {
                                value = "\u8f66\u724c\u8bc6\u522b";
                            } else if (a == 1) {
                                value = "\u4eba\u5de5\u653e\u884c";
                            } else if (a == 2) {
                                String enter_plate_modify_user_name = (String)dataMap.get("enter_plate_modify_user_name");
                                value = enter_plate_modify_user_name != null && enter_plate_modify_user_name.length() > 0 ? String.valueOf(enter_plate_modify_user_name) + "\u4fee\u6539\u8f66\u724c" : "\u4eba\u5de5\u4fee\u6539\u8f66\u724c";
                            } else if (a == 3) {
                                value = "ETC";
                            } else if (a == 4) {
                                value = "\u6a21\u7cca\u5339\u914d";
                            }
                        }
                    } else if ("exit_fee_time_length".equals(entry.getKey())) {
                        Integer t = (Integer)((Object)vobj);
                        if (t != null && t >= 0) {
                            value = appService.getTimeLenDes(t);
                        }
                    } else if (vobj != null) {
                        value = vobj.toString();
                    }
                    if (moneySet.contains(entry.getKey())) {
                        this.addMoney(totalMoneyMap, entry.getKey(), vobj);
                    }
                    writer.write(value == null ? "" : value);
                }
                writer.endRecord();
                writer.flush();
            }
        } while (dataList.size() >= fetchSize);
        for (Map.Entry<String, String> entry : headArr.entrySet()) {
            if ("exit_fee_time_length".equals(entry.getKey())) {
                writer.write("\u603b\u8ba1\uff1a");
                continue;
            }
            if (moneySet.contains(entry.getKey())) {
                writer.write(this.getMoney(totalMoneyMap, entry.getKey()));
                continue;
            }
            writer.write("");
        }
        writer.endRecord();
        writer.flush();
    }

    @Override
    public void exportMonthPayRecordCsv(SearchParam searchParam, Map<String, String> headArr, PrintWriter out) throws Exception {
        List dataList;
        CsvWriter writer = new CsvWriter((Writer)out, ',');
        for (Map.Entry<String, String> entry : headArr.entrySet()) {
            writer.write(entry.getValue());
        }
        writer.endRecord();
        writer.flush();
        searchParam.setOrder_by("id");
        int fetchSize = 500;
        long id = 0L;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
        String tran_time = "tran_time";
        String tran_money = "tran_money";
        String pay_method = "pay_method";
        String pay_scene = "pay_scene";
        String charge_org = "charge_org";
        String valid_date_before = "valid_date_before";
        String start_date = "start_date";
        String end_date = "end_date";
        String tran_quantity = "tran_quantity";
        String N_recharge_money = "recharge_money";
        String N_balance_before = "balance_before";
        String N_balance = "balance";
        String N_service_type = "service_type";
        HashMap<String, BigDecimal> totalMoneyMap = new HashMap<String, BigDecimal>();
        HashSet<String> moneySet = new HashSet<String>();
        moneySet.add("tran_money");
        String idstr = "id";
        do {
            Pagination p = new Pagination();
            p.setRecordsCount((long)fetchSize);
            p.setNeedQueryCount(false);
            p.setGotoPage(1);
            p.setPageSize(fetchSize);
            SearchParam searchParam0 = new SearchParam();
            searchParam.copyTo(searchParam0);
            searchParam0.addGT("id", (Object)id);
            dataList = commonDaoService.selectList(searchParam0, p);
            if (dataList == null || dataList.isEmpty()) break;
            if (dataList == null || dataList.isEmpty()) continue;
            for (Map dataMap : dataList) {
                BigDecimal re;
                BigDecimal balance;
                id = (Long)dataMap.get(idstr);
                Integer serviceType = (Integer)dataMap.get("service_type");
                if (serviceType != null && serviceType == 5 && (balance = (BigDecimal)dataMap.get("balance")) == null && (re = (BigDecimal)dataMap.get("recharge_money")) != null) {
                    BigDecimal balanceBfor = (BigDecimal)dataMap.get("balance_before");
                    if (balanceBfor == null) {
                        balanceBfor = Constants.MONEY_ZERO;
                        dataMap.put("balance_before", balanceBfor);
                    }
                    balance = re.add(balanceBfor);
                    dataMap.put("balance", balance);
                }
                for (Map.Entry<String, String> entry : headArr.entrySet()) {
                    String value = null;
                    Object vobj = dataMap.get(entry.getKey());
                    if ("tran_time".equals(entry.getKey())) {
                        if (vobj != null) {
                            value = df.format((Date)vobj);
                        }
                    } else if ("valid_date_before".equals(entry.getKey()) || "start_date".equals(entry.getKey()) || "end_date".equals(entry.getKey())) {
                        if (vobj != null) {
                            value = df1.format((Date)vobj);
                        }
                    } else if ("pay_method".equals(entry.getKey())) {
                        if (vobj != null) {
                            value = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get((Integer)vobj);
                        }
                    } else if ("pay_scene".equals(entry.getKey())) {
                        if (vobj != null) {
                            value = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap().get((Integer)vobj);
                        }
                    } else if ("charge_org".equals(entry.getKey())) {
                        if (vobj != null) {
                            value = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap().get((Integer)vobj);
                        }
                    } else if ("tran_quantity".equals(entry.getKey())) {
                        Integer tran_unit = (Integer)dataMap.get("tran_unit");
                        Integer _tran_quantity = (Integer)dataMap.get("tran_quantity");
                        if (_tran_quantity == null || tran_unit == null) {
                            value = "\u81ea\u5b9a\u4e49";
                        } else {
                            String vaa = tran_unit == 1 ? "\u5929" : (tran_unit == 2 ? "\u4e2a\u6708" : (tran_unit == 3 ? "\u5e74" : ""));
                            value = _tran_quantity + vaa;
                        }
                    } else if (vobj != null) {
                        value = vobj.toString();
                    }
                    if (moneySet.contains(entry.getKey())) {
                        this.addMoney(totalMoneyMap, entry.getKey(), vobj);
                    }
                    writer.write(value == null ? "" : value);
                }
                writer.endRecord();
                writer.flush();
            }
        } while (dataList.size() >= fetchSize);
        for (Map.Entry<String, String> entry : headArr.entrySet()) {
            if ("tran_time".equals(entry.getKey())) {
                writer.write("\u603b\u8ba1\uff1a");
                continue;
            }
            if (moneySet.contains(entry.getKey())) {
                writer.write(this.getMoney(totalMoneyMap, entry.getKey()));
                continue;
            }
            writer.write("");
        }
        writer.endRecord();
        writer.flush();
    }

    @Override
    public void exportInvoiceRecordCsv(SearchParam searchParam, Map<String, String> headArr, PrintWriter out) throws Exception {
        List dataList;
        CsvWriter writer = new CsvWriter((Writer)out, ',');
        for (Map.Entry<String, String> entry : headArr.entrySet()) {
            writer.write(entry.getValue());
        }
        writer.endRecord();
        writer.flush();
        searchParam.setOrder_by("id");
        int fetchSize = 500;
        long id = 0L;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String invoice_success_time = "invoice_success_time";
        String created_time = "created_time";
        String project_rateStr = "project_rate";
        String project_countStr = "project_count";
        String tran_countStr = "tran_count";
        HashMap<String, BigDecimal> totalMoneyMap = new HashMap<String, BigDecimal>();
        HashSet<String> moneySet = new HashSet<String>();
        moneySet.add("project_amount");
        moneySet.add("project_rate_money");
        moneySet.add("project_rate_amount");
        moneySet.add("tran_count");
        String idstr = "id";
        do {
            Pagination p = new Pagination();
            p.setRecordsCount((long)fetchSize);
            p.setNeedQueryCount(false);
            p.setGotoPage(1);
            p.setPageSize(fetchSize);
            SearchParam searchParam0 = new SearchParam();
            searchParam.copyTo(searchParam0);
            searchParam0.addGT("id", (Object)id);
            dataList = commonDaoService.selectList(searchParam0, p);
            if (dataList == null || dataList.isEmpty()) break;
            if (dataList == null || dataList.isEmpty()) continue;
            for (Map dataMap : dataList) {
                id = (Long)dataMap.get(idstr);
                Integer tranCout = (Integer)dataMap.get("tran_count");
                if (tranCout == null) {
                    tranCout = 0;
                }
                dataMap.put("tran_count", new BigDecimal(tranCout));
                for (Map.Entry<String, String> entry : headArr.entrySet()) {
                    String value = null;
                    Object vobj = dataMap.get(entry.getKey());
                    if ("invoice_success_time".equals(entry.getKey()) || "created_time".equals(entry.getKey())) {
                        if (vobj != null) {
                            value = df.format((Date)vobj);
                        }
                    } else if ("project_rate".equals(entry.getKey())) {
                        BigDecimal project_rate;
                        if (vobj != null && (project_rate = (BigDecimal)vobj) != null) {
                            double a = project_rate.doubleValue() * 100.0;
                            value = a == (double)((int)a) ? String.valueOf((int)a) + "%" : String.valueOf(a) + "%";
                        }
                    } else if ("project_count".equals(entry.getKey())) {
                        BigDecimal project_count;
                        if (vobj != null && (project_count = (BigDecimal)vobj) != null) {
                            value = (double)project_count.intValue() == project_count.doubleValue() ? String.valueOf(project_count.intValue()) : project_count.toString();
                        }
                    } else if ("tran_count".equals(entry.getKey())) {
                        value = tranCout.toString();
                    } else if (vobj != null) {
                        value = vobj.toString();
                    }
                    if (moneySet.contains(entry.getKey())) {
                        this.addMoney(totalMoneyMap, entry.getKey(), vobj);
                    }
                    writer.write(value == null ? "" : value);
                }
                writer.endRecord();
                writer.flush();
            }
        } while (dataList.size() >= fetchSize);
        for (Map.Entry<String, String> entry : headArr.entrySet()) {
            if ("project_name".equals(entry.getKey())) {
                writer.write("\u603b\u8ba1\uff1a");
                continue;
            }
            if (moneySet.contains(entry.getKey())) {
                if ("tran_count".equals(entry.getKey())) {
                    BigDecimal m1 = (BigDecimal)totalMoneyMap.get(entry.getKey());
                    if (m1 == null) {
                        m1 = Constants.MONEY_ZERO;
                    }
                    writer.write(String.valueOf(m1.intValue()));
                    continue;
                }
                writer.write(this.getMoney(totalMoneyMap, entry.getKey()));
                continue;
            }
            writer.write("");
        }
        writer.endRecord();
        writer.flush();
    }
}

