/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.service.impl;

import com.google.gson.Gson;
import com.wovoe.carpark.CarparkPassRecordListener;
import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.DispatchDataTaskUtil;
import com.wovoe.carpark.IllegalPassRecordListener;
import com.wovoe.carpark.KeyLockManager;
import com.wovoe.carpark.ParkingSpace;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.RpcReomtecServiceFactory;
import com.wovoe.carpark.UserSession;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.conn.udp.CarparkUdpConnSession;
import com.wovoe.carpark.conn.udp.CarparkUdpP2pConnection;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCancelPassRecord;
import com.wovoe.carpark.dto.CarparkCarOwner;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkDiscountRecord;
import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkEscapeOrder;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkIllegalPassRecord;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.dto.CarparkOperationLog;
import com.wovoe.carpark.dto.CarparkPassDiscount;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassSelfPay;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPlateCarType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkRegplateRecord;
import com.wovoe.carpark.dto.CarparkSpaceAdjustment;
import com.wovoe.carpark.dto.CarparkSpaceType;
import com.wovoe.carpark.dto.CarparkSpaceTypeDefine;
import com.wovoe.carpark.dto.CarparkSpaceTypeQuantity;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.event.app.CaptureEvent;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.app.PlateRecognizedEvent;
import com.wovoe.carpark.event.app.RefreshPresenceRecordEvent;
import com.wovoe.carpark.event.equipment.DetectedPassEvent;
import com.wovoe.carpark.event.equipment.VehicleTypeEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.service.remote.CommonRemoteService;
import com.wovoe.carpark.vo.PassVo;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.JavaBeanTool;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.Service;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.transfer.ResultResponse;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.session.SqlSession;

@Service
public class RecordSaveServiceImpl
implements RecordSaveService {
    private CopyOnWriteArrayList<CarparkPassRecordListener> carparkPassRecordListeners = new CopyOnWriteArrayList();
    private KeyLockManager passRecordHandleLockManager = new KeyLockManager();
    private CopyOnWriteArrayList<IllegalPassRecordListener> illegalPassRecordListeners = new CopyOnWriteArrayList();

    @Override
    public void savePlateRecognizedEvent(PlateRecognizedEvent event, boolean uploadToServer) {
        if (event.getPlateNumber() == null || event.getPlateNumber().length() == 0) {
            return;
        }
        event.setPicDBPath(this.getDbPicPath(event.getPicPath()));
        event.setPicDBSmallPath(this.getDbPicPath(event.getPlateSmallPath()));
        CarparkRegplateRecord record = new CarparkRegplateRecord();
        record.setCamera_no(event.getCameraEquipmentNo());
        record.setCar_color(ServiceUtil.getString(event.getVehicleColor(), 10));
        record.setCar_dir(ServiceUtil.getString(event.getDirDes(), 20));
        record.setCar_logo(ServiceUtil.getString(event.getCarLogo(), 20));
        record.setTrigger_method(event.getTrigger_method());
        if (event.getCarSpeed() != null) {
            record.setCar_speed(ServiceUtil.getString(event.getCarSpeed().toString(), 10));
        }
        record.setCar_type(ServiceUtil.getString(event.getCarTypeDes(), 20));
        record.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
        record.setChannel_no(event.getChannelNo());
        record.setHost_no(ServiceUtil.getServiceContext().getLocalHostNo());
        record.setPlate_color(ServiceUtil.getString(event.getPlateColor(), 10));
        if (event.getPlateConfidence() != null) {
            record.setPlate_confi(ServiceUtil.getString(event.getPlateConfidence().toString(), 10));
        }
        record.setPlate_judge(ServiceUtil.getString(event.getPlateJudgeDes(), 10));
        record.setPlate_number(ServiceUtil.getString(event.getPlateNumber(), 20));
        record.setPlate_type(ServiceUtil.getString(event.getPlateTypeDes(), 20));
        record.setProject_id(ServiceUtil.getServiceContext().getProjectId());
        record.setReg_time(ServiceUtil.getDatetime(new Date(event.getRegSystemTimeMills())));
        record.setBig_pic_path(ServiceUtil.getString(event.getPicDBPath(), 200));
        record.setSmall_pic_path(ServiceUtil.getString(event.getPicDBSmallPath(), 200));
        if (event.getCarmeraRegTimeMills() != null) {
            record.setCamera_reg_time(event.getCarmeraRegTimeMills());
        } else {
            record.setCamera_reg_time(event.getRegSystemTimeMills());
        }
        LinkedList<CarparkDispatchTask> taskList = null;
        boolean picAlreadyDispath = false;
        boolean hasPicUpload = false;
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        try (SqlSession session = daoService.openSqlSession();){
            try {
                long rid = appService.createLocalRecordSeq("ck_carpark_regplate_record_seq");
                record.setId(rid);
                record.setReg_no("C" + record.getId().toString());
                if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != 1 && uploadToServer) {
                    CarparkLocalConfig localConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig();
                    if (localConfig != null && localConfig.getHost_use() == 1) {
                        String dipathPicType;
                        taskList = new LinkedList<CarparkDispatchTask>();
                        if (event.getDipathPicType() != null && event.getDipathPicType().length() > 0 && "CARPARK_SERVER".equals(event.getDipathPicType())) {
                            dipathPicType = "CARPARK_SERVER";
                        } else if (event.getPlateNumber() != null && event.getPlateNumber().length() > 5 && event.getPlateNumber().indexOf(26080) == -1) {
                            dipathPicType = "ALL_HOSTS_PC";
                            picAlreadyDispath = true;
                        } else {
                            dipathPicType = "CARPARK_SERVER";
                        }
                        boolean needUpIc = true;
                        if (localConfig.getNet_mode() == 2) {
                            CarparkUdpP2pConnection conn = ServiceUtil.getServiceContext().getCarparkUdpP2pConnection();
                            if (conn == null) {
                                needUpIc = false;
                            } else {
                                CarparkUdpConnSession sessiono = conn.getConnectedServerSession();
                                if (sessiono == null) {
                                    needUpIc = false;
                                } else if (sessiono.isUseCloudProxy()) {
                                    needUpIc = false;
                                }
                            }
                        }
                        if (needUpIc) {
                            taskList.addAll(DispatchDataTaskUtil.createDispatchLocalPicTaskList(event.getPicDBPath(), dipathPicType));
                            taskList.addAll(DispatchDataTaskUtil.createDispatchLocalPicTaskList(event.getPicDBSmallPath(), dipathPicType));
                            if (!taskList.isEmpty()) {
                                hasPicUpload = true;
                            }
                        } else {
                            picAlreadyDispath = false;
                        }
                        taskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(daoService.getTableName(CarparkRegplateRecord.class), record.getId(), "CARPARK_SERVER"));
                    } else {
                        picAlreadyDispath = false;
                        hasPicUpload = false;
                    }
                }
                daoService.insert(session, (Object)record);
                if (taskList != null && !taskList.isEmpty()) {
                    for (CarparkDispatchTask h : taskList) {
                        daoService.insert(session, (Object)h);
                    }
                }
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        event.setPicAlreadyDispath(picAlreadyDispath);
        if (taskList != null && !taskList.isEmpty()) {
            if (hasPicUpload) {
                event.setRegRecordAndPicTaskList(taskList);
                ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject(taskList, (Object)event, new TimeoutObjectPool.TimeoutCallback(){

                    public void onTimeout(Object arg0, Object arg1) throws Exception {
                        if (arg1 instanceof PlateRecognizedEvent) {
                            ((PlateRecognizedEvent)arg1).asyncExeTask();
                        }
                    }
                }, 8L, TimeUnit.SECONDS);
            } else {
                appService.asynTryRunDispatchTask(taskList);
            }
        }
    }

    @Override
    public String getDbPicPath(String picPath) {
        if (picPath == null) {
            return null;
        }
        if (picPath.length() == 0) {
            return picPath;
        }
        File picDir = PathFinder.findLocalPicDir();
        String x1 = picDir.toURI().toString();
        File f1 = new File(picPath);
        String x2 = f1.toURI().toString();
        if (x2.startsWith(x1)) {
            String ur3 = x2.substring(x1.length());
            if (ur3.startsWith("/")) {
                ur3 = ur3.substring(1);
            }
            return ur3;
        }
        String path = "/local/pic/";
        int index = x2.lastIndexOf(path);
        if (index > 0) {
            String ur3 = x2.substring(index + path.length());
            return ur3;
        }
        return picPath;
    }

    @Override
    public String getLocalPicPath(String dbPicPath) {
        return new File(PathFinder.findLocalPicDir(), dbPicPath).getAbsolutePath();
    }

    private void handlePassRecordCarType(CommonDaoService daoService, SqlSession session, CarparkPassRecord passRecord) {
        Date d;
        CarparkPlateCarType platecarType;
        String passPlate;
        Date passTime;
        String passCarType;
        int arc;
        String vrese = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("MEND_CAR_TYPE_MERMERY_DAYS");
        if (vrese == null || vrese.length() == 0) {
            vrese = "180";
        }
        try {
            arc = Integer.parseInt(vrese);
            if (arc < 0) {
                arc = 0;
            } else if (arc > 365) {
                arc = 365;
            }
        }
        catch (Exception ex) {
            arc = 0;
        }
        if (arc == 0) {
            return;
        }
        if (passRecord.getExit_time() != null) {
            passCarType = passRecord.getExit_car_type_no();
            passTime = passRecord.getExit_time();
            passPlate = passRecord.getExit_plate();
        } else {
            passCarType = passRecord.getEnter_car_type_no();
            passTime = passRecord.getEnter_time();
            passPlate = passRecord.getEnter_plate();
        }
        if (passPlate == null || passPlate.length() == 0) {
            passPlate = passRecord.getPass_plate();
        }
        if (passTime != null && passPlate != null && passPlate.length() > 6 && passPlate.length() < 10 && passCarType != null && passCarType.length() > 0 && (platecarType = (CarparkPlateCarType)daoService.selectOne(session, new SearchParam().addEQ("plate_number", (Object)passPlate), CarparkPlateCarType.class)) != null && passCarType.equals(platecarType.getCar_type_no()) && ((d = platecarType.getLast_updated_time()) == null || d.getTime() <= passTime.getTime())) {
            CommonParam p = new CommonParam(daoService.getTableName(CarparkPlateCarType.class));
            p.addEQ("plate_number", (Object)passPlate);
            p.addUpdate("last_updated_time", (Object)passTime);
            daoService.update(session, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePresenceRecord(SqlSession session, CarparkPassRecord passRecord) {
        String lockkey0;
        List<String> subAreaList;
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        if (passRecord.getArea_level() == null || passRecord.getPassport_number() == null || passRecord.getPassport_number().length() == 0 || passRecord.getMedium_type() == null || passRecord.getId() == null || passRecord.getArea_no() == null || passRecord.getArea_no().length() == 0) {
            return;
        }
        String lockkey = "handlePresenceRecord_" + passRecord.getPassport_number() + "+" + passRecord.getMedium_type();
        Object lock = this.passRecordHandleLockManager.getLock(lockkey);
        try {
            Object object = lock;
            synchronized (object) {
                String presenceRecordTable;
                this.handlePassRecordCarType(daoService, session, passRecord);
                if (passRecord.getExit_time() != null) {
                    Object t;
                    Map<String, CarparkPassportType> passportTypeMap;
                    presenceRecordTable = daoService.getTableName(CarparkPresenceRecord.class);
                    SearchParam delP = new SearchParam(presenceRecordTable);
                    delP.addEQ("passport_number", (Object)passRecord.getPassport_number());
                    delP.addEQ("medium_type", (Object)passRecord.getMedium_type());
                    delP.addLTE("enter_time", (Object)passRecord.getExit_time());
                    LinkedList<String> areaSet = new LinkedList<String>();
                    areaSet.add(passRecord.getArea_no());
                    List<String> subAreaList2 = ServiceUtil.getServiceContext().getDBConfigCache().getAllSbuArea(passRecord.getArea_no());
                    if (subAreaList2 != null && !subAreaList2.isEmpty()) {
                        areaSet.addAll(subAreaList2);
                    }
                    if (areaSet.size() == 1) {
                        delP.addEQ("area_no", areaSet.get(0));
                    } else {
                        delP.addINList("area_no", areaSet);
                    }
                    daoService.delete(session, delP);
                    if (passRecord.getEnter_passport_type_no() != null && passRecord.getEnter_passport_type_no().length() > 0 && passRecord.getTake_enter_time() != null && passRecord.getTake_passport_type_no() != null && passRecord.getTake_passport_type_no().length() > 0 && passRecord.getTake_plate_number() != null && passRecord.getTake_plate_number().length() > 0) {
                        passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                        t = null;
                        if (passportTypeMap != null) {
                            t = passportTypeMap.get(passRecord.getEnter_passport_type_no());
                        }
                        if (t != null) {
                            CommonParam updateParam = new CommonParam(presenceRecordTable);
                            updateParam.addUpdate("enter_passport_type_no", (Object)((CarparkPassportType)t).getPassport_type_no());
                            updateParam.addUpdate("pass_type", (Object)((CarparkPassportType)t).getPass_type());
                            updateParam.addUpdate("passport_type_no", (Object)((CarparkPassportType)t).getPassport_type_no());
                            updateParam.addUpdate("passport_type_name", (Object)((CarparkPassportType)t).getPassport_type_name());
                            updateParam.addEQ("passport_type_no", (Object)passRecord.getTake_passport_type_no());
                            updateParam.addEQ("passport_number", (Object)passRecord.getTake_plate_number());
                            updateParam.addEQ("area_no", (Object)passRecord.getArea_no());
                            updateParam.addEQ("enter_time", (Object)passRecord.getTake_enter_time());
                            daoService.update(session, updateParam);
                        }
                    }
                    if (passRecord.getArea_level() == 1 && passRecord.getChange_plate() != null && passRecord.getChange_plate().length() > 0 && passRecord.getChange_enter_time() != null && passRecord.getChange_pass_type_no() != null && passRecord.getChange_pass_type_no().length() > 0 && !passRecord.getChange_plate().equals(passRecord.getPass_plate())) {
                        passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                        t = null;
                        CarparkPassportType t1 = null;
                        if (passportTypeMap != null) {
                            t = passportTypeMap.get(passRecord.getChange_pass_type_no());
                            t1 = passportTypeMap.get(passRecord.getPassport_type_no());
                        }
                        if (t != null && t1 != null && ((CarparkPassportType)t).getPass_type() == 0 && t1.getPass_type() != 0) {
                            SearchParam p = new SearchParam(presenceRecordTable);
                            p.addEQ("carpark_id", (Object)passRecord.getCarpark_id());
                            p.addEQ("passport_number", (Object)passRecord.getChange_plate());
                            p.addEQ("enter_plate", (Object)passRecord.getChange_plate());
                            p.addEQ("enter_time", (Object)passRecord.getChange_enter_time());
                            p.addEQ("area_no", (Object)passRecord.getArea_no());
                            CarparkPresenceRecord r = (CarparkPresenceRecord)daoService.selectOne(p, CarparkPresenceRecord.class);
                            if (r != null && r.getEnter_time().getTime() < passRecord.getExit_time().getTime()) {
                                CommonParam updateParam = new CommonParam(presenceRecordTable);
                                updateParam.addUpdate("enter_passport_type_no", (Object)t1.getPassport_type_no());
                                updateParam.addUpdate("pass_type", (Object)t1.getPass_type());
                                updateParam.addUpdate("passport_type_no", (Object)t1.getPassport_type_no());
                                updateParam.addUpdate("passport_type_name", (Object)t1.getPassport_type_name());
                                updateParam.addUpdate("occupy_space_reg_no", (Object)(passRecord.getOccupy_space_reg_no() == null ? "" : passRecord.getOccupy_space_reg_no()));
                                updateParam.addUpdate("occupy_plate", (Object)passRecord.getPass_plate());
                                updateParam.addUpdate("occupy_end_time", (Object)passRecord.getExit_time());
                                updateParam.addUpdate("occupy_passport_type_no", (Object)((CarparkPassportType)t).getPassport_type_no());
                                updateParam.addEQ("id", (Object)r.getId());
                                daoService.update(session, updateParam);
                            }
                        }
                    }
                } else if (passRecord.getEnter_time() != null) {
                    Pagination p;
                    presenceRecordTable = daoService.getTableName(CarparkPresenceRecord.class);
                    List presentlist = daoService.selectList(session, new SearchParam(presenceRecordTable).setQueryFields(new String[]{"id", "enter_time", "area_level", "area_no", "exit_time"}).addEQ("passport_number", (Object)passRecord.getPassport_number()).addEQ("medium_type", (Object)passRecord.getMedium_type()).setOrerbySql("enter_time"), null);
                    if (passRecord.getArea_level() == 1) {
                        LinkedList<Long> delList = new LinkedList<Long>();
                        boolean existOutGTTime = false;
                        if (presentlist != null && !presentlist.isEmpty()) {
                            for (Map obj : presentlist) {
                                Long id = (Long)obj.get("id");
                                if (id == null) continue;
                                Date enter_time = (Date)obj.get("enter_time");
                                Integer area_level = (Integer)obj.get("area_level");
                                String area_no = (String)obj.get("area_no");
                                if (area_level == null || area_no == null || area_no.length() == 0 || enter_time == null) {
                                    delList.add(id);
                                    continue;
                                }
                                if (enter_time.getTime() <= passRecord.getEnter_time().getTime()) {
                                    delList.add(id);
                                    continue;
                                }
                                if (id.equals(passRecord.getId())) {
                                    delList.add(id);
                                    continue;
                                }
                                if (area_level != 1) continue;
                                existOutGTTime = true;
                            }
                        }
                        if (delList != null && !delList.isEmpty()) {
                            SearchParam delParam = new SearchParam(presenceRecordTable);
                            if (delList.size() == 1) {
                                delParam.addEQ("id", delList.get(0));
                            } else {
                                delParam.addINList("id", delList);
                            }
                            daoService.delete(session, delParam);
                        }
                        if (!existOutGTTime) {
                            SearchParam sParam = new SearchParam(daoService.getTableName(CarparkPassRecord.class));
                            p = new Pagination();
                            p.setGotoPage(1);
                            p.setNeedQueryCount(false);
                            p.setRecordsCount(1L);
                            p.setPageSize(1);
                            sParam.addEQ("passport_number", (Object)passRecord.getPassport_number());
                            sParam.addEQ("medium_type", (Object)passRecord.getMedium_type());
                            sParam.addEQ("area_level", (Object)1);
                            sParam.addGT("pass_time", (Object)passRecord.getEnter_time());
                            sParam.setOrerbySql("id");
                            sParam.setQueryFields(new String[]{"id"});
                            Map gtRecord = daoService.selectOne(session, sParam, p);
                            if (gtRecord == null) {
                                SearchParam sParam1 = new SearchParam(presenceRecordTable);
                                sParam1.addEQ("id", (Object)passRecord.getId());
                                sParam1.setQueryFields(new String[]{"id", "enter_record_no", "enter_time", "enter_plate", "enter_channel_name"});
                                CarparkPresenceRecord sameIdPresenceRecord = (CarparkPresenceRecord)daoService.selectOne(session, sParam1, CarparkPresenceRecord.class);
                                if (sameIdPresenceRecord != null) {
                                    long b;
                                    long a;
                                    ServiceLog.getLog().warn((Object)("\u8b66\u544a\u51fa\u73b0\u4e00\u7b14\u76f8\u540cid\u5728\u573a\u8bb0\u5f55\uff0c\u5df2\u5b58\u50a8\u8bb0\u5f55\uff1aid\uff1a" + sameIdPresenceRecord.getId() + ", \u8bb0\u5f55\u7f16\u53f7: " + sameIdPresenceRecord.getEnter_record_no() + ", \u8fdb\u573a\u65f6\u95f4: " + sameIdPresenceRecord.getEnter_time() + ", \u8fdb\u573a\u8f66\u724c: " + sameIdPresenceRecord.getEnter_plate() + ", \u8fdb\u573a\u8f66\u9053: " + sameIdPresenceRecord.getEnter_channel_name()));
                                    ServiceLog.getLog().warn((Object)("\u8b66\u544a\u51fa\u73b0\u4e00\u7b14\u76f8\u540cid\u5728\u573a\u8bb0\u5f55\uff0c\u540c\u6b65\u7684\u8bb0\u5f55\uff1aid\uff1a" + passRecord.getId() + ", \u8bb0\u5f55\u7f16\u53f7: " + passRecord.getEnter_record_no() + ", \u8fdb\u573a\u65f6\u95f4: " + passRecord.getEnter_time() + ", \u8fdb\u573a\u8f66\u724c: " + passRecord.getEnter_plate() + ", \u8fdb\u573a\u8f66\u9053: " + passRecord.getEnter_channel_name()));
                                    boolean deleteDb = sameIdPresenceRecord.getEnter_time() == null ? true : (passRecord.getEnter_time() == null ? false : (a = sameIdPresenceRecord.getEnter_time().getTime()) <= (b = passRecord.getEnter_time().getTime()));
                                    if (deleteDb) {
                                        ServiceLog.getLog().warn((Object)"\u8fd9\u5c06\u79fb\u9664\u5df2\u5b58\u50a8\u7684\u6570\u636e, \u4e00\u822c\u4e0d\u5e94\u8be5\u51fa\u73b0\u8fd9\u79cd\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5");
                                    } else {
                                        ServiceLog.getLog().warn((Object)"\u8fd9\u5c06\u4e22\u5f03\u540c\u6b65\u7684\u6570\u636e, \u4e00\u822c\u4e0d\u5e94\u8be5\u51fa\u73b0\u8fd9\u79cd\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5");
                                    }
                                    if (deleteDb) {
                                        SearchParam delParam = new SearchParam(presenceRecordTable);
                                        delParam.addEQ("id", (Object)passRecord.getId());
                                        daoService.delete(session, delParam);
                                        daoService.insert(session, (Object)passRecord, presenceRecordTable);
                                    }
                                } else {
                                    daoService.insert(session, (Object)passRecord, presenceRecordTable);
                                }
                            }
                        }
                    } else {
                        CarparkArea area;
                        List<String> outAreas;
                        Map<String, CarparkArea> mp = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
                        if (!(mp == null || passRecord.getPass_type() == null || passRecord.getPass_type() != 2 && passRecord.getPass_type() != 4 || (outAreas = ServiceUtil.getServiceContext().getDBConfigCache().getAllParentArea(passRecord.getArea_no())) == null || outAreas.isEmpty())) {
                            CarparkArea rootArea = null;
                            for (String s : outAreas) {
                                CarparkArea a = mp.get(s);
                                if (a == null || a.getArea_level() != 1) continue;
                                rootArea = a;
                                break;
                            }
                            if (rootArea != null) {
                                p = new SearchParam(presenceRecordTable);
                                p.addEQ("carpark_id", (Object)passRecord.getCarpark_id());
                                p.addEQ("passport_number", (Object)passRecord.getPassport_number());
                                p.addEQ("enter_plate", (Object)passRecord.getEnter_plate());
                                p.addLT("enter_time", (Object)passRecord.getEnter_time());
                                p.addEQ("area_no", (Object)rootArea.getArea_no());
                                CarparkPresenceRecord r = (CarparkPresenceRecord)daoService.selectOne((SearchParam)p, CarparkPresenceRecord.class);
                                if (!(r == null || r.getPassport_type_no() == null || r.getPass_type() == null || r.getPass_type() != 2 && r.getPass_type() != 4 || r.getPassport_type_no().equals(passRecord.getPassport_type_no()))) {
                                    boolean needUpdateOccupy = true;
                                    if (passRecord.getOccupy_passport_type_no() != null && passRecord.getOccupy_passport_type_no().length() > 0) {
                                        Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                                        CarparkPassportType t = null;
                                        if (passportTypeMap != null && (t = passportTypeMap.get(r.getPassport_type_no())) != null && t.getPass_type() == 0) {
                                            needUpdateOccupy = false;
                                        }
                                    }
                                    CommonParam updateParam = new CommonParam(presenceRecordTable);
                                    updateParam.addUpdate("enter_passport_type_no", (Object)passRecord.getPassport_type_no());
                                    updateParam.addUpdate("pass_type", (Object)passRecord.getPass_type());
                                    updateParam.addUpdate("passport_type_no", (Object)passRecord.getPassport_type_no());
                                    updateParam.addUpdate("passport_type_name", (Object)passRecord.getPassport_type_name());
                                    updateParam.addUpdate("occupy_space_reg_no", (Object)(passRecord.getOccupy_space_reg_no() == null ? "" : passRecord.getOccupy_space_reg_no()));
                                    if (needUpdateOccupy) {
                                        updateParam.addUpdate("occupy_plate", (Object)passRecord.getPass_plate());
                                        updateParam.addUpdate("occupy_end_time", (Object)passRecord.getEnter_time());
                                        updateParam.addUpdate("occupy_passport_type_no", (Object)r.getPassport_type_no());
                                    }
                                    updateParam.addEQ("id", (Object)r.getId());
                                    daoService.update(session, updateParam);
                                    if (passRecord.getChange_plate() != null && passRecord.getChange_plate().length() > 0 && passRecord.getChange_enter_time() != null && passRecord.getChange_pass_type_no() != null && passRecord.getChange_pass_type_no().length() > 0 && !passRecord.getChange_plate().equals(passRecord.getPass_plate())) {
                                        p = new SearchParam(presenceRecordTable);
                                        p.addEQ("carpark_id", (Object)passRecord.getCarpark_id());
                                        p.addEQ("passport_number", (Object)passRecord.getChange_plate());
                                        p.addEQ("enter_plate", (Object)passRecord.getChange_plate());
                                        p.addEQ("enter_time", (Object)passRecord.getChange_enter_time());
                                        p.addEQ("area_no", (Object)rootArea.getArea_no());
                                        CarparkPresenceRecord r1 = (CarparkPresenceRecord)daoService.selectOne((SearchParam)p, CarparkPresenceRecord.class);
                                        if (r1 != null && r1.getPassport_type_no() != null && r1.getPassport_type_no().equals(passRecord.getPassport_type_no())) {
                                            needUpdateOccupy = true;
                                            if (r1.getOccupy_passport_type_no() != null && r1.getOccupy_passport_type_no().length() > 0) {
                                                Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                                                CarparkPassportType t = null;
                                                if (passportTypeMap != null && (t = passportTypeMap.get(r1.getPassport_type_no())) != null && t.getPass_type() == 0) {
                                                    needUpdateOccupy = false;
                                                }
                                            }
                                            updateParam = new CommonParam(presenceRecordTable);
                                            updateParam.addUpdate("enter_passport_type_no", (Object)r.getPassport_type_no());
                                            updateParam.addUpdate("pass_type", (Object)r.getPass_type());
                                            updateParam.addUpdate("passport_type_no", (Object)r.getPassport_type_no());
                                            updateParam.addUpdate("passport_type_name", (Object)r.getPassport_type_name());
                                            updateParam.addUpdate("occupy_space_reg_no", (Object)(r.getOccupy_space_reg_no() == null ? "" : r.getOccupy_space_reg_no()));
                                            if (needUpdateOccupy) {
                                                updateParam.addUpdate("occupy_plate", (Object)passRecord.getPass_plate());
                                                updateParam.addUpdate("occupy_end_time", (Object)passRecord.getEnter_time());
                                                updateParam.addUpdate("occupy_passport_type_no", (Object)passRecord.getPassport_type_no());
                                            }
                                            updateParam.addEQ("id", (Object)r1.getId());
                                            daoService.update(session, updateParam);
                                        }
                                    }
                                }
                            }
                        }
                        HashSet<String> areaSet = new HashSet<String>();
                        areaSet.add(passRecord.getArea_no());
                        if (mp != null && (area = mp.get(passRecord.getArea_no())) != null && area.getParent_area_no() != null && area.getParent_area_no().length() > 0 && (subAreaList = ServiceUtil.getServiceContext().getDBConfigCache().getAllSbuArea(area.getParent_area_no())) != null && !subAreaList.isEmpty()) {
                            areaSet.addAll(subAreaList);
                        }
                        boolean existOutGTTime = false;
                        LinkedList<Long> delList = new LinkedList<Long>();
                        if (presentlist != null && !presentlist.isEmpty()) {
                            for (Map obj : presentlist) {
                                Long id = (Long)obj.get("id");
                                if (id == null) continue;
                                Date enter_time = (Date)obj.get("enter_time");
                                Integer area_level = (Integer)obj.get("area_level");
                                String area_no = (String)obj.get("area_no");
                                if (area_level == null || area_no == null || area_no.length() == 0 || enter_time == null) {
                                    delList.add(id);
                                    continue;
                                }
                                if (id.equals(passRecord.getId())) {
                                    delList.add(id);
                                    continue;
                                }
                                if (enter_time.getTime() <= passRecord.getEnter_time().getTime()) {
                                    if (!areaSet.contains(area_no)) continue;
                                    delList.add(id);
                                    continue;
                                }
                                if (area_level > passRecord.getArea_level()) continue;
                                existOutGTTime = true;
                            }
                        }
                        if (delList != null && !delList.isEmpty()) {
                            SearchParam delParam = new SearchParam(presenceRecordTable);
                            if (delList.size() == 1) {
                                delParam.addEQ("id", delList.get(0));
                            } else {
                                delParam.addINList("id", delList);
                            }
                            daoService.delete(session, delParam);
                        }
                        if (!existOutGTTime) {
                            SearchParam sParam = new SearchParam(daoService.getTableName(CarparkPassRecord.class));
                            Pagination p2 = new Pagination();
                            p2.setGotoPage(1);
                            p2.setNeedQueryCount(false);
                            p2.setRecordsCount(1L);
                            p2.setPageSize(1);
                            sParam.addEQ("passport_number", (Object)passRecord.getPassport_number());
                            sParam.addEQ("medium_type", (Object)passRecord.getMedium_type());
                            sParam.addLTE("area_level", (Object)passRecord.getArea_level());
                            sParam.addGT("pass_time", (Object)passRecord.getEnter_time());
                            sParam.setOrerbySql("id");
                            sParam.setQueryFields(new String[]{"id"});
                            Map gtRecord = daoService.selectOne(session, sParam, p2);
                            if (gtRecord == null) {
                                SearchParam sParam1 = new SearchParam(presenceRecordTable);
                                sParam1.addEQ("id", (Object)passRecord.getId());
                                sParam1.setQueryFields(new String[]{"id", "enter_record_no", "enter_time", "enter_plate", "enter_channel_name"});
                                CarparkPresenceRecord sameIdPresenceRecord = (CarparkPresenceRecord)daoService.selectOne(session, sParam1, CarparkPresenceRecord.class);
                                if (sameIdPresenceRecord != null) {
                                    long b;
                                    long a;
                                    ServiceLog.getLog().warn((Object)("\u8b66\u544a\u51fa\u73b0\u4e00\u7b14\u76f8\u540cid\u5728\u573a\u8bb0\u5f55\uff0c\u5df2\u5b58\u50a8\u8bb0\u5f55\uff1aid\uff1a" + sameIdPresenceRecord.getId() + ", \u8bb0\u5f55\u7f16\u53f7: " + sameIdPresenceRecord.getEnter_record_no() + ", \u8fdb\u573a\u65f6\u95f4: " + sameIdPresenceRecord.getEnter_time() + ", \u8fdb\u573a\u8f66\u724c: " + sameIdPresenceRecord.getEnter_plate() + ", \u8fdb\u573a\u8f66\u9053: " + sameIdPresenceRecord.getEnter_channel_name()));
                                    ServiceLog.getLog().warn((Object)("\u8b66\u544a\u51fa\u73b0\u4e00\u7b14\u76f8\u540cid\u5728\u573a\u8bb0\u5f55\uff0c\u540c\u6b65\u7684\u8bb0\u5f55\uff1aid\uff1a" + passRecord.getId() + ", \u8bb0\u5f55\u7f16\u53f7: " + passRecord.getEnter_record_no() + ", \u8fdb\u573a\u65f6\u95f4: " + passRecord.getEnter_time() + ", \u8fdb\u573a\u8f66\u724c: " + passRecord.getEnter_plate() + ", \u8fdb\u573a\u8f66\u9053: " + passRecord.getEnter_channel_name()));
                                    boolean deleteDb = sameIdPresenceRecord.getEnter_time() == null ? true : (passRecord.getEnter_time() == null ? false : (a = sameIdPresenceRecord.getEnter_time().getTime()) <= (b = passRecord.getEnter_time().getTime()));
                                    if (deleteDb) {
                                        ServiceLog.getLog().warn((Object)"\u8fd9\u5c06\u79fb\u9664\u5df2\u5b58\u50a8\u7684\u6570\u636e, \u4e00\u822c\u4e0d\u5e94\u8be5\u51fa\u73b0\u8fd9\u79cd\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5");
                                    } else {
                                        ServiceLog.getLog().warn((Object)"\u8fd9\u5c06\u4e22\u5f03\u540c\u6b65\u7684\u6570\u636e, \u4e00\u822c\u4e0d\u5e94\u8be5\u51fa\u73b0\u8fd9\u79cd\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5");
                                    }
                                    if (deleteDb) {
                                        SearchParam delParam = new SearchParam(presenceRecordTable);
                                        delParam.addEQ("id", (Object)passRecord.getId());
                                        daoService.delete(session, delParam);
                                        daoService.insert(session, (Object)passRecord, presenceRecordTable);
                                    }
                                } else {
                                    daoService.insert(session, (Object)passRecord, presenceRecordTable);
                                }
                            }
                        }
                    }
                }
            }
        }
        finally {
            this.passRecordHandleLockManager.releaseLock(lock);
        }
        if (passRecord.getExit_time() != null && passRecord.getEnter_plate() != null && passRecord.getEnter_plate().length() > 0 && passRecord.getExit_plate() != null && passRecord.getExit_plate().length() > 0 && !passRecord.getEnter_plate().equals(passRecord.getExit_plate()) && !(lockkey0 = "handlePresenceRecord_" + passRecord.getEnter_plate() + "+" + 6).equals(lockkey)) {
            Object lock0 = this.passRecordHandleLockManager.getLock(lockkey0);
            try {
                Object object = lock0;
                synchronized (object) {
                    String presenceRecordTable = daoService.getTableName(CarparkPresenceRecord.class);
                    SearchParam delP = new SearchParam(presenceRecordTable);
                    delP.addEQ("passport_number", (Object)passRecord.getEnter_plate());
                    delP.addEQ("medium_type", (Object)6);
                    delP.addLTE("enter_time", (Object)passRecord.getExit_time());
                    LinkedList<String> areaSet = new LinkedList<String>();
                    areaSet.add(passRecord.getArea_no());
                    subAreaList = ServiceUtil.getServiceContext().getDBConfigCache().getAllSbuArea(passRecord.getArea_no());
                    if (subAreaList != null && !subAreaList.isEmpty()) {
                        areaSet.addAll(subAreaList);
                    }
                    if (areaSet.size() == 1) {
                        delP.addEQ("area_no", areaSet.get(0));
                    } else {
                        delP.addINList("area_no", areaSet);
                    }
                    daoService.delete(session, delP);
                }
            }
            finally {
                this.passRecordHandleLockManager.releaseLock(lock0);
            }
        }
    }

    @Override
    public List<String> getEnterOutPlateList(String likePlate, int maxSize) {
        if (maxSize <= 0 || likePlate == null || likePlate.length() == 0) {
            return new LinkedList<String>();
        }
        ArrayList<String> list = new ArrayList<String>(maxSize);
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        int fetchSize = maxSize;
        Pagination p = new Pagination();
        p.setNeedQueryCount(false);
        p.setGotoPage(1);
        p.setPageSize(fetchSize);
        p.setRecordsCount((long)fetchSize);
        List plist = daoService.selectList(new SearchParam(daoService.getTableName(CarparkPassport.class)).setQueryFields(new String[]{"register_plate"}).addLike("register_plate", likePlate), p);
        if (plist != null && !plist.isEmpty()) {
            for (Map pm : plist) {
                String register_plate = (String)pm.get("register_plate");
                if (register_plate == null || register_plate.length() <= 0) continue;
                list.add(register_plate);
            }
        }
        if (list.size() < maxSize) {
            fetchSize = maxSize - list.size();
            p.setNeedQueryCount(false);
            p.setGotoPage(1);
            p.setPageSize(fetchSize);
            p.setRecordsCount((long)fetchSize);
            SearchParam s1 = new SearchParam(daoService.getTableName(CarparkPassRecord.class)).setQueryFields(new String[]{"DISTINCT pass_plate"});
            s1.addLike("pass_plate", likePlate);
            Calendar cl = Calendar.getInstance();
            Date now = cl.getTime();
            cl.add(5, -15);
            Date sd = cl.getTime();
            s1.addGTE("pass_time", (Object)sd);
            s1.addLTE("pass_time", (Object)now);
            if (list != null && !list.isEmpty()) {
                if (list.size() == 1) {
                    s1.addNotEQ("pass_plate", list.get(0));
                } else {
                    for (String s : list) {
                        s1.addNotIN("pass_plate", (Object)s);
                    }
                }
            }
            if ((plist = daoService.selectList(s1, p)) != null && !plist.isEmpty()) {
                for (Map pm : plist) {
                    String plate = (String)pm.get("pass_plate");
                    if (plate == null || plate.length() <= 0) continue;
                    list.add(plate);
                }
            }
        }
        return list;
    }

    @Override
    public List<String> getEnterInOrExitPalteList(String likePlate, int maxSize) {
        if (maxSize <= 0 || likePlate == null || likePlate.length() == 0) {
            return new LinkedList<String>();
        }
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        ArrayList<String> list = new ArrayList<String>(maxSize);
        int fetchSize = maxSize;
        Pagination p = new Pagination();
        p.setNeedQueryCount(false);
        p.setGotoPage(1);
        p.setPageSize(fetchSize);
        p.setRecordsCount((long)fetchSize);
        List plist = daoService.selectList(new SearchParam(daoService.getTableName(CarparkPresenceRecord.class)).setQueryFields(new String[]{"DISTINCT enter_plate"}).addLike("enter_plate", likePlate), p);
        if (plist != null && !plist.isEmpty()) {
            for (Map pm : plist) {
                String plate = (String)pm.get("enter_plate");
                if (plate == null || plate.length() <= 0) continue;
                list.add(plate);
            }
        }
        if (list.size() < maxSize) {
            fetchSize = maxSize - list.size();
            p.setNeedQueryCount(false);
            p.setGotoPage(1);
            p.setPageSize(fetchSize);
            p.setRecordsCount((long)fetchSize);
            SearchParam kl = new SearchParam(daoService.getTableName(CarparkPassport.class)).setQueryFields(new String[]{"register_plate"}).addLike("register_plate", likePlate);
            if (list != null && !list.isEmpty()) {
                if (list.size() == 1) {
                    kl.addNotEQ("register_plate", list.get(0));
                } else {
                    for (String s : list) {
                        kl.addNotIN("register_plate", (Object)s);
                    }
                }
            }
            if ((plist = daoService.selectList(kl, p)) != null && !plist.isEmpty()) {
                for (Map pm : plist) {
                    String register_plate = (String)pm.get("register_plate");
                    if (register_plate == null || register_plate.length() <= 0) continue;
                    list.add(register_plate);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deductMoney(SqlSession session, CarparkTransaction t) {
        CarparkHost localHost;
        if (t.getPassport_number() != null && t.getMedium_type() != null && t.getPay_method() != null && t.getPay_method() == 1 && t.getTran_money() != null && t.getTran_money().doubleValue() > 0.0 && (localHost = ServiceUtil.getServiceContext().getLocalHost()) != null && (localHost.getHost_use() == 2 || localHost.getHost_use() == 3)) {
            CommonParam p;
            Object object;
            Object lock;
            String lockkey;
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            boolean accountDecuctSuccess = false;
            if (t.getTran_user_no() != null && t.getTran_user_no().length() > 0 && t.getPassport_type_no() != null && "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CAR_OWNER_ACCOUNT_BALANCE")) && "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(t.getPassport_type_no(), "STOREAGE_DECUNT_AOUHNT"))) {
                lockkey = "updateCarOnwerBlance_" + t.getTran_user_no();
                lock = this.passRecordHandleLockManager.getLock(lockkey);
                try {
                    object = lock;
                    synchronized (object) {
                        CarparkCarOwner deductCarowner = (CarparkCarOwner)daoService.selectOne(session, new SearchParam().addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()).addEQ("car_owner_no", (Object)t.getTran_user_no()), CarparkCarOwner.class);
                        if (deductCarowner != null) {
                            p = new CommonParam(daoService.getTableName(CarparkCarOwner.class));
                            p.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                            p.addEQ("car_owner_no", (Object)deductCarowner.getCar_owner_no());
                            p.addUpdate("account_balance=account_balance-" + t.getTran_money());
                            p.addUpdate("last_updated_time", (Object)ServiceUtil.getNow());
                            daoService.update(session, p);
                            if (deductCarowner.getAccount_balance() != null) {
                                t.setBalance_before(deductCarowner.getAccount_balance());
                                t.setRecharge_money(t.getTran_money().negate());
                                t.setBalance(t.getBalance_before().subtract(t.getTran_money()));
                            }
                            accountDecuctSuccess = true;
                            t.setTran_des("\u8f66\u4e3b\u8d26\u6237\u6263\u8d39");
                        }
                    }
                }
                finally {
                    this.passRecordHandleLockManager.releaseLock(lock);
                }
            }
            if (!accountDecuctSuccess) {
                lockkey = "deductPassportBlance_" + t.getPassport_number() + "+" + t.getMedium_type();
                lock = this.passRecordHandleLockManager.getLock(lockkey);
                try {
                    object = lock;
                    synchronized (object) {
                        CarparkPassport passport = (CarparkPassport)daoService.selectOne(session, new SearchParam().addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()).addEQ("passport_number", (Object)t.getPassport_number()).addEQ("medium_type", (Object)t.getMedium_type()), CarparkPassport.class);
                        if (passport != null) {
                            p = new CommonParam(daoService.getTableName(CarparkPassport.class));
                            p.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                            p.addEQ("passport_number", (Object)t.getPassport_number()).addEQ("medium_type", (Object)t.getMedium_type());
                            p.addUpdate("balance=balance-" + t.getTran_money());
                            p.addUpdate("last_updated_time", (Object)ServiceUtil.getNow());
                            daoService.update(session, p);
                            if (passport.getBalance() != null) {
                                t.setBalance_before(passport.getBalance());
                                t.setRecharge_money(t.getTran_money().negate());
                                t.setBalance(t.getBalance_before().subtract(t.getTran_money()));
                            }
                            t.setTran_des("\u8f66\u8f86\u8d26\u6237\u6263\u8d39");
                        }
                    }
                }
                finally {
                    this.passRecordHandleLockManager.releaseLock(lock);
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyValueEntry<CarparkCancelPassRecord, Collection<String>> createCancelPassRecrod(PassSession session) {
        try {
            ChannelArea channelArea = (ChannelArea)session.getAttribute("channelArea");
            if (channelArea == null) {
                return null;
            }
            if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                List<CaptureEvent> capList;
                boolean conected;
                CarparkHost severHost;
                Date passTime;
                CarparkArea area = (CarparkArea)session.getAttribute("PASS_EXIT_AREA");
                if (area == null) {
                    return null;
                }
                Collection<Integer> cl1 = session.getConfirmPassExceptions();
                Collection<Integer> cl2 = session.getAllowPassExcetpions();
                Collection<Integer> cl3 = session.getForbidPassExceptions();
                HashSet<Integer> exceptionValueSet = new HashSet<Integer>();
                if (cl1 != null) {
                    exceptionValueSet.addAll(cl1);
                }
                if (cl2 != null) {
                    exceptionValueSet.addAll(cl2);
                }
                if (cl3 != null) {
                    exceptionValueSet.addAll(cl3);
                }
                int pass_state_value = 0;
                if (exceptionValueSet.contains(6)) {
                    pass_state_value = 6;
                } else if (exceptionValueSet.contains(7)) {
                    pass_state_value = 7;
                } else if (exceptionValueSet.contains(8)) {
                    pass_state_value = 8;
                } else if (exceptionValueSet.contains(4)) {
                    pass_state_value = 4;
                } else if (exceptionValueSet.contains(1)) {
                    pass_state_value = 1;
                }
                CarparkPresenceRecord takeChargeRecord = (CarparkPresenceRecord)session.getAttribute("takeChargeRecord");
                Cost cost = (Cost)session.getAttribute("pass_cost");
                LinkedHashSet<String> uploadServerPicList = null;
                CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                UserSession userSession = appService.getUserSession();
                PlateRecognizedEvent plateRecognizedEvent = session.getPlateRecognizedEvent();
                if (plateRecognizedEvent == null && session.getReadPassportNumberEvent() != null) {
                    plateRecognizedEvent = session.getReadPassportNumberEvent().getPlateRecognizedEvent();
                }
                if ((passTime = (Date)session.getAttribute("passTime")) == null) {
                    passTime = ServiceUtil.getNow();
                }
                CarparkCancelPassRecord passRecord = new CarparkCancelPassRecord();
                Map areaPresenceRecordMap = (Map)session.getAttribute("areaPresenceRecordMap");
                CarparkPresenceRecord enterRecord = null;
                if (areaPresenceRecordMap != null) {
                    enterRecord = (CarparkPresenceRecord)areaPresenceRecordMap.get(area.getArea_no());
                }
                if (enterRecord != null) {
                    JavaBeanMap map1 = new JavaBeanMap((Object)enterRecord);
                    JavaBeanMap map2 = new JavaBeanMap((Object)passRecord);
                    Set nemes = map1.keySet();
                    String enter_ = "enter_";
                    for (String nem : nemes) {
                        if (!nem.startsWith(enter_)) continue;
                        map2.put(nem, map1.get((Object)nem));
                    }
                    passRecord.setSecret_free_payment(enterRecord.getSecret_free_payment());
                    passRecord.setPlate_color(enterRecord.getPlate_color());
                    passRecord.setCar_logo(enterRecord.getCar_logo());
                    passRecord.setCar_color(enterRecord.getCar_color());
                    passRecord.setOccupy_plate(enterRecord.getOccupy_plate());
                    passRecord.setOccupy_end_time(enterRecord.getOccupy_end_time());
                    passRecord.setOccupy_passport_type_no(enterRecord.getOccupy_passport_type_no());
                }
                passRecord.setPassport_no(session.getPassport().getPassport_no());
                passRecord.setPassport_number(session.getPassport().getPassport_number());
                passRecord.setMedium_type(session.getPassport().getMedium_type());
                passRecord.setPass_type(session.getPassportType().getPass_type());
                passRecord.setPassport_type_no(session.getPassportType().getPassport_type_no());
                passRecord.setPassport_type_name(session.getPassportType().getPassport_type_name());
                if (session.getCarOwner() != null) {
                    passRecord.setCar_owner_no(session.getCarOwner().getCar_owner_no());
                    passRecord.setCar_owner_name(session.getCarOwner().getCar_owner_name());
                    passRecord.setCar_owner_addr(ServiceUtil.getString(session.getCarOwner().getAddress(), 100));
                    if (session.getPassport().getSpace_reg_no() == null || session.getPassport().getSpace_reg_no().length() == 0) {
                        passRecord.setOccupy_space_reg_no(session.getPassport().getRegister_plate());
                    } else {
                        passRecord.setOccupy_space_reg_no(session.getPassport().getSpace_reg_no());
                    }
                }
                passRecord.setArea_no(area.getArea_no());
                passRecord.setParent_area_no(area.getParent_area_no());
                passRecord.setArea_level(area.getArea_level());
                passRecord.setArea_name(area.getArea_name());
                passRecord.setPass_time(passTime);
                passRecord.setPass_plate(session.getPassPlate());
                if (plateRecognizedEvent != null) {
                    if (plateRecognizedEvent.getPlateColor() != null && plateRecognizedEvent.getPlateColor().length() > 0) {
                        passRecord.setPlate_color(ServiceUtil.getString(plateRecognizedEvent.getPlateColor(), 15));
                    }
                    if (plateRecognizedEvent.getCarLogo() != null && plateRecognizedEvent.getCarLogo().length() > 0) {
                        passRecord.setCar_logo(ServiceUtil.getString(plateRecognizedEvent.getCarLogo(), 45));
                    }
                    if (plateRecognizedEvent.getVehicleColor() != null && plateRecognizedEvent.getVehicleColor().length() > 0) {
                        passRecord.setCar_color(ServiceUtil.getString(plateRecognizedEvent.getVehicleColor(), 15));
                    }
                }
                passRecord.setExit_time(passTime);
                passRecord.setExit_channel_no(session.getPassChannel().getChannelNo());
                passRecord.setExit_channel_name(session.getPassChannel().getChannel().getChannel_name());
                passRecord.setExit_car_type_no(session.getCarType().getCar_type_no());
                passRecord.setExit_car_type_name(session.getCarType().getCar_type_name());
                String defaultCarTypeNo = (String)session.getAttribute("DEFAULT_CARTYPE_NO");
                passRecord.setExit_default_car_type_no(defaultCarTypeNo);
                passRecord.setExit_plate(passRecord.getPass_plate());
                if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().getDetectedPassEvent() != null && session.getReadPassportNumberEvent().getDetectedPassEvent().getPlateNumber() != null && session.getReadPassportNumberEvent().getDetectedPassEvent().getPlateNumber().length() > 0 && session.getReadPassportNumberEvent().getDetectedPassEvent().getMediaType() == DetectedPassEvent.MediaType.OBU) {
                    passRecord.setExit_obu_plate(session.getReadPassportNumberEvent().getDetectedPassEvent().getPlateNumber());
                }
                if (plateRecognizedEvent != null) {
                    passRecord.setExit_reg_plate(plateRecognizedEvent.getPlateNumber());
                }
                if (passRecord.getExit_plate() != null && passRecord.getExit_plate().length() > 0) {
                    if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger()) {
                        passRecord.setExit_plate_source(1);
                    } else if (passRecord.getExit_obu_plate() != null && passRecord.getExit_obu_plate().length() > 0) {
                        if (passRecord.getExit_plate().equals(passRecord.getExit_obu_plate())) {
                            passRecord.setExit_plate_source(3);
                        } else {
                            passRecord.setExit_plate_source(2);
                        }
                    } else if (passRecord.getExit_reg_plate() != null && passRecord.getExit_reg_plate().length() > 0) {
                        if (passRecord.getExit_plate().equals(passRecord.getExit_reg_plate())) {
                            passRecord.setExit_plate_source(0);
                        } else if (session.getPassport().getRegister_plate() != null && session.getPassport().getRegister_plate().length() > 0 && session.getPassport().getId() != null && session.getPassport().getId() > 0L) {
                            passRecord.setExit_plate_source(4);
                        } else {
                            passRecord.setExit_plate_source(2);
                        }
                    }
                }
                if (localHost != null) {
                    passRecord.setExit_host_no(localHost.getHost_no());
                    passRecord.setExit_host_name(localHost.getHost_name());
                }
                if (userSession != null) {
                    if (userSession.getDutyNumber() != null) {
                        passRecord.setExit_duty_no(userSession.getDutyNumber().getDuty_no());
                    } else {
                        passRecord.setExit_duty_no("0");
                    }
                    if (userSession.getUser() != null) {
                        passRecord.setExit_duty_user_code(userSession.getUser().getUser_code());
                        passRecord.setExit_duty_user_name(userSession.getUser().getUser_name());
                    } else {
                        passRecord.setExit_duty_user_code("admin");
                        passRecord.setExit_duty_user_name("\u8d85\u7ea7\u7ba1\u7406\u5458");
                    }
                } else {
                    passRecord.setExit_duty_no("0");
                    passRecord.setExit_duty_user_code("admin");
                    passRecord.setExit_duty_user_name("\u8d85\u7ea7\u7ba1\u7406\u5458");
                }
                passRecord.setExit_lan_state(0);
                if (localHost.getHost_use() == 1 && (severHost = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkServerHost()) != null && !(conected = ServiceUtil.getServiceContext().isConected(severHost.getHost_no()))) {
                    passRecord.setExit_lan_state(1);
                }
                if (plateRecognizedEvent != null) {
                    passRecord.setExit_car_pic(plateRecognizedEvent.getPicDBPath());
                    passRecord.setExit_plate_pic(plateRecognizedEvent.getPicDBSmallPath());
                    if (!plateRecognizedEvent.isPicAlreadyDispath()) {
                        if (passRecord.getExit_car_pic() != null && passRecord.getExit_car_pic().length() > 0) {
                            if (uploadServerPicList == null) {
                                uploadServerPicList = new LinkedHashSet<String>();
                            }
                            uploadServerPicList.add(passRecord.getExit_car_pic());
                        }
                        if (passRecord.getExit_plate_pic() != null && passRecord.getExit_plate_pic().length() > 0) {
                            if (uploadServerPicList == null) {
                                uploadServerPicList = new LinkedHashSet();
                            }
                            uploadServerPicList.add(passRecord.getExit_plate_pic());
                        }
                    }
                }
                if (session.getReadPassportNumberEvent() != null && (capList = session.getReadPassportNumberEvent().getCaptures()) != null && !capList.isEmpty()) {
                    for (CaptureEvent cevent : capList) {
                        Integer x2;
                        if (cevent.getPicture_use() == 1) {
                            if (passRecord.getExit_car_pic() != null && passRecord.getExit_car_pic().length() != 0) continue;
                            try {
                                if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled() || !cevent.getCaptureHandle().isDone() || (x2 = (Integer)cevent.getCaptureHandle().getResult()) == null || x2 != 0) continue;
                                passRecord.setExit_car_pic(this.getDbPicPath(cevent.getImgLocalPath()));
                                if (passRecord.getExit_car_pic() == null || passRecord.getExit_car_pic().length() <= 0) continue;
                                if (uploadServerPicList == null) {
                                    uploadServerPicList = new LinkedHashSet();
                                }
                                uploadServerPicList.add(passRecord.getExit_car_pic());
                            }
                            catch (Exception x2) {}
                            continue;
                        }
                        if (cevent.getPicture_use() == 4) {
                            if (passRecord.getExit_face_pic() != null && passRecord.getExit_face_pic().length() != 0) continue;
                            try {
                                if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled() || !cevent.getCaptureHandle().isDone() || (x2 = (Integer)cevent.getCaptureHandle().getResult()) == null || x2 != 0) continue;
                                passRecord.setExit_face_pic(this.getDbPicPath(cevent.getImgLocalPath()));
                                if (passRecord.getExit_face_pic() == null || passRecord.getExit_face_pic().length() <= 0) continue;
                                if (uploadServerPicList == null) {
                                    uploadServerPicList = new LinkedHashSet();
                                }
                                uploadServerPicList.add(passRecord.getExit_face_pic());
                            }
                            catch (Exception x3) {}
                            continue;
                        }
                        if (cevent.getPicture_use() == 8) {
                            if (passRecord.getCertificate_pic() != null && passRecord.getCertificate_pic().length() != 0) continue;
                            try {
                                if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled() || !cevent.getCaptureHandle().isDone() || (x2 = (Integer)cevent.getCaptureHandle().getResult()) == null || x2 != 0) continue;
                                passRecord.setCertificate_pic(this.getDbPicPath(cevent.getImgLocalPath()));
                                if (passRecord.getCertificate_pic() == null || passRecord.getCertificate_pic().length() <= 0) continue;
                                if (uploadServerPicList == null) {
                                    uploadServerPicList = new LinkedHashSet();
                                }
                                uploadServerPicList.add(passRecord.getCertificate_pic());
                            }
                            catch (Exception x4) {}
                            continue;
                        }
                        if (cevent.getPicture_use() == 2) {
                            if (passRecord.getExit_car_trail_pic() != null && passRecord.getExit_car_trail_pic().length() != 0) continue;
                            try {
                                if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled() || !cevent.getCaptureHandle().isDone() || (x2 = (Integer)cevent.getCaptureHandle().getResult()) == null || x2 != 0) continue;
                                passRecord.setExit_car_trail_pic(this.getDbPicPath(cevent.getImgLocalPath()));
                                if (passRecord.getExit_car_trail_pic() == null || passRecord.getExit_car_trail_pic().length() <= 0) continue;
                                if (uploadServerPicList == null) {
                                    uploadServerPicList = new LinkedHashSet();
                                }
                                uploadServerPicList.add(passRecord.getExit_car_trail_pic());
                            }
                            catch (Exception x5) {}
                            continue;
                        }
                        if (cevent.getPicture_use() != 16 || passRecord.getExit_car_body_pic() != null && passRecord.getExit_car_body_pic().length() != 0) continue;
                        try {
                            if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled() || !cevent.getCaptureHandle().isDone() || (x2 = (Integer)cevent.getCaptureHandle().getResult()) == null || x2 != 0) continue;
                            passRecord.setExit_car_body_pic(this.getDbPicPath(cevent.getImgLocalPath()));
                            if (passRecord.getExit_car_body_pic() == null || passRecord.getExit_car_body_pic().length() <= 0) continue;
                            if (uploadServerPicList == null) {
                                uploadServerPicList = new LinkedHashSet();
                            }
                            uploadServerPicList.add(passRecord.getExit_car_body_pic());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                passRecord.setExit_remark(null);
                if (passRecord.getPass_type() != null && passRecord.getPass_type() == 2) {
                    passRecord.setExit_valid_date(session.getPassport().getDeadline());
                }
                if (passRecord.getPass_type() != null && passRecord.getPass_type() == 1) {
                    passRecord.setExit_balance(session.getPassport().getBalance());
                }
                passRecord.setPass_state_value(pass_state_value);
                passRecord.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                passRecord.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                passRecord.setRecord_state(0);
                passRecord.setPass_channel_no(passRecord.getExit_channel_no());
                passRecord.setPass_duty_user_code(passRecord.getExit_duty_user_code());
                passRecord.setPass_host_no(passRecord.getExit_host_no());
                passRecord.setPass_car_type_no(passRecord.getExit_car_type_no());
                if (takeChargeRecord != null) {
                    if (takeChargeRecord.getPassport_number() != null && takeChargeRecord.getPassport_number().length() > 0 && takeChargeRecord.getMedium_type() != null && takeChargeRecord.getMedium_type() == 6) {
                        passRecord.setTake_plate_number(takeChargeRecord.getPassport_number());
                    } else {
                        passRecord.setTake_plate_number(takeChargeRecord.getEnter_plate());
                    }
                    passRecord.setTake_enter_time(takeChargeRecord.getEnter_time());
                    if (takeChargeRecord.getEnter_passport_type_no() != null && takeChargeRecord.getEnter_passport_type_no().length() > 0) {
                        passRecord.setTake_passport_type_no(takeChargeRecord.getEnter_passport_type_no());
                    } else {
                        passRecord.setTake_passport_type_no(takeChargeRecord.getPassport_type_no());
                    }
                }
                if (cost != null) {
                    passRecord.setExit_fee_time_length(cost.getChargeTimeMinutes());
                    passRecord.setExit_should_charge(cost.getShouldCharged());
                    passRecord.setPeriod_multi_start(cost.getPeriod_multi_start());
                    passRecord.setPeriod_multi_received(cost.getPeriod_multi_received());
                    passRecord.setPeriod_multi_free(cost.getPeriod_multi_free());
                    passRecord.setNext_period_multi_start(cost.getNext_period_multi_start());
                    passRecord.setNext_period_multi_cur(cost.getNext_period_multi_cur());
                    passRecord.setExit_fee_start_time(cost.getCharge_start_time());
                    passRecord.setDiscount_money(cost.getDiscountMoney());
                    passRecord.setAlready_paid(cost.getAlready_paid());
                    passRecord.setAlready_paid_method(cost.getAlready_paid_method());
                    passRecord.setAlready_paid_scene(cost.getAlready_paid_scene());
                    passRecord.setAlready_paid_charge_org(cost.getAlready_paid_charge_org());
                    passRecord.setAlready_paid_time(cost.getAlready_paid_time());
                    if (cost.getAlreadyPaidList() != null) {
                        passRecord.setAlready_paid_times(cost.getAlreadyPaidList().size());
                    } else {
                        passRecord.setAlready_paid_times(0);
                    }
                    passRecord.setCash_pay(cost.getCash());
                    passRecord.setDeduct_money(cost.getDeduct_money());
                    List<CarparkPassDiscount> discountList = cost.getDiscountList();
                    if (discountList == null || discountList.isEmpty()) {
                        passRecord.setDiscount_times(0);
                    } else {
                        passRecord.setDiscount_times(discountList.size());
                        CarparkPassDiscount c = discountList.get(0);
                        passRecord.setDiscount_project_no(c.getDiscount_project_no());
                        passRecord.setDiscount_project_name(c.getDiscount_project_name());
                        passRecord.setDiscount_merchant_type(c.getDiscount_merchant_type());
                        passRecord.setDiscount_merchant_no(c.getDiscount_merchant_no());
                        passRecord.setDiscount_merchant_name(c.getDiscount_merchant_name());
                        passRecord.setDiscount_method(c.getDiscount_method());
                        passRecord.setDiscount_source(c.getDiscount_source());
                        passRecord.setDiscount_value(c.getDiscount_value());
                        passRecord.setDiscount_time(c.getDiscount_time());
                    }
                }
                return new KeyValueEntry((Object)passRecord, uploadServerPicList);
            }
            if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                List<CaptureEvent> capList;
                boolean conected;
                CarparkHost severHost;
                Date passTime;
                LinkedHashSet<String> uploadServerPicList = null;
                Collection<Integer> cl1 = session.getConfirmPassExceptions();
                Collection<Integer> cl2 = session.getAllowPassExcetpions();
                Collection<Integer> cl3 = session.getForbidPassExceptions();
                HashSet<Integer> exceptionValueSet = new HashSet<Integer>();
                if (cl1 != null) {
                    exceptionValueSet.addAll(cl1);
                }
                if (cl2 != null) {
                    exceptionValueSet.addAll(cl2);
                }
                if (cl3 != null) {
                    exceptionValueSet.addAll(cl3);
                }
                int pass_state_value = 0;
                if (exceptionValueSet.contains(6)) {
                    pass_state_value = 6;
                } else if (exceptionValueSet.contains(7)) {
                    pass_state_value = 7;
                } else if (exceptionValueSet.contains(8)) {
                    pass_state_value = 8;
                } else if (exceptionValueSet.contains(4)) {
                    pass_state_value = 4;
                } else if (exceptionValueSet.contains(1)) {
                    pass_state_value = 1;
                } else if (exceptionValueSet.contains(9)) {
                    pass_state_value = 9;
                }
                CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                UserSession userSession = appService.getUserSession();
                PlateRecognizedEvent plateRecognizedEvent = session.getPlateRecognizedEvent();
                if (plateRecognizedEvent == null && session.getReadPassportNumberEvent() != null) {
                    plateRecognizedEvent = session.getReadPassportNumberEvent().getPlateRecognizedEvent();
                }
                if ((passTime = (Date)session.getAttribute("passTime")) == null) {
                    passTime = ServiceUtil.getNow();
                }
                CarparkArea area = channelArea.getEnterAreas().get(0);
                CarparkCancelPassRecord passRecord = new CarparkCancelPassRecord();
                passRecord.setCreated_time(ServiceUtil.getNow());
                passRecord.setPassport_no(session.getPassport().getPassport_no());
                passRecord.setPassport_number(session.getPassport().getPassport_number());
                passRecord.setMedium_type(session.getPassport().getMedium_type());
                passRecord.setPass_type(session.getPassportType().getPass_type());
                passRecord.setPassport_type_no(session.getPassportType().getPassport_type_no());
                passRecord.setPassport_type_name(session.getPassportType().getPassport_type_name());
                if (session.getCarOwner() != null) {
                    passRecord.setCar_owner_no(session.getCarOwner().getCar_owner_no());
                    passRecord.setCar_owner_name(session.getCarOwner().getCar_owner_name());
                    passRecord.setCar_owner_addr(ServiceUtil.getString(session.getCarOwner().getAddress(), 100));
                }
                passRecord.setArea_no(area.getArea_no());
                passRecord.setParent_area_no(area.getParent_area_no());
                passRecord.setArea_level(area.getArea_level());
                passRecord.setArea_name(area.getArea_name());
                passRecord.setPass_time(passTime);
                String sessionPassPlate = null;
                sessionPassPlate = session.getPassPlate();
                if (sessionPassPlate == null) {
                    sessionPassPlate = "";
                }
                passRecord.setPass_plate(sessionPassPlate);
                passRecord.setEnter_passport_type_no(session.getPassportType().getPassport_type_no());
                if (session.getVisitCar() != null && area.getArea_no().equals(session.getVisitCar().getVisit_area_no())) {
                    passRecord.setVisit_auth_no(session.getVisitCar().getVisit_auth_no());
                }
                if (plateRecognizedEvent != null) {
                    passRecord.setPlate_color(ServiceUtil.getString(plateRecognizedEvent.getPlateColor(), 15));
                    passRecord.setCar_logo(ServiceUtil.getString(plateRecognizedEvent.getCarLogo(), 45));
                    passRecord.setCar_color(ServiceUtil.getString(plateRecognizedEvent.getVehicleColor(), 15));
                }
                passRecord.setEnter_time(passTime);
                passRecord.setEnter_channel_no(session.getPassChannel().getChannelNo());
                passRecord.setEnter_channel_name(session.getPassChannel().getChannel().getChannel_name());
                passRecord.setEnter_car_type_no(session.getCarType().getCar_type_no());
                passRecord.setEnter_car_type_name(session.getCarType().getCar_type_name());
                String defaultCarTypeNo = (String)session.getAttribute("DEFAULT_CARTYPE_NO");
                passRecord.setEnter_default_car_type_no(defaultCarTypeNo);
                passRecord.setEnter_plate(passRecord.getPass_plate());
                if (userSession != null) {
                    if (userSession.getDutyNumber() != null) {
                        passRecord.setEnter_duty_no(userSession.getDutyNumber().getDuty_no());
                    } else {
                        passRecord.setEnter_duty_no("0");
                    }
                    if (userSession.getUser() != null) {
                        passRecord.setEnter_duty_user_code(userSession.getUser().getUser_code());
                        passRecord.setEnter_duty_user_name(userSession.getUser().getUser_name());
                    } else {
                        passRecord.setEnter_duty_user_code("admin");
                        passRecord.setEnter_duty_user_name("\u8d85\u7ea7\u7ba1\u7406\u5458");
                    }
                } else {
                    passRecord.setEnter_duty_no("0");
                    passRecord.setEnter_duty_user_code("admin");
                    passRecord.setEnter_duty_user_name("\u8d85\u7ea7\u7ba1\u7406\u5458");
                }
                if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().getDetectedPassEvent() != null && session.getReadPassportNumberEvent().getDetectedPassEvent().getPlateNumber() != null && session.getReadPassportNumberEvent().getDetectedPassEvent().getPlateNumber().length() > 0 && session.getReadPassportNumberEvent().getDetectedPassEvent().getMediaType() == DetectedPassEvent.MediaType.OBU) {
                    passRecord.setEnter_obu_plate(session.getReadPassportNumberEvent().getDetectedPassEvent().getPlateNumber());
                }
                if (plateRecognizedEvent != null) {
                    passRecord.setEnter_reg_plate(plateRecognizedEvent.getPlateNumber());
                }
                if (passRecord.getEnter_plate() != null && passRecord.getEnter_plate().length() > 0) {
                    if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isManualTrigger()) {
                        passRecord.setEnter_plate_source(1);
                    } else if (session.getReadPassportNumberEvent() != null && session.getReadPassportNumberEvent().isUserScan() && session.getReadPassportNumberEvent().getPlateNumber() != null) {
                        passRecord.setEnter_plate_source(5);
                    } else if (session.isReadCard()) {
                        passRecord.setEnter_plate_source(6);
                    } else if (passRecord.getEnter_obu_plate() != null && passRecord.getEnter_obu_plate().length() > 0) {
                        if (passRecord.getEnter_plate().equals(passRecord.getEnter_obu_plate())) {
                            passRecord.setEnter_plate_source(3);
                        } else {
                            passRecord.setEnter_plate_source(2);
                            passRecord.setEnter_plate_modify_time(passTime);
                            passRecord.setEnter_plate_modify_user_name(passRecord.getEnter_duty_user_name());
                        }
                    } else if (passRecord.getEnter_reg_plate() != null && passRecord.getEnter_reg_plate().length() > 0) {
                        if (passRecord.getEnter_plate().equals(passRecord.getEnter_reg_plate())) {
                            passRecord.setEnter_plate_source(0);
                        } else if (session.getSessionState() == PassSession.SessionState.OPEN_DIALOG) {
                            passRecord.setEnter_plate_source(2);
                            passRecord.setEnter_plate_modify_time(passTime);
                            passRecord.setEnter_plate_modify_user_name(passRecord.getEnter_duty_user_name());
                        } else {
                            passRecord.setEnter_plate_source(4);
                        }
                    }
                }
                if (localHost != null) {
                    passRecord.setEnter_host_no(localHost.getHost_no());
                    passRecord.setEnter_host_name(localHost.getHost_name());
                }
                passRecord.setEnter_lan_state(0);
                if (localHost.getHost_use() == 1 && (severHost = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkServerHost()) != null && !(conected = ServiceUtil.getServiceContext().isConected(severHost.getHost_no()))) {
                    passRecord.setEnter_lan_state(1);
                }
                if (plateRecognizedEvent != null) {
                    passRecord.setEnter_car_pic(plateRecognizedEvent.getPicDBPath());
                    passRecord.setEnter_plate_pic(plateRecognizedEvent.getPicDBSmallPath());
                    if (!plateRecognizedEvent.isPicAlreadyDispath()) {
                        if (passRecord.getEnter_car_pic() != null && passRecord.getEnter_car_pic().length() > 0) {
                            if (uploadServerPicList == null) {
                                uploadServerPicList = new LinkedHashSet<String>();
                            }
                            uploadServerPicList.add(passRecord.getEnter_car_pic());
                        }
                        if (passRecord.getEnter_plate_pic() != null && passRecord.getEnter_plate_pic().length() > 0) {
                            if (uploadServerPicList == null) {
                                uploadServerPicList = new LinkedHashSet();
                            }
                            uploadServerPicList.add(passRecord.getEnter_plate_pic());
                        }
                    }
                }
                if (session.getReadPassportNumberEvent() != null && (capList = session.getReadPassportNumberEvent().getCaptures()) != null && !capList.isEmpty()) {
                    for (CaptureEvent cevent : capList) {
                        Integer x6;
                        if (cevent.getPicture_use() == 1) {
                            if (passRecord.getEnter_car_pic() != null && passRecord.getEnter_car_pic().length() != 0) continue;
                            try {
                                if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled() || !cevent.getCaptureHandle().isDone() || (x6 = (Integer)cevent.getCaptureHandle().getResult()) == null || x6 != 0) continue;
                                passRecord.setEnter_car_pic(this.getDbPicPath(cevent.getImgLocalPath()));
                                if (passRecord.getEnter_car_pic() == null || passRecord.getEnter_car_pic().length() <= 0) continue;
                                if (uploadServerPicList == null) {
                                    uploadServerPicList = new LinkedHashSet();
                                }
                                uploadServerPicList.add(passRecord.getEnter_car_pic());
                            }
                            catch (Exception x6) {}
                            continue;
                        }
                        if (cevent.getPicture_use() == 4) {
                            if (passRecord.getEnter_face_pic() != null && passRecord.getEnter_face_pic().length() != 0) continue;
                            try {
                                if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled() || !cevent.getCaptureHandle().isDone() || (x6 = (Integer)cevent.getCaptureHandle().getResult()) == null || x6 != 0) continue;
                                passRecord.setEnter_face_pic(this.getDbPicPath(cevent.getImgLocalPath()));
                                if (passRecord.getEnter_face_pic() == null || passRecord.getEnter_face_pic().length() <= 0) continue;
                                if (uploadServerPicList == null) {
                                    uploadServerPicList = new LinkedHashSet();
                                }
                                uploadServerPicList.add(passRecord.getEnter_face_pic());
                            }
                            catch (Exception x7) {}
                            continue;
                        }
                        if (cevent.getPicture_use() == 2) {
                            if (passRecord.getEnter_car_trail_pic() != null && passRecord.getEnter_car_trail_pic().length() != 0) continue;
                            try {
                                if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled() || !cevent.getCaptureHandle().isDone() || (x6 = (Integer)cevent.getCaptureHandle().getResult()) == null || x6 != 0) continue;
                                passRecord.setEnter_car_trail_pic(this.getDbPicPath(cevent.getImgLocalPath()));
                                if (passRecord.getEnter_car_trail_pic() == null || passRecord.getEnter_car_trail_pic().length() <= 0) continue;
                                if (uploadServerPicList == null) {
                                    uploadServerPicList = new LinkedHashSet();
                                }
                                uploadServerPicList.add(passRecord.getEnter_car_trail_pic());
                            }
                            catch (Exception x8) {}
                            continue;
                        }
                        if (cevent.getPicture_use() != 16 || passRecord.getEnter_car_body_pic() != null && passRecord.getEnter_car_body_pic().length() != 0) continue;
                        try {
                            if (cevent.getCaptureHandle() == null || cevent.getCaptureHandle().isCancelled() || !cevent.getCaptureHandle().isDone() || (x6 = (Integer)cevent.getCaptureHandle().getResult()) == null || x6 != 0) continue;
                            passRecord.setEnter_car_body_pic(this.getDbPicPath(cevent.getImgLocalPath()));
                            if (passRecord.getEnter_car_body_pic() == null || passRecord.getEnter_car_body_pic().length() <= 0) continue;
                            if (uploadServerPicList == null) {
                                uploadServerPicList = new LinkedHashSet();
                            }
                            uploadServerPicList.add(passRecord.getEnter_car_body_pic());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (passRecord.getPass_type() != null && passRecord.getPass_type() == 2) {
                    passRecord.setEnter_valid_date(session.getPassport().getDeadline());
                }
                if (passRecord.getPass_type() != null && passRecord.getPass_type() == 1) {
                    passRecord.setEnter_balance(session.getPassport().getBalance());
                }
                passRecord.setPass_state_value(pass_state_value);
                int state = 0;
                if (exceptionValueSet.contains(2)) {
                    state = 5;
                } else if (passRecord.getEnter_plate_source() != null) {
                    if (passRecord.getEnter_plate_source() == 1) {
                        state = 3;
                    } else if (passRecord.getEnter_plate_source() == 2) {
                        state = 4;
                    } else if (passRecord.getEnter_plate_source() == 5) {
                        state = 7;
                    }
                }
                passRecord.setRecord_state(state);
                passRecord.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                passRecord.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                passRecord.setPass_channel_no(passRecord.getEnter_channel_no());
                passRecord.setPass_duty_user_code(passRecord.getEnter_duty_user_code());
                passRecord.setPass_host_no(passRecord.getEnter_host_no());
                passRecord.setPass_car_type_no(passRecord.getEnter_car_type_no());
                return new KeyValueEntry((Object)passRecord, uploadServerPicList);
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
        }
        return null;
    }

    @Override
    public CarparkEscapeOrder createEscapeOrder(CarparkCancelPassRecord cancelRecord, boolean local) {
        if (cancelRecord != null && cancelRecord.getExit_time() != null && cancelRecord.getEnter_time() != null && cancelRecord.getExit_record_no() != null && cancelRecord.getExit_record_no().length() > 0 && cancelRecord.getEnter_record_no() != null && cancelRecord.getEnter_record_no().length() > 0 && cancelRecord.getPassport_number() != null && cancelRecord.getPassport_number().length() > 0 && cancelRecord.getExit_should_charge() != null && cancelRecord.getExit_should_charge().doubleValue() > 0.0 && cancelRecord.getCash_pay() != null && cancelRecord.getCash_pay().doubleValue() > 0.0 && cancelRecord.getExit_plate() != null && cancelRecord.getExit_plate().length() > 0 && cancelRecord.getExit_reg_plate() != null && cancelRecord.getExit_plate().equals(cancelRecord.getExit_reg_plate()) && (cancelRecord.getRecord_state() == null || cancelRecord.getRecord_state() != 32)) {
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            Pagination p = new Pagination();
            p.setNeedQueryCount(false);
            p.setRecordsCount(1L);
            p.setPageSize(1);
            p.setGotoPage(1);
            CarparkPassRecord passRecord = (CarparkPassRecord)commonDaoService.selectOne(new SearchParam(commonDaoService.getTableName(CarparkPassRecord.class)).setQueryFields(new String[]{"id"}).setOrerbySql("id").addEQ("carpark_id", (Object)cancelRecord.getCarpark_id()).addEQ("passport_number", (Object)cancelRecord.getPassport_number()).addEQ("medium_type", (Object)cancelRecord.getMedium_type()).addGTE("pass_time", (Object)cancelRecord.getExit_time()).addGTE("exit_time", (Object)cancelRecord.getExit_time()).addEQ("enter_time", (Object)cancelRecord.getEnter_time()), CarparkPassRecord.class, p);
            if (passRecord != null && passRecord.getId() != null) {
                return null;
            }
            CarparkEscapeOrder order = new CarparkEscapeOrder();
            JavaBeanTool.copyTo((Object)cancelRecord, (Object)order);
            if (order.getCreated_time() == null) {
                order.setCreated_time(ServiceUtil.getNow());
            }
            order.setOrder_state(0);
            return order;
        }
        return null;
    }

    public boolean keepEveryEscapeOrder() {
        return false;
    }

    @Override
    public void saveCancelRecord(KeyValueEntry<CarparkCancelPassRecord, Collection<String>> kv) {
        LinkedList<CarparkDispatchTask> taskList;
        ApplicationService appService;
        block22: {
            CarparkCancelPassRecord cancelRecord = (CarparkCancelPassRecord)kv.getKey();
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            SqlSession session = daoService.openSqlSession();
            taskList = new LinkedList<CarparkDispatchTask>();
            try {
                try {
                    long passRecordId = appService.createLocalRecordSeq("ck_carpark_pass_record_seq");
                    cancelRecord.setId(passRecordId);
                    if (cancelRecord.getExit_time() != null) {
                        cancelRecord.setExit_record_no("C" + cancelRecord.getId().toString());
                    } else {
                        cancelRecord.setEnter_record_no("C" + cancelRecord.getId().toString());
                    }
                    cancelRecord.setCreated_time(ServiceUtil.getNow());
                    boolean uploadAllHosts = false;
                    CarparkEscapeOrder order = null;
                    if (cancelRecord.getExit_time() != null && cancelRecord.getEnter_time() != null && cancelRecord.getExit_record_no() != null && cancelRecord.getExit_record_no().length() > 0 && cancelRecord.getEnter_record_no() != null && cancelRecord.getEnter_record_no().length() > 0 && cancelRecord.getPassport_number() != null && cancelRecord.getPassport_number().length() > 0 && cancelRecord.getExit_should_charge() != null && cancelRecord.getExit_should_charge().doubleValue() > 0.0 && cancelRecord.getCash_pay() != null && cancelRecord.getCash_pay().doubleValue() > 0.0 && cancelRecord.getExit_plate() != null && cancelRecord.getExit_plate().length() > 0 && cancelRecord.getExit_reg_plate() != null && cancelRecord.getExit_plate().equals(cancelRecord.getExit_reg_plate())) {
                        uploadAllHosts = true;
                        order = this.createEscapeOrder(cancelRecord, true);
                    }
                    if (!uploadAllHosts && cancelRecord.getExit_time() == null && cancelRecord.getEnter_time() != null) {
                        uploadAllHosts = true;
                    }
                    if (cancelRecord.getExit_time() != null && cancelRecord.getRecord_state() != null && cancelRecord.getRecord_state() == 31) {
                        if (!uploadAllHosts) {
                            uploadAllHosts = true;
                        }
                        SearchParam sp = new SearchParam(daoService.getTableName(CarparkPresenceRecord.class));
                        sp.addEQ("carpark_id", (Object)cancelRecord.getCarpark_id());
                        sp.addEQ("passport_number", (Object)cancelRecord.getPassport_number());
                        sp.addEQ("medium_type", (Object)cancelRecord.getMedium_type());
                        sp.addLT("enter_time", (Object)cancelRecord.getExit_time());
                        daoService.delete(session, sp);
                    }
                    if (uploadAllHosts) {
                        if (kv.getValue() != null && !((Collection)kv.getValue()).isEmpty()) {
                            for (String pic : (Collection)kv.getValue()) {
                                if (pic == null || pic.length() <= 0) continue;
                                taskList.addAll(DispatchDataTaskUtil.createDispatchLocalPicTaskList(pic, "ALL_HOSTS"));
                            }
                        }
                        taskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(daoService.getTableName(CarparkCancelPassRecord.class), cancelRecord.getId().toString(), "ALL_HOSTS"));
                    } else {
                        CarparkLocalConfig localConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig();
                        if (localConfig != null && localConfig.getHost_use() == 1) {
                            if (kv.getValue() != null && !((Collection)kv.getValue()).isEmpty()) {
                                for (String pic : (Collection)kv.getValue()) {
                                    if (pic == null || pic.length() <= 0) continue;
                                    taskList.addAll(DispatchDataTaskUtil.createDispatchLocalPicTaskList(pic, "CARPARK_SERVER"));
                                }
                            }
                            taskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(daoService.getTableName(CarparkCancelPassRecord.class), cancelRecord.getId().toString(), "CARPARK_SERVER"));
                        }
                    }
                    daoService.insert(session, (Object)cancelRecord);
                    if (order != null) {
                        SearchParam delParam = new SearchParam(daoService.getTableName(CarparkEscapeOrder.class));
                        delParam.addEQ("passport_number", (Object)order.getPassport_number());
                        delParam.addLT("exit_time", (Object)order.getExit_time());
                        delParam.addEQ("medium_type", (Object)order.getMedium_type());
                        delParam.addEQ("carpark_id", (Object)order.getCarpark_id());
                        delParam.addEQ("area_no", (Object)order.getArea_no());
                        delParam.addEQ("enter_time", (Object)order.getEnter_time());
                        delParam.addEQ("order_state", (Object)0);
                        daoService.delete(session, delParam);
                        daoService.insert(session, (Object)order);
                    }
                    if (taskList != null && !taskList.isEmpty()) {
                        for (CarparkDispatchTask h : taskList) {
                            daoService.insert(session, (Object)h);
                        }
                    }
                    session.commit();
                }
                catch (Exception ex) {
                    session.rollback();
                    ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                    session.close();
                    break block22;
                }
            }
            catch (Throwable throwable) {
                session.close();
                throw throwable;
            }
            session.close();
        }
        if (taskList != null && !taskList.isEmpty()) {
            appService.asynTryRunDispatchTask(taskList);
        }
    }

    @Override
    public CarparkPassRecord handleModifyPlate(SqlSession session, long recordId, String oldPlate, String newPlate, Date modifyDate, String modifyUserCode, String modifyUserName) {
        CarparkHost host;
        if (oldPlate == null || oldPlate.length() == 0) {
            return null;
        }
        if (oldPlate.equals(newPlate)) {
            return null;
        }
        PassVo passVo = null;
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPresenceRecord precrd = (CarparkPresenceRecord)daoService.selectOne(session, new SearchParam().addEQ("id", (Object)recordId), CarparkPresenceRecord.class);
        boolean updatePassrecord = false;
        if (precrd != null && precrd.getEnter_time() != null && oldPlate.equals(precrd.getEnter_plate())) {
            updatePassrecord = true;
            if (precrd.getMedium_type() != null && precrd.getMedium_type() == 6) {
                passVo = PassChannel.getPassVo(newPlate, session, precrd.getEnter_time());
                CarparkPresenceRecord precrd0 = (CarparkPresenceRecord)daoService.selectOne(session, new SearchParam().addEQ("passport_number", (Object)newPlate).addEQ("medium_type", (Object)6).addEQ("area_no", (Object)precrd.getArea_no()), CarparkPresenceRecord.class);
                boolean udpate = false;
                if (precrd0 != null && !precrd0.getId().equals(precrd.getId())) {
                    SearchParam p1;
                    if (precrd0.getEnter_time() == null || precrd0.getEnter_time().getTime() < precrd.getEnter_time().getTime()) {
                        p1 = new SearchParam(daoService.getTableName(CarparkPresenceRecord.class));
                        p1.addEQ("id", (Object)precrd0.getId());
                        daoService.delete(session, p1);
                        udpate = true;
                    } else {
                        p1 = new SearchParam(daoService.getTableName(CarparkPresenceRecord.class));
                        p1.addEQ("id", (Object)precrd.getId());
                        daoService.delete(session, p1);
                    }
                } else {
                    udpate = true;
                }
                if (udpate) {
                    List discountList;
                    CommonParam up2 = this.createModifyPlateUpdateParam(daoService.getTableName(CarparkPresenceRecord.class), recordId, oldPlate, newPlate, modifyDate, modifyUserCode, modifyUserName, passVo, precrd);
                    int count = daoService.update(session, up2);
                    if (count <= 0) {
                        return null;
                    }
                    List selfPayList = daoService.selectList(session, new SearchParam().addEQ("passport_number", (Object)oldPlate).addEQ("plate_number", (Object)oldPlate).addEQ("enter_record_no", (Object)precrd.getEnter_record_no()), CarparkPassSelfPay.class, null);
                    if (selfPayList != null && !selfPayList.isEmpty()) {
                        CommonParam updateParam = new CommonParam(daoService.getTableName(CarparkPassSelfPay.class));
                        updateParam.addUpdate("passport_number", (Object)newPlate);
                        updateParam.addUpdate("plate_number", (Object)newPlate);
                        updateParam.addEQ("passport_number", (Object)oldPlate);
                        updateParam.addEQ("plate_number", (Object)oldPlate);
                        updateParam.addEQ("enter_record_no", (Object)precrd.getEnter_record_no());
                        daoService.update(session, updateParam);
                        updateParam = new CommonParam(daoService.getTableName(CarparkTransaction.class));
                        updateParam.addUpdate("passport_number", (Object)newPlate);
                        updateParam.addUpdate("plate_number", (Object)newPlate);
                        updateParam.addEQ("passport_number", (Object)oldPlate);
                        updateParam.addEQ("plate_number", (Object)oldPlate);
                        updateParam.addEQ("enter_record_no", (Object)precrd.getEnter_record_no());
                        updateParam.addEQ("enter_time", (Object)precrd.getEnter_time());
                        daoService.update(session, updateParam);
                    }
                    if ((discountList = daoService.selectList(session, new SearchParam().addEQ("passport_number", (Object)oldPlate).addEQ("palte_number", (Object)oldPlate).addEQ("enter_time", (Object)precrd.getEnter_time()).addEQ("enter_record_no", (Object)precrd.getEnter_record_no()), CarparkPassDiscount.class, null)) != null && !discountList.isEmpty()) {
                        CommonParam updateParam = new CommonParam(daoService.getTableName(CarparkPassDiscount.class));
                        updateParam.addUpdate("passport_number", (Object)newPlate);
                        updateParam.addUpdate("palte_number", (Object)newPlate);
                        updateParam.addEQ("passport_number", (Object)oldPlate);
                        updateParam.addEQ("palte_number", (Object)oldPlate);
                        updateParam.addEQ("enter_record_no", (Object)precrd.getEnter_record_no());
                        updateParam.addEQ("enter_time", (Object)precrd.getEnter_time());
                        daoService.update(session, updateParam);
                        ArrayList<String> discountNoList = new ArrayList<String>();
                        for (CarparkPassDiscount d : discountList) {
                            if (d.getDiscount_no() == null || d.getDiscount_no().length() <= 0) continue;
                            discountNoList.add(d.getDiscount_no());
                        }
                        if (discountNoList != null && !discountNoList.isEmpty()) {
                            updateParam = new CommonParam(daoService.getTableName(CarparkDiscountRecord.class));
                            updateParam.addUpdate("passport_number", (Object)newPlate);
                            updateParam.addUpdate("palte_number", (Object)newPlate);
                            updateParam.addEQ("passport_number", (Object)oldPlate);
                            updateParam.addEQ("palte_number", (Object)oldPlate);
                            updateParam.addEQ("enter_record_no", (Object)precrd.getEnter_record_no());
                            if (discountNoList.size() == 1) {
                                updateParam.addEQ("discount_no", discountNoList.get(0));
                            } else {
                                updateParam.addINList("discount_no", discountNoList);
                            }
                            daoService.update(session, updateParam);
                        }
                    }
                }
            } else {
                CommonParam updateParam = new CommonParam(daoService.getTableName(CarparkPresenceRecord.class));
                updateParam.addUpdate("pass_plate", (Object)newPlate);
                updateParam.addUpdate("enter_plate", (Object)newPlate);
                updateParam.addUpdate("enter_plate_source", (Object)2);
                updateParam.addUpdate("enter_plate_modify_time", (Object)modifyDate);
                updateParam.addUpdate("enter_plate_modify_user_name", (Object)modifyUserName);
                updateParam.addEQ("id", (Object)recordId);
                updateParam.addEQ("enter_plate", (Object)oldPlate);
                int count = daoService.update(session, updateParam);
                if (count > 0) {
                    precrd.setPass_plate(newPlate);
                    precrd.setEnter_plate(newPlate);
                    if (precrd.getMedium_type() != null && precrd.getMedium_type() == 6) {
                        precrd.setPassport_number(newPlate);
                    }
                    precrd.setEnter_plate_source(2);
                    precrd.setEnter_plate_modify_time(modifyDate);
                    precrd.setEnter_plate_modify_user_name(modifyUserName);
                }
            }
        }
        CarparkPassRecord passRecord = null;
        if (updatePassrecord && (passRecord = (CarparkPassRecord)daoService.selectOne(session, new SearchParam().addEQ("id", (Object)recordId), CarparkPassRecord.class)) != null) {
            if (passRecord.getMedium_type() != null && passRecord.getMedium_type() == 6) {
                CommonParam up2 = this.createModifyPlateUpdateParam(daoService.getTableName(CarparkPassRecord.class), recordId, oldPlate, newPlate, modifyDate, modifyUserCode, modifyUserName, passVo, passRecord);
                daoService.update(session, up2);
            } else {
                CommonParam updateParam = new CommonParam(daoService.getTableName(CarparkPassRecord.class));
                updateParam.addUpdate("pass_plate", (Object)newPlate);
                updateParam.addUpdate("enter_plate", (Object)newPlate);
                updateParam.addUpdate("enter_plate_source", (Object)2);
                updateParam.addUpdate("enter_plate_modify_time", (Object)modifyDate);
                updateParam.addUpdate("enter_plate_modify_user_name", (Object)modifyUserName);
                updateParam.addEQ("id", (Object)recordId);
                updateParam.addEQ("enter_plate", (Object)oldPlate);
                int count = daoService.update(session, updateParam);
                if (count > 0) {
                    passRecord.setPass_plate(newPlate);
                    passRecord.setEnter_plate(newPlate);
                    if (passRecord.getMedium_type() != null && passRecord.getMedium_type() == 6) {
                        passRecord.setPassport_number(newPlate);
                    }
                    passRecord.setEnter_plate_source(2);
                    passRecord.setEnter_plate_modify_time(modifyDate);
                    passRecord.setEnter_plate_modify_user_name(modifyUserName);
                }
            }
        }
        if (!(passRecord == null && precrd == null || (host = ServiceUtil.getServiceContext().getLocalHost()) == null || host.getHost_use() == null || host.getHost_use() != 2 && host.getHost_use() != 3)) {
            CarparkOperationLog opLog = new CarparkOperationLog();
            opLog.setOp_cat(Constants.LOG_OP_CAT_2);
            opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_2_1);
            opLog.setOp_time(modifyDate);
            String text = "\u5c06\u5165\u573a\u8f66\u724c:" + oldPlate + ",\u4fee\u6539\u4e3a:" + newPlate;
            Date enterTime = null;
            if (passRecord != null) {
                enterTime = passRecord.getEnter_time();
            } else if (precrd != null) {
                enterTime = precrd.getEnter_time();
            }
            if (enterTime != null) {
                text = String.valueOf(text) + ",\u5165\u573a\u65f6\u95f4:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(enterTime);
            }
            text = String.valueOf(text) + ",\u8bb0\u5f55Id:" + recordId;
            opLog.setOp_des(text);
            opLog.setOp_user_code(modifyUserCode == null ? "" : modifyUserCode);
            opLog.setOp_user_name(modifyUserName == null ? "" : modifyUserName);
            opLog.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
            opLog.setProject_id(ServiceUtil.getServiceContext().getProjectId());
            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
            daoService.insert(session, (Object)opLog);
        }
        if (passRecord != null) {
            return passRecord;
        }
        return precrd;
    }

    private CommonParam createModifyPlateUpdateParam(String tableName, long recordId, String oldPlate, String newPlate, Date modifyDate, String modifyUserCode, String modifyUserName, PassVo passVo, CarparkPassRecord precrd) {
        CommonParam updateParam = new CommonParam(tableName);
        updateParam.addUpdate("pass_plate", (Object)newPlate);
        precrd.setPass_plate(newPlate);
        updateParam.addUpdate("enter_plate", (Object)newPlate);
        precrd.setEnter_plate(newPlate);
        updateParam.addUpdate("enter_plate_source", (Object)2);
        precrd.setEnter_plate_source(2);
        updateParam.addUpdate("enter_plate_modify_time", (Object)modifyDate);
        precrd.setEnter_plate_modify_time(modifyDate);
        updateParam.addUpdate("enter_plate_modify_user_name", (Object)modifyUserName);
        precrd.setEnter_plate_modify_user_name(modifyUserName);
        updateParam.addUpdate("passport_number", (Object)newPlate);
        precrd.setPassport_number(newPlate);
        if (passVo != null) {
            if (passVo.getPassportType() != null && !passVo.getPassportType().getPassport_type_no().equals(precrd.getPassport_type_no())) {
                updateParam.addUpdate("passport_type_no", (Object)passVo.getPassportType().getPassport_type_no());
                updateParam.addUpdate("passport_type_name", (Object)passVo.getPassportType().getPassport_type_name());
                updateParam.addUpdate("pass_type", (Object)passVo.getPassportType().getPass_type());
                updateParam.addUpdate("enter_passport_type_no", (Object)passVo.getPassportType().getPassport_type_no());
                precrd.setPassport_type_no(passVo.getPassportType().getPassport_type_no());
                precrd.setPassport_type_name(passVo.getPassportType().getPassport_type_name());
                precrd.setPass_type(passVo.getPassportType().getPass_type());
                precrd.setEnter_passport_type_no(passVo.getPassportType().getPassport_type_no());
            }
            if (passVo.getCarOwner() != null) {
                updateParam.addUpdate("car_owner_no", (Object)passVo.getCarOwner().getCar_owner_no());
                updateParam.addUpdate("car_owner_name", (Object)passVo.getCarOwner().getCar_owner_name());
                updateParam.addUpdate("car_owner_addr", (Object)(passVo.getCarOwner().getAddress() == null ? "" : passVo.getCarOwner().getAddress()));
                precrd.setCar_owner_no(passVo.getCarOwner().getCar_owner_no());
                precrd.setCar_owner_name(passVo.getCarOwner().getCar_owner_name());
                precrd.setCar_owner_addr(passVo.getCarOwner().getAddress());
            } else if (precrd.getCar_owner_no() != null && precrd.getCar_owner_no().length() > 0) {
                updateParam.addUpdate("car_owner_no", (Object)"");
                updateParam.addUpdate("car_owner_name", (Object)"");
                updateParam.addUpdate("car_owner_addr", (Object)"");
                precrd.setCar_owner_no("");
                precrd.setCar_owner_name("");
                precrd.setCar_owner_addr("");
            }
            if (passVo.getCarType() != null && !passVo.getCarType().getCar_type_no().equals(precrd.getEnter_car_type_no())) {
                boolean ucar = false;
                if (precrd.getEnter_car_type_no() == null || precrd.getEnter_car_type_no().length() == 0) {
                    ucar = true;
                } else if (precrd.getEnter_default_car_type_no() == null || precrd.getEnter_default_car_type_no().length() == 0) {
                    ucar = true;
                } else if (precrd.getEnter_car_type_no().equals(precrd.getEnter_default_car_type_no())) {
                    ucar = true;
                }
                if (ucar) {
                    updateParam.addUpdate("enter_car_type_no", (Object)passVo.getCarType().getCar_type_no());
                    updateParam.addUpdate("enter_default_car_type_no", (Object)passVo.getCarType().getCar_type_no());
                    updateParam.addUpdate("enter_car_type_name", (Object)passVo.getCarType().getCar_type_name());
                    updateParam.addUpdate("pass_car_type_no", (Object)passVo.getCarType().getCar_type_no());
                    precrd.setEnter_car_type_no(passVo.getCarType().getCar_type_no());
                    precrd.setEnter_default_car_type_no(passVo.getCarType().getCar_type_no());
                    precrd.setEnter_car_type_name(passVo.getCarType().getCar_type_name());
                    precrd.setPass_car_type_no(passVo.getCarType().getCar_type_no());
                }
            }
            if (passVo.getPassport() != null) {
                if (passVo.getPassport().getDeadline() != null) {
                    updateParam.addUpdate("enter_valid_date", (Object)passVo.getPassport().getDeadline());
                } else {
                    updateParam.addUpdate("enter_valid_date=null");
                }
                updateParam.addUpdate("passport_no", (Object)passVo.getPassport().getPassport_no());
                updateParam.addUpdate("enter_balance", (Object)(passVo.getPassport().getBalance() == null ? Constants.MONEY_ZERO : passVo.getPassport().getBalance()));
                precrd.setEnter_valid_date(passVo.getPassport().getDeadline());
                precrd.setEnter_balance(passVo.getPassport().getBalance() == null ? Constants.MONEY_ZERO : passVo.getPassport().getBalance());
                precrd.setPassport_no(passVo.getPassport().getPassport_no());
            }
        }
        updateParam.addEQ("id", (Object)recordId);
        updateParam.addEQ("passport_number", (Object)oldPlate);
        return updateParam;
    }

    @Override
    public void saveIllegalPassRecord(int record_type, String reason_code, String des, String plateNumber, String channelNo, CaptureEvent capture, String opUserCode, String opUserName) {
        ApplicationService appservice;
        UserSession userSession;
        CarparkChannel ch;
        CarparkIllegalPassRecord r = new CarparkIllegalPassRecord();
        r.setPass_time(ServiceUtil.getNow());
        if (plateNumber != null && plateNumber.length() > 0) {
            if (plateNumber.length() > 10) {
                plateNumber = "";
            } else {
                try {
                    if (plateNumber.getBytes("UTF-8").length > 12) {
                        plateNumber = "";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        r.setPass_plate(plateNumber);
        r.setChannel_no(channelNo);
        Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
        if (channelMap != null && (ch = channelMap.get(channelNo)) != null) {
            r.setChannel_name(ch.getChannel_name());
        }
        r.setDirection(0);
        ChannelArea channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(r.getChannel_no());
        if (channelArea != null) {
            CarparkArea passArea = null;
            if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                passArea = channelArea.getExitAreas().get(channelArea.getExitAreas().size() - 1);
                r.setDirection(1);
            } else if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                passArea = channelArea.getEnterAreas().get(0);
            }
            if (passArea != null) {
                r.setArea_no(passArea.getArea_no());
                r.setArea_name(passArea.getArea_name());
                r.setArea_level(passArea.getArea_level());
            }
        }
        r.setRecord_type(record_type);
        r.setReason_code(reason_code);
        r.setDescription(ServiceUtil.getString(des, 100));
        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
        if (localHost != null) {
            r.setHost_no(localHost.getHost_no());
            r.setHost_name(localHost.getHost_name());
        }
        if ((userSession = (appservice = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class)).getUserSession()) != null && userSession.getUser() != null) {
            r.setOp_user_code(userSession.getUser().getUser_code());
            r.setOp_user_name(userSession.getUser().getUser_name());
        } else {
            r.setOp_user_code("");
            r.setOp_user_name("");
        }
        if (opUserCode != null && opUserCode.length() > 0) {
            r.setOp_user_code(ServiceUtil.getString(opUserCode, 45));
        }
        if (opUserName != null && opUserName.length() > 0) {
            r.setOp_user_code(ServiceUtil.getString(opUserName, 45));
        }
        r.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
        r.setProject_id(ServiceUtil.getServiceContext().getProjectId());
        long delayTimills = 0L;
        if (capture != null && capture.getCaptureHandle() != null) {
            if (capture.getCaptureHandle().isDone()) {
                if (capture.getCaptureHandle().getException() == null && capture.getCaptureHandle().getResult() != null && (Integer)capture.getCaptureHandle().getResult() == 0) {
                    r.setPic_path(this.getDbPicPath(capture.getImgLocalPath()));
                }
            } else {
                r.setPic_path(this.getDbPicPath(capture.getImgLocalPath()));
                delayTimills = 6000L;
            }
        }
        final LinkedList<CarparkDispatchTask> dispatchTaskList = new LinkedList<CarparkDispatchTask>();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        try (SqlSession sqlSession = commonDaoService.openSqlSession();){
            try {
                r.setId(appservice.createLocalRecordSeq("ck_carpark_illegal_pass_record_seq"));
                r.setRecord_no("C" + r.getId());
                commonDaoService.insert(sqlSession, (Object)r);
                CarparkLocalConfig localConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig();
                if (localConfig != null && localConfig.getHost_use() == 1) {
                    dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchLocalPicTaskList(r.getPic_path(), "CARPARK_SERVER"));
                    dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(commonDaoService.getTableName(CarparkIllegalPassRecord.class), r.getId().toString(), "CARPARK_SERVER"));
                }
                if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
                    for (CarparkDispatchTask d : dispatchTaskList) {
                        commonDaoService.insert(sqlSession, (Object)d);
                    }
                }
                sqlSession.commit();
            }
            catch (Throwable ex) {
                sqlSession.rollback();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
            if (delayTimills > 0L) {
                ServiceUtil.getServiceContext().getScheduledExecutorService().schedule(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationService appservice = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                        appservice.asynTryRunDispatchTask(dispatchTaskList);
                    }
                }, delayTimills, TimeUnit.MILLISECONDS);
            } else {
                appservice.asynTryRunDispatchTask(dispatchTaskList);
            }
        }
        if (this.illegalPassRecordListeners != null) {
            for (IllegalPassRecordListener l : this.illegalPassRecordListeners) {
                try {
                    l.handleIlleagelPass(r, capture);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String modifyPresenceCarType(long id, String oldCarTypeNo, String newCarTypeNo, String userCode, String userName, Date opTime, boolean dispath) {
        String plateNumber;
        CarparkCarType oldT;
        SearchParam sp;
        if (newCarTypeNo == null || newCarTypeNo.length() == 0) {
            return "\u8f66\u8f86\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map<String, CarparkCarType> cmap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        CarparkCarType newT = null;
        if (cmap != null) {
            newT = cmap.get(newCarTypeNo);
        }
        if (newT == null) {
            return "\u8f66\u8f86\u7c7b\u578b\u4e0d\u5b58\u5728";
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPresenceRecord record = (CarparkPresenceRecord)commonDaoService.selectOne(sp = new SearchParam().addEQ("id", (Object)id), CarparkPresenceRecord.class);
        if (record == null) {
            return "\u5728\u573a\u8bb0\u5f55\u4e0d\u5b58\u5728";
        }
        if (newCarTypeNo.equals(record.getEnter_car_type_no())) {
            return "SUCCESS";
        }
        String oldCarTypeName = null;
        if (oldCarTypeNo != null && oldCarTypeNo.length() > 0 && (oldT = cmap.get(oldCarTypeNo)) != null) {
            oldCarTypeName = oldT.getCar_type_name();
        }
        if (oldCarTypeName == null || oldCarTypeName.length() == 0) {
            oldCarTypeNo = record.getEnter_car_type_no();
            oldCarTypeName = record.getEnter_car_type_name();
        }
        if (oldCarTypeNo == null) {
            oldCarTypeNo = "";
        }
        if (oldCarTypeName == null) {
            oldCarTypeName = "";
        }
        if (userCode == null) {
            userCode = "";
        }
        if (userName == null) {
            userName = "";
        }
        if (opTime == null) {
            opTime = ServiceUtil.getNow();
        }
        int updateCount = 0;
        LinkedList<CarparkDispatchTask> dispatchList = new LinkedList<CarparkDispatchTask>();
        try (SqlSession session = commonDaoService.openSqlSession();){
            CommonParam updateParam = new CommonParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
            updateParam.addUpdate("enter_car_type_no", (Object)newT.getCar_type_no());
            updateParam.addUpdate("enter_default_car_type_no", (Object)oldCarTypeNo);
            updateParam.addUpdate("enter_car_type_name", (Object)newT.getCar_type_name());
            updateParam.addUpdate("pass_car_type_no", (Object)newT.getCar_type_no());
            updateParam.addEQ("id", (Object)id);
            record.setEnter_default_car_type_no(record.getEnter_car_type_no());
            record.setEnter_car_type_no(newT.getCar_type_no());
            record.setEnter_car_type_name(newT.getCar_type_name());
            record.setPass_car_type_no(newT.getCar_type_no());
            updateCount = commonDaoService.update(session, updateParam);
            if (updateCount == 0) {
                return "\u5728\u573a\u8bb0\u5f55\u4e0d\u5b58\u5728";
            }
            try {
                updateParam.setTableName(commonDaoService.getTableName(CarparkPassRecord.class));
                commonDaoService.update(session, updateParam);
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
                if (dispath) {
                    HashMap<String, String> jsonMap = new HashMap<String, String>();
                    jsonMap.put("id", String.valueOf(id));
                    jsonMap.put("userCode", userCode);
                    jsonMap.put("userName", userName);
                    jsonMap.put("opTimeMills", String.valueOf(opTime.getTime()));
                    jsonMap.put("oldCarTypeNo", oldCarTypeNo);
                    jsonMap.put("newCarTypeNo", newCarTypeNo);
                    jsonMap.put("enter_record_no", record.getEnter_record_no());
                    Gson gosn = GsonBuilder.create();
                    String jsonparamString = gosn.toJson(jsonMap);
                    List<CarparkDispatchTask> dlist = DispatchDataTaskUtil.createDispatchTaskList("transferDataService.sendModifyPresenceCarType", jsonparamString, "ALL_HOSTS");
                    if (dlist != null && !dlist.isEmpty()) {
                        for (CarparkDispatchTask task : dlist) {
                            commonDaoService.insert(session, (Object)task);
                            dispatchList.add(task);
                        }
                    }
                }
                if (localHost != null && (localHost.getHost_use() == 2 || localHost.getHost_use() == 3)) {
                    CarparkOperationLog opLog = new CarparkOperationLog();
                    opLog.setOp_cat(Constants.LOG_OP_CAT_2);
                    opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_2_3);
                    opLog.setOp_time(opTime);
                    String text = "\u4fee\u6539\u3010 " + record.getEnter_plate() + "\u3011\u5728\u573a\u8f66\u8f86\u7c7b\u578b\uff08" + oldCarTypeName + "\uff09\u53d8\u66f4\u4e3a\uff1a" + newT.getCar_type_name();
                    Date enterTime = record.getEnter_time();
                    if (enterTime != null) {
                        text = String.valueOf(text) + ",\u5165\u573a\u65f6\u95f4:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(enterTime);
                    }
                    text = String.valueOf(text) + ",\u8bb0\u5f55ID\uff1a" + record.getEnter_record_no();
                    opLog.setOp_des(text);
                    opLog.setOp_user_code(userCode);
                    opLog.setOp_user_name(userName);
                    opLog.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                    opLog.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                    opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
                    commonDaoService.insert(session, (Object)opLog);
                }
                session.commit();
            }
            catch (Throwable ex) {
                session.rollback();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != 1 && (plateNumber = record.getEnter_plate()) != null && plateNumber.length() > 6 && plateNumber.length() < 10) {
            String vrese = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("MEND_CAR_TYPE_MERMERY_DAYS");
            if (vrese == null || vrese.length() == 0) {
                vrese = "180";
            }
            try {
                int arc = Integer.parseInt(vrese);
                if (arc < 0) {
                    arc = 0;
                } else if (arc > 365) {
                    arc = 365;
                }
            }
            catch (Exception ex) {
                boolean arc = false;
            }
            String lockkey = "handleMpdofyPlateCarType_" + plateNumber;
            KeyLockManager keyLockManager = ServiceUtil.getServiceContext().getKeyLockManager();
            Object lock = keyLockManager.getLock(lockkey);
            try {
                Object object = lock;
                synchronized (object) {
                    block48: {
                        session = commonDaoService.openSqlSession();
                        try {
                            try {
                                CarparkPlateCarType platecarType = (CarparkPlateCarType)commonDaoService.selectOne(session, new SearchParam().addEQ("plate_number", (Object)plateNumber), CarparkPlateCarType.class);
                                if (platecarType == null) {
                                    platecarType = new CarparkPlateCarType();
                                    platecarType.setCar_type_no(newCarTypeNo);
                                    platecarType.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                                    platecarType.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                                    ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                                    long plateCarTypeid = appService.createLocalRecordSeq("ck_carpark_plate_car_type_seq");
                                    platecarType.setId(plateCarTypeid);
                                    platecarType.setLast_updated_time(opTime);
                                    platecarType.setPlate_number(plateNumber);
                                    commonDaoService.insert(session, (Object)platecarType);
                                } else {
                                    Date d = platecarType.getLast_updated_time();
                                    if (d == null || d.getTime() <= opTime.getTime()) {
                                        CommonParam p = new CommonParam(commonDaoService.getTableName(CarparkPlateCarType.class));
                                        p.addEQ("plate_number", (Object)plateNumber);
                                        p.addUpdate("last_updated_time", (Object)opTime);
                                        p.addUpdate("car_type_no", (Object)newCarTypeNo);
                                        commonDaoService.update(session, p);
                                    }
                                }
                                session.commit();
                            }
                            catch (Throwable ex) {
                                session.rollback();
                                ServiceLog.getLog().warn((Object)"", ex);
                                session.close();
                                break block48;
                            }
                        }
                        catch (Throwable throwable) {
                            session.close();
                            throw throwable;
                        }
                        session.close();
                    }
                }
            }
            finally {
                keyLockManager.releaseLock(lock);
            }
        }
        if (dispatchList != null && !dispatchList.isEmpty()) {
            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            appService.asynTryRunDispatchTask(dispatchList);
        }
        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new RefreshPresenceRecordEvent(this));
        return "SUCCESS";
    }

    @Override
    public void closeCarparkEscapeOrder(String passport_number, String medium_type, String exit_time, String exit_record_no, String userCode, String userName, Date opTime, boolean dispath) {
        CarparkEscapeOrder order;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        if (medium_type == null || medium_type.length() == 0) {
            medium_type = String.valueOf(6);
        }
        Integer meT = null;
        try {
            if (medium_type != null && medium_type.length() > 0) {
                meT = Integer.valueOf(medium_type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date date = null;
        try {
            if (exit_time != null && exit_time.length() > 0) {
                date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(exit_time);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SearchParam sp = new SearchParam().addEQ("passport_number", (Object)passport_number);
        if (meT != null) {
            sp.addEQ("medium_type", (Object)meT);
        }
        if (date != null) {
            sp.addEQ("exit_time", (Object)date);
        }
        sp.addEQ("exit_record_no", (Object)exit_record_no);
        if (userCode == null) {
            userCode = "";
        }
        if (userName == null) {
            userName = "";
        }
        if (opTime == null) {
            opTime = ServiceUtil.getNow();
        }
        if ((order = (CarparkEscapeOrder)commonDaoService.selectOne(sp, CarparkEscapeOrder.class)) == null) {
            return;
        }
        LinkedList<CarparkDispatchTask> dispatchList = new LinkedList<CarparkDispatchTask>();
        CarparkOperationLog opLog = null;
        if (dispath) {
            CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
            if (localHost != null && (localHost.getHost_use() == 2 || localHost.getHost_use() == 3)) {
                HashMap<String, String> pMap = new HashMap<String, String>();
                pMap.put("userCode", userCode);
                pMap.put("userName", userName);
                pMap.put("opTimeMills", String.valueOf(opTime.getTime()));
                pMap.put("passport_number", passport_number);
                pMap.put("medium_type", medium_type);
                pMap.put("exit_time", exit_time);
                pMap.put("exit_record_no", exit_record_no);
                String jsonparamx = GsonBuilder.create().toJson(pMap);
                List<CarparkDispatchTask> dlIlist = DispatchDataTaskUtil.createDispatchTaskList("transferDataService.sendCloseEscapeOrder", jsonparamx, "ALL_HOSTS");
                if (dlIlist != null && !dlIlist.isEmpty()) {
                    for (CarparkDispatchTask task : dlIlist) {
                        dispatchList.add(task);
                    }
                }
            }
            opLog = new CarparkOperationLog();
            opLog.setOp_cat(Constants.LOG_OP_CAT_2);
            opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_2_6);
            opLog.setOp_time(opTime);
            String text = "\u5173\u95ed\u79bb\u573a\u672a\u652f\u4ed8\u8ba2\u5355\uff01\u8f66\u724c: " + order.getPass_plate();
            Date eTime = order.getExit_time();
            if (eTime != null) {
                text = String.valueOf(text) + ",\u53d6\u6d88\u79bb\u573a\u65f6\u95f4:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(eTime);
            }
            text = String.valueOf(text) + ",\u8ba2\u5355\u53f7:" + order.getExit_record_no();
            opLog.setOp_des(text);
            opLog.setOp_user_code(userCode);
            opLog.setOp_user_name(userName);
            opLog.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
            opLog.setProject_id(ServiceUtil.getServiceContext().getProjectId());
            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
        }
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkEscapeOrder.class));
                updateP.addEQ("id", (Object)order.getId());
                updateP.addEQ("order_state", (Object)0);
                updateP.addUpdate("order_state", (Object)2);
                commonDaoService.update(session, updateP);
                if (dispatchList != null && !dispatchList.isEmpty()) {
                    for (CarparkDispatchTask task : dispatchList) {
                        commonDaoService.insert(session, (Object)task);
                    }
                }
                if (opLog != null) {
                    commonDaoService.insert(session, (Object)opLog);
                }
                session.commit();
            }
            catch (Throwable ex) {
                session.rollback();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void removeCarparkPresenceRecord(long id, String userCode, String userName, Date opTime, boolean dispath) {
        List<String> list;
        SearchParam sp;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPresenceRecord record = (CarparkPresenceRecord)commonDaoService.selectOne(sp = new SearchParam().addEQ("id", (Object)id), CarparkPresenceRecord.class);
        if (record == null) {
            return;
        }
        List sublist = null;
        if (record.getArea_no() != null && record.getArea_no().length() > 0 && (list = ServiceUtil.getServiceContext().getDBConfigCache().getAllSbuArea(record.getArea_no())) != null && !list.isEmpty()) {
            sp = new SearchParam();
            sp.addEQ("passport_number", (Object)record.getPassport_number());
            sp.addEQ("medium_type", (Object)record.getMedium_type());
            if (list.size() == 1) {
                sp.addEQ("area_no", (Object)list.get(0));
            } else {
                sp.addINList("area_no", list);
            }
            sublist = commonDaoService.selectList(sp, CarparkPresenceRecord.class, null);
        }
        int size = 1;
        if (sublist != null && !sublist.isEmpty()) {
            size += sublist.size();
        }
        ArrayList<CarparkPresenceRecord> updateList = new ArrayList<CarparkPresenceRecord>(size);
        updateList.add(record);
        if (sublist != null && !sublist.isEmpty()) {
            updateList.addAll(sublist);
        }
        LinkedList<CarparkDispatchTask> dispatchList = new LinkedList<CarparkDispatchTask>();
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                if (userCode == null) {
                    userCode = "";
                }
                if (userName == null) {
                    userName = "";
                }
                if (opTime == null) {
                    opTime = ServiceUtil.getNow();
                }
                for (CarparkPresenceRecord r : updateList) {
                    CommonParam updateParam = new CommonParam(commonDaoService.getTableName(CarparkPassRecord.class));
                    updateParam.addUpdate("remove_user_code", (Object)userCode);
                    updateParam.addUpdate("remove_user_name", (Object)userName);
                    if (r.getEnter_time() != null) {
                        updateParam.addUpdate("remove_enter_time", (Object)r.getEnter_time());
                    }
                    updateParam.addUpdate("remove_op_time", (Object)opTime);
                    updateParam.addEQ("id", (Object)r.getId());
                    commonDaoService.update(session, updateParam);
                    SearchParam delParam = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
                    delParam.addEQ("id", (Object)r.getId());
                    commonDaoService.delete(session, delParam);
                }
                if (dispath) {
                    CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
                    if (localHost != null && (localHost.getHost_use() == 2 || localHost.getHost_use() == 3)) {
                        HashMap<String, String> pMap = new HashMap<String, String>();
                        pMap.put("id", String.valueOf(id));
                        pMap.put("userCode", userCode);
                        pMap.put("userName", userName);
                        pMap.put("opTimeMills", String.valueOf(opTime.getTime()));
                        String jsonparamx = GsonBuilder.create().toJson(pMap);
                        List<CarparkDispatchTask> dlIlist = DispatchDataTaskUtil.createDispatchTaskList("transferDataService.sendRemoveCarparkPresenceRecord", jsonparamx, "ALL_HOSTS");
                        if (dlIlist != null && !dlIlist.isEmpty()) {
                            for (CarparkDispatchTask task : dlIlist) {
                                commonDaoService.insert(session, (Object)task);
                                dispatchList.add(task);
                            }
                        }
                    }
                    CarparkOperationLog opLog = new CarparkOperationLog();
                    opLog.setOp_cat(Constants.LOG_OP_CAT_2);
                    opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_2_2);
                    opLog.setOp_time(opTime);
                    String text = "\u5220\u9664\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\uff01\u8f66\u724c: " + record.getEnter_plate();
                    Date enterTime = record.getEnter_time();
                    if (enterTime != null) {
                        text = String.valueOf(text) + ",\u5165\u573a\u65f6\u95f4:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(enterTime);
                    }
                    text = String.valueOf(text) + ",\u8bb0\u5f55Id:" + record.getId();
                    opLog.setOp_des(text);
                    opLog.setOp_user_code(userCode);
                    opLog.setOp_user_name(userName);
                    opLog.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                    opLog.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                    ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
                    commonDaoService.insert(session, (Object)opLog);
                }
                session.commit();
            }
            catch (Throwable ex) {
                session.rollback();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        if (dispatchList != null && !dispatchList.isEmpty()) {
            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            appService.asynTryRunDispatchTask(dispatchList);
        }
        ServiceUtil.getServiceContext().getDBConfigCache().addAdjustTakeValue(record.getArea_no(), 1, 1);
        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new RefreshPresenceRecordEvent(this));
    }

    @Override
    public void doTakeOfflineInvoce(CarparkTransaction transtaction, String userCode, String userName, Date opTime) {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        if (transtaction.getId() == null) {
            throw new NullPointerException("transtaction.id is null!");
        }
        CommonParam updateP = new CommonParam(daoService.getTableName(CarparkTransaction.class));
        updateP.addUpdate("invoice_status", (Object)1);
        updateP.addEQ("id", (Object)transtaction.getId());
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        Gson gson = GsonBuilder.create();
        HashMap<String, String> vmap = new HashMap<String, String>();
        vmap.put("tranId", transtaction.getId().toString());
        String json_data2 = gson.toJson(vmap);
        List<CarparkDispatchTask> dispatchTaskList = DispatchDataTaskUtil.createDispatchTaskList("transferDataService.invoiceOfflineSuccess", json_data2, "ALL_HOSTS");
        try (SqlSession session = daoService.openSqlSession();){
            try {
                Date t;
                daoService.update(session, updateP);
                if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
                    for (CarparkDispatchTask task : dispatchTaskList) {
                        daoService.insert(session, (Object)task);
                    }
                }
                CarparkOperationLog opLog = new CarparkOperationLog();
                opLog.setOp_cat(Constants.LOG_OP_CAT_2);
                opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_2_5);
                opLog.setOp_time(opTime);
                String text = "\u9886\u53d6\u7ebf\u4e0b\u53d1\u7968\uff01 ";
                if (transtaction.getPlate_number() != null && transtaction.getPlate_number().length() > 0) {
                    text = String.valueOf(text) + "\u7f34\u8d39\u8f66\u724c\uff1a" + transtaction.getPlate_number() + "\uff0c";
                }
                if ((t = transtaction.getTran_time()) != null) {
                    text = String.valueOf(text) + "\u7f34\u8d39/\u652f\u4ed8\u65f6\u95f4:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(t) + "\uff0c";
                }
                text = String.valueOf(text) + "\u7f34\u8d39/\u652f\u4ed8\u91d1\u989d\uff1a" + transtaction.getTran_money() + "\uff0c";
                if (transtaction.getTran_des() != null && transtaction.getTran_des().length() > 0) {
                    text = String.valueOf(text) + "\u63cf\u8ff0\uff1a" + transtaction.getTran_des();
                }
                text = String.valueOf(text) + ",\u4ea4\u6613\u7f16\u53f7:" + transtaction.getTansaction_no();
                opLog.setOp_des(text);
                opLog.setOp_user_code(userCode);
                opLog.setOp_user_name(userName);
                opLog.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                opLog.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
                daoService.insert(session, (Object)opLog);
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
            appService.asynTryRunDispatchTask(dispatchTaskList);
        }
    }

    @Override
    public void addPassRecordListener(CarparkPassRecordListener l) {
        if (l != null) {
            this.carparkPassRecordListeners.add(l);
        }
    }

    @Override
    public void removePassRecordListener(CarparkPassRecordListener l) {
        if (l != null) {
            this.carparkPassRecordListeners.remove(l);
        }
    }

    @Override
    public Collection<CarparkPassRecordListener> getCarparkPassRecordListeners() {
        return Collections.unmodifiableCollection(this.carparkPassRecordListeners);
    }

    @Override
    public void onAddPassRecord(SqlSession session, CarparkPassRecord passRecord, boolean remotePass) {
        if (passRecord.getPass_time() != null && passRecord.getPassport_number() != null && passRecord.getArea_level() != null && passRecord.getArea_level() == 1 && passRecord.getExit_time() != null && passRecord.getEnter_time() != null) {
            CommonDaoService commonService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            CommonParam searchParam = new CommonParam(commonService.getTableName(CarparkEscapeOrder.class));
            searchParam.addEQ("passport_number", (Object)passRecord.getPassport_number());
            searchParam.addLTE("exit_time", (Object)passRecord.getExit_time());
            searchParam.addEQ("medium_type", (Object)passRecord.getMedium_type());
            searchParam.addEQ("carpark_id", (Object)passRecord.getCarpark_id());
            searchParam.addEQ("area_no", (Object)passRecord.getArea_no());
            searchParam.addEQ("enter_time", (Object)passRecord.getEnter_time());
            searchParam.addEQ("order_state", (Object)0);
            commonService.delete(session, (SearchParam)searchParam);
        }
        try {
            if (passRecord.getExit_time() != null && passRecord.getEnter_time() == null && passRecord.getArea_no() != null && passRecord.getArea_no().length() > 0) {
                ServiceUtil.getServiceContext().getDBConfigCache().addAdjustTakeValue(passRecord.getArea_no(), 0, -1);
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)ex.getMessage(), (Throwable)ex);
        }
        for (CarparkPassRecordListener l : this.carparkPassRecordListeners) {
            l.onAdd(passRecord, session, remotePass);
        }
    }

    @Override
    public void addIllegalPassRecordListener(IllegalPassRecordListener l) {
        if (l != null) {
            this.illegalPassRecordListeners.add(l);
        }
    }

    @Override
    public void removeIllegalPassRecordListener(IllegalPassRecordListener l) {
        if (l != null) {
            this.illegalPassRecordListeners.remove(l);
        }
    }

    @Override
    public Collection<IllegalPassRecordListener> getIllegalPassRecordListeners() {
        return this.illegalPassRecordListeners;
    }

    @Override
    public void saveVehicleTypeEvent(VehicleTypeEvent event, boolean uploadToServer) {
        if (event.getPlateNumber() == null || event.getPlateNumber().length() == 0) {
            event.setPlateNumber("\u65e0\u8f66\u724c");
        }
        String picDbPath = this.getDbPicPath(event.getPicPath());
        String picDBSmallPath = this.getDbPicPath(event.getPlateSmallPath());
        CarparkRegplateRecord record = new CarparkRegplateRecord();
        record.setCamera_no(event.getEquipmentNo());
        record.setCar_color(ServiceUtil.getString(event.getCarColor(), 10));
        record.setTrigger_method(10);
        record.setCar_type(ServiceUtil.getString(event.getVehicleType(), 20));
        record.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
        record.setChannel_no(event.getChannelNo());
        record.setHost_no(ServiceUtil.getServiceContext().getLocalHostNo());
        record.setPlate_color(ServiceUtil.getString(event.getPlateColor(), 10));
        record.setPlate_confi(ServiceUtil.getString(event.getConfidence(), 10));
        record.setPlate_number(ServiceUtil.getString(event.getPlateNumber(), 20));
        record.setProject_id(ServiceUtil.getServiceContext().getProjectId());
        record.setReg_time(ServiceUtil.getDatetime(new Date(event.getSystemMills())));
        record.setBig_pic_path(ServiceUtil.getString(picDbPath, 200));
        record.setSmall_pic_path(ServiceUtil.getString(picDBSmallPath, 200));
        StringBuilder sbr = new StringBuilder(256);
        if (event.getWheelCnt() != null && event.getWheelCnt().length() > 0) {
            if (sbr.length() > 0) {
                sbr.append(", ");
            }
            sbr.append("\u8f6e\u6570: " + event.getWheelCnt());
        }
        if (event.getAxleCnt() != null && event.getAxleCnt().length() > 0) {
            if (sbr.length() > 0) {
                sbr.append(", ");
            }
            sbr.append("\u8f74\u6570: " + event.getAxleCnt());
        }
        if (event.getWheelbase() != null && event.getWheelbase().length() > 0) {
            if (sbr.length() > 0) {
                sbr.append(", ");
            }
            sbr.append("\u8f74\u8ddd: " + event.getWheelbase());
        }
        if (event.getCarLength() != null && event.getCarLength().length() > 0) {
            if (sbr.length() > 0) {
                sbr.append(", ");
            }
            sbr.append("\u8f66\u957f: " + event.getCarLength());
        }
        if (event.getCarHeight() != null && event.getCarHeight().length() > 0) {
            if (sbr.length() > 0) {
                sbr.append(", ");
            }
            sbr.append("\u8f66\u9ad8: " + event.getCarHeight());
        }
        if (sbr.length() > 0) {
            record.setFeatures(ServiceUtil.getString(sbr.toString(), 500));
        }
        LinkedList<CarparkDispatchTask> taskList = null;
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        try (SqlSession session = daoService.openSqlSession();){
            try {
                CarparkLocalConfig localConfig;
                long rid = appService.createLocalRecordSeq("ck_carpark_regplate_record_seq");
                record.setId(rid);
                record.setReg_no("C" + record.getId().toString());
                if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != 1 && uploadToServer && (localConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig()) != null && localConfig.getHost_use() == 1) {
                    taskList = new LinkedList<CarparkDispatchTask>();
                    String dipathPicType = "CARPARK_SERVER";
                    boolean needUpIc = true;
                    if (localConfig.getNet_mode() == 2) {
                        CarparkUdpP2pConnection conn = ServiceUtil.getServiceContext().getCarparkUdpP2pConnection();
                        if (conn == null) {
                            needUpIc = false;
                        } else {
                            CarparkUdpConnSession sessiono = conn.getConnectedServerSession();
                            if (sessiono == null) {
                                needUpIc = false;
                            } else if (sessiono.isUseCloudProxy()) {
                                needUpIc = false;
                            }
                        }
                    }
                    if (needUpIc) {
                        taskList.addAll(DispatchDataTaskUtil.createDispatchLocalPicTaskList(picDbPath, dipathPicType));
                        taskList.addAll(DispatchDataTaskUtil.createDispatchLocalPicTaskList(picDBSmallPath, dipathPicType));
                    }
                    taskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(daoService.getTableName(CarparkRegplateRecord.class), record.getId(), "CARPARK_SERVER"));
                }
                daoService.insert(session, (Object)record);
                if (taskList != null && !taskList.isEmpty()) {
                    for (CarparkDispatchTask h : taskList) {
                        daoService.insert(session, (Object)h);
                    }
                }
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        if (taskList != null && !taskList.isEmpty()) {
            appService.asynTryRunDispatchTask(taskList);
        }
    }

    @Override
    public void doFormalOperation(boolean dispatch, Date delDate) {
        LinkedHashMap<String, String> recordMap = new LinkedHashMap<String, String>();
        recordMap.put("ck_carpark_cancel_pass_record", "pass_time");
        recordMap.put("ck_carpark_discount_record", "discount_time");
        recordMap.put("ck_carpark_illegal_pass_record", "pass_time");
        recordMap.put("ck_carpark_invoice_order", "created_time");
        recordMap.put("ck_carpark_pass_record", "pass_time");
        recordMap.put("ck_carpark_transaction", "tran_time");
        recordMap.put("ck_carpark_visit_auth_record", "created_time");
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        for (Map.Entry en : recordMap.entrySet()) {
            try {
                commonDaoService.delete(new SearchParam((String)en.getKey()).addLT((String)en.getValue(), (Object)delDate));
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u4e0a\u7ebf\u5904\u7406\u5220\u9664\u8868: " + (String)en.getKey() + " \u64cd\u4f5c\u5931\u8d25"));
            }
        }
        if (dispatch) {
            LinkedList<CarparkDispatchTask> dispatchList = new LinkedList<CarparkDispatchTask>();
            String deleteTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(delDate);
            CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
            if (localHost != null && (localHost.getHost_use() == 2 || localHost.getHost_use() == 3)) {
                HashMap<String, String> pMap = new HashMap<String, String>();
                pMap.put("deleteTime", deleteTime);
                String jsonparamx = GsonBuilder.create().toJson(pMap);
                List<CarparkDispatchTask> dlIlist = DispatchDataTaskUtil.createDispatchTaskList("transferDataService.sendFormalOperation", jsonparamx, "ALL_HOSTS");
                if (dlIlist != null && !dlIlist.isEmpty()) {
                    for (CarparkDispatchTask task : dlIlist) {
                        commonDaoService.insert((Object)task);
                        dispatchList.add(task);
                    }
                }
            }
            if (dispatchList != null && !dispatchList.isEmpty()) {
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                appService.asynTryRunDispatchTask(dispatchList);
            }
        }
    }

    @Override
    public void adjustParkingSpace(String areaNo, String spaceTypeNo, int remainSpace, String userCode, String userName, Date opTime, boolean dispath) {
        int present_adjust;
        CarparkArea area;
        if (areaNo == null || areaNo.length() == 0 || opTime == null) {
            return;
        }
        if (spaceTypeNo == null) {
            spaceTypeNo = "";
        }
        Integer carparkId = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkSpaceAdjustment adj = (CarparkSpaceAdjustment)commonDaoService.selectOne(new SearchParam().addEQ("area_no", (Object)areaNo).addEQ("space_type_no", (Object)spaceTypeNo).addEQ("carpark_id", (Object)carparkId), CarparkSpaceAdjustment.class);
        if (adj != null && adj.getAdjust_time() != null && adj.getAdjust_time().getTime() >= opTime.getTime()) {
            return;
        }
        CarparkSpaceType spaceType = null;
        CarparkSpaceTypeQuantity quantity = null;
        List defineList = null;
        if (spaceTypeNo.length() > 0) {
            spaceType = (CarparkSpaceType)commonDaoService.selectOne(new SearchParam().addEQ("space_type_no", (Object)spaceTypeNo).addEQ("carpark_id", (Object)carparkId), CarparkSpaceType.class);
            if (spaceType == null) {
                return;
            }
            quantity = (CarparkSpaceTypeQuantity)commonDaoService.selectOne(new SearchParam().addEQ("area_no", (Object)areaNo).addEQ("space_type_no", (Object)spaceTypeNo).addEQ("carpark_id", (Object)carparkId), CarparkSpaceTypeQuantity.class);
            if (quantity == null || quantity.getQuantity() <= 0) {
                return;
            }
            defineList = commonDaoService.selectList(new SearchParam().addEQ("space_type_no", (Object)spaceTypeNo).addEQ("carpark_id", (Object)carparkId), CarparkSpaceTypeDefine.class, null);
            if (defineList == null || defineList.isEmpty()) {
                return;
            }
        }
        if ((area = (CarparkArea)commonDaoService.selectOne(new SearchParam().addEQ("area_no", (Object)areaNo).addEQ("carpark_id", (Object)carparkId), CarparkArea.class)) == null || area.getSpace_quantities() == null) {
            return;
        }
        int space_quantities = area.getSpace_quantities();
        if (space_quantities <= 0) {
            return;
        }
        List subAreaList = commonDaoService.selectList(new SearchParam().addEQ("parent_area_no", (Object)areaNo).addEQ("carpark_id", (Object)carparkId), CarparkArea.class, null);
        if (spaceTypeNo.length() > 0) {
            space_quantities = quantity.getQuantity();
            if (remainSpace > space_quantities) {
                remainSpace = space_quantities;
            }
            SearchParam searchParam = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
            searchParam.setQueryFields(new String[]{"count(id) AS count", "area_no", "passport_type_no", "enter_car_type_no"});
            searchParam.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
            searchParam.addEQ("project_id", (Object)ServiceUtil.getServiceContext().getProjectId());
            searchParam.setWhereString(" AND enter_time IS NOT NULL AND exit_time IS NULL");
            searchParam.setGroup_by("area_no, passport_type_no, enter_car_type_no");
            if (subAreaList != null && !subAreaList.isEmpty()) {
                searchParam.addIN("area_no", (Object)areaNo);
                for (CarparkArea a : subAreaList) {
                    searchParam.addIN("area_no", (Object)a.getArea_no());
                }
            } else {
                searchParam.addEQ("area_no", (Object)areaNo);
            }
            HashMap<String, Integer> spaceCache0 = new HashMap<String, Integer>();
            List list = commonDaoService.selectList(searchParam, null);
            if (list != null && !list.isEmpty()) {
                for (Map vmap : list) {
                    Integer a;
                    String keyArea = "a_" + vmap.get("area_no");
                    String keyPassportType = String.valueOf(keyArea) + "-b_" + vmap.get("passport_type_no");
                    String keyCarType = String.valueOf(keyArea) + "-c_" + vmap.get("enter_car_type_no");
                    String keyPassportTypeCarType = String.valueOf(keyPassportType) + "-c_" + vmap.get("enter_car_type_no");
                    Long count = (Long)vmap.get("count");
                    if (count == null) continue;
                    if (count < 0L) {
                        count = 0L;
                    }
                    a = (a = (Integer)spaceCache0.get(keyArea)) == null ? Integer.valueOf(count.intValue()) : Integer.valueOf(a + count.intValue());
                    spaceCache0.put(keyArea, a);
                    a = (Integer)spaceCache0.get(keyPassportType);
                    a = a == null ? Integer.valueOf(count.intValue()) : Integer.valueOf(a + count.intValue());
                    spaceCache0.put(keyPassportType, a);
                    a = (Integer)spaceCache0.get(keyCarType);
                    a = a == null ? Integer.valueOf(count.intValue()) : Integer.valueOf(a + count.intValue());
                    spaceCache0.put(keyCarType, a);
                    spaceCache0.put(keyPassportTypeCarType, count.intValue());
                }
            }
            int count1 = 0;
            int count2 = 0;
            for (CarparkSpaceTypeDefine d : defineList) {
                if (!spaceTypeNo.equals(d.getSpace_type_no())) continue;
                if (d.getPassport_type_no() != null && d.getPassport_type_no().length() > 0 && d.getCar_type_no() != null && d.getCar_type_no().length() > 0) {
                    count1 += this.getTookSpace(spaceCache0, area.getArea_no(), d.getPassport_type_no(), d.getCar_type_no());
                } else if (d.getPassport_type_no() != null && d.getPassport_type_no().length() > 0 && (d.getCar_type_no() == null || d.getCar_type_no().length() == 0)) {
                    count1 += this.getTookSpaceByPassportType(spaceCache0, area.getArea_no(), d.getPassport_type_no());
                } else if ((d.getPassport_type_no() == null || d.getPassport_type_no().length() == 0) && d.getCar_type_no() != null && d.getCar_type_no().length() > 0) {
                    count1 += this.getTookSpaceByCarType(spaceCache0, area.getArea_no(), d.getCar_type_no());
                }
                if (subAreaList == null || subAreaList.isEmpty()) continue;
                for (CarparkArea s : subAreaList) {
                    if (d.getPassport_type_no() != null && d.getPassport_type_no().length() > 0 && d.getCar_type_no() != null && d.getCar_type_no().length() > 0) {
                        count2 += this.getTookSpace(spaceCache0, s.getArea_no(), d.getPassport_type_no(), d.getCar_type_no());
                        continue;
                    }
                    if (d.getPassport_type_no() != null && d.getPassport_type_no().length() > 0 && (d.getCar_type_no() == null || d.getCar_type_no().length() == 0)) {
                        count2 += this.getTookSpaceByPassportType(spaceCache0, s.getArea_no(), d.getPassport_type_no());
                        continue;
                    }
                    if (d.getPassport_type_no() != null && d.getPassport_type_no().length() != 0 || d.getCar_type_no() == null || d.getCar_type_no().length() <= 0) continue;
                    count2 += this.getTookSpaceByCarType(spaceCache0, s.getArea_no(), d.getCar_type_no());
                }
            }
            int adjustC = space_quantities - remainSpace;
            int r_take_Count = count1 - count2;
            if (r_take_Count < 0) {
                r_take_Count = 0;
            }
            present_adjust = adjustC - r_take_Count;
        } else {
            if (remainSpace > space_quantities) {
                remainSpace = space_quantities;
            }
            long take_Count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class)).addEQ("area_no", (Object)areaNo).addEQ("carpark_id", (Object)carparkId));
            long sub_take_Count = 0L;
            if (subAreaList != null && !subAreaList.isEmpty()) {
                SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
                if (subAreaList.size() == 1) {
                    sp.addEQ("area_no", (Object)((CarparkArea)subAreaList.get(0)).getArea_no());
                } else {
                    for (CarparkArea a : subAreaList) {
                        sp.addIN("area_no", (Object)a.getArea_no());
                    }
                }
                sp.addEQ("carpark_id", (Object)carparkId);
                sub_take_Count = commonDaoService.selectCount(sp);
            }
            int adjustC = space_quantities - remainSpace;
            int r_take_Count = (int)(take_Count - sub_take_Count);
            if (r_take_Count < 0) {
                r_take_Count = 0;
            }
            present_adjust = adjustC - r_take_Count;
        }
        Date now = ServiceUtil.getNow();
        if (adj == null) {
            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            adj = new CarparkSpaceAdjustment();
            adj.setId(appService.createLocalRecordSeq("ck_carpark_transaction_seq"));
            adj.setSpace_type_no(spaceTypeNo);
            adj.setArea_no(area.getArea_no());
            adj.setPresent_adjust(present_adjust);
            adj.setAdjust_remain_spaces(remainSpace);
            adj.setAdjust_time(opTime);
            adj.setCreated_time(now);
            adj.setLast_updated_time(now);
            adj.setCarpark_id(carparkId);
            adj.setProject_id(ServiceUtil.getServiceContext().getProjectId());
            commonDaoService.insert((Object)adj);
        } else {
            CommonParam updatp = new CommonParam(commonDaoService.getTableName(CarparkSpaceAdjustment.class));
            updatp.addUpdate("present_adjust", (Object)present_adjust);
            updatp.addUpdate("adjust_remain_spaces", (Object)remainSpace);
            updatp.addUpdate("adjust_time", (Object)opTime);
            updatp.addUpdate("last_updated_time", (Object)now);
            updatp.addEQ("id", (Object)adj.getId());
            commonDaoService.update(updatp);
        }
        ServiceUtil.getServiceContext().getDBConfigCache().loadAdjustTakeValue(areaNo, spaceTypeNo);
        final String udateMsg = String.valueOf(userName) + "\u4fee\u6539" + area.getArea_name() + "\u7684\u4f59\u4f4d\u4e3a: " + remainSpace + "\u5728\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(opTime);
        ServiceLog.getLog().info((Object)udateMsg);
        ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(new InformationEvent(this, udateMsg, 2));
        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
        if (localHost != null && (localHost.getHost_use() == 2 || localHost.getHost_use() == 3)) {
            CarparkOperationLog opLog = new CarparkOperationLog();
            opLog.setOp_cat(Constants.LOG_OP_CAT_2);
            opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_2_7);
            opLog.setOp_time(ServiceUtil.getNow());
            String text = "\u4fee\u6539" + area.getArea_name();
            if (spaceType != null) {
                text = String.valueOf(text) + "[" + spaceType.getSpace_type_name() + "]";
            }
            text = String.valueOf(text) + "\u7684\u4f59\u4f4d\u4e3a: " + remainSpace + ", \u64cd\u4f5c\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(opTime);
            opLog.setOp_des(text);
            opLog.setOp_user_code(userCode == null ? "" : userCode);
            opLog.setOp_user_name(userName == null ? "" : userName);
            opLog.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
            opLog.setProject_id(ServiceUtil.getServiceContext().getProjectId());
            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
            commonDaoService.insert((Object)opLog);
        }
        if (dispath) {
            final HashMap<String, String> pMap = new HashMap<String, String>();
            pMap.put("areaNo", areaNo);
            pMap.put("spaceTypeNo", spaceTypeNo);
            pMap.put("remainSpace", String.valueOf(remainSpace));
            pMap.put("userCode", userCode);
            pMap.put("userName", userName);
            pMap.put("opTimeMills", String.valueOf(opTime.getTime()));
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != 1 && localHost != null) {
                Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
                for (final CarparkHost host : hostMap.values()) {
                    if (host == null || host.getHost_no().equals(localHost.getHost_no())) continue;
                    if (ServiceUtil.getServiceContext().isConected(host.getHost_no())) {
                        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                            @Override
                            public void run() {
                                RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(host.getHost_no(), true);
                                if (rpc == null) {
                                    ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u901a\u77e5\u4e3b\u673a\uff1a" + host.getHost_name() + "\u4fee\u6539\u4f59\u4f4d, \u4e3b\u673a\u4e0d\u5728\u7ebf\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f42\u8fb9\u4f59\u4f4d\u4e0d\u4e00\u81f4, \u5f53\u4e3b\u673a\u5728\u7ebf\u91cd\u65b0\u8bbe\u7f6e\u4f59\u4f4d\u53ef\u4ee5\u89e3\u51b3\u6b64\u95ee\u9898"));
                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(new InformationEvent(this, "\u65e0\u6cd5\u901a\u77e5\u4e3b\u673a\uff1a" + host.getHost_name() + "\u4fee\u6539\u4f59\u4f4d, \u4e3b\u673a\u4e0d\u5728\u7ebf, \u8fd9\u53ef\u80fd\u5bfc\u81f4\u4f59\u4f4d\u4e0d\u4e00\u81f4, \u5f53\u4e3b\u673a\u5728\u7ebf\u91cd\u65b0\u8bbe\u7f6e\u4f59\u4f4d\u53ef\u4ee5\u89e3\u51b3\u6b64\u95ee\u9898", 4));
                                } else {
                                    CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
                                    try {
                                        ResultResponse reponse = rpcService.adjustParkingSpace(pMap, new HashMap<String, Object>());
                                        if (!reponse.isSuccess()) {
                                            throw new Exception("\u64cd\u4f5c\u5931\u8d25: " + reponse.getResponseMsg());
                                        }
                                        ServiceLog.getLog().info((Object)("\u901a\u77e5\u4e3b\u673a: " + host.getHost_name() + ", " + udateMsg + ", \u64cd\u4f5c\u6210\u529f"));
                                    }
                                    catch (Throwable ex) {
                                        ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u901a\u77e5\u4e3b\u673a\uff1a" + host.getHost_name() + "\u4fee\u6539\u4f59\u4f4d, \u4e3b\u673a\u4e0d\u5728\u7ebf\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f42\u8fb9\u4f59\u4f4d\u4e0d\u4e00\u81f4, \u5f53\u4e3b\u673a\u5728\u7ebf\u91cd\u65b0\u8bbe\u7f6e\u4f59\u4f4d\u53ef\u4ee5\u89e3\u51b3\u6b64\u95ee\u9898, " + ex.getMessage()));
                                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(new InformationEvent(this, "\u65e0\u6cd5\u901a\u77e5\u4e3b\u673a\uff1a" + host.getHost_name() + "\u4fee\u6539\u4f59\u4f4d\u64cd\u4f5c\u5931\u8d25, \u8fd9\u53ef\u80fd\u5bfc\u81f4\u4f59\u4f4d\u4e0d\u4e00\u81f4, \u5f53\u4e3b\u673a\u5728\u7ebf\u91cd\u65b0\u8bbe\u7f6e\u4f59\u4f4d\u53ef\u4ee5\u89e3\u51b3\u6b64\u95ee\u9898", 4));
                                    }
                                }
                            }
                        });
                        continue;
                    }
                    ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u901a\u77e5\u4e3b\u673a\uff1a" + host.getHost_name() + "\u4fee\u6539\u4f59\u4f4d, \u4e3b\u673a\u4e0d\u5728\u7ebf\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f42\u8fb9\u4f59\u4f4d\u4e0d\u4e00\u81f4, \u5f53\u4e3b\u673a\u5728\u7ebf\u91cd\u65b0\u8bbe\u7f6e\u4f59\u4f4d\u53ef\u4ee5\u89e3\u51b3\u6b64\u95ee\u9898"));
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(new InformationEvent(this, "\u65e0\u6cd5\u901a\u77e5\u4e3b\u673a\uff1a" + host.getHost_name() + "\u4fee\u6539\u4f59\u4f4d, \u4e3b\u673a\u4e0d\u5728\u7ebf, \u8fd9\u53ef\u80fd\u5bfc\u81f4\u4f59\u4f4d\u4e0d\u4e00\u81f4, \u5f53\u4e3b\u673a\u5728\u7ebf\u91cd\u65b0\u8bbe\u7f6e\u4f59\u4f4d\u53ef\u4ee5\u89e3\u51b3\u6b64\u95ee\u9898", 4));
                }
            }
        }
        ParkingSpace.getInstance().refresh();
    }

    private int getTookSpace(Map<String, Integer> spaceCache, String areaNo, String passportTypeNo, String carTypeNo) {
        String key = "a_" + areaNo + "-b_" + passportTypeNo + "-c_" + carTypeNo;
        Integer a = spaceCache.get(key);
        int c = 0;
        if (a != null && (c = a.intValue()) < 0) {
            c = 0;
        }
        return c;
    }

    public int getTookSpaceByPassportType(Map<String, Integer> spaceCache, String areaNo, String passportTypeNo) {
        String key = "a_" + areaNo + "-b_" + passportTypeNo;
        Integer a = spaceCache.get(key);
        int c = 0;
        if (a != null && (c = a.intValue()) < 0) {
            c = 0;
        }
        return c;
    }

    public int getTookSpaceByCarType(Map<String, Integer> spaceCache, String areaNo, String carTypeNo) {
        String key = "a_" + areaNo + "-c_" + carTypeNo;
        Integer a = spaceCache.get(key);
        int c = 0;
        if (a != null && (c = a.intValue()) < 0) {
            c = 0;
        }
        return c;
    }
}

