/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.service.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.RpcReomtecServiceFactory;
import com.wovoe.carpark.WanNetHostSelector;
import com.wovoe.carpark.cloud.CarparkCloudConnection;
import com.wovoe.carpark.cloud.CarparkUploadPicOssConfig;
import com.wovoe.carpark.cloud.CloudResultResponse;
import com.wovoe.carpark.cloud.OssTool;
import com.wovoe.carpark.cloud.SyncRecord;
import com.wovoe.carpark.cloud.client.CarparkHostSyncRemoteService;
import com.wovoe.carpark.cloud.client.HostSate;
import com.wovoe.carpark.cloud.cos.COSConfig;
import com.wovoe.carpark.cloud.cos.COSTool;
import com.wovoe.carpark.conn.udp.CarparkUdpClient;
import com.wovoe.carpark.conn.udp.CarparkUdpClientManager;
import com.wovoe.carpark.conn.udp.CarparkUdpConnSession;
import com.wovoe.carpark.conn.udp.CarparkUdpP2pConnection;
import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkInvoiceOrder;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.service.TransferDataService;
import com.wovoe.carpark.service.remote.CommonRemoteService;
import com.wovoe.carpark.vo.SyncDBRecord;
import com.wovoe.carpark.vo.SyncDBRecordResult;
import com.wovoe.carpark.vo.UploadPicToken;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.Service;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RemoteConnection;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.http.HttpResponse;
import com.wovoe.framework.http.HttpUtil;
import com.wovoe.framework.transfer.ResultResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Service
public class TransferDataServiceImpl
implements TransferDataService {
    private static final String ck_carpark_regplate_record = "ck_carpark_regplate_record";

    @Override
    public boolean sendDbRecordById(String hostNo, String jsonParam) {
        if (ServiceUtil.getServiceContext().getLocalHostNo().equals(hostNo)) {
            return true;
        }
        if (!ServiceUtil.getServiceContext().isConected(hostNo)) {
            return false;
        }
        Gson gosn = GsonBuilder.create();
        Map paramMap = (Map)gosn.fromJson(jsonParam, HashMap.class);
        String tableName = (String)paramMap.get("tableName");
        if (tableName == null || tableName.length() == 0) {
            throw new RuntimeException("tableName is NUll! jsonParam:" + jsonParam);
        }
        String id = paramMap.get("id").toString();
        SearchParam p = new SearchParam(tableName);
        p.setWhereString("AND id=" + id);
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Map recordData = commonDaoService.selectOne(p);
        if (recordData == null) {
            return true;
        }
        return this.sendDbRecordData0(hostNo, tableName, recordData);
    }

    public boolean sendDbRecordData(String hostNo, Object poRecord) {
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        String tableName = commonDaoService.getTableName(poRecord.getClass());
        if (tableName == null || tableName.length() == 0) {
            throw new RuntimeException("\u6620\u5c04\u5bf9\u8c61\u6ca1\u6709\u4f7f\u7528Table\u6ce8\u89e3");
        }
        return this.sendDbRecordData0(hostNo, tableName, poRecord);
    }

    private boolean sendDbRecordData0(String hostNo, String tableName, Object record) {
        Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        CarparkHost host = hostMap.get(hostNo);
        if (host == null) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u5411\u4e3b\u673a" + hostNo + "\u53d1\u9001\u6570\u636e\uff0c\u4e3b\u673a\u4e0d\u5b58\u5728\uff01\u8fd9\u5c06\u4e22\u5f03\u8868" + tableName + "\u8bb0\u5f55"));
            return true;
        }
        RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(hostNo, true);
        if (rpc == null) {
            return false;
        }
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1 && host.getHost_type() == 2) {
            return this.sendDbRecordDataToCloud(rpc, tableName, record);
        }
        CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
        SyncDBRecord datarecord = new SyncDBRecord();
        datarecord.setTableName(tableName);
        Gson gosn = GsonBuilder.create();
        datarecord.setJsonRecord(gosn.toJson(record));
        SyncDBRecordResult result = rpcService.synDBRecord(datarecord, null);
        if (result == null) {
            return false;
        }
        if (result.getReturnCode() == null) {
            return false;
        }
        return result.getReturnCode() == 0;
    }

    private boolean sendDbRecordDataToCloud(RpcReomtecServiceFactory rpc, String tableName, Object record) {
        CloudResultResponse resultResponse;
        block9: {
            Object returnCode;
            block8: {
                block7: {
                    if (ck_carpark_regplate_record.equals(tableName)) {
                        return true;
                    }
                    SyncRecord syncRecord = new SyncRecord();
                    syncRecord.setOpType("I");
                    syncRecord.setOpTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    syncRecord.setRecord(GsonBuilder.create().toJson(record));
                    syncRecord.setTableName(tableName);
                    CarparkHostSyncRemoteService carparkHostSyncRemoteService = rpc.crateRemoteService(CarparkHostSyncRemoteService.class);
                    if (carparkHostSyncRemoteService == null) {
                        return false;
                    }
                    try {
                        resultResponse = carparkHostSyncRemoteService.uploadRecord(syncRecord);
                        if (resultResponse.isSuccess()) break block7;
                        ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u4e91\u7aef" + tableName + "\uff0c\u8bb0\u5f55\u5931\u8d25\uff01\u539f\u56e0\uff1a" + resultResponse.getResponseMsg()));
                        return false;
                    }
                    catch (Throwable ex) {
                        Throwable ex1 = ServiceUtil.getRPCInvokeException(ex);
                        ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u4e91\u7aef" + tableName + "\uff0c\u8bb0\u5f55\u5931\u8d25\uff01\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38\uff01" + ex1.getMessage()));
                        return false;
                    }
                }
                returnCode = resultResponse.get("returnCode");
                if (returnCode != null) break block8;
                ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u4e91\u7aef" + tableName + "\uff0c\u8bb0\u5f55\u5931\u8d25\uff01\u539f\u56e0\uff1a\u7f3a\u5c11returnCode"));
                return false;
            }
            String rCode = returnCode instanceof Number ? String.valueOf(((Number)returnCode).intValue()) : returnCode.toString();
            if (!"0".equals(rCode) && !"SUCCESS".equals(rCode)) break block9;
            return true;
        }
        ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u4e91\u7aef" + tableName + "\uff0c\u8bb0\u5f55\u5931\u8d25\uff01\u539f\u56e0\uff1a" + resultResponse.get("returnMsg")));
        return false;
    }

    public boolean sendModifyPresenceCarTypeToCloud(RpcReomtecServiceFactory rpc, String jsonParam) {
        CarparkHostSyncRemoteService carparkHostSyncRemoteService = rpc.crateRemoteService(CarparkHostSyncRemoteService.class);
        if (carparkHostSyncRemoteService == null) {
            return false;
        }
        try {
            Gson gosn = GsonBuilder.create();
            Map paramMap = (Map)gosn.fromJson(jsonParam, HashMap.class);
            CloudResultResponse resultResponse = carparkHostSyncRemoteService.modifyPreCarType(paramMap);
            if (!resultResponse.isSuccess()) {
                ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u4e91\u7aef\u4fee\u6539\u8f66\u578b\u5931\u8d25\uff01\u539f\u56e0\uff1a" + resultResponse.getResponseMsg()));
                return false;
            }
            return true;
        }
        catch (Throwable ex) {
            Throwable ex1 = ServiceUtil.getRPCInvokeException(ex);
            ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u4e91\u7aef\u4fee\u6539\u8f66\u578b\u5931\u8d25\uff01\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38\uff01" + ex1.getMessage()));
            return false;
        }
    }

    @Override
    public boolean sendLanLocalPic(String hostNo, String jsonParam) {
        String result;
        block12: {
            if (ServiceUtil.getServiceContext().getLocalHostNo().equals(hostNo)) {
                return true;
            }
            if (!ServiceUtil.getServiceContext().isConected(hostNo)) {
                return false;
            }
            CarparkHost remoteHost = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(hostNo);
            if (remoteHost == null) {
                return false;
            }
            Gson gosn = GsonBuilder.create();
            Map paramMap = (Map)gosn.fromJson(jsonParam, HashMap.class);
            String path = (String)paramMap.get("path");
            if (path == null || path.length() == 0) {
                ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u56fe\u7247\u9519\u8bef\uff0c\u7f3a\u5c11\u53c2\u6570:path,param:" + jsonParam + ",hostNo:" + hostNo));
                return true;
            }
            RecordSaveService r = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            File localFile = new File(path);
            if (localFile.exists() && localFile.isFile()) {
                path = r.getDbPicPath(path);
            } else {
                localFile = new File(r.getLocalPicPath(path));
                if (!localFile.exists() || !localFile.isFile()) {
                    return true;
                }
            }
            long maxLen = 0x500000L;
            long fileLen = localFile.length();
            if (fileLen > maxLen) {
                ServiceLog.getLog().warn((Object)("\u56fe\u7247\u8fc7\u5927\uff1a\u65e0\u6cd5\u4e0a\u4f20\uff0c\u4e22\u5f03\uff01" + localFile.getAbsolutePath()));
                return true;
            }
            String sendPath = "http://" + remoteHost.getHost_ip();
            if (remoteHost.getHost_port() != null && remoteHost.getHost_port() != 80) {
                sendPath = String.valueOf(sendPath) + ":" + remoteHost.getHost_port();
            }
            sendPath = String.valueOf(sendPath) + "/uploadlocalpic.action?upToken=" + UploadPicToken.createUploadPicToken(path);
            HashMap<String, String> fileMap = new HashMap<String, String>();
            fileMap.put("pic", localFile.getAbsolutePath());
            result = HttpUtil.uploadFile((String)sendPath, null, null, fileMap, (int)6000, (int)10000);
            if (!"upload:true".equals(result)) break block12;
            return true;
        }
        try {
            ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff01\u8fd4\u56de\uff1a" + result));
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38!", (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean sendModifyPassPlate(String hostNo, String jsonParam) {
        ResultResponse response;
        block7: {
            if (ServiceUtil.getServiceContext().getLocalHostNo().equals(hostNo)) {
                return true;
            }
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                return true;
            }
            if (!ServiceUtil.getServiceContext().isConected(hostNo)) {
                return false;
            }
            RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(hostNo, true);
            if (rpc == null) {
                return false;
            }
            Gson gosn = GsonBuilder.create();
            Map paramMap = (Map)gosn.fromJson(jsonParam, HashMap.class);
            CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
            response = rpcService.handleModifyPassPlate(paramMap, null);
            if (!"0".equals(response.getResponseCode())) break block7;
            return true;
        }
        try {
            ServiceLog.getLog().warn((Object)("\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u9519\u8bef\uff1a" + response.getResponseMsg()));
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u5f02\u5e38!", (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean sendFormalOperation(String hostNo, String jsonParam) {
        ResultResponse response;
        block7: {
            if (ServiceUtil.getServiceContext().getLocalHostNo().equals(hostNo)) {
                return true;
            }
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                return true;
            }
            if (!ServiceUtil.getServiceContext().isConected(hostNo)) {
                return false;
            }
            RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(hostNo, true);
            if (rpc == null) {
                return false;
            }
            Gson gosn = GsonBuilder.create();
            Map paramMap = (Map)gosn.fromJson(jsonParam, HashMap.class);
            CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
            response = rpcService.handleFormalOperation(paramMap, null);
            if (!"0".equals(response.getResponseCode())) break block7;
            return true;
        }
        try {
            ServiceLog.getLog().warn((Object)("\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u9519\u8bef\uff1a" + response.getResponseMsg()));
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u5f02\u5e38!", (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean sendModifyPresenceCarType(String hostNo, String jsonParam) {
        ResultResponse response;
        block7: {
            Map<String, CarparkHost> hostMap;
            CarparkHost host;
            if (ServiceUtil.getServiceContext().getLocalHostNo().equals(hostNo)) {
                return true;
            }
            RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(hostNo, true);
            if (rpc == null) {
                return false;
            }
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1 && (host = (hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap()).get(hostNo)).getHost_type() == 2) {
                return this.sendModifyPresenceCarTypeToCloud(rpc, jsonParam);
            }
            if (!ServiceUtil.getServiceContext().isConected(hostNo)) {
                return false;
            }
            Gson gosn = GsonBuilder.create();
            Map paramMap = (Map)gosn.fromJson(jsonParam, HashMap.class);
            CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
            response = rpcService.handleModifyPresenceCarType(paramMap, null);
            if (!"0".equals(response.getResponseCode())) break block7;
            return true;
        }
        try {
            ServiceLog.getLog().warn((Object)("\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u9519\u8bef\uff1a" + response.getResponseMsg()));
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u5f02\u5e38!", (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean sendRemoveCarparkPresenceRecord(String hostNo, String jsonParam) {
        ResultResponse response;
        block7: {
            if (ServiceUtil.getServiceContext().getLocalHostNo().equals(hostNo)) {
                return true;
            }
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                return true;
            }
            if (!ServiceUtil.getServiceContext().isConected(hostNo)) {
                return false;
            }
            RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(hostNo, true);
            if (rpc == null) {
                return false;
            }
            Gson gosn = GsonBuilder.create();
            Map paramMap = (Map)gosn.fromJson(jsonParam, HashMap.class);
            CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
            response = rpcService.handleRemoveCarparkPresenceRecord(paramMap, null);
            if (!"0".equals(response.getResponseCode())) break block7;
            return true;
        }
        try {
            ServiceLog.getLog().warn((Object)("\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u9519\u8bef\uff1a" + response.getResponseMsg()));
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u5f02\u5e38!", (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean invoiceSuccess(String hostNo, String jsonParam) {
        ResultResponse response;
        block7: {
            if (ServiceUtil.getServiceContext().getLocalHostNo().equals(hostNo)) {
                return true;
            }
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                return true;
            }
            if (!ServiceUtil.getServiceContext().isConected(hostNo)) {
                return false;
            }
            RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(hostNo, true);
            if (rpc == null) {
                return false;
            }
            Gson gosn = GsonBuilder.create();
            CarparkInvoiceOrder invoiceOrder = (CarparkInvoiceOrder)gosn.fromJson(jsonParam, CarparkInvoiceOrder.class);
            CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
            response = rpcService.invoiceSuccess(invoiceOrder, null);
            if (!"0".equals(response.getResponseCode())) break block7;
            return true;
        }
        try {
            ServiceLog.getLog().warn((Object)("\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u9519\u8bef\uff1a" + response.getResponseMsg()));
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u5f02\u5e38!", (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean invoiceOfflineSuccess(String hostNo, String jsonParam) {
        ResultResponse response;
        block7: {
            if (ServiceUtil.getServiceContext().getLocalHostNo().equals(hostNo)) {
                return true;
            }
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                return true;
            }
            if (!ServiceUtil.getServiceContext().isConected(hostNo)) {
                return false;
            }
            RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(hostNo, true);
            if (rpc == null) {
                return false;
            }
            Gson gosn = GsonBuilder.create();
            Map paramMap = (Map)gosn.fromJson(jsonParam, new TypeToken<Map<String, String>>(){}.getType());
            CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
            response = rpcService.invoiceOfflineSuccess(paramMap, null);
            if (!"0".equals(response.getResponseCode())) break block7;
            return true;
        }
        try {
            ServiceLog.getLog().warn((Object)("\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u9519\u8bef\uff1a" + response.getResponseMsg()));
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u5f02\u5e38!", (Throwable)ex);
        }
        return false;
    }

    private boolean sendLocalPicToLan(String jsonParam, HostSate state) {
        String result;
        block9: {
            Map paramMap = (Map)GsonBuilder.create().fromJson(jsonParam, HashMap.class);
            String path = (String)paramMap.get("path");
            if (path == null || path.length() == 0) {
                ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u56fe\u7247\u9519\u8bef\uff0c\u7f3a\u5c11\u53c2\u6570:path,param:" + jsonParam));
                return true;
            }
            RecordSaveService r = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            File localFile = new File(path);
            if (localFile.exists() && localFile.isFile()) {
                path = r.getDbPicPath(path);
            } else {
                localFile = new File(r.getLocalPicPath(path));
                if (!localFile.exists() || !localFile.isFile()) {
                    ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u56fe\u7247\u9519\u8bef\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728:" + path));
                    return true;
                }
            }
            long maxLen = 0x500000L;
            long fileLen = localFile.length();
            if (fileLen > maxLen) {
                ServiceLog.getLog().warn((Object)("\u56fe\u7247\u8fc7\u5927\uff1a\u65e0\u6cd5\u4e0a\u4f20\uff0c\u4e22\u5f03\uff01" + localFile.getAbsolutePath()));
                return true;
            }
            String sendPath = "http://" + state.getLanSocketAddress().getAddress().getHostAddress();
            if (state.getHttpPort() != 80) {
                sendPath = String.valueOf(sendPath) + ":" + state.getHttpPort();
            }
            sendPath = String.valueOf(sendPath) + "/uploadlocalpic.action?upToken=" + UploadPicToken.createUploadPicToken(path);
            HashMap<String, String> fileMap = new HashMap<String, String>();
            fileMap.put("pic", localFile.getAbsolutePath());
            result = HttpUtil.uploadFile((String)sendPath, null, null, fileMap, (int)6000, (int)10000);
            if (!"upload:true".equals(result)) break block9;
            return true;
        }
        try {
            ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff01\u8fd4\u56de\uff1a" + result));
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38!", (Throwable)ex);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean sendLocalPicToCloud(String jsonParam) {
        KeyValueEntry<Integer, String> uploadEntry;
        File outputFile;
        boolean success;
        int height;
        int width;
        Map paramMap = (Map)GsonBuilder.create().fromJson(jsonParam, HashMap.class);
        String path = (String)paramMap.get("path");
        if (path == null || path.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u56fe\u7247\u9519\u8bef\uff0c\u7f3a\u5c11\u53c2\u6570:path,param:" + jsonParam));
            return true;
        }
        CarparkCloudConnection connection = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection();
        if (!connection.isConnected()) {
            return false;
        }
        RecordSaveService r = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        File localFile = new File(path);
        if (localFile.exists() && localFile.isFile()) {
            path = r.getDbPicPath(path);
        } else {
            localFile = new File(r.getLocalPicPath(path));
            if (!localFile.exists() || !localFile.isFile()) {
                ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u56fe\u7247\u9519\u8bef\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728:" + path));
                return true;
            }
        }
        long maxLen = 0x500000L;
        long fileLen = localFile.length();
        if (fileLen > maxLen) {
            ServiceLog.getLog().warn((Object)("\u56fe\u7247\u8fc7\u5927\uff1a\u65e0\u6cd5\u4e0a\u4f20\uff0c\u4e22\u5f03\uff01" + localFile.getAbsolutePath()));
            return true;
        }
        if (path.indexOf("plateSmall_") != -1) {
            width = 105;
            height = 35;
        } else {
            width = 800;
            height = 450;
        }
        if (connection.getUploadPicMethod() == 1 || connection.getUploadPicMethod() == 3) {
            KeyValueEntry<HttpResponse, byte[]> kv;
            String serverPicPath;
            block37: {
                String key;
                String proc;
                String baicPath;
                CarparkUploadPicOssConfig ossConfig = null;
                COSConfig cosConfig = null;
                if (connection.getUploadPicMethod() == 1) {
                    ossConfig = connection.getCarparkUploadPicOssConfig();
                    if (ossConfig == null || ossConfig.getDomain() == null || ossConfig.getDomain().length() <= 0 || ossConfig.getAccessKeyId() == null || ossConfig.getAccessKeyId().length() <= 0 || ossConfig.getAccessKeySecret() == null || ossConfig.getAccessKeySecret().length() <= 0 || ossConfig.getBucket() == null || ossConfig.getBucket().length() <= 0) return true;
                    baicPath = ossConfig.getBasicPath();
                    proc = "oss://" + ossConfig.getBucket();
                } else {
                    cosConfig = connection.getCarparkUploadPicCosConfig();
                    if (cosConfig == null || cosConfig.getSecretId() == null || cosConfig.getSecretId().length() <= 0 || cosConfig.getSeretKey() == null || cosConfig.getSeretKey().length() <= 0 || cosConfig.getBucket() == null || cosConfig.getBucket().length() <= 0 || cosConfig.getRegion() == null || cosConfig.getRegion().length() <= 0) return true;
                    baicPath = cosConfig.getBasicPath();
                    proc = "cos://" + cosConfig.getBucket();
                }
                if (baicPath == null) {
                    baicPath = "";
                }
                if ((key = baicPath.length() > 0 && !baicPath.endsWith("/") ? String.valueOf(baicPath) + "/" + path : String.valueOf(baicPath) + path).startsWith("/")) {
                    key = key.substring(1);
                }
                serverPicPath = String.valueOf(proc) + "/" + key;
                byte[] data = ServiceUtil.compressPic(localFile, width, height, 0.7f);
                if (data == null || data.length == 0) {
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        try (FileInputStream in = new FileInputStream(localFile);){
                            int len;
                            byte[] bf = new byte[1024];
                            while ((len = in.read(bf)) != -1) {
                                out.write(bf, 0, len);
                            }
                        }
                        data = out.toByteArray();
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().error((Object)("\u52a0\u8f7d\u672c\u5730\u6587\u4ef6\u5f02\u5e38! " + ex + ", \u8def\u5f84: " + localFile.getAbsolutePath()));
                    }
                }
                if (data == null || data.length == 0) {
                    return true;
                }
                if (connection.getUploadPicMethod() == 1) {
                    try {
                        OssTool.put("http://" + ossConfig.getDomain(), ossConfig.getAccessKeyId(), ossConfig.getAccessKeySecret(), ossConfig.getBucket(), key, data);
                        return true;
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().error((Object)("\u4e0a\u4f20\u56fe\u7247\u5931\u8d25\uff01 " + ex + ", oss path: " + serverPicPath));
                        return false;
                    }
                }
                try {
                    String uploadPicDomain = cosConfig.getDomain();
                    if (uploadPicDomain == null || uploadPicDomain.length() == 0) {
                        uploadPicDomain = cosConfig.generateDomain();
                    }
                    Proxy proxy = WanNetHostSelector.getWanProxyHost(uploadPicDomain).getProxy();
                    HttpUtil.InputStreamFileEntry entry = new HttpUtil.InputStreamFileEntry("file", localFile.getName(), (InputStream)new ByteArrayInputStream(data));
                    kv = COSTool.postFile(cosConfig, false, key, (HttpUtil.FileEntry)entry, 10000, 20000, proxy);
                    if (!COSTool.isPostFileSuccess(kv)) break block37;
                    return true;
                }
                catch (Exception ex) {
                    ServiceLog.getLog().error((Object)("\u4e0a\u4f20\u56fe\u7247\u5931\u8d25\uff01 " + ex + "! cos path: " + serverPicPath));
                    return false;
                }
            }
            if (kv != null && kv.getKey() != null) {
                ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u56fe\u7247\u5f02\u5e38! cos path: " + serverPicPath + ", \u539f\u56e0: " + ((HttpResponse)kv.getKey()).getResponseCode() + ": " + ((HttpResponse)kv.getKey()).getResponseMessage()));
                return false;
            } else {
                ServiceLog.getLog().warn((Object)"\u4e0a\u4f20\u56fe\u7247\u5931\u8d25! \u672a\u77e5\u54cd\u5e94\u7ed3\u679c null");
            }
            return false;
        }
        if (connection.getUploadPicMethod() != 2) return true;
        File outputDir = new File(PathFinder.findLocalDir(), "uploadPics");
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if (success = ServiceUtil.compressPic(localFile, outputFile = new File(outputDir, String.valueOf(ServiceUtil.getServiceContext().currentTimeMillis()) + ".jpg"), width, height, 0.7f)) {
            try {
                uploadEntry = connection.uploadPic(path, outputFile.getAbsolutePath());
            }
            finally {
                outputFile.delete();
            }
        } else {
            uploadEntry = connection.uploadPic(path, localFile.getAbsolutePath());
        }
        if ((Integer)uploadEntry.getKey() == 0) return true;
        ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u56fe\u7247" + path + "\u5230\u4e91\u7aef\u5931\u8d25\uff01\u539f\u56e0\uff1a" + (String)uploadEntry.getValue()));
        return false;
    }

    @Override
    public boolean sendLocalPic(String hostNo, String jsonParam) {
        String localHostNo = ServiceUtil.getServiceContext().getLocalHostNo();
        if (localHostNo.equals(hostNo)) {
            return true;
        }
        CarparkHost invkehost = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(hostNo);
        if (invkehost == null) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u5411\u5c40\u57df\u7f51\u4e3b\u673a" + hostNo + "\u53d1\u9001\u6570\u636e\uff0c\u4e3b\u673a\u4e0d\u5b58\u5728\uff01\u8fd9\u5c06\u653e\u5f03\u4e0a\u4f20\u56fe\u7247\uff1a" + jsonParam));
            return true;
        }
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config.getCarpark_deploy_type() == 1) {
            if (invkehost.getHost_type() == 2) {
                if (!ServiceUtil.getServiceContext().isConected(hostNo)) {
                    return false;
                }
                return this.sendLocalPicToCloud(jsonParam);
            }
            if (invkehost.getHost_type() == 1) {
                HostSate state = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanHostSate(hostNo);
                if (state.getHttpPort() > 0 && state.getHttpPort() < 65535) {
                    return this.sendLocalPicToLan(jsonParam, state);
                }
                return false;
            }
            return true;
        }
        if (config.getHost_use() == 1) {
            if (config.getNet_mode() == 2) {
                if (invkehost.getHost_use() == 1) {
                    return true;
                }
                CarparkUdpP2pConnection conn = ServiceUtil.getServiceContext().getCarparkUdpP2pConnection();
                if (conn == null) {
                    return false;
                }
                CarparkUdpConnSession session = conn.getConnectedServerSession();
                if (session == null) {
                    return false;
                }
                if (!session.getCarparkSeverHostNo().equals(hostNo)) {
                    return false;
                }
                return this.sendWanPic(localHostNo, session.getCarparkSignKey(), hostNo, session.getCarparkServerAddress(), jsonParam, session.isUseCloudProxy(), session.getCloudSocketAddress(), session.getProxyToken());
            }
            if (invkehost.getHost_use() == 1) {
                if (invkehost.getNet_mode() == 2) {
                    return true;
                }
                return this.sendLanLocalPic(hostNo, jsonParam);
            }
            return this.sendLanLocalPic(hostNo, jsonParam);
        }
        if (invkehost.getHost_use() != 1) {
            return true;
        }
        if (invkehost.getNet_mode() == 2) {
            CarparkUdpClient client = CarparkUdpClientManager.getInstance().getCarparkUdpClient(hostNo);
            if (client == null) {
                return false;
            }
            if (!client.isConnected()) {
                return false;
            }
            InetSocketAddress clientAddress = client.getClientAddress();
            if (clientAddress == null) {
                return false;
            }
            return this.sendWanPic(localHostNo, ServiceUtil.getServiceContext().getCarpark().getLan_sign_key(), hostNo, clientAddress, jsonParam, client.isUseCloudProxy(), client.getCloudSocketAddress(), client.getProxyToken());
        }
        return this.sendLanLocalPic(hostNo, jsonParam);
    }

    private boolean sendWanPic(String srcHostNo, String signKey, String detHostNo, InetSocketAddress remoteAddress, String jsonParam, boolean useCloudProxy, InetSocketAddress cloudProxySocketAddress, byte[] proxyToken) {
        Gson gosn = GsonBuilder.create();
        Map paramMap = (Map)gosn.fromJson(jsonParam, HashMap.class);
        String path = (String)paramMap.get("path");
        if (path == null || path.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u4e0a\u4f20\u56fe\u7247\u9519\u8bef\uff0c\u7f3a\u5c11\u53c2\u6570:path,param:" + jsonParam + ",hostNo:" + detHostNo));
            return true;
        }
        RecordSaveService r = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        File localFile = new File(path);
        if (localFile.exists() && localFile.isFile()) {
            path = r.getDbPicPath(path);
        } else {
            localFile = new File(r.getLocalPicPath(path));
            if (!localFile.exists() || !localFile.isFile()) {
                return true;
            }
        }
        long maxLen = 0x500000L;
        long fileLen = localFile.length();
        if (fileLen > maxLen) {
            ServiceLog.getLog().warn((Object)("\u56fe\u7247\u8fc7\u5927\uff1a\u65e0\u6cd5\u4e0a\u4f20\uff0c\u4e22\u5f03\uff01" + localFile.getAbsolutePath()));
            return true;
        }
        if (fileLen == 0L) {
            return true;
        }
        try {
            RemoteConnection conn = ServiceUtil.getServiceContext().getCarparkUdpConnectionFactory().createUdpConnection(remoteAddress);
            RequestSender sender = conn.createRequest();
            if (useCloudProxy) {
                if (cloudProxySocketAddress != null && proxyToken != null && proxyToken.length > 0) {
                    sender.setAttribute("USE_CLOUD_PROXY_ENTRY", (Object)new KeyValueEntry((Object)cloudProxySocketAddress, (Object)proxyToken));
                } else {
                    sender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
                }
            } else {
                sender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
            }
            sender.setRequestActionName("/CarparkUploadPicAction");
            sender.setHeader("srcHostNo", srcHostNo);
            sender.setHeader("destHostNo", detHostNo);
            sender.setHeader("tmills", String.valueOf(System.currentTimeMillis()));
            sender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            sender.setHeader("path", path);
            FileInputStream in = new FileInputStream(localFile);
            ByteArrayOutputStream out = new ByteArrayOutputStream((int)localFile.length());
            try {
                int read;
                byte[] buff = new byte[8196];
                while ((read = in.read(buff)) != -1) {
                    out.write(buff, 0, read);
                }
            }
            finally {
                in.close();
            }
            byte[] sendData = out.toByteArray();
            sender.setSendData(sendData);
            sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)signKey));
            long timeOutMills = 15000L;
            final OperationFutureHandler rh = ServiceUtil.getServiceContext().createOperationFuture();
            sender.doRequest(new SendCallback(){

                public void onException(Throwable ex) {
                    rh.setException(ex);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    rh.setException((Throwable)new TimeoutException("\u53d1\u9001\u56fe\u7247\u54cd\u5e94\u8d85\u65f6"));
                }

                public long getWaitTimeoutMills() {
                    return 15000L;
                }

                public void doReceiver(Receiver r, int id) throws Exception {
                    rh.setResult((Object)r);
                }
            });
            Receiver rev = (Receiver)rh.get(16000L, TimeUnit.MILLISECONDS);
            if (rev == null) {
                throw new TimeoutException("\u53d1\u9001\u56fe\u7247\u54cd\u5e94\u8d85\u65f6");
            }
            String repCode = rev.getHeaderValue("respCode");
            if (!"SUCCESS".equals(repCode)) {
                String msg = rev.getHeaderValue("respMsg");
                if (msg == null) {
                    msg = "\u9519\u8bef\uff1a" + repCode;
                }
                throw new IOException(msg);
            }
            String sign = rev.getHeaderValue("sign");
            String checkSign = HMPNetDataSignTool.getSign((Receiver)rev, (String)signKey);
            if (!checkSign.equals(sign)) {
                throw new IOException("\u6570\u636e\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
            }
            return true;
        }
        catch (Throwable ex) {
            Throwable t;
            if (ex instanceof ExecutionException && (t = ((ExecutionException)ex).getCause()) != null) {
                ex = t;
            }
            ServiceLog.getLog().warn((Object)("\u53d1\u9001\u56fe\u7247\u5f02\u5e38\uff1a" + ex.getMessage()));
            return false;
        }
    }

    @Override
    public boolean proxyDispath(String hostNo, String jsonParam) {
        Map<String, Object> responseMap;
        block18: {
            RpcReomtecServiceFactory rpc;
            HashMap<String, Object> requestMap;
            block17: {
                LinkedList<CarparkDispatchTask> dtaskList;
                block16: {
                    String json_data;
                    String serviceName;
                    Map paramMap;
                    block15: {
                        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
                        if (config.getHost_use() != 1) {
                            ServiceLog.getLog().warn((Object)("\u8b66\u544a\uff1a\u51fa\u73b0\u4e00\u4e2a\u975e\u5ba2\u6237\u7aef\u4ee3\u7406\u8c03\u5ea6\uff0c\u65e0\u6cd5\u5904\u7406\u7684\u6570\u636e\uff1a\u4e3b\u673a\uff1a" + hostNo + ":" + jsonParam));
                            return true;
                        }
                        if (config.getCarpark_deploy_type() == 1) {
                            return true;
                        }
                        if (!ServiceUtil.getServiceContext().isConected(hostNo)) {
                            return false;
                        }
                        Gson gosn = GsonBuilder.create();
                        paramMap = (Map)gosn.fromJson(jsonParam, new TypeToken<Map<String, String>>(){}.getType());
                        serviceName = (String)paramMap.get("serviceName");
                        json_data = (String)paramMap.get("json_data");
                        if (serviceName == null || serviceName.length() == 0) {
                            ServiceLog.getLog().warn((Object)("\u8b66\u544a\uff1a\u6570\u636e\u7f3a\u5c11serviceName\uff0c\u65e0\u6cd5\u5904\u7406\u7684\u6570\u636e\uff1a\u4e3b\u673a\uff1a" + hostNo + ":" + jsonParam));
                            return true;
                        }
                        if (serviceName.equals("transferDataService.proxyDispath")) {
                            ServiceLog.getLog().warn((Object)("\u8b66\u544a\uff1a\u51fa\u73b0\u4e00\u4e2a\u56de\u8c03\u9519\u8bef\uff0c\u65e0\u6cd5\u5904\u7406\u7684\u6570\u636e\uff1a\u4e3b\u673a\uff1a" + hostNo + ":" + jsonParam));
                            return true;
                        }
                        int h = serviceName.lastIndexOf(46);
                        String serviceName0 = serviceName.substring(0, h);
                        String methodName = serviceName.substring(h + 1);
                        Object obj = ServiceUtil.getServiceContext().getService(serviceName0);
                        if (obj == null) {
                            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u627e\u5230Service:" + serviceName + ",\u4ee3\u7406\u6267\u884c\u4efb\u52a1\u5931\u8d25!"));
                            return true;
                        }
                        Method method = obj.getClass().getMethod(methodName, String.class, String.class);
                        Boolean returnValue = (Boolean)method.invoke(obj, hostNo, json_data);
                        if (returnValue.booleanValue()) break block15;
                        return false;
                    }
                    try {
                        dtaskList = new LinkedList<CarparkDispatchTask>();
                        String dispathHosts = (String)paramMap.get("dispathHosts");
                        if (dispathHosts != null && dispathHosts.length() > 0) {
                            String[] dhs;
                            String[] stringArray = dhs = dispathHosts.split(",");
                            int n = dhs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String srr = stringArray[n2];
                                if ((srr = srr.trim()).length() != 0) {
                                    CarparkDispatchTask t = new CarparkDispatchTask();
                                    t.setHost_no(srr);
                                    t.setJson_data(json_data);
                                    t.setService_name(serviceName);
                                    dtaskList.add(t);
                                }
                                ++n2;
                            }
                        }
                        if (!dtaskList.isEmpty()) break block16;
                        return true;
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)("\u6267\u884c" + serviceName + "\u5f02\u5e38!,\u4e3b\u673a\uff1a" + hostNo + ", " + ex.getMessage()));
                        return false;
                    }
                }
                String taskListJon = GsonBuilder.create().toJson(dtaskList);
                requestMap = new HashMap<String, Object>();
                requestMap.put("dispatchTaskList", taskListJon);
                rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(hostNo, true);
                if (rpc != null) break block17;
                return false;
            }
            CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
            responseMap = rpcService.proxyExeDispathTask(requestMap, null);
            if (!"0".equals(responseMap.get("responseCode"))) break block18;
            return true;
        }
        ServiceLog.getLog().warn((Object)("\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u9519\u8bef\uff1a" + responseMap.get("responseMsg")));
        return false;
    }

    @Override
    public boolean sendCloudLocalPic(String hostNo, String jsonParam) {
        return true;
    }

    @Override
    public boolean syncLocalCartypeMer(String hostNo, String jsonParam) {
        Map<String, Object> response;
        block7: {
            if (ServiceUtil.getServiceContext().getLocalHostNo().equals(hostNo)) {
                return true;
            }
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                return true;
            }
            if (!ServiceUtil.getServiceContext().isConected(hostNo)) {
                return false;
            }
            RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(hostNo, true);
            if (rpc == null) {
                return false;
            }
            Gson gosn = GsonBuilder.create();
            Map tmap = (Map)gosn.fromJson(jsonParam, HashMap.class);
            CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
            response = rpcService.syncLocalCartypeMer(tmap, null);
            if (!"0".equals(response.get("responseCode"))) break block7;
            return true;
        }
        try {
            ServiceLog.getLog().warn((Object)("\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u9519\u8bef\uff1a" + response.get("responseMsg")));
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u5f02\u5e38!", (Throwable)ex);
        }
        return true;
    }

    @Override
    public boolean sendCloseEscapeOrder(String hostNo, String jsonParam) {
        ResultResponse response;
        block7: {
            if (ServiceUtil.getServiceContext().getLocalHostNo().equals(hostNo)) {
                return true;
            }
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
                return true;
            }
            if (!ServiceUtil.getServiceContext().isConected(hostNo)) {
                return false;
            }
            RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(hostNo, true);
            if (rpc == null) {
                return false;
            }
            Gson gosn = GsonBuilder.create();
            Map paramMap = (Map)gosn.fromJson(jsonParam, HashMap.class);
            CommonRemoteService rpcService = rpc.crateRemoteService(CommonRemoteService.class);
            response = rpcService.handleCloseEscapeOrder(paramMap, null);
            if (!"0".equals(response.getResponseCode())) break block7;
            return true;
        }
        try {
            ServiceLog.getLog().warn((Object)("\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u9519\u8bef\uff1a" + response.getResponseMsg()));
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u8c03\u7528\u8fdc\u7a0b\u65b9\u6cd5\u5f02\u5e38!", (Throwable)ex);
        }
        return false;
    }
}

