/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.service.impl.remote;

import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.action.MediaProfile;
import com.wovoe.carpark.equipment.onvif.OnvifMediaProfile;
import com.wovoe.carpark.equipment.onvif.RtspUriTool;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.p2p.media.CameraLivePushEntry;
import com.wovoe.carpark.p2p.media.CameraLivePusher;
import com.wovoe.carpark.p2p.media.rtsp.RtspConnection;
import com.wovoe.carpark.service.remote.CarparkCloudCameraPushHandler;
import com.wovoe.carpark.vo.ChannelEquipmentVo;
import com.wovoe.framework.JavaBeanTool;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.Service;
import com.wovoe.framework.transfer.ResultResponseMap;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;

@Service(value="carparkCloudCameraPushHandler")
public class CarparkCloudCameraPushHandlerImpl
implements CarparkCloudCameraPushHandler {
    @Override
    public OperationFuture<ResultResponseMap> cameraPushConnect(Map<String, String> paramMap, Map<String, Object> context) {
        MediaProfile mediaProfie;
        RtspConnection connection;
        ChannelEquipmentVo camera;
        String pushHostGroupName;
        String pushHostName = paramMap.get("pushHostName");
        String pushHostAppName = paramMap.get("pushHostAppName");
        if (pushHostAppName == null || pushHostAppName.length() == 0) {
            pushHostAppName = paramMap.get("pushHostGroup");
        }
        if ((pushHostGroupName = paramMap.get("pushHostGroupName")) == null || pushHostGroupName.length() == 0) {
            pushHostGroupName = pushHostAppName;
        }
        String cameraNo = paramMap.get("cameraNo");
        String connectId = paramMap.get("connectId");
        String hseq = paramMap.get("hseq");
        if (hseq == null || hseq.length() == 0) {
            hseq = "0";
        }
        String _pushStreamType = paramMap.get("pushStreamType");
        String _pushTransport = paramMap.get("pushTransport");
        String pushHostAddress = paramMap.get("pushHostAddress");
        String pushPort = paramMap.get("pushPort");
        String pushSignKey = paramMap.get("pushSignKey");
        final OperationFutureHandler handler = ServiceUtil.getServiceContext().createOperationFuture();
        if (pushHostName == null || pushHostName.length() == 0) {
            handler.setResult((Object)new ResultResponseMap("403", "\u7f3a\u5c11pushHostName"));
            return handler;
        }
        if (pushHostAppName == null || pushHostAppName.length() == 0) {
            handler.setResult((Object)new ResultResponseMap("403", "\u7f3a\u5c11pushHostGroup"));
            return handler;
        }
        if (cameraNo == null || cameraNo.length() == 0) {
            handler.setResult((Object)new ResultResponseMap("403", "\u7f3a\u5c11cameraNo"));
            return handler;
        }
        if (connectId == null || connectId.length() == 0) {
            handler.setResult((Object)new ResultResponseMap("403", "\u7f3a\u5c11connectId"));
            return handler;
        }
        InetSocketAddress connectServerAddress = null;
        if (pushHostAddress != null && pushHostAddress.length() > 0) {
            if (pushPort == null || pushPort.length() == 0) {
                handler.setResult((Object)new ResultResponseMap("403", "\u7f3a\u5c11pushPort"));
                return handler;
            }
            try {
                int port = Integer.parseInt(pushPort);
                if (port <= 0 || port > 65535) {
                    handler.setResult((Object)new ResultResponseMap("403", "pushPort \u9519\u8bef"));
                    return handler;
                }
                connectServerAddress = new InetSocketAddress(pushHostAddress, port);
            }
            catch (Exception ex) {
                handler.setResult((Object)new ResultResponseMap("403", "\u65e0\u6548\u7684pushHostAddress\u548cpushPort"));
                return handler;
            }
        }
        if (ServiceUtil.getServiceContext() == null || ServiceUtil.getServiceContext().getEquipmentManager() == null || ServiceUtil.getServiceContext().getStartFuture() == null || !ServiceUtil.getServiceContext().getStartFuture().isDone()) {
            handler.setResult((Object)new ResultResponseMap("403", "\u7cfb\u7edf\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff01"));
            return handler;
        }
        Equipment eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(cameraNo);
        if (eq != null) {
            if (eq.getType() != 33) {
                handler.setResult((Object)new ResultResponseMap("403", "\u76f8\u673a\u7f16\u53f7\u9519\u8bef\uff0c\u8bbe\u5907\u7c7b\u578b\u4e0d\u662f\u76f8\u673a"));
                return handler;
            }
            if (!eq.getEquipmentAction().isWorkingProperly()) {
                handler.setResult((Object)new ResultResponseMap("403", "\u65e0\u6cd5\u8fde\u63a5\u76f8\u673a\uff0c\u76f8\u673a\u5de5\u4f5c\u4e0d\u6b63\u5e38"));
                return handler;
            }
        }
        if ((camera = ServiceUtil.getServiceContext().getDBConfigCache().getChannelEquipmentVo(cameraNo)) == null) {
            handler.setResult((Object)new ResultResponseMap("403", "\u76f8\u673a\u7f16\u53f7\u9519\u8bef"));
            return handler;
        }
        if (camera.getEquipment_type() == null || camera.getEquipment_type() != 33) {
            handler.setResult((Object)new ResultResponseMap("403", "\u76f8\u673a\u7f16\u53f7\u9519\u8bef\uff0c\u8bbe\u5907\u7c7b\u578b\u4e0d\u662f\u76f8\u673a"));
            return handler;
        }
        if (camera.getOnvifPort() == null) {
            handler.setResult((Object)new ResultResponseMap("403", "\u76f8\u673a\u672a\u914d\u7f6e Onvif \u7aef\u53e3"));
            return handler;
        }
        if (camera.getEquipment_ip() == null || camera.getEquipment_ip().length() == 0) {
            handler.setResult((Object)new ResultResponseMap("403", "\u76f8\u673a\u672a\u914d\u7f6eIP"));
            return handler;
        }
        int streamType = 0;
        try {
            if (_pushStreamType != null && _pushStreamType.length() > 0) {
                streamType = Integer.parseInt(_pushStreamType);
            }
        }
        catch (Exception ex) {
            handler.setResult((Object)new ResultResponseMap("403", "\u65e0\u6548\u53c2\u6570 pushStreamType"));
            return handler;
        }
        int pushType = 0;
        if (_pushTransport != null && _pushTransport.length() > 0) {
            try {
                pushType = Integer.parseInt(_pushTransport);
            }
            catch (Exception ex) {
                handler.setResult((Object)new ResultResponseMap("403", "\u65e0\u6548\u53c2\u6570 _pushTransport"));
                return handler;
            }
        }
        final String pushHostName0 = pushHostName;
        final String pushHostAppName0 = pushHostAppName;
        final InetSocketAddress connectServerAddress0 = connectServerAddress;
        final String pushSignKey0 = pushSignKey;
        final String connectId0 = connectId;
        final int streamType0 = streamType;
        final int pushType0 = pushType;
        final String pushHostGroupName0 = pushHostGroupName;
        final String hseq0 = hseq;
        final String cameraNo0 = cameraNo;
        CameraLivePusher livePusher = ServiceUtil.getServiceContext().getCameraLivePushManager().getCameraLivePusher(cameraNo);
        if (livePusher != null && (connection = livePusher.getRtspConnection()) != null && (connection.isConnected() || connection.isStarted()) && (mediaProfie = connection.getMediaProfile()) != null && mediaProfie.getUri() != null && mediaProfie.getUri().length() > 0) {
            CameraLivePushEntry pushEntry = new CameraLivePushEntry(pushHostName0, pushHostAppName0, connectServerAddress0, pushSignKey0, connectId0, streamType0, pushType0, pushHostGroupName0, hseq0, cameraNo0, camera.getOnvifUserName(), camera.getOnvifUserPwd(), mediaProfie);
            ServiceUtil.getServiceContext().getCameraLivePushManager().doPush(pushEntry, (OperationFutureHandler<ResultResponseMap>)handler);
            return handler;
        }
        OperationFuture<List<OnvifMediaProfile>> operationFuture = RtspUriTool.getOnvifMediaProfileListUseShortCache(camera.getEquipment_ip(), camera.getOnvifPort(), camera.getOnvifUserName(), camera.getOnvifUserPwd());
        operationFuture.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<List<OnvifMediaProfile>>(){

            public void operationComplete(OperationFuture<List<OnvifMediaProfile>> future) {
                if (future.getException() != null) {
                    ServiceLog.getLog().error((Object)("\u65e0\u6cd5\u83b7\u53d6\u76f8\u673a\uff1a" + camera.getEquipment_ip() + " rtsp \u64ad\u653e\u8def\u5f84\uff01" + future.getException()));
                    handler.setResult((Object)new ResultResponseMap("601", "\u83b7\u53d6\u5a92\u4f53RTSP\u8def\u5f84\u5931\u8d25,\u7f51\u7edc\u5f02\u5e38"));
                } else if (future.isCancelled()) {
                    handler.setResult((Object)new ResultResponseMap("601", "\u83b7\u53d6\u5a92\u4f53RTSP\u8def\u5f84\u64cd\u4f5c\u88ab\u53d6\u6d88"));
                } else if (future.getResult() == null) {
                    handler.setResult((Object)new ResultResponseMap("601", "\u83b7\u53d6\u5a92\u4f53RTSP\u8def\u5f84\u5931\u8d25"));
                } else {
                    ArrayList<MediaProfile> mediaProfileList = null;
                    List list = (List)future.getResult();
                    if (list != null && !list.isEmpty()) {
                        ArrayList<MediaProfile> profiles = new ArrayList<MediaProfile>(list.size());
                        for (OnvifMediaProfile ov : list) {
                            if (ov.getUri() == null || ov.getUri().length() <= 0) continue;
                            MediaProfile profile = new MediaProfile();
                            JavaBeanTool.copyTo((Object)ov, (Object)profile);
                            if (ov.getVideo_Encoding() != null && ov.getVideo_Encoding().length() > 0) {
                                profile.setVideo_Encoding(ov.getVideo_Encoding().toUpperCase(Locale.US));
                            } else {
                                profile.setVideo_Encoding("");
                            }
                            if (ov.getVideo_Width() != null && ov.getVideo_Width().length() > 0) {
                                try {
                                    profile.setWidth((int)Double.parseDouble(ov.getVideo_Width()));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (ov.getVideo_Height() != null && ov.getVideo_Height().length() > 0) {
                                try {
                                    profile.setHeight((int)Double.parseDouble(ov.getVideo_Height()));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (profile.getWidth() <= 0) {
                                profile.setWidth(1);
                            }
                            if (profile.getHeight() <= 0) {
                                profile.setHeight(1);
                            }
                            profiles.add(profile);
                        }
                        if (!profiles.isEmpty()) {
                            mediaProfileList = profiles;
                        }
                    }
                    if (mediaProfileList == null || mediaProfileList.isEmpty()) {
                        handler.setResult((Object)new ResultResponseMap("601", "\u83b7\u53d6\u5a92\u4f53RTSP\u8def\u5f84\u5931\u8d25"));
                    } else {
                        MediaProfile mediaProfile = this.getInternetMediaProfile((List<MediaProfile>)mediaProfileList);
                        if (mediaProfile == null) {
                            handler.setResult((Object)new ResultResponseMap("601", "\u83b7\u53d6\u5a92\u4f53RTSP\u8def\u5f84\u5931\u8d25"));
                        } else {
                            ServiceLog.getLog().error((Object)("\u51c6\u5907\u8fde\u63a5\u76f8\u673a\u89c6\u9891: " + camera.getEquipment_name() + "\uff0c\u4f7f\u7528\u5730\u5740:" + mediaProfile.getUri()));
                            CameraLivePushEntry pushEntry = new CameraLivePushEntry(pushHostName0, pushHostAppName0, connectServerAddress0, pushSignKey0, connectId0, streamType0, pushType0, pushHostGroupName0, hseq0, cameraNo0, camera.getOnvifUserName(), camera.getOnvifUserPwd(), mediaProfile);
                            ServiceUtil.getServiceContext().getCameraLivePushManager().doPush(pushEntry, (OperationFutureHandler<ResultResponseMap>)handler);
                        }
                    }
                }
            }

            public void waitCompleteTimeout() {
                handler.setResult((Object)new ResultResponseMap("601", "\u83b7\u53d6\u5a92\u4f53RTSP\u8def\u5f84\u8d85\u65f6"));
            }

            public MediaProfile getInternetMediaProfile(List<MediaProfile> mediaProfiles) {
                if (mediaProfiles == null || mediaProfiles.isEmpty()) {
                    return null;
                }
                if (mediaProfiles.size() == 1) {
                    return mediaProfiles.get(0);
                }
                final boolean isMainStream = !"sub_stream".equals(camera.getInternetMediaStreamType());
                PriorityQueue<MediaProfile> profiles = new PriorityQueue<MediaProfile>(mediaProfiles.size(), new Comparator<MediaProfile>(){
                    private String rtsp = "rtsp://";
                    private String H264 = "H264";
                    private String H265 = "H265";

                    private int getEncodingOrder(String encoding) {
                        if (encoding == null || encoding.length() == 0) {
                            return 100;
                        }
                        if (this.H264.equalsIgnoreCase(encoding)) {
                            return 1;
                        }
                        if (this.H265.equalsIgnoreCase(encoding)) {
                            return 2;
                        }
                        return 99;
                    }

                    @Override
                    public int compare(MediaProfile o1, MediaProfile o2) {
                        int f2;
                        if (o1.getUri().startsWith(this.rtsp) && !o2.getUri().startsWith(this.rtsp)) {
                            return -1;
                        }
                        if (!o1.getUri().startsWith(this.rtsp) && o2.getUri().startsWith(this.rtsp)) {
                            return 1;
                        }
                        int a1 = Integer.compare(this.getEncodingOrder(o1.getVideo_Encoding()), this.getEncodingOrder(o2.getVideo_Encoding()));
                        if (a1 != 0) {
                            return a1;
                        }
                        int f1 = o1.getWidth() * o1.getHeight();
                        a1 = Integer.compare(f1, f2 = o2.getWidth() * o2.getHeight());
                        if (a1 != 0) {
                            if (isMainStream) {
                                return 0 - a1;
                            }
                            return a1;
                        }
                        int sub1 = o1.getUri().toLowerCase(Locale.US).indexOf("sub");
                        int sub2 = o2.getUri().toLowerCase(Locale.US).indexOf("sub");
                        if (sub1 != -1 && sub2 == -1) {
                            if (isMainStream) {
                                return 1;
                            }
                            return -1;
                        }
                        if (sub1 == -1 && sub2 != -1) {
                            if (isMainStream) {
                                return -1;
                            }
                            return 1;
                        }
                        return 0;
                    }
                });
                for (MediaProfile f : mediaProfiles) {
                    profiles.offer(f);
                }
                return profiles.poll();
            }
        }, 7L, TimeUnit.SECONDS);
        return handler;
    }
}

