/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.service.impl.remote;

import com.wovoe.carpark.cloud.CloudResultResponse;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.remote.CloudConnService;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.Service;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RemoteConnection;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Service(value="cloudConnService")
public class CloudConnServiceImpl
implements CloudConnService {
    @Override
    public Map<String, Object> udpP2pConnect(Map<String, Object> paramMap, Map<String, Object> context) throws Exception {
        int rhs;
        int cloudUdpPort;
        InetSocketAddress remoteClientAddress;
        String connectHostNo = (String)paramMap.get("connectHostNo");
        String connectToken = (String)paramMap.get("connectToken");
        String cloudServerPort = (String)paramMap.get("cloudServerPort");
        String clientPort = (String)paramMap.get("clientPort");
        String clientHostAddress = (String)paramMap.get("clientHostAddress");
        if (connectHostNo == null || connectHostNo.length() == 0) {
            return CloudResultResponse.createResponse("403", "\u7f3a\u5c11\u53c2\u6570connectHostNo");
        }
        if (connectToken == null || connectToken.length() == 0) {
            return CloudResultResponse.createResponse("403", "\u7f3a\u5c11\u53c2\u6570connectToken");
        }
        if (cloudServerPort == null || cloudServerPort.length() == 0) {
            return CloudResultResponse.createResponse("403", "\u7f3a\u5c11\u53c2\u6570cloudServerPort");
        }
        if (clientPort == null || clientPort.length() == 0) {
            return CloudResultResponse.createResponse("403", "\u7f3a\u5c11\u53c2\u6570clientPort");
        }
        if (clientHostAddress == null || clientHostAddress.length() == 0) {
            return CloudResultResponse.createResponse("403", "\u7f3a\u5c11\u53c2\u6570clientHostAddress");
        }
        try {
            remoteClientAddress = new InetSocketAddress(clientHostAddress, Integer.parseInt(clientPort));
        }
        catch (Exception ex) {
            return CloudResultResponse.createResponse("403", "\u9519\u8bef\u7684\u5ba2\u6237\u7aef\u670d\u52a1\u5668\u5730\u5740\uff1a" + clientHostAddress + ":" + clientPort);
        }
        try {
            cloudUdpPort = Integer.parseInt(cloudServerPort);
        }
        catch (Exception ex) {
            return CloudResultResponse.createResponse("403", "\u53c2\u6570cloudServerPort\u9519\u8bef\uff1a" + cloudServerPort);
        }
        Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        CarparkHost host = null;
        if (hostMap != null) {
            host = hostMap.get(connectHostNo);
        }
        if (host == null) {
            return CloudResultResponse.createResponse("403", "\u5c97\u4ead\u4e3b\u673a\u4e0d\u5b58\u5728\uff0c\u65e0\u6548\u4e3b\u673a\u7f16\u53f7/ID\uff0c\u62d2\u7edd\u8fde\u63a5");
        }
        if (host.getHost_use() != 1) {
            return CloudResultResponse.createResponse("403", "\u8be5\u4e3b\u673a\u914d\u7f6e\u7684\u4e0d\u662f\u5c97\u4ead\u5ba2\u6237\u7aef\uff0c\u62d2\u7edd\u8fde\u63a5");
        }
        if (host.getNet_mode() != 2) {
            return CloudResultResponse.createResponse("403", "\u8be5\u4e3b\u673a\u914d\u7f6e\u7684\u7f51\u7edc\u6a21\u5f0f\u4e0d\u662f\u5916\u7f51\u6a21\u5f0f\uff0c\u62d2\u7edd\u5916\u7f51\u8fde\u63a5");
        }
        String cloudHost = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().getConnectCloudDomin();
        if (cloudHost != null && cloudHost.length() > 0 && (rhs = cloudHost.indexOf(58)) != -1) {
            cloudHost = cloudHost.substring(0, rhs);
        }
        if (cloudHost == null || cloudHost.length() == 0) {
            return CloudResultResponse.createResponse("403", "\u4e0e\u670d\u52a1\u5668\u65ad\u5f00\u8fde\u63a5");
        }
        InetSocketAddress cloudSocketAddress = new InetSocketAddress(InetAddress.getByName(cloudHost), cloudUdpPort);
        RemoteConnection cloudUdpConn = ServiceUtil.getServiceContext().getCarparkUdpConnectionFactory().createUdpConnection(cloudSocketAddress);
        RequestSender rsender = cloudUdpConn.createRequest();
        rsender.setRequestActionName("/CloudCarpark_P2PUdpConnectAction");
        rsender.setHeader("op", "carparkServerConnectReuslt");
        rsender.setHeader("b", ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().getId());
        rsender.setHeader("r", RandomStringGenerator.getDefaultInstance().getNewString(32));
        rsender.setHeader("token", connectToken);
        rsender.setHeader("code", "ALLOW_CONNECT");
        rsender.setHeader("msg", "SUCCESS");
        rsender.setHeader("hostNo", connectHostNo);
        rsender.setHeader("transiss_chostNo", connectHostNo);
        rsender.setHeader("transiss_shostNo", ServiceUtil.getServiceContext().getLocalHostNo());
        rsender.setHeader("transiss_sk", ServiceUtil.getServiceContext().getCarpark().getLan_sign_key());
        String sSign = HMPNetDataSignTool.getSign((Receiver)rsender, (String)ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().getSignKey());
        rsender.setHeader("sign", sSign);
        rsender.setAttribute("CLOUD_ACTION_HANDLE", (Object)Boolean.TRUE);
        rsender.doRequest(new SendCallback(){

            public void onException(Throwable ex) {
                ServiceLog.getLog().warn((Object)("UDP\u8bf7\u6c42\u4e91\u7aef\u3010\u5141\u8bb8\u6b64\u5ba2\u6237\u7aef\u8fde\u63a5\u3011\u53d1\u9001\u5f02\u5e38\uff01" + ex.getMessage()));
            }

            public void onCompleted() {
            }
        }, new ReceiveCallback(){

            public void onWaitTimeout() throws Exception {
                ServiceLog.getLog().warn((Object)"UDP\u8bf7\u6c42\u4e91\u7aef\u3010\u5141\u8bb8\u6b64\u5ba2\u6237\u7aef\u8fde\u63a5\u3011\uff0c\u7b49\u5f85\u4e91\u7aef\u54cd\u5e94\u8d85\u65f6");
            }

            public long getWaitTimeoutMills() {
                return 8000L;
            }

            public void doReceiver(Receiver r, int id) throws Exception {
                String result = r.getHeaderValue("result");
                if (!"SUCCESS".equals(result)) {
                    ServiceLog.getLog().warn((Object)("UDP\u8bf7\u6c42\u4e91\u7aef\u3010\u5141\u8bb8\u6b64\u5ba2\u6237\u7aef\u8fde\u63a5\u3011\uff0c\u4e91\u7aef\u54cd\u5e94\uff1a" + result + ":" + r.getHeaderValue("msg") + ", \u8fd9\u53ef\u80fd\u5bfc\u81f4\u4e91\u7aef\u672a\u80fd\u901a\u77e5\u5ba2\u6237\u7aef\u8fdb\u884cudp\u8fde\u63a5\uff0c\u5bfc\u81f4\u672c\u6b21\u8fde\u63a5\u5931\u8d25!"));
                } else {
                    final InetSocketAddress cloudSocketAddress0 = (InetSocketAddress)r.getRemoteAddress();
                    JobTask t = new JobTask(){

                        protected void doRun() throws Exception {
                            RemoteConnection connection = ServiceUtil.getServiceContext().getCarparkUdpConnectionFactory().createUdpConnection(cloudSocketAddress0);
                            RequestSender sender = connection.createRequest();
                            sender.setRequestActionName("/CloudCarpark_P2PUdpConnectAction");
                            sender.setHeader("op", "keepAlived");
                            sender.setHeader("r", String.valueOf(System.currentTimeMillis()));
                            sender.setAttribute("send.wait.ack.timeout", (Object)2800L);
                            sender.setAttribute("send.attempt.times", (Object)1);
                            sender.setAttribute("CLOUD_ACTION_HANDLE", (Object)Boolean.TRUE);
                            sender.doRequest(null, null);
                        }
                    };
                    ServiceUtil.getServiceContext().delay(t, 3L, TimeUnit.SECONDS);
                    ServiceUtil.getServiceContext().delay(t, 6L, TimeUnit.SECONDS);
                }
            }
        });
        this.sendP2pUdpHole(connectHostNo, 10, remoteClientAddress, 1000L);
        return CloudResultResponse.createSuccessResponse();
    }

    private void sendP2pUdpHole(final String connectHostNo, int sendTimes, final InetSocketAddress address, long ackMillsSecs) {
        try {
            ServiceLog.getLog().info((Object)("\u6536\u5230\u5ba2\u6237\u7aef:" + address + "\u8bf7\u6c42\u8fde\u63a5\uff0c\u8fd9\u5c06\u53d1\u9001p2p\u7a7f\u5899\u6253\u6d1e\u8fde\u63a5\u6570\u636e..."));
            RemoteConnection udpConn = ServiceUtil.getServiceContext().getCarparkUdpConnectionFactory().createUdpConnection(address);
            RequestSender usender = udpConn.createRequest();
            usender.setRequestActionName("/CarparkUdpHeatBeatAction");
            usender.setHeader("op", "udphole");
            usender.setHeader("srcHostNo", ServiceUtil.getServiceContext().getLocalHostNo());
            usender.setHeader("destHostNo", connectHostNo);
            usender.setAttribute("send.wait.ack.timeout", (Object)ackMillsSecs);
            usender.setAttribute("send.attempt.times", (Object)sendTimes);
            usender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
            usender.doRequest(new SendCallback(){

                public void onException(Throwable ex) {
                    ServiceLog.getLog().warn((Object)("\u5411\u4e3b\u673a:" + connectHostNo + "(" + address + ") \u53d1\u9001UDP\u6253\u6d1e\u6570\u636e\u5931\u8d25!" + ex.getMessage()));
                }

                public void onCompleted() {
                    ServiceLog.getLog().warn((Object)("\u5411\u4e3b\u673a:" + connectHostNo + "(" + address + ") \u53d1\u9001UDP\u6253\u6d1e\u6570\u636e\u6210\u529f! \u6210\u529f\u6536\u5230ACK"));
                }
            }, null);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u53d1\u9001\u7a7f\u5899\u6570\u636e\u5f02\u5e38:" + ex.getMessage()));
        }
    }
}

