/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.service.impl.remote;

import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.p2p.P2pPeerConnector;
import com.wovoe.carpark.p2p.P2pReverseConnection;
import com.wovoe.carpark.service.remote.CloudWebClientP2pService;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.Service;
import com.wovoe.framework.communication.protocol.ActionMapping;
import com.wovoe.framework.communication.protocol.PlainCryptoFactory;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RemoteConnection;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.Sender;
import com.wovoe.framework.communication.protocol.ServiceActionGetter;
import com.wovoe.framework.p2p.AcceptP2pConnectKey;
import com.wovoe.framework.p2p.IoSessionP2pConnSession;
import com.wovoe.framework.p2p.P2PUDPConnectionFactory;
import com.wovoe.framework.p2p.P2pConnSession;
import com.wovoe.framework.p2p.P2pContextUtil;
import com.wovoe.framework.p2p.P2pTransferTool;
import com.wovoe.framework.p2p.action.P2pDigHoleAction;
import com.wovoe.framework.transfer.ResultResponseMap;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.session.IoSession;

@Service(value="cloudWebClientP2pService")
public class CloudWebClientP2pServiceImpl
implements CloudWebClientP2pService {
    @Override
    public ResultResponseMap connect(Map<String, Object> paramMap, Map<String, Object> context) throws Exception {
        PublicKey publicKey;
        InetSocketAddress cloudSocketAddress;
        InetSocketAddress connSocketAddress;
        String cloudActionName = (String)paramMap.get("ca");
        String cloudActionOp = (String)paramMap.get("co");
        String requestId = (String)paramMap.get("cd");
        String wanDomain = (String)paramMap.get("cw");
        String _cloudUdpPort = (String)paramMap.get("cp");
        String peerId = (String)paramMap.get("pd");
        String peerName = (String)paramMap.get("pn");
        String connId = (String)paramMap.get("sd");
        String connName = (String)paramMap.get("sn");
        String connNetAddress = (String)paramMap.get("sa");
        String _connNetPort = (String)paramMap.get("sp");
        String _connPublicKey = (String)paramMap.get("pk");
        String sessionId = (String)paramMap.get("se");
        String _connUdpPort = (String)paramMap.get("sr");
        if (cloudActionName == null || cloudActionName.length() == 0) {
            return ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11ca");
        }
        if (requestId == null || requestId.length() == 0) {
            return ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11cd");
        }
        if (_cloudUdpPort == null || _cloudUdpPort.length() == 0) {
            return ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11cp");
        }
        if (peerId == null || peerId.length() == 0) {
            return ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11pd");
        }
        if (peerName == null || peerName.length() == 0) {
            return ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11pn");
        }
        if (connId == null || connId.length() == 0) {
            return ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11sd");
        }
        if (connName == null || connName.length() == 0) {
            return ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11sn");
        }
        if (connNetAddress == null || connNetAddress.length() == 0) {
            return ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11sa");
        }
        if (_connNetPort == null || _connNetPort.length() == 0) {
            return ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11sp");
        }
        if (_connPublicKey == null || _connPublicKey.length() == 0) {
            return ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11pk");
        }
        if (sessionId == null || sessionId.length() == 0) {
            return ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11se");
        }
        if (wanDomain == null || wanDomain.length() == 0) {
            return ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11ca");
        }
        if (!peerId.equals(P2pContextUtil.getContext().getLocalHost().getAppId())) {
            return ResultResponseMap.createResponse((String)"403", (String)"peerId\u9519\u8bef");
        }
        if (!peerName.equals(P2pContextUtil.getContext().getLocalHost().getAppName())) {
            return ResultResponseMap.createResponse((String)"403", (String)"peerName\u9519\u8bef");
        }
        try {
            connSocketAddress = new InetSocketAddress(connNetAddress, Integer.parseInt(_connNetPort));
        }
        catch (Exception ex) {
            return ResultResponseMap.createResponse((String)"403", (String)("\u65e0\u6cd5\u89e3\u6790\u7684\u8fde\u63a5\u5730\u5740\u7aef\u53e3: " + connNetAddress + ":" + _connNetPort));
        }
        InetAddress cloudAddress = null;
        String cloudIp = (String)paramMap.get("ci");
        if (cloudIp != null && cloudIp.length() > 0) {
            try {
                cloudAddress = InetAddress.getByName(cloudIp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cloudAddress == null) {
            try {
                cloudAddress = InetAddress.getByName(wanDomain);
            }
            catch (Exception ex) {
                LogUtil.getLog().warn((Object)("\u65e0\u6cd5\u89e3\u6790\u7f51\u7edc\u5730\u5740: " + wanDomain + ": " + ex.getMessage()));
                return ResultResponseMap.createResponse((String)"403", (String)("\u65e0\u6cd5\u89e3\u6790\u7684\u4e91\u7aef\u5730\u5740: " + wanDomain));
            }
        }
        try {
            cloudSocketAddress = new InetSocketAddress(cloudAddress, Integer.parseInt(_cloudUdpPort));
        }
        catch (Exception ex) {
            return ResultResponseMap.createResponse((String)"403", (String)("\u65e0\u6cd5\u89e3\u6790\u7684\u4e91\u7aef\u5730\u5740\u7aef\u53e3: " + wanDomain + ":" + _cloudUdpPort));
        }
        P2PUDPConnectionFactory factory = P2pContextUtil.getContext().getP2PUDPConnectionFactory();
        P2pConnSession session = P2pContextUtil.getContext().getP2pConnSessionManager().getP2pSession((SocketAddress)connSocketAddress, sessionId, factory.getAcceport());
        if (session != null && session.isConnected()) {
            LogUtil.getLog().warn((Object)("\u91cd\u590d\u6d88\u606f?\u8fd8\u662f\u4e1a\u52a1\u9519\u8bef\uff01\u51fa\u73b0\u91cd\u590d\u8fde\u63a5\u5730\u5740: " + connName + ":" + connId + ", " + connSocketAddress + ", sessionId: " + sessionId));
            return ResultResponseMap.createResponse((String)"501", (String)"\u8be5\u5730\u5740\u5df2\u8fde\u63a5, \u8bf7\u4e0d\u8981\u91cd\u590d\u8fde\u63a5! ");
        }
        try {
            byte[] bx = BytesTool.unCompress((String)_connPublicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bx);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            publicKey = keyFactory.generatePublic(keySpec);
        }
        catch (Exception ex) {
            return ResultResponseMap.createResponse((String)"403", (String)"\u65e0\u6cd5\u89e3\u6790\u7684\u79d8\u94a5pk");
        }
        AcceptP2pConnectKey acceptKey = new AcceptP2pConnectKey(sessionId, factory.getAcceport(), connId, connName, peerId, peerName);
        P2pContextUtil.getContext().getTimeoutObjectPool().addObject((Object)acceptKey, (Object)publicKey, null, 20000L, TimeUnit.MILLISECONDS);
        try {
            RemoteConnection cloudConn = factory.createConnection((SocketAddress)cloudSocketAddress);
            RequestSender cloudSender = cloudConn.createRequest();
            cloudSender.setAttribute("send.wait.ack.timeout", (Object)1000L);
            cloudSender.setAttribute("send.attempt.times", (Object)5);
            cloudSender.setAttribute("CLOUD_ACTION_HANDLE", (Object)Boolean.TRUE);
            cloudSender.setAttribute("ACTION_SEND_ENCRYPT_CRYPTO", (Object)P2pContextUtil.getContext().getCloudConnectTransferCrypto());
            cloudSender.setRequestActionName(cloudActionName);
            if (cloudActionOp != null && cloudActionOp.length() > 0) {
                cloudSender.setHeader("op", cloudActionOp);
            }
            cloudSender.setHeader("cd", requestId);
            cloudSender.setHeader("se", sessionId);
            cloudSender.setHeader("pd", peerId);
            cloudSender.setHeader("pn", peerName);
            cloudSender.setHeader("pr", String.valueOf(factory.getAcceport()));
            cloudSender.setHeader("sd", connId);
            cloudSender.setHeader("sn", connName);
            byte[] localPublicKey = P2pContextUtil.getContext().getLocalHost().getRsaPublicKey().getEncoded();
            cloudSender.setSendData(localPublicKey);
            cloudSender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    LogUtil.getLog().warn((Object)("\u53d1\u9001\u5141\u8bb8\u8fdb\u884cP2p\u8fde\u63a5\u5230\u4e91\u7aef\u5931\u8d25\uff0c\u4e91\u7aef\u65e0Ack\u54cd\u5e94" + exception.getMessage()));
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                }

                public long getWaitTimeoutMills() {
                    return 10000L;
                }

                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                }
            });
            this.doDigHole(factory, connSocketAddress, 10, sessionId, acceptKey);
            if (_connUdpPort != null && _connUdpPort.length() > 0) {
                try {
                    int rPort = Integer.parseInt(_connUdpPort);
                    if (rPort != connSocketAddress.getPort()) {
                        this.doDigHole(factory, new InetSocketAddress(connSocketAddress.getAddress(), rPort), 10, sessionId, acceptKey);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ResultResponseMap.createResponse((String)"0", (String)"SUCCESS");
        }
        catch (Exception ex) {
            LogUtil.getLog().warn((Object)"\u53d1\u9001\u8bf7\u6c42P2p\u5141\u8bb8\u8fde\u63a5\u8bf7\u6c42\u5f02\u5e38", (Throwable)ex);
            P2pContextUtil.getContext().getTimeoutObjectPool().removeObject((Object)acceptKey);
            return ResultResponseMap.createResponse((String)"500", (String)"UDP\u8bf7\u6c42\u5f02\u5e38!");
        }
    }

    private void doDigHole(final P2PUDPConnectionFactory factory, final SocketAddress connSocketAddress, final int attemptTimes, final String sessionId, final AcceptP2pConnectKey acceptKey) {
        try {
            if (attemptTimes <= 0) {
                return;
            }
            String p2pDigHoleActionName = P2pDigHoleAction.class.getAnnotation(ActionMapping.class).value()[0];
            RemoteConnection conn = factory.createConnection(connSocketAddress);
            RequestSender digHoleSender = conn.createRequest();
            digHoleSender.setRequestActionName(p2pDigHoleActionName);
            digHoleSender.setHeader("a", "1");
            digHoleSender.setAttribute("transfer.session.id", (Object)sessionId);
            digHoleSender.setAttribute("send.wait.ack.timeout", (Object)1000L);
            digHoleSender.setAttribute("send.attempt.times", (Object)1);
            digHoleSender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
            digHoleSender.setAttribute("ACTION_SEND_ENCRYPT_CRYPTO", (Object)PlainCryptoFactory.getInstance());
            digHoleSender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    int a = attemptTimes - 1;
                    if (a <= 0) {
                        return;
                    }
                    if (P2pContextUtil.getContext().getTimeoutObjectPool().getObject((Object)acceptKey) == null) {
                        return;
                    }
                    CloudWebClientP2pServiceImpl.this.doDigHole(factory, connSocketAddress, a, sessionId, acceptKey);
                }

                public void onCompleted() {
                }
            }, null);
        }
        catch (Exception ex) {
            LogUtil.getLog().warn((Object)("\u53d1\u9001P2p\u6253\u6d1e\u5f02\u5e38! " + ex.getMessage()));
        }
    }

    @Override
    public OperationFuture<ResultResponseMap> reverseConnect(Map<String, Object> paramMap, Map<String, Object> context) throws Exception {
        OperationFutureHandler connectFu;
        boolean transportType;
        final String localId = (String)paramMap.get("cd");
        final String localName = (String)paramMap.get("cn");
        final String peerId = (String)paramMap.get("ad");
        final String peerName = (String)paramMap.get("an");
        final String connId = (String)paramMap.get("gd");
        final OperationFutureHandler handler = ServiceUtil.getServiceContext().createOperationFuture();
        if (localId == null || localId.length() == 0) {
            handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11cd"));
            return handler;
        }
        if (localName == null || localName.length() == 0) {
            handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11cn"));
            return handler;
        }
        if (peerId == null || peerId.length() == 0) {
            handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11ad"));
            return handler;
        }
        if (peerName == null || peerName.length() == 0) {
            handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11an"));
            return handler;
        }
        if (connId == null || connId.length() == 0) {
            handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)"\u7f3a\u5c11gd"));
            return handler;
        }
        if (!localId.equals(P2pContextUtil.getContext().getLocalHost().getAppId())) {
            handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)"cd\u9519\u8bef"));
            return handler;
        }
        if (!localName.equals(P2pContextUtil.getContext().getLocalHost().getAppName())) {
            handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)"cn\u9519\u8bef"));
            return handler;
        }
        String _use = (String)paramMap.get("use");
        if (_use == null || _use.length() == 0) {
            _use = "0";
        }
        if (!"0".equals(_use)) {
            handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)("\u4e0d\u652f\u6301\u7684use:" + _use)));
            return handler;
        }
        String _tst = (String)paramMap.get("tst");
        if (_tst == null || _tst.length() == 0) {
            transportType = false;
        } else if (String.valueOf(0).equals(_tst)) {
            transportType = false;
        } else if (String.valueOf(1).equals(_tst)) {
            transportType = true;
        } else {
            handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)("\u4e0d\u652f\u6301\u7684\u901a\u4fe1\u6a21\u5f0f:" + _tst)));
            return handler;
        }
        if (transportType) {
            OperationFutureHandler operationFutureHandler;
            int tcpPort;
            String _tcpPort = (String)paramMap.get("tpt");
            if (_tcpPort == null || _tcpPort.length() == 0) {
                handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)"TCP\u8fde\u63a5\u7f3a\u5c11\u53c2\u6570tpt"));
                return handler;
            }
            try {
                tcpPort = Integer.parseInt(_tcpPort);
            }
            catch (Exception ex) {
                handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)("TCP\u8fde\u63a5\u53c2\u6570tpt\u9519\u8bef: " + _tcpPort)));
                return handler;
            }
            if (tcpPort <= 0 || tcpPort >= 65535) {
                handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)("TCP\u8fde\u63a5\u53c2\u6570tpt\u9519\u8bef: " + _tcpPort)));
                return handler;
            }
            String connectIp = (String)paramMap.get("tit");
            if (connectIp == null || connectIp.length() == 0) {
                connectIp = (String)paramMap.get("ai");
            }
            if (connectIp == null || connectIp.length() == 0) {
                handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)"TCP\u8fde\u63a5\u7f3a\u5c11\u6709\u6548\u7684\u8fde\u63a5IP"));
                return handler;
            }
            final String connSignKey = (String)paramMap.get("sk");
            if (connSignKey == null || connSignKey.length() == 0) {
                handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)"TCP\u8fde\u63a5\u7f3a\u5c11\u53c2\u6570sk"));
                return handler;
            }
            connectFu = operationFutureHandler = ServiceUtil.getServiceContext().createOperationFuture();
            try {
                ConnectFuture future = P2pContextUtil.getContext().getNioSocketConnector().connect((SocketAddress)new InetSocketAddress(connectIp, tcpPort));
                future.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

                    public void operationComplete(ConnectFuture ioFuture) {
                        if (ioFuture.getException() != null) {
                            operationFutureHandler.setException(ioFuture.getException());
                        } else {
                            IoSession session = ioFuture.getSession();
                            if (session == null || !session.isConnected()) {
                                operationFutureHandler.setException((Throwable)new IOException("Connect failed"));
                            } else {
                                IoSessionP2pConnSession p2psession = new IoSessionP2pConnSession(0, session, (ServiceActionGetter)P2pReverseConnection.getServiceActionManager(), connSignKey);
                                p2psession.setRemotePeerId(peerId);
                                p2psession.setRemotePeerName(peerName);
                                p2psession.setAttribute("WOVOE_TCPCONNECTIOHANLER", (Object)p2psession);
                                operationFutureHandler.setResult((Object)p2psession);
                            }
                        }
                    }
                });
            }
            catch (Throwable ex) {
                operationFutureHandler.setException(ex);
            }
        } else {
            connectFu = P2pPeerConnector.connect(peerId, peerName);
        }
        connectFu.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<P2pConnSession>(){

            public void waitCompleteTimeout() {
                handler.setResult((Object)ResultResponseMap.createResponse((String)"403", (String)"\u8fde\u63a5\u8d85\u65f6"));
            }

            public void operationComplete(OperationFuture<P2pConnSession> future) {
                if (!future.isCancelled() && future.getException() == null && future.getResult() != null) {
                    final P2pConnSession session = (P2pConnSession)future.getResult();
                    P2pReverseConnection connection = new P2pReverseConnection(session);
                    try {
                        RequestSender sender = connection.newRequestSender();
                        sender.setRequestActionName("/p2pReverseConnectAction");
                        sender.setHeader("op", "handshake");
                        sender.setHeader("destAppid", peerId);
                        sender.setHeader("destAppName", peerName);
                        sender.setHeader("srcAppid", localId);
                        sender.setHeader("srcAppName", localName);
                        sender.setHeader("connectId", connId);
                        sender.setHeader("e", String.valueOf(System.currentTimeMillis()));
                        P2pTransferTool.setSign((Sender)sender, (String)session.getLocalSignKey());
                        sender.doRequest(new SendCallback(){

                            public void onException(Throwable exception) {
                                session.close();
                                handler.setResult((Object)ResultResponseMap.createResponse((String)"601", (String)("\u8fdb\u884c\u63e1\u624b\u5931\u8d25\uff01 \u53d1\u9001\u5931\u8d25! " + exception)));
                            }

                            public void onCompleted() {
                            }
                        }, new ReceiveCallback(){

                            public void doReceiver(Receiver receiver, int sendId) throws Exception {
                                if (!"SUCCESS".equals(receiver.getHeaderValue("c"))) {
                                    session.close();
                                    return;
                                }
                                if (!P2pTransferTool.checkSign((Receiver)receiver, (P2pConnSession)session)) {
                                    session.close();
                                    return;
                                }
                                handler.setResult((Object)ResultResponseMap.createResponse((String)"0", (String)"SUCCESS"));
                            }

                            public void onWaitTimeout() throws Exception {
                                session.close();
                                handler.setResult((Object)ResultResponseMap.createResponse((String)"601", (String)"\u8fdb\u884c\u63e1\u624b\u5931\u8d25\uff01\u670d\u52a1\u5668\u65e0\u54cd\u5e94"));
                            }

                            public long getWaitTimeoutMills() {
                                return 8000L;
                            }
                        });
                    }
                    catch (Throwable ex) {
                        session.close();
                        handler.setResult((Object)ResultResponseMap.createResponse((String)"601", (String)("\u8fdb\u884c\u63e1\u624b\u5931\u8d25\uff01 \u53d1\u9001\u5f02\u5e38! " + ex)));
                    }
                } else {
                    String errMsg = "\u8fde\u63a5\u4e3b\u673a: " + peerId + ": " + peerName + " \u5931\u8d25\uff01";
                    if (future.getException() != null) {
                        errMsg = String.valueOf(errMsg) + future.getException();
                    }
                    handler.setResult((Object)ResultResponseMap.createResponse((String)"601", (String)errMsg));
                }
            }
        });
        return handler;
    }
}

