/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.service.impl.remote;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.ConfirmPassDialogCallback;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.KeyLockManager;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassEventHandler;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.SyncRecordDataListener;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.cloud.CloudResultResponse;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCancelPassRecord;
import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkEscapeOrder;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkInvoiceOrder;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.dto.CarparkPassDiscount;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassSelfPay;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPlateCarType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkQueryFee;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.action.PlateRegCameraAction;
import com.wovoe.carpark.equipment.action.RoadBarrierAction;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.app.LocalPassRecordEvent;
import com.wovoe.carpark.event.app.PassRecordEvent;
import com.wovoe.carpark.event.app.ReadPassportNumberEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.WuhanPlateCheckFilter;
import com.wovoe.carpark.pass.filter.YiChangPlateCheckFilter;
import com.wovoe.carpark.pass.filter.YongchengPlateCheckFilter;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.service.remote.CommonRemoteService;
import com.wovoe.carpark.vo.DiscountVo;
import com.wovoe.carpark.vo.HostEquipmentSate;
import com.wovoe.carpark.vo.SyncDBRecord;
import com.wovoe.carpark.vo.SyncDBRecordResult;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.ObjectCreateCallback;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.Service;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.db.sync.DataSyncService;
import com.wovoe.framework.transfer.ResultResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ibatis.session.SqlSession;

@Service
public class CommonRemoteServiceImpl
implements CommonRemoteService {
    private List<SyncRecordDataListener> syncRecordDataListeners = new CopyOnWriteArrayList<SyncRecordDataListener>();

    @Override
    public HostEquipmentSate getHostEquipmentSate(Map<String, String> paramMap, Map<String, Object> context) {
        HostEquipmentSate state;
        block19: {
            CarparkHost localHost;
            String hostNo = paramMap.get("hostNo");
            if (ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(hostNo) == null) {
                HostEquipmentSate s1 = new HostEquipmentSate();
                s1.setResponseCode("1");
                s1.setResponseMsg("\u4e3b\u673a\u7f16\u53f7\uff1a" + hostNo + "\u4e0d\u5b58\u5728\uff0c\u62d2\u7edd\u8bbf\u95ee\uff01");
                return s1;
            }
            try {
                List wanSateList;
                String wanSateListString;
                CarparkHost serverHost;
                CarparkHost localHost2 = ServiceUtil.getServiceContext().getLocalHost();
                if (localHost2 != null && localHost2.getHost_use() == 1 && localHost2.getNet_mode() == 1 && (serverHost = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(hostNo)) != null && serverHost.getHost_use() != 1 && (wanSateListString = paramMap.get("wanSateList")) != null && wanSateListString.length() > 0 && (wanSateList = (List)GsonBuilder.create().fromJson(wanSateListString, new TypeToken<List<HostEquipmentSate>>(){}.getType())) != null && !wanSateList.isEmpty()) {
                    for (HostEquipmentSate ws : wanSateList) {
                        long h4;
                        CarparkHost host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(ws.getHostNo());
                        if (host == null || host.getHost_use() != 1 || host.getNet_mode() != 2) continue;
                        Long t3 = ws.getLastConnectedMills();
                        ServiceUtil.getServiceContext().getHostEquipmentSateManager().setHostOnline(ws);
                        if (t3 == null || t3 <= 0L || (h4 = ServiceUtil.getServiceContext().currentTimeMillis() - t3) <= 0L) continue;
                        ws.setLastConnectedMills(h4);
                    }
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u5916\u7f51\u5ba2\u6237\u7aef\u72b6\u6001\u5f02\u5e38\uff1a" + ex.getMessage()));
            }
            state = ServiceUtil.getServiceContext().getHostEquipmentSateManager().getLocalHostEquipmentSate();
            state.setLastConnectedMills(System.currentTimeMillis());
            Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
            if (hostMap != null && paramMap != null && (localHost = hostMap.get(ServiceUtil.getServiceContext().getLocalHostNo())) != null && localHost.getHost_use() == 1 && localHost.getNet_mode() == 1 && hostNo != null && hostNo.length() > 0) {
                CarparkHost serverHost;
                String serverHostIp = paramMap.get("serverHostIp");
                String serverHostPort = paramMap.get("serverHostPort");
                if (serverHostIp != null && serverHostIp.length() > 0 && serverHostPort != null && serverHostPort.length() > 0 && (serverHost = hostMap.get(hostNo)) != null && serverHost.getHost_use() != 1) {
                    try {
                        boolean updateServerHost;
                        boolean needUpdateLocalConfig;
                        String newHostPort;
                        int serverPort;
                        block21: {
                            String cloudConnected = paramMap.get("cloudConnected");
                            if ("true".equals(cloudConnected)) {
                                ServiceUtil.getServiceContext().setAttribute("cloudConnected", Boolean.TRUE);
                            } else {
                                ServiceUtil.getServiceContext().setAttribute("cloudConnected", Boolean.FALSE);
                            }
                            serverPort = Integer.parseInt(serverHostPort);
                            newHostPort = String.valueOf(serverHostIp) + ":" + serverHostPort;
                            needUpdateLocalConfig = !newHostPort.equals(ServiceUtil.getServiceContext().getCarparkLocalConfig().getServer_host_port());
                            boolean bl = updateServerHost = !serverHostIp.equals(serverHost.getHost_ip()) || serverHost.getHost_port() != serverPort;
                            if (!needUpdateLocalConfig && !updateServerHost) break block19;
                            CommonDaoService commonServie = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                            SqlSession sqlsession = commonServie.openSqlSession();
                            try {
                                try {
                                    CommonParam updateP;
                                    if (needUpdateLocalConfig) {
                                        updateP = new CommonParam(commonServie.getTableName(CarparkLocalConfig.class));
                                        updateP.addEQ("id", (Object)ServiceUtil.getServiceContext().getCarparkLocalConfig().getId());
                                        updateP.addUpdate("server_host_port", (Object)newHostPort);
                                        commonServie.update(sqlsession, updateP);
                                    }
                                    if (updateServerHost) {
                                        updateP = new CommonParam(commonServie.getTableName(CarparkHost.class));
                                        updateP.addEQ("id", (Object)serverHost.getId());
                                        updateP.addUpdate("host_ip", (Object)serverHostIp);
                                        updateP.addUpdate("host_port", (Object)serverPort);
                                        commonServie.update(sqlsession, updateP);
                                    }
                                    sqlsession.commit();
                                }
                                catch (Throwable ex) {
                                    sqlsession.rollback();
                                    ServiceLog.getLog().warn((Object)"\u66f4\u65b0\u672c\u5730\u914d\u7f6e\u5f02\u5e38!", ex);
                                    sqlsession.close();
                                    break block21;
                                }
                            }
                            catch (Throwable throwable) {
                                sqlsession.close();
                                throw throwable;
                            }
                            sqlsession.close();
                        }
                        if (needUpdateLocalConfig) {
                            ServiceUtil.getServiceContext().getCarparkLocalConfig().setServer_host_port(newHostPort);
                        }
                        if (updateServerHost) {
                            serverHost.setHost_ip(serverHostIp);
                            serverHost.setHost_port(serverPort);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncDBRecordResult synDBRecord(SyncDBRecord record, Map<String, Object> context) {
        SyncDBRecordResult result = new SyncDBRecordResult();
        try {
            Object po;
            if (record.getTableName() == null || record.getTableName().length() == 0) {
                throw new Exception("\u7f3a\u5c11\u8868\u540d!");
            }
            CommonDaoService commonServie = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            Class cl = commonServie.getPoClass(record.getTableName());
            if (cl == null) {
                throw new Exception("\u8868\u540d\uff1a" + record.getTableName() + "\u5bf9\u5e94\u7684pojo\u672a\u6620\u5c04\uff01");
            }
            Gson gson = GsonBuilder.create();
            try {
                po = gson.fromJson(record.getJsonRecord(), cl);
            }
            catch (Exception ex) {
                throw new Exception("\u4e0d\u662f\u6709\u6548\u7684json\u6570\u636e");
            }
            JavaBeanMap beanMap = new JavaBeanMap(po);
            Object obj_id = beanMap.get((Object)"id");
            String id = obj_id != null ? obj_id.toString() : "";
            KeyLockManager keyLockManager = ServiceUtil.getServiceContext().getKeyLockManager();
            Object lock = keyLockManager.getLock("commonRemoteService-synDBRecord-" + record.getTableName() + "-" + id);
            try {
                Object object = lock;
                synchronized (object) {
                    String passRecordTableName = commonServie.getTableName(CarparkPassRecord.class);
                    String transactionTableName = commonServie.getTableName(CarparkTransaction.class);
                    String selfPayTableName = commonServie.getTableName(CarparkPassSelfPay.class);
                    String passDiscountName = commonServie.getTableName(CarparkPassDiscount.class);
                    if (record.getTableName().equals(passRecordTableName)) {
                        this.syncPassRecord((CarparkPassRecord)po);
                        this.checkLocalSession((CarparkPassRecord)po);
                    } else if (record.getTableName().equals(transactionTableName)) {
                        CarparkTransaction transaction = (CarparkTransaction)po;
                        this.syncTransaction(transaction);
                        if (transaction.getPay_method() != null && transaction.getPay_method() == 0 && transaction.getPassport_number() != null) {
                            String exitRecordNo;
                            String sx = "WLARAG_";
                            if (transaction.getOrder_no() != null && transaction.getOrder_no().startsWith(sx) && (exitRecordNo = transaction.getOrder_no().substring(sx.length())) != null && exitRecordNo.length() > 0 && transaction.getExit_time() != null && transaction.getEnter_time() != null) {
                                CommonParam updateOrder = new CommonParam(commonServie.getTableName(CarparkEscapeOrder.class));
                                updateOrder.addUpdate("order_pay_time", (Object)transaction.getTran_time());
                                updateOrder.addUpdate("order_pay_method", (Object)transaction.getPay_method());
                                updateOrder.addUpdate("order_pay_scene", (Object)transaction.getPay_scene());
                                updateOrder.addUpdate("order_charge_org", (Object)transaction.getCharge_org());
                                updateOrder.addUpdate("order_pay_entry", (Object)transaction.getPay_entry());
                                updateOrder.addUpdate("order_des", (Object)(String.valueOf(transaction.getOperate_user_name()) + "\u6536\u53d6\u73b0\u91d1\u653e\u884c"));
                                updateOrder.addUpdate("pay_order_no", (Object)transaction.getOrder_no());
                                updateOrder.addUpdate("tran_record_no", (Object)transaction.getTansaction_no());
                                updateOrder.addUpdate("order_pay_money", (Object)transaction.getTran_money());
                                updateOrder.addUpdate("order_state", (Object)1);
                                updateOrder.addEQ("passport_number", (Object)transaction.getPassport_number());
                                updateOrder.addEQ("exit_time", (Object)transaction.getExit_time());
                                updateOrder.addEQ("medium_type", (Object)transaction.getMedium_type());
                                updateOrder.addEQ("carpark_id", (Object)transaction.getCarpark_id());
                                updateOrder.addEQ("enter_record_no", (Object)transaction.getEnter_record_no());
                                updateOrder.addEQ("exit_record_no", (Object)exitRecordNo);
                                commonServie.update(updateOrder);
                            }
                        }
                    } else {
                        commonServie.synDataByPrimeryKey(po);
                        if (po instanceof CarparkCancelPassRecord) {
                            int rState;
                            CarparkCancelPassRecord cancelRecord = (CarparkCancelPassRecord)po;
                            RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                            int n = rState = cancelRecord.getRecord_state() == null ? 0 : cancelRecord.getRecord_state();
                            if (rState == 32) {
                                if (cancelRecord.getExit_time() != null && cancelRecord.getExit_record_no() != null && cancelRecord.getExit_record_no().length() > 0) {
                                    PassEventHandler.rollbackPassRecord(cancelRecord.getPass_time() == null ? cancelRecord.getExit_time() : cancelRecord.getPass_time(), 1, cancelRecord.getExit_record_no(), cancelRecord.getCarpark_id(), cancelRecord.getExit_car_trail_pic(), cancelRecord.getExit_remark(), rState, false);
                                } else if (cancelRecord.getEnter_time() != null && cancelRecord.getEnter_record_no() != null && cancelRecord.getEnter_record_no().length() > 0) {
                                    PassEventHandler.rollbackPassRecord(cancelRecord.getPass_time() == null ? cancelRecord.getEnter_time() : cancelRecord.getPass_time(), 0, cancelRecord.getEnter_record_no(), cancelRecord.getCarpark_id(), cancelRecord.getEnter_car_trail_pic(), cancelRecord.getEnter_remark(), rState, false);
                                }
                            } else {
                                CarparkEscapeOrder oldOrder;
                                CarparkEscapeOrder order = recordSaveService.createEscapeOrder(cancelRecord, false);
                                if (order != null && (oldOrder = (CarparkEscapeOrder)commonServie.selectOne(new SearchParam().addEQ("id", (Object)order.getId()), CarparkEscapeOrder.class)) == null) {
                                    CommonParam delParam = new CommonParam(commonServie.getTableName(CarparkEscapeOrder.class));
                                    delParam.addEQ("passport_number", (Object)order.getPassport_number());
                                    delParam.addLT("exit_time", (Object)order.getExit_time());
                                    delParam.addEQ("medium_type", (Object)order.getMedium_type());
                                    delParam.addEQ("carpark_id", (Object)order.getCarpark_id());
                                    delParam.addEQ("area_no", (Object)order.getArea_no());
                                    delParam.addEQ("enter_time", (Object)order.getEnter_time());
                                    delParam.addEQ("order_state", (Object)0);
                                    commonServie.delete((SearchParam)delParam);
                                    commonServie.insert((Object)order);
                                    if (cancelRecord.getExit_time() != null && rState == 31) {
                                        SearchParam sp = new SearchParam(commonServie.getTableName(CarparkPresenceRecord.class));
                                        sp.addEQ("carpark_id", (Object)cancelRecord.getCarpark_id());
                                        sp.addEQ("passport_number", (Object)cancelRecord.getPassport_number());
                                        sp.addEQ("medium_type", (Object)cancelRecord.getMedium_type());
                                        sp.addLT("enter_time", (Object)cancelRecord.getExit_time());
                                        commonServie.delete(sp);
                                    }
                                }
                            }
                        }
                    }
                    result.setReturnCode(0);
                    result.setReturnMsg("\u6570\u636e\u5df2\u6210\u529f\u4fdd\u5b58");
                    if (selfPayTableName.equals(record.getTableName())) {
                        CarparkPassSelfPay selfPay = (CarparkPassSelfPay)po;
                        if (selfPay.getEnter_pay() != null && selfPay.getEnter_pay() == 2) {
                            CommonParam updateOrder = new CommonParam(commonServie.getTableName(CarparkEscapeOrder.class));
                            updateOrder.addEQ("passport_number", (Object)selfPay.getPassport_number());
                            updateOrder.addEQ("exit_time", (Object)selfPay.getExit_time());
                            updateOrder.addEQ("medium_type", (Object)selfPay.getMedium_type());
                            updateOrder.addEQ("carpark_id", (Object)selfPay.getCarpark_id());
                            updateOrder.addEQ("enter_record_no", (Object)selfPay.getEnter_record_no());
                            updateOrder.addEQ("exit_record_no", (Object)selfPay.getExit_record_no());
                            updateOrder.addUpdate("order_state", (Object)1);
                            updateOrder.addUpdate("order_pay_money", (Object)selfPay.getPaid_amount());
                            updateOrder.addUpdate("order_pay_time", (Object)selfPay.getPaid_time());
                            updateOrder.addUpdate("order_pay_method", (Object)selfPay.getPaid_method());
                            updateOrder.addUpdate("order_pay_scene", (Object)selfPay.getPay_scene());
                            updateOrder.addUpdate("order_charge_org", (Object)selfPay.getCharge_org());
                            updateOrder.addUpdate("order_pay_entry", (Object)selfPay.getPay_entry());
                            if (selfPay.getCloud_order_no() != null) {
                                updateOrder.addUpdate("pay_order_no", (Object)selfPay.getCloud_order_no());
                            }
                            updateOrder.addUpdate("tran_record_no", (Object)selfPay.getCharge_record_no());
                            commonServie.update(updateOrder);
                        }
                        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                        appService.asynHandleSelfPay(selfPay);
                    }
                    if (passDiscountName.equals(record.getTableName())) {
                        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                        appService.asynHandleDiscount((CarparkPassDiscount)po);
                    }
                    for (SyncRecordDataListener l : this.syncRecordDataListeners) {
                        l.onSyncARecord(record.getTableName(), po);
                    }
                }
            }
            finally {
                keyLockManager.releaseLock(lock);
            }
        }
        catch (Throwable ex) {
            result.setReturnCode(1);
            String msg = ex.getMessage();
            result.setResponseMsg(msg == null || msg.length() == 0 ? "\u64cd\u4f5c\u5931\u8d25!" : msg);
            try {
                String errmsg = "\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01";
                errmsg = record != null ? String.valueOf(errmsg) + "\u6570\u636e:" + record : String.valueOf(errmsg) + "\u6570\u636e:NULL";
                ServiceLog.getLog().warn((Object)errmsg, ex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private void checkLocalSession(CarparkPassRecord po) {
        try {
            if (po.getExit_time() != null) {
                Enumeration<PassChannel> enus;
                String otherPassPlate = po.getExit_plate();
                Date otherPassTime = po.getExit_time();
                if (po.getEnter_time() != null && otherPassPlate != null && otherPassPlate.length() > 0 && po.getExit_plate_source() != null && (po.getExit_plate_source() == 0 || po.getExit_plate_source() == 3) && (enus = ServiceUtil.getServiceContext().getPassChannelManager().getChannels()) != null) {
                    while (enus.hasMoreElements()) {
                        PassChannel passChannel = enus.nextElement();
                        Collection<PassSession> sessions = passChannel.getSessions();
                        if (sessions == null) continue;
                        for (PassSession session : sessions) {
                            Date spassTime;
                            String spassPlate;
                            if (session.getSessionState() == PassSession.SessionState.OPEN_DIALOG && session.getReadPassportNumberEvent() != null && !session.getReadPassportNumberEvent().isManualTrigger()) {
                                CarparkArea exitArea;
                                ChannelArea channelArea;
                                spassPlate = session.getPassPlate();
                                if (spassPlate == null || !otherPassPlate.equals(spassPlate) || (spassTime = (Date)session.getAttribute("passTime")) == null || spassTime.getTime() > otherPassTime.getTime() && spassTime.getTime() - otherPassTime.getTime() > 5000L || (channelArea = (ChannelArea)session.getAttribute("channelArea")) == null || channelArea.getExitAreas() == null || channelArea.getExitAreas().isEmpty() || (exitArea = (CarparkArea)session.getAttribute("PASS_EXIT_AREA")) == null || !exitArea.getArea_no().equals(po.getArea_no())) continue;
                                session.removeCancelPassRecord();
                                session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                session.setSessionState(PassSession.SessionState.CANCELED);
                                ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                                if (callback != null) {
                                    callback.doClosePassDialog(session);
                                }
                                String msg = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(po.getPass_channel_no()) != null ? "\u8f66\u8f86\uff1a" + spassPlate + ", \u5df2\u88ab\u5176\u4ed6\u4e3b\u673a" + po.getExit_host_name() + "\u653e\u884c\uff01\u901a\u9053: " + po.getExit_channel_name() + " \u79bb\u573a, \u79bb\u573a\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(po.getPass_time()) : "\u8f66\u8f86\uff1a" + spassPlate + ", \u5df2\u7ecf\u5728\u5176\u4ed6\u901a\u9053: " + po.getExit_channel_name() + " \u79bb\u573a, \u79bb\u573a\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(po.getPass_time());
                                msg = String.valueOf(msg) + "\uff0c\u5df2\u5173\u95ed\u5728\u672c\u673a\u7ba1\u7406\u901a\u9053\u7684\u5f39\u51fa\u6846! ";
                                ServiceLog.getLog().info((Object)msg);
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2));
                                continue;
                            }
                            if (session.getSessionState() != PassSession.SessionState.WAIT_CAR_LEAVE && session.getSessionState() != PassSession.SessionState.CAR_LEAVING || session.getReadPassportNumberEvent() == null || session.getReadPassportNumberEvent().isManualTrigger() || (spassPlate = session.getPassPlate()) == null || !otherPassPlate.equals(spassPlate) || (spassTime = (Date)session.getAttribute("passTime")) == null || spassTime.getTime() > otherPassTime.getTime() && spassTime.getTime() - otherPassTime.getTime() > 5000L) continue;
                            session.setSessionState(PassSession.SessionState.CAR_LEFT);
                        }
                    }
                }
            } else if (po.getEnter_time() != null) {
                Enumeration<PassChannel> enus;
                String otherPassPlate = po.getEnter_plate();
                Date otherPassTime = po.getEnter_time();
                if (otherPassTime != null && otherPassPlate != null && otherPassPlate.length() > 0 && po.getEnter_plate_source() != null && (po.getEnter_plate_source() == 0 || po.getEnter_plate_source() == 3) && (enus = ServiceUtil.getServiceContext().getPassChannelManager().getChannels()) != null) {
                    while (enus.hasMoreElements()) {
                        PassChannel passChannel = enus.nextElement();
                        Collection<PassSession> sessions = passChannel.getSessions();
                        if (sessions == null) continue;
                        for (PassSession session : sessions) {
                            Date spassTime;
                            String spassPlate;
                            if (session.getSessionState() == PassSession.SessionState.OPEN_DIALOG && session.getReadPassportNumberEvent() != null && !session.getReadPassportNumberEvent().isManualTrigger()) {
                                CarparkArea area;
                                ChannelArea channelArea;
                                spassPlate = session.getPassPlate();
                                if (spassPlate == null || !otherPassPlate.equals(spassPlate) || (spassTime = (Date)session.getAttribute("passTime")) == null || spassTime.getTime() > otherPassTime.getTime() && spassTime.getTime() - otherPassTime.getTime() > 5000L || (channelArea = (ChannelArea)session.getAttribute("channelArea")) == null || channelArea.getEnterAreas() == null || channelArea.getEnterAreas().isEmpty() || (area = channelArea.getEnterAreas().get(0)) == null || !area.getArea_no().equals(po.getArea_no())) continue;
                                session.removeCancelPassRecord();
                                session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                                session.setSessionState(PassSession.SessionState.CANCELED);
                                ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                                if (callback != null) {
                                    callback.doClosePassDialog(session);
                                }
                                String msg = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(po.getPass_channel_no()) != null ? "\u8f66\u8f86\uff1a" + spassPlate + ", \u5df2\u88ab\u5176\u4ed6\u4e3b\u673a" + po.getExit_host_name() + "\u653e\u884c\uff01\u901a\u9053: " + po.getExit_channel_name() + ", \u5165\u573a\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(po.getPass_time()) : "\u8f66\u8f86\uff1a" + spassPlate + ", \u5df2\u7ecf\u5728\u5176\u4ed6\u901a\u9053: " + po.getExit_channel_name() + " \u5165\u573a, \u5165\u573a\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(po.getPass_time());
                                msg = String.valueOf(msg) + "\uff0c\u5df2\u5173\u95ed\u5728\u672c\u673a\u7ba1\u7406\u901a\u9053\u7684\u5f39\u51fa\u6846! ";
                                ServiceLog.getLog().info((Object)msg);
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2));
                                continue;
                            }
                            if (session.getSessionState() != PassSession.SessionState.WAIT_CAR_LEAVE && session.getSessionState() != PassSession.SessionState.CAR_LEAVING || session.getReadPassportNumberEvent() == null || session.getReadPassportNumberEvent().isManualTrigger() || (spassPlate = session.getPassPlate()) == null || !otherPassPlate.equals(spassPlate) || (spassTime = (Date)session.getAttribute("passTime")) == null || spassTime.getTime() > otherPassTime.getTime() && spassTime.getTime() - otherPassTime.getTime() > 5000L) continue;
                            session.setSessionState(PassSession.SessionState.CAR_LEFT);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u68c0\u6d4bLocalPassSession\u5f02\u5e38", (Throwable)ex);
        }
    }

    private void syncPassRecord(CarparkPassRecord po) throws Throwable {
        PassChannel passChannel;
        CommonDaoService commonServie = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        try (SqlSession session = commonServie.openSqlSession();){
            try {
                long count = commonServie.selectCount(session, new SearchParam(commonServie.getTableName(po.getClass())).addEQ("id", (Object)po.getId()));
                if (count == 0L) {
                    RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                    commonServie.insert(session, (Object)po);
                    recordSaveService.handlePresenceRecord(session, po);
                    recordSaveService.onAddPassRecord(session, po, true);
                } else {
                    commonServie.updateIfChangedByPrimeryKey(session, (Object)po, null);
                }
                session.commit();
            }
            catch (Throwable e) {
                session.rollback();
                throw e;
            }
        }
        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new PassRecordEvent(this, po));
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1 && po.getPass_channel_no() != null && po.getPass_channel_no().length() > 0 && (passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(po.getPass_channel_no())) != null) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new LocalPassRecordEvent(this, po));
        }
    }

    private void syncTransaction(CarparkTransaction po) throws Throwable {
        CommonDaoService commonServie = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        try (SqlSession session = commonServie.openSqlSession();){
            try {
                long count = commonServie.selectCount(session, new SearchParam(commonServie.getTableName(po.getClass())).addEQ("id", (Object)po.getId()));
                if (count == 0L) {
                    RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                    recordSaveService.deductMoney(session, po);
                    commonServie.insert(session, (Object)po);
                } else {
                    commonServie.updateIfChangedByPrimeryKey(session, (Object)po, null);
                }
                session.commit();
            }
            catch (Throwable e) {
                session.rollback();
                throw e;
            }
        }
    }

    @Override
    public ResultResponse handleModifyPassPlate(Map<String, String> paramMap, Map<String, Object> context) {
        CarparkPassRecord record;
        ResultResponse r;
        block6: {
            CommonDaoService commonServie = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            r = new ResultResponse();
            SqlSession session = commonServie.openSqlSession();
            record = null;
            try {
                try {
                    RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                    long recordId = Long.parseLong(paramMap.get("recordId"));
                    String oldPlate = paramMap.get("oldPlate").toString();
                    String newPlate = paramMap.get("newPlate").toString();
                    long modifyTimeMills = Long.parseLong(paramMap.get("modifyTimeMills"));
                    String modifyUserCode = paramMap.get("modifyUserCode").toString();
                    String modifyUserName = paramMap.get("modifyUserName").toString();
                    Date modifyDate = new Date(modifyTimeMills);
                    record = recordSaveService.handleModifyPlate(session, recordId, oldPlate, newPlate, modifyDate, modifyUserCode, modifyUserName);
                    session.commit();
                    r.setResponseCode("0");
                    r.setResponseMsg("success");
                }
                catch (Throwable e) {
                    session.rollback();
                    r.setResponseCode("1");
                    r.setResponseMsg("\u64cd\u4f5c\u5931\u8d25,\u8fdc\u7a0b\u5f02\u5e38:" + e.getMessage());
                    ServiceLog.getLog().warn((Object)"\u4fee\u6539\u8f66\u724c\u5f02\u5e38\uff01", e);
                    session.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                session.close();
                throw throwable;
            }
            session.close();
        }
        if (record != null) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new PassRecordEvent(this, record));
        }
        return r;
    }

    @Override
    public ResultResponse handleFormalOperation(Map<String, String> paramMap, Map<String, Object> context) {
        Date d;
        String deleteTime = paramMap.get("deleteTime");
        ResultResponse r = new ResultResponse();
        r.setResponseCode("0");
        r.setResponseMsg("success");
        if (deleteTime == null || deleteTime.length() == 0) {
            ServiceLog.getLog().warn((Object)"handleFormalOperation \u7f3a\u5c11\u53c2\u6570: deleteTime");
            return r;
        }
        try {
            d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(deleteTime);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("handleFormalOperation \u65e0\u6548\u53c2\u6570: deleteTime: " + deleteTime));
            return r;
        }
        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        recordSaveService.doFormalOperation(false, d);
        return r;
    }

    @Override
    public ResultResponse syncServerConfigData(final Map<String, String> paramMap, Map<String, Object> context) {
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() != 1) {
                        return;
                    }
                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    LinkedList<DataSyncService.SyncTable> syncTables = new LinkedList<DataSyncService.SyncTable>();
                    for (String tableName : paramMap.values()) {
                        Class al = commonDaoService.getPoClass(tableName);
                        if (al == null) continue;
                        syncTables.add(new DataSyncService.SyncTable(tableName, al));
                    }
                    if (!syncTables.isEmpty()) {
                        DataSyncService dataSyncService = (DataSyncService)ServiceUtil.getServiceContext().getService(DataSyncService.class);
                        String url = "http://" + ServiceUtil.getServiceContext().getCarparkLocalConfig().getServer_host_port() + "/syncTableData";
                        HashMap<String, String> paramMap2 = new HashMap<String, String>();
                        paramMap2.put("hostNo", ServiceUtil.getServiceContext().getLocalHostNo());
                        dataSyncService.doSyncRemoteData(url, 5000, null, 1, syncTables, paramMap2, "ck_ddl_sync_table_log");
                    }
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                }
            }
        });
        ResultResponse r = new ResultResponse();
        r.setResponseCode("0");
        r.setResponseMsg("success");
        return r;
    }

    @Override
    public Map<String, String> modifyUserPassword(Map<String, String> paramMap, Map<String, Object> context) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("responseCode", "0");
        returnMap.put("responseMsg", "success");
        try {
            String userCode = paramMap.get("userCode");
            String oldPwd = paramMap.get("oldPwd");
            String newPwd = paramMap.get("newPwd");
            if (oldPwd == null || oldPwd.length() == 0) {
                returnMap.put("returnCode", "5");
                returnMap.put("returnMsg", "\u539f\u5bc6\u7801\u4e3a\u7a7a");
                return returnMap;
            }
            String hostNo = paramMap.get("hostNo");
            if (hostNo == null || hostNo.length() == 0 || ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(hostNo) == null) {
                returnMap.put("returnCode", "6");
                returnMap.put("returnMsg", "\u4e3b\u673a\u65e0\u6743\u9650");
                return returnMap;
            }
            ApplicationService service = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            int v = service.modifyUserPwd(userCode, oldPwd, newPwd);
            if (v == 0) {
                returnMap.put("returnCode", "0");
                returnMap.put("returnMsg", "\u64cd\u4f5c\u6210\u529f\uff0c\u5bc6\u7801\u5df2\u4fee\u6539\u3002");
            } else if (v == 1) {
                returnMap.put("returnCode", "1");
                returnMap.put("returnMsg", "\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            } else if (v == 2) {
                returnMap.put("returnCode", "2");
                returnMap.put("returnMsg", "\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u5220\u9664\uff01");
            } else if (v == 3) {
                returnMap.put("returnCode", "3");
                returnMap.put("returnMsg", "\u539f\u767b\u5f55\u5bc6\u7801\u4e0d\u6b63\u786e\uff01");
            } else {
                returnMap.put("returnCode", "4");
                returnMap.put("returnMsg", "\u64cd\u4f5c\u5931\u8d25\uff01");
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
            returnMap.put("returnCode", "4");
            returnMap.put("returnMsg", "\u64cd\u4f5c\u5931\u8d25\uff01\u670d\u52a1\u5668\u5f02\u5e38!");
        }
        return returnMap;
    }

    @Override
    public ResultResponse handleModifyPresenceCarType(Map<String, String> paramMap, Map<String, Object> context) {
        ResultResponse r = new ResultResponse();
        try {
            RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            long id = Long.parseLong(paramMap.get("id"));
            long opTimeMills = Long.parseLong(paramMap.get("opTimeMills"));
            String userCode = paramMap.get("userCode").toString();
            String userName = paramMap.get("userName").toString();
            Date opTime = new Date(opTimeMills);
            String oldCarTypeNo = paramMap.get("oldCarTypeNo").toString();
            String newCarTypeNo = paramMap.get("newCarTypeNo").toString();
            recordSaveService.modifyPresenceCarType(id, oldCarTypeNo, newCarTypeNo, userCode, userName, opTime, false);
            r.setResponseCode("0");
            r.setResponseMsg("success");
        }
        catch (Throwable e) {
            r.setResponseCode("1");
            r.setResponseMsg("\u64cd\u4f5c\u5931\u8d25,\u8fdc\u7a0b\u5f02\u5e38:" + e.getMessage());
            ServiceLog.getLog().warn((Object)"\u4fee\u6539\u5728\u573a\u8f66\u8f86\u7c7b\u578b\u5f02\u5e38\uff01", e);
        }
        return r;
    }

    @Override
    public ResultResponse handleRemoveCarparkPresenceRecord(Map<String, String> paramMap, Map<String, Object> context) {
        ResultResponse r = new ResultResponse();
        try {
            RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            if (paramMap.get("exit_record_no") != null && paramMap.get("passport_number") != null && paramMap.get("exit_time") != null && paramMap.get("id") == null) {
                return this.handleCloseEscapeOrder(paramMap, context);
            }
            long id = Long.parseLong(paramMap.get("id"));
            long opTimeMills = Long.parseLong(paramMap.get("opTimeMills"));
            String userCode = paramMap.get("userCode").toString();
            String userName = paramMap.get("userName").toString();
            Date opTime = new Date(opTimeMills);
            recordSaveService.removeCarparkPresenceRecord(id, userCode, userName, opTime, false);
            r.setResponseCode("0");
            r.setResponseMsg("success");
        }
        catch (Throwable e) {
            r.setResponseCode("1");
            r.setResponseMsg("\u64cd\u4f5c\u5931\u8d25,\u8fdc\u7a0b\u5f02\u5e38:" + e.getMessage());
            ServiceLog.getLog().warn((Object)"\u79fb\u9664\u573a\u5185\u8bb0\u5f55\u5f02\u5e38\uff01", e);
        }
        return r;
    }

    @Override
    public Map<String, Object> scanCarPass(Map<String, String> paramMap, Map<String, Object> context) {
        String RETURN_CODE = "returnCode";
        String RETURN_MSG = "returnMsg";
        CloudResultResponse returnMap = CloudResultResponse.createSuccessResponse();
        try {
            List<Equipment> list;
            String channelNo = paramMap.get("channelNo");
            String passportNumber = paramMap.get("passportNumber");
            if (passportNumber == null || passportNumber.length() == 0) {
                return CloudResultResponse.createResponse("403", "\u7f3a\u5c11\u53c2\u6570\u5361\u53f7");
            }
            if (channelNo == null || channelNo.length() == 0) {
                return CloudResultResponse.createResponse("403", "\u7f3a\u5c11\u901a\u9053\u53f7");
            }
            PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
            if (passChannel == null) {
                returnMap.put(RETURN_CODE, "501");
                returnMap.put(RETURN_MSG, "\u901a\u9053\u672a\u8fde\u63a5");
                return returnMap;
            }
            String plateNumber = paramMap.get("plateNumber");
            boolean forceTemp = "true".equals(paramMap.get("forceTemp"));
            if (!ServiceUtil.getServiceContext().isDevEnvironment() && (list = passChannel.getEquipmentList(9)) != null && !list.isEmpty()) {
                boolean ok = false;
                for (Equipment eq : list) {
                    if (eq.getEquipmentAction() == null || !eq.getEquipmentAction().isWorkingProperly()) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    returnMap.put(RETURN_CODE, "501");
                    returnMap.put(RETURN_MSG, "\u8bbe\u5907\u672a\u8fde\u63a5!");
                    return returnMap;
                }
            }
            ReadPassportNumberEvent revent = new ReadPassportNumberEvent(passChannel, passportNumber, 1, channelNo);
            revent.setPlateNumber(plateNumber);
            revent.setUserScan(true);
            revent.setScanCode(passportNumber);
            revent.setForceTemp(forceTemp);
            OperationFutureHandler remoteExeHandler = ServiceUtil.getServiceContext().createOperationFuture();
            revent.setRemoteExeHandler((OperationFutureHandler<Map<String, Object>>)remoteExeHandler);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(revent);
            Map reMap = (Map)remoteExeHandler.get(10L, TimeUnit.SECONDS);
            if (reMap == null) {
                returnMap.put(RETURN_CODE, "501");
                returnMap.put(RETURN_MSG, "\u6267\u884c\u653e\u884c\u6d41\u7a0b\u8d85\u65f6");
            } else {
                boolean success = "0".equals(reMap.get("responseCode"));
                if (success) {
                    if (reMap.get(RETURN_CODE) == null) {
                        returnMap.put(RETURN_CODE, "0");
                        returnMap.put(RETURN_MSG, reMap.get("responseMsg"));
                    } else {
                        returnMap.put(RETURN_CODE, reMap.get(RETURN_CODE));
                        returnMap.put(RETURN_MSG, reMap.get(RETURN_MSG) == null ? "" : reMap.get(RETURN_MSG));
                    }
                } else {
                    returnMap.put(RETURN_CODE, reMap.get("responseCode"));
                    returnMap.put(RETURN_MSG, reMap.get("responseMsg"));
                }
                for (Map.Entry e : reMap.entrySet()) {
                    if ("responseCode".equals(e.getKey()) || "responseMsg".equals(e.getKey()) || RETURN_CODE.equals(e.getKey()) || RETURN_MSG.equals(e.getKey())) continue;
                    returnMap.put((String)e.getKey(), e.getValue());
                }
            }
        }
        catch (Exception ex) {
            returnMap.put(RETURN_CODE, "500");
            returnMap.put(RETURN_MSG, "\u5185\u90e8\u9519\u8bef");
            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
        }
        return returnMap;
    }

    @Override
    public Map<String, Object> queryPassSession(Map<String, String> paramMap, Map<String, Object> context) throws Exception {
        String plateNumber = paramMap.get("plateNumber0");
        String passportNumber = paramMap.get("passportNumber0");
        String mediumType = paramMap.get("mediumType0");
        String scanPassportNumber = paramMap.get("scanPassportNumber0");
        int medium_type = 1;
        if (scanPassportNumber != null && scanPassportNumber.length() > 0) {
            passportNumber = scanPassportNumber;
        } else if (passportNumber != null && passportNumber.length() > 0 && mediumType != null && mediumType.length() > 0) {
            try {
                medium_type = Integer.parseInt(mediumType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean queryByCondition = plateNumber != null && plateNumber.length() > 0 || passportNumber != null && passportNumber.length() > 0;
        String RETURN_CODE = "returnCode";
        String RETURN_MSG = "returnMsg";
        CloudResultResponse returnMap = CloudResultResponse.createSuccessResponse();
        try {
            PassSession passSession;
            block17: {
                Collection<PassSession> cl;
                block16: {
                    String channelNo = paramMap.get("channelNo");
                    if (channelNo == null || channelNo.length() == 0) {
                        return CloudResultResponse.createResponse("403", "\u7f3a\u5c11\u901a\u9053\u53f7");
                    }
                    PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
                    if (passChannel == null) {
                        returnMap.put(RETURN_CODE, "501");
                        returnMap.put(RETURN_MSG, "\u901a\u9053\u672a\u8fde\u63a5");
                        return returnMap;
                    }
                    cl = passChannel.getSessions();
                    passSession = null;
                    if (!queryByCondition) break block16;
                    if (passportNumber != null && passportNumber.length() > 0) {
                        for (PassSession s : cl) {
                            Object passplate;
                            if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG && s.getSessionState() != PassSession.SessionState.WAIT_PAY || (passplate = s.getPassPlate()) != null && s.getReadPassportNumberEvent() != null && s.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(passplate) || s.getReadPassportNumberEvent() == null || !passportNumber.equals(s.getReadPassportNumberEvent().getPassportNumber()) || medium_type != s.getReadPassportNumberEvent().getPassportMediumType()) continue;
                            passSession = s;
                            break;
                        }
                    }
                    if (passSession != null || plateNumber == null || plateNumber.length() <= 0 || passportNumber != null && passportNumber.length() > 0 && 6 == medium_type && plateNumber.equals(passportNumber)) break block17;
                    PassSession samePlateSession = null;
                    for (PassSession s : cl) {
                        String passplate;
                        if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG && s.getSessionState() != PassSession.SessionState.WAIT_PAY || (passplate = s.getPassPlate()) != null && s.getReadPassportNumberEvent() != null && s.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(passplate)) continue;
                        if (s.getReadPassportNumberEvent() != null && plateNumber.equals(s.getReadPassportNumberEvent().getPassportNumber()) && 6 == s.getReadPassportNumberEvent().getPassportMediumType()) {
                            passSession = s;
                        }
                        if (passplate == null || !plateNumber.equals(passplate)) continue;
                        samePlateSession = s;
                    }
                    if (passSession != null || samePlateSession == null) break block17;
                    passSession = samePlateSession;
                    break block17;
                }
                for (PassSession s : cl) {
                    String passplate;
                    if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG && s.getSessionState() != PassSession.SessionState.WAIT_PAY || (passplate = s.getPassPlate()) != null && s.getReadPassportNumberEvent() != null && s.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(passplate)) continue;
                    passSession = s;
                }
            }
            if (passSession != null) {
                CommonRemoteServiceImpl.setQueryPassSessionResult(passSession, returnMap);
            } else {
                returnMap.put(RETURN_CODE, "3");
                returnMap.put(RETURN_MSG, "\u6253\u5361\u5904\u7406");
            }
        }
        catch (Exception ex) {
            returnMap.put(RETURN_CODE, "500");
            returnMap.put(RETURN_MSG, "\u5185\u90e8\u9519\u8bef");
            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
        }
        return returnMap;
    }

    public static void setQueryFeeDicount(Cost cost, CarparkQueryFee queryFee) {
        if (cost == null || queryFee == null) {
            return;
        }
        List<CarparkPassDiscount> disocuntList = cost.getDiscountList();
        if (disocuntList != null && !disocuntList.isEmpty()) {
            ArrayList<CarparkPassDiscount> disList = new ArrayList<CarparkPassDiscount>(disocuntList.size());
            for (CarparkPassDiscount c : disocuntList) {
                if (c.getId() == null) {
                    disList.add(c);
                    continue;
                }
                CarparkPassDiscount c1 = new CarparkPassDiscount();
                c1.setId(c.getId());
                c1.setDiscount_no(c.getDiscount_no());
                c1.setDiscount_amount(c.getDiscount_amount());
                c1.setDiscount_time(c.getDiscount_time());
                c1.setDiscount_method(c.getDiscount_method());
                c1.setDiscount_value(c.getDiscount_value());
                disList.add(c1);
            }
            queryFee.setDiscounts_json(GsonBuilder.create().toJson(disList));
        }
    }

    public static void setDicountListToQueryMap(Cost cost, Map<String, Object> returnMap) {
        if (cost == null || returnMap == null) {
            return;
        }
        List<CarparkPassDiscount> disocuntList = cost.getDiscountList();
        if (disocuntList != null && !disocuntList.isEmpty()) {
            ArrayList<DiscountVo> list = new ArrayList<DiscountVo>(disocuntList.size());
            for (CarparkPassDiscount c : disocuntList) {
                DiscountVo vo = new DiscountVo();
                vo.setId(c.getId());
                vo.setDisNo(c.getDiscount_no());
                vo.setDisTime(c.getDiscount_time());
                vo.setDisMeth(c.getDiscount_method());
                vo.setDisVal(c.getDiscount_value());
                vo.setDisDes(c.getDiscount_value_des());
                vo.setAmount(c.getDiscount_amount() == null ? Constants.MONEY_ZERO : c.getDiscount_amount());
                vo.setMerName(c.getDiscount_merchant_name());
                vo.setMerNo(c.getDiscount_merchant_no());
                vo.setProjNo(c.getDiscount_project_no());
                vo.setProjName(c.getDiscount_project_name());
                vo.setCno(c.getCoupon_no());
                vo.setCorderNo(c.getCoupon_order_no());
                vo.setDisSource(c.getDiscount_source());
                list.add(vo);
            }
            returnMap.put("discountList", GsonBuilder.create().toJson(list));
        }
    }

    public static Map<String, Object> setEnterChargeFee(PassSession passSession, Map<String, Object> returnMap) {
        ChannelArea channelArea;
        if (returnMap == null) {
            returnMap = new HashMap<String, Object>();
        }
        if (passSession == null) {
            return returnMap;
        }
        String RETURN_CODE = "returnCode";
        String RETURN_MSG = "returnMsg";
        Cost cost = (Cost)passSession.getAttribute("pass_cost");
        if (cost == null) {
            cost = new Cost();
        }
        if ((channelArea = (ChannelArea)passSession.getAttribute("channelArea")) != null && channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty() && passSession.getAttribute("PRE_ENTRY_RECORD_ID") != null) {
            int maxAllowMinus;
            CarparkPresenceRecord takeChargeRecord;
            CarparkArea enterArea = channelArea.getEnterAreas().get(0);
            Date enterTime = (Date)passSession.getAttribute("passTime");
            if (enterTime == null) {
                enterTime = ServiceUtil.getNow();
            }
            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            CarparkQueryFee queryFee = new CarparkQueryFee();
            queryFee.setQuery_time(ServiceUtil.getNow());
            queryFee.setPassport_number(passSession.getPassport().getPassport_number());
            queryFee.setMedium_type(passSession.getPassport().getMedium_type());
            queryFee.setEnter_time(enterTime);
            queryFee.setPlate_number(passSession.getPassPlate());
            queryFee.setEnter_record_no("C" + passSession.getAttribute("PRE_ENTRY_RECORD_ID"));
            queryFee.setCharge_start_time(enterTime);
            queryFee.setShould_charge(cost.getShouldCharged());
            queryFee.setActual_charge_amount(cost.getActualCharge());
            queryFee.setDiscount_money(cost.getDiscountMoney());
            queryFee.setAlready_paid(cost.getAlready_paid());
            queryFee.setPeriod_multi_start(cost.getPeriod_multi_start());
            queryFee.setPeriod_multi_received(cost.getPeriod_multi_received());
            queryFee.setPeriod_multi_free(cost.getPeriod_multi_free());
            queryFee.setNext_period_multi_start(cost.getNext_period_multi_start());
            queryFee.setNext_period_multi_cur(cost.getNext_period_multi_cur());
            if (cost.getChargeTimeMinutes() <= 0) {
                queryFee.setCharge_time_length(0);
            } else {
                queryFee.setCharge_time_length(cost.getChargeTimeMinutes());
            }
            queryFee.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
            queryFee.setProject_id(ServiceUtil.getServiceContext().getProjectId());
            String operate_user_code = (String)returnMap.get("operate_user_code");
            if (operate_user_code == null || operate_user_code.length() == 0) {
                operate_user_code = "USER_SELF";
            }
            queryFee.setOperate_user_code(operate_user_code);
            String operate_user_name = (String)returnMap.get("operate_user_name");
            if (operate_user_name == null || operate_user_name.length() == 0) {
                operate_user_name = "\u81ea\u52a9\u7f34\u8d39";
            }
            queryFee.setOperate_user_name(operate_user_name);
            String duty_no = (String)returnMap.get("duty_no");
            if (duty_no == null || duty_no.length() == 0) {
                duty_no = "0";
            }
            queryFee.setDuty_no(duty_no);
            queryFee.setHost_no(ServiceUtil.getServiceContext().getLocalHostNo());
            queryFee.setHost_name(ServiceUtil.getServiceContext().getLocalHost().getHost_name());
            queryFee.setPassport_no(passSession.getPassport().getPassport_no());
            queryFee.setPass_type(passSession.getPassportType().getPass_type());
            queryFee.setPassport_type_no(passSession.getPassportType().getPassport_type_no());
            queryFee.setPassport_type_name(passSession.getPassportType().getPassport_type_name());
            queryFee.setCar_type_no(passSession.getCarType().getCar_type_no());
            queryFee.setCar_type_name(passSession.getCarType().getCar_type_name());
            queryFee.setTran_area_no(enterArea.getArea_no());
            queryFee.setTran_area_name(enterArea.getArea_name());
            queryFee.setTran_channel_no(passSession.getPassChannel().getChannel().getChannel_no());
            queryFee.setTran_channel_name(passSession.getPassChannel().getChannel().getChannel_name());
            if (passSession.getCarOwner() != null) {
                queryFee.setTran_user_no(passSession.getCarOwner().getCar_owner_no());
                queryFee.setTran_user_name(passSession.getCarOwner().getCar_owner_name());
            }
            queryFee.setEnter_pay(1);
            CommonRemoteServiceImpl.setQueryFeeDicount(cost, queryFee);
            returnMap.put("carparkQeuryFee", GsonBuilder.create().toJson((Object)queryFee));
            returnMap.put("plateNumber", queryFee.getPlate_number());
            returnMap.put("passportNumber", queryFee.getPassport_number());
            returnMap.put("mediumType", queryFee.getMedium_type().toString());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            returnMap.put("enterTime", df.format(queryFee.getEnter_time()));
            returnMap.put("enterRecordNo", queryFee.getEnter_record_no());
            returnMap.put("passType", passSession.getPassportType().getPass_type().toString());
            returnMap.put("passTypeNo", passSession.getPassportType().getPassport_type_no());
            returnMap.put("passTypeName", passSession.getPassportType().getPassport_type_name());
            returnMap.put("carTypeNo", passSession.getCarType().getCar_type_no());
            returnMap.put("carTypeName", passSession.getCarType().getCar_type_name());
            returnMap.put("parkName", ServiceUtil.getServiceContext().getCarpark().getCarpark_name());
            returnMap.put("areaNo", enterArea.getArea_no());
            returnMap.put("areaName", enterArea.getArea_name());
            returnMap.put("areaLevel", enterArea.getArea_level().toString());
            returnMap.put("shouldCharge", cost.getShouldCharged().toString());
            returnMap.put("disountFee", cost.getDeduct_money().toString());
            returnMap.put("periodMultiFree", cost.getPeriod_multi_free().toString());
            returnMap.put("alreadyPaid", cost.getAlready_paid().toString());
            returnMap.put("actualCharge", cost.getActualCharge().toString());
            returnMap.put("enterChannelNo", passSession.getPassChannel().getChannel().getChannel_no());
            returnMap.put("enterChannelName", passSession.getPassChannel().getChannel().getChannel_name());
            CommonRemoteServiceImpl.setDicountListToQueryMap(cost, returnMap);
            if (passSession.getPlateRecognizedEvent() != null) {
                if (passSession.getPlateRecognizedEvent().getPlateColor() != null && passSession.getPlateRecognizedEvent().getPlateColor().length() > 0) {
                    returnMap.put("plateColor", passSession.getPlateRecognizedEvent().getPlateColor());
                }
            } else if (passSession.getReadPassportNumberEvent() != null && passSession.getReadPassportNumberEvent().getPlateRecognizedEvent() != null && passSession.getReadPassportNumberEvent().getPlateRecognizedEvent().getPlateColor() != null && passSession.getReadPassportNumberEvent().getPlateRecognizedEvent().getPlateColor().length() > 0) {
                returnMap.put("plateColor", passSession.getReadPassportNumberEvent().getPlateRecognizedEvent().getPlateColor());
            }
            int passState = 0;
            if (passSession.getAllowPassExcetpions().contains(7)) {
                passState = 7;
                if (passSession.getDatabasePassport() != null && passSession.getDatabasePassport().getStart_date() != null) {
                    returnMap.put("startDate", new SimpleDateFormat("yyyy-MM-dd").format(passSession.getDatabasePassport().getStart_date()));
                }
                if (passSession.getDatabasePassportType() != null) {
                    returnMap.put("passType", passSession.getDatabasePassportType().getPass_type().toString());
                    returnMap.put("passTypeNo", passSession.getDatabasePassportType().getPassport_type_no());
                    returnMap.put("passTypeName", passSession.getDatabasePassportType().getPassport_type_name());
                }
            } else if (passSession.getAllowPassExcetpions().contains(8)) {
                passState = 8;
                if (passSession.getDatabasePassport() != null && passSession.getDatabasePassport().getStop_date() != null) {
                    returnMap.put("stopDate", new SimpleDateFormat("yyyy-MM-dd").format(passSession.getDatabasePassport().getStop_date()));
                }
                if (passSession.getDatabasePassportType() != null) {
                    returnMap.put("passType", passSession.getDatabasePassportType().getPass_type().toString());
                    returnMap.put("passTypeNo", passSession.getDatabasePassportType().getPassport_type_no());
                    returnMap.put("passTypeName", passSession.getDatabasePassportType().getPassport_type_name());
                }
            } else {
                Date expirDate = null;
                if (passSession.getPassportType().getPass_type() == 2) {
                    expirDate = passSession.getPassport().getDeadline();
                }
                if (expirDate != null) {
                    if (expirDate.before(enterTime)) {
                        passState = 4;
                    }
                    returnMap.put("validDate", new SimpleDateFormat("yyyy-MM-dd").format(expirDate));
                }
            }
            returnMap.put("passState", String.valueOf(passState));
            Date chargeStartTime = queryFee.getCharge_start_time();
            returnMap.put("chargeStartTime", df.format(chargeStartTime));
            int chargeLenMinus = cost.getChargeTimeMinutes();
            returnMap.put("chargeLenMinus", String.valueOf(chargeLenMinus));
            returnMap.put("chargeLenDes", applicationService.getTimeLenDes(chargeLenMinus));
            if (cost.getPeriod_multi_start() != null) {
                returnMap.put("periodMulti", "Y");
                returnMap.put("periodMultiStart", df.format(cost.getPeriod_multi_start()));
                returnMap.put("periodMultiReceived", cost.getPeriod_multi_received().toString());
                if (cost.getNext_period_multi_start() != null && cost.getNext_period_multi_start().getTime() != cost.getPeriod_multi_start().getTime() && cost.getNext_period_multi_cur() != null && cost.getNext_period_multi_cur().doubleValue() > 0.0) {
                    returnMap.put("newPeriodMultiStart", df.format(cost.getNext_period_multi_start()));
                    returnMap.put("newPeriodMultiAmount", cost.getNext_period_multi_cur().toString());
                }
            } else {
                returnMap.put("periodMulti", "N");
            }
            if ((takeChargeRecord = (CarparkPresenceRecord)passSession.getAttribute("takeChargeRecord")) != null && takeChargeRecord.getEnter_plate() != null && !takeChargeRecord.getEnter_plate().equals(queryFee.getPlate_number())) {
                returnMap.put("takeSpacePlate", takeChargeRecord.getEnter_plate());
            }
            if (cost.getAlready_paid().doubleValue() > 0.0 && cost.getAlready_paid_time() != null) {
                returnMap.put("lastPaidTime", df.format(cost.getAlready_paid_time()));
            }
            if ((maxAllowMinus = queryFee.getCharge_time_length().intValue()) <= 0) {
                maxAllowMinus = 15;
            }
            returnMap.put("maxAllowMinus", String.valueOf(maxAllowMinus));
            returnMap.put("enterChannelNo", passSession.getPassChannel().getChannel().getChannel_no());
            returnMap.put("enterChannelName", passSession.getPassChannel().getChannel().getChannel_name());
            returnMap.put("enterPay", "1");
            returnMap.put("needFeeOrder", "1");
            returnMap.put(RETURN_CODE, "0");
            returnMap.put(RETURN_MSG, "\u9700\u8981\u4ea4\u8d39");
        }
        return returnMap;
    }

    public static Map<String, Object> setQueryPassSessionResult(PassSession passSession, Map<String, Object> returnMap) {
        BigDecimal actualCharge;
        String RETURN_CODE = "returnCode";
        String RETURN_MSG = "returnMsg";
        Cost cost = (Cost)passSession.getAttribute("pass_cost");
        if (cost == null) {
            cost = new Cost();
        }
        if (returnMap == null) {
            returnMap = new HashMap<String, Object>();
        }
        boolean canReturnChargeInfo = (actualCharge = cost.getActualCharge()).doubleValue() > 0.0;
        String enablex = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(passSession.getPassChannel().getChannelNo(), "CHANNEL_SCAN_SELPAY_AFTER_PLAY");
        if (enablex != null && "1".equals(enablex) && passSession.getAttribute("ALREADY_PLAY_CHARGE_VOICE") == null) {
            canReturnChargeInfo = false;
        }
        ChannelArea channelArea = (ChannelArea)passSession.getAttribute("channelArea");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date passTime = (Date)passSession.getAttribute("passTime");
        if (passTime == null) {
            passTime = ServiceUtil.getNow();
        }
        String passPlate = passSession.getPassPlate();
        try {
            if (passPlate != null && passPlate.length() > 0) {
                returnMap.put("plateNumber", passSession.getPassPlate());
                if (passSession.getReadPassportNumberEvent() != null && !passPlate.equals(passSession.getReadPassportNumberEvent().getPassportNumber())) {
                    returnMap.put("passportNumber", passSession.getReadPassportNumberEvent().getPassportNumber());
                }
            } else if (passSession.getReadPassportNumberEvent() != null) {
                returnMap.put("passportNumber", passSession.getReadPassportNumberEvent().getPassportNumber());
            }
            returnMap.put("passTime", df.format(passTime));
            returnMap.put("passChannelNo", passSession.getPassChannel().getChannel().getChannel_no());
            returnMap.put("passChannelName", passSession.getPassChannel().getChannel().getChannel_name());
            returnMap.put("passType", passSession.getPassportType().getPass_type().toString());
            returnMap.put("passTypeNo", passSession.getPassportType().getPassport_type_no());
            returnMap.put("passTypeName", passSession.getPassportType().getPassport_type_name());
            returnMap.put("carTypeNo", passSession.getCarType().getCar_type_no());
            returnMap.put("carTypeName", passSession.getCarType().getCar_type_name());
            returnMap.put("parkName", ServiceUtil.getServiceContext().getCarpark().getCarpark_name());
            int passState = 0;
            if (passSession.getAllowPassExcetpions().contains(7)) {
                passState = 7;
                if (passSession.getDatabasePassport() != null && passSession.getDatabasePassport().getStart_date() != null) {
                    returnMap.put("startDate", new SimpleDateFormat("yyyy-MM-dd").format(passSession.getDatabasePassport().getStart_date()));
                }
                if (passSession.getDatabasePassportType() != null) {
                    returnMap.put("passType", passSession.getDatabasePassportType().getPass_type().toString());
                    returnMap.put("passTypeNo", passSession.getDatabasePassportType().getPassport_type_no());
                    returnMap.put("passTypeName", passSession.getDatabasePassportType().getPassport_type_name());
                }
            } else if (passSession.getAllowPassExcetpions().contains(8)) {
                passState = 8;
                if (passSession.getDatabasePassport() != null && passSession.getDatabasePassport().getStop_date() != null) {
                    returnMap.put("stopDate", new SimpleDateFormat("yyyy-MM-dd").format(passSession.getDatabasePassport().getStop_date()));
                }
                if (passSession.getDatabasePassportType() != null) {
                    returnMap.put("passType", passSession.getDatabasePassportType().getPass_type().toString());
                    returnMap.put("passTypeNo", passSession.getDatabasePassportType().getPassport_type_no());
                    returnMap.put("passTypeName", passSession.getDatabasePassportType().getPassport_type_name());
                }
            } else {
                Date expirDate = null;
                if (passSession.getPassportType().getPass_type() == 2) {
                    expirDate = passSession.getPassport().getDeadline();
                }
                if (expirDate != null) {
                    if (expirDate.before(passTime)) {
                        passState = 4;
                    }
                    returnMap.put("validDate", new SimpleDateFormat("yyyy-MM-dd").format(expirDate));
                }
            }
            returnMap.put("passState", String.valueOf(passState));
            if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                returnMap.put("passDirection", String.valueOf(1));
                CarparkArea exitArea = channelArea.getExitAreas().get(channelArea.getExitAreas().size() - 1);
                returnMap.put("areaNo", exitArea.getArea_no());
                returnMap.put("areaName", exitArea.getArea_name());
                returnMap.put("areaLevel", exitArea.getArea_level().toString());
            } else {
                returnMap.put("passDirection", String.valueOf(0));
                if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                    CarparkArea enterArea = channelArea.getEnterAreas().get(0);
                    returnMap.put("areaNo", enterArea.getArea_no());
                    returnMap.put("areaName", enterArea.getArea_name());
                    returnMap.put("areaLevel", enterArea.getArea_level().toString());
                }
            }
        }
        catch (Throwable ex) {
            ServiceLog.getLog().error((Object)ex.getMessage(), ex);
        }
        if (canReturnChargeInfo) {
            ApplicationService applicationService;
            if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                CarparkPassportType pt;
                CarparkPresenceRecord takeChargeRecord;
                CarparkPresenceRecord enterRecord = CommonRemoteServiceImpl.getEnterRecord(passSession);
                if (enterRecord == null && channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                    Map areaPresenceRecordMap = (Map)passSession.getAttribute("areaPresenceRecordMap");
                    LinkedList<CarparkArea> existAreaList = (LinkedList<CarparkArea>)passSession.getAttribute("PASS_EXIT_AREA_LIST");
                    if (existAreaList == null) {
                        existAreaList = new LinkedList<CarparkArea>();
                    }
                    if (existAreaList.isEmpty()) {
                        existAreaList.add(channelArea.getExitAreas().get(channelArea.getExitAreas().size() - 1));
                    }
                    for (CarparkArea area : existAreaList) {
                        CarparkPresenceRecord e = (CarparkPresenceRecord)areaPresenceRecordMap.get(area.getArea_no());
                        if (e == null) continue;
                        enterRecord = e;
                    }
                }
                if (enterRecord == null) {
                    returnMap.put(RETURN_CODE, "2");
                    returnMap.put(RETURN_MSG, "\u6ca1\u6709\u627e\u5230\u51fa\u5165\u573a\u8bb0\u5f55");
                    return returnMap;
                }
                returnMap.put("enterChannelNo", enterRecord.getEnter_channel_no());
                returnMap.put("enterChannelName", enterRecord.getEnter_channel_name());
                applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                CarparkQueryFee queryFee = new CarparkQueryFee();
                queryFee.setQuery_time(passTime);
                queryFee.setPassport_number(passSession.getPassport().getPassport_number());
                queryFee.setMedium_type(passSession.getPassport().getMedium_type());
                queryFee.setEnter_time(enterRecord.getEnter_time());
                queryFee.setPlate_number(passSession.getPassPlate());
                queryFee.setEnter_record_no(enterRecord.getEnter_record_no());
                queryFee.setCharge_start_time(cost.getCharge_start_time() == null ? enterRecord.getEnter_time() : cost.getCharge_start_time());
                queryFee.setShould_charge(cost.getShouldCharged());
                queryFee.setActual_charge_amount(cost.getActualCharge());
                queryFee.setDiscount_money(cost.getDiscountMoney());
                queryFee.setAlready_paid(cost.getAlready_paid());
                queryFee.setPeriod_multi_start(cost.getPeriod_multi_start());
                queryFee.setPeriod_multi_received(cost.getPeriod_multi_received());
                queryFee.setPeriod_multi_free(cost.getPeriod_multi_free());
                queryFee.setNext_period_multi_start(cost.getNext_period_multi_start());
                queryFee.setNext_period_multi_cur(cost.getNext_period_multi_cur());
                if (cost.getChargeTimeMinutes() <= 0) {
                    if (passTime.getTime() > queryFee.getCharge_start_time().getTime()) {
                        queryFee.setCharge_time_length(ServiceUtil.getMins(queryFee.getCharge_start_time(), passTime));
                    } else {
                        queryFee.setCharge_time_length(0);
                    }
                } else {
                    queryFee.setCharge_time_length(cost.getChargeTimeMinutes());
                }
                queryFee.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                queryFee.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                String operate_user_code = (String)returnMap.get("operate_user_code");
                if (operate_user_code == null || operate_user_code.length() == 0) {
                    operate_user_code = "USER_SELF";
                }
                queryFee.setOperate_user_code(operate_user_code);
                String operate_user_name = (String)returnMap.get("operate_user_name");
                if (operate_user_name == null || operate_user_name.length() == 0) {
                    operate_user_name = "\u81ea\u52a9\u7f34\u8d39";
                }
                queryFee.setOperate_user_name(operate_user_name);
                String duty_no = (String)returnMap.get("duty_no");
                if (duty_no == null || duty_no.length() == 0) {
                    duty_no = "0";
                }
                queryFee.setDuty_no(duty_no);
                queryFee.setHost_no(ServiceUtil.getServiceContext().getLocalHostNo());
                queryFee.setHost_name(ServiceUtil.getServiceContext().getLocalHost().getHost_name());
                queryFee.setPassport_no(passSession.getPassport().getPassport_no());
                queryFee.setPass_type(passSession.getPassportType().getPass_type());
                queryFee.setPassport_type_no(passSession.getPassportType().getPassport_type_no());
                queryFee.setPassport_type_name(passSession.getPassportType().getPassport_type_name());
                queryFee.setCar_type_no(passSession.getCarType().getCar_type_no());
                queryFee.setCar_type_name(passSession.getCarType().getCar_type_name());
                queryFee.setTran_area_no(enterRecord.getArea_no());
                queryFee.setTran_area_name(enterRecord.getArea_name());
                queryFee.setTran_channel_no(passSession.getPassChannel().getChannel().getChannel_no());
                queryFee.setTran_channel_name(passSession.getPassChannel().getChannel().getChannel_name());
                if (passSession.getCarOwner() != null) {
                    queryFee.setTran_user_no(passSession.getCarOwner().getCar_owner_no());
                    queryFee.setTran_user_name(passSession.getCarOwner().getCar_owner_name());
                }
                queryFee.setEnter_pay(0);
                queryFee.setExit_time(passTime);
                CommonRemoteServiceImpl.setQueryFeeDicount(cost, queryFee);
                returnMap.put("carparkQeuryFee", GsonBuilder.create().toJson((Object)queryFee));
                returnMap.put("plateNumber", queryFee.getPlate_number());
                returnMap.put("passportNumber", queryFee.getPassport_number());
                returnMap.put("mediumType", queryFee.getMedium_type().toString());
                returnMap.put("enterTime", df.format(queryFee.getEnter_time()));
                returnMap.put("enterRecordNo", queryFee.getEnter_record_no());
                returnMap.put("passType", passSession.getPassportType().getPass_type().toString());
                returnMap.put("passTypeNo", passSession.getPassportType().getPassport_type_no());
                returnMap.put("passTypeName", passSession.getPassportType().getPassport_type_name());
                returnMap.put("carTypeNo", passSession.getCarType().getCar_type_no());
                returnMap.put("carTypeName", passSession.getCarType().getCar_type_name());
                returnMap.put("parkName", ServiceUtil.getServiceContext().getCarpark().getCarpark_name());
                returnMap.put("areaNo", enterRecord.getArea_no());
                returnMap.put("areaName", enterRecord.getArea_name());
                returnMap.put("areaLevel", enterRecord.getArea_level().toString());
                returnMap.put("shouldCharge", cost.getShouldCharged().toString());
                returnMap.put("disountFee", cost.getDeduct_money().toString());
                returnMap.put("periodMultiFree", cost.getPeriod_multi_free().toString());
                returnMap.put("alreadyPaid", cost.getAlready_paid().toString());
                returnMap.put("actualCharge", cost.getActualCharge().toString());
                CommonRemoteServiceImpl.setDicountListToQueryMap(cost, returnMap);
                Date chargeStartTime = queryFee.getCharge_start_time();
                returnMap.put("chargeStartTime", df.format(chargeStartTime));
                int chargeLenMinus = cost.getChargeTimeMinutes();
                returnMap.put("chargeLenMinus", String.valueOf(chargeLenMinus));
                returnMap.put("chargeLenDes", applicationService.getTimeLenDes(chargeLenMinus));
                returnMap.put("chargeEndTime", df.format(passTime));
                returnMap.put("exitTime", df.format(passTime));
                if (passSession.getPlateRecognizedEvent() != null) {
                    if (passSession.getPlateRecognizedEvent().getPlateColor() != null && passSession.getPlateRecognizedEvent().getPlateColor().length() > 0) {
                        returnMap.put("plateColor", passSession.getPlateRecognizedEvent().getPlateColor());
                    }
                } else if (passSession.getReadPassportNumberEvent() != null && passSession.getReadPassportNumberEvent().getPlateRecognizedEvent() != null && passSession.getReadPassportNumberEvent().getPlateRecognizedEvent().getPlateColor() != null && passSession.getReadPassportNumberEvent().getPlateRecognizedEvent().getPlateColor().length() > 0) {
                    returnMap.put("plateColor", passSession.getReadPassportNumberEvent().getPlateRecognizedEvent().getPlateColor());
                }
                if (cost.getPeriod_multi_start() != null) {
                    returnMap.put("periodMulti", "Y");
                    returnMap.put("periodMultiStart", df.format(cost.getPeriod_multi_start()));
                    returnMap.put("periodMultiReceived", cost.getPeriod_multi_received().toString());
                    if (cost.getNext_period_multi_start() != null && cost.getNext_period_multi_start().getTime() != cost.getPeriod_multi_start().getTime() && cost.getNext_period_multi_cur() != null && cost.getNext_period_multi_cur().doubleValue() > 0.0) {
                        returnMap.put("newPeriodMultiStart", df.format(cost.getNext_period_multi_start()));
                        returnMap.put("newPeriodMultiAmount", cost.getNext_period_multi_cur().toString());
                    }
                } else {
                    returnMap.put("periodMulti", "N");
                }
                if ((takeChargeRecord = (CarparkPresenceRecord)passSession.getAttribute("takeChargeRecord")) != null) {
                    if (takeChargeRecord.getEnter_plate() != null && !takeChargeRecord.getEnter_plate().equals(queryFee.getPlate_number())) {
                        returnMap.put("takeSpacePlate", takeChargeRecord.getEnter_plate());
                    }
                } else if (enterRecord.getEnter_time() != null && enterRecord.getOccupy_end_time() != null && enterRecord.getOccupy_passport_type_no() != null && enterRecord.getOccupy_passport_type_no().length() > 0 && enterRecord.getOccupy_plate() != null && !enterRecord.getOccupy_passport_type_no().equals(passSession.getPassportType().getPassport_type_no()) && (pt = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(enterRecord.getOccupy_passport_type_no())) != null) {
                    returnMap.put("occupyPassType", pt.getPass_type().toString());
                    returnMap.put("occupyPassTypeNo", pt.getPassport_type_no());
                    returnMap.put("occupyPassTypeName", pt.getPassport_type_name());
                    returnMap.put("occupyPlate", enterRecord.getOccupy_plate());
                    returnMap.put("occupyStartTime", df.format(enterRecord.getEnter_time()));
                    returnMap.put("occupyEndTime", df.format(enterRecord.getOccupy_end_time()));
                }
                if (cost.getAlready_paid().doubleValue() > 0.0 && cost.getAlready_paid_time() != null) {
                    returnMap.put("lastPaidTime", df.format(cost.getAlready_paid_time()));
                }
                String sv = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("MAXSTAY_TIME_LENGTH");
                int maxAllowMinus = 15;
                try {
                    if (sv != null && sv.length() > 0) {
                        maxAllowMinus = Integer.parseInt(sv);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (maxAllowMinus <= 0) {
                    maxAllowMinus = 15;
                }
                returnMap.put("maxAllowMinus", String.valueOf(maxAllowMinus));
                returnMap.put("exitChannelNo", passSession.getPassChannel().getChannel().getChannel_no());
                returnMap.put("exitChannelName", passSession.getPassChannel().getChannel().getChannel_name());
                int parkingTimeMins = ServiceUtil.getMins(enterRecord.getEnter_time(), passTime);
                returnMap.put("parkingTimeMins", String.valueOf(parkingTimeMins));
                returnMap.put("parkingTimeDes", applicationService.getTimeLenDes(parkingTimeMins));
                if (ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap().size() > 1 && cost.getAreaChargeLenList() != null && !cost.getAreaChargeLenList().isEmpty()) {
                    for (Map<String, String> sx : cost.getAreaChargeLenList()) {
                        try {
                            sx.put("parkLenDes", applicationService.getTimeLenDes(Integer.parseInt(sx.get("parkLen"))));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    returnMap.put("aclj", GsonBuilder.create().toJson(cost.getAreaChargeLenList()));
                }
                returnMap.put("needFeeOrder", "1");
                returnMap.put(RETURN_CODE, "0");
                returnMap.put(RETURN_MSG, "\u9700\u8981\u4ea4\u8d39");
            } else if (passSession.getAttribute("PRE_ENTRY_RECORD_ID") != null) {
                returnMap = CommonRemoteServiceImpl.setEnterChargeFee(passSession, returnMap);
            } else if (passSession.getAttribute("ESCAPE_ORDER") != null) {
                CarparkEscapeOrder escapeOrder = (CarparkEscapeOrder)passSession.getAttribute("ESCAPE_ORDER");
                applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                CarparkQueryFee queryFee = new CarparkQueryFee();
                queryFee.setQuery_time(ServiceUtil.getNow());
                queryFee.setPassport_number(escapeOrder.getPassport_number());
                queryFee.setMedium_type(escapeOrder.getMedium_type());
                queryFee.setEnter_time(escapeOrder.getEnter_time());
                queryFee.setPlate_number(escapeOrder.getPass_plate());
                queryFee.setEnter_record_no(escapeOrder.getEnter_record_no());
                queryFee.setCharge_start_time(escapeOrder.getEnter_time());
                queryFee.setShould_charge(cost.getShouldCharged());
                queryFee.setActual_charge_amount(cost.getActualCharge());
                queryFee.setDiscount_money(cost.getDiscountMoney());
                queryFee.setAlready_paid(cost.getAlready_paid());
                queryFee.setPeriod_multi_start(cost.getPeriod_multi_start());
                queryFee.setPeriod_multi_received(cost.getPeriod_multi_received());
                queryFee.setPeriod_multi_free(cost.getPeriod_multi_free());
                queryFee.setNext_period_multi_start(cost.getNext_period_multi_start());
                queryFee.setNext_period_multi_cur(cost.getNext_period_multi_cur());
                if (cost.getChargeTimeMinutes() <= 0) {
                    queryFee.setCharge_time_length(0);
                } else {
                    queryFee.setCharge_time_length(cost.getChargeTimeMinutes());
                }
                queryFee.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                queryFee.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                String operate_user_code = (String)returnMap.get("operate_user_code");
                if (operate_user_code == null || operate_user_code.length() == 0) {
                    operate_user_code = "USER_SELF";
                }
                queryFee.setOperate_user_code(operate_user_code);
                String operate_user_name = (String)returnMap.get("operate_user_name");
                if (operate_user_name == null || operate_user_name.length() == 0) {
                    operate_user_name = "\u81ea\u52a9\u7f34\u8d39";
                }
                queryFee.setOperate_user_name(operate_user_name);
                String duty_no = (String)returnMap.get("duty_no");
                if (duty_no == null || duty_no.length() == 0) {
                    duty_no = "0";
                }
                queryFee.setDuty_no(duty_no);
                queryFee.setHost_no(ServiceUtil.getServiceContext().getLocalHostNo());
                queryFee.setHost_name(ServiceUtil.getServiceContext().getLocalHost().getHost_name());
                queryFee.setPassport_no(escapeOrder.getPassport_no());
                queryFee.setPass_type(escapeOrder.getPass_type());
                queryFee.setPassport_type_no(escapeOrder.getPassport_type_no());
                queryFee.setPassport_type_name(escapeOrder.getPassport_type_name());
                queryFee.setCar_type_no(escapeOrder.getExit_car_type_no());
                queryFee.setCar_type_name(escapeOrder.getExit_car_type_name());
                queryFee.setTran_area_no(escapeOrder.getArea_no());
                queryFee.setTran_area_name(escapeOrder.getArea_name());
                queryFee.setTran_channel_no(passSession.getPassChannel().getChannel().getChannel_no());
                queryFee.setTran_channel_name(passSession.getPassChannel().getChannel().getChannel_name());
                queryFee.setTran_user_no(escapeOrder.getCar_owner_no());
                queryFee.setTran_user_name(escapeOrder.getCar_owner_name());
                queryFee.setEnter_pay(2);
                queryFee.setExit_record_no(escapeOrder.getExit_record_no());
                queryFee.setExit_time(escapeOrder.getExit_time());
                CommonRemoteServiceImpl.setQueryFeeDicount(cost, queryFee);
                returnMap.put("carparkQeuryFee", GsonBuilder.create().toJson((Object)queryFee));
                returnMap.put("plateNumber", queryFee.getPlate_number());
                returnMap.put("passportNumber", queryFee.getPassport_number());
                returnMap.put("mediumType", queryFee.getMedium_type().toString());
                returnMap.put("enterTime", df.format(queryFee.getEnter_time()));
                returnMap.put("enterRecordNo", queryFee.getEnter_record_no());
                if (escapeOrder.getPass_type() != null) {
                    returnMap.put("passType", escapeOrder.getPass_type().toString());
                }
                returnMap.put("exitTime", df.format(queryFee.getExit_time()));
                returnMap.put("chargeEndTime", df.format(queryFee.getExit_time()));
                returnMap.put("passTypeNo", escapeOrder.getPassport_type_no());
                returnMap.put("passTypeName", escapeOrder.getPassport_type_name());
                returnMap.put("carTypeNo", escapeOrder.getExit_car_type_no());
                returnMap.put("carTypeName", escapeOrder.getExit_car_type_name());
                returnMap.put("parkName", ServiceUtil.getServiceContext().getCarpark().getCarpark_name());
                returnMap.put("areaNo", escapeOrder.getArea_no());
                returnMap.put("areaName", escapeOrder.getArea_name());
                returnMap.put("areaLevel", escapeOrder.getArea_level().toString());
                returnMap.put("shouldCharge", cost.getShouldCharged().toString());
                returnMap.put("disountFee", cost.getDeduct_money().toString());
                returnMap.put("periodMultiFree", cost.getPeriod_multi_free().toString());
                returnMap.put("alreadyPaid", cost.getAlready_paid().toString());
                returnMap.put("actualCharge", cost.getActualCharge().toString());
                returnMap.put("passChannelNo", passSession.getPassChannel().getChannel().getChannel_no());
                returnMap.put("passChannelName", passSession.getPassChannel().getChannel().getChannel_name());
                returnMap.put("enterChannelNo", escapeOrder.getEnter_channel_no());
                returnMap.put("enterChannelName", escapeOrder.getEnter_channel_name());
                returnMap.put("exitChannelNo", escapeOrder.getExit_channel_no());
                returnMap.put("exitChannelName", escapeOrder.getExit_channel_name());
                if (escapeOrder.getExit_car_pic() != null && escapeOrder.getExit_car_pic().length() > 0) {
                    returnMap.put("exitCarPic", escapeOrder.getExit_car_pic());
                }
                if (escapeOrder.getEnter_car_pic() != null && escapeOrder.getEnter_car_pic().length() > 0) {
                    returnMap.put("enterCarPic", escapeOrder.getEnter_car_pic());
                }
                CommonRemoteServiceImpl.setDicountListToQueryMap(cost, returnMap);
                Date chargeStartTime = queryFee.getCharge_start_time();
                returnMap.put("chargeStartTime", df.format(chargeStartTime));
                int chargeLenMinus = cost.getChargeTimeMinutes();
                returnMap.put("chargeLenMinus", String.valueOf(chargeLenMinus));
                returnMap.put("chargeLenDes", applicationService.getTimeLenDes(chargeLenMinus));
                int parkingTimeMins = ServiceUtil.getMins(escapeOrder.getEnter_time(), escapeOrder.getExit_time());
                returnMap.put("parkingTimeMins", String.valueOf(parkingTimeMins));
                returnMap.put("parkingTimeDes", applicationService.getTimeLenDes(parkingTimeMins));
                if (cost.getPeriod_multi_start() != null) {
                    returnMap.put("periodMulti", "Y");
                    returnMap.put("periodMultiStart", df.format(cost.getPeriod_multi_start()));
                    returnMap.put("periodMultiReceived", cost.getPeriod_multi_received().toString());
                    if (cost.getNext_period_multi_start() != null && cost.getNext_period_multi_start().getTime() != cost.getPeriod_multi_start().getTime() && cost.getNext_period_multi_cur() != null && cost.getNext_period_multi_cur().doubleValue() > 0.0) {
                        returnMap.put("newPeriodMultiStart", df.format(cost.getNext_period_multi_start()));
                        returnMap.put("newPeriodMultiAmount", cost.getNext_period_multi_cur().toString());
                    }
                } else {
                    returnMap.put("periodMulti", "N");
                }
                if (cost.getAlready_paid().doubleValue() > 0.0 && cost.getAlready_paid_time() != null) {
                    returnMap.put("lastPaidTime", df.format(cost.getAlready_paid_time()));
                }
                returnMap.put("maxAllowMinus", "15");
                returnMap.put("needFeeOrder", "1");
                returnMap.put("enterPay", "2");
                returnMap.put(RETURN_CODE, "0");
                returnMap.put(RETURN_MSG, "\u6b20\u8d39\u8865\u4ea4");
            }
        } else {
            String plateNumer = passSession.getPassPlate();
            String msg = "\u503c\u73ed\u5458\u6b63\u5728\u786e\u8ba4 " + plateNumer + " \u653e\u884c\u4fe1\u606f\uff0c\u8bf7\u7b49\u5f85";
            if (channelArea != null && channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                CarparkPresenceRecord enterRecord = CommonRemoteServiceImpl.getEnterRecord(passSession);
                if (enterRecord == null) {
                    returnMap.put(RETURN_CODE, "2");
                    returnMap.put(RETURN_MSG, msg);
                } else {
                    CommonRemoteServiceImpl.setExitCostPassSessionResult(passSession, returnMap);
                    returnMap.put(RETURN_CODE, "1");
                    returnMap.put(RETURN_MSG, msg);
                }
            } else {
                returnMap.put(RETURN_CODE, "1");
                returnMap.put(RETURN_MSG, msg);
            }
        }
        return returnMap;
    }

    public static Map<String, Object> setExitCostPassSessionResult(PassSession passSession, Map<String, Object> returnMap) {
        CarparkPresenceRecord enterRecord;
        if (returnMap == null) {
            returnMap = new HashMap<String, Object>();
        }
        if (passSession == null) {
            return returnMap;
        }
        ChannelArea channelArea = (ChannelArea)passSession.getAttribute("channelArea");
        if (channelArea != null && channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty() && (enterRecord = CommonRemoteServiceImpl.getEnterRecord(passSession)) != null) {
            int chargeLenMinus;
            Cost cost = (Cost)passSession.getAttribute("pass_cost");
            if (cost == null) {
                cost = new Cost();
            }
            String sv = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("MAXSTAY_TIME_LENGTH");
            int maxAllowMinus = 15;
            try {
                if (sv != null && sv.length() > 0) {
                    maxAllowMinus = Integer.parseInt(sv);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (maxAllowMinus <= 0) {
                maxAllowMinus = 15;
            }
            returnMap.put("maxAllowMinus", String.valueOf(maxAllowMinus));
            returnMap.put("exitChannelNo", passSession.getPassChannel().getChannel().getChannel_no());
            returnMap.put("exitChannelName", passSession.getPassChannel().getChannel().getChannel_name());
            returnMap.put("plateNumber", passSession.getPassPlate());
            returnMap.put("passportNumber", passSession.getPassport().getPassport_number());
            if (passSession.getPassport().getMedium_type() != null) {
                returnMap.put("mediumType", passSession.getPassport().getMedium_type().toString());
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            returnMap.put("enterTime", df.format(enterRecord.getEnter_time()));
            returnMap.put("enterRecordNo", enterRecord.getEnter_record_no());
            returnMap.put("enterChannelNo", enterRecord.getEnter_channel_no());
            returnMap.put("enterChannelName", enterRecord.getEnter_channel_name());
            returnMap.put("passType", passSession.getPassportType().getPass_type().toString());
            returnMap.put("passTypeNo", passSession.getPassportType().getPassport_type_no());
            returnMap.put("passTypeName", passSession.getPassportType().getPassport_type_name());
            returnMap.put("carTypeNo", passSession.getCarType().getCar_type_no());
            returnMap.put("carTypeName", passSession.getCarType().getCar_type_name());
            returnMap.put("parkName", ServiceUtil.getServiceContext().getCarpark().getCarpark_name());
            returnMap.put("areaNo", enterRecord.getArea_no());
            returnMap.put("areaName", enterRecord.getArea_name());
            if (enterRecord.getArea_level() != null) {
                returnMap.put("areaLevel", enterRecord.getArea_level().toString());
            }
            returnMap.put("shouldCharge", cost.getShouldCharged().toString());
            returnMap.put("disountFee", cost.getDeduct_money().toString());
            returnMap.put("periodMultiFree", cost.getPeriod_multi_free().toString());
            returnMap.put("alreadyPaid", cost.getAlready_paid().toString());
            returnMap.put("actualCharge", cost.getActualCharge().toString());
            Date chargeStartTime = cost.getCharge_start_time();
            if (chargeStartTime == null) {
                chargeStartTime = enterRecord.getEnter_time();
            }
            if (chargeStartTime != null) {
                returnMap.put("chargeStartTime", df.format(chargeStartTime));
            }
            if ((chargeLenMinus = cost.getChargeTimeMinutes()) < 0) {
                chargeLenMinus = 0;
            }
            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            returnMap.put("chargeLenMinus", String.valueOf(chargeLenMinus));
            returnMap.put("chargeLenDes", applicationService.getTimeLenDes(chargeLenMinus));
            Date passTime = (Date)passSession.getAttribute("passTime");
            if (passTime == null) {
                passTime = ServiceUtil.getNow();
            }
            returnMap.put("exitTime", df.format(passTime));
            returnMap.put("chargeEndTime", df.format(passTime));
            int paringMins = ServiceUtil.getMins(enterRecord.getEnter_time(), passTime);
            returnMap.put("parkingTimeMins", String.valueOf(paringMins));
            returnMap.put("parkingTimeDes", applicationService.getTimeLenDes(paringMins));
            returnMap.put("parkingTimelen", String.valueOf(paringMins));
            if (ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap().size() > 1 && cost.getAreaChargeLenList() != null && !cost.getAreaChargeLenList().isEmpty()) {
                for (Map<String, String> sx : cost.getAreaChargeLenList()) {
                    try {
                        sx.put("parkLenDes", applicationService.getTimeLenDes(Integer.parseInt(sx.get("parkLen"))));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                returnMap.put("aclj", GsonBuilder.create().toJson(cost.getAreaChargeLenList()));
            }
            CommonRemoteServiceImpl.setDicountListToQueryMap(cost, returnMap);
        }
        return returnMap;
    }

    private static CarparkPresenceRecord getEnterRecord(PassSession passSession) {
        CarparkArea exitArea = (CarparkArea)passSession.getAttribute("PASS_EXIT_AREA");
        Map areaPresenceRecordMap = (Map)passSession.getAttribute("areaPresenceRecordMap");
        CarparkPresenceRecord enterRecord = null;
        if (areaPresenceRecordMap != null && !areaPresenceRecordMap.isEmpty() && exitArea != null) {
            enterRecord = (CarparkPresenceRecord)areaPresenceRecordMap.get(exitArea.getArea_no());
        }
        return enterRecord;
    }

    @Override
    public ResultResponse invoiceSuccess(CarparkInvoiceOrder invoiceOrder, Map<String, Object> context) throws Exception {
        ResultResponse r = new ResultResponse();
        try {
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            long count = daoService.selectCount(new SearchParam(daoService.getTableName(CarparkInvoiceOrder.class)).addEQ("invoice_order_no", (Object)invoiceOrder.getInvoice_order_no()));
            if (count == 0L) {
                try (SqlSession session = daoService.openSqlSession();){
                    try {
                        daoService.insert(session, (Object)invoiceOrder);
                        if (invoiceOrder.getCloudOrderNos() != null && !invoiceOrder.getCloudOrderNos().isEmpty()) {
                            CommonParam updateP = new CommonParam(daoService.getTableName(CarparkTransaction.class));
                            if (invoiceOrder.getCloudOrderNos().size() == 1) {
                                updateP.addEQ("order_no", (Object)invoiceOrder.getCloudOrderNos().get(0));
                            } else {
                                updateP.addINList("order_no", invoiceOrder.getCloudOrderNos());
                            }
                            updateP.addUpdate("invoice_status", (Object)2);
                            updateP.addUpdate("invoice_cloud_no", (Object)invoiceOrder.getInvoice_cloud_no());
                            daoService.update(session, updateP);
                        }
                        session.commit();
                    }
                    catch (Exception ex) {
                        session.rollback();
                        throw ex;
                    }
                }
            }
            r.setResponseCode("0");
            r.setResponseMsg("success");
        }
        catch (Throwable e) {
            r.setResponseCode("1");
            r.setResponseMsg("\u64cd\u4f5c\u5931\u8d25,\u8fdc\u7a0b\u5f02\u5e38:" + e.getMessage());
            ServiceLog.getLog().warn((Object)"\u5904\u7406\u7535\u5b50\u53d1\u7968\u8ba2\u5355\u5f02\u5e38\uff01", e);
        }
        return r;
    }

    @Override
    public ResultResponse invoiceOfflineSuccess(Map<String, String> paramMap, Map<String, Object> context) throws Exception {
        ResultResponse r = new ResultResponse();
        try {
            Long tranId = Long.valueOf(paramMap.get("tranId"));
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            CommonParam updateP = new CommonParam(daoService.getTableName(CarparkTransaction.class));
            updateP.addEQ("id", (Object)tranId);
            updateP.addUpdate("invoice_status", (Object)1);
            daoService.update(updateP);
            r.setResponseCode("0");
            r.setResponseMsg("success");
        }
        catch (Throwable e) {
            r.setResponseCode("1");
            r.setResponseMsg("\u64cd\u4f5c\u5931\u8d25,\u8fdc\u7a0b\u5f02\u5e38:" + e.getMessage());
            ServiceLog.getLog().warn((Object)"\u5904\u7406\u7535\u5b50\u53d1\u7968\u8ba2\u5355\u5f02\u5e38\uff01", e);
        }
        return r;
    }

    @Override
    public Map<String, Object> doScanCodePay(Map<String, Object> paramMap, Map<String, Object> context) throws Exception {
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        Map<String, Object> resultMap = applicationService.doServerScanCodePay(paramMap);
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        return resultMap;
    }

    @Override
    public Map<String, Object> doQueryScanPaySate(Map<String, Object> paramMap, Map<String, Object> context) throws Exception {
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        Map<String, Object> resultMap = applicationService.doServerQueryScanPayState(paramMap);
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        return resultMap;
    }

    @Override
    public Map<String, Object> doCancelScanPayOrder(Map<String, Object> paramMap, Map<String, Object> context) throws Exception {
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        Map<String, Object> resultMap = applicationService.doServerCancelScanPay(paramMap);
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        return resultMap;
    }

    @Override
    public Map<String, Object> proxyExeDispathTask(Map<String, Object> paramMap, Map<String, Object> context) throws Exception {
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config.getHost_use() == 1) {
            ServiceLog.getLog().warn((Object)("\u672c\u673a\u4e3a\u5c97\u4ead\u5ba2\u6237\u7aef\uff0c\u4e0d\u5e94\u8be5\u6709\u7a0b\u5e8f\u8fdc\u7a0b\u8c03\u7528\u6b64\u5b9e\u73b0\uff01\u4e22\u5f03\uff1a" + paramMap));
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            return resultMap;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        String taskListJson = (String)paramMap.get("dispatchTaskList");
        List taskList = (List)GsonBuilder.create().fromJson(taskListJson, new TypeToken<List<CarparkDispatchTask>>(){}.getType());
        LinkedList<CarparkDispatchTask> exeTaskList = new LinkedList<CarparkDispatchTask>();
        if (taskList != null && !taskList.isEmpty()) {
            String localHostNo = ServiceUtil.getServiceContext().getLocalHostNo();
            Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
            Date now = ServiceUtil.getNow();
            for (CarparkDispatchTask t : taskList) {
                if (t.getHost_no() == null || t.getHost_no().length() == 0 || t.getJson_data() == null || t.getJson_data().length() == 0 || t.getService_name() == null || t.getService_name().length() == 0 || localHostNo.equals(t.getHost_no())) continue;
                if (!hostMap.containsKey(t.getHost_no())) {
                    ServiceLog.getLog().warn((Object)("\u65e0\u6548\u6307\u6d3e\u4e3b\u673a\uff1a" + t.getHost_no() + ",\u8fd9\u5c06\u4e22\u5f03\u4efb\u52a1\uff1a" + t.getService_name() + ", " + t.getJson_data()));
                    continue;
                }
                t.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                t.setCreated_time(now);
                t.setId(commonDaoService.getSequece("ck_carpark_dispatch_task_seq"));
                t.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                exeTaskList.add(t);
            }
        }
        if (exeTaskList != null && !exeTaskList.isEmpty()) {
            try (SqlSession session = commonDaoService.openSqlSession();){
                try {
                    for (CarparkDispatchTask task : exeTaskList) {
                        commonDaoService.insert(session, (Object)task);
                    }
                    session.commit();
                }
                catch (Exception ex) {
                    session.rollback();
                    throw ex;
                }
            }
            ApplicationService appSrvice = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            appSrvice.asynTryRunDispatchTask(exeTaskList);
        }
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> syncLocalCartypeMer(Map<String, String> paramMap, Map<String, Object> context) throws Exception {
        block14: {
            String car_type_no = paramMap.get("car_type_no");
            String plate_number = paramMap.get("plate_number");
            if (car_type_no != null && car_type_no.length() > 0 && plate_number != null && plate_number.length() > 0) {
                String last_updated_time0 = paramMap.get("last_updated_time");
                Date last_updated_time = null;
                if (last_updated_time0 != null && last_updated_time0.length() > 0) {
                    last_updated_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(last_updated_time0);
                }
                if (last_updated_time == null) {
                    last_updated_time = ServiceUtil.getNow();
                }
                String lockkey = "handleMpdofyPlateCarType_" + plate_number;
                KeyLockManager keyLockManager = ServiceUtil.getServiceContext().getKeyLockManager();
                Object lock = keyLockManager.getLock(lockkey);
                try {
                    try {
                        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                        Object object = lock;
                        synchronized (object) {
                            CarparkPlateCarType platecarType = (CarparkPlateCarType)commonDaoService.selectOne(new SearchParam().addEQ("plate_number", (Object)plate_number), CarparkPlateCarType.class);
                            if (platecarType == null) {
                                platecarType = new CarparkPlateCarType();
                                platecarType.setCar_type_no(car_type_no);
                                platecarType.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                                platecarType.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                                long plateCarTypeid = appService.createLocalRecordSeq("ck_carpark_plate_car_type_seq");
                                platecarType.setId(plateCarTypeid);
                                platecarType.setLast_updated_time(last_updated_time);
                                platecarType.setPlate_number(plate_number);
                                commonDaoService.insert((Object)platecarType);
                            } else {
                                Date d = platecarType.getLast_updated_time();
                                if (d == null || d.getTime() <= last_updated_time.getTime()) {
                                    CommonParam p = new CommonParam(commonDaoService.getTableName(CarparkPlateCarType.class));
                                    p.addEQ("plate_number", (Object)plate_number);
                                    p.addUpdate("last_updated_time", (Object)last_updated_time);
                                    p.addUpdate("car_type_no", (Object)car_type_no);
                                    commonDaoService.update(p);
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                        keyLockManager.releaseLock(lock);
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    keyLockManager.releaseLock(lock);
                    throw throwable;
                }
                keyLockManager.releaseLock(lock);
            }
        }
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        return resultMap;
    }

    @Override
    public Map<String, Object> doSenselessPay(Map<String, Object> paramMap, Map<String, Object> context) throws Exception {
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        Map<String, Object> resultMap = applicationService.doServerSenselessPay(paramMap);
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        return resultMap;
    }

    @Override
    public Map<String, Object> triggerCameraOpenPole(Map<String, String> paramMap, Map<String, Object> context) {
        String opMsg;
        String camera_no = paramMap.get("camera_no");
        String op_soruce = paramMap.get("op_soruce");
        String op_sourceName = "0".equals(op_soruce) ? "\u5c40\u57df\u7f51\u8fdc\u7a0b\u8c03\u7528" : ("1".equals(op_soruce) ? "\u4e91\u7aef\u8fdc\u7a0b\u8c03\u7528" : ("2".equals(op_soruce) ? "\u7b2c\u4e09\u65b9\u7a0b\u5e8f\u8fdc\u7a0b\u8c03\u7528" : "\u8fdc\u7a0b\u8c03\u7528"));
        if (camera_no == null || camera_no.length() == 0) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "PARAM_ERROR");
            resultMap.put("opMsg", "\u7f3a\u5c11\u53c2\u6570\uff1a" + camera_no);
            return resultMap;
        }
        Equipment eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(camera_no);
        if (eq == null) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "OP_ERROR");
            resultMap.put("opMsg", "\u65e0\u6548\u76f8\u673a\u7f16\u53f7,\u6216\u975e\u672c\u673a\u7ba1\u7406\u76f8\u673a\u7f16\u53f7");
            return resultMap;
        }
        if (eq.getType() != 33) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "OP_ERROR");
            resultMap.put("opMsg", "\u65e0\u6548\u76f8\u673a\u7f16\u53f7");
            return resultMap;
        }
        Object action = eq.getEquipmentAction();
        if (!(action instanceof RoadBarrierAction)) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "OP_ERROR");
            resultMap.put("opMsg", "\u8be5\u76f8\u673a\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
            return resultMap;
        }
        boolean success = false;
        RoadBarrierAction raction = (RoadBarrierAction)action;
        OperationFuture<Integer> opF = raction.doRaisePoleAction();
        try {
            Integer a1 = (Integer)opF.get(5L, TimeUnit.SECONDS);
            if (a1 == null) {
                opMsg = "\u64cd\u4f5c\u8d85\u65f6";
            } else if (a1 == 0) {
                success = true;
                opMsg = "\u64cd\u4f5c\u6210\u529f";
            } else {
                opMsg = "\u64cd\u4f5c\u5931\u8d25";
            }
        }
        catch (Exception ex) {
            if (opF.getException() != null) {
                opMsg = opF.getException() instanceof TimeoutException ? "\u64cd\u4f5c\u8d85\u65f6" : "\u64cd\u4f5c\u5931\u8d25\uff01\u539f\u56e0\uff1a" + opF.getException().getMessage();
            }
            String cause = ex.getMessage();
            if (cause == null || cause.length() == 0) {
                cause = "\u672a\u77e5";
            }
            opMsg = "\u64cd\u4f5c\u5931\u8d25\uff01\u539f\u56e0\uff1a" + cause;
        }
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        if (success) {
            resultMap.put("opType", "SUCCESS");
            resultMap.put("opMsg", "\u64cd\u4f5c\u6210\u529f");
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(op_sourceName) + "\u5bf9\u8f66\u724c\u8bc6\u522b\u76f8\u673a " + eq.getName() + "[" + eq.getIp() + "] \u8fdb\u884c\u4e86\u4e00\u6b21\u8d77\u6746\u64cd\u4f5c", 1));
        } else {
            resultMap.put("opType", "OP_ERROR");
            resultMap.put("opMsg", opMsg);
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> triggerCameraDownPole(Map<String, String> paramMap, Map<String, Object> context) {
        String opMsg;
        String camera_no = paramMap.get("camera_no");
        String op_soruce = paramMap.get("op_soruce");
        String op_sourceName = "0".equals(op_soruce) ? "\u5c40\u57df\u7f51\u8fdc\u7a0b\u8c03\u7528\u5f00\u95f8" : ("1".equals(op_soruce) ? "\u4e91\u7aef\u8fdc\u7a0b\u8c03\u7528\u5f00\u95f8" : ("2".equals(op_soruce) ? "\u7b2c\u4e09\u65b9\u7a0b\u5e8f\u8fdc\u7a0b\u8c03\u7528\u5f00\u95f8" : "\u8fdc\u7a0b\u8c03\u7528\u5f00\u95f8"));
        if (camera_no == null || camera_no.length() == 0) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "PARAM_ERROR");
            resultMap.put("opMsg", "\u7f3a\u5c11\u53c2\u6570\uff1a" + camera_no);
            return resultMap;
        }
        Equipment eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(camera_no);
        if (eq == null) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "OP_ERROR");
            resultMap.put("opMsg", "\u65e0\u6548\u76f8\u673a\u7f16\u53f7,\u6216\u975e\u672c\u673a\u7ba1\u7406\u76f8\u673a\u7f16\u53f7");
            return resultMap;
        }
        if (eq.getType() != 33) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "OP_ERROR");
            resultMap.put("opMsg", "\u65e0\u6548\u76f8\u673a\u7f16\u53f7");
            return resultMap;
        }
        Object action = eq.getEquipmentAction();
        if (!(action instanceof RoadBarrierAction)) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "OP_ERROR");
            resultMap.put("opMsg", "\u8be5\u76f8\u673a\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
            return resultMap;
        }
        boolean success = false;
        RoadBarrierAction raction = (RoadBarrierAction)action;
        OperationFuture<Integer> opF = raction.doDownPoleAction();
        try {
            Integer a1 = (Integer)opF.get(5L, TimeUnit.SECONDS);
            if (a1 == null) {
                opMsg = "\u64cd\u4f5c\u8d85\u65f6";
            } else if (a1 == 0) {
                success = true;
                opMsg = "\u64cd\u4f5c\u6210\u529f";
            } else {
                opMsg = "\u64cd\u4f5c\u5931\u8d25";
            }
        }
        catch (Exception ex) {
            if (opF.getException() != null) {
                opMsg = opF.getException() instanceof TimeoutException ? "\u64cd\u4f5c\u8d85\u65f6" : "\u64cd\u4f5c\u5931\u8d25\uff01\u539f\u56e0\uff1a" + opF.getException().getMessage();
            }
            String cause = ex.getMessage();
            if (cause == null || cause.length() == 0) {
                cause = "\u672a\u77e5";
            }
            opMsg = "\u64cd\u4f5c\u5931\u8d25\uff01\u539f\u56e0\uff1a" + cause;
        }
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        if (success) {
            resultMap.put("opType", "SUCCESS");
            resultMap.put("opMsg", "\u64cd\u4f5c\u6210\u529f");
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(op_sourceName) + "\u5bf9\u8f66\u724c\u8bc6\u522b\u76f8\u673a " + eq.getName() + "[" + eq.getIp() + "] \u8fdb\u884c\u4e86\u4e00\u6b21\u843d\u6746\u64cd\u4f5c", 1));
            List<String> channelIst = eq.getChannelNos();
            if (channelIst != null && !channelIst.isEmpty()) {
                String channelNo = channelIst.get(0);
                final PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
                if (passChannel != null) {
                    String userCode = "ORTHER_APP_USER_CODE";
                    String userName = "\u7b2c\u4e09\u65b9\u5e94\u7528";
                    final String des = op_sourceName;
                    ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                        @Override
                        public void run() {
                            PassSession cancelSession = passChannel.getLastSession();
                            String plate = null;
                            if (cancelSession != null && cancelSession.getSessionState() == PassSession.SessionState.CANCELED) {
                                plate = cancelSession.getPassPlate();
                            }
                            passChannel.exceptionPass(false, 0, "0", des, plate, "ORTHER_APP_USER_CODE", "\u7b2c\u4e09\u65b9\u5e94\u7528");
                            if (cancelSession != null && cancelSession.getSessionState() == PassSession.SessionState.CANCELED) {
                                cancelSession.setSessionState(PassSession.SessionState.CAR_LEAVING);
                            }
                        }
                    });
                }
            }
        } else {
            resultMap.put("opType", "OP_ERROR");
            resultMap.put("opMsg", opMsg);
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> triggerCameraSoftReg(Map<String, String> paramMap, Map<String, Object> context) {
        String opMsg;
        String camera_no = paramMap.get("camera_no");
        String op_soruce = paramMap.get("op_soruce");
        final String op_sourceName = "0".equals(op_soruce) ? "\u5c40\u57df\u7f51\u8fdc\u7a0b\u8c03\u7528" : ("1".equals(op_soruce) ? "\u4e91\u7aef\u8fdc\u7a0b\u8c03\u7528" : ("2".equals(op_soruce) ? "\u7b2c\u4e09\u65b9\u7a0b\u5e8f\u8fdc\u7a0b\u8c03\u7528" : "\u8fdc\u7a0b\u8c03\u7528"));
        if (camera_no == null || camera_no.length() == 0) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "PARAM_ERROR");
            resultMap.put("opMsg", "\u7f3a\u5c11\u53c2\u6570\uff1a" + camera_no);
            return resultMap;
        }
        final Equipment eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(camera_no);
        if (eq == null) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "OP_ERROR");
            resultMap.put("opMsg", "\u65e0\u6548\u76f8\u673a\u7f16\u53f7,\u6216\u975e\u672c\u673a\u7ba1\u7406\u76f8\u673a\u7f16\u53f7");
            return resultMap;
        }
        if (eq.getType() != 33) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "OP_ERROR");
            resultMap.put("opMsg", "\u65e0\u6548\u76f8\u673a\u7f16\u53f7");
            return resultMap;
        }
        Object action = eq.getEquipmentAction();
        if (!(action instanceof PlateRegCameraAction)) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "OP_ERROR");
            resultMap.put("opMsg", "\u8be5\u76f8\u673a\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
            return resultMap;
        }
        final String key = String.valueOf(eq.getChannelNos().get(0)) + "_" + eq.getEquipmentNo() + "_triggerRegPlate";
        ObjectCreateCallback<String> regPlateCallback = new ObjectCreateCallback<String>(){

            public void createSuccess(String plateNo) {
                eq.removeAttribute("waitTriggerRegPlate");
                String msg = String.valueOf(op_sourceName) + " \u5bf9\u8f66\u724c\u8bc6\u522b\u76f8\u673a " + eq.getName() + "[" + eq.getIp() + "]\u8fdb\u884c\u4e86\u8f6f\u89e6\u53d1\u64cd\u4f5c,\u6210\u529f\u8bc6\u522b\u8f66\u724c:" + plateNo;
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 1));
            }

            public void onException(Throwable arg0) {
                eq.removeAttribute("waitTriggerRegPlate");
            }
        };
        ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)key);
        ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)key, (Object)regPlateCallback, new TimeoutObjectPool.TimeoutCallback(){

            public void onTimeout(Object arg0, Object arg1) throws Exception {
                eq.removeAttribute("waitTriggerRegPlate");
            }
        }, 4000L, TimeUnit.MILLISECONDS);
        eq.setAttribute("waitTriggerRegPlate", ServiceUtil.getServiceContext().currentTimeMillis());
        boolean success = false;
        PlateRegCameraAction raction = (PlateRegCameraAction)action;
        OperationFuture<Integer> opF = raction.triggerRegPlate();
        opF.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void operationComplete(OperationFuture<Integer> x) {
                if (x.getException() != null || x.getResult() == null || (Integer)x.getResult() != 0) {
                    this.doErr();
                }
            }

            public void waitCompleteTimeout() {
                this.doErr();
            }

            private void doErr() {
                eq.removeAttribute("waitTriggerRegPlate");
                ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)key);
            }
        });
        try {
            Integer a1 = (Integer)opF.get(5L, TimeUnit.SECONDS);
            if (a1 == null) {
                opMsg = "\u64cd\u4f5c\u8d85\u65f6";
            } else if (a1 == 0) {
                success = true;
                opMsg = "\u64cd\u4f5c\u6210\u529f";
            } else {
                opMsg = "\u64cd\u4f5c\u5931\u8d25";
            }
        }
        catch (Exception ex) {
            if (opF.getException() != null) {
                opMsg = opF.getException() instanceof TimeoutException ? "\u64cd\u4f5c\u8d85\u65f6" : "\u64cd\u4f5c\u5931\u8d25\uff01\u539f\u56e0\uff1a" + opF.getException().getMessage();
            }
            String cause = ex.getMessage();
            if (cause == null || cause.length() == 0) {
                cause = "\u672a\u77e5";
            }
            opMsg = "\u64cd\u4f5c\u5931\u8d25\uff01\u539f\u56e0\uff1a" + cause;
        }
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        if (success) {
            resultMap.put("opType", "SUCCESS");
            resultMap.put("opMsg", "\u64cd\u4f5c\u6210\u529f");
        } else {
            resultMap.put("opType", "OP_ERROR");
            resultMap.put("opMsg", opMsg);
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> passConfirmOption(Map<String, String> paramMap, Map<String, Object> context) {
        String channel_no = paramMap.get("channel_no");
        String option = paramMap.get("option");
        if (channel_no == null || channel_no.length() == 0) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "PARAM_ERROR");
            resultMap.put("opMsg", "\u7f3a\u5c11\u53c2\u6570\uff1achannel_no");
            return resultMap;
        }
        if (option == null || option.length() == 0) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "PARAM_ERROR");
            resultMap.put("opMsg", "\u7f3a\u5c11\u53c2\u6570\uff1aoption");
            return resultMap;
        }
        if (!"0".equals(option) && !"1".equals(option)) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "PARAM_ERROR");
            resultMap.put("opMsg", "\u65e0\u6548option\u53c2\u6570\u503c\uff1a" + option);
            return resultMap;
        }
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channel_no);
        if (passChannel == null) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "SERVICE_ERROR");
            resultMap.put("opMsg", "\u901a\u9053\u4e0d\u5b58\u5728\uff01\u6216\u4e0d\u662f\u672c\u673a\u7ba1\u7406\u7684\u901a\u9053");
            return resultMap;
        }
        PassSession session = null;
        for (PassSession s : passChannel.getSessions()) {
            if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG || s.getReadPassportNumberEvent() == null || s.getReadPassportNumberEvent().isManualTrigger()) continue;
            session = s;
            break;
        }
        if (session == null) {
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            resultMap.put("responseCode", "0");
            resultMap.put("responseMsg", "SUCCESS");
            resultMap.put("opType", "NO_DIALOG");
            resultMap.put("opMsg", "\u6ca1\u6709\u8f66\u724c\u8bc6\u522b\u8981\u5904\u7406\u7684\u5f39\u6846");
            return resultMap;
        }
        String plate_number = session.getPassPlate();
        try {
            ServiceLog.getLog().info((Object)("\u901a\u9053:" + passChannel.getChannel().getChannel_name() + ", \u8f66\u724c:" + plate_number + ", \u63a5\u6536\u5230\u4e00\u4e2a\u8fdc\u7a0b\u64cd\u4f5c\u4fe1\u53f7\uff0c\u653e\u884c\u5df2 " + ("1".equals(option) ? "\u786e\u8ba4" : "\u53d6\u6d88")));
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(passChannel.getChannel().getChannel_name()) + ": \u653e\u884c\u8f66\u724c: " + plate_number + ", \u63a5\u6536\u5230\u4e00\u4e2a\u8fdc\u7a0b\u64cd\u4f5c: " + ("1".equals(option) ? "\u786e\u8ba4" : "\u53d6\u6d88") + "\u653e\u884c", 1));
        }
        finally {
            block26: {
                if ("1".equals(option)) {
                    try {
                        session.setAttribute("THIRD_INVOKE_PASS", Boolean.TRUE);
                        ServiceUtil.getServiceContext().getPassFilterChain().excecuteBehindPassFilters(session, session.getConfirmPassFilter());
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)"\u4fdd\u5b58\u653e\u884c\u6570\u636e\u5f02\u5e38\uff01", (Throwable)ex);
                        String message = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u653e\u884c\u5f02\u5e38\uff01\u5185\u90e8\u9519\u8bef\uff01";
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, message, 4));
                        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
                        resultMap.put("responseCode", "0");
                        resultMap.put("responseMsg", "SUCCESS");
                        resultMap.put("opType", "SAVE_PASS_DATA_ERROR");
                        resultMap.put("opMsg", "\u653e\u884c\u5931\u8d25! \u5185\u90e8\u9519\u8bef\uff0c\u4fdd\u5b58\u653e\u884c\u6570\u636e\u5f02\u5e38");
                        return resultMap;
                    }
                }
                try {
                    try {
                        if (session.getOpenDialogCacnelRecord() != null) {
                            session.doSaveCancelPassRecrodIfExist(true, true);
                        }
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().error((Object)"\u4fdd\u5b58\u53d6\u6d88\u53d1\u884c\u8bb0\u5f55\u5f02\u5e38");
                        session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                        session.setSessionState(PassSession.SessionState.CANCELED);
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                    session.setSessionState(PassSession.SessionState.CANCELED);
                    throw throwable;
                }
                session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                session.setSessionState(PassSession.SessionState.CANCELED);
            }
            ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
            if (callback != null) {
                callback.doClosePassDialog(session);
            }
        }
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        resultMap.put("opType", "SUCCESS");
        resultMap.put("opMsg", "\u64cd\u4f5c\u6210\u529f");
        resultMap.put("plate_number", plate_number);
        return resultMap;
    }

    @Override
    public void addSyncRecordDataListener(SyncRecordDataListener l) {
        this.syncRecordDataListeners.add(l);
    }

    @Override
    public void removeSyncRecordDataListener(SyncRecordDataListener l) {
        this.syncRecordDataListeners.remove(l);
    }

    @Override
    public Collection<SyncRecordDataListener> getSyncRecordDataListeners() {
        return this.syncRecordDataListeners;
    }

    @Override
    public Map<String, Object> channelOpenPole(Map<String, String> paramMap, Map<String, Object> context) {
        List<OperationFuture<Integer>> operationFuture;
        String opUserName;
        String channelNo = paramMap.get("channelNo");
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        if (channelNo == null || channelNo.length() == 0) {
            resultMap.put("returnCode", "403");
            resultMap.put("returnMsg", "\u7f3a\u5c11\u53c2\u6570\uff1achannelNo");
            return resultMap;
        }
        final PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel == null) {
            resultMap.put("returnCode", "501");
            resultMap.put("returnMsg", "\u4e0d\u662f\u672c\u673a\u7ba1\u7406\u7684\u901a\u9053");
            return resultMap;
        }
        String opUserCode = paramMap.get("opUserCode");
        if (opUserCode == null || opUserCode.length() == 0) {
            opUserCode = "USER_CLOUD_CODE";
        }
        if ((opUserName = paramMap.get("opUserName")) == null || opUserName.length() == 0) {
            opUserCode = "\u4e91\u7aef\u7528\u6237";
        }
        if ((operationFuture = passChannel.openPole(null)) == null || operationFuture.isEmpty()) {
            resultMap.put("returnCode", "501");
            resultMap.put("returnMsg", "\u8be5\u901a\u9053\u4e0b\u672a\u914d\u7f6e\u9053\u95f8");
            return resultMap;
        }
        String opDes = paramMap.get("opDes");
        if (opDes == null || opDes.length() == 0) {
            opDes = "\u4e91\u7aef\u8fdc\u7a0b\u5f00\u95f8";
        }
        boolean success = false;
        final String des = opDes;
        for (OperationFuture<Integer> f : operationFuture) {
            try {
                Integer ax = (Integer)f.get(5000L, TimeUnit.MILLISECONDS);
                if (ax != null && ax == 0) {
                    success = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (success) break;
        }
        if (success) {
            final String userCode = opUserCode;
            final String userName = opUserName;
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    PassSession cancelSession = passChannel.getLastSession();
                    String plate = null;
                    if (cancelSession != null && cancelSession.getSessionState() == PassSession.SessionState.CANCELED) {
                        plate = cancelSession.getPassPlate();
                    }
                    passChannel.exceptionPass(false, 0, "0", des, plate, userCode, userName);
                    if (cancelSession != null && cancelSession.getSessionState() == PassSession.SessionState.CANCELED) {
                        cancelSession.setSessionState(PassSession.SessionState.CAR_LEAVING);
                    }
                }
            });
            resultMap.put("returnCode", "0");
            resultMap.put("returnMsg", "\u5f00\u95f8\u6210\u529f");
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(passChannel.getChannel().getChannel_name()) + ": " + opDes, 1));
            return resultMap;
        }
        resultMap.put("returnCode", "501");
        resultMap.put("returnMsg", "\u5f00\u95f8\u5931\u8d25");
        return resultMap;
    }

    @Override
    public Map<String, Object> channelDownPole(Map<String, String> paramMap, Map<String, Object> context) {
        String opDes;
        String channelNo = paramMap.get("channelNo");
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        if (channelNo == null || channelNo.length() == 0) {
            resultMap.put("returnCode", "403");
            resultMap.put("returnMsg", "\u7f3a\u5c11\u53c2\u6570\uff1achannelNo");
            return resultMap;
        }
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel == null) {
            resultMap.put("returnCode", "501");
            resultMap.put("returnMsg", "\u4e0d\u662f\u672c\u673a\u7ba1\u7406\u7684\u901a\u9053");
            return resultMap;
        }
        List<OperationFuture<Integer>> operationFuture = passChannel.downPole();
        if (operationFuture == null || operationFuture.isEmpty()) {
            resultMap.put("returnCode", "501");
            resultMap.put("returnMsg", "\u8be5\u901a\u9053\u4e0b\u672a\u914d\u7f6e\u9053\u95f8");
            return resultMap;
        }
        boolean success = false;
        for (OperationFuture<Integer> f : operationFuture) {
            try {
                Integer ax = (Integer)f.get(5000L, TimeUnit.MILLISECONDS);
                if (ax != null && ax == 0) {
                    success = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (success) break;
        }
        if ((opDes = paramMap.get("opDes")) == null || opDes.length() == 0) {
            opDes = "\u4e91\u7aef\u8fdc\u7a0b\u843d\u6746";
        }
        if (success) {
            resultMap.put("returnCode", "0");
            resultMap.put("returnMsg", "\u5173\u95f8\u6210\u529f");
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(passChannel.getChannel().getChannel_name()) + ": " + opDes, 1));
            return resultMap;
        }
        resultMap.put("returnCode", "501");
        resultMap.put("returnMsg", "\u5173\u95f8\u5931\u8d25");
        return resultMap;
    }

    @Override
    public Map<String, Object> otherHostsHandlingPass(Map<String, String> paramMap, Map<String, Object> context) {
        int mediaType;
        String channelNo = paramMap.get("channelNo");
        String passportNumber = paramMap.get("passportNumber");
        String _mediaType = paramMap.get("mediaType");
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        if (channelNo == null || channelNo.length() == 0) {
            resultMap.put("responseCode", "403");
            resultMap.put("responseMsg", "\u7f3a\u5c11\u53c2\u6570: channelNo");
            return resultMap;
        }
        if (passportNumber == null || passportNumber.length() == 0) {
            resultMap.put("responseCode", "403");
            resultMap.put("responseMsg", "\u7f3a\u5c11\u53c2\u6570: passportNumber");
            return resultMap;
        }
        if (_mediaType == null || _mediaType.length() == 0) {
            resultMap.put("responseCode", "403");
            resultMap.put("responseMsg", "\u7f3a\u5c11\u53c2\u6570: mediaType");
            return resultMap;
        }
        try {
            mediaType = Integer.parseInt(_mediaType);
        }
        catch (Exception ex) {
            resultMap.put("responseCode", "403");
            resultMap.put("responseMsg", "\u65e0\u6548\u53c2\u6570: mediaType: " + _mediaType);
            return resultMap;
        }
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        applicationService.closeConfirmDialogWithout(channelNo, passportNumber, mediaType, null);
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        return resultMap;
    }

    @Override
    public Map<String, Object> yiChangPlateCheck(Map<String, Object> paramMap, Map<String, Object> context) {
        Map<String, Object> resultMap = YiChangPlateCheckFilter.doServerYiChangPlateCheck(paramMap);
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        return resultMap;
    }

    @Override
    public Map<String, Object> yongChengPlateCheck(Map<String, Object> paramMap, Map<String, Object> context) {
        Map<String, Object> resultMap = YongchengPlateCheckFilter.doServerYongchengPlateCheck(paramMap);
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        return resultMap;
    }

    @Override
    public Map<String, Object> wuhanPlateCheck(Map<String, Object> paramMap, Map<String, Object> context) {
        Map<String, Object> resultMap = WuhanPlateCheckFilter.doServerWuhanPlateCheck(paramMap);
        resultMap.put("responseCode", "0");
        resultMap.put("responseMsg", "SUCCESS");
        return resultMap;
    }

    @Override
    public ResultResponse handleCloseEscapeOrder(Map<String, String> paramMap, Map<String, Object> context) {
        ResultResponse r = new ResultResponse();
        try {
            RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            long opTimeMills = Long.parseLong(paramMap.get("opTimeMills"));
            String userCode = paramMap.get("userCode");
            String userName = paramMap.get("userName");
            Date opTime = new Date(opTimeMills);
            String passport_number = paramMap.get("passport_number");
            String medium_type = paramMap.get("medium_type");
            String exit_time = paramMap.get("exit_time");
            String exit_record_no = paramMap.get("exit_record_no");
            recordSaveService.closeCarparkEscapeOrder(passport_number, medium_type, exit_time, exit_record_no, userCode, userName, opTime, false);
            r.setResponseCode("0");
            r.setResponseMsg("success");
        }
        catch (Throwable e) {
            r.setResponseCode("1");
            r.setResponseMsg("\u64cd\u4f5c\u5931\u8d25,\u8fdc\u7a0b\u5f02\u5e38:" + e.getMessage());
            ServiceLog.getLog().warn((Object)"\u79fb\u9664\u573a\u5185\u8bb0\u5f55\u5f02\u5e38\uff01", e);
        }
        return r;
    }

    @Override
    public Map<String, Object> queryExitSessionOrder(Map<String, Object> paramMap, Map<String, Object> context) {
        Map<String, List<String>> areaChannelMap;
        List<String> channelNos;
        String passportNumber = (String)paramMap.get("passportNumber");
        String mediumType = (String)paramMap.get("mediumType");
        String areaNo = (String)paramMap.get("areaNo");
        String plateNumber = (String)paramMap.get("plateNumber");
        CloudResultResponse returnMap = CloudResultResponse.createSuccessResponse();
        String RETURN_CODE = "returnCode";
        String RETURN_MSG = "returnMsg";
        if (passportNumber == null || passportNumber.length() == 0) {
            returnMap.put(RETURN_CODE, "403");
            returnMap.put(RETURN_MSG, "\u7f3a\u5c11\u53c2\u6570passportNumber");
            return returnMap;
        }
        if (areaNo == null || areaNo.length() == 0) {
            returnMap.put(RETURN_CODE, "403");
            returnMap.put(RETURN_MSG, "\u7f3a\u5c11\u53c2\u6570areaNo");
            return returnMap;
        }
        int medium_type = 6;
        if (mediumType != null && mediumType.length() > 0) {
            try {
                medium_type = Integer.parseInt(mediumType);
            }
            catch (Exception ex) {
                returnMap.put(RETURN_CODE, "403");
                returnMap.put(RETURN_MSG, "\u53c2\u6570mediumType\u9519\u8bef: " + mediumType);
                return returnMap;
            }
        }
        List<String> list = channelNos = (areaChannelMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreaChannelsMap()) == null ? null : areaChannelMap.get(areaNo);
        if (channelNos == null || channelNos.isEmpty()) {
            returnMap.put(RETURN_CODE, "3");
            returnMap.put(RETURN_MSG, "\u6ca1\u6709\u8ba2\u5355");
            return returnMap;
        }
        PassSession passSession = null;
        for (String channelNo : channelNos) {
            ChannelArea channelArea;
            PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
            if (passChannel == null || (channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(channelNo)) == null || channelArea.getExitAreas() == null || channelArea.getExitAreas().isEmpty()) continue;
            boolean findArea = false;
            for (CarparkArea area : channelArea.getExitAreas()) {
                if (!area.getArea_no().equals(areaNo)) continue;
                findArea = true;
                break;
            }
            if (!findArea) continue;
            PassSession session = null;
            Collection<PassSession> cls = passChannel.getSessions();
            if (cls != null && !cls.isEmpty()) {
                for (PassSession s : cls) {
                    if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG && s.getSessionState() != PassSession.SessionState.WAIT_PAY || s.getReadPassportNumberEvent() == null || !s.getReadPassportNumberEvent().getPassportNumber().equals(passportNumber) || s.getReadPassportNumberEvent().getPassportMediumType() != medium_type) continue;
                    session = s;
                    break;
                }
                if (session == null && medium_type != 6 && plateNumber != null && plateNumber.length() > 0 && !plateNumber.equals(passportNumber)) {
                    for (PassSession s : cls) {
                        if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG && s.getSessionState() != PassSession.SessionState.WAIT_PAY || !plateNumber.equals(s.getPassPlate())) continue;
                        session = s;
                        break;
                    }
                }
            }
            if (session == null || passSession != null && session.getCreatedTimeMills() <= passSession.getCreatedTimeMills()) continue;
            passSession = session;
        }
        if (passSession != null) {
            if (ServiceUtil.getServiceContext().currentTimeMillis() - passSession.getCreatedTimeMills() > TimeUnit.MINUTES.toMillis(5L)) {
                passSession = null;
            } else {
                Map areaPresenceRecordMap = (Map)passSession.getAttribute("areaPresenceRecordMap");
                if (areaPresenceRecordMap != null && !areaPresenceRecordMap.isEmpty() && areaPresenceRecordMap.get(areaNo) != null) {
                    Collection<PassSession> cls = passSession.getPassChannel().getSessions();
                    if (cls == null || cls.isEmpty()) {
                        passSession = null;
                    } else {
                        boolean find = false;
                        for (PassSession s : cls) {
                            if (passSession != null) {
                                if (s.getSessionId() == passSession.getSessionId()) {
                                    find = true;
                                    continue;
                                }
                                if (!find || s.getPlateRecognizedEvent() == null || CommonRemoteServiceImpl.getEnterRecord(s) == null) continue;
                                passSession = null;
                            }
                            break;
                        }
                    }
                } else {
                    passSession = null;
                }
            }
        }
        if (passSession != null) {
            CommonRemoteServiceImpl.setQueryPassSessionResult(passSession, returnMap);
            returnMap.put("sessionCreatedMills", String.valueOf(passSession.getCreateSysMills()));
        } else {
            returnMap.put(RETURN_CODE, "3");
            returnMap.put(RETURN_MSG, "\u65e0\u8ba2\u5355");
        }
        return returnMap;
    }

    @Override
    public Map<String, Object> firefighting(Map<String, Object> paramMap, Map<String, Object> context) {
        String eqNo = (String)paramMap.get("eqNo");
        String eqName = (String)paramMap.get("eqName");
        if (ServiceUtil.getServiceContext().getFirefightingJob() != null) {
            ServiceUtil.getServiceContext().getFirefightingJob().firefighting(eqNo, eqName, false);
        }
        return CloudResultResponse.createSuccessResponse();
    }

    @Override
    public ResultResponse adjustParkingSpace(Map<String, String> paramMap, Map<String, Object> context) {
        String areaNo = paramMap.get("areaNo");
        String spaceTypeNo = paramMap.get("spaceTypeNo");
        String remainSpace = paramMap.get("remainSpace");
        String userCode = paramMap.get("userCode");
        String userName = paramMap.get("userName");
        String opTimeMills = paramMap.get("opTimeMills");
        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        recordSaveService.adjustParkingSpace(areaNo, spaceTypeNo, Integer.parseInt(remainSpace), userCode, userName, new Date(Long.parseLong(opTimeMills)), false);
        ResultResponse r = new ResultResponse();
        r.setResponseCode("0");
        r.setResponseMsg("SUCCESS");
        return r;
    }
}

