/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.service.impl.remote;

import com.google.gson.reflect.TypeToken;
import com.wovoe.carpark.DispatchDataTaskUtil;
import com.wovoe.carpark.JsonListType;
import com.wovoe.carpark.KeyLockManager;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.SenselessOrderNo;
import com.wovoe.carpark.cloud.CloudResultResponse;
import com.wovoe.carpark.cloud.client.CloudCarparkDataSyncService;
import com.wovoe.carpark.cloud.trtc.DeviceInfoCollection;
import com.wovoe.carpark.cloud.trtc.TRTCCloudContext;
import com.wovoe.carpark.dto.CarparkCancelPassRecord;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkCloudOrderMessage;
import com.wovoe.carpark.dto.CarparkDiscountRecord;
import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkEscapeOrder;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkPassDiscount;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassSelfPay;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkQueryFee;
import com.wovoe.carpark.dto.CarparkTranConfig;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.app.LocalPassRecordEvent;
import com.wovoe.carpark.event.app.PassRecordEvent;
import com.wovoe.carpark.event.app.ReadPassportNumberEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.service.impl.remote.CloudMsgServiceImpl;
import com.wovoe.carpark.service.impl.remote.CommonRemoteServiceImpl;
import com.wovoe.carpark.service.remote.CarparkCloudMessageHandler;
import com.wovoe.carpark.service.remote.CloudMsgService;
import com.wovoe.carpark.service.remote.CommonRemoteService;
import com.wovoe.carpark.vo.CarparkConfig;
import com.wovoe.carpark.vo.SyncDBRecord;
import com.wovoe.carpark.vo.SyncDBRecordResult;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JavaBeanTool;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.Service;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.SearchParam;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.session.SqlSession;

@Service(value="carparkCloudMessageHandler")
public class DefaultCarparkCloudMessageHandler
implements CarparkCloudMessageHandler {
    @Override
    public CloudResultResponse handlePassRecord(Map<String, Object> paramMap, Map<String, Object> context) {
        long id;
        String passRecordJson = (String)paramMap.get("passRecordJson");
        if (passRecordJson == null || passRecordJson.length() == 0) {
            return new CloudResultResponse("403", "\u7f3a\u5c11\u53c2\u6570passRecordJson");
        }
        CarparkPassRecord passRecord = (CarparkPassRecord)GsonBuilder.create().fromJson(passRecordJson, CarparkPassRecord.class);
        if (passRecord.getExit_time() != null) {
            if (passRecord.getExit_record_no() == null || !passRecord.getExit_record_no().startsWith("C") && !passRecord.getExit_record_no().startsWith("S")) {
                return new CloudResultResponse("403", "\u65e0\u6cd5\u5904\u7406\u7684\u79bb\u573a\u7f16\u53f7");
            }
            id = Long.valueOf(passRecord.getExit_record_no().substring(1));
        } else if (passRecord.getEnter_time() != null) {
            if (passRecord.getEnter_record_no() == null || !passRecord.getEnter_record_no().startsWith("C") && !passRecord.getEnter_record_no().startsWith("S")) {
                return new CloudResultResponse("403", "\u65e0\u6cd5\u5904\u7406\u7684\u5165\u573a\u7f16\u53f7");
            }
            id = Long.valueOf(passRecord.getEnter_record_no().substring(1));
        } else {
            return new CloudResultResponse("403", "\u7f3a\u5c11\u79bb\u573a\u6216\u5165\u573a\u65f6\u95f4");
        }
        passRecord.setId(id);
        CloudCarparkDataSyncService.downloadPassRecordPic(null, passRecord);
        CommonRemoteService commonRemoteService = (CommonRemoteService)ServiceUtil.getServiceContext().getService("commonRemoteService");
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SyncDBRecord record = new SyncDBRecord();
        record.setTableName(commonDaoService.getTableName(CarparkPassRecord.class));
        record.setJsonRecord(GsonBuilder.create().toJson((Object)passRecord));
        SyncDBRecordResult result = commonRemoteService.synDBRecord(record, context);
        if (!result.isSuccess()) {
            return new CloudResultResponse(result.getResponseCode(), result.getResponseMsg());
        }
        if (result.getReturnCode() == null) {
            return new CloudResultResponse("501", "unknown returnCode!");
        }
        if (result.getReturnCode() == 0) {
            return new CloudResultResponse().success();
        }
        return new CloudResultResponse("501", result.getReturnMsg());
    }

    @Override
    public CloudResultResponse noticeFetchNewData(Map<String, Object> paramMap, Map<String, Object> context) {
        CloudCarparkDataSyncService cloudCarparkDataSyncService = (CloudCarparkDataSyncService)ServiceUtil.getServiceContext().getService("cloudCarparkDataSyncService");
        if (cloudCarparkDataSyncService != null) {
            cloudCarparkDataSyncService.trySyncDataAndMessage();
        }
        return new CloudResultResponse().success();
    }

    @Override
    public Map<String, Object> carparkPayConfig(Map<String, String> paramMap, Map<String, Object> context) {
        String tranConfigsJson = paramMap.get("tranConfigsJson");
        List tranConfigList = null;
        if (tranConfigsJson != null && tranConfigsJson.length() > 0) {
            tranConfigList = (List)GsonBuilder.create().fromJson(tranConfigsJson, new JsonListType<CarparkTranConfig>(CarparkTranConfig.class));
        }
        if (tranConfigList != null && !tranConfigList.isEmpty()) {
            CarparkConfig config = new CarparkConfig();
            config.setTranConfigList(tranConfigList);
            CloudMsgService CloudMsgService2 = (CloudMsgService)ServiceUtil.getServiceContext().getService(CloudMsgService.class);
            return CloudMsgService2.carparkConfig(config, context);
        }
        return new CloudResultResponse().success();
    }

    @Override
    public CloudResultResponse paySuccessNotice(Map<String, String> paramMap, Map<String, Object> context) {
        String selfPayJson = paramMap.get("selfPayJson");
        if (selfPayJson == null || selfPayJson.length() == 0) {
            return new CloudResultResponse("403", "\u7f3a\u5c11\u53c2\u6570selfPayJson");
        }
        CarparkPassSelfPay passSelfPay = (CarparkPassSelfPay)GsonBuilder.create().fromJson(selfPayJson, CarparkPassSelfPay.class);
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        long count = daoService.selectCount(new SearchParam(daoService.getTableName(CarparkPassSelfPay.class)).addEQ("id", (Object)passSelfPay.getId()));
        if (count == 0L) {
            daoService.insert((Object)passSelfPay);
            CarparkPassSelfPay selfPay = passSelfPay;
            if (selfPay.getEnter_pay() != null && selfPay.getEnter_pay() == 2) {
                CommonParam updateOrder = new CommonParam(daoService.getTableName(CarparkEscapeOrder.class));
                updateOrder.addEQ("passport_number", (Object)selfPay.getPassport_number());
                updateOrder.addEQ("exit_time", (Object)selfPay.getExit_time());
                updateOrder.addEQ("medium_type", (Object)selfPay.getMedium_type());
                updateOrder.addEQ("carpark_id", (Object)selfPay.getCarpark_id());
                updateOrder.addEQ("enter_record_no", (Object)selfPay.getEnter_record_no());
                updateOrder.addEQ("exit_record_no", (Object)selfPay.getExit_record_no());
                updateOrder.addUpdate("order_state", (Object)1);
                updateOrder.addUpdate("order_pay_money", (Object)selfPay.getPaid_amount());
                updateOrder.addUpdate("order_pay_time", (Object)selfPay.getPaid_time());
                updateOrder.addUpdate("order_pay_method", (Object)selfPay.getPaid_method());
                updateOrder.addUpdate("order_pay_scene", (Object)selfPay.getPay_scene());
                updateOrder.addUpdate("order_charge_org", (Object)selfPay.getCharge_org());
                updateOrder.addUpdate("order_pay_entry", (Object)selfPay.getPay_entry());
                if (selfPay.getCharge_record_no() != null) {
                    updateOrder.addUpdate("pay_order_no", (Object)selfPay.getCloud_order_no());
                }
                updateOrder.addUpdate("tran_record_no", (Object)selfPay.getCharge_record_no());
                daoService.update(updateOrder);
            }
            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            applicationService.asynHandleSelfPay(passSelfPay);
        }
        return new CloudResultResponse().success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloudResultResponse transRecord(Map<String, String> paramMap, Map<String, Object> context) {
        block12: {
            String tableName;
            String dataJson = paramMap.get("transRecordJson");
            if (dataJson == null || dataJson.length() == 0) {
                return new CloudResultResponse("403", "\u7f3a\u5c11\u53c2\u6570transRecordJson");
            }
            CarparkTransaction t = (CarparkTransaction)GsonBuilder.create().fromJson(dataJson, CarparkTransaction.class);
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            long count = daoService.selectCount(new SearchParam(tableName = daoService.getTableName(CarparkTransaction.class)).addEQ("tran_time", (Object)t.getTran_time()).addEQ("tansaction_no", (Object)t.getTansaction_no()));
            if (count == 0L) {
                Long id = null;
                if (t.getTansaction_no().startsWith("C")) {
                    try {
                        id = Long.valueOf(t.getTansaction_no().substring(1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (id != null) {
                    t.setId(id);
                    KeyLockManager keyLockManager = ServiceUtil.getServiceContext().getKeyLockManager();
                    Object lock = keyLockManager.getLock("commonRemoteService-synDBRecord-" + tableName + "-" + id);
                    try {
                        Object object = lock;
                        synchronized (object) {
                            daoService.synDataByPrimeryKey((Object)t);
                            break block12;
                        }
                    }
                    finally {
                        keyLockManager.releaseLock(lock);
                    }
                }
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                long tranId = appService.createLocalRecordSeq("ck_carpark_transaction_seq");
                t.setId(tranId);
                daoService.insert((Object)t);
            }
        }
        return new CloudResultResponse().success();
    }

    @Override
    public CloudResultResponse queryPassSession(Map<String, String> paramMap, Map<String, Object> context) {
        String channelNo = paramMap.get("channelNo");
        if (channelNo == null || channelNo.length() == 0) {
            return new CloudResultResponse("403", "\u7f3a\u5c11\u901a\u9053\u53f7");
        }
        CarparkChannel channel = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap().get(channelNo);
        if (channel == null) {
            return new CloudResultResponse("403", "\u65e0\u6548\u901a\u9053\u53f7");
        }
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel == null) {
            return new CloudResultResponse("501", "\u901a\u9053\u672a\u8fde\u63a5");
        }
        String plateNumber = paramMap.get("plateNumber0");
        String passportNumber = paramMap.get("passportNumber0");
        String mediumType = paramMap.get("mediumType0");
        String scanPassportNumber = paramMap.get("scanPassportNumber0");
        int medium_type = 1;
        if (scanPassportNumber != null && scanPassportNumber.length() > 0) {
            passportNumber = scanPassportNumber;
        } else if (passportNumber != null && passportNumber.length() > 0 && mediumType != null && mediumType.length() > 0) {
            try {
                medium_type = Integer.parseInt(mediumType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean queryByCondition = plateNumber != null && plateNumber.length() > 0 || passportNumber != null && passportNumber.length() > 0;
        String RETURN_CODE = "returnCode";
        String RETURN_MSG = "returnMsg";
        CloudResultResponse returnMap = new CloudResultResponse().success();
        try {
            PassSession passSession;
            block19: {
                block18: {
                    passSession = null;
                    if (!queryByCondition) break block18;
                    Collection<PassSession> cl = passChannel.getSessions();
                    if (passportNumber != null && passportNumber.length() > 0) {
                        for (PassSession s : cl) {
                            Object passPlate;
                            if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG && s.getSessionState() != PassSession.SessionState.WAIT_PAY || (passPlate = s.getPassPlate()) != null && s.getReadPassportNumberEvent() != null && s.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(passPlate) || s.getReadPassportNumberEvent() == null || !passportNumber.equals(s.getReadPassportNumberEvent().getPassportNumber()) || medium_type != s.getReadPassportNumberEvent().getPassportMediumType()) continue;
                            passSession = s;
                            break;
                        }
                    }
                    if (passSession != null || plateNumber == null || plateNumber.length() <= 0 || passportNumber != null && passportNumber.length() > 0 && 6 == medium_type && plateNumber.equals(passportNumber)) break block19;
                    PassSession samePlateSession = null;
                    for (PassSession s : cl) {
                        String passPlate;
                        if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG && s.getSessionState() != PassSession.SessionState.WAIT_PAY || (passPlate = s.getPassPlate()) != null && s.getReadPassportNumberEvent() != null && s.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(passPlate)) continue;
                        if (s.getReadPassportNumberEvent() != null && plateNumber.equals(s.getReadPassportNumberEvent().getPassportNumber()) && 6 == s.getReadPassportNumberEvent().getPassportMediumType()) {
                            passSession = s;
                        }
                        if (passPlate == null || !plateNumber.equals(passPlate)) continue;
                        samePlateSession = s;
                    }
                    if (passSession != null || samePlateSession == null) break block19;
                    passSession = samePlateSession;
                    break block19;
                }
                passSession = passChannel.getCurrentHandleSession();
                if (passSession == null) {
                    Collection<PassSession> cl = passChannel.getSessions();
                    for (PassSession s : cl) {
                        String passPlate;
                        if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG && s.getSessionState() != PassSession.SessionState.WAIT_PAY || (passPlate = s.getPassPlate()) != null && s.getReadPassportNumberEvent() != null && s.getReadPassportNumberEvent().isManualTrigger() && "\u8bf7\u8f93\u5165\u8f66\u724c".equals(passPlate)) continue;
                        passSession = s;
                    }
                }
            }
            if (passSession != null) {
                CommonRemoteServiceImpl.setQueryPassSessionResult(passSession, returnMap);
            } else {
                returnMap.put(RETURN_CODE, "3");
                returnMap.put(RETURN_MSG, "\u6253\u5361\u5904\u7406");
            }
        }
        catch (Exception ex) {
            returnMap.put(RETURN_CODE, "500");
            returnMap.put(RETURN_MSG, "\u5185\u90e8\u9519\u8bef");
            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
        }
        return returnMap;
    }

    @Override
    public CloudResultResponse scanCarPass(Map<String, String> paramMap, Map<String, Object> context) {
        String channelNo = paramMap.get("channelNo");
        String passportNumber = paramMap.get("passportNumber");
        if (passportNumber == null || passportNumber.length() == 0) {
            return new CloudResultResponse("403", "\u7f3a\u5c11\u53c2\u6570\u5361\u53f7");
        }
        if (channelNo == null || channelNo.length() == 0) {
            return new CloudResultResponse("403", "\u7f3a\u5c11\u901a\u9053\u53f7");
        }
        CarparkChannel channel = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap().get(channelNo);
        if (channel == null) {
            return new CloudResultResponse("403", "\u65e0\u6548\u901a\u9053\u53f7");
        }
        String sv = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_SCAN_PASS");
        if (sv != null && "0".equals(sv)) {
            return new CloudResultResponse("501", "\u8be5\u901a\u9053\u626b\u4e00\u626b\u5165\u573a\u529f\u80fd\u5df2\u5173\u95ed");
        }
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel == null) {
            return new CloudResultResponse("501", "\u901a\u9053\u672a\u8fde\u63a5");
        }
        String plateNumber = paramMap.get("plateNumber");
        boolean forceTemp = "true".equals(paramMap.get("forceTemp"));
        String RETURN_CODE = "returnCode";
        String RETURN_MSG = "returnMsg";
        CloudResultResponse returnMap = new CloudResultResponse().success();
        List<Equipment> list = passChannel.getEquipmentList(9);
        if (!ServiceUtil.getServiceContext().isDevEnvironment() && list != null && !list.isEmpty()) {
            boolean ok = false;
            for (Equipment eq : list) {
                if (eq.getEquipmentAction() == null || !eq.getEquipmentAction().isWorkingProperly()) continue;
                ok = true;
                break;
            }
            if (!ok) {
                returnMap.put(RETURN_CODE, "501");
                returnMap.put(RETURN_MSG, "\u9053\u95f8\u8bbe\u5907\u672a\u8fde\u63a5!");
                return returnMap;
            }
        }
        try {
            ReadPassportNumberEvent revent = new ReadPassportNumberEvent(passChannel, passportNumber, 1, channelNo);
            revent.setPlateNumber(plateNumber);
            revent.setUserScan(true);
            revent.setScanCode(passportNumber);
            revent.setForceTemp(forceTemp);
            OperationFutureHandler remoteExeHandler = ServiceUtil.getServiceContext().createOperationFuture();
            revent.setRemoteExeHandler((OperationFutureHandler<Map<String, Object>>)remoteExeHandler);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(revent);
            Map reMap = (Map)remoteExeHandler.get(8L, TimeUnit.SECONDS);
            if (reMap == null) {
                returnMap.put(RETURN_CODE, "501");
                returnMap.put(RETURN_MSG, "\u6267\u884c\u653e\u884c\u6d41\u7a0b\u8d85\u65f6");
            } else {
                boolean success = "0".equals(reMap.get("responseCode"));
                if (success) {
                    if (reMap.get(RETURN_CODE) == null) {
                        returnMap.put(RETURN_CODE, "0");
                        returnMap.put(RETURN_MSG, reMap.get("responseMsg"));
                    } else {
                        returnMap.put(RETURN_CODE, reMap.get(RETURN_CODE));
                        returnMap.put(RETURN_MSG, reMap.get(RETURN_MSG) == null ? "" : reMap.get(RETURN_MSG));
                    }
                } else {
                    returnMap.put(RETURN_CODE, reMap.get("responseCode"));
                    returnMap.put(RETURN_MSG, reMap.get("responseMsg"));
                }
                for (Map.Entry e : reMap.entrySet()) {
                    if ("responseCode".equals(e.getKey()) || "responseMsg".equals(e.getKey()) || RETURN_CODE.equals(e.getKey()) || RETURN_MSG.equals(e.getKey())) continue;
                    returnMap.put((String)e.getKey(), e.getValue());
                }
            }
        }
        catch (Exception ex) {
            returnMap.put(RETURN_CODE, "500");
            returnMap.put(RETURN_MSG, "\u8bbe\u5907\u5185\u90e8\u5904\u7406\u9519\u8bef");
            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
        }
        return returnMap;
    }

    @Override
    public CloudResultResponse presenceCarDiscount(Map<String, String> paramMap, Map<String, Object> context) {
        String dataJson = paramMap.get("dataJson");
        if (dataJson == null || dataJson.length() == 0) {
            return new CloudResultResponse("403", "\u7f3a\u5c11\u53c2\u6570dataJson");
        }
        CarparkPassDiscount record = (CarparkPassDiscount)GsonBuilder.create().fromJson(dataJson, CarparkPassDiscount.class);
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        daoService.synDataByPrimeryKey((Object)record);
        try {
            String tableName = daoService.getTableName(CarparkDiscountRecord.class);
            long count = daoService.selectCount(new SearchParam(tableName).addEQ("discount_no", (Object)record.getDiscount_no()).addEQ("discount_time", (Object)record.getDiscount_time()));
            if (count == 0L) {
                CarparkDiscountRecord d = new CarparkDiscountRecord();
                JavaBeanTool.copyTo((Object)record, (Object)d);
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                long rdId = appService.createLocalRecordSeq("ck_carpark_discount_record_seq");
                d.setId(rdId);
                daoService.insert((Object)d);
                ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                applicationService.asynHandleDiscount(record);
            }
            ServiceLog.getLog().info((Object)("\u6536\u5230\u5e76\u5904\u7406\u6253\u6298\u8bb0\u5f55\uff1a" + record.getDiscount_project_no() + ", " + record.getPalte_number()));
        }
        catch (Exception tableName) {
            // empty catch block
        }
        CloudResultResponse responseMap = new CloudResultResponse().success();
        return responseMap;
    }

    @Override
    public CloudResultResponse modifyPresenceCartype(Map<String, Object> paramMap1, Map<String, Object> context) {
        SearchParam sp;
        Date opTime;
        Map paramMap;
        String dataJson = (String)paramMap1.get("dataJson");
        if (dataJson == null || dataJson.length() == 0) {
            ServiceLog.getLog().warn((Object)"\u7f3a\u5c11\u53c2\u6570dataJson\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u7c7b\u578b!");
            return new CloudResultResponse().success();
        }
        try {
            paramMap = (Map)GsonBuilder.create().fromJson(dataJson, new TypeToken<Map<String, String>>(){}.getType());
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6548\u53c2\u6570dataJson" + dataJson + "\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u7c7b\u578b!"));
            return new CloudResultResponse().success();
        }
        String enterRecordNo = (String)paramMap.get("enterRecordNo");
        String opUserCode = (String)paramMap.get("opUserCode");
        String opUserName = (String)paramMap.get("opUserName");
        String opTime0 = (String)paramMap.get("opTime");
        if (enterRecordNo == null || enterRecordNo.length() == 0) {
            ServiceLog.getLog().warn((Object)"\u7f3a\u5c11\u53c2\u6570enterRecordNo\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u7c7b\u578b");
            return new CloudResultResponse().success();
        }
        if (opUserCode == null || opUserCode.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570opUserCode\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u7c7b\u578b: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        if (opUserName == null || opUserName.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570opUserName\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u7c7b\u578b: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        if (opTime0 == null || opTime0.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570opTime\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u7c7b\u578b: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        try {
            opTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(opTime0);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("opTime\u683c\u5f0f\u5e94\u8be5\u4e3ayyyy-MM-dd HH:mm:ss\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u7c7b\u578b\uff1a" + enterRecordNo));
            return new CloudResultResponse().success();
        }
        String oldCarTypeNo = (String)paramMap.get("oldCarTypeNo");
        String newCarTypeNo = (String)paramMap.get("newCarTypeNo");
        if (newCarTypeNo == null || newCarTypeNo.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570newCarTypeNo\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u7c7b\u578b\uff1a" + enterRecordNo));
            return new CloudResultResponse().success();
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPresenceRecord record = (CarparkPresenceRecord)commonDaoService.selectOne(sp = new SearchParam().setQueryFields(new String[]{"id"}).addEQ("enter_record_no", (Object)enterRecordNo), CarparkPresenceRecord.class);
        if (record == null || record.getId() == null) {
            ServiceLog.getLog().warn((Object)("\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u7c7b\u578b\uff1a" + enterRecordNo));
            return new CloudResultResponse().success();
        }
        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        recordSaveService.modifyPresenceCarType(record.getId(), oldCarTypeNo, newCarTypeNo, opUserCode, opUserName, opTime, false);
        return new CloudResultResponse().success();
    }

    @Override
    public CloudResultResponse modifyPresencePlate(Map<String, Object> paramMap1, Map<String, Object> context) {
        CarparkPassRecord record;
        SearchParam sp;
        Date opTime;
        Map paramMap;
        String dataJson = (String)paramMap1.get("dataJson");
        if (dataJson == null || dataJson.length() == 0) {
            ServiceLog.getLog().warn((Object)"\u7f3a\u5c11\u53c2\u6570dataJson\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u8f66\u724c!");
            return new CloudResultResponse().success();
        }
        try {
            paramMap = (Map)GsonBuilder.create().fromJson(dataJson, new TypeToken<Map<String, String>>(){}.getType());
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6548\u53c2\u6570dataJson" + dataJson + "\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u8f66\u724c!"));
            return new CloudResultResponse().success();
        }
        String enterRecordNo = (String)paramMap.get("enterRecordNo");
        String opUserCode = (String)paramMap.get("opUserCode");
        String opUserName = (String)paramMap.get("opUserName");
        String opTime0 = (String)paramMap.get("opTime");
        if (enterRecordNo == null || enterRecordNo.length() == 0) {
            ServiceLog.getLog().warn((Object)"\u7f3a\u5c11\u53c2\u6570enterRecordNo\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u8f66\u724c: ");
            return new CloudResultResponse().success();
        }
        if (opUserCode == null || opUserCode.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570opUserCode\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u8f66\u724c: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        if (opUserName == null || opUserName.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570opUserName\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u8f66\u724c: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        if (opTime0 == null || opTime0.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570opTime\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u8f66\u724c: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        try {
            opTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(opTime0);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("opTime\u683c\u5f0f\u5e94\u8be5\u4e3ayyyy-MM-dd HH:mm:ss\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u8f66\u724c: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        String oldPlate = (String)paramMap.get("oldPlate");
        String newPlate = (String)paramMap.get("newPlate");
        if (oldPlate == null || oldPlate.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570oldPlate\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u8f66\u724c: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        if (newPlate == null || newPlate.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570newPlate\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u8f66\u724c: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPresenceRecord record1 = (CarparkPresenceRecord)commonDaoService.selectOne(sp = new SearchParam().setQueryFields(new String[]{"id"}).addEQ("enter_record_no", (Object)enterRecordNo), CarparkPresenceRecord.class);
        if (record1 == null || record1.getId() == null) {
            ServiceLog.getLog().warn((Object)("\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u653e\u5f03\u66f4\u65b0\u5728\u573a\u8f66\u8f86\u8f66\u724c: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                record = recordSaveService.handleModifyPlate(session, record1.getId(), oldPlate, newPlate, opTime, opUserCode, opUserName);
                session.commit();
            }
            catch (Throwable e) {
                session.rollback();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (record != null) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new PassRecordEvent(this, record));
            if (ServiceUtil.getServiceContext().getLocalHostNo().equals(record.getEnter_host_no())) {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new LocalPassRecordEvent(this, record));
            } else if (record.getPass_channel_no() != null && ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(record.getPass_channel_no()) != null) {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new LocalPassRecordEvent(this, record));
            }
        }
        return new CloudResultResponse().success();
    }

    @Override
    public CloudResultResponse removePresenceRecord(Map<String, Object> paramMap1, Map<String, Object> context) {
        Date opTime;
        Map paramMap;
        String dataJson = (String)paramMap1.get("dataJson");
        if (dataJson == null || dataJson.length() == 0) {
            ServiceLog.getLog().warn((Object)"\u7f3a\u5c11\u53c2\u6570dataJson\uff0c\u653e\u5f03\u79fb\u9664\u5728\u573a\u8f66\u8f86!");
            return new CloudResultResponse().success();
        }
        try {
            paramMap = (Map)GsonBuilder.create().fromJson(dataJson, new TypeToken<Map<String, String>>(){}.getType());
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6548\u53c2\u6570dataJson" + dataJson + "\uff0c\u653e\u5f03\u79fb\u9664\u5728\u573a\u8f66\u8f86!"));
            return new CloudResultResponse().success();
        }
        String enterRecordNo = (String)paramMap.get("enterRecordNo");
        String opUserCode = (String)paramMap.get("opUserCode");
        String opUserName = (String)paramMap.get("opUserName");
        String opTime0 = (String)paramMap.get("opTime");
        if (enterRecordNo == null || enterRecordNo.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570enterRecordNo\uff0c\u653e\u5f03\u79fb\u9664\u5728\u573a\u8f66\u8f86: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        if (opUserCode == null || opUserCode.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570opUserCode\uff0c\u653e\u5f03\u79fb\u9664\u5728\u573a\u8f66\u8f86: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        if (opUserName == null || opUserName.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570opUserName\uff0c\u653e\u5f03\u79fb\u9664\u5728\u573a\u8f66\u8f86: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        if (opTime0 == null || opTime0.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570opTime\uff0c\u653e\u5f03\u79fb\u9664\u5728\u573a\u8f66\u8f86: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        try {
            opTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(opTime0);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("opTime\u683c\u5f0f\u5e94\u8be5\u4e3ayyyy-MM-dd HH:mm:ss\uff0c\u653e\u5f03\u79fb\u9664\u5728\u573a\u8f66\u8f86: " + enterRecordNo));
            return new CloudResultResponse().success();
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam sp = new SearchParam().setQueryFields(new String[]{"id"}).addEQ("enter_record_no", (Object)enterRecordNo);
        CarparkPresenceRecord record = (CarparkPresenceRecord)commonDaoService.selectOne(sp, CarparkPresenceRecord.class);
        if (record == null || record.getId() == null) {
            return new CloudResultResponse().success();
        }
        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        recordSaveService.removeCarparkPresenceRecord(record.getId(), opUserCode, opUserName, opTime, false);
        return new CloudResultResponse().success();
    }

    @Override
    public CloudResultResponse setChannelEqVolume(Map<String, Object> paramMap, Map<String, Object> context) {
        ApplicationService ApplicationService2 = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        KeyValueEntry<String, String> en = ApplicationService2.setVolume();
        CloudResultResponse map = new CloudResultResponse().success();
        if (en.getKey() != null && ((String)en.getKey()).length() > 0) {
            map.put("successMsg", en.getKey());
        }
        if (en.getValue() != null && ((String)en.getValue()).length() > 0) {
            map.put("failMsg", en.getValue());
        }
        return map;
    }

    @Override
    public CloudResultResponse queryVideoCallStatus(Map<String, Object> paramMap, Map<String, Object> context) {
        DeviceInfoCollection collection;
        boolean isAudioCall;
        String cloud_userId = (String)paramMap.get("userId");
        if (cloud_userId == null || cloud_userId.length() == 0) {
            return new CloudResultResponse("403", "\u7f3a\u5c11\u4e91\u7aef\u5206\u914duserId");
        }
        CloudResultResponse response = new CloudResultResponse().success();
        TRTCCloudContext trtcContext = ServiceUtil.getServiceContext().getTRTCCloudContext();
        if (trtcContext == null) {
            ServiceLog.getLog().warn((Object)"\u4e91\u7aef\u67e5\u8be2\u8f6f\u4ef6\u662f\u5426\u51c6\u5907\u597d\u63a5\u6536\u89c6\u9891\u901a\u8bdd\uff1aTRTC\u89c6\u9891\u8bed\u97f3\u6a21\u5757\u672a\u5b8c\u6210\u542f\u52a8");
            response.put("return_code", "trtc_not_started");
            return response;
        }
        if (!trtcContext.isEnableTrtcCallAccept()) {
            ServiceLog.getLog().info((Object)"\u4e91\u7aef\u67e5\u8be2\u8f6f\u4ef6\u662f\u5426\u51c6\u5907\u597d\u63a5\u6536\u89c6\u9891\u901a\u8bdd\uff1aTRTC\u63a5\u542c\u529f\u80fd\u672a\u5f00\u542f, \u5f53\u524d\u72b6\u6001\u4e0d\u63a5\u6536\u4efb\u4f55\u89c6\u9891\u901a\u8bdd");
            response.put("return_code", "trtc_disabled");
            return response;
        }
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        if (appService.getUserSession() == null || appService.getUserSession().getUser() == null) {
            response.put("return_code", "user_unlogin");
            return response;
        }
        CarparkUser loginUser = appService.getUserSession().getUser();
        if (trtcContext.getTRTCCallManager().isCalling()) {
            response.put("return_code", "BUSY");
            String userId = trtcContext.getTRTCCallManager().getUserId();
            String userName = trtcContext.getTRTCCallManager().getUserName();
            if (userId != null && userId.length() > 0) {
                response.put("userId", userId);
            }
            if (userName != null) {
                response.put("userName", userName);
            }
            return response;
        }
        if (!trtcContext.isTrtcSdkNormal()) {
            ServiceLog.getLog().warn((Object)"\u4e91\u7aef\u67e5\u8be2\u8f6f\u4ef6\u662f\u5426\u51c6\u5907\u597d\u63a5\u6536\u89c6\u9891\u901a\u8bdd\uff1aTRTC\u89c6\u9891\u8bed\u97f3\u6a21\u5757\u672a\u521d\u59cb\u5316\u5b8c\u6210");
            response.put("return_code", "trtc_uninitialized");
            return response;
        }
        String call_type = (String)paramMap.get("call_type");
        boolean bl = isAudioCall = call_type != null && "AUDIO".equals(call_type);
        if (!isAudioCall) {
            try {
                collection = trtcContext.getTRTCCloud().getDevicesList(2);
                if (collection == null || collection.getDeviceInfoList() == null || collection.getDeviceInfoList().length == 0) {
                    ServiceLog.getLog().warn((Object)"\u901a\u9053\u8bf7\u6c42\u89c6\u9891\u901a\u8bdd\u5931\u8d25\uff01\u539f\u56e0\uff1a\u672a\u68c0\u6d4b\u5230\u6444\u50cf\u5934");
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u901a\u9053\u8bf7\u6c42\u89c6\u9891\u901a\u8bdd\u5931\u8d25\uff01\u539f\u56e0\uff1a\u672a\u68c0\u6d4b\u5230\u6444\u50cf\u5934", 4));
                    response.put("return_code", "camera_not_found");
                    return response;
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u68c0\u6d4b\u6444\u50cf\u5934\u8bbe\u5907\u5f02\u5e38\uff01" + ex.getMessage()));
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u901a\u9053\u8bf7\u6c42\u89c6\u9891\u901a\u8bdd\u5931\u8d25\uff01\u539f\u56e0\uff1a\u68c0\u6d4b\u6444\u50cf\u5934\u662f\u5426\u5b89\u88c5\u9519\u8bef", 4));
                response.put("return_code", "detect_device_camera_error");
                return response;
            }
        }
        try {
            collection = trtcContext.getTRTCCloud().getDevicesList(0);
            if (collection == null || collection.getDeviceInfoList() == null || collection.getDeviceInfoList().length == 0) {
                String name1 = isAudioCall ? "\u8bed\u97f3" : "\u89c6\u9891";
                ServiceLog.getLog().warn((Object)("\u901a\u9053\u8bf7\u6c42" + name1 + "\u901a\u8bdd\u5931\u8d25\uff01\u539f\u56e0\uff1a\u672a\u68c0\u6d4b\u5230\u9ea6\u514b\u98ce"));
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u901a\u9053\u8bf7\u6c42" + name1 + "\u901a\u8bdd\u5931\u8d25\uff01\u539f\u56e0\uff1a\u672a\u68c0\u6d4b\u5230\u9ea6\u514b\u98ce", 4));
                response.put("return_code", "micro_not_found");
                return response;
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u68c0\u6d4b\u9ea6\u514b\u98ce\u8bbe\u5907\u5f02\u5e38\uff01" + ex.getMessage()));
            String name1 = isAudioCall ? "\u8bed\u97f3" : "\u89c6\u9891";
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u901a\u9053\u8bf7\u6c42" + name1 + "\u901a\u8bdd\u5931\u8d25\uff01\u539f\u56e0\uff1a\u68c0\u6d4b\u9ea6\u514b\u98ce\u662f\u5426\u5b89\u88c5\u9519\u8bef", 4));
            response.put("return_code", "detect_device_micro_error");
            return response;
        }
        try {
            collection = trtcContext.getTRTCCloud().getDevicesList(1);
            if (collection == null || collection.getDeviceInfoList() == null || collection.getDeviceInfoList().length == 0) {
                String name1 = isAudioCall ? "\u8bed\u97f3" : "\u89c6\u9891";
                ServiceLog.getLog().warn((Object)("\u901a\u9053\u8bf7\u6c42" + name1 + "\u901a\u8bdd\u5931\u8d25\uff01\u539f\u56e0\uff1a\u672a\u68c0\u6d4b\u5230\u626c\u58f0\u5668\u6216\u542c\u7b52"));
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u901a\u9053\u8bf7\u6c42" + name1 + "\u901a\u8bdd\u5931\u8d25\uff01\u539f\u56e0\uff1a\u672a\u68c0\u6d4b\u5230\u626c\u58f0\u5668\u6216\u542c\u7b52", 4));
                response.put("return_code", "speaker_not_found");
                return response;
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u68c0\u6d4b\u626c\u58f0\u5668\u6216\u542c\u7b52\u8bbe\u5907\u5f02\u5e38\uff01" + ex.getMessage()));
            String name1 = isAudioCall ? "\u8bed\u97f3" : "\u89c6\u9891";
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u901a\u9053\u8bf7\u6c42" + name1 + "\u901a\u8bdd\u5931\u8d25\uff01\u539f\u56e0\uff1a\u68c0\u6d4b\u626c\u58f0\u5668\u6216\u542c\u7b52\u662f\u5426\u5b89\u88c5\u9519\u8bef", 4));
            response.put("return_code", "detect_device_speaker_error");
            return response;
        }
        CarparkHost host = ServiceUtil.getServiceContext().getLocalHost();
        String hostName = host != null ? host.getHost_name() : "";
        hostName = String.valueOf(hostName) + "[" + loginUser.getUser_name() + "]";
        response.put("return_code", "IDLE");
        response.put("userId", cloud_userId);
        response.put("userName", hostName);
        return response;
    }

    @Override
    public CloudResultResponse acceptVideoCall(Map<String, Object> paramMap, Map<String, Object> context) {
        int roomId;
        int sdkAppId;
        int callType;
        String app_id = (String)paramMap.get("app_id");
        String room_id = (String)paramMap.get("room_id");
        String acceptUserId = (String)paramMap.get("acceptUserId");
        String acceptUserName = (String)paramMap.get("acceptUserName");
        String acceptUserSig = (String)paramMap.get("acceptUserSig");
        String callUserId = (String)paramMap.get("callUserId");
        String callUserName = (String)paramMap.get("callUserName");
        String channelNo = (String)paramMap.get("channelNo");
        String aotuAnswer = (String)paramMap.get("aotuAnswer");
        boolean isAotuAnswer = aotuAnswer != null && "true".equals(aotuAnswer);
        String call_type = (String)paramMap.get("call_type");
        boolean isAudioCall = call_type != null && "AUDIO".equals(call_type);
        int n = callType = isAudioCall ? 1 : 2;
        if (app_id == null || app_id.length() == 0) {
            ServiceLog.getLog().warn((Object)"\u8bf7\u6c42\u901a\u8bdd(\u63a5\u542c)\u5931\u8d25\uff01\u7f3a\u5c11app_id");
            return new CloudResultResponse("403", "\u7f3a\u5c11app_id");
        }
        if (room_id == null || room_id.length() == 0) {
            ServiceLog.getLog().warn((Object)"\u8bf7\u6c42\u901a\u8bdd(\u63a5\u542c)\u5931\u8d25\uff01\u7f3a\u5c11room_id");
            return new CloudResultResponse("403", "\u7f3a\u5c11room_id");
        }
        if (acceptUserId == null || acceptUserId.length() == 0) {
            ServiceLog.getLog().warn((Object)"\u8bf7\u6c42\u901a\u8bdd(\u63a5\u542c)\u5931\u8d25\uff01\u7f3a\u5c11acceptUserId");
            return new CloudResultResponse("403", "\u7f3a\u5c11acceptUserId");
        }
        if (acceptUserSig == null || acceptUserSig.length() == 0) {
            ServiceLog.getLog().warn((Object)"\u8bf7\u6c42\u901a\u8bdd(\u63a5\u542c)\u5931\u8d25\uff01\u7f3a\u5c11acceptUserSig");
            return new CloudResultResponse("403", "\u7f3a\u5c11acceptUserSig");
        }
        if (acceptUserName == null) {
            acceptUserName = "";
        }
        if (callUserName == null) {
            callUserName = "";
        }
        if (callUserId == null || callUserId.length() == 0) {
            ServiceLog.getLog().warn((Object)"\u8bf7\u6c42\u901a\u8bdd(\u63a5\u542c)\u5931\u8d25\uff01\u7f3a\u5c11callUserId");
            return new CloudResultResponse("403", "\u7f3a\u5c11\u547c\u53eb\u65b9callUserId");
        }
        if (channelNo == null || channelNo.length() == 0) {
            ServiceLog.getLog().warn((Object)"\u8bf7\u6c42\u901a\u8bdd(\u63a5\u542c)\u5931\u8d25\uff01\u7f3a\u5c11channelNo");
            return new CloudResultResponse("403", "\u7f3a\u5c11channelNo");
        }
        try {
            sdkAppId = Integer.parseInt(app_id);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u8bf7\u6c42\u901a\u8bdd(\u63a5\u542c)\u5931\u8d25\uff01\u9519\u8bef\u7684app_id,\u4e0d\u662f\u6574\u578b");
            return new CloudResultResponse("403", "\u9519\u8bef\u7684app_id,\u4e0d\u662f\u6574\u578b");
        }
        try {
            roomId = Integer.parseInt(room_id);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u8bf7\u6c42\u901a\u8bdd(\u63a5\u542c)\u5931\u8d25\uff01\u9519\u8bef\u7684room_id,\u4e0d\u662f\u6574\u578b");
            return new CloudResultResponse("403", "\u9519\u8bef\u7684room_id,\u4e0d\u662f\u6574\u578b");
        }
        PassChannel channel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (channel == null) {
            ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u901a\u8bdd(\u63a5\u542c)\u5931\u8d25\uff01\u9519\u8bef\u7684channelNo: " + channelNo + ", \u4e0d\u662f\u672c\u673a\u7ba1\u7406\u7684\u8f66\u9053"));
            return new CloudResultResponse("403", "\u9519\u8bef\u7684channelNo,\u4e0d\u662f\u672c\u673a\u7ba1\u7406\u7684\u8f66\u9053");
        }
        TRTCCloudContext trtcContext = ServiceUtil.getServiceContext().getTRTCCloudContext();
        if (trtcContext == null) {
            ServiceLog.getLog().warn((Object)"\u8bf7\u6c42\u901a\u8bdd(\u63a5\u542c)\u5931\u8d25\uff01\u89c6\u9891\u8bed\u97f3\u6a21\u5757\u672a\u5b8c\u6210\u542f\u52a8");
            return new CloudResultResponse("501", "TRTC\u89c6\u9891\u8bed\u97f3\u6a21\u5757\u672a\u5b8c\u6210\u542f\u52a8");
        }
        if (!trtcContext.isEnableTrtcCallAccept()) {
            ServiceLog.getLog().info((Object)"\u8bf7\u6c42\u901a\u8bdd(\u63a5\u542c)\u5931\u8d25\uff01\u63a5\u542c\u529f\u80fd\u672a\u5f00\u542f, \u5f53\u524d\u72b6\u6001\u4e0d\u63a5\u6536\u4efb\u4f55\u89c6\u9891\u901a\u8bdd");
            return new CloudResultResponse("501", "TRTC\u8f6f\u4ef6\u88ab\u8bbe\u7f6e\u7981\u6b62\u63a5\u542c");
        }
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        if (appService.getUserSession() == null || appService.getUserSession().getUser() == null) {
            ServiceLog.getLog().info((Object)"\u8bf7\u6c42\u901a\u8bdd(\u63a5\u542c)\u5931\u8d25\uff01\u7528\u6237\u672a\u767b\u5f55");
            return new CloudResultResponse("501", "\u7528\u6237\u672a\u767b\u5f55");
        }
        if (trtcContext.getTRTCCallManager().isCalling()) {
            if (trtcContext.getTRTCCallManager().getRoleType() == 2 && acceptUserId.equals(trtcContext.getTRTCCallManager().getUserId()) && callUserId.equals(trtcContext.getTRTCCallManager().getRemoteUserId()) && roomId == trtcContext.getTRTCCallManager().getRoomId() && channelNo.equals(trtcContext.getTRTCCallManager().getChannelNo())) {
                return new CloudResultResponse().success();
            }
            ServiceLog.getLog().info((Object)"\u8bf7\u6c42\u901a\u8bdd(\u63a5\u542c)\u5931\u8d25\uff01\u7528\u6237\u6b63\u5728\u63a5\u542c, \u65e0\u6cd5\u518d\u8fdb\u884c\u63a5\u542c\u5176\u4ed6\u547c\u53eb\u8bf7\u6c42");
            return new CloudResultResponse("501", "\u7528\u6237\u5fd9");
        }
        KeyValueEntry<Integer, String> r = trtcContext.getTRTCCallManager().acceptCall(sdkAppId, roomId, callType, acceptUserId, acceptUserName, acceptUserSig, callUserId, callUserName, channelNo, isAotuAnswer);
        if ((Integer)r.getKey() == 0) {
            return new CloudResultResponse().success();
        }
        if ((Integer)r.getKey() == 1 && trtcContext.getTRTCCallManager().isCalling()) {
            if (trtcContext.getTRTCCallManager().getRoleType() == 2 && acceptUserId.equals(trtcContext.getTRTCCallManager().getUserId()) && callUserId.equals(trtcContext.getTRTCCallManager().getRemoteUserId()) && roomId == trtcContext.getTRTCCallManager().getRoomId() && channelNo.equals(trtcContext.getTRTCCallManager().getChannelNo())) {
                return new CloudResultResponse().success();
            }
            ServiceLog.getLog().info((Object)"\u8bf7\u6c42\u901a\u8bdd(\u63a5\u542c)\u5931\u8d25\uff01\u7528\u6237\u6b63\u5728\u63a5\u542c, \u65e0\u6cd5\u518d\u8fdb\u884c\u63a5\u542c\u5176\u4ed6\u547c\u53eb\u8bf7\u6c42");
            return new CloudResultResponse("501", "\u7528\u6237\u5fd9");
        }
        return new CloudResultResponse("501", (String)r.getValue());
    }

    @Override
    public CloudResultResponse roomSatusNotify(Map<String, Object> paramMap, Map<String, Object> context) {
        String enter_room_user_id;
        int roomId;
        String callNotifyType = (String)paramMap.get("callNotifyType");
        String room_id = (String)paramMap.get("room_id");
        if (room_id == null || room_id.length() == 0) {
            return new CloudResultResponse().success();
        }
        try {
            roomId = Integer.parseInt(room_id);
        }
        catch (Exception ex) {
            return new CloudResultResponse().success();
        }
        TRTCCloudContext trtcContext = ServiceUtil.getServiceContext().getTRTCCloudContext();
        if (trtcContext == null) {
            return new CloudResultResponse().success();
        }
        if ("0".equals(callNotifyType)) {
            if (trtcContext.getTRTCCallManager().isCalling() && roomId == trtcContext.getTRTCCallManager().getRoomId() && trtcContext.getTRTCCallManager().getRoleType() == 2) {
                trtcContext.getTRTCCallManager().hangUp();
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u5f53\u524d\u901a\u8bdd\u5df2\u7ed3\u675f\uff0c\u5bf9\u65b9\u5df2\u6302\u65ad\u3002", 1));
            }
        } else if ("1".equals(callNotifyType) && roomId == trtcContext.getTRTCCallManager().getRoomId() && trtcContext.getTRTCCallManager().getRoleType() == 2 && !trtcContext.getTRTCCallManager().isEnterRoom() && (enter_room_user_id = (String)paramMap.get("user_id")) != null && enter_room_user_id.length() > 0 && !enter_room_user_id.equals(trtcContext.getTRTCCallManager().getUserId())) {
            String userName = (String)paramMap.get("user_name");
            String ax = "\u901a\u8bdd\u5df2\u5728\u522b\u7684\u8bbe\u5907\u63a5\u542c!";
            if (userName != null && userName.length() > 0) {
                ax = String.valueOf(ax) + " \u63a5\u542c\u7528\u6237\uff1a" + userName;
            }
            trtcContext.getTRTCCallManager().hangUp();
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, ax, 1));
        }
        return new CloudResultResponse().success();
    }

    @Override
    public CloudResultResponse setSenselessConfigs(Map<String, Object> paramMap, Map<String, Object> context) {
        Map<String, Object> map;
        CloudMsgService cloudMsgService = (CloudMsgService)ServiceUtil.getServiceContext().getService(CloudMsgService.class);
        try {
            map = cloudMsgService.senseLessConfigs(paramMap, context);
        }
        catch (Exception e) {
            ServiceLog.getLog().warn((Object)"\u8bbe\u7f6e\u65e0\u611f\u652f\u4ed8\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
            return new CloudResultResponse("500", "\u5185\u90e8\u9519\u8bef");
        }
        CloudResultResponse r = new CloudResultResponse();
        r.putAll(map);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CloudResultResponse senceLessPaySuccess(Map<String, String> paramMap, Map<String, Object> context) {
        String v;
        Date payTime;
        String cloudOrderNo = paramMap.get("cloudOrderNo");
        if (cloudOrderNo == null) return CloudResultResponse.createResponse("403", "\u7f3a\u5c11\u8ba2\u5355\u53f7");
        if (cloudOrderNo.length() == 0) {
            return CloudResultResponse.createResponse("403", "\u7f3a\u5c11\u8ba2\u5355\u53f7");
        }
        BigDecimal payAmount = new BigDecimal(paramMap.get("payAmount"));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            payTime = df.parse(paramMap.get("payTime"));
        }
        catch (ParseException e) {
            return CloudResultResponse.createResponse("403", "payTime \u65e5\u671f\u683c\u5f0f\u9519\u8bef");
        }
        Integer payMethod = Integer.valueOf(paramMap.get("payMethod"));
        Integer payScene = Integer.valueOf(paramMap.get("payScene"));
        Integer chargeOrg = Integer.valueOf(paramMap.get("chargeOrg"));
        Integer payEntry = Integer.valueOf(paramMap.get("payEntry"));
        Long selfId = Long.valueOf(paramMap.get("selfPayId"));
        String parkId = paramMap.get("parkId");
        if (parkId == null || parkId.length() == 0) {
            parkId = "0";
        }
        String _tranDes = paramMap.get("tranDes");
        String outOrderNo = paramMap.get("outOrderNo");
        if (outOrderNo == null) return CloudResultResponse.createResponse("403", "\u7f3a\u5c11outOrderNo");
        if (outOrderNo.length() == 0) {
            return CloudResultResponse.createResponse("403", "\u7f3a\u5c11outOrderNo");
        }
        String sv = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("MAXSTAY_TIME_LENGTH");
        int maxAllowMinus = 15;
        try {
            if (sv != null && sv.length() > 0) {
                maxAllowMinus = Integer.parseInt(sv);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (maxAllowMinus <= 0) {
            maxAllowMinus = 15;
        }
        String snamex1 = ".senceLessPaySuccess";
        if (context != null && (v = (String)context.get("zinvokeMethodName")) != null && v.length() > 0) {
            snamex1 = "." + v;
        }
        LinkedList<CarparkDispatchTask> dispatchTaskList = new LinkedList<CarparkDispatchTask>();
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CarparkPassSelfPay sefPay = null;
        CarparkTransaction t = null;
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Long queryId = null;
        try {
            SenselessOrderNo senselessOrderNo;
            if (outOrderNo.startsWith(SenselessOrderNo.PREFIX) && (senselessOrderNo = SenselessOrderNo.parse(outOrderNo)) != null) {
                if (!ServiceUtil.getServiceContext().getLocalHostNo().equals(senselessOrderNo.getHostNo())) {
                    ServiceLog.getLog().warn((Object)("\u4e0d\u5904\u7406\u652f\u4ed8\u6d88\u606f, \u4e3b\u673a\u7f16\u53f7\uff1a" + senselessOrderNo.getHostNo() + "\u4e0d\u662f\u672c\u673a,\u8bf7\u68c0\u67e5\uff0c\u4e0d\u5e94\u8be5\u6536\u5230\u6b64\u6d88\u606f\uff0c \u4e22\u5f03\u652f\u4ed8\u6210\u529f\u6d88\u606f\uff1a" + paramMap));
                    return CloudResultResponse.createSuccessResponse();
                }
                queryId = senselessOrderNo.getQueryFeeId();
            }
            if (queryId == null) {
                queryId = Long.valueOf(outOrderNo.substring(0, outOrderNo.lastIndexOf(95)));
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u89e3\u6790\u7684outOrderNo, \u4e22\u5f03\u652f\u4ed8\u6210\u529f\u6d88\u606f\uff1a" + paramMap));
            return CloudResultResponse.createSuccessResponse();
        }
        KeyLockManager keyLockManager = ServiceUtil.getServiceContext().getKeyLockManager();
        Object lock = keyLockManager.getLock("cloudOrderNO+" + cloudOrderNo);
        Object object = lock;
        synchronized (object) {
            block54: {
                String sname = String.valueOf(parkId) + snamex1;
                CarparkCloudOrderMessage message = (CarparkCloudOrderMessage)daoService.selectOne(new SearchParam().addEQ("order_no", (Object)cloudOrderNo).addEQ("name", (Object)sname), CarparkCloudOrderMessage.class);
                if (message == null) {
                    CarparkQueryFee queryFee = (CarparkQueryFee)daoService.selectOne(new SearchParam().addEQ("id", (Object)queryId), CarparkQueryFee.class);
                    if (queryFee == null) {
                        ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u627e\u5230\u67e5\u8d39\u8ba2\u5355\uff0c\u4e22\u5f03\u652f\u4ed8\u6210\u529f\u6d88\u606f\uff1a" + paramMap));
                        CloudResultResponse cloudResultResponse = CloudResultResponse.createSuccessResponse();
                        // MONITOREXIT @DISABLED, blocks:[3, 4, 52, 40, 12] lbl73 : MonitorExitStatement: MONITOREXIT : var28_31
                        keyLockManager.releaseLock(lock);
                        return cloudResultResponse;
                    }
                    String preferentialList = paramMap.get("preferentialList");
                    boolean queryFeeChanged = CloudMsgServiceImpl.checkCarparkQueryFeeChanged(queryFee, preferentialList, daoService);
                    if (queryFeeChanged) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    Calendar cl = Calendar.getInstance();
                    cl.set(14, 0);
                    Date now = cl.getTime();
                    try (SqlSession session = daoService.openSqlSession();){
                        try {
                            message = new CarparkCloudOrderMessage();
                            message.setCarpark_id(carpark_id);
                            message.setCreated_time(now);
                            message.setId(daoService.getSequece("ck_common_seq"));
                            message.setName(sname);
                            message.setOrder_no(cloudOrderNo);
                            message.setProject_id(project_id);
                            sefPay = new CarparkPassSelfPay();
                            sefPay.setId(selfId);
                            sefPay.setPaid_amount(payAmount);
                            sefPay.setPaid_method(payMethod);
                            sefPay.setPay_scene(payScene);
                            sefPay.setCharge_org(chargeOrg);
                            sefPay.setPay_entry(payEntry);
                            if (queryFee.getEnter_time() != null) {
                                long ax = payTime.getTime() - queryFee.getEnter_time().getTime();
                                if (ax < 0L) {
                                    ServiceLog.getLog().warn((Object)("\u652f\u4ed8\u6210\u529f\u6d88\u606f\u7684\u652f\u4ed8\u65f6\u95f4\u6bd4\u5165\u573a\u65f6\u95f4\u5c0f\u4e8e1s\uff0c\u8fd9\u662f\u662f\u5426\u65f6\u95f4\u540c\u6b65\u51fa\u73b0\u95ee\u9898\uff01\u8bf7\u68c0\u67e5! \u652f\u4ed8\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(payTime) + ", \u5165\u573a\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(queryFee.getEnter_time()) + ", \u652f\u4ed8\u8f66\u724c: " + queryFee.getPlate_number() + ", \u8ba2\u5355\u53f7: " + cloudOrderNo + "! "));
                                }
                                if (queryFee.getEnter_pay() != null && queryFee.getEnter_pay() == 1 && ax < 1000L) {
                                    cl.setTime(queryFee.getEnter_time());
                                    cl.add(13, 1);
                                    payTime = cl.getTime();
                                }
                            }
                            sefPay.setPaid_time(payTime);
                            if (queryFee.getEnter_pay() != null && queryFee.getEnter_pay() == 1) {
                                if (queryFee.getCharge_time_length() != null && queryFee.getCharge_time_length() > 0) {
                                    maxAllowMinus = queryFee.getCharge_time_length();
                                    if (queryFee.getEnter_time() != null) {
                                        cl.setTime(queryFee.getEnter_time());
                                    } else {
                                        cl.setTime(payTime);
                                    }
                                    cl.add(12, maxAllowMinus);
                                } else {
                                    cl.setTime(payTime);
                                    cl.add(12, maxAllowMinus);
                                }
                            } else {
                                cl.setTime(payTime);
                                cl.add(12, maxAllowMinus);
                            }
                            sefPay.setPlan_leave_time(cl.getTime());
                            sefPay.setPassport_number(queryFee.getPassport_number());
                            sefPay.setMedium_type(queryFee.getMedium_type());
                            sefPay.setEnter_time(queryFee.getEnter_time());
                            sefPay.setCharge_start_time(queryFee.getCharge_start_time());
                            sefPay.setPlate_number(queryFee.getPlate_number());
                            sefPay.setEnter_record_no(queryFee.getEnter_record_no());
                            sefPay.setShould_charge(queryFee.getShould_charge());
                            sefPay.setDiscount_money(queryFee.getDiscount_money());
                            sefPay.setAlready_paid(queryFee.getAlready_paid());
                            sefPay.setPeriod_multi_free(queryFee.getPeriod_multi_free());
                            sefPay.setPeriod_multi_received(queryFee.getPeriod_multi_received());
                            sefPay.setPeriod_multi_start(queryFee.getPeriod_multi_start());
                            sefPay.setNext_period_multi_cur(queryFee.getNext_period_multi_cur());
                            sefPay.setNext_period_multi_start(queryFee.getNext_period_multi_start());
                            sefPay.setCharge_time_length(queryFee.getCharge_time_length());
                            sefPay.setCloud_order_no(cloudOrderNo);
                            sefPay.setCreated_time(now);
                            sefPay.setCarpark_id(carpark_id);
                            sefPay.setProject_id(project_id);
                            sefPay.setDuty_no(queryFee.getDuty_no());
                            sefPay.setDiscounts_json(queryFee.getDiscounts_json());
                            t = new CarparkTransaction();
                            long tranId = appService.createLocalRecordSeq("ck_carpark_transaction_seq");
                            t.setId(tranId);
                            t.setTansaction_no("C" + t.getId().toString());
                            t.setTran_type(0);
                            t.setService_type(0);
                            t.setPlate_number(sefPay.getPlate_number());
                            t.setPassport_number(sefPay.getPassport_number());
                            t.setMedium_type(sefPay.getMedium_type());
                            t.setPassport_no(queryFee.getPassport_no());
                            t.setPass_type(queryFee.getPass_type());
                            t.setPassport_type_no(queryFee.getPassport_type_no());
                            t.setPassport_type_name(queryFee.getPassport_type_name());
                            t.setCar_type_no(queryFee.getCar_type_no());
                            t.setCar_type_name(queryFee.getCar_type_name());
                            t.setOrder_no(sefPay.getCloud_order_no());
                            t.setTran_money(sefPay.getPaid_amount());
                            t.setTran_time(sefPay.getPaid_time());
                            t.setPay_method(sefPay.getPaid_method());
                            t.setPay_scene(sefPay.getPay_scene());
                            t.setCharge_org(sefPay.getCharge_org());
                            t.setPay_entry(sefPay.getPay_entry());
                            t.setTran_area_no(queryFee.getTran_area_no());
                            t.setTran_area_name(queryFee.getTran_area_name());
                            t.setTran_channel_no(queryFee.getTran_area_no());
                            t.setTran_channel_name(queryFee.getTran_area_name());
                            t.setTran_user_no(queryFee.getTran_user_no());
                            t.setTran_user_name(queryFee.getTran_user_name());
                            t.setDuty_no(sefPay.getDuty_no());
                            t.setEnter_record_no(sefPay.getEnter_record_no());
                            t.setEnter_time(sefPay.getEnter_time());
                            t.setOperate_user_code(queryFee.getOperate_user_code());
                            t.setOperate_user_name(queryFee.getOperate_user_name());
                            if (_tranDes != null && _tranDes.length() > 0) {
                                t.setTran_des(ServiceUtil.getString("\u4e34\u505c" + _tranDes, 200));
                            } else {
                                t.setTran_des("\u65e0\u611f\u652f\u4ed8");
                            }
                            t.setShould_charge(sefPay.getShould_charge());
                            t.setDiscount_money(sefPay.getDiscount_money());
                            t.setAlready_paid(sefPay.getAlready_paid());
                            t.setPeriod_multi_free(sefPay.getPeriod_multi_free());
                            t.setHost_no(queryFee.getHost_no());
                            t.setHost_name(queryFee.getHost_name());
                            t.setCreated_time(sefPay.getCreated_time());
                            t.setCarpark_id(sefPay.getCarpark_id());
                            t.setProject_id(sefPay.getProject_id());
                            t.setExit_time(null);
                            sefPay.setCharge_record_no(t.getTansaction_no());
                            dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(daoService.getTableName(CarparkTransaction.class), t.getId().toString(), "ALL_HOSTS"));
                            try {
                                StringBuilder bsr = new StringBuilder();
                                if (sefPay.getPlate_number() != null && sefPay.getPlate_number().length() > 0) {
                                    bsr.append(sefPay.getPlate_number()).append(", ");
                                }
                                if (sefPay.getMedium_type() != null && sefPay.getMedium_type() != 6) {
                                    bsr.append("\u5361\u53f7\uff1a").append(sefPay.getPassport_number()).append(", ");
                                }
                                bsr.append("\u65e0\u611f\u652f\u4ed8").append(": ").append(sefPay.getPaid_amount()).append(", ");
                                if (sefPay.getPaid_time() != null) {
                                    bsr.append("\u652f\u4ed8\u65f6\u95f4: ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(sefPay.getPaid_time()));
                                }
                                bsr.append("\u8ba2\u5355\u53f7: ").append(sefPay.getCloud_order_no());
                                ServiceLog.getLog().info((Object)("\u652f\u4ed8\u901a\u77e5: " + bsr.toString()));
                            }
                            catch (Exception bsr) {
                                // empty catch block
                            }
                            daoService.insert(session, (Object)message);
                            daoService.insert(session, (Object)sefPay);
                            daoService.insert(session, (Object)t);
                            if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
                                for (CarparkDispatchTask task : dispatchTaskList) {
                                    daoService.insert(session, (Object)task);
                                }
                            }
                            session.commit();
                            break block54;
                        }
                        catch (Exception ex) {
                            session.rollback();
                            throw ex;
                        }
                    }
                }
                ServiceLog.getLog().warn((Object)("\u6536\u5230\u91cd\u590d\u652f\u4ed8\u6d88\u606f\uff1a" + paramMap + ",\u4e22\u5f03!"));
                CloudResultResponse cloudResultResponse = CloudResultResponse.createSuccessResponse();
                // MONITOREXIT @DISABLED, blocks:[3, 4, 12] lbl241 : MonitorExitStatement: MONITOREXIT : var28_31
                keyLockManager.releaseLock(lock);
                return cloudResultResponse;
            }
        }
        if (dispatchTaskList != null && !dispatchTaskList.isEmpty()) {
            appService.asynTryRunDispatchTask(dispatchTaskList);
        }
        if (sefPay == null) return CloudResultResponse.createSuccessResponse();
        appService.asynHandleSelfPay(sefPay);
        return CloudResultResponse.createSuccessResponse();
    }

    @Override
    public CloudResultResponse openPole(Map<String, String> paramMap, Map<String, Object> context) {
        CloudMsgService CloudMsgService2 = (CloudMsgService)ServiceUtil.getServiceContext().getService(CloudMsgService.class);
        return CloudMsgService2.openPole(paramMap, context);
    }

    @Override
    public CloudResultResponse downPole(Map<String, String> paramMap, Map<String, Object> context) {
        CloudMsgService CloudMsgService2 = (CloudMsgService)ServiceUtil.getServiceContext().getService(CloudMsgService.class);
        return CloudMsgService2.downPole(paramMap, context);
    }

    @Override
    public CloudResultResponse otherHostConfirming(Map<String, String> paramMap, Map<String, Object> context) {
        int mediaType;
        String confirmHostNo = paramMap.get("confirmHostNo");
        String confirmChannelNo = paramMap.get("confirmChannelNo");
        String confirmPassportNumber = paramMap.get("confirmPassportNumber");
        String confirmPassMediaType = paramMap.get("confirmPassMediaType");
        String confirmPassTime = paramMap.get("confirmPassTime");
        if (ServiceUtil.getServiceContext().getLocalHostNo().equals(confirmHostNo)) {
            return new CloudResultResponse().success();
        }
        Date passTime = null;
        try {
            if (confirmPassTime != null && confirmPassTime.length() > 0) {
                passTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(confirmPassTime);
            }
            mediaType = Integer.parseInt(confirmPassMediaType);
        }
        catch (Exception ex) {
            return new CloudResultResponse("403", "\u53c2\u6570\u9519\u8bef");
        }
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        applicationService.closeConfirmDialogWithout(confirmChannelNo, confirmPassportNumber, mediaType, passTime);
        return new CloudResultResponse().success();
    }

    @Override
    public CloudResultResponse senselessPayContract(Map<String, String> paramMap, Map<String, Object> context) {
        CloudMsgService cloudMsgService = (CloudMsgService)ServiceUtil.getServiceContext().getService(CloudMsgService.class);
        Map<String, Object> map = cloudMsgService.senselessPayContract(paramMap, context);
        CloudResultResponse s = new CloudResultResponse();
        s.putAll(map);
        return s;
    }

    @Override
    public CloudResultResponse cancelPassRecord(Map<String, String> paramMap, Map<String, Object> context) {
        String recordNo;
        String dataJson = paramMap.get("cancelPassRecordJson");
        if (dataJson == null || dataJson.length() == 0) {
            return new CloudResultResponse("403", "\u7f3a\u5c11\u53c2\u6570cancelPassRecordJson");
        }
        CarparkCancelPassRecord t = (CarparkCancelPassRecord)GsonBuilder.create().fromJson(dataJson, CarparkCancelPassRecord.class);
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        String tableName = daoService.getTableName(CarparkCancelPassRecord.class);
        SearchParam sp = new SearchParam(tableName);
        sp.addEQ("pass_time", (Object)t.getPass_time());
        sp.addEQ("carpark_id", (Object)t.getCarpark_id());
        if (t.getExit_time() != null) {
            recordNo = t.getExit_record_no();
            sp.addEQ("exit_record_no", (Object)recordNo);
        } else {
            recordNo = t.getEnter_record_no();
            sp.addEQ("enter_record_no", (Object)recordNo);
        }
        if (recordNo == null || recordNo.length() == 0) {
            ServiceLog.getLog().error((Object)("\u53d6\u6d88\u8bb0\u5f55\u7f3a\u5c11exit_record_no \u6216enter_record_no,\u4e22\u5f03\u53d6\u6d88\u8bb0\u5f55\uff01" + dataJson));
            return new CloudResultResponse().success();
        }
        long count = daoService.selectCount(sp);
        if (count == 0L) {
            Long id = null;
            if (recordNo.startsWith("C")) {
                try {
                    id = Long.valueOf(recordNo.substring(1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (id != null) {
                t.setId(id);
            } else {
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                long tranId = appService.createLocalRecordSeq("ck_carpark_transaction_seq");
                t.setId(tranId);
            }
            CloudCarparkDataSyncService.downloadPassRecordPic(null, t);
            CommonRemoteService commonRemoteService = (CommonRemoteService)ServiceUtil.getServiceContext().getService("commonRemoteService");
            SyncDBRecord record = new SyncDBRecord();
            record.setTableName(tableName);
            record.setJsonRecord(GsonBuilder.create().toJson((Object)t));
            SyncDBRecordResult result = commonRemoteService.synDBRecord(record, context);
            if (!result.isSuccess()) {
                return new CloudResultResponse(result.getResponseCode(), result.getResponseMsg());
            }
            if (result.getReturnCode() == null) {
                return new CloudResultResponse("501", "unknown returnCode!");
            }
            if (result.getReturnCode() == 0) {
                return new CloudResultResponse().success();
            }
            return new CloudResultResponse("501", result.getReturnMsg());
        }
        return new CloudResultResponse().success();
    }

    @Override
    public CloudResultResponse closeEscapeOrder(Map<String, Object> paramMap1, Map<String, Object> context) {
        Date opTime;
        Map paramMap;
        String dataJson = (String)paramMap1.get("dataJson");
        if (dataJson == null || dataJson.length() == 0) {
            ServiceLog.getLog().warn((Object)"\u7f3a\u5c11\u53c2\u6570dataJson\uff0c\u653e\u5f03\u5173\u95ed\u53d6\u6d88\u653e\u884c\u672a\u652f\u4ed8\u8ba2\u5355! ");
            return new CloudResultResponse().success();
        }
        try {
            paramMap = (Map)GsonBuilder.create().fromJson(dataJson, new TypeToken<Map<String, String>>(){}.getType());
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6548\u53c2\u6570dataJson" + dataJson + "\uff0c\u653e\u5f03\u5173\u95ed\u53d6\u6d88\u653e\u884c\u672a\u652f\u4ed8\u8ba2\u5355! "));
            return new CloudResultResponse().success();
        }
        String opUserCode = (String)paramMap.get("opUserCode");
        String opUserName = (String)paramMap.get("opUserName");
        String opTime0 = (String)paramMap.get("opTime");
        String passport_number = (String)paramMap.get("passport_number");
        String medium_type = (String)paramMap.get("medium_type");
        String exit_time = (String)paramMap.get("exit_time");
        String exit_record_no = (String)paramMap.get("exit_record_no");
        if (opUserCode == null || opUserCode.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570opUserCode\uff0c\u653e\u5f03\u5173\u95ed\u53d6\u6d88\u653e\u884c\u672a\u652f\u4ed8\u8ba2\u5355: " + paramMap));
            return new CloudResultResponse().success();
        }
        if (opUserName == null || opUserName.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570opUserName\uff0c\u653e\u5f03\u5173\u95ed\u53d6\u6d88\u653e\u884c\u672a\u652f\u4ed8\u8ba2\u5355: " + paramMap));
            return new CloudResultResponse().success();
        }
        if (opTime0 == null || opTime0.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u7f3a\u5c11\u53c2\u6570opTime\uff0c\u653e\u5f03\u5173\u95ed\u53d6\u6d88\u653e\u884c\u672a\u652f\u4ed8\u8ba2\u5355: " + paramMap));
            return new CloudResultResponse().success();
        }
        try {
            opTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(opTime0);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("opTime\u683c\u5f0f\u5e94\u8be5\u4e3ayyyy-MM-dd HH:mm:ss\uff0c\u653e\u5f03\u5173\u95ed\u53d6\u6d88\u653e\u884c\u672a\u652f\u4ed8\u8ba2\u5355: " + paramMap));
            return new CloudResultResponse().success();
        }
        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        recordSaveService.closeCarparkEscapeOrder(passport_number, medium_type, exit_time, exit_record_no, opUserCode, opUserName, opTime, false);
        return new CloudResultResponse().success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloudResultResponse addPreRecord(Map<String, String> paramMap, Map<String, Object> context) {
        String passRecordJson = paramMap.get("passRecordJson");
        if (passRecordJson == null || passRecordJson.length() == 0) {
            return new CloudResultResponse("403", "\u7f3a\u5c11\u53c2\u6570passRecordJson");
        }
        CarparkPassRecord passRecord = (CarparkPassRecord)GsonBuilder.create().fromJson(passRecordJson, CarparkPassRecord.class);
        if (passRecord.getEnter_time() == null) {
            LogUtil.getLog().error((Object)("\u4e22\u5f03\u65b0\u589e\u5728\u573a\u8f66\u8f86\u8bb0\u5f55,\u539f\u56e0\u5165\u573a\u65f6\u95f4\u4e3anull," + passRecordJson));
            return new CloudResultResponse().success();
        }
        if (passRecord.getExit_time() != null) {
            LogUtil.getLog().error((Object)("\u4e22\u5f03\u65b0\u589e\u5728\u573a\u8f66\u8f86\u8bb0\u5f55,\u539f\u56e0\u79bb\u573a\u65f6\u95f4\u4e0d\u4e3anull," + passRecordJson));
            return new CloudResultResponse().success();
        }
        if (passRecord.getCreated_time() == null) {
            LogUtil.getLog().error((Object)("\u4e22\u5f03\u65b0\u589e\u5728\u573a\u8f66\u8f86\u8bb0\u5f55,\u539f\u56e0\u79bb\u573a\u65f6\u95f4\u4e3anull," + passRecordJson));
            return new CloudResultResponse().success();
        }
        if (passRecord.getEnter_record_no() == null || !passRecord.getEnter_record_no().startsWith("C") && !passRecord.getEnter_record_no().startsWith("S")) {
            return new CloudResultResponse("403", "\u65e0\u6cd5\u5904\u7406\u7684\u5165\u573a\u7f16\u53f7");
        }
        long id = Long.valueOf(passRecord.getEnter_record_no().substring(1));
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        String passRecordTableName = commonDaoService.getTableName(CarparkPassRecord.class);
        KeyLockManager keyLockManager = ServiceUtil.getServiceContext().getKeyLockManager();
        Object lock = keyLockManager.getLock("commonRemoteService-synDBRecord-" + passRecordTableName + "-" + id);
        try {
            Object object = lock;
            synchronized (object) {
                long count = commonDaoService.selectCount(new SearchParam(passRecordTableName).addEQ("id", (Object)id));
                if (count == 0L) {
                    count = commonDaoService.selectCount(new SearchParam(passRecordTableName).addEQ("passport_number", (Object)passRecord.getPassport_number()).addEQ("medium_type", (Object)passRecord.getMedium_type()).addGT("pass_time", (Object)passRecord.getCreated_time()));
                    if (count > 0L) {
                        LogUtil.getLog().error((Object)("\u4e22\u5f03\u65b0\u589e\u5728\u573a\u8f66\u8f86\u8bb0\u5f55,\u539f\u56e0:\u5b58\u5728\u6bd4\u64cd\u4f5c(\u521b\u5efa)\u65f6\u95f4\u66f4\u65b0\u7684\u901a\u884c\u8bb0\u5f55," + passRecordJson));
                    } else {
                        String presenceRecordTableName = commonDaoService.getTableName(CarparkPresenceRecord.class);
                        count = commonDaoService.selectCount(new SearchParam(presenceRecordTableName).addEQ("id", (Object)id));
                        if (count == 0L) {
                            CarparkPresenceRecord presenceRecord = new CarparkPresenceRecord();
                            JavaBeanTool.copyTo((Object)passRecord, (Object)presenceRecord);
                            commonDaoService.insert((Object)presenceRecord);
                        }
                        commonDaoService.insert((Object)passRecord);
                        if (count == 0L) {
                            LogUtil.getLog().info((Object)("\u6210\u529f\u65b0\u589e\u4e00\u7b14\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\uff1a\u7f16\u53f7\uff1a" + passRecord.getEnter_record_no() + ", " + passRecord.getPassport_number() + ", " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(passRecord.getEnter_time())));
                        }
                    }
                }
            }
        }
        finally {
            keyLockManager.releaseLock(lock);
        }
        return new CloudResultResponse().success();
    }
}

