/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.service.impl.remote;

import com.google.gson.Gson;
import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.DispatchDataTaskUtil;
import com.wovoe.carpark.ParkingSpace;
import com.wovoe.carpark.RpcReomtecServiceFactory;
import com.wovoe.carpark.ThirdApiService;
import com.wovoe.carpark.ValidateUtil;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkAttribute;
import com.wovoe.carpark.dto.CarparkCarOwner;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkDiscountProject;
import com.wovoe.carpark.dto.CarparkDiscountRecord;
import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkOperationLog;
import com.wovoe.carpark.dto.CarparkPassDiscount;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkRegplateRecord;
import com.wovoe.carpark.dto.CarparkTranConfig;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.CarparkCommonService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.service.remote.CloudMsgService;
import com.wovoe.carpark.service.remote.CommonRemoteService;
import com.wovoe.carpark.service.remote.ThirdInvokeService;
import com.wovoe.carpark.vo.ChannelEquipmentVo;
import com.wovoe.carpark.vo.ParingSpaceVo;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JavaBeanTool;
import com.wovoe.framework.ObjectCreateCallback;
import com.wovoe.framework.Service;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.session.SqlSession;

@Service
public class ThirdInvokeServiceImpl
implements ThirdInvokeService {
    @Override
    @ThirdApiService
    public void queryRegPlateRecords(Map<String, String> paramMap, PrintWriter writer) {
        List list;
        Date qTimeEnd;
        Date qTimeBegin;
        String timeBegin = paramMap.get("timeBegin");
        String timeEnd = paramMap.get("timeEnd");
        if (timeBegin == null || timeBegin.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: timeBegin");
            return;
        }
        if (timeEnd == null || timeEnd.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: timeEnd");
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            qTimeBegin = df.parse(timeBegin);
        }
        catch (Exception ex) {
            this.printErr(writer, "PARAM_ERROR", "timeBegin\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u5e94\u8be5\u4e3a: yyyy-MM-dd HH:mm:ss");
            return;
        }
        try {
            qTimeEnd = df.parse(timeEnd);
        }
        catch (Exception ex) {
            this.printErr(writer, "PARAM_ERROR", "timeEnd\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u5e94\u8be5\u4e3a: yyyy-MM-dd HH:mm:ss");
            return;
        }
        String begin = "{\"code\":\"SUCCESS\",\"msg\":\"\u64cd\u4f5c\u6210\u529f\",\"data\":[";
        String end = "]}";
        String q_plate_number = paramMap.get("plate_number");
        if (q_plate_number != null && q_plate_number.length() > 0) {
            q_plate_number = q_plate_number.toUpperCase();
        }
        int fethSize = 500;
        CommonDaoService commonServie = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        long id = 0L;
        writer.print(begin);
        Gson gosn = GsonBuilder.create();
        boolean isprintFirst = true;
        Map<String, CarparkChannel> channelmap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
        Map<String, List<ChannelEquipmentVo>> ceMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelEquipmentVoListMap();
        HashMap<String, String> cameraMap = new HashMap<String, String>();
        do {
            Pagination pagination = new Pagination();
            pagination.setNeedQueryCount(false);
            pagination.setGotoPage(1);
            pagination.setRecordsCount((long)fethSize);
            pagination.setPageSize(fethSize);
            SearchParam sp = new SearchParam(commonServie.getTableName(CarparkRegplateRecord.class));
            sp.addGT("id", (Object)id).addGTE("reg_time", (Object)qTimeBegin).addLT("reg_time", (Object)qTimeEnd).setOrerbySql("id ASC");
            if (q_plate_number != null && q_plate_number.length() > 0) {
                sp.addEQ("plate_number", (Object)q_plate_number);
            }
            if ((list = commonServie.selectList(sp, pagination)) == null || list.isEmpty()) break;
            for (Map objMap : list) {
                CarparkChannel ch;
                id = (Long)objMap.get("id");
                String plate_number = (String)objMap.get("plate_number");
                if (plate_number == null || plate_number.length() < 6) continue;
                LinkedHashMap<String, String> returnMap = new LinkedHashMap<String, String>();
                returnMap.put("reg_no", (String)objMap.get("reg_no"));
                returnMap.put("plate_number", (String)objMap.get("plate_number"));
                returnMap.put("reg_time", df.format((Date)objMap.get("reg_time")));
                String channel_name = "";
                String camera_ip = "";
                String channel_no = (String)objMap.get("channel_no");
                if (channel_no != null && channel_no.length() > 0 && channelmap != null && (ch = channelmap.get(channel_no)) != null) {
                    channel_name = ch.getChannel_name();
                }
                returnMap.put("channel_name", channel_name);
                String camera_no = (String)objMap.get("camera_no");
                if (camera_no != null && camera_no.length() > 0) {
                    String caip = (String)cameraMap.get(camera_no);
                    if (caip == null) {
                        ChannelEquipmentVo vo = this.findChannelEquipmentVo(ceMap, channel_no, camera_no);
                        if (vo != null) {
                            caip = vo.getEquipment_ip();
                        }
                        if (caip == null) {
                            caip = "";
                        }
                        cameraMap.put(camera_no, caip);
                    }
                    camera_ip = caip;
                }
                returnMap.put("camera_ip", camera_ip);
                returnMap.put("plate_color", this.getStringValue("plate_color", objMap, ""));
                returnMap.put("plate_type", this.getStringValue("plate_type", objMap, ""));
                returnMap.put("car_color", this.getStringValue("car_color", objMap, ""));
                returnMap.put("car_type", this.getStringValue("car_type", objMap, ""));
                returnMap.put("car_logo", this.getStringValue("car_logo", objMap, ""));
                String big_pic_path1 = (String)objMap.get("big_pic_path");
                String small_pic_path1 = (String)objMap.get("small_pic_path");
                String big_pic_path = "";
                String small_pic_path = "";
                if (big_pic_path1 != null && big_pic_path1.length() > 0) {
                    try {
                        big_pic_path = BytesTool.compressBytes((byte[])big_pic_path1.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                if (small_pic_path1 != null && small_pic_path1.length() > 0) {
                    try {
                        small_pic_path = BytesTool.compressBytes((byte[])small_pic_path1.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                returnMap.put("big_pic_path", big_pic_path);
                returnMap.put("small_pic_path", small_pic_path);
                if (isprintFirst) {
                    isprintFirst = false;
                } else {
                    writer.print(',');
                }
                writer.print(gosn.toJson(returnMap));
                writer.flush();
            }
        } while (list.size() >= fethSize);
        writer.print(end);
    }

    private String getStringValue(String name, Map<String, Object> objMap, String defaultValue) {
        Object obj = objMap.get(name);
        if (obj == null) {
            return defaultValue;
        }
        return obj.toString();
    }

    private ChannelEquipmentVo findChannelEquipmentVo(Map<String, List<ChannelEquipmentVo>> ceMap, String channelNo, String eqNo) {
        if (ceMap == null || channelNo == null || channelNo.length() == 0 || eqNo == null || eqNo.length() == 0) {
            return null;
        }
        List<ChannelEquipmentVo> list = ceMap.get(channelNo);
        if (list == null) {
            return null;
        }
        for (ChannelEquipmentVo vo : list) {
            if (vo == null || !eqNo.equals(vo.getEquipment_no())) continue;
            return vo;
        }
        return null;
    }

    private void printErr(PrintWriter writer, String errcode, String msg) {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("code", errcode);
        dataMap.put("msg", msg);
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void queryAllCameras(Map<String, String> paramMap, PrintWriter writer) {
        Map<String, CarparkChannel> tMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
        Map<String, List<ChannelEquipmentVo>> eqMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelEquipmentVoListMap();
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        resultMap.put("code", "SUCCESS");
        resultMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        LinkedList list = new LinkedList();
        resultMap.put("data", list);
        if (tMap != null && !tMap.isEmpty() && eqMap != null && !eqMap.isEmpty()) {
            for (CarparkChannel channel : tMap.values()) {
                List<ChannelEquipmentVo> eqList = eqMap.get(channel.getChannel_no());
                if (eqList == null) continue;
                for (ChannelEquipmentVo vo : eqList) {
                    if (vo.getEquipment_type() == null || 33 != vo.getEquipment_type()) continue;
                    HashMap<String, String> vmap = new HashMap<String, String>();
                    vmap.put("camera_no", vo.getEquipment_no());
                    vmap.put("camera_name", vo.getEquipment_name());
                    vmap.put("camera_ip", vo.getEquipment_ip());
                    vmap.put("channel_name", channel.getChannel_name());
                    vmap.put("channel_no", channel.getChannel_no());
                    list.add(vmap);
                }
            }
        }
        writer.print(GsonBuilder.create().toJson(resultMap));
    }

    @Override
    @ThirdApiService
    public void openPole(Map<String, String> paramMap, PrintWriter writer) {
        Map<String, Object> rpcResultMap;
        CommonRemoteService commonRemoteService;
        String camera_no = paramMap.get("camera_no");
        if (camera_no == null || camera_no.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: camera_no");
            return;
        }
        Map<String, CarparkChannel> tMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
        Map<String, List<ChannelEquipmentVo>> eqMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelEquipmentVoListMap();
        CarparkChannel passChannel = null;
        if (tMap != null && !tMap.isEmpty() && eqMap != null && !eqMap.isEmpty()) {
            for (CarparkChannel channel : tMap.values()) {
                List<ChannelEquipmentVo> eqList = eqMap.get(channel.getChannel_no());
                if (eqList != null) {
                    for (ChannelEquipmentVo vo : eqList) {
                        if (vo.getEquipment_type() == null || 33 != vo.getEquipment_type() || !camera_no.equals(vo.getEquipment_no())) continue;
                        passChannel = channel;
                        break;
                    }
                }
                if (passChannel == null) continue;
            }
        }
        if (passChannel == null) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: \u65e0\u6548\u76f8\u673a\u7f16\u53f7");
            return;
        }
        if (passChannel.getManaged_host_no() == null || passChannel.getManaged_host_no().length() == 0) {
            this.printErr(writer, "CONFIG_ERROR", "\u8be5\u76f8\u673a\u672a\u5206\u914d\u7ba1\u7406\u4e3b\u673a");
            return;
        }
        if (passChannel.getManaged_host_no().equals(ServiceUtil.getServiceContext().getLocalHostNo())) {
            commonRemoteService = (CommonRemoteService)ServiceUtil.getServiceContext().getService(CommonRemoteService.class);
        } else {
            CarparkHost host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(passChannel.getManaged_host_no());
            if (host == null) {
                this.printErr(writer, "CONFIG_ERROR", "\u8be5\u76f8\u673a\u914d\u7f6e\u7684\u7ba1\u7406\u4e3b\u673a\u65e0\u6548");
                return;
            }
            RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(host.getHost_no(), true);
            if (rpc == null) {
                this.printErr(writer, "REQUEST_ERROR", "\u65e0\u6cd5\u8fde\u63a5\u8be5\u76f8\u673a\u7684\u7ba1\u7406\u4e3b\u673a");
                return;
            }
            commonRemoteService = rpc.crateRemoteService(CommonRemoteService.class);
        }
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("camera_no", camera_no);
        requestMap.put("op_soruce", "2");
        try {
            rpcResultMap = commonRemoteService.triggerCameraOpenPole(requestMap, null);
        }
        catch (Exception ex) {
            this.printErr(writer, "INVOKE_ERROR", "\u8c03\u7528\u5931\u8d25");
            return;
        }
        if (!"0".equals(rpcResultMap.get("responseCode"))) {
            String responseMsg = (String)rpcResultMap.get("responseMsg");
            if (responseMsg == null || responseMsg.length() == 0) {
                responseMsg = "\u64cd\u4f5c\u5931\u8d25";
            }
            this.printErr(writer, "OP_ERROR", responseMsg);
            return;
        }
        String opType = (String)rpcResultMap.get("opType");
        if (opType == null || opType.length() == 0) {
            opType = "OP_ERROR";
        }
        if (!"SUCCESS".equals(opType)) {
            String opMsg = (String)rpcResultMap.get("opMsg");
            if (opMsg == null || opMsg.length() == 0) {
                opMsg = "\u64cd\u4f5c\u5931\u8d25";
            }
            this.printErr(writer, "OP_ERROR", opMsg);
            return;
        }
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void downPole(Map<String, String> paramMap, PrintWriter writer) {
        Map<String, Object> rpcResultMap;
        CommonRemoteService commonRemoteService;
        String camera_no = paramMap.get("camera_no");
        if (camera_no == null || camera_no.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: camera_no");
            return;
        }
        Map<String, CarparkChannel> tMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
        Map<String, List<ChannelEquipmentVo>> eqMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelEquipmentVoListMap();
        CarparkChannel passChannel = null;
        if (tMap != null && !tMap.isEmpty() && eqMap != null && !eqMap.isEmpty()) {
            for (CarparkChannel channel : tMap.values()) {
                List<ChannelEquipmentVo> eqList = eqMap.get(channel.getChannel_no());
                if (eqList != null) {
                    for (ChannelEquipmentVo vo : eqList) {
                        if (vo.getEquipment_type() == null || 33 != vo.getEquipment_type() || !camera_no.equals(vo.getEquipment_no())) continue;
                        passChannel = channel;
                        break;
                    }
                }
                if (passChannel == null) continue;
            }
        }
        if (passChannel == null) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: \u65e0\u6548\u76f8\u673a\u7f16\u53f7");
            return;
        }
        if (passChannel.getManaged_host_no() == null || passChannel.getManaged_host_no().length() == 0) {
            this.printErr(writer, "CONFIG_ERROR", "\u8be5\u76f8\u673a\u672a\u5206\u914d\u7ba1\u7406\u4e3b\u673a");
            return;
        }
        if (passChannel.getManaged_host_no().equals(ServiceUtil.getServiceContext().getLocalHostNo())) {
            commonRemoteService = (CommonRemoteService)ServiceUtil.getServiceContext().getService(CommonRemoteService.class);
        } else {
            CarparkHost host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(passChannel.getManaged_host_no());
            if (host == null) {
                this.printErr(writer, "CONFIG_ERROR", "\u8be5\u76f8\u673a\u914d\u7f6e\u7684\u7ba1\u7406\u4e3b\u673a\u65e0\u6548");
                return;
            }
            RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(host.getHost_no(), true);
            if (rpc == null) {
                this.printErr(writer, "REQUEST_ERROR", "\u65e0\u6cd5\u8fde\u63a5\u8be5\u76f8\u673a\u7684\u7ba1\u7406\u4e3b\u673a");
                return;
            }
            commonRemoteService = rpc.crateRemoteService(CommonRemoteService.class);
        }
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("camera_no", camera_no);
        requestMap.put("op_soruce", "2");
        try {
            rpcResultMap = commonRemoteService.triggerCameraDownPole(requestMap, null);
        }
        catch (Exception ex) {
            this.printErr(writer, "INVOKE_ERROR", "\u8c03\u7528\u5931\u8d25");
            return;
        }
        if (!"0".equals(rpcResultMap.get("responseCode"))) {
            String responseMsg = (String)rpcResultMap.get("responseMsg");
            if (responseMsg == null || responseMsg.length() == 0) {
                responseMsg = "\u64cd\u4f5c\u5931\u8d25";
            }
            this.printErr(writer, "OP_ERROR", responseMsg);
            return;
        }
        String opType = (String)rpcResultMap.get("opType");
        if (opType == null || opType.length() == 0) {
            opType = "OP_ERROR";
        }
        if (!"SUCCESS".equals(opType)) {
            String opMsg = (String)rpcResultMap.get("opMsg");
            if (opMsg == null || opMsg.length() == 0) {
                opMsg = "\u64cd\u4f5c\u5931\u8d25";
            }
            this.printErr(writer, "OP_ERROR", opMsg);
            return;
        }
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void softTrigger(Map<String, String> paramMap, PrintWriter writer) {
        Map<String, Object> rpcResultMap;
        CommonRemoteService commonRemoteService;
        String camera_no = paramMap.get("camera_no");
        if (camera_no == null || camera_no.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: camera_no");
            return;
        }
        Map<String, CarparkChannel> tMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
        Map<String, List<ChannelEquipmentVo>> eqMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelEquipmentVoListMap();
        CarparkChannel passChannel = null;
        if (tMap != null && !tMap.isEmpty() && eqMap != null && !eqMap.isEmpty()) {
            for (CarparkChannel channel : tMap.values()) {
                List<ChannelEquipmentVo> eqList = eqMap.get(channel.getChannel_no());
                if (eqList != null) {
                    for (ChannelEquipmentVo vo : eqList) {
                        if (vo.getEquipment_type() == null || 33 != vo.getEquipment_type() || !camera_no.equals(vo.getEquipment_no())) continue;
                        passChannel = channel;
                        break;
                    }
                }
                if (passChannel == null) continue;
            }
        }
        if (passChannel == null) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: \u65e0\u6548\u76f8\u673a\u7f16\u53f7");
            return;
        }
        if (passChannel.getManaged_host_no() == null || passChannel.getManaged_host_no().length() == 0) {
            this.printErr(writer, "CONFIG_ERROR", "\u8be5\u76f8\u673a\u672a\u5206\u914d\u7ba1\u7406\u4e3b\u673a");
            return;
        }
        if (passChannel.getManaged_host_no().equals(ServiceUtil.getServiceContext().getLocalHostNo())) {
            commonRemoteService = (CommonRemoteService)ServiceUtil.getServiceContext().getService(CommonRemoteService.class);
        } else {
            CarparkHost host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(passChannel.getManaged_host_no());
            if (host == null) {
                this.printErr(writer, "CONFIG_ERROR", "\u8be5\u76f8\u673a\u914d\u7f6e\u7684\u7ba1\u7406\u4e3b\u673a\u65e0\u6548");
                return;
            }
            RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(host.getHost_no(), true);
            if (rpc == null) {
                this.printErr(writer, "REQUEST_ERROR", "\u65e0\u6cd5\u8fde\u63a5\u8be5\u76f8\u673a\u7684\u7ba1\u7406\u4e3b\u673a");
                return;
            }
            commonRemoteService = rpc.crateRemoteService(CommonRemoteService.class);
        }
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("camera_no", camera_no);
        requestMap.put("op_soruce", "2");
        try {
            rpcResultMap = commonRemoteService.triggerCameraSoftReg(requestMap, null);
        }
        catch (Exception ex) {
            this.printErr(writer, "INVOKE_ERROR", "\u8c03\u7528\u5931\u8d25");
            return;
        }
        if (!"0".equals(rpcResultMap.get("responseCode"))) {
            String responseMsg = (String)rpcResultMap.get("responseMsg");
            if (responseMsg == null || responseMsg.length() == 0) {
                responseMsg = "\u64cd\u4f5c\u5931\u8d25";
            }
            this.printErr(writer, "OP_ERROR", responseMsg);
            return;
        }
        String opType = (String)rpcResultMap.get("opType");
        if (opType == null || opType.length() == 0) {
            opType = "OP_ERROR";
        }
        if (!"SUCCESS".equals(opType)) {
            String opMsg = (String)rpcResultMap.get("opMsg");
            if (opMsg == null || opMsg.length() == 0) {
                opMsg = "\u64cd\u4f5c\u5931\u8d25";
            }
            this.printErr(writer, "OP_ERROR", opMsg);
            return;
        }
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void obtainCamerasSate(Map<String, String> paramMap, PrintWriter writer) {
        String _camera_nos = paramMap.get("camera_nos");
        if (_camera_nos == null || _camera_nos.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: camera_nos");
            return;
        }
        String[] camera_nos = _camera_nos.split(",");
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        resultMap.put("code", "SUCCESS");
        resultMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        LinkedList list = new LinkedList();
        resultMap.put("data", list);
        String[] stringArray = camera_nos;
        int n = camera_nos.length;
        int n2 = 0;
        while (n2 < n) {
            String camera_no = stringArray[n2];
            if ((camera_no = camera_no.trim()).length() != 0) {
                HashMap<String, String> vMap = new HashMap<String, String>();
                vMap.put("camera_no", camera_no);
                EquipmentState state = ServiceUtil.getServiceContext().getEquipmentState(camera_no);
                if (state == EquipmentState.CONNECTED) {
                    vMap.put("camera_state", "1");
                } else {
                    vMap.put("camera_state", "0");
                }
                list.add(vMap);
            }
            ++n2;
        }
        writer.print(GsonBuilder.create().toJson(resultMap));
    }

    private boolean isValidConfigType(Integer config_type) {
        if (config_type == null) {
            return false;
        }
        if (config_type == 33) {
            return true;
        }
        return config_type == 34;
    }

    @Override
    @ThirdApiService
    public void queryConfigItems(Map<String, String> paramMap, PrintWriter writer) {
        Integer config_type;
        String _config_type = paramMap.get("config_type");
        if (_config_type == null || _config_type.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: config_type");
            return;
        }
        try {
            config_type = Integer.valueOf(_config_type);
        }
        catch (Exception ex) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: config_type:" + _config_type);
            return;
        }
        if (!this.isValidConfigType(config_type)) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: config_type:" + config_type);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        List dataList = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"attribute_key", "attribute_value", "attribute_type"}).addEQ("attribute_type", (Object)config_type).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("id"), CarparkAttribute.class, null);
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        resultMap.put("code", "SUCCESS");
        resultMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        LinkedList list = new LinkedList();
        resultMap.put("data", list);
        if (dataList != null && !dataList.isEmpty()) {
            for (CarparkAttribute attr : dataList) {
                HashMap<String, String> vmap = new HashMap<String, String>();
                vmap.put("item_no", attr.getAttribute_key());
                vmap.put("item_value", attr.getAttribute_value());
                list.add(vmap);
            }
        }
        writer.print(GsonBuilder.create().toJson(resultMap));
    }

    @Override
    @ThirdApiService
    public void addConfigItem(Map<String, String> paramMap, PrintWriter writer) {
        Integer config_type;
        String _config_type = paramMap.get("config_type");
        if (_config_type == null || _config_type.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: config_type");
            return;
        }
        try {
            config_type = Integer.valueOf(_config_type);
        }
        catch (Exception ex) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: config_type:" + _config_type);
            return;
        }
        if (!this.isValidConfigType(config_type)) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: config_type:" + config_type);
            return;
        }
        String item_value = paramMap.get("item_value");
        if (item_value == null || item_value.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: item_value");
            return;
        }
        try {
            if (item_value.getBytes("UTF-8").length > 100) {
                this.printErr(writer, "PARAM_ERROR", "\u53c2\u6570\u503c: item_value\u957f\u5ea6\u8fc7\u957f\uff01\u4e0d\u80fd\u8d85\u8fc7100\u4e2aUTF-8\u5b57\u7b26");
                return;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CarparkAttribute attr = (CarparkAttribute)commonDaoService.selectOne(new SearchParam().setQueryFields(new String[]{"attribute_key", "attribute_value", "attribute_type"}).addEQ("attribute_type", (Object)config_type).addEQ("attribute_value", (Object)item_value).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id), CarparkAttribute.class, null);
        if (attr == null) {
            Date now = ServiceUtil.getNow();
            CarparkAttribute t = new CarparkAttribute();
            t.setId(commonDaoService.getSequece("ck_common_seq"));
            t.setAttribute_key("C" + t.getId());
            t.setAttribute_type(config_type);
            t.setAttribute_value(item_value);
            t.setCan_del(1);
            t.setCarpark_id(carpark_id);
            t.setCreated_time(now);
            t.setLast_updated_time(now);
            t.setProject_id(project_id);
            commonDaoService.insert((Object)t);
            attr = t;
        }
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        resultMap.put("code", "SUCCESS");
        resultMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        resultMap.put("item_code", attr.getAttribute_key());
        writer.print(GsonBuilder.create().toJson(resultMap));
    }

    @Override
    @ThirdApiService
    public void modifyConfigItem(Map<String, String> paramMap, PrintWriter writer) {
        Integer config_type;
        String _config_type = paramMap.get("config_type");
        if (_config_type == null || _config_type.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: config_type");
            return;
        }
        try {
            config_type = Integer.valueOf(_config_type);
        }
        catch (Exception ex) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: config_type:" + _config_type);
            return;
        }
        if (!this.isValidConfigType(config_type)) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: config_type:" + config_type);
            return;
        }
        String item_value = paramMap.get("item_value");
        if (item_value == null || item_value.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: item_value");
            return;
        }
        try {
            if (item_value.getBytes("UTF-8").length > 100) {
                this.printErr(writer, "PARAM_ERROR", "\u53c2\u6570\u503c: item_value\u957f\u5ea6\u8fc7\u957f\uff01\u4e0d\u80fd\u8d85\u8fc7100\u4e2aUTF-8\u5b57\u7b26");
                return;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        String item_code = paramMap.get("item_code");
        if (item_code == null || item_code.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: item_code");
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CarparkAttribute attr = (CarparkAttribute)commonDaoService.selectOne(new SearchParam().setQueryFields(new String[]{"id", "attribute_key", "attribute_value", "attribute_type"}).addEQ("attribute_type", (Object)config_type).addEQ("attribute_key", (Object)item_code).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id), CarparkAttribute.class, null);
        if (attr == null) {
            this.printErr(writer, "INVALID_ITEM_CODE", "\u65e0\u6548item_code");
            return;
        }
        if (!item_value.equals(attr.getAttribute_value())) {
            CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkAttribute.class));
            updateP.addUpdate("attribute_value", (Object)item_value);
            updateP.addEQ("id", (Object)attr.getId());
            commonDaoService.update(updateP);
        }
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        resultMap.put("code", "SUCCESS");
        resultMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        writer.print(GsonBuilder.create().toJson(resultMap));
    }

    @Override
    @ThirdApiService
    public void deleteConfigItem(Map<String, String> paramMap, PrintWriter writer) {
        Integer config_type;
        String _config_type = paramMap.get("config_type");
        if (_config_type == null || _config_type.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: config_type");
            return;
        }
        try {
            config_type = Integer.valueOf(_config_type);
        }
        catch (Exception ex) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: config_type:" + _config_type);
            return;
        }
        if (!this.isValidConfigType(config_type)) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: config_type:" + config_type);
            return;
        }
        String item_code = paramMap.get("item_code");
        if (item_code == null || item_code.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: item_code");
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CarparkAttribute attr = (CarparkAttribute)commonDaoService.selectOne(new SearchParam().setQueryFields(new String[]{"id", "attribute_key", "attribute_value", "attribute_type"}).addEQ("attribute_type", (Object)config_type).addEQ("attribute_key", (Object)item_code).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id), CarparkAttribute.class, null);
        if (attr != null) {
            commonDaoService.delete(new SearchParam(commonDaoService.getTableName(CarparkAttribute.class)).addEQ("id", (Object)attr.getId()));
        }
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        resultMap.put("code", "SUCCESS");
        resultMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        writer.print(GsonBuilder.create().toJson(resultMap));
    }

    private Integer getIntValue(String key, Map<?, ?> paramMap) {
        if (key == null || paramMap == null) {
            return null;
        }
        Object o = paramMap.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            String v = (String)o;
            if (v.length() == 0) {
                return null;
            }
            try {
                return Integer.valueOf(v);
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        try {
            return Integer.valueOf(o.toString());
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    @ThirdApiService
    public void passConfirmOption(Map<String, Object> paramMap, PrintWriter writer) {
        Map<String, Object> rpcResultMap;
        CommonRemoteService commonRemoteService;
        Integer option = this.getIntValue("option", paramMap);
        if (option == null) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570option\u6216\u503c\u4e3a\u7a7a\u6216\u65e0\u6548\u503c");
            return;
        }
        if (option != 0 && option != 1) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548option\u503c");
            return;
        }
        String channel_no = (String)paramMap.get("channel_no");
        if (channel_no == null || channel_no.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: channel_no");
            return;
        }
        Map<String, CarparkChannel> tMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
        CarparkChannel carparkChannel = null;
        if (tMap != null) {
            carparkChannel = tMap.get(channel_no);
        }
        if (carparkChannel == null) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: \u65e0\u6548\u901a\u9053\u7f16\u53f7");
            return;
        }
        if (carparkChannel.getManaged_host_no() == null || carparkChannel.getManaged_host_no().length() == 0) {
            this.printErr(writer, "CONFIG_ERROR", "\u8be5\u901a\u9053\u672a\u5206\u914d\u7ba1\u7406\u4e3b\u673a");
            return;
        }
        if (carparkChannel.getManaged_host_no().equals(ServiceUtil.getServiceContext().getLocalHostNo())) {
            commonRemoteService = (CommonRemoteService)ServiceUtil.getServiceContext().getService(CommonRemoteService.class);
        } else {
            CarparkHost host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(carparkChannel.getManaged_host_no());
            if (host == null) {
                this.printErr(writer, "CONFIG_ERROR", "\u8be5\u901a\u9053\u914d\u7f6e\u7684\u7ba1\u7406\u4e3b\u673a\u65e0\u6548");
                return;
            }
            RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(host.getHost_no(), true);
            if (rpc == null) {
                this.printErr(writer, "REQUEST_ERROR", "\u65e0\u6cd5\u8fde\u63a5\u8be5\u901a\u9053\u7684\u7ba1\u7406\u4e3b\u673a");
                return;
            }
            commonRemoteService = rpc.crateRemoteService(CommonRemoteService.class);
        }
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("channel_no", channel_no);
        requestMap.put("option", option.toString());
        try {
            rpcResultMap = commonRemoteService.passConfirmOption(requestMap, null);
        }
        catch (Exception ex) {
            this.printErr(writer, "INVOKE_ERROR", "\u8c03\u7528\u5931\u8d25");
            return;
        }
        if (!"0".equals(rpcResultMap.get("responseCode"))) {
            String responseMsg = (String)rpcResultMap.get("responseMsg");
            if (responseMsg == null || responseMsg.length() == 0) {
                responseMsg = "\u64cd\u4f5c\u5931\u8d25";
            }
            this.printErr(writer, "OP_ERROR", responseMsg);
            return;
        }
        String opType = (String)rpcResultMap.get("opType");
        if (opType == null || opType.length() == 0) {
            opType = "OP_ERROR";
        }
        if ("SUCCESS".equals(opType)) {
            LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
            dataMap.put("code", "SUCCESS");
            dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
            dataMap.put("plate_number", (String)rpcResultMap.get("plate_number"));
            writer.print(GsonBuilder.create().toJson(dataMap));
            return;
        }
        String opMsg = (String)rpcResultMap.get("opMsg");
        if (opMsg == null || opMsg.length() == 0) {
            opMsg = "\u64cd\u4f5c\u5931\u8d25";
        }
        this.printErr(writer, opType, opMsg);
    }

    @Override
    @ThirdApiService
    public void rmPresenceRecord(Map<String, Object> paramMap, PrintWriter writer) {
        String plate_number = (String)paramMap.get("plate_number");
        if (plate_number == null || plate_number.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: plate_number");
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        List list = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"id", "enter_record_no"}).addEQ("enter_plate", (Object)plate_number).setOrerbySql("id"), CarparkPresenceRecord.class, null);
        if (list != null && !list.isEmpty()) {
            RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            Date opTime = ServiceUtil.getNow();
            for (CarparkPresenceRecord record : list) {
                recordSaveService.removeCarparkPresenceRecord(record.getId(), "thirdPart", "\u7b2c\u4e09\u65b9\u7a0b\u5e8f", opTime, true);
            }
        }
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void queryAllPassChannel(Map<String, String> paramMap, PrintWriter writer) {
        Map<String, ChannelArea> channelAreaMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas();
        Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
        Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        ArrayList dataList = new ArrayList(channelMap.size());
        for (CarparkChannel channel : channelMap.values()) {
            CarparkHost host;
            LinkedHashMap<String, Object> cMap = new LinkedHashMap<String, Object>();
            cMap.put("channel_no", channel.getChannel_no());
            cMap.put("channel_name", channel.getChannel_name());
            if (channel.getManaged_host_no() != null && channel.getManaged_host_no().length() > 0 && (host = hostMap.get(channel.getManaged_host_no())) != null) {
                cMap.put("managed_host_no", host.getHost_no());
                cMap.put("managed_host_name", host.getHost_name());
                cMap.put("managed_host_ip", host.getHost_ip());
            }
            LinkedList areaList = new LinkedList();
            ChannelArea caL = channelAreaMap.get(channel.getChannel_no());
            if (caL != null) {
                LinkedHashMap<String, String> areaMap;
                if (caL.getEnterAreas() != null && !caL.getEnterAreas().isEmpty()) {
                    for (CarparkArea area : caL.getEnterAreas()) {
                        areaMap = new LinkedHashMap<String, String>();
                        areaMap.put("area_no", area.getArea_no());
                        areaMap.put("area_name", area.getArea_name());
                        areaMap.put("area_level", area.getArea_level().toString());
                        areaMap.put("channel_direction", String.valueOf(0));
                        areaList.add(areaMap);
                    }
                }
                if (caL.getExitAreas() != null && !caL.getExitAreas().isEmpty()) {
                    for (CarparkArea area : caL.getExitAreas()) {
                        areaMap = new LinkedHashMap();
                        areaMap.put("area_no", area.getArea_no());
                        areaMap.put("area_name", area.getArea_name());
                        areaMap.put("area_level", area.getArea_level().toString());
                        areaMap.put("channel_direction", String.valueOf(1));
                        areaList.add(areaMap);
                    }
                }
            }
            cMap.put("areaList", areaList);
            dataList.add(cMap);
        }
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        dataMap.put("data", dataList);
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void queryAllCarType(Map<String, String> paramMap, PrintWriter writer) {
        Map<String, CarparkCarType> carparkTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        ArrayList dataList = new ArrayList(carparkTypeMap.size());
        for (CarparkCarType t : carparkTypeMap.values()) {
            LinkedHashMap<String, String> cMap = new LinkedHashMap<String, String>();
            cMap.put("car_type_no", t.getCar_type_no());
            cMap.put("car_type_name", t.getCar_type_name());
            dataList.add(cMap);
        }
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        dataMap.put("data", dataList);
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void queryAllPassportType(Map<String, String> paramMap, PrintWriter writer) {
        Map<String, CarparkPassportType> passportTypeTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        ArrayList dataList = new ArrayList(passportTypeTypeMap.size());
        for (CarparkPassportType t : passportTypeTypeMap.values()) {
            LinkedHashMap<String, String> cMap = new LinkedHashMap<String, String>();
            cMap.put("passport_type_no", t.getPassport_type_no());
            cMap.put("passport_type_name", t.getPassport_type_name());
            cMap.put("pass_type", t.getPass_type().toString());
            cMap.put("use_muti_car", t.getUse_muti_car().toString());
            dataList.add(cMap);
        }
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        dataMap.put("data", dataList);
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void queryRegisterPlate(Map<String, String> paramMap, PrintWriter writer) {
        Date deadline_end;
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        String passportTableName = daoService.getTableName(CarparkPassport.class);
        String carOwnerTableName = daoService.getTableName(CarparkCarOwner.class);
        String[] queryStr = new String[]{"a.*", "b.car_owner_name", "b.id_number", "b.driver_number", "b.address", "b.phone_number", "b.email"};
        StringBuilder sbr = new StringBuilder(128);
        sbr.append(passportTableName).append(" a LEFT JOIN ").append(carOwnerTableName).append(" b ON a.car_owner_no=b.car_owner_no");
        SearchParam sp = new SearchParam(sbr.toString());
        ThirdInvokeServiceImpl.setStringQuery(sp, paramMap, "register_plate", "a.register_plate", false);
        ThirdInvokeServiceImpl.setStringQuery(sp, paramMap, "passport_type_nos", "a.passport_type_no", true);
        ThirdInvokeServiceImpl.setStringQuery(sp, paramMap, "car_type_nos", "a.car_type_no", true);
        ThirdInvokeServiceImpl.setIntQuery(sp, paramMap, "passport_state", "a.passport_state");
        Date deadline_begin = ThirdInvokeServiceImpl.getDate(paramMap, "deadline_begin", false);
        if (deadline_begin != null) {
            sp.addGTE("a.deadline", (Object)deadline_begin);
        }
        if ((deadline_end = ThirdInvokeServiceImpl.getDate(paramMap, "deadline_end", false)) != null) {
            Calendar cl = Calendar.getInstance();
            cl.setTime(deadline_end);
            cl.add(6, 1);
            sp.addLT("a.deadline", (Object)deadline_end);
        }
        ThirdInvokeServiceImpl.setStringQuery(sp, paramMap, "car_owner_no", "a.car_owner_no", false);
        ThirdInvokeServiceImpl.setStringQuery(sp, paramMap, "car_owner_name", "b.car_owner_name", false);
        ThirdInvokeServiceImpl.setStringQuery(sp, paramMap, "id_number", "b.id_number", false);
        ThirdInvokeServiceImpl.setStringQuery(sp, paramMap, "phone_number", "b.phone_number", false);
        sp.setOrder_by("a.id");
        sp.setQueryFields(queryStr);
        Pagination pagination = ThirdInvokeServiceImpl.getPagination(paramMap);
        int gotoPage = pagination.getGotoPage();
        LinkedList recordList = daoService.selectList(sp, pagination);
        if (recordList != null && !recordList.isEmpty() && gotoPage > pagination.getTotalPages()) {
            recordList = new LinkedList();
            pagination.setGotoPage(gotoPage);
            pagination.setCurrentPage(gotoPage);
        }
        LinkedList dataList = new LinkedList();
        if (recordList != null && !recordList.isEmpty()) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Map<String, CarparkPassportType> passportTypeTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            Map<String, CarparkCarType> carparkTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
            for (Map dataMap : recordList) {
                Date stop_date;
                Date start_date;
                Date deadline;
                CarparkPassportType t;
                String passport_type_no;
                CarparkCarType carType;
                LinkedHashMap dMap = new LinkedHashMap();
                dMap.put("register_plate", dataMap.get("register_plate"));
                String car_type_no = (String)dataMap.get("car_type_no");
                if (car_type_no != null && car_type_no.length() > 0 && (carType = carparkTypeMap.get(car_type_no)) != null) {
                    dMap.put("car_type_no", carType.getCar_type_no());
                    dMap.put("car_type_name", carType.getCar_type_name());
                }
                if ((passport_type_no = (String)dataMap.get("passport_type_no")) != null && passport_type_no.length() > 0 && (t = passportTypeTypeMap.get(passport_type_no)) != null) {
                    dMap.put("passport_type_no", t.getPassport_type_no());
                    dMap.put("passport_type_name", t.getPassport_type_name());
                    dMap.put("pass_type", t.getPass_type().toString());
                    dMap.put("use_muti_car", t.getUse_muti_car().toString());
                }
                if (dataMap.get("passport_state") != null) {
                    dMap.put("passport_state", dataMap.get("passport_state").toString());
                }
                if ((deadline = (Date)dataMap.get("deadline")) != null) {
                    dMap.put("deadline", df.format(deadline));
                }
                if ((start_date = (Date)dataMap.get("start_date")) != null) {
                    dMap.put("start_date", df.format(start_date));
                }
                if ((stop_date = (Date)dataMap.get("stop_date")) != null) {
                    dMap.put("stop_date", df.format(stop_date));
                }
                if (dataMap.get("balance") != null) {
                    dMap.put("balance", dataMap.get("balance").toString());
                }
                dMap.put("car_owner_no", dataMap.get("car_owner_no"));
                dMap.put("car_owner_name", dataMap.get("car_owner_name"));
                dMap.put("id_number", dataMap.get("id_number"));
                dMap.put("address", dataMap.get("address"));
                dMap.put("phone_number", dataMap.get("phone_number"));
                dataList.add(dMap);
            }
        }
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        dataMap.put("recordsCount", String.valueOf(pagination.getRecordsCount()));
        dataMap.put("totalPages", String.valueOf(pagination.getTotalPages()));
        dataMap.put("pageSize", String.valueOf(pagination.getPageSize()));
        dataMap.put("currentPage", String.valueOf(pagination.getCurrentPage()));
        dataMap.put("data", dataList);
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void addRegisterPlate(Map<String, String> paramMap, PrintWriter writer) {
        int passport_state;
        String passportTableName;
        String register_plate = paramMap.get("register_plate");
        if (register_plate == null || register_plate.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: register_plate");
            return;
        }
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPassport passport = (CarparkPassport)daoService.selectOne(new SearchParam(passportTableName = daoService.getTableName(CarparkPassport.class)).addEQ("register_plate", (Object)register_plate), CarparkPassport.class);
        if (passport != null) {
            this.printErr(writer, "PLATE_EXIST_ERROR", "\u8f66\u724c\u53f7\uff1a" + register_plate + "\u5df2\u7ecf\u5b58\u5728");
            return;
        }
        register_plate = register_plate.trim().toUpperCase();
        try {
            if (register_plate.length() < 5 || register_plate.length() >= 10 || register_plate.getBytes("UTF-8").length > 20 || register_plate.indexOf("'") != -1 || register_plate.indexOf(34) != -1) {
                this.printErr(writer, "INVALID_PARAM_ERROR", "\u8f66\u724c\u53f7:" + register_plate + "\u9519\u8bef");
                return;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        String car_type_no = paramMap.get("car_type_no");
        if (car_type_no == null || car_type_no.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: car_type_no");
            return;
        }
        String passport_type_no = paramMap.get("passport_type_no");
        if (passport_type_no == null || passport_type_no.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: passport_type_no");
            return;
        }
        Map<String, CarparkPassportType> passportTypeTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        Map<String, CarparkCarType> carparkTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        CarparkCarType carType = carparkTypeMap.get(car_type_no);
        if (carType == null) {
            this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: car_type_no:" + car_type_no);
            return;
        }
        CarparkPassportType passportType = passportTypeTypeMap.get(passport_type_no);
        if (passportType == null) {
            this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: passport_type_no:" + passport_type_no);
            return;
        }
        String _passport_state = paramMap.get("passport_state");
        if (_passport_state == null || _passport_state.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: passport_state");
            return;
        }
        try {
            passport_state = Integer.parseInt(_passport_state);
        }
        catch (Exception ex) {
            this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: passport_state:" + _passport_state);
            return;
        }
        if (passport_state != 1 && passport_state != 0) {
            this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: passport_state:" + _passport_state + ", \u65b0\u6ce8\u518c\u7684\u8f66\u724c\u53ea\u80fd\u53d60,1");
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date deadline = null;
        String _deadline = paramMap.get("deadline");
        if (_deadline != null && _deadline.length() > 0) {
            try {
                if (_deadline.length() > 10) {
                    deadline = df.parse(_deadline);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (deadline == null) {
                if (_deadline.length() != 10) {
                    this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: deadline:" + _deadline + ", \u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3ayyyy-MM-dd, \u6216\u8005 yyyy-MM-dd HH:mm:ss ");
                    return;
                }
                try {
                    deadline = df.parse(String.valueOf(_deadline) + " 23:59:59");
                }
                catch (Exception ex) {
                    this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: deadline:" + _deadline + ", \u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3ayyyy-MM-dd, \u6216\u8005 yyyy-MM-dd HH:mm:ss");
                    return;
                }
            }
        }
        if (deadline == null && passportType.getPass_type() == 2) {
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            cl.add(13, -1);
            deadline = cl.getTime();
        }
        Date start_date = null;
        String _start_date = paramMap.get("start_date");
        if (_start_date != null && _start_date.length() > 0) {
            if (_start_date.length() > 10) {
                try {
                    start_date = df.parse(_start_date);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (start_date == null) {
                if (_start_date.length() != 10) {
                    this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: start_date:" + _start_date + ", \u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3ayyyy-MM-dd, \u6216 yyyy-MM-dd HH:mm:ss");
                    return;
                }
                try {
                    start_date = df.parse(String.valueOf(_start_date) + " 00:00:00");
                }
                catch (Exception ex) {
                    this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: start_date:" + _start_date + ", \u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3ayyyy-MM-dd, \u6216 yyyy-MM-dd HH:mm:ss");
                    return;
                }
            }
        }
        if (start_date == null) {
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            start_date = cl.getTime();
        }
        BigDecimal balance = null;
        String _balance = paramMap.get("balance");
        if (_balance != null && _balance.length() > 0) {
            try {
                balance = new BigDecimal(_balance);
            }
            catch (Exception ex) {
                this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: balance:" + _balance + ", \u5fc5\u987b\u662f\u6570\u5b57");
                return;
            }
        }
        if (balance == null) {
            balance = Constants.MONEY_ZERO;
        }
        String car_owner_no = paramMap.get("car_owner_no");
        String car_owner_name = paramMap.get("car_owner_name");
        String carOwnerTableName = daoService.getTableName(CarparkCarOwner.class);
        CarparkCarOwner carOwner = null;
        if (car_owner_no != null && car_owner_no.length() > 0) {
            carOwner = (CarparkCarOwner)daoService.selectOne(new SearchParam(carOwnerTableName).addEQ("car_owner_no", (Object)car_owner_no), CarparkCarOwner.class);
        }
        if (carOwner == null) {
            String address = paramMap.get("address");
            String phone_number = paramMap.get("phone_number");
            String id_number = paramMap.get("id_number");
            boolean needCreateNew = false;
            if (car_owner_no != null && car_owner_no.length() > 0) {
                needCreateNew = true;
            } else if (car_owner_name != null && car_owner_name.length() > 0) {
                needCreateNew = true;
            } else if (address != null && address.length() > 0) {
                needCreateNew = true;
            } else if (id_number != null && id_number.length() > 0) {
                needCreateNew = true;
            }
            if (!(needCreateNew || passportType.getPass_type() == 0 && passportType.getUse_muti_car() == 0)) {
                needCreateNew = true;
            }
            if (needCreateNew) {
                carOwner = new CarparkCarOwner();
                if (car_owner_no != null && car_owner_no.length() > 0) {
                    carOwner.setCar_owner_no(car_owner_no);
                }
                if (car_owner_name == null || car_owner_name.length() == 0) {
                    car_owner_name = "\u672a\u77e5";
                }
                carOwner.setCar_owner_name(ServiceUtil.getString(car_owner_name, 45));
                if (id_number != null && id_number.length() > 0) {
                    if (!ValidateUtil.isIDCard(id_number)) {
                        this.printErr(writer, "INVALID_PARAM_ERROR", "\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef:" + id_number);
                        return;
                    }
                    carOwner.setId_number(id_number);
                }
                if (address != null && address.length() > 0) {
                    carOwner.setAddress(ServiceUtil.getString(address, 200));
                }
                if (phone_number != null && phone_number.length() > 0) {
                    if (!ValidateUtil.isCellPhone(phone_number)) {
                        this.printErr(writer, "INVALID_PARAM_ERROR", "\u624b\u673a\u53f7\u9519\u8bef:" + phone_number);
                        return;
                    }
                    carOwner.setPhone_number(phone_number);
                }
                carOwner.setSex(0);
                carOwner.setCreated_time(ServiceUtil.getNow());
                carOwner.setLast_updated_time(ServiceUtil.getNow());
                carOwner.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                carOwner.setProject_id(ServiceUtil.getServiceContext().getProjectId());
            }
        }
        passport = new CarparkPassport();
        passport.setBalance(balance);
        passport.setCar_color("");
        passport.setCar_logo("");
        passport.setCar_type_no(car_type_no);
        passport.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
        passport.setCash_pledge(Constants.MONEY_ZERO);
        passport.setCreated_time(ServiceUtil.getNow());
        passport.setDeadline(deadline);
        passport.setForbid_online_pay(0);
        passport.setIc_as_id(1);
        passport.setIc_key("");
        passport.setIc_sector("");
        passport.setLast_updated_time(ServiceUtil.getNow());
        passport.setMedium_type(6);
        passport.setNumber_times(0);
        passport.setParking_space_no("");
        passport.setPassport_number(register_plate);
        passport.setPassport_state(passport_state);
        passport.setPassport_type_no(passport_type_no);
        passport.setProject_id(ServiceUtil.getServiceContext().getProjectId());
        passport.setReg_source(3);
        passport.setReg_time(ServiceUtil.getNow());
        passport.setRegister_plate(register_plate);
        passport.setRemain_hours(0);
        passport.setRemark("");
        passport.setStart_date(start_date);
        passport.setStop_date(null);
        passport.setSurface_number("");
        passport.setValid_date(null);
        passport.setVehicle_number("");
        boolean needCreadCarOwner = false;
        if (carOwner != null) {
            boolean bl = needCreadCarOwner = carOwner.getId() == null;
            if (needCreadCarOwner) {
                carOwner.setId(daoService.getSequece("ck_common_seq"));
                if (carOwner.getCar_owner_no() == null || carOwner.getCar_owner_no().length() == 0) {
                    carOwner.setCar_owner_no("C" + carOwner.getId().toString());
                }
            }
            passport.setCar_owner_no(carOwner.getCar_owner_no());
        }
        passport.setId(daoService.getSequece("ck_common_seq"));
        passport.setPassport_no("C" + passport.getId());
        StringBuilder op_des = new StringBuilder(128);
        op_des.append("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8c03\u7528\u6ce8\u518c\u8f66\u724c:").append(passport.getRegister_plate()).append(",\u7c7b\u578b:");
        op_des.append(Constants.getPassTypeMap().get(passportType.getPass_type()));
        op_des.append(",\u7c7b\u578b\u540d:").append(passportType.getPassport_type_name());
        op_des.append(",\u8f66\u8f86\u7c7b\u578b:").append(carType.getCar_type_name());
        if (carOwner != null && carOwner.getCar_owner_name() != null && carOwner.getCar_owner_name().length() > 0 && !"\u672a\u77e5".equals(carOwner.getCar_owner_name())) {
            op_des.append(",\u6240\u5c5e\u8f66\u4e3b:").append(carOwner.getCar_owner_name());
        }
        CarparkOperationLog opLog = new CarparkOperationLog();
        opLog.setOp_cat(Constants.LOG_OP_CAT_1);
        opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_1_1);
        opLog.setOp_time(ServiceUtil.getNow());
        opLog.setOp_des(ServiceUtil.getString(op_des.toString(), 500));
        opLog.setOp_user_code("OHTER_SYS");
        opLog.setOp_user_name("\u5176\u4ed6\u7cfb\u7edf");
        opLog.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
        opLog.setProject_id(ServiceUtil.getServiceContext().getProjectId());
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        opLog.setId(applicationService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
        try (SqlSession session = daoService.openSqlSession();){
            try {
                daoService.insert(session, (Object)passport);
                if (carOwner != null && needCreadCarOwner) {
                    daoService.insert(session, (Object)carOwner);
                }
                daoService.insert(session, (Object)opLog);
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void modifyRegisterPlate(Map<String, String> paramMap, PrintWriter writer) {
        boolean uCarOwner;
        String _passport_state;
        String _balance;
        String _deadline;
        SimpleDateFormat df;
        String _start_date;
        String passport_type_no;
        String passportTableName;
        String register_plate = paramMap.get("register_plate");
        if (register_plate == null || register_plate.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: register_plate");
            return;
        }
        register_plate = register_plate.toUpperCase();
        int logType = Constants.LOG_OP_TYPE_CAT_1_2;
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPassport passport = (CarparkPassport)daoService.selectOne(new SearchParam(passportTableName = daoService.getTableName(CarparkPassport.class)).addEQ("register_plate", (Object)register_plate), CarparkPassport.class);
        if (passport == null) {
            this.printErr(writer, "PLATE_NOT_FOUND", "\u8f66\u724c\u53f7\uff1a" + register_plate + "\u4e0d\u5b58\u5728");
            return;
        }
        StringBuilder op_des = new StringBuilder(128);
        op_des.append("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8c03\u7528\u4fee\u6539,");
        if (passport.getMedium_type() == 6) {
            op_des.append("\u8f66\u724c:").append(passport.getPassport_number());
        } else {
            op_des.append("\u5361\u53f7:").append(passport.getPassport_number());
        }
        CommonParam updatePassport = new CommonParam(passportTableName);
        Map<String, CarparkPassportType> passportTypeTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        Map<String, CarparkCarType> carparkTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        String car_type_no = paramMap.get("car_type_no");
        if (car_type_no != null && car_type_no.length() > 0) {
            CarparkCarType carType = carparkTypeMap.get(car_type_no);
            if (carType == null) {
                this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: car_type_no:" + car_type_no);
                return;
            }
            if (!car_type_no.equals(passport.getCar_type_no())) {
                updatePassport.addUpdate("car_type_no", (Object)car_type_no);
                op_des.append(",\u4fee\u6539\u8f66\u578b\u4e3a:" + carType.getCar_type_name());
            }
        }
        if ((passport_type_no = paramMap.get("passport_type_no")) != null && passport_type_no.length() > 0) {
            CarparkPassportType passportType = passportTypeTypeMap.get(passport_type_no);
            if (passportType == null) {
                this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: passport_type_no:" + passport_type_no);
                return;
            }
            if (!passport_type_no.equals(passport.getPassport_type_no())) {
                if (passport.getPassport_state() != 0) {
                    this.printErr(writer, "PLATE_STATE_ERROR", "\u72b6\u6001\u9519\u8bef\uff01\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u4fee\u6539\u8f66\u724c/\u5361\u7c7b\u578b");
                    return;
                }
                updatePassport.addUpdate("passport_type_no", (Object)passport_type_no);
                op_des.append(",\u4fee\u6539\u7c7b\u578b\u4e3a:" + passportType.getPassport_type_name());
            }
        }
        if ((_start_date = paramMap.get("start_date")) != null && _start_date.length() > 0) {
            Date start_date = null;
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (_start_date.length() > 10) {
                try {
                    start_date = df.parse(_start_date);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (start_date == null) {
                if (_start_date.length() != 10) {
                    this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: start_date:" + _start_date + ", \u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3ayyyy-MM-dd, \u6216 yyyy-MM-dd HH:mm:ss");
                    return;
                }
                try {
                    start_date = df.parse(String.valueOf(_start_date) + " 00:00:00");
                }
                catch (Exception ex) {
                    this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: start_date:" + _start_date + ", \u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3ayyyy-MM-dd, \u6216 yyyy-MM-dd HH:mm:ss");
                    return;
                }
            }
            if (passport.getStart_date() == null || passport.getStart_date().getTime() != start_date.getTime()) {
                if (passport.getPassport_state() != 0) {
                    this.printErr(writer, "PLATE_STATE_ERROR", "\u72b6\u6001\u9519\u8bef\uff01\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u4fee\u6539\u542f\u7528\u6216\u5f00\u59cb\u65e5\u671f");
                    return;
                }
                updatePassport.addUpdate("start_date", (Object)start_date);
                op_des.append(",\u4fee\u6539\u542f\u7528\u65e5\u671f\u4e3a:" + _start_date);
            }
        }
        if ((_deadline = paramMap.get("deadline")) != null && _deadline.length() > 0) {
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date deadline = null;
            try {
                if (_deadline.length() > 10) {
                    deadline = df.parse(_deadline);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (deadline == null) {
                if (_deadline.length() != 10) {
                    this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: deadline:" + _deadline + ", \u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3ayyyy-MM-dd, \u6216\u8005 yyyy-MM-dd HH:mm:ss");
                    return;
                }
                try {
                    deadline = df.parse(String.valueOf(_deadline) + " 23:59:59");
                }
                catch (Exception ex) {
                    this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: deadline:" + _deadline + ", \u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3ayyyy-MM-dd, \u6216\u8005 yyyy-MM-dd HH:mm:ss");
                    return;
                }
            }
            if (passport.getDeadline() == null || passport.getDeadline().getTime() != deadline.getTime()) {
                if (passport.getPassport_state() != 0) {
                    this.printErr(writer, "PLATE_STATE_ERROR", "\u72b6\u6001\u9519\u8bef\uff01\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u4fee\u6539\u6709\u6548\u671f\u9650");
                    return;
                }
                updatePassport.addUpdate("deadline", (Object)deadline);
                op_des.append(",\u4fee\u6539\u6709\u6548\u671f\u4e3a:" + _deadline);
            }
        }
        if ((_balance = paramMap.get("balance")) != null && _balance.length() > 0) {
            BigDecimal balance = null;
            try {
                balance = new BigDecimal(_balance);
            }
            catch (Exception ex) {
                this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: balance:" + _balance + ", \u5fc5\u987b\u662f\u6570\u5b57");
                return;
            }
            if (passport.getBalance() == null || passport.getBalance().doubleValue() != balance.doubleValue()) {
                if (passport.getPassport_state() != 0) {
                    this.printErr(writer, "PLATE_STATE_ERROR", "\u72b6\u6001\u9519\u8bef\uff01\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u4fee\u6539\u4f59\u989d");
                    return;
                }
                updatePassport.addUpdate("balance", (Object)balance);
                op_des.append(",\u4fee\u6539\u6709\u4f59\u989d\u4e3a:" + _deadline);
            }
        }
        if ((_passport_state = paramMap.get("passport_state")) != null && _passport_state.length() > 0) {
            int passport_state;
            try {
                passport_state = Integer.parseInt(_passport_state);
            }
            catch (Exception ex) {
                this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: passport_state:" + _passport_state);
                return;
            }
            if (passport_state != 1 && passport_state != 0 && passport_state != 2) {
                this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: passport_state:" + _passport_state + ", \u65b0\u6ce8\u518c\u7684\u8f66\u724c\u53ea\u80fd\u53d60,1,2");
                return;
            }
            if (passport_state != passport.getPassport_state()) {
                if (passport_state == 0) {
                    if (passport.getPassport_state() == 2) {
                        Date today;
                        Calendar cl = Calendar.getInstance();
                        cl.set(14, 0);
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        Date startDate = today = cl.getTime();
                        Date stop_date = null;
                        if (passport.getStop_date() != null) {
                            cl.setTime(passport.getStop_date());
                            cl.set(14, 0);
                            cl.set(13, 0);
                            cl.set(12, 0);
                            cl.set(11, 0);
                            stop_date = cl.getTime();
                            long stop_date_mills = stop_date.getTime();
                            long today_mills = today.getTime();
                            if (today_mills > stop_date_mills) {
                                CarparkPresenceRecord record = (CarparkPresenceRecord)daoService.selectOne(new SearchParam().setQueryFields(new String[]{"enter_time"}).addEQ("passport_number", (Object)passport.getPassport_number()).addEQ("medium_type", (Object)passport.getMedium_type()).addEQ("area_level", (Object)1).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()).addEQ("project_id", (Object)ServiceUtil.getServiceContext().getProjectId()), CarparkPresenceRecord.class);
                                Date enter_time = null;
                                if (record != null && record.getEnter_time() != null) {
                                    enter_time = record.getEnter_time();
                                }
                                if (enter_time != null) {
                                    cl.setTime(enter_time);
                                    cl.set(14, 0);
                                    cl.set(13, 0);
                                    cl.set(12, 0);
                                    cl.set(11, 0);
                                    long enter_time_mills = cl.getTimeInMillis();
                                    if (enter_time_mills <= today_mills) {
                                        startDate = enter_time_mills > stop_date_mills ? cl.getTime() : stop_date;
                                    }
                                }
                            }
                        }
                        Date deadLine = null;
                        if (passport.getDeadline() != null) {
                            deadLine = passport.getDeadline();
                        } else if (passport.getValid_date() != null) {
                            deadLine = passport.getValid_date();
                        }
                        Date afterDeadline = null;
                        if (deadLine != null) {
                            if (stop_date != null && startDate.getTime() > stop_date.getTime()) {
                                if (deadLine.getTime() < stop_date.getTime()) {
                                    afterDeadline = deadLine;
                                } else {
                                    cl.setTime(deadLine);
                                    cl.set(14, 0);
                                    cl.set(13, 0);
                                    cl.set(12, 0);
                                    cl.set(11, 0);
                                    int rdays = (int)TimeUnit.MILLISECONDS.toDays(cl.getTimeInMillis() - stop_date.getTime());
                                    if (rdays > 0) {
                                        cl.setTime(startDate);
                                        cl.add(5, rdays);
                                        afterDeadline = cl.getTime();
                                    } else {
                                        afterDeadline = deadLine;
                                    }
                                }
                            } else {
                                afterDeadline = deadLine;
                            }
                        }
                        op_des.append("\u542f\u7528\u8f66\u724c/\u5361");
                        updatePassport.addUpdate("passport_state", (Object)0);
                        updatePassport.addUpdate("stop_date = NULL");
                        Date newDeadLine = null;
                        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
                        if (afterDeadline != null) {
                            cl.setTime(afterDeadline);
                            cl.set(14, 0);
                            cl.set(13, 59);
                            cl.set(12, 59);
                            cl.set(11, 23);
                            newDeadLine = cl.getTime();
                        }
                        if (newDeadLine != null) {
                            updatePassport.addUpdate("deadLine", newDeadLine);
                        }
                        if (startDate != null) {
                            cl.setTime(startDate);
                            cl.set(14, 0);
                            cl.set(13, 0);
                            cl.set(12, 0);
                            cl.set(11, 0);
                            startDate = cl.getTime();
                            updatePassport.addUpdate("start_date", (Object)startDate);
                        }
                        op_des.append(",\u542f\u7528\u65e5\u671f:").append(df2.format(startDate));
                        if (newDeadLine != null) {
                            op_des.append(",\u542f\u7528\u540e\u6709\u6548\u671f:").append(df2.format(newDeadLine));
                        }
                        if (passport.getStart_date() != null) {
                            op_des.append(",\u539f\u542f\u7528\u65e5\u671f:").append(df2.format(passport.getStart_date()));
                        }
                        if (deadLine != null) {
                            op_des.append(",\u539f\u6709\u6548\u671f:").append(df2.format(deadLine));
                        }
                        logType = Constants.LOG_OP_TYPE_CAT_1_5;
                    } else {
                        updatePassport.addUpdate("passport_state", (Object)0);
                        if (passport.getPassport_state() == 1) {
                            op_des.append(",\u88ab\u89e3\u9664\u9ed1\u540d\u5355");
                            logType = Constants.LOG_OP_TYPE_CAT_1_3;
                        } else {
                            op_des.append(",\u88ab\u542f\u7528");
                        }
                    }
                } else if (passport_state == 2) {
                    if (passport.getPassport_state() != 0) {
                        this.printErr(writer, "PLATE_STATE_ERROR", "\u72b6\u6001\u9519\u8bef\uff01\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u505c\u7528");
                        return;
                    }
                    String _stop_date = paramMap.get("stop_date");
                    Date stop_date = null;
                    if (_stop_date != null && _stop_date.length() > 0) {
                        try {
                            stop_date = new SimpleDateFormat("yyyy-MM-dd").parse(_stop_date);
                        }
                        catch (Exception ex) {
                            this.printErr(writer, "INVALID_PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: stop_date:" + _stop_date + ", \u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u8be5\u4e3ayyyy-MM-dd");
                            return;
                        }
                    }
                    if (stop_date == null) {
                        Calendar cl = Calendar.getInstance();
                        cl.set(14, 0);
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        Date today = cl.getTime();
                        if (stop_date == null || stop_date.before(today)) {
                            stop_date = today;
                        }
                    }
                    updatePassport.addUpdate("passport_state", (Object)2);
                    updatePassport.addUpdate("stop_date", (Object)stop_date);
                    if (passport.getDeadline() != null) {
                        updatePassport.addUpdate("valid_date", (Object)passport.getDeadline());
                    }
                    op_des.append(",\u5df2\u529e\u7406\u505c\u7528\u4e1a\u52a1,\u505c\u7528\u53d7\u7406\u65e5\u671f:").append(new SimpleDateFormat("yyyy-MM-dd").format(stop_date));
                    logType = Constants.LOG_OP_TYPE_CAT_1_5;
                } else if (passport_state == 1) {
                    if (passport.getPassport_state() != 0) {
                        this.printErr(writer, "PLATE_STATE_ERROR", "\u72b6\u6001\u9519\u8bef\uff01\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u52a0\u5165\u9ed1\u540d\u5355");
                        return;
                    }
                    updatePassport.addUpdate("passport_state", (Object)1);
                    op_des.append(",\u88ab\u52a0\u5165\u9ed1\u540d\u5355");
                    logType = Constants.LOG_OP_TYPE_CAT_1_3;
                }
            }
        }
        String carOwnerTableName = daoService.getTableName(CarparkCarOwner.class);
        CarparkCarOwner carOwner = null;
        if (passport.getCar_owner_no() != null && passport.getCar_owner_no().length() > 0) {
            carOwner = (CarparkCarOwner)daoService.selectOne(new SearchParam(carOwnerTableName).addEQ("car_owner_no", (Object)passport.getCar_owner_no()), CarparkCarOwner.class);
        }
        CommonParam updateCarOwnerP = null;
        if (carOwner != null) {
            String phone_number;
            String address;
            String id_number;
            updateCarOwnerP = new CommonParam(carOwnerTableName);
            String car_owner_name = paramMap.get("car_owner_name");
            if (car_owner_name != null && car_owner_name.length() > 0 && !(car_owner_name = ServiceUtil.getString(car_owner_name, 45)).equals(carOwner.getCar_owner_name())) {
                updateCarOwnerP.addUpdate("car_owner_name", (Object)car_owner_name);
            }
            if ((id_number = paramMap.get("id_number")) != null && id_number.length() > 0) {
                if (!ValidateUtil.isIDCard(id_number)) {
                    this.printErr(writer, "INVALID_PARAM_ERROR", "\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef:" + id_number);
                    return;
                }
                if (!id_number.equals(carOwner.getId_number())) {
                    updateCarOwnerP.addUpdate("id_number", (Object)id_number);
                }
            }
            if ((address = paramMap.get("address")) != null && address.length() > 0 && !(address = ServiceUtil.getString(address, 200)).equals(carOwner.getAddress())) {
                updateCarOwnerP.addUpdate("address", (Object)address);
            }
            if ((phone_number = paramMap.get("phone_number")) != null && phone_number.length() > 0) {
                if (!ValidateUtil.isCellPhone(phone_number)) {
                    this.printErr(writer, "INVALID_PARAM_ERROR", "\u624b\u673a\u53f7\u9519\u8bef:" + phone_number);
                    return;
                }
                if (!phone_number.equals(carOwner.getPhone_number())) {
                    updateCarOwnerP.addUpdate("phone_number", (Object)phone_number);
                }
            }
        }
        boolean uPassport = updatePassport != null && updatePassport.getUpdateKeyValues() != null && !updatePassport.getUpdateKeyValues().isEmpty();
        boolean bl = uCarOwner = carOwner != null && updateCarOwnerP != null && updateCarOwnerP.getUpdateKeyValues() != null && !updateCarOwnerP.getUpdateKeyValues().isEmpty();
        if (uPassport || uCarOwner) {
            CarparkOperationLog opLog = null;
            if (uPassport) {
                opLog = new CarparkOperationLog();
                opLog.setOp_cat(Constants.LOG_OP_CAT_1);
                opLog.setOp_type(logType);
                opLog.setOp_time(ServiceUtil.getNow());
                opLog.setOp_des(ServiceUtil.getString(op_des.toString(), 500));
                opLog.setOp_user_code("OHTER_SYS");
                opLog.setOp_user_name("\u5176\u4ed6\u7cfb\u7edf");
                opLog.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                opLog.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                opLog.setId(applicationService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
            }
            try (SqlSession session = daoService.openSqlSession();){
                try {
                    if (uPassport && updatePassport != null) {
                        updatePassport.addEQ("id", (Object)passport.getId());
                        updatePassport.addUpdate("last_updated_time", (Object)ServiceUtil.getNow());
                        daoService.update(session, updatePassport);
                    }
                    if (uCarOwner) {
                        updateCarOwnerP.addEQ("id", (Object)carOwner.getId());
                        updateCarOwnerP.addUpdate("last_updated_time", (Object)ServiceUtil.getNow());
                        daoService.update(session, updateCarOwnerP);
                    }
                    if (opLog != null) {
                        daoService.insert(session, (Object)opLog);
                    }
                    session.commit();
                }
                catch (Exception ex) {
                    session.rollback();
                    throw ex;
                }
            }
        }
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void delRegisterPlate(Map<String, String> paramMap, PrintWriter writer) {
        String passportTableName;
        String register_plate = paramMap.get("register_plate");
        if (register_plate == null || register_plate.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: register_plate");
            return;
        }
        register_plate = register_plate.toUpperCase();
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPassport passport = (CarparkPassport)daoService.selectOne(new SearchParam(passportTableName = daoService.getTableName(CarparkPassport.class)).addEQ("register_plate", (Object)register_plate), CarparkPassport.class);
        if (passport != null) {
            long count;
            daoService.delete(new SearchParam(passportTableName).addEQ("id", (Object)passport.getId()));
            if (passport.getCar_owner_no() != null && passport.getCar_owner_no().length() > 0 && (count = daoService.selectCount(new SearchParam(passportTableName).addEQ("car_owner_no", (Object)passport.getCar_owner_no()))) == 0L) {
                String carOwnerTableName = daoService.getTableName(CarparkCarOwner.class);
                daoService.delete(new SearchParam(carOwnerTableName).addEQ("car_owner_no", (Object)passport.getCar_owner_no()));
            }
            StringBuilder op_des = new StringBuilder(128);
            op_des.append("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8c03\u7528\u5220\u9664\u6ce8\u518c\u8f66\u724c\uff01");
            if (passport.getMedium_type() == 6) {
                op_des.append("\u8f66\u724c:").append(passport.getPassport_number());
            } else {
                op_des.append("\u5361\u53f7:").append(passport.getPassport_number());
                if (passport.getRegister_plate() != null && passport.getRegister_plate().length() > 0) {
                    op_des.append(",\u7ed1\u5b9a\u8f66\u724c:").append(passport.getRegister_plate());
                }
            }
            Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            CarparkPassportType passportType1 = passportTypeMap.get(passport.getPassport_type_no());
            Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
            CarparkCarType carType = carTypeMap.get(passport.getCar_type_no());
            if (passportType1 != null) {
                op_des.append("\u7c7b\u578b:").append(passportType1.getPassport_type_name());
            }
            if (carType != null) {
                op_des.append("\u8f66\u578b:").append(carType.getCar_type_name());
            }
            CarparkOperationLog opLog = new CarparkOperationLog();
            opLog.setOp_cat(Constants.LOG_OP_CAT_1);
            opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_1_7);
            opLog.setOp_time(ServiceUtil.getNow());
            opLog.setOp_des(ServiceUtil.getString(op_des.toString(), 500));
            opLog.setOp_user_code("OHTER_SYS");
            opLog.setOp_user_name("\u5176\u4ed6\u7cfb\u7edf");
            opLog.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
            opLog.setProject_id(ServiceUtil.getServiceContext().getProjectId());
            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            opLog.setId(applicationService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
            daoService.insert((Object)opLog);
        }
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void queryTempFee(Map<String, String> paramMap, PrintWriter writer) {
        String plateNumber = paramMap.get("plateNumber");
        if (plateNumber == null || plateNumber.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: plateNumber");
            return;
        }
        paramMap.put("plateNumber", plateNumber.toUpperCase());
        String queryEndTime = paramMap.get("queryEndTime");
        if (queryEndTime != null && queryEndTime.length() > 0) {
            try {
                new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(queryEndTime);
            }
            catch (Exception ex) {
                this.printErr(writer, "PARAM_ERROR", "\u65e5\u671f\u683c\u5f0f\u9519\u8bef: " + queryEndTime + "\uff0c\u5e94\u8be5\u4e3a yyyy-MM-dd HH:mm:ss");
                return;
            }
        }
        CloudMsgService cloudMsgService = (CloudMsgService)ServiceUtil.getServiceContext().getService("cloudMsgService");
        Map<String, Object> resultMap = cloudMsgService.queryTempFee(paramMap, new HashMap<String, Object>());
        String errMsg = (String)resultMap.remove("responseMsg");
        String respCode = (String)resultMap.remove("responseCode");
        boolean success = "0".equals(respCode);
        if (success) {
            respCode = "SUCCESS";
            errMsg = "\u64cd\u4f5c\u6210\u529f";
        }
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("code", respCode);
        dataMap.put("msg", errMsg);
        if (success) {
            dataMap.putAll(resultMap);
        }
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void tempFeePaySuccess(Map<String, String> paramMap, PrintWriter writer) {
        int payScene;
        int payMethod;
        String cloudOrderNo = paramMap.get("cloudOrderNo");
        if (cloudOrderNo == null || cloudOrderNo.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: cloudOrderNo");
            return;
        }
        String payAmount = paramMap.get("payAmount");
        if (payAmount == null || payAmount.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: payAmount");
            return;
        }
        String payTime = paramMap.get("payTime");
        if (payTime == null || payTime.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: payTime");
            return;
        }
        String _payMethod = paramMap.get("payMethod");
        if (_payMethod == null || _payMethod.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: payMethod");
            return;
        }
        String _payScene = paramMap.get("payScene");
        if (_payScene == null || _payScene.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: payScene");
            return;
        }
        String outOrderNo = paramMap.get("outOrderNo");
        if (outOrderNo == null || outOrderNo.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: outOrderNo");
            return;
        }
        try {
            BigDecimal bg = new BigDecimal(payAmount);
            if (bg.doubleValue() <= 0.0) {
                this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570payAmount\uff1a" + payAmount + ", \u652f\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
                return;
            }
        }
        catch (Exception ex) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570payAmount\uff1a" + payAmount);
            return;
        }
        try {
            new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(payTime);
        }
        catch (Exception ex) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\uff1apayTime:" + payTime + ", \u683c\u5f0f\u9519\u8bef\uff01\u5e94\u8be5\u4e3a\uff1a yyyy-MM-dd HH:mm:ss");
            return;
        }
        try {
            payMethod = Integer.parseInt(_payMethod);
        }
        catch (Exception ex) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c\uff1apayMethod:" + _payMethod);
            return;
        }
        String payMethodName = Constants.createPayMethodMap().get(payMethod);
        if (payMethodName == null || payMethodName.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c\uff1apayMethod:" + _payMethod);
            return;
        }
        try {
            payScene = Integer.parseInt(_payScene);
        }
        catch (Exception ex) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c\uff1apayScene:" + _payScene);
            return;
        }
        String paySceneName = Constants.createAllPaySceneMap().get(payScene);
        if (paySceneName == null || paySceneName.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c\uff1apayScene:" + _payScene);
            return;
        }
        try {
            CommonDaoService daoService;
            CarparkTranConfig config;
            if (!ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().containsKey(payMethod) && (config = (CarparkTranConfig)(daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class)).selectOne(new SearchParam().addEQ("tran_config_type", (Object)0).addEQ("tran_config_key", (Object)payMethod).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()), CarparkTranConfig.class)) == null) {
                config = new CarparkTranConfig();
                config.setTran_config_key(payMethod);
                config.setTran_config_type(0);
                config.setTran_config_value(payMethodName);
                config.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                config.setCreated_time(ServiceUtil.getNow());
                config.setId(daoService.getSequece("ck_common_seq"));
                config.setLast_updated_time(config.getCreated_time());
                config.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                daoService.insert((Object)config);
            }
            if (!ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap().containsKey(payScene) && (config = (CarparkTranConfig)(daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class)).selectOne(new SearchParam().addEQ("tran_config_type", (Object)1).addEQ("tran_config_key", (Object)payScene).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()), CarparkTranConfig.class)) == null) {
                config = new CarparkTranConfig();
                config.setTran_config_key(payScene);
                config.setTran_config_type(1);
                config.setTran_config_value(paySceneName);
                config.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                config.setCreated_time(ServiceUtil.getNow());
                config.setId(daoService.getSequece("ck_common_seq"));
                config.setLast_updated_time(config.getCreated_time());
                config.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                daoService.insert((Object)config);
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
        }
        HashMap<String, String> paramMapx = new HashMap<String, String>();
        paramMapx.putAll(paramMap);
        paramMapx.put("parkId", String.valueOf(ServiceUtil.getServiceContext().getCarparkId()));
        paramMapx.put("chargeOrg", String.valueOf(0));
        paramMapx.put("payEntry", String.valueOf(2));
        CloudMsgService cloudMsgService = (CloudMsgService)ServiceUtil.getServiceContext().getService("cloudMsgService");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("LOCAL_HANDLE", Boolean.TRUE);
        Map<String, Object> resultMap = cloudMsgService.tempFeePaySuccess(paramMapx, context);
        String errMsg = (String)resultMap.remove("responseMsg");
        String respCode = (String)resultMap.remove("responseCode");
        boolean success = "0".equals(respCode);
        if (success) {
            respCode = "SUCCESS";
            errMsg = "\u64cd\u4f5c\u6210\u529f";
        }
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("code", respCode);
        dataMap.put("msg", errMsg);
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void queryPresenceRecord(Map<String, String> paramMap, PrintWriter writer) {
        LinkedHashMap<String, Object> dataMap2;
        Date d_end;
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam sp = new SearchParam(daoService.getTableName(CarparkPresenceRecord.class));
        String _enter_plate = paramMap.get("enter_plate");
        if (_enter_plate != null && _enter_plate.length() > 0) {
            sp.addEQ("enter_plate", (Object)_enter_plate.toUpperCase());
        }
        ThirdInvokeServiceImpl.setStringQuery(sp, paramMap, "channel_nos", "enter_channel_no", true);
        ThirdInvokeServiceImpl.setStringQuery(sp, paramMap, "passport_type_nos", "passport_type_no", true);
        ThirdInvokeServiceImpl.setStringQuery(sp, paramMap, "car_type_nos", "enter_car_type_no", true);
        ThirdInvokeServiceImpl.setIntQuery(sp, paramMap, "pass_type", "pass_type");
        Date d_begin = ThirdInvokeServiceImpl.getDate(paramMap, "entertTimeBegin", true);
        if (d_begin != null) {
            sp.addGTE("enter_time", (Object)d_begin);
        }
        if ((d_end = ThirdInvokeServiceImpl.getDate(paramMap, "enterTimeEnd", true)) != null) {
            sp.addLTE("enter_time", (Object)d_end);
        }
        sp.setOrder_by("enter_time");
        Pagination pagination = ThirdInvokeServiceImpl.getPagination(paramMap);
        int gotoPage = pagination.getGotoPage();
        LinkedList recordList = daoService.selectList(sp, pagination);
        if (recordList != null && !recordList.isEmpty() && gotoPage > pagination.getTotalPages()) {
            recordList = new LinkedList();
            pagination.setGotoPage(gotoPage);
            pagination.setCurrentPage(gotoPage);
        }
        LinkedList<Map<String, Object>> dataList = new LinkedList<Map<String, Object>>();
        if (recordList != null && !recordList.isEmpty()) {
            for (LinkedHashMap<String, Object> dataMap2 : recordList) {
                this.setPassRecordPicPath(dataMap2);
                dataList.add(ServiceUtil.toStringMap(dataMap2, null));
            }
        }
        dataMap2 = new LinkedHashMap<String, String>();
        dataMap2.put("code", "SUCCESS");
        dataMap2.put("msg", "\u64cd\u4f5c\u6210\u529f");
        dataMap2.put("recordsCount", String.valueOf(pagination.getRecordsCount()));
        dataMap2.put("totalPages", String.valueOf(pagination.getTotalPages()));
        dataMap2.put("pageSize", String.valueOf(pagination.getPageSize()));
        dataMap2.put("currentPage", String.valueOf(pagination.getCurrentPage()));
        dataMap2.put("data", dataList);
        writer.print(GsonBuilder.create().toJson(dataMap2));
    }

    @Override
    @ThirdApiService
    public void queryPassRecord(Map<String, String> paramMap, PrintWriter writer) {
        LinkedHashMap<String, Object> dataMap2;
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam sp = new SearchParam(daoService.getTableName(CarparkPassRecord.class));
        String _pass_plate = paramMap.get("pass_plate");
        if (_pass_plate != null && _pass_plate.length() > 0) {
            sp.addEQ("pass_plate", (Object)_pass_plate.toUpperCase());
        }
        ThirdInvokeServiceImpl.setStringQuery(sp, paramMap, "pass_channel_nos", "pass_channel_no", true);
        ThirdInvokeServiceImpl.setStringQuery(sp, paramMap, "passport_type_nos", "passport_type_no", true);
        ThirdInvokeServiceImpl.setStringQuery(sp, paramMap, "car_type_nos", "pass_car_type_no", true);
        ThirdInvokeServiceImpl.setIntQuery(sp, paramMap, "pass_type", "pass_type");
        Date d_begin = ThirdInvokeServiceImpl.getDate(paramMap, "passTimeBegin", true);
        if (d_begin == null) {
            this.printErr(writer, "PARAM_ERROR", "\u901a\u884c\u8d77\u59cb\u65f6\u95f4\u4e3a\u7a7a\u6216\u683c\u5f0f\u9519\u8bef");
            return;
        }
        sp.addGTE("pass_time", (Object)d_begin);
        Date d_end = ThirdInvokeServiceImpl.getDate(paramMap, "passTimeEnd", true);
        if (d_end == null) {
            this.printErr(writer, "PARAM_ERROR", "\u901a\u884c\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a\u6216\u683c\u5f0f\u9519\u8bef");
            return;
        }
        sp.addLTE("pass_time", (Object)d_end);
        sp.setOrder_by("pass_time");
        String queryType = paramMap.get("queryType");
        if (queryType != null) {
            if ("1".equals(queryType)) {
                sp.addNotEQ("enter_time", null);
                sp.addEQ("exit_time", null);
            } else if ("2".equals(queryType)) {
                sp.addNotEQ("exit_time", null);
            }
        }
        Pagination pagination = ThirdInvokeServiceImpl.getPagination(paramMap);
        int gotoPage = pagination.getGotoPage();
        LinkedList recordList = daoService.selectList(sp, pagination);
        if (recordList != null && !recordList.isEmpty() && gotoPage > pagination.getTotalPages()) {
            recordList = new LinkedList();
            pagination.setGotoPage(gotoPage);
            pagination.setCurrentPage(gotoPage);
        }
        LinkedList<Map<String, Object>> dataList = new LinkedList<Map<String, Object>>();
        if (recordList != null && !recordList.isEmpty()) {
            for (LinkedHashMap<String, Object> dataMap2 : recordList) {
                this.setPassRecordPicPath(dataMap2);
                dataList.add(ServiceUtil.toStringMap(dataMap2, null));
            }
        }
        dataMap2 = new LinkedHashMap<String, String>();
        dataMap2.put("code", "SUCCESS");
        dataMap2.put("msg", "\u64cd\u4f5c\u6210\u529f");
        dataMap2.put("recordsCount", String.valueOf(pagination.getRecordsCount()));
        dataMap2.put("totalPages", String.valueOf(pagination.getTotalPages()));
        dataMap2.put("pageSize", String.valueOf(pagination.getPageSize()));
        dataMap2.put("currentPage", String.valueOf(pagination.getCurrentPage()));
        dataMap2.put("data", dataList);
        writer.print(GsonBuilder.create().toJson(dataMap2));
    }

    private void setPassRecordPicPath(Map<String, Object> objMap) {
        String[] picPaths;
        String[] stringArray = picPaths = new String[]{"enter_car_pic", "enter_plate_pic", "enter_face_pic", "exit_car_pic", "exit_plate_pic", "exit_face_pic", "certificate_pic"};
        int n = picPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.setPicPath(name, objMap);
            ++n2;
        }
    }

    private void setPicPath(String name, Map<String, Object> objMap) {
        String path = (String)objMap.get(name);
        if (path != null && path.length() > 0) {
            try {
                path = BytesTool.compressBytes((byte[])path.getBytes("UTF-8"));
                objMap.put(name, path);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private static void setIntQuery(SearchParam sp, Map<String, ?> paramMap, String key, String name) {
        Integer value = ThirdInvokeServiceImpl.getIntValue(paramMap, key, null);
        if (value != null) {
            sp.addEQ(name, (Object)value);
        }
    }

    private static void setStringQuery(SearchParam sp, Map<String, ?> paramMap, String key, String name, boolean muti) {
        Object x = paramMap.get(key);
        if (x == null) {
            return;
        }
        if (x instanceof String) {
            String v = (String)x;
            if (v.length() == 0) {
                return;
            }
            if (muti) {
                String[] vs;
                String[] stringArray = vs = v.split(",");
                int n = vs.length;
                int n2 = 0;
                while (n2 < n) {
                    String tv = stringArray[n2];
                    if (tv.length() > 0) {
                        sp.addIN(name, (Object)tv);
                    }
                    ++n2;
                }
            } else {
                sp.addEQ(name, (Object)v);
            }
        }
    }

    private static Date getDate(Map<String, ?> paramMap, String key, boolean dateTime) {
        String v;
        block3: {
            try {
                v = (String)paramMap.get(key);
                if (v != null && v.length() != 0) break block3;
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return new SimpleDateFormat(dateTime ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd").parse(v);
    }

    private static Pagination getPagination(Map<String, ?> paramMap) {
        Pagination p = new Pagination();
        int pageSize = ThirdInvokeServiceImpl.getIntValue(paramMap, "pageSize", 10);
        if (pageSize > 50) {
            pageSize = 50;
        } else if (pageSize < 1) {
            pageSize = 10;
        }
        p.setPageSize(pageSize);
        int gotoPage = ThirdInvokeServiceImpl.getIntValue(paramMap, "gotoPage", 1);
        if (gotoPage < 1) {
            gotoPage = 1;
        }
        p.setGotoPage(gotoPage);
        int recordsCount = ThirdInvokeServiceImpl.getIntValue(paramMap, "recordsCount", 0);
        if (recordsCount > 0) {
            p.setRecordsCount((long)recordsCount);
            p.setNeedQueryCount(false);
        }
        return p;
    }

    private static Integer getIntValue(Map<String, ?> paramMap, String key, Integer defaultV) {
        Object obj = paramMap.get(key);
        if (obj == null) {
            return defaultV;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        String vx = obj.toString();
        try {
            if (vx.length() > 0) {
                return Integer.valueOf(vx);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultV;
    }

    @Override
    @ThirdApiService
    public void queryDiscountPojs(Map<String, String> paramMap, PrintWriter writer) {
        List list;
        String discountProjName = paramMap.get("discountProjName");
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam sp = new SearchParam(daoService.getTableName(CarparkDiscountProject.class));
        if (discountProjName != null && discountProjName.length() > 0) {
            sp.addEQ("discount_project_name", (Object)discountProjName);
        }
        ArrayList recordList = new ArrayList((list = daoService.selectList(sp, CarparkDiscountProject.class, null)) == null ? 0 : list.size());
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        if (list != null && !list.isEmpty()) {
            for (CarparkDiscountProject p : list) {
                LinkedHashMap<String, String> reMap = new LinkedHashMap<String, String>();
                reMap.put("discountProjNo", p.getDiscount_project_no());
                reMap.put("discountProjName", p.getDiscount_project_name());
                if (p.getDiscount_method() == 3) {
                    reMap.put("discountProjDesc", "\u514d\u8d39\u505c\u8f66\u5230\u6307\u5b9a\u65f6\u95f4");
                } else {
                    String des = applicationService.getDiscountValueDes(p.getDiscount_method(), p.getDiscount_value());
                    reMap.put("discountProjDesc", des);
                }
                reMap.put("discountProjMethod", p.getDiscount_method().toString());
                recordList.add(reMap);
            }
        }
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        dataMap.put("data", recordList);
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void plateDiscount(Map<String, String> paramMap, PrintWriter writer) {
        String plateNumber = paramMap.get("plateNumber");
        if (plateNumber == null || plateNumber.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1aplateNumber \u6216\u503c\u4e3a\u7a7a");
            return;
        }
        String discountProjNo = paramMap.get("discountProjNo");
        if (discountProjNo == null || discountProjNo.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1adiscountProjNo \u6216\u503c\u4e3a\u7a7a");
            return;
        }
        String opUserCode = paramMap.get("opUserCode");
        opUserCode = opUserCode != null && opUserCode.length() > 0 ? ServiceUtil.getString(opUserCode, 45) : "ORTHER_APP_USER_CODE";
        String opUserName = paramMap.get("opUserName");
        opUserName = opUserName != null && opUserName.length() > 0 ? ServiceUtil.getString(opUserName, 45) : "\u7b2c\u4e09\u65b9\u5e94\u7528";
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam sp = new SearchParam(daoService.getTableName(CarparkPresenceRecord.class));
        sp.addEQ("enter_plate", (Object)plateNumber);
        sp.addEQ("area_level", (Object)1);
        sp.setOrder_by("enter_time ASC");
        List list = daoService.selectList(sp, CarparkPresenceRecord.class, null);
        if (list == null || list.isEmpty()) {
            this.printErr(writer, "CAR_NOT_ENTER", "\u8f66\u724c:" + plateNumber + ", \u4e0d\u5728\u573a\u5185");
            return;
        }
        CarparkPresenceRecord record = (CarparkPresenceRecord)list.get(0);
        sp = new SearchParam(daoService.getTableName(CarparkDiscountProject.class));
        sp.addEQ("discount_project_no", (Object)discountProjNo);
        CarparkDiscountProject dicountProject = (CarparkDiscountProject)daoService.selectOne(sp, CarparkDiscountProject.class);
        if (dicountProject == null) {
            this.printErr(writer, "INVALID_DISCOUNT_PROJECT_NO", "\u65e0\u6548\u6298\u6263\u9879\u76ee\u7f16\u53f7: " + discountProjNo);
            return;
        }
        int discountValue = dicountProject.getDiscount_value();
        int discoutMethod = dicountProject.getDiscount_method();
        Date expireTime = null;
        if (dicountProject.getDiscount_method() == 3) {
            int mins;
            String freeEndTime = paramMap.get("freeEndTime");
            if (freeEndTime == null || freeEndTime.length() == 0) {
                this.printErr(writer, "PARAM_ERROR", "\u6309\u514d\u8d39\u5230\u622a\u6b62\u65f6\u95f4\u6253\u6298,\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            try {
                expireTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(freeEndTime);
            }
            catch (Exception ex) {
                this.printErr(writer, "PARAM_ERROR", "\u6309\u514d\u8d39\u5230\u622a\u6b62\u65f6\u95f4\u6253\u6298,\u622a\u6b62\u65f6\u95f4\u683c\u5f0f\u9519\u8bef, \u5e94\u8be5\u4e3ayyyy-MM-dd HH:mm:ss");
                return;
            }
            if (expireTime.getTime() <= record.getEnter_time().getTime()) {
                this.printErr(writer, "PARAM_ERROR", "\u6309\u514d\u8d39\u5230\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u8f66\u8f86\u5165\u573a\u65f6\u95f4 " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(record.getEnter_time()));
                return;
            }
            Calendar cl = Calendar.getInstance();
            cl.setTime(record.getEnter_time());
            cl.set(14, 0);
            cl.set(12, 59);
            cl.set(13, 59);
            cl.set(11, 23);
            cl.add(6, 27);
            if (expireTime.after(cl.getTime())) {
                this.printErr(writer, "PARAM_ERROR", "\u514d\u8d39\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u8d85\u8fc7: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(cl.getTime()));
                return;
            }
            cl.set(2018, 0, 1, 0, 0, 0);
            cl.set(14, 0);
            discountValue = mins = (int)TimeUnit.MILLISECONDS.toMinutes(expireTime.getTime() - cl.getTimeInMillis());
        }
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        Date now = ServiceUtil.getNow();
        long rdId = applicationService.createLocalRecordSeq("ck_carpark_discount_record_seq");
        CarparkDiscountRecord discountRecord = new CarparkDiscountRecord();
        discountRecord.setDiscount_time(now);
        discountRecord.setEnter_record_no(record.getEnter_record_no());
        discountRecord.setPalte_number(record.getEnter_plate());
        discountRecord.setEnter_time(record.getEnter_time());
        discountRecord.setPassport_number(record.getPassport_number());
        discountRecord.setMedium_type(record.getMedium_type());
        discountRecord.setCoupon_no("0");
        discountRecord.setCoupon_order_no("0");
        discountRecord.setDiscount_project_no(dicountProject.getDiscount_project_no());
        discountRecord.setDiscount_project_name(dicountProject.getDiscount_project_name());
        discountRecord.setDiscount_merchant_type(0);
        discountRecord.setDiscount_merchant_no("0");
        discountRecord.setDiscount_merchant_name("\u8f66\u573a\u7ba1\u7406");
        discountRecord.setDiscount_method(discoutMethod);
        discountRecord.setDiscount_value(discountValue);
        discountRecord.setDiscount_source(4);
        discountRecord.setOperation_user_code(opUserCode);
        discountRecord.setOperation_user_name(opUserName);
        discountRecord.setCreated_time(now);
        discountRecord.setDiscount_value_des(applicationService.getDiscountValueDes(discoutMethod, discountValue));
        discountRecord.setPassport_type_no(record.getPassport_type_no());
        discountRecord.setPassport_type_name(record.getPassport_type_name());
        discountRecord.setCertificate_pic(null);
        discountRecord.setExit_time(null);
        discountRecord.setExit_record_no(null);
        discountRecord.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
        discountRecord.setProject_id(ServiceUtil.getServiceContext().getProjectId());
        discountRecord.setId(rdId);
        discountRecord.setDiscount_no("C" + discountRecord.getId());
        CarparkPassDiscount d1 = new CarparkPassDiscount();
        JavaBeanTool.copyTo((Object)discountRecord, (Object)d1);
        LinkedList<CarparkDispatchTask> dispatchTaskList = new LinkedList<CarparkDispatchTask>();
        dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(daoService.getTableName(CarparkDiscountRecord.class), discountRecord.getId().toString(), "ALL_HOSTS"));
        dispatchTaskList.addAll(DispatchDataTaskUtil.createDispatchRecordByIdTaskList(daoService.getTableName(CarparkPassDiscount.class), d1.getId().toString(), "ALL_HOSTS"));
        try (SqlSession sqlsession = daoService.openSqlSession();){
            try {
                daoService.insert(sqlsession, (Object)discountRecord, daoService.getTableName(CarparkDiscountRecord.class));
                daoService.insert(sqlsession, (Object)d1, daoService.getTableName(CarparkPassDiscount.class));
                for (CarparkDispatchTask t : dispatchTaskList) {
                    daoService.insert(sqlsession, (Object)t);
                }
                sqlsession.commit();
            }
            catch (Exception ex) {
                sqlsession.rollback();
                throw ex;
            }
        }
        applicationService.asynTryRunDispatchTask(dispatchTaskList);
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        dataMap.put("dicountRecordNo", discountRecord.getDiscount_no());
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void queryPlateDiscounts(Map<String, String> paramMap, PrintWriter writer) {
        String plateNumber = paramMap.get("plateNumber");
        if (plateNumber == null || plateNumber.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1aplateNumber \u6216\u503c\u4e3a\u7a7a");
            return;
        }
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam sp = new SearchParam(daoService.getTableName(CarparkPresenceRecord.class));
        sp.addEQ("enter_plate", (Object)plateNumber);
        sp.addEQ("area_level", (Object)1);
        sp.setOrder_by("enter_time ASC");
        List list = daoService.selectList(sp, CarparkPresenceRecord.class, null);
        if (list == null || list.isEmpty()) {
            this.printErr(writer, "CAR_NOT_ENTER", "\u8f66\u724c:" + plateNumber + ", \u4e0d\u5728\u573a\u5185");
            return;
        }
        CarparkPresenceRecord r1 = (CarparkPresenceRecord)list.get(0);
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        List<CarparkPassDiscount> discountList = applicationService.getPassDiscountList(r1.getPassport_number(), r1.getMedium_type(), r1.getEnter_time());
        ArrayList recordList = new ArrayList(discountList == null ? 0 : discountList.size());
        Calendar cl = Calendar.getInstance();
        if (discountList != null && !discountList.isEmpty()) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String enterTimeStr = df.format(r1.getEnter_time());
            for (CarparkPassDiscount discount : discountList) {
                LinkedHashMap<String, String> rMap = new LinkedHashMap<String, String>();
                rMap.put("discountRecordNo", discount.getDiscount_no());
                rMap.put("discountTime", df.format(discount.getDiscount_time()));
                rMap.put("plateNumber", plateNumber);
                rMap.put("enterTime", enterTimeStr);
                rMap.put("discountProjNo", discount.getDiscount_project_no() == null ? "" : discount.getDiscount_project_no());
                rMap.put("discountProjName", discount.getDiscount_project_name() == null ? "" : discount.getDiscount_project_name());
                rMap.put("discountProjDesc", discount.getDiscount_value_des() == null || discount.getDiscount_value_des().length() == 0 ? applicationService.getDiscountValueDes(discount.getDiscount_method(), discount.getDiscount_value()) : discount.getDiscount_value_des());
                rMap.put("discountMethod", discount.getDiscount_method().toString());
                if (discount.getDiscount_method() == 3) {
                    cl.set(2018, 0, 1, 0, 0, 0);
                    cl.set(14, 0);
                    cl.add(12, discount.getDiscount_value());
                    rMap.put("discountValue", df.format(cl.getTime()));
                } else {
                    rMap.put("discountValue", discount.getDiscount_value().toString());
                }
                rMap.put("discountMerchNo", discount.getDiscount_merchant_no());
                rMap.put("discountMerchName", discount.getDiscount_merchant_name());
                if (discount.getDiscount_source() != null) {
                    rMap.put("discountSourceType", discount.getDiscount_source().toString());
                    rMap.put("discountSourceDesc", Constants.getDisocuntSourceMap().get(discount.getDiscount_source()));
                }
                rMap.put("operationCode", discount.getOperation_user_code());
                rMap.put("discountMerchName", discount.getDiscount_merchant_name());
                recordList.add(rMap);
            }
        }
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        dataMap.put("data", recordList);
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void queryLaneLatestSession(Map<String, String> paramMap, PrintWriter writer) throws Exception {
        String channelNo = paramMap.get("channelNo");
        if (channelNo == null || channelNo.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1achannelNo \u6216\u503c\u4e3a\u7a7a");
            return;
        }
        HashMap<String, String> paramMapx = new HashMap<String, String>();
        paramMapx.put("channelNo", channelNo);
        if (paramMap.get("plateNumber") != null) {
            paramMapx.put("plateNumber0", paramMap.get("plateNumber"));
        }
        CloudMsgService cloudMsgService = (CloudMsgService)ServiceUtil.getServiceContext().getService("cloudMsgService");
        Map<String, Object> zmap = cloudMsgService.queryPassSession(paramMapx, new HashMap<String, Object>());
        String errMsg = (String)zmap.remove("responseMsg");
        String respCode = (String)zmap.remove("responseCode");
        boolean success = "0".equals(respCode);
        if (success) {
            respCode = "SUCCESS";
            errMsg = "\u64cd\u4f5c\u6210\u529f";
        }
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("code", respCode);
        dataMap.put("msg", errMsg);
        if (success) {
            dataMap.putAll(zmap);
        }
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    @ThirdApiService
    public void modifyPresenceCarType(Map<String, String> paramMap, PrintWriter writer) throws Exception {
        String enterRecordNo = paramMap.get("enterRecordNo");
        if (enterRecordNo == null || enterRecordNo.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1aenterRecordNo \u6216\u503c\u4e3a\u7a7a");
            return;
        }
        String oldCarTypeNo = paramMap.get("oldCarTypeNo");
        String newCarTypeNo = paramMap.get("newCarTypeNo");
        if (newCarTypeNo == null || newCarTypeNo.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1anewCarTypeNo \u6216\u503c\u4e3a\u7a7a");
            return;
        }
        String opUserCode = paramMap.get("opUserCode");
        opUserCode = opUserCode != null && opUserCode.length() > 0 ? ServiceUtil.getString(opUserCode, 45) : "ORTHER_APP_USER_CODE";
        String opUserName = paramMap.get("opUserName");
        opUserName = opUserName != null && opUserName.length() > 0 ? ServiceUtil.getString(opUserName, 45) : "\u7b2c\u4e09\u65b9\u5e94\u7528";
        HashMap<String, Object> paramMapx = new HashMap<String, Object>();
        paramMapx.put("enterRecordNo", enterRecordNo);
        paramMapx.put("opUserCode", opUserCode);
        paramMapx.put("opUserName", opUserName);
        paramMapx.put("opTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        if (oldCarTypeNo != null) {
            paramMapx.put("oldCarTypeNo", oldCarTypeNo);
        }
        paramMapx.put("newCarTypeNo", newCarTypeNo);
        CloudMsgService cloudMsgService = (CloudMsgService)ServiceUtil.getServiceContext().getService("cloudMsgService");
        Map<String, Object> zmap = cloudMsgService.modifyPresenceCartype(paramMapx, new HashMap<String, Object>());
        String errMsg = (String)zmap.remove("responseMsg");
        String respCode = (String)zmap.remove("responseCode");
        boolean success = "0".equals(respCode);
        if (success) {
            respCode = "SUCCESS";
            errMsg = "\u64cd\u4f5c\u6210\u529f";
        }
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("code", respCode);
        dataMap.put("msg", errMsg);
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    public void queryParkingExceedCars(Map<String, String> paramMap, final PrintWriter writer) {
        long exceedMins;
        Date qTimeEnd;
        Date qTimeBegin;
        String timeBegin = paramMap.get("timeBegin");
        String timeEnd = paramMap.get("timeEnd");
        if (timeBegin == null || timeBegin.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: timeBegin");
            return;
        }
        if (timeEnd == null || timeEnd.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: timeEnd");
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            qTimeBegin = df.parse(timeBegin);
        }
        catch (Exception ex) {
            this.printErr(writer, "PARAM_ERROR", "timeBegin\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u5e94\u8be5\u4e3a: yyyy-MM-dd HH:mm:ss");
            return;
        }
        try {
            qTimeEnd = df.parse(timeEnd);
        }
        catch (Exception ex) {
            this.printErr(writer, "PARAM_ERROR", "timeEnd\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u5e94\u8be5\u4e3a: yyyy-MM-dd HH:mm:ss");
            return;
        }
        if (qTimeBegin.getTime() >= qTimeEnd.getTime()) {
            this.printErr(writer, "PARAM_ERROR", "\u67e5\u8be2\u7684\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4");
            return;
        }
        if (qTimeEnd.getTime() - qTimeBegin.getTime() >= TimeUnit.DAYS.toMillis(32L)) {
            this.printErr(writer, "PARAM_ERROR", "\u67e5\u8be2\u7684\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc731\u5929");
            return;
        }
        String _exceedMins = paramMap.get("exceedMins");
        if (_exceedMins == null || _exceedMins.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u503c: exceedMins");
            return;
        }
        try {
            exceedMins = Long.parseLong(_exceedMins);
        }
        catch (Exception ex) {
            this.printErr(writer, "PARAM_ERROR", "\u9519\u8bef\u53c2\u6570\u503c: exceedMins\uff0c\u5fc5\u987b\u662f\u5927\u4e8e\u6216\u7b49\u4e8e0\u7684\u6574\u6570");
            return;
        }
        if (exceedMins <= 0L) {
            this.printErr(writer, "PARAM_ERROR", "\u9519\u8bef\u53c2\u6570\u503c: exceedMins\uff0c\u5fc5\u987b\u662f\u5927\u4e8e\u6216\u7b49\u4e8e0\u7684\u6574\u6570");
            return;
        }
        String plateNumber = paramMap.get("plateNumber");
        if (plateNumber != null && plateNumber.length() > 0) {
            plateNumber = plateNumber.toUpperCase();
        }
        String passportTypeName = paramMap.get("passportTypeName");
        String passportTypeNo = null;
        if (passportTypeName != null && (passportTypeName = passportTypeName.trim()).length() > 0) {
            Map<String, CarparkPassportType> map = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            if (map != null) {
                for (CarparkPassportType t : map.values()) {
                    if (!passportTypeName.equals(t.getPassport_type_name())) continue;
                    passportTypeNo = t.getPassport_type_no();
                    break;
                }
            }
            if (passportTypeNo == null || passportTypeNo.length() == 0) {
                this.printErr(writer, "PARAM_ERROR", "\u65e0\u6548\u53c2\u6570\u503c: passportTypeName\uff0c\u7c7b\u578b\u4e0d\u5b58\u5728");
                return;
            }
        }
        String begin = "{\"code\":\"SUCCESS\",\"msg\":\"\u64cd\u4f5c\u6210\u529f\",\"data\":[";
        String end = "]}";
        CarparkCommonService carparkCommonService = (CarparkCommonService)ServiceUtil.getServiceContext().getService(CarparkCommonService.class);
        writer.print(begin);
        carparkCommonService.queryParkingExceedCars(qTimeBegin, qTimeEnd, exceedMins, null, plateNumber, false, null, passportTypeNo, null, null, null, null, new ObjectCreateCallback<Map<String, String>>(){
            boolean isprintFirst = true;

            public void createSuccess(Map<String, String> returnMap) {
                if (this.isprintFirst) {
                    this.isprintFirst = false;
                } else {
                    writer.print(',');
                }
                writer.print(GsonBuilder.create().toJson(returnMap));
                writer.flush();
            }

            public void onException(Throwable ex) {
            }
        });
        writer.print(end);
    }

    @Override
    public void queryParkingSpaces(Map<String, String> paramMap, PrintWriter writer) {
        Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
        ArrayList dataList = new ArrayList(areaMap.size());
        for (CarparkArea t : areaMap.values()) {
            LinkedHashMap<String, String> cMap = new LinkedHashMap<String, String>();
            cMap.put("area_no", t.getArea_no());
            cMap.put("area_name", t.getArea_name());
            ParingSpaceVo av = ParkingSpace.getInstance().getRemainSpaceInfo("r-as_" + t.getArea_no());
            cMap.put("total_space", String.valueOf(av.getTotal()));
            cMap.put("remain_space", String.valueOf(av.getRemain()));
            dataList.add(cMap);
        }
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        dataMap.put("data", dataList);
        writer.print(GsonBuilder.create().toJson(dataMap));
    }

    @Override
    public void setRemianSpaces(Map<String, String> paramMap, PrintWriter writer) {
        int remain_space0;
        String area_no = paramMap.get("area_no");
        if (area_no == null || area_no.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1aarea_no \u6216\u503c\u4e3a\u7a7a");
            return;
        }
        if (!ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap().containsKey(area_no)) {
            this.printErr(writer, "PARAM_ERROR", "\u53c2\u6570\uff1aarea_no \u65e0\u6548, \u8bf7\u4f7f\u7528queryParkingSpaces\u83b7\u53d6\u7684\u573a\u533a\u7f16\u53f7");
            return;
        }
        String remain_space = paramMap.get("remain_space");
        if (remain_space == null || remain_space.length() == 0) {
            this.printErr(writer, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1aremain_space \u6216\u503c\u4e3a\u7a7a");
            return;
        }
        try {
            remain_space0 = Integer.parseInt(remain_space);
        }
        catch (Exception ex) {
            this.printErr(writer, "PARAM_ERROR", "\u53c2\u6570\uff1aremain_space \u5fc5\u987b\u662f\u6574\u6570");
            return;
        }
        String opUserCode = paramMap.get("opUserCode");
        opUserCode = opUserCode != null && opUserCode.length() > 0 ? ServiceUtil.getString(opUserCode, 45) : "ORTHER_APP_USER_CODE";
        String opUserName = paramMap.get("opUserName");
        opUserName = opUserName != null && opUserName.length() > 0 ? ServiceUtil.getString(opUserName, 45) : "\u7b2c\u4e09\u65b9\u5e94\u7528";
        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        recordSaveService.adjustParkingSpace(area_no, "", remain_space0, opUserCode, opUserName, ServiceUtil.getNow(), true);
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("code", "SUCCESS");
        dataMap.put("msg", "\u64cd\u4f5c\u6210\u529f");
        writer.print(GsonBuilder.create().toJson(dataMap));
    }
}

