/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.vo;

import java.io.File;
import java.math.BigDecimal;

public class DownloadUpgradeVo {
    private String downlodUrl;
    private String version;
    private long totalBytes;
    private long finishBytes;
    private long donwlondRate;
    private boolean finished;
    private File localFile;

    public DownloadUpgradeVo(String downlodUrl, String version, long totalBytes, long finishBytes, long donwlondRate, boolean finished, File localFile) {
        this.downlodUrl = downlodUrl;
        this.version = version;
        this.totalBytes = totalBytes;
        this.finishBytes = finishBytes;
        this.donwlondRate = donwlondRate;
        this.finished = finished;
        this.localFile = localFile;
    }

    public String getDownlodUrl() {
        return this.downlodUrl;
    }

    public void setDownlodUrl(String downlodUrl) {
        this.downlodUrl = downlodUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getFinishBytes() {
        return this.finishBytes;
    }

    public long getDonwlondRate() {
        return this.donwlondRate;
    }

    public String getDonwlondRateDes() {
        int k = 1024;
        int m = 0x100000;
        if (this.donwlondRate < (long)k) {
            return String.valueOf(this.donwlondRate) + "B/s";
        }
        if (this.donwlondRate < (long)m) {
            float x = (float)this.donwlondRate / (float)k;
            return String.valueOf(new BigDecimal(String.valueOf(x)).setScale(1, 3).toString()) + "k/s";
        }
        float x = (float)this.donwlondRate / (float)m;
        return String.valueOf(new BigDecimal(String.valueOf(x)).setScale(1, 3).toString()) + "m/s";
    }

    public String getToalBytesDes() {
        if (this.totalBytes == 0L) {
            return "\u672a\u77e5";
        }
        int k = 1024;
        int m = 0x100000;
        if (this.totalBytes < (long)k) {
            return String.valueOf(this.totalBytes) + "B";
        }
        if (this.totalBytes < (long)m) {
            return String.valueOf((int)Math.round((double)this.totalBytes / (double)k)) + "k";
        }
        return String.valueOf((int)Math.round((double)this.totalBytes / (double)m)) + "M";
    }

    public String getFinishBytesDes() {
        int k = 1024;
        int m = 0x100000;
        if (this.finishBytes < (long)k) {
            return String.valueOf(this.finishBytes) + "B";
        }
        if (this.finishBytes < (long)m) {
            return String.valueOf((int)Math.floor((double)this.finishBytes / (double)k)) + "k";
        }
        return String.valueOf((int)Math.floor((double)this.finishBytes / (double)m)) + "M";
    }

    public int getRemainSecs() {
        if (this.isFinished()) {
            return 0;
        }
        if (this.donwlondRate <= 0L) {
            return -1;
        }
        if (this.totalBytes <= 0L) {
            return -1;
        }
        if (this.finishBytes >= this.totalBytes) {
            return 1;
        }
        long remainBytes = this.totalBytes - this.finishBytes;
        int remianSec = (int)(remainBytes / this.donwlondRate) + 1;
        return remianSec;
    }

    public String getRemainTimeDes() {
        int hour;
        if (this.isFinished()) {
            return "\u5df2\u5b8c\u6210";
        }
        int sec = this.getRemainSecs();
        if (sec < 0) {
            return "\u672a\u77e5";
        }
        if (sec <= 1) {
            return "1\u79d2";
        }
        if (sec < 60) {
            return String.valueOf(sec) + "\u79d2";
        }
        int second = sec % 60;
        int minutes = sec / 60;
        int minite = minutes % 60;
        int thour = minutes / 60;
        int day = 0;
        if (thour > 24) {
            day = thour / 24;
            hour = thour % 24;
        } else {
            hour = thour;
        }
        StringBuffer b = new StringBuffer();
        if (day > 0) {
            b.append(day).append("\u5929");
        }
        if (hour > 0) {
            b.append(hour).append("\u5c0f\u65f6");
        }
        if (minite > 0) {
            b.append(minite).append("\u5206");
        }
        if (second > 0) {
            b.append(second).append("\u79d2");
        }
        return b.toString();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public File getLocalFile() {
        return this.localFile;
    }
}

