/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.vo;

import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import java.security.Key;

public class UploadPicToken {
    private String hostNo;
    private String savePath;
    private long timeMills;
    private String sign;

    public String getHostNo() {
        return this.hostNo;
    }

    public void setHostNo(String hostNo) {
        this.hostNo = hostNo;
    }

    public String getSavePath() {
        return this.savePath;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public long getTimeMills() {
        return this.timeMills;
    }

    public void setTimeMills(long timeMills) {
        this.timeMills = timeMills;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public static String createUploadPicToken(String savePath) {
        try {
            String sign;
            UploadPicToken t = new UploadPicToken();
            t.hostNo = ServiceUtil.getServiceContext().getLocalHostNo();
            t.timeMills = System.currentTimeMillis();
            t.savePath = savePath;
            t.sign = sign = CryptoUtil.MD5Encode((String)t.toString());
            String jsonStr = GsonBuilder.create().toJson((Object)t);
            Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
            return CryptoUtil.encrypt((String)jsonStr, (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
            return null;
        }
    }

    public static UploadPicToken parseToken(String token) {
        UploadPicToken t;
        block6: {
            block5: {
                if (token == null || token.length() == 0) {
                    return null;
                }
                try {
                    Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                    String value = CryptoUtil.decrypt((String)token, (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
                    t = (UploadPicToken)GsonBuilder.create().fromJson(value, UploadPicToken.class);
                    String x = CryptoUtil.MD5Encode((String)t.toString());
                    if (x.equals(t.sign)) break block5;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (t.getHostNo() != null && t.getHostNo().length() != 0 && t.getSavePath() != null && t.getSavePath().length() != 0) break block6;
            return null;
        }
        return t;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UploadPicToken [hostNo=");
        builder.append(this.hostNo);
        builder.append(", savePath=");
        builder.append(this.savePath);
        builder.append(", timeMills=");
        builder.append(this.timeMills);
        builder.append("]");
        return builder.toString();
    }
}

