/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web;

import com.wovoe.carpark.vo.LeftMenuVo;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LeftMenuManager
implements Comparator<LeftMenuVo> {
    private Map<String, LeftMenuVo> leftMenuMap = new ConcurrentHashMap<String, LeftMenuVo>();

    public void addLeftMenu(LeftMenuVo munu) {
        if (munu == null || munu.getName() == null) {
            return;
        }
        this.leftMenuMap.put(munu.getName(), munu);
    }

    public void removeLeftMenu(String menuName) {
        if (menuName != null) {
            this.leftMenuMap.remove(menuName);
        }
    }

    public LeftMenuVo getLeftMenu(String menuName) {
        if (menuName != null) {
            return this.leftMenuMap.get(menuName);
        }
        return null;
    }

    public Enumeration<String> getAllMenuNames() {
        return Collections.enumeration(this.leftMenuMap.keySet());
    }

    public Map<String, LeftMenuVo> getLefMenuMap() {
        return Collections.unmodifiableMap(this.leftMenuMap);
    }

    public List<LeftMenuVo> gePermissionMenuTree(Set<String> permissionSet) {
        if (permissionSet == null || permissionSet.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, LeftMenuVo> xmap = new HashMap<String, LeftMenuVo>();
        for (LeftMenuVo vo : this.leftMenuMap.values()) {
            if (vo.getPath() == null || vo.getPath().length() <= 0 || !permissionSet.contains(vo.getPath())) continue;
            xmap.put(vo.getName(), vo);
            if (vo.getParent_name() == null || vo.getParent_name().length() <= 0 || xmap.containsKey(vo.getParent_name())) continue;
            this.addParentMenu(xmap, vo.getParent_name());
        }
        return this.getMenuTree(xmap);
    }

    private void addParentMenu(Map<String, LeftMenuVo> xmap, String pname) {
        if (pname == null || pname.length() == 0) {
            return;
        }
        LeftMenuVo p = this.leftMenuMap.get(pname);
        if (p != null && !xmap.containsKey(p.getName())) {
            xmap.put(p.getName(), p);
            this.addParentMenu(xmap, p.getParent_name());
        }
    }

    public List<LeftMenuVo> getMenuTree(Map<String, LeftMenuVo> menuMap) {
        LeftMenuVo vo;
        LinkedList<LeftMenuVo> menuTree = new LinkedList<LeftMenuVo>();
        if (menuMap == null || menuMap.isEmpty()) {
            return menuTree;
        }
        PriorityQueue<LeftMenuVo> queue = new PriorityQueue<LeftMenuVo>(menuMap.size(), this);
        for (LeftMenuVo v : menuMap.values()) {
            queue.offer(v);
        }
        HashMap<String, LeftMenuVo> menuMap0 = new HashMap<String, LeftMenuVo>();
        while ((vo = queue.poll()) != null) {
            LeftMenuVo c = vo.clone();
            c.setChildrens(null);
            menuMap0.put(c.getName(), c);
            if (vo.getMenuLevel() == 0) {
                menuTree.add(c);
                continue;
            }
            LeftMenuVo p = (LeftMenuVo)menuMap0.get(c.getParent_name());
            if (p == null) continue;
            List<LeftMenuVo> ch = p.getChildren();
            if (ch == null) {
                ch = new LinkedList<LeftMenuVo>();
                p.setChildrens(ch);
            }
            ch.add(c);
        }
        return menuTree;
    }

    @Override
    public int compare(LeftMenuVo o1, LeftMenuVo o2) {
        int le = Integer.compare(o1.getMenuLevel(), o2.getMenuLevel());
        if (le == 0) {
            le = Integer.compare(o1.getOrder(), o2.getOrder());
        }
        return le;
    }
}

