/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web;

import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.framework.http.MimeType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StaticResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = -4685413997022578765L;
    private static final Logger logger = Logger.getLogger(StaticResourceServlet.class.getName());
    private static final String faviconico = "favicon.ico";
    private String defaultServlertPath;

    public StaticResourceServlet(String defaultServlertPath) {
        if (defaultServlertPath != null && (defaultServlertPath = defaultServlertPath.trim()).length() > 0 && !"/".equals(defaultServlertPath) && !defaultServlertPath.startsWith("/")) {
            defaultServlertPath = "/" + defaultServlertPath;
        }
        this.defaultServlertPath = defaultServlertPath;
    }

    protected void writeData(HttpServletResponse resp, byte[] data, String mime) throws IOException {
        resp.setStatus(200);
        if (mime != null) {
            resp.setContentType(mime);
        }
        try (ServletOutputStream os = null;){
            os = resp.getOutputStream();
            os.write(data);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri = ServiceUtil.getServiceContext().getRequestActionManager().getRequestPath(req);
        URL resource = null;
        if (uri.endsWith(faviconico)) {
            String vlli = System.getProperty("no_logo", "0");
            if ("1".equals(vlli)) {
                uri = uri.replaceAll(faviconico, "nologo.ico");
            } else {
                byte[] icoData;
                Object va;
                Map<String, Object> mad = CarparkGuiSkinUtil.getCarparkGuiSkin().getDefineSkinInfo();
                if (mad != null && (va = mad.get(faviconico)) != null && va instanceof byte[] && (icoData = (byte[])va).length > 0) {
                    String mime = MimeType.getByFilename((String)faviconico);
                    this.writeData(resp, icoData, mime);
                    return;
                }
            }
        }
        String path = uri;
        if ("/".equals(uri)) {
            if (this.defaultServlertPath != null) {
                resp.sendRedirect(String.valueOf(req.getContextPath()) + this.defaultServlertPath);
                return;
            }
        } else {
            resource = ServiceUtil.getServiceContext().getRequestActionManager().getResource(path);
        }
        if (resource == null) {
            String ajax = req.getParameter("ajax");
            if (ajax != null) {
                resp.sendError(404);
            } else {
                WebUtil.dispath("/pages/page404.html", req, resp);
            }
            return;
        }
        String mime = MimeType.getByFilename((String)path);
        resp.setStatus(200);
        if (mime == null) {
            String ajax = req.getParameter("ajax");
            if (ajax != null) {
                resp.sendError(404);
            } else {
                WebUtil.dispath("/pages/page404.html", req, resp);
            }
            return;
        }
        resp.setContentType(mime);
        try (OutputStream os = null;){
            URLConnection urlConnection = resource.openConnection();
            int length = urlConnection.getContentLength();
            try (InputStream is = urlConnection.getInputStream();){
                int read;
                os = resp.getOutputStream();
                byte[] buff = new byte[8192];
                int total = 0;
                while ((read = is.read(buff)) != -1) {
                    total += read;
                    os.write(buff, 0, read);
                }
                if (total != length) {
                    logger.warning("Was supposed to send " + length + ", but sent " + total);
                }
            }
        }
    }
}

