/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web;

import com.wovoe.carpark.UserSession;
import com.wovoe.carpark.dto.CarparkOperationLog;
import com.wovoe.carpark.dto.CarparkRole;
import com.wovoe.carpark.dto.CarparkRolePermission;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.vo.ClientHost;
import com.wovoe.carpark.vo.LeftMenuVo;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.Key;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.ibatis.session.SqlSession;

public class WebUtil {
    public static final String MANAGE_USER_LOGIN_ATTR = "WEB_MANAGE_USER";
    public static final String MANAGE_USER_PERMISSIONS = "MANAGE_USER_PERMISSIONS";
    public static final String MANAGE_USER_LEFT_MENU = "MANAGE_USER_LEFT_MENU";
    public static final String MANAGE_USER_ROLE_NAME = "MANAGE_USER_ROLE_NAME";
    public static final String MANAGE_CLIENT_LOGIN_HOST = "MANAGE_CLIENT_LOGIN_HOST";
    public static final String TEMPLATE_PAGE_SUFFIX = ".html";
    public static final String WEB_CHARSET = "UTF-8";
    public static final String COOKIE_KEY_LAST_LOSTIN = "lafsdfsfqw001213";
    public static final String COOKIE_KEY_SUCCESS_LOGIN_USER = "jlmmhgjslpeurj89";
    public static int webLogoWidth;
    public static int webLogoMarginLeft;

    public static void dispath(String path, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServiceUtil.getServiceContext().getRequestActionManager().process(path, request, response);
    }

    public static void dispathTemplatePage(String path, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!path.endsWith(TEMPLATE_PAGE_SUFFIX)) {
            path = String.valueOf(path) + TEMPLATE_PAGE_SUFFIX;
        }
        WebUtil.dispath("/manage/template/" + path, request, response);
    }

    public static void showMainContentWithHead(String titile, String contentPageName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (contentPageName == null || contentPageName.length() == 0) {
            WebUtil.showMainContent(titile, null, null, request, response);
        } else {
            String contentPath = "/manage/template/" + contentPageName + TEMPLATE_PAGE_SUFFIX;
            String headPath = "/manage/template/" + contentPageName + "Head" + TEMPLATE_PAGE_SUFFIX;
            WebUtil.showMainContent(titile, headPath, contentPath, request, response);
        }
    }

    public static String getRemoteAddress(HttpServletRequest request) {
        String ip = request.getRemoteAddr();
        return ip;
    }

    public static void showMainContent(String titile, String headPath, String contentPath, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (headPath == null) {
            headPath = "";
        }
        request.setAttribute("content_head", (Object)headPath);
        if (contentPath == null) {
            contentPath = "";
        }
        request.setAttribute("content_page", (Object)contentPath);
        if (titile == null) {
            titile = "";
        }
        int imageWith = 24;
        int imageHeight = 24;
        int imageMarginLeft = 16;
        if (webLogoWidth == 0 || webLogoMarginLeft == 0) {
            block15: {
                try {
                    int newWith;
                    int iHeight;
                    int iWith;
                    BufferedImage image;
                    StringBuilder exten = new StringBuilder();
                    InputStream is = CarparkGuiSkinUtil.getCarparkGuiSkin().obtainImageInput("logo", exten);
                    if (is == null) break block15;
                    try {
                        image = ImageIO.read(is);
                    }
                    finally {
                        is.close();
                    }
                    if (image != null && (iWith = image.getWidth()) != (iHeight = image.getHeight()) && (newWith = iWith * imageHeight / iHeight) > imageWith) {
                        int r = newWith - imageWith;
                        if (r > imageMarginLeft) {
                            imageWith += imageMarginLeft;
                            imageMarginLeft = 0;
                        } else {
                            imageWith += r;
                            imageMarginLeft -= r;
                        }
                    }
                }
                catch (Exception exten) {
                    // empty catch block
                }
            }
            webLogoWidth = imageWith;
            webLogoMarginLeft = imageMarginLeft;
        }
        request.setAttribute("webLogoWidth", (Object)String.valueOf(webLogoWidth));
        request.setAttribute("webLogoHeight", (Object)String.valueOf(imageHeight));
        request.setAttribute("webLogoMaginLeft", (Object)String.valueOf(webLogoMarginLeft));
        request.setAttribute("content_title", (Object)titile);
        request.setAttribute("logoImagePath", (Object)(String.valueOf(request.getContextPath()) + "/getSystemImage.action?name=logo"));
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() != 1) {
            request.setAttribute("allowMidifyPwd", (Object)"1");
        }
        Calendar cl = Calendar.getInstance();
        int year = cl.get(1);
        request.setAttribute("copyright", (Object)("Copyright \u00a9 " + year + " " + CarparkGuiSkinUtil.getCarparkGuiSkin().getCopyrightCompany() + " . All Rights Reserved"));
        request.setAttribute("systemName", (Object)CarparkGuiSkinUtil.getCarparkGuiSkin().getSystemName());
        request.setAttribute("carpark_version", (Object)ServiceUtil.getServiceContext().getVersion());
        request.setAttribute("manageBrandtext", (Object)CarparkGuiSkinUtil.getCarparkGuiSkin().getManageBrandtext());
        if (ServiceUtil.isZvalid()) {
            String sk;
            Integer ar1;
            String ajax;
            Integer a1 = ServiceUtil.getSoftRemainDays();
            HttpSession session = request.getSession(false);
            if (a1 != null && a1 < 30 && session != null && (ajax = request.getParameter("ajax")) == null && ((ar1 = (Integer)session.getAttribute(sk = "tipSoftDeadLineInfo")) == null || ar1.intValue() != a1.intValue())) {
                String r3 = a1 == 0 ? "\u4eca" : "\u8fd8\u5269\uff1a" + a1.toString();
                String var = "\u8f6f\u4ef6\u6388\u6743" + r3 + "\u5929\u5230\u671f\uff01<br><br>\u4e3a\u4e86\u4e0d\u5f71\u54cd\u4f7f\u7528\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb\u552e\u540e\u4eba\u5458\u5904\u7406\uff01";
                request.setAttribute("needTipSoftDeadLineInfo", (Object)var);
                session.setAttribute(sk, (Object)a1);
            }
        }
        WebUtil.dispathTemplatePage("main", request, response);
    }

    public static String getOpHostNo(HttpServletRequest request) {
        ClientHost host = WebUtil.getLoginClientHost(request);
        if (host != null && host.getHostNo() != null && host.getHostNo().length() > 0) {
            return host.getHostNo();
        }
        return ServiceUtil.getServiceContext().getLocalHostNo();
    }

    public static String getOpDutyNo(HttpServletRequest request) {
        ClientHost host = WebUtil.getLoginClientHost(request);
        if (host != null) {
            return host.getDutyNo();
        }
        return null;
    }

    public static ClientHost getLoginClientHost(HttpServletRequest request) {
        Object obj;
        HttpSession session = request.getSession(false);
        if (session != null && (obj = session.getAttribute(MANAGE_CLIENT_LOGIN_HOST)) != null && obj instanceof ClientHost) {
            return (ClientHost)obj;
        }
        return null;
    }

    public static CarparkUser getLoginManageUser(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return (CarparkUser)session.getAttribute(MANAGE_USER_LOGIN_ATTR);
        }
        return null;
    }

    public static Set<String> getLoginUserPermissions(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return (Set)session.getAttribute(MANAGE_USER_PERMISSIONS);
        }
        return null;
    }

    public static void printFinshHtml(HttpServletResponse response, String html) {
        WebUtil.printFinshResponse(response, html, "text/html");
    }

    public static void printFinshText(HttpServletResponse response, String text) {
        WebUtil.printFinshResponse(response, text, "text/plain");
    }

    public static void printFinshJson(HttpServletResponse response, String json) {
        WebUtil.printFinshResponse(response, json, "application/json");
    }

    public static String getRequestPath(HttpServletRequest request) {
        return ServiceUtil.getServiceContext().getRequestActionManager().getRequestPath(request);
    }

    public static void printFinshJson(int opType, String msg, HttpServletResponse response) {
        WebUtil.printFinshJson(opType, msg, null, response);
    }

    public static String getPrintFinshJsonString(int opType, String msg) {
        return WebUtil.getPrintFinshJsonString(opType, msg, null);
    }

    public static String getPrintFinshJsonString(int opType, String msg, Object data) {
        HashMap<String, Object> xmap = new HashMap<String, Object>();
        xmap.put("opType", String.valueOf(opType));
        if (msg != null) {
            xmap.put("msg", msg);
        }
        if (data != null) {
            xmap.put("data", data);
        }
        return GsonBuilder.create().toJson(xmap);
    }

    public static void printFinshJson(int opType, String msg, Object data, HttpServletResponse response) {
        HashMap<String, Object> xmap = new HashMap<String, Object>();
        xmap.put("opType", String.valueOf(opType));
        if (msg != null) {
            xmap.put("msg", msg);
        }
        if (data != null) {
            xmap.put("data", data);
        }
        WebUtil.printFinshJson(response, GsonBuilder.create().toJson(xmap));
    }

    public static void printFinshResponse(HttpServletResponse response, String message, String ContentType) {
        try {
            response.setCharacterEncoding(WEB_CHARSET);
            response.setContentType(ContentType);
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            try (PrintWriter w = response.getWriter();){
                w.write(message);
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static String getCookieValue(HttpServletRequest request, String cookieKey) {
        Cookie[] cookies;
        block8: {
            block7: {
                if (cookieKey != null) break block7;
                return null;
            }
            cookies = request.getCookies();
            if (cookies != null) break block8;
            return null;
        }
        try {
            int i = 0;
            while (i < cookies.length) {
                Cookie cookie = cookies[i];
                String name = cookie.getName();
                String value = cookie.getValue();
                if (cookieKey.equals(name)) {
                    if (value == null || value.length() == 0) {
                        return value;
                    }
                    Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                    return CryptoUtil.decrypt((String)value, (String)WEB_CHARSET, (Key)key, (String)key.getAlgorithm());
                }
                ++i;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    public static void storeCookie(HttpServletResponse response, String cookieid, String value, Integer seconds, String domain, String path) {
        try {
            String cookievalue;
            if (value != null && value.length() > 0) {
                Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                cookievalue = CryptoUtil.encrypt((String)value, (String)WEB_CHARSET, (Key)key, (String)key.getAlgorithm());
            } else {
                cookievalue = value;
                if (cookievalue == null) {
                    cookievalue = "";
                }
            }
            Cookie cookie = new Cookie(cookieid, cookievalue);
            if (seconds == null) {
                cookie.setMaxAge((int)TimeUnit.HOURS.toSeconds(8760L));
            } else {
                cookie.setMaxAge(seconds.intValue());
            }
            if (domain != null) {
                cookie.setDomain(domain);
            }
            if (path != null) {
                cookie.setPath(path);
            }
            response.addCookie(cookie);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Set<String> getWebPermission(String roleNo) {
        Set<String> pset = WebUtil.getWebPermissionx(roleNo);
        int hostUse = ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use();
        if (hostUse != 2 && hostUse != 3) {
            HashSet<String> newSet = new HashSet<String>();
            for (String x : pset) {
                if (ServiceUtil.getServiceContext().getWebContext().getWritePermissionPaths().contains(x)) continue;
                newSet.add(x);
            }
            return newSet;
        }
        return pset;
    }

    private static Set<String> getWebPermissionx(String roleNo) {
        if (roleNo == null || roleNo.length() == 0) {
            return Collections.emptySet();
        }
        if ("1".equals(roleNo)) {
            return ServiceUtil.getServiceContext().getPermissionManager().getAllPermison(1);
        }
        Integer carparkId = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        List list = commonDaoService.selectList(new SearchParam().addEQ("role_no", (Object)roleNo).addEQ("carpark_id", (Object)carparkId).addEQ("project_id", (Object)project_id), CarparkRolePermission.class, null);
        return ServiceUtil.getServiceContext().getPermissionManager().getValidPermission(list, 1);
    }

    public static String createVtocken() {
        try {
            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            UserSession usersession = appService.getUserSession();
            if (usersession != null) {
                ClientHost host = new ClientHost();
                host.setDutyNo(usersession.getDutyNumber().getDuty_no());
                host.setHostNo(ServiceUtil.getServiceContext().getLocalHostNo());
                Calendar cl = Calendar.getInstance();
                cl.add(12, 5);
                host.setTimeount(cl.getTimeInMillis());
                host.setUserCode(usersession.getUser().getUser_code());
                host.setUserName(usersession.getUser().getUser_name());
                String sign = CryptoUtil.MD5Encode((String)host.toString());
                host.setSign(sign);
                String jsonStr = GsonBuilder.create().toJson((Object)host);
                Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                return CryptoUtil.encrypt((String)jsonStr, (String)WEB_CHARSET, (Key)key, (String)key.getAlgorithm());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String createVtockenOnline() {
        try {
            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            UserSession usersession1 = appService.getUserSession();
            if (usersession1 != null) {
                ClientHost host = new ClientHost();
                host.setDutyNo("0");
                host.setHostNo(ServiceUtil.getServiceContext().getLocalHostNo());
                Calendar cl = Calendar.getInstance();
                cl.add(12, 5);
                host.setTimeount(cl.getTimeInMillis());
                host.setUserCode("admin");
                host.setUserName(usersession1.getUser().getUser_name());
                String sign = CryptoUtil.MD5Encode((String)host.toString());
                host.setSign(sign);
                String jsonStr = GsonBuilder.create().toJson((Object)host);
                Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                return CryptoUtil.encrypt((String)jsonStr, (String)WEB_CHARSET, (Key)key, (String)key.getAlgorithm());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void reloadSessionFromCookie(HttpServletRequest request, HttpServletResponse response) {
        String cal;
        Calendar cl;
        Object timeount;
        String loginUserCode;
        String sign;
        String value;
        Key key;
        String vtocken;
        String userCode = null;
        ClientHost clientHost = null;
        try {
            vtocken = request.getParameter("vtocken");
            if (vtocken != null && vtocken.length() > 0) {
                key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                value = CryptoUtil.decrypt((String)vtocken, (String)WEB_CHARSET, (Key)key, (String)key.getAlgorithm());
                ClientHost host = (ClientHost)GsonBuilder.create().fromJson(value, ClientHost.class);
                sign = host.getSign();
                loginUserCode = host.getUserCode();
                timeount = host.getTimeount();
                if (timeount != null && loginUserCode != null && loginUserCode.length() > 0 && sign != null && sign.length() > 0 && host.getHostNo() != null && host.getHostNo().length() > 0 && host.getUserName() != null && host.getUserName().length() > 0 && host.getDutyNo() != null && host.getDutyNo().length() > 0 && (cl = Calendar.getInstance()).getTimeInMillis() <= (Long)timeount && (cal = CryptoUtil.MD5Encode((String)host.toString())).equals(sign) && ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(host.getHostNo()) != null) {
                    userCode = loginUserCode;
                    clientHost = host;
                }
            }
        }
        catch (Exception ex) {
            userCode = null;
        }
        if (userCode == null || userCode.length() == 0) {
            try {
                vtocken = request.getParameter("vtocken1");
                if (vtocken != null && vtocken.length() > 0) {
                    key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                    value = CryptoUtil.decrypt((String)vtocken, (String)WEB_CHARSET, (Key)key, (String)key.getAlgorithm());
                    Map dataMap = (Map)GsonBuilder.create().fromJson(value, HashMap.class);
                    sign = (String)dataMap.get("sign");
                    loginUserCode = (String)dataMap.get("loginUserCode");
                    timeount = (String)dataMap.get("timeount");
                    if (timeount != null && loginUserCode != null && sign != null && (cl = Calendar.getInstance()).getTimeInMillis() <= Long.parseLong((String)timeount) && (cal = CryptoUtil.MD5Encode((String)(String.valueOf(loginUserCode) + "," + (String)timeount + "," + ServiceUtil.getServiceContext().getCarpark().getLan_sign_key()))).equals(sign)) {
                        userCode = loginUserCode;
                    }
                }
            }
            catch (Exception ex) {
                userCode = null;
            }
        }
        if (userCode == null || userCode.length() == 0) {
            userCode = WebUtil.getCookieValue(request, COOKIE_KEY_SUCCESS_LOGIN_USER);
        }
        if (userCode != null && userCode.length() > 0) {
            Integer carparkId = ServiceUtil.getServiceContext().getCarparkId();
            Integer project_id = ServiceUtil.getServiceContext().getProjectId();
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            SearchParam p1 = new SearchParam().addEQ("user_code", (Object)userCode);
            p1.addEQ("carpark_id", (Object)carparkId).addEQ("project_id", (Object)project_id);
            CarparkUser user = (CarparkUser)commonDaoService.selectOne(p1, CarparkUser.class, null);
            if (user != null) {
                boolean haveLoginPermission;
                Set<String> permissions = WebUtil.getWebPermission(user.getRole_no());
                boolean bl = haveLoginPermission = permissions != null && permissions.contains("/manage/login/doLogin.action");
                if (!haveLoginPermission && clientHost != null) {
                    haveLoginPermission = true;
                }
                if (haveLoginPermission) {
                    List<LeftMenuVo> menuList;
                    if ("1".equals(user.getRole_no()) && ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() != 1) {
                        menuList = ServiceUtil.getServiceContext().getWebContext().getLeftMenuManager().getMenuTree(ServiceUtil.getServiceContext().getWebContext().getLeftMenuManager().getLefMenuMap());
                    } else {
                        menuList = ServiceUtil.getServiceContext().getWebContext().getLeftMenuManager().gePermissionMenuTree(permissions);
                        if (clientHost != null && (menuList == null || menuList.isEmpty())) {
                            return;
                        }
                    }
                    CarparkRole role = (CarparkRole)commonDaoService.selectOne(new SearchParam().addEQ("role_no", (Object)user.getRole_no()).addEQ("carpark_id", (Object)carparkId).addEQ("project_id", (Object)project_id), CarparkRole.class, null);
                    HttpSession session = request.getSession();
                    session.setMaxInactiveInterval(1800);
                    session.setAttribute(MANAGE_USER_LOGIN_ATTR, (Object)user);
                    session.setAttribute(MANAGE_USER_PERMISSIONS, permissions);
                    session.setAttribute(MANAGE_USER_LEFT_MENU, menuList);
                    if (clientHost != null) {
                        session.setAttribute(MANAGE_CLIENT_LOGIN_HOST, (Object)clientHost);
                    }
                    if (role != null && role.getRole_name() != null) {
                        session.setAttribute(MANAGE_USER_ROLE_NAME, (Object)role.getRole_name());
                    }
                }
            }
        }
    }

    public static Date getNow() {
        return ServiceUtil.getNow();
    }

    public static Date getDatetime(Date d) {
        return ServiceUtil.getDatetime(d);
    }

    public static String readDataFromRequestStream(HttpServletRequest request) throws Exception {
        String line;
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), WEB_CHARSET));
        StringBuilder sbr = new StringBuilder();
        while ((line = r.readLine()) != null) {
            sbr.append(line);
        }
        return sbr.toString();
    }

    public static boolean hasPermission(HttpServletRequest request, String permission) {
        Set permissions = (Set)request.getSession(false).getAttribute(MANAGE_USER_PERMISSIONS);
        if (permissions == null) {
            permissions = Collections.EMPTY_SET;
        }
        return permissions.contains(permission);
    }

    public static Pagination getPagination(HttpServletRequest request) {
        Pagination pageNation = new Pagination();
        String gotoPage = request.getParameter("gotoPage");
        String pageSize = request.getParameter("pageSize");
        String rowCount = request.getParameter("rowCount");
        int _gotoPage = 1;
        int _pageSize = 10;
        long _recordConut = -1L;
        try {
            if (gotoPage != null && (gotoPage = gotoPage.trim()).length() > 0) {
                _gotoPage = Integer.parseInt(gotoPage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_gotoPage < 1) {
            _gotoPage = 1;
        }
        try {
            if (pageSize != null && (pageSize = pageSize.trim()).length() > 0) {
                _pageSize = Integer.parseInt(pageSize);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_pageSize > 500) {
            _pageSize = 500;
        } else if (_pageSize < 1) {
            _pageSize = 1;
        }
        pageNation.setGotoPage(_gotoPage);
        pageNation.setPageSize(_pageSize);
        try {
            if (rowCount != null && (rowCount = rowCount.trim()).length() > 0) {
                _recordConut = Long.parseLong(rowCount);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_recordConut > -1L) {
            pageNation.setRecordsCount(_recordConut);
            pageNation.setNeedQueryCount(false);
        } else {
            pageNation.setNeedQueryCount(true);
        }
        return pageNation;
    }

    public static void insertCarparkOperationLog(SqlSession session, HttpServletRequest request, int op_cat, int op_type, String op_des) {
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        CarparkUser opuser = WebUtil.getLoginManageUser(request);
        CarparkOperationLog opLog = new CarparkOperationLog();
        opLog.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
        opLog.setProject_id(ServiceUtil.getServiceContext().getProjectId());
        opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
        opLog.setOp_cat(op_cat);
        opLog.setOp_des(ServiceUtil.getString(op_des, 500));
        opLog.setOp_time(WebUtil.getNow());
        opLog.setOp_type(op_type);
        opLog.setOp_user_code(opuser.getUser_code());
        opLog.setOp_user_name(opuser.getUser_name());
        if (session != null) {
            commonDaoService.insert(session, (Object)opLog);
        } else {
            commonDaoService.insert((Object)opLog);
        }
    }

    public static String getOrderBy(HttpServletRequest request, String defaultOrderBy) {
        String sortBy = request.getParameter("sortBy");
        if (sortBy == null || (sortBy = sortBy.trim()).length() == 0) {
            return defaultOrderBy;
        }
        char[] a1 = new char[]{'\"', '\'', '(', ')', '.', ';', '='};
        int i = 0;
        while (i < sortBy.length()) {
            char[] cArray = a1;
            int n = a1.length;
            int n2 = 0;
            while (n2 < n) {
                char a = cArray[n2];
                if (a == sortBy.charAt(i)) {
                    return defaultOrderBy;
                }
                ++n2;
            }
            ++i;
        }
        String s = sortBy.toLowerCase();
        if (s.indexOf(" group by ") != -1 || s.indexOf(" having ") != -1 || s.indexOf(" from ") != -1 || s.indexOf(" insert ") != -1 || s.indexOf(" select ") != -1 || s.indexOf(" where ") != -1 || s.indexOf(" update ") != -1 || s.indexOf(" delete ") != -1 || s.indexOf(" create ") != -1 || s.indexOf(" alter ") != -1 || s.indexOf(" drop ") != -1) {
            return defaultOrderBy;
        }
        return sortBy;
    }

    public static void printTableListJson(HttpServletRequest request, HttpServletResponse response, List<?> dataList, Long recordsCount) {
        String draw = request.getParameter("draw");
        if (dataList != null && !dataList.isEmpty()) {
            ArrayList rList = new ArrayList(dataList.size());
            for (Object obj : dataList) {
                rList.add(ServiceUtil.toStringMap(obj, ""));
            }
            dataList = rList;
        } else if (dataList == null) {
            dataList = new ArrayList(0);
        }
        LinkedHashMap<String, Object> resMap = new LinkedHashMap<String, Object>();
        if (draw != null && draw.length() > 0) {
            resMap.put("draw", draw);
            if (recordsCount != null) {
                resMap.put("recordsTotal", recordsCount);
                resMap.put("recordsFiltered", recordsCount);
            }
            resMap.put("data", dataList);
        } else {
            if (recordsCount != null) {
                resMap.put("total", recordsCount);
            }
            resMap.put("rows", dataList);
        }
        String json = GsonBuilder.create().toJson(resMap);
        WebUtil.printFinshJson(response, json);
    }

    public static String getPicUri(String contextPath, String picPath, String hostNo, boolean showNopic) throws Exception {
        if (picPath == null || picPath.length() == 0) {
            if (showNopic) {
                picPath = "nopic";
            } else {
                return picPath;
            }
        }
        String picUrl = String.valueOf(contextPath) + "/manage/obtainRecordPic.action?p=" + BytesTool.compressBytes((byte[])picPath.getBytes(WEB_CHARSET));
        if (hostNo != null && hostNo.length() > 0) {
            picUrl = String.valueOf(picUrl) + "&t=" + BytesTool.compressBytes((byte[])hostNo.getBytes(WEB_CHARSET));
        }
        return picUrl;
    }
}

