/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action;

import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.dto.Carpark;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.dto.CarparkRole;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.BasicConfigVo;
import com.wovoe.carpark.web.WebLog;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.http.HttpUtil;
import com.wovoe.framework.http.MimeType;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;

@Action
public class InstallInitAction {
    public static KeyValueEntry<String, String> createOPTocken(Object param) {
        try {
            Calendar cl = Calendar.getInstance();
            cl.add(12, 10);
            HashMap<String, String> vls = new HashMap<String, String>();
            vls.put("validTimeMills", String.valueOf(cl.getTimeInMillis()));
            vls.put("param", GsonBuilder.create().toJson(param));
            String eKey = "R" + RandomStringGenerator.getDefaultInstance().getNewNumberString(8);
            vls.put("ran", eKey);
            String jsonStr = GsonBuilder.create().toJson(vls);
            Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
            String eValue = CryptoUtil.encrypt((String)jsonStr, (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
            return new KeyValueEntry((Object)eKey, (Object)eValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static <T> KeyValueEntry<String, T> getParamFromFromToken(String token, Class<?> paramClass) {
        Map vls;
        block5: {
            block4: {
                try {
                    if (token != null && token.length() != 0) break block4;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
            String tokenValue = CryptoUtil.decrypt((String)token, (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
            vls = (Map)GsonBuilder.create().fromJson(tokenValue, HashMap.class);
            Calendar cl = Calendar.getInstance();
            long v1 = cl.getTimeInMillis();
            long validTimeMills = Long.parseLong(vls.get("validTimeMills").toString());
            if (v1 <= validTimeMills) break block5;
            return null;
        }
        Object obj = GsonBuilder.create().fromJson((String)vls.get("param"), paramClass);
        return new KeyValueEntry((Object)vls.get("ran").toString(), obj);
    }

    private void printResponse(HttpServletResponse response, String key, String value) {
        WebUtil.printFinshText(response, String.valueOf(key) + "=" + value);
    }

    @Path(value="/updateClientSeverHost.action")
    public void updateClientSeverHost(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String optocken = request.getParameter("optocken");
        if (optocken == null || optocken.length() == 0) {
            response.sendError(403);
            return;
        }
        KeyValueEntry env = InstallInitAction.getParamFromFromToken(optocken, CarparkHost.class);
        if (env == null) {
            response.sendError(403);
            return;
        }
        CarparkHost serverHost = (CarparkHost)env.getValue();
        if (serverHost.getId() == null) {
            response.sendError(400);
            return;
        }
        if (serverHost.getHost_use() != 2 && serverHost.getHost_use() != 3) {
            response.sendError(400);
            return;
        }
        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
        if (localHost == null) {
            response.sendError(400);
            return;
        }
        if (localHost.getHost_use() != 1) {
            response.sendError(400);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        try (SqlSession sqlSession = commonDaoService.openSqlSession();){
            try {
                CarparkHost localSeverHost;
                Map<String, CarparkHost> hsotMap;
                commonDaoService.updateByPrimeryKey(sqlSession, (Object)serverHost);
                String serverHostPort = String.valueOf(serverHost.getHost_ip()) + ":" + serverHost.getHost_port();
                CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
                if (!serverHostPort.equals(config.getServer_host_port())) {
                    CommonParam udateParam2 = new CommonParam(commonDaoService.getTableName(CarparkLocalConfig.class));
                    udateParam2.addUpdate("server_host_port", (Object)serverHostPort);
                    udateParam2.addEQ("id", (Object)config.getId());
                    commonDaoService.update(sqlSession, udateParam2);
                }
                sqlSession.commit();
                if (ServiceUtil.getServiceContext().getDBConfigCache() != null && (hsotMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap()) != null && (localSeverHost = hsotMap.get(serverHost.getHost_no())) != null) {
                    if (!localSeverHost.getHost_ip().equals(serverHost.getHost_ip())) {
                        localSeverHost.setHost_ip(serverHost.getHost_ip());
                    }
                    if (localSeverHost.getHost_port().intValue() != serverHost.getHost_port().intValue()) {
                        localSeverHost.setHost_port(serverHost.getHost_port());
                    }
                }
                config.setServer_host_port(serverHostPort);
            }
            catch (Exception ex) {
                WebLog.getLog().warn((Object)"", (Throwable)ex);
                sqlSession.rollback();
                throw ex;
            }
        }
        this.printResponse(response, (String)env.getKey(), "SUCCESS");
    }

    @Path(value="/obtainInstallClientVo.action")
    public void obtainInstallClientVo(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String optocken = request.getParameter("optocken");
        if (optocken == null || optocken.length() == 0) {
            WebUtil.printFinshText(response, "ERROR:\u7f3a\u5c11\u53c2\u6570token");
            return;
        }
        KeyValueEntry env = InstallInitAction.getParamFromFromToken(optocken, HashMap.class);
        if (env == null) {
            WebUtil.printFinshText(response, "ERROR:\u65e0\u6548token,\u8bf7\u68c0\u67e5\u5ba2\u6237\u7aef\u4e3b\u673a\u4e0e\u670d\u52a1\u5668\u65f6\u95f4\u662f\u5426\u540c\u6b65!");
            return;
        }
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() == 1) {
            WebUtil.printFinshText(response, "ERROR:\u8bf7\u6c42\u9519\u8bef!\u8bf7\u6c42\u7684\u4e3b\u673a\u4e0d\u662f\u670d\u52a1\u5668");
            return;
        }
        Map vmap = (Map)env.getValue();
        if (vmap == null || vmap.isEmpty()) {
            WebUtil.printFinshText(response, "ERROR:\u5ba2\u6237\u7aef\u7248\u672c\u4e0e\u670d\u52a1\u5668\u7248\u672c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4f7f\u7528\u76f8\u540c\u7248\u672c\u90e8\u7f72");
            return;
        }
        String v_org = (String)vmap.get("v_org");
        String v_id = (String)vmap.get("v_id");
        String v_mills = (String)vmap.get("v_mills");
        String v_sign = (String)vmap.get("v_sign");
        String v_ver = (String)vmap.get("v_ver");
        if (v_org == null || v_org.length() == 0 || v_id == null || v_id.length() == 0 || v_mills == null || v_mills.length() == 0 || v_sign == null || v_sign.length() == 0 || v_ver == null || v_ver.length() == 0) {
            WebUtil.printFinshText(response, "ERROR:\u7f3a\u5c11\u5173\u952e\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u7aef\u4e0e\u670d\u52a1\u5668\u7248\u672c\u662f\u5426\u4e00\u81f4");
            return;
        }
        if (!v_org.equals(String.valueOf(ServiceUtil.getServiceContext().getAuthInfo().getOrgId()))) {
            WebUtil.printFinshText(response, "ERROR:\u8fde\u63a5\u88ab\u62d2\u7edd\uff0c\u5e94\u7528\u4e3b\u4f53\u4e0d\u4e00\u81f4\uff01\u8bf7\u68c0\u67e5\u5e94\u7528\u6388\u6743\u8bc1\u4e66");
            return;
        }
        if (!v_id.equals(String.valueOf(ServiceUtil.getServiceContext().getAuthInfo().getG()))) {
            WebUtil.printFinshText(response, "ERROR:\u8fde\u63a5\u88ab\u62d2\u7edd\uff0c\u5e94\u7528\u8bc1\u4e66\u4e0d\u4e00\u81f4\uff01\u8bf7\u68c0\u67e5\u5e94\u7528\u6388\u6743\u8bc1\u4e66");
            return;
        }
        if (!v_ver.equals(ServiceUtil.getServiceContext().getVersion())) {
            WebUtil.printFinshText(response, "ERROR:\u8fde\u63a5\u88ab\u62d2\u7edd\uff0c \u5ba2\u6237\u7aef\u7248\u672c\u4e0e\u670d\u52a1\u5668\u7248\u672c\u4e0d\u4e00\u81f4\uff0c\u670d\u52a1\u5668\u7248\u672c\uff1a" + ServiceUtil.getServiceContext().getVersion());
            return;
        }
        String sign = CryptoUtil.MD5Encode((String)(String.valueOf(v_org) + "&" + v_id + "&" + v_mills + "&" + v_ver + "&" + ServiceUtil.getServiceContext().getAuthInfo().getL()));
        if (!sign.equals(v_sign)) {
            WebUtil.printFinshText(response, "ERROR:\u8fde\u63a5\u88ab\u62d2\u7edd\uff0c\u6570\u636e\u7b7e\u540d\u9519\u8bef\uff01\u8bf7\u68c0\u67e5\u5e94\u7528\u6388\u6743\u8bc1\u4e66");
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        BasicConfigVo vo = new BasicConfigVo();
        List hostList = commonDaoService.selectList(new SearchParam(), CarparkHost.class, null);
        Carpark carpark = (Carpark)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)ServiceUtil.getServiceContext().getCarparkId()), Carpark.class);
        List roleList = commonDaoService.selectList(new SearchParam(), CarparkRole.class, null);
        List userList = commonDaoService.selectList(new SearchParam(), CarparkUser.class, null);
        vo.setCarpark(carpark);
        vo.setHostList(hostList);
        vo.setRoleList(roleList);
        vo.setUserList(userList);
        String jsonStr = GsonBuilder.create().toJson((Object)vo);
        Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
        String eValue = CryptoUtil.encrypt((String)jsonStr, (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
        this.printResponse(response, (String)env.getKey(), eValue);
    }

    @Path(value="/downloadUpgradeFile.action")
    public void downloadUpgradeFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String optocken = request.getParameter("optocken");
        if (optocken == null || optocken.length() == 0) {
            response.sendError(403);
            return;
        }
        KeyValueEntry env = InstallInitAction.getParamFromFromToken(optocken, HashMap.class);
        if (env == null) {
            response.sendError(403);
            return;
        }
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() == 1) {
            response.sendError(400);
            return;
        }
        String v = (String)((Map)env.getValue()).get("version");
        if (v == null || v.length() == 0) {
            response.sendError(400);
            return;
        }
        File f1 = new File(PathFinder.findLocalDir(), "upgrade/download/" + v + ".zip");
        if (!f1.exists() || !f1.isFile()) {
            response.sendError(404);
            return;
        }
        response.setStatus(200);
        String mime = MimeType.getByFilename((String)f1.getName());
        if (mime == null || mime.length() == 0) {
            mime = "application/zip";
        }
        response.setContentType(mime);
        try (OutputStream os = null;){
            URL resource = f1.toURI().toURL();
            URLConnection urlConnection = resource.openConnection();
            int length = urlConnection.getContentLength();
            response.setContentLength(length);
            try (InputStream is = urlConnection.getInputStream();){
                int read;
                os = response.getOutputStream();
                byte[] buff = new byte[8192];
                int total = 0;
                while ((read = is.read(buff)) != -1) {
                    total += read;
                    os.write(buff, 0, read);
                }
                if (total != length) {
                    WebLog.getLog().warn((Object)("Was supposed to send " + length + ", but sent " + total));
                }
            }
        }
    }

    @Path(value="/carparkbindcloudseq.action")
    public void carparkbindcloudseq(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String p = request.getParameter("p");
        if (p == null || p.length() == 0) {
            response.sendError(400);
        }
        HashMap<String, String> postMap = new HashMap<String, String>();
        postMap.put("p", p);
        String result = HttpUtil.doRequest((String)ServiceUtil.getBindCloudSeqUrl(), null, postMap);
        WebUtil.printFinshHtml(response, result);
    }

    @Path(value="/downloadParkingDisplayUpgradeFile.action")
    public void downloadParkingDisplayUpgradeFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filex;
        String filePath = request.getParameter("filePath");
        if (filePath == null || filePath.length() == 0) {
            response.sendError(400);
            return;
        }
        try {
            filex = new String(BytesTool.unCompress((String)filePath), "UTF-8");
        }
        catch (Exception ex) {
            response.sendError(400);
            return;
        }
        if (!filex.endsWith(".apk")) {
            response.sendError(302);
            return;
        }
        File file = new File(filex);
        if (!file.exists() || !file.isFile()) {
            response.sendError(302);
            return;
        }
        response.setStatus(200);
        String mime = "application/octet-stream";
        response.setContentType(mime);
        try (OutputStream os = null;){
            URL resource = file.toURI().toURL();
            URLConnection urlConnection = resource.openConnection();
            int length = urlConnection.getContentLength();
            response.setContentLength(length);
            try (InputStream is = urlConnection.getInputStream();){
                int read;
                os = response.getOutputStream();
                byte[] buff = new byte[8192];
                int total = 0;
                while ((read = is.read(buff)) != -1) {
                    total += read;
                    os.write(buff, 0, read);
                }
                if (total != length) {
                    WebLog.getLog().warn((Object)("Was supposed to send " + length + ", but sent " + total));
                }
            }
        }
    }

    @Path(value="/downloadParkingDisplayVideoFile.action")
    public void downloadParkingDisplayVideoFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filex;
        String filePath = request.getParameter("filePath");
        if (filePath == null || filePath.length() == 0) {
            response.sendError(400);
            return;
        }
        try {
            filex = new String(BytesTool.unCompress((String)filePath), "UTF-8");
        }
        catch (Exception ex) {
            response.sendError(400);
            return;
        }
        if (!(filex.endsWith(".mp4") || filex.endsWith(".avi") || filex.endsWith(".3gp"))) {
            response.sendError(302);
            return;
        }
        File file = new File(filex);
        if (!file.exists() || !file.isFile()) {
            response.sendError(302);
            return;
        }
        response.setStatus(200);
        String mime = filex.endsWith(".mp4") ? "video/mp4" : (filex.endsWith(".avi") ? "video/x-msvideo" : (filex.endsWith(".3gp") ? "video/3gpp" : "application/octet-stream"));
        response.setContentType(mime);
        try (OutputStream os = null;){
            URL resource = file.toURI().toURL();
            URLConnection urlConnection = resource.openConnection();
            int length = urlConnection.getContentLength();
            response.setContentLength(length);
            try (InputStream is = urlConnection.getInputStream();){
                int read;
                os = response.getOutputStream();
                byte[] buff = new byte[8192];
                int total = 0;
                while ((read = is.read(buff)) != -1) {
                    total += read;
                    os.write(buff, 0, read);
                }
                if (total != length) {
                    WebLog.getLog().warn((Object)("Was supposed to send " + length + ", but sent " + total));
                }
            }
        }
    }

    @Path(value="/smc/uploadHandleResultMsg.action")
    public void uploadHandleResultMsg(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String notifyId = request.getParameter("notifyId");
        String code = request.getParameter("code");
        String msg = request.getParameter("msg");
        if (notifyId != null && notifyId.length() > 0 && code != null && code.length() > 0) {
            OperationFutureHandler h1;
            Integer codeInt;
            try {
                codeInt = Integer.valueOf(code);
            }
            catch (Throwable ex) {
                return;
            }
            Object obj = ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)notifyId);
            if (obj != null && obj instanceof OperationFutureHandler && (h1 = (OperationFutureHandler)ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)notifyId)) != null) {
                try {
                    h1.setResult((Object)new KeyValueEntry((Object)codeInt, (Object)msg));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

