/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action;

import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.vo.UploadPicToken;
import com.wovoe.carpark.web.WebLog;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.http.MimeType;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

@Action
public class PicAction {
    @Path(value="/obtainlocalpic.action")
    public void obtainlocalpic(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block23: {
            String picPath = request.getParameter("path");
            if (picPath == null || picPath.isEmpty()) {
                response.sendError(404);
                return;
            }
            try {
                byte[] b = BytesTool.unCompress((String)picPath);
                String dbpath = new String(b, "UTF-8");
                RecordSaveService s = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                String path = s.getLocalPicPath(dbpath);
                File f1 = new File(path);
                if (f1.exists() && f1.isFile()) {
                    block21: {
                        String mime = MimeType.getByFilename((String)path);
                        response.setContentType(mime);
                        try {
                            String w = request.getParameter("w");
                            String h = request.getParameter("h");
                            int width = 0;
                            int height = 0;
                            if (w != null && w.length() > 0) {
                                width = Integer.parseInt(w);
                            }
                            if (h != null && h.length() > 0) {
                                height = Integer.parseInt(h);
                            }
                            if (width <= 0 || height <= 0) break block21;
                            BufferedImage image = ImageIO.read(f1);
                            try {
                                image = CarparkGuiSkinUtil.resizeImage(image, width, height);
                                try (ServletOutputStream out = response.getOutputStream();){
                                    ImageIO.write((RenderedImage)image, "JPEG", (OutputStream)out);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return;
                        }
                        catch (Exception w) {
                            // empty catch block
                        }
                    }
                    try (OutputStream os = null;
                         FileInputStream is = new FileInputStream(f1);){
                        int read;
                        os = response.getOutputStream();
                        byte[] buff = new byte[8192];
                        while ((read = ((InputStream)is).read(buff)) != -1) {
                            os.write(buff, 0, read);
                        }
                        break block23;
                    }
                }
                response.sendError(404);
                return;
            }
            catch (Exception ex) {
                response.sendError(404);
                return;
            }
        }
    }

    @Path(value="/uploadlocalpic.action")
    public void uploadPic(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String upToken = request.getParameter("upToken");
            if (upToken == null || upToken.length() == 0) {
                this.printError(response, "\u7f3a\u5c11token");
                return;
            }
            UploadPicToken token = UploadPicToken.parseToken(upToken);
            if (token == null) {
                this.printError(response, "\u65e0\u6548token");
                return;
            }
            if (ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(token.getHostNo()) == null) {
                this.printError(response, "\u65e0\u6548\u4e3b\u673a:" + token.getHostNo());
                return;
            }
            if (token.getSavePath() == null || token.getSavePath().length() == 0) {
                this.printError(response, "\u65e0\u6548token");
                return;
            }
            DiskFileItemFactory f = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)f);
            upload.setSizeMax(0x1400000L);
            boolean uploadSuccess = false;
            List fileItemList = upload.parseRequest(request);
            for (Object obj : fileItemList) {
                FileItem fileItem = (FileItem)obj;
                if (fileItem.isFormField()) continue;
                File file1 = new File(PathFinder.findLocalPicDir(), token.getSavePath());
                File pf = file1.getParentFile();
                if (!pf.exists() || !pf.isDirectory()) {
                    pf.mkdirs();
                }
                fileItem.write(file1);
                uploadSuccess = true;
            }
            try {
                response.setContentType("text/html");
                response.setCharacterEncoding("UTF-8");
                PrintWriter httpWriter = response.getWriter();
                httpWriter.print("upload:" + uploadSuccess);
                httpWriter.close();
            }
            catch (Exception ex) {
                WebLog.getLog().warn((Object)"", (Throwable)ex);
            }
        }
        catch (Throwable ex) {
            this.printError(response, ex.getMessage());
            WebLog.getLog().warn((Object)"", ex);
        }
    }

    @Path(value="/getSystemImage.action")
    public void getSystemImage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        InputStream is;
        block31: {
            String contentType;
            String name = request.getParameter("name");
            StringBuilder exten = new StringBuilder();
            if ("dnct".equals("ui")) {
                try {
                    Class<?> cl = Class.forName("com.wovoe.carparj.fragment.dnct.ui.DnctImageUtil");
                    is = (InputStream)cl.getMethod("obtainImageInput", String.class, StringBuilder.class).invoke(cl, name, exten);
                }
                catch (Exception ex) {
                    WebLog.getLog().error((Object)ex.toString());
                    return;
                }
            } else {
                is = CarparkGuiSkinUtil.getCarparkGuiSkin().obtainImageInput(name, exten);
            }
            if (is == null) {
                return;
            }
            String ext = request.getParameter("ext");
            if (ext == null || ext.length() == 0) {
                ext = exten.toString();
            }
            if (ext == null || ext.length() == 0) {
                contentType = "image/png";
                ext = "png";
            } else {
                contentType = MimeType.get((String)ext, null);
                if (contentType == null || contentType.length() == 0) {
                    contentType = "image/png";
                    ext = "png";
                }
            }
            response.setContentType(contentType);
            try {
                BufferedImage image;
                String w = request.getParameter("w");
                String h = request.getParameter("h");
                int width = 0;
                int height = 0;
                if (w != null && w.length() > 0) {
                    width = Integer.parseInt(w);
                }
                if (h != null && h.length() > 0) {
                    height = Integer.parseInt(h);
                }
                if (width <= 0 || height <= 0) break block31;
                try {
                    try {
                        image = ImageIO.read(is);
                    }
                    catch (Exception ex) {
                        is.close();
                        return;
                    }
                }
                finally {
                    is.close();
                }
                try {
                    image = CarparkGuiSkinUtil.resizeImage(image, width, height);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try (ServletOutputStream out = response.getOutputStream();){
                    ImageIO.write((RenderedImage)image, ext, (OutputStream)out);
                }
                return;
            }
            catch (Exception w) {
                // empty catch block
            }
        }
        try (ServletOutputStream os = null;){
            try {
                os = response.getOutputStream();
                byte[] buff = new byte[8192];
                int read = 0;
                while ((read = is.read(buff)) != -1) {
                    os.write(buff, 0, read);
                }
            }
            finally {
                is.close();
            }
        }
    }

    private void printError(HttpServletResponse response, String errmsg) {
        try {
            response.setContentType("text/html");
            response.setCharacterEncoding("UTF-8");
            PrintWriter httpWriter = response.getWriter();
            httpWriter.println("error:" + errmsg);
            httpWriter.close();
        }
        catch (Exception ex) {
            WebLog.getLog().warn((Object)"", (Throwable)ex);
        }
    }
}

