/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action.manage;

import com.google.gson.Gson;
import com.wovoe.carpark.AuthInfo;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.cloud.CloudDataProtocol;
import com.wovoe.carpark.dto.Carpark;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkChannelArea;
import com.wovoe.carpark.dto.CarparkSpaceType;
import com.wovoe.carpark.dto.CarparkSpaceTypeQuantity;
import com.wovoe.carpark.dto.CarparkStrategy;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.BasicSettingService;
import com.wovoe.carpark.web.LeftMenu;
import com.wovoe.carpark.web.Permission;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.carpark.web.WritePermission;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.HardWareInfo;
import com.wovoe.framework.HardWareUtils;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.http.HttpUtil;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;

@Action(value="/manage")
public class CarparkAreaSettingAction {
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u8f66\u573a/\u533a\u57df\u8bbe\u7f6e(\u67e5\u8be2)")
    @LeftMenu(name="\u8f66\u573a/\u533a\u57df\u8bbe\u7f6e", parent_name="\u57fa\u7840\u8bbe\u7f6e", order=111)
    @Path(value="/showCarparkArea.action")
    public void showCarparkArea(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isAjax;
        String op;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carparkId = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Carpark carpark = (Carpark)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)carparkId).addEQ("project_id", (Object)project_id), Carpark.class);
        request.setAttribute("carpark", (Object)carpark);
        BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
        List<CarparkArea> areaList = basicSettingService.getCarparkAreaList(carparkId, project_id, commonDaoService);
        request.setAttribute("areaList", areaList);
        if (areaList != null && !areaList.isEmpty()) {
            request.setAttribute("firestRootAreaNo", (Object)areaList.get(0).getArea_no());
        }
        if ((op = request.getParameter("op")) == null) {
            op = "1";
        }
        request.setAttribute("op", (Object)op);
        if (op.equals("1")) {
            int parkSpaceCount = 0;
            for (CarparkArea area : areaList) {
                if (area.getSpace_quantities() == null || area.getSpace_quantities() <= 0) continue;
                parkSpaceCount += area.getSpace_quantities().intValue();
            }
            request.setAttribute("parkSpaceCount", (Object)parkSpaceCount);
            boolean connected = ServiceUtil.getServiceContext().isConnectedCloud();
            if (!connected && carpark != null && carpark.getCloud_carpark_id() != null && carpark.getCloud_carpark_id().length() > 0 && carpark.getCloud_carpark_sign_key() != null && carpark.getCloud_carpark_sign_key().length() > 0 && ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() != 1) {
                request.setAttribute("checkedCloudConnectPath", (Object)"1");
            }
            request.setAttribute("connectedCloud", (Object)connected);
        } else if (op.equals("2")) {
            String areaNo = request.getParameter("areaNo");
            CarparkArea carparkArea = null;
            for (CarparkArea area : areaList) {
                if (!area.getArea_no().equals(areaNo)) continue;
                carparkArea = area;
                break;
            }
            if (carparkArea != null) {
                request.setAttribute("carparkArea", carparkArea);
                if (carparkArea.getParent_area_no() != null && carparkArea.getParent_area_no().length() > 0 && carparkArea.getArea_level() > 1) {
                    CarparkArea pArea = null;
                    for (CarparkArea area : areaList) {
                        if (!area.getArea_no().equals(carparkArea.getParent_area_no())) continue;
                        pArea = area;
                        break;
                    }
                    if (pArea != null) {
                        request.setAttribute("pArea", pArea);
                    }
                }
            }
        }
        boolean bl = isAjax = request.getParameter("ajax") != null;
        if (!isAjax) {
            WebUtil.showMainContentWithHead("\u8f66\u573a/\u533a\u57df\u8bbe\u7f6e", "carparkArea", request, response);
        }
    }

    @Path(value="/checkCloudConnection.action")
    public void checkCloudConnection(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String text = ServiceUtil.getServiceContext().isConnectedCloud() ? "1" : "0";
        WebUtil.printFinshText(response, text);
    }

    @WritePermission
    @Path(value="/bindCloudCarparkId.action")
    public void bindCloudCarparkId(HttpServletRequest request, HttpServletResponse response) throws Exception {
        CloudDataProtocol p;
        String reulst;
        Integer carparkId;
        if (!WebUtil.hasPermission(request, "/manage/updateCarpark.action")) {
            response.sendError(403);
            return;
        }
        try {
            String id = request.getParameter("id");
            carparkId = Integer.valueOf(id);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u64cd\u4f5c\u5931\u8d25,\u7f3a\u5c11id!", response);
            return;
        }
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Carpark carpark = (Carpark)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)carparkId).addEQ("project_id", (Object)project_id), Carpark.class);
        if (carpark == null) {
            WebUtil.printFinshJson(2, "\u64cd\u4f5c\u5931\u8d25\uff0c\u8f66\u573a\u4e0d\u5b58\u5728!", response);
            return;
        }
        String cloud_carpark_id = request.getParameter("cloud_carpark_id");
        if (cloud_carpark_id == null || cloud_carpark_id.length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u4e91\u505c\u8f66\u573aID", response);
            return;
        }
        String cloud_carpark_sign_key = request.getParameter("cloud_carpark_sign_key");
        if (cloud_carpark_sign_key == null || cloud_carpark_sign_key.length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u4e91API\u79d8\u94a5", response);
            return;
        }
        String t = request.getParameter("t");
        if (t == null || t.length() == 0) {
            WebUtil.printFinshJson(1, "\u975e\u6cd5\u8bf7\u6c42", response);
            return;
        }
        if (ServiceUtil.getServiceContext().getCarpark().getBind_cloud() != null && ServiceUtil.getServiceContext().getCarpark().getBind_cloud() == 1 && ServiceUtil.getServiceContext().getCarpark().getCloud_carpark_id() != null && ServiceUtil.getServiceContext().getCarpark().getCloud_carpark_id().length() > 0 && !ServiceUtil.getServiceContext().getCarpark().getCloud_carpark_id().equals(cloud_carpark_id)) {
            WebUtil.printFinshJson(1, "\u5df2\u7ed1\u5b9a\u4e91\u7aefID: " + ServiceUtil.getServiceContext().getCarpark().getCloud_carpark_id() + ", \u4e0d\u53ef\u7ed1\u5b9a\u5176\u4ed6ID!", response);
            return;
        }
        if (cloud_carpark_sign_key.length() != 32) {
            WebUtil.printFinshJson(1, "\u4e91API\u79d8\u94a5\u9519\u8bef\uff0c\u9700\u8981\u91cd\u65b0\u8bbe\u7f6e", response);
            return;
        }
        AuthInfo authInfo = ServiceUtil.getServiceContext().getAuthInfo();
        HardWareInfo hardWarInfo = HardWareUtils.getHardWareInfo();
        LinkedHashMap<String, String> hostInfoMap = new LinkedHashMap<String, String>();
        hostInfoMap.put("motherboardSn", hardWarInfo.getMotherboardSn() == null ? "" : hardWarInfo.getMotherboardSn());
        hostInfoMap.put("hardDiskSn", hardWarInfo.getHardDiskSn() == null ? "" : hardWarInfo.getHardDiskSn());
        hostInfoMap.put("mac", hardWarInfo.getMac() == null ? "" : hardWarInfo.getMac());
        hostInfoMap.put("cpuSn", hardWarInfo.getCpuSn() == null ? "" : hardWarInfo.getCpuSn());
        hostInfoMap.put("osName", System.getProperty("os.name"));
        LinkedHashMap<String, Object> requestMap = new LinkedHashMap<String, Object>();
        requestMap.put("sn", authInfo.isOfficial() ? authInfo.getSn() : "trial");
        requestMap.put("hostNo", ServiceUtil.getServiceContext().getLocalHost().getHost_no());
        requestMap.put("authMode", String.valueOf(authInfo.getAuthMode()));
        requestMap.put("hostInfo", hostInfoMap);
        String id = cloud_carpark_id;
        String name = "carpark";
        CloudDataProtocol p1 = new CloudDataProtocol();
        p1.setId(id);
        p1.setName(name);
        p1.setCmd("bindParkId");
        p1.setMsgId("bindParkId-" + ServiceUtil.getServiceContext().createLongSeq());
        p1.setData(requestMap);
        p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
        String connparam = p1.toSendString(cloud_carpark_sign_key, ServiceUtil.getServiceContext().getCloudContext().getCloudConnTransferCrypto());
        HashMap<String, String> postMap = new HashMap<String, String>();
        postMap.put("p", connparam);
        postMap.put("t", t);
        String domian = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().getObtainConnectDomain();
        String url = "http://" + domian + "/core/common/carpark/bindCloudCarparkId.do";
        try {
            reulst = HttpUtil.doRequest((String)url, null, postMap);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff0c\u8bf7\u68c0\u67e5\u4e92\u8054\u7f51\u662f\u5426\u53ef\u7528!", response);
            return;
        }
        if (reulst == null || reulst.length() == 0) {
            WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u7a7a\u6570\u636e!", response);
            return;
        }
        if (reulst.startsWith("ERROR:")) {
            WebUtil.printFinshJson(1, reulst, response);
            return;
        }
        try {
            p = CloudDataProtocol.parse(reulst, cloud_carpark_sign_key, ServiceUtil.getServiceContext().getCloudContext().getCloudConnTransferCrypto(), null);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u4e86\u4e0d\u53ef\u8bc6\u522b\u7684\u6570\u636e", response);
            return;
        }
        if (!("bindParkId" + ServiceUtil.getServiceContext().getCloudContext().getResponseEndFlag()).equals(p.getCmd())) {
            WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u54cd\u5e94\u547d\u4ee4\u9519\u8bef!", response);
            return;
        }
        if (!id.equals(p.getId())) {
            WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u54cd\u5e94id\u9519\u8bef", response);
            return;
        }
        if (!name.equals(p.getName())) {
            WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u54cd\u5e94name\u9519\u8bef", response);
            return;
        }
        if (p.getData() == null) {
            WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a", response);
            return;
        }
        Map connectMap = (Map)p.getData();
        String responseCode = (String)connectMap.get("responseCode");
        if (responseCode == null || responseCode.length() == 0) {
            WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u54cd\u5e94\u7f3a\u5c11\u7ed3\u679c\u53c2\u6570", response);
            return;
        }
        if (!"0".equals(responseCode)) {
            WebUtil.printFinshJson(1, "\u9519\u8bef\uff1a" + responseCode + ", " + connectMap.get("responseMsg"), response);
            return;
        }
        Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
        String cloud_carpark_sign_key1 = CryptoUtil.encrypt((String)cloud_carpark_sign_key, (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
        boolean needUpdate = false;
        Carpark carpark0 = new Carpark();
        if (!cloud_carpark_id.equals(carpark.getCloud_carpark_id())) {
            carpark0.setCloud_carpark_id(cloud_carpark_id);
            needUpdate = true;
        }
        if (!cloud_carpark_sign_key1.equals(carpark.getCloud_carpark_sign_key())) {
            carpark0.setCloud_carpark_sign_key(cloud_carpark_sign_key1);
            needUpdate = true;
        }
        if (carpark.getBind_cloud() == null || carpark.getBind_cloud() != 1) {
            carpark0.setBind_cloud(1);
        }
        if (needUpdate) {
            carpark0.setId(carparkId);
            carpark0.setLast_updated_time(WebUtil.getNow());
            commonDaoService.updateByPrimeryKey((Object)carpark0);
        }
        ServiceUtil.getServiceContext().getCarpark().setCloud_carpark_sign_key(cloud_carpark_sign_key1);
        ServiceUtil.getServiceContext().getCarpark().setCloud_carpark_id(cloud_carpark_id);
        ServiceUtil.getServiceContext().getCarpark().setBind_cloud(1);
        WebUtil.insertCarparkOperationLog(null, request, Constants.LOG_OP_CAT_3, Constants.LOG_OP_TYPE_CAT_3_1, "\u7ed1\u5b9a\u4e91\u7aefid:" + cloud_carpark_id + "\u6210\u529f!");
        WebUtil.printFinshJson(0, "\u5df2\u6210\u529f\u7ed1\u5b9a", response);
    }

    @WritePermission
    @Path(value="/checkCarparkCloudConfig.action")
    public void checkCarparkCloudConfig(HttpServletRequest request, HttpServletResponse response) {
        block32: {
            try {
                CloudDataProtocol p;
                String reulst;
                String cloud_carpark_sign_key;
                String cloud_carpark_id;
                if (!WebUtil.hasPermission(request, "/manage/showCarparkArea.action")) {
                    response.sendError(403);
                    return;
                }
                String op = request.getParameter("op");
                if (op == null || op.length() == 0) {
                    WebUtil.printFinshJson(1, "\u7f3a\u5c11\u53c2\u6570", response);
                    return;
                }
                if ("1".equals(op)) {
                    cloud_carpark_id = request.getParameter("cloud_carpark_id");
                    if (cloud_carpark_id == null || cloud_carpark_id.length() == 0) {
                        WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u4e91\u505c\u8f66\u573aID", response);
                        return;
                    }
                    cloud_carpark_sign_key = request.getParameter("cloud_carpark_sign_key");
                    if (cloud_carpark_sign_key == null || cloud_carpark_sign_key.length() == 0) {
                        WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u4e91API\u79d8\u94a5", response);
                        return;
                    }
                    if (ServiceUtil.getServiceContext().getCarpark().getBind_cloud() != null && ServiceUtil.getServiceContext().getCarpark().getBind_cloud() == 1 && ServiceUtil.getServiceContext().getCarpark().getCloud_carpark_id() != null && ServiceUtil.getServiceContext().getCarpark().getCloud_carpark_id().length() > 0 && !ServiceUtil.getServiceContext().getCarpark().getCloud_carpark_id().equals(cloud_carpark_id)) {
                        WebUtil.printFinshJson(1, "\u5df2\u7ed1\u5b9a\u4e91\u7aefID: " + ServiceUtil.getServiceContext().getCarpark().getCloud_carpark_id() + ", \u4e0d\u53ef\u67e5\u8be2\u5176\u5b83ID!", response);
                        return;
                    }
                } else {
                    cloud_carpark_id = ServiceUtil.getServiceContext().getCarpark().getCloud_carpark_id();
                    cloud_carpark_sign_key = ServiceUtil.getServiceContext().getCarpark().getCloud_carpark_sign_key();
                    if (cloud_carpark_id == null || cloud_carpark_id.length() == 0) {
                        WebUtil.printFinshJson(1, "\u8f66\u573a\u4e91ID\u672a\u914d\u7f6e", response);
                        return;
                    }
                    if (cloud_carpark_sign_key == null || cloud_carpark_sign_key.length() == 0) {
                        WebUtil.printFinshJson(1, "\u4e91API\u79d8\u94a5\u672a\u914d\u7f6e", response);
                        return;
                    }
                    if (cloud_carpark_sign_key.length() != 32) {
                        try {
                            Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                            cloud_carpark_sign_key = CryptoUtil.decrypt((String)cloud_carpark_sign_key, (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
                        }
                        catch (Exception ex) {
                            WebUtil.printFinshJson(1, "\u4e91API\u79d8\u94a5\u9519\u8bef\uff0c\u9700\u8981\u91cd\u65b0\u8bbe\u7f6e", response);
                            return;
                        }
                    }
                }
                if (cloud_carpark_sign_key.length() != 32) {
                    WebUtil.printFinshJson(1, "\u4e91API\u79d8\u94a5\u9519\u8bef\uff0c\u9700\u8981\u91cd\u65b0\u8bbe\u7f6e", response);
                    return;
                }
                AuthInfo authInfo = ServiceUtil.getServiceContext().getAuthInfo();
                HardWareInfo hardWarInfo = HardWareUtils.getHardWareInfo();
                LinkedHashMap<String, String> hostInfoMap = new LinkedHashMap<String, String>();
                hostInfoMap.put("motherboardSn", hardWarInfo.getMotherboardSn() == null ? "" : hardWarInfo.getMotherboardSn());
                hostInfoMap.put("hardDiskSn", hardWarInfo.getHardDiskSn() == null ? "" : hardWarInfo.getHardDiskSn());
                hostInfoMap.put("mac", hardWarInfo.getMac() == null ? "" : hardWarInfo.getMac());
                hostInfoMap.put("cpuSn", hardWarInfo.getCpuSn() == null ? "" : hardWarInfo.getCpuSn());
                hostInfoMap.put("osName", System.getProperty("os.name"));
                LinkedHashMap<String, Object> requestMap = new LinkedHashMap<String, Object>();
                requestMap.put("sn", authInfo.isOfficial() ? authInfo.getSn() : "trial");
                requestMap.put("hostNo", ServiceUtil.getServiceContext().getLocalHost().getHost_no());
                requestMap.put("authMode", String.valueOf(authInfo.getAuthMode()));
                requestMap.put("hostInfo", hostInfoMap);
                String id = cloud_carpark_id;
                String name = "carpark";
                CloudDataProtocol p1 = new CloudDataProtocol();
                p1.setId(id);
                p1.setName(name);
                p1.setCmd("connect");
                p1.setMsgId("connect-" + ServiceUtil.getServiceContext().createLongSeq());
                p1.setData(requestMap);
                p1.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
                String connparam = p1.toSendString(cloud_carpark_sign_key, ServiceUtil.getServiceContext().getCloudContext().getCloudConnTransferCrypto());
                HashMap<String, String> postMap = new HashMap<String, String>();
                postMap.put("p", connparam);
                String domian = ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().getObtainConnectDomain();
                String url = "http://" + domian + "/core/common/carpark/checkConnValid.do";
                try {
                    reulst = HttpUtil.doRequest((String)url, null, postMap);
                }
                catch (Exception ex) {
                    WebUtil.printFinshJson(1, "\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff0c\u8bf7\u68c0\u67e5\u4e92\u8054\u7f51\u662f\u5426\u53ef\u7528!", response);
                    return;
                }
                if (reulst == null || reulst.length() == 0) {
                    WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u7a7a\u6570\u636e!", response);
                    return;
                }
                if (reulst.startsWith("ERROR:")) {
                    if (reulst.startsWith("ERROR:UNBOUND,")) {
                        if ("1".equals(op)) {
                            try {
                                String a = reulst.substring("ERROR:UNBOUND,".length()).trim();
                                String json = ServiceUtil.getServiceContext().getCloudContext().getCloudConnTransferCrypto().decrypt(a);
                                Gson gson = GsonBuilder.create();
                                Map data = (Map)gson.fromJson(json, HashMap.class);
                                WebUtil.printFinshJson(10000, "needbind", data, response);
                                break block32;
                            }
                            catch (Exception ex) {
                                WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u7ed1\u5b9a\u6570\u636e\u5f02\u5e38!", response);
                                return;
                            }
                        }
                        WebUtil.printFinshJson(10000, "\u4e91\u670d\u52a1\u5668\u5df2\u89e3\u7ed1\uff0c\u8bf7\u70b9\u51fb\u4fee\u6539\u8bbe\u7f6e\uff0c\u91cd\u65b0\u8f93\u5165api\u79d8\u94a5\u8fdb\u884c\u7ed1\u5b9a", response);
                        return;
                    }
                    WebUtil.printFinshJson(1, reulst, response);
                    return;
                }
                try {
                    p = CloudDataProtocol.parse(reulst, cloud_carpark_sign_key, ServiceUtil.getServiceContext().getCloudContext().getCloudConnTransferCrypto(), null);
                }
                catch (Exception ex) {
                    WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u4e86\u4e0d\u53ef\u8bc6\u522b\u7684\u6570\u636e", response);
                    return;
                }
                if (!("connect" + ServiceUtil.getServiceContext().getCloudContext().getResponseEndFlag()).equals(p.getCmd())) {
                    WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u54cd\u5e94\u547d\u4ee4\u9519\u8bef!", response);
                    return;
                }
                if (!id.equals(p.getId())) {
                    WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u54cd\u5e94id\u9519\u8bef", response);
                    return;
                }
                if (!name.equals(p.getName())) {
                    WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u54cd\u5e94name\u9519\u8bef", response);
                    return;
                }
                if (p.getData() == null) {
                    WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a", response);
                    return;
                }
                Map connectMap = (Map)p.getData();
                String responseCode = (String)connectMap.get("responseCode");
                if (responseCode == null || responseCode.length() == 0) {
                    WebUtil.printFinshJson(1, "\u4e91\u7aef\u670d\u52a1\u5668\u54cd\u5e94\u7f3a\u5c11\u7ed3\u679c\u53c2\u6570", response);
                    return;
                }
                if (!"0".equals(responseCode)) {
                    WebUtil.printFinshJson(1, "\u9519\u8bef\uff1a" + responseCode + ", " + connectMap.get("responseMsg"), response);
                    return;
                }
                WebUtil.printFinshJson(0, "\u914d\u7f6e\u4e91id\u4e0e\u79d8\u94a5\u53ef\u7528", response);
                return;
            }
            catch (Exception ex) {
                if (!response.isCommitted()) {
                    WebUtil.printFinshJson(1, "\u5185\u90e8\u9519\u8bef", response);
                }
                return;
            }
        }
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u8f66\u573a/\u533a\u57df\u8bbe\u7f6e-\u4fee\u6539\u8f66\u573a\u914d\u7f6e")
    @Path(value="/updateCarpark.action")
    public void updateCarpark(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String bind_cloud;
        String id = request.getParameter("id");
        Integer carparkId = null;
        try {
            carparkId = Integer.valueOf(id);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u64cd\u4f5c\u5931\u8d25,\u7f3a\u5c11id!", response);
            return;
        }
        String carpark_name = request.getParameter("carpark_name");
        if (carpark_name == null || (carpark_name = carpark_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u64cd\u4f5c\u5931\u8d25\uff0c\u8f66\u573a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", response);
            return;
        }
        if (carpark_name.getBytes("UTF-8").length > 64) {
            WebUtil.printFinshJson(1, "\u64cd\u4f5c\u5931\u8d25\uff0c\u8f66\u573a\u540d\u79f0\u592a\u957f!", response);
            return;
        }
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Carpark carpark = (Carpark)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)carparkId).addEQ("project_id", (Object)project_id), Carpark.class);
        if (carpark == null) {
            WebUtil.printFinshJson(2, "\u64cd\u4f5c\u5931\u8d25\uff0c\u8f66\u573a\u4e0d\u5b58\u5728!", response);
            return;
        }
        Carpark carpark0 = new Carpark();
        boolean needUpdate = false;
        StringBuilder op_des = new StringBuilder(128);
        if (!carpark_name.equals(carpark.getCarpark_name())) {
            carpark0.setCarpark_name(carpark_name);
            op_des.append("\u4fee\u6539\u8f66\u573a\u540d\u79f0\u4e3a: ").append(carpark_name);
            needUpdate = true;
        }
        if (Constants.YES_STR.equals(bind_cloud = request.getParameter("bind_cloud"))) {
            String cloud_carpark_id = request.getParameter("cloud_carpark_id");
            String cloud_carpark_sign_key = request.getParameter("cloud_carpark_sign_key");
            if (cloud_carpark_id == null || cloud_carpark_id.length() == 0) {
                WebUtil.printFinshJson(2, "\u64cd\u4f5c\u5931\u8d25\uff0c\u7f3a\u5c11\u4e91\u505c\u8f66\u573aID", response);
                return;
            }
            if (cloud_carpark_sign_key == null || cloud_carpark_sign_key.length() == 0) {
                WebUtil.printFinshJson(2, "\u64cd\u4f5c\u5931\u8d25\uff0c\u7f3a\u5c11\u4e91API\u79d8\u94a5", response);
                return;
            }
            if (cloud_carpark_sign_key.length() != 32) {
                WebUtil.printFinshJson(2, "\u64cd\u4f5c\u5931\u8d25\uff0c\u4e91API\u79d8\u94a5\u9519\u8bef", response);
                return;
            }
            Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
            String cloud_carpark_sign_key1 = CryptoUtil.encrypt((String)cloud_carpark_sign_key, (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
            if (!cloud_carpark_id.equals(carpark.getCloud_carpark_id()) && carpark.getCloud_carpark_id() != null && carpark.getCloud_carpark_id().length() > 0 && carpark.getBind_cloud() != null && carpark.getBind_cloud() == 1) {
                WebUtil.printFinshJson(2, "\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u7ed1\u5b9a\u4e91\u505c\u8f66\u573aID:" + carpark.getCloud_carpark_id() + ", \u4e0d\u53ef\u518d\u66f4\u6539", response);
                return;
            }
            if (!cloud_carpark_id.equals(carpark.getCloud_carpark_id())) {
                carpark0.setCloud_carpark_id(cloud_carpark_id);
                needUpdate = true;
            }
            if (!cloud_carpark_sign_key1.equals(carpark.getCloud_carpark_sign_key())) {
                carpark0.setCloud_carpark_sign_key(cloud_carpark_sign_key1);
                needUpdate = true;
            }
            if (carpark.getBind_cloud() == null || carpark.getBind_cloud() != 1) {
                carpark0.setBind_cloud(1);
                needUpdate = true;
            }
        }
        if (needUpdate) {
            carpark0.setId(carparkId);
            carpark0.setLast_updated_time(WebUtil.getNow());
            commonDaoService.updateByPrimeryKey((Object)carpark0);
            if (carpark0.getCloud_carpark_sign_key() != null && carpark0.getCloud_carpark_sign_key().length() > 0) {
                ServiceUtil.getServiceContext().getCarpark().setCloud_carpark_sign_key(carpark0.getCloud_carpark_sign_key());
            }
            if (carpark0.getCloud_carpark_id() != null && carpark0.getCloud_carpark_id().length() > 0) {
                ServiceUtil.getServiceContext().getCarpark().setCloud_carpark_id(carpark0.getCloud_carpark_id());
            }
            if (carpark0.getBind_cloud() != null) {
                ServiceUtil.getServiceContext().getCarpark().setBind_cloud(carpark0.getBind_cloud());
            }
            if (op_des.length() == 0) {
                op_des.append("\u4fee\u6539\u8f66\u573a\u4fe1\u606f");
            }
            WebUtil.insertCarparkOperationLog(null, request, Constants.LOG_OP_CAT_3, Constants.LOG_OP_TYPE_CAT_3_1, op_des.toString());
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f!", response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u8f66\u573a/\u533a\u57df\u8bbe\u7f6e-\u4fee\u6539\u505c\u8f66\u533a\u57df")
    @Path(value="/updateCarparkArea.action")
    public void updateCarparkArea(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer space_quantities0;
        String area_name = request.getParameter("area_name");
        String space_quantities = request.getParameter("space_quantities");
        String id = request.getParameter("id");
        Long areaId = null;
        try {
            areaId = Long.valueOf(id);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11id!", response);
            return;
        }
        if (area_name == null || (area_name = area_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", response);
            return;
        }
        if (area_name.getBytes("UTF-8").length > 45) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u540d\u79f0\u592a\u957f!", response);
            return;
        }
        if (space_quantities == null || (space_quantities = space_quantities.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u8f66\u4f4d\u6570\u4e0d\u80fd\u4e3a\u7a7a!", response);
            return;
        }
        try {
            space_quantities0 = Integer.valueOf(space_quantities);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u8f66\u4f4d\u6570\u5fc5\u987b\u662f\u6b63\u6574\u6570!", response);
            return;
        }
        if (space_quantities0 < 0) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u8f66\u4f4d\u6570\u5fc5\u987b\u662f\u6b63\u6574\u6570!", response);
            return;
        }
        if (space_quantities0 > 1000000) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u8f66\u4f4d\u6570\u592a\u5927!", response);
            return;
        }
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkArea carparkArea = (CarparkArea)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)areaId).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkArea.class);
        if (carparkArea == null) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u4e0d\u5b58\u5728!", response);
            return;
        }
        long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkArea.class)).addEQ("area_name", (Object)area_name).addNotEQ("id", (Object)areaId).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id));
        if (count > 0L) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u540d\u79f0[" + area_name + "]\uff0c\u5df2\u7ecf\u5b58\u5728!", response);
            return;
        }
        StringBuilder op_des = new StringBuilder(128);
        op_des.append("\u4fee\u6539").append(carparkArea.getArea_level() > 1 ? "\u5d4c\u5957\u5185\u573a:" : "\u5916\u573a:").append(carparkArea.getArea_name()).append(";");
        CarparkArea carparkArea0 = new CarparkArea();
        boolean needUpdate = false;
        if (!area_name.equals(carparkArea.getArea_name())) {
            carparkArea0.setArea_name(area_name);
            needUpdate = true;
            op_des.append("\u5c06\u573a\u533a\u540d:").append(carparkArea.getArea_name()).append("\u53d8\u66f4\u4e3a:").append(area_name);
        }
        if (carparkArea.getSpace_quantities() == null || carparkArea.getSpace_quantities().intValue() != space_quantities0.intValue()) {
            carparkArea0.setSpace_quantities(space_quantities0);
            needUpdate = true;
            op_des.append(",\u5c06\u8f66\u4f4d\u6570\u91cf").append(carparkArea.getSpace_quantities()).append("\u53d8\u66f4\u4e3a:").append(space_quantities0);
        }
        if (needUpdate) {
            carparkArea0.setId(areaId);
            carparkArea0.setLast_updated_time(WebUtil.getNow());
            commonDaoService.updateByPrimeryKey((Object)carparkArea0);
            WebUtil.insertCarparkOperationLog(null, request, Constants.LOG_OP_CAT_3, Constants.LOG_OP_TYPE_CAT_3_3, op_des.toString());
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f!", response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u8f66\u573a/\u533a\u57df\u8bbe\u7f6e-\u5220\u9664\u505c\u8f66\u533a\u57df")
    @Path(value="/delCarparkArea.action")
    public void delCarparkArea(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id = request.getParameter("id");
        Long areaId = null;
        try {
            areaId = Long.valueOf(id);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u573a\u533aid!", response);
            return;
        }
        String areaNo = request.getParameter("areaNo");
        if (areaNo == null || (areaNo = areaNo.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u573a\u533a\u7f16\u53f7!", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkArea.class)).addEQ("parent_area_no", (Object)areaNo).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id));
        if (count > 0L) {
            WebUtil.printFinshJson(1, "\u65e0\u6cd5\u5220\u9664\u8be5\u573a\u533a! \u8bf7\u5148\u5220\u9664\u5b50\u573a\u533a", response);
            return;
        }
        count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkChannelArea.class)).addEQ("area_no", (Object)areaNo).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id));
        if (count > 0L) {
            WebUtil.printFinshJson(1, "\u65e0\u6cd5\u5220\u9664\u8be5\u573a\u533a! \u8bf7\u5148\u5220\u9664\u5176\u4e0b\u7684\u51fa\u5165\u901a\u9053", response);
            return;
        }
        CarparkArea delArea = (CarparkArea)commonDaoService.selectOne(new SearchParam(commonDaoService.getTableName(CarparkArea.class)).addEQ("area_no", (Object)areaNo).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkArea.class);
        if (delArea == null) {
            WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f!", response);
        }
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkArea.class)).addEQ("id", (Object)areaId));
                SearchParam p = new SearchParam(commonDaoService.getTableName(CarparkSpaceTypeQuantity.class)).addEQ("area_no", (Object)areaNo).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                long c = commonDaoService.selectCount(session, p);
                if (c > 0L) {
                    commonDaoService.delete(session, p);
                }
                commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkStrategy.class)).addEQ("area_no", (Object)areaNo).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id));
                BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
                basicSettingService.deleteChargeRule(areaNo, null, null, carpark_id, project_id, commonDaoService, session);
                StringBuilder op_des = new StringBuilder(128);
                op_des.append("\u5220\u9664").append(delArea.getArea_level() > 1 ? "\u5d4c\u5957\u5185\u573a:" : "\u5916\u573a:").append(delArea.getArea_name());
                WebUtil.insertCarparkOperationLog(session, request, Constants.LOG_OP_CAT_3, Constants.LOG_OP_TYPE_CAT_3_4, op_des.toString());
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f!", response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u8f66\u573a/\u533a\u57df\u8bbe\u7f6e-\u65b0\u589e\u505c\u8f66\u533a\u57df")
    @Path(value="/addCarparkArea.action")
    public void addCarparkArea(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int insertcount;
        int areaLevel;
        Integer space_quantities0;
        String area_name = request.getParameter("area_name");
        String space_quantities = request.getParameter("space_quantities");
        String carparkId = request.getParameter("carparkId");
        Integer carpark_id = null;
        try {
            carpark_id = Integer.valueOf(carparkId);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u505c\u8f66\u573aid!", response);
            return;
        }
        if (area_name == null || (area_name = area_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", response);
            return;
        }
        if (area_name.getBytes("UTF-8").length > 45) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u540d\u79f0\u592a\u957f!", response);
            return;
        }
        if (space_quantities == null || (space_quantities = space_quantities.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u8f66\u4f4d\u6570\u4e0d\u80fd\u4e3a\u7a7a!", response);
            return;
        }
        try {
            space_quantities0 = Integer.valueOf(space_quantities);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u8f66\u4f4d\u6570\u5fc5\u987b\u662f\u6b63\u6574\u6570!", response);
            return;
        }
        if (space_quantities0 < 0) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u8f66\u4f4d\u6570\u5fc5\u987b\u662f\u6b63\u6574\u6570!", response);
            return;
        }
        if (space_quantities0 > 1000000) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u8f66\u4f4d\u6570\u592a\u5927!", response);
            return;
        }
        String areaType = request.getParameter("areaType");
        if (areaType == null || areaType.length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u9009\u62e9\u573a\u533a\u7c7b\u578b!", response);
            return;
        }
        if (!areaType.equals("1") && !areaType.equals("2")) {
            WebUtil.printFinshJson(1, "\u65e0\u6548\u573a\u533a\u7c7b\u578b!", response);
            return;
        }
        String parent_area_no = request.getParameter("parent_area_no");
        if (areaType.equals("2")) {
            int plevel;
            if (parent_area_no == null || (parent_area_no = parent_area_no.trim()).length() == 0) {
                WebUtil.printFinshJson(1, "\u8bf7\u9009\u5219\u7236\u573a\u533a!", response);
                return;
            }
            int x = parent_area_no.lastIndexOf(44);
            if (x == -1) {
                WebUtil.printFinshJson(1, "\u65e0\u6548\u7236\u573a\u533a\u7f16\u53f7!", response);
                return;
            }
            try {
                plevel = Integer.parseInt(parent_area_no.substring(x + 1));
            }
            catch (Exception ex) {
                WebUtil.printFinshJson(1, "\u65e0\u6548\u7236\u573a\u533a\u7f16\u53f7!", response);
                return;
            }
            if (plevel <= 0) {
                WebUtil.printFinshJson(1, "\u65e0\u6548\u7236\u573a\u533a\u7f16\u53f7!", response);
                return;
            }
            areaLevel = plevel + 1;
            parent_area_no = parent_area_no.substring(0, x);
        } else {
            parent_area_no = "";
            areaLevel = 1;
        }
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkArea.class)).addEQ("area_name", (Object)area_name).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id));
        if (count > 0L) {
            WebUtil.printFinshJson(1, "\u573a\u533a\u540d\u79f0[" + area_name + "]\uff0c\u5df2\u7ecf\u5b58\u5728!", response);
            return;
        }
        Date now = WebUtil.getNow();
        CarparkArea newArea = new CarparkArea();
        newArea.setId(commonDaoService.getSequece("ck_common_seq"));
        newArea.setArea_level(areaLevel);
        newArea.setArea_name(area_name);
        newArea.setArea_no("C" + newArea.getId());
        BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
        newArea.setArea_number(basicSettingService.getAreaNumber(carpark_id, project_id, commonDaoService));
        newArea.setCarpark_id(carpark_id);
        newArea.setCreated_time(now);
        newArea.setLast_updated_time(now);
        newArea.setParent_area_no(parent_area_no);
        newArea.setProject_id(project_id);
        newArea.setSpace_quantities(space_quantities0);
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                insertcount = commonDaoService.insert(session, (Object)newArea);
                List spaceTypelist = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"space_type_no"}).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkSpaceType.class, null);
                if (spaceTypelist != null && !spaceTypelist.isEmpty()) {
                    for (CarparkSpaceType t : spaceTypelist) {
                        CarparkSpaceTypeQuantity q = new CarparkSpaceTypeQuantity();
                        q.setArea_no(newArea.getArea_no());
                        q.setCarpark_id(carpark_id);
                        q.setId(commonDaoService.getSequece("ck_common_seq"));
                        q.setLast_updated_time(now);
                        q.setProject_id(project_id);
                        q.setQuantity(0);
                        q.setSpace_type_no(t.getSpace_type_no());
                        commonDaoService.insert(session, (Object)q);
                    }
                }
                StringBuilder op_des = new StringBuilder(128);
                op_des.append("\u65b0\u589e").append(newArea.getArea_level() > 1 ? "\u5d4c\u5957\u5185\u573a:" : "\u5916\u573a:").append(newArea.getArea_name());
                WebUtil.insertCarparkOperationLog(session, request, Constants.LOG_OP_CAT_3, Constants.LOG_OP_TYPE_CAT_3_2, op_des.toString());
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        if (insertcount > 0) {
            WebUtil.printFinshJson(0, newArea.getArea_no(), response);
        } else {
            WebUtil.printFinshJson(2, "\u6570\u636e\u4fdd\u5b58\u5931\u8d25!", response);
        }
    }
}

