/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action.manage;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.ValidateUtil;
import com.wovoe.carpark.dto.CarparkAttribute;
import com.wovoe.carpark.dto.CarparkCarOwner;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkOperationLog;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.BasicSettingService;
import com.wovoe.carpark.vo.PaginationDisplay;
import com.wovoe.carpark.web.LeftMenu;
import com.wovoe.carpark.web.Permission;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.carpark.web.WritePermission;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Action(value="/manage")
public class CarparkCarOwnerAction {
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u4e3b\u6ce8\u518c\u4e0e\u7ba1\u7406(\u67e5\u8be2)")
    @LeftMenu(name="\u8f66\u4e3b\u6ce8\u518c\u4e0e\u7ba1\u7406", parent_name="\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406", order=212)
    @Path(value="/showCarOwnerManage.action")
    public void showCarOwnerManage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommonDaoService commonDaoService;
        Long id;
        String op = request.getParameter("op");
        Map<String, CarparkAttribute> carOwnerAttrMap = ServiceUtil.getServiceContext().getDBConfigCache().getAttributeTypeMap().get(8);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        request.setAttribute("today", (Object)df.format(new java.util.Date()));
        String platePrefix = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("DEFAULT_PLATE_PREFIX");
        if (platePrefix == null || platePrefix.length() == 0) {
            platePrefix = "\u7ca4B";
        }
        request.setAttribute("platePrefix", (Object)platePrefix);
        if (carOwnerAttrMap != null && !carOwnerAttrMap.isEmpty()) {
            ArrayList<CarparkAttribute> carOwnerAtrrList = new ArrayList<CarparkAttribute>();
            request.setAttribute("carOwnerAttrMap", carOwnerAttrMap);
            for (CarparkAttribute t : carOwnerAttrMap.values()) {
                carOwnerAtrrList.add(t);
            }
            request.setAttribute("carOwnerAtrrList", carOwnerAtrrList);
            request.setAttribute("carOwnerAtrrListSize", (Object)carOwnerAtrrList.size());
        }
        if (op == null) {
            WebUtil.showMainContentWithHead("\u8f66\u4e3b\u6ce8\u518c\u4e0e\u7ba1\u7406", "carparkCarOwnerManage", request, response);
            return;
        }
        if ("showCarOwnerTable".equals(op)) {
            SearchParam sp;
            boolean bl;
            Pagination p = WebUtil.getPagination(request);
            String attr_value = request.getParameter("attr_value");
            String attr = request.getParameter("attr");
            CommonDaoService commonDaoService2 = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
            Integer project_id = ServiceUtil.getServiceContext().getProjectId();
            boolean bl2 = false;
            if (attr != null && attr.length() > 0 && (attr_value = attr_value.trim()).length() > 0 && attr.startsWith("a,")) {
                bl = true;
            }
            if ("1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CAR_OWNER_ACCOUNT_BALANCE"))) {
                request.setAttribute("carownerAccountSupport", (Object)"true");
            }
            List carOwnerList = null;
            HashMap<String, ArrayList<String>> plateListMap = null;
            HashMap carOwnerSpaceMap = new HashMap();
            HashMap<String, Integer> passSpaceTypeNumMap = new HashMap<String, Integer>();
            HashMap<String, CarparkPassportType> passSpaceTypeMap = new HashMap<String, CarparkPassportType>();
            List pateList = null;
            if (bl) {
                int xa;
                if (p.isNeedQueryCount()) {
                    Object c;
                    sp = new SearchParam(commonDaoService2.getTableName(CarparkPassport.class));
                    xa = attr.indexOf(44);
                    sp.addLike(attr.substring(xa + 1), attr_value);
                    sp.setQueryFields(new String[]{"COUNT(DISTINCT car_owner_no) AS c"});
                    sp.addEQ("carpark_id", (Object)carpark_id);
                    sp.addEQ("project_id", (Object)project_id);
                    Map map = commonDaoService2.selectOne(sp);
                    long count = 0L;
                    if (map != null && !map.isEmpty() && (c = map.get("c")) != null) {
                        count = c instanceof Long ? (Long)c : (c instanceof Integer ? ((Integer)c).longValue() : Long.valueOf(c.toString()).longValue());
                    }
                    p.setNeedQueryCount(false);
                    p.setRecordsCount(count);
                }
                if (p.getRecordsCount() > 0L) {
                    sp = new SearchParam(commonDaoService2.getTableName(CarparkPassport.class));
                    xa = attr.indexOf(44);
                    sp.addLike(attr.substring(xa + 1), attr_value);
                    sp.addEQ("carpark_id", (Object)carpark_id);
                    sp.addEQ("project_id", (Object)project_id);
                    sp.setQueryFields(new String[]{"DISTINCT car_owner_no"});
                    sp.setOrder_by("car_owner_no");
                    List list = commonDaoService2.selectList(sp, p);
                    if (list != null && !list.isEmpty()) {
                        sp = new SearchParam();
                        if (list.size() == 1) {
                            sp.addEQ("car_owner_no", ((Map)list.get(0)).get("car_owner_no"));
                        } else {
                            for (Map ob : list) {
                                sp.addIN("car_owner_no", ob.get("car_owner_no"));
                            }
                        }
                        sp.addEQ("carpark_id", (Object)carpark_id);
                        sp.addEQ("project_id", (Object)project_id);
                        sp.setOrder_by("car_owner_no");
                        sp.setTableName(commonDaoService2.getTableName(CarparkCarOwner.class));
                        carOwnerList = commonDaoService2.selectList(sp, null);
                        sp.setTableName(commonDaoService2.getTableName(CarparkPassport.class));
                        sp.setOrder_by(null);
                        sp.setQueryFields(new String[]{"car_owner_no", "register_plate", "passport_type_no", "passport_number", "medium_type"});
                        pateList = commonDaoService2.selectList(sp, null);
                    }
                }
            } else {
                int xa;
                sp = new SearchParam();
                if (attr != null && attr.length() > 0 && attr_value != null && attr_value.length() > 0 && (xa = attr.indexOf(44)) > 0) {
                    sp.addLike(attr.substring(xa + 1), attr_value);
                }
                sp.addEQ("carpark_id", (Object)carpark_id);
                sp.addEQ("project_id", (Object)project_id);
                sp.setOrder_by("id DESC");
                sp.setTableName(commonDaoService2.getTableName(CarparkCarOwner.class));
                carOwnerList = commonDaoService2.selectList(sp, p);
                if (carOwnerList != null && !carOwnerList.isEmpty()) {
                    sp = new SearchParam(commonDaoService2.getTableName(CarparkPassport.class));
                    sp.setQueryFields(new String[]{"car_owner_no", "register_plate", "passport_type_no", "passport_number", "medium_type"});
                    sp.addEQ("carpark_id", (Object)carpark_id);
                    sp.addEQ("project_id", (Object)project_id);
                    if (carOwnerList.size() == 1) {
                        sp.addEQ("car_owner_no", ((Map)carOwnerList.get(0)).get("car_owner_no"));
                    } else {
                        for (Map o : carOwnerList) {
                            sp.addIN("car_owner_no", o.get("car_owner_no"));
                        }
                    }
                    pateList = commonDaoService2.selectList(sp, null);
                }
            }
            if (carOwnerList != null && !carOwnerList.isEmpty()) {
                if (pateList != null && !pateList.isEmpty()) {
                    plateListMap = new HashMap<String, ArrayList<String>>();
                    for (Map map : pateList) {
                        String string = (String)map.get("car_owner_no");
                        String register_plate = (String)map.get("register_plate");
                        String passport_number = (String)map.get("passport_number");
                        if (string != null && string.length() > 0 && passport_number != null && passport_number.length() > 0) {
                            ArrayList<String> list = (ArrayList<String>)plateListMap.get(string);
                            if (list == null) {
                                list = new ArrayList<String>();
                                plateListMap.put(string, list);
                            }
                            if (register_plate != null && register_plate.length() > 0 && !register_plate.equals(passport_number)) {
                                list.add(String.valueOf(passport_number) + "(" + register_plate + ")");
                            } else {
                                list.add(passport_number);
                            }
                        }
                        String passport_type_no = (String)map.get("passport_type_no");
                        CarparkPassportType t = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(passport_type_no);
                        if (t == null || t.getUse_muti_car() != 1 || t.getPass_type() != 2 && t.getPass_type() != 4) continue;
                        passSpaceTypeMap.put(t.getPassport_type_no(), t);
                        passSpaceTypeNumMap.put(t.getPassport_type_no(), 1);
                    }
                    if (!passSpaceTypeMap.isEmpty()) {
                        for (String no : passSpaceTypeMap.keySet()) {
                            String string = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(no, "PASSPORTTYPE_SPACE_NUM");
                            int num = 1;
                            try {
                                if (string != null && string.length() > 0) {
                                    num = Integer.parseInt(string);
                                }
                            }
                            catch (Exception passport_number) {
                                // empty catch block
                            }
                            if (num < 1) {
                                num = 1;
                            } else if (num > 1000) {
                                num = 1000;
                            }
                            if (num <= 1) continue;
                            passSpaceTypeNumMap.put(no, num);
                        }
                    }
                    for (Map map : pateList) {
                        Object x;
                        String string = (String)map.get("car_owner_no");
                        String passport_type_no = (String)map.get("passport_type_no");
                        if (string == null || string.length() <= 0 || passport_type_no == null || passport_type_no.length() <= 0 || !passSpaceTypeNumMap.containsKey(passport_type_no)) continue;
                        Integer nun = (Integer)passSpaceTypeNumMap.get(passport_type_no);
                        HashMap<String, Integer> zmap = (HashMap<String, Integer>)carOwnerSpaceMap.get(string);
                        if (zmap == null) {
                            zmap = new HashMap<String, Integer>();
                            carOwnerSpaceMap.put(string, zmap);
                        }
                        if ((x = (Integer)zmap.get(passport_type_no)) == null) {
                            zmap.put(passport_type_no, nun);
                            continue;
                        }
                        zmap.put(passport_type_no, nun + (Integer)x);
                    }
                    if (carOwnerSpaceMap != null && !carOwnerSpaceMap.isEmpty()) {
                        for (Map ob : carOwnerList) {
                            String string = (String)ob.get("car_owner_no");
                            Map pxMap = (Map)carOwnerSpaceMap.get(string);
                            StringBuilder sbr = new StringBuilder(128);
                            if (pxMap != null && !pxMap.isEmpty()) {
                                for (Map.Entry entry : pxMap.entrySet()) {
                                    CarparkPassportType t = (CarparkPassportType)passSpaceTypeMap.get(entry.getKey());
                                    if (t == null) continue;
                                    String v = String.valueOf(t.getPassport_type_name()) + ", \u8f66\u4f4d\u6570:" + entry.getValue();
                                    if (sbr.length() > 0) {
                                        sbr.append("<br>");
                                    }
                                    sbr.append(v);
                                }
                            }
                            ob.put("car_owner_space_info", sbr.toString());
                        }
                    }
                }
                request.setAttribute("carOwnerList", (Object)carOwnerList);
            }
            if (plateListMap != null && !plateListMap.isEmpty()) {
                request.setAttribute("plateListMap", (Object)plateListMap);
            }
            if (carOwnerList != null && !carOwnerList.isEmpty()) {
                for (Map m : carOwnerList) {
                    for (Map.Entry entry : m.entrySet()) {
                        if (!(entry.getValue() instanceof String)) continue;
                        entry.setValue(ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue((String)entry.getKey(), (String)entry.getValue(), request));
                    }
                }
            }
            request.setAttribute("paginationDisplay", (Object)new PaginationDisplay(p, 5));
            WebUtil.dispathTemplatePage("carparkCarOwnerManage", request, response);
        } else if ("showCarOwnerDetail".equals(op)) {
            id = Long.valueOf(request.getParameter("id"));
            commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            Map carOwner = commonDaoService.selectOne(new SearchParam(commonDaoService.getTableName(CarparkCarOwner.class)).addEQ("id", (Object)id));
            if (carOwner == null) {
                WebUtil.printFinshHtml(response, "404notfound");
                return;
            }
            if ("1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CAR_OWNER_ACCOUNT_BALANCE"))) {
                request.setAttribute("carownerAccountSupport", (Object)"true");
            }
            BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
            List<CarparkPassportType> passportTypeList = this.getPassportTypeList();
            request.setAttribute("passportTypeList", passportTypeList);
            List<CarparkCarType> carTypeList = basicSettingService.getCarTypeListFromCache();
            request.setAttribute("carTypeList", carTypeList);
            if (!WebUtil.hasPermission(request, "/manage/modifyCarOwner.action")) {
                for (Map.Entry entry : carOwner.entrySet()) {
                    if (!(entry.getValue() instanceof String)) continue;
                    entry.setValue(ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue((String)entry.getKey(), (String)entry.getValue(), request));
                }
            }
            request.setAttribute("carOwner", (Object)carOwner);
            WebUtil.dispathTemplatePage("carparkCarOwnerManage", request, response);
        } else if ("loadBindPlates".equals(op)) {
            String car_owner_no = request.getParameter("car_owner_no");
            if (car_owner_no == null || car_owner_no.length() == 0) {
                return;
            }
            boolean carownerAccountSupport = false;
            if ("1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CAR_OWNER_ACCOUNT_BALANCE"))) {
                carownerAccountSupport = true;
            }
            CommonDaoService commonDaoService3 = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
            Integer project_id = ServiceUtil.getServiceContext().getProjectId();
            boolean existDedcutPlate = false;
            List list = commonDaoService3.selectList(new SearchParam(commonDaoService3.getTableName(CarparkPassport.class)).addEQ("car_owner_no", (Object)car_owner_no).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).setOrerbySql("id"), null);
            if (list != null && !list.isEmpty()) {
                Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
                Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                Calendar today1 = Calendar.getInstance();
                today1.set(14, 0);
                today1.set(13, 0);
                today1.set(12, 0);
                today1.set(11, 0);
                java.util.Date today = today1.getTime();
                Set permissions = (Set)request.getSession(false).getAttribute("MANAGE_USER_PERMISSIONS");
                if (permissions == null) {
                    permissions = Collections.EMPTY_SET;
                }
                for (Map map : list) {
                    java.util.Date stop_date;
                    java.util.Date start_date;
                    CarparkPassportType carparkPassportType;
                    CarparkCarType carType = carTypeMap.get(map.get("car_type_no"));
                    if (carType != null) {
                        map.put("carType", carType);
                        map.put("car_type_name", carType.getCar_type_name());
                    }
                    if ((carparkPassportType = passportTypeMap.get(map.get("passport_type_no"))) != null) {
                        map.put("passportType", carparkPassportType);
                        map.put("passport_type_name", carparkPassportType.getPassport_type_name());
                        map.put("pass_type", carparkPassportType.getPass_type());
                        if (carparkPassportType.getPass_type() == 1) {
                            existDedcutPlate = true;
                            if (carownerAccountSupport) {
                                if ("1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(carparkPassportType.getPassport_type_no(), "STOREAGE_DECUNT_AOUHNT"))) {
                                    map.put("deduct_account_name", "\u8f66\u4e3b\u8d26\u6237");
                                } else {
                                    map.put("deduct_account_name", "\u8f66\u8f86\u8d26\u6237");
                                }
                            }
                        }
                        if ((carparkPassportType.getPass_type() == 2 || carparkPassportType.getPass_type() == 4) && carparkPassportType.getUse_muti_car() == 1) {
                            String x = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(carparkPassportType.getPassport_type_no(), "PASSPORTTYPE_SPACE_NUM");
                            int num = 1;
                            try {
                                if (x != null && x.length() > 0) {
                                    num = Integer.parseInt(x);
                                }
                            }
                            catch (Exception entry) {
                                // empty catch block
                            }
                            if (num < 1) {
                                num = 1;
                            } else if (num > 1000) {
                                num = 1000;
                            }
                            map.put("space_type_pnum", String.valueOf(num));
                        }
                    }
                    int passportState = (Integer)map.get("passport_state");
                    java.util.Date xdeadline = (java.util.Date)map.get("deadline");
                    if (xdeadline != null) {
                        today1.setTime(xdeadline);
                        today1.set(14, 0);
                        today1.set(13, 0);
                        today1.set(12, 0);
                        today1.set(11, 0);
                        java.util.Date xdeadline1 = today1.getTime();
                        int days = 0;
                        if (xdeadline.before(today)) {
                            map.put("xepire", Boolean.TRUE);
                        } else {
                            days = (int)TimeUnit.MILLISECONDS.toDays(xdeadline1.getTime() - today.getTime());
                            if (days < 7) {
                                map.put("x7epire", Boolean.TRUE);
                            }
                        }
                        map.put("deadlinestr", new SimpleDateFormat("yyyy-MM-dd").format(xdeadline));
                        if (carparkPassportType.getPass_type() == 2) {
                            java.util.Date _startDate;
                            if (passportState == 2) {
                                java.util.Date _stopDate = (java.util.Date)map.get("stop_date");
                                if (_stopDate != null && !_stopDate.after(today) && !_stopDate.after(xdeadline)) {
                                    days = (int)TimeUnit.MILLISECONDS.toDays(xdeadline1.getTime() - _stopDate.getTime()) + 1;
                                }
                            } else if (passportState == 0 && (_startDate = (java.util.Date)map.get("start_date")) != null && _startDate.after(today) && !_startDate.after(xdeadline)) {
                                days = (int)TimeUnit.MILLISECONDS.toDays(xdeadline1.getTime() - _startDate.getTime());
                            }
                            if (days > 0) {
                                map.put("remainDays", String.valueOf(days));
                            }
                        }
                    }
                    if ((start_date = (java.util.Date)map.get("start_date")) != null && start_date.after(today)) {
                        map.put("notStart", Boolean.TRUE);
                    }
                    if (passportState == 2 && (stop_date = (java.util.Date)map.get("stop_date")) != null && stop_date.after(today)) {
                        map.put("notStopped", Boolean.TRUE);
                    }
                    LinkedHashMap<String, String> operationMap = new LinkedHashMap<String, String>();
                    if (carparkPassportType != null && passportState == 0 && map.get("notStart") == null) {
                        if (carparkPassportType.getPass_type() == 2) {
                            if (permissions.contains("/manage/updatePassportRechageDate.action")) {
                                operationMap.put("/manage/updatePassportRechageDate.action", "\u7eed\u8d39\u5ef6\u671f");
                            }
                        } else if (carparkPassportType.getPass_type() == 1 && permissions.contains("/manage/updatePassportRechageFee.action")) {
                            operationMap.put("/manage/updatePassportRechageFee.action", "\u5145\u503c\u505c\u8f66\u8d39");
                        }
                    }
                    if (permissions.contains("/manage/updateCarparkPassport.action")) {
                        operationMap.put("/manage/showCarOwnerManage.action?op=showPassportDetail", "\u4fee\u6539\u8f66\u8f86\u4fe1\u606f");
                    }
                    if (permissions.contains("/manage/updatePassportPlateBlackList.action") && map.get("notStart") == null) {
                        if (passportState == 0) {
                            operationMap.put("/manage/updatePassportPlateBlackList.action?xp=1", "\u52a0\u5165\u9ed1\u540d\u5355");
                        } else if (passportState == 1) {
                            operationMap.put("/manage/updatePassportPlateBlackList.action?xp=0", "\u89e3\u9664\u9ed1\u540d\u5355");
                        }
                    }
                    if (carparkPassportType != null) {
                        if (carparkPassportType.getPassport_type_number() != 0 && permissions.contains("/manage/updatePassportPlateStop.action")) {
                            if (passportState == 2) {
                                operationMap.put("/manage/updatePassportPlateStop.action?xp=0", "\u542f\u7528\u8f66\u724c/\u5361");
                            } else if (passportState == 0) {
                                if (start_date.after(today)) {
                                    operationMap.put("/manage/updatePassportPlateStop.action?xp=0", "\u542f\u7528\u8f66\u724c/\u5361");
                                } else {
                                    operationMap.put("/manage/updatePassportPlateStop.action?xp=1", "\u505c\u7528\u8f66\u724c/\u5361");
                                }
                            }
                        }
                        if (carparkPassportType.getPass_type() == 2 && passportState == 0 && map.get("notStart") == null && permissions.contains("/manage/updatePassportPlateValidDate.action")) {
                            operationMap.put("/manage/updatePassportPlateValidDate.action", "\u4fee\u6539\u6709\u6548\u671f");
                        }
                        if (passportState == 0 && map.get("notStart") == null && (carparkPassportType.getPass_type() == 2 || carparkPassportType.getPass_type() == 1) && permissions.contains("/manage/updatePassportFobitOnlinePay.action")) {
                            Integer forbid_online_pay = (Integer)map.get("forbid_online_pay");
                            if (forbid_online_pay == null) {
                                forbid_online_pay = 0;
                            }
                            if (forbid_online_pay == 1) {
                                operationMap.put("/manage/updatePassportFobitOnlinePay.action?xp=0", "\u5141\u8bb8\u5728\u7ebf\u5145\u503c");
                            } else {
                                operationMap.put("/manage/updatePassportFobitOnlinePay.action?xp=1", "\u7981\u6b62\u5728\u7ebf\u5145\u503c");
                            }
                        }
                    }
                    if (permissions.contains("/manage/delCarparkPassport.action")) {
                        operationMap.put("/manage/delCarparkPassport.action", "\u6ce8\u9500\u8f66\u724c/\u5361");
                    }
                    if (operationMap.isEmpty()) continue;
                    map.put("actionMap", operationMap);
                }
                request.setAttribute("pdataList", (Object)list);
            }
            if (existDedcutPlate) {
                request.setAttribute("showDedcutField", (Object)"1");
            }
            if (existDedcutPlate && carownerAccountSupport) {
                request.setAttribute("showDedcutAccount", (Object)"1");
            }
            WebUtil.dispathTemplatePage("carparkCarOwnerManage", request, response);
        } else if ("showPassportDetail".equals(op)) {
            id = Long.valueOf(request.getParameter("id"));
            commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            Map passportMap = commonDaoService.selectOne(new SearchParam(commonDaoService.getTableName(CarparkPassport.class)).addEQ("id", (Object)id));
            if (passportMap != null) {
                java.util.Date date;
                Map<String, CarparkCarType> carTypeMap;
                CarparkCarType carType;
                request.setAttribute("passportMap", (Object)passportMap);
                BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
                List<CarparkCarType> carTypeList = basicSettingService.getCarTypeListFromCache();
                request.setAttribute("carTypeList", carTypeList);
                List<CarparkPassportType> passportTypeList = this.getPassportTypeList();
                request.setAttribute("passportTypeList", passportTypeList);
                Map<String, CarparkPassportType> map = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                CarparkPassportType passportType = map.get(passportMap.get("passport_type_no"));
                if (passportType != null) {
                    passportMap.put("passportType", passportType);
                    passportMap.put("passport_type_name", passportType.getPassport_type_name());
                }
                if ((carType = (carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap()).get(passportMap.get("car_type_no"))) != null) {
                    passportMap.put("carType", carType);
                    passportMap.put("car_type_name", carType.getCar_type_name());
                }
                Calendar today1 = Calendar.getInstance();
                today1.set(14, 0);
                today1.set(13, 0);
                today1.set(12, 0);
                today1.set(11, 0);
                java.util.Date today = today1.getTime();
                java.util.Date xdeadline = (java.util.Date)passportMap.get("deadline");
                if (xdeadline != null) {
                    if (xdeadline.before(today)) {
                        passportMap.put("xepire", Boolean.TRUE);
                    } else {
                        int days = (int)TimeUnit.MILLISECONDS.toDays(xdeadline.getTime() - today.getTime());
                        if (days <= 7) {
                            passportMap.put("x7epire", Boolean.TRUE);
                        }
                    }
                }
                int passportState = (Integer)passportMap.get("passport_state");
                java.util.Date start_date = (java.util.Date)passportMap.get("start_date");
                if (start_date != null && start_date.after(today)) {
                    passportMap.put("notStart", Boolean.TRUE);
                }
                if (passportState == 2 && (date = (java.util.Date)passportMap.get("stop_date")) != null && date.after(today)) {
                    passportMap.put("notStopped", Boolean.TRUE);
                }
                WebUtil.dispathTemplatePage("carparkCarOwnerManage", request, response);
            } else {
                WebUtil.printFinshHtml(response, "404notfound");
            }
        }
    }

    private List<CarparkPassportType> getPassportTypeList() {
        BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
        List<CarparkPassportType> passportTypeList = basicSettingService.getPassportTypeListFromCache();
        if (passportTypeList == null) {
            passportTypeList = new LinkedList<CarparkPassportType>();
        }
        if (!passportTypeList.isEmpty()) {
            Iterator<CarparkPassportType> its = passportTypeList.iterator();
            while (its.hasNext()) {
                CarparkPassportType t = its.next();
                if (t.getPass_type() == 5) {
                    its.remove();
                    continue;
                }
                if (t.getPass_type() != 0 || t.getUse_muti_car() == 1) continue;
                its.remove();
            }
        }
        return passportTypeList;
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u4e3b\u6ce8\u518c\u4e0e\u7ba1\u7406-\u65b0\u589e\u8f66\u4e3b")
    @Path(value="/addCarOwner.action")
    public void addCarOwner(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long count;
        String car_owner_name = request.getParameter("car_owner_name");
        if (car_owner_name == null || (car_owner_name = car_owner_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u8f66\u4e3b\u540d\u79f0", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        car_owner_name = ServiceUtil.getString(car_owner_name, 45);
        CarparkCarOwner addowner = new CarparkCarOwner();
        addowner.setCar_owner_name(car_owner_name);
        JavaBeanMap beanMap = new JavaBeanMap((Object)addowner);
        Set names = beanMap.keySet();
        Set<String> notSet = ServiceUtil.toSet("id", "car_owner_no", "car_owner_name", "sex", "birthday", "head_photo", "created_time", "last_updated_time", "project_id", "carpark_id");
        for (String name : names) {
            String pv;
            if (notSet.contains(name) || (pv = request.getParameter(name)) == null) continue;
            pv = pv.trim();
            beanMap.put(name, (Object)pv);
        }
        String _sex = request.getParameter("sex");
        int sex = 0;
        if (_sex != null && _sex.length() > 0) {
            try {
                sex = Integer.parseInt(_sex);
                if (sex != 1) {
                    sex = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        addowner.setSex(sex);
        if (addowner.getId_number() != null && addowner.getId_number().length() > 0) {
            addowner.setId_number(addowner.getId_number().toUpperCase());
            if (!ValidateUtil.isIDCard(addowner.getId_number())) {
                WebUtil.printFinshJson(1, "\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef\uff01", response);
                return;
            }
            long count2 = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkCarOwner.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("id_number", (Object)addowner.getId_number()));
            if (count2 > 0L) {
                WebUtil.printFinshJson(1, "\u8eab\u4efd\u8bc1\u53f7\u4e3a\uff1a" + addowner.getId_number() + " \u7684\u8f66\u4e3b\u5df2\u5b58\u5728!", response);
                return;
            }
        }
        if (addowner.getPhone_number() != null && addowner.getPhone_number().length() > 0) {
            if (!ValidateUtil.isCellPhone(addowner.getPhone_number())) {
                WebUtil.printFinshJson(1, "\u624b\u673a\u53f7\u9519\u8bef\uff01", response);
                return;
            }
            long count3 = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkCarOwner.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("phone_number", (Object)addowner.getPhone_number()));
            if (count3 > 0L) {
                WebUtil.printFinshJson(1, "\u624b\u673a\u53f7\u4e3a\uff1a" + addowner.getPhone_number() + " \u7684\u8f66\u4e3b\u5df2\u5b58\u5728!", response);
                return;
            }
        }
        if (addowner.getEmail() != null && addowner.getEmail().length() > 0) {
            if (!ValidateUtil.isEmail(addowner.getEmail())) {
                WebUtil.printFinshJson(1, "\u7535\u5b50\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\uff01", response);
                return;
            }
            long count4 = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkCarOwner.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("email", (Object)addowner.getEmail()));
            if (count4 > 0L) {
                WebUtil.printFinshJson(1, "\u7535\u5b50\u90ae\u7bb1\u4e3a\uff1a" + addowner.getEmail() + " \u7684\u8f66\u4e3b\u5df2\u5b58\u5728!", response);
                return;
            }
        }
        if (addowner.getDriver_number() != null && addowner.getDriver_number().length() > 0 && (count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkCarOwner.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("driver_number", (Object)addowner.getDriver_number()))) > 0L) {
            WebUtil.printFinshJson(1, "\u9a7e\u9a76\u8bc1\u53f7\u4e3a\uff1a" + addowner.getDriver_number() + " \u7684\u8f66\u4e3b\u5df2\u5b58\u5728!", response);
            return;
        }
        String birthday = request.getParameter("birthday");
        if (birthday != null && birthday.length() > 0) {
            addowner.setBirthday(new Date(new SimpleDateFormat("yyyy-MM-dd").parse(birthday).getTime()));
        }
        java.util.Date now = WebUtil.getNow();
        addowner.setCreated_time(now);
        addowner.setLast_updated_time(now);
        addowner.setProject_id(project_id);
        addowner.setCarpark_id(carpark_id);
        addowner.setId(commonDaoService.getSequece("ck_common_seq"));
        addowner.setCar_owner_no("C" + addowner.getId());
        commonDaoService.insert((Object)addowner);
        WebUtil.printFinshJson(0, addowner.getId() + "," + addowner.getCar_owner_no(), response);
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u4e3b\u6ce8\u518c\u4e0e\u7ba1\u7406-\u5220\u9664\u8f66\u4e3b")
    @Path(value="/delCarOwner.action")
    public void delCarOwner(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long id = Long.valueOf(request.getParameter("id"));
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CarparkCarOwner addowner = (CarparkCarOwner)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkCarOwner.class);
        if (addowner == null) {
            WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
            return;
        }
        long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPassport.class)).addEQ("car_owner_no", (Object)addowner.getCar_owner_no()).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id));
        if (count > 0L) {
            WebUtil.printFinshJson(1, "\u8be5\u8f66\u4e3b\u4e0b\u8fd8\u7ed1\u5b9a\u6709\u8f66\u724c\uff0c\u8bf7\u5148\u6ce8\u9500\u8f66\u724c/\u5361", response);
            return;
        }
        String op = request.getParameter("op");
        if ("checkDel".equals(op)) {
            if (addowner.getAccount_balance() != null && addowner.getAccount_balance().doubleValue() > 0.0) {
                WebUtil.printFinshJson(2, addowner.getAccount_balance().toString(), response);
                return;
            }
            WebUtil.printFinshJson(0, "confirmDel", response);
            return;
        }
        int v = commonDaoService.delete(new SearchParam(commonDaoService.getTableName(CarparkCarOwner.class)).addEQ("id", (Object)id));
        if (v > 0 && addowner.getAccount_balance() != null && addowner.getAccount_balance().doubleValue() != 0.0) {
            java.util.Date now = ServiceUtil.getNow();
            StringBuilder op_des = new StringBuilder(128);
            op_des.append("\u8f66\u4e3b:").append(addowner.getCar_owner_name());
            op_des.append(",\u8d26\u6237:").append(addowner.getCar_owner_no());
            op_des.append(",\u5df2\u88ab\u6210\u529f\u6ce8\u9500\uff01");
            op_des.append("\u6ce8\u9500\u65f6\u8f66\u4e3b\u8d26\u6237\u4f59\u989d:").append(addowner.getAccount_balance());
            CarparkUser opuser = WebUtil.getLoginManageUser(request);
            CarparkOperationLog opLog = new CarparkOperationLog();
            opLog.setOp_cat(Constants.LOG_OP_CAT_1);
            opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_1_7);
            opLog.setOp_time(now);
            opLog.setOp_des(ServiceUtil.getString(op_des.toString(), 500));
            opLog.setOp_user_code(opuser.getUser_code());
            opLog.setOp_user_name(opuser.getUser_name());
            opLog.setCarpark_id(carpark_id);
            opLog.setProject_id(project_id);
            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
            commonDaoService.insert((Object)opLog);
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u4e3b\u6ce8\u518c\u4e0e\u7ba1\u7406-\u4fee\u6539\u8f66\u4e3b\u4fe1\u606f")
    @Path(value="/modifyCarOwner.action")
    public void modifyCarOwner(HttpServletRequest request, HttpServletResponse response) throws Exception {
        CarparkCarOwnerAction.modifyCarOwner0(request, response, false);
    }

    public static void modifyCarOwner0(HttpServletRequest request, HttpServletResponse response, boolean updateByPassportInvoke) throws Exception {
        String birthday;
        String old_phone_number;
        String old_email;
        String old_driver_number;
        String car_owner_name = request.getParameter("car_owner_name");
        if (car_owner_name == null || (car_owner_name = car_owner_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u8f66\u4e3b\u540d\u79f0", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkCarOwner addowner = null;
        if (updateByPassportInvoke) {
            String car_owner_no = request.getParameter("car_owner_no");
            if (car_owner_no == null || car_owner_no.length() == 0) {
                WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
                return;
            }
            Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
            Integer project_id = ServiceUtil.getServiceContext().getProjectId();
            addowner = (CarparkCarOwner)commonDaoService.selectOne(new SearchParam().addEQ("car_owner_no", (Object)car_owner_no).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id), CarparkCarOwner.class);
            if (addowner == null) {
                WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
                return;
            }
        } else {
            Long id = Long.valueOf(request.getParameter("id"));
            addowner = (CarparkCarOwner)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkCarOwner.class);
            if (addowner == null) {
                WebUtil.printFinshJson(1, "\u8f66\u4e3b\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", response);
                return;
            }
        }
        car_owner_name = ServiceUtil.getString(car_owner_name, 45);
        String old_id_number = addowner.getId_number();
        if (old_id_number == null) {
            old_id_number = "";
        }
        if ((old_driver_number = addowner.getDriver_number()) == null) {
            old_driver_number = "";
        }
        if ((old_email = addowner.getEmail()) == null) {
            old_email = "";
        }
        if ((old_phone_number = addowner.getPhone_number()) == null) {
            old_phone_number = "";
        }
        addowner.setCar_owner_name(car_owner_name);
        JavaBeanMap beanMap = new JavaBeanMap((Object)addowner);
        Set names = beanMap.keySet();
        Set<String> notSet = ServiceUtil.toSet("id", "car_owner_no", "car_owner_name", "sex", "birthday", "head_photo", "created_time", "last_updated_time", "project_id", "carpark_id");
        for (String name : names) {
            String pv;
            if (notSet.contains(name) || (pv = request.getParameter(name)) == null) continue;
            pv = pv.trim();
            beanMap.put(name, (Object)pv);
        }
        String _sex = request.getParameter("sex");
        int sex = 0;
        if (_sex != null && _sex.length() > 0) {
            try {
                sex = Integer.parseInt(_sex);
                if (sex != 1) {
                    sex = 0;
                }
            }
            catch (Exception exception) {}
        } else if (addowner.getSex() != null) {
            sex = addowner.getSex();
        }
        addowner.setSex(sex);
        if (addowner.getId_number() != null && addowner.getId_number().length() > 0) {
            addowner.setId_number(addowner.getId_number().toUpperCase());
            if (!ValidateUtil.isIDCard(addowner.getId_number())) {
                WebUtil.printFinshJson(1, "\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef\uff01", response);
                return;
            }
        }
        if (addowner.getPhone_number() != null && addowner.getPhone_number().length() > 0 && !ValidateUtil.isCellPhone(addowner.getPhone_number())) {
            WebUtil.printFinshJson(1, "\u624b\u673a\u53f7\u9519\u8bef\uff01", response);
            return;
        }
        if (addowner.getEmail() != null && addowner.getEmail().length() > 0 && !ValidateUtil.isEmail(addowner.getEmail())) {
            WebUtil.printFinshJson(1, "\u7535\u5b50\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\uff01", response);
            return;
        }
        if (addowner.getDriver_number() != null) {
            addowner.getDriver_number().length();
        }
        if ((birthday = request.getParameter("birthday")) != null && birthday.length() > 0) {
            addowner.setBirthday(new Date(new SimpleDateFormat("yyyy-MM-dd").parse(birthday).getTime()));
        }
        java.util.Date now = WebUtil.getNow();
        addowner.setLast_updated_time(now);
        commonDaoService.updateIfChangedByPrimeryKey((Object)addowner, new String[]{"last_updated_time"});
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }
}

