/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action.manage;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.charge.CarparkChargeFactory;
import com.wovoe.carpark.charge.ChargeAlgorithm;
import com.wovoe.carpark.charge.ChargePassRecord;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.charge.DefaultChargeContext;
import com.wovoe.carpark.charge.Discount;
import com.wovoe.carpark.charge.PeriodMultiPassCost;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkChargeRule;
import com.wovoe.carpark.dto.CarparkChargeSegmentRule;
import com.wovoe.carpark.dto.CarparkChargeTimeLenRange;
import com.wovoe.carpark.dto.CarparkDiscountProject;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkRechargeRule;
import com.wovoe.carpark.dto.CarparkSpecialDate;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.BasicSettingService;
import com.wovoe.carpark.web.LeftMenu;
import com.wovoe.carpark.web.Permission;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.carpark.web.WritePermission;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;

@Action(value="/manage")
public class CarparkChargeRuleSetingAction {
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8ba1\u8d39\u89c4\u5219(\u67e5\u8be2)")
    @LeftMenu(name="\u8ba1\u8d39\u89c4\u5219\u8bbe\u7f6e", parent_name="\u4e1a\u52a1\u8bbe\u7f6e", order=126)
    @Path(value="/showCarparkChargeRule.action")
    public void showCarparkChargeRule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            WebUtil.showMainContentWithHead("\u8ba1\u8d39\u89c4\u5219\u8bbe\u7f6e", "carparkChargeRule", request, response);
            return;
        }
        if ("rechargeRule".equals(op)) {
            this.showRechargeRule(request, response);
            return;
        }
        if ("tempChargeRule".equals(op)) {
            this.showTempChargeRule(request, response);
        } else if ("holidayWorkday".equals(op)) {
            this.showHolidayWorkday(request, response);
        } else if ("tempChargeTest".equals(op)) {
            this.showTempleChargeTest(request, response);
        } else if ("submitChargeTest".equals(op)) {
            this.submitChargeTest(request, response);
        }
    }

    public static String submitChargeTestV(Map<?, ?> requestMap) throws ParseException {
        Cost cost;
        PeriodMultiPassCost periodMultiPassCost;
        CarparkDiscountProject selectDiscount;
        String test_passporttypeno = (String)requestMap.get("test_passporttypeno");
        String test_cartypeno = (String)requestMap.get("test_cartypeno");
        String test_outenter_channelno = (String)requestMap.get("test_outenter_channelno");
        String test_outenter_time = (String)requestMap.get("test_outenter_time");
        String test_outexit_channelno = (String)requestMap.get("test_outexit_channelno");
        String test_outexit_time = (String)requestMap.get("test_outexit_time");
        String test_dispro = (String)requestMap.get("test_dispro");
        String test_deadline = (String)requestMap.get("test_deadline");
        String test_period_starttime = (String)requestMap.get("test_period_starttime");
        String test_period_already_cost = (String)requestMap.get("test_period_already_cost");
        String inerRowcount = (String)requestMap.get("inerRowcount");
        final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CarparkPassportType passPortType = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(test_passporttypeno);
        CarparkCarType carType = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap().get(test_cartypeno);
        CarparkChannel outEnterChannel = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap().get(test_outenter_channelno);
        java.util.Date outEnterTime = df.parse(test_outenter_time);
        CarparkChannel outExitChannel = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap().get(test_outexit_channelno);
        java.util.Date outExitTime = df.parse(test_outexit_time);
        if (!outExitTime.after(outEnterTime)) {
            return WebUtil.getPrintFinshJsonString(1, "\u5916\u573a\u79bb\u573a\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5916\u573a\u5165\u573a\u65f6\u95f4");
        }
        java.util.Date deadLine = null;
        if (passPortType.getPass_type() == 2) {
            if (test_deadline == null || test_deadline.length() == 0) {
                return WebUtil.getPrintFinshJsonString(1, "\u8bf7\u8f93\u5165\u8f66\u724c\u6709\u6548\u671f");
            }
            deadLine = new SimpleDateFormat("yyyy-MM-dd").parse(test_deadline);
        }
        ChannelArea outEnterPassChannelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(outEnterChannel.getChannel_no());
        ChannelArea outExitPassChannelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(outExitChannel.getChannel_no());
        CarparkArea outArea = null;
        for (CarparkArea area : outEnterPassChannelArea.getEnterAreas()) {
            if (area.getArea_level() != 1) continue;
            for (CarparkArea exitArea : outExitPassChannelArea.getExitAreas()) {
                if (!area.getArea_no().equals(exitArea.getArea_no())) continue;
                outArea = exitArea;
                break;
            }
            if (outArea != null) break;
        }
        if (outArea == null) {
            return WebUtil.getPrintFinshJsonString(1, "\u5916\u573a\u5165\u573a\u901a\u9053: " + outEnterChannel.getChannel_name() + "\uff0c \u4e0e\u51fa\u573a\u901a\u9053\uff1a" + outExitChannel.getChannel_name() + " \u4e0d\u5728\u540c\u4e00\u4e2a\u573a\u533a");
        }
        String plateNo = "\u7ca4B12345";
        Discount discount = null;
        if (test_dispro != null && test_dispro.length() > 0 && (selectDiscount = ServiceUtil.getServiceContext().getDBConfigCache().getDiscountProjectMap().get(test_dispro)) != null) {
            discount = new Discount();
            discount.setDiscount_method(selectDiscount.getDiscount_method());
            discount.setDiscount_no(selectDiscount.getDiscount_project_no());
            discount.setDiscount_value(selectDiscount.getDiscount_value());
        }
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        Integer carparkId = ServiceUtil.getServiceContext().getCarparkId();
        ChargeAlgorithm chargeAlgorithm = CarparkChargeFactory.getChargeAlgorithm();
        if (test_period_already_cost != null && test_period_already_cost.length() > 0 && test_period_starttime != null && test_period_starttime.length() > 0) {
            periodMultiPassCost = new PeriodMultiPassCost();
            periodMultiPassCost.setAlreadyCost(new BigDecimal(test_period_already_cost));
            if (periodMultiPassCost.getAlreadyCost().doubleValue() < 0.0) {
                periodMultiPassCost.setAlreadyCost(new BigDecimal("0.00"));
            }
            periodMultiPassCost.setPeriodStartDate(df.parse(test_period_starttime));
        } else {
            periodMultiPassCost = null;
        }
        LinkedList<Discount> discounts = new LinkedList<Discount>();
        if (discount != null) {
            discounts.add(discount);
        }
        DefaultChargeContext context = new DefaultChargeContext(){

            @Override
            public PeriodMultiPassCost getPeriodMultiPassCost(int projectId, int carparkId, String plateNo, java.util.Date passBeginDate, java.util.Date passEndDate) {
                return periodMultiPassCost;
            }

            @Override
            public List<PeriodMultiPassCost> getPeriodMultiPassCostList(int projectId, int carparkId, String plateNo, java.util.Date enterTime, int periodMins, BigDecimal periodMaxMoney, String areaNo) {
                LinkedList<PeriodMultiPassCost> clist = new LinkedList<PeriodMultiPassCost>();
                clist.add(periodMultiPassCost);
                return clist;
            }
        };
        int recordNo = 1;
        ChargePassRecord chargePassRecord = new ChargePassRecord();
        chargePassRecord.setRecordNo(String.valueOf(recordNo++));
        chargePassRecord.setAreaNo(outArea.getArea_no());
        chargePassRecord.setAreaLevel(outArea.getArea_level());
        chargePassRecord.setParentAreaNo(outArea.getParent_area_no());
        chargePassRecord.setEnterTime(outEnterTime);
        chargePassRecord.setExitTime(outExitTime);
        int inerRowcount0 = 0;
        if (inerRowcount != null && inerRowcount.length() > 0 && (inerRowcount0 = Integer.parseInt(inerRowcount)) < 0) {
            inerRowcount0 = 0;
        }
        ArrayList<ChargePassRecord> subrecordsList = new ArrayList<ChargePassRecord>(inerRowcount0);
        if (inerRowcount0 > 0) {
            int i = 0;
            while (i < inerRowcount0) {
                String inrow = (String)requestMap.get("inerRow_" + i);
                if (inrow != null && inrow.length() > 0) {
                    String[] cells = inrow.split(",");
                    String inEnterChannelNo = cells[0];
                    java.util.Date inEnterChannelTime = df.parse(cells[1]);
                    String inExitChannelNo = cells[2];
                    java.util.Date inExitChannelTime = df.parse(cells[3]);
                    if (!inExitChannelTime.after(inEnterChannelTime)) {
                        return WebUtil.getPrintFinshJsonString(1, "\u5185\u573a\u8bb0\u5f55 \u7b2c" + (i + 1) + "\u884c \u51fa\u5165\u65f6\u95f4\u9519\u8bef,\u79bb\u573a\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5165\u573a\u65f6\u95f4");
                    }
                    if (inEnterChannelTime.before(outEnterTime)) {
                        return WebUtil.getPrintFinshJsonString(1, "\u5185\u573a\u8bb0\u5f55 \u7b2c" + (i + 1) + "\u884c \u5165\u573a\u65f6\u95f4\u9519\u8bef, \u5185\u573a\u5165\u573a\u65f6\u95f4 \u4e0d\u80fd\u5c0f\u4e8e\u5916\u573a\u7684\u5165\u573a\u65f6\u95f4 " + test_outenter_time);
                    }
                    if (!inEnterChannelTime.before(outExitTime)) {
                        return WebUtil.getPrintFinshJsonString(1, "\u5185\u573a\u8bb0\u5f55 \u7b2c" + (i + 1) + "\u884c \u5165\u573a\u65f6\u95f4\u9519\u8bef, \u5185\u573a\u5165\u573a\u65f6\u95f4 \u5fc5\u987b\u5c0f\u4e8e\u5916\u573a\u7684\u79bb\u573a\u65f6\u95f4 " + test_outexit_time);
                    }
                    if (inExitChannelTime.after(outExitTime)) {
                        return WebUtil.getPrintFinshJsonString(1, "\u5185\u573a\u8bb0\u5f55 \u7b2c" + (i + 1) + "\u884c \u79bb\u573a\u65f6\u95f4\u9519\u8bef, \u5185\u573a\u79bb\u573a\u65f6\u95f4 \u4e0d\u80fd\u5927\u4e8e\u5916\u573a\u7684\u79bb\u573a\u65f6\u95f4 " + test_outexit_time);
                    }
                    ChannelArea inEnterPassChannelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(inEnterChannelNo);
                    if (inEnterPassChannelArea == null) {
                        return WebUtil.getPrintFinshJsonString(1, "\u5185\u573a\u8bb0\u5f55 \u7b2c" + (i + 1) + "\u884c \u5185\u573a\u5165\u573a\u901a\u9053\u9009\u62e9\u9519\u8bef");
                    }
                    ChannelArea inExitPassChannelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(inExitChannelNo);
                    if (inExitPassChannelArea == null) {
                        return WebUtil.getPrintFinshJsonString(1, "\u5185\u573a\u8bb0\u5f55 \u7b2c" + (i + 1) + "\u884c \u5185\u573a\u51fa\u573a\u901a\u9053\u9009\u62e9\u9519\u8bef");
                    }
                    CarparkArea inArea = null;
                    for (CarparkArea area : inEnterPassChannelArea.getEnterAreas()) {
                        if (area.getArea_level() <= 1) continue;
                        for (CarparkArea exitArea : inExitPassChannelArea.getExitAreas()) {
                            if (!area.getArea_no().equals(exitArea.getArea_no())) continue;
                            inArea = exitArea;
                            break;
                        }
                        if (inArea != null) break;
                    }
                    if (inArea == null) {
                        return WebUtil.getPrintFinshJsonString(1, "\u5185\u573a\u8bb0\u5f55 \u7b2c" + (i + 1) + "\u884c \u51fa\u5165\u901a\u9053\u4e0d\u5728\u540c\u4e00\u4e2a\u5185\u573a\u533a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                    }
                    ChargePassRecord c = new ChargePassRecord();
                    c.setRecordNo(String.valueOf(recordNo++));
                    c.setAreaNo(inArea.getArea_no());
                    c.setAreaLevel(inArea.getArea_level());
                    c.setParentAreaNo(inArea.getParent_area_no());
                    c.setEnterTime(inEnterChannelTime);
                    c.setExitTime(inExitChannelTime);
                    subrecordsList.add(c);
                }
                ++i;
            }
        }
        AbstractList subChargePassRecordList = null;
        if (subrecordsList != null && !subrecordsList.isEmpty()) {
            if (subrecordsList.size() > 1) {
                ChargePassRecord zmap;
                final StringBuilder errSbr = new StringBuilder();
                PriorityQueue<ChargePassRecord> passRecordsOrder = new PriorityQueue<ChargePassRecord>(subrecordsList.size(), new Comparator<ChargePassRecord>(){

                    @Override
                    public int compare(ChargePassRecord o1, ChargePassRecord o2) {
                        java.util.Date d2;
                        java.util.Date d1 = o1.getEnterTime();
                        int h = d1.compareTo(d2 = o2.getEnterTime());
                        if (h == 0 && (h = Integer.valueOf(o1.getAreaLevel()).compareTo(o2.getAreaLevel())) == 0) {
                            if (errSbr.length() > 0) {
                                errSbr.append("<br>");
                            }
                            errSbr.append("\u5165\u573a\u65f6\u95f4").append(df.format(d1));
                            errSbr.append("\uff0c \u4e0e  ").append(df.format(d2));
                            errSbr.append(" \u51b2\u7a81!");
                        }
                        return h;
                    }
                });
                passRecordsOrder.addAll(subrecordsList);
                if (errSbr.length() > 0) {
                    return WebUtil.getPrintFinshJsonString(1, errSbr.toString());
                }
                LinkedList<ChargePassRecord> passRecords = new LinkedList<ChargePassRecord>();
                passRecords.offer(chargePassRecord);
                while ((zmap = passRecordsOrder.poll()) != null) {
                    passRecords.offer(zmap);
                }
                LinkedList<ChargePassRecord> areaStack = new LinkedList<ChargePassRecord>();
                Iterator it = passRecords.iterator();
                while (it.hasNext()) {
                    ChargePassRecord m1 = (ChargePassRecord)it.next();
                    boolean xnext = false;
                    while (!xnext) {
                        java.util.Date de2;
                        xnext = true;
                        CarparkArea area = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap().get(m1.getAreaNo());
                        if (areaStack.isEmpty()) {
                            if (!m1.getAreaNo().equals(chargePassRecord.getAreaNo())) {
                                if (errSbr.length() > 0) {
                                    errSbr.append("<br>");
                                }
                                errSbr.append("\u9519\u8bef\u7684\u533a\u57df\u4e0e\u5165\u573a\u65f6\u95f4!");
                                errSbr.append("\u533a\u57df:").append(area.getArea_name()).append(" \u7684\u5165\u573a\u65f6\u95f4").append(df.format(m1.getEnterTime()));
                                errSbr.append("\uff0c \u4e0e\u6536\u8d39\u533a\u57df \u7684\u5165\u573a\u65f6\u95f4").append(test_outenter_time).append(" \u51b2\u7a81!");
                                it.remove();
                                continue;
                            }
                            areaStack.addFirst(m1);
                            continue;
                        }
                        ChargePassRecord p = (ChargePassRecord)areaStack.peekFirst();
                        CarparkArea pa = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap().get(p.getAreaNo());
                        if (!area.getParent_area_no().equals(pa.getArea_no())) {
                            if (area.getArea_level() > pa.getArea_level()) {
                                if (errSbr.length() > 0) {
                                    errSbr.append("<br>");
                                }
                                errSbr.append("\u9519\u8bef\u7684\u5d4c\u5957\u533a\u57df\u4e0e\u5165\u573a\u65f6\u95f4!");
                                errSbr.append("\u5d4c\u5957\u533a\u57df: ").append(area.getArea_name()).append(", \u5165\u573a\u65f6\u95f4: ").append(df.format(m1.getEnterTime()));
                                errSbr.append("\u4e0e\u533a\u57df: ").append(pa.getArea_name()).append(", \u5165\u573a\u65f6\u95f4: ").append(df.format(p.getEnterTime()));
                                errSbr.append("\u5165\u573a\u987a\u5e8f\u9519\u8bef\uff01 \u4e0d\u5e94\u8be5\u8de8\u8fc7\u5176\u7236\u533a\u57df\u5148\u5165\u573a!");
                                it.remove();
                                continue;
                            }
                            java.util.Date do1 = p.getExitTime();
                            de2 = m1.getEnterTime();
                            if (de2.before(do1)) {
                                if (errSbr.length() > 0) {
                                    errSbr.append("<br>");
                                }
                                errSbr.append("\u533a\u57df\u7684\u51fa\u5165\u65f6\u95f4\u51b2\u7a81!");
                                errSbr.append("\u533a\u57df\uff1a").append(area.getArea_name()).append(" \u7684\u5165\u573a\u65f6\u95f4: ").append(df.format(de2));
                                errSbr.append(" \u5e94\u8be5\u5927\u4e8e\u6216\u8005\u7b49\u4e8e \u533a\u57df: ").append(pa.getArea_name()).append(" \u7684\u51fa\u573a\u65f6\u95f4: ").append(df.format(do1));
                                it.remove();
                                continue;
                            }
                            areaStack.removeFirst();
                            xnext = false;
                            continue;
                        }
                        java.util.Date de1 = p.getEnterTime();
                        de2 = m1.getEnterTime();
                        java.util.Date do1 = p.getExitTime();
                        java.util.Date do2 = m1.getExitTime();
                        if (de2.before(de1)) {
                            if (errSbr.length() > 0) {
                                errSbr.append("<br>");
                            }
                            errSbr.append("\u5d4c\u5957\u533a\u57df\u7684\u51fa\u5165\u65f6\u95f4\u51b2\u7a81!");
                            errSbr.append("\u533a\u57df\uff1a").append(area.getArea_name()).append(" \u7684\u5165\u573a\u65f6\u95f4: ").append(df.format(de2));
                            errSbr.append(" \u5e94\u8be5\u5927\u4e8e\u6216\u8005\u7b49\u4e8e\u533a\u57df: ").append(pa.getArea_name()).append(" \u7684\u5165\u573a\u65f6\u95f4: ").append(df.format(de1));
                            it.remove();
                            continue;
                        }
                        if (do2.after(do1)) {
                            if (errSbr.length() > 0) {
                                errSbr.append("<br>");
                            }
                            errSbr.append("\u5d4c\u5957\u533a\u57df\u7684\u51fa\u5165\u65f6\u95f4\u51b2\u7a81!");
                            errSbr.append("\u533a\u57df\uff1a").append(area.getArea_name()).append(" \u7684\u51fa\u573a\u65f6\u95f4: ").append(df.format(do2));
                            errSbr.append(" \u5e94\u8be5\u5c0f\u4e8e\u6216\u8005\u7b49\u4e8e\u533a\u57df: ").append(pa.getArea_name()).append(" \u7684\u51fa\u573a\u65f6\u95f4: ").append(df.format(do1));
                            it.remove();
                            continue;
                        }
                        areaStack.addFirst(m1);
                    }
                }
                if (errSbr.length() > 0) {
                    return WebUtil.getPrintFinshJsonString(1, errSbr.toString());
                }
                if (passRecords.size() > 1 && passRecords.peek() == chargePassRecord) {
                    passRecords.poll();
                    subChargePassRecordList = passRecords;
                }
            } else {
                subChargePassRecordList = subrecordsList;
            }
        }
        if ((cost = CarparkChargeFactory.getCarparkCharge().exitCharge(projectId, carparkId, passPortType.getPassport_type_no(), carType.getCar_type_no(), deadLine, chargePassRecord, subChargePassRecordList, plateNo, discounts, context, chargeAlgorithm)).getCharge_start_time() == null) {
            cost.setCharge_start_time(chargePassRecord.getEnterTime());
        }
        cost.getActualCharge();
        BigDecimal ac = cost.getActualCharge();
        if (passPortType.getPass_type() == 1) {
            cost.setDeduct_money(ac);
            cost.setCash(Cost.ZERO);
        } else {
            cost.setCash(ac);
            cost.setDeduct_money(Cost.ZERO);
        }
        StringBuilder result = new StringBuilder(256);
        result.append("\u5e94\u6536\u91d1\u989d\uff1a").append(cost.getShouldCharged().toString()).append("<br>");
        result.append("\u6298\u6263\u91d1\u989d\uff1a").append("-" + cost.getDiscountMoney()).append("<br>");
        StringBuilder toolTipBuilder = new StringBuilder(128);
        if (cost.getPeriod_multi_start() != null) {
            BigDecimal v = cost.getPeriod_multi_free();
            String x = "-";
            x = v.doubleValue() == (double)v.intValue() ? String.valueOf(x) + v.intValue() : String.valueOf(x) + v;
            result.append("\u5468\u671f\u4f18\u60e0\uff1a").append(x).append("<br>");
            toolTipBuilder.append("\u5468\u671f\u5f00\u59cb:").append(df.format(cost.getPeriod_multi_start()));
            toolTipBuilder.append("<br>").append("\u5468\u671f\u5df2\u6536:").append(cost.getPeriod_multi_received());
            if (cost.getNext_period_multi_start() != null && cost.getNext_period_multi_start().getTime() != cost.getPeriod_multi_start().getTime() && cost.getNext_period_multi_cur() != null && cost.getNext_period_multi_cur().doubleValue() > 0.0) {
                toolTipBuilder.append("<br>").append("\u672c\u6b21\u505c\u8f66\u8de8\u5468\u671f");
                toolTipBuilder.append("<br>").append("\u65b0\u5468\u671f\u5f00\u59cb:").append(df.format(cost.getNext_period_multi_start()));
                toolTipBuilder.append("<br>").append("\u672c\u6b21\u7f34\u8d39\u540e\u65b0\u5468\u671f\u7d2f\u8ba1").append(cost.getNext_period_multi_cur());
            }
        } else {
            result.append("\u5468\u671f\u4f18\u60e0\uff1a").append("-0.00").append("<br>");
        }
        if (cost.getDeduct_money().doubleValue() > 0.0) {
            result.append("\u6263\u8d39\u91d1\u989d\uff1a");
            result.append(cost.getDeduct_money().toString());
            result.append("<br>");
        } else {
            result.append("\u5b9e\u6536\u91d1\u989d\uff1a");
            result.append(cost.getCash().toString());
            result.append("<br>");
        }
        if (toolTipBuilder.length() > 0) {
            result.append("<p class=='test-primary'>").append((CharSequence)toolTipBuilder).append("<p>");
        }
        return WebUtil.getPrintFinshJsonString(0, result.toString());
    }

    private void submitChargeTest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        LinkedHashMap<String, String> smsm = new LinkedHashMap<String, String>();
        Enumeration enx = request.getParameterNames();
        while (enx.hasMoreElements()) {
            String name = (String)enx.nextElement();
            smsm.put(name, request.getParameter(name));
        }
        String json = CarparkChargeRuleSetingAction.submitChargeTestV(smsm);
        WebUtil.printFinshJson(response, json);
    }

    private void showTempleChargeTest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<CarparkCarType> carTypeList;
        BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
        List<CarparkPassportType> passportTypeList = basicSettingService.getPassportTypeListFromCache();
        if (passportTypeList != null && !passportTypeList.isEmpty()) {
            request.setAttribute("passportTypeList", passportTypeList);
        }
        if ((carTypeList = basicSettingService.getCarTypeListFromCache()) != null && !carTypeList.isEmpty()) {
            request.setAttribute("carTypeList", carTypeList);
        }
        ArrayList<KeyValueEntry> discoutList = new ArrayList<KeyValueEntry>();
        Map<String, CarparkDiscountProject> dmap = ServiceUtil.getServiceContext().getDBConfigCache().getDiscountProjectMap();
        if (dmap != null && !dmap.isEmpty()) {
            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            for (CarparkDiscountProject dp : dmap.values()) {
                if (dp.getDiscount_value() == 3) continue;
                discoutList.add(new KeyValueEntry((Object)dp.getDiscount_project_no(), (Object)(String.valueOf(dp.getDiscount_project_name()) + "[" + appService.getDiscountValueDes(dp.getDiscount_method(), dp.getDiscount_value()) + "]")));
            }
        }
        request.setAttribute("discoutList", discoutList);
        ArrayList<CarparkChannel> outEnterChanelList = new ArrayList<CarparkChannel>();
        ArrayList<CarparkChannel> outExitChanelList = new ArrayList<CarparkChannel>();
        ArrayList<CarparkChannel> inEnterChanelList = new ArrayList<CarparkChannel>();
        ArrayList<CarparkChannel> inExitChanelList = new ArrayList<CarparkChannel>();
        Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
        Map<String, ChannelArea> channelAreaMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas();
        if (channelMap != null && !channelMap.isEmpty() && channelAreaMap != null) {
            for (CarparkChannel channel : channelMap.values()) {
                CarparkArea o1;
                CarparkArea o;
                ChannelArea chanelArea = channelAreaMap.get(channel.getChannel_no());
                if (chanelArea == null) continue;
                if (chanelArea.getEnterAreas() != null && !chanelArea.getEnterAreas().isEmpty()) {
                    o = chanelArea.getEnterAreas().get(0);
                    if (o.getArea_level() == 1) {
                        outEnterChanelList.add(channel);
                        if (chanelArea.getEnterAreas().size() > 1 && (o1 = chanelArea.getEnterAreas().get(chanelArea.getEnterAreas().size() - 1)).getArea_level() > 1) {
                            inEnterChanelList.add(channel);
                        }
                    } else {
                        inEnterChanelList.add(channel);
                    }
                }
                if (chanelArea.getExitAreas() == null || chanelArea.getExitAreas().isEmpty()) continue;
                o = chanelArea.getExitAreas().get(chanelArea.getExitAreas().size() - 1);
                if (o.getArea_level() == 1) {
                    outExitChanelList.add(channel);
                    if (chanelArea.getExitAreas().size() <= 1 || (o1 = chanelArea.getExitAreas().get(0)).getArea_level() <= 1) continue;
                    inExitChanelList.add(channel);
                    continue;
                }
                inExitChanelList.add(channel);
            }
        }
        request.setAttribute("outEnterChanelList", outEnterChanelList);
        request.setAttribute("outExitChanelList", outExitChanelList);
        request.setAttribute("inEnterChanelList", inEnterChanelList);
        request.setAttribute("inExitChanelList", inExitChanelList);
        if (inExitChanelList != null && !inExitChanelList.isEmpty() && inEnterChanelList != null && !inEnterChanelList.isEmpty()) {
            request.setAttribute("existin", (Object)Boolean.TRUE);
        }
        WebUtil.dispathTemplatePage("carparkChargeRule", request, response);
    }

    private void showHolidayWorkday(HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Calendar cl = Calendar.getInstance();
        int currentYear = cl.get(1);
        ArrayList<Integer> yearList = new ArrayList<Integer>(3);
        yearList.add(currentYear - 1);
        yearList.add(currentYear);
        yearList.add(currentYear + 1);
        request.setAttribute("yearList", yearList);
        String selectYear = request.getParameter("year");
        int year = currentYear;
        if (selectYear != null && selectYear.length() > 0) {
            try {
                Integer l = Integer.valueOf(selectYear);
                if (yearList.contains(l)) {
                    year = l;
                }
            }
            catch (Exception l) {
                // empty catch block
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        request.setAttribute("selectedYear", (Object)year);
        cl.set(14, 0);
        cl.set(year, 0, 1, 0, 0, 0);
        Date beginDate = new Date(cl.getTimeInMillis());
        request.setAttribute("beginDate", (Object)df.format(beginDate));
        cl.set(year, 11, 31, 0, 0, 0);
        Date endDate = new Date(cl.getTimeInMillis());
        request.setAttribute("endDate", (Object)df.format(endDate));
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        List list = daoService.selectList(new SearchParam().addGTE("special_date", (Object)beginDate).addLTE("special_date", (Object)endDate).setOrerbySql("special_date").addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)carpark_id), CarparkSpecialDate.class, null);
        if (list != null && !list.isEmpty()) {
            request.setAttribute("specialDateList", (Object)list);
        }
        WebUtil.dispathTemplatePage("carparkChargeRule", request, response);
    }

    private void showTempChargeRule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String value;
        String car_type_no = request.getParameter("car_type_no");
        String passport_type_no = request.getParameter("passport_type_no");
        String area_no = request.getParameter("area_no");
        BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
        List<CarparkPassportType> passportTypeList = basicSettingService.getPassportTypeListFromCache();
        List<CarparkCarType> carTypeList = basicSettingService.getCarTypeListFromCache();
        List<CarparkArea> areaList = basicSettingService.getAreaListFromCache();
        if (passportTypeList == null || passportTypeList.isEmpty() || carTypeList == null || carTypeList.isEmpty() || areaList == null || areaList.isEmpty()) {
            WebUtil.dispathTemplatePage("carparkChargeRule", request, response);
            return;
        }
        CarparkPassportType selectPassportType = passportTypeList.get(0);
        CarparkCarType selectCarType = carTypeList.get(0);
        CarparkArea selectArea = areaList.get(0);
        if (passport_type_no != null && passport_type_no.length() > 0) {
            for (CarparkPassportType carparkPassportType : passportTypeList) {
                if (!passport_type_no.equals(carparkPassportType.getPassport_type_no())) continue;
                selectPassportType = carparkPassportType;
                break;
            }
        }
        if (car_type_no != null && car_type_no.length() > 0) {
            for (CarparkCarType carparkCarType : carTypeList) {
                if (!car_type_no.equals(carparkCarType.getCar_type_no())) continue;
                selectCarType = carparkCarType;
                break;
            }
        }
        if (area_no != null && area_no.length() > 0) {
            for (CarparkArea carparkArea : areaList) {
                if (!area_no.equals(carparkArea.getArea_no())) continue;
                selectArea = carparkArea;
                break;
            }
        }
        request.setAttribute("selectPassportType", (Object)selectPassportType);
        request.setAttribute("selectCarType", (Object)selectCarType);
        request.setAttribute("selectArea", (Object)selectArea);
        request.setAttribute("carTypeList", carTypeList);
        request.setAttribute("passportTypeList", passportTypeList);
        request.setAttribute("areaList", areaList);
        Integer n = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkChargeRule chargeRule = (CarparkChargeRule)commonDaoService.selectOne(new SearchParam().addEQ("passport_type_no", (Object)selectPassportType.getPassport_type_no()).addEQ("car_type_no", (Object)selectCarType.getCar_type_no()).addEQ("area_no", (Object)selectArea.getArea_no()).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)n).setOrerbySql("id DESC"), CarparkChargeRule.class);
        if (chargeRule != null) {
            List segmentRuleList = commonDaoService.selectList(new SearchParam().addEQ("charge_rule_no", (Object)chargeRule.getCharge_rule_no()).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)n).setOrerbySql("id"), CarparkChargeSegmentRule.class, null);
            LinkedList<CarparkChargeSegmentRule> workdaySegmentRuleList = new LinkedList<CarparkChargeSegmentRule>();
            LinkedList<CarparkChargeSegmentRule> holidaySegmentRuleList = new LinkedList<CarparkChargeSegmentRule>();
            LinkedList<CarparkChargeSegmentRule> everydaySegmentRuleList = new LinkedList<CarparkChargeSegmentRule>();
            if (segmentRuleList != null && !segmentRuleList.isEmpty()) {
                LinkedHashMap<String, CarparkChargeSegmentRule> sementRuleMap = new LinkedHashMap<String, CarparkChargeSegmentRule>();
                for (CarparkChargeSegmentRule r : segmentRuleList) {
                    sementRuleMap.put(r.getCharge_segment_rule_no(), r);
                    if (r.getWork_mode_type() == 0) {
                        everydaySegmentRuleList.add(r);
                        continue;
                    }
                    if (r.getWork_mode_type() == 1) {
                        workdaySegmentRuleList.add(r);
                        continue;
                    }
                    if (r.getWork_mode_type() != 2) continue;
                    holidaySegmentRuleList.add(r);
                }
                SearchParam tlPam = new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)n).setOrerbySql("time_len");
                if (sementRuleMap.size() == 1) {
                    tlPam.addEQ("charge_segment_rule_no", ServiceUtil.getFirstElement(sementRuleMap.keySet()));
                } else {
                    tlPam.addINList("charge_segment_rule_no", sementRuleMap.keySet());
                }
                List timeLenRange = commonDaoService.selectList(tlPam, CarparkChargeTimeLenRange.class, null);
                if (timeLenRange != null && !timeLenRange.isEmpty()) {
                    for (CarparkChargeTimeLenRange r : timeLenRange) {
                        CarparkChargeSegmentRule sr = (CarparkChargeSegmentRule)sementRuleMap.get(r.getCharge_segment_rule_no());
                        if (sr == null) continue;
                        List<CarparkChargeTimeLenRange> rlx = sr.getTimeLenRangeList();
                        if (rlx == null) {
                            rlx = new LinkedList<CarparkChargeTimeLenRange>();
                            sr.setTimeLenRangeList(rlx);
                        }
                        rlx.add(r);
                    }
                }
            }
            if (chargeRule.getWork_mode() == 0) {
                if (chargeRule.getMuti_segment_charge() == 1) {
                    if (everydaySegmentRuleList != null && !everydaySegmentRuleList.isEmpty()) {
                        request.setAttribute("segmentRuleList_0_1", everydaySegmentRuleList);
                    }
                } else if (everydaySegmentRuleList != null && !everydaySegmentRuleList.isEmpty()) {
                    request.setAttribute("segmentRule_0_0", everydaySegmentRuleList.get(0));
                }
            } else {
                if (workdaySegmentRuleList != null && !workdaySegmentRuleList.isEmpty()) {
                    request.setAttribute("segmentRuleList_1_1", workdaySegmentRuleList);
                }
                if (holidaySegmentRuleList != null && !holidaySegmentRuleList.isEmpty()) {
                    request.setAttribute("segmentRuleList_2_1", holidaySegmentRuleList);
                }
            }
            request.setAttribute("chargeRule", (Object)chargeRule);
        } else if (!(selectPassportType == null || selectArea == null || selectArea.getArea_level() != 1 || selectPassportType.getPass_type() != 0 && selectPassportType.getPass_type() != 5 || selectPassportType.getPassport_type_number() == 0 || (value = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(selectPassportType.getPassport_type_no(), "DEFALUT_CHARGE_PASSPORT_TYPE")) != null && value.equals("0"))) {
            request.setAttribute("defaultTempRuleTip", (Object)Boolean.TRUE);
        }
        WebUtil.dispathTemplatePage("carparkChargeRule", request, response);
    }

    private void showRechargeRule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String car_type_no = request.getParameter("car_type_no");
        String passport_type_no = request.getParameter("passport_type_no");
        BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
        List<CarparkPassportType> list0 = basicSettingService.getPassportTypeListFromCache();
        LinkedList<CarparkPassportType> rechagePassportList = new LinkedList<CarparkPassportType>();
        for (CarparkPassportType t : list0) {
            if (t.getPass_type() != 1 && t.getPass_type() != 2) continue;
            rechagePassportList.add(t);
        }
        List<CarparkCarType> carTypeList = basicSettingService.getCarTypeListFromCache();
        if (rechagePassportList == null || rechagePassportList.isEmpty() || carTypeList == null || carTypeList.isEmpty()) {
            WebUtil.dispathTemplatePage("carparkChargeRule", request, response);
            return;
        }
        CarparkPassportType selectPassportType = (CarparkPassportType)rechagePassportList.get(0);
        CarparkCarType selectCarType = carTypeList.get(0);
        if (passport_type_no != null && passport_type_no.length() > 0) {
            for (CarparkPassportType carparkPassportType : rechagePassportList) {
                if (!passport_type_no.equals(carparkPassportType.getPassport_type_no())) continue;
                selectPassportType = carparkPassportType;
                break;
            }
        }
        if (car_type_no != null && car_type_no.length() > 0) {
            for (CarparkCarType carparkCarType : carTypeList) {
                if (!car_type_no.equals(carparkCarType.getCar_type_no())) continue;
                selectCarType = carparkCarType;
                break;
            }
        }
        request.setAttribute("selectPassportType", (Object)selectPassportType);
        request.setAttribute("selectCarType", (Object)selectCarType);
        request.setAttribute("carTypeList", carTypeList);
        request.setAttribute("passportTypeList", rechagePassportList);
        Integer n = ServiceUtil.getServiceContext().getProjectId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        List rechargeList = commonDaoService.selectList(new SearchParam(commonDaoService.getTableName(CarparkRechargeRule.class)).addEQ("passport_type_no", (Object)selectPassportType.getPassport_type_no()).addEQ("car_type_no", (Object)selectCarType.getCar_type_no()).addEQ("project_id", (Object)n).setOrerbySql("recharge_unit,recharge_quantity"), null);
        if (rechargeList != null && !rechargeList.isEmpty()) {
            for (Map dataMap : rechargeList) {
                Integer recharge_unit = (Integer)dataMap.get("recharge_unit");
                if (recharge_unit == 0) {
                    int recharge_quantity = (Integer)dataMap.get("recharge_quantity");
                    BigDecimal d = new BigDecimal(recharge_quantity).divide(new BigDecimal(100)).setScale(2, 4);
                    dataMap.put("recharge_quantity", d);
                    continue;
                }
                if (recharge_unit == 1) {
                    dataMap.put("unit_des", "\u5929");
                    continue;
                }
                if (recharge_unit == 2) {
                    dataMap.put("unit_des", "\u4e2a\u6708");
                    continue;
                }
                if (recharge_unit != 3) continue;
                dataMap.put("unit_des", "\u5e74");
            }
            request.setAttribute("rechargeList", (Object)rechargeList);
        }
        WebUtil.dispathTemplatePage("carparkChargeRule", request, response);
    }

    @Path(value="/showRechareRuleJson.action")
    public void showRechareRuleJson(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String passport_type_no = request.getParameter("passport_type_no");
        String car_type_no = request.getParameter("car_type_no");
        if (passport_type_no == null || passport_type_no.length() == 0 || car_type_no == null || car_type_no.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u7f16\u53f7", response);
            return;
        }
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        LinkedList rechargeList = commonDaoService.selectList(new SearchParam(commonDaoService.getTableName(CarparkRechargeRule.class)).setQueryFields(new String[]{"recharge_rule_no", "recharge_quantity", "recharge_unit", "charge_amount"}).addEQ("passport_type_no", (Object)passport_type_no).addEQ("car_type_no", (Object)car_type_no).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("recharge_unit,recharge_quantity"), null);
        if (rechargeList == null) {
            rechargeList = new LinkedList();
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", rechargeList, response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8ba1\u8d39\u89c4\u5219-\u65b0\u589e\u6708\u79df/\u50a8\u503c\u89c4\u5219")
    @Path(value="/addRechargeRule.action")
    public void addRechargeRule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String passport_type_no = request.getParameter("passport_type_no");
        String car_type_no = request.getParameter("car_type_no");
        Integer recharge_quantity = Integer.valueOf(request.getParameter("recharge_quantity"));
        Integer recharge_unit = Integer.valueOf(request.getParameter("recharge_unit"));
        BigDecimal charge_amount = new BigDecimal(request.getParameter("charge_amount"));
        int pass_type = Integer.parseInt(request.getParameter("pass_type"));
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkRechargeRule.class)).addEQ("project_id", (Object)project_id).addEQ("passport_type_no", (Object)passport_type_no).addEQ("car_type_no", (Object)car_type_no).addEQ("recharge_quantity", (Object)recharge_quantity).addEQ("recharge_unit", (Object)recharge_unit));
        if (count > 0L) {
            WebUtil.printFinshJson(1, pass_type == 1 ? "\u5145\u503c\u91d1\u989d\u5b9a\u4e49\u91cd\u590d,\u8bf7\u91cd\u65b0\u8bbe\u7f6e" : "\u5145\u503c\u5468\u671f\u5b9a\u4e49\u91cd\u590d,\u8bf7\u91cd\u65b0\u8bbe\u7f6e", response);
            return;
        }
        java.util.Date now = ServiceUtil.getNow();
        CarparkRechargeRule add = new CarparkRechargeRule();
        add.setId(commonDaoService.getSequece("ck_common_seq"));
        add.setRecharge_rule_no("C" + add.getId());
        add.setCar_type_no(car_type_no);
        add.setCarpark_id(carpark_id);
        add.setCharge_amount(charge_amount);
        add.setCreated_time(now);
        add.setLast_updated_time(now);
        add.setPassport_type_no(passport_type_no);
        add.setProject_id(project_id);
        add.setRecharge_quantity(recharge_quantity);
        add.setRecharge_unit(recharge_unit);
        commonDaoService.insert((Object)add);
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8ba1\u8d39\u89c4\u5219-\u4fee\u6539\u6708\u79df/\u50a8\u503c\u89c4\u5219")
    @Path(value="/updateRechargeRule.action")
    public void updateRechargeRule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String recharge_rule_no = request.getParameter("recharge_rule_no");
        if (recharge_rule_no == null || recharge_rule_no.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u7f16\u53f7", response);
            return;
        }
        String charge_amount_str = request.getParameter("charge_amount");
        if (charge_amount_str == null || charge_amount_str.length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u6536\u8d39\u91d1\u989d", response);
            return;
        }
        BigDecimal charge_amount = new BigDecimal(charge_amount_str);
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkRechargeRule r = (CarparkRechargeRule)commonDaoService.selectOne(new SearchParam().addEQ("project_id", (Object)project_id).addEQ("recharge_rule_no", (Object)recharge_rule_no), CarparkRechargeRule.class);
        if (r == null) {
            WebUtil.printFinshJson(1, "\u8be5\u5145\u503c\u89c4\u5219\u53ef\u80fd\u4ee5\u88ab\u5220\u9664", response);
            return;
        }
        if (r.getCharge_amount().doubleValue() != charge_amount.doubleValue()) {
            CarparkRechargeRule u = new CarparkRechargeRule();
            u.setId(r.getId());
            u.setCharge_amount(charge_amount);
            u.setLast_updated_time(ServiceUtil.getNow());
            commonDaoService.updateByPrimeryKey((Object)u);
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8ba1\u8d39\u89c4\u5219-\u5220\u9664\u6708\u79df/\u50a8\u503c\u89c4\u5219")
    @Path(value="/delRechargeRule.action")
    public void delRechargeRule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String recharge_rule_no = request.getParameter("recharge_rule_no");
        if (recharge_rule_no == null || recharge_rule_no.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u7f16\u53f7", response);
            return;
        }
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkRechargeRule.class)).addEQ("project_id", (Object)project_id).addEQ("recharge_rule_no", (Object)recharge_rule_no));
        if (count > 0L) {
            commonDaoService.delete(new SearchParam(commonDaoService.getTableName(CarparkRechargeRule.class)).addEQ("project_id", (Object)project_id).addEQ("recharge_rule_no", (Object)recharge_rule_no));
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8ba1\u8d39\u89c4\u5219-\u8bbe\u7f6e\u4e34\u505c\u8ba1\u8d39\u89c4\u5219")
    @Path(value="/addChargeRule.action")
    public void addChargeRule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        CarparkChargeRule rule;
        String saveData = request.getParameter("saveData");
        if (saveData == null || saveData.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u6570\u636e", response);
            return;
        }
        try {
            rule = (CarparkChargeRule)GsonBuilder.create().fromJson(saveData, CarparkChargeRule.class);
        }
        catch (Exception ex) {
            LogUtil.getLog().warn((Object)("\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff1a" + saveData), (Throwable)ex);
            WebUtil.printFinshJson(1, "\u6570\u636e\u683c\u5f0f\u9519\u8bef", response);
            return;
        }
        if (rule.getArea_no() == null || rule.getArea_no().length() == 0 || rule.getCar_type_no() == null || rule.getCar_type_no().length() == 0 || rule.getPassport_type_no() == null || rule.getPassport_type_no().length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u6570\u636e", response);
            return;
        }
        BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                basicSettingService.deleteChargeRule(rule.getArea_no(), rule.getCar_type_no(), rule.getPassport_type_no(), carpark_id, project_id, commonDaoService, session);
                java.util.Date now = ServiceUtil.getNow();
                rule.setId(commonDaoService.getSequece("ck_common_seq"));
                rule.setCharge_rule_no("C" + rule.getId());
                rule.setCreated_time(now);
                rule.setLast_updated_time(now);
                rule.setCarpark_id(carpark_id);
                rule.setProject_id(project_id);
                commonDaoService.insert(session, (Object)rule);
                for (CarparkChargeSegmentRule segrule : rule.getSegmentRuleList()) {
                    segrule.setId(commonDaoService.getSequece("ck_common_seq"));
                    segrule.setCharge_segment_rule_no("C" + segrule.getId());
                    segrule.setCharge_rule_no(rule.getCharge_rule_no());
                    segrule.setCreated_time(now);
                    segrule.setLast_updated_time(now);
                    segrule.setCarpark_id(carpark_id);
                    segrule.setProject_id(project_id);
                    commonDaoService.insert(session, (Object)segrule);
                    if (segrule.getTimeLenRangeList() == null || segrule.getTimeLenRangeList().isEmpty()) continue;
                    for (CarparkChargeTimeLenRange r : segrule.getTimeLenRangeList()) {
                        r.setId(commonDaoService.getSequece("ck_common_seq"));
                        r.setCharge_time_len_range_no("C" + r.getId());
                        r.setCharge_segment_rule_no(segrule.getCharge_segment_rule_no());
                        r.setCreated_time(now);
                        r.setLast_updated_time(now);
                        r.setCarpark_id(carpark_id);
                        r.setProject_id(project_id);
                        commonDaoService.insert(session, (Object)r);
                    }
                }
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8ba1\u8d39\u89c4\u5219-\u5220\u9664\u4e34\u505c\u8ba1\u8d39\u89c4\u5219")
    @Path(value="/delChargeRule.action")
    public void delChargeRule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String passport_type_no = request.getParameter("passport_type_no");
        String car_type_no = request.getParameter("car_type_no");
        String area_no = request.getParameter("area_no");
        if (passport_type_no == null || passport_type_no.length() == 0 || car_type_no == null || car_type_no.length() == 0 || area_no == null || area_no.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u53c2\u6570\uff01", response);
            return;
        }
        BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                basicSettingService.deleteChargeRule(area_no, car_type_no, passport_type_no, carpark_id, project_id, commonDaoService, session);
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8ba1\u8d39\u89c4\u5219-\u65b0\u589e\u5de5\u4f5c\u65e5\u8282\u5047\u65e5")
    @Path(value="/addHolidayWorkday.action")
    public void addHolidayWorkday(HttpServletRequest request, HttpServletResponse response) throws Exception {
        java.util.Date date1;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String defineDate = request.getParameter("defineDate");
        if (defineDate == null || defineDate.length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u9009\u62e9\u65e5\u671f", response);
            return;
        }
        try {
            date1 = df.parse(defineDate);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u683c\u5f0f\u4e3a \u5e74-\u6708-\u65e5\uff0c\u6bd4\u5982: 2018-08-01", response);
            return;
        }
        Integer date_type = Integer.valueOf(request.getParameter("date_type"));
        if (date_type != 1 && date_type != 2) {
            WebUtil.printFinshJson(1, "\u65e5\u671f\u7c7b\u578b\u9519\u8bef", response);
            return;
        }
        String remark = request.getParameter("remark");
        if (remark == null) {
            remark = "";
        }
        remark = remark.trim();
        Date special_date = new Date(date1.getTime());
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkSpecialDate.class)).addEQ("special_date", (Object)special_date).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id));
        if (count > 0L) {
            WebUtil.printFinshJson(1, "\u65e5\u671f" + defineDate + "\u5df2\u7ecf\u5b58\u5728", response);
            return;
        }
        java.util.Date now = ServiceUtil.getNow();
        CarparkSpecialDate cdate = new CarparkSpecialDate();
        cdate.setId(commonDaoService.getSequece("ck_common_seq"));
        cdate.setCarpark_id(carpark_id);
        cdate.setCreated_time(now);
        cdate.setDate_type(date_type);
        cdate.setProject_id(project_id);
        cdate.setRemark(ServiceUtil.getString(remark, 45));
        cdate.setSpecial_date(special_date);
        cdate.setLast_updated_time(now);
        commonDaoService.insert((Object)cdate);
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8ba1\u8d39\u89c4\u5219-\u4fee\u6539\u5de5\u4f5c\u65e5\u8282\u5047\u65e5")
    @Path(value="/updateHolidayWorkday.action")
    public void updateHolidayWorkday(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String _id = request.getParameter("id");
        if (_id == null || (_id = _id.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u7f16\u53f7", response);
            return;
        }
        Long id = Long.valueOf(_id);
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkSpecialDate date = (CarparkSpecialDate)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkSpecialDate.class);
        if (date == null) {
            WebUtil.printFinshJson(1, "\u65e5\u671f\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002\u3002\u3002", response);
            return;
        }
        Integer date_type = Integer.valueOf(request.getParameter("date_type"));
        String remark = request.getParameter("remark");
        if (remark == null) {
            remark = "";
        }
        if (date.getDate_type().intValue() != date_type.intValue() || !remark.equals(date.getRemark())) {
            CarparkSpecialDate udpateDate = new CarparkSpecialDate();
            udpateDate.setId(id);
            if (date.getDate_type().intValue() != date_type.intValue()) {
                udpateDate.setDate_type(date_type);
            }
            if (!remark.equals(date.getRemark())) {
                udpateDate.setRemark(remark);
            }
            udpateDate.setLast_updated_time(ServiceUtil.getNow());
            commonDaoService.updateByPrimeryKey((Object)udpateDate);
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8ba1\u8d39\u89c4\u5219-\u5220\u9664\u5de5\u4f5c\u65e5\u8282\u5047\u65e5")
    @Path(value="/delHolidayWorkday.action")
    public void delHolidayWorkday(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String _id = request.getParameter("id");
        if (_id == null || (_id = _id.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u7f16\u53f7", response);
            return;
        }
        Long id = Long.valueOf(_id);
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkSpecialDate date = (CarparkSpecialDate)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkSpecialDate.class);
        if (date != null) {
            commonDaoService.delete(new SearchParam(commonDaoService.getTableName(CarparkSpecialDate.class)).addEQ("id", (Object)id));
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }
}

