/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action.manage;

import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.CarparkCommonService;
import com.wovoe.carpark.web.LeftMenu;
import com.wovoe.carpark.web.Permission;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Action(value="/manage")
public class CarparkCommonSearchAction {
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u8f66\u8f86\u505c\u8f66\u65f6\u957f\u67e5\u8be2")
    @LeftMenu(name="\u8f66\u8f86\u505c\u8f66\u65f6\u957f\u67e5\u8be2", parent_name="\u8bb0\u5f55\u67e5\u8be2", order=314)
    @Path(value="/queryParkingDuration.action")
    public void queryParkingDuration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            Map<String, CarparkCarType> carTypeMap;
            Map<String, CarparkPassportType> passportTypeMap;
            Calendar cl = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            request.setAttribute("endTime", (Object)df.format(cl.getTime()));
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            cl.set(14, 0);
            cl.add(6, -1);
            request.setAttribute("startTime", (Object)df.format(cl.getTime()));
            Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
            if (areaMap != null) {
                request.setAttribute("areaMap", areaMap);
            }
            if ((passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap()) != null) {
                request.setAttribute("passportTypeMap", passportTypeMap);
            }
            if ((carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap()) != null) {
                request.setAttribute("carTypeMap", carTypeMap);
            }
            WebUtil.showMainContentWithHead("\u8f66\u8f86\u505c\u8f66\u65f6\u957f\u67e5\u8be2", "report/parkingDurationQuery", request, response);
        } else if ("query".equals(op)) {
            Date time_end;
            Date time_begin;
            String q_time_begin = request.getParameter("q_time_begin");
            String q_time_end = request.getParameter("q_time_end");
            String q_passport_type_no = request.getParameter("q_passport_type_no");
            String q_car_type_no = request.getParameter("q_car_type_no");
            String q_area_no = request.getParameter("q_area_no");
            String q_plate_number = request.getParameter("q_plate_number");
            String q_parking_duration_begin = request.getParameter("q_parking_duration_begin");
            String q_parking_duration_end = request.getParameter("q_parking_duration_end");
            String q_carowner_name = request.getParameter("q_carowner_name");
            String q_carowner_addr = request.getParameter("q_carowner_addr");
            String q_unit = request.getParameter("q_unit");
            if (q_time_begin == null || (q_time_begin = q_time_begin.trim()).length() == 0) {
                WebUtil.printFinshJson(1, "\u7f3a\u5c11\u67e5\u8be2\u5f00\u59cb\u65f6\u95f4", response);
                return;
            }
            if (q_time_end == null || (q_time_end = q_time_end.trim()).length() == 0) {
                WebUtil.printFinshJson(1, "\u7f3a\u5c11\u67e5\u8be2\u7ed3\u675f\u65f6\u95f4", response);
                return;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                time_begin = df.parse(q_time_begin);
                time_end = df.parse(q_time_end);
            }
            catch (Exception ex) {
                WebUtil.printFinshJson(1, "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef", response);
                return;
            }
            if (time_end.before(time_begin)) {
                WebUtil.printFinshJson(1, "\u65f6\u95f4\u8303\u56f4\u9519\u8bef\uff0c\u5f00\u59cb\u65f6\u95f4\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4", response);
                return;
            }
            Long parking_duration_begin = null;
            Long parking_duration_end = null;
            try {
                if (q_parking_duration_begin != null && (q_parking_duration_begin = q_parking_duration_begin.trim()).length() > 0) {
                    parking_duration_begin = Long.valueOf(q_parking_duration_begin);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (q_parking_duration_end != null && (q_parking_duration_end = q_parking_duration_end.trim()).length() > 0) {
                    parking_duration_end = Long.valueOf(q_parking_duration_end);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ("days".equals(q_unit)) {
                if (parking_duration_begin != null) {
                    parking_duration_begin = parking_duration_begin * 24L * 60L;
                }
                if (parking_duration_end != null) {
                    parking_duration_end = parking_duration_end * 24L * 60L;
                }
            } else if ("hours".equals(q_unit)) {
                if (parking_duration_begin != null) {
                    parking_duration_begin = parking_duration_begin * 60L;
                }
                if (parking_duration_end != null) {
                    parking_duration_end = parking_duration_end * 60L;
                }
            }
            if (q_plate_number != null) {
                q_plate_number = q_plate_number.trim();
            }
            if (q_passport_type_no != null) {
                q_passport_type_no = q_passport_type_no.trim();
            }
            if (q_area_no != null) {
                q_area_no = q_area_no.trim();
            }
            if (q_car_type_no != null) {
                q_car_type_no = q_car_type_no.trim();
            }
            Pagination pagination = WebUtil.getPagination(request);
            CarparkCommonService carparkCommonService = (CarparkCommonService)ServiceUtil.getServiceContext().getService(CarparkCommonService.class);
            List<Map<String, String>> queryList = carparkCommonService.queryParkingExceedCars(time_begin, time_end, parking_duration_begin, parking_duration_end, q_plate_number, true, q_area_no, q_passport_type_no, q_car_type_no, q_carowner_name, q_carowner_addr, pagination, null);
            String str_carOwnerNameStr = "carOwnerName";
            String str_carOwnerAddrStr = "carOwnerAddr";
            String car_owner_name_str = "car_owner_name";
            String addressStr = "address";
            String queryBeginTime = "queryBeginTime";
            String queryEndTime = "queryEndTime";
            if (queryList != null && !queryList.isEmpty()) {
                for (Map<String, String> ax : queryList) {
                    ax.put("carOwnerName", ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue(car_owner_name_str, ax.get("carOwnerName"), request));
                    ax.put("carOwnerAddr", ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue(addressStr, ax.get("carOwnerAddr"), request));
                    ax.put(queryBeginTime, q_time_begin);
                    ax.put(queryEndTime, q_time_end);
                }
            }
            WebUtil.printTableListJson(request, response, queryList, pagination.getRecordsCount());
        } else if ("queryDetail".equals(op)) {
            Date time_end;
            Date time_begin;
            String q_time_begin = request.getParameter("q_time_begin");
            String q_time_end = request.getParameter("q_time_end");
            String q_area_no = request.getParameter("q_area_no");
            String q_plate_number = request.getParameter("q_plate_number");
            if (q_time_begin == null || (q_time_begin = q_time_begin.trim()).length() == 0) {
                WebUtil.printFinshJson(1, "\u7f3a\u5c11\u67e5\u8be2\u5f00\u59cb\u65f6\u95f4", response);
                return;
            }
            if (q_time_end == null || (q_time_end = q_time_end.trim()).length() == 0) {
                WebUtil.printFinshJson(1, "\u7f3a\u5c11\u67e5\u8be2\u7ed3\u675f\u65f6\u95f4", response);
                return;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                time_begin = df.parse(q_time_begin);
                time_end = df.parse(q_time_end);
            }
            catch (Exception ex) {
                WebUtil.printFinshJson(1, "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef", response);
                return;
            }
            if (time_end.before(time_begin)) {
                WebUtil.printFinshJson(1, "\u65f6\u95f4\u8303\u56f4\u9519\u8bef\uff0c\u5f00\u59cb\u65f6\u95f4\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4", response);
                return;
            }
            if (q_plate_number == null || q_plate_number.length() == 0) {
                WebUtil.printFinshJson(1, "\u7f3a\u5c11\u8f66\u724c\u53f7", response);
                return;
            }
            CarparkCommonService carparkCommonService = (CarparkCommonService)ServiceUtil.getServiceContext().getService(CarparkCommonService.class);
            List<Map<String, Object>> dList = carparkCommonService.queryParkingExceedCarDetail(time_begin, time_end, q_plate_number, q_area_no, true);
            HashMap<String, List<Map<String, Object>>> rMap = new HashMap<String, List<Map<String, Object>>>();
            rMap.put("data", dList);
            String json = GsonBuilder.create().toJson(rMap);
            WebUtil.printFinshJson(response, json);
        }
    }
}

