/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action.manage;

import com.wovoe.carpark.dto.CarparkDiscountProject;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.web.LeftMenu;
import com.wovoe.carpark.web.Permission;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.carpark.web.WritePermission;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Action(value="/manage")
public class CarparkDisocuntManageAction {
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u5546\u6237/\u6298\u6263\u7ba1\u7406-\u8f66\u573a\u6298\u6263\u8bbe\u7f6e(\u67e5\u8be2)")
    @LeftMenu(name="\u8f66\u573a\u6298\u6263\u8bbe\u7f6e", parent_name="\u5546\u6237/\u6298\u6263\u7ba1\u7406", order=221)
    @Path(value="/showCarparkDiscountSetting.action")
    public void showCarparkDiscountSetting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            WebUtil.showMainContentWithHead("\u8f66\u573a\u6298\u6263\u89c4\u5219\u8bbe\u7f6e", "carparkDiscount", request, response);
            return;
        }
        if ("showSearch".equals(op)) {
            String useType = request.getParameter("useType");
            CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            Integer project_id = ServiceUtil.getServiceContext().getProjectId();
            Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
            SearchParam searchParm = new SearchParam(daoService.getTableName(CarparkDiscountProject.class));
            searchParm.addEQ("carpark_id", (Object)carpark_id);
            searchParm.addEQ("project_id", (Object)project_id);
            searchParm.setOrerbySql("id");
            if ("1".equals(useType)) {
                searchParm.addIN("use_type", (Object)1);
                searchParm.addIN("use_type", (Object)3);
            } else if ("2".equals(useType)) {
                searchParm.addIN("use_type", (Object)2);
                searchParm.addIN("use_type", (Object)3);
            }
            List dataList = daoService.selectList(searchParm, null);
            if (dataList != null && !dataList.isEmpty()) {
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                for (Map m : dataList) {
                    String discount_des;
                    String discount_value_des;
                    String discount_value0;
                    int discountMethod = (Integer)m.get("discount_method");
                    int discountValue = (Integer)m.get("discount_value");
                    if (discountMethod == 3) {
                        int hour = discountValue << 8 >>> 24;
                        int mins = discountValue << 16 >>> 24;
                        int secs = discountValue << 24 >>> 24;
                        StringBuilder sbr = new StringBuilder(16);
                        if (hour < 10) {
                            sbr.append('0');
                        }
                        sbr.append(hour).append(':');
                        if (mins < 10) {
                            sbr.append('0');
                        }
                        sbr.append(mins).append(':');
                        if (secs < 10) {
                            sbr.append('0');
                        }
                        sbr.append(secs);
                        discount_value0 = sbr.toString();
                        discount_value_des = "\u9ed8\u8ba4\u65f6\u95f4:" + discount_value0;
                        discount_des = "\u591a\u7528\u4e8e\u9152\u5e97\u4f4f\u5bbf\u6253\u6298\uff0c\u514d\u8d39\u65e5\u671f/\u65f6\u95f4\u7531\u64cd\u4f5c\u5458\u81ea\u5b9a\u4e49\uff0c\u514d\u8d39\u65f6\u95f4\u5185\u5141\u8bb8\u591a\u6b21\u51fa\u5165";
                    } else {
                        discount_des = appService.getDiscountValueDes(discountMethod, discountValue);
                        if (discountMethod == 1) {
                            discount_value_des = appService.getTimeLenDes(discountValue);
                            discount_value0 = String.valueOf(discountValue);
                        } else if (discountMethod == 0) {
                            discount_value0 = new BigDecimal((double)discountValue / 100.0).setScale(2, 4).toString();
                            discount_value_des = String.valueOf(discount_value0) + "\u5143";
                        } else if (discountMethod == 2) {
                            discount_value0 = String.valueOf(discountValue);
                            discount_value_des = String.valueOf(discount_value0) + "%";
                        } else if (discountMethod == 5) {
                            discount_value0 = new BigDecimal((double)discountValue / 100.0).setScale(2, 4).toString();
                            discount_value_des = String.valueOf(discount_value0) + "\u5143";
                            discount_des = "\u4f18\u60e0\u5230" + discount_value_des;
                        } else {
                            discount_value0 = "";
                            discount_value_des = "";
                        }
                    }
                    m.put("discount_value0", discount_value0);
                    m.put("discount_value_des", discount_value_des);
                    m.put("discount_des", discount_des);
                }
                request.setAttribute("dataList", (Object)dataList);
            }
            WebUtil.dispathTemplatePage("carparkDiscount", request, response);
        }
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u5546\u6237/\u6298\u6263\u7ba1\u7406-\u8f66\u573a\u6298\u6263\u8bbe\u7f6e-\u65b0\u589e\u6298\u6263\u89c4\u5219")
    @Path(value="/addCarparkDiscountSetting.action")
    public void addCarparkDiscountSetting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int discount_value;
        String discount_project_name = request.getParameter("discount_project_name");
        String _discount_method = request.getParameter("discount_method");
        String discount_value0 = request.getParameter("discount_value0");
        String _use_type = request.getParameter("use_type");
        String _settle_method = request.getParameter("settle_method");
        if (discount_project_name == null || (discount_project_name = discount_project_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u6298\u6263\u540d\u4e0d\u80fd\u4e3a\u7a7a", response);
            return;
        }
        if (discount_value0 == null || (discount_value0 = discount_value0.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u6298\u6263\u503c\u4e0d\u80fd\u4e3a\u7a7a", response);
            return;
        }
        int discount_method = Integer.parseInt(_discount_method);
        Integer use_type = Integer.valueOf(_use_type);
        Integer settle_method = Integer.valueOf(_settle_method);
        if (discount_method == 0) {
            discount_value = new BigDecimal(discount_value0).multiply(new BigDecimal("100")).setScale(2, 4).intValue();
        } else if (discount_method == 1) {
            discount_value = Integer.parseInt(discount_value0);
        } else if (discount_method == 2) {
            discount_value = Integer.parseInt(discount_value0);
            if (discount_value < 0) {
                discount_value = 0;
            } else if (discount_value > 100) {
                discount_value = 100;
            }
        } else if (discount_method == 3) {
            try {
                Date d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse("2018-01-01 " + discount_value0);
                Calendar cl = Calendar.getInstance();
                cl.setTime(d);
                int hour = cl.get(11);
                int mins = cl.get(12);
                int secs = cl.get(13);
                int h = hour << 16;
                h |= mins << 8;
                discount_value = h |= secs;
            }
            catch (Exception ex) {
                WebUtil.printFinshJson(1, String.valueOf(discount_value0) + " \u65f6\u95f4\u683c\u5f0f\u9519\u8bef!", response);
                return;
            }
        } else if (discount_method == 5) {
            discount_value = new BigDecimal(discount_value0).multiply(new BigDecimal("100")).setScale(2, 4).intValue();
        } else {
            WebUtil.printFinshJson(1, "\u672a\u77e5\u7684\u6298\u6263\u65b9\u5f0f", response);
            return;
        }
        if (discount_project_name.getBytes("UTF-8").length > 45) {
            WebUtil.printFinshJson(1, "\u6298\u6263\u540d\u79f0\u5927\u957f", response);
            return;
        }
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        long count = daoService.selectCount(new SearchParam(daoService.getTableName(CarparkDiscountProject.class)).addEQ("discount_project_name", (Object)discount_project_name).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id));
        if (count > 0L) {
            WebUtil.printFinshJson(1, String.valueOf(discount_project_name) + " \u5df2\u5b58\u5728\uff0c\u540d\u79f0\u4e0d\u80fd\u76f8\u540c", response);
            return;
        }
        Date now = ServiceUtil.getNow();
        CarparkDiscountProject c = new CarparkDiscountProject();
        c.setId(daoService.getSequece("ck_common_seq"));
        c.setCarpark_id(carpark_id);
        c.setCreated_time(now);
        c.setDiscount_method(discount_method);
        c.setDiscount_project_name(discount_project_name);
        c.setDiscount_project_no("C" + c.getId());
        c.setDiscount_value(discount_value);
        c.setLast_updated_time(now);
        c.setProject_id(project_id);
        c.setUse_type(use_type);
        c.setSettle_method(settle_method);
        daoService.insert((Object)c);
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u5546\u6237/\u6298\u6263\u7ba1\u7406-\u8f66\u573a\u6298\u6263\u8bbe\u7f6e-\u4fee\u6539\u6298\u6263\u89c4\u5219")
    @Path(value="/modifyCarparkDiscountSetting.action")
    public void modifyCarparkDiscountSetting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long count;
        int discount_value;
        Long id = Long.valueOf(request.getParameter("id"));
        String discount_project_name = request.getParameter("discount_project_name");
        String _discount_method = request.getParameter("discount_method");
        String discount_value0 = request.getParameter("discount_value0");
        String _settle_method = request.getParameter("settle_method");
        String _use_type = request.getParameter("use_type");
        if (discount_project_name == null || (discount_project_name = discount_project_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u6298\u6263\u540d\u4e0d\u80fd\u4e3a\u7a7a", response);
            return;
        }
        if (discount_value0 == null || (discount_value0 = discount_value0.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u6298\u6263\u503c\u4e0d\u80fd\u4e3a\u7a7a", response);
            return;
        }
        int discount_method = Integer.parseInt(_discount_method);
        Integer use_type = Integer.valueOf(_use_type);
        Integer settle_method = Integer.valueOf(_settle_method);
        if (discount_method == 0) {
            discount_value = new BigDecimal(discount_value0).multiply(new BigDecimal("100")).setScale(2, 4).intValue();
        } else if (discount_method == 1) {
            discount_value = Integer.parseInt(discount_value0);
        } else if (discount_method == 2) {
            discount_value = Integer.parseInt(discount_value0);
            if (discount_value < 0) {
                discount_value = 0;
            } else if (discount_value > 100) {
                discount_value = 100;
            }
        } else if (discount_method == 3) {
            try {
                Date d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse("2018-01-01 " + discount_value0);
                Calendar cl = Calendar.getInstance();
                cl.setTime(d);
                int hour = cl.get(11);
                int mins = cl.get(12);
                int secs = cl.get(13);
                int h = hour << 16;
                h |= mins << 8;
                discount_value = h |= secs;
            }
            catch (Exception ex) {
                WebUtil.printFinshJson(1, String.valueOf(discount_value0) + " \u65f6\u95f4\u683c\u5f0f\u9519\u8bef!", response);
                return;
            }
        } else if (discount_method == 5) {
            discount_value = new BigDecimal(discount_value0).multiply(new BigDecimal("100")).setScale(2, 4).intValue();
        } else {
            WebUtil.printFinshJson(1, "\u672a\u77e5\u7684\u6298\u6263\u65b9\u5f0f", response);
            return;
        }
        if (discount_project_name.getBytes("UTF-8").length > 45) {
            WebUtil.printFinshJson(1, "\u6298\u6263\u540d\u79f0\u5927\u957f", response);
            return;
        }
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CarparkDiscountProject p = (CarparkDiscountProject)daoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkDiscountProject.class);
        if (p == null) {
            WebUtil.printFinshJson(1, "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", response);
            return;
        }
        if (!discount_project_name.equals(p.getDiscount_project_name()) && (count = daoService.selectCount(new SearchParam(daoService.getTableName(CarparkDiscountProject.class)).addNotEQ("id", (Object)id).addEQ("discount_project_name", (Object)discount_project_name).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id))) > 0L) {
            WebUtil.printFinshJson(1, String.valueOf(discount_project_name) + " \u5df2\u5b58\u5728\uff0c\u540d\u79f0\u4e0d\u80fd\u76f8\u540c", response);
            return;
        }
        p.setDiscount_method(discount_method);
        p.setDiscount_project_name(discount_project_name);
        p.setDiscount_value(discount_value);
        p.setLast_updated_time(WebUtil.getNow());
        p.setUse_type(use_type);
        p.setSettle_method(settle_method);
        daoService.updateIfChangedByPrimeryKey((Object)p, new String[]{"last_updated_time"});
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u5546\u6237/\u6298\u6263\u7ba1\u7406-\u8f66\u573a\u6298\u6263\u8bbe\u7f6e-\u5220\u9664\u6298\u6263\u89c4\u5219")
    @Path(value="/delCarparkDiscountSetting.action")
    public void delCarparkDiscountSetting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long id = Long.valueOf(request.getParameter("id"));
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkDiscountProject p = (CarparkDiscountProject)daoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkDiscountProject.class);
        if (p == null) {
            WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
            return;
        }
        daoService.delete(new SearchParam(daoService.getTableName(CarparkDiscountProject.class)).addEQ("id", (Object)id));
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }
}

