/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action.manage;

import com.wovoe.carpark.dto.CarparkEscapeOrder;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.vo.ClientHost;
import com.wovoe.carpark.web.LeftMenu;
import com.wovoe.carpark.web.Permission;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.carpark.web.WritePermission;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Action(value="/manage")
public class CarparkEscapeOrderSearchAction {
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u53d6\u6d88\u672a\u652f\u4ed8\u8ba2\u5355")
    @LeftMenu(name="\u53d6\u6d88\u672a\u652f\u4ed8\u8ba2\u5355", parent_name="\u8bb0\u5f55\u67e5\u8be2", order=331)
    @Path(value="/queryCancelArrearageOrder.action")
    public void queryPresenceRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            Calendar cl = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            request.setAttribute("endTime", (Object)df.format(cl.getTime()));
            cl.add(2, -6);
            cl.set(14, 0);
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            request.setAttribute("startTime", (Object)df.format(cl.getTime()));
            WebUtil.showMainContentWithHead("\u53d6\u6d88\u672a\u652f\u4ed8\u8ba2\u5355", "report/carparkEscapeOrderSearch", request, response);
        } else if ("showUnPayOrder".equals(op) || "showCloedOrder".equals(op)) {
            String start_exit_time = request.getParameter("start_exit_time");
            String end_exit_time = request.getParameter("end_exit_time");
            String pass_plate = request.getParameter("pass_plate");
            String order_state = request.getParameter("order_state");
            if (pass_plate != null && (pass_plate = pass_plate.trim()).length() > 0) {
                pass_plate = pass_plate.toUpperCase();
            }
            Date startTime = null;
            Date endTime = null;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (start_exit_time != null && start_exit_time.length() > 0) {
                try {
                    startTime = df.parse(start_exit_time);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (end_exit_time != null && end_exit_time.length() > 0) {
                try {
                    endTime = df.parse(end_exit_time);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService("commonDaoService");
            SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkEscapeOrder.class));
            if (startTime != null) {
                sp.addGTE("exit_time", (Object)startTime);
            }
            if (endTime != null) {
                sp.addLTE("exit_time", (Object)endTime);
            }
            if (pass_plate != null && pass_plate.length() > 0) {
                sp.addLike("pass_plate", pass_plate);
            }
            Integer orderState = null;
            if ("showUnPayOrder".equals(op)) {
                orderState = 0;
                sp.addEQ("order_state", (Object)orderState);
            } else {
                if (order_state != null && (order_state = order_state.trim()).length() > 0) {
                    try {
                        orderState = Integer.valueOf(order_state);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (orderState != null) {
                    sp.addEQ("order_state", (Object)orderState);
                } else {
                    sp.addGT("order_state", (Object)0);
                }
            }
            String defualtOrderBy = "exit_time desc";
            String sortBy = WebUtil.getOrderBy(request, defualtOrderBy);
            sp.setOrder_by(sortBy);
            Pagination pagination = WebUtil.getPagination(request);
            List queryList = commonDaoService.selectList(sp, pagination);
            if (queryList != null && !queryList.isEmpty()) {
                Map<Integer, String> payMethodMap = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap();
                ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                for (Map dataMap : queryList) {
                    String order_pay_method_des;
                    Integer order_pay_method = (Integer)dataMap.get("order_pay_method");
                    if (order_pay_method != null && payMethodMap != null && (order_pay_method_des = payMethodMap.get(order_pay_method)) != null) {
                        dataMap.put("order_pay_method_des", order_pay_method_des);
                    }
                    String exit_plate_pic = (String)dataMap.get("exit_plate_pic");
                    String exit_host_no = (String)dataMap.get("exit_host_no");
                    dataMap.put("exit_plate_pic", WebUtil.getPicUri(request.getContextPath(), exit_plate_pic, exit_host_no, true));
                    Date enterTime = (Date)dataMap.get("enter_time");
                    Date exitTime = (Date)dataMap.get("exit_time");
                    if (enterTime == null || exitTime == null) continue;
                    String des = applicationService.getTimeLenSecDes((int)TimeUnit.MILLISECONDS.toSeconds(exitTime.getTime() - enterTime.getTime()));
                    dataMap.put("parkingTimeDes", des);
                }
            }
            WebUtil.printTableListJson(request, response, queryList, pagination.getRecordsCount());
        }
    }

    @WritePermission
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u5173\u95ed\u53d6\u6d88\u672a\u652f\u4ed8\u8ba2\u5355")
    @Path(value="/closeCancelArrearageOrder.action")
    public void closeCancelArrearageOrder(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String userName;
        String userCode;
        Date opTime = WebUtil.getNow();
        ClientHost clientHost = WebUtil.getLoginClientHost(request);
        if (clientHost != null) {
            userCode = clientHost.getUserCode();
            userName = clientHost.getUserName();
        } else {
            CarparkUser user = WebUtil.getLoginManageUser(request);
            userCode = user.getUser_code();
            userName = user.getUser_name();
        }
        String passport_number = request.getParameter("passport_number");
        String medium_type = request.getParameter("medium_type");
        String exit_time = request.getParameter("exit_time");
        String exit_record_no = request.getParameter("exit_record_no");
        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        recordSaveService.closeCarparkEscapeOrder(passport_number, medium_type, exit_time, exit_record_no, userCode, userName, opTime, true);
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }
}

