/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action.manage;

import com.google.gson.reflect.TypeToken;
import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkFeeReport;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.internel.CarparkTranFeeReportJob;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ExportService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.vo.Cell;
import com.wovoe.carpark.vo.ClientHost;
import com.wovoe.carpark.web.LeftMenu;
import com.wovoe.carpark.web.Permission;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.carpark.web.WritePermission;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JavaBeanUtil;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Action(value="/manage")
public class CarparkFeeStatisticsAction {
    /*
     * WARNING - void declaration
     */
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u6536\u8d39\u7edf\u8ba1-\u4e34\u505c\u7f34\u8d39\u7edf\u8ba1")
    @LeftMenu(name="\u4e34\u505c\u7f34\u8d39\u7edf\u8ba1", parent_name="\u6536\u8d39\u7edf\u8ba1", order=321)
    @Path(value="/tempFeeStatistics.action")
    public void tempFeeStatistics(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, CarparkCarType> carTypeMap;
        String op = request.getParameter("op");
        Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
        LinkedList<CarparkArea> outAreaList = new LinkedList<CarparkArea>();
        if (areaMap != null && !areaMap.isEmpty()) {
            for (CarparkArea area : areaMap.values()) {
                if (area.getArea_level() != 1) continue;
                outAreaList.add(area);
            }
        }
        request.setAttribute("areaList", outAreaList);
        Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        request.setAttribute("hostMap", hostMap);
        Map<Integer, String> payMethodMapCache = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap();
        LinkedHashMap<Integer, String> payMethodMap = new LinkedHashMap<Integer, String>();
        for (Map.Entry<Integer, String> m : payMethodMapCache.entrySet()) {
            if (m.getKey() == 2 || m.getKey() == 1) continue;
            payMethodMap.put(m.getKey(), m.getValue());
        }
        request.setAttribute("payMethodMap", payMethodMap);
        Map<Integer, String> chargeOrgMap = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap();
        request.setAttribute("chargeOrgMap", chargeOrgMap);
        Map<Integer, String> paySceneMap = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap();
        request.setAttribute("paySceneMap", paySceneMap);
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        List userList0 = commonDaoService.selectList(new SearchParam().addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("role_no DESC,user_code"), CarparkUser.class, null);
        ArrayList<KeyValueEntry> userList = new ArrayList<KeyValueEntry>(userList0.size() + 1);
        for (CarparkUser u : userList0) {
            userList.add(new KeyValueEntry((Object)u.getUser_code(), (Object)u.getUser_name()));
        }
        userList.add(new KeyValueEntry((Object)"USER_SELF", (Object)"\u81ea\u52a9\u7f34\u8d39"));
        userList.add(new KeyValueEntry((Object)"USER_CLOUD_CODE", (Object)"\u4e91\u7aef\u7528\u6237"));
        request.setAttribute("userList", userList);
        ArrayList<KeyValueEntry> serviceTypeList = new ArrayList<KeyValueEntry>(2);
        serviceTypeList.add(new KeyValueEntry((Object)0, (Object)"\u4e34\u505c\u7f34\u8d39"));
        serviceTypeList.add(new KeyValueEntry((Object)1, (Object)"\u4e34\u505c\u9000\u8d39"));
        request.setAttribute("serviceTypeList", serviceTypeList);
        Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        if (passportTypeMap != null) {
            request.setAttribute("passportTypeMap", passportTypeMap);
        }
        if ((carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap()) != null) {
            request.setAttribute("carTypeMap", carTypeMap);
        }
        if (op == null) {
            Calendar cl = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            request.setAttribute("endTime", (Object)df.format(cl.getTime()));
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            cl.set(14, 0);
            request.setAttribute("startTime", (Object)df.format(cl.getTime()));
            WebUtil.showMainContentWithHead("\u4e34\u505c\u7f34\u8d39\u7edf\u8ba1", "report/tempFeeStatistics", request, response);
        } else if ("query".equals(op) || "queryTotalMoney".equals(op) || request.getAttribute("export") != null) {
            String as;
            int n;
            int n2;
            String[] stringArray;
            String[] a1;
            String groupby = request.getParameter("groupby");
            String tran_area_nos = request.getParameter("tran_area_no");
            String host_nos = request.getParameter("host_no");
            String operate_user_codes = request.getParameter("operate_user_code");
            String passport_type_nos = request.getParameter("passport_type_no");
            String charge_orgs = request.getParameter("charge_org");
            String pay_scenes = request.getParameter("pay_scene");
            String pay_methods = request.getParameter("pay_method");
            String car_type_nos = request.getParameter("car_type_no");
            String service_types = request.getParameter("service_type");
            String plate_number = request.getParameter("plate_number");
            String start_tran_time = request.getParameter("start_tran_time");
            String end_tran_time = request.getParameter("end_tran_time");
            String start_tran_money = request.getParameter("start_tran_money");
            String end_tran_money = request.getParameter("end_tran_money");
            if (groupby != null && groupby.length() > 0) {
                groupby = groupby.replaceAll("'", "");
            }
            String tableName = commonDaoService.getTableName(CarparkTransaction.class);
            SearchParam sp = new SearchParam(tableName);
            if (service_types != null && (service_types = service_types.trim()).length() > 0) {
                a1 = service_types.split(",");
                if (a1.length == 1) {
                    sp.addEQ("service_type", (Object)Integer.valueOf(a1[0]));
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("service_type", (Object)Integer.valueOf(as));
                        ++n;
                    }
                }
            } else {
                sp.addINList("service_type", (Object[])new Integer[]{0, 1});
            }
            if (plate_number != null && (plate_number = plate_number.trim()).length() > 0) {
                String v2 = plate_number.toUpperCase();
                v2 = v2.replaceAll("\u3000", "");
                v2 = v2.replaceAll(" ", "");
                if ((v2 = v2.replaceAll("I", "1")).length() > 0) {
                    sp.addLike("plate_number", v2);
                }
            }
            if (pay_methods != null && (pay_methods = pay_methods.trim()).length() > 0) {
                a1 = pay_methods.split(",");
                if (a1.length == 1) {
                    sp.addEQ("pay_method", (Object)Integer.valueOf(a1[0]));
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("pay_method", (Object)Integer.valueOf(as));
                        ++n;
                    }
                }
            } else {
                sp.addNotEQ("pay_method", (Object)1);
            }
            if (pay_scenes != null && (pay_scenes = pay_scenes.trim()).length() > 0) {
                a1 = pay_scenes.split(",");
                if (a1.length == 1) {
                    sp.addEQ("pay_scene", (Object)Integer.valueOf(a1[0]));
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("pay_scene", (Object)Integer.valueOf(as));
                        ++n;
                    }
                }
            }
            if (charge_orgs != null && (charge_orgs = charge_orgs.trim()).length() > 0) {
                a1 = charge_orgs.split(",");
                if (a1.length == 1) {
                    sp.addEQ("charge_org", (Object)Integer.valueOf(a1[0]));
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("charge_org", (Object)Integer.valueOf(as));
                        ++n;
                    }
                }
            }
            if (tran_area_nos != null && (tran_area_nos = tran_area_nos.trim()).length() > 0) {
                a1 = tran_area_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("tran_area_no", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("tran_area_no", (Object)as);
                        ++n;
                    }
                }
            }
            if (host_nos != null && (host_nos = host_nos.trim()).length() > 0) {
                a1 = host_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("host_no", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("host_no", (Object)as);
                        ++n;
                    }
                }
            }
            if (operate_user_codes != null && (operate_user_codes = operate_user_codes.trim()).length() > 0) {
                a1 = operate_user_codes.split(",");
                if (a1.length == 1) {
                    sp.addEQ("operate_user_code", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("operate_user_code", (Object)as);
                        ++n;
                    }
                }
            }
            if (passport_type_nos != null && (passport_type_nos = passport_type_nos.trim()).length() > 0) {
                a1 = passport_type_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("passport_type_no", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("passport_type_no", (Object)as);
                        ++n;
                    }
                }
            }
            if (car_type_nos != null && (car_type_nos = car_type_nos.trim()).length() > 0) {
                a1 = car_type_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("car_type_no", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("car_type_no", (Object)as);
                        ++n;
                    }
                }
            }
            if (start_tran_time != null && (start_tran_time = start_tran_time.trim()).length() > 0) {
                sp.addGTE("tran_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(start_tran_time));
            }
            if (end_tran_time != null && (end_tran_time = end_tran_time.trim()).length() > 0) {
                sp.addLTE("tran_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(end_tran_time));
            }
            try {
                if (start_tran_money != null && (start_tran_money = start_tran_money.trim()).length() > 0) {
                    BigDecimal tranMoneyBegin = new BigDecimal(start_tran_money).setScale(2, 4);
                    sp.addGTE("tran_money", (Object)tranMoneyBegin);
                }
            }
            catch (Exception tranMoneyBegin) {
                // empty catch block
            }
            try {
                if (end_tran_money != null && (end_tran_money = end_tran_money.trim()).length() > 0) {
                    BigDecimal tranMoneyEnd = new BigDecimal(end_tran_money).setScale(2, 4);
                    sp.addLTE("tran_money", (Object)tranMoneyEnd);
                }
            }
            catch (Exception tranMoneyEnd) {
                // empty catch block
            }
            if ("queryTotalMoney".equals(op)) {
                BigDecimal money;
                String name1;
                LinkedList headList = new LinkedList();
                LinkedList<Cell> leftList = new LinkedList<Cell>();
                ArrayList rList = new ArrayList();
                LinkedHashMap<String, Cell> dataMap = new LinkedHashMap<String, Cell>();
                if (groupby != null && groupby.length() > 0) {
                    Object t;
                    String value;
                    int n3;
                    int n4;
                    Object object;
                    ArrayList<Cell> celllist;
                    sp.setQueryFields(new String[]{groupby, "SUM(tran_money) AS money"});
                    sp.setGoupbySql(groupby);
                    ArrayList hList = new ArrayList();
                    if (groupby.indexOf("pay_method") != -1) {
                        celllist = new ArrayList<Cell>();
                        if (pay_methods != null && pay_methods.length() > 0) {
                            String[] stringArray2 = pay_methods.split(",");
                            object = stringArray2;
                            n4 = stringArray2.length;
                            n3 = 0;
                            while (n3 < n4) {
                                String pay_method = object[n3];
                                celllist.add(new Cell(pay_method, "pay_method", payMethodMap.get(Integer.valueOf(pay_method)), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (Map.Entry entry : payMethodMap.entrySet()) {
                                celllist.add(new Cell(((Integer)entry.getKey()).toString(), "pay_method", entry.getValue(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("service_type") != -1) {
                        celllist = new ArrayList();
                        if (service_types != null && service_types.length() > 0) {
                            String[] stringArray3 = service_types.split(",");
                            object = stringArray3;
                            n4 = stringArray3.length;
                            n3 = 0;
                            while (n3 < n4) {
                                String service_type = object[n3];
                                value = "";
                                for (KeyValueEntry keyValueEntry : serviceTypeList) {
                                    if (!((Integer)keyValueEntry.getKey()).toString().equals(service_type)) continue;
                                    value = (String)keyValueEntry.getValue();
                                    break;
                                }
                                celllist.add(new Cell(service_type, "service_type", value, 1, 1));
                                ++n3;
                            }
                        } else {
                            for (KeyValueEntry keyValueEntry : serviceTypeList) {
                                celllist.add(new Cell(((Integer)keyValueEntry.getKey()).toString(), "service_type", keyValueEntry.getValue(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("pay_scene") != -1) {
                        celllist = new ArrayList();
                        if (pay_scenes != null && pay_scenes.length() > 0) {
                            String[] stringArray4 = pay_scenes.split(",");
                            object = stringArray4;
                            n4 = stringArray4.length;
                            n3 = 0;
                            while (n3 < n4) {
                                String pay_scene = object[n3];
                                celllist.add(new Cell(pay_scene, "pay_scene", paySceneMap.get(Integer.valueOf(pay_scene)), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (Map.Entry<Integer, String> entry : paySceneMap.entrySet()) {
                                celllist.add(new Cell(entry.getKey().toString(), "pay_scene", entry.getValue(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("car_type_no") != -1) {
                        celllist = new ArrayList();
                        if (car_type_nos != null && car_type_nos.length() > 0) {
                            String[] stringArray5 = car_type_nos.split(",");
                            object = stringArray5;
                            n4 = stringArray5.length;
                            n3 = 0;
                            while (n3 < n4) {
                                Object car_type_no;
                                t = carTypeMap.get(car_type_no = object[n3]);
                                celllist.add(new Cell((String)car_type_no, "car_type_no", t == null ? "" : ((CarparkCarType)t).getCar_type_name(), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (CarparkCarType carparkCarType : carTypeMap.values()) {
                                celllist.add(new Cell(carparkCarType.getCar_type_no(), "car_type_no", carparkCarType.getCar_type_name(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("passport_type_no") != -1) {
                        celllist = new ArrayList();
                        if (passport_type_nos != null && passport_type_nos.length() > 0) {
                            String[] stringArray6 = passport_type_nos.split(",");
                            object = stringArray6;
                            n4 = stringArray6.length;
                            n3 = 0;
                            while (n3 < n4) {
                                Object passport_type_no;
                                t = passportTypeMap.get(passport_type_no = object[n3]);
                                celllist.add(new Cell((String)passport_type_no, "passport_type_no", t == null ? "" : ((CarparkPassportType)t).getPassport_type_name(), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (CarparkPassportType carparkPassportType : passportTypeMap.values()) {
                                celllist.add(new Cell(carparkPassportType.getPassport_type_no(), "passport_type_no", carparkPassportType.getPassport_type_name(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (hList.size() > 1) {
                        int i = 1;
                        while (i < hList.size()) {
                            List list = (List)hList.get(i);
                            for (Cell cell : list) {
                                cell.setColspan(this.getSizecount(hList, i));
                            }
                            ++i;
                        }
                    }
                    if (!hList.isEmpty()) {
                        void var42_85;
                        LinkedList<Cell> parentList = null;
                        int n5 = hList.size() - 1;
                        while (var42_85 >= 0) {
                            if (var42_85 == hList.size() - 1) {
                                headList.add(new LinkedList((Collection)hList.get((int)var42_85)));
                                parentList = (List)hList.get((int)var42_85);
                            } else {
                                LinkedList<Cell> newList = new LinkedList<Cell>();
                                List list = (List)hList.get((int)var42_85);
                                for (Cell parent : parentList) {
                                    for (Cell c : list) {
                                        newList.add(new Cell(String.valueOf(parent.getKey()) + "," + c.getKey(), String.valueOf(parent.getName()) + "," + c.getName(), c.getValue(), c.getRowspan(), c.getColspan()));
                                    }
                                }
                                parentList = newList;
                                headList.add(newList);
                            }
                            --var42_85;
                        }
                    }
                    if (groupby.indexOf("operate_user_code") != -1) {
                        ArrayList<Cell> celllist2 = new ArrayList<Cell>();
                        if (operate_user_codes != null && operate_user_codes.length() > 0) {
                            String[] stringArray7 = operate_user_codes.split(",");
                            object = stringArray7;
                            int parent = stringArray7.length;
                            int list = 0;
                            while (list < parent) {
                                Object operate_user_code = object[list];
                                value = "";
                                for (KeyValueEntry keyValueEntry : userList) {
                                    if (!((String)keyValueEntry.getKey()).equals(operate_user_code)) continue;
                                    value = (String)keyValueEntry.getValue();
                                    break;
                                }
                                celllist2.add(new Cell((String)operate_user_code, "operate_user_code", value, 1, 1));
                                ++list;
                            }
                        } else {
                            for (KeyValueEntry keyValueEntry : userList) {
                                celllist2.add(new Cell((String)keyValueEntry.getKey(), "operate_user_code", keyValueEntry.getValue(), 1, 1));
                            }
                        }
                        rList.add(celllist2);
                    }
                    if (groupby.indexOf("host_no") != -1) {
                        ArrayList<Cell> celllist3 = new ArrayList<Cell>();
                        if (host_nos != null && host_nos.length() > 0) {
                            String[] stringArray8 = host_nos.split(",");
                            object = stringArray8;
                            int parent = stringArray8.length;
                            int list = 0;
                            while (list < parent) {
                                Object host_no;
                                t = hostMap.get(host_no = object[list]);
                                celllist3.add(new Cell((String)host_no, "host_no", t == null ? "" : ((CarparkHost)t).getHost_name(), 1, 1));
                                ++list;
                            }
                        } else {
                            for (CarparkHost carparkHost : hostMap.values()) {
                                celllist3.add(new Cell(carparkHost.getHost_no(), "host_no", carparkHost.getHost_name(), 1, 1));
                            }
                        }
                        rList.add(celllist3);
                    }
                    if (groupby.indexOf("tran_area_no") != -1) {
                        ArrayList<Cell> celllist4 = new ArrayList<Cell>();
                        if (tran_area_nos != null && tran_area_nos.length() > 0) {
                            String[] stringArray9 = tran_area_nos.split(",");
                            object = stringArray9;
                            int parent = stringArray9.length;
                            int list = 0;
                            while (list < parent) {
                                Object tran_area_no = object[list];
                                value = "";
                                for (CarparkArea carparkArea : outAreaList) {
                                    if (!carparkArea.getArea_no().equals(tran_area_no)) continue;
                                    value = carparkArea.getArea_name();
                                    break;
                                }
                                celllist4.add(new Cell((String)tran_area_no, "tran_area_no", value, 1, 1));
                                ++list;
                            }
                        } else {
                            for (CarparkArea carparkArea : outAreaList) {
                                celllist4.add(new Cell(carparkArea.getArea_no(), "tran_area_no", carparkArea.getArea_name(), 1, 1));
                            }
                        }
                        rList.add(celllist4);
                    }
                    if (groupby.indexOf("charge_org") != -1) {
                        ArrayList<Cell> celllist5 = new ArrayList<Cell>();
                        if (charge_orgs != null && charge_orgs.length() > 0) {
                            String[] stringArray10 = charge_orgs.split(",");
                            object = stringArray10;
                            int parent = stringArray10.length;
                            int list = 0;
                            while (list < parent) {
                                Object charge_org = object[list];
                                celllist5.add(new Cell((String)charge_org, "charge_org", chargeOrgMap.get(Integer.valueOf((String)charge_org)), 1, 1));
                                ++list;
                            }
                        } else {
                            for (Map.Entry<Integer, String> entry : chargeOrgMap.entrySet()) {
                                celllist5.add(new Cell(entry.getKey().toString(), "charge_org", entry.getValue(), 1, 1));
                            }
                        }
                        rList.add(celllist5);
                    }
                    if (rList.size() > 1) {
                        int i = 1;
                        while (i < rList.size()) {
                            List list = (List)rList.get(i);
                            for (Cell cell : list) {
                                cell.setRowspan(this.getSizecount(rList, i));
                            }
                            ++i;
                        }
                    }
                    if (!rList.isEmpty()) {
                        void var42_96;
                        List slist = (List)rList.get(0);
                        boolean bl = true;
                        while (var42_96 < rList.size()) {
                            List s1 = (List)rList.get((int)var42_96);
                            for (Cell c : s1) {
                                c.setCellList(slist);
                            }
                            slist = s1;
                            ++var42_96;
                        }
                        leftList.addAll(slist);
                    }
                } else {
                    sp.setQueryFields(new String[]{"SUM(tran_money) AS money"});
                }
                String RIGHT_TOTAL_TITLE = "rightTotal";
                String BOTTOM_TOTAL_TITLE = "bottomTotal";
                String string = "0.00";
                Cell htotalCell = new Cell(RIGHT_TOTAL_TITLE, "", "\u603b\u8ba1", headList.size() < 1 ? 1 : headList.size(), 1);
                if (!headList.isEmpty()) {
                    ((LinkedList)headList.get(0)).add(htotalCell);
                } else {
                    LinkedList<Cell> c1 = new LinkedList<Cell>();
                    c1.add(htotalCell);
                    headList.add(c1);
                }
                String DATA_NAME = "DATA";
                LinkedList<List<Cell>> dataList = new LinkedList<List<Cell>>();
                LinkedList<Cell> enList = new LinkedList<Cell>();
                enList.addAll((Collection)headList.get(headList.size() - 1));
                if (headList.size() > 1) {
                    enList.add(htotalCell);
                }
                if (!leftList.isEmpty()) {
                    this.setDataList(dataList, leftList, new LinkedList<Cell>(), new LinkedList<Cell>());
                    Cell bottom = new Cell(BOTTOM_TOTAL_TITLE, "", "\u603b\u8ba1", 1, rList.size());
                    LinkedList<Cell> linkedList = new LinkedList<Cell>();
                    linkedList.add(bottom);
                    dataList.add(linkedList);
                    for (List list : dataList) {
                        Cell lastCell = (Cell)list.get(list.size() - 1);
                        int cIndex = 0;
                        for (Cell c1 : enList) {
                            String key1 = lastCell.getKey();
                            name1 = lastCell.getName();
                            String key2 = c1.getKey();
                            String name2 = c1.getName();
                            if (name1.length() == 0) {
                                Cell ct = new Cell(String.valueOf(key2) + "," + name2, "DATA" + cIndex, string, 1, 1);
                                list.add(ct);
                            } else {
                                String key = key1;
                                String name = name1;
                                if (name2.length() > 0) {
                                    key = String.valueOf(key) + "," + key2;
                                    name = String.valueOf(name) + "," + name2;
                                }
                                String newKey = this.getMapKey(name, key);
                                Cell dataCell = new Cell(newKey, "DATA" + cIndex, string, 1, 1);
                                list.add(dataCell);
                                dataMap.put(newKey, dataCell);
                            }
                            ++cIndex;
                        }
                    }
                    Cell cell = new Cell("cat", "", "\u7c7b\u578b/\u7c7b\u522b", headList.size(), rList.size());
                    ((LinkedList)headList.get(0)).addFirst(cell);
                } else {
                    LinkedList<Cell> dlist = new LinkedList<Cell>();
                    boolean bl = false;
                    for (Cell c1 : enList) {
                        void var48_135;
                        String key = c1.getKey();
                        String name = c1.getName();
                        if (name.length() > 0) {
                            String newKey = this.getMapKey(name, key);
                            Cell cell = new Cell(newKey, "DATA" + (int)var48_135, string, 1, 1);
                            dlist.add(cell);
                            dataMap.put(newKey, cell);
                        } else {
                            Cell ct = new Cell("H_TOTAL" + (int)var48_135, "DATA" + (int)var48_135, string, 1, 1);
                            dlist.add(ct);
                            dataMap.put("H_TOTAL" + (int)var48_135, ct);
                        }
                        ++var48_135;
                    }
                    dataList.add(dlist);
                }
                List dbList = commonDaoService.selectList(sp, null);
                if (!dbList.isEmpty()) {
                    Object var48_136 = null;
                    TreeMap<String, String> teeMap = new TreeMap<String, String>();
                    for (Map map : dbList) {
                        BigDecimal money2;
                        if (groupby != null && groupby.length() > 0) {
                            void var54_165;
                            void var48_137;
                            if (var48_137 == null) {
                                String[] stringArray11 = groupby.split(",");
                            }
                            if ((money = (BigDecimal)map.get("money")) == null || money.doubleValue() == 0.0) continue;
                            name1 = var48_137;
                            int key1 = ((void)name1).length;
                            boolean bl = false;
                            while (var54_165 < key1) {
                                String s1 = name1[var54_165];
                                Object v = map.get(s1);
                                if (v == null) {
                                    v = "";
                                }
                                teeMap.put(s1, v.toString());
                                ++var54_165;
                            }
                            StringBuilder sbr = new StringBuilder(128);
                            for (Map.Entry entry : teeMap.entrySet()) {
                                if (sbr.length() > 0) {
                                    sbr.append(';');
                                }
                                sbr.append((String)entry.getKey()).append('=').append((String)entry.getValue());
                            }
                            String string2 = sbr.toString();
                            Cell cell = (Cell)dataMap.get(string2);
                            if (cell == null) continue;
                            cell.setValue(money.toString());
                            continue;
                        }
                        Cell cl = (Cell)dataMap.get("H_TOTAL0");
                        if (cl == null || (money2 = (BigDecimal)map.get("money")) == null) continue;
                        cl.setValue(money2.toString());
                    }
                }
                boolean bl = false;
                HashMap<String, BigDecimal> mo = new HashMap<String, BigDecimal>();
                for (List list : dataList) {
                    void var48_140;
                    BigDecimal m1;
                    money = Constants.MONEY_ZERO;
                    int cIndex = 0;
                    for (Cell cell : list) {
                        if (cell.getName() != null && cell.getName().startsWith("DATA")) {
                            BigDecimal m2;
                            m1 = new BigDecimal(cell.getValue().toString());
                            money = money.add(m1);
                            if (cIndex == list.size() - 1) {
                                cell.setValue(money.toString());
                            }
                            if ((m2 = (BigDecimal)mo.get(cell.getName())) == null) {
                                m2 = Constants.MONEY_ZERO;
                            }
                            m2 = m2.add(m1);
                            mo.put(cell.getName(), m2);
                        }
                        ++cIndex;
                    }
                    if (var48_140 == dataList.size() - 1) {
                        for (Cell cell : list) {
                            BigDecimal b;
                            if (cell.getName() == null || !cell.getName().startsWith("DATA") || (b = (BigDecimal)mo.get(cell.getName())) == null) continue;
                            cell.setValue(b.toString());
                        }
                        cIndex = 0;
                        money = Constants.MONEY_ZERO;
                        for (Cell cell : list) {
                            if (cell.getName() != null && cell.getName().startsWith("DATA")) {
                                m1 = new BigDecimal(cell.getValue().toString());
                                money = money.add(m1);
                                if (cIndex == list.size() - 1) {
                                    cell.setValue(money.toString());
                                }
                            }
                            ++cIndex;
                        }
                    }
                    ++var48_140;
                }
                request.setAttribute("dataList", dataList);
                request.setAttribute("headList", headList);
                WebUtil.dispathTemplatePage("report/tempFeeStatistics", request, response);
            } else if ("query".equals(op)) {
                String sortOrder = request.getParameter("sortOrder");
                String sortName = request.getParameter("sortName");
                if (sortName != null && (sortName = sortName.trim()).length() > 0 && sortOrder != null && (sortOrder = sortOrder.trim()).length() > 0) {
                    sp.setOrder_by((String.valueOf(sortName) + " " + sortOrder).replaceAll("'", ""));
                } else {
                    sp.setOrder_by("tran_time");
                }
                Pagination p = WebUtil.getPagination(request);
                List dataList = commonDaoService.selectList(sp, p);
                ArrayList<Map> resultList = new ArrayList<Map>(dataList == null ? 0 : dataList.size());
                if (dataList != null && !dataList.isEmpty()) {
                    for (Map data : dataList) {
                        String string;
                        String string3;
                        String string4;
                        Integer pay_scene1 = (Integer)data.get("pay_scene");
                        Integer pay_method1 = (Integer)data.get("pay_method");
                        Integer charge_org1 = (Integer)data.get("charge_org");
                        Integer invoice_status = (Integer)data.get("invoice_status");
                        boolean isonlinepay = pay_method1 != null && pay_method1 != 0 && pay_method1 != 1 && pay_method1 != 7 && pay_scene1 != null && pay_scene1 > 1;
                        data.put("onlinepay", isonlinepay ? Constants.YES_STR : Constants.NO_STR);
                        if (invoice_status == null) {
                            data.put("invoice_status", 0);
                        }
                        if ((string4 = paySceneMap.get(pay_scene1)) != null && string4.length() > 0) {
                            data.put("pay_scene", string4);
                        }
                        if ((string3 = (String)payMethodMap.get(pay_method1)) != null && string3.length() > 0) {
                            data.put("pay_method", string3);
                        }
                        if ((string = chargeOrgMap.get(charge_org1)) != null && string.length() > 0) {
                            data.put("charge_org", string);
                        }
                        resultList.add(JavaBeanUtil.toStringMap((Object)data));
                    }
                }
                HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
                resMap.put("rows", resultList);
                resMap.put("total", Long.valueOf(p.getRecordsCount()));
                WebUtil.printFinshJson(response, GsonBuilder.create().toJson(resMap));
            } else {
                LinkedHashMap<String, String> headAtrrMap = new LinkedHashMap<String, String>();
                headAtrrMap.put("plate_number", "\u6536\u8d39\u8f66\u724c");
                headAtrrMap.put("passport_type_name", "\u8f66\u724c\u7c7b\u578b");
                headAtrrMap.put("car_type_name", "\u8f66\u8f86\u7c7b\u578b");
                headAtrrMap.put("tran_area_name", "\u6536\u8d39\u573a\u533a");
                headAtrrMap.put("enter_time", "\u5165\u573a\u65f6\u95f4");
                headAtrrMap.put("tran_time", "\u7f34\u8d39\u65f6\u95f4");
                headAtrrMap.put("tran_money", "\u4ea4\u6613\u91d1\u989d");
                headAtrrMap.put("pay_method", "\u652f\u4ed8\u65b9\u5f0f");
                headAtrrMap.put("pay_scene", "\u652f\u4ed8\u573a\u666f");
                headAtrrMap.put("charge_org", "\u6536\u8d39\u65b9");
                headAtrrMap.put("host_name", "\u6536\u8d39\u7535\u8111");
                headAtrrMap.put("operate_user_name", "\u6536\u8d39\u5458");
                headAtrrMap.put("tran_des", "\u6536\u8d39\u63cf\u8ff0");
                ExportService exportService = (ExportService)ServiceUtil.getServiceContext().getService(ExportService.class);
                response.setContentType("text/plain; charset=GBK");
                response.setCharacterEncoding("GBK");
                SimpleDateFormat df11 = new SimpleDateFormat("yyyyMMddHHmmss");
                String f = "tempPayRecord_";
                response.addHeader("Content-Disposition", "attachment;filename=" + f + df11.format(new java.util.Date()) + ".csv");
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setDateHeader("Expires", 0L);
                try (PrintWriter out = response.getWriter();){
                    exportService.exportTempPayRecordCsv(sp, headAtrrMap, out);
                }
            }
        }
    }

    private String getMapKey(String k, String v) {
        TreeMap<String, String> t = new TreeMap<String, String>();
        String[] a = k.split(",");
        String[] b = v.split(",");
        int i = 0;
        while (i < a.length) {
            t.put(a[i], b[i]);
            ++i;
        }
        StringBuilder sbr = new StringBuilder(128);
        for (Map.Entry e : t.entrySet()) {
            if (sbr.length() > 0) {
                sbr.append(';');
            }
            sbr.append((String)e.getKey()).append('=').append((String)e.getValue());
        }
        String newKey = sbr.toString();
        return newKey;
    }

    private void setDataList(List<List<Cell>> dataList, List<Cell> cellList, LinkedList<Cell> rowList, LinkedList<Cell> vlsit) {
        for (Cell cell : cellList) {
            if (cell.getCellList() == null || cell.getCellList().isEmpty()) {
                Cell l;
                LinkedList<Cell> list = new LinkedList<Cell>();
                dataList.add(list);
                while ((l = rowList.poll()) != null) {
                    list.add(new Cell(l.getKey(), l.getName(), l.getValue(), l.getRowspan(), l.getColspan()));
                }
                l = cell;
                StringBuilder parentKey = new StringBuilder(64);
                StringBuilder parentName = new StringBuilder(64);
                if (!vlsit.isEmpty()) {
                    for (Cell c : vlsit) {
                        if (parentKey.length() > 0) {
                            parentKey.append(',');
                            parentName.append(',');
                        }
                        parentKey.append(c.getKey());
                        parentName.append(c.getName());
                    }
                }
                if (parentKey.length() > 0) {
                    parentKey.append(',');
                    parentName.append(',');
                }
                parentKey.append(l.getKey());
                parentName.append(l.getName());
                list.add(new Cell(parentKey.toString(), parentName.toString(), l.getValue(), l.getRowspan(), l.getColspan()));
                continue;
            }
            rowList.offer(cell);
            vlsit.addLast(cell);
            this.setDataList(dataList, cell.getCellList(), rowList, vlsit);
            vlsit.removeLast();
        }
    }

    private int getSizecount(List<?> list, int index) {
        int count = 1;
        int i = 0;
        while (i < index) {
            count *= ((List)list.get(i)).size();
            ++i;
        }
        return count;
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u6536\u8d39\u7edf\u8ba1-\u4e34\u505c\u7f34\u8d39\u7edf\u8ba1\u5bfc\u51fa")
    @Path(value="/exportTempFeeStatistics.action")
    public void exportTempFeeStatistics(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("export", (Object)Boolean.TRUE);
        this.tempFeeStatistics(request, response);
    }

    /*
     * WARNING - void declaration
     */
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u6536\u8d39\u7edf\u8ba1-\u6708\u5361\u7f34\u8d39\u7edf\u8ba1")
    @LeftMenu(name="\u6708\u5361\u7f34\u8d39\u7edf\u8ba1", parent_name="\u6536\u8d39\u7edf\u8ba1", order=322)
    @Path(value="/mothCardFeeStatistics.action")
    public void mothCardFeeStatistics(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        Map<String, CarparkHost> hostMap9 = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        LinkedHashMap<String, CarparkHost> hostMap = new LinkedHashMap<String, CarparkHost>();
        if (hostMap9 != null) {
            hostMap.putAll(hostMap9);
        }
        CarparkHost chost = new CarparkHost();
        chost.setHost_no("CLOUD_HOST_NO");
        chost.setId(-11111L);
        chost.setHost_name("\u4e91\u7aef\u4e3b\u673a");
        hostMap.put("CLOUD_HOST_NO", chost);
        request.setAttribute("hostMap", hostMap);
        Map<Integer, String> payMethodMapCache = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap();
        LinkedHashMap<Integer, String> payMethodMap = new LinkedHashMap<Integer, String>();
        for (Map.Entry<Integer, String> m : payMethodMapCache.entrySet()) {
            if (m.getKey() == 1 || m.getKey() == 6) continue;
            payMethodMap.put(m.getKey(), m.getValue());
        }
        request.setAttribute("payMethodMap", payMethodMap);
        Map<Integer, String> chargeOrgMap = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap();
        request.setAttribute("chargeOrgMap", chargeOrgMap);
        Map<Integer, String> paySceneMap0 = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap();
        LinkedHashMap<Integer, String> paySceneMap = new LinkedHashMap<Integer, String>();
        for (Map.Entry<Integer, String> e : paySceneMap0.entrySet()) {
            if (e.getKey() == 2 || e.getKey() == 5 || e.getKey() == 4) continue;
            paySceneMap.put(e.getKey(), e.getValue());
        }
        request.setAttribute("paySceneMap", paySceneMap);
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        List userList0 = commonDaoService.selectList(new SearchParam().addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("role_no DESC,user_code"), CarparkUser.class, null);
        ArrayList<KeyValueEntry> userList = new ArrayList<KeyValueEntry>(userList0.size() + 1);
        for (CarparkUser u : userList0) {
            userList.add(new KeyValueEntry((Object)u.getUser_code(), (Object)u.getUser_name()));
        }
        userList.add(new KeyValueEntry((Object)"USER_SELF", (Object)"\u81ea\u52a9\u7f34\u8d39"));
        userList.add(new KeyValueEntry((Object)"USER_CLOUD_CODE", (Object)"\u4e91\u7aef\u7528\u6237"));
        request.setAttribute("userList", userList);
        ArrayList<KeyValueEntry> serviceTypeList = new ArrayList<KeyValueEntry>(2);
        serviceTypeList.add(new KeyValueEntry((Object)2, (Object)"\u6708\u5361\u529e\u7406"));
        serviceTypeList.add(new KeyValueEntry((Object)3, (Object)"\u6708\u5361\u5ef6\u671f"));
        serviceTypeList.add(new KeyValueEntry((Object)4, (Object)"\u6708\u5361\u9000\u8d39"));
        request.setAttribute("serviceTypeList", serviceTypeList);
        Map<String, CarparkPassportType> passportTypeMap0 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        LinkedHashMap<String, CarparkPassportType> passportTypeMap = new LinkedHashMap<String, CarparkPassportType>();
        if (passportTypeMap0 != null) {
            for (Map.Entry<String, CarparkPassportType> m : passportTypeMap0.entrySet()) {
                if (m.getValue().getPass_type() != 2) continue;
                passportTypeMap.put(m.getKey(), m.getValue());
            }
        }
        request.setAttribute("passportTypeMap", passportTypeMap);
        Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        if (carTypeMap != null) {
            request.setAttribute("carTypeMap", carTypeMap);
        }
        if (op == null) {
            Calendar cl = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            request.setAttribute("endTime", (Object)df.format(cl.getTime()));
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            cl.set(14, 0);
            request.setAttribute("startTime", (Object)df.format(cl.getTime()));
            WebUtil.showMainContentWithHead("\u6708\u5361\u7f34\u8d39\u7edf\u8ba1", "report/monthFeeStatistics", request, response);
        } else if ("query".equals(op) || "queryTotalMoney".equals(op) || request.getAttribute("export") != null) {
            String as;
            int n;
            int n2;
            String[] stringArray;
            String[] a1;
            String groupby = request.getParameter("groupby");
            String host_nos = request.getParameter("host_no");
            String operate_user_codes = request.getParameter("operate_user_code");
            String passport_type_nos = request.getParameter("passport_type_no");
            String charge_orgs = request.getParameter("charge_org");
            String pay_scenes = request.getParameter("pay_scene");
            String pay_methods = request.getParameter("pay_method");
            String car_type_nos = request.getParameter("car_type_no");
            String service_types = request.getParameter("service_type");
            String plate_number = request.getParameter("plate_number");
            String start_tran_time = request.getParameter("start_tran_time");
            String end_tran_time = request.getParameter("end_tran_time");
            String tran_user_name = request.getParameter("tran_user_name");
            String start_tran_money = request.getParameter("start_tran_money");
            String end_tran_money = request.getParameter("end_tran_money");
            if (groupby != null && groupby.length() > 0) {
                groupby = groupby.replaceAll("'", "");
            }
            String tableName = commonDaoService.getTableName(CarparkTransaction.class);
            SearchParam sp = new SearchParam(tableName);
            if (service_types != null && (service_types = service_types.trim()).length() > 0) {
                a1 = service_types.split(",");
                if (a1.length == 1) {
                    sp.addEQ("service_type", (Object)Integer.valueOf(a1[0]));
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("service_type", (Object)Integer.valueOf(as));
                        ++n;
                    }
                }
            } else {
                sp.addINList("service_type", (Object[])new Integer[]{2, 3, 4});
            }
            if (plate_number != null && (plate_number = plate_number.trim()).length() > 0) {
                String v2 = plate_number.toUpperCase();
                v2 = v2.replaceAll("\u3000", "");
                v2 = v2.replaceAll(" ", "");
                if ((v2 = v2.replaceAll("I", "1")).length() > 0) {
                    sp.addLike("plate_number", v2);
                }
            }
            if (tran_user_name != null && (tran_user_name = tran_user_name.trim()).length() > 0) {
                sp.addLike("tran_user_name", tran_user_name);
            }
            try {
                if (start_tran_money != null && (start_tran_money = start_tran_money.trim()).length() > 0) {
                    BigDecimal tranMoneyBegin = new BigDecimal(start_tran_money).setScale(2, 4);
                    sp.addGTE("tran_money", (Object)tranMoneyBegin);
                }
            }
            catch (Exception tranMoneyBegin) {
                // empty catch block
            }
            try {
                if (end_tran_money != null && (end_tran_money = end_tran_money.trim()).length() > 0) {
                    BigDecimal tranMoneyEnd = new BigDecimal(end_tran_money).setScale(2, 4);
                    sp.addLTE("tran_money", (Object)tranMoneyEnd);
                }
            }
            catch (Exception tranMoneyEnd) {
                // empty catch block
            }
            if (pay_methods != null && (pay_methods = pay_methods.trim()).length() > 0) {
                a1 = pay_methods.split(",");
                if (a1.length == 1) {
                    sp.addEQ("pay_method", (Object)Integer.valueOf(a1[0]));
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("pay_method", (Object)Integer.valueOf(as));
                        ++n;
                    }
                }
            } else {
                sp.addNotEQ("pay_method", (Object)1);
            }
            if (pay_scenes != null && (pay_scenes = pay_scenes.trim()).length() > 0) {
                a1 = pay_scenes.split(",");
                if (a1.length == 1) {
                    sp.addEQ("pay_scene", (Object)Integer.valueOf(a1[0]));
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("pay_scene", (Object)Integer.valueOf(as));
                        ++n;
                    }
                }
            }
            if (charge_orgs != null && (charge_orgs = charge_orgs.trim()).length() > 0) {
                a1 = charge_orgs.split(",");
                if (a1.length == 1) {
                    sp.addEQ("charge_org", (Object)Integer.valueOf(a1[0]));
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("charge_org", (Object)Integer.valueOf(as));
                        ++n;
                    }
                }
            }
            if (host_nos != null && (host_nos = host_nos.trim()).length() > 0) {
                a1 = host_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("host_no", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("host_no", (Object)as);
                        ++n;
                    }
                }
            }
            if (operate_user_codes != null && (operate_user_codes = operate_user_codes.trim()).length() > 0) {
                a1 = operate_user_codes.split(",");
                if (a1.length == 1) {
                    sp.addEQ("operate_user_code", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("operate_user_code", (Object)as);
                        ++n;
                    }
                }
            }
            if (passport_type_nos != null && (passport_type_nos = passport_type_nos.trim()).length() > 0) {
                a1 = passport_type_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("passport_type_no", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("passport_type_no", (Object)as);
                        ++n;
                    }
                }
            }
            if (car_type_nos != null && (car_type_nos = car_type_nos.trim()).length() > 0) {
                a1 = car_type_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("car_type_no", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("car_type_no", (Object)as);
                        ++n;
                    }
                }
            }
            if (start_tran_time != null && (start_tran_time = start_tran_time.trim()).length() > 0) {
                sp.addGTE("tran_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(start_tran_time));
            }
            if (end_tran_time != null && (end_tran_time = end_tran_time.trim()).length() > 0) {
                sp.addLTE("tran_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(end_tran_time));
            }
            if ("queryTotalMoney".equals(op)) {
                BigDecimal money;
                String name1;
                LinkedList headList = new LinkedList();
                LinkedList<Cell> leftList = new LinkedList<Cell>();
                ArrayList rList = new ArrayList();
                LinkedHashMap<String, Cell> dataMap = new LinkedHashMap<String, Cell>();
                if (groupby != null && groupby.length() > 0) {
                    Object t;
                    String value;
                    int n3;
                    int n4;
                    Object object;
                    ArrayList<Cell> celllist;
                    sp.setQueryFields(new String[]{groupby, "SUM(tran_money) AS money"});
                    sp.setGoupbySql(groupby);
                    ArrayList hList = new ArrayList();
                    if (groupby.indexOf("pay_method") != -1) {
                        celllist = new ArrayList<Cell>();
                        if (pay_methods != null && pay_methods.length() > 0) {
                            String[] stringArray2 = pay_methods.split(",");
                            object = stringArray2;
                            n4 = stringArray2.length;
                            n3 = 0;
                            while (n3 < n4) {
                                String pay_method = object[n3];
                                celllist.add(new Cell(pay_method, "pay_method", payMethodMap.get(Integer.valueOf(pay_method)), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (Map.Entry entry : payMethodMap.entrySet()) {
                                celllist.add(new Cell(((Integer)entry.getKey()).toString(), "pay_method", entry.getValue(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("service_type") != -1) {
                        celllist = new ArrayList();
                        if (service_types != null && service_types.length() > 0) {
                            String[] stringArray3 = service_types.split(",");
                            object = stringArray3;
                            n4 = stringArray3.length;
                            n3 = 0;
                            while (n3 < n4) {
                                String service_type = object[n3];
                                value = "";
                                for (KeyValueEntry keyValueEntry : serviceTypeList) {
                                    if (!((Integer)keyValueEntry.getKey()).toString().equals(service_type)) continue;
                                    value = (String)keyValueEntry.getValue();
                                    break;
                                }
                                celllist.add(new Cell(service_type, "service_type", value, 1, 1));
                                ++n3;
                            }
                        } else {
                            for (KeyValueEntry keyValueEntry : serviceTypeList) {
                                celllist.add(new Cell(((Integer)keyValueEntry.getKey()).toString(), "service_type", keyValueEntry.getValue(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("pay_scene") != -1) {
                        celllist = new ArrayList();
                        if (pay_scenes != null && pay_scenes.length() > 0) {
                            String[] stringArray4 = pay_scenes.split(",");
                            object = stringArray4;
                            n4 = stringArray4.length;
                            n3 = 0;
                            while (n3 < n4) {
                                String pay_scene = object[n3];
                                celllist.add(new Cell(pay_scene, "pay_scene", paySceneMap.get(Integer.valueOf(pay_scene)), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (Map.Entry entry : paySceneMap.entrySet()) {
                                celllist.add(new Cell(((Integer)entry.getKey()).toString(), "pay_scene", entry.getValue(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("car_type_no") != -1) {
                        celllist = new ArrayList();
                        if (car_type_nos != null && car_type_nos.length() > 0) {
                            String[] stringArray5 = car_type_nos.split(",");
                            object = stringArray5;
                            n4 = stringArray5.length;
                            n3 = 0;
                            while (n3 < n4) {
                                Object car_type_no;
                                t = carTypeMap.get(car_type_no = object[n3]);
                                celllist.add(new Cell((String)car_type_no, "car_type_no", t == null ? "" : ((CarparkCarType)t).getCar_type_name(), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (CarparkCarType carparkCarType : carTypeMap.values()) {
                                celllist.add(new Cell(carparkCarType.getCar_type_no(), "car_type_no", carparkCarType.getCar_type_name(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("passport_type_no") != -1) {
                        celllist = new ArrayList();
                        if (passport_type_nos != null && passport_type_nos.length() > 0) {
                            String[] stringArray6 = passport_type_nos.split(",");
                            object = stringArray6;
                            n4 = stringArray6.length;
                            n3 = 0;
                            while (n3 < n4) {
                                Object passport_type_no;
                                t = (CarparkPassportType)passportTypeMap.get(passport_type_no = object[n3]);
                                celllist.add(new Cell((String)passport_type_no, "passport_type_no", t == null ? "" : ((CarparkPassportType)t).getPassport_type_name(), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (CarparkPassportType carparkPassportType : passportTypeMap.values()) {
                                celllist.add(new Cell(carparkPassportType.getPassport_type_no(), "passport_type_no", carparkPassportType.getPassport_type_name(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (hList.size() > 1) {
                        int i = 1;
                        while (i < hList.size()) {
                            List list = (List)hList.get(i);
                            for (Cell cell : list) {
                                cell.setColspan(this.getSizecount(hList, i));
                            }
                            ++i;
                        }
                    }
                    if (!hList.isEmpty()) {
                        void var44_85;
                        LinkedList<Cell> parentList = null;
                        int n5 = hList.size() - 1;
                        while (var44_85 >= 0) {
                            if (var44_85 == hList.size() - 1) {
                                headList.add(new LinkedList((Collection)hList.get((int)var44_85)));
                                parentList = (List)hList.get((int)var44_85);
                            } else {
                                LinkedList<Cell> newList = new LinkedList<Cell>();
                                List list = (List)hList.get((int)var44_85);
                                for (Cell parent : parentList) {
                                    for (Cell c : list) {
                                        newList.add(new Cell(String.valueOf(parent.getKey()) + "," + c.getKey(), String.valueOf(parent.getName()) + "," + c.getName(), c.getValue(), c.getRowspan(), c.getColspan()));
                                    }
                                }
                                parentList = newList;
                                headList.add(newList);
                            }
                            --var44_85;
                        }
                    }
                    if (groupby.indexOf("operate_user_code") != -1) {
                        ArrayList<Cell> celllist2 = new ArrayList<Cell>();
                        if (operate_user_codes != null && operate_user_codes.length() > 0) {
                            String[] stringArray7 = operate_user_codes.split(",");
                            object = stringArray7;
                            int parent = stringArray7.length;
                            int list = 0;
                            while (list < parent) {
                                Object operate_user_code = object[list];
                                value = "";
                                for (KeyValueEntry keyValueEntry : userList) {
                                    if (!((String)keyValueEntry.getKey()).equals(operate_user_code)) continue;
                                    value = (String)keyValueEntry.getValue();
                                    break;
                                }
                                celllist2.add(new Cell((String)operate_user_code, "operate_user_code", value, 1, 1));
                                ++list;
                            }
                        } else {
                            for (KeyValueEntry keyValueEntry : userList) {
                                celllist2.add(new Cell((String)keyValueEntry.getKey(), "operate_user_code", keyValueEntry.getValue(), 1, 1));
                            }
                        }
                        rList.add(celllist2);
                    }
                    if (groupby.indexOf("host_no") != -1) {
                        ArrayList<Cell> celllist3 = new ArrayList<Cell>();
                        if (host_nos != null && host_nos.length() > 0) {
                            String[] stringArray8 = host_nos.split(",");
                            object = stringArray8;
                            int parent = stringArray8.length;
                            int list = 0;
                            while (list < parent) {
                                Object host_no;
                                t = (CarparkHost)hostMap.get(host_no = object[list]);
                                celllist3.add(new Cell((String)host_no, "host_no", t == null ? "" : ((CarparkHost)t).getHost_name(), 1, 1));
                                ++list;
                            }
                        } else {
                            for (CarparkHost carparkHost : hostMap.values()) {
                                celllist3.add(new Cell(carparkHost.getHost_no(), "host_no", carparkHost.getHost_name(), 1, 1));
                            }
                        }
                        rList.add(celllist3);
                    }
                    if (groupby.indexOf("charge_org") != -1) {
                        ArrayList<Cell> celllist4 = new ArrayList<Cell>();
                        if (charge_orgs != null && charge_orgs.length() > 0) {
                            String[] stringArray9 = charge_orgs.split(",");
                            object = stringArray9;
                            int parent = stringArray9.length;
                            int list = 0;
                            while (list < parent) {
                                Object charge_org = object[list];
                                celllist4.add(new Cell((String)charge_org, "charge_org", chargeOrgMap.get(Integer.valueOf((String)charge_org)), 1, 1));
                                ++list;
                            }
                        } else {
                            for (Map.Entry<Integer, String> entry : chargeOrgMap.entrySet()) {
                                celllist4.add(new Cell(entry.getKey().toString(), "charge_org", entry.getValue(), 1, 1));
                            }
                        }
                        rList.add(celllist4);
                    }
                    if (rList.size() > 1) {
                        int i = 1;
                        while (i < rList.size()) {
                            List list = (List)rList.get(i);
                            for (Cell cell : list) {
                                cell.setRowspan(this.getSizecount(rList, i));
                            }
                            ++i;
                        }
                    }
                    if (!rList.isEmpty()) {
                        void var44_94;
                        List slist = (List)rList.get(0);
                        boolean bl = true;
                        while (var44_94 < rList.size()) {
                            List s1 = (List)rList.get((int)var44_94);
                            for (Cell c : s1) {
                                c.setCellList(slist);
                            }
                            slist = s1;
                            ++var44_94;
                        }
                        leftList.addAll(slist);
                    }
                } else {
                    sp.setQueryFields(new String[]{"SUM(tran_money) AS money"});
                }
                String RIGHT_TOTAL_TITLE = "rightTotal";
                String BOTTOM_TOTAL_TITLE = "bottomTotal";
                String string = "0.00";
                Cell htotalCell = new Cell(RIGHT_TOTAL_TITLE, "", "\u603b\u8ba1", headList.size() < 1 ? 1 : headList.size(), 1);
                if (!headList.isEmpty()) {
                    ((LinkedList)headList.get(0)).add(htotalCell);
                } else {
                    LinkedList<Cell> c1 = new LinkedList<Cell>();
                    c1.add(htotalCell);
                    headList.add(c1);
                }
                String DATA_NAME = "DATA";
                LinkedList<List<Cell>> dataList = new LinkedList<List<Cell>>();
                LinkedList<Cell> enList = new LinkedList<Cell>();
                enList.addAll((Collection)headList.get(headList.size() - 1));
                if (headList.size() > 1) {
                    enList.add(htotalCell);
                }
                if (!leftList.isEmpty()) {
                    this.setDataList(dataList, leftList, new LinkedList<Cell>(), new LinkedList<Cell>());
                    Cell bottom = new Cell(BOTTOM_TOTAL_TITLE, "", "\u603b\u8ba1", 1, rList.size());
                    LinkedList<Cell> linkedList = new LinkedList<Cell>();
                    linkedList.add(bottom);
                    dataList.add(linkedList);
                    for (List list : dataList) {
                        Cell lastCell = (Cell)list.get(list.size() - 1);
                        int cIndex = 0;
                        for (Cell c1 : enList) {
                            String key1 = lastCell.getKey();
                            name1 = lastCell.getName();
                            String key2 = c1.getKey();
                            String name2 = c1.getName();
                            if (name1.length() == 0) {
                                Cell ct = new Cell(String.valueOf(key2) + "," + name2, "DATA" + cIndex, string, 1, 1);
                                list.add(ct);
                            } else {
                                String key = key1;
                                String name = name1;
                                if (name2.length() > 0) {
                                    key = String.valueOf(key) + "," + key2;
                                    name = String.valueOf(name) + "," + name2;
                                }
                                String newKey = this.getMapKey(name, key);
                                Cell dataCell = new Cell(newKey, "DATA" + cIndex, string, 1, 1);
                                list.add(dataCell);
                                dataMap.put(newKey, dataCell);
                            }
                            ++cIndex;
                        }
                    }
                    Cell cell = new Cell("cat", "", "\u7c7b\u578b/\u7c7b\u522b", headList.size(), rList.size());
                    ((LinkedList)headList.get(0)).addFirst(cell);
                } else {
                    LinkedList<Cell> dlist = new LinkedList<Cell>();
                    boolean bl = false;
                    for (Cell c1 : enList) {
                        void var50_130;
                        Iterator key = c1.getKey();
                        String name = c1.getName();
                        if (name.length() > 0) {
                            String newKey = this.getMapKey(name, (String)((Object)key));
                            Cell cell = new Cell(newKey, "DATA" + (int)var50_130, string, 1, 1);
                            dlist.add(cell);
                            dataMap.put(newKey, cell);
                        } else {
                            Cell ct = new Cell("H_TOTAL" + (int)var50_130, "DATA" + (int)var50_130, string, 1, 1);
                            dlist.add(ct);
                            dataMap.put("H_TOTAL" + (int)var50_130, ct);
                        }
                        ++var50_130;
                    }
                    dataList.add(dlist);
                }
                List dbList = commonDaoService.selectList(sp, null);
                if (!dbList.isEmpty()) {
                    Object var50_131 = null;
                    TreeMap<String, String> teeMap = new TreeMap<String, String>();
                    for (Map map : dbList) {
                        BigDecimal money2;
                        if (groupby != null && groupby.length() > 0) {
                            void var56_165;
                            void var50_132;
                            if (var50_132 == null) {
                                String[] stringArray10 = groupby.split(",");
                            }
                            if ((money = (BigDecimal)map.get("money")) == null || money.doubleValue() == 0.0) continue;
                            name1 = var50_132;
                            int key1 = ((void)name1).length;
                            boolean bl = false;
                            while (var56_165 < key1) {
                                String s1 = name1[var56_165];
                                Object v = map.get(s1);
                                if (v == null) {
                                    v = "";
                                }
                                teeMap.put(s1, v.toString());
                                ++var56_165;
                            }
                            StringBuilder sbr = new StringBuilder(128);
                            for (Map.Entry entry : teeMap.entrySet()) {
                                if (sbr.length() > 0) {
                                    sbr.append(';');
                                }
                                sbr.append((String)entry.getKey()).append('=').append((String)entry.getValue());
                            }
                            String string2 = sbr.toString();
                            Cell cell = (Cell)dataMap.get(string2);
                            if (cell == null) continue;
                            cell.setValue(money.toString());
                            continue;
                        }
                        Cell cl = (Cell)dataMap.get("H_TOTAL0");
                        if (cl == null || (money2 = (BigDecimal)map.get("money")) == null) continue;
                        cl.setValue(money2.toString());
                    }
                }
                boolean bl = false;
                HashMap<String, BigDecimal> mo = new HashMap<String, BigDecimal>();
                for (List list : dataList) {
                    void var50_135;
                    BigDecimal m1;
                    money = Constants.MONEY_ZERO;
                    int cIndex = 0;
                    for (Cell cell : list) {
                        if (cell.getName() != null && cell.getName().startsWith("DATA")) {
                            BigDecimal m2;
                            m1 = new BigDecimal(cell.getValue().toString());
                            money = money.add(m1);
                            if (cIndex == list.size() - 1) {
                                cell.setValue(money.toString());
                            }
                            if ((m2 = (BigDecimal)mo.get(cell.getName())) == null) {
                                m2 = Constants.MONEY_ZERO;
                            }
                            m2 = m2.add(m1);
                            mo.put(cell.getName(), m2);
                        }
                        ++cIndex;
                    }
                    if (var50_135 == dataList.size() - 1) {
                        for (Cell cell : list) {
                            BigDecimal b;
                            if (cell.getName() == null || !cell.getName().startsWith("DATA") || (b = (BigDecimal)mo.get(cell.getName())) == null) continue;
                            cell.setValue(b.toString());
                        }
                        cIndex = 0;
                        money = Constants.MONEY_ZERO;
                        for (Cell cell : list) {
                            if (cell.getName() != null && cell.getName().startsWith("DATA")) {
                                m1 = new BigDecimal(cell.getValue().toString());
                                money = money.add(m1);
                                if (cIndex == list.size() - 1) {
                                    cell.setValue(money.toString());
                                }
                            }
                            ++cIndex;
                        }
                    }
                    ++var50_135;
                }
                request.setAttribute("dataList", dataList);
                request.setAttribute("headList", headList);
                WebUtil.dispathTemplatePage("report/monthFeeStatistics", request, response);
            } else if ("query".equals(op)) {
                String sortOrder = request.getParameter("sortOrder");
                String sortName = request.getParameter("sortName");
                if (sortName != null && (sortName = sortName.trim()).length() > 0 && sortOrder != null && (sortOrder = sortOrder.trim()).length() > 0) {
                    sp.setOrder_by((String.valueOf(sortName) + " " + sortOrder).replaceAll("'", ""));
                } else {
                    sp.setOrder_by("tran_time");
                }
                Pagination p = WebUtil.getPagination(request);
                List dataList = commonDaoService.selectList(sp, p);
                ArrayList<Map> resultList = new ArrayList<Map>(dataList == null ? 0 : dataList.size());
                SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
                if (dataList != null && !dataList.isEmpty()) {
                    for (Map map : dataList) {
                        java.util.Date d1;
                        String string;
                        String string3;
                        String string4;
                        Integer pay_scene1 = (Integer)map.get("pay_scene");
                        Integer pay_method1 = (Integer)map.get("pay_method");
                        Integer charge_org1 = (Integer)map.get("charge_org");
                        String rtran_user_name = (String)map.get("tran_user_name");
                        if (rtran_user_name != null && rtran_user_name.length() > 0) {
                            map.put("tran_user_name", ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("car_owner_name", rtran_user_name, request));
                        }
                        Integer n6 = (Integer)map.get("invoice_status");
                        boolean isonlinepay = pay_method1 != null && pay_method1 != 0 && pay_method1 != 1 && pay_method1 != 7 && pay_scene1 != null && pay_scene1 > 1;
                        map.put("onlinepay", isonlinepay ? Constants.YES_STR : Constants.NO_STR);
                        if (n6 == null) {
                            map.put("invoice_status", 0);
                        }
                        if ((string4 = (String)paySceneMap.get(pay_scene1)) != null && string4.length() > 0) {
                            map.put("pay_scene", string4);
                        }
                        if ((string3 = (String)payMethodMap.get(pay_method1)) != null && string3.length() > 0) {
                            map.put("pay_method", string3);
                        }
                        if ((string = chargeOrgMap.get(charge_org1)) != null && string.length() > 0) {
                            map.put("charge_org", string);
                        }
                        if ((d1 = (java.util.Date)map.get("valid_date_before")) != null) {
                            map.put("valid_date_before", df1.format(d1));
                        } else {
                            map.put("valid_date_before", "");
                        }
                        d1 = (java.util.Date)map.get("end_date");
                        if (d1 != null) {
                            map.put("end_date", df1.format(d1));
                        }
                        if ((d1 = (java.util.Date)map.get("start_date")) != null) {
                            map.put("start_date", df1.format(d1));
                        }
                        Integer tran_unit = (Integer)map.get("tran_unit");
                        Integer tran_quantity = (Integer)map.get("tran_quantity");
                        if (tran_quantity == null || tran_unit == null) {
                            map.put("tran_quantity", "\u81ea\u5b9a\u4e49");
                        } else {
                            void var56_172;
                            if (tran_unit == 1) {
                                String string5 = "\u5929";
                            } else if (tran_unit == 2) {
                                String string6 = "\u4e2a\u6708";
                            } else if (tran_unit == 3) {
                                String string7 = "\u5e74";
                            } else {
                                String string8 = "";
                            }
                            map.put("tran_quantity", tran_quantity + (String)var56_172);
                        }
                        resultList.add(JavaBeanUtil.toStringMap((Object)map));
                    }
                }
                HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
                hashMap.put("rows", resultList);
                hashMap.put("total", Long.valueOf(p.getRecordsCount()));
                WebUtil.printFinshJson(response, GsonBuilder.create().toJson(hashMap));
            } else {
                LinkedHashMap<String, String> headAtrrMap = new LinkedHashMap<String, String>();
                headAtrrMap.put("plate_number", "\u8f66\u724c\u53f7\u7801");
                headAtrrMap.put("passport_type_name", "\u8f66\u724c\u7c7b\u578b");
                headAtrrMap.put("car_type_name", "\u8f66\u8f86\u7c7b\u578b");
                headAtrrMap.put("tran_user_name", "\u8f66\u4e3b\u59d3\u540d");
                headAtrrMap.put("valid_date_before", "\u5ef6\u671f\u524d\u6709\u6548\u671f");
                headAtrrMap.put("start_date", "\u5f00\u59cb\u65e5\u671f");
                headAtrrMap.put("end_date", "\u7ed3\u675f\u65e5\u671f");
                headAtrrMap.put("tran_quantity", "\u5ef6\u671f\u5468\u671f");
                headAtrrMap.put("tran_time", "\u4ea4\u6b3e\u65f6\u95f4");
                headAtrrMap.put("tran_money", "\u4ea4\u6b3e\u91d1\u989d");
                headAtrrMap.put("pay_method", "\u652f\u4ed8\u65b9\u5f0f");
                headAtrrMap.put("pay_scene", "\u652f\u4ed8\u573a\u666f");
                headAtrrMap.put("charge_org", "\u6536\u8d39\u65b9");
                headAtrrMap.put("host_name", "\u6536\u8d39\u7535\u8111");
                headAtrrMap.put("operate_user_name", "\u6536\u8d39\u5458");
                headAtrrMap.put("tran_des", "\u6536\u8d39\u63cf\u8ff0");
                ExportService exportService = (ExportService)ServiceUtil.getServiceContext().getService(ExportService.class);
                response.setContentType("text/plain; charset=GBK");
                response.setCharacterEncoding("GBK");
                SimpleDateFormat df11 = new SimpleDateFormat("yyyyMMddHHmmss");
                String f = "monthPayRecord_";
                response.addHeader("Content-Disposition", "attachment;filename=" + f + df11.format(new java.util.Date()) + ".csv");
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setDateHeader("Expires", 0L);
                try (PrintWriter out = response.getWriter();){
                    exportService.exportMonthPayRecordCsv(sp, headAtrrMap, out);
                }
            }
        }
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u6536\u8d39\u7edf\u8ba1-\u6708\u5361\u7f34\u8d39\u7edf\u8ba1\u5bfc\u51fa")
    @Path(value="/exportMothCardFeeStatistics.action")
    public void exportMothCardFeeStatistics(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("export", (Object)Boolean.TRUE);
        this.mothCardFeeStatistics(request, response);
    }

    /*
     * WARNING - void declaration
     */
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u6536\u8d39\u7edf\u8ba1-\u50a8\u503c\u8f66\u7f34\u8d39\u7edf\u8ba1")
    @LeftMenu(name="\u50a8\u503c\u8f66\u7f34\u8d39\u7edf\u8ba1", parent_name="\u6536\u8d39\u7edf\u8ba1", order=323)
    @Path(value="/rechargeCardFeeStatistics.action")
    public void rechargeCardFeeStatistics(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        Map<String, CarparkHost> hostMap9 = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        LinkedHashMap<String, CarparkHost> hostMap = new LinkedHashMap<String, CarparkHost>();
        if (hostMap9 != null) {
            hostMap.putAll(hostMap9);
        }
        CarparkHost chost = new CarparkHost();
        chost.setHost_no("CLOUD_HOST_NO");
        chost.setId(-11111L);
        chost.setHost_name("\u4e91\u7aef\u4e3b\u673a");
        hostMap.put("CLOUD_HOST_NO", chost);
        request.setAttribute("hostMap", hostMap);
        Map<Integer, String> payMethodMapCache = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap();
        LinkedHashMap<Integer, String> payMethodMap = new LinkedHashMap<Integer, String>();
        for (Map.Entry<Integer, String> m : payMethodMapCache.entrySet()) {
            if (m.getKey() == 1 || m.getKey() == 6) continue;
            payMethodMap.put(m.getKey(), m.getValue());
        }
        request.setAttribute("payMethodMap", payMethodMap);
        Map<Integer, String> chargeOrgMap = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap();
        request.setAttribute("chargeOrgMap", chargeOrgMap);
        Map<Integer, String> paySceneMap0 = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap();
        LinkedHashMap<Integer, String> paySceneMap = new LinkedHashMap<Integer, String>();
        for (Map.Entry<Integer, String> e : paySceneMap0.entrySet()) {
            if (e.getKey() == 2 || e.getKey() == 5 || e.getKey() == 4) continue;
            paySceneMap.put(e.getKey(), e.getValue());
        }
        request.setAttribute("paySceneMap", paySceneMap);
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        List userList0 = commonDaoService.selectList(new SearchParam().addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("role_no DESC,user_code"), CarparkUser.class, null);
        ArrayList<KeyValueEntry> userList = new ArrayList<KeyValueEntry>(userList0.size() + 1);
        for (CarparkUser u : userList0) {
            userList.add(new KeyValueEntry((Object)u.getUser_code(), (Object)u.getUser_name()));
        }
        userList.add(new KeyValueEntry((Object)"USER_SELF", (Object)"\u81ea\u52a9\u7f34\u8d39"));
        userList.add(new KeyValueEntry((Object)"USER_CLOUD_CODE", (Object)"\u4e91\u7aef\u7528\u6237"));
        request.setAttribute("userList", userList);
        ArrayList<KeyValueEntry> serviceTypeList = new ArrayList<KeyValueEntry>(2);
        serviceTypeList.add(new KeyValueEntry((Object)5, (Object)"\u50a8\u503c\u5361\u529e\u7406"));
        serviceTypeList.add(new KeyValueEntry((Object)6, (Object)"\u50a8\u503c\u5361\u5145\u503c"));
        serviceTypeList.add(new KeyValueEntry((Object)7, (Object)"\u50a8\u503c\u5361\u9000\u8d39"));
        request.setAttribute("serviceTypeList", serviceTypeList);
        Map<String, CarparkPassportType> passportTypeMap0 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        LinkedHashMap<String, CarparkPassportType> passportTypeMap = new LinkedHashMap<String, CarparkPassportType>();
        if (passportTypeMap0 != null) {
            for (Map.Entry<String, CarparkPassportType> m : passportTypeMap0.entrySet()) {
                if (m.getValue().getPass_type() != 1) continue;
                passportTypeMap.put(m.getKey(), m.getValue());
            }
        }
        request.setAttribute("passportTypeMap", passportTypeMap);
        Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        if (carTypeMap != null) {
            request.setAttribute("carTypeMap", carTypeMap);
        }
        if (op == null) {
            Calendar cl = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            request.setAttribute("endTime", (Object)df.format(cl.getTime()));
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            cl.set(14, 0);
            request.setAttribute("startTime", (Object)df.format(cl.getTime()));
            WebUtil.showMainContentWithHead("\u50a8\u503c\u8f66\u7f34\u8d39\u7edf\u8ba1", "report/rechargeFeeStatistics", request, response);
        } else if ("query".equals(op) || "queryTotalMoney".equals(op) || request.getAttribute("export") != null) {
            String as;
            int n;
            int n2;
            String[] stringArray;
            String[] a1;
            String groupby = request.getParameter("groupby");
            String host_nos = request.getParameter("host_no");
            String operate_user_codes = request.getParameter("operate_user_code");
            String passport_type_nos = request.getParameter("passport_type_no");
            String charge_orgs = request.getParameter("charge_org");
            String pay_scenes = request.getParameter("pay_scene");
            String pay_methods = request.getParameter("pay_method");
            String car_type_nos = request.getParameter("car_type_no");
            String service_types = request.getParameter("service_type");
            String plate_number = request.getParameter("plate_number");
            String start_tran_time = request.getParameter("start_tran_time");
            String end_tran_time = request.getParameter("end_tran_time");
            if (groupby != null && groupby.length() > 0) {
                groupby = groupby.replaceAll("'", "");
            }
            String tableName = commonDaoService.getTableName(CarparkTransaction.class);
            SearchParam sp = new SearchParam(tableName);
            if (service_types != null && (service_types = service_types.trim()).length() > 0) {
                a1 = service_types.split(",");
                if (a1.length == 1) {
                    sp.addEQ("service_type", (Object)Integer.valueOf(a1[0]));
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("service_type", (Object)Integer.valueOf(as));
                        ++n;
                    }
                }
            } else {
                sp.addINList("service_type", (Object[])new Integer[]{5, 6, 7});
            }
            if (plate_number != null && (plate_number = plate_number.trim()).length() > 0) {
                String v2 = plate_number.toUpperCase();
                v2 = v2.replaceAll("\u3000", "");
                v2 = v2.replaceAll(" ", "");
                if ((v2 = v2.replaceAll("I", "1")).length() > 0) {
                    sp.addLike("plate_number", v2);
                }
            }
            if (pay_methods != null && (pay_methods = pay_methods.trim()).length() > 0) {
                a1 = pay_methods.split(",");
                if (a1.length == 1) {
                    sp.addEQ("pay_method", (Object)Integer.valueOf(a1[0]));
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("pay_method", (Object)Integer.valueOf(as));
                        ++n;
                    }
                }
            } else {
                sp.addNotEQ("pay_method", (Object)1);
            }
            if (pay_scenes != null && (pay_scenes = pay_scenes.trim()).length() > 0) {
                a1 = pay_scenes.split(",");
                if (a1.length == 1) {
                    sp.addEQ("pay_scene", (Object)Integer.valueOf(a1[0]));
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("pay_scene", (Object)Integer.valueOf(as));
                        ++n;
                    }
                }
            }
            if (charge_orgs != null && (charge_orgs = charge_orgs.trim()).length() > 0) {
                a1 = charge_orgs.split(",");
                if (a1.length == 1) {
                    sp.addEQ("charge_org", (Object)Integer.valueOf(a1[0]));
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("charge_org", (Object)Integer.valueOf(as));
                        ++n;
                    }
                }
            }
            if (host_nos != null && (host_nos = host_nos.trim()).length() > 0) {
                a1 = host_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("host_no", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("host_no", (Object)as);
                        ++n;
                    }
                }
            }
            if (operate_user_codes != null && (operate_user_codes = operate_user_codes.trim()).length() > 0) {
                a1 = operate_user_codes.split(",");
                if (a1.length == 1) {
                    sp.addEQ("operate_user_code", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("operate_user_code", (Object)as);
                        ++n;
                    }
                }
            }
            if (passport_type_nos != null && (passport_type_nos = passport_type_nos.trim()).length() > 0) {
                a1 = passport_type_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("passport_type_no", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("passport_type_no", (Object)as);
                        ++n;
                    }
                }
            }
            if (car_type_nos != null && (car_type_nos = car_type_nos.trim()).length() > 0) {
                a1 = car_type_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("car_type_no", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("car_type_no", (Object)as);
                        ++n;
                    }
                }
            }
            if (start_tran_time != null && (start_tran_time = start_tran_time.trim()).length() > 0) {
                sp.addGTE("tran_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(start_tran_time));
            }
            if (end_tran_time != null && (end_tran_time = end_tran_time.trim()).length() > 0) {
                sp.addLTE("tran_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(end_tran_time));
            }
            if ("queryTotalMoney".equals(op)) {
                BigDecimal money;
                String name1;
                LinkedList headList = new LinkedList();
                LinkedList<Cell> leftList = new LinkedList<Cell>();
                ArrayList rList = new ArrayList();
                LinkedHashMap<String, Cell> dataMap = new LinkedHashMap<String, Cell>();
                if (groupby != null && groupby.length() > 0) {
                    Object t;
                    String value;
                    int n3;
                    int n4;
                    Object object;
                    ArrayList<Cell> celllist;
                    sp.setQueryFields(new String[]{groupby, "SUM(tran_money) AS money"});
                    sp.setGoupbySql(groupby);
                    ArrayList hList = new ArrayList();
                    if (groupby.indexOf("pay_method") != -1) {
                        celllist = new ArrayList<Cell>();
                        if (pay_methods != null && pay_methods.length() > 0) {
                            String[] stringArray2 = pay_methods.split(",");
                            object = stringArray2;
                            n4 = stringArray2.length;
                            n3 = 0;
                            while (n3 < n4) {
                                String pay_method = object[n3];
                                celllist.add(new Cell(pay_method, "pay_method", payMethodMap.get(Integer.valueOf(pay_method)), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (Map.Entry entry : payMethodMap.entrySet()) {
                                celllist.add(new Cell(((Integer)entry.getKey()).toString(), "pay_method", entry.getValue(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("service_type") != -1) {
                        celllist = new ArrayList();
                        if (service_types != null && service_types.length() > 0) {
                            String[] stringArray3 = service_types.split(",");
                            object = stringArray3;
                            n4 = stringArray3.length;
                            n3 = 0;
                            while (n3 < n4) {
                                String service_type = object[n3];
                                value = "";
                                for (KeyValueEntry keyValueEntry : serviceTypeList) {
                                    if (!((Integer)keyValueEntry.getKey()).toString().equals(service_type)) continue;
                                    value = (String)keyValueEntry.getValue();
                                    break;
                                }
                                celllist.add(new Cell(service_type, "service_type", value, 1, 1));
                                ++n3;
                            }
                        } else {
                            for (KeyValueEntry keyValueEntry : serviceTypeList) {
                                celllist.add(new Cell(((Integer)keyValueEntry.getKey()).toString(), "service_type", keyValueEntry.getValue(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("pay_scene") != -1) {
                        celllist = new ArrayList();
                        if (pay_scenes != null && pay_scenes.length() > 0) {
                            String[] stringArray4 = pay_scenes.split(",");
                            object = stringArray4;
                            n4 = stringArray4.length;
                            n3 = 0;
                            while (n3 < n4) {
                                String pay_scene = object[n3];
                                celllist.add(new Cell(pay_scene, "pay_scene", paySceneMap.get(Integer.valueOf(pay_scene)), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (Map.Entry entry : paySceneMap.entrySet()) {
                                celllist.add(new Cell(((Integer)entry.getKey()).toString(), "pay_scene", entry.getValue(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("car_type_no") != -1) {
                        celllist = new ArrayList();
                        if (car_type_nos != null && car_type_nos.length() > 0) {
                            String[] stringArray5 = car_type_nos.split(",");
                            object = stringArray5;
                            n4 = stringArray5.length;
                            n3 = 0;
                            while (n3 < n4) {
                                Object car_type_no;
                                t = carTypeMap.get(car_type_no = object[n3]);
                                celllist.add(new Cell((String)car_type_no, "car_type_no", t == null ? "" : ((CarparkCarType)t).getCar_type_name(), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (CarparkCarType carparkCarType : carTypeMap.values()) {
                                celllist.add(new Cell(carparkCarType.getCar_type_no(), "car_type_no", carparkCarType.getCar_type_name(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("passport_type_no") != -1) {
                        celllist = new ArrayList();
                        if (passport_type_nos != null && passport_type_nos.length() > 0) {
                            String[] stringArray6 = passport_type_nos.split(",");
                            object = stringArray6;
                            n4 = stringArray6.length;
                            n3 = 0;
                            while (n3 < n4) {
                                Object passport_type_no;
                                t = (CarparkPassportType)passportTypeMap.get(passport_type_no = object[n3]);
                                celllist.add(new Cell((String)passport_type_no, "passport_type_no", t == null ? "" : ((CarparkPassportType)t).getPassport_type_name(), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (CarparkPassportType carparkPassportType : passportTypeMap.values()) {
                                celllist.add(new Cell(carparkPassportType.getPassport_type_no(), "passport_type_no", carparkPassportType.getPassport_type_name(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (hList.size() > 1) {
                        int i = 1;
                        while (i < hList.size()) {
                            List list = (List)hList.get(i);
                            for (Cell cell : list) {
                                cell.setColspan(this.getSizecount(hList, i));
                            }
                            ++i;
                        }
                    }
                    if (!hList.isEmpty()) {
                        void var41_80;
                        LinkedList<Cell> parentList = null;
                        int n5 = hList.size() - 1;
                        while (var41_80 >= 0) {
                            if (var41_80 == hList.size() - 1) {
                                headList.add(new LinkedList((Collection)hList.get((int)var41_80)));
                                parentList = (List)hList.get((int)var41_80);
                            } else {
                                LinkedList<Cell> newList = new LinkedList<Cell>();
                                List list = (List)hList.get((int)var41_80);
                                for (Cell parent : parentList) {
                                    for (Cell c : list) {
                                        newList.add(new Cell(String.valueOf(parent.getKey()) + "," + c.getKey(), String.valueOf(parent.getName()) + "," + c.getName(), c.getValue(), c.getRowspan(), c.getColspan()));
                                    }
                                }
                                parentList = newList;
                                headList.add(newList);
                            }
                            --var41_80;
                        }
                    }
                    if (groupby.indexOf("operate_user_code") != -1) {
                        ArrayList<Cell> celllist2 = new ArrayList<Cell>();
                        if (operate_user_codes != null && operate_user_codes.length() > 0) {
                            String[] stringArray7 = operate_user_codes.split(",");
                            object = stringArray7;
                            int parent = stringArray7.length;
                            int list = 0;
                            while (list < parent) {
                                Object operate_user_code = object[list];
                                value = "";
                                for (KeyValueEntry keyValueEntry : userList) {
                                    if (!((String)keyValueEntry.getKey()).equals(operate_user_code)) continue;
                                    value = (String)keyValueEntry.getValue();
                                    break;
                                }
                                celllist2.add(new Cell((String)operate_user_code, "operate_user_code", value, 1, 1));
                                ++list;
                            }
                        } else {
                            for (KeyValueEntry keyValueEntry : userList) {
                                celllist2.add(new Cell((String)keyValueEntry.getKey(), "operate_user_code", keyValueEntry.getValue(), 1, 1));
                            }
                        }
                        rList.add(celllist2);
                    }
                    if (groupby.indexOf("host_no") != -1) {
                        ArrayList<Cell> celllist3 = new ArrayList<Cell>();
                        if (host_nos != null && host_nos.length() > 0) {
                            String[] stringArray8 = host_nos.split(",");
                            object = stringArray8;
                            int parent = stringArray8.length;
                            int list = 0;
                            while (list < parent) {
                                Object host_no;
                                t = (CarparkHost)hostMap.get(host_no = object[list]);
                                celllist3.add(new Cell((String)host_no, "host_no", t == null ? "" : ((CarparkHost)t).getHost_name(), 1, 1));
                                ++list;
                            }
                        } else {
                            for (CarparkHost carparkHost : hostMap.values()) {
                                celllist3.add(new Cell(carparkHost.getHost_no(), "host_no", carparkHost.getHost_name(), 1, 1));
                            }
                        }
                        rList.add(celllist3);
                    }
                    if (groupby.indexOf("charge_org") != -1) {
                        ArrayList<Cell> celllist4 = new ArrayList<Cell>();
                        if (charge_orgs != null && charge_orgs.length() > 0) {
                            String[] stringArray9 = charge_orgs.split(",");
                            object = stringArray9;
                            int parent = stringArray9.length;
                            int list = 0;
                            while (list < parent) {
                                Object charge_org = object[list];
                                celllist4.add(new Cell((String)charge_org, "charge_org", chargeOrgMap.get(Integer.valueOf((String)charge_org)), 1, 1));
                                ++list;
                            }
                        } else {
                            for (Map.Entry<Integer, String> entry : chargeOrgMap.entrySet()) {
                                celllist4.add(new Cell(entry.getKey().toString(), "charge_org", entry.getValue(), 1, 1));
                            }
                        }
                        rList.add(celllist4);
                    }
                    if (rList.size() > 1) {
                        int i = 1;
                        while (i < rList.size()) {
                            List list = (List)rList.get(i);
                            for (Cell cell : list) {
                                cell.setRowspan(this.getSizecount(rList, i));
                            }
                            ++i;
                        }
                    }
                    if (!rList.isEmpty()) {
                        void var41_89;
                        List slist = (List)rList.get(0);
                        boolean bl = true;
                        while (var41_89 < rList.size()) {
                            List s1 = (List)rList.get((int)var41_89);
                            for (Cell c : s1) {
                                c.setCellList(slist);
                            }
                            slist = s1;
                            ++var41_89;
                        }
                        leftList.addAll(slist);
                    }
                } else {
                    sp.setQueryFields(new String[]{"SUM(tran_money) AS money"});
                }
                String RIGHT_TOTAL_TITLE = "rightTotal";
                String BOTTOM_TOTAL_TITLE = "bottomTotal";
                String string = "0.00";
                Cell htotalCell = new Cell(RIGHT_TOTAL_TITLE, "", "\u603b\u8ba1", headList.size() < 1 ? 1 : headList.size(), 1);
                if (!headList.isEmpty()) {
                    ((LinkedList)headList.get(0)).add(htotalCell);
                } else {
                    LinkedList<Cell> c1 = new LinkedList<Cell>();
                    c1.add(htotalCell);
                    headList.add(c1);
                }
                String DATA_NAME = "DATA";
                LinkedList<List<Cell>> dataList = new LinkedList<List<Cell>>();
                LinkedList<Cell> enList = new LinkedList<Cell>();
                enList.addAll((Collection)headList.get(headList.size() - 1));
                if (headList.size() > 1) {
                    enList.add(htotalCell);
                }
                if (!leftList.isEmpty()) {
                    this.setDataList(dataList, leftList, new LinkedList<Cell>(), new LinkedList<Cell>());
                    Cell bottom = new Cell(BOTTOM_TOTAL_TITLE, "", "\u603b\u8ba1", 1, rList.size());
                    LinkedList<Cell> linkedList = new LinkedList<Cell>();
                    linkedList.add(bottom);
                    dataList.add(linkedList);
                    for (List list : dataList) {
                        Cell lastCell = (Cell)list.get(list.size() - 1);
                        int cIndex = 0;
                        for (Cell c1 : enList) {
                            String key1 = lastCell.getKey();
                            name1 = lastCell.getName();
                            String key2 = c1.getKey();
                            String name2 = c1.getName();
                            if (name1.length() == 0) {
                                Cell ct = new Cell(String.valueOf(key2) + "," + name2, "DATA" + cIndex, string, 1, 1);
                                list.add(ct);
                            } else {
                                String key = key1;
                                String name = name1;
                                if (name2.length() > 0) {
                                    key = String.valueOf(key) + "," + key2;
                                    name = String.valueOf(name) + "," + name2;
                                }
                                String newKey = this.getMapKey(name, key);
                                Cell dataCell = new Cell(newKey, "DATA" + cIndex, string, 1, 1);
                                list.add(dataCell);
                                dataMap.put(newKey, dataCell);
                            }
                            ++cIndex;
                        }
                    }
                    Cell cell = new Cell("cat", "", "\u7c7b\u578b/\u7c7b\u522b", headList.size(), rList.size());
                    ((LinkedList)headList.get(0)).addFirst(cell);
                } else {
                    LinkedList<Cell> dlist = new LinkedList<Cell>();
                    boolean bl = false;
                    for (Cell c1 : enList) {
                        void var47_124;
                        Iterator key = c1.getKey();
                        String name = c1.getName();
                        if (name.length() > 0) {
                            String newKey = this.getMapKey(name, (String)((Object)key));
                            Cell cell = new Cell(newKey, "DATA" + (int)var47_124, string, 1, 1);
                            dlist.add(cell);
                            dataMap.put(newKey, cell);
                        } else {
                            Cell ct = new Cell("H_TOTAL" + (int)var47_124, "DATA" + (int)var47_124, string, 1, 1);
                            dlist.add(ct);
                            dataMap.put("H_TOTAL" + (int)var47_124, ct);
                        }
                        ++var47_124;
                    }
                    dataList.add(dlist);
                }
                List dbList = commonDaoService.selectList(sp, null);
                if (!dbList.isEmpty()) {
                    Object var47_125 = null;
                    TreeMap<String, String> teeMap = new TreeMap<String, String>();
                    for (Map map : dbList) {
                        BigDecimal money2;
                        if (groupby != null && groupby.length() > 0) {
                            void var53_157;
                            void var47_126;
                            if (var47_126 == null) {
                                String[] stringArray10 = groupby.split(",");
                            }
                            if ((money = (BigDecimal)map.get("money")) == null || money.doubleValue() == 0.0) continue;
                            name1 = var47_126;
                            int key1 = ((void)name1).length;
                            boolean bl = false;
                            while (var53_157 < key1) {
                                String s1 = name1[var53_157];
                                Object v = map.get(s1);
                                if (v == null) {
                                    v = "";
                                }
                                teeMap.put(s1, v.toString());
                                ++var53_157;
                            }
                            StringBuilder sbr = new StringBuilder(128);
                            for (Map.Entry entry : teeMap.entrySet()) {
                                if (sbr.length() > 0) {
                                    sbr.append(';');
                                }
                                sbr.append((String)entry.getKey()).append('=').append((String)entry.getValue());
                            }
                            String string2 = sbr.toString();
                            Cell cell = (Cell)dataMap.get(string2);
                            if (cell == null) continue;
                            cell.setValue(money.toString());
                            continue;
                        }
                        Cell cl = (Cell)dataMap.get("H_TOTAL0");
                        if (cl == null || (money2 = (BigDecimal)map.get("money")) == null) continue;
                        cl.setValue(money2.toString());
                    }
                }
                boolean bl = false;
                HashMap<String, BigDecimal> mo = new HashMap<String, BigDecimal>();
                for (List list : dataList) {
                    void var47_129;
                    BigDecimal m1;
                    money = Constants.MONEY_ZERO;
                    int cIndex = 0;
                    for (Cell cell : list) {
                        if (cell.getName() != null && cell.getName().startsWith("DATA")) {
                            BigDecimal m2;
                            m1 = new BigDecimal(cell.getValue().toString());
                            money = money.add(m1);
                            if (cIndex == list.size() - 1) {
                                cell.setValue(money.toString());
                            }
                            if ((m2 = (BigDecimal)mo.get(cell.getName())) == null) {
                                m2 = Constants.MONEY_ZERO;
                            }
                            m2 = m2.add(m1);
                            mo.put(cell.getName(), m2);
                        }
                        ++cIndex;
                    }
                    if (var47_129 == dataList.size() - 1) {
                        for (Cell cell : list) {
                            BigDecimal b;
                            if (cell.getName() == null || !cell.getName().startsWith("DATA") || (b = (BigDecimal)mo.get(cell.getName())) == null) continue;
                            cell.setValue(b.toString());
                        }
                        cIndex = 0;
                        money = Constants.MONEY_ZERO;
                        for (Cell cell : list) {
                            if (cell.getName() != null && cell.getName().startsWith("DATA")) {
                                m1 = new BigDecimal(cell.getValue().toString());
                                money = money.add(m1);
                                if (cIndex == list.size() - 1) {
                                    cell.setValue(money.toString());
                                }
                            }
                            ++cIndex;
                        }
                    }
                    ++var47_129;
                }
                request.setAttribute("dataList", dataList);
                request.setAttribute("headList", headList);
                WebUtil.dispathTemplatePage("report/rechargeFeeStatistics", request, response);
            } else if ("query".equals(op)) {
                String sortOrder = request.getParameter("sortOrder");
                String sortName = request.getParameter("sortName");
                if (sortName != null && (sortName = sortName.trim()).length() > 0 && sortOrder != null && (sortOrder = sortOrder.trim()).length() > 0) {
                    sp.setOrder_by((String.valueOf(sortName) + " " + sortOrder).replaceAll("'", ""));
                } else {
                    sp.setOrder_by("tran_time");
                }
                Pagination p = WebUtil.getPagination(request);
                List dataList = commonDaoService.selectList(sp, p);
                ArrayList<Map> resultList = new ArrayList<Map>(dataList == null ? 0 : dataList.size());
                String N_recharge_money = "recharge_money";
                String string = "balance_before";
                String N_balance = "balance";
                String N_service_type = "service_type";
                if (dataList != null && !dataList.isEmpty()) {
                    for (Map data : dataList) {
                        BigDecimal re;
                        BigDecimal balance;
                        Integer serviceType;
                        String string3;
                        String vdaa;
                        Integer n6 = (Integer)data.get("pay_scene");
                        Integer pay_method1 = (Integer)data.get("pay_method");
                        Integer n7 = (Integer)data.get("charge_org");
                        Integer invoice_status = (Integer)data.get("invoice_status");
                        boolean isonlinepay = pay_method1 != null && pay_method1 != 0 && pay_method1 != 1 && pay_method1 != 7 && n6 != null && n6 > 1;
                        data.put("onlinepay", isonlinepay ? Constants.YES_STR : Constants.NO_STR);
                        if (invoice_status == null) {
                            data.put("invoice_status", 0);
                        }
                        if ((vdaa = (String)paySceneMap.get(n6)) != null && vdaa.length() > 0) {
                            data.put("pay_scene", vdaa);
                        }
                        if ((vdaa = (String)payMethodMap.get(pay_method1)) != null && vdaa.length() > 0) {
                            data.put("pay_method", vdaa);
                        }
                        if ((vdaa = chargeOrgMap.get(n7)) != null && vdaa.length() > 0) {
                            data.put("charge_org", vdaa);
                        }
                        if ((string3 = (String)data.get("tran_user_name")) != null && string3.length() > 0) {
                            data.put("tran_user_name", ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("car_owner_name", string3, request));
                        }
                        if ((serviceType = (Integer)data.get("service_type")) != null && serviceType == 5 && (balance = (BigDecimal)data.get("balance")) == null && (re = (BigDecimal)data.get("recharge_money")) != null) {
                            BigDecimal balanceBfor = (BigDecimal)data.get("balance_before");
                            if (balanceBfor == null) {
                                balanceBfor = Constants.MONEY_ZERO;
                                data.put("balance_before", balanceBfor);
                            }
                            balance = re.add(balanceBfor);
                            data.put("balance", balance);
                        }
                        resultList.add(JavaBeanUtil.toStringMap((Object)data));
                    }
                }
                HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
                resMap.put("rows", resultList);
                resMap.put("total", Long.valueOf(p.getRecordsCount()));
                WebUtil.printFinshJson(response, GsonBuilder.create().toJson(resMap));
            } else {
                LinkedHashMap<String, String> headAtrrMap = new LinkedHashMap<String, String>();
                headAtrrMap.put("plate_number", "\u5145\u503c\u8f66\u724c");
                headAtrrMap.put("passport_type_name", "\u8f66\u724c\u7c7b\u578b");
                headAtrrMap.put("car_type_name", "\u8f66\u8f86\u7c7b\u578b");
                headAtrrMap.put("tran_user_name", "\u8f66\u4e3b\u59d3\u540d");
                headAtrrMap.put("balance_before", "\u5145\u503c\u524d\u4f59\u989d");
                headAtrrMap.put("recharge_money", "\u5145\u503c\u91d1\u989d");
                headAtrrMap.put("balance", "\u5145\u503c\u540e\u4f59\u989d");
                headAtrrMap.put("tran_time", "\u5145\u503c\u65f6\u95f4");
                headAtrrMap.put("tran_money", "\u5b9e\u4ed8\u91d1\u989d");
                headAtrrMap.put("pay_method", "\u652f\u4ed8\u65b9\u5f0f");
                headAtrrMap.put("pay_scene", "\u652f\u4ed8\u573a\u666f");
                headAtrrMap.put("charge_org", "\u6536\u8d39\u65b9");
                headAtrrMap.put("host_name", "\u6536\u8d39\u7535\u8111");
                headAtrrMap.put("operate_user_name", "\u6536\u8d39\u5458");
                headAtrrMap.put("tran_des", "\u6536\u8d39\u63cf\u8ff0");
                ExportService exportService = (ExportService)ServiceUtil.getServiceContext().getService(ExportService.class);
                response.setContentType("text/plain; charset=GBK");
                response.setCharacterEncoding("GBK");
                SimpleDateFormat df11 = new SimpleDateFormat("yyyyMMddHHmmss");
                String f = "rechargeRecord_";
                response.addHeader("Content-Disposition", "attachment;filename=" + f + df11.format(new java.util.Date()) + ".csv");
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setDateHeader("Expires", 0L);
                try (PrintWriter out = response.getWriter();){
                    exportService.exportMonthPayRecordCsv(sp, headAtrrMap, out);
                }
            }
        }
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u6536\u8d39\u7edf\u8ba1-\u50a8\u503c\u8f66\u7f34\u8d39\u7edf\u8ba1\u5bfc\u51fa")
    @Path(value="/exportRechargeCardFeeStatistics.action")
    public void exportRechargeCardFeeStatistics(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("export", (Object)Boolean.TRUE);
        this.rechargeCardFeeStatistics(request, response);
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u6536\u8d39\u7edf\u8ba1-\u50a8\u503c\u8f66\u6263\u8d39\u8bb0\u5f55")
    @LeftMenu(name="\u50a8\u503c\u8f66\u6263\u8d39\u8bb0\u5f55", parent_name="\u6536\u8d39\u7edf\u8ba1", order=324)
    @Path(value="/rechargeCardDeductRecord.action")
    public void rechargeCardDeductStatistics(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
            request.setAttribute("hostMap", hostMap);
            Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
            LinkedList<CarparkArea> outAreaList = new LinkedList<CarparkArea>();
            if (areaMap != null && !areaMap.isEmpty()) {
                for (CarparkArea area : areaMap.values()) {
                    if (area.getArea_level() != 1) continue;
                    outAreaList.add(area);
                }
            }
            request.setAttribute("areaList", outAreaList);
            Integer project_id = ServiceUtil.getServiceContext().getProjectId();
            Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            List userList0 = commonDaoService.selectList(new SearchParam().addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("role_no DESC,user_code"), CarparkUser.class, null);
            ArrayList<KeyValueEntry> userList = new ArrayList<KeyValueEntry>(userList0.size() + 1);
            for (CarparkUser u : userList0) {
                userList.add(new KeyValueEntry((Object)u.getUser_code(), (Object)u.getUser_name()));
            }
            userList.add(new KeyValueEntry((Object)"USER_SELF", (Object)"\u81ea\u52a9\u7f34\u8d39"));
            userList.add(new KeyValueEntry((Object)"USER_CLOUD_CODE", (Object)"\u4e91\u7aef\u7528\u6237"));
            request.setAttribute("userList", userList);
            Map<String, CarparkPassportType> passportTypeMap0 = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            LinkedHashMap<String, CarparkPassportType> passportTypeMap = new LinkedHashMap<String, CarparkPassportType>();
            if (passportTypeMap0 != null) {
                for (Map.Entry<String, CarparkPassportType> m : passportTypeMap0.entrySet()) {
                    if (m.getValue().getPass_type() != 1) continue;
                    passportTypeMap.put(m.getKey(), m.getValue());
                }
            }
            request.setAttribute("passportTypeMap", passportTypeMap);
            Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
            if (carTypeMap != null) {
                request.setAttribute("carTypeMap", carTypeMap);
            }
            Map<String, ChannelArea> channalAreaMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas();
            Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
            ArrayList<CarparkChannel> channelList = new ArrayList<CarparkChannel>();
            if (channelMap != null && !channelMap.isEmpty()) {
                for (CarparkChannel ch : channelMap.values()) {
                    ChannelArea cha = channalAreaMap.get(ch.getChannel_no());
                    if (cha == null || cha.getExitAreas() == null || cha.getExitAreas().isEmpty()) continue;
                    channelList.add(ch);
                }
            }
            request.setAttribute("channelList", channelList);
            Calendar cl = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            request.setAttribute("endTime", (Object)df.format(cl.getTime()));
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            cl.set(14, 0);
            request.setAttribute("startTime", (Object)df.format(cl.getTime()));
            WebUtil.showMainContentWithHead("\u50a8\u503c\u8f66\u6263\u8d39\u8bb0\u5f55", "report/rechargeCardDeductRecord", request, response);
        } else if ("query".equals(op) || "queryTotalMoney".equals(op) || request.getAttribute("export") != null) {
            String as;
            int cl;
            int df;
            String[] cha;
            String[] a1;
            String host_nos = request.getParameter("host_no");
            String operate_user_codes = request.getParameter("operate_user_code");
            String passport_type_nos = request.getParameter("passport_type_no");
            String tran_area_nos = request.getParameter("tran_area_no");
            String tran_channel_nos = request.getParameter("tran_channel_no");
            String car_type_nos = request.getParameter("car_type_no");
            String plate_number = request.getParameter("plate_number");
            String start_tran_time = request.getParameter("start_tran_time");
            String end_tran_time = request.getParameter("end_tran_time");
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            String tableName = commonDaoService.getTableName(CarparkTransaction.class);
            SearchParam sp = new SearchParam(tableName);
            sp.addEQ("service_type", (Object)0);
            sp.addEQ("pay_method", (Object)1);
            if (plate_number != null && (plate_number = plate_number.trim()).length() > 0) {
                String v2 = plate_number.toUpperCase();
                v2 = v2.replaceAll("\u3000", "");
                v2 = v2.replaceAll(" ", "");
                if ((v2 = v2.replaceAll("I", "1")).length() > 0) {
                    sp.addLike("plate_number", v2);
                }
            }
            if (host_nos != null && (host_nos = host_nos.trim()).length() > 0) {
                a1 = host_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("host_no", (Object)a1[0]);
                } else {
                    cha = a1;
                    df = a1.length;
                    cl = 0;
                    while (cl < df) {
                        as = cha[cl];
                        sp.addIN("host_no", (Object)as);
                        ++cl;
                    }
                }
            }
            if (operate_user_codes != null && (operate_user_codes = operate_user_codes.trim()).length() > 0) {
                a1 = operate_user_codes.split(",");
                if (a1.length == 1) {
                    sp.addEQ("operate_user_code", (Object)a1[0]);
                } else {
                    cha = a1;
                    df = a1.length;
                    cl = 0;
                    while (cl < df) {
                        as = cha[cl];
                        sp.addIN("operate_user_code", (Object)as);
                        ++cl;
                    }
                }
            }
            if (passport_type_nos != null && (passport_type_nos = passport_type_nos.trim()).length() > 0) {
                a1 = passport_type_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("passport_type_no", (Object)a1[0]);
                } else {
                    cha = a1;
                    df = a1.length;
                    cl = 0;
                    while (cl < df) {
                        as = cha[cl];
                        sp.addIN("passport_type_no", (Object)as);
                        ++cl;
                    }
                }
            }
            if (car_type_nos != null && (car_type_nos = car_type_nos.trim()).length() > 0) {
                a1 = car_type_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("car_type_no", (Object)a1[0]);
                } else {
                    cha = a1;
                    df = a1.length;
                    cl = 0;
                    while (cl < df) {
                        as = cha[cl];
                        sp.addIN("car_type_no", (Object)as);
                        ++cl;
                    }
                }
            }
            if (tran_area_nos != null && (tran_area_nos = tran_area_nos.trim()).length() > 0) {
                a1 = tran_area_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("tran_area_no", (Object)a1[0]);
                } else {
                    cha = a1;
                    df = a1.length;
                    cl = 0;
                    while (cl < df) {
                        as = cha[cl];
                        sp.addIN("tran_area_no", (Object)as);
                        ++cl;
                    }
                }
            }
            if (tran_channel_nos != null && (tran_channel_nos = tran_channel_nos.trim()).length() > 0) {
                a1 = tran_channel_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("tran_channel_no", (Object)a1[0]);
                } else {
                    cha = a1;
                    df = a1.length;
                    cl = 0;
                    while (cl < df) {
                        as = cha[cl];
                        sp.addIN("tran_channel_no", (Object)as);
                        ++cl;
                    }
                }
            }
            if (start_tran_time != null && (start_tran_time = start_tran_time.trim()).length() > 0) {
                sp.addGTE("tran_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(start_tran_time));
            }
            if (end_tran_time != null && (end_tran_time = end_tran_time.trim()).length() > 0) {
                sp.addLTE("tran_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(end_tran_time));
            }
            if ("query".equals(op)) {
                String sortOrder = request.getParameter("sortOrder");
                String sortName = request.getParameter("sortName");
                if (sortName != null && (sortName = sortName.trim()).length() > 0 && sortOrder != null && (sortOrder = sortOrder.trim()).length() > 0) {
                    sp.setOrder_by((String.valueOf(sortName) + " " + sortOrder).replaceAll("'", ""));
                } else {
                    sp.setOrder_by("tran_time");
                }
                Pagination p = WebUtil.getPagination(request);
                List dataList = commonDaoService.selectList(sp, p);
                ArrayList<Map> resultList = new ArrayList<Map>(dataList == null ? 0 : dataList.size());
                if (dataList != null && !dataList.isEmpty()) {
                    for (Map data : dataList) {
                        String rtran_user_name = (String)data.get("tran_user_name");
                        if (rtran_user_name != null && rtran_user_name.length() > 0) {
                            data.put("tran_user_name", ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("car_owner_name", rtran_user_name, request));
                        }
                        resultList.add(JavaBeanUtil.toStringMap((Object)data));
                    }
                }
                HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
                resMap.put("rows", resultList);
                resMap.put("total", Long.valueOf(p.getRecordsCount()));
                WebUtil.printFinshJson(response, GsonBuilder.create().toJson(resMap));
            } else if ("queryTotalMoney".equals(op)) {
                sp.setQueryFields(new String[]{"SUM(tran_money) AS money"});
                Map moneyMap = commonDaoService.selectOne(sp);
                BigDecimal totalMoney = null;
                if (moneyMap != null) {
                    totalMoney = (BigDecimal)moneyMap.get("money");
                }
                if (totalMoney == null) {
                    totalMoney = Constants.MONEY_ZERO;
                }
                WebUtil.printFinshJson(0, totalMoney.toString(), response);
            } else if (request.getAttribute("export") != null) {
                LinkedHashMap<String, String> headAtrrMap = new LinkedHashMap<String, String>();
                headAtrrMap.put("plate_number", "\u6263\u8d39\u8f66\u724c");
                headAtrrMap.put("passport_type_name", "\u8f66\u724c\u7c7b\u578b");
                headAtrrMap.put("car_type_name", "\u8f66\u8f86\u7c7b\u578b");
                headAtrrMap.put("tran_user_name", "\u8f66\u4e3b\u59d3\u540d");
                headAtrrMap.put("tran_area_name", "\u79bb\u573a\u573a\u533a");
                headAtrrMap.put("tran_channel_name", "\u79bb\u573a\u901a\u9053");
                headAtrrMap.put("balance_before", "\u6263\u8d39\u524d\u4f59\u989d");
                headAtrrMap.put("balance", "\u6263\u8d39\u540e\u4f59\u989d");
                headAtrrMap.put("enter_time", "\u5165\u573a\u65f6\u95f4");
                headAtrrMap.put("tran_time", "\u6263\u8d39\u65f6\u95f4");
                headAtrrMap.put("tran_money", "\u6263\u8d39\u91d1\u989d");
                headAtrrMap.put("should_charge", "\u5e94\u6536\u91d1\u989d");
                headAtrrMap.put("period_multi_free", "\u5468\u671f\u4f18\u60e0\u91d1\u989d");
                headAtrrMap.put("discount_money", "\u6298\u6263\u4f18\u60e0");
                headAtrrMap.put("already_paid", "\u573a\u5185\u5df2\u6536");
                headAtrrMap.put("operate_user_name", "\u503c\u73ed\u5458");
                headAtrrMap.put("host_name", "\u6263\u8d39\u7535\u8111");
                ExportService exportService = (ExportService)ServiceUtil.getServiceContext().getService(ExportService.class);
                response.setContentType("text/plain; charset=GBK");
                response.setCharacterEncoding("GBK");
                SimpleDateFormat df11 = new SimpleDateFormat("yyyyMMddHHmmss");
                String f = "deductRecord_";
                response.addHeader("Content-Disposition", "attachment;filename=" + f + df11.format(new java.util.Date()) + ".csv");
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setDateHeader("Expires", 0L);
                try (PrintWriter out = response.getWriter();){
                    exportService.exportTempPayRecordCsv(sp, headAtrrMap, out);
                }
            }
        }
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u6536\u8d39\u7edf\u8ba1-\u50a8\u503c\u8f66\u6263\u8d39\u8bb0\u5f55\u5bfc\u51fa")
    @Path(value="/exportRechargeCardDeductRecord.action")
    public void exportRechargeCardDeductStatistics(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("export", (Object)Boolean.TRUE);
        this.rechargeCardDeductStatistics(request, response);
    }

    /*
     * WARNING - void declaration
     */
    @WritePermission
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u6536\u8d39\u7edf\u8ba1-\u505c\u8f66\u573a\u6536\u8d39\u62a5\u8868")
    @LeftMenu(name="\u505c\u8f66\u573a\u6536\u8d39\u62a5\u8868", parent_name="\u6536\u8d39\u7edf\u8ba1", order=327)
    @Path(value="/carparkFeeStatisticsReport.action")
    public void carparkFeeStatisticsReport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        Map<Integer, String> payMethodMapCache = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap();
        LinkedHashMap<Integer, String> payMethodMap = new LinkedHashMap<Integer, String>();
        for (Map.Entry<Integer, String> m : payMethodMapCache.entrySet()) {
            if (m.getKey() == 1) continue;
            payMethodMap.put(m.getKey(), m.getValue());
        }
        request.setAttribute("payMethodMap", payMethodMap);
        LinkedHashMap<Integer, String> serviceTypeMap = new LinkedHashMap<Integer, String>();
        serviceTypeMap.put(1, "\u4e34\u505c\u8f66\u8d39");
        serviceTypeMap.put(2, "\u6708\u5361\u8d39\u7528");
        serviceTypeMap.put(3, "\u5145\u503c\u8d39\u7528");
        serviceTypeMap.put(4, "\u4f18\u60e0\u5238\u8d2d\u4e70");
        serviceTypeMap.put(5, "\u4ee3\u4ed8\u91d1\u5145\u503c");
        request.setAttribute("serviceTypeMap", serviceTypeMap);
        Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        request.setAttribute("passportTypeMap", passportTypeMap);
        Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        request.setAttribute("carTypeMap", carTypeMap);
        if (op == null) {
            Calendar cl = Calendar.getInstance();
            int currentYear = cl.get(1);
            request.setAttribute("currentYear", (Object)currentYear);
            request.setAttribute("currentMonth", (Object)(cl.get(2) + 1));
            request.setAttribute("currentDay", (Object)cl.get(5));
            StringBuilder sbr = new StringBuilder();
            int i = 2018;
            while (i <= currentYear) {
                if (sbr.length() > 0) {
                    sbr.append(',');
                }
                sbr.append(i);
                ++i;
            }
            request.setAttribute("selecteYears", (Object)sbr.toString());
            WebUtil.showMainContentWithHead("\u505c\u8f66\u6536\u8d39\u62a5\u8868", "report/reportMonthFee", request, response);
            return;
        }
        if ("queryTotalMoney".equals(op)) {
            int yearBegin0;
            String tll;
            int i;
            int l;
            int monthBegin0;
            String as;
            String[] a1;
            int n;
            int n2;
            String[] stringArray;
            String groupby = request.getParameter("groupby");
            String d0 = request.getParameter("d0");
            String yearBegin = request.getParameter("yearBegin");
            String yearEnd = request.getParameter("yearEnd");
            String monthBegin = request.getParameter("monthBegin");
            String monthEnd = request.getParameter("monthEnd");
            String quarterBegin = request.getParameter("quarterBegin");
            String quarterEnd = request.getParameter("quarterEnd");
            String dayBegin = request.getParameter("dayBegin");
            String dayEnd = request.getParameter("dayEnd");
            String pay_methods = request.getParameter("pay_method");
            String car_type_nos = request.getParameter("car_type_no");
            String passport_type_nos = request.getParameter("passport_type_no");
            String service_types = request.getParameter("service_type");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            if (groupby != null && groupby.length() > 0) {
                groupby = groupby.replaceAll("'", "");
            }
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            String tableName = commonDaoService.getTableName(CarparkFeeReport.class);
            SearchParam sp = new SearchParam(tableName);
            HashMap<Integer, Integer> serviceTypeATMap = new HashMap<Integer, Integer>();
            if (service_types != null && (service_types = service_types.trim()).length() > 0) {
                String[] vs;
                stringArray = vs = service_types.split(",");
                n2 = vs.length;
                n = 0;
                while (n < n2) {
                    String serviceType = stringArray[n];
                    int stype = Integer.parseInt(serviceType);
                    if (stype == 1) {
                        serviceTypeATMap.put(0, 1);
                        serviceTypeATMap.put(1, 1);
                    } else if (stype == 2) {
                        serviceTypeATMap.put(2, 2);
                        serviceTypeATMap.put(3, 2);
                        serviceTypeATMap.put(4, 2);
                    } else if (stype == 3) {
                        serviceTypeATMap.put(5, 3);
                        serviceTypeATMap.put(6, 3);
                        serviceTypeATMap.put(7, 3);
                    } else if (stype == 4) {
                        serviceTypeATMap.put(9, 4);
                        serviceTypeATMap.put(10, 4);
                    } else if (stype == 5) {
                        serviceTypeATMap.put(11, 5);
                        serviceTypeATMap.put(12, 5);
                    }
                    ++n;
                }
                if (!serviceTypeATMap.isEmpty()) {
                    sp.addINList("service_type", serviceTypeATMap.keySet());
                }
            }
            if (pay_methods != null && (pay_methods = pay_methods.trim()).length() > 0) {
                a1 = pay_methods.split(",");
                if (a1.length == 1) {
                    sp.addEQ("pay_method", (Object)Integer.valueOf(a1[0]));
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("pay_method", (Object)Integer.valueOf(as));
                        ++n;
                    }
                }
            } else {
                sp.addNotEQ("pay_method", (Object)1);
            }
            if (passport_type_nos != null && (passport_type_nos = passport_type_nos.trim()).length() > 0) {
                a1 = passport_type_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("passport_type_no", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("passport_type_no", (Object)as);
                        ++n;
                    }
                }
            }
            if (car_type_nos != null && (car_type_nos = car_type_nos.trim()).length() > 0) {
                a1 = car_type_nos.split(",");
                if (a1.length == 1) {
                    sp.addEQ("car_type_no", (Object)a1[0]);
                } else {
                    stringArray = a1;
                    n2 = a1.length;
                    n = 0;
                    while (n < n2) {
                        as = stringArray[n];
                        sp.addIN("car_type_no", (Object)as);
                        ++n;
                    }
                }
            }
            Calendar cl1 = Calendar.getInstance();
            cl1.set(11, 0);
            cl1.set(12, 0);
            cl1.set(13, 0);
            cl1.set(14, 0);
            cl1.add(6, 1);
            java.util.Date xxxxx2 = cl1.getTime();
            cl1.add(6, -2);
            java.util.Date xxxxx1 = cl1.getTime();
            LinkedHashMap<Integer, String> rowListMap = new LinkedHashMap<Integer, String>();
            Calendar cl = Calendar.getInstance();
            StringBuilder groupby0 = new StringBuilder();
            StringBuilder title = new StringBuilder();
            if ("byMonth".equals(d0)) {
                title.append(yearBegin).append("\u5e74");
                if (groupby0.length() > 0) {
                    groupby0.append(",");
                }
                groupby0.append("month");
                monthBegin0 = Integer.parseInt(monthBegin);
                int monthEnd0 = Integer.parseInt(monthEnd);
                int yearBegin02 = Integer.parseInt(yearBegin);
                if (monthBegin0 > monthEnd0) {
                    l = monthBegin0;
                    monthBegin0 = monthEnd0;
                    monthEnd0 = l;
                }
                i = monthBegin0;
                while (i <= monthEnd0) {
                    rowListMap.put(i, "month");
                    ++i;
                }
                tll = "\u6708\u4efd";
                if (monthBegin0 == monthEnd0) {
                    cl.set(1, yearBegin02);
                    cl.set(2, monthBegin0 - 1);
                    cl.set(5, 1);
                    cl.set(11, 0);
                    cl.set(12, 0);
                    cl.set(13, 0);
                    cl.set(14, 0);
                    sp.addGTE("report_date", (Object)new Date(cl.getTimeInMillis()));
                    cl.add(2, 1);
                    cl.add(6, -1);
                    sp.addLTE("report_date", (Object)new Date(cl.getTimeInMillis()));
                    title.append(monthBegin0).append("\u6708");
                } else {
                    cl.set(1, yearBegin02);
                    cl.set(2, monthBegin0 - 1);
                    cl.set(5, 1);
                    cl.set(11, 0);
                    cl.set(12, 0);
                    cl.set(13, 0);
                    cl.set(14, 0);
                    sp.addGTE("report_date", (Object)new Date(cl.getTimeInMillis()));
                    cl.set(2, monthEnd0 - 1);
                    cl.add(2, 1);
                    cl.add(6, -1);
                    sp.addLTE("report_date", (Object)new Date(cl.getTimeInMillis()));
                    title.append(monthBegin0).append("\u6708").append("-").append(monthEnd0).append("\u6708");
                }
            } else if ("byQuarter".equals(d0)) {
                int monthBegin02;
                int monthEnd0;
                title.append(yearBegin).append("\u5e74");
                if (groupby0.length() > 0) {
                    groupby0.append(",");
                }
                groupby0.append("quarter");
                yearBegin0 = Integer.parseInt(yearBegin);
                int quarterBegin0 = Integer.parseInt(quarterBegin);
                int quarterEnd0 = Integer.parseInt(quarterEnd);
                if (quarterBegin0 > quarterEnd0) {
                    l = quarterBegin0;
                    quarterBegin0 = quarterEnd0;
                    quarterEnd0 = l;
                }
                i = quarterBegin0;
                while (i <= quarterEnd0) {
                    rowListMap.put(i, "quarter");
                    ++i;
                }
                tll = "\u5b63\u5ea6";
                if (quarterBegin0 == quarterEnd0) {
                    if (quarterBegin0 == 1) {
                        boolean monthBegin022 = true;
                        monthEnd0 = 3;
                    } else if (quarterBegin0 == 2) {
                        monthBegin02 = 4;
                        monthEnd0 = 6;
                    } else if (quarterBegin0 == 3) {
                        monthBegin02 = 7;
                        monthEnd0 = 9;
                    } else {
                        monthBegin02 = 10;
                        monthEnd0 = 12;
                    }
                } else {
                    monthBegin02 = quarterBegin0 == 1 ? 1 : (quarterBegin0 == 2 ? 4 : (quarterBegin0 == 3 ? 7 : 10));
                    monthEnd0 = quarterEnd0 == 1 ? 3 : (quarterEnd0 == 2 ? 6 : (quarterEnd0 == 3 ? 9 : 12));
                }
                cl.set(1, yearBegin0);
                cl.set(2, monthBegin02 - 1);
                cl.set(5, 1);
                cl.set(11, 0);
                cl.set(12, 0);
                cl.set(13, 0);
                cl.set(14, 0);
                sp.addGTE("report_date", (Object)new Date(cl.getTimeInMillis()));
                cl.set(2, monthEnd0 - 1);
                cl.add(2, 1);
                cl.add(6, -1);
                sp.addLTE("report_date", (Object)new Date(cl.getTimeInMillis()));
                if (quarterBegin0 == quarterEnd0) {
                    title.append("\u7b2c").append(quarterBegin0).append("\u5b63\u5ea6");
                } else {
                    title.append("\u7b2c").append(quarterBegin0).append("-").append(quarterEnd0).append("\u5b63\u5ea6");
                }
            } else if ("byYear".equals(d0)) {
                if (groupby0.length() > 0) {
                    groupby0.append(",");
                }
                groupby0.append("year");
                yearBegin0 = Integer.parseInt(yearBegin);
                int yearEnd0 = Integer.parseInt(yearEnd);
                tll = "\u5e74\u4efd";
                if (yearBegin0 > yearEnd0) {
                    int l2 = yearBegin0;
                    yearBegin0 = yearEnd0;
                    yearEnd0 = l2;
                }
                int i2 = yearBegin0;
                while (i2 <= yearEnd0) {
                    rowListMap.put(i2, "year");
                    ++i2;
                }
                if (yearBegin0 == yearEnd0) {
                    sp.addGTE("report_date", (Object)new Date(df.parse(String.valueOf(yearBegin0) + "-01-01").getTime()));
                    sp.addLTE("report_date", (Object)new Date(df.parse(String.valueOf(yearBegin0) + "-12-31").getTime()));
                    title.append(yearBegin0).append("\u5e74\u5ea6");
                } else {
                    sp.addGTE("report_date", (Object)new Date(df.parse(String.valueOf(yearBegin0) + "-01-01").getTime()));
                    sp.addLTE("report_date", (Object)new Date(df.parse(String.valueOf(yearEnd0) + "-12-31").getTime()));
                    title.append(yearBegin0).append("-").append(yearEnd0).append("\u5e74\u5ea6");
                }
            } else if ("byDay".equals(d0)) {
                title.append(yearBegin).append("\u5e74").append(monthBegin).append("\u6708");
                if (groupby0.length() > 0) {
                    groupby0.append(",");
                }
                groupby0.append("day");
                monthBegin0 = Integer.parseInt(monthBegin);
                int yearBegin03 = Integer.parseInt(yearBegin);
                tll = "\u65e5";
                int dayBegin0 = Integer.parseInt(dayBegin);
                int dayEnd0 = Integer.parseInt(dayEnd);
                if (dayBegin0 > dayEnd0) {
                    int l3 = dayBegin0;
                    dayBegin0 = dayEnd0;
                    dayEnd0 = l3;
                }
                int i3 = dayBegin0;
                while (i3 <= dayEnd0) {
                    rowListMap.put(i3, "day");
                    ++i3;
                }
                if (dayBegin0 == dayEnd0) {
                    cl.set(1, yearBegin03);
                    cl.set(2, monthBegin0 - 1);
                    cl.set(5, dayBegin0);
                    cl.set(11, 0);
                    cl.set(12, 0);
                    cl.set(13, 0);
                    cl.set(14, 0);
                    sp.addEQ("report_date", (Object)new Date(cl.getTimeInMillis()));
                    title.append(dayBegin0).append("\u53f7");
                } else {
                    cl.set(1, yearBegin03);
                    cl.set(2, monthBegin0 - 1);
                    cl.set(5, dayBegin0);
                    cl.set(11, 0);
                    cl.set(12, 0);
                    cl.set(13, 0);
                    cl.set(14, 0);
                    sp.addGTE("report_date", (Object)new Date(cl.getTimeInMillis()));
                    cl.set(5, dayEnd0);
                    sp.addLTE("report_date", (Object)new Date(cl.getTimeInMillis()));
                    cl.set(1, yearBegin03);
                    cl.set(2, monthBegin0 - 1);
                    cl.set(5, 1);
                    int h1 = cl.get(5);
                    cl.add(2, 1);
                    cl.add(6, -1);
                    int h2 = cl.get(5);
                    if (dayBegin0 != h1 || dayEnd0 != h2) {
                        title.append(dayBegin0).append("-").append(dayEnd0).append("\u53f7");
                    }
                }
            } else {
                return;
            }
            if (groupby != null && groupby.length() > 0) {
                groupby0.append(',').append(groupby);
            }
            groupby = groupby0.toString();
            CarparkTranFeeReportJob.getInstance().runCarparkFeeReport(xxxxx1, xxxxx2);
            if ("queryTotalMoney".equals(op)) {
                BigDecimal money;
                Object key2;
                LinkedList<Object> headList = new LinkedList<Object>();
                LinkedList<Cell> leftList = new LinkedList<Cell>();
                ArrayList rList = new ArrayList();
                LinkedHashMap<String, Cell> dataMap = new LinkedHashMap<String, Cell>();
                if (groupby != null && groupby.length() > 0) {
                    Object t;
                    int n3;
                    int n4;
                    Object object;
                    sp.setQueryFields(new String[]{groupby, "SUM(tran_money) AS money"});
                    sp.setGoupbySql(groupby);
                    ArrayList hList = new ArrayList();
                    if (groupby.indexOf("pay_method") != -1) {
                        ArrayList<Cell> celllist = new ArrayList<Cell>();
                        if (pay_methods != null && pay_methods.length() > 0) {
                            String[] stringArray2 = pay_methods.split(",");
                            object = stringArray2;
                            n4 = stringArray2.length;
                            n3 = 0;
                            while (n3 < n4) {
                                String pay_method = object[n3];
                                celllist.add(new Cell(pay_method, "pay_method", payMethodMap.get(Integer.valueOf(pay_method)), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (Map.Entry entry : payMethodMap.entrySet()) {
                                celllist.add(new Cell(((Integer)entry.getKey()).toString(), "pay_method", entry.getValue(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("car_type_no") != -1) {
                        ArrayList<Cell> celllist = new ArrayList<Cell>();
                        if (car_type_nos != null && car_type_nos.length() > 0) {
                            String[] stringArray3 = car_type_nos.split(",");
                            object = stringArray3;
                            n4 = stringArray3.length;
                            n3 = 0;
                            while (n3 < n4) {
                                Object car_type_no;
                                t = carTypeMap.get(car_type_no = object[n3]);
                                celllist.add(new Cell((String)car_type_no, "car_type_no", t == null ? "" : ((CarparkCarType)t).getCar_type_name(), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (CarparkCarType carparkCarType : carTypeMap.values()) {
                                celllist.add(new Cell(carparkCarType.getCar_type_no(), "car_type_no", carparkCarType.getCar_type_name(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("passport_type_no") != -1) {
                        ArrayList<Cell> celllist = new ArrayList<Cell>();
                        if (passport_type_nos != null && passport_type_nos.length() > 0) {
                            String[] stringArray4 = passport_type_nos.split(",");
                            object = stringArray4;
                            n4 = stringArray4.length;
                            n3 = 0;
                            while (n3 < n4) {
                                Object passport_type_no;
                                t = passportTypeMap.get(passport_type_no = object[n3]);
                                celllist.add(new Cell((String)passport_type_no, "passport_type_no", t == null ? "" : ((CarparkPassportType)t).getPassport_type_name(), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (CarparkPassportType carparkPassportType : passportTypeMap.values()) {
                                celllist.add(new Cell(carparkPassportType.getPassport_type_no(), "passport_type_no", carparkPassportType.getPassport_type_name(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (groupby.indexOf("service_type") != -1) {
                        ArrayList<Cell> celllist = new ArrayList<Cell>();
                        if (service_types != null && service_types.length() > 0) {
                            String[] stringArray5 = service_types.split(",");
                            object = stringArray5;
                            n4 = stringArray5.length;
                            n3 = 0;
                            while (n3 < n4) {
                                String service_type = object[n3];
                                celllist.add(new Cell(service_type, "service_type", serviceTypeMap.get(Integer.valueOf(service_type)), 1, 1));
                                ++n3;
                            }
                        } else {
                            for (Map.Entry entry : serviceTypeMap.entrySet()) {
                                celllist.add(new Cell(((Integer)entry.getKey()).toString(), "service_type", entry.getValue(), 1, 1));
                            }
                        }
                        hList.add(celllist);
                    }
                    if (hList.size() > 1) {
                        int i4 = 1;
                        while (i4 < hList.size()) {
                            List list = (List)hList.get(i4);
                            for (Cell cell : list) {
                                cell.setColspan(this.getSizecount(hList, i4));
                            }
                            ++i4;
                        }
                    }
                    if (!hList.isEmpty()) {
                        void var42_82;
                        Object parentList = null;
                        int n5 = hList.size() - 1;
                        while (var42_82 >= 0) {
                            if (var42_82 == hList.size() - 1) {
                                headList.add(new LinkedList((Collection)hList.get((int)var42_82)));
                                parentList = (List)hList.get((int)var42_82);
                            } else {
                                LinkedList newList = new LinkedList();
                                List list = (List)hList.get((int)var42_82);
                                object = parentList.iterator();
                                while (object.hasNext()) {
                                    Cell parent = (Cell)object.next();
                                    for (Cell c : list) {
                                        newList.add(new Cell(String.valueOf(parent.getKey()) + "," + c.getKey(), String.valueOf(parent.getName()) + "," + c.getName(), c.getValue(), c.getRowspan(), c.getColspan()));
                                    }
                                }
                                parentList = newList;
                                headList.add(newList);
                            }
                            --var42_82;
                        }
                    }
                    if (rowListMap != null) {
                        ArrayList<Cell> celllist = new ArrayList<Cell>();
                        for (Map.Entry entry : rowListMap.entrySet()) {
                            String text = "month".equals(entry.getValue()) ? entry.getKey() + "\u6708" : ("day".equals(entry.getValue()) ? entry.getKey() + "\u53f7" : ("quarter".equals(entry.getValue()) ? "\u7b2c" + entry.getKey() + "\u5b63\u5ea6" : ("year".equals(entry.getValue()) ? entry.getKey() + "\u5e74" : ((Integer)entry.getKey()).toString())));
                            celllist.add(new Cell(((Integer)entry.getKey()).toString(), (String)entry.getValue(), text, 1, 1));
                        }
                        rList.add(celllist);
                    }
                    if (rList.size() > 1) {
                        int i6 = 1;
                        while (i6 < rList.size()) {
                            List list = (List)rList.get(i6);
                            for (Cell cell : list) {
                                cell.setRowspan(this.getSizecount(rList, i6));
                            }
                            ++i6;
                        }
                    }
                    if (!rList.isEmpty()) {
                        void var42_86;
                        List slist = (List)rList.get(0);
                        boolean bl = true;
                        while (var42_86 < rList.size()) {
                            List s1 = (List)rList.get((int)var42_86);
                            for (Cell c : s1) {
                                c.setCellList(slist);
                            }
                            slist = s1;
                            ++var42_86;
                        }
                        leftList.addAll(slist);
                    }
                } else {
                    sp.setQueryFields(new String[]{"SUM(tran_money) AS money"});
                }
                String RIGHT_TOTAL_TITLE = "rightTotal";
                String BOTTOM_TOTAL_TITLE = "bottomTotal";
                String string = "0.00";
                Cell htotalCell = new Cell(RIGHT_TOTAL_TITLE, "", "\u603b\u8ba1", headList.size() < 1 ? 1 : headList.size(), 1);
                if (!headList.isEmpty()) {
                    ((LinkedList)headList.get(0)).add(htotalCell);
                } else {
                    LinkedList<Cell> c1 = new LinkedList<Cell>();
                    c1.add(htotalCell);
                    headList.add(c1);
                }
                String DATA_NAME = "DATA";
                LinkedList<List<Cell>> dataList = new LinkedList<List<Cell>>();
                LinkedList<Cell> enList = new LinkedList<Cell>();
                enList.addAll((Collection)headList.get(headList.size() - 1));
                if (headList.size() > 1) {
                    enList.add(htotalCell);
                }
                if (!leftList.isEmpty()) {
                    this.setDataList(dataList, leftList, new LinkedList<Cell>(), new LinkedList<Cell>());
                    Cell bottom = new Cell(BOTTOM_TOTAL_TITLE, "", "\u603b\u8ba1", 1, rList.size());
                    LinkedList<Cell> dlist1 = new LinkedList<Cell>();
                    dlist1.add(bottom);
                    dataList.add(dlist1);
                    for (List list : dataList) {
                        Cell lastCell = (Cell)list.get(list.size() - 1);
                        int cIndex = 0;
                        for (Cell c1 : enList) {
                            String string2 = lastCell.getKey();
                            String name1 = lastCell.getName();
                            key2 = c1.getKey();
                            String name2 = c1.getName();
                            if (name1.length() == 0) {
                                Cell ct = new Cell(String.valueOf(key2) + "," + name2, "DATA" + cIndex, string, 1, 1);
                                list.add(ct);
                            } else {
                                String key = string2;
                                String name = name1;
                                if (name2.length() > 0) {
                                    key = String.valueOf(key) + "," + (String)key2;
                                    name = String.valueOf(name) + "," + name2;
                                }
                                String newKey = this.getMapKey(name, key);
                                Cell dataCell = new Cell(newKey, "DATA" + cIndex, string, 1, 1);
                                list.add(dataCell);
                                dataMap.put(newKey, dataCell);
                            }
                            ++cIndex;
                        }
                    }
                    Cell cell = new Cell("cat", "", String.valueOf(tll) + "/\u7c7b\u522b", headList.size(), rList.size());
                    ((LinkedList)headList.get(0)).addFirst(cell);
                } else {
                    LinkedList<Cell> dlist = new LinkedList<Cell>();
                    int h_index = 0;
                    for (Cell c1 : enList) {
                        String string3 = c1.getKey();
                        String name = c1.getName();
                        if (name.length() > 0) {
                            String newKey = this.getMapKey(name, string3);
                            Cell dataCell = new Cell(newKey, "DATA" + h_index, string, 1, 1);
                            dlist.add(dataCell);
                            dataMap.put(newKey, dataCell);
                        } else {
                            Cell ct = new Cell("H_TOTAL" + h_index, "DATA" + h_index, string, 1, 1);
                            dlist.add(ct);
                            dataMap.put("H_TOTAL" + h_index, ct);
                        }
                        ++h_index;
                    }
                    dataList.add(dlist);
                }
                List dbList = commonDaoService.selectList(sp, null);
                String SERVICE_TYPE = "service_type";
                if (!dbList.isEmpty()) {
                    String[] a12 = null;
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    for (Map map : dbList) {
                        BigDecimal money2;
                        if (groupby != null && groupby.length() > 0) {
                            void var55_132;
                            if (a12 == null) {
                                a12 = groupby.split(",");
                            }
                            if ((money = (BigDecimal)map.get("money")) == null || money.doubleValue() == 0.0) continue;
                            key2 = a12;
                            int name1 = a12.length;
                            boolean bl = false;
                            while (var55_132 < name1) {
                                String s1 = key2[var55_132];
                                Object v = map.get(s1);
                                if (SERVICE_TYPE.equals(s1)) {
                                    Integer d = (Integer)serviceTypeATMap.get(v);
                                    v = d;
                                }
                                if (v == null) {
                                    v = "";
                                }
                                treeMap.put(s1, v.toString());
                                ++var55_132;
                            }
                            StringBuilder sbr = new StringBuilder(128);
                            for (Map.Entry entry : treeMap.entrySet()) {
                                if (sbr.length() > 0) {
                                    sbr.append(';');
                                }
                                sbr.append((String)entry.getKey()).append('=').append((String)entry.getValue());
                            }
                            String string4 = sbr.toString();
                            Cell cell = (Cell)dataMap.get(string4);
                            if (cell == null) continue;
                            if (cell.getValue() == null || string.equals(cell.getValue())) {
                                cell.setValue(money.toString());
                                continue;
                            }
                            BigDecimal d = new BigDecimal(cell.getValue().toString());
                            money = money.add(d);
                            cell.setValue(money.toString());
                            continue;
                        }
                        Cell cl1x = (Cell)dataMap.get("H_TOTAL0");
                        if (cl1x == null || (money2 = (BigDecimal)map.get("money")) == null) continue;
                        cl1x.setValue(money2.toString());
                    }
                }
                int rowIndex = 0;
                HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>();
                for (List list : dataList) {
                    BigDecimal m1;
                    money = Constants.MONEY_ZERO;
                    int cIndex = 0;
                    for (Cell cell : list) {
                        if (cell.getName() != null && cell.getName().startsWith("DATA")) {
                            BigDecimal m2;
                            m1 = new BigDecimal(cell.getValue().toString());
                            money = money.add(m1);
                            if (cIndex == list.size() - 1) {
                                cell.setValue(money.toString());
                            }
                            if ((m2 = (BigDecimal)hashMap.get(cell.getName())) == null) {
                                m2 = Constants.MONEY_ZERO;
                            }
                            m2 = m2.add(m1);
                            hashMap.put(cell.getName(), m2);
                        }
                        ++cIndex;
                    }
                    if (rowIndex == dataList.size() - 1) {
                        for (Cell cell : list) {
                            BigDecimal b;
                            if (cell.getName() == null || !cell.getName().startsWith("DATA") || (b = (BigDecimal)hashMap.get(cell.getName())) == null) continue;
                            cell.setValue(b.toString());
                        }
                        cIndex = 0;
                        money = Constants.MONEY_ZERO;
                        for (Cell cell : list) {
                            if (cell.getName() != null && cell.getName().startsWith("DATA")) {
                                m1 = new BigDecimal(cell.getValue().toString());
                                money = money.add(m1);
                                if (cIndex == list.size() - 1) {
                                    cell.setValue(money.toString());
                                }
                            }
                            ++cIndex;
                        }
                    }
                    ++rowIndex;
                }
                request.setAttribute("dataList", dataList);
                request.setAttribute("headList", headList);
                WebUtil.dispathTemplatePage("report/reportMonthFee", request, response);
            }
        }
    }

    @WritePermission
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u6536\u8d39\u7edf\u8ba1-\u5173\u95ed\u7f34\u8d39\u8ba2\u5355\u5728\u7ebf\u5f00\u7968\u529f\u80fd")
    @Path(value="/takeOfflineInvoce.action")
    public void takeOfflineInvoce(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String userName;
        String userCode;
        String tranId = request.getParameter("tranId");
        if (tranId == null || tranId.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u53c2\u6570", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkTransaction transtaction = (CarparkTransaction)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)Long.valueOf(tranId)), CarparkTransaction.class);
        if (transtaction == null) {
            WebUtil.printFinshJson(1, "\u4ea4\u6613\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", response);
            return;
        }
        if (transtaction.getInvoice_status() != null && transtaction.getInvoice_status() == 2) {
            WebUtil.printFinshJson(1, "\u8be5\u4ea4\u6613\u8ba2\u5355\u5df2\u7ecf\u5f00\u4e86\u7ebf\u4e0a\u7535\u5b50\u53d1\u7968\uff0c\u4e0d\u53ef\u518d\u9886\u53d6\u7ebf\u4e0b\u7eb8\u8d28\u53d1\u7968\uff0c\u60a8\u53ef\u91cd\u65b0\u70b9\u51fb\u67e5\u8be2\u5237\u65b0\u5f00\u7968\u72b6\u6001", response);
            return;
        }
        if (transtaction.getInvoice_status() != null && transtaction.getInvoice_status() == 1) {
            WebUtil.printFinshJson(1, "\u8be5\u4ea4\u6613\u8ba2\u5355\u5df2\u7ecf\u9886\u53d6\u4e86\u7ebf\u4e0b\u7eb8\u8d28\u53d1\u7968\uff0c\u4e0d\u53ef\u518d\u91cd\u590d\u9886\u53d6\uff0c\u540c\u65f6\u4e5f\u4e0d\u80fd\u5728\u7ebf\u5f00\u7535\u5b50\u53d1\u7968\u4e86\uff0c\u60a8\u53ef\u91cd\u65b0\u70b9\u51fb\u67e5\u8be2\u5237\u65b0\u5f00\u7968\u72b6\u6001", response);
            return;
        }
        java.util.Date opTime = WebUtil.getNow();
        ClientHost clientHost = WebUtil.getLoginClientHost(request);
        if (clientHost != null) {
            userCode = clientHost.getUserCode();
            userName = clientHost.getUserName();
        } else {
            CarparkUser user = WebUtil.getLoginManageUser(request);
            userCode = user.getUser_code();
            userName = user.getUser_name();
        }
        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        recordSaveService.doTakeOfflineInvoce(transtaction, userCode, userName, opTime);
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f!", response);
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u6536\u8d39\u7edf\u8ba1-\u4ee3\u4ed8\u91d1\u5145\u503c\u8bb0\u5f55\u5bfc\u51fa")
    @Path(value="/exportRechargeBehalfStatistics.action")
    public void exportRechargeBehalfStatistics(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("export", (Object)Boolean.TRUE);
        this.rechargeBehalfStatistics(request, response);
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u6536\u8d39\u7edf\u8ba1-\u4ee3\u4ed8\u91d1\u5145\u503c\u7edf\u8ba1")
    @LeftMenu(name="\u4ee3\u4ed8\u91d1\u5145\u503c\u7edf\u8ba1", parent_name="\u6536\u8d39\u7edf\u8ba1", order=326)
    @Path(value="/rechargeBehalfStatistics.action")
    public void rechargeBehalfStatistics(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("rechargeBehalfStatistics", (Object)Boolean.TRUE);
        this.tranCouponStatistics(request, response);
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u6536\u8d39\u7edf\u8ba1-\u4f18\u60e0\u5238\u7f34\u8d39\u8bb0\u5f55\u5bfc\u51fa")
    @Path(value="/exportTranCouponStatistics.action")
    public void exportTranCouponStatistics(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("export", (Object)Boolean.TRUE);
        this.tranCouponStatistics(request, response);
    }

    /*
     * WARNING - void declaration
     */
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u6536\u8d39\u7edf\u8ba1-\u4f18\u60e0\u5238\u7f34\u8d39\u7edf\u8ba1")
    @LeftMenu(name="\u4f18\u60e0\u5238\u7f34\u8d39\u7edf\u8ba1", parent_name="\u6536\u8d39\u7edf\u8ba1", order=325)
    @Path(value="/tranCouponStatistics.action")
    public void tranCouponStatistics(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        boolean rechargeBehalf = request.getAttribute("rechargeBehalfStatistics") != null;
        ArrayList<KeyValueEntry> serviceTypeList = new ArrayList<KeyValueEntry>(2);
        if (rechargeBehalf) {
            serviceTypeList.add(new KeyValueEntry((Object)11, (Object)"\u4ee3\u4ed8\u91d1\u5145\u503c"));
            serviceTypeList.add(new KeyValueEntry((Object)12, (Object)"\u4ee3\u4ed8\u91d1\u9000\u8d39"));
        } else {
            serviceTypeList.add(new KeyValueEntry((Object)9, (Object)"\u8d2d\u4e70\u4f18\u60e0\u5238"));
            serviceTypeList.add(new KeyValueEntry((Object)10, (Object)"\u4f18\u60e0\u5238\u9000\u8d39"));
        }
        request.setAttribute("serviceTypeList", serviceTypeList);
        if (op == null) {
            Calendar cl = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            request.setAttribute("endTime", (Object)df.format(cl.getTime()));
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            cl.set(14, 0);
            request.setAttribute("startTime", (Object)df.format(cl.getTime()));
            Map<Integer, String> payMethodMapCache = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap();
            LinkedHashMap<Integer, String> payMethodMap = new LinkedHashMap<Integer, String>();
            for (Map.Entry<Integer, String> m : payMethodMapCache.entrySet()) {
                if (m.getKey() == 1 || m.getKey() == 6) continue;
                payMethodMap.put(m.getKey(), m.getValue());
            }
            request.setAttribute("payMethodMap", payMethodMap);
            Map<Integer, String> chargeOrgMap = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap();
            request.setAttribute("chargeOrgMap", chargeOrgMap);
            Map<Integer, String> paySceneMap0 = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap();
            LinkedHashMap<Integer, String> paySceneMap = new LinkedHashMap<Integer, String>();
            for (Map.Entry<Integer, String> e : paySceneMap0.entrySet()) {
                if (e.getKey() == 2 || e.getKey() == 5 || e.getKey() == 4 || e.getKey() == 0) continue;
                paySceneMap.put(e.getKey(), e.getValue());
            }
            request.setAttribute("paySceneMap", paySceneMap);
            if (rechargeBehalf) {
                WebUtil.showMainContentWithHead("\u4ee3\u4ed8\u91d1\u5145\u503c\u7edf\u8ba1", "report/rechargeBehalfStatistics", request, response);
            } else {
                WebUtil.showMainContentWithHead("\u4f18\u60e0\u5238\u7f34\u8d39\u7edf\u8ba1", "report/tranCouponStatistics", request, response);
            }
        } else if ("query".equals(op) || "queryTotalMoney".equals(op) || request.getAttribute("export") != null) {
            String pay_methods;
            String pay_scenes;
            String charge_orgs;
            String start_timeStr = request.getParameter("start_tran_time");
            String end_timeStr = request.getParameter("end_tran_time");
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
            SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkTransaction.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("tran_type", (Object)0);
            if (start_timeStr != null && (start_timeStr = start_timeStr.trim()).length() > 0) {
                try {
                    java.util.Date startTime = this.getTime(start_timeStr);
                    if (startTime != null) {
                        sp.addGTE("tran_time", (Object)startTime);
                    }
                }
                catch (Exception startTime) {
                    // empty catch block
                }
            }
            if (end_timeStr != null && (end_timeStr = end_timeStr.trim()).length() > 0) {
                try {
                    java.util.Date endTime = this.getTime(end_timeStr);
                    if (endTime != null) {
                        sp.addLTE("tran_time", (Object)endTime);
                    }
                }
                catch (Exception endTime) {
                    // empty catch block
                }
            }
            String queryAttr1 = request.getParameter("queryAttr1");
            String queryValue1 = request.getParameter("queryAttr1_value");
            if (queryAttr1 != null && (queryAttr1 = queryAttr1.trim()).length() > 0 && queryValue1 != null && (queryValue1 = queryValue1.trim()).length() > 0) {
                queryValue1 = queryValue1.replaceAll("\"", "").replaceAll("'", "").replaceAll(" ", "");
                sp.addLike(queryAttr1, queryValue1);
            }
            if ((charge_orgs = request.getParameter("charge_org")) != null && (charge_orgs = charge_orgs.trim()).length() > 0) {
                this.setMutiSelect(sp, "charge_org", charge_orgs, Integer.class);
            }
            if ((pay_scenes = request.getParameter("pay_scene")) != null && (pay_scenes = pay_scenes.trim()).length() > 0) {
                this.setMutiSelect(sp, "pay_scene", pay_scenes, Integer.class);
            }
            if ((pay_methods = request.getParameter("pay_method")) != null && (pay_methods = pay_methods.trim()).length() > 0) {
                this.setMutiSelect(sp, "pay_method", pay_methods, Integer.class);
            } else {
                sp.addNotEQ("pay_method", (Object)1);
            }
            String service_types = request.getParameter("service_type");
            if (service_types != null && (service_types = service_types.trim()).length() > 0) {
                this.setMutiSelect(sp, "service_type", service_types, Integer.class);
            } else {
                for (KeyValueEntry ke : serviceTypeList) {
                    sp.addIN("service_type", ke.getKey());
                }
            }
            if ("queryTotalMoney".equals(op)) {
                BigDecimal money;
                Object key1;
                Object operate_user_name;
                Object pay_method;
                Map<Integer, String> chargeOrgMap;
                Map<Integer, String> paySceneMap;
                Map<Integer, String> payMethodMap = this.getMapFromRequest(request, "pay_method", Integer.class);
                if (payMethodMap == null) {
                    payMethodMap = new HashMap<Integer, String>();
                }
                if ((paySceneMap = this.getMapFromRequest(request, "pay_scene", Integer.class)) == null) {
                    paySceneMap = new HashMap<Integer, String>();
                }
                if ((chargeOrgMap = this.getMapFromRequest(request, "charge_org", Integer.class)) == null) {
                    chargeOrgMap = new HashMap<Integer, String>();
                }
                LinkedHashMap<Object, Object> opUserMap = new LinkedHashMap<Object, Object>();
                LinkedHashMap<String, Object> merchantMap = new LinkedHashMap<String, Object>();
                String groupby = request.getParameter("groupby");
                if (groupby != null && (groupby = groupby.trim()).length() > 0) {
                    groupby = groupby.replaceAll("\"", "").replaceAll("'", "").replaceAll(" ", "");
                }
                if (groupby != null && groupby.length() > 0) {
                    sp.setQueryFields(new String[]{groupby, "SUM(tran_money) AS money"});
                    sp.setGoupbySql(groupby);
                } else {
                    sp.setQueryFields(new String[]{"SUM(tran_money) AS money"});
                }
                ArrayList dbList = commonDaoService.selectList(sp, null);
                if (groupby != null && groupby.length() > 0) {
                    groupby = groupby.replace(",goods_name", "").replace(",host_name", "").replace(",operate_user_name", "").replace(",tran_user_name", "");
                }
                if (dbList != null && !dbList.isEmpty()) {
                    Map<Integer, String> allChargeOrgMap = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap();
                    Map<Integer, String> allPaySceneMap = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap();
                    Map<Integer, String> allPayMethodMap = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap();
                    LinkedHashMap<Map, BigDecimal> dataMapxMap = new LinkedHashMap<Map, BigDecimal>();
                    for (Map dataMap : dbList) {
                        BigDecimal bigd;
                        BigDecimal bigDecimal = (BigDecimal)dataMap.remove("money");
                        if (bigDecimal == null) continue;
                        if (groupby != null && groupby.length() > 0) {
                            Integer charge_org;
                            Integer pay_scene;
                            pay_method = (Integer)dataMap.get("pay_method");
                            if (pay_method != null && !payMethodMap.containsKey(pay_method)) {
                                String methodName = allPayMethodMap.get(pay_method);
                                if (methodName == null) {
                                    methodName = "";
                                }
                                payMethodMap.put((Integer)pay_method, methodName);
                            }
                            if ((pay_scene = (Integer)dataMap.get("pay_scene")) != null && !paySceneMap.containsKey(pay_scene)) {
                                String n = allPaySceneMap.get(pay_scene);
                                if (n == null) {
                                    n = "";
                                }
                                paySceneMap.put(pay_scene, n);
                            }
                            if ((charge_org = (Integer)dataMap.get("charge_org")) != null && !chargeOrgMap.containsKey(charge_org)) {
                                String n = allChargeOrgMap.get(charge_org);
                                if (n == null) {
                                    n = "";
                                }
                                chargeOrgMap.put(charge_org, n);
                            }
                            operate_user_name = (String)dataMap.remove("operate_user_name");
                            String operate_user_code = (String)dataMap.get("operate_user_code");
                            if (operate_user_code != null && operate_user_code.length() > 0) {
                                if (operate_user_name == null) {
                                    operate_user_name = "";
                                }
                                if ("USER_CLOUD_CODE".equals(operate_user_code)) {
                                    dataMap.put("operate_user_code", operate_user_name);
                                    if (!opUserMap.containsKey(operate_user_name)) {
                                        opUserMap.put(operate_user_name, operate_user_name);
                                    }
                                } else if (!opUserMap.containsKey(operate_user_code)) {
                                    opUserMap.put(operate_user_code, operate_user_name);
                                }
                            }
                            String string = (String)dataMap.remove("tran_user_name");
                            String string2 = (String)dataMap.get("tran_user_no");
                            if (string2 != null && string2.length() > 0 && !merchantMap.containsKey(string2)) {
                                void var36_137;
                                if (string == null) {
                                    String string3 = "";
                                }
                                merchantMap.put(string2, var36_137);
                            }
                        }
                        if ((bigd = (BigDecimal)dataMapxMap.get(dataMap)) == null) {
                            dataMapxMap.put(dataMap, bigDecimal);
                            continue;
                        }
                        dataMapxMap.put(dataMap, bigDecimal.add(bigd));
                    }
                    if (dataMapxMap != null && !dataMapxMap.isEmpty()) {
                        ArrayList<Map> vlist = new ArrayList<Map>(dataMapxMap.size());
                        for (Map.Entry entry : dataMapxMap.entrySet()) {
                            ((Map)entry.getKey()).put("money", entry.getValue());
                            vlist.add((Map)entry.getKey());
                        }
                        dbList = vlist;
                    } else {
                        dbList = new ArrayList(0);
                    }
                }
                if (opUserMap.isEmpty()) {
                    opUserMap.put("-1", "\u65e0\u6570\u636e(\u6536\u8d39\u5458)");
                }
                if (merchantMap.isEmpty()) {
                    merchantMap.put("-1", "\u65e0\u6570\u636e(\u5546\u6237)");
                }
                LinkedList<Object> headList = new LinkedList<Object>();
                LinkedList<Cell> leftList = new LinkedList<Cell>();
                ArrayList rList = new ArrayList();
                LinkedHashMap<String, Cell> dataMap = new LinkedHashMap<String, Cell>();
                if (groupby != null && groupby.length() > 0) {
                    String t;
                    ArrayList hList = new ArrayList();
                    if (groupby.indexOf("pay_method") != -1) {
                        ArrayList<Cell> arrayList = new ArrayList<Cell>();
                        if (pay_methods != null && pay_methods.length() > 0) {
                            String[] stringArray = pay_methods.split(",");
                            operate_user_name = stringArray;
                            int charge_org = stringArray.length;
                            int pay_scene = 0;
                            while (pay_scene < charge_org) {
                                t = payMethodMap.get(Integer.valueOf((String)(pay_method = operate_user_name[pay_scene])));
                                arrayList.add(new Cell((String)pay_method, "pay_method", t == null ? "" : t, 1, 1));
                                ++pay_scene;
                            }
                        } else {
                            for (Map.Entry entry : payMethodMap.entrySet()) {
                                arrayList.add(new Cell(((Integer)entry.getKey()).toString(), "pay_method", entry.getValue(), 1, 1));
                            }
                        }
                        hList.add(arrayList);
                    }
                    if (groupby.indexOf("service_type") != -1) {
                        ArrayList<Cell> arrayList = new ArrayList<Cell>();
                        if (service_types != null && service_types.length() > 0) {
                            String[] stringArray = service_types.split(",");
                            operate_user_name = stringArray;
                            int charge_org = stringArray.length;
                            int pay_scene = 0;
                            while (pay_scene < charge_org) {
                                String service_type = operate_user_name[pay_scene];
                                String value = "";
                                for (KeyValueEntry keyValueEntry : serviceTypeList) {
                                    if (!((Integer)keyValueEntry.getKey()).toString().equals(service_type)) continue;
                                    value = (String)keyValueEntry.getValue();
                                    break;
                                }
                                arrayList.add(new Cell(service_type, "service_type", value, 1, 1));
                                ++pay_scene;
                            }
                        } else {
                            for (KeyValueEntry keyValueEntry : serviceTypeList) {
                                arrayList.add(new Cell(((Integer)keyValueEntry.getKey()).toString(), "service_type", keyValueEntry.getValue(), 1, 1));
                            }
                        }
                        hList.add(arrayList);
                    }
                    if (groupby.indexOf("pay_scene") != -1) {
                        ArrayList<Cell> arrayList = new ArrayList<Cell>();
                        if (pay_scenes != null && pay_scenes.length() > 0) {
                            String[] stringArray = pay_scenes.split(",");
                            operate_user_name = stringArray;
                            int charge_org = stringArray.length;
                            int pay_scene = 0;
                            while (pay_scene < charge_org) {
                                Object pay_scene2;
                                t = paySceneMap.get(Integer.valueOf((String)(pay_scene2 = operate_user_name[pay_scene])));
                                arrayList.add(new Cell((String)pay_scene2, "pay_scene", t == null ? "" : t, 1, 1));
                                ++pay_scene;
                            }
                        } else {
                            for (Map.Entry<Integer, String> entry : paySceneMap.entrySet()) {
                                arrayList.add(new Cell(entry.getKey().toString(), "pay_scene", entry.getValue(), 1, 1));
                            }
                        }
                        hList.add(arrayList);
                    }
                    if (hList.size() > 1) {
                        void var29_62;
                        boolean bl = true;
                        while (var29_62 < hList.size()) {
                            List list = (List)hList.get((int)var29_62);
                            for (Cell cell : list) {
                                cell.setColspan(this.getSizecount(hList, (int)var29_62));
                            }
                            ++var29_62;
                        }
                    }
                    if (!hList.isEmpty()) {
                        void var30_98;
                        Object var29_63 = null;
                        int n = hList.size() - 1;
                        while (var30_98 >= 0) {
                            if (var30_98 == hList.size() - 1) {
                                headList.add(new LinkedList((Collection)hList.get((int)var30_98)));
                                List list = (List)hList.get((int)var30_98);
                            } else {
                                void var29_64;
                                LinkedList newList = new LinkedList();
                                List list = (List)hList.get((int)var30_98);
                                for (Cell parent : var29_64) {
                                    for (Cell c : list) {
                                        newList.add(new Cell(String.valueOf(parent.getKey()) + "," + c.getKey(), String.valueOf(parent.getName()) + "," + c.getName(), c.getValue(), c.getRowspan(), c.getColspan()));
                                    }
                                }
                                Object object = newList;
                                headList.add(newList);
                            }
                            --var30_98;
                        }
                    }
                    if (groupby.indexOf("tran_user_no") != -1) {
                        ArrayList<Cell> arrayList = new ArrayList<Cell>();
                        for (Map.Entry entry : merchantMap.entrySet()) {
                            arrayList.add(new Cell((String)entry.getKey(), "tran_user_no", entry.getValue(), 1, 1));
                        }
                        rList.add(arrayList);
                    }
                    if (groupby.indexOf("operate_user_code") != -1) {
                        ArrayList<Cell> arrayList = new ArrayList<Cell>();
                        for (Map.Entry entry : opUserMap.entrySet()) {
                            arrayList.add(new Cell((String)entry.getKey(), "operate_user_code", entry.getValue(), 1, 1));
                        }
                        rList.add(arrayList);
                    }
                    if (groupby.indexOf("charge_org") != -1) {
                        ArrayList<Cell> arrayList = new ArrayList<Cell>();
                        if (charge_orgs != null && charge_orgs.length() > 0) {
                            String[] stringArray = charge_orgs.split(",");
                            operate_user_name = stringArray;
                            int parent = stringArray.length;
                            int list = 0;
                            while (list < parent) {
                                Object charge_org;
                                t = chargeOrgMap.get(Integer.valueOf((String)(charge_org = operate_user_name[list])));
                                arrayList.add(new Cell((String)charge_org, "charge_org", t == null ? "" : t, 1, 1));
                                ++list;
                            }
                        } else {
                            for (Map.Entry<Integer, String> entry : chargeOrgMap.entrySet()) {
                                arrayList.add(new Cell(entry.getKey().toString(), "charge_org", entry.getValue(), 1, 1));
                            }
                        }
                        rList.add(arrayList);
                    }
                    if (rList.size() > 1) {
                        void var29_72;
                        boolean bl = true;
                        while (var29_72 < rList.size()) {
                            List list = (List)rList.get((int)var29_72);
                            for (Cell cell : list) {
                                cell.setRowspan(this.getSizecount(rList, (int)var29_72));
                            }
                            ++var29_72;
                        }
                    }
                    if (!rList.isEmpty()) {
                        void var29_74;
                        void var30_105;
                        List list = (List)rList.get(0);
                        boolean bl = true;
                        while (var30_105 < rList.size()) {
                            List s1 = (List)rList.get((int)var30_105);
                            for (Cell c : s1) {
                                c.setCellList((List<Cell>)var29_74);
                            }
                            List list2 = s1;
                            ++var30_105;
                        }
                        leftList.addAll((Collection<Cell>)var29_74);
                    }
                }
                String RIGHT_TOTAL_TITLE = "rightTotal";
                String string = "bottomTotal";
                String string4 = "0.00";
                Cell htotalCell = new Cell(RIGHT_TOTAL_TITLE, "", "\u603b\u8ba1", headList.size() < 1 ? 1 : headList.size(), 1);
                if (!headList.isEmpty()) {
                    ((LinkedList)headList.get(0)).add(htotalCell);
                } else {
                    LinkedList<Cell> c1 = new LinkedList<Cell>();
                    c1.add(htotalCell);
                    headList.add(c1);
                }
                String DATA_NAME = "DATA";
                LinkedList<List<Cell>> dataList = new LinkedList<List<Cell>>();
                LinkedList<Cell> enList = new LinkedList<Cell>();
                enList.addAll((Collection)headList.get(headList.size() - 1));
                if (headList.size() > 1) {
                    enList.add(htotalCell);
                }
                if (!leftList.isEmpty()) {
                    this.setDataList(dataList, leftList, new LinkedList<Cell>(), new LinkedList<Cell>());
                    Cell bottom = new Cell(string, "", "\u603b\u8ba1", 1, rList.size());
                    LinkedList<Cell> linkedList = new LinkedList<Cell>();
                    linkedList.add(bottom);
                    dataList.add(linkedList);
                    for (List list : dataList) {
                        Cell lastCell = (Cell)list.get(list.size() - 1);
                        boolean bl = false;
                        for (Cell cell : enList) {
                            void var37_153;
                            key1 = lastCell.getKey();
                            String name1 = lastCell.getName();
                            String key2 = cell.getKey();
                            String name2 = cell.getName();
                            if (name1.length() == 0) {
                                Cell ct = new Cell(String.valueOf(key2) + "," + name2, "DATA" + (int)var37_153, string4, 1, 1);
                                list.add(ct);
                            } else {
                                Object key = key1;
                                String name = name1;
                                if (name2.length() > 0) {
                                    key = String.valueOf(key) + "," + key2;
                                    name = String.valueOf(name) + "," + name2;
                                }
                                String newKey2 = this.getMapKey(name, (String)key);
                                Cell dataCell = new Cell(newKey2, "DATA" + (int)var37_153, string4, 1, 1);
                                list.add(dataCell);
                                dataMap.put(newKey2, dataCell);
                            }
                            ++var37_153;
                        }
                    }
                    Cell cell = new Cell("cat", "", "\u7c7b\u578b/\u7c7b\u522b", headList.size(), rList.size());
                    ((LinkedList)headList.get(0)).addFirst(cell);
                } else {
                    LinkedList<Cell> dlist = new LinkedList<Cell>();
                    boolean bl = false;
                    for (Cell cell : enList) {
                        void var36_146;
                        String key = cell.getKey();
                        String name = cell.getName();
                        if (name.length() > 0) {
                            String string5 = this.getMapKey(name, key);
                            Cell dataCell = new Cell(string5, "DATA" + (int)var36_146, string4, 1, 1);
                            dlist.add(dataCell);
                            dataMap.put(string5, dataCell);
                        } else {
                            Cell cell2 = new Cell("H_TOTAL" + (int)var36_146, "DATA" + (int)var36_146, string4, 1, 1);
                            dlist.add(cell2);
                            dataMap.put("H_TOTAL" + (int)var36_146, cell2);
                        }
                        ++var36_146;
                    }
                    dataList.add(dlist);
                }
                if (!dbList.isEmpty()) {
                    String[] a1 = null;
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    for (Map map : dbList) {
                        BigDecimal money3;
                        if (groupby != null && groupby.length() > 0) {
                            void var41_175;
                            if (a1 == null) {
                                a1 = groupby.split(",");
                            }
                            if ((money = (BigDecimal)map.get("money")) == null || money.doubleValue() == 0.0) continue;
                            key1 = a1;
                            int dataCell = a1.length;
                            boolean bl = false;
                            while (var41_175 < dataCell) {
                                String s1 = key1[var41_175];
                                Object v = map.get(s1);
                                if (v == null) {
                                    v = "";
                                }
                                treeMap.put(s1, v.toString());
                                ++var41_175;
                            }
                            StringBuilder sbr = new StringBuilder(128);
                            for (Map.Entry entry : treeMap.entrySet()) {
                                if (sbr.length() > 0) {
                                    sbr.append(';');
                                }
                                sbr.append((String)entry.getKey()).append('=').append((String)entry.getValue());
                            }
                            String string6 = sbr.toString();
                            Cell cell = (Cell)dataMap.get(string6);
                            if (cell == null) continue;
                            cell.setValue(money.toString());
                            continue;
                        }
                        Cell cl = (Cell)dataMap.get("H_TOTAL0");
                        if (cl == null || (money3 = (BigDecimal)map.get("money")) == null) continue;
                        cl.setValue(money3.toString());
                    }
                }
                int rowIndex = 0;
                HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>();
                for (List list : dataList) {
                    BigDecimal m1;
                    money = Constants.MONEY_ZERO;
                    int cIndex = 0;
                    for (Cell cell : list) {
                        if (cell.getName() != null && cell.getName().startsWith("DATA")) {
                            BigDecimal m2;
                            m1 = new BigDecimal(cell.getValue().toString());
                            money = money.add(m1);
                            if (cIndex == list.size() - 1) {
                                cell.setValue(money.toString());
                            }
                            if ((m2 = (BigDecimal)hashMap.get(cell.getName())) == null) {
                                m2 = Constants.MONEY_ZERO;
                            }
                            m2 = m2.add(m1);
                            hashMap.put(cell.getName(), m2);
                        }
                        ++cIndex;
                    }
                    if (rowIndex == dataList.size() - 1) {
                        for (Cell cell : list) {
                            BigDecimal b;
                            if (cell.getName() == null || !cell.getName().startsWith("DATA") || (b = (BigDecimal)hashMap.get(cell.getName())) == null) continue;
                            cell.setValue(b.toString());
                        }
                        cIndex = 0;
                        money = Constants.MONEY_ZERO;
                        for (Cell cell : list) {
                            if (cell.getName() != null && cell.getName().startsWith("DATA")) {
                                m1 = new BigDecimal(cell.getValue().toString());
                                money = money.add(m1);
                                if (cIndex == list.size() - 1) {
                                    cell.setValue(money.toString());
                                }
                            }
                            ++cIndex;
                        }
                    }
                    ++rowIndex;
                }
                request.setAttribute("dataList", dataList);
                request.setAttribute("headList", headList);
                if (rechargeBehalf) {
                    WebUtil.dispathTemplatePage("report/rechargeBehalfStatistics", request, response);
                } else {
                    WebUtil.dispathTemplatePage("report/tranCouponStatistics", request, response);
                }
            } else if ("query".equals(op)) {
                String defualtOrderBy = "tran_time asc";
                String sortBy = WebUtil.getOrderBy(request, defualtOrderBy);
                sp.setOrder_by(sortBy);
                Pagination pagination = WebUtil.getPagination(request);
                List queryList = commonDaoService.selectList(sp, pagination);
                if (queryList != null && !queryList.isEmpty()) {
                    SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
                    Map<Integer, String> allChargeOrgMap = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap();
                    Map<Integer, String> allPaySceneMap = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap();
                    Map<Integer, String> allPayMethodMap = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap();
                    for (Map dataMap : queryList) {
                        java.util.Date d1;
                        String v;
                        String passport_number;
                        Integer pay_method = (Integer)dataMap.get("pay_method");
                        Integer pay_scene = (Integer)dataMap.get("pay_scene");
                        Integer n = (Integer)dataMap.get("charge_org");
                        String string = (String)dataMap.get("plate_number");
                        if (string != null) {
                            dataMap.put("plate_number", "");
                        }
                        if ((passport_number = (String)dataMap.get("passport_number")) == null) {
                            dataMap.put("passport_number", passport_number);
                        }
                        if (pay_method != null) {
                            v = allPayMethodMap.get(pay_method);
                            if (v == null) {
                                v = "";
                            }
                            dataMap.put("pay_method_name", v);
                        } else {
                            dataMap.put("pay_method_name", "");
                        }
                        if (pay_scene != null) {
                            v = allPaySceneMap.get(pay_scene);
                            if (v == null) {
                                v = "";
                            }
                            dataMap.put("pay_scene_name", v);
                        } else {
                            dataMap.put("pay_scene_name", "");
                        }
                        if (n != null) {
                            v = allChargeOrgMap.get(n);
                            if (v == null) {
                                v = "";
                            }
                            dataMap.put("charge_org_name", v);
                        } else {
                            dataMap.put("charge_org_name", "");
                        }
                        Integer invoice_status = (Integer)dataMap.get("invoice_status");
                        boolean isonlinepay = pay_method != null && pay_method != 0 && pay_method != 1 && pay_method != 7 && pay_scene != null && pay_scene > 1;
                        dataMap.put("onlinepay", isonlinepay ? Constants.YES_STR : Constants.NO_STR);
                        if (invoice_status == null) {
                            dataMap.put("invoice_status", 0);
                        }
                        if ((d1 = (java.util.Date)dataMap.get("end_date")) != null) {
                            dataMap.put("end_date", df1.format(d1));
                        }
                        if ((d1 = (java.util.Date)dataMap.get("start_date")) == null) continue;
                        dataMap.put("start_date", df1.format(d1));
                    }
                }
                WebUtil.printTableListJson(request, response, queryList, pagination.getRecordsCount());
            } else {
                String f;
                LinkedHashMap<String, String> headAtrrMap = new LinkedHashMap<String, String>();
                if (rechargeBehalf) {
                    headAtrrMap.put("tran_user_name", "\u5546\u6237\u540d\u79f0");
                    headAtrrMap.put("balance_before", "\u5145\u503c\u524d\u4ee3\u4ed8\u91d1\u4f59\u989d");
                    headAtrrMap.put("recharge_money", "\u5145\u503c\u91d1\u989d");
                    headAtrrMap.put("balance", "\u5145\u503c\u540e\u4ee3\u4ed8\u91d1\u4f59\u989d");
                    headAtrrMap.put("tran_time", "\u5145\u503c\u65f6\u95f4");
                    headAtrrMap.put("tran_money", "\u5b9e\u4ed8\u91d1\u989d");
                    headAtrrMap.put("pay_method", "\u652f\u4ed8\u65b9\u5f0f");
                    headAtrrMap.put("pay_scene", "\u652f\u4ed8\u573a\u666f");
                    headAtrrMap.put("charge_org", "\u6536\u8d39\u65b9");
                    headAtrrMap.put("operate_user_name", "\u6536\u8d39\u5458");
                    headAtrrMap.put("tran_des", "\u6536\u8d39\u63cf\u8ff0");
                    f = "rechargeBehalf_";
                } else {
                    headAtrrMap.put("tran_user_name", "\u5546\u6237\u540d\u79f0");
                    headAtrrMap.put("goods_name", "\u4f18\u60e0\u5238\u540d");
                    headAtrrMap.put("start_date", "\u751f\u6548\u65e5\u671f");
                    headAtrrMap.put("end_date", "\u6709\u6548\u622a\u6b62\u65e5\u671f");
                    headAtrrMap.put("tran_quantity", "\u8d2d\u4e70\u5f20\u6570");
                    headAtrrMap.put("tran_time", "\u8d2d\u4e70\u65f6\u95f4");
                    headAtrrMap.put("tran_money", "\u8d2d\u4e70\u91d1\u989d");
                    headAtrrMap.put("pay_method", "\u652f\u4ed8\u65b9\u5f0f");
                    headAtrrMap.put("pay_scene", "\u652f\u4ed8\u573a\u666f");
                    headAtrrMap.put("charge_org", "\u6536\u8d39\u65b9");
                    headAtrrMap.put("operate_user_name", "\u6536\u8d39\u5458");
                    headAtrrMap.put("tran_des", "\u6536\u8d39\u63cf\u8ff0");
                    f = "buyCoupon_";
                }
                ExportService exportService = (ExportService)ServiceUtil.getServiceContext().getService(ExportService.class);
                response.setContentType("text/plain; charset=GBK");
                response.setCharacterEncoding("GBK");
                SimpleDateFormat df11 = new SimpleDateFormat("yyyyMMddHHmmss");
                response.addHeader("Content-Disposition", "attachment;filename=" + f + df11.format(new java.util.Date()) + ".csv");
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setDateHeader("Expires", 0L);
                try (PrintWriter out = response.getWriter();){
                    exportService.exportMonthPayRecordCsv(sp, headAtrrMap, out);
                }
            }
        }
    }

    private java.util.Date getTime(String dateStr) throws ParseException {
        String st = dateStr;
        String forMat = st.length() == 16 ? "yyyy-MM-dd HH:mm" : (st.length() == 10 ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss");
        return new SimpleDateFormat(forMat).parse(st);
    }

    private void setMutiSelect(SearchParam sp, String key, String values, Class<?> cls) {
        if (key != null && key.length() > 0 && values != null && (values = values.trim()).length() > 0) {
            int h1 = values.indexOf(44);
            if (h1 == -1) {
                if (Integer.class.equals(cls) || Integer.TYPE.equals(cls)) {
                    sp.addEQ(key, (Object)Integer.valueOf(values));
                } else if (Long.class.equals(cls) || Long.TYPE.equals(cls)) {
                    sp.addEQ(key, (Object)Long.valueOf(values));
                } else {
                    sp.addEQ(key, (Object)values);
                }
            } else {
                String[] as;
                String[] stringArray = as = values.split(",");
                int n = as.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if ((s = s.trim()).length() != 0) {
                        if (Integer.class.equals(cls) || Integer.TYPE.equals(cls)) {
                            sp.addEQ(key, (Object)Integer.valueOf(s));
                        } else if (Long.class.equals(cls) || Long.TYPE.equals(cls)) {
                            sp.addEQ(key, (Object)Long.valueOf(s));
                        } else {
                            sp.addIN(key, (Object)s);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private <T> Map<T, String> getMapFromRequest(HttpServletRequest request, String name, Class<T> keyCl) {
        boolean intkey;
        String mapName = "map_" + name;
        String values = request.getParameter(mapName);
        boolean bl = intkey = Integer.class.equals(keyCl) || Integer.TYPE.equals(keyCl);
        if (values == null || (values = values.trim()).length() == 0 || !values.startsWith("{") || !values.endsWith("}")) {
            return null;
        }
        try {
            if (intkey) {
                Map map = (Map)GsonBuilder.create().fromJson(values, new TypeToken<Map<Integer, String>>(){}.getType());
                return map;
            }
            Map map = (Map)GsonBuilder.create().fromJson(values, new TypeToken<Map<String, String>>(){}.getType());
            return map;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

