/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action.manage;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.cloud.client.HostSate;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkChannelArea;
import com.wovoe.carpark.dto.CarparkEquipment;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.dto.CarparkRolePermission;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.BasicSettingService;
import com.wovoe.carpark.web.LeftMenu;
import com.wovoe.carpark.web.Permission;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.carpark.web.WritePermission;
import com.wovoe.carpark.web.action.InstallInitAction;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.http.HttpResponseCallback;
import com.wovoe.framework.http.HttpUtil;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.security.Key;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;

@Action(value="/manage")
public class CarparkHostSettingAction {
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u5c97\u4ead/\u4e3b\u673a\u8bbe\u7f6e(\u67e5\u8be2)")
    @LeftMenu(name="\u5c97\u4ead/\u4e3b\u673a\u8bbe\u7f6e", parent_name="\u57fa\u7840\u8bbe\u7f6e", order=113)
    @Path(value="/showCarparkHost.action")
    public void showCarparkHost(HttpServletRequest request, HttpServletResponse response) throws Exception {
        CarparkHost host;
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        List hostList = commonDaoService.selectList(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).setOrerbySql("host_no"), CarparkHost.class, null);
        Map hostsMap = ServiceUtil.toMap(hostList, "host_no");
        CarparkHost serverHost = null;
        Iterator its = hostList.iterator();
        while (its.hasNext()) {
            host = (CarparkHost)its.next();
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() == 1) {
                if (host.getHost_use() != 2 && host.getHost_use() != 3) continue;
                its.remove();
                serverHost = host;
                break;
            }
            if (!host.getHost_no().equals(ServiceUtil.getServiceContext().getLocalHostNo())) continue;
            its.remove();
            serverHost = host;
            break;
        }
        if (serverHost == null) {
            throw new RuntimeException("\u670d\u52a1\u5668\u4e22\u5931\uff01");
        }
        request.setAttribute("serverHost", serverHost);
        if (hostList != null && !hostList.isEmpty()) {
            request.setAttribute("hostList", (Object)hostList);
        }
        String hostNo = request.getParameter("hostNo");
        host = serverHost;
        if (hostNo != null && (hostNo = hostNo.trim()).length() > 0) {
            if (!hostNo.equals(serverHost.getHost_no()) && hostList != null && !hostList.isEmpty()) {
                for (CarparkHost hostx : hostList) {
                    if (!hostNo.equals(hostx.getHost_no())) continue;
                    host = hostx;
                }
            }
        } else {
            CarparkHost localHost = (CarparkHost)hostsMap.get(ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_no());
            if (localHost != null) {
                host = localHost;
            }
        }
        request.setAttribute("host", (Object)host);
        List channels = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"id", "channel_no", "channel_name", "managed_host_no", "slave_managed_host_no"}).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).setOrerbySql("channel_name"), CarparkChannel.class, null);
        ArrayList hostMangedChannelList = new ArrayList();
        ArrayList unManageChannelList = new ArrayList();
        ArrayList slaveHostMangedChannelList = new ArrayList();
        ArrayList slaveUnManageChannelList = new ArrayList();
        HashSet<String> needQueyChannelNos = new HashSet<String>();
        int cCount = 0;
        if (channels != null && !channels.isEmpty()) {
            for (CarparkChannel channel : channels) {
                CarparkHost mhost;
                HashMap<String, Object> dmap = new HashMap<String, Object>();
                dmap.put("channel_no", channel.getChannel_no());
                dmap.put("channel_name", channel.getChannel_name());
                dmap.put("channel_id", channel.getId());
                if (channel.getManaged_host_no() == null || channel.getManaged_host_no().length() == 0) {
                    unManageChannelList.add(dmap);
                    needQueyChannelNos.add(channel.getChannel_no());
                } else {
                    mhost = (CarparkHost)hostsMap.get(channel.getManaged_host_no());
                    if (mhost == null || mhost.getHost_use() == 2) {
                        unManageChannelList.add(dmap);
                        needQueyChannelNos.add(channel.getChannel_no());
                    } else if (host.getHost_no().equals(mhost.getHost_no())) {
                        hostMangedChannelList.add(dmap);
                        needQueyChannelNos.add(channel.getChannel_no());
                    }
                }
                dmap = new HashMap();
                dmap.put("channel_no", channel.getChannel_no());
                dmap.put("channel_name", channel.getChannel_name());
                dmap.put("channel_id", channel.getId());
                if (channel.getSlave_managed_host_no() == null || channel.getSlave_managed_host_no().length() == 0) {
                    slaveUnManageChannelList.add(dmap);
                    needQueyChannelNos.add(channel.getChannel_no());
                } else {
                    mhost = (CarparkHost)hostsMap.get(channel.getSlave_managed_host_no());
                    if (mhost == null || mhost.getHost_use() == 2) {
                        slaveUnManageChannelList.add(dmap);
                        needQueyChannelNos.add(channel.getChannel_no());
                    } else if (host.getHost_no().equals(mhost.getHost_no())) {
                        slaveHostMangedChannelList.add(dmap);
                        needQueyChannelNos.add(channel.getChannel_no());
                    }
                }
                if (channel.getManaged_host_no() != null && channel.getManaged_host_no().length() != 0 || channel.getSlave_managed_host_no() != null && channel.getSlave_managed_host_no().length() != 0) continue;
                ++cCount;
            }
        }
        HashMap<String, LinkedList<CarparkChannelArea>> channelAreaMap = null;
        Map areaMap = null;
        if (!needQueyChannelNos.isEmpty()) {
            SearchParam p1 = new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).setQueryFields(new String[]{"channel_no", "area_no", "channel_direction"}).setOrerbySql("channel_no,area_no,channel_direction");
            if (needQueyChannelNos.size() == 1) {
                p1.addEQ("channel_no", ServiceUtil.getFirstElement(needQueyChannelNos));
            } else {
                p1.addINList("channel_no", needQueyChannelNos);
            }
            List channelAreaList = commonDaoService.selectList(p1, CarparkChannelArea.class, null);
            if (channelAreaList != null && !channelAreaList.isEmpty()) {
                channelAreaMap = new HashMap<String, LinkedList<CarparkChannelArea>>();
                HashSet<String> areaNos = new HashSet<String>();
                for (CarparkChannelArea ca : channelAreaList) {
                    LinkedList<CarparkChannelArea> l = (LinkedList<CarparkChannelArea>)channelAreaMap.get(ca.getChannel_no());
                    if (l == null) {
                        l = new LinkedList<CarparkChannelArea>();
                        channelAreaMap.put(ca.getChannel_no(), l);
                    }
                    l.add(ca);
                    areaNos.add(ca.getArea_no());
                }
                if (areaNos != null && !areaNos.isEmpty()) {
                    p1 = new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).setQueryFields(new String[]{"area_no", "area_level", "area_name"});
                    if (areaNos.size() == 1) {
                        p1.addEQ("area_no", ServiceUtil.getFirstElement(areaNos));
                    } else {
                        p1.addINList("area_no", areaNos);
                    }
                    List areaList = commonDaoService.selectList(p1, CarparkArea.class, null);
                    if (areaList != null && !areaList.isEmpty()) {
                        areaMap = ServiceUtil.toMap(areaList, "area_no");
                    }
                }
            }
        }
        Object[] xlist = new Object[]{hostMangedChannelList, unManageChannelList, slaveHostMangedChannelList, slaveUnManageChannelList};
        Object[] objectArray = xlist;
        int areaList = xlist.length;
        int areaNos = 0;
        while (areaNos < areaList) {
            Object obj = objectArray[areaNos];
            List sl = (List)obj;
            if (sl != null && !sl.isEmpty() && channelAreaMap != null && areaMap != null) {
                for (Map d : sl) {
                    List als;
                    String channel_no = (String)d.get("channel_no");
                    if (channel_no == null || (als = (List)channelAreaMap.get(channel_no)) == null || als.isEmpty()) continue;
                    StringBuilder sbr = new StringBuilder();
                    for (CarparkChannelArea a : als) {
                        CarparkArea ar;
                        if (sbr.length() > 0) {
                            sbr.append('\u3001');
                        }
                        if ((ar = (CarparkArea)areaMap.get(a.getArea_no())) != null) {
                            sbr.append(ar.getArea_name());
                        }
                        sbr.append(' ').append('[').append(a.getChannel_direction() == 0 ? "\u5165\u53e3" : "\u51fa\u53e3").append(']');
                    }
                    d.put("areaDes", sbr.toString());
                }
            }
            ++areaNos;
        }
        if (!hostMangedChannelList.isEmpty()) {
            request.setAttribute("hostMangedChannelList", hostMangedChannelList);
        }
        if (!unManageChannelList.isEmpty()) {
            request.setAttribute("unManageChannelList", unManageChannelList);
        }
        if (!slaveHostMangedChannelList.isEmpty()) {
            request.setAttribute("slaveHostMangedChannelList", slaveHostMangedChannelList);
        }
        if (!slaveUnManageChannelList.isEmpty()) {
            request.setAttribute("slaveUnManageChannelList", slaveUnManageChannelList);
        }
        boolean cloudDeploycarpark = false;
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
            cloudDeploycarpark = true;
        }
        request.setAttribute("cloudDeploycarpark", (Object)(cloudDeploycarpark ? "1" : "0"));
        if (cloudDeploycarpark) {
            if (cCount > 0) {
                request.setAttribute("unManageChannelSize", (Object)cCount);
            }
        } else if (!unManageChannelList.isEmpty()) {
            request.setAttribute("unManageChannelSize", (Object)unManageChannelList.size());
        }
        if (host.getHost_no().equals(serverHost.getHost_no())) {
            if (!cloudDeploycarpark) {
                Set<String> serverIpv4set = ServiceUtil.getServiceContext().getLocalIpv4(false);
                if (serverIpv4set == null) {
                    serverIpv4set = new HashSet<String>();
                }
                if (!serverIpv4set.contains(serverHost.getHost_ip())) {
                    request.setAttribute("invalidServerIpv4", (Object)Boolean.TRUE);
                }
                request.setAttribute("serverIpv4set", serverIpv4set);
            } else {
                request.setAttribute("hostOnline", (Object)ServiceUtil.getServiceContext().isConected(host.getHost_no()));
            }
        } else {
            request.setAttribute("hostOnline", (Object)ServiceUtil.getServiceContext().isHostOnline(host.getHost_no()));
        }
        if (!cloudDeploycarpark) {
            BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
            Map<String, String> eqIpSet = basicSettingService.getAllEquipmentIpSetMap(carpark_id, project_id, commonDaoService);
            if (eqIpSet.containsKey(host.getHost_ip())) {
                Object eq;
                String equipment_no = eqIpSet.get(host.getHost_ip());
                String eqName = "\u4e0e\u8bbe\u5907";
                if (equipment_no != null && equipment_no.length() > 0 && (eq = (CarparkEquipment)commonDaoService.selectOne(new SearchParam().setQueryFields(new String[]{"equipment_name"}).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("equipment_no", (Object)equipment_no), CarparkEquipment.class)) != null) {
                    eqName = String.valueOf(eqName) + "[" + ((CarparkEquipment)eq).getEquipment_name() + "]";
                }
                request.setAttribute("ipcrash", (Object)(String.valueOf(eqName) + "IP\u51b2\u7a81"));
            }
            HashMap<String, String> hostIpSet = new HashMap<String, String>();
            for (CarparkHost ho : hostsMap.values()) {
                if (ho.getHost_ip() == null || ho.getHost_ip().length() <= 0 || ho.getHost_no().equals(host.getHost_no())) continue;
                hostIpSet.put(ho.getHost_ip(), ho.getHost_name());
            }
            if (hostIpSet.containsKey(host.getHost_ip())) {
                request.setAttribute("ipcrash", (Object)("\u4e0e\u4e3b\u673a[" + (String)hostIpSet.get(host.getHost_ip()) + "]IP\u51b2\u7a81"));
            }
            HashSet<String> allIpSet = new HashSet<String>();
            for (String s : eqIpSet.keySet()) {
                allIpSet.add(s);
            }
            for (String s : hostIpSet.keySet()) {
                allIpSet.add(s);
            }
            allIpSet.add(host.getHost_ip());
            String availableIp = basicSettingService.getAvailableIp(allIpSet, host.getHost_ip());
            if (availableIp != null && availableIp.length() > 0) {
                request.setAttribute("availableIp", (Object)availableIp);
            }
        } else if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() == 1) {
            if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_no().equals(host.getHost_no())) {
                request.removeAttribute("hostOnline");
                request.setAttribute("localHostIps", ServiceUtil.getServiceContext().getLocalIpv4(true));
                request.setAttribute("localHostHttpPort", (Object)String.valueOf(ServiceUtil.getServiceContext().getHttpServiceServer().getPort()));
            } else if (host.getHost_use() == 1) {
                HostSate hostState = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanHostSate(host.getHost_no());
                if (hostState != null) {
                    request.setAttribute("lanConnectedIp", (Object)hostState.getLanSocketAddress().getAddress().getHostAddress());
                    request.setAttribute("lanConnectedHttpPort", (Object)String.valueOf(hostState.getHttpPort()));
                } else {
                    request.setAttribute("lanConnectedIp", (Object)"unConnected");
                }
            }
        }
        WebUtil.showMainContentWithHead("\u5c97\u4ead/\u4e3b\u673a\u8bbe\u7f6e", "carparkHost", request, response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u5c97\u4ead/\u4e3b\u673a\u8bbe\u7f6e-\u65b0\u589e\u5c97\u4ead/\u4e3b\u673a")
    @Path(value="/addCarparkHost.action")
    public void addCarparkHost(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int host_port;
        String host_ip;
        int net_mode;
        String host_name = request.getParameter("host_name");
        String net_mode_str = request.getParameter("net_mode");
        String host_type_str = request.getParameter("host_type");
        String manage_channelNos = request.getParameter("manage_channelNos");
        String host_use_str = request.getParameter("host_use");
        if (host_name == null || (host_name = host_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u5c97\u4ead\u540d\u79f0", response);
            return;
        }
        if (host_name.getBytes("UTF-8").length > 45) {
            WebUtil.printFinshJson(1, "\u5c97\u4ead\u540d\u79f0\u592a\u957f!", response);
            return;
        }
        if (net_mode_str == null || (net_mode_str = net_mode_str.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u9009\u62e9\u7f51\u7edc\u6a21\u5f0f", response);
            return;
        }
        if (host_use_str == null || (host_use_str = host_use_str.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u9009\u62e9\u4e3b\u673a\u90e8\u7f72\u7c7b\u578b", response);
            return;
        }
        if (!String.valueOf(1).equals(host_use_str)) {
            WebUtil.printFinshJson(1, "\u9519\u8bef\u7684\u4e3b\u673a\u90e8\u7f72\u7c7b\u578b", response);
            return;
        }
        try {
            net_mode = Integer.parseInt(net_mode_str);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u9519\u8bef\u7684\u7f51\u7edc\u6a21\u5f0f", response);
            return;
        }
        if (net_mode != 1 && net_mode != 2) {
            WebUtil.printFinshJson(1, "\u9519\u8bef\u7684\u7f51\u7edc\u6a21\u5f0f", response);
            return;
        }
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        if (net_mode == 1) {
            BasicSettingService basicSettingService;
            Map<String, String> eqIpSet;
            host_ip = request.getParameter("host_ip");
            String host_port_str = request.getParameter("host_port");
            if (host_ip == null || (host_ip = host_ip.trim()).length() == 0) {
                WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u7ba1\u7406\u4e3b\u673aIP\u5730\u5740", response);
                return;
            }
            if (host_port_str == null || (host_port_str = host_port_str.trim()).length() == 0) {
                WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u7ba1\u7406\u4e3b\u673a\u7aef\u53e3\u53f7", response);
                return;
            }
            if (host_type_str == null || (host_type_str = host_type_str.trim()).length() == 0) {
                host_type_str = String.valueOf(1);
            }
            try {
                host_port = Integer.parseInt(host_port_str);
                if (host_port <= 1 || host_port >= 65535) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7aef\u53e3\u53f7,\u7aef\u53e3\u53f7\u5e94\u8be5\u5728(1,65535)\u4e4b\u95f4", response);
                return;
            }
            if (host_name.getBytes("UTF-8").length > 45) {
                WebUtil.printFinshJson(1, "\u5c97\u4ead\u540d\u79f0\u592a\u957f!", response);
                return;
            }
            List hostList = commonDaoService.selectList(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).setOrerbySql("host_no"), CarparkHost.class, null);
            if (hostList != null && !hostList.isEmpty()) {
                for (CarparkHost h1 : hostList) {
                    if (host_name.equals(h1.getHost_name())) {
                        WebUtil.printFinshJson(1, "\u4e3b\u673a\u540d[" + host_name + "] \u5df2\u7ecf\u5b58\u5728,\u8bf7\u91cd\u65b0\u547d\u540d!", response);
                        return;
                    }
                    if (!host_ip.equals(h1.getHost_ip())) continue;
                    WebUtil.printFinshJson(1, "IP\u4e0e\u4e3b\u673a[" + h1.getHost_name() + "] \u51b2\u7a81\uff01\u8bf7\u91cd\u65b0\u5206\u914d!", response);
                    return;
                }
            }
            if ((eqIpSet = (basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class)).getAllEquipmentIpSetMap(carpark_id, project_id, commonDaoService)).containsKey(host_ip)) {
                CarparkEquipment eq;
                String equipment_no = eqIpSet.get(host_ip);
                String eqName = "\u4e3b\u673aIP\u4e0e\u8bbe\u5907";
                if (equipment_no != null && equipment_no.length() > 0 && (eq = (CarparkEquipment)commonDaoService.selectOne(new SearchParam().setQueryFields(new String[]{"equipment_name"}).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("equipment_no", (Object)equipment_no), CarparkEquipment.class)) != null) {
                    eqName = String.valueOf(eqName) + "[" + eq.getEquipment_name() + "]";
                }
                WebUtil.printFinshJson(1, String.valueOf(eqName) + "\u51b2\u7a81\uff01\u8bf7\u91cd\u65b0\u5206\u914d!", response);
                return;
            }
        } else {
            host_port = 80;
            Random r = new Random();
            host_ip = new StringBuilder(32).append(this.getRand(20, 180, r)).append('.').append(this.getRand(1, 250, r)).append('.').append(this.getRand(1, 250, r)).append('.').append(this.getRand(1, 250, r)).toString();
        }
        Date now = WebUtil.getNow();
        CarparkHost host = new CarparkHost();
        host.setCarpark_id(carpark_id);
        host.setCreated_time(now);
        host.setDisable(0);
        host.setHost_ip(host_ip);
        host.setHost_name(host_name);
        host.setHost_port(host_port);
        host.setHost_type(Integer.parseInt(host_type_str));
        host.setHost_use(1);
        host.setLast_updated_time(now);
        host.setNet_mode(Integer.parseInt(net_mode_str));
        host.setProject_id(project_id);
        int insertCount = 0;
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                String[] nos;
                host.setId(commonDaoService.getSequece("ck_common_seq"));
                host.setHost_no("C" + host.getId());
                insertCount = commonDaoService.insert(session, (Object)host);
                if (manage_channelNos != null && (manage_channelNos = manage_channelNos.trim()).length() > 0 && (nos = manage_channelNos.split(",")) != null && nos.length > 0) {
                    String[] stringArray = nos;
                    int n = nos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if ((s = s.trim()).length() > 0) {
                            CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkChannel.class));
                            updateP.addEQ("channel_no", (Object)s).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                            updateP.addUpdate("managed_host_no", (Object)host.getHost_no());
                            commonDaoService.update(session, updateP);
                        }
                        ++n2;
                    }
                }
                CarparkRolePermission p = new CarparkRolePermission();
                p.setCarpark_id(carpark_id);
                p.setId(commonDaoService.getSequece("ck_common_seq"));
                p.setLast_updated_time(now);
                p.setPermission_no("long_host_client_" + host.getHost_no());
                p.setProject_id(project_id);
                p.setRole_no("2");
                commonDaoService.insert(session, (Object)p);
                StringBuilder op_des = new StringBuilder(128);
                op_des.append("\u65b0\u589e\u5c97\u4ead\u901a\u9053\u7ba1\u7406\u4e3b\u673a:").append(host.getHost_name()).append("[").append(host.getHost_ip()).append(']');
                WebUtil.insertCarparkOperationLog(session, request, Constants.LOG_OP_CAT_5, Constants.LOG_OP_TYPE_CAT_5_2, op_des.toString());
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        if (insertCount > 0) {
            WebUtil.printFinshJson(0, host.getHost_no(), response);
        } else {
            WebUtil.printFinshJson(2, "\u6570\u636e\u4fdd\u5b58\u5931\u8d25!", response);
        }
    }

    private int getRand(int begin, int end, Random r) {
        int len;
        if (begin < 0) {
            begin = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > begin) {
            len = end - begin + 1;
        } else if (end < begin) {
            len = begin - end + 1;
        } else {
            return begin;
        }
        if (len <= 1) {
            return begin;
        }
        int h1 = Math.abs(r.nextInt());
        return begin + h1 % len;
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u5c97\u4ead/\u4e3b\u673a\u8bbe\u7f6e-\u4fee\u6539\u5c97\u4ead/\u4e3b\u673a")
    @Path(value="/updateCarparkHost.action")
    public void updateCarparkHost(HttpServletRequest request, HttpServletResponse response) throws Exception {
        CarparkHost localHost;
        int host_type;
        int host_port;
        String hostNo = request.getParameter("hostNo");
        if (hostNo == null || (hostNo = hostNo.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u4e3b\u673a\u7f16\u53f7", response);
            return;
        }
        String host_name = request.getParameter("host_name");
        String host_type_str = request.getParameter("host_type");
        String host_ip = request.getParameter("host_ip");
        String host_port_str = request.getParameter("host_port");
        String manage_channelNos = request.getParameter("manage_channelNos");
        String unmanage_channelNos = request.getParameter("unmanage_channelNos");
        String host_use_str = request.getParameter("host_use");
        if (host_name == null || (host_name = host_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u5c97\u4ead\u540d\u79f0", response);
            return;
        }
        if (host_name.getBytes("UTF-8").length > 45) {
            WebUtil.printFinshJson(1, "\u5c97\u4ead\u540d\u79f0\u592a\u957f!", response);
            return;
        }
        if (host_use_str == null || (host_use_str = host_use_str.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u9009\u62e9\u4e3b\u673a\u7c7b\u578b", response);
            return;
        }
        if (host_ip == null || (host_ip = host_ip.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u7ba1\u7406\u4e3b\u673aIP\u5730\u5740", response);
            return;
        }
        if (host_port_str == null || (host_port_str = host_port_str.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u7ba1\u7406\u4e3b\u673a\u7aef\u53e3\u53f7", response);
            return;
        }
        if (host_type_str == null || (host_type_str = host_type_str.trim()).length() == 0) {
            host_type_str = String.valueOf(1);
        }
        try {
            host_port = Integer.parseInt(host_port_str);
            if (host_port <= 1 || host_port >= 65535) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7aef\u53e3\u53f7,\u7aef\u53e3\u53f7\u5e94\u8be5\u5728(1,65535)\u4e4b\u95f4", response);
            return;
        }
        int host_use = Integer.parseInt(host_use_str);
        boolean isLocalServer = hostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo());
        if (isLocalServer) {
            if (host_use != 2 && host_use != 3) {
                WebUtil.printFinshJson(1, "\u9519\u8bef\u7684\u4e3b\u673a\u7c7b\u578b", response);
                return;
            }
        } else if (host_use != 1) {
            WebUtil.printFinshJson(1, "\u9519\u8bef\u7684\u4e3b\u673a\u7c7b\u578b", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        List hostList = commonDaoService.selectList(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).setOrerbySql("host_no"), CarparkHost.class, null);
        CarparkHost oldHost = null;
        if (hostList != null && !hostList.isEmpty()) {
            for (CarparkHost h1 : hostList) {
                if (!h1.getHost_no().equals(hostNo)) continue;
                oldHost = h1;
                break;
            }
        }
        if (oldHost == null) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u4e3b\u673a\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664!", response);
            return;
        }
        int net_mode = oldHost.getNet_mode();
        if (!oldHost.getHost_name().equals(host_name)) {
            for (CarparkHost h1 : hostList) {
                if (h1.getHost_no().equals(hostNo) || !host_name.equals(h1.getHost_name())) continue;
                WebUtil.printFinshJson(1, "\u4e3b\u673a\u540d[" + host_name + "] \u5df2\u7ecf\u5b58\u5728,\u8bf7\u91cd\u65b0\u547d\u540d!", response);
                return;
            }
        }
        if (!oldHost.getHost_ip().equals(host_ip)) {
            for (CarparkHost h1 : hostList) {
                if (h1.getHost_no().equals(hostNo) || !host_ip.equals(h1.getHost_ip())) continue;
                WebUtil.printFinshJson(1, "IP\u4e0e\u4e3b\u673a[" + h1.getHost_name() + "] \u51b2\u7a81\uff01\u8bf7\u91cd\u65b0\u5206\u914d!", response);
                return;
            }
            BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
            Map<String, String> eqIpSet = basicSettingService.getAllEquipmentIpSetMap(carpark_id, project_id, commonDaoService);
            if (eqIpSet.containsKey(host_ip)) {
                CarparkEquipment eq;
                String equipment_no = eqIpSet.get(host_ip);
                String eqName = "\u4e3b\u673aIP\u4e0e\u8bbe\u5907";
                if (equipment_no != null && equipment_no.length() > 0 && (eq = (CarparkEquipment)commonDaoService.selectOne(new SearchParam().setQueryFields(new String[]{"equipment_name"}).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("equipment_no", (Object)equipment_no), CarparkEquipment.class)) != null) {
                    eqName = String.valueOf(eqName) + "[" + eq.getEquipment_name() + "]";
                }
                WebUtil.printFinshJson(1, String.valueOf(eqName) + "\u51b2\u7a81\uff01\u8bf7\u91cd\u65b0\u5206\u914d!", response);
                return;
            }
        }
        boolean needAdviceOtherHost = false;
        String restartServerUrl = null;
        if (isLocalServer) {
            if (oldHost.getHost_port() != host_port) {
                restartServerUrl = "http://" + host_ip;
                if (host_port != 80) {
                    restartServerUrl = String.valueOf(restartServerUrl) + ":" + host_port;
                }
                restartServerUrl = String.valueOf(restartServerUrl) + "/manage/showCarparkHost.action";
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put("loginUserCode", WebUtil.getLoginManageUser(request).getUser_code());
                Calendar cl = Calendar.getInstance();
                cl.add(12, 5);
                dataMap.put("timeount", String.valueOf(cl.getTimeInMillis()));
                String sign = CryptoUtil.MD5Encode((String)(String.valueOf((String)dataMap.get("loginUserCode")) + "," + (String)dataMap.get("timeount") + "," + ServiceUtil.getServiceContext().getCarpark().getLan_sign_key()));
                dataMap.put("sign", sign);
                String value = GsonBuilder.create().toJson(dataMap);
                Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                restartServerUrl = String.valueOf(restartServerUrl) + "?vtocken1=" + CryptoUtil.encrypt((String)value, (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
                needAdviceOtherHost = true;
            }
            if (!oldHost.getHost_ip().equals(host_ip)) {
                needAdviceOtherHost = true;
            }
        }
        CarparkLocalConfig localConfig = null;
        if (isLocalServer) {
            if (host_use != oldHost.getHost_use()) {
                if (localConfig == null) {
                    localConfig = new CarparkLocalConfig();
                }
                localConfig.setHost_use(host_use);
            }
            if (net_mode != oldHost.getNet_mode()) {
                if (localConfig == null) {
                    localConfig = new CarparkLocalConfig();
                }
                localConfig.setNet_mode(net_mode);
            }
            if (needAdviceOtherHost) {
                String newHostPort = String.valueOf(host_ip) + ":" + host_port;
                if (localConfig == null) {
                    localConfig = new CarparkLocalConfig();
                }
                localConfig.setServer_host_port(newHostPort);
            }
        }
        boolean insertLog = false;
        StringBuilder op_des = new StringBuilder(128);
        op_des.append("\u4fee\u6539");
        if (host_use == 1) {
            op_des.append("\u5c97\u4ead\u4e3b\u673a");
        } else {
            op_des.append("\u505c\u8f66\u573a\u670d\u52a1\u5668\u4e3b\u673a");
        }
        if (!host_name.equals(oldHost.getHost_name())) {
            if (!insertLog) {
                insertLog = true;
            }
            op_des.append("(").append(oldHost.getHost_name()).append(")\u540d\u79f0\u53d8\u66f4\u4e3a:").append(host_name);
        } else {
            op_des.append("(").append(oldHost.getHost_name()).append("");
        }
        if (!host_ip.equals(oldHost.getHost_ip())) {
            if (!insertLog) {
                insertLog = true;
            }
            op_des.append(";ip\u7531").append(oldHost.getHost_ip()).append("\u53d8\u66f4\u4e3a:").append(host_ip);
        }
        if (oldHost.getHost_port() == null || host_port != oldHost.getHost_port()) {
            if (!insertLog) {
                insertLog = true;
            }
            op_des.append(";\u7aef\u53e3\u7531").append(oldHost.getHost_port()).append("\u53d8\u66f4\u4e3a:").append(host_port);
        }
        if ((host_type = Integer.parseInt(host_type_str)) != oldHost.getHost_type()) {
            if (!insertLog) {
                insertLog = true;
            }
            op_des.append(";\u66f4\u6539\u4e86\u4e3b\u673a\u7c7b\u578b\u4e3a:").append(host_type);
        }
        if (host_use != oldHost.getHost_use()) {
            if (!insertLog) {
                insertLog = true;
            }
            op_des.append(";\u66f4\u6539\u90e8\u7f72\u7c7b\u578b\u4e3a:");
            if (host_use == 3) {
                op_des.append("\u5c97\u4ead\u5ba2\u6237\u7aef+\u670d\u52a1\u5668");
            } else if (host_use == 2) {
                op_des.append("\u505c\u8f66\u573a\u670d\u52a1\u5668");
            } else {
                op_des.append("\u5c97\u4ead\u5ba2\u6237\u7aef");
            }
        }
        if (net_mode != oldHost.getNet_mode()) {
            if (!insertLog) {
                insertLog = true;
            }
            op_des.append(";\u66f4\u6539\u7f51\u7edc\u6a21\u5f0f\u4e3a:");
            if (net_mode == 1) {
                op_des.append("\u5c40\u57df\u7f51\u6a21\u5f0f");
            } else {
                op_des.append("\u5916\u7f51\u76f4\u8fde\u4e91\u7aef\u6a21\u5f0f");
            }
        }
        Date now = WebUtil.getNow();
        int oldHostUse = oldHost.getHost_use();
        CarparkHost updateHost = oldHost;
        updateHost.setHost_ip(host_ip);
        updateHost.setHost_name(host_name);
        updateHost.setHost_port(host_port);
        updateHost.setHost_type(Integer.parseInt(host_type_str));
        updateHost.setHost_use(host_use);
        updateHost.setLast_updated_time(now);
        updateHost.setNet_mode(net_mode);
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                List channelIst;
                commonDaoService.updateIfChangedByPrimeryKey(session, (Object)updateHost, new String[]{"last_updated_time"});
                if (localConfig != null) {
                    localConfig.setId(ServiceUtil.getServiceContext().getCarparkLocalConfig().getId());
                    commonDaoService.updateByPrimeryKey(session, (Object)localConfig);
                    if (!insertLog) {
                        insertLog = true;
                    }
                }
                if ((channelIst = commonDaoService.selectList(session, new SearchParam().setQueryFields(new String[]{"id", "channel_no", "managed_host_no"}).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkChannel.class, null)) != null && !channelIst.isEmpty()) {
                    if (host_use == 2) {
                        if (oldHostUse != host_use) {
                            LinkedList<Long> ids = new LinkedList<Long>();
                            for (CarparkChannel c : channelIst) {
                                if (c.getManaged_host_no() == null || !c.getManaged_host_no().equals(hostNo)) continue;
                                ids.add(c.getId());
                            }
                            if (ids != null && !ids.isEmpty()) {
                                CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkChannel.class));
                                updateP.addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                                if (ids.size() == 1) {
                                    updateP.addEQ("id", ids.get(0));
                                } else {
                                    updateP.addINList("id", ids);
                                }
                                updateP.addUpdate("managed_host_no", (Object)"");
                                commonDaoService.update(session, updateP);
                                if (!insertLog) {
                                    insertLog = true;
                                }
                            }
                        }
                    } else {
                        CommonParam updateP;
                        String s;
                        int n;
                        int n2;
                        String[] stringArray;
                        String[] nos;
                        LinkedList<Long> addids = new LinkedList<Long>();
                        LinkedList<Long> delids = new LinkedList<Long>();
                        HashSet<String> selectNos = new HashSet<String>();
                        HashSet<String> unSelectNos = new HashSet<String>();
                        if (manage_channelNos != null && (manage_channelNos = manage_channelNos.trim()).length() > 0 && (nos = manage_channelNos.split(",")) != null && nos.length > 0) {
                            stringArray = nos;
                            n2 = nos.length;
                            n = 0;
                            while (n < n2) {
                                s = stringArray[n];
                                if ((s = s.trim()).length() > 0) {
                                    selectNos.add(s);
                                }
                                ++n;
                            }
                        }
                        if (unmanage_channelNos != null && (unmanage_channelNos = unmanage_channelNos.trim()).length() > 0 && (nos = unmanage_channelNos.split(",")) != null && nos.length > 0) {
                            stringArray = nos;
                            n2 = nos.length;
                            n = 0;
                            while (n < n2) {
                                s = stringArray[n];
                                if ((s = s.trim()).length() > 0) {
                                    unSelectNos.add(s);
                                }
                                ++n;
                            }
                        }
                        for (CarparkChannel c : channelIst) {
                            if (c.getManaged_host_no() != null && c.getManaged_host_no().equals(hostNo)) {
                                if (!unSelectNos.contains(c.getChannel_no())) continue;
                                delids.add(c.getId());
                                continue;
                            }
                            if (!selectNos.contains(c.getChannel_no())) continue;
                            addids.add(c.getId());
                        }
                        if (addids != null && !addids.isEmpty()) {
                            updateP = new CommonParam(commonDaoService.getTableName(CarparkChannel.class));
                            updateP.addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                            if (addids.size() == 1) {
                                updateP.addEQ("id", addids.get(0));
                            } else {
                                updateP.addINList("id", addids);
                            }
                            updateP.addUpdate("managed_host_no", (Object)hostNo);
                            commonDaoService.update(session, updateP);
                            if (!insertLog) {
                                insertLog = true;
                            }
                        }
                        if (delids != null && !delids.isEmpty()) {
                            updateP = new CommonParam(commonDaoService.getTableName(CarparkChannel.class));
                            updateP.addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                            if (delids.size() == 1) {
                                updateP.addEQ("id", delids.get(0));
                            } else {
                                updateP.addINList("id", delids);
                            }
                            updateP.addUpdate("managed_host_no", (Object)"");
                            commonDaoService.update(session, updateP);
                            if (!insertLog) {
                                insertLog = true;
                            }
                        }
                    }
                }
                if (insertLog) {
                    WebUtil.insertCarparkOperationLog(session, request, Constants.LOG_OP_CAT_5, isLocalServer ? Constants.LOG_OP_TYPE_CAT_5_1 : Constants.LOG_OP_TYPE_CAT_5_3, op_des.toString());
                }
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        if (isLocalServer && needAdviceOtherHost && (localHost = ServiceUtil.getServiceContext().getLocalHost()) != null) {
            localHost.setHost_ip(host_ip);
            localHost.setHost_port(host_port);
        }
        if (localConfig != null) {
            if (localConfig.getHost_use() != null && localConfig.getHost_use().intValue() != ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use().intValue()) {
                ServiceUtil.getServiceContext().getCarparkLocalConfig().setHost_use(localConfig.getHost_use());
            }
            if (localConfig.getNet_mode() != null && localConfig.getNet_mode().intValue() != ServiceUtil.getServiceContext().getCarparkLocalConfig().getNet_mode().intValue()) {
                ServiceUtil.getServiceContext().getCarparkLocalConfig().setNet_mode(localConfig.getNet_mode());
            }
            if (localConfig.getServer_host_port() != null && localConfig.getServer_host_port().length() > 0 && !localConfig.getServer_host_port().equals(ServiceUtil.getServiceContext().getCarparkLocalConfig().getServer_host_port())) {
                ServiceUtil.getServiceContext().getCarparkLocalConfig().setServer_host_port(localConfig.getServer_host_port());
            }
        }
        WebUtil.printFinshJson(0, restartServerUrl == null ? "\u64cd\u4f5c\u6210\u529f" : restartServerUrl, response);
        if (isLocalServer && needAdviceOtherHost) {
            for (CarparkHost h : hostList) {
                if (h.getHost_no().equals(ServiceUtil.getServiceContext().getLocalHostNo()) || h.getHost_use() != 1 || h.getNet_mode() != 1) continue;
                try {
                    StringBuilder url = new StringBuilder(128);
                    url.append("http://").append(h.getHost_ip());
                    if (h.getHost_port() != 80) {
                        url.append(":").append(h.getHost_port());
                    }
                    url.append("/updateClientSeverHost.action?optocken=");
                    KeyValueEntry<String, String> keyV = InstallInitAction.createOPTocken(updateHost);
                    url.append((String)keyV.getValue());
                    String result = (String)HttpUtil.doRequest((String)url.toString(), null, null, null, null, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)3000, (int)6000);
                    boolean success = (String.valueOf((String)keyV.getKey()) + "=SUCCESS").equals(result);
                    if (success) continue;
                    ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u901a\u77e5\u5c97\u4ead\u4e3b\u673a\uff1a" + h.getHost_name() + "[" + h.getHost_ip() + "] \u670d\u52a1\u5668\u4e3b\u673aIP\u4e0e\u7aef\u53e3\u53f7\u5df2\u53d1\u751f\u66f4\u6539"));
                }
                catch (Throwable ex) {
                    ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u901a\u77e5\u5c97\u4ead\u4e3b\u673a\uff1a" + h.getHost_name() + "[" + h.getHost_ip() + "] \u670d\u52a1\u5668\u4e3b\u673aIP\u4e0e\u7aef\u53e3\u53f7\u5df2\u53d1\u751f\u66f4\u6539"));
                }
            }
        }
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u5c97\u4ead/\u4e3b\u673a\u8bbe\u7f6e-\u5220\u9664\u5c97\u4ead/\u4e3b\u673a")
    @Path(value="/delCarparkHost.action")
    public void delCarparkHost(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String hostNo = request.getParameter("hostNo");
        if (hostNo == null || (hostNo = hostNo.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u4e3b\u673a\u7f16\u53f7", response);
            return;
        }
        if (hostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo())) {
            WebUtil.printFinshJson(1, "\u65e0\u6cd5\u5220\u9664\u505c\u8f66\u573a\u670d\u52a1\u5668", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CarparkHost host = (CarparkHost)commonDaoService.selectOne(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("host_no", (Object)hostNo).setOrerbySql("host_no"), CarparkHost.class);
        if (host == null) {
            WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
            return;
        }
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                SearchParam p = new SearchParam().setQueryFields(new String[]{"id"}).addEQ("managed_host_no", (Object)hostNo).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                List clist = commonDaoService.selectList(session, p, CarparkChannel.class, null);
                if (clist != null && !clist.isEmpty()) {
                    CommonParam updateParam = new CommonParam(commonDaoService.getTableName(CarparkChannel.class));
                    updateParam.addUpdate("managed_host_no", (Object)"");
                    if (clist.size() == 1) {
                        updateParam.addEQ("id", (Object)((CarparkChannel)clist.get(0)).getId());
                    } else {
                        for (CarparkChannel c : clist) {
                            updateParam.addIN("id", (Object)c.getId());
                        }
                    }
                    commonDaoService.update(session, updateParam);
                }
                SearchParam delParm = new SearchParam(commonDaoService.getTableName(CarparkHost.class));
                delParm.addEQ("host_no", (Object)hostNo).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                commonDaoService.delete(session, delParm);
                SearchParam delParm1 = new SearchParam(commonDaoService.getTableName(CarparkRolePermission.class)).addEQ("permission_no", (Object)("long_host_client_" + hostNo)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                commonDaoService.delete(session, delParm1);
                StringBuilder op_des = new StringBuilder(128);
                op_des.append("\u5220\u9664\u5c97\u4ead\u4e3b\u673a:").append(host.getHost_name()).append("[").append(host.getHost_ip()).append(']');
                WebUtil.insertCarparkOperationLog(session, request, Constants.LOG_OP_CAT_5, Constants.LOG_OP_TYPE_CAT_5_4, op_des.toString());
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }
}

