/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action.manage;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkDateRange;
import com.wovoe.carpark.dto.CarparkPassPermission;
import com.wovoe.carpark.dto.CarparkPassPermissionChannel;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.BasicSettingService;
import com.wovoe.carpark.web.LeftMenu;
import com.wovoe.carpark.web.Permission;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.carpark.web.WritePermission;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;

@Action(value="/manage")
public class CarparkPassPermissionSettingAction {
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u51fa\u5165\u6743\u9650\u8bbe\u7f6e(\u67e5\u8be2)")
    @LeftMenu(name="\u51fa\u5165\u6743\u9650\u8bbe\u7f6e", parent_name="\u4e1a\u52a1\u8bbe\u7f6e", order=125)
    @Path(value="/showCarparkPassPermission.action")
    public void showCarparkPassPermission(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
            List<CarparkPassportType> passportTypeList = basicSettingService.getPassportTypeListFromCache();
            List<CarparkCarType> carTypeList = basicSettingService.getCarTypeListFromCache();
            if (passportTypeList != null) {
                request.setAttribute("passportTypeList", passportTypeList);
            }
            if (carTypeList != null) {
                request.setAttribute("carTypeList", carTypeList);
            }
            WebUtil.showMainContentWithHead("\u51fa\u5165\u6743\u9650\u8bbe\u7f6e", "carparkPassPermission", request, response);
        } else {
            String xst = request.getParameter("xst");
            if ("showAdd".equals(xst)) {
                List<CarparkChannel> channelList = this.getNeedAuthChannels();
                if (channelList != null && !channelList.isEmpty()) {
                    request.setAttribute("channelList", channelList);
                }
                WebUtil.dispathTemplatePage("carparkPassPermission", request, response);
            } else if ("query".equals(xst)) {
                if ("showPassportTypePermission".equals(op)) {
                    SearchParam sarchParm = new SearchParam();
                    String passport_type_no = request.getParameter("passport_type_no");
                    if (passport_type_no != null && passport_type_no.length() > 0) {
                        sarchParm.addEQ("auth_type_no", (Object)passport_type_no);
                    }
                    sarchParm.addEQ("auth_type", (Object)0);
                    this.handleDataList(request, response, sarchParm);
                } else if ("showCarTypePermission".equals(op)) {
                    SearchParam sarchParm = new SearchParam();
                    String car_type_no = request.getParameter("car_type_no");
                    if (car_type_no != null && car_type_no.length() > 0) {
                        sarchParm.addEQ("auth_type_no", (Object)car_type_no);
                    }
                    sarchParm.addEQ("auth_type", (Object)1);
                    this.handleDataList(request, response, sarchParm);
                } else if ("showPlatePermission".equals(op)) {
                    SearchParam sarchParm = new SearchParam();
                    String query_passport_number = request.getParameter("query_passport_number");
                    if (query_passport_number != null && query_passport_number.length() > 0) {
                        sarchParm.addEQ("auth_type_no", (Object)query_passport_number);
                    }
                    sarchParm.addEQ("auth_type", (Object)2);
                    this.handleDataList(request, response, sarchParm);
                }
            }
        }
    }

    private void handleDataList(HttpServletRequest request, HttpServletResponse response, SearchParam sarchParm) {
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        sarchParm.setOrerbySql(WebUtil.getOrderBy(request, "auth_type_no,id")).addEQ("carpark_id", (Object)carpark_id);
        sarchParm.setTableName(commonDaoService.getTableName(CarparkPassPermission.class));
        Pagination pagination = WebUtil.getPagination(request);
        List dataList = commonDaoService.selectList(sarchParm, pagination);
        if (dataList != null && !dataList.isEmpty()) {
            ArrayList<String> nos = new ArrayList<String>(dataList.size());
            for (Map p : dataList) {
                nos.add((String)p.get("pass_permission_no"));
            }
            SearchParam p1 = new SearchParam().setQueryFields(new String[]{"pass_permission_no", "channel_no"}).addEQ("carpark_id", (Object)carpark_id);
            if (nos.size() == 1) {
                p1.addEQ("pass_permission_no", nos.get(0));
            } else {
                p1.addINList("pass_permission_no", nos);
            }
            SearchParam p2 = new SearchParam().setQueryFields(new String[]{"id", "range_begin", "range_end", "ref_no"}).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("id");
            if (nos.size() == 1) {
                p2.addEQ("ref_no", nos.get(0));
            } else {
                p2.addINList("ref_no", nos);
            }
            p2.addEQ("ref_type", (Object)0);
            List channellist = commonDaoService.selectList(p1, CarparkPassPermissionChannel.class, null);
            List rangeList = commonDaoService.selectList(p2, CarparkDateRange.class, null);
            HashMap<String, StringBuilder> xchannelMap = new HashMap<String, StringBuilder>();
            HashMap<String, LinkedList<CarparkDateRange>> xrangeMap = new HashMap<String, LinkedList<CarparkDateRange>>();
            if (channellist != null && !channellist.isEmpty()) {
                Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
                List<CarparkChannel> needAuth = this.getNeedAuthChannels();
                HashSet<String> enableX = new HashSet<String>();
                if (needAuth != null && !needAuth.isEmpty()) {
                    Iterator iterator = needAuth.iterator();
                    while (iterator.hasNext()) {
                        CarparkChannel c1 = (CarparkChannel)iterator.next();
                        enableX.add(c1.getChannel_no());
                    }
                }
                for (CarparkPassPermissionChannel c : channellist) {
                    boolean enableCh;
                    CarparkChannel ch;
                    StringBuilder sbr = (StringBuilder)xchannelMap.get(c.getPass_permission_no());
                    if (sbr == null) {
                        sbr = new StringBuilder();
                        xchannelMap.put(c.getPass_permission_no(), sbr);
                    }
                    if ((ch = channelMap.get(c.getChannel_no())) == null) continue;
                    if (sbr.length() > 0) {
                        sbr.append('\u3001');
                    }
                    if (!(enableCh = enableX.contains(c.getChannel_no()))) {
                        sbr.append("<span class='text-danger'>").append(ch.getChannel_name()).append("</span>");
                        continue;
                    }
                    sbr.append(ch.getChannel_name());
                }
            }
            if (rangeList != null && !rangeList.isEmpty()) {
                for (CarparkDateRange r : rangeList) {
                    LinkedList<CarparkDateRange> lv = (LinkedList<CarparkDateRange>)xrangeMap.get(r.getRef_no());
                    if (lv == null) {
                        lv = new LinkedList<CarparkDateRange>();
                        xrangeMap.put(r.getRef_no(), lv);
                    }
                    lv.add(r);
                }
            }
            Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
            for (Map dataMap : dataList) {
                Object t;
                String pass_permission_no = (String)dataMap.get("pass_permission_no");
                Integer auth_type = (Integer)dataMap.get("auth_type");
                String auth_type_no = (String)dataMap.get("auth_type_no");
                Integer date_range_type = (Integer)dataMap.get("date_range_type");
                String date_range_value = (String)dataMap.get("date_range_value");
                String auth_obj_name = auth_type == 0 ? ((t = passportTypeMap.get(auth_type_no)) != null ? ((CarparkPassportType)t).getPassport_type_name() : "") : (auth_type == 1 ? ((t = carTypeMap.get(auth_type_no)) != null ? ((CarparkCarType)t).getCar_type_name() : "") : auth_type_no);
                dataMap.put("auth_obj_name", auth_obj_name);
                StringBuilder channelNames = (StringBuilder)xchannelMap.get(pass_permission_no);
                if (channelNames != null) {
                    dataMap.put("auth_channelNames", channelNames.toString());
                } else {
                    dataMap.put("auth_channelNames", "");
                }
                List prangeList = (List)xrangeMap.get(pass_permission_no);
                StringBuilder sb1 = new StringBuilder();
                SimpleDateFormat df = null;
                if (date_range_type == 1) {
                    sb1.append("\u6bcf\u5929 ");
                    df = new SimpleDateFormat("HH:mm");
                } else if (date_range_type == 2) {
                    sb1.append("\u6bcf\u5468\u3010").append(date_range_value).append("\u3011");
                    df = new SimpleDateFormat("HH:mm");
                } else if (date_range_type == 5) {
                    df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                }
                if (prangeList != null && !prangeList.isEmpty() && df != null) {
                    int indx = 0;
                    for (CarparkDateRange r : prangeList) {
                        if (indx > 0) {
                            sb1.append('\u3001');
                        }
                        sb1.append('[').append(df.format(r.getRange_begin())).append(' ').append('\u81f3').append(' ').append(df.format(r.getRange_end())).append(']');
                        ++indx;
                    }
                }
                dataMap.put("auth_dateRangeDes", sb1.toString());
            }
            request.setAttribute("dataList", (Object)dataList);
        }
        WebUtil.printTableListJson(request, response, dataList, pagination.getRecordsCount());
    }

    private List<CarparkChannel> getNeedAuthChannels() {
        BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
        List<CarparkChannel> channelList = basicSettingService.getChannelListFromCache();
        LinkedList<CarparkChannel> needAuthChnanels = new LinkedList<CarparkChannel>();
        if (channelList != null && !channelList.isEmpty()) {
            for (CarparkChannel c : channelList) {
                if (!"1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(c.getChannel_no(), "CHANNEL_AUTH"))) continue;
                needAuthChnanels.add(c);
            }
        }
        return needAuthChnanels;
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u51fa\u5165\u6743\u9650\u8bbe\u7f6e-\u5220\u9664\u51fa\u5165\u6743\u9650")
    @Path(value="/delCarparkPassPermission.action")
    public void delCarparkPassPermission(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String pass_permission_no = request.getParameter("pass_permission_no");
        if (pass_permission_no == null || pass_permission_no.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u7f16\u53f7!", response);
            return;
        }
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        String op_des = request.getParameter("op_des");
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                SearchParam p1 = new SearchParam(commonDaoService.getTableName(CarparkPassPermission.class)).addEQ("pass_permission_no", (Object)pass_permission_no).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                SearchParam p2 = new SearchParam(commonDaoService.getTableName(CarparkPassPermissionChannel.class)).addEQ("pass_permission_no", (Object)pass_permission_no).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                SearchParam p3 = new SearchParam(commonDaoService.getTableName(CarparkDateRange.class)).addEQ("ref_no", (Object)pass_permission_no).addEQ("ref_type", (Object)0).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                commonDaoService.delete(session, p1);
                commonDaoService.delete(session, p2);
                commonDaoService.delete(session, p3);
                if (op_des != null && op_des.length() > 0) {
                    WebUtil.insertCarparkOperationLog(session, request, Constants.LOG_OP_CAT_12, Constants.LOG_OP_TYPE_CAT_12_2, op_des);
                }
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u51fa\u5165\u6743\u9650\u8bbe\u7f6e-\u65b0\u589e\u51fa\u5165\u6743\u9650")
    @Path(value="/addCarparkPassPermission.action")
    public void addCarparkPassPermission(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] sv;
        String[] auth_channelNosA;
        String auth_type_nos = request.getParameter("auth_type_nos");
        if (auth_type_nos == null || auth_type_nos.length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u9009\u62e9\u8ba4\u8bc1\u5bf9\u8c61!", response);
            return;
        }
        Integer auth_type = Integer.valueOf(request.getParameter("auth_type"));
        String auth_channelNos = request.getParameter("auth_channelNos");
        Integer auth_value = Integer.valueOf(request.getParameter("auth_value"));
        Integer date_range_type = Integer.valueOf(request.getParameter("date_range_type"));
        String date_range_value = request.getParameter("date_range_value");
        String dateRange = request.getParameter("dateRange");
        LinkedList<CarparkPassPermissionChannel> passPermissionChannelList = new LinkedList<CarparkPassPermissionChannel>();
        LinkedList<CarparkDateRange> dateRangeList = new LinkedList<CarparkDateRange>();
        String[] stringArray = auth_channelNosA = auth_channelNos.split(",");
        int n = auth_channelNosA.length;
        int n2 = 0;
        while (n2 < n) {
            String s1 = stringArray[n2];
            if ((s1 = s1.trim()).length() != 0) {
                CarparkPassPermissionChannel channel = new CarparkPassPermissionChannel();
                channel.setChannel_no(s1);
                passPermissionChannelList.add(channel);
            }
            ++n2;
        }
        Date now = ServiceUtil.getNow();
        SimpleDateFormat df = date_range_type == 5 ? new SimpleDateFormat("yyyy-MM-dd HH:mm") : new SimpleDateFormat("HH:mm");
        Calendar cl = Calendar.getInstance();
        String[] stringArray2 = sv = dateRange.split(";");
        int n3 = sv.length;
        int n4 = 0;
        while (n4 < n3) {
            String[] s1;
            String s = stringArray2[n4];
            if (s.length() != 0 && (s1 = s.split(",")).length >= 2) {
                CarparkDateRange r = new CarparkDateRange();
                Date range_begin = df.parse(s1[0].trim());
                Date range_end = df.parse(s1[1].trim());
                cl.setTime(range_begin);
                cl.set(13, 0);
                if (date_range_type != 5) {
                    cl.set(1, 2000);
                    cl.set(2, 0);
                    cl.set(5, 1);
                }
                range_begin = cl.getTime();
                r.setRange_begin(range_begin);
                cl.setTime(range_end);
                cl.set(13, 59);
                if (date_range_type != 5) {
                    cl.set(1, 2000);
                    cl.set(2, 0);
                    cl.set(5, 1);
                }
                range_end = cl.getTime();
                r.setRange_end(range_end);
                dateRangeList.add(r);
            }
            ++n4;
        }
        String op_des = request.getParameter("op_des");
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                String[] auth_type_nosA;
                String[] stringArray3 = auth_type_nosA = auth_type_nos.split(",");
                int n5 = auth_type_nosA.length;
                int n6 = 0;
                while (n6 < n5) {
                    String auth_type_no = stringArray3[n6];
                    if ((auth_type_no = auth_type_no.trim()).length() != 0) {
                        CarparkPassPermission p = new CarparkPassPermission();
                        p.setId(commonDaoService.getSequece("ck_common_seq"));
                        p.setAuth_type(auth_type);
                        p.setAuth_type_no(auth_type_no);
                        p.setAuth_value(auth_value);
                        p.setCarpark_id(carpark_id);
                        p.setCreated_time(now);
                        p.setDate_range_type(date_range_type);
                        p.setDate_range_value(date_range_value);
                        p.setLast_updated_time(now);
                        p.setPass_permission_no("C" + p.getId());
                        p.setProject_id(project_id);
                        commonDaoService.insert(session, (Object)p);
                        for (CarparkPassPermissionChannel c : passPermissionChannelList) {
                            c.setId(commonDaoService.getSequece("ck_common_seq"));
                            c.setPass_permission_no(p.getPass_permission_no());
                            c.setLast_updated_time(now);
                            c.setCarpark_id(carpark_id);
                            c.setProject_id(project_id);
                            commonDaoService.insert(session, (Object)c);
                        }
                        for (CarparkDateRange r : dateRangeList) {
                            r.setId(commonDaoService.getSequece("ck_common_seq"));
                            r.setDate_range_no("C" + r.getId());
                            r.setLast_updated_time(now);
                            r.setCarpark_id(carpark_id);
                            r.setCreated_time(now);
                            r.setProject_id(project_id);
                            r.setRef_no(p.getPass_permission_no());
                            r.setRef_type(0);
                            commonDaoService.insert(session, (Object)r);
                        }
                    }
                    ++n6;
                }
                if (op_des != null && op_des.length() > 0) {
                    WebUtil.insertCarparkOperationLog(session, request, Constants.LOG_OP_CAT_12, Constants.LOG_OP_TYPE_CAT_12_1, op_des);
                }
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }
}

