/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action.manage;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.dto.CarparkDateRange;
import com.wovoe.carpark.dto.CarparkPassPermission;
import com.wovoe.carpark.dto.CarparkPassPermissionChannel;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkRechargeRule;
import com.wovoe.carpark.dto.CarparkSpaceTypeDefine;
import com.wovoe.carpark.dto.CarparkStrategy;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.BasicSettingService;
import com.wovoe.carpark.web.LeftMenu;
import com.wovoe.carpark.web.Permission;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.carpark.web.WritePermission;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;

@Action(value="/manage")
public class CarparkPassportTypeSettingAction {
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8f66\u724c/\u5361\u7c7b\u578b\u8bbe\u7f6e(\u67e5\u8be2)")
    @LeftMenu(name="\u8f66\u724c/\u5361\u7c7b\u578b\u8bbe\u7f6e", parent_name="\u4e1a\u52a1\u8bbe\u7f6e", order=121)
    @Path(value="/showCarparkPassportType.action")
    public void showCarparkPassportType(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            request.setAttribute("passTypeMap", Constants.getPassTypeMap());
            WebUtil.showMainContentWithHead("\u8f66\u724c/\u5361\u7c7b\u578b\u8bbe\u7f6e", "carparkPassportType", request, response);
            return;
        }
        if ("showSearch".equals(op)) {
            LinkedList passportTypeList;
            request.setAttribute("passTypeMap", Constants.getPassTypeMap());
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            Integer project_id = ServiceUtil.getServiceContext().getProjectId();
            String passType = request.getParameter("passType");
            SearchParam p = new SearchParam().addEQ("project_id", (Object)project_id).setOrerbySql("id");
            if (passType != null && passType.length() > 0) {
                try {
                    p.addEQ("pass_type", (Object)Integer.valueOf(passType));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((passportTypeList = commonDaoService.selectList(p, CarparkPassportType.class, null)) == null) {
                passportTypeList = new LinkedList();
            }
            request.setAttribute("passportTypeList", passportTypeList);
            WebUtil.dispathTemplatePage("carparkPassportType", request, response);
        }
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8f66\u724c/\u5361\u7c7b\u578b\u8bbe\u7f6e-\u65b0\u589e\u5361\u7c7b\u578b")
    @Path(value="/addCarparkPassportType.action")
    public void addCarparkPassportType(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String passport_type_name = request.getParameter("passport_type_name");
        if (passport_type_name == null || (passport_type_name = passport_type_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u8f66\u724c/\u5361\u7c7b\u578b\u540d", response);
            return;
        }
        if (passport_type_name.getBytes("UTF-8").length > 45) {
            WebUtil.printFinshJson(1, "\u8f66\u724c/\u5361\u7c7b\u578b\u540d\u592a\u957f", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        SearchParam p = new SearchParam().addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id);
        List passportTypeList = commonDaoService.selectList(p.setQueryFields(new String[]{"passport_type_name", "passport_type_number"}), CarparkPassportType.class, null);
        boolean foundSameName = false;
        HashSet<Integer> numbers = new HashSet<Integer>();
        for (CarparkPassportType t : passportTypeList) {
            if (passport_type_name.equals(t.getPassport_type_name())) {
                foundSameName = true;
                break;
            }
            numbers.add(t.getPassport_type_number());
        }
        if (foundSameName) {
            WebUtil.printFinshJson(1, "\u8f66\u724c/\u5361\u7c7b\u578b\u540d\u3010" + passport_type_name + "\u3011\u5df2\u7ecf\u5b58\u5728", response);
            return;
        }
        int passport_type_number = 255;
        int i = 100;
        while (i <= 255) {
            if (!numbers.contains(i)) {
                passport_type_number = i;
                break;
            }
            ++i;
        }
        Date now = ServiceUtil.getNow();
        CarparkPassportType t = new CarparkPassportType();
        t.setCan_del(1);
        t.setCreated_time(now);
        t.setId(commonDaoService.getSequece("ck_common_seq"));
        t.setLast_updated_time(now);
        t.setPass_type(Integer.valueOf(request.getParameter("pass_type")));
        t.setPassport_type_name(passport_type_name);
        t.setPassport_type_no("C" + t.getId());
        t.setPassport_type_number(passport_type_number);
        t.setProject_id(project_id);
        t.setCarpark_id(carpark_id);
        t.setUse_issuer(Integer.valueOf(request.getParameter("use_issuer")));
        t.setUse_muti_car(Integer.valueOf(request.getParameter("use_muti_car")));
        int insertcount = commonDaoService.insert((Object)t);
        if (insertcount > 0) {
            StringBuilder op_des = new StringBuilder(128);
            op_des.append("\u65b0\u589e\u8f66\u724c/\u5361\u7c7b\u578b:").append(t.getPassport_type_name()).append(t.getUse_muti_car() == 1 ? "(\u652f\u6301\u591a\u4f4d\u591a\u8f66)" : "(\u4e0d\u652f\u6301\u591a\u4f4d\u591a\u8f66)");
            WebUtil.insertCarparkOperationLog(null, request, Constants.LOG_OP_CAT_7, Constants.LOG_OP_TYPE_CAT_7_1, op_des.toString());
            WebUtil.printFinshJson(0, t.getPassport_type_no(), response);
        } else {
            WebUtil.printFinshJson(2, "\u6570\u636e\u4fdd\u5b58\u5931\u8d25!", response);
        }
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8f66\u724c/\u5361\u7c7b\u578b\u8bbe\u7f6e-\u4fee\u6539\u5361\u7c7b\u578b")
    @Path(value="/updateCarparkPassportType.action")
    public void updateCarparkPassportType(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int use_muti_car;
        String use_muti_carStr;
        String passport_type_name = request.getParameter("passport_type_name");
        if (passport_type_name == null || (passport_type_name = passport_type_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u8f66\u724c/\u5361\u7c7b\u578b\u540d", response);
            return;
        }
        if (passport_type_name.getBytes("UTF-8").length > 45) {
            WebUtil.printFinshJson(1, "\u8f66\u724c/\u5361\u7c7b\u578b\u540d\u592a\u957f", response);
            return;
        }
        String passport_type_no = request.getParameter("passport_type_no");
        if (passport_type_no == null || passport_type_no.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u7f16\u53f7", response);
            return;
        }
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPassportType type = (CarparkPassportType)commonDaoService.selectOne(new SearchParam().addEQ("passport_type_no", (Object)passport_type_no).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id), CarparkPassportType.class);
        if (type == null) {
            WebUtil.printFinshJson(1, "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", response);
            return;
        }
        CarparkPassportType updateType = new CarparkPassportType();
        StringBuilder op_des = new StringBuilder(128);
        op_des.append("\u4fee\u6539\u8f66\u724c/\u5361\u7c7b\u578b:");
        boolean update = false;
        if (!passport_type_name.equals(type.getPassport_type_name())) {
            update = true;
            updateType.setPassport_type_name(passport_type_name);
            long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPassportType.class)).addEQ("passport_type_name", (Object)passport_type_name).addNotEQ("id", (Object)type.getId()).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id));
            if (count > 0L) {
                WebUtil.printFinshJson(1, "\u8f66\u724c/\u5361\u7c7b\u578b\u540d\u3010" + passport_type_name + "\u3011\u5df2\u7ecf\u5b58\u5728", response);
                return;
            }
            op_des.append("\u5c06\u540d\u79f0 ").append(type.getPassport_type_name()).append(" \u66f4\u6539\u4e3a: ").append(passport_type_name);
        }
        if ((use_muti_carStr = request.getParameter("use_muti_car")) != null && (use_muti_carStr = use_muti_carStr.trim()).length() > 0 && (use_muti_car = Integer.parseInt(use_muti_carStr)) != type.getUse_muti_car()) {
            update = true;
            updateType.setUse_muti_car(use_muti_car);
            op_des.append(";\u53d8\u66f4\u4e3a").append(use_muti_car == 1 ? "\u652f\u6301\u591a\u4f4d\u591a\u8f66" : "\u4e0d\u652f\u6301\u591a\u4f4d\u591a\u8f66");
        }
        if (update) {
            updateType.setId(type.getId());
            updateType.setLast_updated_time(ServiceUtil.getNow());
            commonDaoService.updateByPrimeryKey((Object)updateType);
            WebUtil.insertCarparkOperationLog(null, request, Constants.LOG_OP_CAT_7, Constants.LOG_OP_TYPE_CAT_7_2, op_des.toString());
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u4e1a\u52a1\u8bbe\u7f6e-\u8f66\u724c/\u5361\u7c7b\u578b\u8bbe\u7f6e-\u5220\u9664\u5361\u7c7b\u578b")
    @Path(value="/delCarparkPassportType.action")
    public void delCarparkPassportType(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String passport_type_no = request.getParameter("passport_type_no");
        if (passport_type_no == null || passport_type_no.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u7f16\u53f7", response);
            return;
        }
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPassport.class)).addEQ("passport_type_no", (Object)passport_type_no).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id));
        if (count > 0L) {
            WebUtil.printFinshJson(1, "\u8be5\u5361\u7c7b\u578b\u4e0b\u8fd8\u6709\u6ce8\u518c\u7684\u8f66\u724c\u7528\u6237,\u8bf7\u5148\u5c06\u5176\u4e0b\u7684\u6240\u6709\u8f66\u4e3b\u8f66\u724c\u4fe1\u606f\u79fb\u9664\uff0c\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c", response);
            return;
        }
        CarparkPassportType type = (CarparkPassportType)commonDaoService.selectOne(new SearchParam().addEQ("passport_type_no", (Object)passport_type_no).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id), CarparkPassportType.class);
        if (type != null) {
            if (type.getCan_del() != 1) {
                WebUtil.printFinshJson(1, "\u65e0\u6cd5\u5220\u9664\u7cfb\u7edf\u751f\u6210\u7684\u5361\u7c7b\u578b", response);
                return;
            }
            try (SqlSession session = commonDaoService.openSqlSession();){
                try {
                    commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkPassportType.class)).addEQ("id", (Object)type.getId()).addEQ("project_id", (Object)project_id));
                    long count1 = commonDaoService.selectCount(session, new SearchParam(commonDaoService.getTableName(CarparkSpaceTypeDefine.class)).addEQ("passport_type_no", (Object)passport_type_no).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id));
                    if (count1 > 0L) {
                        commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkSpaceTypeDefine.class)).addEQ("passport_type_no", (Object)passport_type_no).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id));
                    }
                    commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkStrategy.class)).addEQ("passport_type_no", (Object)passport_type_no).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id));
                    List passPermissionList = commonDaoService.selectList(session, new SearchParam().setQueryFields(new String[]{"pass_permission_no"}).addEQ("auth_type", (Object)0).addEQ("auth_type_no", (Object)passport_type_no).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id), CarparkPassPermission.class, null);
                    if (passPermissionList != null && !passPermissionList.isEmpty()) {
                        HashSet<String> pass_permission_noSet = new HashSet<String>();
                        for (CarparkPassPermission m : passPermissionList) {
                            pass_permission_noSet.add(m.getPass_permission_no());
                        }
                        SearchParam p1 = new SearchParam(commonDaoService.getTableName(CarparkPassPermission.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                        SearchParam p2 = new SearchParam(commonDaoService.getTableName(CarparkPassPermissionChannel.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                        SearchParam p3 = new SearchParam(commonDaoService.getTableName(CarparkDateRange.class)).addEQ("ref_type", (Object)0).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                        if (pass_permission_noSet.size() == 1) {
                            String pass_permission_no = (String)ServiceUtil.getFirstElement(pass_permission_noSet);
                            p1.addEQ("pass_permission_no", (Object)pass_permission_no);
                            p2.addEQ("pass_permission_no", (Object)pass_permission_no);
                            p3.addEQ("ref_no", (Object)pass_permission_no);
                        } else {
                            p1.addINList("pass_permission_no", pass_permission_noSet);
                            p2.addINList("pass_permission_no", pass_permission_noSet);
                            p3.addINList("ref_no", pass_permission_noSet);
                        }
                        commonDaoService.delete(session, p1);
                        commonDaoService.delete(session, p2);
                        commonDaoService.delete(session, p3);
                    }
                    BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
                    basicSettingService.deleteChargeRule(null, null, passport_type_no, carpark_id, project_id, commonDaoService, session);
                    commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkRechargeRule.class)).addEQ("project_id", (Object)project_id).addEQ("passport_type_no", (Object)passport_type_no));
                    StringBuilder op_des = new StringBuilder(128);
                    op_des.append("\u5220\u9664\u8f66\u724c/\u5361\u7c7b\u578b:").append(type.getPassport_type_name()).append(",\u4ee5\u53ca\u5176\u5173\u8054\u7684\u6743\u9650\uff0c\u8ba1\u8d39\u89c4\u5219\u7b49\u6570\u636e");
                    WebUtil.insertCarparkOperationLog(session, request, Constants.LOG_OP_CAT_7, Constants.LOG_OP_TYPE_CAT_7_3, op_des.toString());
                    session.commit();
                }
                catch (Exception ex) {
                    session.rollback();
                    throw ex;
                }
            }
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }
}

