/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action.manage;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.DispatchDataTaskUtil;
import com.wovoe.carpark.ValidateUtil;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.dto.CarparkAttribute;
import com.wovoe.carpark.dto.CarparkCarOwner;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkDispatchTask;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkOperationLog;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassport;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkRechargeRule;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.BasicSettingService;
import com.wovoe.carpark.vo.PaginationDisplay;
import com.wovoe.carpark.web.LeftMenu;
import com.wovoe.carpark.web.Permission;
import com.wovoe.carpark.web.WebLog;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.carpark.web.WritePermission;
import com.wovoe.carpark.web.action.manage.CarparkCarOwnerAction;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.KeyValue;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.ibatis.session.SqlSession;

@Action(value="/manage")
public class CarparkPlateManageAction {
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406(\u67e5\u8be2)")
    @LeftMenu(name="\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406", parent_name="\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406", order=211)
    @Path(value="/showPlateManage.action")
    public void showPlateManage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
            List<CarparkPassportType> passportTypeList = this.getPassportTypeList();
            request.setAttribute("passportTypeList", passportTypeList);
            List<CarparkCarType> carTypeList = basicSettingService.getCarTypeListFromCache();
            request.setAttribute("carTypeList", carTypeList);
            Map<String, CarparkAttribute> carOwnerAttrMap = ServiceUtil.getServiceContext().getDBConfigCache().getAttributeTypeMap().get(8);
            ArrayList<CarparkAttribute> carOwnerAtrrList = new ArrayList<CarparkAttribute>();
            if (carOwnerAttrMap != null && !carOwnerAttrMap.isEmpty()) {
                request.setAttribute("carOwnerAttrMapSize", (Object)carOwnerAttrMap.size());
                request.setAttribute("carOwnerAttrMap", carOwnerAttrMap);
                for (CarparkAttribute t : carOwnerAttrMap.values()) {
                    carOwnerAtrrList.add(t);
                }
            }
            CarparkAttribute t2 = new CarparkAttribute();
            t2.setId(-1L);
            t2.setAttribute_key("remark");
            t2.setAttribute_value("\u5907\u6ce8\u4fe1\u606f");
            t2.setAttribute_type(8);
            carOwnerAtrrList.add(t2);
            request.setAttribute("carOwnerAtrrList", carOwnerAtrrList);
            request.setAttribute("carOwnerAtrrListSize", (Object)carOwnerAtrrList.size());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            request.setAttribute("today", (Object)df.format(new java.util.Date()));
            String platePrefix = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("DEFAULT_PLATE_PREFIX");
            if (platePrefix == null || platePrefix.length() == 0) {
                platePrefix = "\u7ca4B";
            }
            request.setAttribute("platePrefix", (Object)platePrefix);
            String showCheckbox = System.getProperty("SHOW_PLATE_MANAGE_CHECKBOX");
            String showMonthBatchMoney = System.getProperty("SHOW_MONTH_BATCH_MONTY");
            request.setAttribute("showCheckbox", (Object)(showCheckbox == null ? "0" : showCheckbox));
            request.setAttribute("showMonthBatchMoney", (Object)(showMonthBatchMoney == null ? "0" : showMonthBatchMoney));
            WebUtil.showMainContentWithHead("\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406", "carparkPlateManage", request, response);
            return;
        }
        if ("showPassportTable".equals(op)) {
            String showCheckbox;
            Pagination p;
            List<Map<String, Object>> pdataList;
            boolean carownerAccountSupport = false;
            if ("1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CAR_OWNER_ACCOUNT_BALANCE"))) {
                request.setAttribute("carownerAccountSupport", (Object)"true");
                carownerAccountSupport = true;
            }
            if ((pdataList = this.queryRequestPassportList(request, p = WebUtil.getPagination(request))) != null && !pdataList.isEmpty()) {
                Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
                Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                Calendar today1 = Calendar.getInstance();
                today1.set(14, 0);
                today1.set(13, 0);
                today1.set(12, 0);
                today1.set(11, 0);
                java.util.Date today = today1.getTime();
                String dispayTheadFV = (String)request.getAttribute("dispayTheadFV");
                Set permissions = (Set)request.getSession(false).getAttribute("MANAGE_USER_PERMISSIONS");
                if (permissions == null) {
                    permissions = Collections.EMPTY_SET;
                }
                for (Map<String, Object> map : pdataList) {
                    Object objx;
                    java.util.Date stop_date;
                    java.util.Date start_date;
                    Object passportType;
                    CarparkCarType carparkCarType = carTypeMap.get(map.get("car_type_no"));
                    if (carparkCarType != null) {
                        map.put("carType", carparkCarType);
                        map.put("car_type_name", carparkCarType.getCar_type_name());
                    }
                    if ((passportType = passportTypeMap.get(map.get("passport_type_no"))) != null) {
                        map.put("passportType", passportType);
                        map.put("passport_type_name", ((CarparkPassportType)passportType).getPassport_type_name());
                        map.put("pass_type", ((CarparkPassportType)passportType).getPass_type());
                        if (carownerAccountSupport && ((CarparkPassportType)passportType).getPass_type() == 1) {
                            if (map.get("car_owner_no") != null && "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(((CarparkPassportType)passportType).getPassport_type_no(), "STOREAGE_DECUNT_AOUHNT"))) {
                                map.put("deduct_account_type", "1");
                            } else {
                                map.put("deduct_account_type", "0");
                            }
                        }
                    } else {
                        WebLog.getLog().warn((Object)("\u65e0\u6548\u8f66\u8f86\u7c7b\u578b\u7f16\u53f7: " + map.get("passport_type_no") + "\uff0c\u8f66\u8f86\u7c7b\u578b\u4e0d\u5b58\u5728: \u6ce8\u518c\u8f66\u724c\uff1a" + map.get("register_plate") + ", \u8f66\u4e3b\uff1a" + map.get("car_owner_name") + ", \u5408\u6cd5\u8f66\u8f86\u7c7b\u578b\u7f16\u53f7: " + passportTypeMap.keySet()));
                    }
                    int passportState = (Integer)map.get("passport_state");
                    java.util.Date xdeadline = (java.util.Date)map.get("deadline");
                    if (xdeadline != null) {
                        today1.setTime(xdeadline);
                        today1.set(14, 0);
                        today1.set(13, 0);
                        today1.set(12, 0);
                        today1.set(11, 0);
                        java.util.Date xdeadline1 = today1.getTime();
                        int days = 0;
                        if (xdeadline.before(today)) {
                            map.put("xepire", Boolean.TRUE);
                        } else {
                            days = (int)TimeUnit.MILLISECONDS.toDays(xdeadline1.getTime() - today.getTime());
                            if (days < 7) {
                                map.put("x7epire", Boolean.TRUE);
                            }
                        }
                        map.put("deadlinestr", new SimpleDateFormat("yyyy-MM-dd").format(xdeadline));
                        if (passportType != null && ((CarparkPassportType)passportType).getPass_type() == 2) {
                            java.util.Date _startDate;
                            if (passportState == 2) {
                                java.util.Date _stopDate = (java.util.Date)map.get("stop_date");
                                if (_stopDate != null && !_stopDate.after(today) && !_stopDate.after(xdeadline)) {
                                    days = (int)TimeUnit.MILLISECONDS.toDays(xdeadline1.getTime() - _stopDate.getTime()) + 1;
                                }
                            } else if (passportState == 0 && (_startDate = (java.util.Date)map.get("start_date")) != null && _startDate.after(today) && !_startDate.after(xdeadline)) {
                                days = (int)TimeUnit.MILLISECONDS.toDays(xdeadline1.getTime() - _startDate.getTime());
                            }
                            if (days > 0) {
                                map.put("remainDays", String.valueOf(days));
                            }
                        }
                    }
                    if ((start_date = (java.util.Date)map.get("start_date")) != null && start_date.after(today)) {
                        map.put("notStart", Boolean.TRUE);
                    }
                    if (passportState == 2 && (stop_date = (java.util.Date)map.get("stop_date")) != null && stop_date.after(today)) {
                        map.put("notStopped", Boolean.TRUE);
                    }
                    if (dispayTheadFV != null && (objx = map.get(dispayTheadFV)) != null) {
                        map.put("dispayTheadFV", objx);
                    }
                    LinkedHashMap<String, String> operationMap = new LinkedHashMap<String, String>();
                    if (passportType != null && passportState == 0 && map.get("notStart") == null) {
                        if (((CarparkPassportType)passportType).getPass_type() == 2) {
                            if (permissions.contains("/manage/updatePassportRechageDate.action")) {
                                operationMap.put("/manage/updatePassportRechageDate.action", "\u7eed\u8d39\u5ef6\u671f");
                            }
                        } else if (((CarparkPassportType)passportType).getPass_type() == 1 && permissions.contains("/manage/updatePassportRechageFee.action")) {
                            operationMap.put("/manage/updatePassportRechageFee.action", "\u5145\u503c\u505c\u8f66\u8d39");
                        }
                    }
                    if (permissions.contains("/manage/updateCarparkPassport.action")) {
                        operationMap.put("/manage/showPlateManage.action?op=showPassportDetail", "\u67e5\u770b/\u4fee\u6539\u8f66\u8f86\u4fe1\u606f");
                    } else {
                        operationMap.put("/manage/showPlateManage.action?op=showPassportDetail", "\u8f66\u8f86\u8be6\u7ec6\u4fe1\u606f");
                    }
                    if (permissions.contains("/manage/updatePassportPlateBlackList.action") && map.get("notStart") == null) {
                        if (passportState == 0) {
                            operationMap.put("/manage/updatePassportPlateBlackList.action?xp=1", "\u52a0\u5165\u9ed1\u540d\u5355");
                        } else if (passportState == 1) {
                            operationMap.put("/manage/updatePassportPlateBlackList.action?xp=0", "\u89e3\u9664\u9ed1\u540d\u5355");
                        }
                    }
                    if (passportType != null) {
                        if (((CarparkPassportType)passportType).getPassport_type_number() != 0 && permissions.contains("/manage/updatePassportPlateStop.action")) {
                            if (passportState == 2) {
                                operationMap.put("/manage/updatePassportPlateStop.action?xp=0", "\u542f\u7528\u8f66\u724c/\u5361");
                            } else if (passportState == 0) {
                                if (start_date.after(today)) {
                                    operationMap.put("/manage/updatePassportPlateStop.action?xp=0", "\u542f\u7528\u8f66\u724c/\u5361");
                                } else {
                                    operationMap.put("/manage/updatePassportPlateStop.action?xp=1", "\u505c\u7528\u8f66\u724c/\u5361");
                                }
                            }
                        }
                        if (((CarparkPassportType)passportType).getPass_type() == 2 && passportState == 0 && map.get("notStart") == null && permissions.contains("/manage/updatePassportPlateValidDate.action")) {
                            operationMap.put("/manage/updatePassportPlateValidDate.action", "\u4fee\u6539\u6709\u6548\u671f");
                        }
                        if (passportState == 0 && map.get("notStart") == null && (((CarparkPassportType)passportType).getPass_type() == 2 || ((CarparkPassportType)passportType).getPass_type() == 1) && permissions.contains("/manage/updatePassportFobitOnlinePay.action")) {
                            Integer forbid_online_pay = (Integer)map.get("forbid_online_pay");
                            if (forbid_online_pay == null) {
                                forbid_online_pay = 0;
                            }
                            if (forbid_online_pay == 1) {
                                operationMap.put("/manage/updatePassportFobitOnlinePay.action?xp=0", "\u5141\u8bb8\u5728\u7ebf\u5145\u503c");
                            } else {
                                operationMap.put("/manage/updatePassportFobitOnlinePay.action?xp=1", "\u7981\u6b62\u5728\u7ebf\u5145\u503c");
                            }
                        }
                    }
                    if (permissions.contains("/manage/delCarparkPassport.action")) {
                        operationMap.put("/manage/delCarparkPassport.action", "\u6ce8\u9500\u8f66\u724c/\u5361");
                    }
                    map.put("actionMap", operationMap);
                }
                if (pdataList != null && !pdataList.isEmpty()) {
                    for (Map<String, Object> m : pdataList) {
                        for (Map.Entry entry : m.entrySet()) {
                            if (!(entry.getValue() instanceof String)) continue;
                            entry.setValue(ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue((String)entry.getKey(), (String)entry.getValue(), request));
                        }
                    }
                }
                request.setAttribute("pdataList", pdataList);
                request.setAttribute("paginationDisplay", (Object)new PaginationDisplay(p, 5));
            }
            request.setAttribute("showCheckbox", (Object)((showCheckbox = System.getProperty("SHOW_PLATE_MANAGE_CHECKBOX")) == null ? "0" : showCheckbox));
            WebUtil.dispathTemplatePage("carparkPlateManage", request, response);
        } else if ("showPassportDetail".equals(op)) {
            Long id = Long.valueOf(request.getParameter("id"));
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            Map passportMap = commonDaoService.selectOne(new SearchParam(commonDaoService.getTableName(CarparkPassport.class)).addEQ("id", (Object)id));
            if (passportMap != null) {
                Map carOwnerMap;
                java.util.Date stop_date;
                Map<String, CarparkCarType> carTypeMap;
                CarparkCarType carType;
                request.setAttribute("passportMap", (Object)passportMap);
                BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
                List<CarparkCarType> carTypeList = basicSettingService.getCarTypeListFromCache();
                request.setAttribute("carTypeList", carTypeList);
                List<CarparkPassportType> passportTypeList = this.getPassportTypeList();
                request.setAttribute("passportTypeList", passportTypeList);
                Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
                CarparkPassportType passportType = passportTypeMap.get(passportMap.get("passport_type_no"));
                if (passportType != null) {
                    passportMap.put("passportType", passportType);
                    passportMap.put("passport_type_name", passportType.getPassport_type_name());
                }
                if ((carType = (carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap()).get(passportMap.get("car_type_no"))) != null) {
                    passportMap.put("carType", carType);
                    passportMap.put("car_type_name", carType.getCar_type_name());
                }
                Calendar today1 = Calendar.getInstance();
                today1.set(14, 0);
                today1.set(13, 0);
                today1.set(12, 0);
                today1.set(11, 0);
                java.util.Date date = today1.getTime();
                java.util.Date xdeadline = (java.util.Date)passportMap.get("deadline");
                if (xdeadline != null) {
                    if (xdeadline.before(date)) {
                        passportMap.put("xepire", Boolean.TRUE);
                    } else {
                        int days = (int)TimeUnit.MILLISECONDS.toDays(xdeadline.getTime() - date.getTime());
                        if (days <= 7) {
                            passportMap.put("x7epire", Boolean.TRUE);
                        }
                    }
                }
                int passportState = (Integer)passportMap.get("passport_state");
                java.util.Date start_date = (java.util.Date)passportMap.get("start_date");
                if (start_date != null && start_date.after(date)) {
                    passportMap.put("notStart", Boolean.TRUE);
                }
                if (passportState == 2 && (stop_date = (java.util.Date)passportMap.get("stop_date")) != null && stop_date.after(date)) {
                    passportMap.put("notStopped", Boolean.TRUE);
                }
                Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
                Integer project_id = ServiceUtil.getServiceContext().getProjectId();
                String car_owner_no = (String)passportMap.get("car_owner_no");
                if (car_owner_no != null && car_owner_no.length() > 0 && (carOwnerMap = commonDaoService.selectOne(new SearchParam(commonDaoService.getTableName(CarparkCarOwner.class)).addEQ("car_owner_no", (Object)car_owner_no).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id))) != null) {
                    passportMap.put("carOwner", carOwnerMap);
                    for (Map.Entry entry : carOwnerMap.entrySet()) {
                        if (!(entry.getValue() instanceof String)) continue;
                        entry.setValue(ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue((String)entry.getKey(), (String)entry.getValue(), request));
                    }
                    Map<String, CarparkAttribute> map = ServiceUtil.getServiceContext().getDBConfigCache().getAttributeTypeMap().get(8);
                    ArrayList<CarparkAttribute> carOwnerAtrrList = new ArrayList<CarparkAttribute>();
                    if (map != null && !map.isEmpty()) {
                        request.setAttribute("carOwnerAttrMapSize", (Object)map.size());
                        request.setAttribute("carOwnerAttrMap", map);
                        for (CarparkAttribute t : map.values()) {
                            carOwnerAtrrList.add(t);
                        }
                    }
                    CarparkAttribute t3 = new CarparkAttribute();
                    t3.setId(-1L);
                    t3.setAttribute_key("remark");
                    t3.setAttribute_value("\u5907\u6ce8\u4fe1\u606f");
                    t3.setAttribute_type(8);
                    carOwnerAtrrList.add(t3);
                    request.setAttribute("carOwnerAtrrList", carOwnerAtrrList);
                    request.setAttribute("carOwnerAtrrListSize", (Object)carOwnerAtrrList.size());
                    if ("1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CAR_OWNER_ACCOUNT_BALANCE")) && passportType != null && passportType.getPass_type() == 1) {
                        request.setAttribute("carOwnerAccount_balance", carOwnerMap.get("account_balance"));
                    }
                }
            }
            WebUtil.dispathTemplatePage("carparkPlateManage", request, response);
        }
    }

    private List<String> getStringList(String values) {
        if (values == null || (values = values.trim()).length() == 0) {
            return new ArrayList<String>(0);
        }
        if (values.indexOf(44) == -1) {
            ArrayList<String> l = new ArrayList<String>(1);
            l.add(values);
            return l;
        }
        String[] v = values.split(",");
        ArrayList<String> l = new ArrayList<String>(v.length);
        String[] stringArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ((s = s.trim()).length() != 0) {
                l.add(s);
            }
            ++n2;
        }
        return l;
    }

    private SearchParam queryRequestPassportListParam(HttpServletRequest request, boolean fourceOnlyMonth) {
        List<String> list;
        boolean queryOnlyMonth;
        String passport_type_nos = request.getParameter("passport_type_no");
        String car_type_nos = request.getParameter("car_type_no");
        String state = request.getParameter("state");
        String attr = request.getParameter("attr");
        String attr_value = request.getParameter("attr_value");
        String attr_text = request.getParameter("attr_text");
        String deadline_begin = request.getParameter("q_deadline_begin");
        String deadline_end = request.getParameter("q_deadline_end");
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!(attr_text == null || attr_text.length() <= 0 || attr.endsWith("passport_number") || attr.endsWith("car_owner_name") || attr.endsWith("address") || attr.endsWith("phone_number") || attr.endsWith("register_plate"))) {
            request.setAttribute("dispayTheadF", (Object)attr_text);
            request.setAttribute("dispayTheadFV", (Object)attr.split(",")[1]);
        }
        java.util.Date beginTime = null;
        if (deadline_begin != null && (deadline_begin = deadline_begin.trim()).length() > 0) {
            try {
                beginTime = df1.parse(String.valueOf(deadline_begin) + " 00:00:00");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        java.util.Date endTime = null;
        if (deadline_end != null && deadline_end.length() > 0) {
            try {
                endTime = df1.parse(String.valueOf(deadline_end) + " 23:59:59");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (beginTime != null && endTime != null && beginTime.after(endTime)) {
            return null;
        }
        boolean bl = queryOnlyMonth = beginTime != null || endTime != null || "-1".equals(state);
        if (fourceOnlyMonth) {
            queryOnlyMonth = true;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        String queryTableName = queryOnlyMonth ? String.valueOf(commonDaoService.getTableName(CarparkPassport.class)) + " a JOIN " + commonDaoService.getTableName(CarparkPassportType.class) + " c ON a.passport_type_no=c.passport_type_no AND a.carpark_id=c.carpark_id AND c.pass_type=" + 2 + " LEFT JOIN " + commonDaoService.getTableName(CarparkCarOwner.class) + " b ON a.car_owner_no=b.car_owner_no AND a.carpark_id=b.carpark_id AND a.project_id=b.project_id" : String.valueOf(commonDaoService.getTableName(CarparkPassport.class)) + " a LEFT JOIN " + commonDaoService.getTableName(CarparkCarOwner.class) + " b ON a.car_owner_no=b.car_owner_no AND a.carpark_id=b.carpark_id AND a.project_id=b.project_id";
        SearchParam sp = new SearchParam(queryTableName);
        if (beginTime != null) {
            sp.addGTE("a.deadline", (Object)beginTime);
        }
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("a.*");
        selectFields.add("b.remark AS remark1");
        String[] clientNames = commonDaoService.getColumnNames(commonDaoService.getTableName(CarparkCarOwner.class));
        Set<String> notX = ServiceUtil.toSet("id", "car_owner_no", "remark", "created_time", "last_updated_time", "project_id", "carpark_id");
        String[] stringArray = clientNames;
        int n = clientNames.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!notX.contains(s)) {
                selectFields.add("b." + s);
            }
            ++n2;
        }
        sp.setSelectFields(selectFields);
        sp.addEQ("a.carpark_id", (Object)carpark_id);
        sp.addEQ("a.project_id", (Object)project_id);
        Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        List<String> queryPassTypeList = this.getStringList(passport_type_nos);
        if (queryPassTypeList != null && !queryPassTypeList.isEmpty()) {
            if (queryOnlyMonth) {
                LinkedList<String> passportList0 = new LinkedList<String>();
                for (String s : queryPassTypeList) {
                    CarparkPassportType qtype = passportTypeMap.get(s);
                    if (qtype == null || qtype.getPass_type() != 2) continue;
                    passportList0.add(s);
                }
                if (passportList0.isEmpty()) {
                    return null;
                }
                queryPassTypeList = passportList0;
            }
            if (queryPassTypeList.size() == 1) {
                sp.addEQ("a.passport_type_no", (Object)queryPassTypeList.get(0));
            } else {
                sp.addINList("a.passport_type_no", queryPassTypeList);
            }
        }
        if (car_type_nos != null && car_type_nos.length() > 0 && (list = this.getStringList(car_type_nos)) != null && !list.isEmpty()) {
            if (list.size() == 1) {
                sp.addEQ("a.car_type_no", (Object)list.get(0));
            } else {
                sp.addINList("a.car_type_no", list);
            }
        }
        if (state != null && state.length() > 0) {
            if ("-1".equals(state)) {
                java.util.Date now = ServiceUtil.getNow();
                if (endTime == null) {
                    sp.addLT("a.deadline", (Object)now);
                } else {
                    if (now.before(endTime)) {
                        sp.addLT("a.deadline", (Object)now);
                    } else {
                        sp.addLTE("a.deadline", (Object)endTime);
                    }
                    endTime = null;
                }
            } else if ("-2".equals(state)) {
                sp.addGT("a.start_date", (Object)ServiceUtil.getNow());
            } else if ("-3".equals(state)) {
                sp.addEQ("a.forbid_online_pay", (Object)1);
            } else {
                sp.addEQ("a.passport_state", (Object)Integer.valueOf(state));
            }
        }
        if (endTime != null) {
            sp.addLTE("a.deadline", (Object)endTime);
        }
        if (attr != null && attr.length() > 0 && attr_value != null && attr_value.length() > 0) {
            sp.addLike(attr.replace(',', '.').replaceAll(" ", "").replaceAll("'", "").replaceAll("\"", ""), attr_value);
        }
        sp.setOrder_by("a.reg_time DESC");
        return sp;
    }

    private List<Map<String, Object>> queryRequestPassportList(HttpServletRequest request, Pagination p) {
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam sp = this.queryRequestPassportListParam(request, false);
        if (sp == null) {
            return new ArrayList<Map<String, Object>>(0);
        }
        return commonDaoService.selectList(sp, p);
    }

    private List<CarparkPassportType> getPassportTypeList() {
        BasicSettingService basicSettingService = (BasicSettingService)ServiceUtil.getServiceContext().getService(BasicSettingService.class);
        List<CarparkPassportType> passportTypeList = basicSettingService.getPassportTypeListFromCache();
        if (passportTypeList == null) {
            passportTypeList = new LinkedList<CarparkPassportType>();
        }
        if (!passportTypeList.isEmpty()) {
            Iterator<CarparkPassportType> its = passportTypeList.iterator();
            while (its.hasNext()) {
                CarparkPassportType t = its.next();
                if (t.getPass_type() != 5) continue;
                its.remove();
            }
        }
        return passportTypeList;
    }

    @Path(value="/obtainAddPlateEnterTime.action")
    public void obtainAddPlateEnterTime(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String returnValue;
        String plate = request.getParameter("plateNo");
        if (plate == null || plate.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u8f66\u724c\u53f7", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CarparkPresenceRecord record = (CarparkPresenceRecord)commonDaoService.selectOne(new SearchParam().setQueryFields(new String[]{"enter_time"}).addEQ("enter_plate", (Object)plate).addEQ("area_level", (Object)1).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkPresenceRecord.class);
        if (record != null && record.getEnter_time() != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            returnValue = df.format(record.getEnter_time());
        } else {
            returnValue = "";
        }
        WebUtil.printFinshJson(0, returnValue, response);
    }

    @Path(value="/querySelectCarownerTable.action")
    public void querySelectCarownerTable(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, CarparkAttribute> carOwnerAttrMap;
        Pagination p = WebUtil.getPagination(request);
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        SearchParam sparam = new SearchParam(commonDaoService.getTableName(CarparkCarOwner.class));
        sparam.addEQ("carpark_id", (Object)carpark_id);
        sparam.addEQ("project_id", (Object)project_id);
        String queryKey = request.getParameter("queryKey");
        String queryValue = request.getParameter("queryValue");
        if (queryKey != null && (queryKey = queryKey.trim()).length() > 0 && queryValue != null && (queryValue = queryValue.trim()).length() > 0) {
            sparam.addLike(queryKey, queryValue);
        }
        String sortName = request.getParameter("sortName");
        String sortOrder = request.getParameter("sortOrder");
        if (sortName != null && (sortName = sortName.trim()).length() > 0 && sortOrder != null && (sortOrder = sortOrder.trim()).length() > 0) {
            sparam.setOrder_by(String.valueOf(sortName) + " " + sortOrder);
        } else {
            sparam.setOrder_by("id DESC");
        }
        List carownerList = commonDaoService.selectList(sparam, p);
        if (carownerList != null && !carownerList.isEmpty()) {
            request.setAttribute("carownerList", (Object)carownerList);
            request.setAttribute("paginationDisplay", (Object)new PaginationDisplay(p, 5));
        }
        if ((carOwnerAttrMap = ServiceUtil.getServiceContext().getDBConfigCache().getAttributeTypeMap().get(8)) != null && !carOwnerAttrMap.isEmpty()) {
            request.setAttribute("carOwnerAttrMapSize", (Object)carOwnerAttrMap.size());
            request.setAttribute("carOwnerAttrMap", carOwnerAttrMap);
        } else {
            request.setAttribute("carOwnerAttrMapSize", (Object)0);
        }
        WebUtil.dispathTemplatePage("carparkPlateManage", request, response);
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c")
    @Path(value="/addCarparkPassport.action")
    public void addCarparkPassport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ApplicationService appService;
        String passport_type_no = request.getParameter("passport_type_no");
        Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        CarparkPassportType passportType = passportTypeMap.get(passport_type_no);
        if (passportType == null) {
            WebUtil.printFinshJson(1, "\u65e0\u6548\u8f66\u724c\u7c7b\u578b\u7f16\u53f7", response);
            return;
        }
        if (passportType.getPass_type() == 5) {
            WebUtil.printFinshJson(1, "\u4e0d\u53ef\u6dfb\u52a0\u8bbf\u5ba2\u8f66\u7c7b\u578b\u8f66\u8f86", response);
            return;
        }
        String car_type_no = request.getParameter("car_type_no");
        CarparkCarType carType = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap().get(car_type_no);
        if (carType == null) {
            WebUtil.printFinshJson(1, "\u65e0\u6548\u8f66\u8f86\u7c7b\u578b\u7f16\u53f7", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        String passport_number = request.getParameter("passport_number");
        Integer medium_type = Integer.valueOf(request.getParameter("medium_type"));
        String parking_space_no = request.getParameter("parking_space_no");
        String car_logo = request.getParameter("car_logo");
        String vehicle_number = request.getParameter("vehicle_number");
        String recharge_unit = request.getParameter("recharge_unit");
        String recharge_period = request.getParameter("recharge_period");
        String _start_date = request.getParameter("start_date");
        String _deadline = request.getParameter("deadline");
        String _balance = request.getParameter("balance");
        String pay_method = request.getParameter("pay_method");
        String pay_money = request.getParameter("pay_money");
        String register_plate = request.getParameter("register_plate");
        boolean useCarOwnerAccount = false;
        if (passportType.getPass_type() == 1 && "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CAR_OWNER_ACCOUNT_BALANCE")) && "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType.getPassport_type_no(), "STOREAGE_DECUNT_AOUHNT"))) {
            useCarOwnerAccount = true;
        }
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        if (passport_number != null && passport_number.length() > 0) {
            long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPassport.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("passport_number", (Object)passport_number).addEQ("medium_type", (Object)medium_type));
            if (count > 0L) {
                if (medium_type == 6) {
                    WebUtil.printFinshJson(1, "\u8f66\u724c\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!", response);
                    return;
                }
                WebUtil.printFinshJson(1, "\u5361\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!", response);
                return;
            }
            if (register_plate != null && register_plate.length() > 0 && (count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPassport.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("register_plate", (Object)register_plate))) > 0L) {
                WebUtil.printFinshJson(1, "\u8f66\u724c\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!", response);
                return;
            }
        } else {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u901a\u884c\u8bc1/\u5361\u53f7!", response);
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        java.util.Date now = ServiceUtil.getNow();
        CarparkPassport passport = new CarparkPassport();
        if (!useCarOwnerAccount) {
            passport.setBalance(_balance == null ? Constants.MONEY_ZERO : new BigDecimal(_balance));
        } else {
            passport.setBalance(Constants.MONEY_ZERO);
        }
        passport.setCar_color("");
        passport.setCar_logo(car_logo);
        passport.setCar_type_no(car_type_no);
        passport.setCarpark_id(carpark_id);
        passport.setCash_pledge(Constants.MONEY_ZERO);
        passport.setCreated_time(now);
        if (_deadline != null && _deadline.length() > 0) {
            passport.setDeadline(df.parse(String.valueOf(_deadline) + " 23:59:59"));
        }
        passport.setForbid_online_pay(0);
        passport.setIc_as_id(1);
        passport.setIc_key("");
        passport.setIc_sector("");
        passport.setLast_updated_time(now);
        passport.setMedium_type(medium_type);
        passport.setNumber_times(0);
        passport.setParking_space_no(parking_space_no);
        passport.setPassport_number(passport_number);
        passport.setPassport_state(0);
        passport.setPassport_type_no(passport_type_no);
        passport.setProject_id(project_id);
        passport.setReg_source(1);
        passport.setReg_time(now);
        passport.setRegister_plate(register_plate);
        passport.setRemain_hours(0);
        passport.setRemark("");
        if (_start_date != null && _start_date.length() > 0) {
            passport.setStart_date(df.parse(String.valueOf(_start_date) + " 00:00:00"));
        } else {
            Calendar cl1 = Calendar.getInstance();
            cl1.set(11, 0);
            cl1.set(12, 0);
            cl1.set(13, 0);
            cl1.set(14, 0);
            passport.setStart_date(cl1.getTime());
        }
        passport.setStop_date(null);
        passport.setSurface_number("");
        passport.setValid_date(null);
        passport.setVehicle_number(vehicle_number);
        CarparkCarOwner addowner = null;
        String car_owner_name = request.getParameter("car_owner_name");
        boolean addNewCarOwner = false;
        if (passportType.getPass_type() == 0 && passportType.getUse_muti_car() == 0) {
            passport.setCar_owner_no("");
        } else {
            String car_owner_no = request.getParameter("car_owner_no");
            if (car_owner_no == null || (car_owner_no = car_owner_no.trim()).length() == 0) {
                long count;
                if (car_owner_name == null || (car_owner_name = car_owner_name.trim()).length() == 0) {
                    WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u8f66\u4e3b\u540d\u79f0", response);
                    return;
                }
                car_owner_name = ServiceUtil.getString(car_owner_name, 45);
                addowner = new CarparkCarOwner();
                addNewCarOwner = true;
                addowner.setCar_owner_name(car_owner_name);
                JavaBeanMap beanMap = new JavaBeanMap((Object)addowner);
                Set names = beanMap.keySet();
                Set<String> notSet = ServiceUtil.toSet("id", "car_owner_no", "car_owner_name", "sex", "birthday", "head_photo", "created_time", "last_updated_time", "project_id", "carpark_id");
                for (String name : names) {
                    String pv;
                    if (notSet.contains(name) || (pv = request.getParameter(name)) == null) continue;
                    pv = pv.trim();
                    beanMap.put(name, (Object)pv);
                }
                String _sex = request.getParameter("sex");
                int sex = 0;
                if (_sex != null && _sex.length() > 0) {
                    try {
                        sex = Integer.parseInt(_sex);
                        if (sex != 1) {
                            sex = 0;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (addowner.getId_number() != null && addowner.getId_number().length() > 0) {
                    addowner.setId_number(addowner.getId_number().toUpperCase());
                    if (!ValidateUtil.isIDCard(addowner.getId_number())) {
                        WebUtil.printFinshJson(1, "\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef\uff01", response);
                        return;
                    }
                    long count2 = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkCarOwner.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("id_number", (Object)addowner.getId_number()));
                    if (count2 > 0L) {
                        WebUtil.printFinshJson(1, "\u8eab\u4efd\u8bc1\u53f7\u4e3a\uff1a" + addowner.getId_number() + " \u7684\u8f66\u4e3b\u5df2\u5b58\u5728!", response);
                        return;
                    }
                }
                if (addowner.getPhone_number() != null && addowner.getPhone_number().length() > 0) {
                    if (!ValidateUtil.isCellPhone(addowner.getPhone_number())) {
                        WebUtil.printFinshJson(1, "\u624b\u673a\u53f7\u9519\u8bef\uff01", response);
                        return;
                    }
                    long count3 = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkCarOwner.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("phone_number", (Object)addowner.getPhone_number()));
                    if (count3 > 0L) {
                        WebUtil.printFinshJson(1, "\u624b\u673a\u53f7\u4e3a\uff1a" + addowner.getPhone_number() + " \u7684\u8f66\u4e3b\u5df2\u5b58\u5728!", response);
                        return;
                    }
                }
                if (addowner.getEmail() != null && addowner.getEmail().length() > 0) {
                    if (!ValidateUtil.isEmail(addowner.getEmail())) {
                        WebUtil.printFinshJson(1, "\u7535\u5b50\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\uff01", response);
                        return;
                    }
                    long count4 = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkCarOwner.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("email", (Object)addowner.getEmail()));
                    if (count4 > 0L) {
                        WebUtil.printFinshJson(1, "\u7535\u5b50\u90ae\u7bb1\u4e3a\uff1a" + addowner.getEmail() + " \u7684\u8f66\u4e3b\u5df2\u5b58\u5728!", response);
                        return;
                    }
                }
                if (addowner.getDriver_number() != null && addowner.getDriver_number().length() > 0 && (count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkCarOwner.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("driver_number", (Object)addowner.getDriver_number()))) > 0L) {
                    WebUtil.printFinshJson(1, "\u9a7e\u9a76\u8bc1\u53f7\u4e3a\uff1a" + addowner.getDriver_number() + " \u7684\u8f66\u4e3b\u5df2\u5b58\u5728!", response);
                    return;
                }
                addowner.setSex(sex);
                addowner.setCreated_time(now);
                addowner.setLast_updated_time(now);
                addowner.setProject_id(project_id);
                addowner.setCarpark_id(carpark_id);
                String birthday = request.getParameter("birthday");
                if (birthday != null && birthday.length() > 0) {
                    addowner.setBirthday(new Date(new SimpleDateFormat("yyyy-MM-dd").parse(birthday).getTime()));
                }
                if (useCarOwnerAccount) {
                    addowner.setAccount_balance(_balance == null ? Constants.MONEY_ZERO : new BigDecimal(_balance));
                } else {
                    addowner.setAccount_balance(Constants.MONEY_ZERO);
                }
            } else {
                passport.setCar_owner_no(car_owner_no);
            }
        }
        CarparkUser opuser = WebUtil.getLoginManageUser(request);
        CarparkTransaction trans = null;
        CarparkCarOwner updateBlanceCarOwner = null;
        if (passportType.getPass_type() == 1 || passportType.getPass_type() == 2 || passportType.getPass_type() == 4) {
            trans = new CarparkTransaction();
            if (passportType.getPass_type() == 1) {
                if (useCarOwnerAccount) {
                    if (addNewCarOwner) {
                        trans.setBalance_before(Constants.MONEY_ZERO);
                        trans.setRecharge_money(new BigDecimal(_balance));
                        trans.setBalance(trans.getRecharge_money());
                        trans.setTran_des(String.valueOf(passportType.getPassport_type_name()) + "\u6ce8\u518c, \u4f7f\u7528\u8f66\u4e3b\u8d26\u6237");
                        trans.setService_type(5);
                    } else {
                        CarparkCarOwner carOwner = (CarparkCarOwner)commonDaoService.selectOne(new SearchParam().addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()).addEQ("car_owner_no", (Object)passport.getCar_owner_no()), CarparkCarOwner.class);
                        if (carOwner.getAccount_balance() == null) {
                            carOwner.setAccount_balance(Constants.MONEY_ZERO);
                        }
                        trans.setBalance_before(carOwner.getAccount_balance());
                        trans.setRecharge_money(new BigDecimal(_balance));
                        trans.setBalance(trans.getRecharge_money().add(trans.getBalance_before()));
                        trans.setTran_des(String.valueOf(passportType.getPassport_type_name()) + "\u6ce8\u518c, \u4f7f\u7528\u8f66\u4e3b\u8d26\u6237");
                        trans.setService_type(5);
                        if (trans.getRecharge_money().doubleValue() > 0.0) {
                            updateBlanceCarOwner = carOwner;
                            updateBlanceCarOwner.setAccount_balance(trans.getBalance());
                        }
                    }
                } else {
                    trans.setBalance_before(Constants.MONEY_ZERO);
                    trans.setRecharge_money(new BigDecimal(_balance));
                    trans.setBalance(trans.getRecharge_money());
                    trans.setTran_des(String.valueOf(passportType.getPassport_type_name()) + "\u6ce8\u518c, \u4f7f\u7528\u8f66\u8f86\u8d26\u6237");
                    trans.setService_type(5);
                }
            } else if (passportType.getPass_type() == 2) {
                trans.setValid_date_before(null);
                trans.setStart_date(passport.getStart_date());
                trans.setEnd_date(passport.getDeadline());
                if (recharge_unit != null && recharge_unit.length() > 0 && recharge_period != null && recharge_period.length() > 0) {
                    trans.setTran_quantity(Integer.valueOf(recharge_period));
                    trans.setTran_unit(Integer.valueOf(recharge_unit));
                }
                trans.setTran_des(String.valueOf(passportType.getPassport_type_name()) + "\u6ce8\u518c");
                trans.setService_type(2);
            } else if (passportType.getPass_type() == 4) {
                trans.setService_type(8);
                trans.setTran_des(String.valueOf(passportType.getPassport_type_name()) + "\u6ce8\u518c");
            }
            if (addNewCarOwner && addowner != null && addowner.getRemark() != null && addowner.getRemark().length() > 0) {
                trans.setTran_des(ServiceUtil.getString(String.valueOf(trans.getTran_des()) + ", " + addowner.getRemark(), 200));
            }
            trans.setTran_type(0);
            trans.setPlate_number(passport.getRegister_plate());
            trans.setPassport_no(passport.getPassport_no());
            trans.setPassport_number(passport.getPassport_number());
            trans.setMedium_type(passport.getMedium_type());
            trans.setPass_type(passportType.getPass_type());
            trans.setPassport_type_no(passportType.getPassport_type_no());
            trans.setPassport_type_name(passportType.getPassport_type_name());
            trans.setCar_type_no(car_type_no);
            trans.setCar_type_name(carType.getCar_type_name());
            if (pay_money == null || pay_money.length() == 0) {
                trans.setTran_money(Constants.MONEY_ZERO);
            } else {
                trans.setTran_money(new BigDecimal(pay_money));
            }
            trans.setTran_time(now);
            if (pay_method == null || pay_method.length() == 0) {
                trans.setPay_method(0);
            } else {
                trans.setPay_method(Integer.valueOf(pay_method));
            }
            trans.setPay_scene(1);
            trans.setCharge_org(0);
            trans.setPay_entry(1);
            trans.setTran_channel_no(null);
            trans.setEnter_record_no(null);
            trans.setEnter_time(null);
            trans.setOperate_user_code(opuser.getUser_code());
            trans.setOperate_user_name(opuser.getUser_name());
            trans.setShould_charge(null);
            trans.setDiscount_money(null);
            trans.setHost_no(WebUtil.getOpHostNo(request));
            CarparkHost host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(trans.getHost_no());
            trans.setHost_name(host == null ? null : host.getHost_name());
            trans.setDuty_no(WebUtil.getOpDutyNo(request));
            trans.setCreated_time(now);
            trans.setCarpark_id(carpark_id);
            trans.setProject_id(project_id);
        }
        StringBuilder op_des = new StringBuilder(128);
        op_des.append("\u6ce8\u518c\u8f66\u724c:").append(passport.getRegister_plate()).append(",\u7c7b\u578b:");
        op_des.append(Constants.getPassTypeMap().get(passportType.getPass_type()));
        op_des.append(",\u7c7b\u578b\u540d:").append(passportType.getPassport_type_name());
        op_des.append(",\u8f66\u8f86\u7c7b\u578b:").append(carType.getCar_type_name());
        if (car_owner_name != null && car_owner_name.length() > 0) {
            op_des.append(",\u6240\u5c5e\u8f66\u4e3b:").append(car_owner_name);
        }
        if (trans != null) {
            if (passportType.getPass_type() == 1) {
                op_des.append(",\u5145\u503c\u505c\u8f66\u8d39:").append(trans.getRecharge_money());
                op_des.append(",\u652f\u4ed8\u91d1\u989d:").append(trans.getTran_money());
            } else if (passportType.getPass_type() == 2) {
                SimpleDateFormat dfx = new SimpleDateFormat("yyyy-MM-dd");
                if (trans.getStart_date() != null) {
                    op_des.append(",\u5f00\u59cb\u65e5\u671f:").append(dfx.format(trans.getStart_date()));
                }
                if (trans.getEnd_date() != null) {
                    op_des.append(",\u7ed3\u675f\u65e5\u671f:").append(dfx.format(trans.getEnd_date()));
                }
                op_des.append(",\u652f\u4ed8\u91d1\u989d:").append(trans.getTran_money());
            }
            if (trans.getTran_money() != null && trans.getTran_money().doubleValue() > 0.0 && trans.getPay_method() != null) {
                op_des.append(",\u652f\u4ed8\u65b9\u5f0f:").append(ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(trans.getPay_method()));
            }
        }
        CarparkOperationLog opLog = new CarparkOperationLog();
        opLog.setOp_cat(Constants.LOG_OP_CAT_1);
        opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_1_1);
        opLog.setOp_time(now);
        opLog.setOp_des(ServiceUtil.getString(op_des.toString(), 500));
        opLog.setOp_user_code(opuser.getUser_code());
        opLog.setOp_user_name(opuser.getUser_name());
        opLog.setCarpark_id(carpark_id);
        opLog.setProject_id(project_id);
        LinkedList<CarparkDispatchTask> taskList = null;
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                passport.setId(commonDaoService.getSequece("ck_common_seq"));
                passport.setPassport_no("C" + passport.getId());
                if (addowner != null) {
                    addowner.setId(commonDaoService.getSequece("ck_common_seq"));
                    addowner.setCar_owner_no("C" + addowner.getId());
                    passport.setCar_owner_no(addowner.getCar_owner_no());
                    if (trans != null) {
                        trans.setTran_user_no(addowner.getCar_owner_no());
                        trans.setTran_user_name(addowner.getCar_owner_name());
                    }
                } else if (trans != null && passport.getCar_owner_no() != null && passport.getCar_owner_no().length() > 0) {
                    trans.setTran_user_no(passport.getCar_owner_no());
                    trans.setTran_user_name(car_owner_name);
                }
                appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
                if (trans != null) {
                    List<CarparkDispatchTask> tlist;
                    trans.setId(appService.createLocalRecordSeq("ck_carpark_transaction_seq"));
                    trans.setTansaction_no("C" + trans.getId());
                    trans.setOrder_no(null);
                    trans.setPassport_no(passport.getPassport_no());
                    commonDaoService.insert(session, (Object)trans);
                    if (!ServiceUtil.getServiceContext().getLocalHostNo().equals(trans.getHost_no()) && (tlist = DispatchDataTaskUtil.createDispatchRecordByIdTaskList(commonDaoService.getTableName(CarparkTransaction.class), trans.getId(), trans.getHost_no())) != null && !tlist.isEmpty()) {
                        if (taskList == null) {
                            taskList = new LinkedList<CarparkDispatchTask>();
                        }
                        for (CarparkDispatchTask t : tlist) {
                            commonDaoService.insert(session, (Object)t);
                            taskList.add(t);
                        }
                    }
                }
                commonDaoService.insert(session, (Object)passport);
                if (addowner != null) {
                    commonDaoService.insert(session, (Object)addowner);
                } else if (updateBlanceCarOwner != null) {
                    CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkCarOwner.class));
                    updateP.addEQ("carpark_id", (Object)updateBlanceCarOwner.getCarpark_id());
                    updateP.addEQ("car_owner_no", (Object)updateBlanceCarOwner.getCar_owner_no());
                    updateP.addUpdate("last_updated_time", (Object)ServiceUtil.getNow());
                    updateP.addUpdate("account_balance", (Object)updateBlanceCarOwner.getAccount_balance());
                    commonDaoService.update(session, updateP);
                }
                commonDaoService.insert(session, (Object)opLog);
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
        if (taskList != null && !taskList.isEmpty()) {
            appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            appService.asynTryRunDispatchTask((Collection<CarparkDispatchTask>)taskList);
        }
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u7eed\u8d39\u5ef6\u671f")
    @Path(value="/updatePassportRechageDate.action")
    public void updatePassportRechageDate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String _id = request.getParameter("id");
        if (_id == null || _id.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11id", response);
            return;
        }
        Long id = null;
        try {
            id = Long.valueOf(_id);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u65e0\u6548id", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPassport oldPassport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkPassport.class);
        if (oldPassport == null) {
            WebUtil.printFinshJson(1, "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", response);
            return;
        }
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        String opx = request.getParameter("opx");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (Constants.YES_STR.equals(opx)) {
            List rechargeList;
            java.util.Date today;
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            java.util.Date startDate = today = cl.getTime();
            if (oldPassport.getDeadline() != null) {
                returnMap.put("beforeDeadline", df.format(oldPassport.getDeadline()));
                if (oldPassport.getDeadline().before(today)) {
                    if ("1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(oldPassport.getPassport_type_no(), "DELAYED_START_TIME"))) {
                        cl.setTime(oldPassport.getDeadline());
                        cl.set(14, 0);
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.add(5, 1);
                        startDate = cl.getTime();
                    } else {
                        CarparkPassRecord record;
                        ApplicationService applicationService;
                        KeyValueEntry<CarparkPassport, KeyValueEntry<CarparkPassportType, CarparkPresenceRecord>> entry;
                        String show = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(oldPassport.getPassport_type_no(), "PASSTYPE_RECHARGE_SHOW_TEMPMONEY");
                        boolean showTempCost = show != null && "1".equals(show);
                        SearchParam queryPx = new SearchParam().addEQ("passport_number", (Object)oldPassport.getPassport_number()).addEQ("medium_type", (Object)oldPassport.getMedium_type()).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id);
                        queryPx.setOrerbySql("enter_time,area_level");
                        if (!showTempCost) {
                            queryPx.setQueryFields(new String[]{"enter_time", "area_level"});
                        }
                        CarparkPassRecord cRecord = null;
                        List presenceRecordList = commonDaoService.selectList(queryPx, CarparkPresenceRecord.class, null);
                        LinkedList<CarparkPresenceRecord> subRecordsList = null;
                        if (presenceRecordList != null && !presenceRecordList.isEmpty()) {
                            for (CarparkPresenceRecord r : presenceRecordList) {
                                if (r.getEnter_time() == null || r.getExit_time() != null) continue;
                                if (r.getArea_level() != null && r.getArea_level() == 1) {
                                    cRecord = r;
                                    continue;
                                }
                                if (subRecordsList == null) {
                                    subRecordsList = new LinkedList<CarparkPresenceRecord>();
                                }
                                subRecordsList.add(r);
                            }
                        }
                        CarparkPassRecord takeRecord = null;
                        if (cRecord == null && (entry = (applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class)).queryRechargeMutiTempRecord(oldPassport)) != null) {
                            takeRecord = (CarparkPresenceRecord)((KeyValueEntry)entry.getValue()).getValue();
                        }
                        if ((record = takeRecord != null ? takeRecord : cRecord) != null && record.getEnter_time() != null) {
                            if (record.getEnter_time().before(today)) {
                                String zv = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(oldPassport.getPassport_type_no(), "PASSTYPE_DELAYED_START_TIME_IGNOLENTER");
                                if (zv != null && "1".equals(zv)) {
                                    startDate = today;
                                } else if (record.getEnter_time().before(oldPassport.getDeadline())) {
                                    cl.setTime(oldPassport.getDeadline());
                                    cl.set(14, 0);
                                    cl.set(13, 0);
                                    cl.set(12, 0);
                                    cl.set(11, 0);
                                    cl.add(5, 1);
                                    startDate = cl.getTime();
                                } else {
                                    cl.setTime(record.getEnter_time());
                                    cl.set(14, 0);
                                    cl.set(13, 0);
                                    cl.set(12, 0);
                                    cl.set(11, 0);
                                    startDate = cl.getTime();
                                }
                            }
                            returnMap.put("enter_time", df1.format(record.getEnter_time()));
                            if (!oldPassport.getRegister_plate().equals(record.getEnter_plate())) {
                                returnMap.put("take_plate", record.getEnter_plate());
                            }
                            if (showTempCost) {
                                try {
                                    ApplicationService applicationService2 = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                                    Cost cost = applicationService2.charge(record, ServiceUtil.getNow(), oldPassport.getPassport_type_no(), record.getEnter_car_type_no(), oldPassport.getDeadline(), record.getEnter_plate(), record.getPassport_number(), record.getMedium_type(), record.getEnter_time(), null, null, subRecordsList);
                                    if (cost != null) {
                                        returnMap.put("tempCost", cost.getActualCharge().toString());
                                    }
                                }
                                catch (Exception ex) {
                                    WebLog.getLog().warn((Object)"\u8ba1\u8d39\u9519\u8bef", (Throwable)ex);
                                }
                            }
                        }
                    }
                    returnMap.put("expire", "1");
                } else {
                    cl.setTime(oldPassport.getDeadline());
                    cl.set(14, 0);
                    cl.set(13, 0);
                    cl.set(12, 0);
                    cl.set(11, 0);
                    cl.add(5, 1);
                    startDate = cl.getTime();
                }
            }
            returnMap.put("start_time", df.format(startDate));
            cl.setTime(startDate);
            cl.add(2, 1);
            cl.add(5, -1);
            returnMap.put("defaultenddate", df.format(cl.getTime()));
            Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            CarparkPassportType oldPassportType = passportTypeMap.get(oldPassport.getPassport_type_no());
            if (oldPassportType != null) {
                returnMap.put("passport_type_name", oldPassportType.getPassport_type_name());
            }
            if (oldPassport.getPassport_type_no() != null && oldPassport.getCar_type_no() != null && (rechargeList = commonDaoService.selectList(new SearchParam(commonDaoService.getTableName(CarparkRechargeRule.class)).setQueryFields(new String[]{"recharge_rule_no", "recharge_quantity", "recharge_unit", "charge_amount"}).addEQ("passport_type_no", (Object)oldPassport.getPassport_type_no()).addEQ("car_type_no", (Object)oldPassport.getCar_type_no()).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("recharge_unit,recharge_quantity"), null)) != null && !rechargeList.isEmpty()) {
                returnMap.put("rechargeList", rechargeList);
            }
        } else {
            ApplicationService appService;
            String beforeDeadline = request.getParameter("beforeDeadline");
            if (beforeDeadline != null && beforeDeadline.length() > 0 && oldPassport.getDeadline() != null && !df.format(oldPassport.getDeadline()).equals(beforeDeadline)) {
                WebUtil.printFinshJson(0, "\u8f66\u724c:" + oldPassport.getRegister_plate() + "\u6709\u6548\u671f\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u64cd\u4f5c!", response);
                return;
            }
            Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            CarparkPassportType passportType1 = passportTypeMap.get(oldPassport.getPassport_type_no());
            Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
            CarparkCarType carType = carTypeMap.get(oldPassport.getCar_type_no());
            java.util.Date start_date = df1.parse(String.valueOf(request.getParameter("start_date")) + " 00:00:00");
            java.util.Date end_date = df1.parse(String.valueOf(request.getParameter("end_date")) + " 23:59:59");
            int pay_method = Integer.parseInt(request.getParameter("pay_method"));
            BigDecimal pay_money = new BigDecimal(request.getParameter("pay_money"));
            String recharge_period = request.getParameter("recharge_period");
            String recharge_unit = request.getParameter("recharge_unit");
            String remark = request.getParameter("remark");
            if (remark != null) {
                remark = remark.trim();
            }
            java.util.Date now = ServiceUtil.getNow();
            CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkPassport.class));
            updateP.addEQ("id", (Object)id);
            updateP.addUpdate("last_updated_time", (Object)now);
            updateP.addUpdate("deadline", (Object)end_date);
            StringBuilder op_des = new StringBuilder(128);
            if (oldPassport.getMedium_type() == 6) {
                op_des.append("\u8f66\u724c:").append(oldPassport.getPassport_number());
            } else {
                op_des.append("\u5361\u53f7:").append(oldPassport.getPassport_number());
                if (oldPassport.getRegister_plate() != null && oldPassport.getRegister_plate().length() > 0) {
                    op_des.append(",\u7ed1\u5b9a\u8f66\u724c:").append(oldPassport.getRegister_plate());
                }
            }
            if (passportType1 != null) {
                op_des.append("\u7c7b\u578b:").append(passportType1.getPassport_type_name());
            }
            if (carType != null) {
                op_des.append("\u8f66\u578b:").append(carType.getCar_type_name());
            }
            op_des.append(",\u5df2\u6210\u7eed\u8d39\u5ef6\u671f\uff01");
            if (beforeDeadline != null && beforeDeadline.length() > 0) {
                op_des.append(",\u5ef6\u671f\u524d\u6709\u6548\u671f\uff1a" + beforeDeadline);
            }
            op_des.append(",\u5ef6\u671f\u5f00\u59cb\u65e5\u671f\uff1a" + df.format(start_date));
            op_des.append(",\u5ef6\u671f\u7ed3\u675f\u65e5\u671f\uff1a" + df.format(end_date));
            op_des.append(",\u652f\u4ed8\u91d1\u989d:").append(pay_money);
            op_des.append(",\u652f\u4ed8\u65b9\u5f0f:").append(ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(pay_method));
            CarparkUser opuser = WebUtil.getLoginManageUser(request);
            CarparkOperationLog opLog = new CarparkOperationLog();
            opLog.setOp_cat(Constants.LOG_OP_CAT_1);
            opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_1_8);
            opLog.setOp_time(now);
            opLog.setOp_des(ServiceUtil.getString(op_des.toString(), 500));
            opLog.setOp_user_code(opuser.getUser_code());
            opLog.setOp_user_name(opuser.getUser_name());
            opLog.setCarpark_id(carpark_id);
            opLog.setProject_id(project_id);
            CarparkTransaction trans = null;
            if (pay_money.doubleValue() >= 0.0) {
                CarparkCarOwner owner;
                if (passportType1 == null) {
                    WebUtil.printFinshJson(1, "\u672a\u77e5\u8f66\u724c/\u5361\u7c7b\u578b\uff0c\u65e0\u6cd5\u7eed\u8d39\u5ef6\u671f", response);
                    return;
                }
                trans = new CarparkTransaction();
                trans.setService_type(3);
                trans.setStart_date(start_date);
                trans.setEnd_date(end_date);
                trans.setValid_date_before(oldPassport.getDeadline());
                if (recharge_unit != null && recharge_unit.length() > 0 && recharge_period != null && recharge_period.length() > 0) {
                    trans.setTran_quantity(Integer.valueOf(recharge_period));
                    trans.setTran_unit(Integer.valueOf(recharge_unit));
                }
                if (remark != null && remark.length() > 0) {
                    trans.setTran_des(ServiceUtil.getString(remark, 200));
                } else {
                    trans.setTran_des(String.valueOf(passportType1.getPassport_type_name()) + "\u7eed\u8d39\u5ef6\u671f");
                }
                trans.setTran_type(0);
                trans.setPlate_number(oldPassport.getRegister_plate());
                trans.setPassport_no(oldPassport.getPassport_no());
                trans.setPassport_number(oldPassport.getPassport_number());
                trans.setMedium_type(oldPassport.getMedium_type());
                trans.setPass_type(passportType1.getPass_type());
                trans.setPassport_type_no(passportType1.getPassport_type_no());
                trans.setPassport_type_name(passportType1.getPassport_type_name());
                trans.setCar_type_no(oldPassport.getCar_type_no());
                if (carType != null) {
                    trans.setCar_type_name(carType.getCar_type_name());
                }
                trans.setTran_money(pay_money);
                trans.setTran_time(now);
                trans.setPay_method(pay_method);
                trans.setPay_scene(1);
                trans.setCharge_org(0);
                trans.setPay_entry(1);
                trans.setTran_channel_no(null);
                trans.setTran_channel_name(null);
                trans.setEnter_record_no(null);
                trans.setEnter_time(null);
                trans.setOperate_user_code(opuser.getUser_code());
                trans.setOperate_user_name(opuser.getUser_name());
                trans.setShould_charge(null);
                trans.setDiscount_money(null);
                trans.setHost_no(WebUtil.getOpHostNo(request));
                CarparkHost host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(trans.getHost_no());
                trans.setHost_name(host == null ? null : host.getHost_name());
                trans.setDuty_no(WebUtil.getOpDutyNo(request));
                trans.setCreated_time(now);
                trans.setCarpark_id(carpark_id);
                trans.setProject_id(project_id);
                trans.setTran_user_no(oldPassport.getCar_owner_no());
                if (oldPassport.getCar_owner_no() != null && oldPassport.getCar_owner_no().length() > 0 && (owner = (CarparkCarOwner)commonDaoService.selectOne(new SearchParam().setQueryFields(new String[]{"car_owner_no", "car_owner_name"}).addEQ("car_owner_no", (Object)oldPassport.getCar_owner_no()).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkCarOwner.class)) != null) {
                    trans.setTran_user_name(owner.getCar_owner_name());
                }
            }
            LinkedList<CarparkDispatchTask> taskList = null;
            try (SqlSession session = commonDaoService.openSqlSession();){
                try {
                    commonDaoService.update(session, updateP);
                    appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
                    commonDaoService.insert(session, (Object)opLog);
                    if (trans != null) {
                        List<CarparkDispatchTask> tlist;
                        trans.setId(appService.createLocalRecordSeq("ck_carpark_transaction_seq"));
                        trans.setTansaction_no("C" + trans.getId());
                        trans.setOrder_no(null);
                        commonDaoService.insert(session, (Object)trans);
                        if (!ServiceUtil.getServiceContext().getLocalHostNo().equals(trans.getHost_no()) && (tlist = DispatchDataTaskUtil.createDispatchRecordByIdTaskList(commonDaoService.getTableName(CarparkTransaction.class), trans.getId(), trans.getHost_no())) != null && !tlist.isEmpty()) {
                            if (taskList == null) {
                                taskList = new LinkedList<CarparkDispatchTask>();
                            }
                            for (CarparkDispatchTask t : tlist) {
                                commonDaoService.insert(session, (Object)t);
                                taskList.add(t);
                            }
                        }
                    }
                    session.commit();
                }
                catch (Exception ex) {
                    session.rollback();
                    throw ex;
                }
            }
            WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
            if (taskList != null && !taskList.isEmpty()) {
                appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                appService.asynTryRunDispatchTask((Collection<CarparkDispatchTask>)taskList);
            }
            return;
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", returnMap, response);
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u5145\u503c\u505c\u8f66\u8d39")
    @Path(value="/updatePassportRechageFee.action")
    public void updatePassportRechageFee(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String _id = request.getParameter("id");
        if (_id == null || _id.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11id", response);
            return;
        }
        Long id = null;
        try {
            id = Long.valueOf(_id);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u65e0\u6548id", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPassport oldPassport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkPassport.class);
        if (oldPassport == null) {
            WebUtil.printFinshJson(1, "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", response);
            return;
        }
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        String opx = request.getParameter("opx");
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (Constants.YES_STR.equals(opx)) {
            Map<String, CarparkPassportType> passportTypeMap;
            CarparkPassportType oldPassportType;
            List rechargeList;
            if (oldPassport.getBalance() == null) {
                oldPassport.setBalance(Constants.MONEY_ZERO);
            }
            CarparkCarOwner userBlanceCarOwner = null;
            if (oldPassport.getCar_owner_no() != null && oldPassport.getCar_owner_no().length() > 0 && "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CAR_OWNER_ACCOUNT_BALANCE")) && "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(oldPassport.getPassport_type_no(), "STOREAGE_DECUNT_AOUHNT"))) {
                userBlanceCarOwner = (CarparkCarOwner)commonDaoService.selectOne(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("car_owner_no", (Object)oldPassport.getCar_owner_no()), CarparkCarOwner.class);
            }
            if (userBlanceCarOwner != null) {
                returnMap.put("balance", userBlanceCarOwner.getAccount_balance().toString());
                returnMap.put("account_type", "\u8f66\u4e3b\u8d26\u6237(" + userBlanceCarOwner.getCar_owner_name() + ")");
                returnMap.put("account_type_value", "1");
            } else {
                returnMap.put("balance", oldPassport.getBalance().toString());
                returnMap.put("account_type", "\u8f66\u8f86\u8d26\u6237");
                returnMap.put("account_type_value", "0");
            }
            if (oldPassport.getPassport_type_no() != null && oldPassport.getCar_type_no() != null && (rechargeList = commonDaoService.selectList(new SearchParam(commonDaoService.getTableName(CarparkRechargeRule.class)).setQueryFields(new String[]{"recharge_rule_no", "recharge_quantity", "recharge_unit", "charge_amount"}).addEQ("passport_type_no", (Object)oldPassport.getPassport_type_no()).addEQ("car_type_no", (Object)oldPassport.getCar_type_no()).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("recharge_unit,recharge_quantity"), null)) != null && !rechargeList.isEmpty()) {
                returnMap.put("rechargeList", rechargeList);
            }
            if ((oldPassportType = (passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap()).get(oldPassport.getPassport_type_no())) != null) {
                returnMap.put("passport_type_name", oldPassportType.getPassport_type_name());
            }
        } else {
            ApplicationService appService;
            BigDecimal balance;
            CommonParam updateP;
            Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            CarparkPassportType passportType1 = passportTypeMap.get(oldPassport.getPassport_type_no());
            Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
            CarparkCarType carType = carTypeMap.get(oldPassport.getCar_type_no());
            int pay_method = Integer.parseInt(request.getParameter("pay_method"));
            BigDecimal pay_money = new BigDecimal(request.getParameter("pay_money"));
            BigDecimal rechage_money = new BigDecimal(request.getParameter("rechage_money"));
            if (pay_money.doubleValue() < 0.0) {
                WebUtil.printFinshJson(1, "\u652f\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", response);
                return;
            }
            if (rechage_money.doubleValue() < 0.0) {
                WebUtil.printFinshJson(1, "\u5145\u503c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", response);
                return;
            }
            java.util.Date now = ServiceUtil.getNow();
            CarparkCarOwner userBlanceCarOwner = null;
            if (oldPassport.getCar_owner_no() != null && oldPassport.getCar_owner_no().length() > 0 && passportType1.getPass_type() == 1 && "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getCarparkStrategyValue("CAR_OWNER_ACCOUNT_BALANCE")) && "1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passportType1.getPassport_type_no(), "STOREAGE_DECUNT_AOUHNT"))) {
                userBlanceCarOwner = (CarparkCarOwner)commonDaoService.selectOne(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("car_owner_no", (Object)oldPassport.getCar_owner_no()), CarparkCarOwner.class);
            }
            StringBuilder op_des = new StringBuilder(128);
            if (oldPassport.getMedium_type() == 6) {
                op_des.append("\u8f66\u724c:").append(oldPassport.getPassport_number());
            } else {
                op_des.append("\u5361\u53f7:").append(oldPassport.getPassport_number());
                if (oldPassport.getRegister_plate() != null && oldPassport.getRegister_plate().length() > 0) {
                    op_des.append(",\u7ed1\u5b9a\u8f66\u724c:").append(oldPassport.getRegister_plate());
                }
            }
            if (passportType1 != null) {
                op_des.append("\u7c7b\u578b:").append(passportType1.getPassport_type_name());
            }
            if (carType != null) {
                op_des.append("\u8f66\u578b:").append(carType.getCar_type_name());
            }
            if (userBlanceCarOwner != null) {
                updateP = new CommonParam(commonDaoService.getTableName(CarparkCarOwner.class));
                updateP.addEQ("carpark_id", (Object)carpark_id);
                updateP.addEQ("car_owner_no", (Object)userBlanceCarOwner.getCar_owner_no());
                updateP.addEQ("account_balance", (Object)userBlanceCarOwner.getAccount_balance());
                if (userBlanceCarOwner.getAccount_balance() == null) {
                    userBlanceCarOwner.setAccount_balance(Constants.MONEY_ZERO);
                }
                balance = userBlanceCarOwner.getAccount_balance().add(rechage_money);
                updateP.addUpdate("account_balance", (Object)balance);
                updateP.addUpdate("last_updated_time", (Object)now);
                op_des.append(",\u8f66\u4e3b\u8d26\u6237,\u5145\u503c\u524d\u4f59\u989d:" + userBlanceCarOwner.getAccount_balance());
                op_des.append(",\u5145\u503c\u91d1\u989d:" + rechage_money);
                op_des.append(",\u5145\u503c\u540e\u4f59\u989d:" + balance);
            } else {
                updateP = new CommonParam(commonDaoService.getTableName(CarparkPassport.class));
                updateP.addEQ("id", (Object)id);
                if (oldPassport.getBalance() == null) {
                    updateP.addEQ("balance", null);
                } else {
                    updateP.addEQ("balance", (Object)oldPassport.getBalance());
                }
                updateP.addUpdate("last_updated_time", (Object)now);
                if (oldPassport.getBalance() == null) {
                    oldPassport.setBalance(Constants.MONEY_ZERO);
                }
                balance = oldPassport.getBalance().add(rechage_money);
                updateP.addUpdate("balance", (Object)balance);
                op_des.append(",\u8f66\u8f86\u8d26\u6237,\u5145\u503c\u524d\u4f59\u989d:" + oldPassport.getBalance());
                op_des.append(",\u5145\u503c\u91d1\u989d:" + rechage_money);
                op_des.append(",\u5145\u503c\u540e\u4f59\u989d:" + balance);
            }
            op_des.append(",\u652f\u4ed8\u91d1\u989d:").append(pay_money);
            op_des.append(",\u652f\u4ed8\u65b9\u5f0f:").append(ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(pay_method));
            CarparkUser opuser = WebUtil.getLoginManageUser(request);
            CarparkOperationLog opLog = new CarparkOperationLog();
            opLog.setOp_cat(Constants.LOG_OP_CAT_1);
            opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_1_9);
            opLog.setOp_time(now);
            opLog.setOp_des(ServiceUtil.getString(op_des.toString(), 500));
            opLog.setOp_user_code(opuser.getUser_code());
            opLog.setOp_user_name(opuser.getUser_name());
            opLog.setCarpark_id(carpark_id);
            opLog.setProject_id(project_id);
            CarparkTransaction trans = null;
            if (pay_money.doubleValue() > 0.0) {
                CarparkCarOwner owner;
                if (passportType1 == null) {
                    WebUtil.printFinshJson(1, "\u672a\u77e5\u8f66\u724c/\u5361\u7c7b\u578b\uff0c\u65e0\u6cd5\u7eed\u8d39\u5ef6\u671f", response);
                    return;
                }
                trans = new CarparkTransaction();
                trans.setService_type(6);
                if (userBlanceCarOwner != null) {
                    trans.setBalance_before(userBlanceCarOwner.getAccount_balance());
                } else {
                    trans.setBalance_before(oldPassport.getBalance());
                }
                trans.setBalance(balance);
                trans.setRecharge_money(rechage_money);
                trans.setTran_des(String.valueOf(passportType1.getPassport_type_name()) + "\u5145\u503c, " + (userBlanceCarOwner == null ? "\u8f66\u8f86\u8d26\u6237" : "\u8f66\u4e3b\u8d26\u6237"));
                trans.setTran_type(0);
                trans.setPlate_number(oldPassport.getRegister_plate());
                trans.setPassport_no(oldPassport.getPassport_no());
                trans.setPassport_number(oldPassport.getPassport_number());
                trans.setMedium_type(oldPassport.getMedium_type());
                trans.setPass_type(passportType1.getPass_type());
                trans.setPassport_type_no(passportType1.getPassport_type_no());
                trans.setPassport_type_name(passportType1.getPassport_type_name());
                trans.setCar_type_no(oldPassport.getCar_type_no());
                if (carType != null) {
                    trans.setCar_type_name(carType.getCar_type_name());
                }
                trans.setTran_money(pay_money);
                trans.setTran_time(now);
                trans.setPay_method(pay_method);
                trans.setPay_scene(1);
                trans.setCharge_org(0);
                trans.setPay_entry(1);
                trans.setTran_channel_no(null);
                trans.setTran_channel_name(null);
                trans.setEnter_record_no(null);
                trans.setEnter_time(null);
                trans.setOperate_user_code(opuser.getUser_code());
                trans.setOperate_user_name(opuser.getUser_name());
                trans.setShould_charge(null);
                trans.setDiscount_money(null);
                trans.setHost_no(WebUtil.getOpHostNo(request));
                CarparkHost host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(trans.getHost_no());
                trans.setHost_name(host == null ? null : host.getHost_name());
                trans.setDuty_no(WebUtil.getOpDutyNo(request));
                trans.setCreated_time(now);
                trans.setCarpark_id(carpark_id);
                trans.setProject_id(project_id);
                trans.setTran_user_no(oldPassport.getCar_owner_no());
                if (userBlanceCarOwner != null) {
                    trans.setTran_user_name(userBlanceCarOwner.getCar_owner_name());
                    op_des.append(", ").append(userBlanceCarOwner.getCar_owner_name()).append(", ").append(userBlanceCarOwner.getCar_owner_no());
                } else if (oldPassport.getCar_owner_no() != null && oldPassport.getCar_owner_no().length() > 0 && (owner = (CarparkCarOwner)commonDaoService.selectOne(new SearchParam().setQueryFields(new String[]{"car_owner_no", "car_owner_name"}).addEQ("car_owner_no", (Object)oldPassport.getCar_owner_no()).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkCarOwner.class)) != null) {
                    trans.setTran_user_name(owner.getCar_owner_name());
                    op_des.append(", ").append(owner.getCar_owner_name()).append(", ").append(owner.getCar_owner_no());
                }
            }
            int count = 0;
            LinkedList<CarparkDispatchTask> taskList = null;
            try (SqlSession session = commonDaoService.openSqlSession();){
                try {
                    count = commonDaoService.update(session, updateP);
                    if (count > 0) {
                        appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                        opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
                        commonDaoService.insert(session, (Object)opLog);
                        if (trans != null) {
                            List<CarparkDispatchTask> tlist;
                            trans.setId(appService.createLocalRecordSeq("ck_carpark_transaction_seq"));
                            trans.setTansaction_no("C" + trans.getId());
                            trans.setOrder_no(null);
                            commonDaoService.insert(session, (Object)trans);
                            if (!ServiceUtil.getServiceContext().getLocalHostNo().equals(trans.getHost_no()) && (tlist = DispatchDataTaskUtil.createDispatchRecordByIdTaskList(commonDaoService.getTableName(CarparkTransaction.class), trans.getId(), trans.getHost_no())) != null && !tlist.isEmpty()) {
                                if (taskList == null) {
                                    taskList = new LinkedList<CarparkDispatchTask>();
                                }
                                for (CarparkDispatchTask t : tlist) {
                                    commonDaoService.insert(session, (Object)t);
                                    taskList.add(t);
                                }
                            }
                        }
                    }
                    session.commit();
                }
                catch (Exception ex) {
                    session.rollback();
                    throw ex;
                }
            }
            if (count > 0) {
                WebUtil.printFinshJson(0, balance.toString(), response);
            } else {
                WebUtil.printFinshJson(1, "\u53d8\u66f4\u4f59\u989d\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u3002", response);
            }
            if (taskList != null && !taskList.isEmpty()) {
                appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                appService.asynTryRunDispatchTask((Collection<CarparkDispatchTask>)taskList);
            }
            return;
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", returnMap, response);
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u4fee\u6539\u8f66\u8f86\u4fe1\u606f")
    @Path(value="/updateCarparkPassport.action")
    public void updateCarparkPassport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String car_type_no;
        String passport_type_no;
        String _id = request.getParameter("id");
        if (_id == null || _id.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11id", response);
            return;
        }
        Long id = null;
        try {
            id = Long.valueOf(_id);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u65e0\u6548id", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPassport oldPassport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkPassport.class);
        if (oldPassport == null) {
            WebUtil.printFinshJson(1, "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", response);
            return;
        }
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        StringBuilder op_des = new StringBuilder(128);
        if (oldPassport.getMedium_type() == 6) {
            op_des.append("\u8f66\u724c:").append(oldPassport.getPassport_number());
        } else {
            op_des.append("\u5361\u53f7:").append(oldPassport.getPassport_number());
            if (oldPassport.getRegister_plate() != null && oldPassport.getRegister_plate().length() > 0) {
                op_des.append(", \u8f66\u724c:").append(oldPassport.getRegister_plate());
            }
        }
        CarparkPassport updatePassport = new CarparkPassport();
        String register_plate = request.getParameter("register_plate");
        if (register_plate != null && register_plate.length() > 0 && register_plate.length() > 5 && register_plate.length() < 10) {
            long count;
            if (oldPassport.getMedium_type() == 6) {
                if (!register_plate.equals(oldPassport.getPassport_number())) {
                    count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPassport.class)).addNotEQ("id", (Object)id).addEQ("passport_number", (Object)register_plate).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id));
                    if (count > 0L) {
                        WebUtil.printFinshJson(1, "\u8f66\u724c\u53f7:" + register_plate + ",\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!", response);
                        return;
                    }
                    count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPassport.class)).addNotEQ("id", (Object)id).addEQ("register_plate", (Object)register_plate).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id));
                    if (count > 0L) {
                        WebUtil.printFinshJson(1, "\u8f66\u724c\u53f7:" + register_plate + ",\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!", response);
                        return;
                    }
                    updatePassport.setPassport_number(register_plate);
                    updatePassport.setRegister_plate(register_plate);
                    if (updatePassport.getId() == null) {
                        updatePassport.setId(id);
                    }
                    op_des.append(",\u53d8\u66f4\u4e3a:").append(register_plate);
                }
            } else if (!register_plate.equals(oldPassport.getRegister_plate())) {
                count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPassport.class)).addNotEQ("id", (Object)id).addEQ("register_plate", (Object)register_plate).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id));
                if (count > 0L) {
                    WebUtil.printFinshJson(1, "\u8f66\u724c\u53f7:" + register_plate + ",\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!", response);
                    return;
                }
                updatePassport.setRegister_plate(register_plate);
                if (updatePassport.getId() == null) {
                    updatePassport.setId(id);
                }
                if (oldPassport.getRegister_plate() == null || oldPassport.getRegister_plate().length() == 0) {
                    op_des.append("\uff0c\u7ed1\u5b9a\u8f66\u724c:").append(register_plate);
                } else {
                    op_des.append(",\u4fee\u6539\u4e3a\u8f66\u724c:").append(register_plate);
                }
            }
        } else if (!(oldPassport.getMedium_type() == 6 || register_plate != null && register_plate.length() != 0 || register_plate.equals(oldPassport.getRegister_plate()))) {
            updatePassport.setRegister_plate("");
            if (updatePassport.getId() == null) {
                updatePassport.setId(id);
            }
            op_des.append(", \u53d6\u6d88\u8f66\u724c\u4e0e\u5361\u7ed1\u5b9a");
        }
        if ((passport_type_no = request.getParameter("passport_type_no")) != null && passport_type_no.length() > 0 && !passport_type_no.equals(oldPassport.getPassport_type_no())) {
            CarparkPassportType passportType;
            Map<String, CarparkPassportType> passportTypeMap;
            CarparkPassportType oldPassportType;
            updatePassport.setPassport_type_no(passport_type_no);
            if (updatePassport.getId() == null) {
                updatePassport.setId(id);
            }
            if ((oldPassportType = (passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap()).get(oldPassport.getPassport_type_no())) != null) {
                op_des.append(",\u539f\u7c7b\u578b:").append(oldPassportType.getPassport_type_name());
            }
            if ((passportType = passportTypeMap.get(passport_type_no)) != null) {
                op_des.append(",\u53d8\u66f4\u4e3a:").append(passportType.getPassport_type_name());
                if (passportType.getPass_type() == 2) {
                    Calendar cl;
                    if (oldPassport.getDeadline() == null) {
                        cl = Calendar.getInstance();
                        cl.add(5, -1);
                        cl.set(14, 0);
                        cl.set(13, 59);
                        cl.set(12, 59);
                        cl.set(11, 23);
                        updatePassport.setDeadline(cl.getTime());
                    }
                    if (oldPassport.getStart_date() == null) {
                        cl = Calendar.getInstance();
                        cl.add(5, -1);
                        cl.set(14, 0);
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        updatePassport.setStart_date(cl.getTime());
                    }
                } else if (passportType.getPass_type() == 1 && oldPassport.getBalance() == null) {
                    updatePassport.setBalance(Constants.MONEY_ZERO);
                }
            } else {
                WebUtil.printFinshJson(1, "\u65e0\u6548\u8f66\u724c/\u5361\u7c7b\u578b,\u8bf7\u91cd\u65b0\u9009\u62e9", response);
                return;
            }
        }
        if ((car_type_no = request.getParameter("car_type_no")) != null && car_type_no.length() > 0 && !car_type_no.equals(oldPassport.getCar_type_no())) {
            CarparkCarType carType;
            Map<String, CarparkCarType> carTypeMap;
            CarparkCarType oldCarType;
            updatePassport.setCar_type_no(car_type_no);
            if (updatePassport.getId() == null) {
                updatePassport.setId(id);
            }
            if ((oldCarType = (carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap()).get(oldPassport.getCar_type_no())) != null) {
                op_des.append(",\u539f\u8f66\u8f86\u7c7b\u578b:").append(oldCarType.getCar_type_name());
            }
            if ((carType = carTypeMap.get(car_type_no)) != null) {
                op_des.append(",\u53d8\u66f4\u4e3a:").append(carType.getCar_type_name());
            } else {
                WebUtil.printFinshJson(1, "\u65e0\u6548\u8f66\u8f86\u7c7b\u578b,\u8bf7\u91cd\u65b0\u9009\u62e9", response);
                return;
            }
        }
        HashMap<String, String> cMap = new HashMap<String, String>();
        cMap.put("vehicle_number", "\u884c\u9a76\u8bc1\u53f7");
        cMap.put("parking_space_no", "\u505c\u8f66\u4f4d\u53f7");
        cMap.put("car_logo", "\u8f66\u8f86\u54c1\u724c");
        cMap.put("car_color", "\u8f66\u8f86\u989c\u8272");
        JavaBeanMap oldMap = new JavaBeanMap((Object)oldPassport);
        JavaBeanMap updateMap = new JavaBeanMap((Object)updatePassport);
        for (Map.Entry se : cMap.entrySet()) {
            String valu = request.getParameter((String)se.getKey());
            if (valu == null) continue;
            valu = valu.trim();
            String olv = (String)oldMap.get(se.getKey());
            if (olv == null) {
                olv = "";
            }
            if (valu.equals(olv)) continue;
            updateMap.put((String)se.getKey(), (Object)valu);
            if (updatePassport.getId() == null) {
                updatePassport.setId(id);
            }
            op_des.append(",\u4fee\u6539").append((String)se.getValue()).append("\u4e3a:").append(valu);
        }
        if (updatePassport.getId() != null) {
            java.util.Date now = ServiceUtil.getNow();
            updatePassport.setLast_updated_time(now);
            CarparkUser opuser = WebUtil.getLoginManageUser(request);
            CarparkOperationLog opLog = new CarparkOperationLog();
            opLog.setOp_cat(Constants.LOG_OP_CAT_1);
            opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_1_2);
            opLog.setOp_time(now);
            opLog.setOp_des(ServiceUtil.getString(op_des.toString(), 500));
            opLog.setOp_user_code(opuser.getUser_code());
            opLog.setOp_user_name(opuser.getUser_name());
            opLog.setCarpark_id(carpark_id);
            opLog.setProject_id(project_id);
            try (SqlSession session = commonDaoService.openSqlSession();){
                try {
                    commonDaoService.updateByPrimeryKey(session, (Object)updatePassport);
                    ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
                    commonDaoService.insert(session, (Object)opLog);
                    session.commit();
                }
                catch (Exception ex) {
                    session.rollback();
                    throw ex;
                }
            }
        }
        String car_owner_no = request.getParameter("car_owner_no");
        String car_owner_name = request.getParameter("car_owner_name");
        if (car_owner_no != null && car_owner_no.length() > 0 && car_owner_name != null && car_owner_name.length() > 0) {
            CarparkCarOwnerAction.modifyCarOwner0(request, response, true);
        } else {
            WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
        }
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u4fee\u6539\u8f66\u724c\u53f7\u7801")
    @Path(value="/updatePassportPlateNumber.action")
    public void updatePassportPlateNumber(HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u4fee\u6539\u8f66\u724c/\u5361\u7c7b\u578b")
    @Path(value="/updatePassportPlateType.action")
    public void updatePassportPlateType(HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u4fee\u6539\u8f66\u8f86\u7c7b\u578b")
    @Path(value="/updatePassportPlateCarType.action")
    public void updatePassportPlateCarType(HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u52a0\u5165/\u89e3\u9664\u9ed1\u540d\u5355")
    @Path(value="/updatePassportPlateBlackList.action")
    public void updatePassportPlateBlackList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String _id = request.getParameter("id");
        if (_id == null || _id.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11id", response);
            return;
        }
        Long id = null;
        try {
            id = Long.valueOf(_id);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u65e0\u6548id", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPassport oldPassport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkPassport.class);
        if (oldPassport == null) {
            WebUtil.printFinshJson(1, "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", response);
            return;
        }
        String xp = request.getParameter("xp");
        if (xp == null || xp.length() == 0) {
            WebUtil.printFinshJson(1, "\u672a\u77e5\u64cd\u4f5c\u7c7b\u578b", response);
            return;
        }
        int statex = Integer.parseInt(xp);
        int passportState = 0;
        if (statex == 1) {
            if (oldPassport.getPassport_state() == 1) {
                WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
                return;
            }
            passportState = 1;
        } else if (oldPassport.getPassport_state() != 1) {
            WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
            return;
        }
        java.util.Date now = ServiceUtil.getNow();
        CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkPassport.class));
        updateP.addEQ("id", (Object)id);
        updateP.addUpdate("passport_state", (Object)passportState);
        updateP.addUpdate("last_updated_time", (Object)now);
        StringBuilder op_des = new StringBuilder(128);
        if (oldPassport.getMedium_type() == 6) {
            op_des.append("\u8f66\u724c:").append(oldPassport.getPassport_number());
        } else {
            op_des.append("\u5361\u53f7:").append(oldPassport.getPassport_number());
        }
        if (statex == 1) {
            op_des.append("\u88ab\u52a0\u5165\u9ed1\u540d\u5355");
        } else {
            op_des.append("\u89e3\u9664\u9ed1\u540d\u5355\u72b6\u6001");
        }
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CarparkUser opuser = WebUtil.getLoginManageUser(request);
        CarparkOperationLog opLog = new CarparkOperationLog();
        opLog.setOp_cat(Constants.LOG_OP_CAT_1);
        opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_1_3);
        opLog.setOp_time(now);
        opLog.setOp_des(ServiceUtil.getString(op_des.toString(), 500));
        opLog.setOp_user_code(opuser.getUser_code());
        opLog.setOp_user_name(opuser.getUser_name());
        opLog.setCarpark_id(carpark_id);
        opLog.setProject_id(project_id);
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                commonDaoService.update(session, updateP);
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
                commonDaoService.insert(session, (Object)opLog);
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u505c\u7528/\u542f\u7528\u8f66\u724c/\u5361")
    @Path(value="/updatePassportPlateStop.action")
    public void updatePassportPlateStop(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String _id = request.getParameter("id");
        if (_id == null || _id.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11id", response);
            return;
        }
        Long id = null;
        try {
            id = Long.valueOf(_id);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u65e0\u6548id", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CarparkPassport oldPassport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkPassport.class);
        if (oldPassport == null) {
            WebUtil.printFinshJson(1, "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", response);
            return;
        }
        Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        CarparkPassportType oldPassportType = passportTypeMap.get(oldPassport.getPassport_type_no());
        if (oldPassportType == null) {
            WebUtil.printFinshJson(1, "\u65e0\u6548\u7684\u8f66\u724c/\u5361\u7c7b\u578b", response);
            return;
        }
        boolean isStop = Constants.YES_STR.equals(request.getParameter("xp"));
        String opx = request.getParameter("opx");
        if (Constants.YES_STR.equals(opx)) {
            CarparkPresenceRecord record = (CarparkPresenceRecord)commonDaoService.selectOne(new SearchParam().setQueryFields(new String[]{"enter_time"}).addEQ("passport_number", (Object)oldPassport.getPassport_number()).addEQ("medium_type", (Object)oldPassport.getMedium_type()).addEQ("area_level", (Object)1).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkPresenceRecord.class);
            java.util.Date enter_time = null;
            if (record != null && record.getEnter_time() != null) {
                enter_time = record.getEnter_time();
            }
            HashMap<String, String> returnMap = new HashMap<String, String>();
            if (enter_time != null) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                returnMap.put("enter_time", df.format(enter_time));
            } else {
                returnMap.put("enter_time", "");
            }
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            returnMap.put("passportTypeName", oldPassportType.getPassport_type_name());
            if (isStop) {
                java.util.Date startStopDate;
                returnMap.put("stop", Constants.YES_STR);
                Calendar cl = Calendar.getInstance();
                java.util.Date now = cl.getTime();
                if (oldPassportType.getPass_type() == 2) {
                    if (oldPassport.getDeadline() != null) {
                        returnMap.put("deadline", df1.format(oldPassport.getDeadline()));
                        if (oldPassport.getDeadline().before(now)) {
                            returnMap.put("expire", Constants.YES_STR);
                        }
                    }
                } else if (oldPassportType.getPass_type() == 1 && oldPassport.getBalance() != null) {
                    returnMap.put("balance", oldPassport.getBalance().toString());
                }
                if (returnMap.get("balance") == null) {
                    returnMap.put("balance", "");
                }
                if (returnMap.get("deadline") == null) {
                    returnMap.put("deadline", "");
                }
                if (returnMap.get("expire") == null) {
                    returnMap.put("expire", Constants.NO_STR);
                }
                returnMap.put("minStopDate", df1.format(now));
                if (enter_time == null || Constants.YES_STR.equals(returnMap.get("expire"))) {
                    startStopDate = now;
                } else {
                    cl.add(5, 1);
                    startStopDate = cl.getTime();
                }
                returnMap.put("startStopDate", df1.format(startStopDate));
                WebUtil.printFinshJson(0, "", returnMap, response);
                return;
            }
            returnMap.put("stop", Constants.NO_STR);
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            java.util.Date today = cl.getTime();
            if (oldPassport.getPassport_state() == 2) {
                java.util.Date startDate = today;
                java.util.Date stop_date = null;
                if (oldPassport.getStop_date() != null) {
                    returnMap.put("stop_date", df1.format(oldPassport.getStop_date()));
                    cl.setTime(oldPassport.getStop_date());
                    cl.set(14, 0);
                    cl.set(13, 0);
                    cl.set(12, 0);
                    cl.set(11, 0);
                    stop_date = cl.getTime();
                    long stop_date_mills = stop_date.getTime();
                    long today_mills = today.getTime();
                    if (today_mills > stop_date_mills && enter_time != null) {
                        cl.setTime(enter_time);
                        cl.set(14, 0);
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        long enter_time_mills = cl.getTimeInMillis();
                        if (enter_time_mills <= today_mills) {
                            startDate = enter_time_mills > stop_date_mills ? cl.getTime() : stop_date;
                        }
                    }
                }
                returnMap.put("start_date", df1.format(startDate));
                if (oldPassportType.getPass_type() == 2) {
                    java.util.Date deadLine = null;
                    if (oldPassport.getDeadline() != null) {
                        deadLine = oldPassport.getDeadline();
                    } else if (oldPassport.getValid_date() != null) {
                        deadLine = oldPassport.getValid_date();
                    }
                    if (deadLine != null) {
                        returnMap.put("deadline", df1.format(deadLine));
                        if (stop_date != null && startDate.getTime() > stop_date.getTime()) {
                            if (deadLine.getTime() < stop_date.getTime()) {
                                returnMap.put("afterDeadline", df1.format(deadLine));
                            } else {
                                cl.setTime(deadLine);
                                cl.set(14, 0);
                                cl.set(13, 0);
                                cl.set(12, 0);
                                cl.set(11, 0);
                                int rdays = (int)TimeUnit.MILLISECONDS.toDays(cl.getTimeInMillis() - stop_date.getTime());
                                if (rdays > 0) {
                                    cl.setTime(startDate);
                                    cl.add(5, rdays);
                                    returnMap.put("afterDeadline", df1.format(cl.getTime()));
                                } else {
                                    returnMap.put("afterDeadline", df1.format(deadLine));
                                }
                            }
                        } else {
                            returnMap.put("afterDeadline", df1.format(deadLine));
                        }
                    }
                } else if (oldPassportType.getPass_type() == 1 && oldPassport.getBalance() != null) {
                    returnMap.put("balance", oldPassport.getBalance().toString());
                }
                WebUtil.printFinshJson(0, "", returnMap, response);
                return;
            }
            if (oldPassport.getPassport_state() == 0 && oldPassport.getStart_date() != null && oldPassport.getStart_date().after(today) && oldPassportType.getPass_type() == 2) {
                java.util.Date start_date;
                returnMap.put("start_date1", df1.format(oldPassport.getStart_date()));
                java.util.Date deadLine = oldPassport.getDeadline();
                if (enter_time != null && enter_time.before(today)) {
                    cl.setTime(enter_time);
                    cl.set(14, 0);
                    cl.set(13, 0);
                    cl.set(12, 0);
                    cl.set(11, 0);
                    start_date = cl.getTime();
                } else {
                    start_date = today;
                }
                returnMap.put("start_date", df1.format(start_date));
                if (deadLine != null) {
                    returnMap.put("deadline1", df1.format(deadLine));
                    cl.setTime(oldPassport.getStart_date());
                    cl.set(14, 0);
                    cl.set(13, 0);
                    cl.set(12, 0);
                    cl.set(11, 0);
                    int days = (int)TimeUnit.MILLISECONDS.toDays(cl.getTimeInMillis() - start_date.getTime());
                    cl.setTime(deadLine);
                    if (days > 0) {
                        cl.add(5, 0 - days);
                    }
                    returnMap.put("afterDeadline", df1.format(cl.getTime()));
                }
                WebUtil.printFinshJson(0, "", returnMap, response);
                return;
            }
            WebUtil.printFinshJson(1, "\u72b6\u6001\u9519\u8bef", response);
            return;
        }
        if (isStop) {
            if (oldPassport.getPassport_state() == 2) {
                WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
                return;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            java.util.Date stop_date = null;
            String _stop_date = request.getParameter("stop_date");
            if (_stop_date != null && _stop_date.length() > 0) {
                try {
                    stop_date = df.parse(_stop_date.trim());
                }
                catch (Exception df1) {
                    // empty catch block
                }
            }
            java.util.Date now = ServiceUtil.getNow();
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            java.util.Date today = cl.getTime();
            if (stop_date == null || stop_date.before(today)) {
                stop_date = today;
            }
            CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkPassport.class));
            updateP.addEQ("id", (Object)id);
            updateP.addUpdate("passport_state", (Object)2);
            updateP.addUpdate("stop_date", (Object)stop_date);
            if (oldPassport.getDeadline() != null) {
                updateP.addUpdate("valid_date", (Object)oldPassport.getDeadline());
            }
            updateP.addUpdate("last_updated_time", (Object)now);
            StringBuilder op_des = new StringBuilder(128);
            if (oldPassport.getMedium_type() == 6) {
                op_des.append("\u8f66\u724c:").append(oldPassport.getPassport_number());
            } else {
                op_des.append("\u5361\u53f7:").append(oldPassport.getPassport_number());
                op_des.append(",\u8f66\u724c:").append(oldPassport.getRegister_plate());
            }
            op_des.append(",\u7c7b\u578b:").append(oldPassportType.getPassport_type_name());
            op_des.append(",\u5df2\u529e\u7406\u505c\u7528\u4e1a\u52a1,\u505c\u7528\u53d7\u7406\u65e5\u671f:").append(df.format(stop_date));
            if (oldPassportType.getPass_type() == 2) {
                if (oldPassport.getDeadline() != null) {
                    op_des.append(",\u505c\u7528\u65f6\u6709\u6548\u671f:").append(df.format(oldPassport.getDeadline()));
                }
            } else if (oldPassportType.getPass_type() == 1 && oldPassport.getBalance() != null) {
                op_des.append(",\u529e\u7406\u505c\u7528\u65f6\u4f59\u989d:").append(oldPassport.getBalance().toString());
            }
            CarparkUser opuser = WebUtil.getLoginManageUser(request);
            CarparkOperationLog opLog = new CarparkOperationLog();
            opLog.setOp_cat(Constants.LOG_OP_CAT_1);
            opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_1_5);
            opLog.setOp_time(now);
            opLog.setOp_des(ServiceUtil.getString(op_des.toString(), 500));
            opLog.setOp_user_code(opuser.getUser_code());
            opLog.setOp_user_name(opuser.getUser_name());
            opLog.setCarpark_id(carpark_id);
            opLog.setProject_id(project_id);
            try (SqlSession session = commonDaoService.openSqlSession();){
                try {
                    commonDaoService.update(session, updateP);
                    ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
                    commonDaoService.insert(session, (Object)opLog);
                    session.commit();
                }
                catch (Exception ex) {
                    session.rollback();
                    throw ex;
                }
            }
            WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
            return;
        }
        String newStartDate = request.getParameter("newStartDate");
        String newDeadLine = request.getParameter("newDeadLine");
        if (newStartDate == null || newStartDate.length() == 0) {
            WebUtil.printFinshJson(0, "\u7f3a\u5c11\u53c2\u6570", response);
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        java.util.Date now = ServiceUtil.getNow();
        CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkPassport.class));
        updateP.addEQ("id", (Object)id);
        if (oldPassport.getPassport_state() != 0) {
            updateP.addUpdate("passport_state", (Object)0);
        }
        updateP.addUpdate("stop_date = NULL");
        updateP.addUpdate("start_date", (Object)df1.parse(String.valueOf(newStartDate) + " 00:00:00"));
        if (newDeadLine != null && newDeadLine.length() > 0) {
            updateP.addUpdate("deadline", (Object)df1.parse(String.valueOf(newDeadLine) + " 23:59:59"));
        }
        updateP.addUpdate("last_updated_time", (Object)now);
        StringBuilder op_des = new StringBuilder(128);
        if (oldPassport.getMedium_type() == 6) {
            op_des.append("\u8f66\u724c:").append(oldPassport.getPassport_number());
        } else {
            op_des.append("\u5361\u53f7:").append(oldPassport.getPassport_number());
            op_des.append(",\u8f66\u724c:").append(oldPassport.getRegister_plate());
        }
        op_des.append(",\u7c7b\u578b:").append(oldPassportType.getPassport_type_name());
        op_des.append(",\u542f\u7528\u65e5\u671f:").append(newStartDate);
        if (newDeadLine != null && newDeadLine.length() > 0) {
            op_des.append(",\u542f\u7528\u540e\u6709\u6548\u671f:").append(newDeadLine);
        }
        if (oldPassport.getPassport_state() == 0) {
            if (oldPassport.getStart_date() != null) {
                op_des.append(",\u539f\u542f\u7528\u65e5\u671f:").append(df.format(oldPassport.getStart_date()));
            }
            if (oldPassportType.getPass_type() == 2 && oldPassport.getDeadline() != null) {
                op_des.append(",\u539f\u6709\u6548\u671f:").append(df.format(oldPassport.getDeadline()));
            }
        } else if (oldPassport.getPassport_state() == 2) {
            if (oldPassport.getStop_date() != null) {
                op_des.append(",\u505c\u7528\u65e5\u671f:").append(df.format(oldPassport.getStop_date()));
            }
            if (oldPassportType.getPass_type() == 2 && oldPassport.getDeadline() != null) {
                op_des.append(",\u505c\u7528\u65f6\u6709\u6548\u671f:").append(df.format(oldPassport.getDeadline()));
            }
        }
        CarparkUser opuser = WebUtil.getLoginManageUser(request);
        CarparkOperationLog opLog = new CarparkOperationLog();
        opLog.setOp_cat(Constants.LOG_OP_CAT_1);
        opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_1_5);
        opLog.setOp_time(now);
        opLog.setOp_des(ServiceUtil.getString(op_des.toString(), 500));
        opLog.setOp_user_code(opuser.getUser_code());
        opLog.setOp_user_name(opuser.getUser_name());
        opLog.setCarpark_id(carpark_id);
        opLog.setProject_id(project_id);
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                commonDaoService.update(session, updateP);
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
                commonDaoService.insert(session, (Object)opLog);
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u4fee\u6539\u6709\u6548\u671f")
    @Path(value="/updatePassportPlateValidDate.action")
    public void updatePassportPlateValidDate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String _id = request.getParameter("id");
        if (_id == null || _id.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11id", response);
            return;
        }
        Long id = null;
        try {
            id = Long.valueOf(_id);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u65e0\u6548id", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPassport oldPassport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkPassport.class);
        if (oldPassport == null) {
            WebUtil.printFinshJson(1, "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", response);
            return;
        }
        String newdeadline = request.getParameter("newdeadline");
        if (newdeadline == null || newdeadline.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u53c2\u6570", response);
            return;
        }
        java.util.Date new_deadline = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(String.valueOf(newdeadline) + " 23:59:59");
        java.util.Date now = ServiceUtil.getNow();
        CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkPassport.class));
        updateP.addEQ("id", (Object)id);
        updateP.addUpdate("deadline", (Object)new_deadline);
        updateP.addUpdate("last_updated_time", (Object)now);
        StringBuilder op_des = new StringBuilder(128);
        if (oldPassport.getMedium_type() == 6) {
            op_des.append("\u8f66\u724c:").append(oldPassport.getPassport_number());
        } else {
            op_des.append("\u5361\u53f7:").append(oldPassport.getPassport_number());
            if (oldPassport.getRegister_plate() != null) {
                op_des.append(",\u8f66\u724c:").append(oldPassport.getRegister_plate());
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        op_des.append(",\u539f\u6709\u6548\u671f\u4e3a:");
        if (oldPassport.getDeadline() == null) {
            op_des.append("\u672a\u77e5");
        } else {
            op_des.append(df.format(oldPassport.getDeadline()));
        }
        op_des.append(",\u53d8\u66f4\u4e3a:").append(newdeadline);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CarparkUser opuser = WebUtil.getLoginManageUser(request);
        CarparkOperationLog opLog = new CarparkOperationLog();
        opLog.setOp_cat(Constants.LOG_OP_CAT_1);
        opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_1_6);
        opLog.setOp_time(now);
        opLog.setOp_des(ServiceUtil.getString(op_des.toString(), 500));
        opLog.setOp_user_code(opuser.getUser_code());
        opLog.setOp_user_name(opuser.getUser_name());
        opLog.setCarpark_id(carpark_id);
        opLog.setProject_id(project_id);
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                commonDaoService.update(session, updateP);
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
                commonDaoService.insert(session, (Object)opLog);
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u7981\u6b62/\u89e3\u9664\u5728\u7ebf\u5145\u503c")
    @Path(value="/updatePassportFobitOnlinePay.action")
    public void updatePassportFobitOnlinePay(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String _id = request.getParameter("id");
        if (_id == null || _id.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11id", response);
            return;
        }
        Long id = null;
        try {
            id = Long.valueOf(_id);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u65e0\u6548id", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPassport oldPassport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkPassport.class);
        if (oldPassport == null) {
            WebUtil.printFinshJson(1, "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", response);
            return;
        }
        String _xp = request.getParameter("xp");
        if (_xp == null || _xp.length() == 0) {
            WebUtil.printFinshJson(1, "\u672a\u77e5\u64cd\u4f5c\u7c7b\u578b", response);
            return;
        }
        if (oldPassport.getForbid_online_pay() == null) {
            oldPassport.setForbid_online_pay(0);
        }
        int forbid_online_pay = Integer.parseInt(_xp);
        if (oldPassport.getForbid_online_pay() == forbid_online_pay) {
            WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
            return;
        }
        java.util.Date now = ServiceUtil.getNow();
        CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkPassport.class));
        updateP.addEQ("id", (Object)id);
        updateP.addUpdate("forbid_online_pay", (Object)forbid_online_pay);
        updateP.addUpdate("last_updated_time", (Object)now);
        StringBuilder op_des = new StringBuilder(128);
        if (oldPassport.getMedium_type() == 6) {
            op_des.append("\u8f66\u724c:").append(oldPassport.getPassport_number());
        } else {
            op_des.append("\u5361\u53f7:").append(oldPassport.getPassport_number());
        }
        if (forbid_online_pay == 1) {
            op_des.append("\u88ab\u8bbe\u7f6e\u4e3a\u7981\u6b62\u5728\u7ebf\u5145\u503c/\u5ef6\u671f");
        } else {
            op_des.append("\u88ab\u8bbe\u7f6e\u4e3a\u5141\u8bb8\u5728\u7ebf\u5145\u503c/\u5ef6\u671f");
        }
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CarparkUser opuser = WebUtil.getLoginManageUser(request);
        CarparkOperationLog opLog = new CarparkOperationLog();
        opLog.setOp_cat(Constants.LOG_OP_CAT_1);
        opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_1_4);
        opLog.setOp_time(now);
        opLog.setOp_des(ServiceUtil.getString(op_des.toString(), 500));
        opLog.setOp_user_code(opuser.getUser_code());
        opLog.setOp_user_name(opuser.getUser_name());
        opLog.setCarpark_id(carpark_id);
        opLog.setProject_id(project_id);
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                commonDaoService.update(session, updateP);
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
                commonDaoService.insert(session, (Object)opLog);
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u6ce8\u9500\u8f66\u724c/\u5361")
    @Path(value="/delCarparkPassport.action")
    public void delCarparkPassport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ApplicationService appService;
        String balance;
        String remainDays;
        String _id = request.getParameter("id");
        if (_id == null || _id.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11id", response);
            return;
        }
        Long id = null;
        try {
            id = Long.valueOf(_id);
        }
        catch (Exception ex) {
            WebUtil.printFinshJson(1, "\u65e0\u6548id", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkPassport passport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkPassport.class);
        if (passport == null) {
            WebUtil.printFinshJson(1, "\u8f66\u724c\u5df2\u88ab\u6ce8\u9500\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c", response);
            return;
        }
        String remoney = request.getParameter("refoundmoney");
        BigDecimal refoundMoney = null;
        if (remoney != null && remoney.length() > 0) {
            refoundMoney = new BigDecimal(remoney);
        }
        if (refoundMoney != null && refoundMoney.doubleValue() < 0.0) {
            WebUtil.printFinshJson(1, String.valueOf(passport.getRegister_plate()) + "\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", response);
            return;
        }
        Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
        CarparkPassportType passportType1 = passportTypeMap.get(passport.getPassport_type_no());
        Map<String, CarparkCarType> carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap();
        CarparkCarType carType = carTypeMap.get(passport.getCar_type_no());
        java.util.Date now = ServiceUtil.getNow();
        CommonParam delP = new CommonParam(commonDaoService.getTableName(CarparkPassport.class));
        delP.addEQ("id", (Object)id);
        StringBuilder op_des = new StringBuilder(128);
        if (passport.getMedium_type() == 6) {
            op_des.append("\u8f66\u724c:").append(passport.getPassport_number());
        } else {
            op_des.append("\u5361\u53f7:").append(passport.getPassport_number());
            if (passport.getRegister_plate() != null && passport.getRegister_plate().length() > 0) {
                op_des.append(",\u7ed1\u5b9a\u8f66\u724c:").append(passport.getRegister_plate());
            }
        }
        if (passportType1 != null) {
            op_des.append("\u7c7b\u578b:").append(passportType1.getPassport_type_name());
        }
        if (carType != null) {
            op_des.append("\u8f66\u578b:").append(carType.getCar_type_name());
        }
        op_des.append(",\u5df2\u88ab\u6210\u529f\u6ce8\u9500\uff01");
        if (refoundMoney != null) {
            op_des.append("\u9000\u6b3e\u91d1\u989d:").append(refoundMoney);
        }
        if ((remainDays = request.getParameter("remainDays")) != null && remainDays.length() > 0) {
            op_des.append(",\u6ce8\u9500\u65f6\u5269\u4f59\u5929\u6570:").append(remainDays);
        }
        if ((balance = request.getParameter("balance")) != null && balance.length() > 0) {
            op_des.append(",\u6ce8\u9500\u65f6\u8f66\u8f86\u8d26\u6237\u4f59\u989d:").append(balance);
        }
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CarparkUser opuser = WebUtil.getLoginManageUser(request);
        CarparkOperationLog opLog = new CarparkOperationLog();
        opLog.setOp_cat(Constants.LOG_OP_CAT_1);
        opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_1_7);
        opLog.setOp_time(now);
        opLog.setOp_des(ServiceUtil.getString(op_des.toString(), 500));
        opLog.setOp_user_code(opuser.getUser_code());
        opLog.setOp_user_name(opuser.getUser_name());
        opLog.setCarpark_id(carpark_id);
        opLog.setProject_id(project_id);
        CarparkTransaction trans = null;
        if (refoundMoney != null && refoundMoney.doubleValue() > 0.0) {
            CarparkCarOwner owner;
            if (passportType1 == null) {
                WebUtil.printFinshJson(1, "\u672a\u77e5\u8f66\u724c/\u5361\u7c7b\u578b\uff0c\u65e0\u6cd5\u9000\u8d39", response);
                return;
            }
            trans = new CarparkTransaction();
            if (passportType1.getPass_type() == 1) {
                trans.setService_type(7);
                trans.setTran_des("\u50a8\u503c\u5361\u6ce8\u9500\u9000\u8d39\uff0c\u6ce8\u9500\u65f6\u4f59\u989d:" + balance);
                trans.setBalance_before(Constants.MONEY_ZERO);
            } else if (passportType1.getPass_type() == 2) {
                trans.setService_type(4);
                trans.setTran_des("\u6708\u5361\u6ce8\u9500\u9000\u8d39\uff0c\u6ce8\u9500\u65f6\u5269\u4f59\u5929\u6570:" + remainDays);
            } else {
                WebUtil.printFinshJson(1, "\u672a\u77e5\u9000\u8d39\u7c7b\u578b\uff0c\u65e0\u6cd5\u9000\u8d39", response);
                return;
            }
            trans.setTran_type(0);
            trans.setPlate_number(passport.getRegister_plate());
            trans.setPassport_no(passport.getPassport_no());
            trans.setPassport_number(passport.getPassport_number());
            trans.setMedium_type(passport.getMedium_type());
            trans.setPass_type(passportType1.getPass_type());
            trans.setPassport_type_no(passportType1.getPassport_type_no());
            trans.setPassport_type_name(passportType1.getPassport_type_name());
            trans.setCar_type_no(passport.getCar_type_no());
            if (carType != null) {
                trans.setCar_type_name(carType.getCar_type_name());
            }
            trans.setTran_money(refoundMoney.negate());
            trans.setTran_time(now);
            trans.setPay_method(0);
            trans.setPay_scene(1);
            trans.setCharge_org(0);
            trans.setPay_entry(1);
            trans.setTran_channel_no(null);
            trans.setTran_channel_name(null);
            trans.setEnter_record_no(null);
            trans.setEnter_time(null);
            trans.setOperate_user_code(opuser.getUser_code());
            trans.setOperate_user_name(opuser.getUser_name());
            trans.setShould_charge(null);
            trans.setDiscount_money(null);
            trans.setHost_no(WebUtil.getOpHostNo(request));
            CarparkHost host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(trans.getHost_no());
            trans.setHost_name(host == null ? null : host.getHost_name());
            trans.setDuty_no(WebUtil.getOpDutyNo(request));
            trans.setCreated_time(now);
            trans.setCarpark_id(carpark_id);
            trans.setProject_id(project_id);
            trans.setTran_user_no(passport.getCar_owner_no());
            if (passport.getCar_owner_no() != null && passport.getCar_owner_no().length() > 0 && (owner = (CarparkCarOwner)commonDaoService.selectOne(new SearchParam().setQueryFields(new String[]{"car_owner_no", "car_owner_name"}).addEQ("car_owner_no", (Object)passport.getCar_owner_no()).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkCarOwner.class)) != null) {
                trans.setTran_user_name(owner.getCar_owner_name());
            }
        }
        LinkedList<CarparkDispatchTask> taskList = null;
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                commonDaoService.delete(session, (SearchParam)delP);
                appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
                commonDaoService.insert(session, (Object)opLog);
                if (trans != null) {
                    List<CarparkDispatchTask> tlist;
                    trans.setId(appService.createLocalRecordSeq("ck_carpark_transaction_seq"));
                    trans.setTansaction_no("C" + trans.getId());
                    trans.setOrder_no(null);
                    commonDaoService.insert(session, (Object)trans);
                    if (!ServiceUtil.getServiceContext().getLocalHostNo().equals(trans.getHost_no()) && (tlist = DispatchDataTaskUtil.createDispatchRecordByIdTaskList(commonDaoService.getTableName(CarparkTransaction.class), trans.getId(), trans.getHost_no())) != null && !tlist.isEmpty()) {
                        if (taskList == null) {
                            taskList = new LinkedList<CarparkDispatchTask>();
                        }
                        for (CarparkDispatchTask t : tlist) {
                            commonDaoService.insert(session, (Object)t);
                            taskList.add(t);
                        }
                    }
                }
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
        if (taskList != null && !taskList.isEmpty()) {
            appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            appService.asynTryRunDispatchTask((Collection<CarparkDispatchTask>)taskList);
        }
    }

    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u5bfc\u51fa\u8f66\u724c\u5217\u8868")
    @Path(value="/exportCarparkPassport.action")
    public void exportCarparkPassport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        response.setContentType("application/vnd.ms-excel");
        SimpleDateFormat df1 = new SimpleDateFormat("yyyyMMddHHmmss");
        response.addHeader("Content-Disposition", "attachment;filename=carplate_" + df1.format(new java.util.Date()) + ".xls");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        try (ServletOutputStream out = response.getOutputStream();){
            applicationService.exportPlateClientExcel((OutputStream)out);
        }
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u5bfc\u5165\u8f66\u724c\u5217\u8868")
    @Path(value="/importCarparkPassport.action")
    public void importCarparkPassport(HttpServletRequest request, HttpServletResponse response) throws Exception {
        DiskFileItemFactory f = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)f);
        upload.setSizeMax(0x2800000L);
        List fileItemList = upload.parseRequest(request);
        boolean have = false;
        for (Object obj : fileItemList) {
            FileItem fileItem = (FileItem)obj;
            if (fileItem.isFormField()) continue;
            have = true;
            InputStream in = fileItem.getInputStream();
            try {
                try {
                    ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    CarparkUser user = WebUtil.getLoginManageUser(request);
                    String x1 = applicationService.importPlateFromExcel(fileItem.getName(), in, user.getUser_code(), user.getUser_name());
                    request.setAttribute("successMsg", (Object)x1);
                }
                catch (Exception ex) {
                    request.setAttribute("errorMsg", (Object)("\u64cd\u4f5c\u5931\u8d25! \u539f\u56e0\uff1a" + ex.getMessage()));
                    in.close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
        }
        if (!have) {
            request.setAttribute("errorMsg", (Object)"\u64cd\u4f5c\u5931\u8d25! \u6ca1\u6709\u5bfc\u5165\u6587\u4ef6!");
        }
        String errorMsg = (String)request.getAttribute("errorMsg");
        String successMsg = (String)request.getAttribute("successMsg");
        String pram = "1=1";
        if (errorMsg != null && errorMsg.length() > 0) {
            pram = String.valueOf(pram) + "&errorMsg=" + URLEncoder.encode(errorMsg, "UTF-8");
        }
        if (successMsg != null && successMsg.length() > 0) {
            pram = String.valueOf(pram) + "&successMsg=" + URLEncoder.encode(successMsg, "UTF-8");
        }
        response.sendRedirect(String.valueOf(request.getContextPath()) + "/manage/showPlateManage.action?" + pram);
    }

    @Path(value="/downloadImportPlateTemplate.action")
    public void downloadImportPlateTemplate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        response.setContentType("application/vnd.ms-excel");
        SimpleDateFormat df1 = new SimpleDateFormat("yyyyMMddHHmmss");
        response.addHeader("Content-Disposition", "attachment;filename=template_" + df1.format(new java.util.Date()) + ".xls");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        try (ServletOutputStream out = response.getOutputStream();){
            applicationService.exportImportTempExcel((OutputStream)out);
        }
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u5220\u9664\u6240\u6709\u8f66\u724c\u4e0e\u8f66\u4e3b")
    @Path(value="/delAllPassportClient.action")
    public void delAllPassportClient(HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                SearchParam sl = new SearchParam(commonDaoService.getTableName(CarparkPassport.class));
                SearchParam sl1 = new SearchParam(commonDaoService.getTableName(CarparkCarOwner.class));
                commonDaoService.delete(session, sl);
                commonDaoService.delete(session, sl1);
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u4e1a\u52a1\u529e\u7406-\u8f66\u8f86/\u8f66\u4e3b\u7ba1\u7406-\u8f66\u8f86\u6ce8\u518c\u4e0e\u7ba1\u7406-\u6279\u91cf\u5ef6\u671f")
    @Path(value="/updateDateBySearchCondition.action")
    public void updateDateBySearchCondition(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if ("goUpdate".equals(op) || "doUpdate".equals(op)) {
            String state = request.getParameter("state");
            if ("2".equals(state)) {
                WebUtil.printFinshJson(1, "\u60a8\u4e0d\u80fd\u7ed9\u5df2\u505c\u7528\u7684\u8f66\u8f86\u8fdb\u884c\u6279\u91cf\u5ef6\u671f\u64cd\u4f5c!", response);
                return;
            }
            if ("-2".equals(state)) {
                WebUtil.printFinshJson(1, "\u60a8\u4e0d\u80fd\u7ed9\u672a\u542f\u7528\u6708\u5361\u7684\u8f66\u8f86\u8fdb\u884c\u6279\u91cf\u5ef6\u671f\u64cd\u4f5c!", response);
                return;
            }
            if ("1".equals(state)) {
                WebUtil.printFinshJson(1, "\u60a8\u4e0d\u80fd\u7ed9\u9ed1\u540d\u5355\u8f66\u8fdb\u884c\u6279\u91cf\u5ef6\u671f\u64cd\u4f5c!", response);
                return;
            }
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            SearchParam sp = this.queryRequestPassportListParam(request, true);
            if (sp != null) {
                sp.addLT("a.start_date", (Object)ServiceUtil.getNow());
                boolean contiansPassportState = false;
                ArrayList eqs = sp.getPropertysEqual();
                if (eqs != null && !eqs.isEmpty()) {
                    String a = "a.passport_state";
                    for (KeyValue ev : eqs) {
                        if (!a.contentEquals((CharSequence)ev.getKey())) continue;
                        contiansPassportState = true;
                        break;
                    }
                }
                if (!contiansPassportState) {
                    sp.addEQ("a.passport_state", (Object)0);
                }
            }
            if ("doUpdate".equals(op)) {
                java.util.Date newDeadLine;
                String updateDeadLine = request.getParameter("updateDeadLine");
                if (updateDeadLine == null || updateDeadLine.length() == 0) {
                    WebUtil.printFinshJson(1, "\u672a\u9009\u62e9\u6709\u6548\u671f!", response);
                    return;
                }
                try {
                    newDeadLine = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(String.valueOf(updateDeadLine) + " 23:59:59");
                }
                catch (Exception ex) {
                    WebUtil.printFinshJson(1, "\u65e5\u671f\u683c\u5f0f\u9519\u8bef!", response);
                    return;
                }
                if (sp == null) {
                    WebUtil.printFinshJson(0, "0 \u8f86\u8f66\u6709\u6548\u671f\u53d8\u66f4\u4e3a\uff1a" + updateDeadLine, response);
                    return;
                }
                BigDecimal everyMoney = null;
                String showMonthBatchMoney = request.getParameter("sbm");
                if ("1".equals(showMonthBatchMoney)) {
                    String evmy = request.getParameter("evmy");
                    if (evmy == null || (evmy = evmy.trim()).length() == 0) {
                        WebUtil.printFinshJson(0, "\u8bf7\u8f93\u5165\u6bcf\u8f86\u8f66\u7684\u7f34\u8d39\u91d1\u989d", response);
                        return;
                    }
                    try {
                        everyMoney = new BigDecimal(evmy).setScale(2, 4);
                    }
                    catch (Exception ex) {
                        WebUtil.printFinshJson(0, "\u6bcf\u8f86\u8f66\u7684\u7f34\u8d39\u91d1\u989d\u5fc5\u987b\u662f\u6570\u5b57", response);
                        return;
                    }
                    if (everyMoney.doubleValue() < 0.0) {
                        WebUtil.printFinshJson(0, "\u6bcf\u8f86\u8f66\u7684\u7f34\u8d39\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", response);
                        return;
                    }
                }
                sp.setQueryFields(new String[]{"a.id"});
                String ov = request.getParameter("ov");
                ArrayList<Long> idLongList = null;
                if ("byIds".equals(ov)) {
                    String ids = request.getParameter("ids");
                    if (ids != null && ids.length() > 0) {
                        String[] ss = ids.split(",");
                        idLongList = new ArrayList();
                        String[] stringArray = ss;
                        int n = ss.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            idLongList.add(Long.valueOf(s));
                            ++n2;
                        }
                    }
                } else {
                    List queryList = commonDaoService.selectList(sp, null);
                    if (queryList != null && !queryList.isEmpty()) {
                        idLongList = new ArrayList<Long>(queryList.size());
                        for (Map obMap : queryList) {
                            idLongList.add((Long)obMap.get("id"));
                        }
                    }
                }
                if (idLongList == null || idLongList.isEmpty()) {
                    WebUtil.printFinshJson(0, "0 \u8f86\u8f66\u6709\u6548\u671f\u53d8\u66f4\u4e3a\uff1a" + updateDeadLine, response);
                    return;
                }
                int updateCount = 0;
                if (everyMoney != null) {
                    java.util.Date now = ServiceUtil.getNow();
                    CarparkUser opuser = WebUtil.getLoginManageUser(request);
                    ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    Calendar cl = Calendar.getInstance();
                    cl.set(14, 0);
                    cl.set(13, 0);
                    cl.set(12, 0);
                    cl.set(11, 0);
                    java.util.Date todayBegin = cl.getTime();
                    cl.add(6, 1);
                    cl.add(13, -1);
                    java.util.Date todayEnd = cl.getTime();
                    for (Long id : idLongList) {
                        CarparkCarOwner owner;
                        CarparkPassport passport = (CarparkPassport)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()), CarparkPassport.class);
                        if (passport == null) continue;
                        CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkPassport.class));
                        updateP.addUpdate("deadline", (Object)newDeadLine);
                        updateP.addUpdate("last_updated_time", (Object)ServiceUtil.getNow());
                        updateP.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                        updateP.addEQ("id", (Object)id);
                        CarparkTransaction trans = new CarparkTransaction();
                        trans.setService_type(3);
                        if (passport.getDeadline() == null) {
                            if (newDeadLine.before(todayEnd)) {
                                cl.setTime(newDeadLine);
                                cl.set(13, 0);
                                cl.set(12, 0);
                                cl.set(11, 0);
                                trans.setStart_date(cl.getTime());
                                trans.setEnd_date(newDeadLine);
                                trans.setTran_quantity(1);
                                trans.setTran_unit(1);
                            } else {
                                trans.setStart_date(todayBegin);
                                trans.setEnd_date(newDeadLine);
                                cl.setTime(newDeadLine);
                                cl.set(13, 0);
                                cl.set(12, 0);
                                cl.set(11, 0);
                                trans.setTran_quantity((int)TimeUnit.MILLISECONDS.toDays(cl.getTimeInMillis() - todayBegin.getTime()) + 1);
                                trans.setTran_unit(1);
                            }
                            trans.setValid_date_before(null);
                        } else {
                            cl.setTime(passport.getDeadline());
                            cl.set(13, 0);
                            cl.set(12, 0);
                            cl.set(11, 0);
                            long l1 = cl.getTimeInMillis();
                            cl.setTime(newDeadLine);
                            cl.set(13, 0);
                            cl.set(12, 0);
                            cl.set(11, 0);
                            long l2 = cl.getTimeInMillis();
                            if (l1 < l2) {
                                if (l2 <= todayBegin.getTime()) {
                                    cl.setTimeInMillis(l1);
                                    cl.add(6, 1);
                                    trans.setStart_date(cl.getTime());
                                    trans.setEnd_date(newDeadLine);
                                } else if ("1".equals(ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeStrategyValue(passport.getPassport_type_no(), "DELAYED_START_TIME"))) {
                                    cl.setTimeInMillis(l1);
                                    cl.add(6, 1);
                                    trans.setStart_date(cl.getTime());
                                    trans.setEnd_date(newDeadLine);
                                } else if (l1 < todayBegin.getTime()) {
                                    trans.setStart_date(todayBegin);
                                    trans.setEnd_date(newDeadLine);
                                } else {
                                    cl.setTimeInMillis(l1);
                                    cl.add(6, 1);
                                    trans.setStart_date(cl.getTime());
                                    trans.setEnd_date(newDeadLine);
                                }
                                trans.setTran_quantity((int)TimeUnit.MILLISECONDS.toDays(l2 - trans.getStart_date().getTime()) + 1);
                                trans.setTran_unit(1);
                            } else if (l1 == l2) {
                                trans.setStart_date(new java.util.Date(l2));
                                trans.setEnd_date(newDeadLine);
                                trans.setTran_quantity(0);
                                trans.setTran_unit(1);
                            } else {
                                trans.setStart_date(new java.util.Date(l1));
                                trans.setEnd_date(newDeadLine);
                                trans.setTran_quantity(0 - ((int)TimeUnit.MILLISECONDS.toDays(l1 - l2) + 1));
                                trans.setTran_unit(1);
                            }
                            trans.setValid_date_before(passport.getDeadline());
                        }
                        trans.setTran_des("\u6279\u91cf\u5ef6\u671f");
                        trans.setTran_type(0);
                        trans.setPlate_number(passport.getRegister_plate());
                        trans.setPassport_no(passport.getPassport_no());
                        trans.setPassport_number(passport.getPassport_number());
                        trans.setMedium_type(passport.getMedium_type());
                        CarparkPassportType passportType = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(passport.getPassport_type_no());
                        trans.setPass_type(passportType == null ? 2 : passportType.getPass_type());
                        trans.setPassport_type_no(passport.getPassport_type_no());
                        trans.setPassport_type_name(passportType == null ? "" : passportType.getPassport_type_name());
                        trans.setCar_type_no(passport.getCar_type_no());
                        CarparkCarType carType = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap().get(passport.getCar_type_no());
                        trans.setCar_type_name(carType == null ? "" : carType.getCar_type_name());
                        trans.setTran_money(everyMoney);
                        trans.setTran_time(now);
                        trans.setPay_method(0);
                        trans.setPay_scene(1);
                        trans.setCharge_org(0);
                        trans.setPay_entry(1);
                        trans.setTran_channel_no(null);
                        trans.setTran_channel_name(null);
                        trans.setEnter_record_no(null);
                        trans.setEnter_time(null);
                        trans.setOperate_user_code(opuser.getUser_code());
                        trans.setOperate_user_name(opuser.getUser_name());
                        trans.setShould_charge(null);
                        trans.setDiscount_money(null);
                        trans.setHost_no(WebUtil.getOpHostNo(request));
                        CarparkHost host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(trans.getHost_no());
                        trans.setHost_name(host == null ? null : host.getHost_name());
                        trans.setDuty_no(WebUtil.getOpDutyNo(request));
                        trans.setCreated_time(now);
                        trans.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
                        trans.setProject_id(ServiceUtil.getServiceContext().getProjectId());
                        trans.setTran_user_no(passport.getCar_owner_no());
                        if (passport.getCar_owner_no() != null && passport.getCar_owner_no().length() > 0 && (owner = (CarparkCarOwner)commonDaoService.selectOne(new SearchParam().setQueryFields(new String[]{"car_owner_no", "car_owner_name"}).addEQ("car_owner_no", (Object)passport.getCar_owner_no()).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()).addEQ("project_id", (Object)ServiceUtil.getServiceContext().getProjectId()), CarparkCarOwner.class)) != null) {
                            trans.setTran_user_name(owner.getCar_owner_name());
                        }
                        trans.setId(appService.createLocalRecordSeq("ck_carpark_transaction_seq"));
                        trans.setTansaction_no("C" + trans.getId());
                        trans.setOrder_no(null);
                        try (SqlSession session = commonDaoService.openSqlSession();){
                            try {
                                int c = commonDaoService.update(updateP);
                                if (c > 0) {
                                    commonDaoService.insert(session, (Object)trans);
                                    updateCount += c;
                                }
                                session.commit();
                            }
                            catch (Exception ex) {
                                session.rollback();
                                throw ex;
                            }
                        }
                    }
                } else {
                    int batchSize = 200;
                    String tableName = commonDaoService.getTableName(CarparkPassport.class);
                    if (idLongList.size() <= batchSize) {
                        ArrayList<Long> idList = idLongList;
                        CommonParam updateP = new CommonParam(tableName);
                        updateP.addUpdate("deadline", (Object)newDeadLine);
                        updateP.addUpdate("last_updated_time", (Object)ServiceUtil.getNow());
                        updateP.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                        if (idList.size() == 1) {
                            updateP.addEQ("id", idList.get(0));
                        } else {
                            updateP.addINList("id", idList);
                        }
                        updateCount += commonDaoService.update(updateP);
                    } else {
                        List list = commonDaoService.getPaginationList(idLongList.size(), batchSize);
                        LinkedList<Long> idList = new LinkedList<Long>();
                        for (KeyValue e : list) {
                            idList.clear();
                            int beginIndex = (Integer)e.getKey();
                            int endIndex = beginIndex + (Integer)e.getValue();
                            int i = beginIndex;
                            while (i < endIndex) {
                                idList.add((Long)idLongList.get(i));
                                ++i;
                            }
                            if (idList.isEmpty()) continue;
                            CommonParam updateP = new CommonParam(tableName);
                            updateP.addUpdate("deadline", (Object)newDeadLine);
                            updateP.addUpdate("last_updated_time", (Object)ServiceUtil.getNow());
                            updateP.addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                            if (idList.size() == 1) {
                                updateP.addEQ("id", idList.get(0));
                            } else {
                                updateP.addINList("id", idList);
                            }
                            updateCount += commonDaoService.update(updateP);
                        }
                    }
                }
                if (updateCount > 0) {
                    Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
                    Integer project_id = ServiceUtil.getServiceContext().getProjectId();
                    CarparkUser opuser = WebUtil.getLoginManageUser(request);
                    CarparkOperationLog opLog = new CarparkOperationLog();
                    opLog.setOp_cat(Constants.LOG_OP_CAT_1);
                    opLog.setOp_type(Constants.LOG_OP_TYPE_CAT_1_6);
                    opLog.setOp_time(ServiceUtil.getNow());
                    opLog.setOp_des(ServiceUtil.getString("\u6279\u91cf\u5ef6\u671f\u64cd\u4f5c\uff1a\u672c\u6b21\u64cd\u4f5c\u6709" + updateCount + " \u8f86\u8f66\u6709\u6548\u671f\u53d8\u66f4\u4e3a\uff1a" + updateDeadLine, 500));
                    opLog.setOp_user_code(opuser.getUser_code());
                    opLog.setOp_user_name(opuser.getUser_name());
                    opLog.setCarpark_id(carpark_id);
                    opLog.setProject_id(project_id);
                    ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    opLog.setId(appService.createLocalRecordSeq("ck_carpark_operation_log_seq"));
                    commonDaoService.insert((Object)opLog);
                }
                WebUtil.printFinshJson(0, String.valueOf(updateCount) + " \u8f86\u8f66\u6709\u6548\u671f\u53d8\u66f4\u4e3a\uff1a" + updateDeadLine, response);
                return;
            }
            if ("goUpdate".equals(op)) {
                Map vm;
                if (sp == null) {
                    WebUtil.printFinshJson(1, "\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6708\u5361\u7c7b\u578b\u8f66\u8f86!", response);
                    return;
                }
                sp.setQueryFields(new String[]{"COUNT(a.id) AS count"});
                sp.setOrder_by(null);
                List queryList = commonDaoService.selectList(sp, null);
                long needUpdateCout = 0L;
                if (queryList != null && !queryList.isEmpty() && (vm = (Map)queryList.get(0)) != null && vm.get("count") != null) {
                    needUpdateCout = (Long)vm.get("count");
                }
                if (needUpdateCout <= 0L) {
                    WebUtil.printFinshJson(1, "\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6708\u5361\u7c7b\u578b\u8f66\u8f86!", response);
                    return;
                }
                WebUtil.printFinshJson(0, String.valueOf(needUpdateCout), response);
                return;
            }
        }
    }
}

