/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action.manage;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.OrderNo;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkAttribute;
import com.wovoe.carpark.dto.CarparkCancelPassRecord;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkDiscountProject;
import com.wovoe.carpark.dto.CarparkDiscountRecord;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkIllegalPassRecord;
import com.wovoe.carpark.dto.CarparkInvoiceOrder;
import com.wovoe.carpark.dto.CarparkMerchant;
import com.wovoe.carpark.dto.CarparkMerchantCouponProj;
import com.wovoe.carpark.dto.CarparkMerchantUser;
import com.wovoe.carpark.dto.CarparkOperationLog;
import com.wovoe.carpark.dto.CarparkPassDiscount;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPassSelfPay;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.dto.CarparkRegplateRecord;
import com.wovoe.carpark.dto.CarparkTransaction;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.gui.SwingUtil;
import com.wovoe.carpark.gui.util.CarparkGuiSkinUtil;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.ExportService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.vo.ChannelEquipmentVo;
import com.wovoe.carpark.vo.ClientHost;
import com.wovoe.carpark.web.LeftMenu;
import com.wovoe.carpark.web.Permission;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.carpark.web.WritePermission;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.JavaBeanUtil;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

@Action(value="/manage")
public class CarparkRecordSearchAction {
    @Path(value="/obtainRecordPic.action")
    public void obtainRecordPic(HttpServletRequest request, HttpServletResponse response) throws Exception {
        BufferedImage image = null;
        try {
            Map map;
            String host;
            ApplicationService apps;
            String picPath = request.getParameter("p");
            if (!(picPath == null || picPath.length() <= 0 || "nopic".equals(picPath) || "nopic".equals(picPath = new String(BytesTool.unCompress((String)picPath), "UTF-8")) || (image = (apps = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class)).loadLocalPic(picPath)) != null || (host = request.getParameter("t")) == null || host.length() <= 0 || (host = new String(BytesTool.unCompress((String)host), "UTF-8")).equals(ServiceUtil.getServiceContext().getLocalHostNo()) || (map = (Map)apps.asynLoadRemotePic(host, picPath).get(5L, TimeUnit.SECONDS)) == null)) {
                image = (BufferedImage)map.get(picPath);
            }
        }
        catch (Exception picPath) {
            // empty catch block
        }
        if (image == null) {
            image = CarparkGuiSkinUtil.getCarparkGuiSkin().newBufferedImage("no_pic");
        }
        String w = request.getParameter("w");
        String h = request.getParameter("h");
        if (w != null && w.length() > 0 && h != null && h.length() > 0) {
            try {
                int width = Integer.parseInt(w);
                int height = Integer.parseInt(h);
                if (width > 0 && height > 0) {
                    image = SwingUtil.resizeImage(image, width, height);
                }
            }
            catch (Exception width) {
                // empty catch block
            }
        }
        response.setContentType("image/jpeg");
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write((RenderedImage)image, "JPEG", (OutputStream)out);
        out.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\u67e5\u8be2")
    @LeftMenu(name="\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\u67e5\u8be2", parent_name="\u8bb0\u5f55\u67e5\u8be2", order=311)
    @Path(value="/queryPresenceRecord.action")
    public void queryPresenceRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            Map<String, CarparkCarType> carTypeMap;
            Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
            if (areaMap != null) {
                request.setAttribute("areaMap", areaMap);
            }
            Map<String, ChannelArea> channalAreaMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas();
            Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
            ArrayList<CarparkChannel> channelList = new ArrayList<CarparkChannel>();
            if (channelMap != null && !channelMap.isEmpty()) {
                for (CarparkChannel ch : channelMap.values()) {
                    ChannelArea cha = channalAreaMap.get(ch.getChannel_no());
                    if (cha == null || cha.getEnterAreas() == null || cha.getEnterAreas().isEmpty()) continue;
                    channelList.add(ch);
                }
            }
            request.setAttribute("channelList", channelList);
            Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            if (passportTypeMap != null) {
                request.setAttribute("passportTypeMap", passportTypeMap);
            }
            if ((carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap()) != null) {
                request.setAttribute("carTypeMap", carTypeMap);
            }
            WebUtil.showMainContentWithHead("\u5728\u573a\u8f66\u8f86\u8bb0\u5f55", "report/presenceRecord", request, response);
            return;
        }
        if ("query".equals(op) || request.getAttribute("export") != null || request.getAttribute("removeByQuery") != null) {
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
            String queryAttr1 = request.getParameter("queryAttr1");
            String queryValue1 = request.getParameter("queryValue1");
            String start_enter_time = request.getParameter("start_enter_time");
            String end_enter_time = request.getParameter("end_enter_time");
            String area_no = request.getParameter("area_no");
            String enter_channel_no = request.getParameter("enter_channel_no");
            String passport_type_no = request.getParameter("passport_type_no");
            String enter_car_type_no = request.getParameter("enter_car_type_no");
            if (queryAttr1 != null && (queryAttr1 = queryAttr1.trim()).length() > 0 && queryValue1 != null && (queryValue1 = queryValue1.trim()).length() > 0) {
                if ("enter_plate".equals(queryAttr1)) {
                    String v2 = queryValue1.toUpperCase();
                    v2 = v2.replaceAll("\u3000", "");
                    v2 = v2.replaceAll(" ", "");
                    if ((v2 = v2.replaceAll("I", "1")).length() > 0) {
                        sp.addLike(queryAttr1, v2);
                    }
                } else {
                    sp.addLike(queryAttr1, queryValue1);
                }
            }
            if (start_enter_time != null && start_enter_time.length() > 0) {
                sp.addGTE("enter_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(start_enter_time));
            }
            if (end_enter_time != null && end_enter_time.length() > 0) {
                sp.addLTE("enter_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(end_enter_time));
            }
            if (area_no != null && (area_no = area_no.trim()).length() > 0) {
                sp.addEQ("area_no", (Object)area_no);
            }
            if (enter_channel_no != null && (enter_channel_no = enter_channel_no.trim()).length() > 0) {
                sp.addEQ("enter_channel_no", (Object)enter_channel_no);
            }
            if (passport_type_no != null && (passport_type_no = passport_type_no.trim()).length() > 0) {
                sp.addEQ("passport_type_no", (Object)passport_type_no);
            }
            if (enter_car_type_no != null && (enter_car_type_no = enter_car_type_no.trim()).length() > 0) {
                sp.addEQ("enter_car_type_no", (Object)enter_car_type_no);
            }
            if ("query".equals(op)) {
                String sortOrder = request.getParameter("sortOrder");
                String sortName = request.getParameter("sortName");
                if (sortName != null && (sortName = sortName.trim()).length() > 0 && sortOrder != null && (sortOrder = sortOrder.trim()).length() > 0) {
                    sp.setOrder_by((String.valueOf(sortName) + " " + sortOrder).replaceAll("'", ""));
                } else {
                    sp.setOrder_by("enter_time desc");
                }
                Pagination p = WebUtil.getPagination(request);
                List dataList = commonDaoService.selectList(sp, p);
                ArrayList<Map> resultList = new ArrayList<Map>(dataList == null ? 0 : dataList.size());
                if (dataList != null && !dataList.isEmpty()) {
                    long currentMills = System.currentTimeMillis();
                    ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    for (Map data : dataList) {
                        String v;
                        String enter_plate_pic = (String)data.get("enter_plate_pic");
                        String hostNo = (String)data.get("enter_host_no");
                        data.put("enter_plate_pic", CarparkRecordSearchAction.getPicUri(request.getContextPath(), enter_plate_pic, hostNo, true));
                        String enter_car_pic = (String)data.get("enter_car_pic");
                        data.put("enter_car_pic", CarparkRecordSearchAction.getPicUri(request.getContextPath(), enter_car_pic, hostNo, true));
                        if (enter_car_pic != null && enter_car_pic.length() > 0 && enter_plate_pic != null && enter_plate_pic.length() > 0) {
                            data.put("enter_plate_pic0", CarparkRecordSearchAction.getPicUri(request.getContextPath(), enter_plate_pic, hostNo, false));
                        }
                        String car_owner_name = ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("car_owner_name", (String)data.get("car_owner_name"), request);
                        String car_owner_addr = ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("address", (String)data.get("car_owner_addr"), request);
                        if (car_owner_name != null && car_owner_name.length() > 0) {
                            data.put("car_owner_name", car_owner_name);
                        }
                        if (car_owner_addr != null && car_owner_addr.length() > 0) {
                            data.put("car_owner_addr", car_owner_addr);
                        }
                        if ((v = (String)data.get("enter_plate")) == null) {
                            data.put("enter_plate", "");
                        }
                        Integer enter_plate_source = (Integer)data.get("enter_plate_source");
                        String v1 = null;
                        if (enter_plate_source != null && v != null && v.length() > 0) {
                            if (enter_plate_source == 0) {
                                v1 = "\u8f66\u724c\u8bc6\u522b";
                            } else if (enter_plate_source == 1) {
                                v1 = "\u4eba\u5de5\u653e\u884c";
                            } else if (enter_plate_source == 2) {
                                v1 = "\u4eba\u5de5\u4fee\u6539\u8f66\u724c";
                            } else if (enter_plate_source == 3) {
                                v1 = "ETC\u653e\u884c";
                            } else if (enter_plate_source == 4) {
                                v1 = "\u6a21\u7cca\u5339\u914d";
                            } else if (enter_plate_source == 5) {
                                v1 = "\u8f66\u4e3b\u626b\u7801";
                            }
                        }
                        if (v1 == null) {
                            v1 = "";
                        }
                        data.put("pass_desx", v1);
                        Date enter_time = (Date)data.get("enter_time");
                        long parkingTimeLen = currentMills - enter_time.getTime();
                        if (parkingTimeLen < 0L) {
                            parkingTimeLen = 0L;
                        }
                        long parkingTimeLenSec = parkingTimeLen / 1000L;
                        parkingTimeLen = ServiceUtil.getMins(parkingTimeLenSec);
                        data.put("parkingTimeLen", String.valueOf(parkingTimeLen));
                        data.put("parkingTimeDes", appService.getTimeLenSecDes((int)parkingTimeLenSec));
                        resultList.add(JavaBeanUtil.toStringMap((Object)data));
                    }
                }
                HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
                resMap.put("rows", resultList);
                resMap.put("total", Long.valueOf(p.getRecordsCount()));
                WebUtil.printFinshJson(response, GsonBuilder.create().toJson(resMap));
                return;
            }
            if (request.getAttribute("removeByQuery") != null) {
                String userName;
                String userCode;
                Date opTime = WebUtil.getNow();
                ClientHost clientHost = WebUtil.getLoginClientHost(request);
                if (clientHost != null) {
                    userCode = clientHost.getUserCode();
                    userName = clientHost.getUserName();
                } else {
                    CarparkUser user = WebUtil.getLoginManageUser(request);
                    userCode = user.getUser_code();
                    userName = user.getUser_name();
                }
                if ("1".equals(request.getAttribute("removeByQuery"))) {
                    long count = commonDaoService.selectCount(sp);
                    WebUtil.printFinshJson(0, String.valueOf(count), response);
                    return;
                } else {
                    sp.setQueryFields(new String[]{"id"});
                    sp.setOrder_by("id");
                    List dataList = commonDaoService.selectList(sp, null);
                    RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                    if (dataList != null && !dataList.isEmpty()) {
                        for (Map obj : dataList) {
                            Long id = (Long)obj.get("id");
                            if (id == null) continue;
                            recordSaveService.removeCarparkPresenceRecord(id, userCode, userName, opTime, true);
                        }
                    }
                    WebUtil.printFinshJson(0, "\u5df2\u6210\u529f\u5220\u9664" + String.valueOf(dataList == null ? 0 : dataList.size()) + "\u6761\u8bb0\u5f55", response);
                }
                return;
            }
            sp.setOrder_by("enter_time");
            LinkedHashMap<String, String> headAtrrMap = new LinkedHashMap<String, String>();
            headAtrrMap.put("enter_time", "\u5165\u573a\u65f6\u95f4");
            headAtrrMap.put("enter_plate", "\u5165\u573a\u8f66\u724c");
            headAtrrMap.put("enter_plate_source", "\u653e\u884c\u65b9\u5f0f");
            headAtrrMap.put("area_name", "\u5165\u573a\u533a\u57df");
            headAtrrMap.put("enter_channel_name", "\u5165\u573a\u901a\u9053");
            headAtrrMap.put("passport_type_name", "\u8f66\u724c\u7c7b\u578b");
            headAtrrMap.put("enter_car_type_name", "\u8f66\u8f86\u7c7b\u578b");
            headAtrrMap.put("car_owner_name", "\u8f66\u4e3b\u59d3\u540d");
            headAtrrMap.put("car_owner_addr", "\u8f66\u4e3b\u4f4f\u5740");
            headAtrrMap.put("enter_valid_date", "\u5165\u573a\u65f6\u6709\u6548\u671f");
            headAtrrMap.put("enter_balance", "\u5165\u573a\u65f6\u4f59\u989d");
            headAtrrMap.put("enter_host_name", "\u5c97\u4ead/\u4e3b\u673a");
            headAtrrMap.put("enter_duty_user_name", "\u503c\u73ed\u5458");
            headAtrrMap.put("enter_remark", "\u8bb0\u5f55\u63cf\u8ff0");
            ExportService exportService = (ExportService)ServiceUtil.getServiceContext().getService(ExportService.class);
            response.setContentType("application/vnd.ms-excel");
            SimpleDateFormat df1 = new SimpleDateFormat("yyyyMMddHHmmss");
            response.addHeader("Content-Disposition", "attachment;filename=Export_" + df1.format(new Date()) + ".xls");
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            try (ServletOutputStream out = response.getOutputStream();){
                exportService.exportPresenceRecordExcel(sp, headAtrrMap, (OutputStream)out);
                return;
            }
        }
        if ("showDetail".equals(op)) {
            Integer lanState;
            Integer record_state;
            Long id = Long.valueOf(request.getParameter("id"));
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class));
            sp.addEQ("id", (Object)id);
            Map dataMap = commonDaoService.selectOne(sp);
            if (dataMap == null) {
                WebUtil.printFinshHtml(response, "404notfound");
                return;
            }
            String car_owner_name = ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("car_owner_name", (String)dataMap.get("car_owner_name"), request);
            String car_owner_addr = ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("address", (String)dataMap.get("car_owner_addr"), request);
            if (car_owner_name != null && car_owner_name.length() > 0) {
                dataMap.put("car_owner_name", car_owner_name);
            }
            if (car_owner_addr != null && car_owner_addr.length() > 0) {
                dataMap.put("car_owner_addr", car_owner_addr);
            }
            String enter_car_pic = (String)dataMap.get("enter_car_pic");
            String enter_plate_pic = (String)dataMap.get("enter_plate_pic");
            String hostNo = (String)dataMap.get("enter_host_no");
            dataMap.put("enter_car_pic", CarparkRecordSearchAction.getPicUri(request.getContextPath(), enter_car_pic, hostNo, true));
            if (enter_plate_pic != null && enter_plate_pic.length() > 0) {
                dataMap.put("enter_plate_pic", CarparkRecordSearchAction.getPicUri(request.getContextPath(), enter_plate_pic, hostNo, false));
            }
            Integer enter_plate_source = (Integer)dataMap.get("enter_plate_source");
            String v = null;
            String v2 = null;
            char z = '\u3001';
            if (enter_plate_source != null) {
                if (enter_plate_source == 0) {
                    v = "[\u8f66\u724c\u8bc6\u522b]";
                } else if (enter_plate_source == 1) {
                    v = "[\u4eba\u5de5\u653e\u884c]";
                } else if (enter_plate_source == 2) {
                    String enter_plate_modify_user_name = (String)dataMap.get("enter_plate_modify_user_name");
                    v = enter_plate_modify_user_name != null && enter_plate_modify_user_name.length() > 0 ? "[" + enter_plate_modify_user_name + "\u4fee\u6539]" : "\u4eba\u5de5\u4fee\u6539";
                    String enter_reg_plate = (String)dataMap.get("enter_reg_plate");
                    if (enter_reg_plate != null && enter_reg_plate.length() > 0) {
                        v2 = "\u8f66\u724c\u8bc6\u522b\uff1a" + enter_reg_plate;
                    } else {
                        String enter_obu_plate = (String)dataMap.get("enter_obu_plate");
                        if (enter_obu_plate != null && enter_obu_plate.length() > 0) {
                            v2 = "ETC\uff1a" + enter_obu_plate;
                        }
                    }
                    if (v2 == null || v2.length() == 0) {
                        v2 = "\u4eba\u5de5\u653e\u884c";
                    }
                } else if (enter_plate_source == 3) {
                    v = "[ETC]";
                } else if (enter_plate_source == 4) {
                    v = "[\u6a21\u7cca\u5339\u914d]";
                    String enter_reg_plate = (String)dataMap.get("enter_reg_plate");
                    if (enter_reg_plate != null && enter_reg_plate.length() > 0) {
                        v2 = "\u8f66\u724c\u8bc6\u522b\uff1a" + enter_reg_plate;
                    } else {
                        String enter_obu_plate = (String)dataMap.get("enter_obu_plate");
                        if (enter_obu_plate != null && enter_obu_plate.length() > 0) {
                            v2 = "ETC\uff1a" + enter_obu_plate;
                        }
                    }
                } else if (enter_plate_source == 5) {
                    v = "[\u8f66\u4e3b\u626b\u7801]";
                }
            }
            if (v != null) {
                dataMap.put("enter_plate_source", v);
            }
            StringBuilder sbr = new StringBuilder(128);
            if (v2 != null && v2.length() > 0) {
                if (sbr.length() > 0) {
                    sbr.append(z);
                }
                sbr.append(v2);
            }
            v = "";
            Integer pass_state_value = (Integer)dataMap.get("pass_state_value");
            if (pass_state_value != null && pass_state_value > 0) {
                if (pass_state_value == 6) {
                    v = "\u9ed1\u540d\u5355\u8f66";
                } else if (pass_state_value == 7) {
                    v = "\u672a\u542f\u7528";
                } else if (pass_state_value == 8) {
                    v = "\u5df2\u505c\u7528";
                } else if (pass_state_value == 4) {
                    v = "\u5df2\u8fc7\u671f";
                } else if (pass_state_value == 1) {
                    v = "\u65e0\u6743\u9650";
                }
            }
            if (v != null && v.length() > 0) {
                if (sbr.length() > 0) {
                    sbr.append(z);
                }
                sbr.append(v);
            }
            if ((record_state = (Integer)dataMap.get("record_state")) != null && record_state == 5) {
                if (sbr.length() > 0) {
                    sbr.append(z);
                }
                sbr.append("\u91cd\u590d\u5165\u573a");
            }
            if ((lanState = (Integer)dataMap.get("enter_lan_state")) != null) {
                if (lanState == 1) {
                    String enter_reg_plate = (String)dataMap.get("enter_reg_plate");
                    if (enter_reg_plate == null || enter_reg_plate.length() == 0) {
                        if (sbr.length() > 0) {
                            sbr.append(z);
                        }
                        sbr.append("\u8bc6\u522b\u76f8\u673a\u65ad\u7ebf");
                    }
                } else if (lanState == 2) {
                    if (sbr.length() > 0) {
                        sbr.append(z);
                    }
                    sbr.append("\u670d\u52a1\u5668\u65ad\u7ebf");
                } else if (lanState == 3) {
                    if (sbr.length() > 0) {
                        sbr.append(z);
                    }
                    sbr.append("\u5b58\u5728\u79bb\u7ebf\u4e3b\u673a");
                }
            }
            if (sbr.length() == 0) {
                sbr.append(dataMap.get("enter_host_name")).append(z).append(dataMap.get("enter_duty_user_name"));
            } else {
                String v1 = String.valueOf(z) + (String)dataMap.get("enter_host_name") + z + (String)dataMap.get("enter_duty_user_name");
                dataMap.put("addLine0", v1);
            }
            dataMap.put("line2", sbr.toString());
            String car_owner_no = (String)dataMap.get("car_owner_no");
            if (car_owner_no != null && car_owner_no.length() > 0) {
                sbr = new StringBuilder(128);
                sbr.append(dataMap.get("car_owner_name"));
                Integer pass_type = (Integer)dataMap.get("pass_type");
                if (pass_type != null) {
                    BigDecimal enter_balance;
                    if (pass_type == 2) {
                        Date enter_valid_date = (Date)dataMap.get("enter_valid_date");
                        if (enter_valid_date != null) {
                            if (sbr.length() > 0) {
                                sbr.append(z);
                            }
                            sbr.append("\u6709\u6548\u671f\uff1a").append(new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5").format(enter_valid_date));
                        }
                    } else if (pass_type == 1 && (enter_balance = (BigDecimal)dataMap.get("enter_balance")) != null) {
                        if (sbr.length() > 0) {
                            sbr.append(z);
                        }
                        sbr.append("\u4f59\u989d\uff1a").append(enter_balance);
                    }
                }
                if (car_owner_addr != null && car_owner_addr.length() > 0) {
                    if (sbr.length() > 0) {
                        sbr.append(z);
                    }
                    sbr.append(car_owner_addr);
                }
                dataMap.put("line3", sbr.toString());
            }
            request.setAttribute("record", (Object)dataMap);
            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            SearchParam sk = new SearchParam().addEQ("passport_number", dataMap.get("passport_number")).addEQ("medium_type", dataMap.get("medium_type")).addEQ("enter_time", dataMap.get("enter_time"));
            sk.setOrder_by("discount_time");
            List discountList = commonDaoService.selectList(sk, CarparkPassDiscount.class, null);
            StringBuilder discountInfo = new StringBuilder();
            if (discountList != null && !discountList.isEmpty()) {
                SimpleDateFormat df1 = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
                for (CarparkPassDiscount m : discountList) {
                    if (discountInfo.length() > 0) {
                        discountInfo.append('\u3001');
                    }
                    discountInfo.append(m.getDiscount_project_name());
                    String v1 = m.getDiscount_value_des();
                    if ((v1 == null || v1.length() == 0) && m.getDiscount_method() != null && m.getDiscount_value() != null) {
                        v1 = appService.getDiscountValueDes(m.getDiscount_method(), m.getDiscount_value());
                        m.setDiscount_value_des(v1);
                    }
                    if (v1 != null && v1.length() > 0) {
                        discountInfo.append('[').append(v1).append(']');
                    }
                    if (m.getDiscount_time() == null) continue;
                    discountInfo.append(',').append(df1.format(m.getDiscount_time()));
                }
            }
            if (discountInfo != null && discountInfo.length() > 0) {
                dataMap.put("line4", discountInfo.toString());
            }
            SearchParam param1 = new SearchParam().addEQ("passport_number", dataMap.get("passport_number")).addEQ("medium_type", dataMap.get("medium_type")).addEQ("enter_time", dataMap.get("enter_time"));
            param1.setOrder_by("paid_time ASC");
            List selfPayList = commonDaoService.selectList(param1, CarparkPassSelfPay.class, null);
            StringBuilder selfPayInfo = new StringBuilder();
            if (selfPayList != null && !selfPayList.isEmpty()) {
                SimpleDateFormat df1 = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
                for (CarparkPassSelfPay p1 : selfPayList) {
                    String paMdes;
                    if (selfPayInfo.length() > 0) {
                        selfPayInfo.append('\u3001');
                    }
                    if ((paMdes = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(p1.getPaid_method())) != null) {
                        if (p1.getPaid_method() == 0 && p1.getPay_scene() != null && p1.getPay_scene() == 1) {
                            selfPayInfo.append("\u7ba1\u7406\u5904\u5df2\u6536\u73b0\u91d1:");
                        } else {
                            selfPayInfo.append(paMdes).append("\u5df2\u652f\u4ed8:");
                        }
                    }
                    selfPayInfo.append(p1.getPaid_amount());
                    if (p1.getPaid_time() == null) continue;
                    selfPayInfo.append(',').append(df1.format(p1.getPaid_time()));
                }
            }
            if (selfPayInfo != null && selfPayInfo.length() > 0) {
                dataMap.put("line5", selfPayInfo.toString());
            }
            Date occupy_end_time = (Date)dataMap.get("occupy_end_time");
            String occupy_plate = (String)dataMap.get("occupy_plate");
            String occupy_passport_type_no = (String)dataMap.get("occupy_passport_type_no");
            Date enter_time = (Date)dataMap.get("enter_time");
            if (occupy_end_time != null && enter_time != null && occupy_plate != null && occupy_plate.length() > 0 && occupy_passport_type_no != null && occupy_passport_type_no.length() > 0 && !occupy_passport_type_no.equals(dataMap.get("passport_type_no"))) {
                StringBuilder b1 = new StringBuilder(128);
                if (!occupy_plate.equals(dataMap.get("pass_plate"))) {
                    b1.append("\u672c\u8f66\u5165\u573a\u65f6, ").append(occupy_plate).append("\u5df2\u7ecf\u5360\u7528\u8f66\u4f4d: ").append(dataMap.get("passport_type_name")).append(", ");
                }
                CarparkPassportType passportType = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(occupy_passport_type_no);
                int tpSec = (int)TimeUnit.MILLISECONDS.toSeconds(occupy_end_time.getTime() - enter_time.getTime());
                String dsc = appService.getTimeLenSecDes(tpSec);
                if (passportType != null) {
                    if (passportType.getPass_type() == 0) {
                        b1.append("\u672c\u8f66\u5360\u7528\u4e34\u505c(" + passportType.getPassport_type_name() + ")\u8f66\u4f4d\u65f6\u957f\uff1a").append(dsc);
                    } else {
                        b1.append("\u672c\u8f66\u4e3a(" + passportType.getPassport_type_name() + ")\u8f66\u4f4d\u65f6\u957f\uff1a").append(dsc);
                    }
                } else {
                    b1.append("\u672c\u8f66\u5360\u7528\u8f66\u4f4d\u65f6\u957f\uff1a").append(dsc);
                }
                b1.append(", \u622a\u6b62\u65f6\u95f4\uff1a").append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(enter_time));
                dataMap.put("line6", b1.toString());
            }
            WebUtil.dispathTemplatePage("report/presenceRecord", request, response);
            return;
        }
        if (!"downloadImportExcel".equals(op)) return;
        response.setContentType("application/vnd.ms-excel");
        SimpleDateFormat df1 = new SimpleDateFormat("yyyyMMddHHmmss");
        response.addHeader("Content-Disposition", "attachment;filename=ImportTemplate_" + df1.format(new Date()) + ".xls");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        try (ServletOutputStream out = response.getOutputStream();
             HSSFWorkbook workbook = new HSSFWorkbook();){
            HSSFSheet sheet = workbook.createSheet("\u5728\u573a\u8f66\u8f86\u5bfc\u5165\u6a21\u677f");
            int rowIndex = 0;
            int cellIndex = 0;
            ArrayList<Object[]> dataList = new ArrayList<Object[]>();
            dataList.add(new Object[]{"\u8f66\u724c\u53f7\u7801", "\u5165\u573a\u65f6\u95f4", "\u5165\u573a\u901a\u9053", "\u8f66\u8f86\u7c7b\u578b"});
            CarparkCarType t = PassChannel.getTimepDynCarType();
            String carTypeName = t != null ? t.getCar_type_name() : "\u5c0f\u578b\u8f66";
            CarparkChannel chanl = null;
            Map<String, CarparkChannel> chmap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
            Map<String, ChannelArea> channelAreaMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas();
            if (chmap != null && !chmap.isEmpty() && channelAreaMap != null && !channelAreaMap.isEmpty()) {
                block14: for (CarparkChannel ch : chmap.values()) {
                    ChannelArea channelArea = channelAreaMap.get(ch.getChannel_no());
                    List<CarparkArea> areaList = channelArea.getEnterAreas();
                    if (channelArea == null || areaList == null || areaList.isEmpty()) continue;
                    if (chanl == null) {
                        chanl = ch;
                    }
                    for (CarparkArea ara : areaList) {
                        if (ara.getArea_level() != 1) continue;
                        chanl = ch;
                        continue block14;
                    }
                }
            }
            String channelName = null;
            if (chanl != null) {
                channelName = chanl.getChannel_name();
            }
            if (channelName == null || channelName.length() == 0) {
                channelName = "\u5927\u95e8\u5165\u53e3";
            }
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            cl.add(11, -1);
            dataList.add(new Object[]{"\u7ca4ACA001", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(cl.getTime()), channelName, carTypeName});
            cl.add(12, 10);
            dataList.add(new Object[]{"\u9102ACA9518", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(cl.getTime()), channelName, ""});
            cl.add(12, 6);
            dataList.add(new Object[]{"\u8d63BCA98\u5b66", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(cl.getTime()), channelName, carTypeName});
            cl.add(12, 30);
            dataList.add(new Object[]{"\u6d59A0787H", new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(cl.getTime()), channelName, carTypeName});
            dataList.add(new Object[]{"\u672c\u884c\u4e0e\u4e0b\u9762\u4e00\u884c\u4e3a\u8bf4\u660e\uff0c\u5b9e\u9645\u5bfc\u5165\u4e0d\u9700\u8981\uff0c\u5728\u573a\u8f66\u8f86\u5bfc\u5165\u4e00\u822c\u7528\u4e8e\u66f4\u6362\u505c\u8f66\u573a\u8f6f\u4ef6\u4f7f\u7528\uff0c\u4e3b\u8981\u662f\u4e0d\u5f71\u54cd\u4e34\u505c\u8f66\u8ba1\u8d39", "", "", ""});
            dataList.add(new Object[]{"\u5fc5\u987b", "\u5fc5\u987b\uff0cexcel\u65e5\u671f\u683c\u5f0f\u6216\u8005yyyy-MM-dd HH:mm:ss,\u6216\u8005yyyy/MM/dd HH:mm:ss\u5b57\u7b26\u4e32\u683c\u5f0f", "\u5fc5\u987b,\u901a\u9053\u7ba1\u7406\u4e2d\u5b9a\u4e49\u7684\u901a\u9053\u540d\u79f0", "\u4e0d\u662f\u5fc5\u987b\uff0c\u9ed8\u8ba4" + carTypeName});
            for (Object[] s : dataList) {
                HSSFRow headRow = sheet.createRow(rowIndex++);
                cellIndex = 0;
                Object[] objectArray = s;
                int n = s.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    headRow.createCell(cellIndex++).setCellValue(obj.toString());
                    ++n2;
                }
            }
            workbook.write((OutputStream)out);
            return;
        }
    }

    private static String getPicUri(String contextPath, String picPath, String hostNo, boolean showNopic) throws Exception {
        return WebUtil.getPicUri(contextPath, picPath, hostNo, showNopic);
    }

    @WritePermission
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u4fee\u6539\u5728\u573a\u8f66\u8f86\u8f66\u724c")
    @Path(value="/modifyPresenceRecordPlate.action")
    public void modifyPresenceRecordPlate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String userName;
        String userCode;
        long id = Long.parseLong(request.getParameter("id"));
        String newPlate = request.getParameter("newPlate");
        String oldPlate = request.getParameter("oldPlate");
        Date opTime = WebUtil.getNow();
        ClientHost clientHost = WebUtil.getLoginClientHost(request);
        if (clientHost != null) {
            userCode = clientHost.getUserCode();
            userName = clientHost.getUserName();
        } else {
            CarparkUser user = WebUtil.getLoginManageUser(request);
            userCode = user.getUser_code();
            userName = user.getUser_name();
        }
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        appService.modifyEnterPlate(id, oldPlate, newPlate, opTime, userCode, userName);
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u4fee\u6539\u5728\u573a\u8f66\u8f86\u7c7b\u578b")
    @Path(value="/modifyPresenceRecordCartype.action")
    public void modifyPresenceRecordCartype(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String userName;
        String userCode;
        long id = Long.parseLong(request.getParameter("id"));
        Date opTime = WebUtil.getNow();
        String modifyCarTypeNo = request.getParameter("modifyCarTypeNo");
        String oldCarTypeNo = request.getParameter("oldCarTypeNo");
        ClientHost clientHost = WebUtil.getLoginClientHost(request);
        if (clientHost != null) {
            userCode = clientHost.getUserCode();
            userName = clientHost.getUserName();
        } else {
            CarparkUser user = WebUtil.getLoginManageUser(request);
            userCode = user.getUser_code();
            userName = user.getUser_name();
        }
        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        String result = recordSaveService.modifyPresenceCarType(id, oldCarTypeNo, modifyCarTypeNo, userCode, userName, opTime, true);
        if ("SUCCESS".equals(result)) {
            WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
        } else {
            WebUtil.printFinshJson(1, result, response);
        }
    }

    @WritePermission
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\u79fb\u9664")
    @Path(value="/removePresenceRecord.action")
    public void removePresenceRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String userName;
        String userCode;
        String deleteByQuery = request.getParameter("deleteByQuery");
        if (deleteByQuery != null && ("1".equals(deleteByQuery) || "2".equals(deleteByQuery))) {
            request.setAttribute("removeByQuery", (Object)deleteByQuery);
            this.queryPresenceRecord(request, response);
            return;
        }
        long id = Long.parseLong(request.getParameter("id"));
        Date opTime = WebUtil.getNow();
        ClientHost clientHost = WebUtil.getLoginClientHost(request);
        if (clientHost != null) {
            userCode = clientHost.getUserCode();
            userName = clientHost.getUserName();
        } else {
            CarparkUser user = WebUtil.getLoginManageUser(request);
            userCode = user.getUser_code();
            userName = user.getUser_name();
        }
        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        recordSaveService.removeCarparkPresenceRecord(id, userCode, userName, opTime, true);
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\u5bfc\u51fa")
    @Path(value="/exportPresenceRecord.action")
    public void exportPresenceRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("export", (Object)Boolean.TRUE);
        this.queryPresenceRecord(request, response);
    }

    @WritePermission
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u5728\u573a\u8f66\u8f86\u8bb0\u5f55\u5bfc\u5165")
    @Path(value="/importPresenceRecord.action")
    public void importPresenceRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        DiskFileItemFactory f = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)f);
        upload.setSizeMax(0x2800000L);
        List fileItemList = upload.parseRequest(request);
        KeyValueEntry result = null;
        for (Object obj : fileItemList) {
            FileItem fileItem = (FileItem)obj;
            if (fileItem.isFormField()) continue;
            InputStream in = fileItem.getInputStream();
            try {
                try {
                    String userName;
                    String userCode;
                    ClientHost clientHost = WebUtil.getLoginClientHost(request);
                    if (clientHost != null) {
                        userCode = clientHost.getUserCode();
                        userName = clientHost.getUserName();
                    } else {
                        CarparkUser user = WebUtil.getLoginManageUser(request);
                        userCode = user.getUser_code();
                        userName = user.getUser_name();
                    }
                    ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    result = applicationService.importPresenceRecordFromExcel(fileItem.getName(), in, userCode, userName);
                    if (result == null) {
                        result = new KeyValueEntry((Object)1, (Object)"\u65e0\u54cd\u5e94");
                    }
                }
                catch (Exception ex) {
                    result = new KeyValueEntry((Object)1, (Object)("\u5f02\u5e38\uff1a" + ex.getMessage()));
                    in.close();
                    break;
                }
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            break;
        }
        if (result == null) {
            WebUtil.printFinshJson(1, "\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684Excel\u6587\u4ef6", response);
        } else {
            WebUtil.printFinshJson((Integer)result.getKey(), (String)result.getValue(), response);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u8f66\u8f86\u5165\u573a\u8bb0\u5f55\u67e5\u8be2")
    @LeftMenu(name="\u8f66\u8f86\u5165\u573a\u8bb0\u5f55\u67e5\u8be2", parent_name="\u8bb0\u5f55\u67e5\u8be2", order=312)
    @Path(value="/queryEnterPassRecord.action")
    public void queryEnterPassRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String enter_remark;
        Integer lanState;
        Integer record_state;
        String op = request.getParameter("op");
        if (op == null) {
            Map<String, CarparkCarType> carTypeMap;
            Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
            if (areaMap != null) {
                request.setAttribute("areaMap", areaMap);
            }
            Map<String, ChannelArea> channalAreaMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas();
            Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
            ArrayList<CarparkChannel> channelList = new ArrayList<CarparkChannel>();
            if (channelMap != null && !channelMap.isEmpty()) {
                for (CarparkChannel ch : channelMap.values()) {
                    ChannelArea cha = channalAreaMap.get(ch.getChannel_no());
                    if (cha == null || cha.getEnterAreas() == null || cha.getEnterAreas().isEmpty()) continue;
                    channelList.add(ch);
                }
            }
            request.setAttribute("channelList", channelList);
            Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            if (passportTypeMap != null) {
                request.setAttribute("passportTypeMap", passportTypeMap);
            }
            if ((carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap()) != null) {
                request.setAttribute("carTypeMap", carTypeMap);
            }
            Calendar cl = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            request.setAttribute("endTime", (Object)df.format(cl.getTime()));
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            cl.set(14, 0);
            request.setAttribute("startTime", (Object)df.format(cl.getTime()));
            WebUtil.showMainContentWithHead("\u8f66\u8f86\u5165\u573a\u8bb0\u5f55", "report/enterPassRecord", request, response);
            return;
        }
        if ("query".equals(op) || request.getAttribute("export") != null) {
            boolean cancelled;
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkPassRecord.class));
            String queryAttr1 = request.getParameter("queryAttr1");
            String queryValue1 = request.getParameter("queryValue1");
            String start_enter_time = request.getParameter("start_enter_time");
            String end_enter_time = request.getParameter("end_enter_time");
            String area_no = request.getParameter("area_no");
            String enter_channel_no = request.getParameter("enter_channel_no");
            String passport_type_no = request.getParameter("passport_type_no");
            String enter_car_type_no = request.getParameter("enter_car_type_no");
            String _record_des = request.getParameter("record_des");
            if (queryAttr1 != null && (queryAttr1 = queryAttr1.trim()).length() > 0 && queryValue1 != null && (queryValue1 = queryValue1.trim()).length() > 0) {
                if ("enter_plate".equals(queryAttr1)) {
                    String v2 = queryValue1.toUpperCase();
                    v2 = v2.replaceAll("\u3000", "");
                    v2 = v2.replaceAll(" ", "");
                    if ((v2 = v2.replaceAll("I", "1")).length() > 0) {
                        sp.addLike(queryAttr1, v2);
                    }
                } else {
                    sp.addLike(queryAttr1, queryValue1);
                }
            }
            sp.addEQ("exit_time", null);
            if (start_enter_time != null && start_enter_time.length() > 0) {
                sp.addGTE("pass_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(start_enter_time));
            }
            if (end_enter_time != null && end_enter_time.length() > 0) {
                sp.addLTE("pass_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(end_enter_time));
            }
            if (area_no != null && (area_no = area_no.trim()).length() > 0) {
                sp.addEQ("area_no", (Object)area_no);
            }
            if (enter_channel_no != null && (enter_channel_no = enter_channel_no.trim()).length() > 0) {
                sp.addEQ("enter_channel_no", (Object)enter_channel_no);
            }
            if (passport_type_no != null && (passport_type_no = passport_type_no.trim()).length() > 0) {
                sp.addEQ("passport_type_no", (Object)passport_type_no);
            }
            if (enter_car_type_no != null && (enter_car_type_no = enter_car_type_no.trim()).length() > 0) {
                sp.addEQ("enter_car_type_no", (Object)enter_car_type_no);
            }
            if (_record_des != null) {
                _record_des = _record_des.trim();
            }
            boolean bl = cancelled = _record_des != null && "11".equals(_record_des);
            if (!cancelled) {
                if (_record_des != null && _record_des.length() > 0) {
                    int a = Integer.parseInt(_record_des);
                    if (a == 100) {
                        sp.addEQ("record_state", (Object)5);
                    } else if (a == 101) {
                        sp.addNotEQ("remove_op_time", null);
                    } else {
                        sp.addEQ("enter_plate_source", (Object)a);
                    }
                }
            } else {
                sp.setTableName(commonDaoService.getTableName(CarparkCancelPassRecord.class));
            }
            if ("query".equals(op)) {
                String sortOrder = request.getParameter("sortOrder");
                String sortName = request.getParameter("sortName");
                if (sortName != null && (sortName = sortName.trim()).length() > 0 && sortOrder != null && (sortOrder = sortOrder.trim()).length() > 0) {
                    sp.setOrder_by((String.valueOf(sortName) + " " + sortOrder).replaceAll("'", ""));
                } else {
                    sp.setOrder_by("pass_time desc");
                }
                Pagination p = WebUtil.getPagination(request);
                List dataList = commonDaoService.selectList(sp, p);
                ArrayList<Map> resultList = new ArrayList<Map>(dataList == null ? 0 : dataList.size());
                if (dataList != null && !dataList.isEmpty()) {
                    for (Map data : dataList) {
                        String enter_remark2;
                        Integer record_state2;
                        String enter_plate_pic = (String)data.get("enter_plate_pic");
                        String hostNo = (String)data.get("enter_host_no");
                        data.put("enter_plate_pic", CarparkRecordSearchAction.getPicUri(request.getContextPath(), enter_plate_pic, hostNo, true));
                        String enterPlate = (String)data.get("enter_plate");
                        String v = null;
                        Integer enter_plate_source = (Integer)data.get("enter_plate_source");
                        if (enter_plate_source != null && enterPlate != null) {
                            if (enter_plate_source == 0) {
                                v = "\u8f66\u724c\u8bc6\u522b";
                            } else if (enter_plate_source == 1) {
                                v = "\u4eba\u5de5\u653e\u884c";
                            } else if (enter_plate_source == 2) {
                                v = "\u4eba\u5de5\u4fee\u6539";
                            } else if (enter_plate_source == 3) {
                                v = "ETC";
                            } else if (enter_plate_source == 4) {
                                v = "\u6a21\u7cca\u5339\u914d";
                            }
                        }
                        if (v == null) {
                            v = "";
                        }
                        if ((record_state2 = (Integer)data.get("record_state")) != null && record_state2 == 5) {
                            if (v.length() > 0) {
                                v = String.valueOf(v) + "\u3001";
                            }
                            v = String.valueOf(v) + "\u91cd\u590d\u5165\u573a";
                        }
                        if (data.get("remove_op_time") != null) {
                            if (v.length() > 0) {
                                v = String.valueOf(v) + "<br>";
                            }
                            v = String.valueOf(v) + "\u4eba\u5de5\u79fb\u9664\u5728\u573a\u8bb0\u5f55";
                        }
                        if ((enter_remark2 = (String)data.get("enter_remark")) != null && enter_remark2.length() > 0) {
                            if (v.length() > 0) {
                                v = String.valueOf(v) + ", ";
                            }
                            v = String.valueOf(v) + enter_remark2;
                        }
                        data.put("record_des", v);
                        String car_owner_name = ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("car_owner_name", (String)data.get("car_owner_name"), request);
                        String car_owner_addr = ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("address", (String)data.get("car_owner_addr"), request);
                        if (car_owner_name != null && car_owner_name.length() > 0) {
                            data.put("car_owner_name", car_owner_name);
                        }
                        if (car_owner_addr != null && car_owner_addr.length() > 0) {
                            data.put("car_owner_addr", car_owner_addr);
                        }
                        resultList.add(JavaBeanUtil.toStringMap((Object)data));
                    }
                }
                HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
                resMap.put("rows", resultList);
                resMap.put("total", Long.valueOf(p.getRecordsCount()));
                WebUtil.printFinshJson(response, GsonBuilder.create().toJson(resMap));
                return;
            }
            LinkedHashMap<String, String> headAtrrMap = new LinkedHashMap<String, String>();
            headAtrrMap.put("enter_time", "\u5165\u573a\u65f6\u95f4");
            headAtrrMap.put("enter_plate", "\u5165\u573a\u8f66\u724c");
            headAtrrMap.put("enter_plate_source", "\u653e\u884c\u65b9\u5f0f");
            headAtrrMap.put("area_name", "\u5165\u573a\u533a\u57df");
            headAtrrMap.put("enter_channel_name", "\u5165\u573a\u901a\u9053");
            headAtrrMap.put("passport_type_name", "\u8f66\u724c\u7c7b\u578b");
            headAtrrMap.put("enter_car_type_name", "\u8f66\u8f86\u7c7b\u578b");
            headAtrrMap.put("car_owner_name", "\u8f66\u4e3b\u59d3\u540d");
            headAtrrMap.put("car_owner_addr", "\u8f66\u4e3b\u4f4f\u5740");
            headAtrrMap.put("enter_valid_date", "\u5165\u573a\u65f6\u6709\u6548\u671f");
            headAtrrMap.put("enter_balance", "\u5165\u573a\u65f6\u4f59\u989d");
            headAtrrMap.put("enter_host_name", "\u5c97\u4ead/\u4e3b\u673a");
            headAtrrMap.put("enter_duty_user_name", "\u503c\u73ed\u5458");
            headAtrrMap.put("enter_remark", "\u8bb0\u5f55\u63cf\u8ff0");
            ExportService exportService = (ExportService)ServiceUtil.getServiceContext().getService(ExportService.class);
            response.setContentType("text/plain; charset=GBK");
            response.setCharacterEncoding("GBK");
            SimpleDateFormat df11 = new SimpleDateFormat("yyyyMMddHHmmss");
            String fileN = cancelled ? "cancelEnterRecord_" : "EnterRecord_";
            response.addHeader("Content-Disposition", "attachment;filename=" + fileN + df11.format(new Date()) + ".csv");
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            try (PrintWriter out = response.getWriter();){
                exportService.exportEnterRecordCsv(sp, headAtrrMap, out);
                return;
            }
        }
        if (!"showDetail".equals(op)) return;
        Long id = Long.valueOf(request.getParameter("id"));
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkPassRecord.class));
        sp.addEQ("id", (Object)id);
        Map dataMap = commonDaoService.selectOne(sp);
        if (dataMap == null) {
            WebUtil.printFinshHtml(response, "404notfound");
            return;
        }
        String car_owner_name = ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("car_owner_name", (String)dataMap.get("car_owner_name"), request);
        String car_owner_addr = ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("address", (String)dataMap.get("car_owner_addr"), request);
        if (car_owner_name != null && car_owner_name.length() > 0) {
            dataMap.put("car_owner_name", car_owner_name);
        }
        if (car_owner_addr != null && car_owner_addr.length() > 0) {
            dataMap.put("car_owner_addr", car_owner_addr);
        }
        String enter_car_pic = (String)dataMap.get("enter_car_pic");
        String enter_plate_pic = (String)dataMap.get("enter_plate_pic");
        String hostNo = (String)dataMap.get("enter_host_no");
        dataMap.put("enter_car_pic", CarparkRecordSearchAction.getPicUri(request.getContextPath(), enter_car_pic, hostNo, true));
        if (enter_plate_pic != null && enter_plate_pic.length() > 0) {
            dataMap.put("enter_plate_pic", CarparkRecordSearchAction.getPicUri(request.getContextPath(), enter_plate_pic, hostNo, false));
        }
        Integer enter_plate_source = (Integer)dataMap.get("enter_plate_source");
        String v = null;
        String v2 = null;
        char z = '\u3001';
        if (enter_plate_source != null) {
            if (enter_plate_source == 0) {
                v = "[\u8f66\u724c\u8bc6\u522b]";
            } else if (enter_plate_source == 1) {
                v = "[\u4eba\u5de5\u653e\u884c]";
            } else if (enter_plate_source == 2) {
                String enter_plate_modify_user_name = (String)dataMap.get("enter_plate_modify_user_name");
                v = enter_plate_modify_user_name != null && enter_plate_modify_user_name.length() > 0 ? "[" + enter_plate_modify_user_name + "\u4fee\u6539]" : "\u4eba\u5de5\u4fee\u6539";
                String enter_reg_plate = (String)dataMap.get("enter_reg_plate");
                if (enter_reg_plate != null && enter_reg_plate.length() > 0) {
                    v2 = "\u8f66\u724c\u8bc6\u522b\uff1a" + enter_reg_plate;
                } else {
                    String enter_obu_plate = (String)dataMap.get("enter_obu_plate");
                    if (enter_obu_plate != null && enter_obu_plate.length() > 0) {
                        v2 = "ETC\uff1a" + enter_obu_plate;
                    }
                }
                if (v2 == null || v2.length() == 0) {
                    v2 = "\u4eba\u5de5\u653e\u884c";
                }
            } else if (enter_plate_source == 3) {
                v = "[ETC]";
            } else if (enter_plate_source == 4) {
                v = "[\u6a21\u7cca\u5339\u914d]";
                String enter_reg_plate = (String)dataMap.get("enter_reg_plate");
                if (enter_reg_plate != null && enter_reg_plate.length() > 0) {
                    v2 = "\u8f66\u724c\u8bc6\u522b\uff1a" + enter_reg_plate;
                } else {
                    String enter_obu_plate = (String)dataMap.get("enter_obu_plate");
                    if (enter_obu_plate != null && enter_obu_plate.length() > 0) {
                        v2 = "ETC\uff1a" + enter_obu_plate;
                    }
                }
            }
        }
        if (v != null) {
            dataMap.put("enter_plate_source", v);
        }
        StringBuilder sbr = new StringBuilder(128);
        if (v2 != null && v2.length() > 0) {
            if (sbr.length() > 0) {
                sbr.append(z);
            }
            sbr.append(v2);
        }
        v = "";
        Integer pass_state_value = (Integer)dataMap.get("pass_state_value");
        if (pass_state_value != null && pass_state_value > 0) {
            if (pass_state_value == 6) {
                v = "\u9ed1\u540d\u5355\u8f66";
            } else if (pass_state_value == 7) {
                v = "\u672a\u542f\u7528";
            } else if (pass_state_value == 8) {
                v = "\u5df2\u505c\u7528";
            } else if (pass_state_value == 4) {
                v = "\u5df2\u8fc7\u671f";
            } else if (pass_state_value == 1) {
                v = "\u65e0\u6743\u9650";
            }
        }
        if (v != null && v.length() > 0) {
            if (sbr.length() > 0) {
                sbr.append(z);
            }
            sbr.append(v);
        }
        if ((record_state = (Integer)dataMap.get("record_state")) != null && record_state == 5) {
            if (sbr.length() > 0) {
                sbr.append(z);
            }
            sbr.append("\u91cd\u590d\u5165\u573a");
        }
        if ((lanState = (Integer)dataMap.get("enter_lan_state")) != null) {
            if (lanState == 1) {
                String enter_reg_plate = (String)dataMap.get("enter_reg_plate");
                if (enter_reg_plate == null || enter_reg_plate.length() == 0) {
                    if (sbr.length() > 0) {
                        sbr.append(z);
                    }
                    sbr.append("\u8bc6\u522b\u76f8\u673a\u65ad\u7ebf");
                }
            } else if (lanState == 2) {
                if (sbr.length() > 0) {
                    sbr.append(z);
                }
                sbr.append("\u670d\u52a1\u5668\u65ad\u7ebf");
            } else if (lanState == 3) {
                if (sbr.length() > 0) {
                    sbr.append(z);
                }
                sbr.append("\u5b58\u5728\u79bb\u7ebf\u4e3b\u673a");
            }
        }
        if (sbr.length() == 0) {
            sbr.append(dataMap.get("enter_host_name")).append(z).append(dataMap.get("enter_duty_user_name"));
        } else {
            String v1 = String.valueOf(z) + (String)dataMap.get("enter_host_name") + z + (String)dataMap.get("enter_duty_user_name");
            dataMap.put("addLine0", v1);
        }
        dataMap.put("line2", sbr.toString());
        String car_owner_no = (String)dataMap.get("car_owner_no");
        if (car_owner_no != null && car_owner_no.length() > 0) {
            sbr = new StringBuilder(128);
            sbr.append(dataMap.get("car_owner_name"));
            Integer pass_type = (Integer)dataMap.get("pass_type");
            if (pass_type != null) {
                BigDecimal enter_balance;
                if (pass_type == 2) {
                    Date enter_valid_date = (Date)dataMap.get("enter_valid_date");
                    if (enter_valid_date != null) {
                        if (sbr.length() > 0) {
                            sbr.append(z);
                        }
                        sbr.append("\u6709\u6548\u671f\uff1a").append(new SimpleDateFormat("yy\u5e74MM\u6708dd\u65e5").format(enter_valid_date));
                    }
                } else if (pass_type == 1 && (enter_balance = (BigDecimal)dataMap.get("enter_balance")) != null) {
                    if (sbr.length() > 0) {
                        sbr.append(z);
                    }
                    sbr.append("\u4f59\u989d\uff1a").append(enter_balance);
                }
            }
            if (car_owner_addr != null && car_owner_addr.length() > 0) {
                if (sbr.length() > 0) {
                    sbr.append(z);
                }
                sbr.append(car_owner_addr);
            }
            dataMap.put("line3", sbr.toString());
        }
        Date remove_op_time = (Date)dataMap.get("remove_op_time");
        String line4 = null;
        if (remove_op_time != null) {
            sbr = new StringBuilder(128);
            sbr.append(dataMap.get("remove_user_name"));
            sbr.append("\u5728 ").append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(remove_op_time));
            sbr.append(" \u5c06\u6b64\u8bb0\u5f55\u4ece\u5728\u573a\u8f66\u8f86\u79fb\u9664\u3002");
            line4 = sbr.toString();
        }
        if ((enter_remark = (String)dataMap.get("enter_remark")) != null && enter_remark.length() > 0) {
            line4 = line4 == null ? enter_remark : String.valueOf(line4) + ", " + enter_remark;
        }
        if (line4 != null) {
            dataMap.put("line4", line4);
        }
        request.setAttribute("record", (Object)dataMap);
        WebUtil.dispathTemplatePage("report/enterPassRecord", request, response);
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u8f66\u8f86\u5165\u573a\u8bb0\u5f55\u5bfc\u51fa")
    @Path(value="/exportEnterPassRecord.action")
    public void exportEnterPassRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("export", (Object)Boolean.TRUE);
        this.queryEnterPassRecord(request, response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u8f66\u8f86\u79bb\u573a\u8bb0\u5f55\u67e5\u8be2")
    @LeftMenu(name="\u8f66\u8f86\u79bb\u573a\u8bb0\u5f55\u67e5\u8be2", parent_name="\u8bb0\u5f55\u67e5\u8be2", order=313)
    @Path(value="/queryExitPassRecord.action")
    public void queryExitPassRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            Map<String, CarparkCarType> carTypeMap;
            Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
            if (areaMap != null) {
                request.setAttribute("areaMap", areaMap);
            }
            Map<String, ChannelArea> channalAreaMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas();
            Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
            ArrayList<CarparkChannel> channelList = new ArrayList<CarparkChannel>();
            if (channelMap != null && !channelMap.isEmpty()) {
                for (CarparkChannel ch : channelMap.values()) {
                    ChannelArea cha = channalAreaMap.get(ch.getChannel_no());
                    if (cha == null || cha.getExitAreas() == null || cha.getExitAreas().isEmpty()) continue;
                    channelList.add(ch);
                }
            }
            request.setAttribute("channelList", channelList);
            Map<String, CarparkPassportType> passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap();
            if (passportTypeMap != null) {
                request.setAttribute("passportTypeMap", passportTypeMap);
            }
            if ((carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap()) != null) {
                request.setAttribute("carTypeMap", carTypeMap);
            }
            Calendar cl = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            request.setAttribute("endTime", (Object)df.format(cl.getTime()));
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            cl.set(14, 0);
            request.setAttribute("startTime", (Object)df.format(cl.getTime()));
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            List merchantList = commonDaoService.selectList(new SearchParam().addEQ("merchant_type", (Object)0), CarparkMerchant.class, null);
            int counta = 1;
            if (merchantList != null && !merchantList.isEmpty()) {
                counta += merchantList.size();
            }
            ArrayList<KeyValueEntry> discountMerchantList = new ArrayList<KeyValueEntry>(counta);
            discountMerchantList.add(new KeyValueEntry((Object)"0", (Object)"\u8f66\u573a\u7ba1\u7406"));
            if (merchantList != null && !merchantList.isEmpty()) {
                for (CarparkMerchant t : merchantList) {
                    discountMerchantList.add(new KeyValueEntry((Object)t.getMerchant_no(), (Object)t.getMerchant_name()));
                }
            }
            request.setAttribute("discountMerchantList", discountMerchantList);
            Map<String, CarparkHost> hosMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
            request.setAttribute("hosMap", hosMap);
            Integer project_id = ServiceUtil.getServiceContext().getProjectId();
            Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
            List userList = commonDaoService.selectList(new SearchParam().addINList("role_no", (Object[])new String[]{"1", "2"}).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("role_no DESC,user_code"), CarparkUser.class, null);
            request.setAttribute("userList", (Object)userList);
            ArrayList<KeyValueEntry> discountProjList = new ArrayList<KeyValueEntry>();
            Map<String, CarparkDiscountProject> dmap = ServiceUtil.getServiceContext().getDBConfigCache().getDiscountProjectMap();
            if (dmap != null && !dmap.isEmpty()) {
                for (CarparkDiscountProject dp : dmap.values()) {
                    discountProjList.add(new KeyValueEntry((Object)dp.getDiscount_project_no(), (Object)dp.getDiscount_project_name()));
                }
            }
            request.setAttribute("discountProjList", discountProjList);
            WebUtil.showMainContentWithHead("\u8f66\u8f86\u79bb\u573a\u8bb0\u5f55", "report/exitPassRecord", request, response);
            return;
        }
        if ("query".equals(op) || request.getAttribute("export") != null || "queryTotalMoney".equals(op)) {
            Integer v;
            String area_no = request.getParameter("area_no");
            String exit_channel_no = request.getParameter("exit_channel_no");
            String passport_type_no = request.getParameter("passport_type_no");
            String exit_car_type_no = request.getParameter("exit_car_type_no");
            String record_des = request.getParameter("record_des");
            String exit_host_no = request.getParameter("exit_host_no");
            String exit_duty_user_code = request.getParameter("exit_duty_user_code");
            String queryAttr2 = request.getParameter("queryAttr2");
            String start_money = request.getParameter("start_money");
            String end_money = request.getParameter("end_money");
            String discount_merchant_no = request.getParameter("discount_merchant_no");
            String discount_project_no = request.getParameter("discount_project_no");
            String queryAttr1 = request.getParameter("queryAttr1");
            String queryAttr1_value = request.getParameter("queryAttr1_value");
            String start_exit_time = request.getParameter("start_exit_time");
            String end_exit_time = request.getParameter("end_exit_time");
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            String tableName = commonDaoService.getTableName(CarparkPassRecord.class);
            SearchParam sp = new SearchParam();
            if (queryAttr1 != null && (queryAttr1 = queryAttr1.trim()).length() > 0 && queryAttr1_value != null && (queryAttr1_value = queryAttr1_value.trim()).length() > 0) {
                if ("exit_plate".equals(queryAttr1)) {
                    String v2 = queryAttr1_value.toUpperCase();
                    v2 = v2.replaceAll("\u3000", "");
                    v2 = v2.replaceAll(" ", "");
                    v2 = v2.replaceAll("I", "1");
                    if ((v2 = v2.replaceAll("O", "0")).length() > 0) {
                        sp.addLike(queryAttr1, v2);
                    }
                } else {
                    sp.addLike(queryAttr1, queryAttr1_value);
                }
            }
            sp.addNotEQ("exit_time", null);
            if (area_no != null && (area_no = area_no.trim()).length() > 0) {
                sp.addEQ("area_no", (Object)area_no);
            }
            if (exit_channel_no != null && (exit_channel_no = exit_channel_no.trim()).length() > 0) {
                sp.addEQ("exit_channel_no", (Object)exit_channel_no);
            }
            if (passport_type_no != null && (passport_type_no = passport_type_no.trim()).length() > 0) {
                sp.addEQ("passport_type_no", (Object)passport_type_no);
            }
            if (exit_car_type_no != null && (exit_car_type_no = exit_car_type_no.trim()).length() > 0) {
                sp.addEQ("exit_car_type_no", (Object)exit_car_type_no);
            }
            if (exit_host_no != null && (exit_host_no = exit_host_no.trim()).length() > 0) {
                sp.addEQ("exit_host_no", (Object)exit_host_no);
            }
            if (exit_duty_user_code != null && (exit_duty_user_code = exit_duty_user_code.trim()).length() > 0) {
                sp.addEQ("exit_duty_user_code", (Object)exit_duty_user_code);
            }
            if (discount_merchant_no != null && (discount_merchant_no = discount_merchant_no.trim()).length() > 0) {
                sp.addEQ("discount_merchant_no", (Object)discount_merchant_no);
            }
            if (discount_project_no != null && (discount_project_no = discount_project_no.trim()).length() > 0 && !"ALL".equals(discount_project_no)) {
                sp.addEQ("discount_project_no", (Object)discount_project_no);
            }
            if (start_exit_time != null && start_exit_time.length() > 0) {
                sp.addGTE("pass_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(start_exit_time));
            }
            if (end_exit_time != null && end_exit_time.length() > 0) {
                sp.addLTE("pass_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(end_exit_time));
            }
            if (queryAttr2 != null && (queryAttr2 = queryAttr2.trim()).length() > 0) {
                if (start_money != null && (start_money = start_money.trim()).length() > 0) {
                    try {
                        BigDecimal d1 = new BigDecimal(start_money).setScale(2, 4);
                        sp.addGTE(queryAttr2, (Object)d1);
                    }
                    catch (Exception d1) {
                        // empty catch block
                    }
                }
                if (end_money != null && (end_money = end_money.trim()).length() > 0) {
                    try {
                        BigDecimal d2 = new BigDecimal(end_money).setScale(2, 4);
                        sp.addLTE(queryAttr2, (Object)d2);
                    }
                    catch (Exception d2) {
                        // empty catch block
                    }
                }
            }
            boolean isCancelRecord = false;
            if (record_des != null && (record_des = record_des.trim()).length() > 0 && (v = Integer.valueOf(record_des)) != null) {
                if (v == 1) {
                    sp.addEQ("enter_time", null);
                } else if (v == 2) {
                    sp.addEQ("record_state", (Object)2);
                } else if (v == 3) {
                    sp.addEQ("enter_plate_source", (Object)1);
                } else if (v == 4) {
                    sp.addEQ("enter_plate_source", (Object)2);
                } else if (v == 5) {
                    sp.addEQ("enter_plate_source", (Object)4);
                } else if (v == 6) {
                    sp.addEQ("exit_plate_source", (Object)1);
                } else if (v == 7) {
                    sp.addEQ("exit_plate_source", (Object)2);
                } else if (v == 8) {
                    sp.addEQ("exit_plate_source", (Object)4);
                } else if (v == 9) {
                    sp.addNotEQ("certificate_pic", null);
                } else if (v == 10) {
                    sp.addNotEQ("remove_enter_time", null);
                } else if (v == 11) {
                    tableName = commonDaoService.getTableName(CarparkCancelPassRecord.class);
                    isCancelRecord = true;
                }
            }
            sp.setTableName(tableName);
            if ("query".equals(op)) {
                String sortOrder = request.getParameter("sortOrder");
                String sortName = request.getParameter("sortName");
                if (sortName != null && (sortName = sortName.trim()).length() > 0 && sortOrder != null && (sortOrder = sortOrder.trim()).length() > 0) {
                    sp.setOrder_by((String.valueOf(sortName) + " " + sortOrder).replaceAll("'", ""));
                } else {
                    sp.setOrder_by("pass_time desc");
                }
                Pagination p = WebUtil.getPagination(request);
                List dataList = commonDaoService.selectList(sp, p);
                ArrayList<Map> resultList = new ArrayList<Map>(dataList == null ? 0 : dataList.size());
                if (dataList != null && !dataList.isEmpty()) {
                    for (Map data : dataList) {
                        String exit_plate_pic = (String)data.get("exit_plate_pic");
                        String hostNo = (String)data.get("exit_host_no");
                        data.put("exit_plate_pic", CarparkRecordSearchAction.getPicUri(request.getContextPath(), exit_plate_pic, hostNo, true));
                        String v2 = null;
                        if (isCancelRecord) {
                            v2 = "\u53d6\u6d88\u653e\u884c";
                        } else {
                            if (data.get("remove_enter_time") != null) {
                                v2 = "\u5728\u573a\u8f66\u8f86\u88ab\u79fb\u9664";
                            } else if (data.get("enter_time") == null) {
                                v2 = "\u65e0\u573a\u5185\u8bb0\u5f55";
                            } else {
                                Integer record_state = (Integer)data.get("record_state");
                                if (record_state != null && record_state == 2) {
                                    v2 = "\u51fa\u5165\u8f66\u724c\u4e0d\u4e00\u81f4";
                                } else {
                                    String certificate_pic = (String)data.get("certificate_pic");
                                    if (certificate_pic != null && certificate_pic.length() > 0) {
                                        v2 = "\u8bc1\u4ef6\u6293\u62cd";
                                    } else {
                                        Integer exit_plate_source = (Integer)data.get("exit_plate_source");
                                        Integer enter_plate_source = (Integer)data.get("enter_plate_source");
                                        if (exit_plate_source != null) {
                                            if (exit_plate_source == 1) {
                                                v2 = "\u51fa\u573a\u4eba\u5de5\u653e\u884c";
                                            } else if (exit_plate_source == 2) {
                                                v2 = "\u51fa\u573a\u4eba\u5de5\u4fee\u6539\u8f66\u724c";
                                            } else if (exit_plate_source == 4) {
                                                v2 = "\u51fa\u573a\u6a21\u7cca\u5339\u914d";
                                            } else {
                                                if (exit_plate_source == 0) {
                                                    v2 = "\u8f66\u724c\u8bc6\u522b";
                                                } else if (exit_plate_source == 3) {
                                                    v2 = "ETC";
                                                }
                                                if (enter_plate_source != null) {
                                                    if (enter_plate_source == 1) {
                                                        v2 = "\u5165\u573a\u4eba\u5de5\u653e\u884c";
                                                    } else if (enter_plate_source == 2) {
                                                        v2 = "\u4eba\u5de5\u4fee\u6539\u5165\u573a\u8f66\u724c";
                                                    } else if (enter_plate_source == 4) {
                                                        v2 = "\u5165\u573a\u6a21\u7cca\u5339\u914d";
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (v2 == null) {
                                v2 = "";
                            }
                        }
                        data.put("record_des", v2);
                        String car_owner_name = ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("car_owner_name", (String)data.get("car_owner_name"), request);
                        String car_owner_addr = ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("address", (String)data.get("car_owner_addr"), request);
                        if (car_owner_name != null && car_owner_name.length() > 0) {
                            data.put("car_owner_name", car_owner_name);
                        }
                        if (car_owner_addr != null && car_owner_addr.length() > 0) {
                            data.put("car_owner_addr", car_owner_addr);
                        }
                        resultList.add(JavaBeanUtil.toStringMap((Object)data));
                    }
                }
                HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
                resMap.put("rows", resultList);
                resMap.put("total", Long.valueOf(p.getRecordsCount()));
                WebUtil.printFinshJson(response, GsonBuilder.create().toJson(resMap));
                return;
            }
            if ("queryTotalMoney".equals(op)) {
                sp.setQueryFields(new String[]{"SUM(exit_should_charge) AS exit_should_charge_total", "SUM(period_multi_free) AS period_multi_free_total", "SUM(discount_money) AS discount_money_total", "SUM(already_paid) AS already_paid_total", "SUM(cash_pay) AS cash_pay_total", "SUM(deduct_money) AS deduct_money"});
                HashMap<String, String> totalMoneyMap = commonDaoService.selectOne(sp);
                if (totalMoneyMap == null) {
                    totalMoneyMap = new HashMap<String, String>();
                }
                String[] s1 = new String[]{"exit_should_charge_total", "period_multi_free_total", "discount_money_total", "already_paid_total", "cash_pay_total", "deduct_money"};
                NumberFormat sf = NumberFormat.getCurrencyInstance(Locale.CHINA);
                String[] stringArray = s1;
                int n = s1.length;
                int resultList = 0;
                while (resultList < n) {
                    String s = stringArray[resultList];
                    BigDecimal d = (BigDecimal)totalMoneyMap.get(s);
                    if (d == null) {
                        d = Constants.MONEY_ZERO;
                    }
                    totalMoneyMap.put(s, sf.format(d));
                    ++resultList;
                }
                request.setAttribute("totalMoneyMap", totalMoneyMap);
                WebUtil.dispathTemplatePage("report/exitPassRecord", request, response);
                return;
            }
            LinkedHashMap<String, String> headAtrrMap = new LinkedHashMap<String, String>();
            headAtrrMap.put("enter_time", "\u5165\u573a\u65f6\u95f4");
            headAtrrMap.put("enter_plate", "\u5165\u573a\u8f66\u724c");
            headAtrrMap.put("enter_plate_source", "\u5165\u573a\u65b9\u5f0f");
            headAtrrMap.put("enter_channel_name", "\u5165\u573a\u901a\u9053");
            headAtrrMap.put("enter_host_name", "\u5165\u573a\u5c97\u4ead\u4e3b\u673a");
            headAtrrMap.put("enter_duty_user_name", "\u5165\u573a\u503c\u73ed\u5458");
            headAtrrMap.put("exit_time", "\u51fa\u573a\u65f6\u95f4");
            headAtrrMap.put("exit_plate", "\u51fa\u573a\u8f66\u724c");
            headAtrrMap.put("exit_plate_source", "\u51fa\u573a\u65b9\u5f0f");
            headAtrrMap.put("exit_channel_name", "\u51fa\u573a\u901a\u9053");
            headAtrrMap.put("exit_host_name", "\u51fa\u573a\u5c97\u4ead\u4e3b\u673a");
            headAtrrMap.put("exit_duty_user_name", "\u51fa\u573a\u503c\u73ed\u5458");
            headAtrrMap.put("exit_remark", "\u51fa\u573a\u5907\u6ce8");
            headAtrrMap.put("area_name", "\u51fa\u573a\u533a\u57df");
            headAtrrMap.put("passport_type_name", "\u8f66\u724c\u7c7b\u578b");
            headAtrrMap.put("exit_car_type_name", "\u8f66\u8f86\u7c7b\u578b");
            headAtrrMap.put("car_owner_name", "\u8f66\u4e3b\u59d3\u540d");
            headAtrrMap.put("car_owner_addr", "\u8f66\u4e3b\u4f4f\u5740");
            headAtrrMap.put("enter_valid_date", "\u5165\u573a\u65f6\u6709\u6548\u671f");
            headAtrrMap.put("enter_balance", "\u5165\u573a\u65f6\u4f59\u989d");
            headAtrrMap.put("exit_valid_date", "\u51fa\u573a\u65f6\u6709\u6548\u671f");
            headAtrrMap.put("exit_balance", "\u51fa\u573a\u65f6\u4f59\u989d");
            headAtrrMap.put("discount_times", "\u6253\u6298\u6b21\u6570");
            headAtrrMap.put("discount_project_name", "\u6298\u6263\u540d\u79f0/\u9879\u76ee");
            headAtrrMap.put("discount_merchant_name", "\u6253\u6298\u5546\u6237");
            headAtrrMap.put("discount_des", "\u6298\u6263\u63cf\u8ff0");
            headAtrrMap.put("discount_source", "\u6253\u6298\u573a\u666f");
            headAtrrMap.put("discount_time", "\u6253\u6298\u65f6\u95f4");
            headAtrrMap.put("parkTimeLen", "\u505c\u8f66\u65f6\u957f");
            headAtrrMap.put("exit_fee_time_length", "\u8ba1\u8d39\u65f6\u957f");
            headAtrrMap.put("exit_should_charge", "\u5e94\u6536\u91d1\u989d");
            headAtrrMap.put("period_multi_free", "\u5468\u671f\u4f18\u60e0\u91d1\u989d");
            headAtrrMap.put("discount_money", "\u6298\u6263\u4f18\u60e0\u91d1\u989d");
            headAtrrMap.put("already_paid", "\u573a\u5185\u652f\u4ed8/\u81ea\u52a9\u7f34\u8d39/\u626b\u7801\u652f\u4ed8");
            headAtrrMap.put("cash_pay", "\u51fa\u53e3\u73b0\u91d1");
            headAtrrMap.put("deduct_money", "\u51fa\u53e3\u6263\u8d39(\u50a8\u503c\u8f66)");
            ExportService exportService = (ExportService)ServiceUtil.getServiceContext().getService(ExportService.class);
            response.setContentType("text/plain; charset=GBK");
            response.setCharacterEncoding("GBK");
            SimpleDateFormat df11 = new SimpleDateFormat("yyyyMMddHHmmss");
            String f = isCancelRecord ? "cancelRecord_" : "exitRecord_";
            response.addHeader("Content-Disposition", "attachment;filename=" + f + df11.format(new Date()) + ".csv");
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            try (PrintWriter out = response.getWriter();){
                exportService.exportExitRecordCsv(sp, headAtrrMap, out);
                return;
            }
        }
        if ("obtianPros".equals(op)) {
            String discount_merchant_no = request.getParameter("discount_merchant_no");
            if (discount_merchant_no == null || discount_merchant_no.length() == 0) {
                return;
            }
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            LinkedList<KeyValueEntry> proList = new LinkedList<KeyValueEntry>();
            if ("0".equals(discount_merchant_no)) {
                Map<String, CarparkDiscountProject> dmap = ServiceUtil.getServiceContext().getDBConfigCache().getDiscountProjectMap();
                if (dmap != null && !dmap.isEmpty()) {
                    for (CarparkDiscountProject p : dmap.values()) {
                        proList.add(new KeyValueEntry((Object)p.getDiscount_project_no(), (Object)p.getDiscount_project_name()));
                    }
                }
                proList.add(new KeyValueEntry((Object)"certificates_free", (Object)"\u8bc1\u4ef6\u6293\u62cd\u514d\u8d39"));
            } else {
                List proList0 = commonDaoService.selectList(new SearchParam().addEQ("merchant_no", (Object)discount_merchant_no), CarparkMerchantCouponProj.class, null);
                if (proList0 != null && !proList0.isEmpty()) {
                    for (CarparkMerchantCouponProj p : proList0) {
                        proList.add(new KeyValueEntry((Object)p.getCoupon_proj_no(), (Object)p.getCoupon_proj_name()));
                    }
                }
            }
            HashMap<String, LinkedList<KeyValueEntry>> dataMap = new HashMap<String, LinkedList<KeyValueEntry>>();
            dataMap.put("proList", proList);
            WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", dataMap, response);
            return;
        } else {
            String certificate_pic;
            if (!"showDetail".equals(op)) return;
            Long id = Long.valueOf(request.getParameter("id"));
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            String tableName = commonDaoService.getTableName(CarparkPassRecord.class);
            boolean canceled = "1".equals(request.getParameter("cancelRecord"));
            if (canceled) {
                tableName = commonDaoService.getTableName(CarparkCancelPassRecord.class);
            }
            SearchParam sp = new SearchParam(tableName);
            sp.addEQ("id", (Object)id);
            Map record = commonDaoService.selectOne(sp);
            if (record == null) {
                WebUtil.printFinshHtml(response, "404notfound");
                return;
            }
            String car_owner_name = ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("car_owner_name", (String)record.get("car_owner_name"), request);
            String car_owner_addr = ServiceUtil.getServiceContext().getHideSensitiveInfo().getWebSensitiveValue("address", (String)record.get("car_owner_addr"), request);
            if (car_owner_name != null && car_owner_name.length() > 0) {
                record.put("car_owner_name", car_owner_name);
            }
            if (car_owner_addr != null && car_owner_addr.length() > 0) {
                record.put("car_owner_addr", car_owner_addr);
            }
            String enter_car_pic = (String)record.get("enter_car_pic");
            String enter_plate_pic = (String)record.get("enter_plate_pic");
            String hostNo = (String)record.get("enter_host_no");
            record.put("enter_car_pic", CarparkRecordSearchAction.getPicUri(request.getContextPath(), enter_car_pic, hostNo, true));
            if (enter_plate_pic != null && enter_plate_pic.length() > 0) {
                record.put("enter_plate_pic", CarparkRecordSearchAction.getPicUri(request.getContextPath(), enter_plate_pic, hostNo, false));
            }
            String exit_car_pic = (String)record.get("exit_car_pic");
            String exit_plate_pic = (String)record.get("exit_plate_pic");
            hostNo = (String)record.get("exit_host_no");
            record.put("exit_car_pic", CarparkRecordSearchAction.getPicUri(request.getContextPath(), exit_car_pic, hostNo, true));
            if (exit_plate_pic != null && exit_plate_pic.length() > 0) {
                record.put("exit_plate_pic", CarparkRecordSearchAction.getPicUri(request.getContextPath(), exit_plate_pic, hostNo, false));
            }
            if ((certificate_pic = (String)record.get("certificate_pic")) != null && certificate_pic.length() > 0) {
                record.put("certificate_pic", CarparkRecordSearchAction.getPicUri(request.getContextPath(), certificate_pic, hostNo, true));
            }
            CarparkPassRecord passRecord = (CarparkPassRecord)new JavaBeanMap((Object)record).toJavaBean(CarparkPassRecord.class);
            String[] enterPlateLabel = new String[]{passRecord.getEnter_plate()};
            record.put("enter_pass_info", this.getEnterPassInfo(passRecord, enterPlateLabel));
            if (passRecord.getEnter_plate() != null) {
                record.put("enter_plate", enterPlateLabel[0]);
            }
            String[] exitPlateLabel = new String[]{passRecord.getExit_plate()};
            record.put("exit_pass_info", this.getExitPassInfo(passRecord, exitPlateLabel));
            if (passRecord.getExit_plate() != null) {
                record.put("exit_plate", exitPlateLabel[0]);
            }
            record.put("parkingTimeLen", this.getParkingTimeLen(passRecord));
            record.put("exceptionInfo", this.getExceptionInfo(passRecord));
            record.put("carInfo", this.getCarInfo(passRecord));
            if (passRecord.getArea_level() != null && passRecord.getArea_level() == 1) {
                String[] lineTip1 = new String[1];
                String line1 = this.getChageInfo(passRecord, lineTip1);
                if (line1 != null && line1.length() > 0) {
                    record.put("line1", line1);
                }
                if (lineTip1[0] != null && lineTip1[0].length() > 0) {
                    record.put("lineTip1", lineTip1[0]);
                }
                if (passRecord.getPeriod_multi_start() != null && passRecord.getNext_period_multi_cur() != null) {
                    record.put("line2", this.getPeriodChageInfo(passRecord));
                }
                if (passRecord.getDiscount_times() != null && passRecord.getDiscount_times() > 0) {
                    if (passRecord.getDiscount_times() == 1) {
                        record.put("line3", this.getDicountInfo(passRecord));
                    } else {
                        String line3 = this.getDiscountListDes(this.getDiscoutList(passRecord));
                        if (line3 != null && line3.length() > 0) {
                            record.put("line3", line3);
                        }
                    }
                }
                if (passRecord.getAlready_paid() != null && passRecord.getAlready_paid().doubleValue() > 0.0) {
                    if (passRecord.getAlready_paid_times() != null && passRecord.getAlready_paid_times() == 1) {
                        record.put("line4", this.getSelfPayInfo(passRecord));
                    } else {
                        String line4 = this.getSelfPayListDes(this.getTranscaList(passRecord));
                        if (line4 != null && line4.length() > 0) {
                            record.put("line4", line4);
                        }
                    }
                }
            }
            if (passRecord.getEnter_time() == null && passRecord.getRemove_enter_time() != null) {
                StringBuilder sbr = new StringBuilder(128);
                sbr.append("\u53ef\u80fd\u7531\u3010").append(passRecord.getRemove_user_name()).append("\u3011\u5220\u9664\u5728\u573a\u8f66\u8f86 ").append(passRecord.getPass_plate()).append("\u5bfc\u81f4\uff01");
                sbr.append("\u5165\u573a\u65f6\u95f4\uff1a").append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(passRecord.getRemove_enter_time()));
                if (passRecord.getRemove_op_time() != null) {
                    sbr.append("\uff0c\u5220\u9664\u65f6\u95f4\uff1a").append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(passRecord.getRemove_op_time()));
                }
                record.put("line5", sbr.toString());
            }
            if (canceled) {
                record.put("line6", "\u8bb0\u5f55\u672a\u751f\u6548\uff0c\u539f\u56e0\uff1a\u64cd\u4f5c\u5458\u5728\u5f39\u6846\u6536\u8d39\u7684\u65f6\u5019\u53d6\u6d88\u653e\u884c\uff01");
            }
            request.setAttribute("record", (Object)record);
            WebUtil.dispathTemplatePage("report/exitPassRecord", request, response);
            return;
        }
    }

    private String getSelfPayListDes(List<CarparkTransaction> transactionList) {
        if (transactionList == null || transactionList.isEmpty()) {
            return null;
        }
        StringBuilder sbr = new StringBuilder(128);
        char z = '\uff0c';
        char x = '\u3001';
        for (CarparkTransaction t : transactionList) {
            if (t.getPay_method() == 0 && t.getPay_scene() == 0 || t.getPay_method() == 1 && t.getPay_scene() == 0) continue;
            if (sbr.length() > 0) {
                sbr.append(x);
            }
            sbr.append('[');
            String payMethod = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(t.getPay_method());
            String payScene = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap().get(t.getPay_scene());
            String payOrg = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap().get(t.getCharge_org());
            sbr.append(payMethod).append('\uff1a').append(t.getTran_money());
            if (payScene != null && payScene.length() > 0) {
                sbr.append(z).append(payScene);
            }
            if (payOrg != null && payOrg.length() > 0) {
                sbr.append(z).append(payOrg);
            }
            if (t.getTran_time() != null) {
                sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(t.getTran_time()));
            }
            sbr.append(']');
        }
        String v = sbr.toString();
        return "\u573a\u5185\u5df2\u652f\u4ed8\u660e\u7ec6\uff1a" + v;
    }

    private List<CarparkTransaction> getTranscaList(CarparkPassRecord record) {
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        Integer carparkId = ServiceUtil.getServiceContext().getCarparkId();
        List transactionList0 = null;
        SearchParam sp = new SearchParam();
        sp.addEQ("passport_number", (Object)record.getPassport_number());
        if (record.getMedium_type() != null) {
            sp.addEQ("medium_type", (Object)record.getMedium_type());
        }
        sp.addEQ("enter_time", (Object)record.getEnter_time()).addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)carparkId);
        sp.addEQ("service_type", (Object)0);
        sp.setOrerbySql("tran_time");
        transactionList0 = daoService.selectList(sp, CarparkTransaction.class, null);
        return transactionList0;
    }

    private String getSelfPayInfo(CarparkPassRecord record) {
        StringBuilder sbr = new StringBuilder(128);
        char z = '\uff0c';
        sbr.append("\u573a\u5185\u5df2\u652f\u4ed8\u660e\u7ec6\uff1a").append('[');
        String payMethod = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(record.getAlready_paid_method());
        String payScene = ServiceUtil.getServiceContext().getDBConfigCache().getPaySceneMap().get(record.getAlready_paid_scene());
        String payOrg = ServiceUtil.getServiceContext().getDBConfigCache().getChargeOrgMap().get(record.getAlready_paid_charge_org());
        sbr.append(payMethod).append('\uff1a').append(record.getAlready_paid());
        if (payScene != null && payScene.length() > 0) {
            sbr.append(z).append(payScene);
        }
        if (payOrg != null && payOrg.length() > 0) {
            sbr.append(z).append(payOrg);
        }
        if (record.getAlready_paid_time() != null) {
            sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(record.getAlready_paid_time()));
        }
        sbr.append(']');
        return sbr.toString();
    }

    private String getDiscountListDes(List<CarparkDiscountRecord> discountList) {
        if (discountList == null || discountList.isEmpty()) {
            return null;
        }
        StringBuilder sbr = new StringBuilder(128);
        char z = '\uff0c';
        String x = "\u3001";
        for (CarparkDiscountRecord d : discountList) {
            if (sbr.length() > 0) {
                sbr.append(x);
            }
            sbr.append('[');
            sbr.append(d.getDiscount_project_name());
            if (d.getDiscount_method() != null && d.getDiscount_value() != null) {
                ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                sbr.append('(').append(appService.getDiscountValueDes(d.getDiscount_method(), d.getDiscount_value())).append(')');
            }
            if (d.getDiscount_merchant_no() != null && d.getDiscount_merchant_no().length() > 0) {
                if ("0".equals(d.getDiscount_merchant_no()) && "\u8f66\u573a\u7ba1\u7406".equals(d.getDiscount_merchant_name())) {
                    if (d.getDiscount_source() != null) {
                        if (d.getDiscount_source() == 1) {
                            sbr.append(z).append("\u7ba1\u7406\u5904\u6253\u6298");
                            if (d.getDiscount_time() != null) {
                                sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(d.getDiscount_time()));
                            }
                        } else if (d.getDiscount_source() == 0) {
                            sbr.append(z).append("\u79bb\u573a\u5c97\u4ead\u5904\u6253\u6298");
                        } else {
                            sbr.append(z).append("\u7ba1\u7406\u5458\u4e91\u7aef\u6253\u6298");
                            if (d.getDiscount_time() != null) {
                                sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(d.getDiscount_time()));
                            }
                        }
                    } else {
                        sbr.append(z).append("\u8f66\u573a\u7ba1\u7406");
                    }
                } else {
                    sbr.append(z).append(d.getDiscount_merchant_name()).append("\u6253\u6298");
                    if (d.getDiscount_time() != null) {
                        sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(d.getDiscount_time()));
                    }
                }
            }
            sbr.append(']');
        }
        String v = sbr.toString();
        return "\u6298\u6263\u660e\u7ec6\uff1a" + v;
    }

    private List<CarparkDiscountRecord> getDiscoutList(CarparkPassRecord record) {
        List discouList0 = null;
        CommonDaoService daoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer projectId = ServiceUtil.getServiceContext().getProjectId();
        Integer carparkId = ServiceUtil.getServiceContext().getCarparkId();
        Calendar cl = Calendar.getInstance();
        cl.set(2018, 0, 1, 0, 0, 0);
        cl.set(14, 0);
        int minute = (int)TimeUnit.MILLISECONDS.toMinutes(record.getEnter_time().getTime() - cl.getTimeInMillis());
        SearchParam sp = new SearchParam().addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)carparkId).addEQ("passport_number", (Object)record.getPassport_number()).addLT("enter_time", (Object)record.getEnter_time()).addEQ("discount_method", (Object)3).addGT("discount_value", (Object)minute);
        sp.setOrerbySql("discount_time");
        if (record.getMedium_type() != null) {
            sp.addEQ("medium_type", (Object)record.getMedium_type());
        }
        discouList0 = daoService.selectList(sp, CarparkDiscountRecord.class, null);
        sp = new SearchParam();
        sp.addEQ("passport_number", (Object)record.getPassport_number());
        if (record.getMedium_type() != null) {
            sp.addEQ("medium_type", (Object)record.getMedium_type());
        }
        sp.addEQ("enter_time", (Object)record.getEnter_time()).addEQ("project_id", (Object)projectId).addEQ("carpark_id", (Object)carparkId);
        sp.setOrerbySql("discount_time");
        List l = daoService.selectList(sp, CarparkDiscountRecord.class, null);
        if (l != null && !l.isEmpty()) {
            if (discouList0 == null || discouList0.isEmpty()) {
                discouList0 = l;
            } else {
                discouList0.addAll(l);
            }
        }
        return discouList0;
    }

    private String getDicountInfo(CarparkPassRecord record) {
        StringBuilder sbr = new StringBuilder(128);
        char z = '\uff0c';
        sbr.append("\u6298\u6263\u660e\u7ec6\uff1a").append('[');
        sbr.append(record.getDiscount_project_name());
        if (record.getDiscount_method() != null && record.getDiscount_value() != null) {
            ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            sbr.append('(').append(appService.getDiscountValueDes(record.getDiscount_method(), record.getDiscount_value())).append(')');
        }
        if (record.getDiscount_merchant_no() != null && record.getDiscount_merchant_no().length() > 0) {
            if ("0".equals(record.getDiscount_merchant_no()) && "\u8f66\u573a\u7ba1\u7406".equals(record.getDiscount_merchant_name())) {
                if (record.getDiscount_source() != null) {
                    if (record.getDiscount_source() == 1) {
                        sbr.append(z).append("\u7ba1\u7406\u5904\u6253\u6298");
                        if (record.getDiscount_time() != null) {
                            sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(record.getDiscount_time()));
                        }
                    } else if (record.getDiscount_source() == 0) {
                        sbr.append(z).append("\u79bb\u573a\u5c97\u4ead\u5904\u6253\u6298");
                    } else {
                        sbr.append(z).append("\u7ba1\u7406\u5458\u4e91\u7aef\u6253\u6298");
                        if (record.getDiscount_time() != null) {
                            sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(record.getDiscount_time()));
                        }
                    }
                } else {
                    sbr.append(z).append("\u8f66\u573a\u7ba1\u7406");
                }
            } else {
                String vd = record.getDiscount_merchant_name();
                if (vd == null) {
                    vd = "";
                }
                sbr.append(z).append(vd).append("\u6253\u6298");
                if (record.getDiscount_time() != null) {
                    sbr.append(z).append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(record.getDiscount_time()));
                }
            }
        }
        sbr.append(']');
        return sbr.toString();
    }

    private String getPeriodChageInfo(CarparkPassRecord record) {
        if (record.getPeriod_multi_start() == null || record.getNext_period_multi_start() == null) {
            return null;
        }
        StringBuilder sbr = new StringBuilder(128);
        char z = '\u3001';
        SimpleDateFormat df = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
        sbr.append("\u5468\u671f\u5f00\u59cb\uff1a").append(df.format(record.getPeriod_multi_start()));
        sbr.append(z).append("\u4e4b\u524d\u5df2\u6536\uff1a").append(record.getPeriod_multi_received() == null ? Constants.MONEY_ZERO : record.getPeriod_multi_received());
        if (record.getPeriod_multi_start().getTime() != record.getNext_period_multi_start().getTime()) {
            sbr.append(z).append("\u672c\u6b21\u4f18\u60e0\uff1a").append(record.getPeriod_multi_free() == null ? Constants.MONEY_ZERO : record.getPeriod_multi_free());
            sbr.append(z).append("\u65b0\u5468\u671f\u5f00\u59cb\uff1a").append(df.format(record.getNext_period_multi_start()));
            sbr.append(z).append("\u65b0\u5468\u671f\u7d2f\u8ba1\uff1a").append(record.getNext_period_multi_cur() == null ? Constants.MONEY_ZERO : record.getNext_period_multi_cur());
        } else {
            sbr.append(z).append("\u672c\u6b21\u7d2f\u8ba1\uff1a").append(record.getNext_period_multi_cur() == null ? Constants.MONEY_ZERO : record.getNext_period_multi_cur());
            sbr.append(z).append("\u672c\u6b21\u4f18\u60e0\uff1a").append(record.getPeriod_multi_free() == null ? Constants.MONEY_ZERO : record.getPeriod_multi_free());
        }
        String v = sbr.toString();
        return v;
    }

    private String getChageInfo(CarparkPassRecord record, String[] lineTip) {
        StringBuilder sbr = new StringBuilder(128);
        char z = '\u3001';
        sbr.append("\u51fa\u573a\u5e94\u6536\uff1a");
        BigDecimal should = record.getExit_should_charge();
        if (should == null) {
            should = Constants.MONEY_ZERO;
        }
        sbr.append(should);
        BigDecimal f = record.getPeriod_multi_free();
        if (f != null && f.doubleValue() > 0.0) {
            sbr.append(z).append("\u5468\u671f\u4f18\u60e0\uff1a").append(f);
        } else if (record.getPeriod_multi_start() != null && record.getNext_period_multi_cur() != null) {
            sbr.append(z).append("\u5468\u671f\u4f18\u60e0\uff1a0.00");
        }
        if (record.getDiscount_money() != null && record.getDiscount_money().doubleValue() > 0.0) {
            sbr.append(z).append("\u6298\u6263\u51cf\u514d\uff1a").append(record.getDiscount_money());
        }
        boolean ax = false;
        if (record.getAlready_paid() != null && record.getAlready_paid().doubleValue() > 0.0) {
            sbr.append(z).append("\u573a\u5185\u5df2\u4ed8\uff1a").append(record.getAlready_paid());
            ax = true;
        }
        if (record.getCash_pay() != null && record.getCash_pay().doubleValue() > 0.0) {
            sbr.append(z).append("\u51fa\u53e3\u73b0\u91d1\uff1a").append(record.getCash_pay());
            ax = true;
        }
        if (record.getDeduct_money() != null && record.getDeduct_money().doubleValue() > 0.0) {
            sbr.append(z).append("\u51fa\u53e3\u6263\u8d39\uff1a").append(record.getDeduct_money());
            ax = true;
        }
        if (!ax) {
            sbr.append(z).append("\u5b9e\u6536\u91d1\u989d\uff1a0.00");
        }
        if (record.getEnter_time() != null) {
            ApplicationService appService;
            if (record.getExit_fee_time_length() != null) {
                appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                sbr.append("\uff1b").append("\u8ba1\u8d39\u65f6\u957f\uff1a");
                sbr.append(appService.getTimeLenDes(record.getExit_fee_time_length()));
                if (record.getExit_fee_start_time() != null && record.getExit_fee_start_time().getTime() != record.getEnter_time().getTime()) {
                    sbr.append(z).append("\u8ba1\u8d39\u5f00\u59cb\uff1a").append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(record.getExit_fee_start_time()));
                    if (record.getTake_plate_number() != null && record.getTake_plate_number().length() > 0) {
                        sbr.append("(").append(record.getTake_plate_number()).append(")");
                    }
                }
            }
            if (record.getTake_plate_number() != null && record.getTake_plate_number().length() > 0 && record.getTake_enter_time() != null) {
                StringBuilder b1 = new StringBuilder(128);
                b1.append("\u4ece\u8f66\u724c\u3010").append(record.getTake_plate_number());
                b1.append("\u3011\u7684\u5165\u573a\u65f6\u95f4\u3010").append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(record.getTake_enter_time()));
                b1.append("\u3011\u5f00\u59cb\u5360\u7528\u4e34\u505c\u8f66\u4f4d\uff0c\u5e76\u5f00\u59cb\u8ba1\u8d39\u3002");
                lineTip[0] = b1.toString();
            } else if (record.getOccupy_end_time() != null && record.getOccupy_plate() != null && record.getOccupy_plate().length() > 0 && record.getOccupy_passport_type_no() != null && record.getOccupy_passport_type_no().length() > 0 && !record.getOccupy_passport_type_no().equals(record.getPassport_type_no())) {
                appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                StringBuilder b1 = new StringBuilder(128);
                if (!record.getOccupy_plate().equals(record.getPass_plate())) {
                    b1.append("\u672c\u8f66\u5165\u573a\u65f6, ").append(record.getOccupy_plate()).append("\u5df2\u7ecf\u5360\u7528\u8f66\u4f4d: ").append(record.getPassport_type_name()).append(", ");
                }
                CarparkPassportType passportType = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap().get(record.getOccupy_passport_type_no());
                int tpsec = (int)TimeUnit.MILLISECONDS.toSeconds(record.getOccupy_end_time().getTime() - record.getEnter_time().getTime());
                String dsc = appService.getTimeLenSecDes(tpsec);
                if (passportType != null) {
                    if (passportType.getPass_type() == 0) {
                        b1.append("\u672c\u8f66\u5360\u7528\u4e34\u505c(" + passportType.getPassport_type_name() + ")\u8f66\u4f4d\u65f6\u957f\uff1a").append(dsc);
                    } else {
                        b1.append("\u672c\u8f66\u4e3a(" + passportType.getPassport_type_name() + ")\u65f6\u957f\uff1a").append(dsc);
                    }
                } else {
                    b1.append("\u672c\u8f66\u5360\u7528\u8f66\u4f4d\u65f6\u957f\uff1a").append(dsc);
                }
                b1.append(", \u622a\u6b62\u65f6\u95f4\uff1a").append(new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(record.getEnter_time()));
                lineTip[0] = b1.toString();
            }
        }
        return sbr.toString();
    }

    private String getCarInfo(CarparkPassRecord record) {
        StringBuilder sbr = new StringBuilder(128);
        char z = '\u3001';
        sbr.append("\u8f66\u8f86\u4fe1\u606f\uff1a");
        if (record.getMedium_type() != null && record.getMedium_type() != 6) {
            sbr.append(record.getPassport_number()).append(z);
        }
        sbr.append(record.getPassport_type_name());
        if (record.getExit_car_type_name() != null && record.getExit_car_type_name().length() > 0) {
            sbr.append(z).append(record.getExit_car_type_name());
        }
        if (record.getPlate_color() != null && record.getPlate_color().length() > 0) {
            sbr.append(z).append(record.getPlate_color()).append("\u724c\u8f66");
        }
        if (record.getExit_valid_date() != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            sbr.append(z).append("\u51fa\u573a\u6709\u6548\u671f\uff1a").append(df.format(record.getExit_valid_date()));
        }
        if (record.getPass_type() != null && record.getPass_type() == 1 && record.getExit_balance() != null) {
            sbr.append(z).append("\u51fa\u573a\u65f6\u4f59\u989d\uff1a").append(record.getExit_balance());
        }
        String v = "";
        Integer pass_state_value = record.getPass_state_value();
        if (pass_state_value != null && pass_state_value > 0) {
            if (pass_state_value == 6) {
                v = "\u9ed1\u540d\u5355\u8f66";
            } else if (pass_state_value == 7) {
                v = "\u672a\u542f\u7528";
            } else if (pass_state_value == 8) {
                v = "\u5df2\u505c\u7528";
            } else if (pass_state_value == 4) {
                v = "\u5df2\u8fc7\u671f";
            } else if (pass_state_value == 1) {
                v = "\u65e0\u6743\u9650";
            } else if (pass_state_value == 9) {
                v = "\u5339\u914d\u4e0a\u4e00\u5165\u573a\u8bb0\u5f55";
            }
        }
        if (v != null && v.length() > 0) {
            sbr.append(z);
            sbr.append(v);
        }
        String car_owner_name = record.getCar_owner_name();
        String car_owner_addr = record.getCar_owner_addr();
        if (car_owner_name != null && car_owner_name.length() > 0) {
            sbr.append(z);
            sbr.append("\u8f66\u4e3b\uff1a").append(car_owner_name);
            if (car_owner_addr != null && car_owner_addr.length() > 0) {
                sbr.append('[').append(car_owner_addr).append(']');
            }
        }
        if (record.getCar_color() != null && record.getCar_color().length() > 0) {
            sbr.append(z);
            if (!record.getCar_color().endsWith("\u8272")) {
                sbr.append(String.valueOf(record.getCar_color()) + "\u8272");
            } else {
                sbr.append(record.getCar_color());
            }
        }
        if (record.getCar_logo() != null && record.getCar_logo().length() > 0) {
            if (record.getCar_color() == null || record.getCar_color().length() == 0) {
                sbr.append(z);
            }
            sbr.append(record.getCar_logo());
        }
        if (record.getExit_time() != null && record.getExit_remark() != null && record.getExit_remark().length() > 0) {
            sbr.append(z).append(record.getExit_remark());
        }
        return sbr.toString();
    }

    private String getExceptionInfo(CarparkPassRecord record) {
        String exitPlate;
        String exitEqplate;
        Integer lanState = record.getExit_lan_state();
        if (lanState != null) {
            if (lanState == 1) {
                return "\u51fa\u573a\u5f02\u5e38\uff1a\u8f66\u724c\u8bc6\u522b\u76f8\u673a\u65ad\u7ebf";
            }
            if (lanState == 2) {
                return "\u51fa\u573a\u5f02\u5e38\uff1a\u4e0e\u670d\u52a1\u5668\u65ad\u5f00\u8fde\u63a5";
            }
            if (lanState == 3) {
                return "\u51fa\u573a\u5f02\u5e38\uff1a\u5b58\u5728\u79bb\u7ebf\u5c97\u4ead\u4e3b\u673a";
            }
        }
        if ((exitEqplate = record.getExit_reg_plate()) == null || exitEqplate.length() == 0) {
            exitEqplate = record.getExit_obu_plate();
        }
        if ((exitPlate = record.getExit_plate()) == null) {
            exitPlate = "";
        }
        if (exitEqplate != null && exitEqplate.length() > 0 && !exitEqplate.equals(exitPlate)) {
            return "\u51fa\u53e3\u8bc6\u522b\uff1a" + exitEqplate + ",\u4e0e\u51fa\u573a\u8f66\u724c\u4e0d\u4e00\u81f4";
        }
        if (record.getEnter_time() == null) {
            return "\u8bb0\u5f55\u5f02\u5e38\uff1a\u65e0\u5165\u573a\u8bb0\u5f55";
        }
        String enterPlate = record.getEnter_plate();
        if (enterPlate == null) {
            enterPlate = "";
        }
        if (!enterPlate.equals(exitPlate)) {
            return "\u8bb0\u5f55\u5f02\u5e38\uff1a\u51fa\u5165\u8f66\u724c\u4e0d\u4e00\u81f4";
        }
        String enterEqplate = record.getEnter_reg_plate();
        if (enterEqplate == null || enterEqplate.length() == 0) {
            enterEqplate = record.getEnter_obu_plate();
        }
        if (enterEqplate != null && enterEqplate.length() > 0 && !enterEqplate.equals(enterPlate)) {
            return "\u5165\u53e3\u8bc6\u522b\uff1a" + enterEqplate + ",\u4e0e\u5165\u573a\u8f66\u724c\u4e0d\u4e00\u81f4";
        }
        lanState = record.getEnter_lan_state();
        if (lanState != null) {
            if (lanState == 1) {
                return "\u5165\u573a\u5f02\u5e38\uff1a\u8f66\u724c\u8bc6\u522b\u76f8\u673a\u65ad\u7ebf";
            }
            if (lanState == 2) {
                return "\u5165\u573a\u5f02\u5e38\uff1a\u4e0e\u670d\u52a1\u5668\u65ad\u5f00\u8fde\u63a5";
            }
            if (lanState == 3) {
                return "\u5165\u573a\u5f02\u5e38\uff1a\u5b58\u5728\u79bb\u7ebf\u5c97\u4ead\u4e3b\u673a";
            }
        }
        return "\u51fa\u5165\u7f51\u7edc\uff1a\u6b63\u5e38";
    }

    private String getParkingTimeLen(CarparkPassRecord record) {
        if (record.getEnter_time() == null) {
            return "\u65e0\u5165\u573a\u8bb0\u5f55";
        }
        if (record.getExit_time() == null) {
            return "";
        }
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        int sec = (int)TimeUnit.MILLISECONDS.toSeconds(record.getExit_time().getTime() - record.getEnter_time().getTime());
        return appService.getTimeLenSecDes(sec);
    }

    private String getExitPassInfo(CarparkPassRecord record, String[] plateLabel) {
        if (record.getExit_time() == null) {
            return null;
        }
        if (record.getExit_plate() == null || record.getExit_plate().length() == 0) {
            return "\u51fa\u573a\u653e\u884c\uff1a\u975e\u8f66\u724c\u653e\u884c";
        }
        Integer exit_plate_source = record.getExit_plate_source();
        if (exit_plate_source != null) {
            if (exit_plate_source == 0) {
                return "\u51fa\u573a\u653e\u884c\uff1a\u8f66\u724c\u8bc6\u522b";
            }
            if (exit_plate_source == 1) {
                return "\u51fa\u573a\u653e\u884c\uff1a\u4eba\u5de5\u653e\u884c";
            }
            if (exit_plate_source == 2) {
                String v = plateLabel[0];
                plateLabel[0] = v = String.valueOf(v) + "[\u4eba\u5de5\u4fee\u6539]";
                String exit_reg_plate = record.getExit_reg_plate();
                if (exit_reg_plate != null && exit_reg_plate.length() > 0) {
                    return "\u51fa\u573a\u8f66\u724c\u8bc6\u522b\uff1a" + exit_reg_plate;
                }
                String exit_obu_plate = record.getExit_obu_plate();
                if (exit_obu_plate != null && exit_obu_plate.length() > 0) {
                    return "\u51fa\u573aETC\u8bc6\u522b\uff1a" + exit_obu_plate;
                }
                return "\u51fa\u573a\u653e\u884c\uff1a\u4eba\u5de5\u653e\u884c";
            }
            if (exit_plate_source == 3) {
                return "\u51fa\u573a\u653e\u884c\uff1aETC\u8bc6\u522b";
            }
            if (exit_plate_source == 4) {
                String v = plateLabel[0];
                plateLabel[0] = v = String.valueOf(v) + "[\u6a21\u7cca\u5339\u914d]";
                String exit_reg_plate = record.getExit_reg_plate();
                if (exit_reg_plate != null && exit_reg_plate.length() > 0) {
                    return "\u51fa\u573a\u8f66\u724c\u8bc6\u522b\uff1a" + exit_reg_plate;
                }
                String exit_obu_plate = record.getExit_obu_plate();
                if (exit_obu_plate != null && exit_obu_plate.length() > 0) {
                    return "\u51fa\u573aETC\u8bc6\u522b\uff1a" + exit_obu_plate;
                }
            }
        }
        return null;
    }

    private String getEnterPassInfo(CarparkPassRecord record, String[] plateLabel) {
        if (record.getEnter_time() == null) {
            return "\u5165\u573a\u653e\u884c\uff1a\u8f66\u672a\u5165\u573a";
        }
        if (record.getEnter_plate() == null || record.getEnter_plate().length() == 0) {
            return "\u5165\u573a\u653e\u884c\uff1a\u975e\u8f66\u724c\u653e\u884c";
        }
        Integer enter_plate_source = record.getEnter_plate_source();
        if (enter_plate_source != null) {
            if (enter_plate_source == 0) {
                return "\u5165\u573a\u653e\u884c\uff1a\u8f66\u724c\u8bc6\u522b";
            }
            if (enter_plate_source == 1) {
                return "\u5165\u573a\u653e\u884c\uff1a\u4eba\u5de5\u653e\u884c";
            }
            if (enter_plate_source == 5) {
                return "\u5165\u573a\u653e\u884c\uff1a" + Constants.getScanName(record.getPassport_number()) + "\u626b\u4e00\u626b";
            }
            if (enter_plate_source == 2) {
                String v = plateLabel[0];
                v = record.getEnter_plate_modify_user_name() != null && record.getEnter_plate_modify_user_name().length() > 0 ? String.valueOf(v) + "[" + record.getEnter_plate_modify_user_name() + "\u4fee\u6539]" : String.valueOf(v) + "[\u4eba\u5de5\u4fee\u6539]";
                plateLabel[0] = v;
                String enter_reg_plate = record.getEnter_reg_plate();
                if (enter_reg_plate != null && enter_reg_plate.length() > 0) {
                    return "\u5165\u573a\u8f66\u724c\u8bc6\u522b\uff1a" + enter_reg_plate;
                }
                String enter_obu_plate = record.getEnter_obu_plate();
                if (enter_obu_plate != null && enter_obu_plate.length() > 0) {
                    return "\u5165\u573aETC\u8bc6\u522b\uff1a" + enter_obu_plate;
                }
                return "\u5165\u573a\u653e\u884c\uff1a\u4eba\u5de5\u653e\u884c";
            }
            if (enter_plate_source == 3) {
                return "\u5165\u573a\u653e\u884c\uff1aETC\u8bc6\u522b";
            }
            if (enter_plate_source == 4) {
                String v = plateLabel[0];
                plateLabel[0] = v = String.valueOf(v) + "[\u6a21\u7cca\u5339\u914d]";
                String enter_reg_plate = record.getEnter_reg_plate();
                if (enter_reg_plate != null && enter_reg_plate.length() > 0) {
                    return "\u5165\u573a\u8f66\u724c\u8bc6\u522b\uff1a" + enter_reg_plate;
                }
                String enter_obu_plate = record.getEnter_obu_plate();
                if (enter_obu_plate != null && enter_obu_plate.length() > 0) {
                    return "\u5165\u573aETC\u8bc6\u522b\uff1a" + enter_obu_plate;
                }
            }
        }
        return null;
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u8f66\u8f86\u79bb\u573a\u8bb0\u5f55\u5bfc\u51fa")
    @Path(value="/exportExitPassRecord.action")
    public void exportExitPassRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("export", (Object)Boolean.TRUE);
        this.queryExitPassRecord(request, response);
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u4eba\u5de5\u8d77\u6746\u8bb0\u5f55\u67e5\u8be2")
    @LeftMenu(name="\u4eba\u5de5\u8d77\u6746\u8bb0\u5f55\u67e5\u8be2", parent_name="\u8bb0\u5f55\u67e5\u8be2", order=315)
    @Path(value="/queryManualOpenPoleRecord.action")
    public void queryManualOpenPoleRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("queryPath", (Object)"/manage/queryManualOpenPoleRecord.action");
        request.setAttribute("exportPath", (Object)"/manage/exportManualOpenPoleRecord.action");
        request.setAttribute("reasonTitle", (Object)"\u5f00\u95f8\u65b9\u5f0f");
        request.setAttribute("hasExportPermission", (Object)WebUtil.hasPermission(request, (String)request.getAttribute("exportPath")));
        LinkedList<KeyValueEntry> list = new LinkedList<KeyValueEntry>();
        list.add(new KeyValueEntry((Object)"", (Object)"\u6240\u6709\u65b9\u5f0f"));
        list.add(new KeyValueEntry((Object)"0", (Object)"\u8f6f\u4ef6\u754c\u9762\u6309\u952e"));
        list.add(new KeyValueEntry((Object)"1", (Object)"\u9053\u95f8\u9065\u63a7\u5668"));
        request.setAttribute("reasonsList", list);
        this.hadleIllagePassRecord(0, request, response);
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u4eba\u5de5\u8d77\u6746\u8bb0\u5f55\u5bfc\u51fa")
    @Path(value="/exportManualOpenPoleRecord.action")
    public void exportManualOpenPoleRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("export", (Object)Boolean.TRUE);
        this.hadleIllagePassRecord(0, request, response);
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u7279\u6b8a\u8f66\u8f86\u653e\u884c\u8bb0\u5f55\u67e5\u8be2")
    @LeftMenu(name="\u7279\u6b8a\u8f66\u8f86\u653e\u884c\u8bb0\u5f55", parent_name="\u8bb0\u5f55\u67e5\u8be2", order=316)
    @Path(value="/querySpecialCarPassRecord.action")
    public void querySpecialCarPassRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, CarparkAttribute> mapV;
        request.setAttribute("queryPath", (Object)"/manage/querySpecialCarPassRecord.action");
        request.setAttribute("exportPath", (Object)"/manage/exportSpecialCarPassRecord.action");
        request.setAttribute("reasonTitle", (Object)"\u653e\u884c\u539f\u56e0");
        request.setAttribute("hasExportPermission", (Object)WebUtil.hasPermission(request, (String)request.getAttribute("exportPath")));
        LinkedList<KeyValueEntry> list = new LinkedList<KeyValueEntry>();
        list.add(new KeyValueEntry((Object)"", (Object)"\u6240\u6709\u539f\u56e0"));
        Map<Integer, Map<String, CarparkAttribute>> amp = ServiceUtil.getServiceContext().getDBConfigCache().getAttributeTypeMap();
        if (amp != null && (mapV = amp.get(4)) != null) {
            for (CarparkAttribute arr : mapV.values()) {
                list.add(new KeyValueEntry((Object)arr.getAttribute_key(), (Object)arr.getAttribute_value()));
            }
        }
        request.setAttribute("reasonsList", list);
        this.hadleIllagePassRecord(1, request, response);
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u6b8a\u8f66\u8f86\u653e\u884c\u8bb0\u5f55\u5bfc\u51fa")
    @Path(value="/exportSpecialCarPassRecord.action")
    public void exportSpecialCarPassRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("export", (Object)Boolean.TRUE);
        this.hadleIllagePassRecord(1, request, response);
    }

    private void hadleIllagePassRecord(int record_type, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            Map<String, CarparkArea> areaMap;
            Map<String, CarparkHost> hosMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
            request.setAttribute("hosMap", hosMap);
            Integer project_id = ServiceUtil.getServiceContext().getProjectId();
            Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            List userList = commonDaoService.selectList(new SearchParam().addINList("role_no", (Object[])new String[]{"1", "2"}).addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("role_no DESC,user_code"), CarparkUser.class, null);
            request.setAttribute("userList", (Object)userList);
            Calendar cl = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            request.setAttribute("endTime", (Object)df.format(cl.getTime()));
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            cl.set(14, 0);
            request.setAttribute("startTime", (Object)df.format(cl.getTime()));
            Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
            if (channelMap != null) {
                request.setAttribute("channelMap", channelMap);
            }
            if ((areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap()) != null) {
                request.setAttribute("areaMap", areaMap);
            }
            WebUtil.showMainContentWithHead(record_type == 1 ? "\u7279\u6b8a\u8f66\u8f86\u653e\u884c\u8bb0\u5f55" : "\u4eba\u5de5\u5f00\u95f8\u653e\u884c\u8bb0\u5f55", "report/illegalPassRecord", request, response);
        } else {
            if ("query".equals(op) || request.getAttribute("export") != null) {
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkIllegalPassRecord.class));
                String area_no = request.getParameter("area_no");
                String channel_no = request.getParameter("channel_no");
                String host_no = request.getParameter("host_no");
                String op_user_code = request.getParameter("op_user_code");
                String reason_code = request.getParameter("reason_code");
                String start_pass_time = request.getParameter("start_pass_time");
                String end_pass_time = request.getParameter("end_pass_time");
                if (start_pass_time != null && start_pass_time.length() > 0) {
                    sp.addGTE("pass_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(start_pass_time));
                }
                if (end_pass_time != null && end_pass_time.length() > 0) {
                    sp.addLTE("pass_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(end_pass_time));
                }
                if (area_no != null && (area_no = area_no.trim()).length() > 0) {
                    sp.addEQ("area_no", (Object)area_no);
                }
                if (channel_no != null && (channel_no = channel_no.trim()).length() > 0) {
                    sp.addEQ("channel_no", (Object)channel_no);
                }
                if (host_no != null && (host_no = host_no.trim()).length() > 0) {
                    sp.addEQ("host_no", (Object)host_no);
                }
                if (op_user_code != null && (op_user_code = op_user_code.trim()).length() > 0) {
                    sp.addEQ("op_user_code", (Object)op_user_code);
                }
                if (reason_code != null && (reason_code = reason_code.trim()).length() > 0) {
                    sp.addEQ("reason_code", (Object)reason_code);
                }
                sp.addEQ("record_type", (Object)record_type);
                if ("query".equals(op)) {
                    String sortOrder = request.getParameter("sortOrder");
                    String sortName = request.getParameter("sortName");
                    if (sortName != null && (sortName = sortName.trim()).length() > 0 && sortOrder != null && (sortOrder = sortOrder.trim()).length() > 0) {
                        sp.setOrder_by((String.valueOf(sortName) + " " + sortOrder).replaceAll("'", ""));
                    } else {
                        sp.setOrder_by("pass_time desc");
                    }
                    Pagination p = WebUtil.getPagination(request);
                    List dataList = commonDaoService.selectList(sp, p);
                    ArrayList<Map> resultList = new ArrayList<Map>(dataList == null ? 0 : dataList.size());
                    if (dataList != null && !dataList.isEmpty()) {
                        for (Map data : dataList) {
                            resultList.add(JavaBeanUtil.toStringMap((Object)data));
                        }
                    }
                    HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
                    resMap.put("rows", resultList);
                    resMap.put("total", Long.valueOf(p.getRecordsCount()));
                    WebUtil.printFinshJson(response, GsonBuilder.create().toJson(resMap));
                    return;
                }
                LinkedHashMap<String, String> headAtrrMap = new LinkedHashMap<String, String>();
                headAtrrMap.put("pass_time", "\u653e\u884c\u65f6\u95f4");
                headAtrrMap.put("channel_name", "\u653e\u884c\u901a\u9053");
                headAtrrMap.put("area_name", "\u653e\u884c\u573a\u533a");
                headAtrrMap.put("area_name", "\u5165\u573a\u533a\u57df");
                headAtrrMap.put("description", record_type == 1 ? "\u653e\u884c\u539f\u56e0" : "\u5f00\u95f8\u65b9\u5f0f");
                headAtrrMap.put("host_name", "\u64cd\u4f5c\u4e3b\u673a");
                headAtrrMap.put("op_user_name", "\u64cd\u4f5c\u5458");
                ExportService exportService = (ExportService)ServiceUtil.getServiceContext().getService(ExportService.class);
                response.setContentType("text/plain; charset=GBK");
                response.setCharacterEncoding("GBK");
                SimpleDateFormat df11 = new SimpleDateFormat("yyyyMMddHHmmss");
                response.addHeader("Content-Disposition", "attachment;filename=record_" + df11.format(new Date()) + ".csv");
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setDateHeader("Expires", 0L);
                try (PrintWriter out = response.getWriter();){
                    exportService.exportIllegalRecordCsv(sp, headAtrrMap, out);
                }
                return;
            }
            if ("showDetail".equals(op)) {
                Long id = Long.valueOf(request.getParameter("id"));
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkIllegalPassRecord.class));
                sp.addEQ("id", (Object)id);
                Map record = commonDaoService.selectOne(sp);
                if (record == null) {
                    WebUtil.printFinshHtml(response, "404notfound");
                    return;
                }
                String pic_path = (String)record.get("pic_path");
                String hostNo = (String)record.get("host_no");
                record.put("pic_path", CarparkRecordSearchAction.getPicUri(request.getContextPath(), pic_path, hostNo, true));
                request.setAttribute("record", (Object)record);
                WebUtil.dispathTemplatePage("report/illegalPassRecord", request, response);
                return;
            }
        }
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u8f66\u8f86\u6298\u6263\u8bb0\u5f55\u67e5\u8be2")
    @LeftMenu(name="\u8f66\u8f86\u6298\u6263\u8bb0\u5f55\u67e5\u8be2", parent_name="\u8bb0\u5f55\u67e5\u8be2", order=317)
    @Path(value="/queryCarDiscountRecord.action")
    public void queryCarDiscountRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            Calendar cl = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            request.setAttribute("endTime", (Object)df.format(cl.getTime()));
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            cl.set(14, 0);
            request.setAttribute("startTime", (Object)df.format(cl.getTime()));
            Map<Integer, String> dicountSenceMap = Constants.getDisocuntSourceMap();
            request.setAttribute("dicountSenceMap", dicountSenceMap);
            WebUtil.showMainContentWithHead("\u8f66\u8f86\u6298\u6263\u8bb0\u5f55\u67e5\u8be2", "report/discountRecord", request, response);
        } else if ("obtianProUsers".equals(op)) {
            String discount_merchant_no = request.getParameter("discount_merchant_no");
            if (discount_merchant_no == null || discount_merchant_no.length() == 0) {
                return;
            }
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            LinkedList<KeyValueEntry> proList = new LinkedList<KeyValueEntry>();
            LinkedList<KeyValueEntry> userList = new LinkedList<KeyValueEntry>();
            if ("0".equals(discount_merchant_no)) {
                Map<String, CarparkDiscountProject> dmap = ServiceUtil.getServiceContext().getDBConfigCache().getDiscountProjectMap();
                if (dmap != null && !dmap.isEmpty()) {
                    for (CarparkDiscountProject p : dmap.values()) {
                        proList.add(new KeyValueEntry((Object)p.getDiscount_project_no(), (Object)p.getDiscount_project_name()));
                    }
                }
                proList.add(new KeyValueEntry((Object)"certificates_free", (Object)"\u8bc1\u4ef6\u6293\u62cd\u514d\u8d39"));
                List userList0 = commonDaoService.selectList(new SearchParam().setOrerbySql("role_no DESC,user_code"), CarparkUser.class, null);
                if (userList0 != null && !userList0.isEmpty()) {
                    for (CarparkUser u : userList0) {
                        userList.add(new KeyValueEntry((Object)u.getUser_code(), (Object)u.getUser_name()));
                    }
                }
            } else {
                List proList0;
                List userList0 = commonDaoService.selectList(new SearchParam().addEQ("merchant_no", (Object)discount_merchant_no), CarparkMerchantUser.class, null);
                if (userList0 != null && !userList0.isEmpty()) {
                    for (CarparkMerchantUser u : userList0) {
                        userList.add(new KeyValueEntry((Object)u.getUser_no(), (Object)u.getUser_name()));
                    }
                }
                if ((proList0 = commonDaoService.selectList(new SearchParam().addEQ("merchant_no", (Object)discount_merchant_no), CarparkMerchantCouponProj.class, null)) != null && !proList0.isEmpty()) {
                    for (CarparkMerchantCouponProj p : proList0) {
                        proList.add(new KeyValueEntry((Object)p.getCoupon_proj_no(), (Object)p.getCoupon_proj_name()));
                    }
                }
            }
            HashMap<String, LinkedList<KeyValueEntry>> dataMap = new HashMap<String, LinkedList<KeyValueEntry>>();
            dataMap.put("proList", proList);
            dataMap.put("userList", userList);
            WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", dataMap, response);
        } else if ("query".equals(op) || request.getAttribute("export") != null) {
            String discount_source = request.getParameter("discount_source");
            String start_discount_time = request.getParameter("start_discount_time");
            String end_discount_time = request.getParameter("end_discount_time");
            String discount_merchant_name = request.getParameter("discount_merchant_name");
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkDiscountRecord.class));
            String queryAttr1 = request.getParameter("queryAttr1");
            String queryValue1 = request.getParameter("queryAttr1_value");
            if (queryAttr1 != null && (queryAttr1 = queryAttr1.trim()).length() > 0 && queryValue1 != null && (queryValue1 = queryValue1.trim()).length() > 0) {
                queryValue1 = queryValue1.replaceAll("\"", "").replaceAll("'", "").replaceAll(" ", "");
                if ("palte_number".equals(queryAttr1)) {
                    String v2 = queryValue1.toUpperCase();
                    v2 = v2.replaceAll("\u3000", "");
                    v2 = v2.replaceAll(" ", "");
                    v2 = v2.replaceAll("\u2006", "");
                    if ((v2 = v2.replaceAll("I", "1")).length() > 0) {
                        sp.addLike(queryAttr1, v2);
                    }
                } else {
                    sp.addLike(queryAttr1, queryValue1);
                }
            }
            if (start_discount_time != null && start_discount_time.length() > 0) {
                sp.addGTE("discount_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(start_discount_time));
            }
            if (end_discount_time != null && end_discount_time.length() > 0) {
                sp.addLTE("discount_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(end_discount_time));
            }
            if (discount_merchant_name != null && (discount_merchant_name = discount_merchant_name.trim()).length() > 0) {
                sp.addLike("discount_merchant_name", discount_merchant_name);
            }
            if (discount_source != null && (discount_source = discount_source.trim()).length() > 0) {
                sp.addEQ("discount_source", (Object)Integer.valueOf(discount_source));
            }
            if ("query".equals(op)) {
                String sortOrder = request.getParameter("sortOrder");
                String sortName = request.getParameter("sortName");
                if (sortName != null && (sortName = sortName.trim()).length() > 0 && sortOrder != null && (sortOrder = sortOrder.trim()).length() > 0) {
                    sp.setOrder_by((String.valueOf(sortName) + " " + sortOrder).replaceAll("'", ""));
                } else {
                    sp.setOrder_by("discount_time desc");
                }
                Pagination p = WebUtil.getPagination(request);
                List dataList = commonDaoService.selectList(sp, p);
                ArrayList<Map> resultList = new ArrayList<Map>(dataList == null ? 0 : dataList.size());
                if (dataList != null && !dataList.isEmpty()) {
                    for (Map data : dataList) {
                        String v;
                        Integer _discount_source = (Integer)data.get("discount_source");
                        if (_discount_source != null && (v = Constants.getDisocuntSourceMap().get(_discount_source)) != null) {
                            data.put("discount_source", v);
                        }
                        resultList.add(JavaBeanUtil.toStringMap((Object)data));
                    }
                }
                HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
                resMap.put("rows", resultList);
                resMap.put("total", Long.valueOf(p.getRecordsCount()));
                WebUtil.printFinshJson(response, GsonBuilder.create().toJson(resMap));
                return;
            }
            LinkedHashMap<String, String> headAtrrMap = new LinkedHashMap<String, String>();
            headAtrrMap.put("discount_time", "\u6253\u6298\u65f6\u95f4");
            headAtrrMap.put("discount_merchant_name", "\u6253\u6298\u5546\u6237");
            headAtrrMap.put("discount_project_name", "\u6298\u6263\u540d\u79f0");
            headAtrrMap.put("discount_value_des", "\u6298\u6263\u5185\u5bb9");
            headAtrrMap.put("palte_number", "\u6253\u6298\u8f66\u724c");
            headAtrrMap.put("enter_time", "\u5165\u573a\u65f6\u95f4");
            headAtrrMap.put("discount_source", "\u6253\u6298\u65b9\u5f0f");
            headAtrrMap.put("operation_user_name", "\u64cd\u4f5c\u5458");
            headAtrrMap.put("coupon_no", "\u4f18\u60e0\u5238\u7f16\u53f7");
            headAtrrMap.put("coupon_order_no", "\u4f18\u60e0\u5238\u8ba2\u5355\u7f16\u53f7");
            headAtrrMap.put("exit_time", "\u79bb\u573a\u65f6\u95f4");
            headAtrrMap.put("discount_amount", "\u4f18\u60e0\u91d1\u989d");
            ExportService exportService = (ExportService)ServiceUtil.getServiceContext().getService(ExportService.class);
            response.setContentType("text/plain; charset=GBK");
            response.setCharacterEncoding("GBK");
            SimpleDateFormat df11 = new SimpleDateFormat("yyyyMMddHHmmss");
            response.addHeader("Content-Disposition", "attachment;filename=discount_" + df11.format(new Date()) + ".csv");
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            try (PrintWriter out = response.getWriter();){
                exportService.exportDiscountRecordCsv(sp, headAtrrMap, out);
            }
            return;
        }
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u8f66\u8f86\u6298\u6263\u8bb0\u5f55\u5bfc\u51fa")
    @Path(value="/exportCarDiscountRecord.action")
    public void exportCarDiscountRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("export", (Object)Boolean.TRUE);
        this.queryCarDiscountRecord(request, response);
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u8f66\u724c\u8bc6\u522b\u65e5\u5fd7\u67e5\u8be2")
    @LeftMenu(name="\u8f66\u724c\u8bc6\u522b\u65e5\u5fd7\u67e5\u8be2", parent_name="\u8bb0\u5f55\u67e5\u8be2", order=318)
    @Path(value="/queryCarPlateRegLog.action")
    public void queryCarPlateRegLog(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            Calendar cl = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            request.setAttribute("endTime", (Object)df.format(cl.getTime()));
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            cl.set(14, 0);
            request.setAttribute("startTime", (Object)df.format(cl.getTime()));
            Map<String, CarparkHost> hosMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
            request.setAttribute("hosMap", hosMap);
            Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
            if (channelMap != null) {
                request.setAttribute("channelMap", channelMap);
            }
            Map<String, List<ChannelEquipmentVo>> channelEqMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelEquipmentVoListMap();
            LinkedList<ChannelEquipmentVo> eqList = new LinkedList<ChannelEquipmentVo>();
            if (channelEqMap != null && !channelEqMap.isEmpty()) {
                for (List<ChannelEquipmentVo> l : channelEqMap.values()) {
                    if (l == null) continue;
                    for (ChannelEquipmentVo v : l) {
                        if (v.getEquipment_type() == 33) {
                            eqList.add(v);
                            continue;
                        }
                        if (v.getEquipment_type() != 38) continue;
                        eqList.add(v);
                    }
                }
            }
            request.setAttribute("eqList", eqList);
            WebUtil.showMainContentWithHead("\u8f66\u724c\u8bc6\u522b\u65e5\u5fd7", "report/carplateRegRecord", request, response);
        } else {
            if ("query".equals(op)) {
                String plate_number = request.getParameter("plate_number");
                String start_reg_time = request.getParameter("start_reg_time");
                String end_reg_time = request.getParameter("end_reg_time");
                String host_no = request.getParameter("host_no");
                String channel_no = request.getParameter("channel_no");
                String camera_no = request.getParameter("camera_no");
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkRegplateRecord.class));
                if (plate_number != null && (plate_number = plate_number.trim()).length() > 0) {
                    String v2 = plate_number.toUpperCase();
                    v2 = v2.replaceAll("\u3000", "");
                    v2 = v2.replaceAll(" ", "");
                    if ((v2 = v2.replaceAll("I", "1")).length() > 0) {
                        sp.addLike("plate_number", v2);
                    }
                }
                if (start_reg_time != null && start_reg_time.length() > 0) {
                    sp.addGTE("reg_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(start_reg_time));
                }
                if (end_reg_time != null && end_reg_time.length() > 0) {
                    sp.addLTE("reg_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(end_reg_time));
                }
                if (host_no != null && (host_no = host_no.trim()).length() > 0) {
                    sp.addEQ("host_no", (Object)host_no);
                }
                if (channel_no != null && (channel_no = channel_no.trim()).length() > 0) {
                    sp.addEQ("channel_no", (Object)channel_no);
                }
                if (camera_no != null && (camera_no = camera_no.trim()).length() > 0) {
                    sp.addEQ("camera_no", (Object)camera_no);
                }
                String sortOrder = request.getParameter("sortOrder");
                String sortName = request.getParameter("sortName");
                if (sortName != null && (sortName = sortName.trim()).length() > 0 && sortOrder != null && (sortOrder = sortOrder.trim()).length() > 0) {
                    sp.setOrder_by((String.valueOf(sortName) + " " + sortOrder).replaceAll("'", ""));
                } else {
                    sp.setOrder_by("reg_time desc");
                }
                Pagination p = WebUtil.getPagination(request);
                List dataList = commonDaoService.selectList(sp, p);
                ArrayList<Map> resultList = new ArrayList<Map>(dataList == null ? 0 : dataList.size());
                if (dataList != null && !dataList.isEmpty()) {
                    Map<String, CarparkHost> hosMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
                    Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
                    Map<String, List<ChannelEquipmentVo>> channelEqMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelEquipmentVoListMap();
                    HashMap<String, ChannelEquipmentVo> eqMap = new HashMap<String, ChannelEquipmentVo>();
                    if (channelEqMap != null && !channelEqMap.isEmpty()) {
                        for (List list : channelEqMap.values()) {
                            for (ChannelEquipmentVo v : list) {
                                eqMap.put(v.getEquipment_no(), v);
                            }
                        }
                    }
                    for (Map map : dataList) {
                        String plate_color;
                        String small_pic_path = (String)map.get("small_pic_path");
                        String hostNo = (String)map.get("host_no");
                        map.put("small_pic_path", CarparkRecordSearchAction.getPicUri(request.getContextPath(), small_pic_path, hostNo, true));
                        CarparkChannel channel = channelMap.get(map.get("channel_no"));
                        String channel_name = channel != null ? channel.getChannel_name() : "";
                        map.put("channel_name", channel_name);
                        ChannelEquipmentVo eq = (ChannelEquipmentVo)eqMap.get(map.get("camera_no"));
                        String camera_ip = eq != null ? (eq.getEquipment_ip() != null && eq.getEquipment_ip().length() > 0 ? eq.getEquipment_ip() : eq.getEquipment_name()) : "";
                        map.put("camera_ip", camera_ip);
                        CarparkHost host = hosMap.get(hostNo);
                        String host_name = host != null ? host.getHost_name() : "";
                        map.put("host_name", host_name);
                        String plateNumber = (String)map.get("plate_number");
                        if (plateNumber != null && plateNumber.length() > 0 && (plate_color = (String)map.get("plate_color")) != null && plate_color.length() > 0) {
                            plateNumber = String.valueOf(plateNumber) + " [" + plate_color + "]";
                            map.put("plate_number", plateNumber);
                        }
                        StringBuilder sbr = new StringBuilder();
                        String plate_type = (String)map.get("plate_type");
                        String plate_judge = (String)map.get("plate_judge");
                        String plate_confi = (String)map.get("plate_confi");
                        String car_color = (String)map.get("car_color");
                        String car_logo = (String)map.get("car_logo");
                        String car_dir = (String)map.get("car_dir");
                        String car_type = (String)map.get("car_type");
                        String car_speed = (String)map.get("car_speed");
                        String features = (String)map.get("features");
                        if (plate_type != null && plate_type.length() > 0) {
                            if (sbr.length() > 0) {
                                sbr.append('\u3001');
                            }
                            sbr.append(plate_type);
                        }
                        if (plate_judge != null && plate_judge.length() > 0) {
                            if (sbr.length() > 0) {
                                sbr.append('\u3001');
                            }
                            sbr.append(plate_judge);
                        }
                        if (plate_confi != null && plate_confi.length() > 0) {
                            if (sbr.length() > 0) {
                                sbr.append('\u3001');
                            }
                            sbr.append("\u53ef\u4fe1\u5ea6\uff1a").append(plate_confi);
                        }
                        if (car_color != null && car_color.length() > 0) {
                            if (sbr.length() > 0) {
                                sbr.append('\u3001');
                            }
                            sbr.append(car_color);
                        }
                        if (car_logo != null && car_logo.length() > 0) {
                            if (sbr.length() > 0) {
                                sbr.append('\u3001');
                            }
                            sbr.append(car_logo);
                        }
                        if (car_dir != null && car_dir.length() > 0) {
                            if (sbr.length() > 0) {
                                sbr.append('\u3001');
                            }
                            sbr.append(car_dir);
                        }
                        if (car_type != null && car_type.length() > 0) {
                            if (sbr.length() > 0) {
                                sbr.append('\u3001');
                            }
                            sbr.append(car_type);
                        }
                        if (car_speed != null && car_speed.length() > 0) {
                            if (sbr.length() > 0) {
                                sbr.append('\u3001');
                            }
                            sbr.append("\u8f66\u901f\uff1a").append(car_speed);
                        }
                        if (features != null && features.length() > 0) {
                            if (sbr.length() > 0) {
                                sbr.append('\uff1b');
                            }
                            sbr.append(features);
                        }
                        map.put("reg_info", sbr.toString());
                        Integer trigger_method = (Integer)map.get("trigger_method");
                        if (trigger_method != null && trigger_method == 1) {
                            map.put("trigger_method", "\u4eba\u5de5\u89e6\u53d1");
                        } else if (trigger_method != null && trigger_method == 10) {
                            map.put("trigger_method", "\u8f66\u578b\u8bc6\u522b\u5668");
                        } else if (trigger_method != null && trigger_method == 2) {
                            map.put("trigger_method", "\u5730\u611f\u7ebf\u5708");
                        } else {
                            map.put("trigger_method", "\u76f8\u673a\u8bc6\u522b");
                        }
                        resultList.add(JavaBeanUtil.toStringMap((Object)map));
                    }
                }
                HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
                resMap.put("rows", resultList);
                resMap.put("total", Long.valueOf(p.getRecordsCount()));
                WebUtil.printFinshJson(response, GsonBuilder.create().toJson(resMap));
                return;
            }
            if ("showDetail".equals(op)) {
                String plate_color;
                CarparkHost host;
                Map data;
                CarparkChannel channel;
                SearchParam sp;
                Long id = Long.valueOf(request.getParameter("id"));
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                Map dataMap = commonDaoService.selectOne(sp = new SearchParam(commonDaoService.getTableName(CarparkRegplateRecord.class)).addEQ("id", (Object)id));
                if (dataMap == null) {
                    WebUtil.printFinshHtml(response, "404notfound");
                    return;
                }
                String big_pic_path = (String)dataMap.get("big_pic_path");
                String small_pic_path = (String)dataMap.get("small_pic_path");
                String hostNo = (String)dataMap.get("host_no");
                dataMap.put("big_pic_path", CarparkRecordSearchAction.getPicUri(request.getContextPath(), big_pic_path, hostNo, true));
                if (small_pic_path != null && small_pic_path.length() > 0) {
                    dataMap.put("small_pic_path", CarparkRecordSearchAction.getPicUri(request.getContextPath(), small_pic_path, hostNo, false));
                }
                Map<String, CarparkHost> hosMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
                Map<String, CarparkChannel> channelMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap();
                Map<String, List<ChannelEquipmentVo>> channelEqMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelEquipmentVoListMap();
                HashMap<String, ChannelEquipmentVo> eqMap = new HashMap<String, ChannelEquipmentVo>();
                if (channelEqMap != null && !channelEqMap.isEmpty()) {
                    for (List<ChannelEquipmentVo> l : channelEqMap.values()) {
                        for (ChannelEquipmentVo v : l) {
                            eqMap.put(v.getEquipment_no(), v);
                        }
                    }
                }
                String channel_name = (channel = channelMap.get((data = dataMap).get("channel_no"))) != null ? channel.getChannel_name() : "";
                data.put("channel_name", channel_name);
                ChannelEquipmentVo eq = (ChannelEquipmentVo)eqMap.get(data.get("camera_no"));
                if (eq != null) {
                    if (eq.getEquipment_ip() != null && eq.getEquipment_ip().length() > 0) {
                        data.put("camera_ip", eq.getEquipment_ip());
                    }
                    if (eq.getEquipment_name() != null && eq.getEquipment_name().length() > 0) {
                        data.put("camera_name", eq.getEquipment_name());
                    }
                }
                String host_name = (host = hosMap.get(hostNo)) != null ? host.getHost_name() : "";
                data.put("host_name", host_name);
                String string = (String)data.get("plate_number");
                if (string != null && string.length() > 0 && (plate_color = (String)data.get("plate_color")) != null && plate_color.length() > 0) {
                    String string2 = String.valueOf(string) + " [" + plate_color + "]";
                    data.put("plate_number", string2);
                }
                StringBuilder sbr = new StringBuilder();
                String plate_type = (String)data.get("plate_type");
                String plate_judge = (String)data.get("plate_judge");
                String plate_confi = (String)data.get("plate_confi");
                String car_color = (String)data.get("car_color");
                String car_logo = (String)data.get("car_logo");
                String car_dir = (String)data.get("car_dir");
                String car_type = (String)data.get("car_type");
                String car_speed = (String)data.get("car_speed");
                if (plate_type != null && plate_type.length() > 0) {
                    if (sbr.length() > 0) {
                        sbr.append('\u3001');
                    }
                    sbr.append(plate_type);
                }
                if (plate_judge != null && plate_judge.length() > 0) {
                    if (sbr.length() > 0) {
                        sbr.append('\u3001');
                    }
                    sbr.append(plate_judge);
                }
                if (plate_confi != null && plate_confi.length() > 0) {
                    if (sbr.length() > 0) {
                        sbr.append('\u3001');
                    }
                    sbr.append("\u53ef\u4fe1\u5ea6\uff1a").append(plate_confi);
                }
                if (car_color != null && car_color.length() > 0) {
                    if (sbr.length() > 0) {
                        sbr.append('\u3001');
                    }
                    sbr.append(car_color);
                }
                if (car_logo != null && car_logo.length() > 0) {
                    if (sbr.length() > 0) {
                        sbr.append('\u3001');
                    }
                    sbr.append(car_logo);
                }
                if (car_dir != null && car_dir.length() > 0) {
                    if (sbr.length() > 0) {
                        sbr.append('\u3001');
                    }
                    sbr.append(car_dir);
                }
                if (car_type != null && car_type.length() > 0) {
                    if (sbr.length() > 0) {
                        sbr.append('\u3001');
                    }
                    sbr.append(car_type);
                }
                if (car_speed != null && car_speed.length() > 0) {
                    if (sbr.length() > 0) {
                        sbr.append('\u3001');
                    }
                    sbr.append("\u8f66\u901f\uff1a").append(car_speed);
                }
                data.put("reg_info", sbr.toString());
                Integer trigger_method = (Integer)data.get("trigger_method");
                if (trigger_method != null && trigger_method == 1) {
                    data.put("trigger_method", "\u4eba\u5de5\u89e6\u53d1");
                } else if (trigger_method != null && trigger_method == 10) {
                    data.put("trigger_method", "\u8f66\u578b\u8bc6\u522b\u5668");
                } else {
                    data.put("trigger_method", "\u76f8\u673a\u8bc6\u522b");
                }
                request.setAttribute("record", (Object)data);
                WebUtil.dispathTemplatePage("report/carplateRegRecord", request, response);
            }
        }
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u4e1a\u52a1\u64cd\u4f5c\u65e5\u5fd7\u67e5\u8be2")
    @LeftMenu(name="\u4e1a\u52a1\u64cd\u4f5c\u65e5\u5fd7\u67e5\u8be2", parent_name="\u8bb0\u5f55\u67e5\u8be2", order=319)
    @Path(value="/queryServiceOpLog.action")
    public void queryServiceOpLog(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            Calendar cl = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            request.setAttribute("endTime", (Object)df.format(cl.getTime()));
            cl.set(13, 0);
            cl.set(12, 0);
            cl.set(11, 0);
            cl.set(14, 0);
            request.setAttribute("startTime", (Object)df.format(cl.getTime()));
            request.setAttribute("opCatMap", Constants.getOpLogMap());
            Integer project_id = ServiceUtil.getServiceContext().getProjectId();
            Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            List userList = commonDaoService.selectList(new SearchParam().addEQ("project_id", (Object)project_id).addEQ("carpark_id", (Object)carpark_id).setOrerbySql("role_no DESC,user_code"), CarparkUser.class, null);
            request.setAttribute("userList", (Object)userList);
            WebUtil.showMainContentWithHead("\u4e1a\u52a1\u64cd\u4f5c\u65e5\u5fd7", "report/operationLogRecord", request, response);
        } else if ("query".equals(op)) {
            String op_des = request.getParameter("op_des");
            String start_op_time = request.getParameter("start_op_time");
            String end_op_time = request.getParameter("end_op_time");
            String op_cat = request.getParameter("op_cat");
            String op_user_code = request.getParameter("op_user_code");
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkOperationLog.class));
            if (op_des != null && (op_des = op_des.trim()).length() > 0) {
                sp.addLike("op_des", op_des);
            }
            if (start_op_time != null && start_op_time.length() > 0) {
                sp.addGTE("op_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(start_op_time));
            }
            if (end_op_time != null && end_op_time.length() > 0) {
                sp.addLTE("op_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(end_op_time));
            }
            if (op_user_code != null && (op_user_code = op_user_code.trim()).length() > 0) {
                sp.addEQ("op_user_code", (Object)op_user_code);
            }
            if (op_cat != null && (op_cat = op_cat.trim()).length() > 0) {
                int l = op_cat.indexOf(44);
                if (l > 0) {
                    Integer p1 = Integer.valueOf(op_cat.substring(0, l).trim());
                    Integer p2 = Integer.valueOf(op_cat.substring(l + 1).trim());
                    sp.addEQ("op_cat", (Object)p1);
                    sp.addEQ("op_type", (Object)p2);
                } else {
                    sp.addEQ("op_cat", (Object)Integer.valueOf(op_cat));
                }
            }
            String sortOrder = request.getParameter("sortOrder");
            String sortName = request.getParameter("sortName");
            if (sortName != null && (sortName = sortName.trim()).length() > 0 && sortOrder != null && (sortOrder = sortOrder.trim()).length() > 0) {
                sp.setOrder_by((String.valueOf(sortName) + " " + sortOrder).replaceAll("'", ""));
            } else {
                sp.setOrder_by("op_time desc");
            }
            Pagination p = WebUtil.getPagination(request);
            List dataList = commonDaoService.selectList(sp, p);
            ArrayList<Map> resultList = new ArrayList<Map>(dataList == null ? 0 : dataList.size());
            if (dataList != null) {
                for (Map data : dataList) {
                    Integer _op_cat = (Integer)data.get("op_cat");
                    Integer _op_type = (Integer)data.get("op_type");
                    KeyValueEntry<String, List<KeyValueEntry<Integer, String>>> lo = Constants.getOpLogMap().get(_op_cat);
                    if (lo != null) {
                        data.put("op_cat", lo.getKey());
                        for (KeyValueEntry l1 : (List)lo.getValue()) {
                            if (((Integer)l1.getKey()).intValue() != _op_type.intValue()) continue;
                            data.put("op_type", l1.getValue());
                            break;
                        }
                    }
                    resultList.add(JavaBeanUtil.toStringMap((Object)data));
                }
            }
            HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
            resMap.put("rows", resultList);
            resMap.put("total", Long.valueOf(p.getRecordsCount()));
            WebUtil.printFinshJson(response, GsonBuilder.create().toJson(resMap));
            return;
        }
    }

    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u7535\u5b50\u53d1\u7968\u8bb0\u5f55\u5bfc\u51fa")
    @Path(value="/exportInvoiceOrderRecord.action")
    public void exitInvoiceOrderRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("export", (Object)Boolean.TRUE);
        this.queryInvoiceOrderRecord(request, response);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Permission(value="\u67e5\u8be2\u4e0e\u7edf\u8ba1-\u8bb0\u5f55\u67e5\u8be2-\u7535\u5b50\u53d1\u7968\u8ba2\u5355\u67e5\u8be2")
    @LeftMenu(name="\u7535\u5b50\u53d1\u7968\u8ba2\u5355\u67e5\u8be2", parent_name="\u8bb0\u5f55\u67e5\u8be2", order=319)
    @Path(value="/queryInvoiceOrderRecord.action")
    public void queryInvoiceOrderRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op = request.getParameter("op");
        if (op == null) {
            OrderNo orderNo;
            Calendar cl = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            request.setAttribute("endTime", (Object)df.format(cl.getTime()));
            Date startTime = null;
            String invoice_cloud_no = request.getParameter("invoice_cloud_no");
            if (invoice_cloud_no != null && invoice_cloud_no.length() > 0 && (orderNo = OrderNo.parse(invoice_cloud_no)) != null) {
                startTime = orderNo.getDay();
            }
            if (startTime == null) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                cl.set(14, 0);
                startTime = cl.getTime();
            }
            request.setAttribute("startTime", (Object)df.format(startTime));
            WebUtil.showMainContentWithHead("\u7535\u5b50\u53d1\u7968\u8ba2\u5355\u8bb0\u5f55", "report/invoiceOrderRecord", request, response);
            return;
        }
        if ("query".equals(op) || request.getAttribute("export") != null || "queryTotalMoney".equals(op)) {
            String queryAttr1 = request.getParameter("queryAttr1");
            String queryAttr1_value = request.getParameter("queryAttr1_value");
            String start_created_time = request.getParameter("start_created_time");
            String end_created_time = request.getParameter("end_created_time");
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            String tableName = commonDaoService.getTableName(CarparkInvoiceOrder.class);
            SearchParam sp = new SearchParam(tableName);
            if (queryAttr1 != null && (queryAttr1 = queryAttr1.trim()).length() > 0 && queryAttr1_value != null && (queryAttr1_value = queryAttr1_value.trim()).length() > 0) {
                if ("invoice_cloud_no".equals(queryAttr1) || "invoice_order_no".equals(queryAttr1)) {
                    sp.addEQ(queryAttr1, (Object)queryAttr1_value);
                } else {
                    sp.addLike(queryAttr1, queryAttr1_value);
                }
            }
            if (start_created_time != null && start_created_time.length() > 0) {
                sp.addGTE("invoice_success_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(start_created_time));
            }
            if (end_created_time != null && end_created_time.length() > 0) {
                sp.addLTE("invoice_success_time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(end_created_time));
            }
            if ("query".equals(op)) {
                String sortOrder = request.getParameter("sortOrder");
                String sortName = request.getParameter("sortName");
                if (sortName != null && (sortName = sortName.trim()).length() > 0 && sortOrder != null && (sortOrder = sortOrder.trim()).length() > 0) {
                    sp.setOrder_by((String.valueOf(sortName) + " " + sortOrder).replaceAll("'", ""));
                } else {
                    sp.setOrder_by("created_time desc");
                }
                Pagination p = WebUtil.getPagination(request);
                List dataList = commonDaoService.selectList(sp, p);
                ArrayList<Map> resultList = new ArrayList<Map>(dataList == null ? 0 : dataList.size());
                if (dataList != null && !dataList.isEmpty()) {
                    for (Map data : dataList) {
                        BigDecimal project_count;
                        BigDecimal bigDecimal = (BigDecimal)data.get("project_rate");
                        if (bigDecimal != null) {
                            double a = bigDecimal.doubleValue() * 100.0;
                            if (a == (double)((int)a)) {
                                data.put("project_rate", String.valueOf((int)a) + "%");
                            } else {
                                data.put("project_rate", String.valueOf(a) + "%");
                            }
                        }
                        if ((project_count = (BigDecimal)data.get("project_count")) != null && (double)project_count.intValue() == project_count.doubleValue()) {
                            data.put("project_count", project_count.intValue());
                        }
                        resultList.add(JavaBeanUtil.toStringMap((Object)data));
                    }
                }
                HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
                resMap.put("rows", resultList);
                resMap.put("total", Long.valueOf(p.getRecordsCount()));
                WebUtil.printFinshJson(response, GsonBuilder.create().toJson(resMap));
                return;
            }
            if ("queryTotalMoney".equals(op)) {
                sp.setQueryFields(new String[]{"SUM(project_amount) AS project_amount_total", "SUM(project_rate_money) AS project_rate_money_total", "SUM(project_rate_amount) AS project_rate_amount_total", "SUM(tran_count) AS tran_count_total"});
                HashMap<String, String> totalMoneyMap = commonDaoService.selectOne(sp);
                if (totalMoneyMap == null) {
                    totalMoneyMap = new HashMap<String, String>();
                }
                String[] s1 = new String[]{"project_amount_total", "project_rate_money_total", "project_rate_amount_total", "tran_count_total"};
                NumberFormat sf = NumberFormat.getCurrencyInstance(Locale.CHINA);
                String[] stringArray = s1;
                int n = s1.length;
                int n2 = 0;
                while (n2 < n) {
                    void var18_45;
                    String s = stringArray[n2];
                    Object v = totalMoneyMap.get(s);
                    if (v == null) {
                        if ("tran_count_total".equals(s)) {
                            Integer n3 = 0;
                        } else {
                            BigDecimal bigDecimal = Constants.MONEY_ZERO;
                        }
                    }
                    if (var18_45 instanceof BigDecimal) {
                        BigDecimal d = (BigDecimal)var18_45;
                        totalMoneyMap.put(s, sf.format(d));
                    } else {
                        totalMoneyMap.put(s, var18_45.toString());
                    }
                    ++n2;
                }
                request.setAttribute("totalMoneyMap", totalMoneyMap);
                WebUtil.dispathTemplatePage("report/invoiceOrderRecord", request, response);
                return;
            }
            LinkedHashMap<String, String> headAtrrMap = new LinkedHashMap<String, String>();
            headAtrrMap.put("invoice_cloud_no", "\u4e1a\u52a1\u8ba2\u5355\u53f7");
            headAtrrMap.put("invoice_order_no", "\u53d1\u7968\u8ba2\u5355\u53f7");
            headAtrrMap.put("invoice_success_time", "\u5f00\u7968\u65f6\u95f4");
            headAtrrMap.put("buyer_name", "\u8d2d\u4e70\u65b9\u540d\u79f0");
            headAtrrMap.put("buyer_identity_no", "\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7");
            headAtrrMap.put("buyer_phone", "\u8d2d\u4e70\u65b9\u624b\u673a\u53f7");
            headAtrrMap.put("project_count", "\u9879\u76ee\u6570\u91cf");
            headAtrrMap.put("project_name", "\u9879\u76ee\u540d\u79f0");
            headAtrrMap.put("project_amount", "\u4ef7\u7a0e\u5408\u8ba1(\u5143)");
            headAtrrMap.put("project_rate", "\u7a0e\u7387");
            headAtrrMap.put("project_rate_money", "\u7a0e\u91d1\u5408\u8ba1(\u5143)");
            headAtrrMap.put("project_rate_amount", "\u7a0e\u540e\u5408\u8ba1(\u5143)");
            headAtrrMap.put("seller_name", "\u9500\u552e\u65b9\u540d\u79f0");
            headAtrrMap.put("seller_identity_no", "\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7");
            headAtrrMap.put("ticket_code", "\u53d1\u7968\u4ee3\u7801");
            headAtrrMap.put("ticket_sn", "\u53d1\u7968\u53f7\u7801");
            headAtrrMap.put("tran_count", "\u4ea4\u6613\u8ba2\u5355\u6570");
            ExportService exportService = (ExportService)ServiceUtil.getServiceContext().getService(ExportService.class);
            response.setContentType("text/plain; charset=GBK");
            response.setCharacterEncoding("GBK");
            SimpleDateFormat df11 = new SimpleDateFormat("yyyyMMddHHmmss");
            response.addHeader("Content-Disposition", "attachment;filename=invoice_" + df11.format(new Date()) + ".csv");
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            try (PrintWriter out = response.getWriter();){
                exportService.exportInvoiceRecordCsv(sp, headAtrrMap, out);
                return;
            }
        }
        if (!"showTranList".equals(op)) return;
        String invoice_cloud_no = request.getParameter("invoice_cloud_no");
        if (invoice_cloud_no == null || invoice_cloud_no.length() == 0) {
            WebUtil.printFinshHtml(response, "404notfound");
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam sp = new SearchParam(commonDaoService.getTableName(CarparkTransaction.class));
        sp.addEQ("invoice_cloud_no", (Object)invoice_cloud_no);
        List dataList = commonDaoService.selectList(sp, null);
        if (dataList == null || dataList.isEmpty()) {
            WebUtil.printFinshHtml(response, "404notfound");
            return;
        }
        ArrayList<Map> returnList = new ArrayList<Map>(dataList.size());
        for (Map data : dataList) {
            Integer pay_method = (Integer)data.get("pay_method");
            String payMethodStr = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(pay_method);
            if (payMethodStr == null) {
                payMethodStr = "";
            }
            data.put("pay_method", payMethodStr);
            returnList.add(JavaBeanUtil.toStringMap((Object)data));
        }
        request.setAttribute("returnList", returnList);
        WebUtil.dispathTemplatePage("report/invoiceOrderRecord", request, response);
    }
}

