/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action.manage;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.dto.CarparkRole;
import com.wovoe.carpark.dto.CarparkRolePermission;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.web.LeftMenu;
import com.wovoe.carpark.web.Permission;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.carpark.web.WritePermission;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;

@Action(value="/manage")
public class CarparkSystemAccessSettingAction {
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u7cfb\u7edf\u7528\u6237/\u89d2\u8272\u8bbe\u7f6e(\u67e5\u8be2)")
    @LeftMenu(name="\u7cfb\u7edf\u7528\u6237/\u89d2\u8272\u8bbe\u7f6e", parent_name="\u57fa\u7840\u8bbe\u7f6e", order=115)
    @Path(value="/showCarparkSystemAccess.action")
    public void showCarparkSystemAccess(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op;
        boolean readOnly = true;
        if ("1".equals(WebUtil.getLoginManageUser(request).getRole_no()) && ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() != 1) {
            request.setAttribute("hasWriteRolePermission", (Object)"1");
            readOnly = false;
        }
        if ((op = request.getParameter("op")) == null) {
            WebUtil.showMainContentWithHead("\u7cfb\u7edf\u7528\u6237\u4e0e\u89d2\u8272\u8bbe\u7f6e", "carparkSystemAccess", request, response);
            return;
        }
        if ("showSystemUser".equals(op) || "showRoleAndPermission".equals(op)) {
            List userList;
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
            Integer project_id = ServiceUtil.getServiceContext().getProjectId();
            List roleList = commonDaoService.selectList(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).setOrerbySql("id"), CarparkRole.class, null);
            if (roleList == null || roleList.isEmpty()) {
                WebUtil.dispathTemplatePage("carparkSystemAccess", request, response);
                return;
            }
            CarparkRole selectedRole = "showRoleAndPermission".equals(op) ? (CarparkRole)roleList.get(roleList.size() - 1) : (CarparkRole)roleList.get(0);
            String role_no = request.getParameter("role_no");
            if (role_no != null && role_no.length() > 0) {
                for (CarparkRole r : roleList) {
                    if (!role_no.equals(r.getRole_no())) continue;
                    selectedRole = r;
                    break;
                }
            }
            request.setAttribute("roleList", (Object)roleList);
            request.setAttribute("selectedRole", (Object)selectedRole);
            if ("showSystemUser".equals(op) && (userList = commonDaoService.selectList(new SearchParam().addEQ("role_no", (Object)selectedRole.getRole_no()).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).setOrerbySql("id"), CarparkUser.class, null)) != null && !userList.isEmpty()) {
                request.setAttribute("userList", (Object)userList);
            }
            WebUtil.dispathTemplatePage("carparkSystemAccess", request, response);
        } else if ("showRolePermissions".equals(op)) {
            HashMap<String, String> unSelectedMap;
            Map.Entry<String, String> m8;
            String role_no = request.getParameter("role_no");
            if (role_no == null) {
                role_no = "";
            }
            Map<String, String> manageMap = ServiceUtil.getServiceContext().getPermissionManager().getPermissionMap(1);
            Map<String, String> clientMap = ServiceUtil.getServiceContext().getPermissionManager().getPermissionMap(0);
            HashMap<String, String> allPerMissionMap = new HashMap<String, String>();
            String m = "[\u7ba1\u7406\u7cfb\u7edf]";
            String c = "[\u8f66\u9053\u7cfb\u7edf]";
            for (Map.Entry<String, String> entry : manageMap.entrySet()) {
                allPerMissionMap.put(entry.getKey(), String.valueOf(m) + entry.getValue());
            }
            for (Map.Entry<String, String> entry : clientMap.entrySet()) {
                allPerMissionMap.put(entry.getKey(), String.valueOf(c) + entry.getValue());
            }
            PriorityQueue<Map.Entry<String, String>> queueList = new PriorityQueue<Map.Entry<String, String>>(allPerMissionMap.size(), new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            for (Map.Entry entry : allPerMissionMap.entrySet()) {
                queueList.offer(entry);
            }
            LinkedHashMap<String, String> allPerMissionMap0 = new LinkedHashMap<String, String>();
            while ((m8 = queueList.poll()) != null) {
                allPerMissionMap0.put(m8.getKey(), m8.getValue());
            }
            Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
            Integer project_id = ServiceUtil.getServiceContext().getProjectId();
            if ("1".equals(role_no)) {
                unSelectedMap = null;
            } else {
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                List list = commonDaoService.selectList(new SearchParam().addEQ("role_no", (Object)role_no).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id), CarparkRolePermission.class, null);
                if (list != null && !list.isEmpty()) {
                    for (CarparkRolePermission cp : list) {
                        allPerMissionMap.remove(cp.getPermission_no());
                    }
                }
                unSelectedMap = allPerMissionMap;
            }
            allPerMissionMap = allPerMissionMap0;
            boolean canModify = true;
            if (readOnly) {
                canModify = false;
            } else if ("1".equals(role_no)) {
                canModify = false;
            } else if (!"1".equals(WebUtil.getLoginManageUser(request).getRole_no())) {
                canModify = false;
            }
            String canModifyAllValue = canModify ? Constants.YES_STR : Constants.NO_STR;
            ArrayList alist = new ArrayList(allPerMissionMap.size());
            String idStr = "id";
            String permissionValueStr = "permissionValue";
            String selectedStr = "selected";
            String canModifyStr = "canModify";
            String canModifyAllStr = "canModifyAll";
            for (Map.Entry entry : allPerMissionMap.entrySet()) {
                LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
                dataMap.put("id", BytesTool.compressBytes((byte[])((String)entry.getKey()).getBytes("UTF-8")));
                dataMap.put("permissionValue", (String)entry.getValue());
                dataMap.put("selected", unSelectedMap != null && unSelectedMap.containsKey(entry.getKey()) ? Constants.NO_STR : Constants.YES_STR);
                dataMap.put("canModify", canModify ? Constants.YES_STR : Constants.NO_STR);
                dataMap.put("canModifyAll", canModifyAllValue);
                alist.add(dataMap);
            }
            HashMap rMap = new HashMap();
            rMap.put("data", alist);
            String json = GsonBuilder.create().toJson(rMap);
            WebUtil.printFinshJson(response, json);
        }
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u7cfb\u7edf\u7528\u6237/\u89d2\u8272\u8bbe\u7f6e-\u65b0\u589e\u7cfb\u7edf\u64cd\u4f5c\u7528\u6237")
    @Path(value="/addSystemUser.action")
    public void addSystemUser(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String user_code = request.getParameter("user_code");
        String user_name = request.getParameter("user_name");
        String role_no = request.getParameter("role_no");
        String user_phone = request.getParameter("user_phone");
        String password = request.getParameter("password");
        if (user_code == null || (user_code = user_code.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u7528\u6237\u8d26\u53f7", response);
            return;
        }
        if (user_code.getBytes("UTF-8").length > 45) {
            WebUtil.printFinshJson(1, "\u7528\u6237\u8d26\u53f7\u8fc7\u957f", response);
            return;
        }
        if (user_name == null || (user_name = user_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u7528\u6237\u540d\u79f0", response);
            return;
        }
        if (user_name.getBytes("UTF-8").length > 45) {
            WebUtil.printFinshJson(1, "\u7528\u6237\u540d\u79f0\u8fc7\u957f", response);
            return;
        }
        if (role_no == null || (role_no = role_no.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u9009\u62e9\u89d2\u8272", response);
            return;
        }
        if ("1".equals(role_no) && !"admin".equals(WebUtil.getLoginManageUser(request).getUser_code())) {
            response.sendError(403);
            return;
        }
        if (password == null || (password = password.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u767b\u5f55\u5bc6\u7801", response);
            return;
        }
        if (user_phone == null) {
            user_phone = "";
        }
        user_phone = user_phone.trim();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkUser.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("user_code", (Object)user_code));
        if (count > 0L) {
            WebUtil.printFinshJson(1, "\u7528\u6237\u8d26\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u4e00\u4e2a", response);
            return;
        }
        count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkUser.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("user_name", (Object)user_name));
        if (count > 0L) {
            WebUtil.printFinshJson(1, "\u7528\u6237\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u4e00\u4e2a", response);
            return;
        }
        if (user_phone.length() > 0 && (count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkUser.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("user_phone", (Object)user_phone))) > 0L) {
            WebUtil.printFinshJson(1, "\u624b\u673a\u53f7\u5df2\u7ecf\u5b58\u5728", response);
            return;
        }
        Date now = ServiceUtil.getNow();
        CarparkUser user = new CarparkUser();
        user.setCan_del(1);
        user.setCarpark_id(carpark_id);
        user.setCreated_time(now);
        user.setId(commonDaoService.getSequece("ck_common_seq"));
        user.setLast_updated_time(now);
        user.setPassword(CryptoUtil.MD5Encode((String)password));
        user.setProject_id(project_id);
        user.setRole_no(role_no);
        user.setUser_code(user_code);
        user.setUser_name(user_name);
        user.setUser_phone(user_phone);
        user.setUser_state(0);
        commonDaoService.insert((Object)user);
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u7cfb\u7edf\u7528\u6237/\u89d2\u8272\u8bbe\u7f6e-\u4fee\u6539\u7cfb\u7edf\u64cd\u4f5c\u7528\u6237")
    @Path(value="/updateSystemUser.action")
    public void updateSystemUser(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long count;
        String _id = request.getParameter("id");
        String user_name = request.getParameter("user_name");
        String role_no = request.getParameter("role_no");
        String user_phone = request.getParameter("user_phone");
        if (_id == null || (_id = _id.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u7f16\u53f7", response);
            return;
        }
        Long id = Long.valueOf(_id);
        if (user_name == null || (user_name = user_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u7528\u6237\u540d\u79f0", response);
            return;
        }
        if (user_name.getBytes("UTF-8").length > 45) {
            WebUtil.printFinshJson(1, "\u7528\u6237\u540d\u79f0\u8fc7\u957f", response);
            return;
        }
        if (role_no == null || (role_no = role_no.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u9009\u62e9\u89d2\u8272", response);
            return;
        }
        if (user_phone == null) {
            user_phone = "";
        }
        user_phone = user_phone.trim();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkUser olduser = (CarparkUser)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkUser.class);
        if (olduser == null) {
            WebUtil.printFinshJson(1, "\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", response);
            return;
        }
        if (!user_name.equals(olduser.getUser_name()) && (count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkUser.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("user_name", (Object)user_name).addNotEQ("id", (Object)id))) > 0L) {
            WebUtil.printFinshJson(1, "\u7528\u6237\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u4e00\u4e2a", response);
            return;
        }
        if (user_phone.length() > 0 && !user_phone.equals(olduser.getUser_phone()) && (count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkUser.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("user_phone", (Object)user_phone).addNotEQ("id", (Object)id))) > 0L) {
            WebUtil.printFinshJson(1, "\u624b\u673a\u53f7\u5df2\u7ecf\u5b58\u5728", response);
            return;
        }
        CarparkUser currentUser = WebUtil.getLoginManageUser(request);
        CarparkUser updateUser = new CarparkUser();
        boolean needUpdate = false;
        if (!user_phone.equals(olduser.getUser_phone())) {
            updateUser.setUser_phone(user_phone);
            needUpdate = true;
        }
        if (!"admin".equals(olduser.getUser_code())) {
            if (currentUser.getUser_code().equals(olduser.getUser_code())) {
                if (!user_name.equals(olduser.getUser_name())) {
                    updateUser.setUser_name(user_name);
                    needUpdate = true;
                }
            } else if (!user_name.equals(olduser.getUser_name())) {
                updateUser.setUser_name(user_name);
                needUpdate = true;
            }
            if ("1".equals(role_no) && !"1".equals(olduser.getRole_no()) && !"admin".equals(currentUser.getUser_code())) {
                response.sendError(403);
                return;
            }
            if (!role_no.equals(olduser.getRole_no())) {
                updateUser.setRole_no(role_no);
                needUpdate = true;
            }
        } else if (!"admin".equals(currentUser.getUser_code())) {
            response.sendError(403);
            return;
        }
        if (needUpdate) {
            updateUser.setId(id);
            updateUser.setLast_updated_time(ServiceUtil.getNow());
            commonDaoService.updateByPrimeryKey((Object)updateUser);
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Path(value="/resetSystemUserPasswd.action")
    public void resetSystemUserPasswd(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String userId = request.getParameter("id");
        if (userId == null || (userId = userId.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u7528\u6237\u7f16\u53f7", response);
            return;
        }
        String newPwd = request.getParameter("newPwd");
        if (newPwd == null || (newPwd = newPwd.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u65b0\u5bc6\u7801", response);
            return;
        }
        Long id = Long.valueOf(userId);
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkUser olduser = (CarparkUser)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkUser.class);
        if (olduser == null) {
            WebUtil.printFinshJson(1, "\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664", response);
            return;
        }
        if ("admin".equals(olduser.getUser_code())) {
            response.sendError(403);
            return;
        }
        CarparkUser currentUser = WebUtil.getLoginManageUser(request);
        if (!"1".equals(currentUser.getRole_no())) {
            response.sendError(403);
            return;
        }
        if ("1".equals(olduser.getRole_no()) && !"admin".equals(currentUser.getUser_code())) {
            response.sendError(403);
            return;
        }
        String pwd = CryptoUtil.MD5Encode((String)newPwd);
        if (!pwd.equals(olduser.getPassword())) {
            CarparkUser uuser = new CarparkUser();
            uuser.setPassword(pwd);
            uuser.setLast_updated_time(ServiceUtil.getNow());
            uuser.setId(id);
            commonDaoService.updateByPrimeryKey((Object)uuser);
        }
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Permission(value="\u7cfb\u7edf\u8bbe\u7f6e-\u57fa\u7840\u8bbe\u7f6e-\u7cfb\u7edf\u7528\u6237/\u89d2\u8272\u8bbe\u7f6e-\u5220\u9664\u7cfb\u7edf\u64cd\u4f5c\u7528\u6237")
    @Path(value="/delSystemUser.action")
    public void delSystemUser(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String userId = request.getParameter("id");
        if (userId == null || (userId = userId.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u7528\u6237\u7f16\u53f7", response);
            return;
        }
        Long id = Long.valueOf(userId);
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        CarparkUser olduser = (CarparkUser)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)id), CarparkUser.class);
        if (olduser == null) {
            WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
            return;
        }
        if ("admin".equals(olduser.getUser_code())) {
            response.sendError(403);
            return;
        }
        if ("1".equals(olduser.getRole_no()) && !"admin".equals(WebUtil.getLoginManageUser(request).getUser_code())) {
            response.sendError(403);
            return;
        }
        commonDaoService.delete(new SearchParam(commonDaoService.getTableName(CarparkUser.class)).addEQ("id", (Object)id));
        WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f", response);
    }

    @WritePermission
    @Path(value="/addSystemRole.action")
    public void addSystemRole(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!"1".equals(WebUtil.getLoginManageUser(request).getRole_no())) {
            response.sendError(403);
            return;
        }
        String role_name = request.getParameter("role_name");
        if (role_name == null || (role_name = role_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u89d2\u8272\u540d", response);
            return;
        }
        if (role_name.getBytes("UTF-8").length > 45) {
            WebUtil.printFinshJson(1, "\u89d2\u8272\u540d\u79f0\u8fc7\u957f", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkRole.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("role_name", (Object)role_name));
        if (count > 0L) {
            WebUtil.printFinshJson(1, "\u89d2\u8272\u540d\u79f0\u5df2\u7ecf\u5b58\u5728", response);
            return;
        }
        Date now = WebUtil.getNow();
        CarparkRole role = new CarparkRole();
        role.setCan_del(1);
        role.setCarpark_id(carpark_id);
        role.setCreated_time(now);
        role.setId(commonDaoService.getSequece("ck_common_seq"));
        role.setLast_updated_time(now);
        role.setProject_id(project_id);
        role.setRole_name(role_name);
        role.setRole_no("C" + role.getId().toString());
        commonDaoService.insert((Object)role);
        WebUtil.printFinshJson(0, role.getRole_no(), response);
    }

    @WritePermission
    @Path(value="/updateSystemRole.action")
    public void updateSystemRole(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!"1".equals(WebUtil.getLoginManageUser(request).getRole_no())) {
            response.sendError(403);
            return;
        }
        String role_no = request.getParameter("role_no");
        if (role_no == null || (role_no = role_no.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u7f16\u53f7", response);
            return;
        }
        if ("1".equals(role_no)) {
            WebUtil.printFinshJson(1, "\u60a8\u4e0d\u80fd\u4fee\u6539\u8d85\u7ea7\u7ba1\u7406\u5458\u7684\u89d2\u8272\u540d\u79f0", response);
            return;
        }
        String role_name = request.getParameter("role_name");
        if (role_name == null || (role_name = role_name.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u8bf7\u8f93\u5165\u89d2\u8272\u540d", response);
            return;
        }
        if (role_name.getBytes("UTF-8").length > 45) {
            WebUtil.printFinshJson(1, "\u89d2\u8272\u540d\u79f0\u8fc7\u957f", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CarparkRole oldRole = (CarparkRole)commonDaoService.selectOne(new SearchParam(commonDaoService.getTableName(CarparkRole.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("role_no", (Object)role_no), CarparkRole.class);
        if (oldRole == null) {
            WebUtil.printFinshJson(1, "\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u5220\u9664", response);
            return;
        }
        if (!role_name.equals(oldRole.getRole_name())) {
            long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkRole.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("role_name", (Object)role_name).addNotEQ("id", (Object)oldRole.getId()));
            if (count > 0L) {
                WebUtil.printFinshJson(1, "\u89d2\u8272\u540d\u79f0\u3010" + role_name + "\u3011\u5df2\u7ecf\u5b58\u5728", response);
                return;
            }
            CarparkRole updateRole = new CarparkRole();
            updateRole.setId(oldRole.getId());
            updateRole.setRole_name(role_name);
            updateRole.setLast_updated_time(WebUtil.getNow());
            commonDaoService.updateByPrimeryKey((Object)updateRole);
        }
        WebUtil.printFinshJson(0, oldRole.getRole_no(), response);
    }

    @WritePermission
    @Path(value="/delSystemRole.action")
    public void delSystemRole(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!"1".equals(WebUtil.getLoginManageUser(request).getRole_no())) {
            response.sendError(403);
            return;
        }
        String role_no = request.getParameter("role_no");
        if (role_no == null || (role_no = role_no.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u7f16\u53f7", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CarparkRole oldRole = (CarparkRole)commonDaoService.selectOne(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("role_no", (Object)role_no), CarparkRole.class);
        if (oldRole == null) {
            WebUtil.printFinshJson(0, "", response);
            return;
        }
        if (oldRole.getCan_del() != 1) {
            response.sendError(403);
            return;
        }
        if (oldRole.getRole_no().equals("1")) {
            response.sendError(403);
            return;
        }
        long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkUser.class)).addEQ("role_no", (Object)role_no).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id));
        if (count > 0L) {
            WebUtil.printFinshJson(1, "\u89d2\u8272:" + oldRole.getRole_name() + " \u4e0b\u8fd8\u6709\u7cfb\u7edf\u7528\u6237\uff0c\u8bf7\u5148\u5220\u9664\u5176\u4e0b\u7684\u7528\u6237\u3002", response);
            return;
        }
        try (SqlSession session = commonDaoService.openSqlSession();){
            try {
                commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkRole.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("role_no", (Object)role_no));
                commonDaoService.delete(session, new SearchParam(commonDaoService.getTableName(CarparkRolePermission.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("role_no", (Object)role_no));
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                throw ex;
            }
        }
        WebUtil.printFinshJson(0, "", response);
    }

    @WritePermission
    @Path(value="/setSystemRolePermission.action")
    public void setSystemRolePermission(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] optionPermissionNos;
        boolean enable;
        if (!"1".equals(WebUtil.getLoginManageUser(request).getRole_no())) {
            response.sendError(403);
            return;
        }
        String role_no = request.getParameter("role_no");
        if (role_no == null || (role_no = role_no.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u89d2\u8272\u7f16\u53f7", response);
            return;
        }
        if ("1".equals(role_no)) {
            response.sendError(403);
            return;
        }
        String ids = request.getParameter("ids");
        if (ids == null || ids.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u8981\u6388\u6743\u7684\u7f16\u53f7", response);
            return;
        }
        String optype = request.getParameter("optype");
        if (optype == null || optype.length() == 0) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u64cd\u4f5c\u7c7b\u578b", response);
            return;
        }
        if (Constants.YES_STR.equals(optype)) {
            enable = true;
        } else if (Constants.NO_STR.equals(optype)) {
            enable = false;
        } else {
            WebUtil.printFinshJson(1, "\u672a\u77e5\u64cd\u4f5c\u7c7b\u578b", response);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Integer carpark_id = ServiceUtil.getServiceContext().getCarparkId();
        Integer project_id = ServiceUtil.getServiceContext().getProjectId();
        CarparkRole oldRole = (CarparkRole)commonDaoService.selectOne(new SearchParam().addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("role_no", (Object)role_no), CarparkRole.class);
        if (oldRole == null) {
            WebUtil.printFinshJson(1, "\u89d2\u8272\u5df2\u7ecf\u88ab\u5220\u9664,\u65e0\u6cd5\u8bbe\u7f6e\u5176\u6743\u9650", response);
            return;
        }
        HashSet<String> needOptionNos = new HashSet<String>();
        String[] stringArray = optionPermissionNos = ids.split(",");
        int n = optionPermissionNos.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ((s = s.trim()).length() != 0) {
                try {
                    String pem = new String(BytesTool.unCompress((String)s), "UTF-8");
                    needOptionNos.add(pem);
                }
                catch (Exception ex) {
                    WebUtil.printFinshJson(1, "\u5b58\u5728\u672a\u77e5\u6743\u9650\u503c, \u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u63d0\u4ea4", response);
                    return;
                }
            }
            ++n2;
        }
        if (needOptionNos.isEmpty()) {
            WebUtil.printFinshJson(1, "\u7f3a\u5c11\u9700\u8981\u64cd\u4f5c\u7684\u6743\u9650\u9879", response);
            return;
        }
        int oppCouunnt = needOptionNos.size();
        if (needOptionNos.size() == 1) {
            CarparkRolePermission permission = (CarparkRolePermission)commonDaoService.selectOne(new SearchParam(commonDaoService.getTableName(CarparkRolePermission.class)).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("role_no", (Object)role_no).addEQ("permission_no", ServiceUtil.getFirstElement(needOptionNos)), CarparkRolePermission.class);
            if (enable) {
                if (permission == null) {
                    CarparkRolePermission p = new CarparkRolePermission();
                    p.setCarpark_id(carpark_id);
                    p.setId(commonDaoService.getSequece("ck_common_seq"));
                    p.setLast_updated_time(ServiceUtil.getNow());
                    p.setPermission_no((String)ServiceUtil.getFirstElement(needOptionNos));
                    p.setProject_id(project_id);
                    p.setRole_no(role_no);
                    commonDaoService.insert((Object)p);
                }
            } else if (permission != null) {
                commonDaoService.delete(new SearchParam(commonDaoService.getTableName(CarparkRolePermission.class)).addEQ("id", (Object)permission.getId()));
            }
        } else {
            List listp = commonDaoService.selectList(new SearchParam().setQueryFields(new String[]{"id", "permission_no"}).addEQ("carpark_id", (Object)carpark_id).addEQ("project_id", (Object)project_id).addEQ("role_no", (Object)role_no), CarparkRolePermission.class, null);
            LinkedList<Long> delList = null;
            if (listp != null && !listp.isEmpty()) {
                for (CarparkRolePermission p : listp) {
                    if (enable) {
                        if (!needOptionNos.contains(p.getPermission_no())) continue;
                        needOptionNos.remove(p.getPermission_no());
                        continue;
                    }
                    if (!needOptionNos.contains(p.getPermission_no())) continue;
                    if (delList == null) {
                        delList = new LinkedList<Long>();
                    }
                    delList.add(p.getId());
                }
            }
            if (enable) {
                if (!needOptionNos.isEmpty()) {
                    Date now = ServiceUtil.getNow();
                    ArrayList<CarparkRolePermission> addList = new ArrayList<CarparkRolePermission>(needOptionNos.size());
                    for (String s : needOptionNos) {
                        CarparkRolePermission p = new CarparkRolePermission();
                        p.setCarpark_id(carpark_id);
                        p.setId(commonDaoService.getSequece("ck_common_seq"));
                        p.setLast_updated_time(now);
                        p.setPermission_no(s);
                        p.setProject_id(project_id);
                        p.setRole_no(role_no);
                        addList.add(p);
                    }
                    commonDaoService.insertBatch(addList, commonDaoService.getTableName(CarparkRolePermission.class));
                }
            } else if (delList != null && !delList.isEmpty()) {
                if (delList.size() == 1) {
                    commonDaoService.delete(new SearchParam(commonDaoService.getTableName(CarparkRolePermission.class)).addEQ("id", delList.get(0)));
                } else if (delList.size() <= 100) {
                    commonDaoService.delete(new SearchParam(commonDaoService.getTableName(CarparkRolePermission.class)).addINList("id", (Collection)delList));
                } else {
                    int fethSize = 100;
                    LinkedList<Long> ax = new LinkedList<Long>();
                    for (Long a : delList) {
                        ax.add(a);
                        if (ax.size() < fethSize) continue;
                        commonDaoService.delete(new SearchParam(commonDaoService.getTableName(CarparkRolePermission.class)).addINList("id", ax));
                        ax.clear();
                    }
                    if (!ax.isEmpty()) {
                        commonDaoService.delete(new SearchParam(commonDaoService.getTableName(CarparkRolePermission.class)).addINList("id", ax));
                    }
                }
            }
        }
        WebUtil.printFinshJson(0, String.valueOf(oppCouunnt), response);
    }
}

