/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.action.manage;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.dto.Carpark;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.vo.LeftMenuVo;
import com.wovoe.carpark.web.WebUtil;
import com.wovoe.carpark.web.WritePermission;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.web.Action;
import com.wovoe.framework.web.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Action(value="/manage")
public class IndexAction {
    private String findCanShowPage(List<LeftMenuVo> listvo) {
        if (listvo == null || listvo.isEmpty()) {
            return null;
        }
        for (LeftMenuVo vo : listvo) {
            if (vo == null) continue;
            if (vo.getPath() != null && vo.getPath().length() > 0 && !"/manage/index.action".equals(vo.getPath())) {
                return vo.getPath();
            }
            return this.findCanShowPage(vo.getChildren());
        }
        return null;
    }

    @Path(value="/index.action")
    public void index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Set permissions = (Set)request.getSession(false).getAttribute("MANAGE_USER_PERMISSIONS");
        boolean haveIndexPage = permissions.contains("visit_web_manage_index_page");
        haveIndexPage = false;
        if (!haveIndexPage) {
            List list = (List)request.getSession(false).getAttribute("MANAGE_USER_LEFT_MENU");
            if (list != null && !list.isEmpty()) {
                for (Object k : list) {
                    LeftMenuVo vo = (LeftMenuVo)k;
                    if (vo == null) continue;
                    if (vo.getPath() != null && vo.getPath().length() > 0 && !"/manage/index.action".equals(vo.getPath())) {
                        response.sendRedirect(String.valueOf(request.getContextPath()) + vo.getPath());
                        return;
                    }
                    String path = this.findCanShowPage(vo.getChildren());
                    if (path == null || path.length() <= 0) continue;
                    response.sendRedirect(String.valueOf(request.getContextPath()) + path);
                    return;
                }
            }
            WebUtil.showMainContentWithHead("\u9996\u9875", null, request, response);
            return;
        }
        WebUtil.showMainContentWithHead("\u9996\u9875", "index", request, response);
    }

    @WritePermission
    @Path(value="/modifyLoginPwd.action")
    public void modifyLoginPwd(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String oldPwd = request.getParameter("old_login_pwd");
        String newPwd = request.getParameter("new_login_pwd");
        if (oldPwd == null || (oldPwd = oldPwd.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u767b\u5f55\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", response);
            return;
        }
        if (newPwd == null || (newPwd = newPwd.trim()).length() == 0) {
            WebUtil.printFinshJson(1, "\u64cd\u4f5c\u5931\u8d25\uff0c\u65b0\u767b\u5f55\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", response);
            return;
        }
        CarparkUser user = WebUtil.getLoginManageUser(request);
        if (user == null) {
            WebUtil.printFinshJson(1, "\u64cd\u4f5c\u5931\u8d25\uff0c\u672a\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55", response);
            return;
        }
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        int result = appService.modifyUserPwd(user.getUser_code(), oldPwd, newPwd);
        if (result == 0) {
            WebUtil.printFinshJson(0, "\u64cd\u4f5c\u6210\u529f\uff0c\u5bc6\u7801\u5df2\u6210\u529f\u4fee\u6539", response);
        } else if (result == 3) {
            WebUtil.printFinshJson(3, "\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u767b\u5f55\u5bc6\u7801\u4e0d\u6b63\u786e", response);
        } else {
            WebUtil.printFinshJson(result, "\u64cd\u4f5c\u5931\u8d25\uff01", response);
        }
    }

    @WritePermission
    @Path(value="/formalOperation.action")
    public void formalOperation(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!"admin".equals(WebUtil.getLoginManageUser(request).getUser_code())) {
            WebUtil.printFinshHtml(response, "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"></head><body><div align='center' style='margin-top:50px;font-size:16px;'>\u9700\u8981\u8d85\u7ea7\u7ba1\u7406\u5458\u6743\u9650  <a href='" + request.getContextPath() + "/manage/index.action'>\u8fd4\u56de\u9996\u9875</a></div></body></html>");
            return;
        }
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
            WebUtil.printFinshHtml(response, "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"></head><body><div align='center' style='margin-top:50px;font-size:16px;'>\u8bf7\u8bbf\u95ee\u670d\u52a1\u5668\u4e3b\u673a</div></body></html>");
            return;
        }
        Carpark carpark = ServiceUtil.getServiceContext().getCarpark();
        if (carpark == null) {
            WebUtil.printFinshHtml(response, "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"></head><body><div align='center' style='margin-top:50px;font-size:16px;'>\u7cfb\u7edf\u672a\u521d\u59cb\u5316  <a href='" + request.getContextPath() + "/manage/index.action'>\u8fd4\u56de\u9996\u9875</a></div></body></html>");
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        SearchParam p = new SearchParam("ck_dbsql_version");
        p.addEQ("sql_file_name", (Object)"formalOperation.sql");
        Map dataMap = commonDaoService.selectOne(p);
        if (dataMap != null && dataMap.get("current_version") != null) {
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            cl.set(2020, 0, 1, 0, 0, 0);
            cl.add(13, (Integer)dataMap.get("current_version"));
            WebUtil.printFinshHtml(response, "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"></head><body><div align='center' style='margin-top:50px;font-size:16px;'>\u7cfb\u7edf\u5df2\u5728" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(cl.getTime()) + "\u6b63\u5f0f\u8fd0\u8425  <a href='" + request.getContextPath() + "/manage/index.action'>\u8fd4\u56de\u9996\u9875</a></div></body></html>");
            return;
        }
        if (System.currentTimeMillis() - carpark.getCreated_time().getTime() >= TimeUnit.DAYS.toMillis(90L)) {
            WebUtil.printFinshHtml(response, "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"></head><body><div align='center' style='margin-top:50px;font-size:16px;'>\u7cfb\u7edf\u5df2\u6b63\u5f0f\u8fd0\u8425 <a href='" + request.getContextPath() + "/manage/index.action'>\u8fd4\u56de\u9996\u9875</a> </div></body></html>");
            return;
        }
        String op = request.getParameter("op");
        if ("doFormalOperation".equals(op)) {
            RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            Date now = cl.getTime();
            recordSaveService.doFormalOperation(true, now);
            HashMap<String, Object> inertMap = new HashMap<String, Object>();
            inertMap.put("sql_file_name", "formalOperation.sql");
            long x = cl.getTimeInMillis() / 1000L;
            cl.set(2020, 0, 1, 0, 0, 0);
            long x1 = cl.getTimeInMillis() / 1000L;
            int h = (int)(x - x1);
            inertMap.put("current_version", h);
            commonDaoService.insert(inertMap, "ck_dbsql_version");
            commonDaoService.delete(new SearchParam("ck_carpark_fee_report").addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId()));
            WebUtil.insertCarparkOperationLog(null, request, Constants.LOG_OP_CAT_3, Constants.LOG_OP_TYPE_CAT_3_1, "\u5220\u9664\u4e4b\u524d\u6240\u6709\u5386\u53f2\u8bb0\u5f55, \u7cfb\u7edf\u542f\u52a8\u6b63\u5f0f\u8fd0\u8425");
            WebUtil.printFinshHtml(response, "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"></head><body><div align='center' style='margin-top:50px;font-size:16px;'>\u64cd\u4f5c\u6210\u529f, \u7cfb\u7edf\u5df2\u6b63\u5f0f\u8fd0\u8425  <a href='" + request.getContextPath() + "/manage/index.action'>\u8fd4\u56de\u9996\u9875</a></div></body></html>");
            return;
        }
        StringBuilder sbr = new StringBuilder(256);
        sbr.append("<!DOCTYPE html><html><head><meta charset=\"UTF-8\"></head><body>");
        sbr.append("<div align='center' style='margin-top:50px;font-size:16px;'><form action='").append(request.getContextPath()).append("/manage/formalOperation.action' method='post'><input type='hidden' name='op' value='doFormalOperation'><p>\u60a8\u786e\u5b9a\u8981\u542f\u7528\u6b63\u5f0f\u8fd0\u8425\u529f\u80fd\u5417?</p><p>\u5982\u679c\u542f\u7528, \u7cfb\u7edf\u5c06\u5220\u9664\u4e4b\u524d\u8fd0\u884c\u7684\u6240\u6709\u5386\u53f2\u8bb0\u5f55</p><p>\u8be5\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u800c\u4e14\u53ea\u5141\u8bb8\u4f7f\u7528\u4e00\u6b21</p><p>\u5982\u679c\u5e0c\u671b\u7ee7\u7eed\u6b64\u64cd\u4f5c\uff0c\u8bf7\u70b9\u51fb\u786e\u5b9a\uff0c\u5982\u679c\u653e\u5f03\uff0c\u8bf7\u70b9\u51fb\u8fd4\u56de\u9996\u9875</p><div><input type='button' value='\u8fd4\u56de\u9996\u9875'  onclick=\"location.href='").append(request.getContextPath()).append("/manage/index.action'\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type='submit' value='\u786e\u5b9a\u542f\u7528'> </div></form></div>");
        sbr.append("</body></html>");
        WebUtil.printFinshHtml(response, sbr.toString());
    }
}

