/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.web.intercepter;

import com.wovoe.carpark.RpcReomtecServiceFactory;
import com.wovoe.carpark.internel.DefaultRpcReomtecServiceFactory;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.http.HttpResponseCallback;
import com.wovoe.framework.http.HttpUtil;
import com.wovoe.framework.transfer.DataProtocol;
import com.wovoe.framework.transfer.IOResponse;
import com.wovoe.framework.transfer.ResultResponse;
import com.wovoe.framework.transfer.ResultResponseMap;
import com.wovoe.framework.transfer.ServiceAction;
import com.wovoe.framework.transfer.ServiceActionManager;
import com.wovoe.framework.transfer.ServiceRequest;
import com.wovoe.framework.transfer.TransferCrypto;
import com.wovoe.framework.transfer.connection.WaitResultTimeout;
import com.wovoe.framework.web.RequestIntercepter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DatatTransferIntercepter
implements RequestIntercepter {
    private final String intercepterPath = "/datatransfer/gateway/";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean intercepter(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path = ServiceUtil.getServiceContext().getRequestActionManager().getRequestPath(request);
        if (!path.startsWith("/datatransfer/gateway/")) return true;
        String hexUri = path.substring("/datatransfer/gateway/".length(), path.length());
        if (hexUri.indexOf(47) >= 0) return true;
        try {
            ResultResponse res;
            ServletIOResponse re;
            DataProtocol dataFrame;
            String exeHostNo;
            String signKey = ServiceUtil.getServiceContext().getCarpark().getLan_sign_key();
            TransferCrypto crypto = ServiceUtil.getServiceContext().getTransferCrypto();
            try {
                byte[] hexValue = ServiceUtil.getServiceContext().getCrypto().decrypt(BytesTool.unCompress((String)hexUri));
                int index = 0;
                int remoteHostNoLen = BytesTool.bytesToInt((byte[])hexValue, (int)index);
                String remoteHostNo = new String(hexValue, index += 4, remoteHostNoLen, "UTF-8");
                if (!ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().containsKey(remoteHostNo)) {
                    response.sendError(403, "\u62d2\u7edd\u8fde\u63a5!");
                    return false;
                }
                int exeHostNolen = BytesTool.bytesToInt((byte[])hexValue, (int)(index += remoteHostNoLen));
                exeHostNo = new String(hexValue, index += 4, exeHostNolen, "UTF-8");
            }
            catch (Exception ex) {
                response.sendError(400, "\u65e0\u6548URI!");
                return false;
            }
            boolean isLocalExe = ServiceUtil.getServiceContext().getLocalHostNo().equals(exeHostNo);
            try {
                StringBuffer s = new StringBuffer(128);
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "UTF-8"));){
                    String tmp;
                    while ((tmp = br.readLine()) != null) {
                        s.append(tmp);
                    }
                }
                String p = s.toString();
                if (p.length() == 0) {
                    response.sendError(400, "\u7f3a\u5c11\u53c2\u6570!");
                    return false;
                }
                dataFrame = isLocalExe ? DataProtocol.parse((String)p, (String)signKey, (TransferCrypto)crypto) : DataProtocol.parse((String)p, (String)signKey, (TransferCrypto)crypto, (boolean)false);
                if (dataFrame.getCmd() == null || dataFrame.getCmd().endsWith("Result")) {
                    response.sendError(400, "\u9519\u8bef\u7684\u8bf7\u6c42\u547d\u4ee4!");
                    return false;
                }
                if (dataFrame.getMsgId() == null || dataFrame.getMsgId().length() == 0) {
                    response.sendError(400, "\u9519\u8bef\u7684\u8bf7\u6c42id!");
                    return false;
                }
            }
            catch (Exception ex) {
                response.sendError(400, "\u975e\u6cd5\u8bf7\u6c42!");
                return false;
            }
            if (isLocalExe) {
                this.execute(request, response, dataFrame, signKey, crypto);
                return false;
            }
            RpcReomtecServiceFactory factory = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(exeHostNo, false);
            if (factory == null) {
                re = new ServletIOResponse(request, response, dataFrame.getMsgId(), signKey, crypto);
                res = new ResultResponse();
                res.setResponseCode("500");
                res.setResponseMsg("\u9519\u8bef\u4e3b\u673a:" + exeHostNo);
                re.doResponse(String.valueOf(dataFrame.getCmd()) + "Result", res);
                return false;
            }
            if (!(factory instanceof DefaultRpcReomtecServiceFactory)) {
                re = new ServletIOResponse(request, response, dataFrame.getMsgId(), signKey, crypto);
                res = new ResultResponse();
                res.setResponseCode("500");
                res.setResponseMsg("\u65e0\u6cd5\u4ee3\u7406\u4e3b\u673a\u8bf7\u6c42:" + exeHostNo + ",\u8bf7\u4f7f\u7528DefaultRpcReomtecServiceFactory");
                re.doResponse(String.valueOf(dataFrame.getCmd()) + "Result", res);
                return false;
            }
            try {
                DefaultRpcReomtecServiceFactory rpcf = (DefaultRpcReomtecServiceFactory)factory;
                int conenctTimeMills = rpcf.getConnectTimeoutMills();
                int readTimeMills = rpcf.getReadTimeoutMills();
                String json = dataFrame.toSendString(rpcf.getSecurityGetter().getSignKey(), rpcf.getSecurityGetter().getCrypto());
                if (conenctTimeMills <= 0) {
                    conenctTimeMills = 5000;
                }
                if (readTimeMills <= 0) {
                    readTimeMills = 10000;
                }
                String resultString = (String)HttpUtil.doRequest((String)rpcf.getGateway(), null, null, null, (String)json, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)conenctTimeMills, (int)readTimeMills);
                DataProtocol pol = DataProtocol.parse((String)resultString, (String)rpcf.getSecurityGetter().getSignKey(), (TransferCrypto)rpcf.getSecurityGetter().getCrypto(), (boolean)false);
                String reponseStr = pol.toSendString(signKey, crypto);
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/html");
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setDateHeader("Expires", 0L);
                PrintWriter w = response.getWriter();
                try {
                    w.write(reponseStr);
                    return false;
                }
                finally {
                    try {
                        w.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable ex) {
                if (!response.isCommitted()) {
                    ServletIOResponse re2 = new ServletIOResponse(request, response, dataFrame.getMsgId(), signKey, crypto);
                    ResultResponse res2 = new ResultResponse();
                    res2.setResponseCode("500");
                    res2.setResponseMsg("\u65e0\u6cd5\u5904\u7406\u4ee3\u7406\u4e3b\u673a\u8bf7\u6c42:" + exeHostNo + ",\u539f\u56e0:" + ex.getMessage());
                    re2.doResponse(String.valueOf(dataFrame.getCmd()) + "Result", res2);
                    return false;
                }
                ServiceLog.getLog().error((Object)("\u65e0\u6cd5\u5904\u7406\u4ee3\u7406\u4e3b\u673a\u8bf7\u6c42:" + exeHostNo + ",\u539f\u56e0:" + ex.getMessage()));
                return false;
            }
        }
        catch (Throwable ex) {
            try {
                if (!response.isCommitted()) {
                    response.sendError(400, ex.getMessage());
                }
            }
            catch (Exception ex1) {
                ServiceLog.getLog().error((Object)ex1.getMessage());
            }
            ServiceLog.getLog().error((Object)ex.getMessage());
        }
        return false;
    }

    private void execute(HttpServletRequest request, HttpServletResponse response, DataProtocol p, String signKey, TransferCrypto crypto) throws Exception {
        try {
            ServiceAction action = ServiceActionManager.getInstance().getServiceAction(p.getCmd());
            ServletIOResponse re = new ServletIOResponse(request, response, p.getMsgId(), signKey, crypto);
            if (action != null) {
                action.execute((ServiceRequest)p, (IOResponse)re);
            } else {
                ResultResponse res = new ResultResponse();
                res.setResponseCode("404");
                res.setResponseMsg("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u547d\u4ee4: " + p.getCmd() + ", \u6b64\u670d\u52a1\u4e0d\u6388\u652f\u6301\uff01");
                re.doResponse(String.valueOf(p.getCmd()) + "Result", res);
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"handle error!", (Throwable)ex);
        }
    }

    private static class ServletIOResponse
    implements IOResponse {
        private HttpServletResponse response0;
        private HttpServletRequest request0;
        private String msgId;
        private String signKey;
        private TransferCrypto crypto;
        private AsyncContext asyncContext;

        public ServletIOResponse(HttpServletRequest request, HttpServletResponse response, String msgId, String signKey, TransferCrypto crypto) {
            this.request0 = request;
            this.response0 = response;
            this.msgId = msgId;
            this.signKey = signKey;
            this.crypto = crypto;
        }

        private void doResponse0(String cmd, Object data) throws IOException {
            try {
                HttpServletResponse response = this.asyncContext != null ? (HttpServletResponse)this.asyncContext.getResponse() : this.response0;
                DataProtocol f = new DataProtocol();
                f.setCmd(cmd);
                f.setData(data);
                f.setTimeMills(String.valueOf(System.currentTimeMillis()));
                f.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
                f.setMsgId(this.msgId);
                String json = f.toSendString(this.signKey, this.crypto);
                response.setCharacterEncoding("UTF-8");
                response.setContentType("text/html");
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setDateHeader("Expires", 0L);
                PrintWriter w = response.getWriter();
                try {
                    w.write(json);
                }
                finally {
                    try {
                        w.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (this.asyncContext != null) {
                        this.asyncContext.complete();
                    }
                }
                catch (Exception exception) {}
            }
        }

        public void doResponse(final String cmd, Object data) throws IOException {
            try {
                if (data instanceof OperationFuture) {
                    long waiMills = WaitResultTimeout.getAndRemove((long)15000L);
                    if (waiMills <= 0L) {
                        waiMills = 15000L;
                    }
                    this.asyncContext = this.request0.startAsync();
                    this.asyncContext.setTimeout(waiMills + 5000L);
                    OperationFuture opf = (OperationFuture)data;
                    opf.addCompleteListener(new OperationFuture.CompleteListener(){

                        public void operationComplete(OperationFuture future) {
                            if (future.isCancelled()) {
                                this.doResponseX(new ResultResponseMap("501", "operation canceled"));
                            } else if (future.getException() != null) {
                                LogUtil.getLog().warn((Object)("Service: " + cmd + " Asynchronous processing result returns an exception"), future.getException());
                                this.doResponseX(new ResultResponseMap("500", "Internal business processing exception"));
                            } else if (future.getResult() == null) {
                                LogUtil.getLog().warn((Object)("Service: " + cmd + " Asynchronous processing result returns NULL"));
                                this.doResponseX(new ResultResponseMap("502", "Asynchronous processing business return null"));
                            } else {
                                this.doResponseX(future.getResult());
                            }
                        }

                        public void waitCompleteTimeout() {
                            LogUtil.getLog().warn((Object)("Service: " + cmd + " Asynchronous processing result timeout"));
                            this.doResponseX(new ResultResponseMap("501", "Asynchronous processing business timeout"));
                        }

                        private void doResponseX(Object obj) {
                            try {
                                this.doResponse0(cmd, obj);
                            }
                            catch (Throwable ex) {
                                LogUtil.getLog().warn((Object)("Response: " + cmd + ", Excption!" + ex.getMessage()));
                            }
                        }
                    }, waiMills, TimeUnit.MILLISECONDS);
                } else {
                    this.doResponse0(cmd, data);
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"response error!", (Throwable)ex);
            }
        }
    }
}

