/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.usb.dog;

import com.softkey.jsyunew3;
import com.wovoe.carpark.usb.dog.BytesTool;
import com.wovoe.carpark.usb.dog.DogWriteData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class UsbDogTool {
    static final String getData(String readKey) {
        List<String> list = UsbDogTool.getAllDevicePath(20);
        if (list == null || list.isEmpty()) {
            return "1";
        }
        StringBuilder sbr = new StringBuilder(256);
        String succs = "0,";
        String lastError = null;
        for (String devicePath : list) {
            String s = UsbDogTool.getData(readKey, devicePath);
            if (s == null || s.length() <= 0) continue;
            if (s.startsWith(succs)) {
                if (sbr.length() > 0) {
                    sbr.append(";");
                }
                sbr.append(s);
                continue;
            }
            lastError = s;
        }
        if (sbr.length() > 0) {
            return sbr.toString();
        }
        if (lastError == null || lastError.length() == 0) {
            lastError = "3";
        }
        return lastError;
    }

    private static final String getData(String readKey, String devicePath) {
        block9: {
            DogWriteData readData;
            String id;
            block10: {
                block8: {
                    block7: {
                        block6: {
                            try {
                                if (devicePath != null && devicePath.length() != 0) break block6;
                                return "1";
                            }
                            catch (Throwable ex) {
                                return "4";
                            }
                        }
                        id = UsbDogTool.getIdHex(devicePath);
                        if (id != null && id.length() != 0) break block7;
                        return "2";
                    }
                    readData = UsbDogTool.readEncrptData(readKey, devicePath);
                    if (readData != null) break block8;
                    return "3";
                }
                if (readData.getResult() != 20000 || readData.getWriteData() == null || readData.getWriteData().length <= 0) break block9;
                if (!readData.isNeedActivation()) break block10;
                return "3";
            }
            return "0," + id + "," + BytesTool.byteArrayToHexString(readData.getWriteData());
        }
        return "3";
    }

    private static DogWriteData readEncrptData(String readKey, String devicePath) {
        int offset = 0;
        int len = 5;
        if (jsyunew3.YReadEx((short)offset, (short)len, readKey, readKey, devicePath) != 0) {
            return null;
        }
        byte[] buf = new byte[len];
        int i = 0;
        while (i < len) {
            buf[i] = (byte)jsyunew3.GetBuf(i);
            ++i;
        }
        int dataLen = (buf[3] & 0xFF) << 8 | buf[4] & 0xFF;
        DogWriteData d = new DogWriteData();
        if (dataLen > 507 || dataLen < 10) {
            d.setResult(10000);
            d.setMsg("Invalid data");
            return d;
        }
        offset = 0;
        if (jsyunew3.YReadEx((short)offset, (short)(len += dataLen), readKey, readKey, devicePath) != 0) {
            return null;
        }
        buf = new byte[len];
        int i2 = 0;
        while (i2 < len) {
            buf[i2] = (byte)jsyunew3.GetBuf(i2);
            ++i2;
        }
        boolean needActiv = (buf[2] & 0xFF) == 0;
        offset = 5;
        byte[] encrypData = new byte[dataLen];
        System.arraycopy(buf, offset, encrypData, 0, encrypData.length);
        d.setWriteData(encrypData);
        d.setNeedActivation(needActiv);
        d.setMsg("Read successful");
        d.setResult(20000);
        return d;
    }

    private static String getIdHex(String devicePath) {
        long id1 = jsyunew3.GetID_1(devicePath);
        if (jsyunew3.get_LastError() != 0L) {
            return null;
        }
        long id2 = jsyunew3.GetID_2(devicePath);
        if (jsyunew3.get_LastError() != 0L) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.allocate(16);
        return UsbDogTool.getIdStr(id1, id2, buf);
    }

    private static String getDevicePath(int port) {
        String devicePath = jsyunew3.FindPort(port);
        if (jsyunew3.get_LastError() == 0L && devicePath != null && devicePath.length() > 0) {
            return devicePath;
        }
        return null;
    }

    private static List<String> getAllDevicePath(int maxPort) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i <= maxPort) {
            String s = UsbDogTool.getDevicePath(i);
            if (s == null || s.length() <= 0) break;
            list.add(s);
            ++i;
        }
        return list;
    }

    private static String getIdStr(long id1, long id2, ByteBuffer buf) {
        byte[] array;
        int length;
        int offset;
        buf.clear();
        buf.putLong(id1);
        buf.putLong(id2);
        buf.flip();
        if (buf.hasArray()) {
            offset = buf.position() + buf.arrayOffset();
            length = buf.remaining();
            array = buf.array();
        } else {
            offset = 0;
            length = buf.remaining();
            array = new byte[length];
            buf.get(array);
        }
        return BytesTool.byteArrayToHexString(array, offset, length);
    }
}

