/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.upgrade;

import com.wovoe.carpark.upgrade.FileProcessCallback;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipInputStream;

public class FileUtil {
    private static File startupDir;

    public static void unPack(String unPackFileName, String destDirName, FileProcessCallback processCallback) {
        FileInputStream fileInputStream = null;
        File zipFile = new File(unPackFileName);
        try {
            try {
                processCallback.start();
                fileInputStream = new FileInputStream(zipFile);
                ZipInputStream zin = new ZipInputStream(fileInputStream);
                FileUtil.unzip(zin, new File(destDirName), processCallback);
                processCallback.finish();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static void unzip(ZipInputStream zin, File destDir, FileProcessCallback processCallback) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File findLocalDir() {
        File findLocalDir = new File(FileUtil.findHomeDir(), "local");
        if (!findLocalDir.exists() || !findLocalDir.isDirectory()) {
            findLocalDir.mkdir();
        }
        return findLocalDir;
    }

    public static File findHomeDir() {
        if (startupDir == null) {
            ProtectionDomain pd = FileUtil.class.getProtectionDomain();
            if (pd == null) {
                return null;
            }
            CodeSource cs = pd.getCodeSource();
            if (cs == null) {
                return null;
            }
            URL url = cs.getLocation();
            if (url == null) {
                return null;
            }
            String result = url.toString();
            if (!result.endsWith(".jar")) {
                if (result.endsWith("/")) {
                    result = result.substring(0, result.length() - 1);
                }
                if (result.endsWith("/bin")) {
                    result = result.substring(0, result.lastIndexOf(47));
                }
            } else {
                result = result.substring(0, result.lastIndexOf(47));
                result = result.substring(0, result.lastIndexOf(47));
            }
            if ((result = result.substring(0, result.lastIndexOf(47))) == null) {
                throw new RuntimeException("Can not find the app boot path.");
            }
            if (Character.isUpperCase(result.charAt(0))) {
                char[] chars = result.toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                result = new String(chars);
            }
            try {
                startupDir = new File(new URI(result));
            }
            catch (URISyntaxException e) {
                new RuntimeException(e);
            }
        }
        return startupDir;
    }

    public static void copyFile(File src, File dstDir, FileProcessCallback processCallback) throws IOException {
        if (!dstDir.exists() || !dstDir.isDirectory()) {
            dstDir.mkdirs();
        }
        if (src.isFile()) {
            File co = new File(dstDir, src.getName());
            if (processCallback != null) {
                processCallback.process(src.getName());
            }
            FileUtil.copyFile(src, co);
        } else if (src.isDirectory()) {
            File[] fl;
            File co = new File(dstDir, src.getName());
            if (!co.exists() || !co.isDirectory()) {
                if (processCallback != null) {
                    processCallback.process(src.getName());
                }
                co.mkdirs();
            }
            if ((fl = src.listFiles()) != null && fl.length > 0) {
                File[] fileArray = fl;
                int n = fl.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    FileUtil.copyFile(f, co, processCallback);
                    ++n2;
                }
            }
        }
    }

    public static void copyFile(File src, File dst) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
                out.flush();
            }
        }
        catch (Throwable throwable) {
            FileUtil.closeInputStream(in);
            FileUtil.closeOutputStream(out);
            throw throwable;
        }
        FileUtil.closeInputStream(in);
        FileUtil.closeOutputStream(out);
    }

    public static void closeInputStream(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void closeOutputStream(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean deleteFile(File delFile, FileProcessCallback processCallback) {
        boolean isok;
        if (processCallback != null) {
            processCallback.start();
        }
        if (delFile.exists()) {
            if (delFile.isFile()) {
                try {
                    if (processCallback != null) {
                        processCallback.process(delFile.getName());
                    }
                    isok = delFile.delete();
                }
                catch (Exception ex) {
                    isok = false;
                }
            } else if (delFile.isDirectory()) {
                AtomicBoolean a = new AtomicBoolean(true);
                FileUtil.deleteFolder01(delFile, a, processCallback);
                isok = a.get();
            } else {
                isok = false;
            }
        } else {
            isok = true;
        }
        if (processCallback != null) {
            processCallback.finish();
        }
        return isok;
    }

    private static void deleteFolder01(File dir, final AtomicBoolean r, final FileProcessCallback processCallback) {
        if (!r.get()) {
            return;
        }
        try {
            dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File paramFile) {
                    if (paramFile.isFile()) {
                        if (processCallback != null) {
                            processCallback.process(paramFile.getAbsolutePath());
                        }
                        r.set(paramFile.delete());
                    } else if (paramFile.isDirectory()) {
                        FileUtil.deleteFolder01(paramFile, r, processCallback);
                    }
                    if (!r.get()) {
                        throw new RuntimeException("\u5220\u9664\u6587\u4ef6\u5931\u8d25!" + paramFile.getAbsolutePath());
                    }
                    return false;
                }
            });
        }
        catch (Throwable ex) {
            r.set(false);
        }
        if (!r.get()) {
            return;
        }
        try {
            if (processCallback != null) {
                processCallback.process(dir.getAbsolutePath());
            }
            r.set(dir.delete());
        }
        catch (Exception ex) {
            r.set(false);
        }
    }
}

