/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.upgrade;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class SwingUtil {
    private static final Set<String> fontFamilyNames = new HashSet<String>();
    public static final String MIC_YAHEI_BOLD = "\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53";
    public static final String DEFAULT_FONT_NAME = "\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53";

    public static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return SwingUtil.getWindowForComponent(parentComponent.getParent());
    }

    public static void setLookAndFeel(String LookAndFeel2) {
        if (LookAndFeel2 == null || (LookAndFeel2 = LookAndFeel2.trim()).length() == 0) {
            LookAndFeel2 = "Nimbus";
        }
        String Nimbus = null;
        String Windows = null;
        String WindowsClassic = null;
        String gtk = null;
        UIManager.LookAndFeelInfo[] installedLookAndFeels = UIManager.getInstalledLookAndFeels();
        int idx = 0;
        while (idx < installedLookAndFeels.length) {
            String v = installedLookAndFeels[idx].getName();
            if (LookAndFeel2.equals(v)) {
                try {
                    UIManager.setLookAndFeel(installedLookAndFeels[idx].getClassName());
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ("Nimbus".equals(v)) {
                Nimbus = installedLookAndFeels[idx].getClassName();
            } else if ("Windows".equals(v)) {
                Windows = installedLookAndFeels[idx].getClassName();
            } else if ("Windows Classic".equals(v)) {
                WindowsClassic = installedLookAndFeels[idx].getClassName();
            } else if ("gtk".equals(v)) {
                gtk = installedLookAndFeels[idx].getClassName();
            }
            ++idx;
        }
        if (Nimbus != null) {
            try {
                UIManager.setLookAndFeel(Nimbus);
            }
            catch (Exception exception) {}
        } else if (Windows != null) {
            try {
                UIManager.setLookAndFeel(Windows);
            }
            catch (Exception exception) {}
        } else if (WindowsClassic != null) {
            try {
                UIManager.setLookAndFeel(WindowsClassic);
            }
            catch (Exception exception) {}
        } else if (gtk != null) {
            try {
                UIManager.setLookAndFeel(gtk);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFontFamily(String familyNames) {
        if (fontFamilyNames.isEmpty()) {
            Set<String> set = fontFamilyNames;
            synchronized (set) {
                if (fontFamilyNames.isEmpty()) {
                    String[] vs;
                    String[] stringArray = vs = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                    int n = vs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String v = stringArray[n2];
                        fontFamilyNames.add(v);
                        ++n2;
                    }
                    if (!fontFamilyNames.contains("Dialog")) {
                        fontFamilyNames.add("Dialog");
                    }
                }
            }
        }
        if (familyNames != null) {
            StringTokenizer token = new StringTokenizer(familyNames, ",");
            while (token.hasMoreTokens()) {
                String v = token.nextToken().trim();
                if (!fontFamilyNames.contains(v)) continue;
                return v;
            }
        }
        return "Dialog";
    }

    public static JButton createImageButton(Icon icon, Icon rolloverIcon) {
        JButton b = new JButton();
        b.setCursor(new Cursor(12));
        b.setContentAreaFilled(false);
        b.setBorderPainted(false);
        b.setIcon(icon);
        if (rolloverIcon != null) {
            b.setRolloverIcon(rolloverIcon);
        }
        b.setHorizontalTextPosition(0);
        return b;
    }

    public static BufferedImage convertToBufferedImage(ImageIcon image) {
        BufferedImage newImage = new BufferedImage(image.getIconWidth(), image.getIconHeight(), 2);
        Graphics2D g = newImage.createGraphics();
        g.drawImage(image.getImage(), 0, 0, null);
        g.dispose();
        return newImage;
    }

    public static Image resizeImage(Image originalImage, int width, int height) {
        return originalImage.getScaledInstance(width, height, 4);
    }

    public static BufferedImage resizeImage(BufferedImage originalImage, int width, int height) {
        if (originalImage == null) {
            return null;
        }
        if (originalImage.getWidth() == width && originalImage.getHeight() == height) {
            return originalImage;
        }
        BufferedImage newImage = new BufferedImage(width, height, originalImage.getType());
        Graphics g = newImage.getGraphics();
        try {
            Image image = originalImage.getScaledInstance(width, height, 4);
            g.drawImage(image, 0, 0, null);
        }
        finally {
            g.dispose();
        }
        return newImage;
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static void invokeLater(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {}
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public static Dimension getStringFontSize(String str, Font font) {
        if (str == null || str.length() == 0) {
            return new Dimension(0, 0);
        }
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        Rectangle2D r = font.getStringBounds(str, frc);
        return new Dimension((int)r.getWidth(), (int)r.getHeight());
    }

    public static void setSpin(JSpinner spinner) {
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner, "0");
        spinner.setEditor(editor);
        JFormattedTextField textField = ((JSpinner.NumberEditor)spinner.getEditor()).getTextField();
        textField.setEditable(true);
        DefaultFormatterFactory factory = (DefaultFormatterFactory)textField.getFormatterFactory();
        NumberFormatter formatter = (NumberFormatter)factory.getDefaultFormatter();
        formatter.setAllowsInvalid(false);
    }
}

