/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.upgrade;

import com.wovoe.carpark.upgrade.SwingUtil;
import com.wovoe.carpark.upgrade.UpdateCallback;
import com.wovoe.carpark.upgrade.XYConstraints;
import com.wovoe.carpark.upgrade.XYLayout;
import com.wovoe.carpark.upgrade.XYPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class WaitDialog
extends JDialog
implements UpdateCallback {
    private static final long serialVersionUID = 3709673421412110519L;
    private XYPanel rootPanel;
    private JLabel textLabel;
    private JProgressBar progressbar;
    private JButton closeOrCancelButton;
    private Dimension screenSize;

    public static WaitDialog createDialog(Component c, Dimension size) {
        int y;
        int x;
        Dimension wsize1;
        WaitDialog.setLookAndFeel(null);
        Frame rootFrame = JOptionPane.getRootFrame();
        Window window = WaitDialog.getWindowForComponent(c);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (size == null) {
            int width = (int)Math.round(screenSize.getHeight() * 500.0 / 768.0);
            int height = (int)Math.round(screenSize.getHeight() * 180.0 / 768.0);
            size = new Dimension(width, height);
        }
        String title = "\u6b63\u5728\u5347\u7ea7... ,\u8fd9\u53ef\u80fd\u9700\u8981\u4e00\u4e9b\u65f6\u95f4 !";
        WaitDialog dialog = window instanceof Frame ? new WaitDialog((Frame)window, title, true) : (window instanceof Dialog ? new WaitDialog((Dialog)window, title, true) : new WaitDialog(window, title, true));
        dialog.screenSize = screenSize;
        Dimension dimension = wsize1 = window == null || rootFrame == window ? screenSize : window.getSize();
        if (wsize1 == null) {
            wsize1 = screenSize;
        }
        if (wsize1.width == 0 && wsize1.height == 0) {
            wsize1 = screenSize;
        }
        if (window != null && rootFrame != window) {
            Point location = window.getLocation();
            x = location == null ? 0 : location.x;
            y = location == null ? 0 : location.y;
        } else {
            x = 0;
            y = 0;
        }
        dialog.setLocation(x + (wsize1.width - size.width) / 2, y + (wsize1.height - size.height) / 2);
        dialog.setResizable(false);
        dialog.setSize(size);
        dialog.init(null);
        dialog.setMaximumSize(size);
        dialog.setMinimumSize(size);
        dialog.setDefaultCloseOperation(0);
        return dialog;
    }

    @Override
    public void setResizable(boolean resizable) {
        super.setResizable(resizable);
        if (this.rootPanel != null) {
            this.rootPanel.setResizable(resizable);
        }
    }

    private static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return WaitDialog.getWindowForComponent(parentComponent.getParent());
    }

    private WaitDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    private WaitDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    private WaitDialog(Window owner, String title, boolean modal) {
        super(owner, title, modal ? DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
    }

    private void init(Dimension size) {
        if (this.rootPanel == null) {
            this.rootPanel = new XYPanel();
            this.rootPanel.setLayout(new XYLayout());
            this.rootPanel.addXywhChangeListener(new XYPanel.XywhChangeListener(){

                @Override
                public void onChange(XYPanel panel, XYConstraints newXywh, XYConstraints oldXywh) {
                    WaitDialog.this.init(new Dimension(newXywh.getWidth(), newXywh.getHeight()));
                }
            });
            this.rootPanel.setBackground(Color.decode("#FFF9ED"));
            this.getContentPane().add(this.rootPanel);
            this.rootPanel.setResizable(this.isResizable());
            this.rootPanel.setFirstRepaint(true);
            return;
        }
        int font13Size = (int)Math.round(this.screenSize.getHeight() * 13.0 / 768.0);
        int font12Size = (int)Math.round(this.screenSize.getHeight() * 12.0 / 768.0);
        String fontName = SwingUtil.getFontFamily("\u5fae\u8f6f\u96c5\u9ed1,Microsoft YaHei UI,Microsoft YaHei,\u5b8b\u4f53");
        Font font13 = new Font(fontName, 0, font13Size);
        Font font12 = new Font(fontName, 0, font12Size);
        if (this.textLabel == null) {
            this.textLabel = new JLabel();
            this.textLabel.setFont(font13);
            this.textLabel.setText("\u6b63\u5728\u5347\u7ea7\uff0c\u8bf7\u7a0d\u540e...");
        } else {
            this.rootPanel.remove(this.textLabel);
        }
        int barHeight = (int)Math.round(this.screenSize.getHeight() * 22.0 / 768.0);
        int buttonHeight = (int)Math.round(this.screenSize.getHeight() * 25.0 / 768.0);
        int textLabelHeight = (int)Math.round(this.screenSize.getHeight() * 25.0 / 768.0);
        int margingGrap = (int)Math.round(this.screenSize.getHeight() * 10.0 / 768.0);
        int marginLeftRight = (int)Math.round(this.screenSize.getHeight() * 10.0 / 768.0);
        int totalHeight = textLabelHeight + margingGrap + buttonHeight + margingGrap + barHeight;
        int tempY = (size.height - totalHeight) / 2;
        int tempX = marginLeftRight;
        int tempW = size.width - 2 * marginLeftRight;
        int tempH = textLabelHeight;
        this.rootPanel.add((Component)this.textLabel, new XYConstraints(tempX, tempY, tempW, tempH));
        if (this.progressbar == null) {
            this.progressbar = new JProgressBar();
            this.progressbar.setFont(font12);
            this.progressbar.setOrientation(0);
            this.progressbar.setMinimum(0);
            this.progressbar.setMaximum(100);
            this.progressbar.setValue(0);
        } else {
            this.rootPanel.remove(this.progressbar);
        }
        this.rootPanel.add((Component)this.progressbar, new XYConstraints(tempX, tempY += tempH + margingGrap, tempW, barHeight));
        tempY += barHeight + margingGrap;
        if (this.closeOrCancelButton == null) {
            this.closeOrCancelButton = new JButton();
            this.closeOrCancelButton.setText("\u5173   \u95ed");
            this.closeOrCancelButton.setFont(font12);
            this.closeOrCancelButton.setEnabled(false);
            this.closeOrCancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WaitDialog.this.dispose();
                    System.exit(0);
                }
            });
        } else {
            this.rootPanel.remove(this.closeOrCancelButton);
        }
        tempW = (int)Math.round(this.screenSize.getHeight() * 80.0 / 768.0);
        tempX = (size.width - tempW) / 2;
        this.rootPanel.add((Component)this.closeOrCancelButton, new XYConstraints(tempX, tempY, tempW, buttonHeight));
    }

    private void setMessage(final String msg, final Integer bar) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (WaitDialog.this.progressbar != null && bar != null) {
                    WaitDialog.this.progressbar.setValue(bar);
                }
                if (WaitDialog.this.textLabel != null && msg != null) {
                    WaitDialog.this.textLabel.setText(msg);
                }
            }
        });
    }

    @Override
    public void finish(final boolean success) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (WaitDialog.this.closeOrCancelButton != null) {
                    WaitDialog.this.closeOrCancelButton.setEnabled(true);
                    if (success) {
                        WaitDialog.this.setTitle("\u5347\u7ea7\u5b8c\u6210!");
                        WaitDialog.this.progressbar.setValue(100);
                        WaitDialog.this.textLabel.setText("\u5347\u7ea7\u6210\u529f!\u6b63\u5728\u9000\u51fa\u5347\u7ea7\u7a0b\u5e8f...");
                    } else {
                        WaitDialog.this.setTitle("\u5347\u7ea7\u5931\u8d25!");
                    }
                }
            }
        });
        if (success) {
            System.out.println("upgrade_success_resart_carpark");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    private void showDisplay0() {
        ImageIcon imageIcon = new ImageIcon(WaitDialog.class.getResource("upgrade.png"));
        this.setIconImage(imageIcon == null ? null : imageIcon.getImage());
        this.setVisible(true);
    }

    public void showDisplay() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showDisplay0();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitDialog.this.showDisplay0();
                }
            });
        }
    }

    @Override
    public void setProcessValue(int value) {
        this.setMessage(null, value);
    }

    @Override
    public void pushMessage(String message) {
        this.setMessage(message, null);
    }

    public static void setLookAndFeel(String LookAndFeel2) {
        if (LookAndFeel2 == null || (LookAndFeel2 = LookAndFeel2.trim()).length() == 0) {
            LookAndFeel2 = "Nimbus";
        }
        String Nimbus = null;
        String Windows = null;
        String WindowsClassic = null;
        String gtk = null;
        UIManager.LookAndFeelInfo[] installedLookAndFeels = UIManager.getInstalledLookAndFeels();
        int idx = 0;
        while (idx < installedLookAndFeels.length) {
            String v = installedLookAndFeels[idx].getName();
            if (LookAndFeel2.equals(v)) {
                try {
                    UIManager.setLookAndFeel(installedLookAndFeels[idx].getClassName());
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ("Nimbus".equals(v)) {
                Nimbus = installedLookAndFeels[idx].getClassName();
            } else if ("Windows".equals(v)) {
                Windows = installedLookAndFeels[idx].getClassName();
            } else if ("Windows Classic".equals(v)) {
                WindowsClassic = installedLookAndFeels[idx].getClassName();
            } else if ("gtk".equals(v)) {
                gtk = installedLookAndFeels[idx].getClassName();
            }
            ++idx;
        }
        if (Nimbus != null) {
            try {
                UIManager.setLookAndFeel(Nimbus);
            }
            catch (Exception exception) {}
        } else if (Windows != null) {
            try {
                UIManager.setLookAndFeel(Windows);
            }
            catch (Exception exception) {}
        } else if (WindowsClassic != null) {
            try {
                UIManager.setLookAndFeel(WindowsClassic);
            }
            catch (Exception exception) {}
        } else if (gtk != null) {
            try {
                UIManager.setLookAndFeel(gtk);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

