/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carmera.drive.qlm;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.wovoe.carmera.drive.qlm.sdk.YYDSSDKLibrary;
import com.wovoe.carmera.drive.qlm.sdk.YYDSSDKLibraryFactory;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.nativetransport.TransportCloseListener;
import com.wovoe.nativetransport.TransportUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class QLMLPRCameraAction
implements ServiceAction {
    public static final String ACTION_NAME = "/QLMLPRCameraAction";
    private static Map<String, Method> methodsMap = new HashMap<String, Method>();
    private static ConcurrentHashMap<String, CameraWrap> camerasMap = new ConcurrentHashMap();
    private static final Object carmeraManagerLock = new Object();
    private static final Object closeAllCameraLock = new Object();
    private static Map<String, Pointer> strPointerMap = new HashMap<String, Pointer>();

    static {
        try {
            Method[] mehtods = QLMLPRCameraAction.class.getMethods();
            String service = "service";
            Method[] methodArray = mehtods;
            int n = mehtods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                String name = m.getName();
                Class<?>[] cls = m.getParameterTypes();
                if (cls != null && cls.length == 1 && Receiver.class.equals(cls[0]) && !service.equals(name)) {
                    methodsMap.put(name, m);
                }
                ++n2;
            }
            TransportUtil.addTransportCloseListener((TransportCloseListener)new TransportCloseListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onClose() throws Exception {
                    try {
                        Object object = strPointerMap;
                        synchronized (object) {
                            strPointerMap.clear();
                        }
                        object = carmeraManagerLock;
                        synchronized (object) {
                            Iterator it = camerasMap.entrySet().iterator();
                            while (it.hasNext()) {
                                try {
                                    try {
                                        CameraWrap rm;
                                        CameraWrap cameraWrap = rm = (CameraWrap)it.next().getValue();
                                        synchronized (cameraWrap) {
                                            if (!rm.released) {
                                                rm.released = true;
                                                QLMLPRCameraAction.closeConnect(rm);
                                            }
                                        }
                                    }
                                    catch (Exception exception) {
                                        it.remove();
                                        continue;
                                    }
                                }
                                catch (Throwable throwable) {
                                    it.remove();
                                    throw throwable;
                                }
                                it.remove();
                            }
                        }
                    }
                    catch (Exception ex) {
                        TransportUtil.getLog().error((Object)("close error!" + ex.getMessage()));
                    }
                }
            });
        }
        catch (Exception ex) {
            TransportUtil.getLog().error((Object)"", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pointer getPointer(String name, boolean create) {
        Map<String, Pointer> map = strPointerMap;
        synchronized (map) {
            block6: {
                if (name != null) break block6;
                return null;
            }
            Pointer p = strPointerMap.get(name);
            if (p != null) {
                return p;
            }
            if (create) {
                p = QLMLPRCameraAction.getPointer(name);
                strPointerMap.put(name, p);
                return p;
            }
            return null;
        }
    }

    static Pointer getPointer(String v) {
        byte[] ev = (String.valueOf(v) + "\u0000").getBytes();
        Memory m = new Memory((long)ev.length);
        m.write(0L, ev, 0, ev.length);
        return m;
    }

    public void stopPlay(final Receiver request) throws Exception {
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QLMLPRCameraAction.responseError(request, "Missing parameter: cameraId", null);
            return;
        }
        CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null) {
            ResponseSender response = request.createResponse();
            response.setHeader("cameraId", cameraId);
            response.setHeader("result", "true");
            response.doResponse(null, null);
            return;
        }
        final CameraWrap w0 = wrap;
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    QLMLPRCameraAction.stopPlay0(w0);
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", "true");
                    try {
                        response.doResponse(null, null);
                    }
                    catch (IOException e) {
                        TransportUtil.getLog().error((Object)"", (Throwable)e);
                    }
                }
                catch (Exception ex) {
                    QLMLPRCameraAction.responseError(request, "Failed to close the camera: " + w0.ip, ex);
                }
            }
        });
    }

    private static void responseError(Receiver request, String message, Throwable e) {
        try {
            String e1;
            String cameraId = request.getHeaderValue("cameraId");
            ResponseSender response = request.createResponse();
            response.setHeader("result", "error");
            if (cameraId != null && cameraId.length() > 0) {
                response.setHeader("cameraId", cameraId);
            }
            if (message != null && message.length() > 0) {
                response.setHeader("msg", message);
            }
            if (e != null && (e1 = e.getMessage()) != null && e1.length() > 0) {
                response.setHeader("msg1", e1);
            }
            response.doResponse(null, null);
        }
        catch (IOException e1) {
            TransportUtil.getLog().error((Object)"", (Throwable)e1);
        }
    }

    public void playVisible(final Receiver request) throws Exception {
        int port0;
        long componentID0;
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QLMLPRCameraAction.responseError(request, "Missing parameter: cameraId", null);
            return;
        }
        final String ip = request.getHeaderValue("ip");
        if (!(ip != null && cameraId.length() != 0 || cameraId != null && cameraId.length() != 0)) {
            QLMLPRCameraAction.responseError(request, "Missing parameter: ip", null);
            return;
        }
        String componentID = request.getHeaderValue("componentID");
        if (componentID == null || componentID.length() == 0) {
            QLMLPRCameraAction.responseError(request, "Missing parameter: componentID", null);
            return;
        }
        try {
            componentID0 = Long.parseLong(componentID);
        }
        catch (Exception ex) {
            QLMLPRCameraAction.responseError(request, "componentID not a integer: " + componentID, null);
            return;
        }
        String userName0 = request.getHeaderValue("userName");
        String userPwd0 = request.getHeaderValue("userPwd");
        String _port = request.getHeaderValue("port");
        if (_port != null && _port.length() > 0) {
            try {
                port0 = Integer.parseInt(_port);
            }
            catch (Exception ex) {
                port0 = 8857;
            }
        } else {
            port0 = 8857;
        }
        final int vPort = port0;
        final String userName1 = userName0 == null || userName0.length() == 0 ? "admin" : userName0;
        final String userPwd1 = userPwd0 == null || userPwd0.length() == 0 ? "admin" : userPwd0;
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CameraWrap wrap;
                Object object = carmeraManagerLock;
                synchronized (object) {
                    wrap = (CameraWrap)camerasMap.get(cameraId);
                    if (!(wrap == null || ip.equals(wrap.ip) && vPort == wrap.port && userName1.equals(wrap.userName) && userPwd1.equals(wrap.userPwd))) {
                        camerasMap.remove(wrap.cameraId);
                        CameraWrap cameraWrap = wrap;
                        synchronized (cameraWrap) {
                            wrap.released = true;
                        }
                        QLMLPRCameraAction.closeConnect(wrap);
                        wrap = null;
                    }
                    if (wrap == null) {
                        CameraWrap newWrap = new CameraWrap();
                        newWrap.ip = ip;
                        newWrap.cameraId = cameraId;
                        newWrap.userName = userName1;
                        newWrap.userPwd = userPwd1;
                        newWrap.port = vPort;
                        camerasMap.put(cameraId, newWrap);
                        wrap = newWrap;
                    }
                }
                boolean rsult = QLMLPRCameraAction.this.play(wrap, componentID0);
                if (!rsult) {
                    QLMLPRCameraAction.responseError(request, "Playback failed!" + ip, null);
                    return;
                }
                try {
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", String.valueOf(rsult));
                    response.doResponse(null, null);
                }
                catch (IOException e) {
                    TransportUtil.getLog().error((Object)"", (Throwable)e);
                }
            }
        });
    }

    public void disConnect(final Receiver request) throws Exception {
        final String cameraId = request.getHeaderValue("cameraId");
        if (cameraId == null || cameraId.length() == 0) {
            QLMLPRCameraAction.responseError(request, "DisConnect failed:cameraId", null);
            return;
        }
        CameraWrap wrap = camerasMap.get(cameraId);
        if (wrap == null) {
            ResponseSender response = request.createResponse();
            response.setHeader("cameraId", cameraId);
            response.setHeader("result", "true");
            response.doResponse(null, null);
            return;
        }
        TransportUtil.getWorkThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    QLMLPRCameraAction.release(cameraId);
                    ResponseSender response = request.createResponse();
                    response.setHeader("cameraId", cameraId);
                    response.setHeader("result", "true");
                    response.doResponse(null, null);
                }
                catch (IOException e) {
                    TransportUtil.getLog().error((Object)"", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void release(String cameraId) {
        CameraWrap wrap;
        if (cameraId == null) {
            return;
        }
        Object object = carmeraManagerLock;
        synchronized (object) {
            wrap = camerasMap.remove(cameraId);
            if (wrap == null) {
                return;
            }
            CameraWrap cameraWrap = wrap;
            synchronized (cameraWrap) {
                if (wrap.released) {
                    return;
                }
                wrap.released = true;
            }
        }
        QLMLPRCameraAction.closeConnect(wrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSameComponentID(String cameraId, Long componentID0) {
        if (cameraId == null || cameraId.length() == 0 || componentID0 == null || componentID0 == 0L) {
            return;
        }
        Object object = closeAllCameraLock;
        synchronized (object) {
            for (CameraWrap w : camerasMap.values()) {
                if (cameraId.equals(w.cameraId)) continue;
                CameraWrap cameraWrap = w;
                synchronized (cameraWrap) {
                    if (!w.released && w.displayHandler != null && w.ComponentId != null && w.ComponentId.longValue() == componentID0.longValue()) {
                        QLMLPRCameraAction.stopPlay0(w);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean play(CameraWrap wrap, Long componentID0) {
        if (wrap == null) return false;
        if (componentID0 == null) {
            return false;
        }
        this.closeSameComponentID(wrap.cameraId, componentID0);
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            if (wrap.released) {
                return false;
            }
            boolean invokeSet = false;
            if (wrap.displayHandler != null && wrap.ComponentId != null) {
                if (wrap.ComponentId.longValue() == componentID0.longValue()) {
                    return true;
                }
                invokeSet = true;
            }
            YYDSSDKLibrary lib = YYDSSDKLibraryFactory.getSDKLibrary();
            if (wrap.displayHandler == null) {
                NativeLong nv;
                Pointer userName = QLMLPRCameraAction.getPointer(wrap.userName, true);
                Pointer userPwd = QLMLPRCameraAction.getPointer(wrap.userPwd, true);
                lib.LPRYYDSLoadInfo(userName, userPwd, new byte[2]);
                if (wrap.ipPointer == null) {
                    wrap.ipPointer = QLMLPRCameraAction.getPointer(wrap.ip);
                }
                if ((nv = lib.LPRYYDSClient_Open(wrap.ipPointer, (short)wrap.port, userName, userPwd)).longValue() <= 0L) {
                    return false;
                }
                wrap.displayHandler = nv;
            }
            if (invokeSet) {
                int h = lib.LPRYYDSClient_SetDisPlayWnd(wrap.displayHandler, new NativeLong(componentID0.longValue()));
                if (h != 1) {
                    return false;
                }
            } else {
                int h = lib.LPRYYDSClient_StartStream(wrap.displayHandler, new NativeLong(componentID0.longValue()));
                if (h != 1) {
                    return false;
                }
            }
            wrap.ComponentId = componentID0;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopPlay0(CameraWrap wrap) {
        CameraWrap cameraWrap = wrap;
        synchronized (cameraWrap) {
            if (wrap.displayHandler != null) {
                YYDSSDKLibraryFactory.getSDKLibrary().LPRYYDSClient_Stop(wrap.displayHandler);
            }
            wrap.ComponentId = null;
            wrap.displayHandler = null;
        }
    }

    private static void closeConnect(CameraWrap wrap) {
        QLMLPRCameraAction.stopPlay0(wrap);
    }

    public void service(Receiver request) throws Exception {
        String op = request.getHeaderValue("op");
        if (op == null || op.length() == 0) {
            QLMLPRCameraAction.responseError(request, "Missing parameter: op!", null);
            return;
        }
        try {
            Method method = methodsMap.get(op);
            if (method == null) {
                QLMLPRCameraAction.responseError(request, "ivalid parameter op value: " + op, null);
                return;
            }
            method.invoke((Object)this, request);
        }
        catch (Throwable e) {
            TransportUtil.getLog().error((Object)"Abnormal execution!", e);
        }
    }

    private static class CameraWrap {
        String cameraId;
        String ip;
        String userName;
        String userPwd;
        Pointer ipPointer;
        int port;
        NativeLong displayHandler;
        volatile Long ComponentId;
        volatile boolean released;

        private CameraWrap() {
        }
    }
}

