/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carmera.drive.qlm.sdk;

import com.sun.jna.Structure;
import com.wovoe.carmera.drive.qlm.sdk.TTimeSeg;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class TWhiteListInfo
extends Structure {
    public long idx;
    public byte[] plateID = new byte[16];
    public int timeOnCreate;
    public int timeEnable;
    public int timeOverdue;
    public byte enable;
    public byte isBlack;
    public int vehicleColor;
    public int plateType;
    public byte useTimeSeg;
    public TTimeSeg[] timeSeg = new TTimeSeg[21];
    public int customerID;
    public byte[] vehicleRemark = new byte[32];

    public TWhiteListInfo() {
        this.initFieldOrder();
    }

    protected void initFieldOrder() {
        this.setFieldOrder(new String[]{"idx", "plateID", "timeOnCreate", "timeEnable", "timeOverdue", "enable", "isBlack", "vehicleColor", "plateType", "useTimeSeg", "timeSeg", "customerID", "vehicleRemark"});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TWhiteListInfo [idx=");
        builder.append(this.idx);
        builder.append(", plateID=");
        builder.append(TWhiteListInfo.getString(this.plateID, 0, this.plateID.length, "GBK"));
        builder.append(", timeOnCreate=");
        builder.append(this.timeOnCreate);
        builder.append(", timeEnable=");
        builder.append(this.timeEnable);
        builder.append(", timeOverdue=");
        builder.append(this.timeOverdue);
        builder.append(", enable=");
        builder.append(this.enable);
        builder.append(", isBlack=");
        builder.append(this.isBlack);
        builder.append(", vehicleColor=");
        builder.append(this.vehicleColor);
        builder.append(", plateType=");
        builder.append(this.plateType);
        builder.append(", useTimeSeg=");
        builder.append(this.useTimeSeg);
        builder.append(", timeSeg=");
        builder.append(Arrays.toString((Object[])this.timeSeg));
        builder.append(", customerID=");
        builder.append(this.customerID);
        builder.append(", vehicleRemark=");
        builder.append(TWhiteListInfo.getString(this.vehicleRemark, 0, this.vehicleRemark.length, "GBK"));
        builder.append("]");
        return builder.toString();
    }

    public TWhiteListInfo fillTimeSeg() {
        int i = 0;
        while (i < this.timeSeg.length) {
            if (this.timeSeg[i] == null) {
                this.timeSeg[i] = new TTimeSeg();
            }
            ++i;
        }
        return this;
    }

    public TWhiteListInfo setPlateNumber(String plate, String charset) {
        if (plate == null || plate.length() == 0) {
            Arrays.fill(this.plateID, (byte)0);
        } else {
            byte[] d;
            try {
                d = charset != null && charset.length() > 0 ? plate.getBytes(charset) : plate.getBytes();
            }
            catch (UnsupportedEncodingException e) {
                d = plate.getBytes();
            }
            if (d.length >= this.plateID.length) {
                System.arraycopy(d, 0, this.plateID, 0, this.plateID.length);
            } else {
                System.arraycopy(d, 0, this.plateID, 0, d.length);
                byte z = 0;
                int i = d.length;
                while (i < this.plateID.length) {
                    if (this.plateID[i] != z) {
                        this.plateID[i] = z;
                    }
                    ++i;
                }
            }
        }
        return this;
    }

    static String getString(byte[] bytes, int offset, int maxLength, String charset) {
        int len = 0;
        int end = offset + maxLength;
        byte e = 0;
        int i = offset;
        while (i < end) {
            if (bytes[i] == e) break;
            ++len;
            ++i;
        }
        if (len == 0) {
            return "";
        }
        if (charset == null || charset.length() == 0) {
            return new String(bytes, offset, len);
        }
        try {
            return new String(bytes, offset, len, charset);
        }
        catch (UnsupportedEncodingException e1) {
            return new String(bytes, offset, len);
        }
    }
}

