/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carmera.drive.qlm.sdk;

import com.sun.jna.Native;
import com.wovoe.carmera.drive.qlm.sdk.StdCallYYDSSDKLibrary;
import com.wovoe.carmera.drive.qlm.sdk.YYDSSDKLibrary;
import com.wovoe.nativetransport.TransportCloseListener;
import com.wovoe.nativetransport.TransportUtil;
import java.io.File;
import java.util.Locale;

public class YYDSSDKLibraryFactory
implements TransportCloseListener {
    private static YYDSSDKLibrary instance;
    private static final String LIBRAY_NAME = "yydsLprSdk";
    private static boolean initedSdk;
    private static TransportCloseListener l;

    private YYDSSDKLibraryFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerTransportCloseListener() {
        if (l != null) return;
        Class<YYDSSDKLibraryFactory> clazz = YYDSSDKLibraryFactory.class;
        synchronized (YYDSSDKLibraryFactory.class) {
            if (l != null) return;
            l = new YYDSSDKLibraryFactory();
            TransportUtil.addTransportCloseListener((TransportCloseListener)l);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static YYDSSDKLibrary loadLibrary(String librayPath) {
        if (librayPath == null || librayPath.length() == 0) {
            librayPath = LIBRAY_NAME;
        }
        if (instance != null) return instance;
        Class<YYDSSDKLibrary> clazz = YYDSSDKLibrary.class;
        synchronized (YYDSSDKLibrary.class) {
            if (instance != null) return instance;
            instance = YYDSSDKLibraryFactory.isWindows() ? (StdCallYYDSSDKLibrary)Native.loadLibrary((String)librayPath, StdCallYYDSSDKLibrary.class) : (YYDSSDKLibrary)Native.loadLibrary((String)librayPath, YYDSSDKLibrary.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean isWindows32() {
        boolean os32;
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        return OS_NAME.indexOf("win") != -1 && (os32 = System.getProperty("sun.arch.data.model", "32").equals("32"));
    }

    public static boolean isWindows() {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        return OS_NAME.indexOf("win") != -1;
    }

    private static String getLibDirName(boolean os32) {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "win" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "linux" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nix") != -1) {
            return "unix" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("mac") != -1) {
            return "mac" + (os32 ? "32" : "64");
        }
        return os32 ? "32" : "64";
    }

    private static String getLibFileName() {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "yydsLprSdk.dll";
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "yydsLprSdk.so";
        }
        return "yydsLprSdk.dll";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YYDSSDKLibrary getSDKLibrary() {
        if (instance == null) {
            File xf = TransportUtil.findHomeDir();
            File nativeDir = "native".equals(xf.getName()) ? xf : new File(xf, "native");
            File ice_ipcsdkDir = new File(nativeDir, "qlmlprsdk");
            String libPath = null;
            if (ice_ipcsdkDir.exists() && ice_ipcsdkDir.isDirectory()) {
                boolean os32 = System.getProperty("sun.arch.data.model", "32").equals("32");
                File libDir = new File(ice_ipcsdkDir, YYDSSDKLibraryFactory.getLibDirName(os32));
                if (!libDir.exists() || !libDir.isDirectory()) {
                    TransportUtil.getLog().warn((Object)("Directory does not exist, lib path cannot be found: " + libDir));
                } else {
                    File file = new File(libDir, YYDSSDKLibraryFactory.getLibFileName());
                    if (file.exists() && file.isFile()) {
                        libPath = file.getAbsolutePath();
                    } else {
                        TransportUtil.getLog().warn((Object)("Unable to find dynamic library file :" + file.getAbsolutePath()));
                    }
                }
            }
            YYDSSDKLibraryFactory.loadLibrary(libPath);
        }
        if (initedSdk) return instance;
        Class<YYDSSDKLibrary> clazz = YYDSSDKLibrary.class;
        synchronized (YYDSSDKLibrary.class) {
            int x;
            if (initedSdk || (x = instance.LPRYYDSClient_Init()) != 1) return instance;
            initedSdk = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean isInited() {
        return instance != null && initedSdk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose() throws Exception {
        Class<YYDSSDKLibrary> clazz = YYDSSDKLibrary.class;
        synchronized (YYDSSDKLibrary.class) {
            if (instance != null && initedSdk) {
                initedSdk = false;
                instance.LPRYYDSClient_UnInit();
                instance = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

