/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework;

import java.nio.ByteBuffer;

public class CRC16 {
    private static int[] ushCrcTab;
    private int crcValue;

    static {
        int[] nArray = new int[256];
        nArray[1] = 32773;
        nArray[2] = 32783;
        nArray[3] = 10;
        nArray[4] = 32795;
        nArray[5] = 30;
        nArray[6] = 20;
        nArray[7] = 32785;
        nArray[8] = 32819;
        nArray[9] = 54;
        nArray[10] = 60;
        nArray[11] = 32825;
        nArray[12] = 40;
        nArray[13] = 32813;
        nArray[14] = 32807;
        nArray[15] = 34;
        nArray[16] = 32867;
        nArray[17] = 102;
        nArray[18] = 108;
        nArray[19] = 32873;
        nArray[20] = 120;
        nArray[21] = 32893;
        nArray[22] = 32887;
        nArray[23] = 114;
        nArray[24] = 80;
        nArray[25] = 32853;
        nArray[26] = 32863;
        nArray[27] = 90;
        nArray[28] = 32843;
        nArray[29] = 78;
        nArray[30] = 68;
        nArray[31] = 32833;
        nArray[32] = 32963;
        nArray[33] = 198;
        nArray[34] = 204;
        nArray[35] = 32969;
        nArray[36] = 216;
        nArray[37] = 32989;
        nArray[38] = 32983;
        nArray[39] = 210;
        nArray[40] = 240;
        nArray[41] = 33013;
        nArray[42] = 33023;
        nArray[43] = 250;
        nArray[44] = 33003;
        nArray[45] = 238;
        nArray[46] = 228;
        nArray[47] = 32993;
        nArray[48] = 160;
        nArray[49] = 32933;
        nArray[50] = 32943;
        nArray[51] = 170;
        nArray[52] = 32955;
        nArray[53] = 190;
        nArray[54] = 180;
        nArray[55] = 32945;
        nArray[56] = 32915;
        nArray[57] = 150;
        nArray[58] = 156;
        nArray[59] = 32921;
        nArray[60] = 136;
        nArray[61] = 32909;
        nArray[62] = 32903;
        nArray[63] = 130;
        nArray[64] = 33155;
        nArray[65] = 390;
        nArray[66] = 396;
        nArray[67] = 33161;
        nArray[68] = 408;
        nArray[69] = 33181;
        nArray[70] = 33175;
        nArray[71] = 402;
        nArray[72] = 432;
        nArray[73] = 33205;
        nArray[74] = 33215;
        nArray[75] = 442;
        nArray[76] = 33195;
        nArray[77] = 430;
        nArray[78] = 420;
        nArray[79] = 33185;
        nArray[80] = 480;
        nArray[81] = 33253;
        nArray[82] = 33263;
        nArray[83] = 490;
        nArray[84] = 33275;
        nArray[85] = 510;
        nArray[86] = 500;
        nArray[87] = 33265;
        nArray[88] = 33235;
        nArray[89] = 470;
        nArray[90] = 476;
        nArray[91] = 33241;
        nArray[92] = 456;
        nArray[93] = 33229;
        nArray[94] = 33223;
        nArray[95] = 450;
        nArray[96] = 320;
        nArray[97] = 33093;
        nArray[98] = 33103;
        nArray[99] = 330;
        nArray[100] = 33115;
        nArray[101] = 350;
        nArray[102] = 340;
        nArray[103] = 33105;
        nArray[104] = 33139;
        nArray[105] = 374;
        nArray[106] = 380;
        nArray[107] = 33145;
        nArray[108] = 360;
        nArray[109] = 33133;
        nArray[110] = 33127;
        nArray[111] = 354;
        nArray[112] = 33059;
        nArray[113] = 294;
        nArray[114] = 300;
        nArray[115] = 33065;
        nArray[116] = 312;
        nArray[117] = 33085;
        nArray[118] = 33079;
        nArray[119] = 306;
        nArray[120] = 272;
        nArray[121] = 33045;
        nArray[122] = 33055;
        nArray[123] = 282;
        nArray[124] = 33035;
        nArray[125] = 270;
        nArray[126] = 260;
        nArray[127] = 33025;
        nArray[128] = 33539;
        nArray[129] = 774;
        nArray[130] = 780;
        nArray[131] = 33545;
        nArray[132] = 792;
        nArray[133] = 33565;
        nArray[134] = 33559;
        nArray[135] = 786;
        nArray[136] = 816;
        nArray[137] = 33589;
        nArray[138] = 33599;
        nArray[139] = 826;
        nArray[140] = 33579;
        nArray[141] = 814;
        nArray[142] = 804;
        nArray[143] = 33569;
        nArray[144] = 864;
        nArray[145] = 33637;
        nArray[146] = 33647;
        nArray[147] = 874;
        nArray[148] = 33659;
        nArray[149] = 894;
        nArray[150] = 884;
        nArray[151] = 33649;
        nArray[152] = 33619;
        nArray[153] = 854;
        nArray[154] = 860;
        nArray[155] = 33625;
        nArray[156] = 840;
        nArray[157] = 33613;
        nArray[158] = 33607;
        nArray[159] = 834;
        nArray[160] = 960;
        nArray[161] = 33733;
        nArray[162] = 33743;
        nArray[163] = 970;
        nArray[164] = 33755;
        nArray[165] = 990;
        nArray[166] = 980;
        nArray[167] = 33745;
        nArray[168] = 33779;
        nArray[169] = 1014;
        nArray[170] = 1020;
        nArray[171] = 33785;
        nArray[172] = 1000;
        nArray[173] = 33773;
        nArray[174] = 33767;
        nArray[175] = 994;
        nArray[176] = 33699;
        nArray[177] = 934;
        nArray[178] = 940;
        nArray[179] = 33705;
        nArray[180] = 952;
        nArray[181] = 33725;
        nArray[182] = 33719;
        nArray[183] = 946;
        nArray[184] = 912;
        nArray[185] = 33685;
        nArray[186] = 33695;
        nArray[187] = 922;
        nArray[188] = 33675;
        nArray[189] = 910;
        nArray[190] = 900;
        nArray[191] = 33665;
        nArray[192] = 640;
        nArray[193] = 33413;
        nArray[194] = 33423;
        nArray[195] = 650;
        nArray[196] = 33435;
        nArray[197] = 670;
        nArray[198] = 660;
        nArray[199] = 33425;
        nArray[200] = 33459;
        nArray[201] = 694;
        nArray[202] = 700;
        nArray[203] = 33465;
        nArray[204] = 680;
        nArray[205] = 33453;
        nArray[206] = 33447;
        nArray[207] = 674;
        nArray[208] = 33507;
        nArray[209] = 742;
        nArray[210] = 748;
        nArray[211] = 33513;
        nArray[212] = 760;
        nArray[213] = 33533;
        nArray[214] = 33527;
        nArray[215] = 754;
        nArray[216] = 720;
        nArray[217] = 33493;
        nArray[218] = 33503;
        nArray[219] = 730;
        nArray[220] = 33483;
        nArray[221] = 718;
        nArray[222] = 708;
        nArray[223] = 33473;
        nArray[224] = 33347;
        nArray[225] = 582;
        nArray[226] = 588;
        nArray[227] = 33353;
        nArray[228] = 600;
        nArray[229] = 33373;
        nArray[230] = 33367;
        nArray[231] = 594;
        nArray[232] = 624;
        nArray[233] = 33397;
        nArray[234] = 33407;
        nArray[235] = 634;
        nArray[236] = 33387;
        nArray[237] = 622;
        nArray[238] = 612;
        nArray[239] = 33377;
        nArray[240] = 544;
        nArray[241] = 33317;
        nArray[242] = 33327;
        nArray[243] = 554;
        nArray[244] = 33339;
        nArray[245] = 574;
        nArray[246] = 564;
        nArray[247] = 33329;
        nArray[248] = 33299;
        nArray[249] = 534;
        nArray[250] = 540;
        nArray[251] = 33305;
        nArray[252] = 520;
        nArray[253] = 33293;
        nArray[254] = 33287;
        nArray[255] = 514;
        ushCrcTab = nArray;
    }

    public CRC16() {
        this(ushCrcTab[0]);
    }

    public CRC16(int initValue) {
        this.crcValue = initValue;
    }

    public void update(byte[] bytes, int offset, int length) {
        this.crcValue = CRC16.calculate(this.crcValue, bytes, offset, length);
    }

    public void update(byte[] bytes) {
        this.update(bytes, 0, bytes.length);
    }

    public void update(byte b) {
        this.crcValue = CRC16.calculate(this.crcValue, b);
    }

    public int getCRCValue() {
        return this.crcValue;
    }

    public static int calculate(byte[] bytes, int offset, int length) {
        return CRC16.calculate(ushCrcTab[0], bytes, offset, length);
    }

    public static int calculate(int crcValue, byte[] bytes, int offset, int length) {
        int len = offset + length;
        int i = offset;
        while (i < len) {
            crcValue = CRC16.calculate(crcValue, bytes[i]);
            ++i;
        }
        return crcValue;
    }

    public static int calculate(ByteBuffer buf) {
        int crcValue = ushCrcTab[0];
        if (buf.hasRemaining()) {
            int pos = buf.position();
            int lmit = buf.limit();
            while (buf.hasRemaining()) {
                crcValue = CRC16.calculate(crcValue, buf.get());
            }
            buf.position(pos);
            buf.limit(lmit);
        }
        return crcValue;
    }

    public static int calculate(int crcValue, byte b) {
        return crcValue << 24 >>> 16 ^ ushCrcTab[crcValue >>> 8 ^ b << 24 >>> 24];
    }
}

