/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework;

import com.wovoe.framework.BytesTool;
import com.wovoe.framework.Crypto;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class CryptoUtil {
    public static String encrypt(String originalText, String charset, Key key, String algorithm) throws InvalidKeyException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, IOException {
        return CryptoUtil.encrypt(originalText.getBytes(charset), key, algorithm);
    }

    public static String encrypt(byte[] input, Key key, String algorithm) throws InvalidKeyException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, IOException {
        return CryptoUtil.encrypt(input, 0, input.length, key, algorithm);
    }

    public static String encrypt(byte[] input, int inputOffset, int inputLen, Key key, String algorithm) throws InvalidKeyException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, IOException {
        ByteBuffer buf = CryptoUtil.crypt(input, inputOffset, inputLen, CryptoUtil.getEncryptCipher(key, algorithm));
        return CryptoUtil.byteToHexString(buf);
    }

    public static String decrypt(String ciphertext, String returnCharset, Key key, String algorithm) throws InvalidKeyException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, IOException {
        return CryptoUtil.decrypt(CryptoUtil.hexStringToByteArray(ciphertext), returnCharset, key, algorithm);
    }

    public static String decrypt(byte[] input, String returnCharset, Key key, String algorithm) throws InvalidKeyException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, IOException {
        return CryptoUtil.decrypt(input, 0, input.length, returnCharset, key, algorithm);
    }

    public static String decrypt(byte[] input, int inputOffset, int inputLen, String returnCharset, Key key, String algorithm) throws InvalidKeyException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, IOException {
        byte[] array;
        int length;
        int offset;
        ByteBuffer buf = CryptoUtil.crypt(input, inputOffset, inputLen, CryptoUtil.getDecryptCipher(key, algorithm));
        if (buf.hasArray()) {
            offset = buf.position() + buf.arrayOffset();
            length = buf.remaining();
            array = buf.array();
        } else {
            offset = 0;
            length = buf.remaining();
            array = new byte[length];
            buf.get(array);
        }
        if (returnCharset == null) {
            return new String(array, offset, length);
        }
        return new String(array, offset, length, returnCharset);
    }

    public static void writeKey(OutputStream out, Key key) throws IOException {
        ObjectOutputStream objout = new ObjectOutputStream(out);
        objout.writeObject(key);
    }

    public static void saveKeyToFile(Key key, String savePath) throws IOException {
        try (FileOutputStream out = new FileOutputStream(savePath);){
            CryptoUtil.writeKey(out, key);
        }
    }

    public static Key readKeyFromFile(String keyFilePath) throws IOException, ClassNotFoundException {
        try (FileInputStream in = new FileInputStream(keyFilePath);){
            Key key = CryptoUtil.readKeyFromInputStream(in);
            return key;
        }
    }

    public static Key readKeyFromInputStream(InputStream keyInput) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(keyInput);
        return (Key)in.readObject();
    }

    public static Key readKeyFromURL(URL keyurl) throws IOException, ClassNotFoundException {
        try (InputStream in = keyurl.openStream();){
            Key key = CryptoUtil.readKeyFromInputStream(in);
            return key;
        }
    }

    public static Key createRandomDESKey() throws NoSuchAlgorithmException {
        return CryptoUtil.createRandomKey("DES");
    }

    public static Key createRandomAESKey() throws NoSuchAlgorithmException {
        return CryptoUtil.createRandomKey("AES");
    }

    public static Key createRandomKey(String algorithm) throws NoSuchAlgorithmException {
        KeyGenerator keygen = KeyGenerator.getInstance(algorithm);
        SecureRandom random = new SecureRandom();
        keygen.init(random);
        SecretKey key = keygen.generateKey();
        return key;
    }

    public static Key[] createRSAKey() throws NoSuchAlgorithmException {
        Key[] keys = new Key[2];
        KeyPairGenerator pairgen = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = new SecureRandom();
        pairgen.initialize(512, random);
        KeyPair keyPair = pairgen.generateKeyPair();
        keys[0] = keyPair.getPublic();
        keys[1] = keyPair.getPrivate();
        return keys;
    }

    public static Cipher getEncryptCipher(Key key, String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher ciper = Cipher.getInstance(algorithm);
        ciper.init(1, key);
        return ciper;
    }

    public static Cipher getDecryptCipher(Key key, String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher ciper = Cipher.getInstance(algorithm);
        ciper.init(2, key);
        return ciper;
    }

    public static ByteBuffer crypt(byte[] input, int inputOffset, int inputLen, Cipher cipher) throws IOException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int outputOffset;
        int blockSize = cipher.getBlockSize();
        int outputSize = cipher.getOutputSize(blockSize);
        int numOfBlocks = inputLen / blockSize;
        int lengthOfLastPart = inputLen % blockSize;
        byte[] outBytes = new byte[outputSize * (numOfBlocks + 1)];
        int outOffset = outputOffset = 0;
        if (numOfBlocks > 0) {
            int i = 0;
            while (i < numOfBlocks) {
                outputSize = cipher.getOutputSize(blockSize);
                if (outBytes.length - outputOffset < outputSize) {
                    int newLength = (outBytes.length << 1) + outputSize;
                    byte[] newByes = new byte[newLength];
                    System.arraycopy(outBytes, outOffset, newByes, outOffset, outputOffset);
                    outBytes = newByes;
                }
                int h = cipher.update(input, inputOffset, blockSize, outBytes, outputOffset);
                inputOffset += blockSize;
                outputOffset += h;
                ++i;
            }
        }
        if (outBytes.length - outputOffset < (outputSize = cipher.getOutputSize(blockSize))) {
            int newLength = (outBytes.length << 1) + outputSize;
            byte[] newByes = new byte[newLength];
            System.arraycopy(outBytes, outOffset, newByes, outOffset, outputOffset);
            outBytes = newByes;
        }
        outputOffset = lengthOfLastPart > 0 ? (outputOffset += cipher.doFinal(input, inputOffset, lengthOfLastPart, outBytes, outputOffset)) : (outputOffset += cipher.doFinal(outBytes, outputOffset));
        return ByteBuffer.wrap(outBytes, outOffset, outputOffset);
    }

    public static void crypt(InputStream in, OutputStream out, Cipher cipher) throws IOException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int b;
        int blockSize = cipher.getBlockSize();
        int outputSize = cipher.getOutputSize(blockSize);
        byte[] inBytes = new byte[blockSize];
        byte[] outBytes = new byte[outputSize];
        int inLength = 0;
        int outLength = 0;
        while ((b = in.read()) != -1) {
            inBytes[inLength++] = (byte)b;
            if (inLength != blockSize) continue;
            outLength = cipher.update(inBytes, 0, blockSize, outBytes);
            out.write(outBytes, 0, outLength);
            inLength = 0;
        }
        outBytes = inLength > 0 ? cipher.doFinal(inBytes, 0, inLength) : cipher.doFinal();
        if (outBytes != null) {
            out.write(outBytes);
        }
    }

    public static byte[] getKeyBytes(Key key) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        CryptoUtil.writeKey(out, key);
        byte[] bs = out.toByteArray();
        return bs;
    }

    public static String getKeyJavaCode(Key key) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        CryptoUtil.writeKey(out, key);
        byte[] bs = out.toByteArray();
        return CryptoUtil.getKeyJavaCode(bs);
    }

    public static String getKeyJavaCode(byte[] bs) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("byte[] keyBytes=new byte[]{");
        int i = 0;
        while (i < bs.length) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append("(byte)").append(bs[i] & 0xFF);
            ++i;
        }
        buf.append("};");
        return buf.toString();
    }

    public static Key unWrapKey(Key privateKey, byte[] wrappedKey, String wrappedKeyAlgorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(4, privateKey);
        return cipher.unwrap(wrappedKey, wrappedKeyAlgorithm, 3);
    }

    public static byte[] wrapKey(Key publicKey, Key key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(3, publicKey);
        return cipher.wrap(key);
    }

    public static boolean isValidAlgorithm(String algorithm) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            return cipher != null;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        catch (NoSuchPaddingException e) {
            return false;
        }
    }

    public static String MD5Encode(String origin) {
        return CryptoUtil.MD5EncodeString(origin, "UTF-8");
    }

    public static byte[] MD5Encode(String origin, String charset) {
        byte[] data;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            data = md.digest(charset == null ? origin.getBytes() : origin.getBytes(charset));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return data;
    }

    public static String MD5EncodeString(String origin, String charset) {
        byte[] data = CryptoUtil.MD5Encode(origin, charset);
        return CryptoUtil.byteArrayToHexString(data, 0, data.length);
    }

    private static String byteArrayToHexString(byte[] buf, int offset, int length) {
        StringBuffer strbuf = new StringBuffer(length << 1);
        int end = length + offset;
        int i = offset;
        while (i < end) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append('0');
            }
            strbuf.append(Integer.toString(buf[i] & 0xFF, 16));
            ++i;
        }
        return strbuf.toString();
    }

    public static String byteToHexString(ByteBuffer data) {
        StringBuilder inputBuffer = new StringBuilder();
        while (data.hasRemaining()) {
            byte cChar = data.get();
            String sTemp = Integer.toHexString(cChar & 0xFF);
            if (sTemp.length() == 1) {
                inputBuffer.append('0').append(sTemp);
                continue;
            }
            inputBuffer.append(sTemp);
        }
        return inputBuffer.toString();
    }

    public static byte[] hexStringToByteArray(String hex) {
        if (hex == null) {
            return null;
        }
        int length = hex.length();
        int byteLength = length >> 1;
        byte[] result = new byte[byteLength];
        char[] buffer = new char[2];
        int i = 0;
        int pos = 0;
        while (pos < length) {
            buffer[0] = hex.charAt(pos);
            buffer[1] = hex.charAt(pos + 1);
            result[i] = (byte)CryptoUtil.parseInt(buffer, 16);
            pos += 2;
            ++i;
        }
        return result;
    }

    public static int parseInt(char[] ch, int radix) throws NumberFormatException {
        if (ch == null) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = ch.length;
        if (max > 0) {
            int digit;
            int limit;
            if (ch[0] == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < max) {
                if ((digit = Character.digit(ch[i++], radix)) < 0) {
                    throw new NumberFormatException("For input string: \"" + new String(ch) + "\"");
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(ch[i++], radix)) < 0) {
                    throw new NumberFormatException("For input string: \"" + new String(ch) + "\"");
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input string: \"" + new String(ch) + "\"");
                }
                if ((result *= radix) < limit + digit) {
                    throw new NumberFormatException("For input string: \"" + new String(ch) + "\"");
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException("For input string: \"" + new String(ch) + "\"");
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("For input string: \"" + new String(ch) + "\"");
        }
        return -result;
    }

    public static String encrypt(String originalText, String siginKey, Crypto crypto) {
        try {
            String charset = "UTF-8";
            StringBuilder sbr = new StringBuilder(originalText.length() + siginKey.length() + 1);
            sbr.append(originalText).append(',').append(siginKey);
            String a = sbr.toString();
            byte[] b = CryptoUtil.MD5Encode(a, charset);
            byte[] c = originalText.getBytes(charset);
            byte[] d = new byte[c.length + b.length];
            System.arraycopy(c, 0, d, 0, c.length);
            System.arraycopy(b, 0, d, c.length, b.length);
            return BytesTool.byteArrayToHexString(crypto.encrypt(d));
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static String decrypt(String encryptText, String siginKey, Crypto crypto) {
        try {
            String charset = "UTF-8";
            byte[] g = crypto.decrypt(BytesTool.hexStringToByteArray(encryptText));
            String x = new String(g, 0, g.length - 16, charset);
            StringBuilder sbr = new StringBuilder(x.length() + siginKey.length() + 1);
            sbr.append(x).append(',').append(siginKey);
            String a = sbr.toString();
            byte[] b = CryptoUtil.MD5Encode(a, charset);
            boolean eq = true;
            int i = 0;
            int j = g.length - 16;
            while (i < b.length) {
                if (b[i] != g[j]) {
                    eq = false;
                    break;
                }
                ++i;
                ++j;
            }
            if (eq) {
                return x;
            }
            throw new RuntimeException("sign error!");
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static String encryptCompress(String originalText, Key key) {
        try {
            byte[] array;
            int length;
            int offset;
            byte[] input = originalText.getBytes("UTF-8");
            ByteBuffer buf = CryptoUtil.crypt(input, 0, input.length, CryptoUtil.getEncryptCipher(key, key.getAlgorithm()));
            if (buf.hasArray()) {
                offset = buf.position() + buf.arrayOffset();
                length = buf.remaining();
                array = buf.array();
            } else {
                offset = 0;
                length = buf.remaining();
                array = new byte[length];
                buf.get(array);
            }
            return BytesTool.compressBytes(array, offset, length);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static String decryptCompress(String encrypttext, Key key) {
        try {
            byte[] array;
            int length;
            int offset;
            byte[] input = BytesTool.unCompress(encrypttext);
            ByteBuffer buf = CryptoUtil.crypt(input, 0, input.length, CryptoUtil.getDecryptCipher(key, key.getAlgorithm()));
            if (buf.hasArray()) {
                offset = buf.position() + buf.arrayOffset();
                length = buf.remaining();
                array = buf.array();
            } else {
                offset = 0;
                length = buf.remaining();
                array = new byte[length];
                buf.get(array);
            }
            return new String(array, offset, length, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, IOException {
        System.out.println(CryptoUtil.getKeyJavaCode(CryptoUtil.createRandomAESKey()));
    }
}

