/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework;

import java.security.SecureRandom;
import java.util.Random;

public class RandomStringGenerator {
    private static final char[] PRINTABLE_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ012345679".toCharArray();
    private static final char[] NUMBER_CHARACTERS = "012345679".toCharArray();
    private static final int DEFAULT_MAX_RANDOM_LENGTH = 35;
    private final SecureRandom randomizer = new SecureRandom();
    private final char[] seed;
    private final int randomLength;
    private static RandomStringGenerator defaultInstance = new RandomStringGenerator();

    public static RandomStringGenerator getDefaultInstance() {
        return defaultInstance;
    }

    public RandomStringGenerator() {
        this(35);
    }

    public RandomStringGenerator(int randomLength) {
        this(randomLength, PRINTABLE_CHARACTERS);
    }

    public RandomStringGenerator(int randomLength, char[] seedOptions) {
        if (randomLength < 1) {
            randomLength = 1;
        }
        this.randomLength = randomLength;
        if (seedOptions == null || seedOptions.length == 0) {
            seedOptions = PRINTABLE_CHARACTERS;
        }
        this.seed = seedOptions;
    }

    public int getDefaultRandomLength() {
        return this.randomLength;
    }

    public String getNewString() {
        return RandomStringGenerator.newRandomString(this.randomizer, this.randomLength, this.seed);
    }

    public String getNewString(int length, char[] seeds) {
        return RandomStringGenerator.newRandomString(this.randomizer, length, seeds);
    }

    public String getNewNumberString(int length) {
        return RandomStringGenerator.newRandomString(this.randomizer, length, NUMBER_CHARACTERS);
    }

    public String getNewString(int length) {
        return RandomStringGenerator.newRandomString(this.randomizer, length, this.seed);
    }

    public byte[] getRandomBytes(int length) {
        byte[] rb = new byte[length];
        this.randomizer.nextBytes(rb);
        return rb;
    }

    private static String convertBytesToString(byte[] rb, char[] seedchars) {
        char[] output = new char[rb.length];
        int i = 0;
        while (i < rb.length) {
            int index = (rb[i] & 0xFF) % seedchars.length;
            output[i] = seedchars[index];
            ++i;
        }
        return new String(output);
    }

    public static String newRandomString(Random random, int length, char[] seed) {
        if (length < 0) {
            length = 0;
        }
        byte[] rb = new byte[length];
        random.nextBytes(rb);
        if (seed == null || seed.length == 0) {
            seed = PRINTABLE_CHARACTERS;
        }
        return RandomStringGenerator.convertBytesToString(rb, seed);
    }
}

