/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication;

import com.wovoe.framework.communication.OpType;
import com.wovoe.framework.communication.ProtocolContext;
import com.wovoe.framework.communication.ProtocolHandler;

public abstract class AbstractProtocolHandler
implements ProtocolHandler {
    private ProtocolHandler nextProtocolHandler;
    private ProtocolHandler previousProtocolHandler;

    @Override
    public void protocolHandle(ProtocolContext ctx) throws Exception {
        OpType opType = ctx.getOpType();
        if (opType == OpType.OP_READ) {
            if (this.handleRead(ctx) && this.previousProtocolHandler != null) {
                this.previousProtocolHandler.protocolHandle(ctx);
            }
        } else if (opType == OpType.OP_WRITE) {
            if (this.handleWrite(ctx) && this.nextProtocolHandler != null) {
                this.nextProtocolHandler.protocolHandle(ctx);
            }
        } else {
            throw new Exception("Unknown OpType!");
        }
    }

    protected abstract boolean handleRead(ProtocolContext var1) throws Exception;

    protected abstract boolean handleWrite(ProtocolContext var1) throws Exception;

    @Override
    public void setNextProtocolHandler(ProtocolHandler protocolHandler) {
        this.nextProtocolHandler = protocolHandler;
    }

    @Override
    public ProtocolHandler getNextProtocolHandler() {
        return this.nextProtocolHandler;
    }

    @Override
    public ProtocolHandler getPreviousProtocolHandler() {
        return this.previousProtocolHandler;
    }

    @Override
    public void setPreviousProtocolHandler(ProtocolHandler protocolHandler) {
        this.previousProtocolHandler = protocolHandler;
    }
}

