/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication;

import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.communication.AppProtocolPacket;
import com.wovoe.framework.communication.AppReceiveCondition;
import com.wovoe.framework.communication.Condition;
import java.util.concurrent.TimeUnit;

public abstract class AppResponseListener<V>
implements AppReceiveCondition {
    private static final long defaultTimeOut = TimeUnit.SECONDS.toNanos(5L);
    private long timeout = defaultTimeOut;
    protected V result;
    private OperationFutureHandler<V> responseFuture;
    private Object waitkey;

    protected AppResponseListener() {
    }

    protected void setResult(V result) {
        this.result = result;
    }

    protected AppResponseListener(OperationFutureHandler<V> responseFuture) {
        this();
        this.setResponseFuture(responseFuture);
    }

    public void setResponseFuture(OperationFutureHandler<V> responseFuture) {
        this.responseFuture = responseFuture;
    }

    public OperationFuture<V> getResponseFuture() {
        return this.responseFuture;
    }

    public long getWaitTimeout() {
        return this.timeout;
    }

    public void setWaitTimeout(long timeout, TimeUnit unit) {
        if (timeout > 0L) {
            this.timeout = unit.toNanos(timeout);
        }
    }

    public void handleResponse(AppProtocolPacket receivePacket) {
        if (this.responseFuture != null) {
            this.responseFuture.setResult(this.getResponseValue(receivePacket));
        }
    }

    public void handleException(Throwable exception) {
        if (this.responseFuture != null) {
            this.responseFuture.setException(exception);
        }
    }

    public Object getWaitkey() {
        return this.waitkey;
    }

    public void setWaitkey(Object waitkey) {
        this.waitkey = waitkey;
    }

    @Override
    public Condition.Result checkReceiveCompleted(AppProtocolPacket receivePacket) {
        return Condition.Result.TRUE;
    }

    public V getResponseValue(AppProtocolPacket receivePacket) {
        return this.result;
    }
}

