/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.framework.communication;

import com.wovoe.framework.BytesTool;
import com.wovoe.framework.communication.AppProtocolPacket;
import com.wovoe.framework.communication.SimpleAttributeHolder;
import com.wovoe.framework.communication.TLVProtocol;
import java.util.Collection;
import java.util.LinkedList;

public class AppTLVPacket
extends SimpleAttributeHolder
implements AppProtocolPacket {
    private byte mainTag;
    private byte subTag;
    private int length;
    private byte[] dataValue;
    private int dataValueOffset;
    private int dataValueLength;
    private AppTLVPacket parent;
    private LinkedList<AppTLVPacket> children;
    private int currentValueLength;

    public int getValueLength() {
        return this.length;
    }

    public int getDataValueOffset() {
        return this.dataValueOffset;
    }

    public int getDataValueLength() {
        return this.dataValueLength;
    }

    public byte[] getDataValue() {
        return this.dataValue;
    }

    public void setValueLength(int length) {
        this.length = length;
    }

    public void setDataValueOffset(int dataValueOffset) {
        this.dataValueOffset = dataValueOffset;
    }

    public void setDataValueLength(int dataValueLength) {
        this.dataValueLength = dataValueLength;
    }

    public AppTLVPacket() {
    }

    public AppTLVPacket(byte mainTag, byte subTag, byte[] dataValue) {
        this(mainTag, subTag, dataValue, 0, dataValue == null ? 0 : dataValue.length);
    }

    public AppTLVPacket(byte mainTag, byte subTag, byte[] dataValue, int dataValueOffset, int dataValueLength) {
        if (TLVProtocol.getInstance().isNestedTag(mainTag) && dataValue != null) {
            throw new IllegalArgumentException("\u5d4c\u5957TLV\u7684dataValue\u5e94\u8be5\u4e3anull\u6216\u8005dataValueLength==0!");
        }
        if (dataValue != null && (dataValueLength < 0 || dataValueOffset < 0 || dataValue.length < dataValueOffset + dataValueLength)) {
            throw new IllegalArgumentException("\u65e0\u6548\u53c2\u6570!\u53c2\u6570: dataValueOffset=" + dataValueOffset + " dataValueLength=" + dataValueLength);
        }
        this.mainTag = mainTag;
        this.subTag = subTag;
        this.dataValue = dataValue;
        this.dataValueOffset = 0;
        if (dataValue != null) {
            this.dataValueOffset = dataValueOffset;
            this.dataValueLength = dataValueLength;
        }
    }

    public byte getMainTag() {
        return this.mainTag;
    }

    public void setMainTag(byte mainTag) {
        this.mainTag = mainTag;
    }

    public byte getMainTagValue() {
        return TLVProtocol.getInstance().getMainTagValue(this.mainTag);
    }

    public int getTagBytesLength() {
        return TLVProtocol.getInstance().getTagBytesLength(this.mainTag);
    }

    int getLengthBytesLength() {
        return TLVProtocol.getInstance().getLengthBytesLength(this.length);
    }

    public AppTLVPacket appendChild(AppTLVPacket child) {
        if (!this.isNestedTag()) {
            throw new RuntimeException("\u4e0d\u662f\u5d4c\u5957tag\uff0c\u4e0d\u80fdAppend Child!");
        }
        if (child == null) {
            return this;
        }
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(child);
        child.setParent(this);
        return this;
    }

    public byte getSubTag() {
        return this.subTag;
    }

    public void setSubTag(byte subTag) {
        this.subTag = subTag;
    }

    public void setDataValue(byte[] dataValue) {
        if (this.isNestedTag() && dataValue != null) {
            throw new RuntimeException("\u5d4c\u5957tag\u4e0d\u80fd\u8bbe\u7f6edataValue,dataValue\u5fc5\u987b\u4e3anull!");
        }
        this.dataValue = dataValue;
    }

    public void setParent(AppTLVPacket parent) {
        this.parent = parent;
    }

    public boolean haveSubTag() {
        return TLVProtocol.getInstance().haveSubTag(this.mainTag);
    }

    public boolean isNestedTag() {
        return TLVProtocol.getInstance().isNestedTag(this.mainTag);
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public boolean haveChildren() {
        Collection<AppTLVPacket> children = this.getChildren();
        if (children == null) {
            return false;
        }
        return !children.isEmpty();
    }

    public AppTLVPacket getFirstChild() {
        LinkedList<AppTLVPacket> children = this.children;
        if (children != null) {
            return children.peek();
        }
        return null;
    }

    public AppTLVPacket getParent() {
        return this.parent;
    }

    public Collection<AppTLVPacket> getChildren() {
        return this.children;
    }

    public int calculateValueLength() {
        if (!this.isNestedTag()) {
            if (this.dataValue == null) {
                this.length = 0;
            } else {
                this.length = this.dataValue.length;
                if (this.length > Short.MAX_VALUE) {
                    throw new RuntimeException("Data length must be less than 32767 bytes\uff01 ");
                }
            }
            return this.length;
        }
        if (!this.haveChildren()) {
            this.length = 0;
            return this.length;
        }
        this.length = 0;
        for (AppTLVPacket p : this.children) {
            int len = p.calculateValueLength();
            len = p.length > 127 ? (len += 2) : ++len;
            len = p.haveSubTag() ? (len += 2) : ++len;
            this.length += len;
        }
        if (this.length > Short.MAX_VALUE) {
            throw new RuntimeException("Data length must be less than 32767 bytes\uff01 ");
        }
        return this.length;
    }

    public int getCurrentValueLength() {
        return this.currentValueLength;
    }

    public void setCurrentValueLength(int currentValueLength) {
        this.currentValueLength = currentValueLength;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(128);
        AppTLVPacket p = this;
        while ((p = p.parent) != null) {
            b.append(' ').append(' ').append(' ');
        }
        String s1 = Integer.toHexString(this.mainTag & 0xFF);
        b.append("TLVPacket [ mainTag=");
        if (s1.length() == 1) {
            b.append('0');
        }
        b.append(s1);
        if (this.haveSubTag()) {
            s1 = Integer.toHexString(this.subTag & 0xFF);
            b.append(" subTag=");
            if (s1.length() == 1) {
                b.append('0');
            }
            b.append(s1);
        }
        b.append(" length=");
        s1 = Integer.toHexString(this.length);
        if (this.getLengthBytesLength() == 1) {
            if (s1.length() == 1) {
                b.append('0');
            }
        } else if (s1.length() == 3) {
            b.append('0');
        }
        b.append(s1);
        if (!this.isNestedTag()) {
            b.append(" data=");
            if (this.dataValue == null) {
                b.append("null");
            } else {
                b.append(BytesTool.byteArrayToHexString(this.dataValue, this.dataValueOffset, this.dataValueLength));
            }
            b.append(']');
        } else {
            b.append(']');
            if (this.children != null) {
                for (AppTLVPacket child : this.children) {
                    assert (child != this);
                    b.append('\n').append(child);
                }
            }
        }
        return b.toString();
    }
}

